#include "FullPullTex.inc"
#include "Shapes.inc"



#declare X = 1.1;
#declare Y = 1.4;
#declare Z = 0.7;
#declare R = 0.125;

#declare Bracket = 
union{
  object{rbox(0.2, 0.075, 0.7, 0.02) translate <0, 0, -0.35> }
  object{rbox(0.2, 0.075, 1  , 0.02) translate <0, 0,  0.5 > rotate 40*x}
}


#declare Tank=
union{

  #ifdef (HighDef) 
    union{
       intersection{
          rbox(X,2*Y,Z,R)
          box{<-X,-Y/2,-Z>< X, Y/2, Z>}
       }
       object{sqrDohNut(X,Z,R,0.0075)  scale<1,3,1> translate<0, Y/2-0.02,0> }
       object{sqrDohNut(X,Z,R,0.0075)  scale<1,3,1> translate<0,-Y/2+0.02,0> }     

     union{
      isosurface {
/*
f_helix1(x,y,z, P0, P1, P2, P3, P4, P5, P6) 

P0 : Number of helixes - e.g. 2 for a double helix 
P1 : Period - is related to the number of turns per unit length 
P2 : Minor radius (major radius > minor radius) 
P3 : Major radius 
P4 : Shape parameter. If this is greater than 1 then the tube becomes fatter in the y direction 
P5 : Cross section type 
P6 : Cross section rotation angle (degrees) 
                                     p0  p1   p2   p3    p4   p5  p6                    
*/
        function{    f_helix1(x,y,z, 1, -93, .155, .0125, .5, 0.7, 45) }
        max_gradient 4
        contained_by { sphere {0, 0.225} } 
        texture{AlloyTex}
      }
      cylinder{<0,0,0><0,-0.5,0>0.16}
      sphere{<0,0,0>0.2 scale<1,.3,1> translate<0, 0.18,0> texture{AlloyTex}}
      torus{0.175 .025 scale <1,1.5,1>translate<0, -0.13,0>texture{AlloyTex}}
      torus{0.175 .025 scale <1,1.5,1>translate<0,  0.17,0>texture{AlloyTex}}
      scale <.6,.4,.6>
      translate <X/2-0.15,Y/2+0.2,-0.2>
      }

    }
  #else
    box{<-X/2,-Y/2,-Z/2>< X/2, Y/2, Z/2> }
  #end
  
  object{Bracket translate<-X/2+0.2, -Y/2-.025, 0.5> }
  object{Bracket translate< X/2-0.2, -Y/2-.025, 0.5> } 
  
  texture{ChassisTex}
   
  texture{
    pigment{
      image_map{jpeg "Card.jpg" once interpolate 2.0} 
      translate <-0.5,-0.5,0>
      scale <1,1.2,1>
    }
  }   
  

  texture{
    pigment{
      image_map{jpeg "Tank.jpg" once interpolate 2.0} 
      translate <-0.5,-0.5,0>  
      scale <0.4,1.2,1>
      rotate 90*y
    }
  }   

}
