#ifdef (Rotate)
  #version unofficial megapov 1.2;

  global_settings {
    motion_blur 5, 4         
  }
#end

#include "Shapes"     
#include "FullPullTex.inc"
#include "Tubes.inc"
#include "Wheels.inc" 
#include "DustAndSmoke.inc" 
 
#declare Chassis =

#declare W = 2.1;
#declare L = 12;
#declare R = 0.5; 
#declare H = 6;


union{

   //tubing radius 
   #declare tubeR = .075;
   
   union{
     object{HalfFrame(H, W, R) }
     object{HalfFrame(H, W, R) translate <0,0,-1>}  
   
   
     #declare h = H - R;
     #while (h > 0)
   
       object{HalfFrame(R+ 0.001, W, R) rotate 90*x translate<0, h, 0> }
       object{tubeL(1) rotate -90*x translate<-W/2, h, 0> }
       object{tubeL(1) rotate -90*x translate< W/2, h, 0> }
     
       #declare h = h - 1;
     #end 
     texture{ChassisTex}
   }                     
   
   #declare tubeR = .1125;
   
   object{
     Frame(L, W, R) 
     translate L/2*y 
     rotate -97*x
   }

   object{
     Frame(L, W, R) 
     translate L/2*y 
     rotate -101*x 
     translate <0, 1.1, -.125>
   }
   
   
   #declare N = 1;
   #while (N < (L - 2))   
     cylinder{ <-W/2,-N*.122,-N> <-W/2,1.1-(N+1)*.191,-N-1> .075  }
     cylinder{ <-W/2,1.1-(N+1)*.191,-N-1> <-W/2,-(N+2)*.122,-N-2> .075 }
     #declare N = N + 2;
   #end
   
   #declare N = 1;
   #while (N < (L - 2))   
     cylinder{ <W/2,-N*.122,-N> <W/2,1.1-(N+1)*.191,-N-1> .075  }
     cylinder{ <W/2,1.1-(N+1)*.191,-N-1> <W/2,-(N+2)*.122,-N-2> .075 }
     #declare N = N + 2;
   #end
   
   #declare N = 1;
   #while (N < L)   
     cylinder{<-W/2,-N*.122,-N> <-W/2,1.1-N*.191,-N> .075  }
     #declare N = N + 1;
   #end

   #declare N = 1;
   #while (N < L)   
     cylinder{< W/2,-N*.122,-N> < W/2,1.1-N*.191,-N> .075  }
     #declare N = N + 1;
   #end
   
   #declare N = -.5;
   #while ( N <= .5 )
   cylinder{ <N, -1.2, -L + .07><N, -1.5 , -L + .07> 0.075}
   #declare N = N + .5;
   #end
   
   //Bottom brackets
   difference{
     union{
       object{rbox(W-0.3,.1,.6, 0.03) }                         
       
       object{rbox(.1,2,.6, 0.03) translate<-W/2+0.15,0.95,0> } 
       object{rbox(.1,2,.6, 0.03) translate< W/2-0.15,0.95,0> } 
       
       translate<0,-1.2,-7>
     }
     box{<-1,1,-10><1,10,10> rotate -11*x} 
   }
   
   cylinder{<0,0,-4><0,0,-L+2>.1 translate <0,-1.4,0>} 
   
   intersection{ 
     object{rbox(.5,2,5,.2) scale <1,1,.1>translate <0,-0.65,-7>}
     box{<-10,-10,-10><10,-1.15,10>}
   }
   
   translate < 0, 2.75, 0 >    
}
   
#declare UnderSeat =
union{
  
  union{     
    difference{
      object{rbox(  2, 1.5, 5.5, 0.05)}
      box{<-10,-10,-10><10,0.5,10>} 
    }         
    #declare N=-2.55;
    #while (N<=2)
      object{BoltHeadWash rotate  90*z scale .05 texture{ChromeTex} translate <-1,0.625,N> }
      object{BoltHeadWash rotate -90*z scale .05 texture{ChromeTex} translate < 1,0.625,N> }
      #declare N = N + .6;
    #end
  
    #declare N=-.8;
    #while (N<= .8)
      object{BoltHeadWash rotate -90*x scale .05 texture{ChromeTex}  translate <N,0.625,-2.75>}
      #declare N = N + .53333;
    #end  
  }
  union{
      object{rbox(1.95, 2.1, 5.45, 0.05) translate<0,-0.3,0>}
      object{rbox(.5,2,5,.2) scale <1,1,.1>translate <0,-0.9,-1.5> }
      texture{BoxTex }   
  }
  translate<0,3,-2.5>
  
  texture{ChromeTex}
}


#declare Controls =
union{
}

#declare Pedal =
union{

  #declare r = 2;
  #declare X = .4;
  
  intersection{
    union{
      difference{
        cylinder{<r, 0, -X/2><r 0, X/2>r}
        cylinder{<r, 0, -X><r 0, X>r-.05}
      }
      #declare R = 2.;
      torus{R,.075 rotate 90*x translate <0, -R, 0> scale<1,1,1>}
    }
    union{  
      box{<0,-X/2,-X><r,X/2,X>}
      box{<.4,-1,-X><r,X,X>}
    }
  }
  
  texture{ChromeTex}
}

#declare Tractor =
union{
   
   cylinder { <0,0,0><0,0,-L+2>0.2 texture{ChromeTex} rotate -4*x translate 3*y}
   
   #ifdef (Dust)
     object{WheelDust }
   #end
   
   #declare ww = 2.8;  
     
   #ifdef (Rotate)
     motion_blur{
       union{
         union{
            object{LeftBackWheel  translate  ww*x}
            object{RightBackWheel translate -ww*x} 
            rotate 2*x*clock
         }

         object{BackTyre translate  ww*x}
         object{BackTyre translate -ww*x}         
         
         translate 2.9*y
       }
       rotate x*clock
     }
   #else 
     union{
        object{BackTyre translate  ww*x}
        object{BackTyre translate -ww*x}
        object{LeftBackWheel  translate  ww*x}
        object{RightBackWheel translate -ww*x}
        translate 2.9*y
     }
   #end
            
   #declare ww = 2;                            
   #declare xx = 0.7;     
     
   #ifdef (Rotate)
       motion_blur{
         union{
           object{LeftFrontWheel  translate< ww, 0, -L+xx>}
           object{RightFrontWheel translate<-ww, 0, -L+xx>}    
         }
         rotate 0.05*x*clock
       }                                      
   #else
       object{LeftFrontWheel  translate< ww, 0, -L+xx>}
       object{RightFrontWheel translate<-ww, 0, -L+xx>}    
   #end

   object{FrontAxle translate<0, 0, -L+xx>}

   union{   
     #ifdef (Driver) 
       #include "Driver_pov.inc"  object{Poseray_scene_object }
       #include "Helmet_pov.inc"  object{Poseray_scene_object }
       #include "Clothes_pov.inc" object{Poseray_scene_object } 
       
       #include "SteeringWheel_pov.inc" object{Poseray_scene_object }               
     #end

     scale 10.5 rotate 180*y translate<0, 2, -2.5>
   }
   
   #ifdef (HighDef)
     #include "Seat.inc" object{Seat translate<0, 4, -0.25>} 
     object{UnderSeat}
     object{Pedal scale .7 rotate -50*z rotate 90*y translate<-0.7,4.28,-4.6> }
     object{Pedal scale .7 rotate -50*z rotate 90*y translate< 0.7,4.28,-4.6> }
     #include "SteeringWheel.inc" object{SteeringWheel}    
   #end  
     
   #ifdef (Motor)
     #include "Engine.inc" object{Engine}
   #end                     
   
   #ifdef (Smoke)
     object{SmokeAndFire(90)   translate <-1.30,0> }
     object{SmokeAndFire(150)   translate < 1.25,0,0> }
   #end
   
   object{MudGuard texture{GuardTex} }
   object{Chassis}
         
   
   texture{DirtyChassisTex}  
}   
