


//length of tube upright from origin   
#macro tubeL(Length)
  cylinder{<0,0,0><0,Length,0>tubeR}
#end

//curve of tube upright from orign curving along +ve X
#macro tubeC(Radius)  
intersection{

  torus{Radius, tubeR rotate 90*x }
  box{ <0, 0, -tubeR-1> <-Radius-tubeR-1, Radius+tubeR+1, tubeR+1> }
  
  translate Radius*x
  
}
#end

//Frame centered origin length (up) width across flat in xy plan radius on corners
#macro Frame(Length, Width, Radius)

#declare fL = Length - 2 * Radius;
#declare fW = Width  - 2 * Radius;

union{
  object{ tubeL(fL) translate <-Width/2, -fL/2, 0>}
  object{ tubeL(fL) translate < Width/2, -fL/2, 0>}   
  
  object{ tubeL(fW) rotate 90* z translate < fW/2, -Length/2>}
  object{ tubeL(fW) rotate 90* z translate < fW/2,  Length/2>}
  
  object{ tubeC(Radius)              translate <-Width/2, fL/2, 0>} 
  object{ tubeC(Radius) rotate 180*y translate < Width/2, fL/2, 0>} 
  object{ tubeC(Radius) rotate 180*x translate <-Width/2,-fL/2, 0>} 
  object{ tubeC(Radius) rotate 180*z translate < Width/2,-fL/2, 0>} 
}
#end

//Half Frame standing over centered origin length (up) width across flat in xy plan radius on corners
#macro HalfFrame(Length, Width, Radius)

#declare fL = Length - Radius;
#declare fW = Width  - 2 * Radius;

union{
  object{ tubeL(fL) translate <-Width/2, 0, 0>}
  object{ tubeL(fL) translate < Width/2, 0, 0>}   
  
  object{ tubeL(fW) rotate 90* z translate < fW/2,  Length>}
  
  object{ tubeC(Radius)              translate <-Width/2, fL, 0>} 
  object{ tubeC(Radius) rotate 180*y translate < Width/2, fL, 0>} 

}

#end

   