


global_settings { max_trace_level 11000 }

camera
{
  location 0
  look_at <0,10,0>
}

light_source
{
  0, rgb 1
}

// electric field
box
{
  -15,15
  translate <0,10,0>
  pigment {rgbt 1}
  interior
  {
    media
    {
      emission 0.8
      density
      {
        crackle
        density_map
        {
          [0.0 gradient <1,1,1> color_map { [0 rgb x] [1/3 rgb y] [2/3 rgb z] [1 rgb x] } turbulence 1 scale 2 ]
          [0.05 rgb 0 ]
        }
      }
    }
  }

  hollow
}


#include "spaceship.pov"

#macro sp(k)
object
{
  spaceship(k)
  scale 0.2
  rotate x*-90
  rotate z*90
}
#end

// macro that shows a spline (for debug)
#macro show_spline(spl,nmin,nmax,nstep,r)
#declare n=nmin;
#while(n<=nmax)
sphere
{
  spl(n), r
  pigment
  { rgb<1,0,0> }
}
#declare n=n+nstep;
#end
#end

// path of the spaceship
#declare path=
spline
{
  quadratic_spline
  0, <10,10,-10>,
  0.5, <2,7,0>,
  1, <-2,5,1>
}

//show_spline(path,0,1,1/20,0.05)

// time diffration
#declare n=0;
#while(n<=1-1/15)
object
{
  sp(.75-.25*n*n)
  rotate x*(1-n-0.25)*-180
  rotate y*n*-45
  translate path(n)
}
#declare n=n+1/15;
#end

#declare n=1;
#while(n<=1)
object
{
  sp(1-n*n)
  rotate x*(1-n-0.25)*-180
  rotate y*n*-45
  translate path(n)
}
#declare n=n+1/15;
#end


// last spaceship
#declare lsp=
object
{
  sp(0)
  rotate x*(-0.25)*-180
  rotate y*-45
  translate path(1)
}

// last spaceship border
#declare lspm=
object
{
  sp(0)
  scale 1.1
  rotate x*(-0.25)*-180
  rotate y*-45
  translate path(1)
}


#macro sparckle(r)
sphere
{
  0, 1
  pigment {rgbt 1}
  interior
  {
    media
    {
      emission 2
      density
      {
        spherical
        density_map
        {
          [0 rgb 0]
          [1
            crackle
            color_map
            {
              [0.0 rgb 1 ]
              [0.1 rgb 0 ]
            }
            warp { black_hole r,1 strength 2 }
            translate -r
          ]
        }
      }
    }
  }
  hollow
}
#end

#declare sr=seed(0);

#declare minlsp=min_extent(lspm);
#declare maxlsp=max_extent(lspm);

#declare i=0;
#while(i<10000)
#declare r1=<rand(sr),rand(sr),rand(sr)>*(maxlsp-minlsp)+minlsp;
#declare r2=<rand(sr),rand(sr),rand(sr)>*100;
#if (inside(lspm,r1) & !inside(lsp,r1))
object
{
  sparckle(r2)
  scale 0.5
  translate r1
}
#end
#declare i=i+1;
#end

// title
union
{
  text
  {
    ttf "crystal.ttf"
    "17/05/2075 14:00GMTT"
    0.01, 0
    scale <1,0.5,1>
  }

  text
  {
    ttf "crystal.ttf"
    "One atomic time unit before light speed"
    0.01, 0
    scale <1,0.5,1>
    translate y*-0.75
  }

  box
  {
    <-0.5,-2,0.01>,<20.5,1.2,0.02>
    scale <1,0.5,1>
    pigment { rgb <1,0,0,0.9> }
  }

  scale 0.006
  rotate x*-90
  translate <-0.06,0.1,-0.045>
  pigment { rgb 2 }
}


