


#macro body(k)
union
{
  difference
  {
    sphere
    {
      <0,0,0>,1
      scale <6,3,1.8>
    }
    box
    {
      <10,0,10>,<-10,-10,-10>
    }
    sphere
    {
      <0,0,0>,1
      scale <6,3,1.8>
      translate <-6,3,0>
    }
  }
  intersection
  {
    sphere
    {
      <0,0,0>,1
      scale <10,0.5,5>
    }
    sphere
    {
      <0,0,0>,1
      scale <6,3,1.8>
    }
  }
  union
  {
    cone
    {
      <0,0,0>,1,<8,0,0>,0.5
    }
    sphere
    {
      <8,0,0>,0.5
    }
    scale <1,0.5,1>
    translate <0,2,0>
  }
  difference
  {
    sphere
    {
      <0,0,0>,1
      scale <3,0.2,3>
      translate <8,2,0>
    }
    sphere
    {
      <8+10,2,0>,10
    }
  }

  difference
  {
    sphere
    {
      <0,0,0>,1
      scale <10,0.5,5>
    }
    cylinder
    {
      <20,-5,0>,<20,5,0>,20
    }
    superellipsoid
    {
      <0.5,0.5>
      scale 1.23
      translate <0,0,3>
    }
    superellipsoid
    {
      <0.5,0.5>
      scale 1.23
      translate <0,0,-3>
    }
  }
}
#end

#macro joint(k)
intersection
{
  sphere
  {
    <0,0,0>,1.1
    scale <6,3,1.8>
    translate <-6,3,0>
  }
  sphere
  {
    <0,0,0>,1.1
    scale <6,3,1.8>
  }
}
#end



#macro machinegun(k)
difference
{
  cylinder
  {
    <-8,0,0>,<-10.5,0,0>,0.2
  }
  cylinder
  {
    <-9,0,0>,<-12,0,0>,0.15
  }
  cylinder
  {
    <-10.3,-1,0>,<-10.3,1,0>,0.1
  }
  cylinder
  {
    <-10.3,0,-1>,<-10.3,0,1>,0.1
  }
  pigment { rgbt<0.2,0.1,0.1,k> }
}
#end

#macro rocket_support(k)
union
{
  cylinder
  {
    <-2.5,0,0>,<-2.5,-1,0>,0.2
  }
  cylinder
  {
    <-5,0,0>,<-5,-1,0>,0.2
  }
  pigment { rgbt<0.2,0.1,0.1,k> }
}
#end

#macro rocket(k)
union
{
  cylinder
  {
    <-2,-1,0>,<-5.5,-1,0>,0.3
  }
  cylinder
  {
    <-2,-1,0>,<-2.5,-1,0>,0.5
  }
  sphere
  {
    <-5.5,-1,0>,0.3
  }
  pigment { rgbt <0.8,0.8,0.8,k> }
}
#end

#macro jet(k)
union
{
  difference
  {
    union
    {
      superellipsoid
      {
        <0.5,0.5>
      }
      sphere
      {
        <0,0,0>,1
        scale <1,1.2,0.2>
      }
      sphere
      {
        <0,0,0>,1
        scale <1,1.2,0.2>
        translate <0,0,-0.33>
      }
      sphere
      {
        <0,0,0>,1
        scale <1,1.2,0.2>
        translate <0,0,+0.33>
      }
    }
    cylinder
    {
      <0.5,0,0>,<2,0,0>, (0.9-0.4)/2.1*2.75
      pigment { rgbt <0,0,0,k> }
    }
  }
  cylinder
  {
    <0,0,-1.5>,<0,0,1.5>,0.2
    pigment { rgbt<0.2,0.1,0.1,k> }
  }

  difference
  {
    cone
    {
       <0,0,0>,0.5,<2,0,0>,1
    }
    cone
    {
       <0,0,0>,0.4,<2.1,0,0>,0.9
    }
    pigment
    {
      gradient x
      color_map
      {
        [0.0 rgbt <0,0,0.2,k>]
        [0.5 rgbt <0,0.2,0.4,k>]
        [1.0 rgbt <0,0,0.2,k>]
      }
      turbulence 1
      scale <0.05,1,1>
    }
  }

  pigment
  {
    gradient x
    color_map
    {
      [0.0 rgbt <0.5,0.5,0.5,k>]
      [0.5 rgbt <0.7,0.7,0.7,k>]
      [1.0 rgbt <0.5,0.5,0.5,k>]
    }
    turbulence 2
    scale <10,1,1>
  }
}
#end

#macro spaceship(k)
union
{
  object
  {
    jet(k)
    translate <0,0,3>
  }
  object
  {
    jet(k)
    translate <0,0,-3>
  }


  difference
  {
    object
    {
      body(k)
    }
    object
    {
      joint(k)
    }
  }

  intersection
  {
    object
    {
      body(k)
    }
    object
    {
      joint(k)
    }
    pigment
    {
      gradient x
      color_map
      {
        [0.0 rgbt <0.5,0.5,0.5,k>]
        [0.5 rgbt <0.7,0.7,0.7,k>]
        [1.0 rgbt <0.5,0.5,0.5,k>]
      }
      turbulence 2
      scale <10,1,1>
    }
  }


  intersection
  {
    sphere
    {
      <0,0,0>,1
      scale <6,3,1.8>
    }
    sphere
    {
      <0,0,0>,1
      scale <6,3,1.8>
      translate <-6,3,0>
    }
    pigment { rgbt<0.1,0.2,0.3,k> }
  }

  union
  {
    cone
    {
      <1,2,0>,0.15,<2,5,0>,0.05
    }
    sphere
    {
      <2,5,0>,0.1
    }
    pigment { rgbt <0.6,0.6,0.6,k> }
  }


  object
  {
    rocket_support(k)
    translate <0,0,3>
  }
  object
  {
    rocket_support(k)
    translate <-1,0,1.5>
  }
  object
  {
    rocket_support(k)
    translate <0,0,-3>
  }
  object
  {
    rocket_support(k)
    translate <-1,0,-1.5>
  }
  object
  {
    rocket_support(k)
    translate <-2.5,0,0>
  }

  object
  {
    rocket(k)
    translate <0,0,3>
  }
  object
  {
    rocket(k)
    translate <-1,0,1.5>
  }
  object
  {
    rocket(k)
    translate <0,0,-3>
  }
  object
  {
    rocket(k)
    translate <-1,0,-1.5>
  }
  object
  {
    rocket(k)
    translate <-2.5,0,0>
  }

  union
  {
    object
    {
      machinegun(k)
      translate <0.2,0,0>
    }
    object
    {
      machinegun(k)
      translate <0.3,0,1>
    }
    object
    {
      machinegun(k)
      translate <1,0,2>
    }
    object
    {
      machinegun(k)
      translate <2.2,0,3>
    }
    object
    {
      machinegun(k)
      translate <0.3,0,-1>
    }
    object
    {
      machinegun(k)
      translate <1,0,-2>
    }
    object
    {
      machinegun(k)
     translate <2.2,0,-3>
    } 
  }

  texture
  {
    pigment
    {
      checker
      pigment
      {
        gradient x+y+z
        color_map
        {
          [0.0 rgbt <209/255,192/255,135/255,k>]
          [0.45 rgbt <209/255,192/255,135/255,k>]
          [0.55 rgbt <240/255,221/255,148/255,k>]
          [0.95 rgbt <240/255,221/255,148/255,k>]
          [1.0 rgbt <209/255,192/255,135/255,k>]
        }
        turbulence 1
        scale 1/20
      }
      pigment
      {
        gradient x+y+z
        color_map
        {
          [0.0 rgbt <0.5,0.5,1,k>]
          [0.25 rgbt <0.5,0.5,1,k>]
          [0.5 rgbt <0.75,0.75,1,k>]
          [0.75 rgbt <0.75,0.75,1,k>]
          [1.0 rgbt <0.5,0.5,1,k>]
        }
        turbulence 2
        scale 6
        scale 1/20
      }
      scale 20
      translate <10,0,10>
    }

    normal
    {
      brick 0.05 brick_size <4,10,3> mortar 0.1
      scale -1
    }
  }

}
#end


