global_settings {
    ambient_light 0.275
    radiosity {
        pretrace_start 0.08
        pretrace_end 0.005
        count 350
        error_bound 0.18
        recursion_limit 2
        brightness 1
    }
}

#declare Hut_ohne_Textur =
object  {
    union   {
        lathe   {
            cubic_spline
            4,
            <-4, -2>, <0, 0>, <3, -2>, <0, -4>
                }
        difference  {
            torus   {2.875, 0.125  scale <1, 0.75 , 1>  translate -2*y}
            plane   {-y, 2}
                    }
            }
    translate 2*y
    scale <1, 10/9, 1>
        }

#declare Hut =
object  {
    Hut_ohne_Textur
    texture {
        pigment {
            wood  sine_wave  rotate 90*x  scale 6  phase 0.2
            color_map   {
                [0  color rgb<1, 0.75, 0>*0.65]
                [1  color rgb<1, 0.35, 0>*0.35]
                        }
                }
        finish  {
            ambient 0.25
            diffuse 0.8
            phong 0.15
            phong_size 10
                }
        normal  {
            average
            normal_map  {
                [wrinkles 0.12  scale 0.5]
                [
                    bump_map {gif "hutrand2.gif"  bump_size 3  map_type 2  interpolate 2}  1
                    rotate 180*y
                    scale <1, 4, 1>
                    translate -0.2*y
                ]
            }
        }
    }
    texture {
        pigment {
            image_map {
                gif "hutrand2.gif"  filter all 0.75  transmit all 0.3  map_type 2
                interpolate 2
            }
            rotate 180*y
            scale <1, 4, 1>
            translate -0.2*y
        }
    }
}

#declare Stiel1 =
object  {
    union   {
        cone    {0, 0.5, -4*y, 0.5}
        difference  {
            torus   {
                5, 0.5  rotate 90*x  scale <1, 7/5, 1>
                translate <-5, -4, 0>
                    }
            plane   {-y, 4}
            plane   {y, -4  rotate -45*z  translate -5*x}
                    }
            }
    pigment {
        bozo
        scale 0.1
        color_map {
            [0    color rgb <0.55, 0.75*0.6, 0.1>+0.15]
            [0.6  color rgb <0.55, 0.75*0.6, 0.1>+0.15]
            [0.8  color rgb (<0.55, 0.75*0.6, 0.1>+0.15)*0.5]
            [1    color rgb (<0.55, 0.75*0.6, 0.1>+0.15)*0.5]
        }
    }
    finish  {
        ambient 0.25
        diffuse 0.7
        phong 0.02
        phong_size 10
            }
    normal  {
        average
        normal_map {
            [1  granite 0.1]
            [1  wrinkles 0.2  scale <0.4, 0.7, 0.4>]
        }
    }
        }

#declare Stiel2 =
object  {
    union   {
        object  {Stiel1  translate 4*y  scale <1, 5/7, 1>}
        difference  {
            torus   {
                10, 0.5  rotate 90*x  translate -5*x
                rotate -45*z  translate <-5, 0, 0>
                    }
            plane   {x, -5}
            plane   {-y, 0  rotate -45*z  translate -5*x}
                    }
            }
    pigment {
        bozo
        scale 0.1
        color_map {
            [0    color rgb <0.55, 0.75*0.6, 0.1>+0.15]
            [0.6  color rgb <0.55, 0.75*0.6, 0.1>+0.15]
            [0.8  color rgb (<0.55, 0.75*0.6, 0.1>+0.15)*0.5]
            [1    color rgb (<0.55, 0.75*0.6, 0.1>+0.15)*0.5]
        }
    }
    finish  {
        ambient 0.25
        diffuse 0.7
        phong 0.02
        phong_size 10
            }
    normal  {
        average
        normal_map {
            [1  granite 0.1]
            [1  wrinkles 0.2  scale <0.4, 0.7, 0.4>]
        }
    }
    translate -4*(5/7)*y
    scale <1, 7/5, 1>
        }

camera  {
    location <3.5, 20, -15>
    look_at <1.9, 3.85, 0>
    angle 60
    focal_point <1.5, 15.2, -0.75>
    aperture 1.5
    blur_samples 1000
    confidence 0.999
    variance 0.5/pow (256, 3)
        }

light_source    {
    <-1000, 2000, -1100> color rgb <1, 0.95, 0.9>*0.85
    area_light <0, 0, 550>, <550, 0, 0>, 5, 5
    jitter
    circular
    orient
                }

#declare Pilz1 =
object  {
    union   {
        object  {Hut  rotate -10*x}
        object  {Stiel1}
            }
    translate 3.5*y
    rotate -13*x
    translate -3.5*y
    translate 1.5*x
    rotate 45*y
    translate <-1.25, -0.5, -1>
        }

#declare Pilz2 =
object  {
    union   {
        object  {Hut  rotate 125*y  scale <1.2, 1, 1.2>}
        object  {Stiel1}
            }
    translate <1.5, 9.5, 0>
    scale <4/3, 1.8, 4/3>
    translate -9.5*y
        }

#declare Pilz3 =
object  {
    union   {
        object  {
            Hut  scale 10/9  rotate 250*y  rotate 9*z
            translate <5, 11.5, 0>
            rotate -15*z  translate <-0.5, -8.5, -0.5>
                }
        object  {
            Stiel2  translate <5, 11.5, 0>  rotate -15*z
            translate <-0.5, -8.5, -0.5>
                }
            }
translate 8.5*y
scale <1, 6/5, 1>
rotate -17*y
translate -8.5*y
        }


object  {Pilz1}
object  {Pilz2}
object  {Pilz3}

#include "nacktschnecke.inc"

object  {
    Nacktschnecke
    translate -3*x
    scale <1, 1, 0.95>
    rotate -6*x
    scale <1, 1, 0.75>*0.2
    rotate -35.65*z
    translate 5*x
    rotate 30*y
    translate <-1, 10.25, 0>
        }

object  {
    Hut_ohne_Textur
    rotate 125*y
    scale <1.2, 1, 1.2>*1.001
    translate <1.5, 9.5, 0>
    scale <4/3, 1.8, 4/3>
    translate -9.5*y
    texture {
        material_map    {
            gif "schneckenschleim.gif"  interpolate 4  once
            texture {
                pigment {color red 1  green 1  blue 1  transmit 1}
                    }
            texture {bozo  scale 0.35
                texture_map {
                    [0
                        pigment {color red 1  green 1  blue 1  transmit 1}
                        finish  {
                            irid    {
                                0.375
                                thickness 0.75
                                    }
                                }
                        normal  {wrinkles 0.15  scale 0.5}
                    ]
                    [0.5
                        pigment {color red 1  green 1  blue 1  transmit 1}
                        finish  {
                            irid    {
                                0.22
                                thickness 0.75
                                    }
                                }
                        normal  {wrinkles 0.1  scale 0.5}
                    ]
                    [0.8
                        pigment {color red 1  green 1  blue 1  transmit 1}
                    ]
                    [1
                        pigment {color red 1  green 1  blue 1  transmit 1}
                    ]
                            }
                    }
                        }
        rotate 90*x
        translate -0.5*z
        scale <5, 1, 0.835>
        translate -1*x
        rotate -20*z
        translate 5*x
        rotate 30*y
        translate <-1, 10.8, -0.093>
             }
        }

height_field    {
    tga "berg.tga"
    pigment {
        image_map   {tga "waldboden2.tga"  interpolate 2}
        rotate 90*x
            }
    translate <-0.5, 0, -0.5>
    scale <160, 10, 170>
    translate -15.25*y
    finish  {ambient 0.375  diffuse 0.6  crand 0.2}
    rotate -50*y
                }

plane   {
    y, 40
    pigment {
        image_map   {gif "baumschatten.gif"  interpolate 2  filter all 1}
        rotate 90*x
        scale 100
        translate 36*z
            }
    finish  {ambient 1  diffuse 0}
    hollow
        }

fog {
    fog_type 1
    color red 1  green 1  blue 1
    distance 230
    turbulence 1
    turb_depth 50
    }
