#declare Fuss =
object  {
    union   {
        difference  {
            torus   {3, 2  rotate 90*x  translate -3*y}
            plane   {y, 0}
            plane   {-x, 0}
                    }
        difference  {
            torus   {24, 2  rotate 90*x  translate -24*y}
            plane   {y, 0}
            plane   {x, 0}
                    }
            }
        }

#declare Fuehler =
object  {
    union   {
        lathe   {
            cubic_spline
            5, -1.5*u, v, 0.9*u, <0.5, -1>, <1, -2>
                }
        lathe   {
            cubic_spline
            4, <1, 4>, <0.5, -1>, <0.7, -6>, <2, -9>
                }
            }
        }

#declare Kopf =
object  {
    union   {
        object  {
            Fuehler
            translate 6*y
            scale 0.25
            rotate <-30, 0, 35>
            translate <-3.75, 0.7, -0.75>
                }
        object  {
            Fuehler
            translate 6*y
            scale 0.25
            rotate <30, 0, 35>
            translate <-3.75, 0.7, 0.75>
                }
        object  {
            Fuehler
            translate 6*y
            scale 0.175
            rotate <-25, 0, 110>
            translate <-3.5, 0.4, -0.7>
                }
        object  {
            Fuehler
            translate 6*y
            scale 0.175
            rotate <25, 0, 110>
            translate <-3.5, 0.4, 0.7>
                }
        superellipsoid  {
            <0.85, 0.85>
            scale <1.85, 0.75, 1.4>
            translate <-2.5, 0.5, 0>
                        }
            }
        }

#declare Nacktschnecke =
object  {
    union   {
        object  {
            Fuss
            pigment {color rgb 0.09}
            finish  {ambient 0.4  diffuse 0.8  phong 0.75  phong_size 20}
            normal  {
                average
                normal_map  {
                    [wrinkles 1  scale <5, 1, 1>*0.15  turbulence 0.05
                    slope_map   {
                        [0 <0, 3>]
                        [1 <0, -3>]
                                }
                    ]
                    [bumps 0.5  scale 0.05]
                            }
                    }
                }
        object  {
            Fuss
            translate -3*x
            scale <14.25/14, 0.5, 4.13/4>
            translate 3*x
            pigment {color rgb 0.1}
            finish  {ambient 0.4  diffuse 0.8  phong 0.85  phong_size 20}
            normal  {
                average
                normal_map {
                    [1  radial 0.15  scale <3, 1, 1>  translate 3*x  frequency 100
                        turbulence 0.1
                        slope_map {
                            [0   <0, 0>]
                            [0.3 <1, 0>]
                            [0.6 <0, 0>]
                            [1   <0, 0>]
                        }
                    ]
                    [0.15  wrinkles 1  scale <5, 1, 1>*0.15  turbulence 0.05
                    slope_map   {
                        [0 <0, 3>]
                        [1 <0, -3>]
                                }
                    ]
                }
            }
                }
        object  {
            difference  {
                object  {
                    Fuss
                    scale <0.65, 0.625, 0.8>
                    translate <-0.95, 1, 0>
                        }
                cone    {
                    -3*z, 0.4, 3*z, 0.4
                    scale <1, 0.75, 1>
                    translate <-0.9, 1.2, 0>
                        }
                        }
            pigment {color rgb 0.095}
            finish  {ambient 0.4  diffuse 0.8  phong 0.85  phong_size 20}
            normal  {
                average
                normal_map {
                    [1    bumps 0.8  scale 0.06  turbulence 0.1]
                    [0.5  wrinkles 1  scale <5, 1, 1>*0.15  turbulence 0.05
                    slope_map   {
                        [0 <0, 3>]
                        [1 <0, -3>]
                                }
                    ]
                    [0.5  bumps 0.5  scale 0.05]
                }
            }
                }
        object  {
            Kopf
            pigment {color rgb 0.095}
            finish  {ambient 0.4  diffuse 0.8  phong 0.8  phong_size 20}
            normal  {bumps 0.75  scale 0.08}
                }
            }
        }
