// Persistence of Vision Ray Tracer Scene Description File
// File: eyeball.inc
// Vers: 3.5
// Desc: Eyeball include 
// Date: 27.09.03 (dd.mm.yy)
// Auth: Tim Nikias Wenclawiak
// Last Update: 27.09.03 (dd.mm.yy)

//Required Files
// None (but uses excerpt from MMM)

//Description
// Two macros which create a realistic human eye: one for the texturing of the Iris,
// the other for the eyeball itself.
//
// Example Usage:
// #declare Foo_Texture=Eyeball_Texture(x,z)
// object{Eyeball_Macro(0,Foo_Texture) translate <0,0,0>}


//Homepage:
// www.nolights.de
//Email:
// Tim.Nikias(@)nolights.de

//My files sometimes build on each other. Checking if following parameter
//was declared/is set to true avoids my other include-files to include
//an already included file again.
#declare _eyeball_inc_tnw=1;

//Eyeball_Texture
//Parameters:
// 1. Color of iris near pupil
// 2. Color of iris near outer border
// 3. Color of eye-white
//Returns:
// UV-mapped Texture-Definition for the Eyeball-Macro
//Notes:
// None
#macro Eyeball_Texture(Inside_Color,Outside_Color,Eyewhite_Color)
 texture{
  pigment{uv_mapping gradient y poly_wave 2 scale 1.0001
   pigment_map{
    [0 rgb 0]
    [.01 bozo scale <.02,.15,.02> turbulence .2 translate 4 color_map{[0 rgb Inside_Color][1 rgb Inside_Color*.5]}]
    [.25 bozo scale <.02,.15,.02> turbulence .5 color_map{[0 rgb Outside_Color][1 rgb Outside_Color*.4]}]
    [.9 rgb 0]
    [.99 rgb Eyewhite_Color]
    [1 rgb Eyewhite_Color]}}
  normal{uv_mapping bozo .01 no_bump_scale scale <.02,.15,.02> turbulence .5}
  finish{specular 1 roughness .01 metallic .75}
  }
#end

//Eyeball_Macro
//Parameters:
// 1. value from 0 to 1 how open the pupil is
// 2. Texture for the Iris
//Returns:
// Eyeball object, size of unit-sphere
//Notes:
// An optional texture declared as "Eye_Texture" will be used for the eye-white
#macro Eyeball_Macro(Pupil_Open,Iris_Texture)
 #ifndef (Eye_Texture) #local Eye_Texture=texture{pigment{rgb 1}finish{brilliance 2 diffuse .9}} #end
 #ifndef (Eye_Detail) #local Eye_Detail=<50,2>; #end
 #declare Iris_Radius=sqrt(.19);
 #declare Pupil_Radius=Iris_Radius*(.125+.325*Pupil_Open);
 #local Eye_TriStrip=array[Eye_Detail.u][Eye_Detail.v]
 #local A=0;
 #while (A<Eye_Detail.u)
  #local A_Mover=A/(Eye_Detail.u-1);
  #local EyeEdge=vrotate(y*Iris_Radius*.99,z*360*A_Mover);
  #local EyeCenter=vrotate(y*Pupil_Radius,z*360*A_Mover);
  #local B=0;
  #while (B<Eye_Detail.v)
   #local B_Mover=B/(Eye_Detail.v-1);  
   #local Eye_TriStrip[A][B]=EyeCenter-(EyeCenter-EyeEdge)*B_Mover-(.001*(1-B_Mover))*z;
   #local B=B+1;
  #end 
  #local A=A+1;
 #end
 union{
  //Main White of Eye
  difference{
   sphere{0,1}
   box{<-1.1,-1.1,-1.1>,<1.1,1.1,-.9>}
   texture{Eye_Texture}
   }
  //Reflective/Specular "Glazing"
  blob{threshold .5
   sphere{0,2.001,1}
   sphere{0,.5,1 scale <1,1,.45> translate z*-.9}
    pigment{rgbt <0,0,0,1>}
    interior{ior 1.84}
    finish{
     specular 1 roughness .001
     reflection{0,.6 falloff 2 exponent .8}
     }
    }
  disc{<0,0,-.90001>,-z,Iris_Radius*.75 pigment{rgb 0}}
  object{
   Make_UVMesh(Eye_TriStrip)
   texture{uv_mapping Iris_Texture}
   translate z*-.9
   }
  }
#end

//Make_UVMesh is a macro straight out of my MMM, also available on my homepage.
#ifndef (Make_UVMesh)
/***************/
/**Make_UVMesh**/
/***************/
//Give: 2D-Array (mesh-field)
//Return: Mesh with UV-Data
#macro Make_UVMesh(_data_array)
 #local _dX=dimension_size(_data_array,1);
 #local _dZ=dimension_size(_data_array,2);
 mesh{
 //Mesh with triangles
  #local A=0;
  #while (A<_dX-1)
   #local B=0;
   #while (B<_dZ-1)
    //Shortest connection
    #if (
        vlength(_data_array[A][B]-_data_array[A+1][B+1]) >=
        vlength(_data_array[A][B+1]-_data_array[A+1][B]) )
     #if (vlength(_data_array[A][B+1]-_data_array[A+1][B])!=0)
      #if (
          (vlength(_data_array[A][B+1]-_data_array[A][B])!=0) &
          (vlength(_data_array[A+1][B]-_data_array[A][B])!=0))
       triangle{_data_array[ A ][B+1],_data_array[A+1][ B ],_data_array[ A ][ B ]
        uv_vectors <A/(_dX-1),(B+1)/(_dZ-1)>,<(A+1)/(_dX-1),B/(_dZ-1)>,<A/(_dX-1),B/(_dZ-1)>
       }
      #end
      #if (
          (vlength(_data_array[A][B+1]-_data_array[A+1][B+1])!=0) &
          (vlength(_data_array[A+1][B]-_data_array[A+1][B+1])!=0))
       triangle{_data_array[ A ][B+1],_data_array[A+1][ B ],_data_array[A+1][B+1]
        uv_vectors <A/(_dX-1),(B+1)/(_dZ-1)>,<(A+1)/(_dX-1),B/(_dZ-1)>,<(A+1)/(_dX-1),(B+1)/(_dZ-1)>
       }
      #end
     #end
    #else
     #if (vlength(_data_array[A][B]-_data_array[A+1][B+1])!=0)
      #if (
          (vlength(_data_array[ A ][ B ]-_data_array[A][B+1])!=0) &
          (vlength(_data_array[A+1][B+1]-_data_array[A][B+1])!=0))
        triangle{_data_array[A+1][B+1],_data_array[ A ][ B ],_data_array[ A ][B+1]
        uv_vectors <(A+1)/(_dX-1),(B+1)/(_dZ-1)>,<A/(_dX-1),B/(_dZ-1)>,<A/(_dX-1),(B+1)/(_dZ-1)>
        }
      #end
      #if (
          (vlength(_data_array[ A ][ B ]-_data_array[A+1][B])!=0) &
          (vlength(_data_array[A+1][B+1]-_data_array[A+1][B])!=0))
       triangle{_data_array[A+1][B+1],_data_array[ A ][ B ],_data_array[A+1][ B ]
        uv_vectors <(A+1)/(_dX-1),(B+1)/(_dZ-1)>,<A/(_dX-1),B/(_dZ-1)>,<(A+1)/(_dX-1),B/(_dZ-1)>
       }
      #end
     #end
    #end
   #local B=B+1;
   #end
  #local A=A+1;
  #end
 }
#end
#end