// Auth: Paolo Gibellini
// Title: Sprint Turtle
// The turtle is the subject  of children's song "La tartaruga sprint")
// Exported from Wings 3D 0.98.32b (rearranged materials and scene)
// Some materials from Moray and some from news.povray.org
// Eyeball from Tim Nikias
// Grass by Gilles Tran
// Motion blur in MegaPOV
// Some blur to better the grass path

#version unofficial MegaPov 1.2

#include "colors.inc"
#include "skies.inc"
#include "eyeball.inc"
#include "mgrass.pov"

// Global settings -----------------------------------------------
global_settings {
  adc_bailout 0.003922
  ambient_light <1.0,1.0,1.0>/2
//assumed_gamma 1.0 // 1.9
  hf_gray_16 off
  irid_wavelength <0.247059,0.176471,0.137255>
  max_intersections 64
  max_trace_level 10
  number_of_waves 10
  noise_generator 2
  charset ascii
  motion_blur 10, 3
  radiosity {
    pretrace_start 0.08           // start pretrace at this size
    pretrace_end   0.04           // end pretrace at this size
    count 35                      // higher -> higher quality (1..1600) [35]
    nearest_count 5               // higher -> higher quality (1..10) [5]
    error_bound 1.8               // higher -> smoother, less accurate [1.8]
    recursion_limit 4             // how much interreflections are calculated (1..5+) [3]
    low_error_factor .5           // reduce error_bound during last pretrace step
    gray_threshold 0.0            // increase for weakening colors (0..1) [0]
    minimum_reuse 0.015           // reuse of old radiosity samples [0.015]
    brightness 0.6                  // brightness of radiosity effects (0..1) [1]

    adc_bailout 0.01/2
    //normal on                   // take surface normals into account [off]
    //media on                    // take media into account [off]
    //save_file "guga04-06.rad"       // save radiosity data
    load_file "guga04-06.rad"       // load saved radiosity data
    always_sample off           // turn sampling in final trace off [on]
    //max_sample 1.0              // maximum brightness of samples
  }
}


sky_sphere {
	S_Cloud1
}
// ---------------------------------------------------------------

// Camera --------------------------------------------------------
camera {
	location  <9,0.778,-4.965>
	//location  <9,40,-4.965> // Dall'alto, carina
	//location  <9,60,-4.965> // Dall'alto
	sky       <0.20671,0.86607,0.45518>
	right     <1.25441,0.0,0.0>
	angle     19.52621
	look_at   <0.5,0.5,-0.6>
	
	aperture 0.05 //0.05           	 // [0...N] larger is narrower depth of field (blurrier)
	blur_samples 6     //5   	 // number of rays per pixel for sampling
	focal_point <1.2,0.38,0>    // point that is in focus <X,Y,Z>
	confidence 0.5           // [0...<1] when to move on while sampling (smaller is less accurate)
	variance 0.22  // 1/4            // [0...1] how precise to calculate (smaller is more accurate)
}

// ---------------------------------------------------------------

// Lights --------------------------------------------------------

light_source {
  <2, 2, -2>
  color rgb <1.000, 1.000, 1.000>
}

light_source {
  <800, 400, 400>
  color rgb <1.000, 1.000, 1.000>
} 

// ---------------------------------------------------------------

// Textures ------------------------------------------------------
// Jaime ------------------------------------------------

#declare rmin=.1;
#declare rmax=.33;
//#declare c1=Blue*.25; #declare c2=Green*.5;
//#declare c1=Red*.125; #declare c2=Yellow*.5;
//#declare c1=Blue*.2+Green*.1; #declare c2=Yellow*.5;
//#declare c1=Violet*.5; #declare c2=Red;
#declare c1=Red*.5; #declare c2=Green;
//#declare c1=Black; #declare c2=White;
//#declare c1=Black; #declare c2=Red;
//#declare c1=Blue*.5; #declare c2=Orange;
//#declare c1=Black; #declare c2=Aquamarine;
//declare c1=Black; #declare c2=Blue*.7+Green*.3;

#declare t_custom_paint=
texture{
  pigment{rgb c2}
  finish{specular 2 metallic roughness .1 brilliance 10}
}
texture{
  pigment{rgb c1 transmit .33}
  finish{
   specular 1 roughness .0125
   diffuse 1-rmax reflection{rmin,rmax} conserve_energy
   //irid{.25 thickness pi/2} // :)
  }
}
#declare erbetta= texture {   
      pigment {
         onion
         color_map {
            [ 0.0     rgbft <0.596078, 0.752941, 0.419608, 0.0, 0.0> ]
            [ 0.171   rgbft <0.682, 0.549, 0.42, 0.0, 0.0> ]
            [ 0.274   rgbft <0.557, 0.451, 0.322, 0.0, 0.0> ]
            [ 0.393   rgbft <0.533333, 0.745098, 0.427451, 0.0, 0.0> ]
            [ 0.564   rgbft <0.670588, 0.682353, 0.415686, 0.0, 0.0> ]
            [ 0.701   rgbft <0.482, 0.392, 0.278, 0.0, 0.0> ]
            [ 1.0     rgbft <0.513725, 0.721569, 0.454902, 0.0, 0.0> ]
         }
         turbulence 0.8
         scale  0.4
      }
   }

#declare vetro_WingsMat =texture{
      pigment{ rgbf <0.886667, 1.00000, 1.00000, 0.5>}
      finish{
        ambient rgb <1.00000, 1.00000, 1.00000>/2
        diffuse 0.340000
        brilliance 1.00000
        specular 0.500000 roughness 5.00000e-2
       }
}
#declare pneumatici_WingsMat = texture {
   pigment {
     crackle turbulence 0.2 octaves 2
     colour_map {
        [ 0   rgb <.0,.1,.0>]
        [ 0.1 rgb <.2,.4,.1>]
        [ 0.4 rgb <.2,.3,.2>]
        [ 1.0 rgb <.4,.4,.1>]
     }
   scale 0.3
   }
   finish { ambient 0.2}
   normal {
     crackle 2
     turbulence 0.2
     scale 0.3
   }
   scale 0.2
}  
#declare occhiali_WingsMat =texture{
  pigment{rgb <0.1, 0.1, 0.05>}
  finish{ambient 0.0 reflection 0.5}
  normal {granite 0.4 turbulence 0.3 scale 0.3 cubic_wave slope_map {
   [0.00 0.00]
   [0.75 0.05]
   [0.80 0.10]
   [1.00 0.70]
   }
  }
}
#declare occhi_WingsMat =
  texture{
      pigment{ rgbf <1.00000, 1.00000, 1.00000, 0.00000e+0>}
      finish{
        ambient rgb <1.00000, 1.00000, 1.00000>
        diffuse 0.600000
        brilliance 1.00000
        specular 0.500000 roughness 5.00000e-2
        }
}
#declare mozzi_WingsMat = texture {      
         pigment {
            color rgb <0.658824, 0.658824, 0.658824>
         }      
         finish {
            ambient 0.3
            brilliance 10.0
            phong 1.0
            phong_size 20.0
            reflection {
               0.6 , 0.6
               fresnel  off
               falloff  1.0
               exponent 1.0
               metallic 0.0
            }
         }
}
#declare denti_WingsMat =
  texture{
      pigment{ rgbf <1.00000, 1.00000, 1.00000, 0.00000e+0>}
      finish{
        ambient rgb <1.00000, 1.00000, 1.00000>
        diffuse 0.600000
        brilliance 1.00000
        specular 0.500000 roughness 5.00000e-2
        }
}
#declare casco_WingsMat =t_custom_paint;
#declare _auto_name_no_1_ = 
   texture  // texture44_1
   {   
      pigment
      {
         bozo
         color_map
         {
            [ 0.0     rgbft <0.596078, 0.752941, 0.419608, 0.0, 0.0> ]
            [ 0.171   rgbft <0.682, 0.549, 0.42, 0.0, 0.0> ]
            [ 0.274   rgbft <0.557, 0.451, 0.322, 0.0, 0.0> ]
            [ 0.393   rgbft <0.533333, 0.745098, 0.427451, 0.0, 0.0> ]
            [ 0.564   rgbft <0.670588, 0.682353, 0.415686, 0.0, 0.0> ]
            [ 0.701   rgbft <0.482, 0.392, 0.278, 0.0, 0.0> ]
            [ 1.0     rgbft <0.513725, 0.721569, 0.454902, 0.0, 0.0> ]
         }
         turbulence 0.2
         ramp_wave
         scale  <0.4, 0.4, 2.0>
      }
   }
   texture  // texture45_1
   {   
      pigment
      {
         bozo
         color_map
         {
            [ 0.0     rgbft <0.682, 0.604, 0.38, 1.0, 0.0> ]
            [ 0.087   rgbft <0.658824, 0.788235, 0.572549, 0.02, 0.0> ]
            [ 0.226   rgbft <0.635, 0.553, 0.325, 1.0, 0.0> ]
            [ 0.348   rgbft <0.658824, 0.788235, 0.572549, 0.02, 0.0> ]
            [ 0.496   rgbft <0.682, 0.604, 0.38, 1.0, 0.0> ]
            [ 0.565   rgbft <0.658824, 0.788235, 0.572549, 0.02, 0.0> ]
            [ 0.661   rgbft <0.682, 0.604, 0.38, 1.0, 0.0> ]
            [ 0.835   rgbft <0.658824, 0.788235, 0.572549, 0.02, 0.0> ]
            [ 1.0     rgbft <0.682, 0.604, 0.38, 1.0, 0.0> ]
         }
         turbulence 0.8
         ramp_wave
         scale  0.4
      }
   }
#declare Verdolino_WingsMat =texture { _auto_name_no_1_  scale 0.2 normal {crackle 2 turbulence 0.2 scale 0.3 }};
#declare nari_WingsMat =texture { _auto_name_no_1_  scale 0.2};

#declare Giallino_WingsMat = texture{
	     pigment{ 
	      	granite
	      	color_map {
	      		[0.0 rgbf <1.00000, 1.00000, 0.506667, 0.00000e+0>]
            	[ 0.6     rgbft <0.5, 0.3, 0.2, 0.0, 0.0> ]
	      	}
     	 }
         finish {
            ambient 0.1
            specular 0.1
            roughness 0.5
         }
         normal {bozo 2 turbulence 0.2 scale 0.2 }
}
#declare Corpo_WingsMat =texture {      
         pigment {
            granite
            color_map {
               [ 0.0     rgbft <0.812, 0.882, 0.478, 0.0, 0.0> ]
               [ 0.6     rgbft <0.98, 0.81, 0.6, 0.0, 0.0> ]
               [ 0.6     rgbft <0.5, 0.3, 0.2, 0.0, 0.0> ]
               [ 0.65    rgbft <0.5, 0.3, 0.2, 0.0, 0.0> ]
               [ 0.65    rgbft <0.8, 0.53, 0.46, 0.0, 0.0> ]
               [ 1.0     rgbft <0.85, 0.75, 0.35, 0.0, 0.0> ]
            }
         }      
         finish {
            ambient 0.1
            specular 0.1
            roughness 0.5
         }
         scale 0.1
}
#declare t_asfalto =texture {
     pigment {
        granite
        color_map {
			[0.000 color rgbt <0, 0, 0, 0.000>]
			[1.000 color rgbt <0.6, 0.675, 0.55, 0.000>]
        }
        turbulence 1.85
        ramp_wave
        //scale 0.1 // Troppo grandi per alte risoluzioni
        scale  0.01
     }
}
#declare t_striscia_asfalto =texture {
     pigment {
        granite
        color_map {
			[0.000 color rgbt <0.85, 0.9, 0.95, 0.000>]
			[1.000 color rgbt <1, 1, 1, 0.000>]
        }
        turbulence 1.85
        ramp_wave
        //scale 0.1 // Troppo grandi per alte risoluzioni
        scale  0.01
     }
}

// ---------------------------------------------------------------

// Wings objects -------------------------------------------------
#declare lente2 = mesh2 {
vertex_vectors {32,<1.28612,0.444602,0.139917>,<1.27424,0.440178,0.158717>,<1.26416,0.427579,0.174654>,<1.25743,0.408724,0.185303>,<1.25506,0.386483,0.189043>,<1.25743,0.364242,0.185303>,<1.26416,0.345387,0.174654>,<1.27424,0.332788,0.158717>,<1.28612,0.328364,0.139917>,<1.29800,0.332788,0.121118>,<1.30808,0.345387,0.105180>,<1.31481,0.364242,9.45310e-2>,<1.31718,0.386483,9.07915e-2>,<1.31481,0.408724,9.45310e-2>,<1.30808,0.427579,0.105180>,<1.29800,0.440178,0.121118>,<1.29391,0.444602,0.144845>,<1.28203,0.440178,0.163644>,<1.27196,0.427579,0.179582>,<1.26522,0.408724,0.190231>,<1.26286,0.386483,0.193970>,<1.26522,0.364242,0.190231>,<1.27196,0.345387,0.179582>,<1.28203,0.332788,0.163644>,<1.29391,0.328364,0.144845>,<1.30580,0.332788,0.126045>,<1.31587,0.345387,0.110108>,<1.32261,0.364242,9.94587e-2>,<1.32497,0.386483,9.57192e-2>,<1.32261,0.408724,9.94587e-2>,<1.31587,0.427579,0.110108>,<1.30580,0.440178,0.126045>}
normal_vectors {32,<-0.304939,0.944952,-0.118651>,<-0.670351,0.741978,9.93589e-3>,<-0.884621,0.461800,6.46993e-2>,<-0.977623,0.209426,-1.98716e-2>,<-0.976569,4.63772e-2,0.210147>,<-0.957602,-0.224825,0.180144>,<-0.884621,-0.461800,6.46993e-2>,<-0.768737,-0.628470,-0.118611>,<-0.304939,-0.944952,-0.118651>,<-0.332622,-0.783884,-0.524297>,<-0.356047,-0.527387,-0.771423>,<-0.121290,-0.303989,-0.944923>,<-0.415028,-1.00278e-14,-0.909809>,<-0.121290,0.303989,-0.944923>,<-0.356047,0.527387,-0.771423>,<-0.482675,0.663966,-0.571117>,<0.304939,0.944952,0.118651>,<0.482675,0.663966,0.571117>,<0.356047,0.527387,0.771423>,<0.121290,0.303989,0.944923>,<0.229052,-4.63772e-2,0.972309>,<0.266986,-0.310519,0.912303>,<0.356047,-0.527387,0.771423>,<0.332622,-0.783884,0.524297>,<0.304939,-0.944952,0.118651>,<0.768737,-0.628470,0.118611>,<0.884621,-0.461800,-6.46993e-2>,<0.977623,-0.209426,1.98716e-2>,<0.937919,-2.58519e-16,-0.346855>,<0.977623,0.209426,1.98716e-2>,<0.884621,0.461800,-6.46993e-2>,<0.670351,0.741978,-9.93589e-3>}
texture_list { 11,
	texture { vetro_WingsMat }
	texture { pneumatici_WingsMat }
	texture { occhiali_WingsMat }
	texture { occhi_WingsMat }
	texture { nari_WingsMat }
	texture { mozzi_WingsMat }
	texture { denti_WingsMat }
	texture { casco_WingsMat }
	texture { Verdolino_WingsMat }
	texture { Giallino_WingsMat }
	texture { Corpo_WingsMat }
}
face_indices {60,<0,1,17>,0,<1,0,15>,0,<1,2,18>,0,<2,1,15>,0,<2,3,19>,0,<2,15,14>,0,<3,2,14>,0,<3,14,13>,0,<4,3,13>,0,<4,13,12>,0,<4,20,19>,0,<5,4,12>,0,<5,12,11>,0,<5,21,20>,0,<6,5,11>,0,<6,11,10>,0,<6,22,21>,0,<7,6,10>,0,<7,10,9>,0,<7,23,22>,0,<8,24,23>,0,<9,8,7>,0,<9,25,24>,0,<10,26,25>,0,<11,12,28>,0,<11,27,26>,0,<13,14,30>,0,<13,28,12>,0,<13,29,28>,0,<14,15,31>,0,<15,0,16>,0,<16,31,15>,0,<17,16,0>,0,<18,17,1>,0,<19,3,4>,0,<19,18,2>,0,<20,4,5>,0,<21,5,6>,0,<22,6,7>,0,<23,7,8>,0,<23,24,25>,0,<24,8,9>,0,<25,9,10>,0,<25,22,23>,0,<25,26,22>,0,<26,10,11>,0,<26,21,22>,0,<26,27,21>,0,<27,20,21>,0,<27,28,20>,0,<28,19,20>,0,<28,27,11>,0,<28,29,19>,0,<29,18,19>,0,<29,30,18>,0,<30,17,18>,0,<30,29,13>,0,<30,31,17>,0,<31,16,17>,0,<31,30,14>,0}
normal_indices {60,<0,1,17>,<1,0,15>,<1,2,18>,<2,1,15>,<2,3,19>,<2,15,14>,<3,2,14>,<3,14,13>,<4,3,13>,<4,13,12>,<4,20,19>,<5,4,12>,<5,12,11>,<5,21,20>,<6,5,11>,<6,11,10>,<6,22,21>,<7,6,10>,<7,10,9>,<7,23,22>,<8,24,23>,<9,8,7>,<9,25,24>,<10,26,25>,<11,12,28>,<11,27,26>,<13,14,30>,<13,28,12>,<13,29,28>,<14,15,31>,<15,0,16>,<16,31,15>,<17,16,0>,<18,17,1>,<19,3,4>,<19,18,2>,<20,4,5>,<21,5,6>,<22,6,7>,<23,7,8>,<23,24,25>,<24,8,9>,<25,9,10>,<25,22,23>,<25,26,22>,<26,10,11>,<26,21,22>,<26,27,21>,<27,20,21>,<27,28,20>,<28,19,20>,<28,27,11>,<28,29,19>,<29,18,19>,<29,30,18>,<30,17,18>,<30,29,13>,<30,31,17>,<31,16,17>,<31,30,14>}
}

#declare lente1 = mesh2 {
vertex_vectors {32,<1.33052,0.444602,-5.06086e-2>,<1.33485,0.440178,-2.87944e-2>,<1.33853,0.427579,-1.03012e-2>,<1.34099,0.408724,2.05553e-3>,<1.34185,0.386483,6.39465e-3>,<1.34099,0.364242,2.05553e-3>,<1.33853,0.345387,-1.03012e-2>,<1.33485,0.332788,-2.87944e-2>,<1.33052,0.328364,-5.06086e-2>,<1.32618,0.332788,-7.24228e-2>,<1.32250,0.345387,-9.09159e-2>,<1.32005,0.364242,-0.103273>,<1.31919,0.386483,-0.107612>,<1.32005,0.408724,-0.103273>,<1.32250,0.427579,-9.09159e-2>,<1.32618,0.440178,-7.24228e-2>,<1.33956,0.444602,-5.24067e-2>,<1.34390,0.440178,-3.05925e-2>,<1.34758,0.427579,-1.20993e-2>,<1.35003,0.408724,2.57397e-4>,<1.35090,0.386483,4.59651e-3>,<1.35003,0.364242,2.57397e-4>,<1.34758,0.345387,-1.20993e-2>,<1.34390,0.332788,-3.05925e-2>,<1.33956,0.328364,-5.24067e-2>,<1.33523,0.332788,-7.42209e-2>,<1.33155,0.345387,-9.27141e-2>,<1.32909,0.364242,-0.105071>,<1.32823,0.386483,-0.109410>,<1.32909,0.408724,-0.105071>,<1.33155,0.427579,-9.27141e-2>,<1.33523,0.440178,-7.42209e-2>}
normal_vectors {32,<-0.327207,0.944952,1.16962e-3>,<-0.498783,0.783884,0.369785>,<-0.609430,0.527387,0.591994>,<-0.576932,0.310519,0.755465>,<-0.440894,1.57360e-16,0.897559>,<-0.576932,-0.310519,0.755465>,<-0.609430,-0.527387,0.591994>,<-0.655638,-0.663966,0.359568>,<-0.327207,-0.944952,1.16962e-3>,<-0.622021,-0.741978,-0.250116>,<-0.802310,-0.461800,-0.378206>,<-0.828941,-0.224825,-0.512163>,<-0.927609,0.00000e+0,-0.373554>,<-0.828941,0.224825,-0.512163>,<-0.802310,0.461800,-0.378206>,<-0.760023,0.628470,-0.165501>,<0.327207,0.944952,-1.16962e-3>,<0.760023,0.628470,0.165501>,<0.802310,0.461800,0.378206>,<0.828941,0.224825,0.512163>,<0.927609,-2.78766e-16,0.373554>,<0.828941,-0.224825,0.512163>,<0.802310,-0.461800,0.378206>,<0.622021,-0.741978,0.250116>,<0.327207,-0.944952,-1.16962e-3>,<0.655638,-0.663966,-0.359568>,<0.609430,-0.527387,-0.591994>,<0.576932,-0.310519,-0.755465>,<0.440894,4.18127e-15,-0.897559>,<0.576932,0.310519,-0.755465>,<0.609430,0.527387,-0.591994>,<0.498783,0.783884,-0.369785>}
texture_list { 11,
	texture { vetro_WingsMat }
	texture { pneumatici_WingsMat }
	texture { occhiali_WingsMat }
	texture { occhi_WingsMat }
	texture { nari_WingsMat }
	texture { mozzi_WingsMat }
	texture { denti_WingsMat }
	texture { casco_WingsMat }
	texture { Verdolino_WingsMat }
	texture { Giallino_WingsMat }
	texture { Corpo_WingsMat }
}
face_indices {60,<0,16,31>,0,<1,0,15>,0,<1,17,16>,0,<2,1,15>,0,<2,15,14>,0,<2,18,17>,0,<3,2,14>,0,<3,14,13>,0,<3,19,18>,0,<4,3,13>,0,<4,5,21>,0,<4,13,12>,0,<4,20,19>,0,<5,4,12>,0,<5,6,22>,0,<5,12,11>,0,<6,5,11>,0,<6,7,23>,0,<6,11,10>,0,<7,6,10>,0,<7,8,24>,0,<7,10,9>,0,<8,9,25>,0,<9,8,7>,0,<9,10,26>,0,<10,11,27>,0,<11,12,28>,0,<13,29,28>,0,<14,30,29>,0,<15,31,30>,0,<16,0,1>,0,<17,1,2>,0,<18,2,3>,0,<19,3,4>,0,<21,20,4>,0,<22,21,5>,0,<23,22,6>,0,<23,24,25>,0,<24,23,7>,0,<25,22,23>,0,<25,24,8>,0,<25,26,22>,0,<26,21,22>,0,<26,25,9>,0,<26,27,21>,0,<27,20,21>,0,<27,26,10>,0,<27,28,20>,0,<28,12,13>,0,<28,19,20>,0,<28,27,11>,0,<28,29,19>,0,<29,13,14>,0,<29,18,19>,0,<29,30,18>,0,<30,14,15>,0,<30,17,18>,0,<30,31,17>,0,<31,15,0>,0,<31,16,17>,0}
normal_indices {60,<0,16,31>,<1,0,15>,<1,17,16>,<2,1,15>,<2,15,14>,<2,18,17>,<3,2,14>,<3,14,13>,<3,19,18>,<4,3,13>,<4,5,21>,<4,13,12>,<4,20,19>,<5,4,12>,<5,6,22>,<5,12,11>,<6,5,11>,<6,7,23>,<6,11,10>,<7,6,10>,<7,8,24>,<7,10,9>,<8,9,25>,<9,8,7>,<9,10,26>,<10,11,27>,<11,12,28>,<13,29,28>,<14,30,29>,<15,31,30>,<16,0,1>,<17,1,2>,<18,2,3>,<19,3,4>,<21,20,4>,<22,21,5>,<23,22,6>,<23,24,25>,<24,23,7>,<25,22,23>,<25,24,8>,<25,26,22>,<26,21,22>,<26,25,9>,<26,27,21>,<27,20,21>,<27,26,10>,<27,28,20>,<28,12,13>,<28,19,20>,<28,27,11>,<28,29,19>,<29,13,14>,<29,18,19>,<29,30,18>,<30,14,15>,<30,17,18>,<30,31,17>,<31,15,0>,<31,16,17>}
}

#declare elmetto = mesh2 {
vertex_vectors {162,<1.22294,0.567683,-4.49843e-3>,<1.21838,0.568120,2.13314e-2>,<1.20539,0.569367,4.32288e-2>,<1.18594,0.571232,5.78602e-2>,<1.16301,0.573432,6.29981e-2>,<1.14008,0.575632,5.78602e-2>,<1.12064,0.577497,4.32288e-2>,<1.10765,0.578743,2.13314e-2>,<1.10309,0.579181,-4.49843e-3>,<1.10765,0.578743,-3.03282e-2>,<1.12064,0.577497,-5.22257e-2>,<1.14008,0.575632,-6.68571e-2>,<1.16301,0.573432,-7.19950e-2>,<1.18594,0.571232,-6.68571e-2>,<1.20539,0.569367,-5.22257e-2>,<1.21838,0.568120,-3.03282e-2>,<1.27041,0.529597,-4.49843e-3>,<1.26198,0.530405,4.32288e-2>,<1.23798,0.532708,8.36900e-2>,<1.20206,0.536154,0.110725>,<1.15968,0.540219,0.120219>,<1.11731,0.544284,0.110725>,<1.08139,0.547731,8.36900e-2>,<1.05738,0.550033,4.32288e-2>,<1.04895,0.550842,-4.49843e-3>,<1.05738,0.550033,-5.22257e-2>,<1.08139,0.547731,-9.26869e-2>,<1.11731,0.544284,-0.119722>,<1.15968,0.540219,-0.129216>,<1.20206,0.536154,-0.119722>,<1.23798,0.532708,-9.26869e-2>,<1.26198,0.530405,-5.22257e-2>,<1.29938,0.476634,-4.49843e-3>,<1.28836,0.477691,5.78602e-2>,<1.25700,0.480700,0.110725>,<1.21007,0.485202,0.146049>,<1.15470,0.490514,0.158453>,<1.09934,0.495825,0.146049>,<1.05240,0.500328,0.110725>,<1.02104,0.503336,5.78602e-2>,<1.01003,0.504393,-4.49843e-3>,<1.02104,0.503336,-6.68571e-2>,<1.05240,0.500328,-0.119722>,<1.09934,0.495825,-0.155046>,<1.15470,0.490514,-0.167449>,<1.21007,0.485202,-0.155046>,<1.25700,0.480700,-0.119722>,<1.28836,0.477691,-6.68571e-2>,<1.30542,0.416859,-4.49843e-3>,<1.29350,0.418002,6.29981e-2>,<1.25956,0.421259,0.120219>,<1.20875,0.426133,0.158453>,<1.14883,0.431882,0.171879>,<1.08890,0.437630,0.158453>,<1.03810,0.442504,0.120219>,<1.00415,0.445761,6.29981e-2>,<0.992231,0.446904,-4.49843e-3>,<1.00415,0.445761,-7.19950e-2>,<1.03810,0.442504,-0.129216>,<1.08890,0.437630,-0.167449>,<1.14883,0.431882,-0.180875>,<1.20875,0.426133,-0.167449>,<1.25956,0.421259,-0.129216>,<1.29350,0.418002,-7.19950e-2>,<1.16418,0.585094,-4.49843e-3>,<1.29634,0.417730,-4.49843e-3>,<1.28511,0.418807,5.90833e-2>,<1.25313,0.421875,0.112985>,<1.20528,0.426466,0.149001>,<1.14883,0.431882,0.161649>,<1.09238,0.437297,0.149001>,<1.04452,0.441888,0.112985>,<1.01254,0.444956,5.90833e-2>,<1.00131,0.446033,-4.49843e-3>,<1.01254,0.444956,-6.80802e-2>,<1.04452,0.441888,-0.121982>,<1.09238,0.437297,-0.157998>,<1.14883,0.431882,-0.170646>,<1.20528,0.426466,-0.157998>,<1.25313,0.421875,-0.121982>,<1.28511,0.418807,-6.80802e-2>,<1.22294,0.567683,-4.49843e-3>,<1.21838,0.568120,2.13314e-2>,<1.20539,0.569367,4.32288e-2>,<1.18594,0.571232,5.78602e-2>,<1.16301,0.573432,6.29981e-2>,<1.14008,0.575632,5.78602e-2>,<1.12064,0.577497,4.32288e-2>,<1.10765,0.578743,2.13314e-2>,<1.10309,0.579181,-4.49843e-3>,<1.10765,0.578743,-3.03282e-2>,<1.12064,0.577497,-5.22257e-2>,<1.14008,0.575632,-6.68571e-2>,<1.16301,0.573432,-7.19950e-2>,<1.18594,0.571232,-6.68571e-2>,<1.20539,0.569367,-5.22257e-2>,<1.21838,0.568120,-3.03282e-2>,<1.27041,0.529597,-4.49843e-3>,<1.26198,0.530405,4.32288e-2>,<1.23798,0.532708,8.36900e-2>,<1.20206,0.536154,0.110725>,<1.15968,0.540219,0.120219>,<1.11731,0.544284,0.110725>,<1.08139,0.547731,8.36900e-2>,<1.05738,0.550033,4.32288e-2>,<1.04895,0.550842,-4.49843e-3>,<1.05738,0.550033,-5.22257e-2>,<1.08139,0.547731,-9.26869e-2>,<1.11731,0.544284,-0.119722>,<1.15968,0.540219,-0.129216>,<1.20206,0.536154,-0.119722>,<1.23798,0.532708,-9.26869e-2>,<1.26198,0.530405,-5.22257e-2>,<1.29938,0.476634,-4.49843e-3>,<1.28836,0.477691,5.78602e-2>,<1.25700,0.480700,0.110725>,<1.21007,0.485202,0.146049>,<1.15470,0.490514,0.158453>,<1.09934,0.495825,0.146049>,<1.05240,0.500328,0.110725>,<1.02104,0.503336,5.78602e-2>,<1.01003,0.504393,-4.49843e-3>,<1.02104,0.503336,-6.68571e-2>,<1.05240,0.500328,-0.119722>,<1.09934,0.495825,-0.155046>,<1.15470,0.490514,-0.167449>,<1.21007,0.485202,-0.155046>,<1.25700,0.480700,-0.119722>,<1.28836,0.477691,-6.68571e-2>,<1.30542,0.416859,-4.49843e-3>,<1.29350,0.418002,6.29981e-2>,<1.25956,0.421259,0.120219>,<1.20875,0.426133,0.158453>,<1.14883,0.431882,0.171879>,<1.08890,0.437630,0.158453>,<1.03810,0.442504,0.120219>,<1.00415,0.445761,6.29981e-2>,<0.992231,0.446904,-4.49843e-3>,<1.00415,0.445761,-7.19950e-2>,<1.03810,0.442504,-0.129216>,<1.08890,0.437630,-0.167449>,<1.14883,0.431882,-0.180875>,<1.20875,0.426133,-0.167449>,<1.25956,0.421259,-0.129216>,<1.29350,0.418002,-7.19950e-2>,<1.16418,0.585094,-4.49843e-3>,<1.29634,0.417730,-4.49843e-3>,<1.28511,0.418807,5.90833e-2>,<1.25313,0.421875,0.112985>,<1.20528,0.426466,0.149001>,<1.14883,0.431882,0.161649>,<1.09238,0.437297,0.149001>,<1.04452,0.441888,0.112985>,<1.01254,0.444956,5.90833e-2>,<1.00131,0.446033,-4.49843e-3>,<1.01254,0.444956,-6.80802e-2>,<1.04452,0.441888,-0.121982>,<1.09238,0.437297,-0.157998>,<1.14883,0.431882,-0.170646>,<1.20528,0.426466,-0.157998>,<1.25313,0.421875,-0.121982>,<1.28511,0.418807,-6.80802e-2>}
normal_vectors {162,<0.463277,0.886214,-4.18326e-16>,<0.475776,0.870921,0.123022>,<0.396364,0.883739,0.248798>,<0.268754,0.901806,0.338404>,<8.76327e-2,0.913133,0.398132>,<-9.20290e-2,0.936687,0.337859>,<-0.220183,0.943372,0.248131>,<-0.300103,0.945993,0.122617>,<-0.284982,0.958533,4.53669e-16>,<-0.300103,0.945993,-0.122617>,<-0.220183,0.943372,-0.248131>,<-9.20290e-2,0.936687,-0.337859>,<8.76327e-2,0.913133,-0.398132>,<0.268754,0.901806,-0.338404>,<0.396364,0.883739,-0.248798>,<0.475776,0.870921,-0.123022>,<0.721681,0.692226,-2.13223e-16>,<0.721055,0.652165,0.234009>,<0.582150,0.678224,0.448458>,<0.359398,0.713181,0.601835>,<6.74412e-2,0.702284,0.708695>,<-0.216501,0.769572,0.600738>,<-0.440688,0.778417,0.447058>,<-0.581034,0.779784,0.233101>,<-0.573974,0.818873,2.84202e-17>,<-0.581034,0.779784,-0.233101>,<-0.440688,0.778417,-0.447058>,<-0.216501,0.769572,-0.600738>,<6.74412e-2,0.702284,-0.708695>,<0.359398,0.713181,-0.601835>,<0.582150,0.678224,-0.448458>,<0.721055,0.652165,-0.234009>,<0.932904,0.360125,-1.24399e-15>,<0.897424,0.307602,0.316247>,<0.719363,0.337805,0.606963>,<0.423986,0.380233,0.821984>,<3.43073e-2,0.357033,0.933461>,<-0.343130,0.456477,0.820909>,<-0.640006,0.472931,0.605581>,<-0.819609,0.478337,0.315331>,<-0.843922,0.536465,-1.62006e-16>,<-0.819609,0.478337,-0.315331>,<-0.640006,0.472931,-0.605581>,<-0.343130,0.456477,-0.820909>,<3.43073e-2,0.357033,-0.933461>,<0.423986,0.380233,-0.821984>,<0.719363,0.337805,-0.606963>,<0.897424,0.307602,-0.316247>,<0.814380,-0.580333,-1.93408e-15>,<0.516529,-0.815050,0.262470>,<0.474694,-0.685518,0.552024>,<0.210231,-0.657813,0.723246>,<-6.05948e-2,-0.631989,0.772605>,<-0.331622,-0.604738,0.724099>,<-0.597376,-0.580502,0.553317>,<-0.762556,-0.566398,0.312572>,<-0.827245,-0.561841,-6.06230e-16>,<-0.762556,-0.566398,-0.312572>,<-0.597376,-0.580502,-0.553317>,<-0.331622,-0.604738,-0.724099>,<-6.05948e-2,-0.631989,-0.772605>,<0.210231,-0.657813,-0.723246>,<0.474694,-0.685518,-0.552024>,<0.638563,-0.703659,-0.311611>,<9.55748e-2,0.995422,-2.51532e-17>,<-9.54947e-2,-0.995430,4.98370e-16>,<-9.54947e-2,-0.995430,-5.23288e-15>,<-9.54947e-2,-0.995430,1.64661e-15>,<-9.54947e-2,-0.995430,7.74267e-15>,<-9.54947e-2,-0.995430,-3.98375e-29>,<-9.54947e-2,-0.995430,-3.75571e-15>,<-9.54947e-2,-0.995430,3.75571e-15>,<-9.54947e-2,-0.995430,-3.04803e-15>,<-9.54947e-2,-0.995430,0.00000e+0>,<-9.54947e-2,-0.995430,2.10910e-15>,<-9.54947e-2,-0.995430,-7.74267e-15>,<-9.54947e-2,-0.995430,-4.62487e-16>,<-9.54947e-2,-0.995430,-2.99022e-15>,<-9.54947e-2,-0.995430,-7.74267e-15>,<-9.54947e-2,-0.995430,-3.52447e-15>,<-9.54947e-2,-0.995430,2.10910e-15>,<-0.463277,-0.886214,4.18326e-16>,<-0.475776,-0.870921,-0.123022>,<-0.396364,-0.883739,-0.248798>,<-0.268754,-0.901806,-0.338404>,<-8.76327e-2,-0.913133,-0.398132>,<9.20290e-2,-0.936687,-0.337859>,<0.220183,-0.943372,-0.248131>,<0.300103,-0.945993,-0.122617>,<0.284982,-0.958533,-4.53669e-16>,<0.300103,-0.945993,0.122617>,<0.220183,-0.943372,0.248131>,<9.20290e-2,-0.936687,0.337859>,<-8.76327e-2,-0.913133,0.398132>,<-0.268754,-0.901806,0.338404>,<-0.396364,-0.883739,0.248798>,<-0.475776,-0.870921,0.123022>,<-0.721681,-0.692226,4.50138e-16>,<-0.721055,-0.652165,-0.234009>,<-0.582150,-0.678224,-0.448458>,<-0.359398,-0.713181,-0.601835>,<-6.74412e-2,-0.702284,-0.708695>,<0.216501,-0.769572,-0.600738>,<0.440688,-0.778417,-0.447058>,<0.581034,-0.779784,-0.233101>,<0.573974,-0.818873,-2.32098e-16>,<0.581034,-0.779784,0.233101>,<0.440688,-0.778417,0.447058>,<0.216501,-0.769572,0.600738>,<-6.74412e-2,-0.702284,0.708695>,<-0.359398,-0.713181,0.601835>,<-0.582150,-0.678224,0.448458>,<-0.721055,-0.652165,0.234009>,<-0.932904,-0.360125,1.06287e-15>,<-0.897424,-0.307602,-0.316247>,<-0.719363,-0.337805,-0.606963>,<-0.423986,-0.380233,-0.821984>,<-3.43073e-2,-0.357033,-0.933461>,<0.343130,-0.456477,-0.820909>,<0.640006,-0.472931,-0.605581>,<0.819609,-0.478337,-0.315331>,<0.843922,-0.536465,-4.76489e-17>,<0.819609,-0.478337,0.315331>,<0.640006,-0.472931,0.605581>,<0.343130,-0.456477,0.820909>,<-3.43073e-2,-0.357033,0.933461>,<-0.423986,-0.380233,0.821984>,<-0.719363,-0.337805,0.606963>,<-0.897424,-0.307602,0.316247>,<-0.702481,0.711702,1.66927e-15>,<-0.638563,0.703659,-0.311611>,<-0.474694,0.685518,-0.552024>,<-0.210231,0.657813,-0.723246>,<6.05948e-2,0.631989,-0.772605>,<0.331622,0.604738,-0.724099>,<0.597376,0.580502,-0.553317>,<0.663569,0.700281,-0.263216>,<0.912103,0.409962,1.00126e-15>,<0.762556,0.566398,0.312572>,<0.597376,0.580502,0.553317>,<0.331622,0.604738,0.724099>,<6.05948e-2,0.631989,0.772605>,<-0.210231,0.657813,0.723246>,<-0.474694,0.685518,0.552024>,<-0.638563,0.703659,0.311611>,<-9.55748e-2,-0.995422,2.51532e-17>,<9.54947e-2,0.995430,0.00000e+0>,<9.54947e-2,0.995430,3.98696e-15>,<9.54947e-2,0.995430,-1.64661e-15>,<9.54947e-2,0.995430,-7.74267e-15>,<9.54947e-2,0.995430,3.98375e-29>,<9.54947e-2,0.995430,3.75571e-15>,<9.54947e-2,0.995430,-3.75571e-15>,<9.54947e-2,0.995430,5.98043e-15>,<9.54947e-2,0.995430,-4.69464e-16>,<9.54947e-2,0.995430,-2.10910e-15>,<9.54947e-2,0.995430,7.74267e-15>,<9.54947e-2,0.995430,4.62487e-16>,<9.54947e-2,0.995430,2.99022e-15>,<9.54947e-2,0.995430,7.74267e-15>,<9.54947e-2,0.995430,3.52447e-15>,<9.54947e-2,0.995430,-2.10910e-15>}
texture_list { 11,
	texture { vetro_WingsMat }
	texture { pneumatici_WingsMat }
	texture { occhiali_WingsMat }
	texture { occhi_WingsMat }
	texture { nari_WingsMat }
	texture { mozzi_WingsMat }
	texture { denti_WingsMat }
	texture { casco_WingsMat }
	texture { Verdolino_WingsMat }
	texture { Giallino_WingsMat }
	texture { Corpo_WingsMat }
}
face_indices {320,<0,16,15>,7,<0,64,1>,7,<1,17,16>,7,<1,64,2>,7,<2,18,17>,7,<2,64,3>,7,<3,18,2>,7,<3,19,18>,7,<3,64,4>,7,<4,5,21>,7,<4,19,3>,7,<4,20,19>,7,<4,21,20>,7,<4,64,5>,7,<5,6,22>,7,<5,22,21>,7,<5,64,6>,7,<6,7,23>,7,<6,64,7>,7,<7,8,24>,7,<7,24,23>,7,<7,64,8>,7,<8,64,9>,7,<9,24,8>,7,<9,25,24>,7,<9,64,10>,7,<10,25,9>,7,<10,26,25>,7,<10,64,11>,7,<11,26,10>,7,<11,27,26>,7,<11,64,12>,7,<12,27,11>,7,<12,28,27>,7,<12,64,13>,7,<13,14,30>,7,<13,29,12>,7,<13,30,29>,7,<13,64,14>,7,<14,64,15>,7,<15,31,14>,7,<15,64,0>,7,<16,0,1>,7,<16,31,15>,7,<16,32,31>,7,<17,1,2>,7,<17,32,16>,7,<17,33,32>,7,<18,34,33>,7,<19,34,18>,7,<19,35,34>,7,<20,21,37>,7,<20,35,19>,7,<20,36,35>,7,<20,37,36>,7,<21,22,38>,7,<21,38,37>,7,<22,23,39>,7,<23,22,6>,7,<23,24,40>,7,<23,40,39>,7,<25,40,24>,7,<25,41,40>,7,<26,41,25>,7,<26,42,41>,7,<27,42,26>,7,<27,43,42>,7,<28,43,27>,7,<28,44,43>,7,<29,28,12>,7,<29,30,46>,7,<29,45,28>,7,<29,46,45>,7,<31,30,14>,7,<31,47,30>,7,<32,47,31>,7,<33,17,18>,7,<33,48,32>,7,<33,49,48>,7,<34,49,33>,7,<34,50,49>,7,<35,50,34>,7,<35,51,50>,7,<36,37,53>,7,<36,51,35>,7,<36,52,51>,7,<36,53,52>,7,<37,38,54>,7,<38,39,55>,7,<39,38,22>,7,<39,40,56>,7,<41,56,40>,7,<41,57,56>,7,<42,58,57>,7,<43,59,58>,7,<44,45,61>,7,<44,59,43>,7,<44,60,59>,7,<44,61,60>,7,<45,44,28>,7,<45,46,62>,7,<45,62,61>,7,<46,47,63>,7,<46,63,62>,7,<47,32,48>,7,<47,46,30>,7,<47,48,63>,7,<48,65,80>,7,<49,66,65>,7,<50,67,49>,7,<51,68,50>,7,<52,69,51>,7,<53,69,52>,7,<53,70,69>,7,<54,53,37>,7,<54,70,53>,7,<54,71,70>,7,<55,54,38>,7,<55,71,54>,7,<55,72,71>,7,<56,55,39>,7,<56,57,74>,7,<56,72,55>,7,<56,73,72>,7,<57,41,42>,7,<57,58,75>,7,<58,42,43>,7,<58,59,76>,7,<59,60,77>,7,<61,78,77>,7,<62,79,78>,7,<63,80,79>,7,<65,48,49>,7,<65,66,147>,7,<65,146,80>,7,<66,67,148>,7,<67,66,49>,7,<67,68,149>,7,<68,67,50>,7,<68,69,150>,7,<69,68,51>,7,<69,70,151>,7,<70,71,152>,7,<71,72,153>,7,<72,73,154>,7,<74,73,56>,7,<74,155,73>,7,<75,74,57>,7,<75,156,74>,7,<76,75,58>,7,<76,157,75>,7,<77,60,61>,7,<77,76,59>,7,<77,158,76>,7,<78,61,62>,7,<78,159,77>,7,<79,62,63>,7,<79,160,78>,7,<80,63,48>,7,<80,161,79>,7,<81,145,96>,7,<82,81,97>,7,<82,97,98>,7,<82,145,81>,7,<83,82,98>,7,<83,145,82>,7,<84,83,99>,7,<84,99,100>,7,<84,100,85>,7,<84,145,83>,7,<85,101,102>,7,<85,102,86>,7,<85,145,84>,7,<86,102,103>,7,<86,103,87>,7,<86,145,85>,7,<87,103,104>,7,<87,145,86>,7,<88,104,105>,7,<88,145,87>,7,<89,105,90>,7,<89,145,88>,7,<90,106,91>,7,<90,145,89>,7,<91,145,90>,7,<92,91,107>,7,<92,107,108>,7,<92,145,91>,7,<93,92,108>,7,<93,108,109>,7,<93,109,110>,7,<93,110,94>,7,<93,145,92>,7,<94,110,111>,7,<94,111,95>,7,<94,145,93>,7,<95,111,112>,7,<95,112,96>,7,<95,145,94>,7,<96,97,81>,7,<96,112,97>,7,<96,145,95>,7,<98,97,113>,7,<98,99,83>,7,<98,113,114>,7,<99,98,114>,7,<100,99,115>,7,<100,101,85>,7,<100,115,116>,7,<100,116,101>,7,<101,117,118>,7,<101,118,102>,7,<102,118,119>,7,<102,119,103>,7,<103,119,120>,7,<104,88,87>,7,<104,120,121>,7,<104,121,105>,7,<105,89,88>,7,<105,106,90>,7,<105,121,106>,7,<106,107,91>,7,<106,122,107>,7,<108,107,123>,7,<108,123,124>,7,<109,108,124>,7,<109,124,125>,7,<109,125,126>,7,<109,126,110>,7,<110,126,127>,7,<110,127,111>,7,<111,127,128>,7,<111,128,112>,7,<112,113,97>,7,<112,128,113>,7,<114,113,129>,7,<114,115,99>,7,<114,129,130>,7,<115,114,130>,7,<115,130,131>,7,<116,115,131>,7,<116,117,101>,7,<116,131,132>,7,<117,116,132>,7,<117,132,133>,7,<117,133,134>,7,<117,134,118>,7,<118,134,135>,7,<119,135,136>,7,<120,104,103>,7,<120,136,137>,7,<121,122,106>,7,<121,137,122>,7,<122,123,107>,7,<123,122,138>,7,<124,123,139>,7,<125,124,140>,7,<125,140,141>,7,<125,141,142>,7,<125,142,126>,7,<126,142,143>,7,<126,143,127>,7,<127,143,144>,7,<127,144,128>,7,<128,129,113>,7,<128,144,129>,7,<129,144,161>,7,<129,146,147>,7,<129,147,130>,7,<130,147,148>,7,<130,148,131>,7,<131,148,149>,7,<131,149,132>,7,<132,149,150>,7,<132,150,133>,7,<133,150,134>,7,<134,151,135>,7,<135,119,118>,7,<135,152,136>,7,<136,120,119>,7,<136,153,154>,7,<137,121,120>,7,<137,138,122>,7,<137,154,155>,7,<138,139,123>,7,<138,155,156>,7,<139,140,124>,7,<139,156,157>,7,<140,157,158>,7,<142,141,158>,7,<143,142,159>,7,<144,143,160>,7,<146,161,80>,7,<147,146,65>,7,<148,147,66>,7,<149,148,67>,7,<150,149,68>,7,<150,151,134>,7,<151,150,69>,7,<151,152,135>,7,<152,151,70>,7,<152,153,136>,7,<153,152,71>,7,<154,137,136>,7,<154,153,72>,7,<155,138,137>,7,<155,154,73>,7,<156,139,138>,7,<156,155,74>,7,<157,140,139>,7,<157,156,75>,7,<158,141,140>,7,<158,157,76>,7,<158,159,142>,7,<159,158,77>,7,<159,160,143>,7,<160,159,78>,7,<160,161,144>,7,<161,146,129>,7,<161,160,79>,7}
normal_indices {320,<0,16,15>,<0,64,1>,<1,17,16>,<1,64,2>,<2,18,17>,<2,64,3>,<3,18,2>,<3,19,18>,<3,64,4>,<4,5,21>,<4,19,3>,<4,20,19>,<4,21,20>,<4,64,5>,<5,6,22>,<5,22,21>,<5,64,6>,<6,7,23>,<6,64,7>,<7,8,24>,<7,24,23>,<7,64,8>,<8,64,9>,<9,24,8>,<9,25,24>,<9,64,10>,<10,25,9>,<10,26,25>,<10,64,11>,<11,26,10>,<11,27,26>,<11,64,12>,<12,27,11>,<12,28,27>,<12,64,13>,<13,14,30>,<13,29,12>,<13,30,29>,<13,64,14>,<14,64,15>,<15,31,14>,<15,64,0>,<16,0,1>,<16,31,15>,<16,32,31>,<17,1,2>,<17,32,16>,<17,33,32>,<18,34,33>,<19,34,18>,<19,35,34>,<20,21,37>,<20,35,19>,<20,36,35>,<20,37,36>,<21,22,38>,<21,38,37>,<22,23,39>,<23,22,6>,<23,24,40>,<23,40,39>,<25,40,24>,<25,41,40>,<26,41,25>,<26,42,41>,<27,42,26>,<27,43,42>,<28,43,27>,<28,44,43>,<29,28,12>,<29,30,46>,<29,45,28>,<29,46,45>,<31,30,14>,<31,47,30>,<32,47,31>,<33,17,18>,<33,48,32>,<33,49,48>,<34,49,33>,<34,50,49>,<35,50,34>,<35,51,50>,<36,37,53>,<36,51,35>,<36,52,51>,<36,53,52>,<37,38,54>,<38,39,55>,<39,38,22>,<39,40,56>,<41,56,40>,<41,57,56>,<42,58,57>,<43,59,58>,<44,45,61>,<44,59,43>,<44,60,59>,<44,61,60>,<45,44,28>,<45,46,62>,<45,62,61>,<46,47,63>,<46,63,62>,<47,32,48>,<47,46,30>,<47,48,63>,<48,65,80>,<49,66,65>,<50,67,49>,<51,68,50>,<52,69,51>,<53,69,52>,<53,70,69>,<54,53,37>,<54,70,53>,<54,71,70>,<55,54,38>,<55,71,54>,<55,72,71>,<56,55,39>,<56,57,74>,<56,72,55>,<56,73,72>,<57,41,42>,<57,58,75>,<58,42,43>,<58,59,76>,<59,60,77>,<61,78,77>,<62,79,78>,<63,80,79>,<65,48,49>,<65,66,147>,<65,146,80>,<66,67,148>,<67,66,49>,<67,68,149>,<68,67,50>,<68,69,150>,<69,68,51>,<69,70,151>,<70,71,152>,<71,72,153>,<72,73,154>,<74,73,56>,<74,155,73>,<75,74,57>,<75,156,74>,<76,75,58>,<76,157,75>,<77,60,61>,<77,76,59>,<77,158,76>,<78,61,62>,<78,159,77>,<79,62,63>,<79,160,78>,<80,63,48>,<80,161,79>,<81,145,96>,<82,81,97>,<82,97,98>,<82,145,81>,<83,82,98>,<83,145,82>,<84,83,99>,<84,99,100>,<84,100,85>,<84,145,83>,<85,101,102>,<85,102,86>,<85,145,84>,<86,102,103>,<86,103,87>,<86,145,85>,<87,103,104>,<87,145,86>,<88,104,105>,<88,145,87>,<89,105,90>,<89,145,88>,<90,106,91>,<90,145,89>,<91,145,90>,<92,91,107>,<92,107,108>,<92,145,91>,<93,92,108>,<93,108,109>,<93,109,110>,<93,110,94>,<93,145,92>,<94,110,111>,<94,111,95>,<94,145,93>,<95,111,112>,<95,112,96>,<95,145,94>,<96,97,81>,<96,112,97>,<96,145,95>,<98,97,113>,<98,99,83>,<98,113,114>,<99,98,114>,<100,99,115>,<100,101,85>,<100,115,116>,<100,116,101>,<101,117,118>,<101,118,102>,<102,118,119>,<102,119,103>,<103,119,120>,<104,88,87>,<104,120,121>,<104,121,105>,<105,89,88>,<105,106,90>,<105,121,106>,<106,107,91>,<106,122,107>,<108,107,123>,<108,123,124>,<109,108,124>,<109,124,125>,<109,125,126>,<109,126,110>,<110,126,127>,<110,127,111>,<111,127,128>,<111,128,112>,<112,113,97>,<112,128,113>,<114,113,129>,<114,115,99>,<114,129,130>,<115,114,130>,<115,130,131>,<116,115,131>,<116,117,101>,<116,131,132>,<117,116,132>,<117,132,133>,<117,133,134>,<117,134,118>,<118,134,135>,<119,135,136>,<120,104,103>,<120,136,137>,<121,122,106>,<121,137,122>,<122,123,107>,<123,122,138>,<124,123,139>,<125,124,140>,<125,140,141>,<125,141,142>,<125,142,126>,<126,142,143>,<126,143,127>,<127,143,144>,<127,144,128>,<128,129,113>,<128,144,129>,<129,144,161>,<129,146,147>,<129,147,130>,<130,147,148>,<130,148,131>,<131,148,149>,<131,149,132>,<132,149,150>,<132,150,133>,<133,150,134>,<134,151,135>,<135,119,118>,<135,152,136>,<136,120,119>,<136,153,154>,<137,121,120>,<137,138,122>,<137,154,155>,<138,139,123>,<138,155,156>,<139,140,124>,<139,156,157>,<140,157,158>,<142,141,158>,<143,142,159>,<144,143,160>,<146,161,80>,<147,146,65>,<148,147,66>,<149,148,67>,<150,149,68>,<150,151,134>,<151,150,69>,<151,152,135>,<152,151,70>,<152,153,136>,<153,152,71>,<154,137,136>,<154,153,72>,<155,138,137>,<155,154,73>,<156,139,138>,<156,155,74>,<157,140,139>,<157,156,75>,<158,141,140>,<158,157,76>,<158,159,142>,<159,158,77>,<159,160,143>,<160,159,78>,<160,161,144>,<161,146,129>,<161,160,79>}
}

#declare supporto_lente2 = mesh2 {
vertex_vectors {128,<1.34584,0.474048,-5.80165e-2>,<1.35263,0.467438,-2.63189e-2>,<1.35839,0.448615,5.53132e-4>,<1.36224,0.420445,1.85084e-2>,<1.36359,0.387215,2.48135e-2>,<1.36224,0.353986,1.85084e-2>,<1.35839,0.325815,5.53132e-4>,<1.35263,0.306992,-2.63189e-2>,<1.34584,0.300383,-5.80165e-2>,<1.33905,0.306992,-8.97142e-2>,<1.33329,0.325815,-0.116586>,<1.32944,0.353986,-0.134541>,<1.32809,0.387215,-0.140847>,<1.32944,0.420445,-0.134541>,<1.33329,0.448615,-0.116586>,<1.33905,0.467438,-8.97142e-2>,<1.28602,0.427327,-4.78064e-2>,<1.28314,0.417915,-6.12424e-2>,<1.28122,0.403830,-7.02200e-2>,<1.28054,0.387215,-7.33725e-2>,<1.28122,0.370601,-7.02200e-2>,<1.28314,0.356515,-6.12424e-2>,<1.28602,0.347104,-4.78064e-2>,<1.28942,0.343799,-3.19575e-2>,<1.29281,0.347104,-1.61087e-2>,<1.29569,0.356515,-2.67270e-3>,<1.29762,0.370601,6.30494e-3>,<1.29829,0.387215,9.45747e-3>,<1.29762,0.403830,6.30494e-3>,<1.29569,0.417915,-2.67270e-3>,<1.29281,0.427327,-1.61087e-2>,<1.28942,0.430631,-3.19575e-2>,<1.34584,0.452687,-5.80165e-2>,<1.35096,0.447703,-3.41165e-2>,<1.35530,0.433511,-1.38550e-2>,<1.35821,0.412270,-3.16717e-4>,<1.35922,0.387215,4.43730e-3>,<1.35821,0.362160,-3.16717e-4>,<1.35530,0.340920,-1.38550e-2>,<1.35096,0.326727,-3.41165e-2>,<1.34584,0.321744,-5.80165e-2>,<1.34072,0.326727,-8.19166e-2>,<1.33638,0.340920,-0.102178>,<1.33347,0.362160,-0.115716>,<1.33246,0.387215,-0.120470>,<1.33347,0.412270,-0.115716>,<1.33638,0.433511,-0.102178>,<1.34072,0.447703,-8.19166e-2>,<1.29114,0.407592,-2.39063e-2>,<1.28942,0.409271,-3.19575e-2>,<1.28769,0.407592,-4.00087e-2>,<1.28623,0.402811,-4.68342e-2>,<1.28525,0.395655,-5.13949e-2>,<1.28491,0.387215,-5.29964e-2>,<1.28525,0.378775,-5.13949e-2>,<1.28623,0.371620,-4.68342e-2>,<1.28769,0.366839,-4.00087e-2>,<1.28942,0.365160,-3.19575e-2>,<1.29114,0.366839,-2.39063e-2>,<1.29260,0.371620,-1.70808e-2>,<1.29358,0.378775,-1.25202e-2>,<1.29392,0.387215,-1.09187e-2>,<1.29358,0.395655,-1.25202e-2>,<1.29260,0.402811,-1.70808e-2>,<1.34584,0.474048,-5.80165e-2>,<1.35263,0.467438,-2.63189e-2>,<1.35839,0.448615,5.53132e-4>,<1.36224,0.420445,1.85084e-2>,<1.36359,0.387215,2.48135e-2>,<1.36224,0.353986,1.85084e-2>,<1.35839,0.325815,5.53132e-4>,<1.35263,0.306992,-2.63189e-2>,<1.34584,0.300383,-5.80165e-2>,<1.33905,0.306992,-8.97142e-2>,<1.33329,0.325815,-0.116586>,<1.32944,0.353986,-0.134541>,<1.32809,0.387215,-0.140847>,<1.32944,0.420445,-0.134541>,<1.33329,0.448615,-0.116586>,<1.33905,0.467438,-8.97142e-2>,<1.28602,0.427327,-4.78064e-2>,<1.28314,0.417915,-6.12424e-2>,<1.28122,0.403830,-7.02200e-2>,<1.28054,0.387215,-7.33725e-2>,<1.28122,0.370601,-7.02200e-2>,<1.28314,0.356515,-6.12424e-2>,<1.28602,0.347104,-4.78064e-2>,<1.28942,0.343799,-3.19575e-2>,<1.29281,0.347104,-1.61087e-2>,<1.29569,0.356515,-2.67270e-3>,<1.29762,0.370601,6.30494e-3>,<1.29829,0.387215,9.45747e-3>,<1.29762,0.403830,6.30494e-3>,<1.29569,0.417915,-2.67270e-3>,<1.29281,0.427327,-1.61087e-2>,<1.28942,0.430631,-3.19575e-2>,<1.34584,0.452687,-5.80165e-2>,<1.35096,0.447703,-3.41165e-2>,<1.35530,0.433511,-1.38550e-2>,<1.35821,0.412270,-3.16717e-4>,<1.35922,0.387215,4.43730e-3>,<1.35821,0.362160,-3.16717e-4>,<1.35530,0.340920,-1.38550e-2>,<1.35096,0.326727,-3.41165e-2>,<1.34584,0.321744,-5.80165e-2>,<1.34072,0.326727,-8.19166e-2>,<1.33638,0.340920,-0.102178>,<1.33347,0.362160,-0.115716>,<1.33246,0.387215,-0.120470>,<1.33347,0.412270,-0.115716>,<1.33638,0.433511,-0.102178>,<1.34072,0.447703,-8.19166e-2>,<1.29114,0.407592,-2.39063e-2>,<1.28942,0.409271,-3.19575e-2>,<1.28769,0.407592,-4.00087e-2>,<1.28623,0.402811,-4.68342e-2>,<1.28525,0.395655,-5.13949e-2>,<1.28491,0.387215,-5.29964e-2>,<1.28525,0.378775,-5.13949e-2>,<1.28623,0.371620,-4.68342e-2>,<1.28769,0.366839,-4.00087e-2>,<1.28942,0.365160,-3.19575e-2>,<1.29114,0.366839,-2.39063e-2>,<1.29260,0.371620,-1.70808e-2>,<1.29358,0.378775,-1.25202e-2>,<1.29392,0.387215,-1.09187e-2>,<1.29358,0.395655,-1.25202e-2>,<1.29260,0.402811,-1.70808e-2>}
normal_vectors {128,<9.00565e-2,0.992357,-8.43612e-2>,<0.540678,0.822042,0.178647>,<0.625475,0.636107,0.451828>,<0.683398,0.366080,0.631627>,<0.535175,-4.03334e-15,0.844741>,<0.828257,-0.304752,0.470231>,<0.625475,-0.636107,0.451828>,<0.540678,-0.822042,0.178647>,<9.00565e-2,-0.992357,-8.43612e-2>,<0.346338,-0.802533,-0.485789>,<0.269762,-0.590729,-0.760439>,<0.222930,-0.287167,-0.931578>,<0.757037,-1.22364e-15,-0.653372>,<0.222930,0.287167,-0.931578>,<0.269762,0.590729,-0.760439>,<0.346338,0.802533,-0.485789>,<-0.910090,0.411271,5.09150e-2>,<-0.947222,0.310407,-8.01066e-2>,<-0.970596,0.176151,-0.164054>,<-0.965963,2.75127e-16,-0.258682>,<-0.982748,-0.150565,-0.107408>,<-0.947222,-0.310407,-8.01066e-2>,<-0.910090,-0.411271,5.09150e-2>,<-0.808844,-0.547872,0.213557>,<-0.807813,-0.433594,0.399292>,<-0.758854,-0.331360,0.560662>,<-0.783925,-0.140731,0.604696>,<-0.799091,4.96793e-15,0.601211>,<-0.725853,0.165062,0.667752>,<-0.758854,0.331360,0.560662>,<-0.807813,0.433594,0.399292>,<-0.808844,0.547872,0.213557>,<0.977797,0.00000e+0,-0.209552>,<0.977797,-4.50086e-15,-0.209552>,<0.977797,1.77199e-14,-0.209552>,<0.977797,5.89016e-29,-0.209552>,<0.977797,-1.08977e-15,-0.209552>,<0.977797,-6.64497e-15,-0.209552>,<0.977797,-1.77199e-14,-0.209552>,<0.977797,-2.17955e-15,-0.209552>,<0.977797,0.00000e+0,-0.209552>,<0.977797,0.00000e+0,-0.209552>,<0.977797,0.00000e+0,-0.209552>,<0.977797,-1.67010e-15,-0.209552>,<0.977797,0.00000e+0,-0.209552>,<0.977797,0.00000e+0,-0.209552>,<0.977797,0.00000e+0,-0.209552>,<0.977797,0.00000e+0,-0.209552>,<-0.977797,0.00000e+0,0.209552>,<-0.977797,0.00000e+0,0.209552>,<-0.977797,0.00000e+0,0.209552>,<-0.977797,0.00000e+0,0.209552>,<-0.977797,6.47000e-15,0.209552>,<-0.977797,1.31504e-14,0.209552>,<-0.977797,-1.97256e-14,0.209552>,<-0.977797,-6.47000e-15,0.209552>,<-0.977797,0.00000e+0,0.209552>,<-0.977797,0.00000e+0,0.209552>,<-0.977797,0.00000e+0,0.209552>,<-0.977797,-6.68041e-15,0.209552>,<-0.977797,-1.97256e-14,0.209552>,<-0.977797,-1.31504e-14,0.209552>,<-0.977797,6.68041e-15,0.209552>,<-0.977797,6.68041e-15,0.209552>,<-9.00565e-2,-0.992357,8.43612e-2>,<-0.540678,-0.822042,-0.178647>,<-0.625475,-0.636107,-0.451828>,<-0.683398,-0.366080,-0.631627>,<-0.708548,-1.80054e-15,-0.705662>,<-0.683398,0.366080,-0.631627>,<-0.625475,0.636107,-0.451828>,<-0.540678,0.822042,-0.178647>,<-9.00565e-2,0.992357,8.43612e-2>,<-0.346338,0.802533,0.485789>,<-0.269762,0.590729,0.760439>,<-0.510642,0.233325,0.827529>,<-0.596511,5.57842e-15,0.802605>,<-0.222930,-0.287167,0.931578>,<-0.269762,-0.590729,0.760439>,<-0.346338,-0.802533,0.485789>,<0.910090,-0.411271,-5.09150e-2>,<0.947222,-0.310407,8.01066e-2>,<0.970596,-0.176151,0.164054>,<0.965963,2.85389e-16,0.258682>,<0.982748,0.150565,0.107408>,<0.947222,0.310407,8.01066e-2>,<0.910090,0.411271,-5.09150e-2>,<0.808844,0.547872,-0.213557>,<0.807813,0.433594,-0.399292>,<0.758854,0.331360,-0.560662>,<0.783925,0.140731,-0.604696>,<0.799091,-4.96793e-15,-0.601211>,<0.725853,-0.165062,-0.667752>,<0.758854,-0.331360,-0.560662>,<0.807813,-0.433594,-0.399292>,<0.808844,-0.547872,-0.213557>,<-0.977797,0.00000e+0,0.209552>,<-0.977797,4.50086e-15,0.209552>,<-0.977797,-1.77199e-14,0.209552>,<-0.977797,-5.89016e-29,0.209552>,<-0.977797,-4.73317e-30,0.209552>,<-0.977797,-1.67010e-15,0.209552>,<-0.977797,1.77199e-14,0.209552>,<-0.977797,2.17955e-15,0.209552>,<-0.977797,0.00000e+0,0.209552>,<-0.977797,0.00000e+0,0.209552>,<-0.977797,0.00000e+0,0.209552>,<-0.977797,-6.64497e-15,0.209552>,<-0.977797,-1.08977e-15,0.209552>,<-0.977797,0.00000e+0,0.209552>,<-0.977797,0.00000e+0,0.209552>,<-0.977797,0.00000e+0,0.209552>,<0.977797,0.00000e+0,-0.209552>,<0.977797,0.00000e+0,-0.209552>,<0.977797,0.00000e+0,-0.209552>,<0.977797,0.00000e+0,-0.209552>,<0.977797,-6.47000e-15,-0.209552>,<0.977797,-1.31504e-14,-0.209552>,<0.977797,1.97256e-14,-0.209552>,<0.977797,6.47000e-15,-0.209552>,<0.977797,0.00000e+0,-0.209552>,<0.977797,0.00000e+0,-0.209552>,<0.977797,0.00000e+0,-0.209552>,<0.977797,6.68041e-15,-0.209552>,<0.977797,1.97256e-14,-0.209552>,<0.977797,1.31504e-14,-0.209552>,<0.977797,-6.68041e-15,-0.209552>,<0.977797,-6.68041e-15,-0.209552>}
texture_list { 11,
	texture { vetro_WingsMat }
	texture { pneumatici_WingsMat }
	texture { occhiali_WingsMat }
	texture { occhi_WingsMat }
	texture { nari_WingsMat }
	texture { mozzi_WingsMat }
	texture { denti_WingsMat }
	texture { casco_WingsMat }
	texture { Verdolino_WingsMat }
	texture { Giallino_WingsMat }
	texture { Corpo_WingsMat }
}
face_indices {256,<0,15,16>,2,<1,0,31>,2,<1,33,32>,2,<2,1,30>,2,<2,30,29>,2,<2,34,33>,2,<3,2,29>,2,<3,29,28>,2,<3,35,34>,2,<4,3,28>,2,<4,26,5>,2,<4,27,26>,2,<4,36,35>,2,<5,25,6>,2,<5,26,25>,2,<5,37,36>,2,<6,24,7>,2,<6,25,24>,2,<6,38,5>,2,<7,24,23>,2,<7,39,6>,2,<8,23,22>,2,<8,40,7>,2,<9,22,21>,2,<9,40,8>,2,<9,41,40>,2,<10,20,11>,2,<10,21,20>,2,<10,41,9>,2,<10,42,41>,2,<11,20,19>,2,<11,42,10>,2,<11,43,42>,2,<12,13,45>,2,<12,43,11>,2,<12,44,43>,2,<13,12,19>,2,<13,14,46>,2,<13,19,18>,2,<14,13,18>,2,<14,15,47>,2,<14,18,17>,2,<15,0,32>,2,<15,14,17>,2,<16,31,0>,2,<16,50,49>,2,<17,16,15>,2,<17,51,50>,2,<18,52,51>,2,<19,12,11>,2,<19,53,52>,2,<20,54,53>,2,<21,10,9>,2,<21,55,20>,2,<22,9,8>,2,<22,56,21>,2,<23,8,7>,2,<23,57,22>,2,<24,57,23>,2,<24,58,57>,2,<25,58,24>,2,<25,59,58>,2,<26,27,61>,2,<26,59,25>,2,<26,60,59>,2,<27,28,62>,2,<28,27,4>,2,<28,29,63>,2,<29,30,48>,2,<30,31,49>,2,<31,30,1>,2,<32,0,1>,2,<32,47,15>,2,<33,1,2>,2,<33,97,32>,2,<34,2,3>,2,<34,98,33>,2,<35,3,4>,2,<35,99,34>,2,<36,4,5>,2,<36,100,35>,2,<37,101,36>,2,<38,37,5>,2,<38,102,37>,2,<39,38,6>,2,<39,103,38>,2,<40,39,7>,2,<40,41,105>,2,<40,104,39>,2,<41,42,106>,2,<42,43,107>,2,<43,44,108>,2,<44,45,109>,2,<45,44,12>,2,<45,46,110>,2,<46,45,13>,2,<46,47,111>,2,<47,32,96>,2,<47,46,14>,2,<48,49,113>,2,<48,63,29>,2,<49,31,16>,2,<49,48,30>,2,<50,16,17>,2,<50,114,49>,2,<51,17,18>,2,<51,115,50>,2,<52,18,19>,2,<52,116,51>,2,<53,19,20>,2,<53,117,52>,2,<54,118,53>,2,<55,54,20>,2,<55,119,54>,2,<56,55,21>,2,<56,120,55>,2,<57,56,22>,2,<57,58,122>,2,<57,121,56>,2,<58,59,123>,2,<59,60,124>,2,<60,61,125>,2,<61,60,26>,2,<61,62,126>,2,<62,61,27>,2,<62,63,127>,2,<63,48,112>,2,<63,62,28>,2,<64,95,80>,2,<65,64,96>,2,<65,94,95>,2,<66,65,97>,2,<66,93,94>,2,<66,94,65>,2,<67,66,98>,2,<67,92,93>,2,<67,93,66>,2,<68,67,99>,2,<68,69,90>,2,<68,90,91>,2,<68,91,92>,2,<68,100,101>,2,<68,101,69>,2,<69,70,89>,2,<69,89,90>,2,<69,101,102>,2,<69,102,70>,2,<70,71,88>,2,<70,88,89>,2,<70,102,103>,2,<70,103,71>,2,<71,72,87>,2,<71,103,104>,2,<71,104,72>,2,<72,73,86>,2,<72,104,73>,2,<73,74,85>,2,<73,105,74>,2,<74,75,84>,2,<74,84,85>,2,<74,106,75>,2,<75,76,83>,2,<75,107,108>,2,<76,108,109>,2,<77,82,83>,2,<77,83,76>,2,<77,109,110>,2,<78,81,82>,2,<78,82,77>,2,<78,110,111>,2,<79,80,81>,2,<79,111,96>,2,<80,79,64>,2,<80,95,113>,2,<81,78,79>,2,<81,80,114>,2,<82,81,115>,2,<83,82,116>,2,<83,84,75>,2,<84,83,117>,2,<84,118,119>,2,<84,119,85>,2,<85,86,73>,2,<85,119,120>,2,<85,120,86>,2,<86,87,72>,2,<86,120,121>,2,<86,121,87>,2,<87,88,71>,2,<87,121,88>,2,<88,122,89>,2,<89,123,90>,2,<90,124,125>,2,<91,125,126>,2,<92,67,68>,2,<92,126,127>,2,<93,127,112>,2,<94,112,113>,2,<95,64,65>,2,<96,64,79>,2,<96,97,65>,2,<96,111,47>,2,<97,96,32>,2,<97,98,66>,2,<98,97,33>,2,<98,99,67>,2,<99,98,34>,2,<99,100,68>,2,<100,99,35>,2,<101,100,36>,2,<102,101,37>,2,<103,102,38>,2,<104,103,39>,2,<104,105,73>,2,<105,104,40>,2,<105,106,74>,2,<106,105,41>,2,<106,107,75>,2,<107,106,42>,2,<108,76,75>,2,<108,107,43>,2,<109,77,76>,2,<109,108,44>,2,<110,78,77>,2,<110,109,45>,2,<111,79,78>,2,<111,110,46>,2,<112,94,93>,2,<112,127,63>,2,<113,95,94>,2,<113,112,48>,2,<113,114,80>,2,<114,113,49>,2,<114,115,81>,2,<115,114,50>,2,<115,116,82>,2,<116,115,51>,2,<116,117,83>,2,<117,116,52>,2,<117,118,84>,2,<118,117,53>,2,<119,118,54>,2,<120,119,55>,2,<121,120,56>,2,<121,122,88>,2,<122,121,57>,2,<122,123,89>,2,<123,122,58>,2,<123,124,90>,2,<124,123,59>,2,<125,91,90>,2,<125,124,60>,2,<126,92,91>,2,<126,125,61>,2,<127,93,92>,2,<127,126,62>,2}
normal_indices {256,<0,15,16>,<1,0,31>,<1,33,32>,<2,1,30>,<2,30,29>,<2,34,33>,<3,2,29>,<3,29,28>,<3,35,34>,<4,3,28>,<4,26,5>,<4,27,26>,<4,36,35>,<5,25,6>,<5,26,25>,<5,37,36>,<6,24,7>,<6,25,24>,<6,38,5>,<7,24,23>,<7,39,6>,<8,23,22>,<8,40,7>,<9,22,21>,<9,40,8>,<9,41,40>,<10,20,11>,<10,21,20>,<10,41,9>,<10,42,41>,<11,20,19>,<11,42,10>,<11,43,42>,<12,13,45>,<12,43,11>,<12,44,43>,<13,12,19>,<13,14,46>,<13,19,18>,<14,13,18>,<14,15,47>,<14,18,17>,<15,0,32>,<15,14,17>,<16,31,0>,<16,50,49>,<17,16,15>,<17,51,50>,<18,52,51>,<19,12,11>,<19,53,52>,<20,54,53>,<21,10,9>,<21,55,20>,<22,9,8>,<22,56,21>,<23,8,7>,<23,57,22>,<24,57,23>,<24,58,57>,<25,58,24>,<25,59,58>,<26,27,61>,<26,59,25>,<26,60,59>,<27,28,62>,<28,27,4>,<28,29,63>,<29,30,48>,<30,31,49>,<31,30,1>,<32,0,1>,<32,47,15>,<33,1,2>,<33,97,32>,<34,2,3>,<34,98,33>,<35,3,4>,<35,99,34>,<36,4,5>,<36,100,35>,<37,101,36>,<38,37,5>,<38,102,37>,<39,38,6>,<39,103,38>,<40,39,7>,<40,41,105>,<40,104,39>,<41,42,106>,<42,43,107>,<43,44,108>,<44,45,109>,<45,44,12>,<45,46,110>,<46,45,13>,<46,47,111>,<47,32,96>,<47,46,14>,<48,49,113>,<48,63,29>,<49,31,16>,<49,48,30>,<50,16,17>,<50,114,49>,<51,17,18>,<51,115,50>,<52,18,19>,<52,116,51>,<53,19,20>,<53,117,52>,<54,118,53>,<55,54,20>,<55,119,54>,<56,55,21>,<56,120,55>,<57,56,22>,<57,58,122>,<57,121,56>,<58,59,123>,<59,60,124>,<60,61,125>,<61,60,26>,<61,62,126>,<62,61,27>,<62,63,127>,<63,48,112>,<63,62,28>,<64,95,80>,<65,64,96>,<65,94,95>,<66,65,97>,<66,93,94>,<66,94,65>,<67,66,98>,<67,92,93>,<67,93,66>,<68,67,99>,<68,69,90>,<68,90,91>,<68,91,92>,<68,100,101>,<68,101,69>,<69,70,89>,<69,89,90>,<69,101,102>,<69,102,70>,<70,71,88>,<70,88,89>,<70,102,103>,<70,103,71>,<71,72,87>,<71,103,104>,<71,104,72>,<72,73,86>,<72,104,73>,<73,74,85>,<73,105,74>,<74,75,84>,<74,84,85>,<74,106,75>,<75,76,83>,<75,107,108>,<76,108,109>,<77,82,83>,<77,83,76>,<77,109,110>,<78,81,82>,<78,82,77>,<78,110,111>,<79,80,81>,<79,111,96>,<80,79,64>,<80,95,113>,<81,78,79>,<81,80,114>,<82,81,115>,<83,82,116>,<83,84,75>,<84,83,117>,<84,118,119>,<84,119,85>,<85,86,73>,<85,119,120>,<85,120,86>,<86,87,72>,<86,120,121>,<86,121,87>,<87,88,71>,<87,121,88>,<88,122,89>,<89,123,90>,<90,124,125>,<91,125,126>,<92,67,68>,<92,126,127>,<93,127,112>,<94,112,113>,<95,64,65>,<96,64,79>,<96,97,65>,<96,111,47>,<97,96,32>,<97,98,66>,<98,97,33>,<98,99,67>,<99,98,34>,<99,100,68>,<100,99,35>,<101,100,36>,<102,101,37>,<103,102,38>,<104,103,39>,<104,105,73>,<105,104,40>,<105,106,74>,<106,105,41>,<106,107,75>,<107,106,42>,<108,76,75>,<108,107,43>,<109,77,76>,<109,108,44>,<110,78,77>,<110,109,45>,<111,79,78>,<111,110,46>,<112,94,93>,<112,127,63>,<113,95,94>,<113,112,48>,<113,114,80>,<114,113,49>,<114,115,81>,<115,114,50>,<115,116,82>,<116,115,51>,<116,117,83>,<117,116,52>,<117,118,84>,<118,117,53>,<119,118,54>,<120,119,55>,<121,120,56>,<121,122,88>,<122,121,57>,<122,123,89>,<123,122,58>,<123,124,90>,<124,123,59>,<125,91,90>,<125,124,60>,<126,92,91>,<126,125,61>,<127,93,92>,<127,126,62>}
}

#declare supporto_lente1 = mesh2 {
vertex_vectors {128,<1.29647,0.474048,0.152427>,<1.27979,0.467438,0.178165>,<1.26565,0.448615,0.199984>,<1.25620,0.420445,0.214564>,<1.25288,0.387215,0.219683>,<1.25620,0.353986,0.214564>,<1.26565,0.325815,0.199984>,<1.27979,0.306992,0.178165>,<1.29647,0.300383,0.152427>,<1.31314,0.306992,0.126689>,<1.32728,0.325815,0.104870>,<1.33673,0.353986,9.02906e-2>,<1.34005,0.387215,8.51710e-2>,<1.33673,0.420445,9.02906e-2>,<1.32728,0.448615,0.104870>,<1.31314,0.467438,0.126689>,<1.26329,0.427327,8.57811e-2>,<1.27036,0.417915,7.48714e-2>,<1.27508,0.403830,6.75818e-2>,<1.27674,0.387215,6.50220e-2>,<1.27508,0.370601,6.75818e-2>,<1.27036,0.356515,7.48714e-2>,<1.26329,0.347104,8.57811e-2>,<1.25495,0.343799,9.86500e-2>,<1.24661,0.347104,0.111519>,<1.23954,0.356515,0.122429>,<1.23481,0.370601,0.129718>,<1.23316,0.387215,0.132278>,<1.23481,0.403830,0.129718>,<1.23954,0.417915,0.122429>,<1.24661,0.427327,0.111519>,<1.25495,0.430631,9.86500e-2>,<1.29647,0.452687,0.152427>,<1.28389,0.447703,0.171833>,<1.27323,0.433511,0.188285>,<1.26611,0.412270,0.199278>,<1.26361,0.387215,0.203138>,<1.26611,0.362160,0.199278>,<1.27323,0.340920,0.188285>,<1.28389,0.326727,0.171833>,<1.29647,0.321744,0.152427>,<1.30904,0.326727,0.133021>,<1.31970,0.340920,0.116569>,<1.32683,0.362160,0.105576>,<1.32933,0.387215,0.101716>,<1.32683,0.412270,0.105576>,<1.31970,0.433511,0.116569>,<1.30904,0.447703,0.133021>,<1.25071,0.407592,0.105187>,<1.25495,0.409271,9.86500e-2>,<1.25918,0.407592,9.21126e-2>,<1.26277,0.402811,8.65705e-2>,<1.26517,0.395655,8.28674e-2>,<1.26602,0.387215,8.15670e-2>,<1.26517,0.378775,8.28674e-2>,<1.26277,0.371620,8.65705e-2>,<1.25918,0.366839,9.21126e-2>,<1.25495,0.365160,9.86500e-2>,<1.25071,0.366839,0.105187>,<1.24712,0.371620,0.110730>,<1.24472,0.378775,0.114433>,<1.24388,0.387215,0.115733>,<1.24472,0.395655,0.114433>,<1.24712,0.402811,0.110730>,<1.29647,0.474048,0.152427>,<1.27979,0.467438,0.178165>,<1.26565,0.448615,0.199984>,<1.25620,0.420445,0.214564>,<1.25288,0.387215,0.219683>,<1.25620,0.353986,0.214564>,<1.26565,0.325815,0.199984>,<1.27979,0.306992,0.178165>,<1.29647,0.300383,0.152427>,<1.31314,0.306992,0.126689>,<1.32728,0.325815,0.104870>,<1.33673,0.353986,9.02906e-2>,<1.34005,0.387215,8.51710e-2>,<1.33673,0.420445,9.02906e-2>,<1.32728,0.448615,0.104870>,<1.31314,0.467438,0.126689>,<1.26329,0.427327,8.57811e-2>,<1.27036,0.417915,7.48714e-2>,<1.27508,0.403830,6.75818e-2>,<1.27674,0.387215,6.50220e-2>,<1.27508,0.370601,6.75818e-2>,<1.27036,0.356515,7.48714e-2>,<1.26329,0.347104,8.57811e-2>,<1.25495,0.343799,9.86500e-2>,<1.24661,0.347104,0.111519>,<1.23954,0.356515,0.122429>,<1.23481,0.370601,0.129718>,<1.23316,0.387215,0.132278>,<1.23481,0.403830,0.129718>,<1.23954,0.417915,0.122429>,<1.24661,0.427327,0.111519>,<1.25495,0.430631,9.86500e-2>,<1.29647,0.452687,0.152427>,<1.28389,0.447703,0.171833>,<1.27323,0.433511,0.188285>,<1.26611,0.412270,0.199278>,<1.26361,0.387215,0.203138>,<1.26611,0.362160,0.199278>,<1.27323,0.340920,0.188285>,<1.28389,0.326727,0.171833>,<1.29647,0.321744,0.152427>,<1.30904,0.326727,0.133021>,<1.31970,0.340920,0.116569>,<1.32683,0.362160,0.105576>,<1.32933,0.387215,0.101716>,<1.32683,0.412270,0.105576>,<1.31970,0.433511,0.116569>,<1.30904,0.447703,0.133021>,<1.25071,0.407592,0.105187>,<1.25495,0.409271,9.86500e-2>,<1.25918,0.407592,9.21126e-2>,<1.26277,0.402811,8.65705e-2>,<1.26517,0.395655,8.28674e-2>,<1.26602,0.387215,8.15670e-2>,<1.26517,0.378775,8.28674e-2>,<1.26277,0.371620,8.65705e-2>,<1.25918,0.366839,9.21126e-2>,<1.25495,0.365160,9.86500e-2>,<1.25071,0.366839,0.105187>,<1.24712,0.371620,0.110730>,<1.24472,0.378775,0.114433>,<1.24388,0.387215,0.115733>,<1.24472,0.395655,0.114433>,<1.24712,0.402811,0.110730>}
normal_vectors {128,<7.04524e-2,0.989950,0.122616>,<0.139152,0.796114,0.588931>,<-3.73783e-2,0.576795,0.816033>,<-0.139810,0.276139,0.950895>,<0.271469,-6.58781e-16,0.962447>,<0.177582,-0.223589,0.958370>,<-3.73783e-2,-0.576795,0.816033>,<0.139152,-0.796114,0.588931>,<7.04524e-2,-0.989950,0.122616>,<0.599146,-0.799883,3.48022e-2>,<0.784388,-0.597177,-0.167675>,<0.899298,-0.332190,-0.284452>,<0.944824,-4.10357e-15,-0.327579>,<0.899298,0.332190,-0.284452>,<0.784388,0.597177,-0.167675>,<0.599146,0.799883,3.48022e-2>,<-0.580773,0.459608,-0.671910>,<-0.451894,0.355777,-0.818055>,<-0.365441,0.177752,-0.913705>,<-0.480183,-1.26324e-14,-0.877169>,<-0.460741,-0.151254,-0.874551>,<-0.451894,-0.355777,-0.818055>,<-0.580773,-0.459608,-0.671910>,<-0.667469,-0.564847,-0.485214>,<-0.835784,-0.408203,-0.367199>,<-0.917944,-0.296726,-0.263312>,<-0.965754,-0.163845,-0.201184>,<-0.984149,9.08099e-16,-0.177344>,<-0.965754,0.163845,-0.201184>,<-0.917944,0.296726,-0.263312>,<-0.835784,0.408203,-0.367199>,<-0.667469,0.564847,-0.485214>,<0.839209,-7.02377e-15,0.543809>,<0.839209,-1.64263e-14,0.543809>,<0.839209,0.00000e+0,0.543809>,<0.839209,-3.53061e-15,0.543809>,<0.839209,3.53061e-15,0.543809>,<0.839209,0.00000e+0,0.543809>,<0.839209,0.00000e+0,0.543809>,<0.839209,1.64263e-14,0.543809>,<0.839209,-2.60324e-29,0.543809>,<0.839209,-1.64263e-14,0.543809>,<0.839209,-3.53061e-15,0.543809>,<0.839209,-2.91721e-15,0.543809>,<0.839209,9.54522e-29,0.543809>,<0.839209,4.68251e-15,0.543809>,<0.839209,0.00000e+0,0.543809>,<0.839209,0.00000e+0,0.543809>,<-0.839209,4.17002e-14,-0.543809>,<-0.839209,2.08501e-14,-0.543809>,<-0.839209,6.83883e-15,-0.543809>,<-0.839209,2.09613e-14,-0.543809>,<-0.839209,-1.39001e-14,-0.543809>,<-0.839209,-6.83883e-15,-0.543809>,<-0.839209,0.00000e+0,-0.543809>,<-0.839209,-1.74307e-14,-0.543809>,<-0.839209,-6.83883e-15,-0.543809>,<-0.839209,-2.08501e-14,-0.543809>,<-0.839209,-4.17002e-14,-0.543809>,<-0.839209,-1.03694e-14,-0.543809>,<-0.839209,-1.12521e-14,-0.543809>,<-0.839209,7.79395e-28,-0.543809>,<-0.839209,1.39001e-14,-0.543809>,<-0.839209,6.83883e-15,-0.543809>,<-7.04524e-2,-0.989950,-0.122616>,<-0.139152,-0.796114,-0.588931>,<3.73783e-2,-0.576795,-0.816033>,<0.139810,-0.276139,-0.950895>,<-0.478303,4.14387e-16,-0.878195>,<0.139810,0.276139,-0.950895>,<3.73783e-2,0.576795,-0.816033>,<-0.139152,0.796114,-0.588931>,<-7.04524e-2,0.989950,-0.122616>,<-0.599146,0.799883,-3.48022e-2>,<-0.784388,0.597177,0.167675>,<-0.954132,0.278714,0.109318>,<-0.868184,-3.75994e-16,0.496242>,<-0.899298,-0.332190,0.284452>,<-0.784388,-0.597177,0.167675>,<-0.599146,-0.799883,-3.48022e-2>,<0.580773,-0.459608,0.671910>,<0.451894,-0.355777,0.818055>,<0.365441,-0.177752,0.913705>,<0.480183,1.11333e-14,0.877169>,<0.460741,0.151254,0.874551>,<0.451894,0.355777,0.818055>,<0.580773,0.459608,0.671910>,<0.667469,0.564847,0.485214>,<0.835784,0.408203,0.367199>,<0.917944,0.296726,0.263312>,<0.956300,0.140080,0.256646>,<0.993026,-3.43188e-15,0.117900>,<0.965754,-0.163845,0.201184>,<0.917944,-0.296726,0.263312>,<0.835784,-0.408203,0.367199>,<0.667469,-0.564847,0.485214>,<-0.839209,7.02377e-15,-0.543809>,<-0.839209,1.64263e-14,-0.543809>,<-0.839209,0.00000e+0,-0.543809>,<-0.839209,3.53061e-15,-0.543809>,<-0.839209,0.00000e+0,-0.543809>,<-0.839209,-2.64796e-15,-0.543809>,<-0.839209,0.00000e+0,-0.543809>,<-0.839209,-1.64263e-14,-0.543809>,<-0.839209,2.60324e-29,-0.543809>,<-0.839209,1.64263e-14,-0.543809>,<-0.839209,3.53061e-15,-0.543809>,<-0.839209,7.02377e-15,-0.543809>,<-0.839209,-1.76531e-15,-0.543809>,<-0.839209,-4.68251e-15,-0.543809>,<-0.839209,0.00000e+0,-0.543809>,<-0.839209,0.00000e+0,-0.543809>,<0.839209,-4.17002e-14,0.543809>,<0.839209,-2.08501e-14,0.543809>,<0.839209,-6.83883e-15,0.543809>,<0.839209,-2.09613e-14,0.543809>,<0.839209,1.39001e-14,0.543809>,<0.839209,6.83883e-15,0.543809>,<0.839209,0.00000e+0,0.543809>,<0.839209,1.74307e-14,0.543809>,<0.839209,6.83883e-15,0.543809>,<0.839209,2.08501e-14,0.543809>,<0.839209,4.17002e-14,0.543809>,<0.839209,1.03694e-14,0.543809>,<0.839209,0.00000e+0,0.543809>,<0.839209,-6.83883e-15,0.543809>,<0.839209,-1.39001e-14,0.543809>,<0.839209,-6.83883e-15,0.543809>}
texture_list { 11,
	texture { vetro_WingsMat }
	texture { pneumatici_WingsMat }
	texture { occhiali_WingsMat }
	texture { occhi_WingsMat }
	texture { nari_WingsMat }
	texture { mozzi_WingsMat }
	texture { denti_WingsMat }
	texture { casco_WingsMat }
	texture { Verdolino_WingsMat }
	texture { Giallino_WingsMat }
	texture { Corpo_WingsMat }
}
face_indices {256,<0,30,1>,2,<0,31,30>,2,<1,29,2>,2,<1,30,29>,2,<1,33,32>,2,<2,28,3>,2,<2,29,28>,2,<2,34,33>,2,<3,27,4>,2,<3,28,27>,2,<3,35,34>,2,<4,36,35>,2,<5,4,27>,2,<5,26,6>,2,<5,37,36>,2,<6,25,7>,2,<6,38,5>,2,<7,24,8>,2,<7,39,6>,2,<8,40,7>,2,<9,8,23>,2,<9,23,22>,2,<9,40,8>,2,<9,41,40>,2,<10,9,22>,2,<10,22,21>,2,<10,41,9>,2,<10,42,41>,2,<11,10,21>,2,<11,21,20>,2,<11,42,10>,2,<11,43,42>,2,<12,11,20>,2,<12,13,45>,2,<12,19,18>,2,<12,20,19>,2,<12,43,11>,2,<12,44,43>,2,<13,14,46>,2,<13,17,14>,2,<13,18,17>,2,<14,15,47>,2,<14,16,15>,2,<14,17,16>,2,<15,0,32>,2,<15,16,31>,2,<15,31,0>,2,<16,50,49>,2,<17,51,50>,2,<18,13,12>,2,<18,52,51>,2,<19,53,52>,2,<20,54,53>,2,<21,55,20>,2,<22,56,21>,2,<23,57,22>,2,<24,23,8>,2,<24,57,23>,2,<24,58,57>,2,<25,24,7>,2,<25,58,24>,2,<25,59,58>,2,<26,25,6>,2,<26,59,25>,2,<26,60,59>,2,<27,26,5>,2,<27,28,62>,2,<27,60,26>,2,<27,61,60>,2,<28,29,63>,2,<29,30,48>,2,<30,31,49>,2,<32,0,1>,2,<32,47,15>,2,<33,1,2>,2,<33,97,32>,2,<34,2,3>,2,<34,98,33>,2,<35,3,4>,2,<35,99,34>,2,<36,4,5>,2,<36,100,35>,2,<37,101,36>,2,<38,37,5>,2,<38,102,37>,2,<39,38,6>,2,<39,103,38>,2,<40,39,7>,2,<40,41,105>,2,<40,104,39>,2,<41,42,106>,2,<42,43,107>,2,<43,44,108>,2,<44,45,109>,2,<45,44,12>,2,<45,46,110>,2,<46,45,13>,2,<46,47,111>,2,<47,32,96>,2,<47,46,14>,2,<48,49,113>,2,<48,63,29>,2,<49,31,16>,2,<49,48,30>,2,<50,16,17>,2,<50,114,49>,2,<51,17,18>,2,<51,115,50>,2,<52,18,19>,2,<52,116,51>,2,<53,19,20>,2,<53,117,52>,2,<54,118,53>,2,<55,54,20>,2,<55,119,54>,2,<56,55,21>,2,<56,120,55>,2,<57,56,22>,2,<57,58,122>,2,<57,121,56>,2,<58,59,123>,2,<59,60,124>,2,<60,61,125>,2,<61,62,126>,2,<62,61,27>,2,<62,63,127>,2,<63,48,112>,2,<63,62,28>,2,<65,64,96>,2,<65,94,64>,2,<66,65,97>,2,<66,93,65>,2,<67,66,98>,2,<67,68,91>,2,<67,91,92>,2,<67,92,66>,2,<68,67,99>,2,<68,100,101>,2,<68,101,69>,2,<69,90,91>,2,<69,101,102>,2,<69,102,70>,2,<70,89,90>,2,<70,90,69>,2,<70,102,103>,2,<70,103,71>,2,<71,88,89>,2,<71,89,70>,2,<71,103,104>,2,<71,104,72>,2,<72,87,88>,2,<72,88,71>,2,<72,104,73>,2,<73,86,87>,2,<73,87,72>,2,<73,105,74>,2,<74,85,86>,2,<74,86,73>,2,<74,106,75>,2,<75,84,85>,2,<75,85,74>,2,<75,107,108>,2,<76,77,82>,2,<76,83,84>,2,<76,84,75>,2,<76,108,109>,2,<77,78,81>,2,<77,81,82>,2,<77,109,110>,2,<78,79,80>,2,<78,80,81>,2,<78,110,111>,2,<79,64,95>,2,<79,95,80>,2,<79,111,96>,2,<80,95,113>,2,<81,80,114>,2,<82,81,115>,2,<82,83,76>,2,<83,82,116>,2,<84,83,117>,2,<84,118,119>,2,<84,119,85>,2,<85,119,120>,2,<85,120,86>,2,<86,120,121>,2,<86,121,87>,2,<87,121,88>,2,<88,122,89>,2,<89,123,90>,2,<90,124,125>,2,<91,68,69>,2,<91,125,126>,2,<92,93,66>,2,<92,126,127>,2,<93,94,65>,2,<93,127,112>,2,<94,95,64>,2,<94,112,113>,2,<96,64,79>,2,<96,97,65>,2,<96,111,47>,2,<97,96,32>,2,<97,98,66>,2,<98,97,33>,2,<98,99,67>,2,<99,98,34>,2,<99,100,68>,2,<100,99,35>,2,<101,100,36>,2,<102,101,37>,2,<103,102,38>,2,<104,103,39>,2,<104,105,73>,2,<105,104,40>,2,<105,106,74>,2,<106,105,41>,2,<106,107,75>,2,<107,106,42>,2,<108,76,75>,2,<108,107,43>,2,<109,77,76>,2,<109,108,44>,2,<110,78,77>,2,<110,109,45>,2,<111,79,78>,2,<111,110,46>,2,<112,94,93>,2,<112,127,63>,2,<113,95,94>,2,<113,112,48>,2,<113,114,80>,2,<114,113,49>,2,<114,115,81>,2,<115,114,50>,2,<115,116,82>,2,<116,115,51>,2,<116,117,83>,2,<117,116,52>,2,<117,118,84>,2,<118,117,53>,2,<119,118,54>,2,<120,119,55>,2,<121,120,56>,2,<121,122,88>,2,<122,121,57>,2,<122,123,89>,2,<123,122,58>,2,<123,124,90>,2,<124,123,59>,2,<125,91,90>,2,<125,124,60>,2,<126,92,91>,2,<126,125,61>,2,<127,93,92>,2,<127,126,62>,2}
normal_indices {256,<0,30,1>,<0,31,30>,<1,29,2>,<1,30,29>,<1,33,32>,<2,28,3>,<2,29,28>,<2,34,33>,<3,27,4>,<3,28,27>,<3,35,34>,<4,36,35>,<5,4,27>,<5,26,6>,<5,37,36>,<6,25,7>,<6,38,5>,<7,24,8>,<7,39,6>,<8,40,7>,<9,8,23>,<9,23,22>,<9,40,8>,<9,41,40>,<10,9,22>,<10,22,21>,<10,41,9>,<10,42,41>,<11,10,21>,<11,21,20>,<11,42,10>,<11,43,42>,<12,11,20>,<12,13,45>,<12,19,18>,<12,20,19>,<12,43,11>,<12,44,43>,<13,14,46>,<13,17,14>,<13,18,17>,<14,15,47>,<14,16,15>,<14,17,16>,<15,0,32>,<15,16,31>,<15,31,0>,<16,50,49>,<17,51,50>,<18,13,12>,<18,52,51>,<19,53,52>,<20,54,53>,<21,55,20>,<22,56,21>,<23,57,22>,<24,23,8>,<24,57,23>,<24,58,57>,<25,24,7>,<25,58,24>,<25,59,58>,<26,25,6>,<26,59,25>,<26,60,59>,<27,26,5>,<27,28,62>,<27,60,26>,<27,61,60>,<28,29,63>,<29,30,48>,<30,31,49>,<32,0,1>,<32,47,15>,<33,1,2>,<33,97,32>,<34,2,3>,<34,98,33>,<35,3,4>,<35,99,34>,<36,4,5>,<36,100,35>,<37,101,36>,<38,37,5>,<38,102,37>,<39,38,6>,<39,103,38>,<40,39,7>,<40,41,105>,<40,104,39>,<41,42,106>,<42,43,107>,<43,44,108>,<44,45,109>,<45,44,12>,<45,46,110>,<46,45,13>,<46,47,111>,<47,32,96>,<47,46,14>,<48,49,113>,<48,63,29>,<49,31,16>,<49,48,30>,<50,16,17>,<50,114,49>,<51,17,18>,<51,115,50>,<52,18,19>,<52,116,51>,<53,19,20>,<53,117,52>,<54,118,53>,<55,54,20>,<55,119,54>,<56,55,21>,<56,120,55>,<57,56,22>,<57,58,122>,<57,121,56>,<58,59,123>,<59,60,124>,<60,61,125>,<61,62,126>,<62,61,27>,<62,63,127>,<63,48,112>,<63,62,28>,<65,64,96>,<65,94,64>,<66,65,97>,<66,93,65>,<67,66,98>,<67,68,91>,<67,91,92>,<67,92,66>,<68,67,99>,<68,100,101>,<68,101,69>,<69,90,91>,<69,101,102>,<69,102,70>,<70,89,90>,<70,90,69>,<70,102,103>,<70,103,71>,<71,88,89>,<71,89,70>,<71,103,104>,<71,104,72>,<72,87,88>,<72,88,71>,<72,104,73>,<73,86,87>,<73,87,72>,<73,105,74>,<74,85,86>,<74,86,73>,<74,106,75>,<75,84,85>,<75,85,74>,<75,107,108>,<76,77,82>,<76,83,84>,<76,84,75>,<76,108,109>,<77,78,81>,<77,81,82>,<77,109,110>,<78,79,80>,<78,80,81>,<78,110,111>,<79,64,95>,<79,95,80>,<79,111,96>,<80,95,113>,<81,80,114>,<82,81,115>,<82,83,76>,<83,82,116>,<84,83,117>,<84,118,119>,<84,119,85>,<85,119,120>,<85,120,86>,<86,120,121>,<86,121,87>,<87,121,88>,<88,122,89>,<89,123,90>,<90,124,125>,<91,68,69>,<91,125,126>,<92,93,66>,<92,126,127>,<93,94,65>,<93,127,112>,<94,95,64>,<94,112,113>,<96,64,79>,<96,97,65>,<96,111,47>,<97,96,32>,<97,98,66>,<98,97,33>,<98,99,67>,<99,98,34>,<99,100,68>,<100,99,35>,<101,100,36>,<102,101,37>,<103,102,38>,<104,103,39>,<104,105,73>,<105,104,40>,<105,106,74>,<106,105,41>,<106,107,75>,<107,106,42>,<108,76,75>,<108,107,43>,<109,77,76>,<109,108,44>,<110,78,77>,<110,109,45>,<111,79,78>,<111,110,46>,<112,94,93>,<112,127,63>,<113,95,94>,<113,112,48>,<113,114,80>,<114,113,49>,<114,115,81>,<115,114,50>,<115,116,82>,<116,115,51>,<116,117,83>,<117,116,52>,<117,118,84>,<118,117,53>,<119,118,54>,<120,119,55>,<121,120,56>,<121,122,88>,<122,121,57>,<122,123,89>,<123,122,58>,<123,124,90>,<124,123,59>,<125,91,90>,<125,124,60>,<126,92,91>,<126,125,61>,<127,93,92>,<127,126,62>}
}

#declare mozzo4 = mesh2 {
vertex_vectors {114,<0.763347,0.262846,-0.689860>,<0.745823,0.262846,-0.669877>,<0.721985,0.262846,-0.658122>,<0.695464,0.262846,-0.656383>,<0.670297,0.262846,-0.664927>,<0.650314,0.262846,-0.682451>,<0.638559,0.262846,-0.706288>,<0.636820,0.262846,-0.732809>,<0.645364,0.262846,-0.757977>,<0.662888,0.262846,-0.777960>,<0.686725,0.262846,-0.789715>,<0.713246,0.262846,-0.791453>,<0.738414,0.262846,-0.782910>,<0.758397,0.262846,-0.765386>,<0.770152,0.262846,-0.741548>,<0.771890,0.262846,-0.715027>,<0.813358,0.224261,-0.660986>,<0.780977,0.224261,-0.624063>,<0.736932,0.224261,-0.602342>,<0.687927,0.224261,-0.599130>,<0.641423,0.224261,-0.614916>,<0.604500,0.224261,-0.647297>,<0.582779,0.224261,-0.691342>,<0.579567,0.224261,-0.740347>,<0.595353,0.224261,-0.786851>,<0.627734,0.224261,-0.823774>,<0.671779,0.224261,-0.845495>,<0.720784,0.224261,-0.848707>,<0.767288,0.224261,-0.832921>,<0.804211,0.224261,-0.800540>,<0.825932,0.224261,-0.756495>,<0.829144,0.224261,-0.707490>,<0.846774,0.166514,-0.641693>,<0.804467,0.166514,-0.593451>,<0.746918,0.166514,-0.565071>,<0.682890,0.166514,-0.560875>,<0.622130,0.166514,-0.581500>,<0.573888,0.166514,-0.623807>,<0.545508,0.166514,-0.681355>,<0.541312,0.166514,-0.745383>,<0.561937,0.166514,-0.806144>,<0.604244,0.166514,-0.854386>,<0.661792,0.166514,-0.882765>,<0.725820,0.166514,-0.886962>,<0.786581,0.166514,-0.866337>,<0.834823,0.166514,-0.824030>,<0.863202,0.166514,-0.766481>,<0.867399,0.166514,-0.702453>,<0.858508,9.83959e-2,-0.634918>,<0.812715,9.83959e-2,-0.582701>,<0.750425,9.83959e-2,-0.551984>,<0.681122,9.83959e-2,-0.547441>,<0.615355,9.83959e-2,-0.569766>,<0.563138,9.83959e-2,-0.615559>,<0.532421,9.83959e-2,-0.677849>,<0.527878,9.83959e-2,-0.747152>,<0.550203,9.83959e-2,-0.812918>,<0.595996,9.83959e-2,-0.865135>,<0.658286,9.83959e-2,-0.895853>,<0.727589,9.83959e-2,-0.900396>,<0.793355,9.83959e-2,-0.878071>,<0.845572,9.83959e-2,-0.832278>,<0.876290,9.83959e-2,-0.769988>,<0.880833,9.83959e-2,-0.700685>,<0.846774,3.02782e-2,-0.641693>,<0.804467,3.02782e-2,-0.593451>,<0.746918,3.02782e-2,-0.565071>,<0.682890,3.02782e-2,-0.560875>,<0.622130,3.02782e-2,-0.581500>,<0.573888,3.02782e-2,-0.623807>,<0.545508,3.02782e-2,-0.681355>,<0.541312,3.02782e-2,-0.745383>,<0.561937,3.02782e-2,-0.806144>,<0.604244,3.02782e-2,-0.854386>,<0.661792,3.02782e-2,-0.882765>,<0.725820,3.02782e-2,-0.886962>,<0.786581,3.02782e-2,-0.866337>,<0.834823,3.02782e-2,-0.824030>,<0.863202,3.02782e-2,-0.766481>,<0.867399,3.02782e-2,-0.702453>,<0.813358,-2.74691e-2,-0.660986>,<0.780977,-2.74691e-2,-0.624063>,<0.736932,-2.74691e-2,-0.602342>,<0.687927,-2.74691e-2,-0.599130>,<0.641423,-2.74691e-2,-0.614916>,<0.604500,-2.74691e-2,-0.647297>,<0.582779,-2.74691e-2,-0.691342>,<0.579567,-2.74691e-2,-0.740347>,<0.595353,-2.74691e-2,-0.786851>,<0.627734,-2.74691e-2,-0.823774>,<0.671779,-2.74691e-2,-0.845495>,<0.720784,-2.74691e-2,-0.848707>,<0.767288,-2.74691e-2,-0.832921>,<0.804211,-2.74691e-2,-0.800540>,<0.825932,-2.74691e-2,-0.756495>,<0.829144,-2.74691e-2,-0.707490>,<0.763347,-6.60547e-2,-0.689860>,<0.745823,-6.60547e-2,-0.669877>,<0.721985,-6.60547e-2,-0.658122>,<0.695464,-6.60547e-2,-0.656383>,<0.670297,-6.60547e-2,-0.664927>,<0.650314,-6.60547e-2,-0.682451>,<0.638559,-6.60547e-2,-0.706288>,<0.636820,-6.60547e-2,-0.732809>,<0.645364,-6.60547e-2,-0.757977>,<0.662888,-6.60547e-2,-0.777960>,<0.686725,-6.60547e-2,-0.789715>,<0.713246,-6.60547e-2,-0.791453>,<0.738414,-6.60547e-2,-0.782910>,<0.758397,-6.60547e-2,-0.765386>,<0.770152,-6.60547e-2,-0.741548>,<0.771890,-6.60547e-2,-0.715027>,<0.704355,0.276396,-0.723918>,<0.704355,-7.96041e-2,-0.723918>}
normal_vectors {114,<0.373698,0.907921,0.189816>,<0.269406,0.896745,0.351097>,<9.89193e-2,0.924082,0.369172>,<-3.23586e-2,0.907921,0.417891>,<-0.189816,0.907921,0.373698>,<-0.351097,0.896745,0.269406>,<-0.369172,0.924082,9.89193e-2>,<-0.417891,0.907921,-3.23586e-2>,<-0.373698,0.907921,-0.189816>,<-0.269406,0.896745,-0.351097>,<-8.66275e-2,0.907921,-0.410093>,<4.98864e-2,0.924082,-0.378925>,<0.189816,0.907921,-0.373698>,<0.351097,0.896745,-0.269406>,<0.410093,0.907921,-8.66275e-2>,<0.378925,0.924082,4.98864e-2>,<0.616470,0.707599,0.345352>,<0.457732,0.659268,0.596529>,<0.170377,0.752769,0.635855>,<-8.31508e-2,0.707599,0.701705>,<-0.377149,0.687172,0.620929>,<-0.602575,0.678577,0.420044>,<-0.635855,0.752769,0.170377>,<-0.701705,0.707599,-8.31508e-2>,<-0.616470,0.707599,-0.345352>,<-0.457732,0.659268,-0.596529>,<-0.174030,0.707599,-0.684848>,<8.59234e-2,0.752769,-0.652653>,<0.377149,0.687172,-0.620929>,<0.602575,0.678577,-0.420044>,<0.684848,0.707599,-0.174030>,<0.652653,0.752769,8.59234e-2>,<0.768795,0.419315,0.482834>,<0.576513,0.321155,0.751327>,<0.231989,0.443376,0.865794>,<-0.145840,0.356654,0.922783>,<-0.461841,0.383160,0.799932>,<-0.694223,0.382443,0.609748>,<-0.873660,0.409068,0.263404>,<-0.922783,0.356654,-0.145840>,<-0.767871,0.382443,-0.513917>,<-0.539238,0.345848,-0.767862>,<-0.234342,0.383155,-0.893463>,<0.147115,0.409068,-0.900567>,<0.503054,0.345848,-0.792039>,<0.699195,0.419315,-0.579051>,<0.895853,0.356654,-0.265040>,<0.900567,0.409068,0.147115>,<0.864128,6.61589e-2,0.498905>,<0.607428,-6.61589e-2,0.791615>,<0.231185,2.83931e-2,0.972495>,<-0.169700,-3.97197e-2,0.984695>,<-0.498905,6.61589e-2,0.864128>,<-0.793353,-2.88329e-17,0.608761>,<-0.972495,-2.83931e-2,0.231185>,<-0.984695,-3.97197e-2,-0.169700>,<-0.884518,3.97197e-2,-0.464812>,<-0.659915,1.48643e-16,-0.751340>,<-0.322157,1.00694e-16,-0.946686>,<0.102271,-2.83931e-2,-0.994351>,<0.500000,-4.80548e-16,-0.866025>,<0.791615,6.61589e-2,-0.607428>,<0.954121,-3.97197e-2,-0.296777>,<0.994351,-2.83931e-2,0.102271>,<0.796730,-0.356654,0.487872>,<0.562302,-0.383160,0.732806>,<0.263404,-0.409068,0.873660>,<-0.115717,-0.383155,0.916407>,<-0.487872,-0.356654,0.796730>,<-0.767862,-0.345848,0.539238>,<-0.865794,-0.443376,0.231989>,<-0.916407,-0.383155,-0.115717>,<-0.820149,-0.321155,-0.473513>,<-0.558417,-0.383155,-0.735773>,<-0.234342,-0.383155,-0.893463>,<0.116995,-0.443376,-0.888667>,<0.457602,-0.383155,-0.802367>,<0.751327,-0.321155,-0.576513>,<0.893463,-0.383155,-0.234342>,<0.888667,-0.443376,0.116995>,<0.616470,-0.707599,0.345352>,<0.457732,-0.659268,0.596529>,<0.170377,-0.752769,0.635855>,<-8.31508e-2,-0.707599,0.701705>,<-0.345352,-0.707599,0.616470>,<-0.596529,-0.659268,0.457732>,<-0.635855,-0.752769,0.170377>,<-0.701705,-0.707599,-8.31508e-2>,<-0.620929,-0.687172,-0.377149>,<-0.420044,-0.678577,-0.602575>,<-0.174030,-0.707599,-0.684848>,<8.59234e-2,-0.752769,-0.652653>,<0.345352,-0.707599,-0.616470>,<0.596529,-0.659268,-0.457732>,<0.684848,-0.707599,-0.174030>,<0.652653,-0.752769,8.59234e-2>,<0.373698,-0.907921,0.189816>,<0.269406,-0.896745,0.351097>,<9.89193e-2,-0.924082,0.369172>,<-3.23586e-2,-0.907921,0.417891>,<-0.189816,-0.907921,0.373698>,<-0.351097,-0.896745,0.269406>,<-0.369172,-0.924082,9.89193e-2>,<-0.417891,-0.907921,-3.23586e-2>,<-0.373698,-0.907921,-0.189816>,<-0.269406,-0.896745,-0.351097>,<-8.66275e-2,-0.907921,-0.410093>,<4.98864e-2,-0.924082,-0.378925>,<0.189816,-0.907921,-0.373698>,<0.351097,-0.896745,-0.269406>,<0.410093,-0.907921,-8.66275e-2>,<0.378925,-0.924082,4.98864e-2>,<-2.08865e-16,1.00000,-4.69061e-16>,<-2.15945e-16,-1.00000,-2.95597e-16>}
texture_list { 11,
	texture { vetro_WingsMat }
	texture { pneumatici_WingsMat }
	texture { occhiali_WingsMat }
	texture { occhi_WingsMat }
	texture { nari_WingsMat }
	texture { mozzi_WingsMat }
	texture { denti_WingsMat }
	texture { casco_WingsMat }
	texture { Verdolino_WingsMat }
	texture { Giallino_WingsMat }
	texture { Corpo_WingsMat }
}
face_indices {224,<0,16,31>,5,<0,112,1>,5,<1,2,18>,5,<1,17,16>,5,<1,112,2>,5,<2,112,3>,5,<3,18,2>,5,<3,19,18>,5,<3,112,4>,5,<4,19,3>,5,<4,20,19>,5,<4,112,5>,5,<5,6,22>,5,<5,20,4>,5,<5,21,20>,5,<5,112,6>,5,<6,112,7>,5,<7,22,6>,5,<7,23,22>,5,<7,112,8>,5,<8,23,7>,5,<8,24,23>,5,<8,112,9>,5,<9,24,8>,5,<9,25,24>,5,<9,112,10>,5,<10,26,9>,5,<10,112,11>,5,<11,27,10>,5,<11,112,12>,5,<12,28,27>,5,<12,112,13>,5,<13,29,28>,5,<13,112,14>,5,<14,30,13>,5,<14,112,15>,5,<15,31,14>,5,<15,112,0>,5,<16,0,1>,5,<16,32,47>,5,<17,18,34>,5,<17,33,32>,5,<18,17,1>,5,<19,34,18>,5,<19,35,34>,5,<20,21,37>,5,<20,35,19>,5,<20,36,35>,5,<21,22,38>,5,<22,21,5>,5,<23,38,22>,5,<23,39,38>,5,<24,39,23>,5,<24,40,39>,5,<25,41,40>,5,<26,25,9>,5,<26,42,25>,5,<27,11,12>,5,<27,26,10>,5,<27,43,26>,5,<28,12,13>,5,<28,29,45>,5,<28,44,43>,5,<30,29,13>,5,<30,46,29>,5,<31,15,0>,5,<31,30,14>,5,<31,47,30>,5,<32,16,17>,5,<33,34,50>,5,<33,49,48>,5,<34,33,17>,5,<35,36,52>,5,<35,50,34>,5,<35,51,50>,5,<37,36,20>,5,<37,53,52>,5,<38,37,21>,5,<38,54,53>,5,<39,40,56>,5,<39,54,38>,5,<39,55,54>,5,<40,24,25>,5,<40,41,57>,5,<41,42,58>,5,<42,41,25>,5,<43,27,28>,5,<43,42,26>,5,<43,44,60>,5,<43,59,42>,5,<44,45,61>,5,<45,44,28>,5,<46,45,29>,5,<46,62,61>,5,<47,31,16>,5,<47,32,48>,5,<47,46,30>,5,<47,63,46>,5,<48,32,33>,5,<48,63,47>,5,<49,50,66>,5,<49,65,64>,5,<50,49,33>,5,<50,51,67>,5,<51,52,68>,5,<52,36,37>,5,<52,51,35>,5,<53,37,38>,5,<53,69,68>,5,<54,55,71>,5,<54,70,69>,5,<55,56,72>,5,<56,55,39>,5,<57,56,40>,5,<57,73,72>,5,<58,57,41>,5,<58,74,73>,5,<59,58,42>,5,<59,60,76>,5,<59,75,74>,5,<60,59,43>,5,<60,61,77>,5,<61,45,46>,5,<61,60,44>,5,<62,78,77>,5,<63,48,64>,5,<63,62,46>,5,<63,79,78>,5,<64,48,49>,5,<64,65,81>,5,<64,79,63>,5,<64,80,79>,5,<66,65,49>,5,<66,67,83>,5,<66,81,65>,5,<66,82,81>,5,<67,66,50>,5,<67,68,84>,5,<68,52,53>,5,<68,67,51>,5,<68,69,85>,5,<69,53,54>,5,<70,71,87>,5,<70,85,69>,5,<70,86,85>,5,<71,70,54>,5,<71,72,88>,5,<72,56,57>,5,<72,71,55>,5,<73,57,58>,5,<73,89,88>,5,<74,58,59>,5,<74,90,89>,5,<75,91,90>,5,<76,75,59>,5,<76,77,93>,5,<76,92,75>,5,<77,61,62>,5,<77,76,60>,5,<78,62,63>,5,<78,94,93>,5,<79,95,94>,5,<80,95,79>,5,<80,96,95>,5,<81,80,64>,5,<81,97,80>,5,<82,83,99>,5,<82,97,81>,5,<82,98,97>,5,<83,82,66>,5,<83,84,100>,5,<84,83,67>,5,<84,85,101>,5,<85,84,68>,5,<86,87,103>,5,<86,101,85>,5,<86,102,101>,5,<87,86,70>,5,<87,88,104>,5,<88,72,73>,5,<88,87,71>,5,<88,89,105>,5,<89,73,74>,5,<90,74,75>,5,<90,106,105>,5,<91,107,106>,5,<92,91,75>,5,<92,108,91>,5,<93,77,78>,5,<93,92,76>,5,<93,109,92>,5,<94,78,79>,5,<94,110,109>,5,<95,111,110>,5,<96,111,95>,5,<96,113,111>,5,<97,96,80>,5,<97,113,96>,5,<98,113,97>,5,<99,98,82>,5,<99,113,98>,5,<100,99,83>,5,<100,113,99>,5,<101,100,84>,5,<101,113,100>,5,<102,113,101>,5,<103,102,86>,5,<103,113,102>,5,<104,103,87>,5,<104,113,103>,5,<105,89,90>,5,<105,104,88>,5,<105,113,104>,5,<106,90,91>,5,<106,113,105>,5,<107,113,106>,5,<108,107,91>,5,<108,113,107>,5,<109,93,94>,5,<109,108,92>,5,<109,113,108>,5,<110,94,95>,5,<110,113,109>,5,<111,113,110>,5}
normal_indices {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}
}

#declare ruota4 = mesh2 {
vertex_vectors {128,<0.479751,9.83959e-2,-0.856493>,<0.496848,0.197645,-0.846622>,<0.545536,0.281785,-0.818512>,<0.618403,0.338005,-0.776442>,<0.704355,0.357747,-0.726817>,<0.790308,0.338005,-0.677193>,<0.863175,0.281785,-0.635123>,<0.911863,0.197645,-0.607013>,<0.928960,9.83959e-2,-0.597142>,<0.911863,-8.53457e-4,-0.607013>,<0.863175,-8.49930e-2,-0.635123>,<0.790308,-0.141213,-0.677193>,<0.704355,-0.160955,-0.726817>,<0.618403,-0.141213,-0.776442>,<0.545536,-8.49930e-2,-0.818512>,<0.496848,-8.53457e-4,-0.846622>,<0.503775,9.83959e-2,-0.875282>,<0.520120,0.193278,-0.865846>,<0.566666,0.273716,-0.838972>,<0.636327,0.327463,-0.798754>,<0.718497,0.346336,-0.751312>,<0.800668,0.327463,-0.703871>,<0.870329,0.273716,-0.663652>,<0.916875,0.193278,-0.636779>,<0.933220,9.83959e-2,-0.627342>,<0.916875,3.51339e-3,-0.636779>,<0.870329,-7.69241e-2,-0.663652>,<0.800668,-0.130671,-0.703871>,<0.718497,-0.149544,-0.751312>,<0.636327,-0.130671,-0.798754>,<0.566666,-7.69241e-2,-0.838972>,<0.520120,3.51339e-3,-0.865846>,<0.533491,9.83959e-2,-0.871654>,<0.548020,0.182736,-0.863266>,<0.589394,0.254236,-0.839378>,<0.651315,0.302011,-0.803628>,<0.724355,0.318787,-0.761458>,<0.797396,0.302011,-0.719288>,<0.859317,0.254236,-0.683538>,<0.900691,0.182736,-0.659651>,<0.915220,9.83959e-2,-0.651263>,<0.900691,1.40559e-2,-0.659651>,<0.859317,-5.74441e-2,-0.683538>,<0.797396,-0.105219,-0.719288>,<0.724355,-0.121995,-0.761458>,<0.651315,-0.105219,-0.803628>,<0.589394,-5.74441e-2,-0.839378>,<0.548020,1.40559e-2,-0.863266>,<0.551491,9.83959e-2,-0.847733>,<0.564204,0.172193,-0.840394>,<0.600406,0.234756,-0.819492>,<0.654587,0.276559,-0.788211>,<0.718497,0.291238,-0.751312>,<0.782408,0.276559,-0.714414>,<0.836589,0.234756,-0.683132>,<0.872791,0.172193,-0.662231>,<0.885504,9.83959e-2,-0.654891>,<0.872791,2.45984e-2,-0.662231>,<0.836589,-3.79641e-2,-0.683132>,<0.782408,-7.97670e-2,-0.714414>,<0.718497,-9.44463e-2,-0.751312>,<0.654587,-7.97670e-2,-0.788211>,<0.600406,-3.79641e-2,-0.819492>,<0.564204,2.45984e-2,-0.840394>,<0.547231,9.83959e-2,-0.817533>,<0.559192,0.167827,-0.810628>,<0.593252,0.226687,-0.790963>,<0.644227,0.266016,-0.761533>,<0.704355,0.279827,-0.726817>,<0.764484,0.266016,-0.692102>,<0.815459,0.226687,-0.662672>,<0.849519,0.167827,-0.643007>,<0.861479,9.83959e-2,-0.636102>,<0.849519,2.89652e-2,-0.643007>,<0.815459,-2.98952e-2,-0.662672>,<0.764484,-6.92245e-2,-0.692102>,<0.704355,-8.30352e-2,-0.726817>,<0.644227,-6.92245e-2,-0.761533>,<0.593252,-2.98952e-2,-0.790963>,<0.559192,2.89652e-2,-0.810628>,<0.523207,9.83959e-2,-0.798744>,<0.535920,0.172193,-0.791404>,<0.572122,0.234756,-0.770503>,<0.626303,0.276559,-0.739221>,<0.690213,0.291238,-0.702323>,<0.754124,0.276559,-0.665424>,<0.808304,0.234756,-0.634143>,<0.844507,0.172193,-0.613241>,<0.857219,9.83959e-2,-0.605901>,<0.844507,2.45984e-2,-0.613241>,<0.808304,-3.79641e-2,-0.634143>,<0.754124,-7.97670e-2,-0.665424>,<0.690213,-9.44463e-2,-0.702323>,<0.626303,-7.97670e-2,-0.739221>,<0.572122,-3.79641e-2,-0.770503>,<0.535920,2.45984e-2,-0.791404>,<0.493491,9.83959e-2,-0.802372>,<0.508020,0.182736,-0.793984>,<0.549394,0.254236,-0.770096>,<0.611315,0.302011,-0.734346>,<0.684355,0.318787,-0.692176>,<0.757396,0.302011,-0.650006>,<0.819317,0.254236,-0.614256>,<0.860691,0.182736,-0.590369>,<0.875220,9.83959e-2,-0.581981>,<0.860691,1.40559e-2,-0.590369>,<0.819317,-5.74441e-2,-0.614256>,<0.757396,-0.105219,-0.650006>,<0.684355,-0.121995,-0.692176>,<0.611315,-0.105219,-0.734346>,<0.549394,-5.74441e-2,-0.770096>,<0.508020,1.40559e-2,-0.793984>,<0.475491,9.83959e-2,-0.826293>,<0.491836,0.193278,-0.816856>,<0.538382,0.273716,-0.789983>,<0.608043,0.327463,-0.749764>,<0.690213,0.346336,-0.702323>,<0.772384,0.327463,-0.654881>,<0.842045,0.273716,-0.614663>,<0.888591,0.193278,-0.587789>,<0.904935,9.83959e-2,-0.578353>,<0.888591,3.51339e-3,-0.587789>,<0.842045,-7.69241e-2,-0.614663>,<0.772384,-0.130671,-0.654881>,<0.690213,-0.149544,-0.702323>,<0.608043,-0.130671,-0.749764>,<0.538382,-7.69241e-2,-0.789983>,<0.491836,3.51339e-3,-0.816856>}
normal_vectors {128,<0.791658,9.45099e-16,0.610964>,<0.850198,-0.344538,0.398066>,<0.651545,-0.658776,0.376169>,<0.383621,-0.896538,0.221484>,<1.19692e-15,-1.00000,-2.89125e-15>,<-0.383621,-0.896538,-0.221484>,<-0.651545,-0.658776,-0.376169>,<-0.850198,-0.344538,-0.398066>,<-0.822360,-3.96225e-2,-0.567586>,<-0.820276,0.320722,-0.473587>,<-0.651545,0.658776,-0.376169>,<-0.383621,0.896538,-0.221484>,<1.84888e-15,1.00000,-3.39342e-15>,<0.383621,0.896538,0.221484>,<0.651545,0.658776,0.376169>,<0.850198,0.344538,0.398066>,<0.184684,-1.68793e-2,0.982653>,<0.341934,-0.306629,0.888290>,<7.29584e-2,-0.516506,0.853170>,<-0.172451,-0.628628,0.758345>,<-0.351257,-0.711671,0.608394>,<-0.548749,-0.674805,0.493470>,<-0.757326,-0.535997,0.373049>,<-0.904022,-0.315588,0.288353>,<-0.967582,5.68850e-18,0.252559>,<-0.904022,0.315588,0.288353>,<-0.757326,0.535997,0.373049>,<-0.548749,0.674805,0.493470>,<-0.351257,0.711671,0.608394>,<-0.172451,0.628628,0.758345>,<7.29584e-2,0.516506,0.853170>,<0.276033,0.276552,0.920503>,<-0.499801,2.81860e-2,0.865681>,<-0.446531,-1.20614e-2,0.894687>,<-0.500000,2.07733e-15,0.866025>,<-0.512727,8.47361e-2,0.854360>,<-0.495051,-0.140354,0.857453>,<-0.488598,6.06367e-2,0.870399>,<-0.500000,1.65380e-15,0.866025>,<-0.571514,-1.68551e-2,0.820419>,<-0.424747,1.68551e-2,0.905155>,<-0.500000,-1.26052e-16,0.866025>,<-0.500000,-2.06725e-15,0.866025>,<-0.488598,-6.06367e-2,0.870399>,<-0.495051,0.140354,0.857453>,<-0.512727,-8.47361e-2,0.854360>,<-0.500000,-1.86557e-15,0.866025>,<-0.551556,-1.20614e-2,0.834050>,<-0.943345,-1.68793e-2,0.331385>,<-0.935264,0.228496,0.270316>,<-0.815053,0.469339,0.339720>,<-0.624174,0.638730,0.449924>,<-0.351257,0.711671,0.608394>,<-3.46422e-2,0.693210,0.719903>,<9.61131e-2,0.489769,0.866538>,<9.09340e-2,0.233137,0.968183>,<0.321586,-1.21108e-2,0.946803>,<0.136157,-0.264824,0.954636>,<9.61131e-2,-0.489769,0.866538>,<-3.46422e-2,-0.693210,0.719903>,<-0.351257,-0.711671,0.608394>,<-0.624174,-0.638730,0.449924>,<-0.815053,-0.469339,0.339720>,<-0.946943,-0.256863,0.193186>,<-0.924940,5.63038e-16,-0.380114>,<-0.760300,0.408095,-0.505374>,<-0.570517,0.752339,-0.329388>,<-0.277754,0.947173,-0.160361>,<2.17605e-15,1.00000,-2.91408e-15>,<0.277754,0.947173,0.160361>,<0.570517,0.752339,0.329388>,<0.760300,0.408095,0.505374>,<0.924940,-5.02712e-18,0.380114>,<0.760300,-0.408095,0.505374>,<0.570517,-0.752339,0.329388>,<0.277754,-0.947173,0.160361>,<1.28490e-15,-1.00000,-3.46950e-15>,<-0.277754,-0.947173,-0.160361>,<-0.570517,-0.752339,-0.329388>,<-0.760300,-0.408095,-0.505374>,<-0.394755,4.34415e-16,-0.918786>,<-9.09340e-2,0.233137,-0.968183>,<-9.61131e-2,0.489769,-0.866538>,<3.46422e-2,0.693210,-0.719903>,<0.351257,0.711671,-0.608394>,<0.624174,0.638730,-0.449924>,<0.815053,0.469339,-0.339720>,<0.935264,0.228496,-0.270316>,<0.967582,-2.12371e-16,-0.252559>,<0.935264,-0.228496,-0.270316>,<0.815053,-0.469339,-0.339720>,<0.624174,-0.638730,-0.449924>,<0.351257,-0.711671,-0.608394>,<3.46422e-2,-0.693210,-0.719903>,<-9.61131e-2,-0.489769,-0.866538>,<-9.09340e-2,-0.233137,-0.968183>,<0.446531,1.20614e-2,-0.894687>,<0.571514,-1.68551e-2,-0.820419>,<0.500000,6.15133e-16,-0.866025>,<0.488598,6.06367e-2,-0.870399>,<0.495051,-0.140354,-0.857453>,<0.512727,8.47361e-2,-0.854360>,<0.500000,3.94290e-15,-0.866025>,<0.446531,-1.20614e-2,-0.894687>,<0.551556,1.20614e-2,-0.834050>,<0.500000,-9.63036e-16,-0.866025>,<0.500000,-2.97482e-15,-0.866025>,<0.512727,-8.47361e-2,-0.854360>,<0.495051,0.140354,-0.857453>,<0.488598,-6.06367e-2,-0.870399>,<0.500000,-1.12438e-15,-0.866025>,<0.500000,2.11011e-15,-0.866025>,<0.980748,-1.21108e-2,-0.194900>,<0.904022,-0.315588,-0.288353>,<0.757326,-0.535997,-0.373049>,<0.548749,-0.674805,-0.493470>,<0.351257,-0.711671,-0.608394>,<0.172451,-0.628628,-0.758345>,<-7.29584e-2,-0.516506,-0.853170>,<-0.341934,-0.306629,-0.888290>,<-0.265021,1.89058e-2,-0.964057>,<-0.211849,0.289763,-0.933358>,<-7.29584e-2,0.516506,-0.853170>,<0.172451,0.628628,-0.758345>,<0.351257,0.711671,-0.608394>,<0.548749,0.674805,-0.493470>,<0.757326,0.535997,-0.373049>,<0.897179,0.281995,-0.339923>}
texture_list { 11,
	texture { vetro_WingsMat }
	texture { pneumatici_WingsMat }
	texture { occhiali_WingsMat }
	texture { occhi_WingsMat }
	texture { nari_WingsMat }
	texture { mozzi_WingsMat }
	texture { denti_WingsMat }
	texture { casco_WingsMat }
	texture { Verdolino_WingsMat }
	texture { Giallino_WingsMat }
	texture { Corpo_WingsMat }
}
face_indices {256,<0,16,17>,1,<1,113,112>,1,<2,1,17>,1,<2,114,113>,1,<3,2,18>,1,<3,115,114>,1,<4,3,19>,1,<4,20,21>,1,<4,21,5>,1,<4,116,115>,1,<5,21,22>,1,<5,22,6>,1,<5,117,4>,1,<6,22,23>,1,<6,23,7>,1,<6,118,5>,1,<7,23,24>,1,<7,24,8>,1,<7,119,6>,1,<8,24,9>,1,<8,120,119>,1,<9,25,10>,1,<9,121,120>,1,<10,26,11>,1,<10,121,9>,1,<10,122,121>,1,<11,27,12>,1,<11,122,10>,1,<11,123,122>,1,<12,13,125>,1,<12,28,29>,1,<12,123,11>,1,<12,124,123>,1,<13,14,126>,1,<13,29,30>,1,<14,15,127>,1,<14,30,31>,1,<15,0,112>,1,<15,31,0>,1,<16,32,33>,1,<17,1,0>,1,<17,18,2>,1,<18,17,33>,1,<18,19,3>,1,<19,18,34>,1,<19,20,4>,1,<19,35,36>,1,<21,20,36>,1,<22,21,37>,1,<23,22,38>,1,<24,23,39>,1,<24,25,9>,1,<24,40,41>,1,<24,41,25>,1,<25,26,10>,1,<25,41,42>,1,<25,42,26>,1,<26,27,11>,1,<26,42,43>,1,<26,43,27>,1,<27,28,12>,1,<27,43,44>,1,<27,44,28>,1,<28,44,29>,1,<29,13,12>,1,<29,45,46>,1,<30,14,13>,1,<30,46,47>,1,<31,15,14>,1,<31,16,0>,1,<31,47,32>,1,<32,16,31>,1,<32,48,49>,1,<33,17,16>,1,<33,34,18>,1,<33,49,50>,1,<34,35,19>,1,<34,50,51>,1,<35,51,52>,1,<36,20,19>,1,<36,37,21>,1,<37,36,52>,1,<37,38,22>,1,<37,53,54>,1,<37,54,38>,1,<38,39,23>,1,<38,54,55>,1,<38,55,39>,1,<39,40,24>,1,<40,39,55>,1,<41,40,56>,1,<41,57,42>,1,<42,58,43>,1,<43,59,60>,1,<43,60,44>,1,<44,45,29>,1,<44,60,45>,1,<45,61,46>,1,<46,30,29>,1,<46,62,47>,1,<47,31,30>,1,<47,63,48>,1,<48,32,47>,1,<49,33,32>,1,<49,48,64>,1,<50,34,33>,1,<50,49,65>,1,<51,35,34>,1,<51,50,66>,1,<52,36,35>,1,<52,51,67>,1,<52,53,37>,1,<52,68,69>,1,<52,69,53>,1,<53,69,70>,1,<53,70,54>,1,<54,70,71>,1,<54,71,55>,1,<55,56,40>,1,<56,55,71>,1,<56,57,41>,1,<56,72,73>,1,<56,73,57>,1,<57,58,42>,1,<57,73,58>,1,<58,59,43>,1,<58,74,59>,1,<59,75,60>,1,<60,61,45>,1,<60,76,77>,1,<61,62,46>,1,<61,77,78>,1,<62,63,47>,1,<62,78,79>,1,<63,79,64>,1,<64,48,63>,1,<64,65,49>,1,<64,80,65>,1,<65,66,50>,1,<65,81,82>,1,<65,82,66>,1,<66,67,51>,1,<66,82,83>,1,<66,83,67>,1,<67,68,52>,1,<67,83,84>,1,<67,84,68>,1,<69,68,84>,1,<70,69,85>,1,<71,70,86>,1,<71,72,56>,1,<72,71,87>,1,<72,88,89>,1,<73,74,58>,1,<73,89,90>,1,<74,75,59>,1,<74,90,91>,1,<75,76,60>,1,<75,91,92>,1,<76,92,77>,1,<77,61,60>,1,<77,93,78>,1,<78,62,61>,1,<78,94,79>,1,<79,63,62>,1,<79,95,80>,1,<80,64,79>,1,<80,81,65>,1,<80,96,81>,1,<81,97,98>,1,<81,98,82>,1,<82,98,99>,1,<82,99,83>,1,<83,99,84>,1,<84,85,69>,1,<84,100,101>,1,<84,101,85>,1,<85,86,70>,1,<85,101,102>,1,<85,102,86>,1,<86,87,71>,1,<86,102,103>,1,<86,103,87>,1,<87,88,72>,1,<87,103,104>,1,<87,104,88>,1,<89,73,72>,1,<89,88,104>,1,<90,74,73>,1,<90,89,105>,1,<91,75,74>,1,<91,90,106>,1,<92,76,75>,1,<92,91,107>,1,<92,93,77>,1,<92,108,109>,1,<93,94,78>,1,<93,109,94>,1,<94,95,79>,1,<94,110,95>,1,<95,111,96>,1,<96,80,95>,1,<96,97,81>,1,<96,112,97>,1,<97,113,98>,1,<98,114,99>,1,<99,100,84>,1,<99,115,100>,1,<100,116,117>,1,<100,117,101>,1,<102,101,117>,1,<103,102,118>,1,<103,119,120>,1,<103,120,104>,1,<104,105,89>,1,<104,120,121>,1,<104,121,105>,1,<105,106,90>,1,<105,121,122>,1,<106,107,91>,1,<106,122,123>,1,<107,108,92>,1,<108,107,123>,1,<108,124,125>,1,<109,93,92>,1,<109,110,94>,1,<109,125,126>,1,<110,111,95>,1,<110,126,127>,1,<111,127,96>,1,<112,0,1>,1,<112,113,97>,1,<112,127,15>,1,<113,1,2>,1,<113,114,98>,1,<114,2,3>,1,<114,115,99>,1,<115,3,4>,1,<115,116,100>,1,<117,116,4>,1,<117,118,102>,1,<118,117,5>,1,<118,119,103>,1,<119,7,8>,1,<119,118,6>,1,<120,8,9>,1,<122,106,105>,1,<123,107,106>,1,<123,124,108>,1,<125,109,108>,1,<125,124,12>,1,<126,110,109>,1,<126,125,13>,1,<127,111,110>,1,<127,112,96>,1,<127,126,14>,1}
normal_indices {256,<0,16,17>,<1,113,112>,<2,1,17>,<2,114,113>,<3,2,18>,<3,115,114>,<4,3,19>,<4,20,21>,<4,21,5>,<4,116,115>,<5,21,22>,<5,22,6>,<5,117,4>,<6,22,23>,<6,23,7>,<6,118,5>,<7,23,24>,<7,24,8>,<7,119,6>,<8,24,9>,<8,120,119>,<9,25,10>,<9,121,120>,<10,26,11>,<10,121,9>,<10,122,121>,<11,27,12>,<11,122,10>,<11,123,122>,<12,13,125>,<12,28,29>,<12,123,11>,<12,124,123>,<13,14,126>,<13,29,30>,<14,15,127>,<14,30,31>,<15,0,112>,<15,31,0>,<16,32,33>,<17,1,0>,<17,18,2>,<18,17,33>,<18,19,3>,<19,18,34>,<19,20,4>,<19,35,36>,<21,20,36>,<22,21,37>,<23,22,38>,<24,23,39>,<24,25,9>,<24,40,41>,<24,41,25>,<25,26,10>,<25,41,42>,<25,42,26>,<26,27,11>,<26,42,43>,<26,43,27>,<27,28,12>,<27,43,44>,<27,44,28>,<28,44,29>,<29,13,12>,<29,45,46>,<30,14,13>,<30,46,47>,<31,15,14>,<31,16,0>,<31,47,32>,<32,16,31>,<32,48,49>,<33,17,16>,<33,34,18>,<33,49,50>,<34,35,19>,<34,50,51>,<35,51,52>,<36,20,19>,<36,37,21>,<37,36,52>,<37,38,22>,<37,53,54>,<37,54,38>,<38,39,23>,<38,54,55>,<38,55,39>,<39,40,24>,<40,39,55>,<41,40,56>,<41,57,42>,<42,58,43>,<43,59,60>,<43,60,44>,<44,45,29>,<44,60,45>,<45,61,46>,<46,30,29>,<46,62,47>,<47,31,30>,<47,63,48>,<48,32,47>,<49,33,32>,<49,48,64>,<50,34,33>,<50,49,65>,<51,35,34>,<51,50,66>,<52,36,35>,<52,51,67>,<52,53,37>,<52,68,69>,<52,69,53>,<53,69,70>,<53,70,54>,<54,70,71>,<54,71,55>,<55,56,40>,<56,55,71>,<56,57,41>,<56,72,73>,<56,73,57>,<57,58,42>,<57,73,58>,<58,59,43>,<58,74,59>,<59,75,60>,<60,61,45>,<60,76,77>,<61,62,46>,<61,77,78>,<62,63,47>,<62,78,79>,<63,79,64>,<64,48,63>,<64,65,49>,<64,80,65>,<65,66,50>,<65,81,82>,<65,82,66>,<66,67,51>,<66,82,83>,<66,83,67>,<67,68,52>,<67,83,84>,<67,84,68>,<69,68,84>,<70,69,85>,<71,70,86>,<71,72,56>,<72,71,87>,<72,88,89>,<73,74,58>,<73,89,90>,<74,75,59>,<74,90,91>,<75,76,60>,<75,91,92>,<76,92,77>,<77,61,60>,<77,93,78>,<78,62,61>,<78,94,79>,<79,63,62>,<79,95,80>,<80,64,79>,<80,81,65>,<80,96,81>,<81,97,98>,<81,98,82>,<82,98,99>,<82,99,83>,<83,99,84>,<84,85,69>,<84,100,101>,<84,101,85>,<85,86,70>,<85,101,102>,<85,102,86>,<86,87,71>,<86,102,103>,<86,103,87>,<87,88,72>,<87,103,104>,<87,104,88>,<89,73,72>,<89,88,104>,<90,74,73>,<90,89,105>,<91,75,74>,<91,90,106>,<92,76,75>,<92,91,107>,<92,93,77>,<92,108,109>,<93,94,78>,<93,109,94>,<94,95,79>,<94,110,95>,<95,111,96>,<96,80,95>,<96,97,81>,<96,112,97>,<97,113,98>,<98,114,99>,<99,100,84>,<99,115,100>,<100,116,117>,<100,117,101>,<102,101,117>,<103,102,118>,<103,119,120>,<103,120,104>,<104,105,89>,<104,120,121>,<104,121,105>,<105,106,90>,<105,121,122>,<106,107,91>,<106,122,123>,<107,108,92>,<108,107,123>,<108,124,125>,<109,93,92>,<109,110,94>,<109,125,126>,<110,111,95>,<110,126,127>,<111,127,96>,<112,0,1>,<112,113,97>,<112,127,15>,<113,1,2>,<113,114,98>,<114,2,3>,<114,115,99>,<115,3,4>,<115,116,100>,<117,116,4>,<117,118,102>,<118,117,5>,<118,119,103>,<119,7,8>,<119,118,6>,<120,8,9>,<122,106,105>,<123,107,106>,<123,124,108>,<125,109,108>,<125,124,12>,<126,110,109>,<126,125,13>,<127,111,110>,<127,112,96>,<127,126,14>}
}

#declare mozzo3 = mesh2 {
vertex_vectors {114,<0.776387,0.274494,0.687316>,<0.784931,0.274494,0.712484>,<0.783192,0.274494,0.739005>,<0.771437,0.274494,0.762843>,<0.751455,0.274494,0.780367>,<0.726287,0.274494,0.788910>,<0.699766,0.274494,0.787172>,<0.675928,0.274494,0.775416>,<0.658404,0.274494,0.755434>,<0.649861,0.274494,0.730266>,<0.651599,0.274494,0.703745>,<0.663354,0.274494,0.679908>,<0.683337,0.274494,0.662383>,<0.708505,0.274494,0.653840>,<0.735026,0.274494,0.655579>,<0.758863,0.274494,0.667334>,<0.826398,0.235908,0.658443>,<0.842184,0.235908,0.704946>,<0.838972,0.235908,0.753951>,<0.817251,0.235908,0.797997>,<0.780328,0.235908,0.830377>,<0.733824,0.235908,0.846163>,<0.684819,0.235908,0.842951>,<0.640774,0.235908,0.821231>,<0.608393,0.235908,0.784308>,<0.592608,0.235908,0.737804>,<0.595819,0.235908,0.688799>,<0.617540,0.235908,0.644753>,<0.654463,0.235908,0.612373>,<0.700967,0.235908,0.596587>,<0.749972,0.235908,0.599799>,<0.794017,0.235908,0.621520>,<0.859814,0.178161,0.639150>,<0.880439,0.178161,0.699910>,<0.876243,0.178161,0.763938>,<0.847863,0.178161,0.821486>,<0.799621,0.178161,0.863793>,<0.738861,0.178161,0.884419>,<0.674833,0.178161,0.880222>,<0.617285,0.178161,0.851843>,<0.574977,0.178161,0.803600>,<0.554352,0.178161,0.742840>,<0.558549,0.178161,0.678812>,<0.586928,0.178161,0.621264>,<0.635170,0.178161,0.578957>,<0.695931,0.178161,0.558331>,<0.759959,0.178161,0.562528>,<0.817507,0.178161,0.590908>,<0.871548,0.110043,0.632375>,<0.893873,0.110043,0.698141>,<0.889331,0.110043,0.767445>,<0.858613,0.110043,0.829735>,<0.806396,0.110043,0.875528>,<0.740629,0.110043,0.897852>,<0.671326,0.110043,0.893310>,<0.609036,0.110043,0.862592>,<0.563243,0.110043,0.810375>,<0.540919,0.110043,0.744609>,<0.545461,0.110043,0.675305>,<0.576179,0.110043,0.613016>,<0.628396,0.110043,0.567223>,<0.694162,0.110043,0.544898>,<0.763466,0.110043,0.549440>,<0.825755,0.110043,0.580158>,<0.859814,4.19255e-2,0.639150>,<0.880439,4.19255e-2,0.699910>,<0.876243,4.19255e-2,0.763938>,<0.847863,4.19255e-2,0.821486>,<0.799621,4.19255e-2,0.863793>,<0.738861,4.19255e-2,0.884419>,<0.674833,4.19255e-2,0.880222>,<0.617285,4.19255e-2,0.851843>,<0.574977,4.19255e-2,0.803600>,<0.554352,4.19255e-2,0.742840>,<0.558549,4.19255e-2,0.678812>,<0.586928,4.19255e-2,0.621264>,<0.635170,4.19255e-2,0.578957>,<0.695931,4.19255e-2,0.558331>,<0.759959,4.19255e-2,0.562528>,<0.817507,4.19255e-2,0.590908>,<0.826398,-1.58219e-2,0.658443>,<0.842184,-1.58219e-2,0.704946>,<0.838972,-1.58219e-2,0.753951>,<0.817251,-1.58219e-2,0.797997>,<0.780328,-1.58219e-2,0.830377>,<0.733824,-1.58219e-2,0.846163>,<0.684819,-1.58219e-2,0.842951>,<0.640774,-1.58219e-2,0.821231>,<0.608393,-1.58219e-2,0.784308>,<0.592608,-1.58219e-2,0.737804>,<0.595819,-1.58219e-2,0.688799>,<0.617540,-1.58219e-2,0.644753>,<0.654463,-1.58219e-2,0.612373>,<0.700967,-1.58219e-2,0.596587>,<0.749972,-1.58219e-2,0.599799>,<0.794017,-1.58219e-2,0.621520>,<0.776387,-5.44074e-2,0.687316>,<0.784931,-5.44074e-2,0.712484>,<0.783192,-5.44074e-2,0.739005>,<0.771437,-5.44074e-2,0.762843>,<0.751455,-5.44074e-2,0.780367>,<0.726287,-5.44074e-2,0.788910>,<0.699766,-5.44074e-2,0.787172>,<0.675928,-5.44074e-2,0.775416>,<0.658404,-5.44074e-2,0.755434>,<0.649861,-5.44074e-2,0.730266>,<0.651599,-5.44074e-2,0.703745>,<0.663354,-5.44074e-2,0.679908>,<0.683337,-5.44074e-2,0.662383>,<0.708505,-5.44074e-2,0.653840>,<0.735026,-5.44074e-2,0.655579>,<0.758863,-5.44074e-2,0.667334>,<0.717396,0.288043,0.721375>,<0.717396,-6.79568e-2,0.721375>}
normal_vectors {114,<0.373698,0.907921,-0.189816>,<0.417891,0.907921,-3.23586e-2>,<0.369172,0.924082,9.89193e-2>,<0.351097,0.896745,0.269406>,<0.189816,0.907921,0.373698>,<4.98864e-2,0.924082,0.378925>,<-8.66275e-2,0.907921,0.410093>,<-0.269406,0.896745,0.351097>,<-0.373698,0.907921,0.189816>,<-0.378925,0.924082,4.98864e-2>,<-0.410093,0.907921,-8.66275e-2>,<-0.351097,0.896745,-0.269406>,<-0.189816,0.907921,-0.373698>,<-3.23586e-2,0.907921,-0.417891>,<9.89193e-2,0.924082,-0.369172>,<0.269406,0.896745,-0.351097>,<0.616470,0.707599,-0.345352>,<0.701705,0.707599,-8.31508e-2>,<0.635855,0.752769,0.170377>,<0.602575,0.678577,0.420044>,<0.377149,0.687172,0.620929>,<8.59234e-2,0.752769,0.652653>,<-0.174030,0.707599,0.684848>,<-0.457732,0.659268,0.596529>,<-0.616470,0.707599,0.345352>,<-0.652653,0.752769,8.59234e-2>,<-0.684848,0.707599,-0.174030>,<-0.602575,0.678577,-0.420044>,<-0.377149,0.687172,-0.620929>,<-8.31508e-2,0.707599,-0.701705>,<0.170377,0.752769,-0.635855>,<0.457732,0.659268,-0.596529>,<0.768795,0.419315,-0.482834>,<0.922783,0.356654,-0.145840>,<0.873660,0.409068,0.263404>,<0.694223,0.382443,0.609748>,<0.461841,0.383160,0.799932>,<0.147115,0.409068,0.900567>,<-0.265040,0.356654,0.895853>,<-0.602132,0.345848,0.719601>,<-0.768795,0.419315,0.482834>,<-0.900567,0.409068,0.147115>,<-0.895853,0.356654,-0.265040>,<-0.699195,0.419315,-0.579051>,<-0.473513,0.321155,-0.820149>,<-0.115717,0.383155,-0.916407>,<0.263404,0.409068,-0.873660>,<0.602132,0.345848,-0.719601>,<0.879524,2.83931e-2,-0.475008>,<0.991445,2.66704e-16,-0.130526>,<0.972495,-2.83931e-2,0.231185>,<0.793353,6.19906e-16,0.608761>,<0.498905,6.61589e-2,0.864128>,<0.102271,-2.83931e-2,0.994351>,<-0.258819,1.29748e-16,0.965926>,<-0.585745,-2.83931e-2,0.809998>,<-0.864128,6.61589e-2,0.498905>,<-0.994351,-2.83931e-2,0.102271>,<-0.954121,-3.97197e-2,-0.296777>,<-0.775429,2.83931e-2,-0.630796>,<-0.464812,-3.97197e-2,-0.884518>,<-0.169700,3.97197e-2,-0.984695>,<0.231185,-2.83931e-2,-0.972495>,<0.608761,-4.32493e-16,-0.793353>,<0.767871,-0.382443,-0.513917>,<0.922783,-0.356654,-0.145840>,<0.865794,-0.443376,0.231989>,<0.735773,-0.383155,0.558417>,<0.473513,-0.321155,0.820149>,<0.116995,-0.443376,0.888667>,<-0.265040,-0.356654,0.895853>,<-0.579051,-0.419315,0.699195>,<-0.820149,-0.321155,0.473513>,<-0.888667,-0.443376,0.116995>,<-0.893463,-0.383155,-0.234342>,<-0.767862,-0.345848,-0.539238>,<-0.513917,-0.382443,-0.767871>,<-0.145840,-0.356654,-0.922783>,<0.231989,-0.443376,-0.865794>,<0.539238,-0.345848,-0.767862>,<0.616470,-0.707599,-0.345352>,<0.701705,-0.707599,-8.31508e-2>,<0.635855,-0.752769,0.170377>,<0.602575,-0.678577,0.420044>,<0.377149,-0.687172,0.620929>,<8.59234e-2,-0.752769,0.652653>,<-0.174030,-0.707599,0.684848>,<-0.420044,-0.678577,0.602575>,<-0.620929,-0.687172,0.377149>,<-0.652653,-0.752769,8.59234e-2>,<-0.684848,-0.707599,-0.174030>,<-0.596529,-0.659268,-0.457732>,<-0.345352,-0.707599,-0.616470>,<-8.31508e-2,-0.707599,-0.701705>,<0.170377,-0.752769,-0.635855>,<0.457732,-0.659268,-0.596529>,<0.373698,-0.907921,-0.189816>,<0.417891,-0.907921,-3.23586e-2>,<0.369172,-0.924082,9.89193e-2>,<0.351097,-0.896745,0.269406>,<0.189816,-0.907921,0.373698>,<4.98864e-2,-0.924082,0.378925>,<-8.66275e-2,-0.907921,0.410093>,<-0.269406,-0.896745,0.351097>,<-0.373698,-0.907921,0.189816>,<-0.378925,-0.924082,4.98864e-2>,<-0.410093,-0.907921,-8.66275e-2>,<-0.351097,-0.896745,-0.269406>,<-0.189816,-0.907921,-0.373698>,<-3.23586e-2,-0.907921,-0.417891>,<9.89193e-2,-0.924082,-0.369172>,<0.269406,-0.896745,-0.351097>,<-3.48698e-16,1.00000,-3.54008e-17>,<-3.50468e-16,-1.00000,5.31012e-18>}
texture_list { 11,
	texture { vetro_WingsMat }
	texture { pneumatici_WingsMat }
	texture { occhiali_WingsMat }
	texture { occhi_WingsMat }
	texture { nari_WingsMat }
	texture { mozzi_WingsMat }
	texture { denti_WingsMat }
	texture { casco_WingsMat }
	texture { Verdolino_WingsMat }
	texture { Giallino_WingsMat }
	texture { Corpo_WingsMat }
}
face_indices {224,<0,16,15>,5,<0,112,1>,5,<1,17,0>,5,<1,112,2>,5,<2,18,1>,5,<2,112,3>,5,<3,4,20>,5,<3,19,18>,5,<3,112,4>,5,<4,5,21>,5,<4,112,5>,5,<5,112,6>,5,<6,21,5>,5,<6,22,21>,5,<6,112,7>,5,<7,8,24>,5,<7,22,6>,5,<7,23,22>,5,<7,112,8>,5,<8,9,25>,5,<8,112,9>,5,<9,112,10>,5,<10,25,9>,5,<10,26,25>,5,<10,112,11>,5,<11,26,10>,5,<11,27,26>,5,<11,112,12>,5,<12,28,11>,5,<12,112,13>,5,<13,29,12>,5,<13,112,14>,5,<14,30,13>,5,<14,112,15>,5,<15,31,30>,5,<15,112,0>,5,<16,31,15>,5,<17,16,0>,5,<17,33,16>,5,<18,2,3>,5,<18,17,1>,5,<18,34,17>,5,<19,35,34>,5,<20,19,3>,5,<20,21,37>,5,<20,36,35>,5,<21,20,4>,5,<22,37,21>,5,<22,38,37>,5,<23,24,40>,5,<23,38,22>,5,<23,39,38>,5,<24,23,7>,5,<24,25,41>,5,<25,24,8>,5,<26,41,25>,5,<26,42,41>,5,<27,42,26>,5,<27,43,42>,5,<28,27,11>,5,<28,44,43>,5,<29,28,12>,5,<29,45,28>,5,<30,14,15>,5,<30,29,13>,5,<30,46,29>,5,<31,16,32>,5,<31,47,46>,5,<32,47,31>,5,<33,32,16>,5,<33,49,48>,5,<34,18,19>,5,<34,33,17>,5,<34,35,51>,5,<34,50,33>,5,<35,19,20>,5,<35,36,52>,5,<37,36,20>,5,<37,53,52>,5,<38,39,55>,5,<38,53,37>,5,<38,54,53>,5,<39,40,56>,5,<40,39,23>,5,<41,40,24>,5,<41,57,56>,5,<42,43,59>,5,<42,57,41>,5,<42,58,57>,5,<43,27,28>,5,<44,45,61>,5,<44,60,59>,5,<45,44,28>,5,<46,30,31>,5,<46,45,29>,5,<46,47,63>,5,<46,62,45>,5,<47,32,48>,5,<48,32,33>,5,<48,49,65>,5,<48,63,47>,5,<50,49,33>,5,<50,51,67>,5,<50,66,65>,5,<51,50,34>,5,<51,52,68>,5,<52,36,37>,5,<52,51,35>,5,<53,54,70>,5,<53,69,68>,5,<55,54,38>,5,<55,56,72>,5,<55,71,70>,5,<56,40,41>,5,<56,55,39>,5,<57,58,74>,5,<57,73,72>,5,<58,59,75>,5,<59,43,44>,5,<59,58,42>,5,<59,60,76>,5,<60,61,77>,5,<61,60,44>,5,<62,61,45>,5,<62,63,79>,5,<62,78,77>,5,<63,48,64>,5,<63,62,46>,5,<64,79,63>,5,<64,80,95>,5,<65,49,50>,5,<65,64,48>,5,<65,81,80>,5,<66,82,81>,5,<67,66,50>,5,<67,68,84>,5,<67,83,66>,5,<68,52,53>,5,<68,67,51>,5,<69,70,86>,5,<69,84,68>,5,<69,85,84>,5,<70,54,55>,5,<70,69,53>,5,<70,71,87>,5,<71,72,88>,5,<72,56,57>,5,<72,71,55>,5,<73,74,90>,5,<73,88,72>,5,<73,89,88>,5,<74,73,57>,5,<74,75,91>,5,<75,74,58>,5,<76,75,59>,5,<76,92,91>,5,<77,61,62>,5,<77,76,60>,5,<77,93,92>,5,<78,94,93>,5,<79,78,62>,5,<79,95,78>,5,<80,64,65>,5,<80,96,111>,5,<81,65,66>,5,<81,97,96>,5,<82,98,97>,5,<83,82,66>,5,<83,99,82>,5,<84,83,67>,5,<84,99,83>,5,<84,100,99>,5,<85,86,102>,5,<85,100,84>,5,<85,101,100>,5,<86,85,69>,5,<86,87,103>,5,<87,86,70>,5,<88,87,71>,5,<88,103,87>,5,<88,104,103>,5,<89,90,106>,5,<89,104,88>,5,<89,105,104>,5,<90,89,73>,5,<90,91,107>,5,<91,75,76>,5,<91,90,74>,5,<92,76,77>,5,<92,108,107>,5,<93,77,78>,5,<93,109,108>,5,<94,110,109>,5,<95,79,64>,5,<95,94,78>,5,<95,111,94>,5,<96,80,81>,5,<96,113,111>,5,<97,81,82>,5,<97,113,96>,5,<98,113,97>,5,<99,98,82>,5,<99,113,98>,5,<100,113,99>,5,<101,113,100>,5,<102,101,85>,5,<102,113,101>,5,<103,102,86>,5,<103,113,102>,5,<104,113,103>,5,<105,113,104>,5,<106,105,89>,5,<106,113,105>,5,<107,91,92>,5,<107,106,90>,5,<107,113,106>,5,<108,92,93>,5,<108,113,107>,5,<109,93,94>,5,<109,113,108>,5,<110,113,109>,5,<111,95,80>,5,<111,110,94>,5,<111,113,110>,5}
normal_indices {224,<0,16,15>,<0,112,1>,<1,17,0>,<1,112,2>,<2,18,1>,<2,112,3>,<3,4,20>,<3,19,18>,<3,112,4>,<4,5,21>,<4,112,5>,<5,112,6>,<6,21,5>,<6,22,21>,<6,112,7>,<7,8,24>,<7,22,6>,<7,23,22>,<7,112,8>,<8,9,25>,<8,112,9>,<9,112,10>,<10,25,9>,<10,26,25>,<10,112,11>,<11,26,10>,<11,27,26>,<11,112,12>,<12,28,11>,<12,112,13>,<13,29,12>,<13,112,14>,<14,30,13>,<14,112,15>,<15,31,30>,<15,112,0>,<16,31,15>,<17,16,0>,<17,33,16>,<18,2,3>,<18,17,1>,<18,34,17>,<19,35,34>,<20,19,3>,<20,21,37>,<20,36,35>,<21,20,4>,<22,37,21>,<22,38,37>,<23,24,40>,<23,38,22>,<23,39,38>,<24,23,7>,<24,25,41>,<25,24,8>,<26,41,25>,<26,42,41>,<27,42,26>,<27,43,42>,<28,27,11>,<28,44,43>,<29,28,12>,<29,45,28>,<30,14,15>,<30,29,13>,<30,46,29>,<31,16,32>,<31,47,46>,<32,47,31>,<33,32,16>,<33,49,48>,<34,18,19>,<34,33,17>,<34,35,51>,<34,50,33>,<35,19,20>,<35,36,52>,<37,36,20>,<37,53,52>,<38,39,55>,<38,53,37>,<38,54,53>,<39,40,56>,<40,39,23>,<41,40,24>,<41,57,56>,<42,43,59>,<42,57,41>,<42,58,57>,<43,27,28>,<44,45,61>,<44,60,59>,<45,44,28>,<46,30,31>,<46,45,29>,<46,47,63>,<46,62,45>,<47,32,48>,<48,32,33>,<48,49,65>,<48,63,47>,<50,49,33>,<50,51,67>,<50,66,65>,<51,50,34>,<51,52,68>,<52,36,37>,<52,51,35>,<53,54,70>,<53,69,68>,<55,54,38>,<55,56,72>,<55,71,70>,<56,40,41>,<56,55,39>,<57,58,74>,<57,73,72>,<58,59,75>,<59,43,44>,<59,58,42>,<59,60,76>,<60,61,77>,<61,60,44>,<62,61,45>,<62,63,79>,<62,78,77>,<63,48,64>,<63,62,46>,<64,79,63>,<64,80,95>,<65,49,50>,<65,64,48>,<65,81,80>,<66,82,81>,<67,66,50>,<67,68,84>,<67,83,66>,<68,52,53>,<68,67,51>,<69,70,86>,<69,84,68>,<69,85,84>,<70,54,55>,<70,69,53>,<70,71,87>,<71,72,88>,<72,56,57>,<72,71,55>,<73,74,90>,<73,88,72>,<73,89,88>,<74,73,57>,<74,75,91>,<75,74,58>,<76,75,59>,<76,92,91>,<77,61,62>,<77,76,60>,<77,93,92>,<78,94,93>,<79,78,62>,<79,95,78>,<80,64,65>,<80,96,111>,<81,65,66>,<81,97,96>,<82,98,97>,<83,82,66>,<83,99,82>,<84,83,67>,<84,99,83>,<84,100,99>,<85,86,102>,<85,100,84>,<85,101,100>,<86,85,69>,<86,87,103>,<87,86,70>,<88,87,71>,<88,103,87>,<88,104,103>,<89,90,106>,<89,104,88>,<89,105,104>,<90,89,73>,<90,91,107>,<91,75,76>,<91,90,74>,<92,76,77>,<92,108,107>,<93,77,78>,<93,109,108>,<94,110,109>,<95,79,64>,<95,94,78>,<95,111,94>,<96,80,81>,<96,113,111>,<97,81,82>,<97,113,96>,<98,113,97>,<99,98,82>,<99,113,98>,<100,113,99>,<101,113,100>,<102,101,85>,<102,113,101>,<103,102,86>,<103,113,102>,<104,113,103>,<105,113,104>,<106,105,89>,<106,113,105>,<107,91,92>,<107,106,90>,<107,113,106>,<108,92,93>,<108,113,107>,<109,93,94>,<109,113,108>,<110,113,109>,<111,95,80>,<111,110,94>,<111,113,110>}
}

#declare ruota3 = mesh2 {
vertex_vectors {128,<0.492791,0.110043,0.848152>,<0.509888,0.209293,0.838281>,<0.558576,0.293432,0.810170>,<0.631443,0.349652,0.768101>,<0.717396,0.369394,0.718476>,<0.803348,0.349652,0.668851>,<0.876215,0.293432,0.626782>,<0.924903,0.209293,0.598671>,<0.942000,0.110043,0.588800>,<0.924903,1.07938e-2,0.598671>,<0.876215,-7.33457e-2,0.626782>,<0.803348,-0.129566,0.668851>,<0.717396,-0.149308,0.718476>,<0.631443,-0.129566,0.768101>,<0.558576,-7.33457e-2,0.810170>,<0.509888,1.07938e-2,0.838281>,<0.488531,0.110043,0.817951>,<0.504876,0.204926,0.808514>,<0.551422,0.285363,0.781641>,<0.621083,0.339110,0.741422>,<0.703254,0.357983,0.693981>,<0.785424,0.339110,0.646540>,<0.855085,0.285363,0.606321>,<0.901631,0.204926,0.579448>,<0.917976,0.110043,0.570011>,<0.901631,1.51607e-2,0.579448>,<0.855085,-6.52768e-2,0.606321>,<0.785424,-0.119023,0.646540>,<0.703254,-0.137897,0.693981>,<0.621083,-0.119023,0.741422>,<0.551422,-6.52768e-2,0.781641>,<0.504876,1.51607e-2,0.808514>,<0.506531,0.110043,0.794031>,<0.521060,0.194383,0.785642>,<0.562434,0.265883,0.761755>,<0.624355,0.313658,0.726005>,<0.697396,0.330434,0.683835>,<0.770436,0.313658,0.641665>,<0.832357,0.265883,0.605915>,<0.873731,0.194383,0.582028>,<0.888260,0.110043,0.573639>,<0.873731,2.57032e-2,0.582028>,<0.832357,-4.57968e-2,0.605915>,<0.770436,-9.35716e-2,0.641665>,<0.697396,-0.110348,0.683835>,<0.624355,-9.35716e-2,0.726005>,<0.562434,-4.57968e-2,0.761755>,<0.521060,2.57032e-2,0.785642>,<0.536247,0.110043,0.790402>,<0.548960,0.183841,0.783063>,<0.585162,0.246403,0.762161>,<0.639343,0.288206,0.730880>,<0.703254,0.302885,0.693981>,<0.767164,0.288206,0.657082>,<0.821345,0.246403,0.625801>,<0.857547,0.183841,0.604900>,<0.870260,0.110043,0.597560>,<0.857547,3.62457e-2,0.604900>,<0.821345,-2.63168e-2,0.625801>,<0.767164,-6.81198e-2,0.657082>,<0.703254,-8.27990e-2,0.693981>,<0.639343,-6.81198e-2,0.730880>,<0.585162,-2.63168e-2,0.762161>,<0.548960,3.62457e-2,0.783063>,<0.560272,0.110043,0.809192>,<0.572232,0.179474,0.802286>,<0.606292,0.238334,0.782622>,<0.657267,0.277664,0.753191>,<0.717396,0.291474,0.718476>,<0.777524,0.277664,0.683761>,<0.828499,0.238334,0.654330>,<0.862559,0.179474,0.634666>,<0.874520,0.110043,0.627760>,<0.862559,4.06125e-2,0.634666>,<0.828499,-1.82480e-2,0.654330>,<0.777524,-5.75773e-2,0.683761>,<0.717396,-7.13879e-2,0.718476>,<0.657267,-5.75773e-2,0.753191>,<0.606292,-1.82480e-2,0.782622>,<0.572232,4.06125e-2,0.802286>,<0.564532,0.110043,0.839392>,<0.577244,0.183841,0.832052>,<0.613447,0.246403,0.811151>,<0.667627,0.288206,0.779870>,<0.731538,0.302885,0.742971>,<0.795448,0.288206,0.706072>,<0.849629,0.246403,0.674791>,<0.885831,0.183841,0.653889>,<0.898544,0.110043,0.646550>,<0.885831,3.62457e-2,0.653889>,<0.849629,-2.63168e-2,0.674791>,<0.795448,-6.81198e-2,0.706072>,<0.731538,-8.27990e-2,0.742971>,<0.667627,-6.81198e-2,0.779870>,<0.613447,-2.63168e-2,0.811151>,<0.577244,3.62457e-2,0.832052>,<0.546531,0.110043,0.863313>,<0.561060,0.194383,0.854924>,<0.602434,0.265883,0.831037>,<0.664355,0.313658,0.795287>,<0.737396,0.330434,0.753117>,<0.810436,0.313658,0.710947>,<0.872357,0.265883,0.675197>,<0.913731,0.194383,0.651310>,<0.928260,0.110043,0.642922>,<0.913731,2.57032e-2,0.651310>,<0.872357,-4.57968e-2,0.675197>,<0.810436,-9.35716e-2,0.710947>,<0.737396,-0.110348,0.753117>,<0.664355,-9.35716e-2,0.795287>,<0.602434,-4.57968e-2,0.831037>,<0.561060,2.57032e-2,0.854924>,<0.516816,0.110043,0.866941>,<0.533160,0.204926,0.857504>,<0.579706,0.285363,0.830631>,<0.649367,0.339110,0.790412>,<0.731538,0.357983,0.742971>,<0.813709,0.339110,0.695530>,<0.883369,0.285363,0.655311>,<0.929915,0.204926,0.628438>,<0.946260,0.110043,0.619001>,<0.929915,1.51607e-2,0.628438>,<0.883369,-6.52768e-2,0.655311>,<0.813709,-0.119023,0.695530>,<0.731538,-0.137897,0.742971>,<0.649367,-0.119023,0.790412>,<0.579706,-6.52768e-2,0.830631>,<0.533160,1.51607e-2,0.857504>}
normal_vectors {128,<0.791658,-3.16709e-16,-0.610964>,<0.850198,-0.344538,-0.398066>,<0.651545,-0.658776,-0.376169>,<0.383621,-0.896538,-0.221484>,<4.71731e-16,-1.00000,1.97823e-16>,<-0.383621,-0.896538,0.221484>,<-0.651545,-0.658776,0.376169>,<-0.850198,-0.344538,0.398066>,<-0.791658,-4.02170e-17,0.610964>,<-0.850198,0.344538,0.398066>,<-0.651545,0.658776,0.376169>,<-0.383621,0.896538,0.221484>,<-5.33551e-16,1.00000,-2.89125e-16>,<0.383621,0.896538,-0.221484>,<0.651545,0.658776,-0.376169>,<0.850198,0.344538,-0.398066>,<0.980748,-1.21108e-2,0.194900>,<0.904022,-0.315588,0.288353>,<0.757326,-0.535997,0.373049>,<0.548749,-0.674805,0.493470>,<0.351257,-0.711671,0.608394>,<0.172451,-0.628628,0.758345>,<-7.29584e-2,-0.516506,0.853170>,<-0.341934,-0.306629,0.888290>,<-0.184684,-1.68793e-2,0.982653>,<-0.276033,0.276552,0.920503>,<-7.29584e-2,0.516506,0.853170>,<0.172451,0.628628,0.758345>,<0.351257,0.711671,0.608394>,<0.548749,0.674805,0.493470>,<0.757326,0.535997,0.373049>,<0.897179,0.281995,0.339923>,<0.499801,2.81860e-2,0.865681>,<0.571514,-1.68551e-2,0.820419>,<0.500000,9.27742e-16,0.866025>,<0.488598,6.06367e-2,0.870399>,<0.495051,-0.140354,0.857453>,<0.512727,8.47361e-2,0.854360>,<0.500000,4.99165e-16,0.866025>,<0.446531,-1.20614e-2,0.894687>,<0.499801,2.81860e-2,0.865681>,<0.551556,-1.20614e-2,0.834050>,<0.500000,1.39161e-15,0.866025>,<0.512727,-8.47361e-2,0.854360>,<0.495051,0.140354,0.857453>,<0.488598,-6.06367e-2,0.870399>,<0.500000,-1.09917e-15,0.866025>,<0.424747,-1.68551e-2,0.905155>,<-0.265021,1.89058e-2,0.964057>,<-9.09340e-2,0.233137,0.968183>,<-9.61131e-2,0.489769,0.866538>,<3.46422e-2,0.693210,0.719903>,<0.351257,0.711671,0.608394>,<0.624174,0.638730,0.449924>,<0.815053,0.469339,0.339720>,<0.935264,0.228496,0.270316>,<0.943345,-1.68793e-2,0.331385>,<0.946943,-0.256863,0.193186>,<0.815053,-0.469339,0.339720>,<0.624174,-0.638730,0.449924>,<0.351257,-0.711671,0.608394>,<3.46422e-2,-0.693210,0.719903>,<-9.61131e-2,-0.489769,0.866538>,<-0.224380,-0.254829,0.940593>,<-0.893001,-2.83576e-2,0.449160>,<-0.760300,0.408095,0.505374>,<-0.570517,0.752339,0.329388>,<-0.277754,0.947173,0.160361>,<8.55963e-17,1.00000,7.60856e-17>,<0.277754,0.947173,-0.160361>,<0.570517,0.752339,-0.329388>,<0.760300,0.408095,-0.505374>,<0.893001,-2.83576e-2,-0.449160>,<0.776424,-0.442968,-0.448269>,<0.570517,-0.752339,-0.329388>,<0.277754,-0.947173,-0.160361>,<-8.21725e-16,-1.00000,5.17382e-16>,<-0.277754,-0.947173,0.160361>,<-0.570517,-0.752339,0.329388>,<-0.776424,-0.442968,0.448269>,<-0.967582,2.38917e-16,-0.252559>,<-0.935264,0.228496,-0.270316>,<-0.815053,0.469339,-0.339720>,<-0.624174,0.638730,-0.449924>,<-0.351257,0.711671,-0.608394>,<-3.46422e-2,0.693210,-0.719903>,<9.61131e-2,0.489769,-0.866538>,<9.09340e-2,0.233137,-0.968183>,<0.343602,3.95544e-2,-0.938282>,<0.172922,-0.229826,-0.957746>,<9.61131e-2,-0.489769,-0.866538>,<-3.46422e-2,-0.693210,-0.719903>,<-0.351257,-0.711671,-0.608394>,<-0.624174,-0.638730,-0.449924>,<-0.815053,-0.469339,-0.339720>,<-0.935264,-0.228496,-0.270316>,<-0.616601,3.99373e-17,-0.787276>,<-0.446531,-1.20614e-2,-0.894687>,<-0.500000,2.71264e-15,-0.866025>,<-0.512727,8.47361e-2,-0.854360>,<-0.495051,-0.140354,-0.857453>,<-0.488598,6.06367e-2,-0.870399>,<-0.500000,1.60842e-15,-0.866025>,<-0.571514,-1.68551e-2,-0.820419>,<-0.446531,1.20614e-2,-0.894687>,<-0.500000,-5.06728e-16,-0.866025>,<-0.500000,-1.95632e-15,-0.866025>,<-0.488598,-6.06367e-2,-0.870399>,<-0.495051,0.140354,-0.857453>,<-0.512727,-8.47361e-2,-0.854360>,<-0.500000,-2.33448e-15,-0.866025>,<-0.446531,1.20614e-2,-0.894687>,<0.131095,-1.59867e-16,-0.991370>,<0.341934,-0.306629,-0.888290>,<7.29584e-2,-0.516506,-0.853170>,<-0.172451,-0.628628,-0.758345>,<-0.351257,-0.711671,-0.608394>,<-0.548749,-0.674805,-0.493470>,<-0.757326,-0.535997,-0.373049>,<-0.904022,-0.315588,-0.288353>,<-0.980748,-1.21108e-2,-0.194900>,<-0.897179,0.281995,-0.339923>,<-0.757326,0.535997,-0.373049>,<-0.548749,0.674805,-0.493470>,<-0.351257,0.711671,-0.608394>,<-0.172451,0.628628,-0.758345>,<7.29584e-2,0.516506,-0.853170>,<0.341934,0.306629,-0.888290>}
texture_list { 11,
	texture { vetro_WingsMat }
	texture { pneumatici_WingsMat }
	texture { occhiali_WingsMat }
	texture { occhi_WingsMat }
	texture { nari_WingsMat }
	texture { mozzi_WingsMat }
	texture { denti_WingsMat }
	texture { casco_WingsMat }
	texture { Verdolino_WingsMat }
	texture { Giallino_WingsMat }
	texture { Corpo_WingsMat }
}
face_indices {256,<0,1,113>,1,<0,16,1>,1,<0,112,127>,1,<0,127,15>,1,<1,17,2>,1,<2,18,3>,1,<2,114,113>,1,<3,19,4>,1,<3,115,114>,1,<4,5,117>,1,<4,20,21>,1,<4,21,5>,1,<4,116,115>,1,<5,6,118>,1,<5,21,22>,1,<5,22,6>,1,<6,7,119>,1,<6,22,23>,1,<6,23,7>,1,<7,8,120>,1,<8,7,23>,1,<8,24,25>,1,<8,25,9>,1,<9,25,10>,1,<9,121,120>,1,<10,26,11>,1,<10,122,121>,1,<11,27,12>,1,<11,123,122>,1,<12,13,125>,1,<12,28,29>,1,<12,29,13>,1,<12,124,123>,1,<13,14,126>,1,<13,29,30>,1,<13,30,14>,1,<14,15,127>,1,<14,30,31>,1,<14,31,15>,1,<15,16,0>,1,<15,31,16>,1,<16,17,1>,1,<16,32,33>,1,<17,18,2>,1,<17,33,34>,1,<18,19,3>,1,<18,34,35>,1,<19,20,4>,1,<19,35,36>,1,<21,20,36>,1,<21,37,38>,1,<21,38,22>,1,<22,38,39>,1,<22,39,23>,1,<23,24,8>,1,<24,23,39>,1,<25,24,40>,1,<25,26,10>,1,<25,41,26>,1,<26,27,11>,1,<26,42,27>,1,<27,28,12>,1,<27,43,44>,1,<27,44,28>,1,<28,44,29>,1,<29,45,30>,1,<30,46,31>,1,<31,47,32>,1,<32,16,31>,1,<32,48,49>,1,<33,17,16>,1,<34,18,17>,1,<34,33,49>,1,<35,19,18>,1,<35,34,50>,1,<35,51,52>,1,<36,20,19>,1,<36,37,21>,1,<37,36,52>,1,<38,37,53>,1,<39,38,54>,1,<39,40,24>,1,<40,39,55>,1,<40,41,25>,1,<41,40,56>,1,<41,42,26>,1,<41,57,58>,1,<41,58,42>,1,<42,43,27>,1,<42,58,59>,1,<42,59,43>,1,<43,59,60>,1,<43,60,44>,1,<44,45,29>,1,<44,60,45>,1,<45,46,30>,1,<45,61,62>,1,<46,47,31>,1,<46,62,63>,1,<47,63,48>,1,<48,32,47>,1,<48,64,65>,1,<49,33,32>,1,<49,50,34>,1,<50,49,65>,1,<50,51,35>,1,<51,50,66>,1,<52,36,35>,1,<52,51,67>,1,<52,53,37>,1,<52,68,69>,1,<53,54,38>,1,<53,69,70>,1,<54,55,39>,1,<54,70,71>,1,<55,56,40>,1,<55,71,72>,1,<56,57,41>,1,<57,56,72>,1,<58,57,73>,1,<59,58,74>,1,<60,59,75>,1,<60,61,45>,1,<60,76,77>,1,<61,77,78>,1,<62,46,45>,1,<62,78,79>,1,<63,47,46>,1,<63,79,64>,1,<64,48,63>,1,<64,79,95>,1,<64,80,81>,1,<65,49,48>,1,<65,66,50>,1,<65,81,82>,1,<66,67,51>,1,<66,82,83>,1,<67,68,52>,1,<67,83,84>,1,<69,53,52>,1,<69,68,84>,1,<70,54,53>,1,<70,69,85>,1,<71,55,54>,1,<71,70,86>,1,<71,87,88>,1,<71,88,72>,1,<72,56,55>,1,<72,73,57>,1,<72,88,89>,1,<72,89,73>,1,<73,74,58>,1,<73,89,90>,1,<74,75,59>,1,<74,90,91>,1,<75,76,60>,1,<75,91,92>,1,<77,61,60>,1,<77,76,92>,1,<78,62,61>,1,<78,77,93>,1,<79,63,62>,1,<79,78,94>,1,<80,96,81>,1,<81,65,64>,1,<81,97,82>,1,<82,66,65>,1,<82,98,83>,1,<83,67,66>,1,<83,99,84>,1,<84,68,67>,1,<84,85,69>,1,<84,100,101>,1,<84,101,85>,1,<85,86,70>,1,<86,85,101>,1,<86,87,71>,1,<87,86,102>,1,<87,103,104>,1,<87,104,88>,1,<89,88,104>,1,<89,105,106>,1,<90,74,73>,1,<90,106,107>,1,<91,75,74>,1,<92,76,75>,1,<92,91,107>,1,<92,93,77>,1,<92,108,109>,1,<93,94,78>,1,<93,109,110>,1,<94,95,79>,1,<94,110,111>,1,<95,80,64>,1,<95,111,96>,1,<96,80,95>,1,<96,97,81>,1,<96,112,97>,1,<97,98,82>,1,<97,113,114>,1,<97,114,98>,1,<98,99,83>,1,<98,114,115>,1,<98,115,99>,1,<99,100,84>,1,<99,115,100>,1,<100,116,117>,1,<100,117,101>,1,<101,102,86>,1,<101,117,118>,1,<101,118,102>,1,<102,103,87>,1,<102,118,119>,1,<102,119,103>,1,<103,119,120>,1,<103,120,104>,1,<104,105,89>,1,<104,120,121>,1,<104,121,105>,1,<106,90,89>,1,<106,105,121>,1,<107,91,90>,1,<107,106,122>,1,<107,108,92>,1,<108,107,123>,1,<108,124,125>,1,<109,93,92>,1,<109,125,110>,1,<110,94,93>,1,<110,126,111>,1,<111,95,94>,1,<111,127,112>,1,<112,96,111>,1,<112,113,97>,1,<113,1,2>,1,<113,112,0>,1,<114,2,3>,1,<115,3,4>,1,<115,116,100>,1,<117,116,4>,1,<118,117,5>,1,<119,118,6>,1,<120,8,9>,1,<120,119,7>,1,<121,9,10>,1,<121,122,106>,1,<122,10,11>,1,<122,123,107>,1,<123,11,12>,1,<123,124,108>,1,<125,109,108>,1,<125,124,12>,1,<125,126,110>,1,<126,125,13>,1,<126,127,111>,1,<127,126,14>,1}
normal_indices {256,<0,1,113>,<0,16,1>,<0,112,127>,<0,127,15>,<1,17,2>,<2,18,3>,<2,114,113>,<3,19,4>,<3,115,114>,<4,5,117>,<4,20,21>,<4,21,5>,<4,116,115>,<5,6,118>,<5,21,22>,<5,22,6>,<6,7,119>,<6,22,23>,<6,23,7>,<7,8,120>,<8,7,23>,<8,24,25>,<8,25,9>,<9,25,10>,<9,121,120>,<10,26,11>,<10,122,121>,<11,27,12>,<11,123,122>,<12,13,125>,<12,28,29>,<12,29,13>,<12,124,123>,<13,14,126>,<13,29,30>,<13,30,14>,<14,15,127>,<14,30,31>,<14,31,15>,<15,16,0>,<15,31,16>,<16,17,1>,<16,32,33>,<17,18,2>,<17,33,34>,<18,19,3>,<18,34,35>,<19,20,4>,<19,35,36>,<21,20,36>,<21,37,38>,<21,38,22>,<22,38,39>,<22,39,23>,<23,24,8>,<24,23,39>,<25,24,40>,<25,26,10>,<25,41,26>,<26,27,11>,<26,42,27>,<27,28,12>,<27,43,44>,<27,44,28>,<28,44,29>,<29,45,30>,<30,46,31>,<31,47,32>,<32,16,31>,<32,48,49>,<33,17,16>,<34,18,17>,<34,33,49>,<35,19,18>,<35,34,50>,<35,51,52>,<36,20,19>,<36,37,21>,<37,36,52>,<38,37,53>,<39,38,54>,<39,40,24>,<40,39,55>,<40,41,25>,<41,40,56>,<41,42,26>,<41,57,58>,<41,58,42>,<42,43,27>,<42,58,59>,<42,59,43>,<43,59,60>,<43,60,44>,<44,45,29>,<44,60,45>,<45,46,30>,<45,61,62>,<46,47,31>,<46,62,63>,<47,63,48>,<48,32,47>,<48,64,65>,<49,33,32>,<49,50,34>,<50,49,65>,<50,51,35>,<51,50,66>,<52,36,35>,<52,51,67>,<52,53,37>,<52,68,69>,<53,54,38>,<53,69,70>,<54,55,39>,<54,70,71>,<55,56,40>,<55,71,72>,<56,57,41>,<57,56,72>,<58,57,73>,<59,58,74>,<60,59,75>,<60,61,45>,<60,76,77>,<61,77,78>,<62,46,45>,<62,78,79>,<63,47,46>,<63,79,64>,<64,48,63>,<64,79,95>,<64,80,81>,<65,49,48>,<65,66,50>,<65,81,82>,<66,67,51>,<66,82,83>,<67,68,52>,<67,83,84>,<69,53,52>,<69,68,84>,<70,54,53>,<70,69,85>,<71,55,54>,<71,70,86>,<71,87,88>,<71,88,72>,<72,56,55>,<72,73,57>,<72,88,89>,<72,89,73>,<73,74,58>,<73,89,90>,<74,75,59>,<74,90,91>,<75,76,60>,<75,91,92>,<77,61,60>,<77,76,92>,<78,62,61>,<78,77,93>,<79,63,62>,<79,78,94>,<80,96,81>,<81,65,64>,<81,97,82>,<82,66,65>,<82,98,83>,<83,67,66>,<83,99,84>,<84,68,67>,<84,85,69>,<84,100,101>,<84,101,85>,<85,86,70>,<86,85,101>,<86,87,71>,<87,86,102>,<87,103,104>,<87,104,88>,<89,88,104>,<89,105,106>,<90,74,73>,<90,106,107>,<91,75,74>,<92,76,75>,<92,91,107>,<92,93,77>,<92,108,109>,<93,94,78>,<93,109,110>,<94,95,79>,<94,110,111>,<95,80,64>,<95,111,96>,<96,80,95>,<96,97,81>,<96,112,97>,<97,98,82>,<97,113,114>,<97,114,98>,<98,99,83>,<98,114,115>,<98,115,99>,<99,100,84>,<99,115,100>,<100,116,117>,<100,117,101>,<101,102,86>,<101,117,118>,<101,118,102>,<102,103,87>,<102,118,119>,<102,119,103>,<103,119,120>,<103,120,104>,<104,105,89>,<104,120,121>,<104,121,105>,<106,90,89>,<106,105,121>,<107,91,90>,<107,106,122>,<107,108,92>,<108,107,123>,<108,124,125>,<109,93,92>,<109,125,110>,<110,94,93>,<110,126,111>,<111,95,94>,<111,127,112>,<112,96,111>,<112,113,97>,<113,1,2>,<113,112,0>,<114,2,3>,<115,3,4>,<115,116,100>,<117,116,4>,<118,117,5>,<119,118,6>,<120,8,9>,<120,119,7>,<121,9,10>,<121,122,106>,<122,10,11>,<122,123,107>,<123,11,12>,<123,124,108>,<125,109,108>,<125,124,12>,<125,126,110>,<126,125,13>,<126,127,111>,<127,126,14>}
}

#declare mozzo2 = mesh2 {
vertex_vectors {114,<-0.661435,0.278188,0.748688>,<-0.678960,0.278188,0.768670>,<-0.702797,0.278188,0.780425>,<-0.729318,0.278188,0.782164>,<-0.754486,0.278188,0.773620>,<-0.774468,0.278188,0.756096>,<-0.786224,0.278188,0.732259>,<-0.787962,0.278188,0.705738>,<-0.779419,0.278188,0.680570>,<-0.761894,0.278188,0.660588>,<-0.738057,0.278188,0.648832>,<-0.711536,0.278188,0.647094>,<-0.686368,0.278188,0.655637>,<-0.666386,0.278188,0.673161>,<-0.654630,0.278188,0.696999>,<-0.652892,0.278188,0.723520>,<-0.611425,0.239603,0.777561>,<-0.643805,0.239603,0.814484>,<-0.687851,0.239603,0.836205>,<-0.736856,0.239603,0.839417>,<-0.783360,0.239603,0.823631>,<-0.820283,0.239603,0.791251>,<-0.842003,0.239603,0.747205>,<-0.845215,0.239603,0.698200>,<-0.829429,0.239603,0.651696>,<-0.797049,0.239603,0.614773>,<-0.753003,0.239603,0.593053>,<-0.703998,0.239603,0.589841>,<-0.657495,0.239603,0.605627>,<-0.620572,0.239603,0.638007>,<-0.598851,0.239603,0.682053>,<-0.595639,0.239603,0.731058>,<-0.578009,0.181855,0.796854>,<-0.620316,0.181855,0.845096>,<-0.677864,0.181855,0.873476>,<-0.741892,0.181855,0.877673>,<-0.802652,0.181855,0.857047>,<-0.850894,0.181855,0.814740>,<-0.879274,0.181855,0.757192>,<-0.883471,0.181855,0.693164>,<-0.862845,0.181855,0.632404>,<-0.820538,0.181855,0.584161>,<-0.762990,0.181855,0.555782>,<-0.698962,0.181855,0.551585>,<-0.638202,0.181855,0.572211>,<-0.589960,0.181855,0.614518>,<-0.561580,0.181855,0.672066>,<-0.557383,0.181855,0.736094>,<-0.566275,0.113738,0.803629>,<-0.612068,0.113738,0.855846>,<-0.674357,0.113738,0.886564>,<-0.743661,0.113738,0.891106>,<-0.809427,0.113738,0.868781>,<-0.861644,0.113738,0.822988>,<-0.892362,0.113738,0.760699>,<-0.896904,0.113738,0.691395>,<-0.874580,0.113738,0.625629>,<-0.828787,0.113738,0.573412>,<-0.766497,0.113738,0.542694>,<-0.697193,0.113738,0.538152>,<-0.631427,0.113738,0.560476>,<-0.579210,0.113738,0.606269>,<-0.548492,0.113738,0.668559>,<-0.543950,0.113738,0.737863>,<-0.578009,4.56200e-2,0.796854>,<-0.620316,4.56200e-2,0.845096>,<-0.677864,4.56200e-2,0.873476>,<-0.741892,4.56200e-2,0.877673>,<-0.802652,4.56200e-2,0.857047>,<-0.850894,4.56200e-2,0.814740>,<-0.879274,4.56200e-2,0.757192>,<-0.883471,4.56200e-2,0.693164>,<-0.862845,4.56200e-2,0.632404>,<-0.820538,4.56200e-2,0.584161>,<-0.762990,4.56200e-2,0.555782>,<-0.698962,4.56200e-2,0.551585>,<-0.638202,4.56200e-2,0.572211>,<-0.589960,4.56200e-2,0.614518>,<-0.561580,4.56200e-2,0.672066>,<-0.557383,4.56200e-2,0.736094>,<-0.611425,-1.21274e-2,0.777561>,<-0.643805,-1.21274e-2,0.814484>,<-0.687851,-1.21274e-2,0.836205>,<-0.736856,-1.21274e-2,0.839417>,<-0.783360,-1.21274e-2,0.823631>,<-0.820283,-1.21274e-2,0.791251>,<-0.842003,-1.21274e-2,0.747205>,<-0.845215,-1.21274e-2,0.698200>,<-0.829429,-1.21274e-2,0.651696>,<-0.797049,-1.21274e-2,0.614773>,<-0.753003,-1.21274e-2,0.593053>,<-0.703998,-1.21274e-2,0.589841>,<-0.657495,-1.21274e-2,0.605627>,<-0.620572,-1.21274e-2,0.638007>,<-0.598851,-1.21274e-2,0.682053>,<-0.595639,-1.21274e-2,0.731058>,<-0.661435,-5.07130e-2,0.748688>,<-0.678960,-5.07130e-2,0.768670>,<-0.702797,-5.07130e-2,0.780425>,<-0.729318,-5.07130e-2,0.782164>,<-0.754486,-5.07130e-2,0.773620>,<-0.774468,-5.07130e-2,0.756096>,<-0.786224,-5.07130e-2,0.732259>,<-0.787962,-5.07130e-2,0.705738>,<-0.779419,-5.07130e-2,0.680570>,<-0.761894,-5.07130e-2,0.660588>,<-0.738057,-5.07130e-2,0.648832>,<-0.711536,-5.07130e-2,0.647094>,<-0.686368,-5.07130e-2,0.655637>,<-0.666386,-5.07130e-2,0.673161>,<-0.654630,-5.07130e-2,0.696999>,<-0.652892,-5.07130e-2,0.723520>,<-0.720427,0.291738,0.714629>,<-0.720427,-6.42624e-2,0.714629>}
normal_vectors {114,<0.373698,0.907921,0.189816>,<0.269406,0.896745,0.351097>,<9.89193e-2,0.924082,0.369172>,<-3.23586e-2,0.907921,0.417891>,<-0.189816,0.907921,0.373698>,<-0.351097,0.896745,0.269406>,<-0.369172,0.924082,9.89193e-2>,<-0.417891,0.907921,-3.23586e-2>,<-0.373698,0.907921,-0.189816>,<-0.269406,0.896745,-0.351097>,<-8.66275e-2,0.907921,-0.410093>,<4.98864e-2,0.924082,-0.378925>,<0.189816,0.907921,-0.373698>,<0.351097,0.896745,-0.269406>,<0.410093,0.907921,-8.66275e-2>,<0.378925,0.924082,4.98864e-2>,<0.616470,0.707599,0.345352>,<0.457732,0.659268,0.596529>,<0.170377,0.752769,0.635855>,<-8.31508e-2,0.707599,0.701705>,<-0.377149,0.687172,0.620929>,<-0.602575,0.678577,0.420044>,<-0.635855,0.752769,0.170377>,<-0.701705,0.707599,-8.31508e-2>,<-0.620929,0.687172,-0.377149>,<-0.420044,0.678577,-0.602575>,<-0.174030,0.707599,-0.684848>,<8.59234e-2,0.752769,-0.652653>,<0.377149,0.687172,-0.620929>,<0.602575,0.678577,-0.420044>,<0.684848,0.707599,-0.174030>,<0.652653,0.752769,8.59234e-2>,<0.767871,0.382443,0.513917>,<0.562302,0.383160,0.732806>,<0.263404,0.409068,0.873660>,<-0.145840,0.356654,0.922783>,<-0.461841,0.383160,0.799932>,<-0.694223,0.382443,0.609748>,<-0.873660,0.409068,0.263404>,<-0.922783,0.356654,-0.145840>,<-0.792039,0.345848,-0.503054>,<-0.558417,0.383155,-0.735773>,<-0.234342,0.383155,-0.893463>,<0.147115,0.409068,-0.900567>,<0.503054,0.345848,-0.792039>,<0.735773,0.383155,-0.558417>,<0.893463,0.383155,-0.234342>,<0.900567,0.409068,0.147115>,<0.879524,-2.83931e-2,0.475008>,<0.607428,6.61589e-2,0.791615>,<0.231185,-2.83931e-2,0.972495>,<-0.169700,-3.97197e-2,0.984695>,<-0.498905,6.61589e-2,0.864128>,<-0.793353,-1.07162e-15,0.608761>,<-0.972495,-2.83931e-2,0.231185>,<-0.984695,-3.97197e-2,-0.169700>,<-0.866025,-6.34323e-16,-0.500000>,<-0.608761,-1.11968e-15,-0.793353>,<-0.296777,3.97197e-2,-0.954121>,<0.102271,-2.83931e-2,-0.994351>,<0.500000,7.68876e-17,-0.866025>,<0.767921,3.97197e-2,-0.639312>,<0.946686,8.15141e-17,-0.322157>,<0.997908,8.15141e-17,6.46474e-2>,<0.799932,-0.383160,0.461841>,<0.587693,-0.356654,0.726234>,<0.231989,-0.443376,0.865794>,<-0.115717,-0.383155,0.916407>,<-0.487872,-0.356654,0.796730>,<-0.767862,-0.345848,0.539238>,<-0.865794,-0.443376,0.231989>,<-0.916407,-0.383155,-0.115717>,<-0.802367,-0.383155,-0.457602>,<-0.602132,-0.345848,-0.719601>,<-0.265040,-0.356654,-0.895853>,<0.116995,-0.443376,-0.888667>,<0.457602,-0.383155,-0.802367>,<0.751327,-0.321155,-0.576513>,<0.893463,-0.383155,-0.234342>,<0.900567,-0.409068,0.147115>,<0.620929,-0.687172,0.377149>,<0.420044,-0.678577,0.602575>,<0.170377,-0.752769,0.635855>,<-8.31508e-2,-0.707599,0.701705>,<-0.345352,-0.707599,0.616470>,<-0.596529,-0.659268,0.457732>,<-0.635855,-0.752769,0.170377>,<-0.701705,-0.707599,-8.31508e-2>,<-0.616470,-0.707599,-0.345352>,<-0.457732,-0.659268,-0.596529>,<-0.174030,-0.707599,-0.684848>,<8.59234e-2,-0.752769,-0.652653>,<0.345352,-0.707599,-0.616470>,<0.596529,-0.659268,-0.457732>,<0.684848,-0.707599,-0.174030>,<0.652653,-0.752769,8.59234e-2>,<0.373698,-0.907921,0.189816>,<0.269406,-0.896745,0.351097>,<9.89193e-2,-0.924082,0.369172>,<-3.23586e-2,-0.907921,0.417891>,<-0.189816,-0.907921,0.373698>,<-0.351097,-0.896745,0.269406>,<-0.369172,-0.924082,9.89193e-2>,<-0.417891,-0.907921,-3.23586e-2>,<-0.373698,-0.907921,-0.189816>,<-0.269406,-0.896745,-0.351097>,<-8.66275e-2,-0.907921,-0.410093>,<4.98864e-2,-0.924082,-0.378925>,<0.189816,-0.907921,-0.373698>,<0.351097,-0.896745,-0.269406>,<0.410093,-0.907921,-8.66275e-2>,<0.378925,-0.924082,4.98864e-2>,<4.03569e-16,1.00000,-4.41625e-16>,<4.05339e-16,-1.00000,-4.74371e-16>}
texture_list { 11,
	texture { vetro_WingsMat }
	texture { pneumatici_WingsMat }
	texture { occhiali_WingsMat }
	texture { occhi_WingsMat }
	texture { nari_WingsMat }
	texture { mozzi_WingsMat }
	texture { denti_WingsMat }
	texture { casco_WingsMat }
	texture { Verdolino_WingsMat }
	texture { Giallino_WingsMat }
	texture { Corpo_WingsMat }
}
face_indices {224,<0,16,31>,5,<0,112,1>,5,<1,2,18>,5,<1,17,16>,5,<1,112,2>,5,<2,112,3>,5,<3,18,2>,5,<3,19,18>,5,<3,112,4>,5,<4,19,3>,5,<4,20,19>,5,<4,112,5>,5,<5,6,22>,5,<5,20,4>,5,<5,21,20>,5,<5,112,6>,5,<6,112,7>,5,<7,22,6>,5,<7,23,22>,5,<7,112,8>,5,<8,23,7>,5,<8,24,23>,5,<8,112,9>,5,<9,24,8>,5,<9,25,24>,5,<9,112,10>,5,<10,26,9>,5,<10,112,11>,5,<11,27,10>,5,<11,112,12>,5,<12,28,27>,5,<12,112,13>,5,<13,29,28>,5,<13,112,14>,5,<14,30,13>,5,<14,112,15>,5,<15,31,14>,5,<15,112,0>,5,<16,0,1>,5,<16,32,47>,5,<17,18,34>,5,<17,33,32>,5,<18,17,1>,5,<19,34,18>,5,<19,35,34>,5,<20,21,37>,5,<20,35,19>,5,<20,36,35>,5,<21,22,38>,5,<22,21,5>,5,<23,38,22>,5,<23,39,38>,5,<24,25,41>,5,<24,39,23>,5,<24,40,39>,5,<26,25,9>,5,<26,42,25>,5,<27,11,12>,5,<27,26,10>,5,<27,43,26>,5,<28,12,13>,5,<28,29,45>,5,<28,44,43>,5,<30,29,13>,5,<30,46,29>,5,<31,15,0>,5,<31,30,14>,5,<31,47,30>,5,<32,16,17>,5,<32,33,49>,5,<34,33,17>,5,<34,50,49>,5,<35,36,52>,5,<35,50,34>,5,<35,51,50>,5,<37,36,20>,5,<37,53,52>,5,<38,37,21>,5,<38,54,53>,5,<39,40,56>,5,<39,54,38>,5,<39,55,54>,5,<40,41,57>,5,<41,40,24>,5,<41,42,58>,5,<42,41,25>,5,<43,27,28>,5,<43,42,26>,5,<43,44,60>,5,<43,59,42>,5,<44,45,61>,5,<45,44,28>,5,<45,46,62>,5,<46,45,29>,5,<47,31,16>,5,<47,32,48>,5,<47,46,30>,5,<47,63,46>,5,<48,49,65>,5,<48,63,47>,5,<48,64,79>,5,<49,33,34>,5,<49,48,32>,5,<50,51,67>,5,<50,66,65>,5,<51,52,68>,5,<52,36,37>,5,<52,51,35>,5,<53,37,38>,5,<53,69,68>,5,<54,55,71>,5,<54,70,69>,5,<55,56,72>,5,<56,55,39>,5,<56,57,73>,5,<57,56,40>,5,<57,58,74>,5,<58,57,41>,5,<59,58,42>,5,<59,60,76>,5,<59,75,74>,5,<60,59,43>,5,<60,61,77>,5,<61,60,44>,5,<62,61,45>,5,<62,78,77>,5,<63,62,46>,5,<63,79,78>,5,<64,80,79>,5,<65,49,50>,5,<65,64,48>,5,<65,81,80>,5,<66,67,83>,5,<66,81,65>,5,<66,82,81>,5,<67,66,50>,5,<67,68,84>,5,<68,52,53>,5,<68,67,51>,5,<68,69,85>,5,<69,53,54>,5,<70,71,87>,5,<70,85,69>,5,<70,86,85>,5,<71,70,54>,5,<71,72,88>,5,<72,71,55>,5,<72,73,89>,5,<73,72,56>,5,<74,58,59>,5,<74,73,57>,5,<74,90,89>,5,<75,91,90>,5,<76,75,59>,5,<76,77,93>,5,<76,92,75>,5,<77,61,62>,5,<77,76,60>,5,<78,62,63>,5,<78,94,93>,5,<79,63,48>,5,<79,95,94>,5,<80,64,65>,5,<80,95,79>,5,<80,96,95>,5,<81,97,80>,5,<82,83,99>,5,<82,97,81>,5,<82,98,97>,5,<83,82,66>,5,<83,84,100>,5,<84,83,67>,5,<84,85,101>,5,<85,84,68>,5,<86,87,103>,5,<86,101,85>,5,<86,102,101>,5,<87,86,70>,5,<87,88,104>,5,<88,87,71>,5,<88,89,105>,5,<89,73,74>,5,<89,88,72>,5,<90,74,75>,5,<90,106,105>,5,<91,107,106>,5,<92,91,75>,5,<92,108,91>,5,<93,77,78>,5,<93,92,76>,5,<93,109,92>,5,<94,78,79>,5,<94,110,109>,5,<95,111,110>,5,<96,111,95>,5,<96,113,111>,5,<97,96,80>,5,<97,113,96>,5,<98,113,97>,5,<99,98,82>,5,<99,113,98>,5,<100,99,83>,5,<100,113,99>,5,<101,100,84>,5,<101,113,100>,5,<102,113,101>,5,<103,102,86>,5,<103,113,102>,5,<104,103,87>,5,<104,113,103>,5,<105,89,90>,5,<105,104,88>,5,<105,113,104>,5,<106,90,91>,5,<106,113,105>,5,<107,113,106>,5,<108,107,91>,5,<108,113,107>,5,<109,93,94>,5,<109,108,92>,5,<109,113,108>,5,<110,94,95>,5,<110,113,109>,5,<111,113,110>,5}
normal_indices {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}
}

#declare ruota2 = mesh2 {
vertex_vectors {128,<-0.945032,0.113738,0.582054>,<-0.927935,0.212987,0.591925>,<-0.879247,0.297126,0.620035>,<-0.806380,0.353347,0.662105>,<-0.720427,0.373089,0.711730>,<-0.634475,0.353347,0.761354>,<-0.561608,0.297126,0.803424>,<-0.512919,0.212987,0.831534>,<-0.495822,0.113738,0.841405>,<-0.512919,1.44883e-2,0.831534>,<-0.561608,-6.96513e-2,0.803424>,<-0.634475,-0.125872,0.761354>,<-0.720427,-0.145613,0.711730>,<-0.806380,-0.125872,0.662105>,<-0.879247,-6.96513e-2,0.620035>,<-0.927935,1.44883e-2,0.591925>,<-0.921007,0.113738,0.563265>,<-0.904662,0.208620,0.572702>,<-0.858117,0.289058,0.599575>,<-0.788456,0.342804,0.639794>,<-0.706285,0.361678,0.687235>,<-0.624114,0.342804,0.734676>,<-0.554453,0.289058,0.774895>,<-0.507907,0.208620,0.801768>,<-0.491563,0.113738,0.811205>,<-0.507907,1.88551e-2,0.801768>,<-0.554453,-6.15824e-2,0.774895>,<-0.624114,-0.115329,0.734676>,<-0.706285,-0.134202,0.687235>,<-0.788456,-0.115329,0.639794>,<-0.858117,-6.15824e-2,0.599575>,<-0.904662,1.88551e-2,0.572702>,<-0.891291,0.113738,0.566893>,<-0.876763,0.198078,0.575281>,<-0.835388,0.269578,0.599169>,<-0.773468,0.317352,0.634919>,<-0.700427,0.334129,0.677089>,<-0.627386,0.317352,0.719259>,<-0.565466,0.269578,0.755009>,<-0.524092,0.198078,0.778896>,<-0.509563,0.113738,0.787284>,<-0.524092,2.93976e-2,0.778896>,<-0.565466,-4.21024e-2,0.755009>,<-0.627386,-8.98772e-2,0.719259>,<-0.700427,-0.106653,0.677089>,<-0.773468,-8.98772e-2,0.634919>,<-0.835388,-4.21024e-2,0.599169>,<-0.876763,2.93976e-2,0.575281>,<-0.873291,0.113738,0.590814>,<-0.860579,0.187535,0.598153>,<-0.824376,0.250098,0.619055>,<-0.770195,0.291901,0.650336>,<-0.706285,0.306580,0.687235>,<-0.642374,0.291901,0.724134>,<-0.588194,0.250098,0.755415>,<-0.551991,0.187535,0.776316>,<-0.539279,0.113738,0.783656>,<-0.551991,3.99401e-2,0.776316>,<-0.588194,-2.26224e-2,0.755415>,<-0.642374,-6.44253e-2,0.724134>,<-0.706285,-7.91046e-2,0.687235>,<-0.770195,-6.44253e-2,0.650336>,<-0.824376,-2.26224e-2,0.619055>,<-0.860579,3.99401e-2,0.598153>,<-0.877551,0.113738,0.621014>,<-0.865591,0.183168,0.627920>,<-0.831530,0.242029,0.647584>,<-0.780556,0.281358,0.677014>,<-0.720427,0.295169,0.711730>,<-0.660298,0.281358,0.746445>,<-0.609324,0.242029,0.775875>,<-0.575264,0.183168,0.795540>,<-0.563303,0.113738,0.802445>,<-0.575264,4.43070e-2,0.795540>,<-0.609324,-1.45535e-2,0.775875>,<-0.660298,-5.38828e-2,0.746445>,<-0.720427,-6.76934e-2,0.711730>,<-0.780556,-5.38828e-2,0.677014>,<-0.831530,-1.45535e-2,0.647584>,<-0.865591,4.43070e-2,0.627920>,<-0.901575,0.113738,0.639804>,<-0.888863,0.187535,0.647143>,<-0.852660,0.250098,0.668045>,<-0.798480,0.291901,0.699326>,<-0.734569,0.306580,0.736225>,<-0.670659,0.291901,0.773123>,<-0.616478,0.250098,0.804405>,<-0.580276,0.187535,0.825306>,<-0.567563,0.113738,0.832646>,<-0.580276,3.99401e-2,0.825306>,<-0.616478,-2.26224e-2,0.804405>,<-0.670659,-6.44253e-2,0.773123>,<-0.734569,-7.91046e-2,0.736225>,<-0.798480,-6.44253e-2,0.699326>,<-0.852660,-2.26224e-2,0.668045>,<-0.888863,3.99401e-2,0.647143>,<-0.931291,0.113738,0.636175>,<-0.916763,0.198078,0.644563>,<-0.875388,0.269578,0.668451>,<-0.813468,0.317352,0.704201>,<-0.740427,0.334129,0.746371>,<-0.667386,0.317352,0.788541>,<-0.605466,0.269578,0.824291>,<-0.564092,0.198078,0.848178>,<-0.549563,0.113738,0.856566>,<-0.564092,2.93976e-2,0.848178>,<-0.605466,-4.21024e-2,0.824291>,<-0.667386,-8.98772e-2,0.788541>,<-0.740427,-0.106653,0.746371>,<-0.813468,-8.98772e-2,0.704201>,<-0.875388,-4.21024e-2,0.668451>,<-0.916763,2.93976e-2,0.644563>,<-0.949291,0.113738,0.612255>,<-0.932947,0.208620,0.621691>,<-0.886401,0.289058,0.648565>,<-0.816740,0.342804,0.688783>,<-0.734569,0.361678,0.736225>,<-0.652399,0.342804,0.783666>,<-0.582738,0.289058,0.823885>,<-0.536192,0.208620,0.850758>,<-0.519847,0.113738,0.860195>,<-0.536192,1.88551e-2,0.850758>,<-0.582738,-6.15824e-2,0.823885>,<-0.652399,-0.115329,0.783666>,<-0.734569,-0.134202,0.736225>,<-0.816740,-0.115329,0.688783>,<-0.886401,-6.15824e-2,0.648565>,<-0.932947,1.88551e-2,0.621691>}
normal_vectors {128,<0.791658,9.04882e-17,0.610964>,<0.850198,-0.344538,0.398066>,<0.651545,-0.658776,0.376169>,<0.383621,-0.896538,0.221484>,<-2.70104e-16,-1.00000,3.34777e-16>,<-0.383621,-0.896538,-0.221484>,<-0.651545,-0.658776,-0.376169>,<-0.850198,-0.344538,-0.398066>,<-0.791658,3.21736e-16,-0.610964>,<-0.850198,0.344538,-0.398066>,<-0.651545,0.658776,-0.376169>,<-0.383621,0.896538,-0.221484>,<4.64122e-16,1.00000,-1.06520e-15>,<0.383621,0.896538,0.221484>,<0.651545,0.658776,0.376169>,<0.850198,0.344538,0.398066>,<0.184684,-1.68793e-2,0.982653>,<0.341934,-0.306629,0.888290>,<7.29584e-2,-0.516506,0.853170>,<-0.172451,-0.628628,0.758345>,<-0.351257,-0.711671,0.608394>,<-0.548749,-0.674805,0.493470>,<-0.757326,-0.535997,0.373049>,<-0.904022,-0.315588,0.288353>,<-0.980748,-1.21108e-2,0.194900>,<-0.897179,0.281995,0.339923>,<-0.757326,0.535997,0.373049>,<-0.548749,0.674805,0.493470>,<-0.351257,0.711671,0.608394>,<-0.172451,0.628628,0.758345>,<7.29584e-2,0.516506,0.853170>,<0.276033,0.276552,0.920503>,<-0.551556,1.20614e-2,0.834050>,<-0.446531,-1.20614e-2,0.894687>,<-0.500000,1.55296e-15,0.866025>,<-0.512727,8.47361e-2,0.854360>,<-0.495051,-0.140354,0.857453>,<-0.488598,6.06367e-2,0.870399>,<-0.500000,6.45385e-16,0.866025>,<-0.571514,-1.68551e-2,0.820419>,<-0.446531,1.20614e-2,0.894687>,<-0.500000,-1.31598e-15,0.866025>,<-0.500000,4.53787e-16,0.866025>,<-0.488598,-6.06367e-2,0.870399>,<-0.495051,0.140354,0.857453>,<-0.512727,-8.47361e-2,0.854360>,<-0.500000,-3.42861e-16,0.866025>,<-0.500000,1.94120e-16,0.866025>,<-0.967582,1.21355e-16,0.252559>,<-0.935264,0.228496,0.270316>,<-0.815053,0.469339,0.339720>,<-0.624174,0.638730,0.449924>,<-0.351257,0.711671,0.608394>,<-3.46422e-2,0.693210,0.719903>,<9.61131e-2,0.489769,0.866538>,<9.09340e-2,0.233137,0.968183>,<0.394755,3.66616e-16,0.918786>,<9.09340e-2,-0.233137,0.968183>,<9.61131e-2,-0.489769,0.866538>,<-3.46422e-2,-0.693210,0.719903>,<-0.351257,-0.711671,0.608394>,<-0.624174,-0.638730,0.449924>,<-0.815053,-0.469339,0.339720>,<-0.935264,-0.228496,0.270316>,<-0.924940,1.70922e-16,-0.380114>,<-0.760300,0.408095,-0.505374>,<-0.570517,0.752339,-0.329388>,<-0.277754,0.947173,-0.160361>,<2.57169e-15,1.00000,-1.56736e-15>,<0.277754,0.947173,0.160361>,<0.570517,0.752339,0.329388>,<0.760300,0.408095,0.505374>,<0.924940,-3.46871e-16,0.380114>,<0.760300,-0.408095,0.505374>,<0.570517,-0.752339,0.329388>,<0.277754,-0.947173,0.160361>,<4.08009e-16,-1.00000,-2.11518e-15>,<-0.277754,-0.947173,-0.160361>,<-0.570517,-0.752339,-0.329388>,<-0.760300,-0.408095,-0.505374>,<-0.394755,5.02214e-18,-0.918786>,<-9.09340e-2,0.233137,-0.968183>,<-9.61131e-2,0.489769,-0.866538>,<3.46422e-2,0.693210,-0.719903>,<0.351257,0.711671,-0.608394>,<0.624174,0.638730,-0.449924>,<0.815053,0.469339,-0.339720>,<0.935264,0.228496,-0.270316>,<0.967582,-3.10971e-16,-0.252559>,<0.935264,-0.228496,-0.270316>,<0.815053,-0.469339,-0.339720>,<0.624174,-0.638730,-0.449924>,<0.351257,-0.711671,-0.608394>,<3.46422e-2,-0.693210,-0.719903>,<-9.61131e-2,-0.489769,-0.866538>,<-9.09340e-2,-0.233137,-0.968183>,<0.373501,-4.24334e-17,-0.927630>,<0.571514,-1.68551e-2,-0.820419>,<0.500000,2.52104e-15,-0.866025>,<0.488598,6.06367e-2,-0.870399>,<0.495051,-0.140354,-0.857453>,<0.512727,8.47361e-2,-0.854360>,<0.500000,-3.02524e-17,-0.866025>,<0.446531,-1.20614e-2,-0.894687>,<0.551556,1.20614e-2,-0.834050>,<0.500000,-7.31101e-16,-0.866025>,<0.500000,9.47910e-16,-0.866025>,<0.512727,-8.47361e-2,-0.854360>,<0.495051,0.140354,-0.857453>,<0.488598,-6.06367e-2,-0.870399>,<0.500000,-1.61346e-15,-0.866025>,<0.571514,1.68551e-2,-0.820419>,<0.967582,2.65463e-17,-0.252559>,<0.904022,-0.315588,-0.288353>,<0.757326,-0.535997,-0.373049>,<0.548749,-0.674805,-0.493470>,<0.351257,-0.711671,-0.608394>,<0.172451,-0.628628,-0.758345>,<-7.29584e-2,-0.516506,-0.853170>,<-0.341934,-0.306629,-0.888290>,<-0.184684,-1.68793e-2,-0.982653>,<-0.276033,0.276552,-0.920503>,<-7.29584e-2,0.516506,-0.853170>,<0.172451,0.628628,-0.758345>,<0.351257,0.711671,-0.608394>,<0.548749,0.674805,-0.493470>,<0.757326,0.535997,-0.373049>,<0.904022,0.315588,-0.288353>}
texture_list { 11,
	texture { vetro_WingsMat }
	texture { pneumatici_WingsMat }
	texture { occhiali_WingsMat }
	texture { occhi_WingsMat }
	texture { nari_WingsMat }
	texture { mozzi_WingsMat }
	texture { denti_WingsMat }
	texture { casco_WingsMat }
	texture { Verdolino_WingsMat }
	texture { Giallino_WingsMat }
	texture { Corpo_WingsMat }
}
face_indices {256,<0,16,17>,1,<1,113,112>,1,<2,1,17>,1,<2,114,113>,1,<3,2,18>,1,<3,115,114>,1,<4,3,19>,1,<4,20,21>,1,<4,21,5>,1,<4,116,115>,1,<5,21,22>,1,<5,22,6>,1,<5,117,4>,1,<6,22,23>,1,<6,23,7>,1,<6,118,5>,1,<7,23,24>,1,<7,24,8>,1,<7,119,6>,1,<8,24,9>,1,<8,120,119>,1,<9,25,10>,1,<9,121,8>,1,<10,26,11>,1,<10,121,9>,1,<10,122,121>,1,<11,27,12>,1,<11,122,10>,1,<11,123,122>,1,<12,13,125>,1,<12,28,29>,1,<12,123,11>,1,<12,124,123>,1,<13,14,126>,1,<13,29,30>,1,<14,15,127>,1,<14,30,31>,1,<15,0,112>,1,<15,31,0>,1,<16,32,33>,1,<17,1,0>,1,<17,18,2>,1,<18,17,33>,1,<18,19,3>,1,<19,18,34>,1,<19,20,4>,1,<19,35,36>,1,<21,20,36>,1,<22,21,37>,1,<23,22,38>,1,<24,23,39>,1,<24,25,9>,1,<25,24,40>,1,<25,26,10>,1,<25,41,42>,1,<25,42,26>,1,<26,27,11>,1,<26,42,43>,1,<26,43,27>,1,<27,28,12>,1,<27,43,44>,1,<27,44,28>,1,<28,44,29>,1,<29,13,12>,1,<29,45,46>,1,<30,14,13>,1,<30,46,47>,1,<31,15,14>,1,<31,16,0>,1,<31,47,32>,1,<32,16,31>,1,<32,48,49>,1,<33,17,16>,1,<33,34,18>,1,<33,49,50>,1,<34,35,19>,1,<34,50,51>,1,<35,51,52>,1,<36,20,19>,1,<36,37,21>,1,<37,36,52>,1,<37,38,22>,1,<37,53,54>,1,<37,54,38>,1,<38,39,23>,1,<38,54,55>,1,<38,55,39>,1,<39,40,24>,1,<40,39,55>,1,<40,41,25>,1,<40,56,57>,1,<40,57,41>,1,<41,57,42>,1,<42,58,43>,1,<43,59,60>,1,<43,60,44>,1,<44,45,29>,1,<44,60,45>,1,<45,61,46>,1,<46,30,29>,1,<46,62,47>,1,<47,31,30>,1,<47,63,32>,1,<49,33,32>,1,<49,48,64>,1,<50,34,33>,1,<50,49,65>,1,<51,35,34>,1,<51,50,66>,1,<52,36,35>,1,<52,51,67>,1,<52,53,37>,1,<52,68,69>,1,<52,69,53>,1,<53,69,70>,1,<53,70,54>,1,<54,70,71>,1,<54,71,55>,1,<55,56,40>,1,<56,55,71>,1,<56,72,73>,1,<56,73,57>,1,<57,58,42>,1,<57,73,58>,1,<58,59,43>,1,<58,74,59>,1,<59,75,60>,1,<60,61,45>,1,<60,76,77>,1,<61,62,46>,1,<61,77,78>,1,<62,63,47>,1,<62,78,79>,1,<63,48,32>,1,<63,79,64>,1,<64,48,63>,1,<64,65,49>,1,<64,80,65>,1,<65,66,50>,1,<65,81,82>,1,<65,82,66>,1,<66,67,51>,1,<66,82,83>,1,<66,83,67>,1,<67,68,52>,1,<67,83,84>,1,<67,84,68>,1,<69,68,84>,1,<70,69,85>,1,<71,70,86>,1,<71,72,56>,1,<72,71,87>,1,<72,88,89>,1,<73,74,58>,1,<73,89,90>,1,<74,75,59>,1,<74,90,91>,1,<75,76,60>,1,<75,91,92>,1,<76,92,77>,1,<77,61,60>,1,<77,93,78>,1,<78,62,61>,1,<78,94,79>,1,<79,63,62>,1,<79,95,80>,1,<80,64,79>,1,<80,81,65>,1,<80,96,81>,1,<81,97,98>,1,<81,98,82>,1,<82,98,99>,1,<82,99,83>,1,<83,99,84>,1,<84,85,69>,1,<84,100,101>,1,<84,101,85>,1,<85,86,70>,1,<85,101,102>,1,<85,102,86>,1,<86,87,71>,1,<86,102,103>,1,<86,103,87>,1,<87,88,72>,1,<87,103,104>,1,<87,104,88>,1,<89,73,72>,1,<89,88,104>,1,<90,74,73>,1,<90,89,105>,1,<91,75,74>,1,<91,90,106>,1,<92,76,75>,1,<92,91,107>,1,<92,93,77>,1,<92,108,109>,1,<93,94,78>,1,<93,109,94>,1,<94,95,79>,1,<94,110,95>,1,<95,111,96>,1,<96,80,95>,1,<96,97,81>,1,<96,112,97>,1,<97,113,98>,1,<98,114,99>,1,<99,100,84>,1,<99,115,100>,1,<100,116,117>,1,<100,117,101>,1,<102,101,117>,1,<103,102,118>,1,<103,119,120>,1,<103,120,104>,1,<104,105,89>,1,<104,120,121>,1,<104,121,105>,1,<105,106,90>,1,<105,121,122>,1,<106,107,91>,1,<106,122,123>,1,<107,108,92>,1,<108,107,123>,1,<108,124,125>,1,<109,93,92>,1,<109,110,94>,1,<109,125,126>,1,<110,111,95>,1,<110,126,127>,1,<111,127,112>,1,<112,0,1>,1,<112,96,111>,1,<112,113,97>,1,<112,127,15>,1,<113,1,2>,1,<113,114,98>,1,<114,2,3>,1,<114,115,99>,1,<115,3,4>,1,<115,116,100>,1,<117,116,4>,1,<117,118,102>,1,<118,117,5>,1,<118,119,103>,1,<119,7,8>,1,<119,118,6>,1,<121,120,8>,1,<122,106,105>,1,<123,107,106>,1,<123,124,108>,1,<125,109,108>,1,<125,124,12>,1,<126,110,109>,1,<126,125,13>,1,<127,111,110>,1,<127,126,14>,1}
normal_indices {256,<0,16,17>,<1,113,112>,<2,1,17>,<2,114,113>,<3,2,18>,<3,115,114>,<4,3,19>,<4,20,21>,<4,21,5>,<4,116,115>,<5,21,22>,<5,22,6>,<5,117,4>,<6,22,23>,<6,23,7>,<6,118,5>,<7,23,24>,<7,24,8>,<7,119,6>,<8,24,9>,<8,120,119>,<9,25,10>,<9,121,8>,<10,26,11>,<10,121,9>,<10,122,121>,<11,27,12>,<11,122,10>,<11,123,122>,<12,13,125>,<12,28,29>,<12,123,11>,<12,124,123>,<13,14,126>,<13,29,30>,<14,15,127>,<14,30,31>,<15,0,112>,<15,31,0>,<16,32,33>,<17,1,0>,<17,18,2>,<18,17,33>,<18,19,3>,<19,18,34>,<19,20,4>,<19,35,36>,<21,20,36>,<22,21,37>,<23,22,38>,<24,23,39>,<24,25,9>,<25,24,40>,<25,26,10>,<25,41,42>,<25,42,26>,<26,27,11>,<26,42,43>,<26,43,27>,<27,28,12>,<27,43,44>,<27,44,28>,<28,44,29>,<29,13,12>,<29,45,46>,<30,14,13>,<30,46,47>,<31,15,14>,<31,16,0>,<31,47,32>,<32,16,31>,<32,48,49>,<33,17,16>,<33,34,18>,<33,49,50>,<34,35,19>,<34,50,51>,<35,51,52>,<36,20,19>,<36,37,21>,<37,36,52>,<37,38,22>,<37,53,54>,<37,54,38>,<38,39,23>,<38,54,55>,<38,55,39>,<39,40,24>,<40,39,55>,<40,41,25>,<40,56,57>,<40,57,41>,<41,57,42>,<42,58,43>,<43,59,60>,<43,60,44>,<44,45,29>,<44,60,45>,<45,61,46>,<46,30,29>,<46,62,47>,<47,31,30>,<47,63,32>,<49,33,32>,<49,48,64>,<50,34,33>,<50,49,65>,<51,35,34>,<51,50,66>,<52,36,35>,<52,51,67>,<52,53,37>,<52,68,69>,<52,69,53>,<53,69,70>,<53,70,54>,<54,70,71>,<54,71,55>,<55,56,40>,<56,55,71>,<56,72,73>,<56,73,57>,<57,58,42>,<57,73,58>,<58,59,43>,<58,74,59>,<59,75,60>,<60,61,45>,<60,76,77>,<61,62,46>,<61,77,78>,<62,63,47>,<62,78,79>,<63,48,32>,<63,79,64>,<64,48,63>,<64,65,49>,<64,80,65>,<65,66,50>,<65,81,82>,<65,82,66>,<66,67,51>,<66,82,83>,<66,83,67>,<67,68,52>,<67,83,84>,<67,84,68>,<69,68,84>,<70,69,85>,<71,70,86>,<71,72,56>,<72,71,87>,<72,88,89>,<73,74,58>,<73,89,90>,<74,75,59>,<74,90,91>,<75,76,60>,<75,91,92>,<76,92,77>,<77,61,60>,<77,93,78>,<78,62,61>,<78,94,79>,<79,63,62>,<79,95,80>,<80,64,79>,<80,81,65>,<80,96,81>,<81,97,98>,<81,98,82>,<82,98,99>,<82,99,83>,<83,99,84>,<84,85,69>,<84,100,101>,<84,101,85>,<85,86,70>,<85,101,102>,<85,102,86>,<86,87,71>,<86,102,103>,<86,103,87>,<87,88,72>,<87,103,104>,<87,104,88>,<89,73,72>,<89,88,104>,<90,74,73>,<90,89,105>,<91,75,74>,<91,90,106>,<92,76,75>,<92,91,107>,<92,93,77>,<92,108,109>,<93,94,78>,<93,109,94>,<94,95,79>,<94,110,95>,<95,111,96>,<96,80,95>,<96,97,81>,<96,112,97>,<97,113,98>,<98,114,99>,<99,100,84>,<99,115,100>,<100,116,117>,<100,117,101>,<102,101,117>,<103,102,118>,<103,119,120>,<103,120,104>,<104,105,89>,<104,120,121>,<104,121,105>,<105,106,90>,<105,121,122>,<106,107,91>,<106,122,123>,<107,108,92>,<108,107,123>,<108,124,125>,<109,93,92>,<109,110,94>,<109,125,126>,<110,111,95>,<110,126,127>,<111,127,112>,<112,0,1>,<112,96,111>,<112,113,97>,<112,127,15>,<113,1,2>,<113,114,98>,<114,2,3>,<114,115,99>,<115,3,4>,<115,116,100>,<117,116,4>,<117,118,102>,<118,117,5>,<118,119,103>,<119,7,8>,<119,118,6>,<121,120,8>,<122,106,105>,<123,107,106>,<123,124,108>,<125,109,108>,<125,124,12>,<126,110,109>,<126,125,13>,<127,111,110>,<127,126,14>}
}

#declare mozzo1 = mesh2 {
vertex_vectors {114,<-0.649805,0.264840,-0.753521>,<-0.641262,0.264840,-0.728353>,<-0.643000,0.264840,-0.701832>,<-0.654755,0.264840,-0.677995>,<-0.674738,0.264840,-0.660470>,<-0.699905,0.264840,-0.651927>,<-0.726427,0.264840,-0.653665>,<-0.750264,0.264840,-0.665421>,<-0.767788,0.264840,-0.685403>,<-0.776331,0.264840,-0.710571>,<-0.774593,0.264840,-0.737092>,<-0.762838,0.264840,-0.760929>,<-0.742855,0.264840,-0.778454>,<-0.717688,0.264840,-0.786997>,<-0.691166,0.264840,-0.785259>,<-0.667329,0.264840,-0.773503>,<-0.599794,0.226254,-0.782394>,<-0.584008,0.226254,-0.735891>,<-0.587220,0.226254,-0.686886>,<-0.608941,0.226254,-0.642840>,<-0.645864,0.226254,-0.610460>,<-0.692368,0.226254,-0.594674>,<-0.741373,0.226254,-0.597886>,<-0.785418,0.226254,-0.619607>,<-0.817799,0.226254,-0.656529>,<-0.833585,0.226254,-0.703033>,<-0.830373,0.226254,-0.752038>,<-0.808652,0.226254,-0.796084>,<-0.771729,0.226254,-0.828464>,<-0.725225,0.226254,-0.844250>,<-0.676220,0.226254,-0.841038>,<-0.632175,0.226254,-0.819317>,<-0.566378,0.168507,-0.801687>,<-0.545753,0.168507,-0.740927>,<-0.549949,0.168507,-0.676899>,<-0.578329,0.168507,-0.619351>,<-0.626571,0.168507,-0.577044>,<-0.687331,0.168507,-0.556418>,<-0.751359,0.168507,-0.560615>,<-0.808908,0.168507,-0.588995>,<-0.851215,0.168507,-0.637237>,<-0.871840,0.168507,-0.697997>,<-0.867644,0.168507,-0.762025>,<-0.839264,0.168507,-0.819573>,<-0.791022,0.168507,-0.861880>,<-0.730262,0.168507,-0.882506>,<-0.666234,0.168507,-0.878309>,<-0.608685,0.168507,-0.849929>,<-0.554644,0.100389,-0.808462>,<-0.532319,0.100389,-0.742696>,<-0.536862,0.100389,-0.673392>,<-0.567580,0.100389,-0.611102>,<-0.619797,0.100389,-0.565309>,<-0.685563,0.100389,-0.542985>,<-0.754866,0.100389,-0.547527>,<-0.817156,0.100389,-0.578245>,<-0.862949,0.100389,-0.630462>,<-0.885274,0.100389,-0.696228>,<-0.880731,0.100389,-0.765532>,<-0.850013,0.100389,-0.827822>,<-0.797797,0.100389,-0.873615>,<-0.732030,0.100389,-0.895939>,<-0.662727,0.100389,-0.891397>,<-0.600437,0.100389,-0.860679>,<-0.566378,3.22717e-2,-0.801687>,<-0.545753,3.22717e-2,-0.740927>,<-0.549949,3.22717e-2,-0.676899>,<-0.578329,3.22717e-2,-0.619351>,<-0.626571,3.22717e-2,-0.577044>,<-0.687331,3.22717e-2,-0.556418>,<-0.751359,3.22717e-2,-0.560615>,<-0.808908,3.22717e-2,-0.588995>,<-0.851215,3.22717e-2,-0.637237>,<-0.871840,3.22717e-2,-0.697997>,<-0.867644,3.22717e-2,-0.762025>,<-0.839264,3.22717e-2,-0.819573>,<-0.791022,3.22717e-2,-0.861880>,<-0.730262,3.22717e-2,-0.882506>,<-0.666234,3.22717e-2,-0.878309>,<-0.608685,3.22717e-2,-0.849929>,<-0.599794,-2.54756e-2,-0.782394>,<-0.584008,-2.54756e-2,-0.735891>,<-0.587220,-2.54756e-2,-0.686886>,<-0.608941,-2.54756e-2,-0.642840>,<-0.645864,-2.54756e-2,-0.610460>,<-0.692368,-2.54756e-2,-0.594674>,<-0.741373,-2.54756e-2,-0.597886>,<-0.785418,-2.54756e-2,-0.619607>,<-0.817799,-2.54756e-2,-0.656529>,<-0.833585,-2.54756e-2,-0.703033>,<-0.830373,-2.54756e-2,-0.752038>,<-0.808652,-2.54756e-2,-0.796084>,<-0.771729,-2.54756e-2,-0.828464>,<-0.725225,-2.54756e-2,-0.844250>,<-0.676220,-2.54756e-2,-0.841038>,<-0.632175,-2.54756e-2,-0.819317>,<-0.649805,-6.40612e-2,-0.753521>,<-0.641262,-6.40612e-2,-0.728353>,<-0.643000,-6.40612e-2,-0.701832>,<-0.654755,-6.40612e-2,-0.677995>,<-0.674738,-6.40612e-2,-0.660470>,<-0.699905,-6.40612e-2,-0.651927>,<-0.726427,-6.40612e-2,-0.653665>,<-0.750264,-6.40612e-2,-0.665421>,<-0.767788,-6.40612e-2,-0.685403>,<-0.776331,-6.40612e-2,-0.710571>,<-0.774593,-6.40612e-2,-0.737092>,<-0.762838,-6.40612e-2,-0.760929>,<-0.742855,-6.40612e-2,-0.778454>,<-0.717688,-6.40612e-2,-0.786997>,<-0.691166,-6.40612e-2,-0.785259>,<-0.667329,-6.40612e-2,-0.773503>,<-0.708797,0.278389,-0.719462>,<-0.708797,-7.76106e-2,-0.719462>}
normal_vectors {114,<0.373698,0.907921,-0.189816>,<0.417891,0.907921,-3.23586e-2>,<0.369172,0.924082,9.89193e-2>,<0.351097,0.896745,0.269406>,<0.189816,0.907921,0.373698>,<4.98864e-2,0.924082,0.378925>,<-8.66275e-2,0.907921,0.410093>,<-0.269406,0.896745,0.351097>,<-0.373698,0.907921,0.189816>,<-0.378925,0.924082,4.98864e-2>,<-0.410093,0.907921,-8.66275e-2>,<-0.351097,0.896745,-0.269406>,<-0.189816,0.907921,-0.373698>,<-3.23586e-2,0.907921,-0.417891>,<9.89193e-2,0.924082,-0.369172>,<0.269406,0.896745,-0.351097>,<0.616470,0.707599,-0.345352>,<0.701705,0.707599,-8.31508e-2>,<0.635855,0.752769,0.170377>,<0.602575,0.678577,0.420044>,<0.377149,0.687172,0.620929>,<8.59234e-2,0.752769,0.652653>,<-0.174030,0.707599,0.684848>,<-0.420044,0.678577,0.602575>,<-0.620929,0.687172,0.377149>,<-0.652653,0.752769,8.59234e-2>,<-0.684848,0.707599,-0.174030>,<-0.602575,0.678577,-0.420044>,<-0.377149,0.687172,-0.620929>,<-8.31508e-2,0.707599,-0.701705>,<0.170377,0.752769,-0.635855>,<0.457732,0.659268,-0.596529>,<0.802367,0.383155,-0.457602>,<0.916407,0.383155,-0.115717>,<0.873660,0.409068,0.263404>,<0.694223,0.382443,0.609748>,<0.434399,0.345848,0.831677>,<0.116995,0.443376,0.888667>,<-0.234342,0.383155,0.893463>,<-0.587693,0.356654,0.726234>,<-0.799932,0.383160,0.461841>,<-0.900567,0.409068,0.147115>,<-0.893463,0.383155,-0.234342>,<-0.735773,0.383155,-0.558417>,<-0.473513,0.321155,-0.820149>,<-0.115717,0.383155,-0.916407>,<0.263404,0.409068,-0.873660>,<0.602132,0.345848,-0.719601>,<0.851130,-2.83931e-2,-0.524186>,<0.984695,3.97197e-2,-0.169700>,<0.980933,7.67191e-17,0.194347>,<0.809998,-2.83931e-2,0.585745>,<0.533609,3.97197e-2,0.844798>,<0.130526,6.12698e-17,0.991445>,<-0.296777,3.97197e-2,0.954121>,<-0.607428,-6.61589e-2,0.791615>,<-0.864128,6.61589e-2,0.498905>,<-0.994351,-2.83931e-2,0.102271>,<-0.946686,9.11040e-17,-0.322157>,<-0.751340,1.10284e-16,-0.659915>,<-0.464812,-3.97197e-2,-0.884518>,<-0.169700,3.97197e-2,-0.984695>,<0.231185,-2.83931e-2,-0.972495>,<0.576289,3.97197e-2,-0.816281>,<0.799932,-0.383160,-0.461841>,<0.922783,-0.356654,-0.145840>,<0.873660,-0.409068,0.263404>,<0.732806,-0.383160,0.562302>,<0.487872,-0.356654,0.796730>,<0.116995,-0.443376,0.888667>,<-0.265040,-0.356654,0.895853>,<-0.562302,-0.383160,0.732806>,<-0.796730,-0.356654,0.487872>,<-0.888667,-0.443376,0.116995>,<-0.893463,-0.383155,-0.234342>,<-0.735773,-0.383155,-0.558417>,<-0.503054,-0.345848,-0.792039>,<-0.145840,-0.356654,-0.922783>,<0.231989,-0.443376,-0.865794>,<0.587693,-0.356654,-0.726234>,<0.620929,-0.687172,-0.377149>,<0.701705,-0.707599,-8.31508e-2>,<0.635855,-0.752769,0.170377>,<0.596529,-0.659268,0.457732>,<0.345352,-0.707599,0.616470>,<8.59234e-2,-0.752769,0.652653>,<-0.174030,-0.707599,0.684848>,<-0.457732,-0.659268,0.596529>,<-0.616470,-0.707599,0.345352>,<-0.652653,-0.752769,8.59234e-2>,<-0.684848,-0.707599,-0.174030>,<-0.602575,-0.678577,-0.420044>,<-0.377149,-0.687172,-0.620929>,<-8.31508e-2,-0.707599,-0.701705>,<0.170377,-0.752769,-0.635855>,<0.420044,-0.678577,-0.602575>,<0.373698,-0.907921,-0.189816>,<0.417891,-0.907921,-3.23586e-2>,<0.369172,-0.924082,9.89193e-2>,<0.351097,-0.896745,0.269406>,<0.189816,-0.907921,0.373698>,<4.98864e-2,-0.924082,0.378925>,<-8.66275e-2,-0.907921,0.410093>,<-0.269406,-0.896745,0.351097>,<-0.373698,-0.907921,0.189816>,<-0.378925,-0.924082,4.98864e-2>,<-0.410093,-0.907921,-8.66275e-2>,<-0.351097,-0.896745,-0.269406>,<-0.189816,-0.907921,-0.373698>,<-3.23586e-2,-0.907921,-0.417891>,<9.89193e-2,-0.924082,-0.369172>,<0.269406,-0.896745,-0.351097>,<-5.77033e-16,1.00000,-5.48712e-17>,<-5.71723e-16,-1.00000,1.41603e-17>}
texture_list { 11,
	texture { vetro_WingsMat }
	texture { pneumatici_WingsMat }
	texture { occhiali_WingsMat }
	texture { occhi_WingsMat }
	texture { nari_WingsMat }
	texture { mozzi_WingsMat }
	texture { denti_WingsMat }
	texture { casco_WingsMat }
	texture { Verdolino_WingsMat }
	texture { Giallino_WingsMat }
	texture { Corpo_WingsMat }
}
face_indices {224,<0,16,15>,5,<0,112,1>,5,<1,17,0>,5,<1,112,2>,5,<2,18,1>,5,<2,112,3>,5,<3,4,20>,5,<3,19,18>,5,<3,112,4>,5,<4,5,21>,5,<4,112,5>,5,<5,112,6>,5,<6,21,5>,5,<6,22,21>,5,<6,112,7>,5,<7,8,24>,5,<7,22,6>,5,<7,23,22>,5,<7,112,8>,5,<8,9,25>,5,<8,112,9>,5,<9,112,10>,5,<10,25,9>,5,<10,26,25>,5,<10,112,11>,5,<11,26,10>,5,<11,27,26>,5,<11,112,12>,5,<12,28,11>,5,<12,112,13>,5,<13,29,12>,5,<13,112,14>,5,<14,30,13>,5,<14,112,15>,5,<15,31,30>,5,<15,112,0>,5,<16,31,15>,5,<17,16,0>,5,<17,33,16>,5,<18,2,3>,5,<18,17,1>,5,<18,34,17>,5,<19,35,34>,5,<20,19,3>,5,<20,21,37>,5,<20,36,35>,5,<21,20,4>,5,<22,37,21>,5,<22,38,37>,5,<23,38,22>,5,<23,39,38>,5,<24,23,7>,5,<24,25,41>,5,<24,40,39>,5,<25,24,8>,5,<26,41,25>,5,<26,42,41>,5,<27,42,26>,5,<27,43,42>,5,<28,27,11>,5,<28,44,43>,5,<29,28,12>,5,<29,45,28>,5,<30,14,15>,5,<30,29,13>,5,<30,46,29>,5,<31,16,32>,5,<31,47,46>,5,<32,33,49>,5,<32,47,31>,5,<33,32,16>,5,<34,18,19>,5,<34,33,17>,5,<34,35,51>,5,<34,50,33>,5,<35,19,20>,5,<35,36,52>,5,<36,37,53>,5,<37,36,20>,5,<38,53,37>,5,<38,54,53>,5,<39,23,24>,5,<39,40,56>,5,<39,55,54>,5,<41,40,24>,5,<41,57,56>,5,<42,57,41>,5,<42,58,57>,5,<43,27,28>,5,<43,59,58>,5,<44,45,61>,5,<44,60,59>,5,<45,44,28>,5,<46,30,31>,5,<46,45,29>,5,<46,47,63>,5,<46,62,45>,5,<47,32,48>,5,<48,49,65>,5,<48,63,47>,5,<48,64,79>,5,<49,48,32>,5,<50,49,33>,5,<50,66,65>,5,<51,50,34>,5,<51,52,68>,5,<51,67,66>,5,<52,51,35>,5,<53,52,36>,5,<53,54,70>,5,<53,69,68>,5,<54,38,39>,5,<55,56,72>,5,<55,71,70>,5,<56,40,41>,5,<56,55,39>,5,<57,58,74>,5,<57,73,72>,5,<58,42,43>,5,<58,59,75>,5,<59,43,44>,5,<59,60,76>,5,<60,61,77>,5,<61,60,44>,5,<62,61,45>,5,<62,63,79>,5,<62,78,77>,5,<63,62,46>,5,<65,49,50>,5,<65,64,48>,5,<65,81,80>,5,<66,50,51>,5,<66,82,81>,5,<67,83,66>,5,<68,52,53>,5,<68,67,51>,5,<68,84,83>,5,<69,70,86>,5,<69,84,68>,5,<69,85,84>,5,<70,54,55>,5,<70,69,53>,5,<70,71,87>,5,<72,56,57>,5,<72,71,55>,5,<72,88,87>,5,<73,74,90>,5,<73,88,72>,5,<73,89,88>,5,<74,73,57>,5,<74,75,91>,5,<75,74,58>,5,<75,76,92>,5,<76,75,59>,5,<77,61,62>,5,<77,76,60>,5,<77,93,92>,5,<78,94,93>,5,<79,63,48>,5,<79,64,80>,5,<79,78,62>,5,<79,95,78>,5,<80,64,65>,5,<80,95,79>,5,<80,96,111>,5,<81,65,66>,5,<81,97,96>,5,<82,98,97>,5,<83,67,68>,5,<83,82,66>,5,<83,99,82>,5,<84,99,83>,5,<84,100,99>,5,<85,86,102>,5,<85,100,84>,5,<85,101,100>,5,<86,85,69>,5,<86,87,103>,5,<87,71,72>,5,<87,86,70>,5,<88,103,87>,5,<88,104,103>,5,<89,90,106>,5,<89,104,88>,5,<89,105,104>,5,<90,89,73>,5,<90,91,107>,5,<91,90,74>,5,<92,76,77>,5,<92,91,75>,5,<92,108,107>,5,<93,77,78>,5,<93,109,108>,5,<94,110,109>,5,<95,94,78>,5,<95,111,94>,5,<96,80,81>,5,<96,113,111>,5,<97,81,82>,5,<97,113,96>,5,<98,113,97>,5,<99,98,82>,5,<99,113,98>,5,<100,113,99>,5,<101,113,100>,5,<102,101,85>,5,<102,113,101>,5,<103,102,86>,5,<103,113,102>,5,<104,113,103>,5,<105,113,104>,5,<106,105,89>,5,<106,113,105>,5,<107,91,92>,5,<107,106,90>,5,<107,113,106>,5,<108,92,93>,5,<108,113,107>,5,<109,93,94>,5,<109,113,108>,5,<110,113,109>,5,<111,95,80>,5,<111,110,94>,5,<111,113,110>,5}
normal_indices {224,<0,16,15>,<0,112,1>,<1,17,0>,<1,112,2>,<2,18,1>,<2,112,3>,<3,4,20>,<3,19,18>,<3,112,4>,<4,5,21>,<4,112,5>,<5,112,6>,<6,21,5>,<6,22,21>,<6,112,7>,<7,8,24>,<7,22,6>,<7,23,22>,<7,112,8>,<8,9,25>,<8,112,9>,<9,112,10>,<10,25,9>,<10,26,25>,<10,112,11>,<11,26,10>,<11,27,26>,<11,112,12>,<12,28,11>,<12,112,13>,<13,29,12>,<13,112,14>,<14,30,13>,<14,112,15>,<15,31,30>,<15,112,0>,<16,31,15>,<17,16,0>,<17,33,16>,<18,2,3>,<18,17,1>,<18,34,17>,<19,35,34>,<20,19,3>,<20,21,37>,<20,36,35>,<21,20,4>,<22,37,21>,<22,38,37>,<23,38,22>,<23,39,38>,<24,23,7>,<24,25,41>,<24,40,39>,<25,24,8>,<26,41,25>,<26,42,41>,<27,42,26>,<27,43,42>,<28,27,11>,<28,44,43>,<29,28,12>,<29,45,28>,<30,14,15>,<30,29,13>,<30,46,29>,<31,16,32>,<31,47,46>,<32,33,49>,<32,47,31>,<33,32,16>,<34,18,19>,<34,33,17>,<34,35,51>,<34,50,33>,<35,19,20>,<35,36,52>,<36,37,53>,<37,36,20>,<38,53,37>,<38,54,53>,<39,23,24>,<39,40,56>,<39,55,54>,<41,40,24>,<41,57,56>,<42,57,41>,<42,58,57>,<43,27,28>,<43,59,58>,<44,45,61>,<44,60,59>,<45,44,28>,<46,30,31>,<46,45,29>,<46,47,63>,<46,62,45>,<47,32,48>,<48,49,65>,<48,63,47>,<48,64,79>,<49,48,32>,<50,49,33>,<50,66,65>,<51,50,34>,<51,52,68>,<51,67,66>,<52,51,35>,<53,52,36>,<53,54,70>,<53,69,68>,<54,38,39>,<55,56,72>,<55,71,70>,<56,40,41>,<56,55,39>,<57,58,74>,<57,73,72>,<58,42,43>,<58,59,75>,<59,43,44>,<59,60,76>,<60,61,77>,<61,60,44>,<62,61,45>,<62,63,79>,<62,78,77>,<63,62,46>,<65,49,50>,<65,64,48>,<65,81,80>,<66,50,51>,<66,82,81>,<67,83,66>,<68,52,53>,<68,67,51>,<68,84,83>,<69,70,86>,<69,84,68>,<69,85,84>,<70,54,55>,<70,69,53>,<70,71,87>,<72,56,57>,<72,71,55>,<72,88,87>,<73,74,90>,<73,88,72>,<73,89,88>,<74,73,57>,<74,75,91>,<75,74,58>,<75,76,92>,<76,75,59>,<77,61,62>,<77,76,60>,<77,93,92>,<78,94,93>,<79,63,48>,<79,64,80>,<79,78,62>,<79,95,78>,<80,64,65>,<80,95,79>,<80,96,111>,<81,65,66>,<81,97,96>,<82,98,97>,<83,67,68>,<83,82,66>,<83,99,82>,<84,99,83>,<84,100,99>,<85,86,102>,<85,100,84>,<85,101,100>,<86,85,69>,<86,87,103>,<87,71,72>,<87,86,70>,<88,103,87>,<88,104,103>,<89,90,106>,<89,104,88>,<89,105,104>,<90,89,73>,<90,91,107>,<91,90,74>,<92,76,77>,<92,91,75>,<92,108,107>,<93,77,78>,<93,109,108>,<94,110,109>,<95,94,78>,<95,111,94>,<96,80,81>,<96,113,111>,<97,81,82>,<97,113,96>,<98,113,97>,<99,98,82>,<99,113,98>,<100,113,99>,<101,113,100>,<102,101,85>,<102,113,101>,<103,102,86>,<103,113,102>,<104,113,103>,<105,113,104>,<106,105,89>,<106,113,105>,<107,91,92>,<107,106,90>,<107,113,106>,<108,92,93>,<108,113,107>,<109,93,94>,<109,113,108>,<110,113,109>,<111,95,80>,<111,110,94>,<111,113,110>}
}

#declare ruota1 = mesh2 {
vertex_vectors {128,<-0.933401,0.100389,-0.592686>,<-0.916304,0.199639,-0.602557>,<-0.867616,0.283778,-0.630667>,<-0.794749,0.339999,-0.672736>,<-0.708797,0.359740,-0.722361>,<-0.622844,0.339999,-0.771986>,<-0.549977,0.283778,-0.814056>,<-0.501289,0.199639,-0.842166>,<-0.484192,0.100389,-0.852037>,<-0.501289,1.14004e-3,-0.842166>,<-0.549977,-8.29995e-2,-0.814056>,<-0.622844,-0.139220,-0.771986>,<-0.708797,-0.158962,-0.722361>,<-0.794749,-0.139220,-0.672736>,<-0.867616,-8.29995e-2,-0.630667>,<-0.916304,1.14004e-3,-0.602557>,<-0.937661,0.100389,-0.622886>,<-0.921316,0.195272,-0.632323>,<-0.874770,0.275709,-0.659196>,<-0.805109,0.329456,-0.699415>,<-0.722939,0.348329,-0.746856>,<-0.640768,0.329456,-0.794297>,<-0.571107,0.275709,-0.834516>,<-0.524561,0.195272,-0.861389>,<-0.508216,0.100389,-0.870826>,<-0.524561,5.50689e-3,-0.861389>,<-0.571107,-7.49306e-2,-0.834516>,<-0.640768,-0.128677,-0.794297>,<-0.722939,-0.147551,-0.746856>,<-0.805109,-0.128677,-0.699415>,<-0.874770,-7.49306e-2,-0.659196>,<-0.921316,5.50689e-3,-0.632323>,<-0.919661,0.100389,-0.646807>,<-0.905132,0.184729,-0.655195>,<-0.863758,0.256229,-0.679082>,<-0.801837,0.304004,-0.714832>,<-0.728797,0.320780,-0.757002>,<-0.655756,0.304004,-0.799172>,<-0.593835,0.256229,-0.834922>,<-0.552461,0.184729,-0.858809>,<-0.537932,0.100389,-0.867198>,<-0.552461,1.60494e-2,-0.858809>,<-0.593835,-5.54506e-2,-0.834922>,<-0.655756,-0.103225,-0.799172>,<-0.728797,-0.120002,-0.757002>,<-0.801837,-0.103225,-0.714832>,<-0.863758,-5.54506e-2,-0.679082>,<-0.905132,1.60494e-2,-0.655195>,<-0.889945,0.100389,-0.650435>,<-0.877232,0.174187,-0.657775>,<-0.841030,0.236749,-0.678676>,<-0.786849,0.278552,-0.709957>,<-0.722939,0.293232,-0.746856>,<-0.659028,0.278552,-0.783755>,<-0.604847,0.236749,-0.815036>,<-0.568645,0.174187,-0.835937>,<-0.555932,0.100389,-0.843277>,<-0.568645,2.65919e-2,-0.835937>,<-0.604847,-3.59706e-2,-0.815036>,<-0.659028,-7.77735e-2,-0.783755>,<-0.722939,-9.24528e-2,-0.746856>,<-0.786849,-7.77735e-2,-0.709957>,<-0.841030,-3.59706e-2,-0.678676>,<-0.877232,2.65919e-2,-0.657775>,<-0.865920,0.100389,-0.631646>,<-0.853960,0.169820,-0.638551>,<-0.819900,0.228681,-0.658216>,<-0.768925,0.268010,-0.687646>,<-0.708797,0.281820,-0.722361>,<-0.648668,0.268010,-0.757076>,<-0.597693,0.228681,-0.786507>,<-0.563633,0.169820,-0.806171>,<-0.551673,0.100389,-0.813077>,<-0.563633,3.09587e-2,-0.806171>,<-0.597693,-2.79017e-2,-0.786507>,<-0.648668,-6.72310e-2,-0.757076>,<-0.708797,-8.10417e-2,-0.722361>,<-0.768925,-6.72310e-2,-0.687646>,<-0.819900,-2.79017e-2,-0.658216>,<-0.853960,3.09587e-2,-0.638551>,<-0.861661,0.100389,-0.601445>,<-0.848948,0.174187,-0.608785>,<-0.812746,0.236749,-0.629686>,<-0.758565,0.278552,-0.660967>,<-0.694654,0.293232,-0.697866>,<-0.630744,0.278552,-0.734765>,<-0.576563,0.236749,-0.766046>,<-0.540361,0.174187,-0.786948>,<-0.527648,0.100389,-0.794287>,<-0.540361,2.65919e-2,-0.786948>,<-0.576563,-3.59706e-2,-0.766046>,<-0.630744,-7.77735e-2,-0.734765>,<-0.694654,-9.24528e-2,-0.697866>,<-0.758565,-7.77735e-2,-0.660967>,<-0.812746,-3.59706e-2,-0.629686>,<-0.848948,2.65919e-2,-0.608785>,<-0.879661,0.100389,-0.577525>,<-0.865132,0.184729,-0.585913>,<-0.823758,0.256229,-0.609800>,<-0.761837,0.304004,-0.645550>,<-0.688797,0.320780,-0.687720>,<-0.615756,0.304004,-0.729890>,<-0.553835,0.256229,-0.765640>,<-0.512461,0.184729,-0.789527>,<-0.497932,0.100389,-0.797916>,<-0.512461,1.60494e-2,-0.789527>,<-0.553835,-5.54506e-2,-0.765640>,<-0.615756,-0.103225,-0.729890>,<-0.688797,-0.120002,-0.687720>,<-0.761837,-0.103225,-0.645550>,<-0.823758,-5.54506e-2,-0.609800>,<-0.865132,1.60494e-2,-0.585913>,<-0.909377,0.100389,-0.573896>,<-0.893032,0.195272,-0.583333>,<-0.846486,0.275709,-0.610206>,<-0.776825,0.329456,-0.650425>,<-0.694654,0.348329,-0.697866>,<-0.612484,0.329456,-0.745307>,<-0.542823,0.275709,-0.785526>,<-0.496277,0.195272,-0.812400>,<-0.479932,0.100389,-0.821836>,<-0.496277,5.50689e-3,-0.812400>,<-0.542823,-7.49306e-2,-0.785526>,<-0.612484,-0.128677,-0.745307>,<-0.694654,-0.147551,-0.697866>,<-0.776825,-0.128677,-0.650425>,<-0.846486,-7.49306e-2,-0.610206>,<-0.893032,5.50689e-3,-0.583333>}
normal_vectors {128,<0.791658,-8.04339e-17,-0.610964>,<0.850198,-0.344538,-0.398066>,<0.651545,-0.658776,-0.376169>,<0.383621,-0.896538,-0.221484>,<4.10862e-16,-1.00000,-3.04343e-17>,<-0.383621,-0.896538,0.221484>,<-0.651545,-0.658776,0.376169>,<-0.850198,-0.344538,0.398066>,<-0.791658,4.02170e-17,0.610964>,<-0.850198,0.344538,0.398066>,<-0.651545,0.658776,0.376169>,<-0.383621,0.896538,0.221484>,<-5.15956e-16,1.00000,1.74997e-16>,<0.383621,0.896538,-0.221484>,<0.651545,0.658776,-0.376169>,<0.850198,0.344538,-0.398066>,<0.980748,-1.21108e-2,0.194900>,<0.904022,-0.315588,0.288353>,<0.757326,-0.535997,0.373049>,<0.548749,-0.674805,0.493470>,<0.351257,-0.711671,0.608394>,<0.172451,-0.628628,0.758345>,<-7.29584e-2,-0.516506,0.853170>,<-0.341934,-0.306629,0.888290>,<-0.184684,-1.68793e-2,0.982653>,<-0.276033,0.276552,0.920503>,<-7.29584e-2,0.516506,0.853170>,<0.172451,0.628628,0.758345>,<0.351257,0.711671,0.608394>,<0.548749,0.674805,0.493470>,<0.757326,0.535997,0.373049>,<0.897179,0.281995,0.339923>,<0.499801,2.81860e-2,0.865681>,<0.571514,-1.68551e-2,0.820419>,<0.500000,2.31935e-15,0.866025>,<0.488598,6.06367e-2,0.870399>,<0.495051,-0.140354,0.857453>,<0.512727,8.47361e-2,0.854360>,<0.500000,2.22355e-15,0.866025>,<0.446531,-1.20614e-2,0.894687>,<0.551556,1.20614e-2,0.834050>,<0.500000,-2.36977e-16,0.866025>,<0.500000,-1.65380e-15,0.866025>,<0.512727,-8.47361e-2,0.854360>,<0.495051,0.140354,0.857453>,<0.488598,-6.06367e-2,0.870399>,<0.500000,-2.41515e-15,0.866025>,<0.424747,-1.68551e-2,0.905155>,<-0.321586,-1.21108e-2,0.946803>,<-9.09340e-2,0.233137,0.968183>,<-9.61131e-2,0.489769,0.866538>,<3.46422e-2,0.693210,0.719903>,<0.351257,0.711671,0.608394>,<0.624174,0.638730,0.449924>,<0.815053,0.469339,0.339720>,<0.935264,0.228496,0.270316>,<0.967582,1.98718e-15,0.252559>,<0.935264,-0.228496,0.270316>,<0.815053,-0.469339,0.339720>,<0.624174,-0.638730,0.449924>,<0.351257,-0.711671,0.608394>,<3.46422e-2,-0.693210,0.719903>,<-9.61131e-2,-0.489769,0.866538>,<-0.136157,-0.264824,0.954636>,<-0.924940,2.36275e-16,0.380114>,<-0.760300,0.408095,0.505374>,<-0.570517,0.752339,0.329388>,<-0.277754,0.947173,0.160361>,<1.53693e-15,1.00000,-1.82606e-16>,<0.277754,0.947173,-0.160361>,<0.570517,0.752339,-0.329388>,<0.760300,0.408095,-0.505374>,<0.893001,-2.83576e-2,-0.449160>,<0.776424,-0.442968,-0.448269>,<0.570517,-0.752339,-0.329388>,<0.277754,-0.947173,-0.160361>,<-6.84771e-16,-1.00000,1.14889e-15>,<-0.277754,-0.947173,0.160361>,<-0.570517,-0.752339,0.329388>,<-0.760300,-0.408095,0.505374>,<-0.967582,9.86006e-17,-0.252559>,<-0.935264,0.228496,-0.270316>,<-0.815053,0.469339,-0.339720>,<-0.624174,0.638730,-0.449924>,<-0.351257,0.711671,-0.608394>,<-3.46422e-2,0.693210,-0.719903>,<9.61131e-2,0.489769,-0.866538>,<9.09340e-2,0.233137,-0.968183>,<0.343602,3.95544e-2,-0.938282>,<0.172922,-0.229826,-0.957746>,<9.61131e-2,-0.489769,-0.866538>,<-3.46422e-2,-0.693210,-0.719903>,<-0.351257,-0.711671,-0.608394>,<-0.624174,-0.638730,-0.449924>,<-0.815053,-0.469339,-0.339720>,<-0.935264,-0.228496,-0.270316>,<-0.616601,-2.02183e-16,-0.787276>,<-0.446531,-1.20614e-2,-0.894687>,<-0.500000,2.58154e-15,-0.866025>,<-0.512727,8.47361e-2,-0.854360>,<-0.495051,-0.140354,-0.857453>,<-0.488598,6.06367e-2,-0.870399>,<-0.500000,4.73955e-16,-0.866025>,<-0.571514,-1.68551e-2,-0.820419>,<-0.446531,1.20614e-2,-0.894687>,<-0.500000,9.68078e-16,-0.866025>,<-0.500000,-6.25217e-16,-0.866025>,<-0.488598,-6.06367e-2,-0.870399>,<-0.495051,0.140354,-0.857453>,<-0.512727,-8.47361e-2,-0.854360>,<-0.500000,-2.36977e-16,-0.866025>,<-0.446531,1.20614e-2,-0.894687>,<0.131095,-3.04746e-16,-0.991370>,<0.341934,-0.306629,-0.888290>,<7.29584e-2,-0.516506,-0.853170>,<-0.172451,-0.628628,-0.758345>,<-0.351257,-0.711671,-0.608394>,<-0.548749,-0.674805,-0.493470>,<-0.757326,-0.535997,-0.373049>,<-0.904022,-0.315588,-0.288353>,<-0.980748,-1.21108e-2,-0.194900>,<-0.897179,0.281995,-0.339923>,<-0.757326,0.535997,-0.373049>,<-0.548749,0.674805,-0.493470>,<-0.351257,0.711671,-0.608394>,<-0.172451,0.628628,-0.758345>,<7.29584e-2,0.516506,-0.853170>,<0.341934,0.306629,-0.888290>}
texture_list { 11,
	texture { vetro_WingsMat }
	texture { pneumatici_WingsMat }
	texture { occhiali_WingsMat }
	texture { occhi_WingsMat }
	texture { nari_WingsMat }
	texture { mozzi_WingsMat }
	texture { denti_WingsMat }
	texture { casco_WingsMat }
	texture { Verdolino_WingsMat }
	texture { Giallino_WingsMat }
	texture { Corpo_WingsMat }
}
face_indices {256,<0,1,113>,1,<0,16,1>,1,<0,112,127>,1,<0,127,15>,1,<1,17,2>,1,<2,18,3>,1,<2,114,113>,1,<3,19,4>,1,<3,115,114>,1,<4,5,117>,1,<4,20,21>,1,<4,21,5>,1,<4,116,115>,1,<5,6,118>,1,<5,21,22>,1,<5,22,6>,1,<6,7,119>,1,<6,22,23>,1,<6,23,7>,1,<7,8,120>,1,<8,7,23>,1,<8,24,25>,1,<8,25,9>,1,<9,25,10>,1,<9,121,120>,1,<10,26,11>,1,<10,122,121>,1,<11,27,12>,1,<11,123,122>,1,<12,13,125>,1,<12,28,29>,1,<12,29,13>,1,<12,124,123>,1,<13,14,126>,1,<13,29,30>,1,<13,30,14>,1,<14,15,127>,1,<14,30,31>,1,<14,31,15>,1,<15,16,0>,1,<15,31,16>,1,<16,17,1>,1,<16,32,33>,1,<17,18,2>,1,<17,33,34>,1,<18,19,3>,1,<18,34,35>,1,<19,20,4>,1,<19,35,36>,1,<21,20,36>,1,<21,37,38>,1,<21,38,22>,1,<22,38,39>,1,<22,39,23>,1,<23,24,8>,1,<24,23,39>,1,<25,24,40>,1,<25,26,10>,1,<25,41,26>,1,<26,27,11>,1,<26,42,27>,1,<27,28,12>,1,<27,43,44>,1,<27,44,28>,1,<28,44,29>,1,<29,45,30>,1,<30,46,31>,1,<31,47,32>,1,<32,16,31>,1,<32,48,49>,1,<33,17,16>,1,<34,18,17>,1,<34,33,49>,1,<35,19,18>,1,<35,34,50>,1,<35,51,52>,1,<36,20,19>,1,<36,37,21>,1,<37,36,52>,1,<38,37,53>,1,<39,38,54>,1,<39,40,24>,1,<40,39,55>,1,<40,41,25>,1,<40,56,57>,1,<40,57,41>,1,<41,42,26>,1,<41,57,58>,1,<41,58,42>,1,<42,43,27>,1,<42,58,59>,1,<42,59,43>,1,<43,59,60>,1,<43,60,44>,1,<44,45,29>,1,<44,60,45>,1,<45,46,30>,1,<45,61,62>,1,<46,47,31>,1,<46,62,63>,1,<47,63,48>,1,<48,32,47>,1,<48,64,65>,1,<49,33,32>,1,<49,50,34>,1,<50,49,65>,1,<50,51,35>,1,<51,50,66>,1,<52,36,35>,1,<52,51,67>,1,<52,53,37>,1,<52,68,69>,1,<53,54,38>,1,<53,69,70>,1,<54,55,39>,1,<54,70,71>,1,<55,56,40>,1,<55,71,72>,1,<57,56,72>,1,<58,57,73>,1,<59,58,74>,1,<60,59,75>,1,<60,61,45>,1,<60,76,77>,1,<61,77,78>,1,<62,46,45>,1,<62,78,79>,1,<63,47,46>,1,<63,79,48>,1,<64,79,95>,1,<64,80,81>,1,<65,49,48>,1,<65,66,50>,1,<65,81,82>,1,<66,67,51>,1,<66,82,83>,1,<67,68,52>,1,<67,83,84>,1,<69,53,52>,1,<69,68,84>,1,<70,54,53>,1,<70,69,85>,1,<71,55,54>,1,<71,70,86>,1,<71,87,88>,1,<71,88,72>,1,<72,56,55>,1,<72,73,57>,1,<72,88,89>,1,<72,89,73>,1,<73,74,58>,1,<73,89,90>,1,<74,75,59>,1,<74,90,91>,1,<75,76,60>,1,<75,91,92>,1,<77,61,60>,1,<77,76,92>,1,<78,62,61>,1,<78,77,93>,1,<79,63,62>,1,<79,64,48>,1,<79,78,94>,1,<80,96,81>,1,<81,65,64>,1,<81,97,82>,1,<82,66,65>,1,<82,98,83>,1,<83,67,66>,1,<83,99,84>,1,<84,68,67>,1,<84,85,69>,1,<84,100,101>,1,<84,101,85>,1,<85,86,70>,1,<86,85,101>,1,<86,87,71>,1,<87,86,102>,1,<87,103,104>,1,<87,104,88>,1,<89,88,104>,1,<89,105,106>,1,<90,74,73>,1,<90,106,107>,1,<91,75,74>,1,<92,76,75>,1,<92,91,107>,1,<92,93,77>,1,<92,108,109>,1,<93,94,78>,1,<93,109,110>,1,<94,95,79>,1,<94,110,111>,1,<95,80,64>,1,<95,111,96>,1,<96,80,95>,1,<96,97,81>,1,<96,112,97>,1,<97,98,82>,1,<97,113,114>,1,<97,114,98>,1,<98,99,83>,1,<98,114,115>,1,<98,115,99>,1,<99,100,84>,1,<99,115,100>,1,<100,116,117>,1,<100,117,101>,1,<101,102,86>,1,<101,117,118>,1,<101,118,102>,1,<102,103,87>,1,<102,118,119>,1,<102,119,103>,1,<103,119,120>,1,<103,120,104>,1,<104,105,89>,1,<104,120,121>,1,<104,121,105>,1,<106,90,89>,1,<106,105,121>,1,<107,91,90>,1,<107,106,122>,1,<107,108,92>,1,<108,107,123>,1,<108,124,125>,1,<109,93,92>,1,<109,125,110>,1,<110,94,93>,1,<110,126,111>,1,<111,95,94>,1,<111,127,112>,1,<112,96,111>,1,<112,113,97>,1,<113,1,2>,1,<113,112,0>,1,<114,2,3>,1,<115,3,4>,1,<115,116,100>,1,<117,116,4>,1,<118,117,5>,1,<119,118,6>,1,<120,8,9>,1,<120,119,7>,1,<121,9,10>,1,<121,122,106>,1,<122,10,11>,1,<122,123,107>,1,<123,11,12>,1,<123,124,108>,1,<125,109,108>,1,<125,124,12>,1,<125,126,110>,1,<126,125,13>,1,<126,127,111>,1,<127,126,14>,1}
normal_indices {256,<0,1,113>,<0,16,1>,<0,112,127>,<0,127,15>,<1,17,2>,<2,18,3>,<2,114,113>,<3,19,4>,<3,115,114>,<4,5,117>,<4,20,21>,<4,21,5>,<4,116,115>,<5,6,118>,<5,21,22>,<5,22,6>,<6,7,119>,<6,22,23>,<6,23,7>,<7,8,120>,<8,7,23>,<8,24,25>,<8,25,9>,<9,25,10>,<9,121,120>,<10,26,11>,<10,122,121>,<11,27,12>,<11,123,122>,<12,13,125>,<12,28,29>,<12,29,13>,<12,124,123>,<13,14,126>,<13,29,30>,<13,30,14>,<14,15,127>,<14,30,31>,<14,31,15>,<15,16,0>,<15,31,16>,<16,17,1>,<16,32,33>,<17,18,2>,<17,33,34>,<18,19,3>,<18,34,35>,<19,20,4>,<19,35,36>,<21,20,36>,<21,37,38>,<21,38,22>,<22,38,39>,<22,39,23>,<23,24,8>,<24,23,39>,<25,24,40>,<25,26,10>,<25,41,26>,<26,27,11>,<26,42,27>,<27,28,12>,<27,43,44>,<27,44,28>,<28,44,29>,<29,45,30>,<30,46,31>,<31,47,32>,<32,16,31>,<32,48,49>,<33,17,16>,<34,18,17>,<34,33,49>,<35,19,18>,<35,34,50>,<35,51,52>,<36,20,19>,<36,37,21>,<37,36,52>,<38,37,53>,<39,38,54>,<39,40,24>,<40,39,55>,<40,41,25>,<40,56,57>,<40,57,41>,<41,42,26>,<41,57,58>,<41,58,42>,<42,43,27>,<42,58,59>,<42,59,43>,<43,59,60>,<43,60,44>,<44,45,29>,<44,60,45>,<45,46,30>,<45,61,62>,<46,47,31>,<46,62,63>,<47,63,48>,<48,32,47>,<48,64,65>,<49,33,32>,<49,50,34>,<50,49,65>,<50,51,35>,<51,50,66>,<52,36,35>,<52,51,67>,<52,53,37>,<52,68,69>,<53,54,38>,<53,69,70>,<54,55,39>,<54,70,71>,<55,56,40>,<55,71,72>,<57,56,72>,<58,57,73>,<59,58,74>,<60,59,75>,<60,61,45>,<60,76,77>,<61,77,78>,<62,46,45>,<62,78,79>,<63,47,46>,<63,79,48>,<64,79,95>,<64,80,81>,<65,49,48>,<65,66,50>,<65,81,82>,<66,67,51>,<66,82,83>,<67,68,52>,<67,83,84>,<69,53,52>,<69,68,84>,<70,54,53>,<70,69,85>,<71,55,54>,<71,70,86>,<71,87,88>,<71,88,72>,<72,56,55>,<72,73,57>,<72,88,89>,<72,89,73>,<73,74,58>,<73,89,90>,<74,75,59>,<74,90,91>,<75,76,60>,<75,91,92>,<77,61,60>,<77,76,92>,<78,62,61>,<78,77,93>,<79,63,62>,<79,64,48>,<79,78,94>,<80,96,81>,<81,65,64>,<81,97,82>,<82,66,65>,<82,98,83>,<83,67,66>,<83,99,84>,<84,68,67>,<84,85,69>,<84,100,101>,<84,101,85>,<85,86,70>,<86,85,101>,<86,87,71>,<87,86,102>,<87,103,104>,<87,104,88>,<89,88,104>,<89,105,106>,<90,74,73>,<90,106,107>,<91,75,74>,<92,76,75>,<92,91,107>,<92,93,77>,<92,108,109>,<93,94,78>,<93,109,110>,<94,95,79>,<94,110,111>,<95,80,64>,<95,111,96>,<96,80,95>,<96,97,81>,<96,112,97>,<97,98,82>,<97,113,114>,<97,114,98>,<98,99,83>,<98,114,115>,<98,115,99>,<99,100,84>,<99,115,100>,<100,116,117>,<100,117,101>,<101,102,86>,<101,117,118>,<101,118,102>,<102,103,87>,<102,118,119>,<102,119,103>,<103,119,120>,<103,120,104>,<104,105,89>,<104,120,121>,<104,121,105>,<106,90,89>,<106,105,121>,<107,91,90>,<107,106,122>,<107,108,92>,<108,107,123>,<108,124,125>,<109,93,92>,<109,125,110>,<110,94,93>,<110,126,111>,<111,95,94>,<111,127,112>,<112,96,111>,<112,113,97>,<113,1,2>,<113,112,0>,<114,2,3>,<115,3,4>,<115,116,100>,<117,116,4>,<118,117,5>,<119,118,6>,<120,8,9>,<120,119,7>,<121,9,10>,<121,122,106>,<122,10,11>,<122,123,107>,<123,11,12>,<123,124,108>,<125,109,108>,<125,124,12>,<125,126,110>,<126,125,13>,<126,127,111>,<127,126,14>}
}

#declare Guga = mesh2 {
vertex_vectors {1464,<-1.53447e-16,0.464817,0.654480>,<0.749119,0.546739,2.18224e-16>,<-0.749119,0.546739,-2.25865e-16>,<-2.64469e-16,3.42383e-2,0.841151>,<0.450067,0.625434,0.446599>,<-0.450067,0.625434,0.446599>,<0.773671,-1.30248e-2,5.16909e-17>,<-0.773671,-1.30248e-2,-5.93314e-17>,<0.562381,4.18184e-2,0.570325>,<-9.79360e-17,0.869078,-3.82025e-18>,<-0.562381,4.18184e-2,0.570325>,<-0.516521,0.314278,0.512128>,<0.516521,0.314278,0.512128>,<-0.895344,0.266547,-2.25865e-16>,<-9.79360e-17,0.216326,0.735569>,<0.895344,0.266547,2.18224e-16>,<-1.25692e-16,0.700332,0.338670>,<-0.392837,0.765217,-5.93314e-17>,<0.392837,0.765217,5.16909e-17>,<-0.242701,0.792223,0.241151>,<0.242701,0.792223,0.241151>,<0.405157,0.566028,0.503351>,<6.70799e-2,0.440706,0.661127>,<7.42468e-2,0.263285,0.708293>,<0.440725,0.352443,0.546837>,<0.823761,0.316603,7.42814e-2>,<0.748917,0.523437,6.70602e-2>,<0.517853,0.580802,0.406474>,<0.565181,0.360448,0.442194>,<6.48249e-2,0.519344,0.599905>,<0.363829,0.640671,0.460001>,<0.239770,0.761943,0.297372>,<4.00478e-2,0.678792,0.381023>,<-0.683440,0.603482,6.57323e-2>,<-0.474363,0.655550,0.365238>,<-0.303884,0.774537,0.240865>,<-0.428379,0.752579,4.09101e-2>,<-6.70799e-2,0.440706,0.661127>,<-0.405157,0.566028,0.503351>,<-0.440725,0.352443,0.546837>,<-7.42468e-2,0.263285,0.708293>,<-0.517853,0.580802,0.406474>,<-0.758347,0.523437,6.70602e-2>,<-0.823761,0.316603,7.42814e-2>,<-0.565181,0.360448,0.442194>,<0.315682,0.802248,3.87992e-2>,<9.86546e-2,0.869501,3.87992e-2>,<0.235163,0.813597,0.175308>,<-3.76430e-2,0.743421,0.283370>,<-3.76430e-2,0.856519,9.25343e-2>,<-0.174069,0.800648,0.228960>,<7.49359e-2,0.193280,0.743778>,<8.49993e-2,5.17890e-2,0.849374>,<0.508704,6.44131e-2,0.634514>,<0.462227,0.260947,0.569971>,<0.654646,6.22530e-2,0.510431>,<0.975570,4.50500e-2,8.48792e-2>,<0.864378,0.231637,7.49360e-2>,<0.587699,0.267938,0.463523>,<-8.49993e-2,5.17890e-2,0.849374>,<-7.49359e-2,0.193280,0.743778>,<-0.462227,0.260947,0.569971>,<-0.508704,6.44131e-2,0.634514>,<-0.864378,0.231637,7.49360e-2>,<-0.975570,4.50500e-2,8.48792e-2>,<-0.654646,6.22530e-2,0.510431>,<-0.587699,0.267938,0.463523>,<3.76430e-2,0.856519,9.25343e-2>,<3.76430e-2,0.743421,0.283370>,<0.174069,0.800648,0.228960>,<-9.86546e-2,0.869501,3.87992e-2>,<-0.315682,0.802248,3.87992e-2>,<-0.235163,0.813597,0.175308>,<0.474363,0.655550,0.365238>,<0.683440,0.603482,6.57323e-2>,<0.428379,0.752579,4.09101e-2>,<0.303884,0.774537,0.240865>,<-0.363829,0.640671,0.460001>,<-6.48249e-2,0.519344,0.599905>,<-4.00478e-2,0.678792,0.381023>,<-0.239770,0.761943,0.297372>,<0.372965,0.526027,0.549944>,<0.119875,0.439077,0.666647>,<0.129287,0.304039,0.700605>,<0.394849,0.374993,0.582299>,<0.798513,0.355778,0.133675>,<0.753240,0.509270,0.124201>,<0.573409,0.549541,0.378440>,<0.610729,0.390062,0.400437>,<0.100865,0.574534,0.565030>,<0.305777,0.657955,0.470564>,<0.229356,0.752507,0.343050>,<6.81338e-2,0.685849,0.412729>,<-0.631448,0.649357,0.107187>,<-0.490370,0.683184,0.312479>,<-0.352875,0.774898,0.235837>,<-0.456721,0.754351,7.43719e-2>,<-0.119875,0.439077,0.666647>,<-0.372965,0.526027,0.549944>,<-0.394849,0.374993,0.582299>,<-0.129287,0.304039,0.700605>,<-0.573409,0.549541,0.378440>,<-0.753240,0.509270,0.124201>,<-0.798513,0.355778,0.133675>,<-0.610729,0.390062,0.400437>,<0.283813,0.833248,5.88232e-2>,<0.151306,0.874310,5.88232e-2>,<0.234652,0.840177,0.142169>,<-5.21365e-2,0.784092,0.262875>,<-5.21365e-2,0.853137,0.146372>,<-0.135423,0.819028,0.229658>,<0.134623,0.193830,0.753313>,<0.147369,8.24270e-2,0.824628>,<0.454032,9.97804e-2,0.672304>,<0.425376,0.235590,0.619176>,<0.704581,9.67509e-2,0.459440>,<0.934612,8.12787e-2,0.151305>,<0.859611,0.220696,0.138568>,<0.649096,0.244646,0.430513>,<-0.147369,8.24270e-2,0.824628>,<-0.134623,0.193830,0.753313>,<-0.425376,0.235590,0.619176>,<-0.454032,9.97804e-2,0.672304>,<-0.859611,0.220696,0.138568>,<-0.934612,8.12787e-2,0.151305>,<-0.704581,9.67509e-2,0.459440>,<-0.649096,0.244646,0.430513>,<5.21365e-2,0.853137,0.146372>,<5.21365e-2,0.784092,0.262875>,<0.135423,0.819028,0.229658>,<-0.151306,0.874310,5.88232e-2>,<-0.283813,0.833248,5.88232e-2>,<-0.234652,0.840177,0.142169>,<0.490370,0.683184,0.312479>,<0.631448,0.649357,0.107187>,<0.456721,0.754351,7.43719e-2>,<0.352875,0.774898,0.235837>,<-0.305777,0.657955,0.470564>,<-0.100865,0.574534,0.565030>,<-6.81338e-2,0.685849,0.412729>,<-0.229356,0.752507,0.343050>,<0.229499,0.545652,0.567333>,<-0.229499,0.545652,0.567333>,<0.835872,0.409179,2.18224e-16>,<-1.53447e-16,0.112954,0.828551>,<0.621466,0.596832,0.229491>,<-0.621466,0.596832,0.229491>,<-0.973365,0.131401,-5.93314e-17>,<0.225719,1.74747e-2,0.673213>,<0.489623,0.478625,0.489457>,<0.622947,-3.50757e-2,0.331575>,<0.352720,0.718168,0.352496>,<-0.352720,0.718168,0.352496>,<-0.489623,0.478625,0.489457>,<-0.225719,1.74747e-2,0.673213>,<-0.622947,-3.50757e-2,0.331575>,<0.589256,0.666667,1.07202e-16>,<-0.589256,0.666667,-1.14843e-16>,<-9.79360e-17,0.575237,0.510014>,<-0.561114,0.168166,0.560986>,<0.561114,0.168166,0.560986>,<-0.835872,0.409179,-2.25865e-16>,<-1.53447e-16,0.331002,0.710789>,<0.973365,0.131401,5.16909e-17>,<0.260606,0.263341,0.634333>,<0.703698,0.291020,0.260573>,<-0.260606,0.263341,0.634333>,<-0.703698,0.291020,0.260573>,<-1.25692e-16,0.796853,0.174194>,<-0.196419,0.838645,-3.15758e-17>,<0.196419,0.838645,2.39353e-17>,<-0.124828,0.847432,0.124591>,<0.124828,0.847432,0.124591>,<0.123659,0.746351,0.296208>,<-0.319718,0.787733,0.123670>,<0.319718,0.787733,0.123670>,<-0.123659,0.746351,0.296208>,<0.232557,0.535951,0.574685>,<0.406264,0.569768,0.497269>,<1.19504e-2,0.334122,0.711313>,<6.21307e-2,0.442222,0.657890>,<0.261047,0.275280,0.635119>,<6.95215e-2,0.257846,0.706858>,<0.481654,0.477109,0.498491>,<0.443066,0.348713,0.542337>,<0.823214,0.411586,1.17269e-2>,<0.823585,0.311602,6.90740e-2>,<0.628705,0.587718,0.233189>,<0.756019,0.525377,6.16526e-2>,<0.499927,0.479060,0.483278>,<0.511624,0.583658,0.406545>,<0.703866,0.302927,0.261816>,<0.560524,0.356217,0.443431>,<0.226730,0.556614,0.561745>,<6.17815e-2,0.511952,0.602130>,<0.343360,0.718347,0.360057>,<0.368921,0.636782,0.458561>,<0.127506,0.743761,0.307405>,<0.241172,0.761563,0.291017>,<1.08758e-2,0.582028,0.509093>,<3.62517e-2,0.676296,0.376883>,<-0.614363,0.607176,0.227918>,<-0.687586,0.597277,6.17126e-2>,<-0.361326,0.721213,0.344673>,<-0.472900,0.650619,0.369135>,<-0.330670,0.785898,0.128454>,<-0.297581,0.773055,0.241211>,<-0.583707,0.671862,1.16995e-2>,<-0.425241,0.750507,3.61578e-2>,<-0.232557,0.535951,0.574685>,<-6.21307e-2,0.442222,0.657890>,<-0.481654,0.477109,0.498491>,<-0.406264,0.569768,0.497269>,<-0.261047,0.275280,0.635119>,<-0.443066,0.348713,0.542337>,<-1.19504e-2,0.334122,0.711313>,<-6.95215e-2,0.257846,0.706858>,<-0.628705,0.587718,0.233189>,<-0.511624,0.583658,0.406545>,<-0.832643,0.411586,1.17269e-2>,<-0.756019,0.525377,6.16526e-2>,<-0.703866,0.302927,0.261816>,<-0.823585,0.311602,6.90740e-2>,<-0.499927,0.479060,0.483278>,<-0.560524,0.356217,0.443431>,<0.201569,0.840330,1.14974e-2>,<0.319187,0.797095,3.51801e-2>,<0.137154,0.849409,0.120704>,<8.99471e-2,0.868133,3.51801e-2>,<0.310776,0.795606,0.120704>,<0.234137,0.809083,0.179370>,<-1.03578e-2,0.799834,0.179751>,<-3.51216e-2,0.737011,0.285050>,<-0.119498,0.845616,0.136222>,<-3.51216e-2,0.856505,8.34186e-2>,<-0.119498,0.755138,0.288891>,<-0.179264,0.797475,0.227561>,<1.23846e-2,0.115843,0.828965>,<6.98966e-2,0.194001,0.739967>,<0.301563,2.99323e-2,0.756122>,<8.00099e-2,4.62696e-2,0.848974>,<0.553049,0.169371,0.569854>,<0.511365,5.94346e-2,0.630998>,<0.263870,0.255282,0.642696>,<0.462993,0.262591,0.563442>,<0.829953,2.09621e-2,0.302393>,<0.650614,5.73704e-2,0.511918>,<0.969774,0.133885,1.20627e-2>,<0.976334,3.97750e-2,7.95152e-2>,<0.711194,0.282477,0.264492>,<0.861668,0.232931,6.94707e-2>,<0.571373,0.169554,0.554822>,<0.581191,0.269687,0.463299>,<-1.23846e-2,0.115843,0.828965>,<-8.00099e-2,4.62696e-2,0.848974>,<-0.263870,0.255282,0.642696>,<-6.98966e-2,0.194001,0.739967>,<-0.553049,0.169371,0.569854>,<-0.462993,0.262591,0.563442>,<-0.301563,2.99323e-2,0.756122>,<-0.511365,5.94346e-2,0.630998>,<-0.969774,0.133885,1.20627e-2>,<-0.861668,0.232931,6.94707e-2>,<-0.829953,2.09621e-2,0.302393>,<-0.976334,3.97750e-2,7.95152e-2>,<-0.571373,0.169554,0.554822>,<-0.650614,5.73704e-2,0.511918>,<-0.711194,0.282477,0.264492>,<-0.581191,0.269687,0.463299>,<1.03578e-2,0.799834,0.179751>,<3.51216e-2,0.856505,8.34186e-2>,<0.119498,0.755138,0.288891>,<3.51216e-2,0.737011,0.285050>,<0.119498,0.845616,0.136222>,<0.179264,0.797475,0.227561>,<-0.201569,0.840330,1.14974e-2>,<-8.99471e-2,0.868133,3.51801e-2>,<-0.310776,0.795606,0.120704>,<-0.319187,0.797095,3.51801e-2>,<-0.137154,0.849409,0.120704>,<-0.234137,0.809083,0.179370>,<0.614363,0.607176,0.227918>,<0.472900,0.650619,0.369135>,<0.583707,0.671862,1.16995e-2>,<0.687586,0.597277,6.17126e-2>,<0.330670,0.785898,0.128454>,<0.425241,0.750507,3.61578e-2>,<0.361326,0.721213,0.344673>,<0.297581,0.773055,0.241211>,<-0.226730,0.556614,0.561745>,<-0.368921,0.636782,0.458561>,<-1.08758e-2,0.582028,0.509093>,<-6.17815e-2,0.511952,0.602130>,<-0.127506,0.743761,0.307405>,<-3.62517e-2,0.676296,0.376883>,<-0.343360,0.718347,0.360057>,<-0.241172,0.761563,0.291017>,<0.244783,0.508393,0.605468>,<0.408564,0.567559,0.515579>,<8.03004e-2,0.358551,0.707165>,<7.25060e-2,0.442978,0.672407>,<0.265908,0.315295,0.650230>,<7.95982e-2,0.267875,0.718972>,<0.430391,0.465137,0.548533>,<0.443721,0.356464,0.558537>,<0.810680,0.426871,8.50858e-2>,<0.832859,0.321254,8.19682e-2>,<0.658734,0.557661,0.250303>,<0.758733,0.525774,7.48137e-2>,<0.562539,0.477195,0.436762>,<0.528968,0.582834,0.412402>,<0.714485,0.346405,0.271545>,<0.575772,0.364843,0.447733>,<0.212695,0.600831,0.544263>,<6.52319e-2,0.530722,0.605959>,<0.299426,0.720963,0.394427>,<0.361525,0.650882,0.467276>,<0.139017,0.739791,0.355388>,<0.238695,0.770985,0.306286>,<5.22853e-2,0.619660,0.505224>,<4.07057e-2,0.688539,0.389198>,<-0.589783,0.651872,0.220032>,<-0.687390,0.615198,6.92021e-2>,<-0.401747,0.736613,0.306871>,<-0.480182,0.666841,0.366069>,<-0.379034,0.784650,0.146148>,<-0.311317,0.784679,0.242879>,<-0.567070,0.699910,5.93094e-2>,<-0.434756,0.762916,4.46242e-2>,<-0.244783,0.508393,0.605468>,<-7.25060e-2,0.442978,0.672407>,<-0.430391,0.465137,0.548533>,<-0.408564,0.567559,0.515579>,<-0.265908,0.315295,0.650230>,<-0.443721,0.356464,0.558537>,<-8.03004e-2,0.358551,0.707165>,<-7.95982e-2,0.267875,0.718972>,<-0.658734,0.557661,0.250303>,<-0.528968,0.582834,0.412402>,<-0.810680,0.426871,8.50858e-2>,<-0.768162,0.525774,7.48137e-2>,<-0.714485,0.346405,0.271545>,<-0.832859,0.321254,8.19682e-2>,<-0.562539,0.477195,0.436762>,<-0.575772,0.364843,0.447733>,<0.213234,0.861102,3.33360e-2>,<0.317822,0.814640,4.10692e-2>,<0.165828,0.867784,0.113705>,<0.104865,0.880632,4.10692e-2>,<0.293603,0.828189,0.113705>,<0.238813,0.825776,0.175017>,<-2.58478e-2,0.821268,0.198524>,<-3.67366e-2,0.755098,0.288464>,<-0.106160,0.854957,0.166493>,<-3.67366e-2,0.866063,0.101227>,<-0.106160,0.788378,0.278836>,<-0.170590,0.811246,0.235080>,<8.98493e-2,0.134487,0.816702>,<8.04793e-2,0.198288,0.754189>,<0.305450,7.10034e-2,0.762021>,<9.05260e-2,5.88771e-2,0.858648>,<0.493105,0.174388,0.623341>,<0.511681,7.13210e-2,0.644827>,<0.277504,0.237872,0.678022>,<0.465836,0.265647,0.581289>,<0.833458,6.52320e-2,0.310723>,<0.664369,6.85336e-2,0.515781>,<0.938103,0.148895,9.41343e-2>,<0.983694,5.14613e-2,9.25127e-2>,<0.745380,0.259168,0.282599>,<0.873660,0.235859,8.26033e-2>,<0.640734,0.175505,0.499188>,<0.598247,0.272008,0.469443>,<-8.98493e-2,0.134487,0.816702>,<-9.05260e-2,5.88771e-2,0.858648>,<-0.277504,0.237872,0.678022>,<-8.04793e-2,0.198288,0.754189>,<-0.493105,0.174388,0.623341>,<-0.465836,0.265647,0.581289>,<-0.305450,7.10034e-2,0.762021>,<-0.511681,7.13210e-2,0.644827>,<-0.938103,0.148895,9.41343e-2>,<-0.873660,0.235859,8.26033e-2>,<-0.833458,6.52320e-2,0.310723>,<-0.983694,5.14613e-2,9.25127e-2>,<-0.640734,0.175505,0.499188>,<-0.664369,6.85336e-2,0.515781>,<-0.745380,0.259168,0.282599>,<-0.598247,0.272008,0.469443>,<2.58478e-2,0.821268,0.198524>,<3.67366e-2,0.866063,0.101227>,<0.106160,0.788378,0.278836>,<3.67366e-2,0.755098,0.288464>,<0.106160,0.854957,0.166493>,<0.170590,0.811246,0.235080>,<-0.213234,0.861102,3.33360e-2>,<-0.104865,0.880632,4.10692e-2>,<-0.293603,0.828189,0.113705>,<-0.317822,0.814640,4.10692e-2>,<-0.165828,0.867784,0.113705>,<-0.238813,0.825776,0.175017>,<0.589783,0.651872,0.220032>,<0.480182,0.666841,0.366069>,<0.567070,0.699910,5.93094e-2>,<0.687390,0.615198,6.92021e-2>,<0.379034,0.784650,0.146148>,<0.434756,0.762916,4.46242e-2>,<0.401747,0.736613,0.306871>,<0.311317,0.784679,0.242879>,<-0.212695,0.600831,0.544263>,<-0.361525,0.650882,0.467276>,<-5.22853e-2,0.619660,0.505224>,<-6.52319e-2,0.530722,0.605959>,<-0.139017,0.739791,0.355388>,<-4.07057e-2,0.688539,0.389198>,<-0.299426,0.720963,0.394427>,<-0.238695,0.770985,0.306286>,<0.256762,0.412886,0.631674>,<0.689999,0.453152,0.263156>,<0.175628,0.673654,0.452374>,<-0.486408,0.721879,0.183889>,<-0.256762,0.412886,0.631674>,<-0.689999,0.453152,0.263156>,<-1.25692e-16,-3.52035e-2,0.423407>,<0.225462,0.856361,8.73142e-2>,<-7.87341e-2,0.825112,0.216737>,<0.292926,0.156406,0.723449>,<0.792561,0.163945,0.298853>,<-0.292926,0.156406,0.723449>,<-0.792561,0.163945,0.298853>,<7.87341e-2,0.825112,0.216737>,<-0.225462,0.856361,8.73142e-2>,<0.486408,0.721879,0.183889>,<-0.175628,0.673654,0.452374>,<0.230515,0.539781,0.569743>,<6.01962e-3,0.331833,0.709469>,<0.259977,0.269493,0.632434>,<0.484471,0.477442,0.492708>,<0.832090,0.409915,5.42588e-3>,<0.624116,0.591286,0.230407>,<0.493786,0.478512,0.484926>,<0.701760,0.297141,0.259945>,<0.228124,0.550274,0.563079>,<0.347718,0.716681,0.355670>,<0.125939,0.743023,0.301217>,<6.34492e-3,0.576616,0.508626>,<-0.616715,0.600976,0.228214>,<-0.356712,0.718161,0.347879>,<-0.324939,0.784753,0.125894>,<-0.584943,0.667568,6.22899e-3>,<-0.230515,0.539781,0.569743>,<-0.484471,0.477442,0.492708>,<-0.259977,0.269493,0.632434>,<-6.01962e-3,0.331833,0.709469>,<-0.624116,0.591286,0.230407>,<-0.832090,0.409915,5.42588e-3>,<-0.701760,0.297141,0.259945>,<-0.493786,0.478512,0.484926>,<0.198653,0.837320,6.34201e-3>,<0.130613,0.846910,0.121694>,<0.314005,0.790080,0.121694>,<-6.29308e-3,0.796615,0.175569>,<-0.121607,0.844986,0.129578>,<-0.121607,0.749390,0.290883>,<6.24897e-3,0.113322,0.827346>,<0.300561,2.36115e-2,0.754699>,<0.555883,0.167826,0.564345>,<0.261571,0.257537,0.636991>,<0.828815,1.47834e-2,0.300605>,<0.969518,0.131824,5.64033e-3>,<0.706089,0.285098,0.261496>,<0.565386,0.168058,0.556461>,<-6.24897e-3,0.113322,0.827346>,<-0.261571,0.257537,0.636991>,<-0.555883,0.167826,0.564345>,<-0.300561,2.36115e-2,0.754699>,<-0.969518,0.131824,5.64033e-3>,<-0.828815,1.47834e-2,0.300605>,<-0.565386,0.168058,0.556461>,<-0.706089,0.285098,0.261496>,<6.29308e-3,0.796615,0.175569>,<0.121607,0.749390,0.290883>,<0.121607,0.844986,0.129578>,<-0.198653,0.837320,6.34201e-3>,<-0.314005,0.790080,0.121694>,<-0.130613,0.846910,0.121694>,<0.616715,0.600976,0.228214>,<0.584943,0.667568,6.22899e-3>,<0.324939,0.784753,0.125894>,<0.356712,0.718161,0.347879>,<-0.228124,0.550274,0.563079>,<-6.34492e-3,0.576616,0.508626>,<-0.125939,0.743023,0.301217>,<-0.347718,0.716681,0.355670>,<0.237014,0.537452,0.586533>,<1.77037e-2,0.337662,0.722128>,<0.265180,0.279987,0.646215>,<0.484491,0.479776,0.510619>,<0.832438,0.415126,1.97783e-2>,<0.639274,0.589513,0.240067>,<0.511014,0.482226,0.488680>,<0.713607,0.307839,0.268391>,<0.225658,0.567642,0.568097>,<0.341300,0.727818,0.368315>,<0.127421,0.752922,0.316263>,<1.17786e-2,0.592747,0.516045>,<-0.618911,0.618890,0.229950>,<-0.368195,0.731877,0.345735>,<-0.337911,0.795927,0.131438>,<-0.588627,0.682940,1.56529e-2>,<-0.237014,0.537452,0.586533>,<-0.484491,0.479776,0.510619>,<-0.265180,0.279987,0.646215>,<-1.77037e-2,0.337662,0.722128>,<-0.639274,0.589513,0.240067>,<-0.841867,0.415126,1.97783e-2>,<-0.713607,0.307839,0.268391>,<-0.511014,0.482226,0.488680>,<0.205850,0.852008,1.42796e-2>,<0.142643,0.860917,0.121438>,<0.313008,0.808123,0.121438>,<-9.96588e-3,0.810447,0.186799>,<-0.117049,0.855366,0.144091>,<-0.117049,0.766594,0.293881>,<1.82934e-2,0.121932,0.838645>,<0.305761,3.72876e-2,0.765737>,<0.555968,0.175134,0.580831>,<0.268500,0.259779,0.653739>,<0.838711,2.76747e-2,0.308834>,<0.978239,0.139225,2.00490e-2>,<0.721274,0.286256,0.271336>,<0.581747,0.174706,0.560121>,<-1.82934e-2,0.121932,0.838645>,<-0.268500,0.259779,0.653739>,<-0.555968,0.175134,0.580831>,<-0.305761,3.72876e-2,0.765737>,<-0.978239,0.139225,2.00490e-2>,<-0.838711,2.76747e-2,0.308834>,<-0.581747,0.174706,0.560121>,<-0.721274,0.286256,0.271336>,<9.96588e-3,0.810447,0.186799>,<0.117049,0.766594,0.293881>,<0.117049,0.855366,0.144091>,<-0.205850,0.852008,1.42796e-2>,<-0.313008,0.808123,0.121438>,<-0.142643,0.860917,0.121438>,<0.618911,0.618890,0.229950>,<0.588627,0.682940,1.56529e-2>,<0.337911,0.795927,0.131438>,<0.368195,0.731877,0.345735>,<-0.225658,0.567642,0.568097>,<-1.17786e-2,0.592747,0.516045>,<-0.127421,0.752922,0.316263>,<-0.341300,0.727818,0.368315>,<1.79620e-16,0.464817,-0.654480>,<6.85975e-17,3.42383e-2,-0.841151>,<0.450067,0.625434,-0.446599>,<-0.450067,0.625434,-0.446599>,<0.562381,4.18184e-2,-0.570325>,<-0.562381,4.18184e-2,-0.570325>,<-0.516521,0.314278,-0.512128>,<0.516521,0.314278,-0.512128>,<2.35131e-16,0.216326,-0.735569>,<1.30863e-17,0.700332,-0.338670>,<-0.242701,0.792223,-0.241151>,<0.242701,0.792223,-0.241151>,<0.405157,0.566028,-0.503351>,<6.70799e-2,0.440706,-0.661127>,<7.42468e-2,0.263285,-0.708293>,<0.440725,0.352443,-0.546837>,<0.823761,0.316603,-7.42814e-2>,<0.758347,0.523437,-6.70602e-2>,<0.517853,0.580802,-0.406474>,<0.565181,0.360448,-0.442194>,<6.48249e-2,0.519344,-0.599905>,<0.363829,0.640671,-0.460001>,<0.239770,0.761943,-0.297372>,<4.00478e-2,0.678792,-0.381023>,<-0.683440,0.603482,-6.57323e-2>,<-0.474363,0.655550,-0.365238>,<-0.303884,0.774537,-0.240865>,<-0.428379,0.752579,-4.09101e-2>,<-6.70799e-2,0.440706,-0.661127>,<-0.405157,0.566028,-0.503351>,<-0.440725,0.352443,-0.546837>,<-7.42468e-2,0.263285,-0.708293>,<-0.517853,0.580802,-0.406474>,<-0.758347,0.523437,-6.70602e-2>,<-0.823761,0.316603,-7.42814e-2>,<-0.565181,0.360448,-0.442194>,<0.315682,0.802248,-3.87992e-2>,<9.86546e-2,0.869501,-3.87992e-2>,<0.235163,0.813597,-0.175308>,<-3.76430e-2,0.743421,-0.283370>,<-3.76430e-2,0.856519,-9.25343e-2>,<-0.174069,0.800648,-0.228960>,<7.49359e-2,0.193280,-0.743778>,<8.49993e-2,5.17890e-2,-0.849374>,<0.508704,6.44131e-2,-0.634514>,<0.462227,0.260947,-0.569971>,<0.654646,6.22530e-2,-0.510431>,<0.975570,4.50500e-2,-8.48792e-2>,<0.864378,0.231637,-7.49360e-2>,<0.587699,0.267938,-0.463523>,<-8.49993e-2,5.17890e-2,-0.849374>,<-7.49359e-2,0.193280,-0.743778>,<-0.462227,0.260947,-0.569971>,<-0.508704,6.44131e-2,-0.634514>,<-0.864378,0.231637,-7.49360e-2>,<-0.975570,4.50500e-2,-8.48792e-2>,<-0.654646,6.22530e-2,-0.510431>,<-0.587699,0.267938,-0.463523>,<3.76430e-2,0.856519,-9.25343e-2>,<3.76430e-2,0.743421,-0.283370>,<0.174069,0.800648,-0.228960>,<-9.86546e-2,0.869501,-3.87992e-2>,<-0.315682,0.802248,-3.87992e-2>,<-0.235163,0.813597,-0.175308>,<0.474363,0.655550,-0.365238>,<0.683440,0.603482,-6.57323e-2>,<0.428379,0.752579,-4.09101e-2>,<0.303884,0.774537,-0.240865>,<-0.363829,0.640671,-0.460001>,<-6.48249e-2,0.519344,-0.599905>,<-4.00478e-2,0.678792,-0.381023>,<-0.239770,0.761943,-0.297372>,<0.372965,0.526027,-0.549944>,<0.119875,0.439077,-0.666647>,<0.129287,0.304039,-0.700605>,<0.394849,0.374993,-0.582299>,<0.798513,0.355778,-0.133675>,<0.753240,0.509270,-0.124201>,<0.573409,0.549541,-0.378440>,<0.610729,0.390062,-0.400437>,<0.100865,0.574534,-0.565030>,<0.305777,0.657955,-0.470564>,<0.229356,0.752507,-0.343050>,<6.81338e-2,0.685849,-0.412729>,<-0.631448,0.649357,-0.107187>,<-0.490370,0.683184,-0.312479>,<-0.352875,0.774898,-0.235837>,<-0.456721,0.754351,-7.43719e-2>,<-0.119875,0.439077,-0.666647>,<-0.372965,0.526027,-0.549944>,<-0.394849,0.374993,-0.582299>,<-0.129287,0.304039,-0.700605>,<-0.573409,0.549541,-0.378440>,<-0.753240,0.509270,-0.124201>,<-0.798513,0.355778,-0.133675>,<-0.610729,0.390062,-0.400437>,<0.283813,0.833248,-5.88232e-2>,<0.151306,0.874310,-5.88232e-2>,<0.234652,0.840177,-0.142169>,<-5.21365e-2,0.784092,-0.262875>,<-5.21365e-2,0.853137,-0.146372>,<-0.135423,0.819028,-0.229658>,<0.134623,0.193830,-0.753313>,<0.147369,8.24270e-2,-0.824628>,<0.454032,9.97804e-2,-0.672304>,<0.425376,0.235590,-0.619176>,<0.704581,9.67509e-2,-0.459440>,<0.934612,8.12787e-2,-0.151305>,<0.859611,0.220696,-0.138568>,<0.649096,0.244646,-0.430513>,<-0.147369,8.24270e-2,-0.824628>,<-0.134623,0.193830,-0.753313>,<-0.425376,0.235590,-0.619176>,<-0.454032,9.97804e-2,-0.672304>,<-0.859611,0.220696,-0.138568>,<-0.934612,8.12787e-2,-0.151305>,<-0.704581,9.67509e-2,-0.459440>,<-0.649096,0.244646,-0.430513>,<5.21365e-2,0.853137,-0.146372>,<5.21365e-2,0.784092,-0.262875>,<0.135423,0.819028,-0.229658>,<-0.151306,0.874310,-5.88232e-2>,<-0.283813,0.833248,-5.88232e-2>,<-0.234652,0.840177,-0.142169>,<0.490370,0.683184,-0.312479>,<0.631448,0.649357,-0.107187>,<0.456721,0.754351,-7.43719e-2>,<0.352875,0.774898,-0.235837>,<-0.305777,0.657955,-0.470564>,<-0.100865,0.574534,-0.565030>,<-6.81338e-2,0.685849,-0.412729>,<-0.229356,0.752507,-0.343050>,<0.229499,0.545652,-0.567333>,<-0.229499,0.545652,-0.567333>,<1.24109e-16,0.112954,-0.828551>,<0.621466,0.596832,-0.229491>,<-0.621466,0.596832,-0.229491>,<0.225719,1.74747e-2,-0.673213>,<0.489623,0.478625,-0.489457>,<0.622947,-3.50757e-2,-0.331575>,<0.352720,0.718168,-0.352496>,<-0.352720,0.718168,-0.352496>,<-0.489623,0.478625,-0.489457>,<-0.225719,1.74747e-2,-0.673213>,<-0.622947,-3.50757e-2,-0.331575>,<1.24109e-16,0.575237,-0.510014>,<-0.561114,0.168166,-0.560986>,<0.561114,0.168166,-0.560986>,<1.24109e-16,0.331002,-0.710789>,<0.260606,0.263341,-0.634333>,<0.703698,0.291020,-0.260573>,<-0.260606,0.263341,-0.634333>,<-0.703698,0.291020,-0.260573>,<-4.24248e-17,0.796853,-0.174194>,<-0.124828,0.847432,-0.124591>,<0.124828,0.847432,-0.124591>,<0.123659,0.746351,-0.296208>,<-0.319718,0.787733,-0.123670>,<0.319718,0.787733,-0.123670>,<-0.123659,0.746351,-0.296208>,<0.232557,0.535951,-0.574685>,<0.406264,0.569768,-0.497269>,<1.19504e-2,0.334122,-0.711313>,<6.21307e-2,0.442222,-0.657890>,<0.261047,0.275280,-0.635119>,<6.95215e-2,0.257846,-0.706858>,<0.481654,0.477109,-0.498491>,<0.443066,0.348713,-0.542337>,<0.832643,0.411586,-1.17269e-2>,<0.823585,0.311602,-6.90740e-2>,<0.628705,0.587718,-0.233189>,<0.756019,0.525377,-6.16526e-2>,<0.499927,0.479060,-0.483278>,<0.511624,0.583658,-0.406545>,<0.703866,0.302927,-0.261816>,<0.560524,0.356217,-0.443431>,<0.226730,0.556614,-0.561745>,<6.17815e-2,0.511952,-0.602130>,<0.343360,0.718347,-0.360057>,<0.368921,0.636782,-0.458561>,<0.127506,0.743761,-0.307405>,<0.241172,0.761563,-0.291017>,<1.08758e-2,0.582028,-0.509093>,<3.62517e-2,0.676296,-0.376883>,<-0.614363,0.607176,-0.227918>,<-0.687586,0.597277,-6.17126e-2>,<-0.361326,0.721213,-0.344673>,<-0.472900,0.650619,-0.369135>,<-0.330670,0.785898,-0.128454>,<-0.297581,0.773055,-0.241211>,<-0.583707,0.671862,-1.16995e-2>,<-0.425241,0.750507,-3.61578e-2>,<-0.232557,0.535951,-0.574685>,<-6.21307e-2,0.442222,-0.657890>,<-0.481654,0.477109,-0.498491>,<-0.406264,0.569768,-0.497269>,<-0.261047,0.275280,-0.635119>,<-0.443066,0.348713,-0.542337>,<-1.19504e-2,0.334122,-0.711313>,<-6.95215e-2,0.257846,-0.706858>,<-0.628705,0.587718,-0.233189>,<-0.511624,0.583658,-0.406545>,<-0.832643,0.411586,-1.17269e-2>,<-0.756019,0.525377,-6.16526e-2>,<-0.703866,0.302927,-0.261816>,<-0.823585,0.311602,-6.90740e-2>,<-0.499927,0.479060,-0.483278>,<-0.560524,0.356217,-0.443431>,<0.201569,0.840330,-1.14974e-2>,<0.319187,0.797095,-3.51801e-2>,<0.137154,0.849409,-0.120704>,<8.99471e-2,0.868133,-3.51801e-2>,<0.310776,0.795606,-0.120704>,<0.234137,0.809083,-0.179370>,<-1.03578e-2,0.799834,-0.179751>,<-3.51216e-2,0.737011,-0.285050>,<-0.119498,0.845616,-0.136222>,<-3.51216e-2,0.856505,-8.34186e-2>,<-0.119498,0.755138,-0.288891>,<-0.179264,0.797475,-0.227561>,<1.23846e-2,0.115843,-0.828965>,<6.98966e-2,0.194001,-0.739967>,<0.301563,2.99323e-2,-0.756122>,<8.00099e-2,4.62696e-2,-0.848974>,<0.553049,0.169371,-0.569854>,<0.511365,5.94346e-2,-0.630998>,<0.263870,0.255282,-0.642696>,<0.462993,0.262591,-0.563442>,<0.829953,2.09621e-2,-0.302393>,<0.650614,5.73704e-2,-0.511918>,<0.969774,0.133885,-1.20627e-2>,<0.976334,3.97750e-2,-7.95152e-2>,<0.711194,0.282477,-0.264492>,<0.861668,0.232931,-6.94707e-2>,<0.571373,0.169554,-0.554822>,<0.581191,0.269687,-0.463299>,<-1.23846e-2,0.115843,-0.828965>,<-8.00099e-2,4.62696e-2,-0.848974>,<-0.263870,0.255282,-0.642696>,<-6.98966e-2,0.194001,-0.739967>,<-0.553049,0.169371,-0.569854>,<-0.462993,0.262591,-0.563442>,<-0.301563,2.99323e-2,-0.756122>,<-0.511365,5.94346e-2,-0.630998>,<-0.969774,0.133885,-1.20627e-2>,<-0.861668,0.232931,-6.94707e-2>,<-0.829953,2.09621e-2,-0.302393>,<-0.976334,3.97750e-2,-7.95152e-2>,<-0.571373,0.169554,-0.554822>,<-0.650614,5.73704e-2,-0.511918>,<-0.711194,0.282477,-0.264492>,<-0.581191,0.269687,-0.463299>,<1.03578e-2,0.799834,-0.179751>,<3.51216e-2,0.856505,-8.34186e-2>,<0.119498,0.755138,-0.288891>,<3.51216e-2,0.737011,-0.285050>,<0.119498,0.845616,-0.136222>,<0.179264,0.797475,-0.227561>,<-0.201569,0.840330,-1.14974e-2>,<-8.99471e-2,0.868133,-3.51801e-2>,<-0.310776,0.795606,-0.120704>,<-0.319187,0.797095,-3.51801e-2>,<-0.137154,0.849409,-0.120704>,<-0.234137,0.809083,-0.179370>,<0.614363,0.607176,-0.227918>,<0.472900,0.650619,-0.369135>,<0.583707,0.671862,-1.16995e-2>,<0.687586,0.597277,-6.17126e-2>,<0.330670,0.785898,-0.128454>,<0.425241,0.750507,-3.61578e-2>,<0.361326,0.721213,-0.344673>,<0.297581,0.773055,-0.241211>,<-0.226730,0.556614,-0.561745>,<-0.368921,0.636782,-0.458561>,<-1.08758e-2,0.582028,-0.509093>,<-6.17815e-2,0.511952,-0.602130>,<-0.127506,0.743761,-0.307405>,<-3.62517e-2,0.676296,-0.376883>,<-0.343360,0.718347,-0.360057>,<-0.241172,0.761563,-0.291017>,<0.244783,0.508393,-0.605468>,<0.408564,0.567559,-0.515579>,<8.03004e-2,0.358551,-0.707165>,<7.25060e-2,0.442978,-0.672407>,<0.265908,0.315295,-0.650230>,<7.95982e-2,0.267875,-0.718972>,<0.430391,0.465137,-0.548533>,<0.443721,0.356464,-0.558537>,<0.810680,0.426871,-8.50858e-2>,<0.832859,0.321254,-8.19682e-2>,<0.658734,0.557661,-0.250303>,<0.768162,0.525774,-7.48137e-2>,<0.562539,0.477195,-0.436762>,<0.528968,0.582834,-0.412402>,<0.714485,0.346405,-0.271545>,<0.575772,0.364843,-0.447733>,<0.212695,0.600831,-0.544263>,<6.52319e-2,0.530722,-0.605959>,<0.299426,0.720963,-0.394427>,<0.361525,0.650882,-0.467276>,<0.139017,0.739791,-0.355388>,<0.238695,0.770985,-0.306286>,<5.22853e-2,0.619660,-0.505224>,<4.07057e-2,0.688539,-0.389198>,<-0.589783,0.651872,-0.220032>,<-0.687390,0.615198,-6.92021e-2>,<-0.401747,0.736613,-0.306871>,<-0.480182,0.666841,-0.366069>,<-0.379034,0.784650,-0.146148>,<-0.311317,0.784679,-0.242879>,<-0.567070,0.699910,-5.93094e-2>,<-0.434756,0.762916,-4.46242e-2>,<-0.244783,0.508393,-0.605468>,<-7.25060e-2,0.442978,-0.672407>,<-0.430391,0.465137,-0.548533>,<-0.408564,0.567559,-0.515579>,<-0.265908,0.315295,-0.650230>,<-0.443721,0.356464,-0.558537>,<-8.03004e-2,0.358551,-0.707165>,<-7.95982e-2,0.267875,-0.718972>,<-0.658734,0.557661,-0.250303>,<-0.528968,0.582834,-0.412402>,<-0.810680,0.426871,-8.50858e-2>,<-0.768162,0.525774,-7.48137e-2>,<-0.714485,0.346405,-0.271545>,<-0.832859,0.321254,-8.19682e-2>,<-0.562539,0.477195,-0.436762>,<-0.575772,0.364843,-0.447733>,<0.213234,0.861102,-3.33360e-2>,<0.317822,0.814640,-4.10692e-2>,<0.165828,0.867784,-0.113705>,<0.104865,0.880632,-4.10692e-2>,<0.293603,0.828189,-0.113705>,<0.238813,0.825776,-0.175017>,<-2.58478e-2,0.821268,-0.198524>,<-3.67366e-2,0.755098,-0.288464>,<-0.106160,0.854957,-0.166493>,<-3.67366e-2,0.866063,-0.101227>,<-0.106160,0.788378,-0.278836>,<-0.170590,0.811246,-0.235080>,<8.98493e-2,0.134487,-0.816702>,<8.04793e-2,0.198288,-0.754189>,<0.305450,7.10034e-2,-0.762021>,<9.05260e-2,5.88771e-2,-0.858648>,<0.493105,0.174388,-0.623341>,<0.511681,7.13210e-2,-0.644827>,<0.277504,0.237872,-0.678022>,<0.465836,0.265647,-0.581289>,<0.833458,6.52320e-2,-0.310723>,<0.664369,6.85336e-2,-0.515781>,<0.938103,0.148895,-9.41343e-2>,<0.983694,5.14613e-2,-9.25127e-2>,<0.745380,0.259168,-0.282599>,<0.873660,0.235859,-8.26033e-2>,<0.640734,0.175505,-0.499188>,<0.598247,0.272008,-0.469443>,<-8.98493e-2,0.134487,-0.816702>,<-9.05260e-2,5.88771e-2,-0.858648>,<-0.277504,0.237872,-0.678022>,<-8.04793e-2,0.198288,-0.754189>,<-0.493105,0.174388,-0.623341>,<-0.465836,0.265647,-0.581289>,<-0.305450,7.10034e-2,-0.762021>,<-0.511681,7.13210e-2,-0.644827>,<-0.938103,0.148895,-9.41343e-2>,<-0.873660,0.235859,-8.26033e-2>,<-0.833458,6.52320e-2,-0.310723>,<-0.983694,5.14613e-2,-9.25127e-2>,<-0.640734,0.175505,-0.499188>,<-0.664369,6.85336e-2,-0.515781>,<-0.745380,0.259168,-0.282599>,<-0.598247,0.272008,-0.469443>,<2.58478e-2,0.821268,-0.198524>,<3.67366e-2,0.866063,-0.101227>,<0.106160,0.788378,-0.278836>,<3.67366e-2,0.755098,-0.288464>,<0.106160,0.854957,-0.166493>,<0.170590,0.811246,-0.235080>,<-0.213234,0.861102,-3.33360e-2>,<-0.104865,0.880632,-4.10692e-2>,<-0.293603,0.828189,-0.113705>,<-0.317822,0.814640,-4.10692e-2>,<-0.165828,0.867784,-0.113705>,<-0.238813,0.825776,-0.175017>,<0.589783,0.651872,-0.220032>,<0.480182,0.666841,-0.366069>,<0.567070,0.699910,-5.93094e-2>,<0.687390,0.615198,-6.92021e-2>,<0.379034,0.784650,-0.146148>,<0.434756,0.762916,-4.46242e-2>,<0.401747,0.736613,-0.306871>,<0.311317,0.784679,-0.242879>,<-0.212695,0.600831,-0.544263>,<-0.361525,0.650882,-0.467276>,<-5.22853e-2,0.619660,-0.505224>,<-6.52319e-2,0.530722,-0.605959>,<-0.139017,0.739791,-0.355388>,<-4.07057e-2,0.688539,-0.389198>,<-0.299426,0.720963,-0.394427>,<-0.238695,0.770985,-0.306286>,<0.256762,0.412886,-0.631674>,<0.689999,0.453152,-0.263156>,<0.175628,0.673654,-0.452374>,<-0.486408,0.721879,-0.183889>,<-0.256762,0.412886,-0.631674>,<-0.689999,0.453152,-0.263156>,<1.30863e-17,-3.52035e-2,-0.423407>,<0.225462,0.856361,-8.73142e-2>,<-7.87341e-2,0.825112,-0.216737>,<0.292926,0.156406,-0.723449>,<0.792561,0.163945,-0.298853>,<-0.292926,0.156406,-0.723449>,<-0.792561,0.163945,-0.298853>,<7.87341e-2,0.825112,-0.216737>,<-0.225462,0.856361,-8.73142e-2>,<0.486408,0.721879,-0.183889>,<-0.175628,0.673654,-0.452374>,<0.230515,0.539781,-0.569743>,<6.01962e-3,0.331833,-0.709469>,<0.259977,0.269493,-0.632434>,<0.484471,0.477442,-0.492708>,<0.832090,0.409915,-5.42588e-3>,<0.624116,0.591286,-0.230407>,<0.493786,0.478512,-0.484926>,<0.701760,0.297141,-0.259945>,<0.228124,0.550274,-0.563079>,<0.347718,0.716681,-0.355670>,<0.125939,0.743023,-0.301217>,<6.34492e-3,0.576616,-0.508626>,<-0.616715,0.600976,-0.228214>,<-0.356712,0.718161,-0.347879>,<-0.324939,0.784753,-0.125894>,<-0.584943,0.667568,-6.22899e-3>,<-0.230515,0.539781,-0.569743>,<-0.484471,0.477442,-0.492708>,<-0.259977,0.269493,-0.632434>,<-6.01962e-3,0.331833,-0.709469>,<-0.624116,0.591286,-0.230407>,<-0.832090,0.409915,-5.42588e-3>,<-0.701760,0.297141,-0.259945>,<-0.493786,0.478512,-0.484926>,<0.198653,0.837320,-6.34201e-3>,<0.130613,0.846910,-0.121694>,<0.314005,0.790080,-0.121694>,<-6.29308e-3,0.796615,-0.175569>,<-0.121607,0.844986,-0.129578>,<-0.121607,0.749390,-0.290883>,<6.24897e-3,0.113322,-0.827346>,<0.300561,2.36115e-2,-0.754699>,<0.555883,0.167826,-0.564345>,<0.261571,0.257537,-0.636991>,<0.828815,1.47834e-2,-0.300605>,<0.969518,0.131824,-5.64033e-3>,<0.706089,0.285098,-0.261496>,<0.565386,0.168058,-0.556461>,<-6.24897e-3,0.113322,-0.827346>,<-0.261571,0.257537,-0.636991>,<-0.555883,0.167826,-0.564345>,<-0.300561,2.36115e-2,-0.754699>,<-0.969518,0.131824,-5.64033e-3>,<-0.828815,1.47834e-2,-0.300605>,<-0.565386,0.168058,-0.556461>,<-0.706089,0.285098,-0.261496>,<6.29308e-3,0.796615,-0.175569>,<0.121607,0.749390,-0.290883>,<0.121607,0.844986,-0.129578>,<-0.198653,0.837320,-6.34201e-3>,<-0.314005,0.790080,-0.121694>,<-0.130613,0.846910,-0.121694>,<0.616715,0.600976,-0.228214>,<0.584943,0.667568,-6.22899e-3>,<0.324939,0.784753,-0.125894>,<0.356712,0.718161,-0.347879>,<-0.228124,0.550274,-0.563079>,<-6.34492e-3,0.576616,-0.508626>,<-0.125939,0.743023,-0.301217>,<-0.347718,0.716681,-0.355670>,<0.237014,0.537452,-0.586533>,<1.77037e-2,0.337662,-0.722128>,<0.265180,0.279987,-0.646215>,<0.484491,0.479776,-0.510619>,<0.841867,0.415126,-1.97783e-2>,<0.639274,0.589513,-0.240067>,<0.511014,0.482226,-0.488680>,<0.713607,0.307839,-0.268391>,<0.225658,0.567642,-0.568097>,<0.341300,0.727818,-0.368315>,<0.127421,0.752922,-0.316263>,<1.17786e-2,0.592747,-0.516045>,<-0.618911,0.618890,-0.229950>,<-0.368195,0.731877,-0.345735>,<-0.337911,0.795927,-0.131438>,<-0.588627,0.682940,-1.56529e-2>,<-0.237014,0.537452,-0.586533>,<-0.484491,0.479776,-0.510619>,<-0.265180,0.279987,-0.646215>,<-1.77037e-2,0.337662,-0.722128>,<-0.639274,0.589513,-0.240067>,<-0.841867,0.415126,-1.97783e-2>,<-0.713607,0.307839,-0.268391>,<-0.511014,0.482226,-0.488680>,<0.205850,0.852008,-1.42796e-2>,<0.142643,0.860917,-0.121438>,<0.313008,0.808123,-0.121438>,<-9.96588e-3,0.810447,-0.186799>,<-0.117049,0.855366,-0.144091>,<-0.117049,0.766594,-0.293881>,<1.82934e-2,0.121932,-0.838645>,<0.305761,3.72876e-2,-0.765737>,<0.555968,0.175134,-0.580831>,<0.268500,0.259779,-0.653739>,<0.838711,2.76747e-2,-0.308834>,<0.978239,0.139225,-2.00490e-2>,<0.721274,0.286256,-0.271336>,<0.581747,0.174706,-0.560121>,<-1.82934e-2,0.121932,-0.838645>,<-0.268500,0.259779,-0.653739>,<-0.555968,0.175134,-0.580831>,<-0.305761,3.72876e-2,-0.765737>,<-0.978239,0.139225,-2.00490e-2>,<-0.838711,2.76747e-2,-0.308834>,<-0.581747,0.174706,-0.560121>,<-0.721274,0.286256,-0.271336>,<9.96588e-3,0.810447,-0.186799>,<0.117049,0.766594,-0.293881>,<0.117049,0.855366,-0.144091>,<-0.205850,0.852008,-1.42796e-2>,<-0.313008,0.808123,-0.121438>,<-0.142643,0.860917,-0.121438>,<0.618911,0.618890,-0.229950>,<0.588627,0.682940,-1.56529e-2>,<0.337911,0.795927,-0.131438>,<0.368195,0.731877,-0.345735>,<-0.225658,0.567642,-0.568097>,<-1.17786e-2,0.592747,-0.516045>,<-0.127421,0.752922,-0.316263>,<-0.341300,0.727818,-0.368315>,<-1.05901,4.31703e-2,-5.93314e-17>,<-1.10746,0.104734,-5.93314e-17>,<1.04934,3.84740e-2,-3.97576e-2>,<1.04934,3.84740e-2,3.97576e-2>,<1.03900,6.62391e-2,-4.87062e-2>,<1.03900,6.62391e-2,4.87062e-2>,<1.05856,1.37357e-2,5.16909e-17>,<1.02660,9.95091e-2,5.16909e-17>,<1.07577,4.93718e-2,3.97576e-2>,<1.09289,2.92780e-2,4.93838e-17>,<1.07577,4.93718e-2,-3.97576e-2>,<1.05655,7.19240e-2,-4.87062e-2>,<1.03352,9.89476e-2,4.93838e-17>,<1.05655,7.19240e-2,4.87062e-2>,<1.09461,6.67165e-2,3.97576e-2>,<1.11757,5.36909e-2,4.49667e-17>,<1.09461,6.67165e-2,-3.97576e-2>,<1.06883,8.13358e-2,-4.87062e-2>,<1.03795,9.88535e-2,4.49667e-17>,<1.06883,8.13358e-2,4.87062e-2>,<1.10655,8.97664e-2,3.97576e-2>,<1.13258,8.53801e-2,4.00625e-17>,<1.10655,8.97664e-2,-3.97576e-2>,<1.07733,9.46894e-2,-4.87062e-2>,<1.04232,0.100588,4.00625e-17>,<1.07733,9.46894e-2,4.87062e-2>,<1.11856,0.104814,5.61586e-2>,<1.15534,9.86184e-2,2.38650e-17>,<1.11856,0.104814,-5.61586e-2>,<1.06993,0.113008,-7.10520e-2>,<1.01886,0.121613,-1.58835e-17>,<1.06993,0.113008,7.10520e-2>,<1.24166,0.418435,0.118818>,<1.30641,0.409987,-8.54617e-3>,<1.23748,0.432286,-0.125054>,<1.10600,0.449412,-0.151680>,<1.00800,0.462176,-2.91499e-16>,<1.10600,0.449412,0.151680>,<1.22082,0.502782,7.78262e-2>,<1.26295,0.497281,-1.21734e-16>,<1.22082,0.502782,-7.78262e-2>,<1.14063,0.513252,-9.01232e-2>,<1.08702,0.520256,-1.97750e-16>,<1.14063,0.513252,9.01232e-2>,<1.12342,0.133643,5.61586e-2>,<1.16019,0.127448,4.92169e-18>,<1.12342,0.133643,-5.61586e-2>,<1.07479,0.141837,-7.10520e-2>,<1.02372,0.150442,-3.48269e-17>,<1.07479,0.141837,7.10520e-2>,<1.19275,0.213841,0.129944>,<1.29316,0.203601,-7.93158e-17>,<1.19275,0.213841,-0.129944>,<1.05832,0.231433,-0.161019>,<0.949731,0.245417,-2.17140e-16>,<1.05832,0.231433,0.161019>,<1.01460,0.194246,3.34802e-2>,<1.04522,0.189087,7.60755e-2>,<1.03259,0.177743,9.44019e-2>,<0.992983,0.182915,3.91106e-2>,<1.11708,0.176979,-9.45559e-2>,<1.10784,0.178536,-9.73876e-2>,<1.09937,0.169038,-0.121364>,<1.12680,0.165420,-0.115588>,<1.17043,0.167991,5.43672e-2>,<1.18408,0.165691,3.35182e-2>,<1.20376,0.155405,3.56817e-2>,<1.18200,0.158213,7.29701e-2>,<1.04522,0.189087,-7.60755e-2>,<1.01460,0.194246,-3.34802e-2>,<0.992983,0.182915,-3.91106e-2>,<1.03259,0.177743,-9.44019e-2>,<1.10784,0.178536,9.73876e-2>,<1.11708,0.176979,9.45559e-2>,<1.12680,0.165420,0.115588>,<1.09937,0.169038,0.121364>,<1.18408,0.165691,-3.35182e-2>,<1.17043,0.167991,-5.43672e-2>,<1.18200,0.158213,-7.29701e-2>,<1.20376,0.155405,-3.56817e-2>,<1.17415,0.440543,-0.158125>,<1.28029,0.413386,7.59162e-2>,<1.17415,0.440543,0.158125>,<1.04025,0.457975,-8.97199e-2>,<1.04025,0.457975,8.97199e-2>,<1.28947,0.412188,-6.02844e-2>,<1.23977,0.505601,3.57224e-2>,<1.23409,0.486061,0.104777>,<1.23977,0.505601,-3.57224e-2>,<1.29522,0.478082,-1.53054e-16>,<1.18264,0.513053,-8.18373e-2>,<1.23409,0.486061,-0.104777>,<1.11587,0.521778,-4.60743e-2>,<1.12666,0.500072,-0.126416>,<1.11587,0.521778,4.60743e-2>,<1.04541,0.510680,-2.69767e-16>,<1.18264,0.513053,8.18373e-2>,<1.12666,0.500072,0.126416>,<1.22884,0.340273,0.123524>,<1.29616,0.331519,-9.00740e-3>,<1.21990,0.328139,-0.131847>,<1.08036,0.346314,-0.160131>,<0.976778,0.359875,-2.55367e-16>,<1.08036,0.346314,0.160131>,<1.24665,0.219639,-7.00972e-2>,<0.992877,0.252690,-9.16898e-2>,<1.13024,0.234808,-0.161389>,<1.13024,0.234808,0.161389>,<1.26874,0.219639,7.00972e-2>,<0.992877,0.252690,9.16898e-2>,<1.00778,0.180932,7.03986e-2>,<1.11381,0.167106,-0.123388>,<1.19714,0.156224,5.64619e-2>,<1.00778,0.180932,-7.03986e-2>,<1.11381,0.167106,0.123388>,<1.19714,0.156224,-5.64619e-2>,<1.15161,0.181414,0.130657>,<1.15406,0.161881,9.57501e-2>,<1.19421,0.175914,9.76608e-2>,<1.23888,0.170117,2.67157e-2>,<1.20599,0.155139,-4.13954e-17>,<1.23888,0.170117,-2.67157e-2>,<1.19421,0.175914,-9.76608e-2>,<1.15406,0.161881,-9.57501e-2>,<1.15161,0.181414,-0.130657>,<1.08491,0.190205,-0.149332>,<1.06769,0.173199,-0.111577>,<1.03405,0.196844,-0.126971>,<0.965354,0.205787,-3.12588e-2>,<0.988019,0.183602,-1.04042e-16>,<0.965354,0.205787,3.12588e-2>,<1.03405,0.196844,0.126971>,<1.06769,0.173199,0.111577>,<1.08491,0.190205,0.149332>,<1.18024,0.520160,-7.62538e-6>,<1.26892,0.335017,7.90714e-2>,<1.27861,0.333757,-6.25906e-2>,<1.15268,0.336855,-0.166843>,<1.01079,0.355325,-9.47412e-2>,<1.01079,0.355325,9.47412e-2>,<1.15268,0.336855,0.166843>,<1.18234,0.492824,-0.132097>,<1.27644,0.480544,5.73537e-2>,<1.18234,0.492824,0.132097>,<1.07227,0.507177,-7.47106e-2>,<1.07227,0.507177,7.47106e-2>,<1.27644,0.480544,-5.73537e-2>,<0.963556,0.200784,-1.73727e-16>,<1.16886,0.173958,0.111912>,<1.16886,0.173958,-0.111912>,<1.22143,0.174068,6.42511e-2>,<1.23501,0.165369,-6.41367e-17>,<1.22143,0.174068,-6.42511e-2>,<1.11921,0.187411,-0.145094>,<1.06204,0.187940,-0.137547>,<0.995306,0.203559,-8.25861e-2>,<0.995306,0.203559,8.25861e-2>,<1.06204,0.187940,0.137547>,<1.11921,0.187411,0.145094>,<1.17725,0.166841,4.39427e-2>,<1.17725,0.166841,-4.39427e-2>,<1.11246,0.177758,-9.59717e-2>,<1.02991,0.191667,-5.47778e-2>,<1.02991,0.191667,5.47778e-2>,<1.11246,0.177758,9.59717e-2>,<1.18408,0.165691,-2.42861e-17>,<1.07653,0.183812,-8.67315e-2>,<1.07653,0.183812,8.67315e-2>,<1.14375,0.172485,7.44615e-2>,<1.14375,0.172485,-7.44615e-2>,<1.01460,0.194246,-9.02056e-17>,<0.550451,6.30336e-2,0.664361>,<0.602846,4.55443e-2,0.604866>,<0.600200,0.171765,0.594350>,<0.596348,0.171552,0.598885>,<0.591698,4.59648e-2,0.614437>,<0.679154,6.14070e-2,0.554861>,<0.594704,0.172204,0.600573>,<0.589655,0.172202,0.603929>,<-0.602846,4.55443e-2,0.604866>,<-0.550451,6.30336e-2,0.664361>,<-0.596348,0.171552,0.598885>,<-0.600200,0.171765,0.594350>,<-0.679154,6.14070e-2,0.554861>,<-0.591698,4.59648e-2,0.614437>,<-0.589655,0.172202,0.603929>,<-0.594704,0.172204,0.600573>,<0.602846,4.55443e-2,-0.604866>,<0.550451,6.30336e-2,-0.664361>,<0.596348,0.171552,-0.598885>,<0.600200,0.171765,-0.594350>,<0.679154,6.14070e-2,-0.554861>,<0.591698,4.59648e-2,-0.614437>,<0.589655,0.172202,-0.603929>,<0.594704,0.172204,-0.600573>,<-0.550451,6.30336e-2,-0.664361>,<-0.602846,4.55443e-2,-0.604866>,<-0.600200,0.171765,-0.594350>,<-0.596348,0.171552,-0.598885>,<-0.591698,4.59648e-2,-0.614437>,<-0.679154,6.14070e-2,-0.554861>,<-0.594704,0.172204,-0.600573>,<-0.589655,0.172202,-0.603929>,<0.543981,5.46679e-2,0.690927>,<0.621369,2.88363e-2,0.603052>,<0.618046,0.187354,0.589845>,<0.599671,0.186338,0.611482>,<0.586547,3.03505e-2,0.633434>,<0.709153,5.19990e-2,0.549913>,<0.605997,0.187337,0.605750>,<0.584005,0.187328,0.620367>,<-0.621369,2.88363e-2,0.603052>,<-0.543981,5.46679e-2,0.690927>,<-0.599671,0.186338,0.611482>,<-0.618046,0.187354,0.589845>,<-0.709153,5.19990e-2,0.549913>,<-0.586547,3.03505e-2,0.633434>,<-0.584005,0.187328,0.620367>,<-0.605997,0.187337,0.605750>,<0.621369,2.88363e-2,-0.603052>,<0.543981,5.46679e-2,-0.690927>,<0.599671,0.186338,-0.611482>,<0.618046,0.187354,-0.589845>,<0.709153,5.19990e-2,-0.549913>,<0.586547,3.03505e-2,-0.633434>,<0.584005,0.187328,-0.620367>,<0.605997,0.187337,-0.605750>,<-0.543981,5.46679e-2,-0.690927>,<-0.621369,2.88363e-2,-0.603052>,<-0.618046,0.187354,-0.589845>,<-0.599671,0.186338,-0.611482>,<-0.586547,3.03505e-2,-0.633434>,<-0.709153,5.19990e-2,-0.549913>,<-0.605997,0.187337,-0.605750>,<-0.584005,0.187328,-0.620367>,<0.570640,5.71226e-2,0.713682>,<0.648027,3.12909e-2,0.625807>,<0.644704,0.189809,0.612600>,<0.626329,0.188793,0.634237>,<0.605935,3.30927e-2,0.662607>,<0.728541,5.47412e-2,0.579086>,<0.625386,0.190079,0.634923>,<0.603394,0.190070,0.649540>,<-0.648027,3.12909e-2,0.625807>,<-0.570640,5.71226e-2,0.713682>,<-0.626329,0.188793,0.634237>,<-0.644704,0.189809,0.612600>,<-0.728541,5.47412e-2,0.579086>,<-0.605935,3.30927e-2,0.662607>,<-0.603394,0.190070,0.649540>,<-0.625386,0.190079,0.634923>,<0.648027,3.12909e-2,-0.625807>,<0.570640,5.71226e-2,-0.713682>,<0.626329,0.188793,-0.634237>,<0.644704,0.189809,-0.612600>,<0.728541,5.47412e-2,-0.579086>,<0.605935,3.30927e-2,-0.662607>,<0.603394,0.190070,-0.649540>,<0.625386,0.190079,-0.634923>,<-0.570640,5.71226e-2,-0.713682>,<-0.648027,3.12909e-2,-0.625807>,<-0.644704,0.189809,-0.612600>,<-0.626329,0.188793,-0.634237>,<-0.605935,3.30927e-2,-0.662607>,<-0.728541,5.47412e-2,-0.579086>,<-0.625386,0.190079,-0.634923>,<-0.603394,0.190070,-0.649540>,<1.29970,0.424163,-3.41847e-2>,<1.30416,0.370383,-1.43099e-16>,<1.28562,0.319563,-3.60296e-2>,<1.28116,0.373342,-7.02143e-2>,<1.29266,0.371863,-3.51071e-2>,<1.26299,0.428954,9.67118e-2>,<1.22869,0.380213,0.128450>,<1.24686,0.324601,0.101953>,<1.28116,0.373342,7.02143e-2>,<1.25493,0.376777,9.93324e-2>,<1.24179,0.216740,0.100020>,<1.22869,0.380213,-0.128450>,<1.28095,0.211620,-3.50486e-2>,<1.16341,0.388699,0.162484>,<1.25526,0.483303,8.10655e-2>,<1.28583,0.479313,-2.86769e-2>,<1.16663,0.196854,-6.71741e-2>,<1.16663,0.196854,6.71741e-2>,<1.12607,0.194877,-0.113802>,<1.18757,0.186859,-1.33579e-2>,<1.18757,0.186859,1.33579e-2>,<1.12607,0.194877,0.113802>,<1.30989,0.422850,-3.75801e-2>,<1.31661,0.408675,-1.19416e-2>,<1.31435,0.369071,-3.39544e-3>,<1.30286,0.370550,-3.85026e-2>,<1.29136,0.372030,-7.36097e-2>,<1.29967,0.410875,-6.36798e-2>,<1.30989,0.422850,-3.75801e-2>,<1.30286,0.370550,-3.85026e-2>,<1.29582,0.318251,-3.94251e-2>,<1.28881,0.332445,-6.59860e-2>,<1.29136,0.372030,-7.36097e-2>,<1.30286,0.370550,-3.85026e-2>,<1.31435,0.369071,-3.39544e-3>,<1.30636,0.330206,-1.24028e-2>,<1.29582,0.318251,-3.94251e-2>,<1.30286,0.370550,-3.85026e-2>,<1.27096,0.428087,0.103993>,<1.24963,0.417567,0.126099>,<1.23666,0.379345,0.135731>,<1.26289,0.375910,0.106613>,<1.28913,0.372477,7.74952e-2>,<1.28826,0.412521,8.31971e-2>,<1.27096,0.428089,0.103993>,<1.26290,0.375912,0.106613>,<1.25483,0.323736,0.109237>,<1.27688,0.334152,8.63551e-2>,<1.28913,0.372478,7.74980e-2>,<1.26289,0.375913,0.106616>,<1.23666,0.379345,0.135734>,<1.23680,0.339406,0.130808>,<1.25483,0.323733,0.109237>,<1.26289,0.375910,0.106616>,<1.30292,0.263576,-3.85425e-2>,<1.26229,0.268846,0.106951>,<1.28680,0.275503,8.05487e-2>,<1.31429,0.265544,-7.50709e-3>,<1.29293,0.259804,-2.57488e-2>,<1.29771,0.261024,-1.06478e-2>,<1.28361,0.218026,-5.65726e-3>,<1.27677,0.222364,-2.31115e-2>,<1.26928,0.269421,7.84447e-2>,<1.25690,0.265913,9.21401e-2>,<1.24264,0.230030,8.72629e-2>,<1.25718,0.231485,7.14771e-2>,<1.20192,0.208247,-6.86357e-2>,<1.21297,0.208247,6.86357e-2>,<1.15470,0.204359,-0.121873>,<1.23565,0.195230,-6.67893e-3>,<1.23565,0.195230,6.67893e-3>,<1.15470,0.204359,0.121873>,<0.415298,-3.51183e-2,0.362186>,<0.207649,-3.51609e-2,0.392796>,<0.207649,-3.51609e-2,-0.392796>,<0.415298,-3.51183e-2,-0.362186>,<-0.415298,-3.51183e-2,0.362186>,<-0.207649,-3.51609e-2,0.392796>,<-0.207649,-3.51609e-2,-0.392796>,<-0.415298,-3.51183e-2,-0.362186>,<2.67998e-2,-3.21378e-2,0.392093>,<2.67998e-2,-3.21378e-2,-0.392093>,<0.180601,-3.56947e-2,-0.369440>,<0.180601,-3.56947e-2,0.369440>,<0.388244,-3.51238e-2,0.338828>,<0.234703,-3.51553e-2,0.361462>,<0.234703,-3.51553e-2,-0.361462>,<0.388244,-3.51238e-2,-0.338828>,<-0.234703,-3.51553e-2,0.361462>,<-0.388244,-3.51238e-2,0.338828>,<-0.388244,-3.51238e-2,-0.338828>,<-0.234703,-3.51553e-2,-0.361462>,<-2.67998e-2,-3.21378e-2,0.392093>,<-0.180601,-3.56947e-2,0.369440>,<-0.180601,-3.56947e-2,-0.369440>,<-2.67998e-2,-3.21378e-2,-0.392093>,<-0.606481,-3.59244e-2,0.309580>,<-0.747181,-1.49921e-2,-5.01630e-17>,<-0.606481,-3.59244e-2,-0.309580>,<-0.439423,-3.39388e-2,-0.334233>,<-0.439423,-3.39388e-2,0.334233>,<0.747181,-1.49921e-2,5.03811e-17>,<0.606481,-3.59244e-2,0.309580>,<0.439423,-3.39388e-2,0.334233>,<0.439423,-3.39388e-2,-0.334233>,<0.606481,-3.59244e-2,-0.309580>}
normal_vectors {1464,<3.57763e-17,0.582397,0.812905>,<0.757485,0.652853,9.70154e-17>,<-0.757485,0.652853,-2.39256e-16>,<6.54517e-17,-0.562115,0.827059>,<0.458253,0.620347,0.636533>,<-0.458253,0.620347,0.636533>,<0.147512,-0.989060,-1.13915e-16>,<-0.166562,-0.986031,1.01196e-17>,<0.115544,-0.965963,0.231440>,<-1.59333e-16,1.00000,1.13136e-16>,<-0.115544,-0.965963,0.231440>,<-0.594738,0.315380,0.739474>,<0.594738,0.315380,0.739474>,<-0.890881,0.454236,2.06603e-15>,<-2.44392e-16,0.482425,0.875937>,<0.890881,0.454236,-2.59241e-15>,<5.45593e-17,0.831896,0.554932>,<-0.411959,0.911202,-1.30690e-15>,<0.411959,0.911202,-1.64304e-15>,<-0.140833,0.914351,0.379642>,<0.140833,0.914351,0.379642>,<0.417530,0.889414,0.186040>,<-0.489683,0.768129,0.412540>,<3.09848e-2,-0.600805,0.798795>,<0.802074,-0.485724,0.347490>,<0.901428,-0.419700,0.106207>,<0.717456,0.694949,-4.79881e-2>,<3.44195e-3,0.855071,0.518499>,<0.230310,-0.536822,0.811652>,<-0.303539,0.148467,0.941181>,<0.796946,0.254066,0.548021>,<0.154633,0.953906,-0.257202>,<-0.874641,0.478235,-7.93312e-2>,<-0.927319,0.359557,-0.103919>,<-0.443614,3.80300e-2,0.895411>,<0.574969,0.749813,0.327400>,<0.115452,0.628466,-0.769221>,<0.489683,0.768129,0.412540>,<-0.417530,0.889414,0.186040>,<-0.802074,-0.485724,0.347490>,<-3.09848e-2,-0.600805,0.798795>,<-3.44195e-3,0.855071,0.518499>,<-0.497640,0.812213,-0.304409>,<-0.828421,-0.546470,0.122839>,<-0.230310,-0.536822,0.811652>,<0.771196,0.489965,-0.406436>,<-0.310144,0.930822,-0.193343>,<0.135441,0.231989,0.963243>,<0.570414,4.08877e-2,0.820339>,<0.381370,0.915541,-0.127838>,<-0.863959,0.395990,0.311073>,<-0.351701,0.904664,0.240603>,<-9.97439e-2,-0.437108,0.893861>,<0.707938,-0.389715,0.589021>,<0.299174,0.945565,-0.128071>,<0.326486,-0.480971,0.813679>,<0.901461,-0.430894,4.12150e-2>,<0.329577,0.917247,-0.223690>,<-0.137641,0.895371,0.423516>,<9.97439e-2,-0.437108,0.893861>,<0.351701,0.904664,0.240603>,<-0.299174,0.945565,-0.128071>,<-0.707938,-0.389715,0.589021>,<-0.329577,0.917247,-0.223690>,<-0.901461,-0.430894,4.12150e-2>,<-0.326486,-0.480971,0.813679>,<0.137641,0.895371,0.423516>,<-0.381370,0.915541,-0.127838>,<-0.499402,8.67560e-2,0.862015>,<0.863959,0.395990,0.311073>,<0.310144,0.930822,-0.193343>,<-0.771196,0.489965,-0.406436>,<-0.135441,0.231989,0.963243>,<0.443614,3.80300e-2,0.895411>,<0.927319,0.359557,-0.103919>,<-0.115452,0.628466,-0.769221>,<-0.574969,0.749813,0.327400>,<-0.796946,0.254066,0.548021>,<0.303539,0.148467,0.941181>,<0.874641,0.478235,-7.93312e-2>,<-0.154633,0.953906,-0.257202>,<0.324164,0.400733,0.856931>,<0.193689,0.416765,0.888140>,<0.331345,7.56277e-2,0.940474>,<0.438182,8.75326e-2,0.894614>,<0.848205,0.117431,0.516486>,<0.800073,0.464055,0.380179>,<0.743894,0.407259,0.529869>,<0.788395,0.109947,0.605265>,<-9.14835e-2,0.708953,0.699297>,<9.82498e-2,0.729264,0.677142>,<-1.36764e-2,0.884068,0.467159>,<-0.224218,0.818936,0.528271>,<-0.605272,0.782891,0.143969>,<-0.531679,0.785055,0.317815>,<-0.306759,0.923579,0.230001>,<-0.431084,0.900777,5.26006e-2>,<-0.193689,0.416765,0.888140>,<-0.324164,0.400733,0.856931>,<-0.438182,8.75326e-2,0.894614>,<-0.331345,7.56277e-2,0.940474>,<-0.743894,0.407259,0.529869>,<-0.798912,0.423538,0.427029>,<-0.848205,0.117431,0.516486>,<-0.788395,0.109947,0.605265>,<0.421652,0.893154,-0.156478>,<8.42984e-2,0.996016,-2.90754e-2>,<0.215247,0.898855,0.381744>,<0.394988,0.708673,0.584608>,<0.266581,0.919114,0.290111>,<-0.139570,0.881739,0.450619>,<0.163315,0.677300,0.717352>,<0.356922,0.355922,0.863670>,<0.464309,0.259112,0.846923>,<0.319888,0.568104,0.758241>,<0.755778,0.238539,0.609835>,<0.798365,0.290696,0.527361>,<0.705806,0.587473,0.395871>,<0.680646,0.531764,0.503933>,<-0.356922,0.355922,0.863670>,<-0.163315,0.677300,0.717352>,<-0.319888,0.568104,0.758241>,<-0.464309,0.259112,0.846923>,<-0.705806,0.587473,0.395871>,<-0.798365,0.290696,0.527361>,<-0.755778,0.238539,0.609835>,<-0.680646,0.531764,0.503933>,<-0.266581,0.919114,0.290111>,<-0.394988,0.708673,0.584608>,<0.139570,0.881739,0.450619>,<-8.42984e-2,0.996016,-2.90754e-2>,<-0.421652,0.893154,-0.156478>,<-0.215247,0.898855,0.381744>,<0.531679,0.785055,0.317815>,<0.605272,0.782891,0.143969>,<0.431084,0.900777,5.26006e-2>,<0.306759,0.923579,0.230001>,<-9.82498e-2,0.729264,0.677142>,<9.14835e-2,0.708953,0.699297>,<0.224218,0.818936,0.528271>,<1.36764e-2,0.884068,0.467159>,<0.153789,0.583533,0.797394>,<-0.153789,0.583533,0.797394>,<0.909207,0.416344,-1.31020e-16>,<2.92513e-17,0.432458,0.901654>,<0.687650,0.629072,0.362500>,<-0.687650,0.629072,0.362500>,<-0.731246,0.682113,6.78098e-15>,<8.18820e-2,-0.977840,0.192677>,<0.590318,0.308311,0.745968>,<0.151462,-0.974953,0.162871>,<0.242716,0.860959,0.447034>,<-0.242716,0.860959,0.447034>,<-0.590318,0.308311,0.745968>,<-8.18820e-2,-0.977840,0.192677>,<-0.151462,-0.974953,0.162871>,<0.507881,0.861427,3.54230e-15>,<-0.507881,0.861427,3.09204e-15>,<2.41738e-16,0.803415,0.595419>,<-0.219514,0.927510,0.302556>,<0.219514,0.927510,0.302556>,<-0.909207,0.416344,-1.09184e-16>,<1.23754e-16,0.246980,0.969021>,<0.704191,0.710011,-1.10698e-14>,<0.315214,0.359348,0.878356>,<0.775927,0.346869,0.526896>,<-0.315214,0.359348,0.878356>,<-0.775927,0.346869,0.526896>,<-1.87728e-16,0.876552,0.481306>,<-0.276270,0.961080,-4.86075e-15>,<0.276270,0.961080,5.05936e-15>,<-5.45423e-2,0.954889,0.291913>,<5.45423e-2,0.954889,0.291913>,<-0.107376,0.832878,0.542941>,<-0.383120,0.912164,0.145521>,<0.383120,0.912164,0.145521>,<0.107376,0.832878,0.542941>,<-0.187392,0.949556,0.251452>,<0.441907,0.549554,0.709019>,<-0.554089,2.05480e-2,0.832204>,<-8.06281e-2,0.556716,0.826780>,<0.390855,-0.799634,0.455870>,<0.174850,-2.61784e-2,0.984247>,<0.934832,0.237805,0.263700>,<0.627331,-1.74198e-2,0.778558>,<0.922623,0.211582,0.322489>,<0.872056,0.133701,0.470789>,<0.148757,0.986934,-6.19107e-2>,<0.782364,0.243722,0.573154>,<5.63183e-2,0.188473,0.980462>,<0.546757,0.559893,0.622557>,<0.436927,-0.806052,0.399219>,<0.649159,-2.77190e-2,0.760148>,<0.472543,-0.114706,0.873811>,<-9.96399e-2,0.656304,0.747888>,<0.769474,0.636495,-5.27574e-2>,<0.372828,0.633821,0.677695>,<-0.501118,0.778479,-0.377955>,<2.52516e-2,0.931899,0.361839>,<-0.894445,0.266252,0.359273>,<-0.440898,0.813991,0.378191>,<-0.829027,-3.70110e-2,0.557982>,<-0.698922,0.704653,0.122359>,<0.160606,0.448625,0.879171>,<-0.509209,0.640056,0.575356>,<0.317372,0.907307,-0.275805>,<-0.117741,0.965026,0.234228>,<-0.421909,0.500188,-0.756178>,<-0.282441,0.926996,-0.246791>,<0.187392,0.949556,0.251452>,<8.06281e-2,0.556716,0.826780>,<-0.934832,0.237805,0.263700>,<-0.441907,0.549554,0.709019>,<-0.390855,-0.799634,0.455870>,<-0.627331,-1.74198e-2,0.778558>,<0.554089,2.05480e-2,0.832204>,<-0.174850,-2.61784e-2,0.984247>,<-0.146409,0.987564,-5.72907e-2>,<-0.546757,0.559893,0.622557>,<-0.914830,0.125162,-0.383954>,<-0.753465,0.653227,7.47238e-2>,<-0.436927,-0.806052,0.399219>,<-0.911166,9.64858e-2,0.400583>,<-5.63183e-2,0.188473,0.980462>,<-0.649159,-2.77190e-2,0.760148>,<0.122259,0.426319,-0.896272>,<0.474259,0.878092,-6.34995e-2>,<-0.485156,0.571312,0.661986>,<5.80385e-2,0.998309,-3.20211e-3>,<0.875911,0.180338,0.447503>,<0.273050,0.826661,0.492011>,<0.978290,0.183368,9.65699e-2>,<0.236431,0.691950,0.682133>,<-0.538155,0.800376,-0.264175>,<0.216754,0.936133,0.276897>,<-0.285035,0.180252,0.941416>,<-0.249757,0.825287,0.506481>,<-0.587916,0.467616,0.660068>,<-3.66014e-2,0.766526,0.641169>,<0.349744,-0.671535,0.653238>,<-3.68097e-2,-0.435389,0.899489>,<0.965731,0.198494,0.167222>,<0.249974,-0.596464,0.762721>,<-0.201490,0.979490,-2.97759e-4>,<0.449930,0.678614,0.580556>,<0.548540,-0.711341,0.439428>,<0.689556,-0.570255,0.446455>,<0.779951,0.472771,-0.410078>,<0.711892,-0.428137,0.556694>,<-1.83142e-2,0.994673,-0.101437>,<0.706657,0.669301,0.229503>,<2.54300e-2,0.251387,0.967553>,<0.477088,0.649756,0.591780>,<0.587916,0.467616,0.660068>,<3.68097e-2,-0.435389,0.899489>,<0.201490,0.979490,-2.97759e-4>,<3.66014e-2,0.766526,0.641169>,<-0.965731,0.198494,0.167222>,<-0.449930,0.678614,0.580556>,<-0.349744,-0.671535,0.653238>,<-0.249974,-0.596464,0.762721>,<-0.779951,0.472771,-0.410078>,<-0.706657,0.669301,0.229503>,<-0.548540,-0.711341,0.439428>,<-0.845056,-0.282461,0.453977>,<-2.54300e-2,0.251387,0.967553>,<-0.689556,-0.570255,0.446455>,<1.83142e-2,0.994673,-0.101437>,<-0.477088,0.649756,0.591780>,<-0.978290,0.183368,9.65699e-2>,<-0.216754,0.936133,0.276897>,<0.367702,0.150903,0.917618>,<-0.253785,0.746138,0.615525>,<0.538155,0.800376,-0.264175>,<0.249757,0.825287,0.506481>,<-0.122259,0.426319,-0.896272>,<-5.80385e-2,0.998309,-3.20211e-3>,<-0.875911,0.180338,0.447503>,<-0.474259,0.878092,-6.34995e-2>,<0.485156,0.571312,0.661986>,<-0.273050,0.826661,0.492011>,<0.829027,-3.70110e-2,0.557982>,<0.509209,0.640056,0.575356>,<0.421909,0.500188,-0.756178>,<0.698922,0.704653,0.122359>,<-0.317372,0.907307,-0.275805>,<0.282441,0.926996,-0.246791>,<-0.160606,0.448625,0.879171>,<0.117741,0.965026,0.234228>,<-0.472543,-0.114706,0.873811>,<-0.372828,0.633821,0.677695>,<0.894445,0.266252,0.359273>,<9.96399e-2,0.656304,0.747888>,<0.501118,0.778479,-0.377955>,<0.440898,0.813991,0.378191>,<-0.769474,0.636495,-5.27574e-2>,<-2.52516e-2,0.931899,0.361839>,<0.250080,0.434653,0.865180>,<0.320115,0.828572,0.459342>,<0.221505,0.256858,0.940723>,<-0.215720,0.654618,0.724527>,<0.395276,4.87721e-2,0.917267>,<-9.38772e-3,-0.520942,0.853540>,<0.436349,0.249568,0.864474>,<0.700575,-0.380556,0.603632>,<0.872113,0.312652,0.376388>,<0.887402,-0.405322,0.219618>,<0.764373,0.440107,0.471211>,<0.580779,0.805063,-0.120706>,<0.746946,0.260419,0.611763>,<0.299806,0.817148,0.492326>,<0.819987,8.22597e-2,0.566440>,<0.494981,-0.405716,0.768367>,<4.32162e-2,0.699871,0.712961>,<-0.332935,3.51870e-2,0.942293>,<8.54629e-2,0.819076,0.567283>,<0.705918,0.383840,0.595271>,<-0.174547,0.864527,0.471304>,<0.169608,0.923669,-0.343610>,<-0.237054,0.772766,0.588760>,<-0.654485,0.744991,0.128984>,<-0.569565,0.781361,0.255088>,<-0.958005,0.234166,-0.165510>,<-0.407768,0.860010,0.306771>,<-0.365153,0.438815,0.821039>,<-0.353315,0.930693,9.47603e-2>,<0.306448,0.904459,0.296723>,<-0.501063,0.863927,5.06609e-2>,<-0.210369,0.902567,-0.375655>,<-0.250080,0.434653,0.865180>,<0.215720,0.654618,0.724527>,<-0.436349,0.249568,0.864474>,<-0.320115,0.828572,0.459342>,<-0.395276,4.87721e-2,0.917267>,<-0.700575,-0.380556,0.603632>,<-0.221505,0.256858,0.940723>,<9.38772e-3,-0.520942,0.853540>,<-0.764373,0.440107,0.471211>,<-0.299806,0.817148,0.492326>,<-0.853392,0.283523,0.437422>,<-0.610963,0.790262,-4.70138e-2>,<-0.819987,8.22597e-2,0.566440>,<-0.888048,-0.446812,0.108305>,<-0.746946,0.260419,0.611763>,<-0.494981,-0.405716,0.768367>,<0.282910,0.927729,-0.243474>,<0.793556,0.468809,-0.387927>,<7.34255e-2,0.950407,0.302216>,<-0.450918,0.855795,-0.253553>,<0.465877,0.861638,0.201339>,<0.275677,0.623303,0.731775>,<0.474887,0.759492,0.444583>,<0.626259,0.275156,0.729444>,<-6.39605e-2,0.948101,0.311471>,<0.410913,0.865128,-0.287582>,<4.76247e-2,0.743845,0.666653>,<-0.535630,0.680821,0.499583>,<0.211263,0.577601,0.788508>,<-0.345551,0.892007,0.291407>,<0.416139,0.268407,0.868784>,<0.138481,-0.193049,0.971368>,<0.450845,0.385708,0.804965>,<0.742189,-0.311663,0.593314>,<0.242519,0.644057,0.725517>,<0.422096,0.819535,0.387553>,<0.785089,0.232126,0.574241>,<0.556400,-0.316964,0.768084>,<0.770747,0.473215,0.426634>,<0.919746,-0.246663,0.305326>,<0.681628,0.581564,0.444035>,<0.410200,0.893148,-0.184450>,<0.707141,0.373798,0.600189>,<0.184274,0.883808,0.430030>,<-0.211263,0.577601,0.788508>,<-0.138481,-0.193049,0.971368>,<-0.242519,0.644057,0.725517>,<0.345551,0.892007,0.291407>,<-0.450845,0.385708,0.804965>,<-0.422096,0.819535,0.387553>,<-0.416139,0.268407,0.868784>,<-0.742189,-0.311663,0.593314>,<-0.770747,0.473215,0.426634>,<-0.410200,0.893148,-0.184450>,<-0.785089,0.232126,0.574241>,<-0.919746,-0.246663,0.305326>,<-0.707141,0.373798,0.600189>,<-0.556400,-0.316964,0.768084>,<-0.681628,0.581564,0.444035>,<-0.184274,0.883808,0.430030>,<-0.474887,0.759492,0.444583>,<-0.410913,0.865128,-0.287582>,<-4.76247e-2,0.743845,0.666653>,<-0.626259,0.275156,0.729444>,<6.39605e-2,0.948101,0.311471>,<0.535630,0.680821,0.499583>,<-0.282910,0.927729,-0.243474>,<0.450918,0.855795,-0.253553>,<-0.465877,0.861638,0.201339>,<-0.793556,0.468809,-0.387927>,<-7.34255e-2,0.950407,0.302216>,<-0.275677,0.623303,0.731775>,<0.569565,0.781361,0.255088>,<0.365153,0.438815,0.821039>,<0.501063,0.863927,5.06609e-2>,<0.958005,0.234166,-0.165510>,<0.353315,0.930693,9.47603e-2>,<0.210369,0.902567,-0.375655>,<0.407768,0.860010,0.306771>,<-0.306448,0.904459,0.296723>,<-4.32162e-2,0.699871,0.712961>,<-0.705918,0.383840,0.595271>,<0.237054,0.772766,0.588760>,<0.332935,3.51870e-2,0.942293>,<0.174547,0.864527,0.471304>,<0.654485,0.744991,0.128984>,<-8.54629e-2,0.819076,0.567283>,<-0.169608,0.923669,-0.343610>,<0.335490,0.247965,0.908823>,<0.805255,0.266303,0.529761>,<-5.56290e-2,0.795040,0.604000>,<-0.466321,0.863777,0.190877>,<-0.335490,0.247965,0.908823>,<-0.805255,0.266303,0.529761>,<-1.40055e-17,-0.998871,4.75095e-2>,<0.294603,0.950923,9.46302e-2>,<0.155713,0.849818,0.503550>,<0.342197,0.470393,0.813407>,<0.746273,0.415418,0.520100>,<-0.342197,0.470393,0.813407>,<-0.746273,0.415418,0.520100>,<-0.155713,0.849818,0.503550>,<-0.294603,0.950923,9.46302e-2>,<0.466321,0.863777,0.190877>,<5.56290e-2,0.795040,0.604000>,<7.65610e-2,0.697481,0.712501>,<-4.65819e-2,0.266702,0.962653>,<0.437134,-0.226319,0.870456>,<0.643084,0.255557,0.721896>,<0.829071,0.297264,0.473577>,<0.689683,0.571600,0.444535>,<0.563120,0.250984,0.787339>,<0.785721,-0.221827,0.577439>,<0.192826,0.438559,0.877772>,<0.336543,0.884704,0.322549>,<-0.211160,0.932910,0.291701>,<-0.438463,0.667549,0.601771>,<-0.754552,0.522670,0.396822>,<-0.122586,0.840052,0.528474>,<-0.214631,0.976680,5.41628e-3>,<-0.548353,0.815826,-0.183676>,<-7.65610e-2,0.697481,0.712501>,<-0.643084,0.255557,0.721896>,<-0.437134,-0.226319,0.870456>,<4.65819e-2,0.266702,0.962653>,<-0.602328,0.738130,0.303918>,<-0.907777,0.382719,0.171659>,<-0.785721,-0.221827,0.577439>,<-0.563120,0.250984,0.787339>,<0.273376,0.883960,-0.379315>,<-7.31782e-2,0.920243,0.384445>,<0.644278,0.727009,0.237411>,<0.577531,0.702583,0.415734>,<-0.158646,0.971717,0.174924>,<-2.45860e-2,0.653982,0.756110>,<-6.94529e-2,0.457999,0.886235>,<0.363066,-0.629275,0.687165>,<0.337106,0.772413,0.538272>,<0.100339,0.833572,0.543222>,<0.595961,-0.667852,0.445876>,<0.679739,0.640907,0.356643>,<0.516166,0.804292,0.294428>,<0.436276,0.781091,0.446721>,<6.94529e-2,0.457999,0.886235>,<-0.100339,0.833572,0.543222>,<-0.337106,0.772413,0.538272>,<-0.363066,-0.629275,0.687165>,<-0.842843,0.468215,0.265310>,<-0.595961,-0.667852,0.445876>,<-0.436276,0.781091,0.446721>,<-0.516166,0.804292,0.294428>,<-0.577531,0.702583,0.415734>,<-3.36661e-3,0.585493,0.810670>,<0.158646,0.971717,0.174924>,<-0.273376,0.883960,-0.379315>,<-0.644278,0.727009,0.237411>,<7.31782e-2,0.920243,0.384445>,<0.754552,0.522670,0.396822>,<0.548353,0.815826,-0.183676>,<0.214631,0.976680,5.41628e-3>,<0.122586,0.840052,0.528474>,<-0.192826,0.438559,0.877772>,<0.438463,0.667549,0.601771>,<0.211160,0.932910,0.291701>,<-0.336543,0.884704,0.322549>,<-6.44294e-2,0.821153,0.567059>,<-0.530298,0.275655,0.801747>,<0.448444,-0.395384,0.801605>,<0.955498,0.235990,0.177008>,<0.858145,0.233747,-0.457110>,<0.541355,0.806646,0.237186>,<-2.41228e-2,0.177829,0.983766>,<0.739734,-0.369576,0.562323>,<0.268579,0.354079,0.895820>,<0.489801,0.844267,0.217506>,<-0.349275,0.936966,-1.00712e-2>,<-0.768296,0.481324,0.421958>,<-0.789098,0.300998,0.535467>,<0.140670,0.719645,0.679944>,<0.309993,0.917358,-0.249718>,<-0.440291,0.679932,-0.586375>,<6.44294e-2,0.821153,0.567059>,<-0.955498,0.235990,0.177008>,<-0.448444,-0.395384,0.801605>,<0.530298,0.275655,0.801747>,<-0.552364,0.791563,0.261383>,<-0.869876,0.362149,-0.334909>,<-0.739734,-0.369576,0.562323>,<2.41228e-2,0.177829,0.983766>,<0.221006,0.740670,-0.634479>,<-0.293966,0.720425,0.628150>,<0.803005,0.226535,0.551239>,<0.805261,0.514567,0.294577>,<-0.458509,0.887009,-5.46306e-2>,<-0.338709,2.82540e-2,0.940467>,<-0.471114,0.265812,0.841068>,<0.447251,-0.191523,0.873662>,<0.885203,0.439201,0.153359>,<-9.73315e-4,0.955112,0.296244>,<0.774111,-0.227388,0.590802>,<0.925827,0.250554,-0.282963>,<0.414310,0.884055,0.216320>,<-3.67853e-2,0.228852,0.972766>,<0.471114,0.265812,0.841068>,<9.73315e-4,0.955112,0.296244>,<-0.885203,0.439201,0.153359>,<-0.447251,-0.191523,0.873662>,<-0.925827,0.250554,-0.282963>,<-0.774111,-0.227388,0.590802>,<3.67853e-2,0.228852,0.972766>,<-0.414310,0.884055,0.216320>,<-0.805261,0.514567,0.294577>,<0.338709,2.82540e-2,0.940467>,<0.458509,0.887009,-5.46306e-2>,<-0.221006,0.740670,-0.634479>,<-0.803005,0.226535,0.551239>,<0.293966,0.720425,0.628150>,<0.789098,0.300998,0.535467>,<0.440291,0.679932,-0.586375>,<-0.309993,0.917358,-0.249718>,<-0.140670,0.719645,0.679944>,<-0.268579,0.354079,0.895820>,<0.768296,0.481324,0.421958>,<0.349275,0.936966,-1.00712e-2>,<-0.489801,0.844267,0.217506>,<7.65612e-16,0.582397,-0.812905>,<-1.29691e-15,-0.562115,-0.827059>,<0.458253,0.620347,-0.636533>,<-0.458253,0.620347,-0.636533>,<0.115544,-0.965963,-0.231440>,<-0.115544,-0.965963,-0.231440>,<-0.594738,0.315380,-0.739474>,<0.594738,0.315380,-0.739474>,<3.57647e-16,0.482425,-0.875937>,<-4.26682e-16,0.831896,-0.554932>,<-0.140833,0.914351,-0.379642>,<0.140833,0.914351,-0.379642>,<0.417530,0.889414,-0.186040>,<-0.489683,0.768129,-0.412540>,<3.09848e-2,-0.600805,-0.798795>,<0.802074,-0.485724,-0.347490>,<0.828421,-0.546470,-0.122839>,<0.497640,0.812213,0.304409>,<3.44195e-3,0.855071,-0.518499>,<0.230310,-0.536822,-0.811652>,<-0.303539,0.148467,-0.941181>,<0.796946,0.254066,-0.548021>,<0.154633,0.953906,0.257202>,<-0.874641,0.478235,7.93312e-2>,<-0.927319,0.359557,0.103919>,<-0.443614,3.80300e-2,-0.895411>,<0.533303,0.793549,-0.293033>,<0.115452,0.628466,0.769221>,<0.489683,0.768129,-0.412540>,<-0.417530,0.889414,-0.186040>,<-0.802074,-0.485724,-0.347490>,<-3.09848e-2,-0.600805,-0.798795>,<-3.44195e-3,0.855071,-0.518499>,<-0.497640,0.812213,0.304409>,<-0.828421,-0.546470,-0.122839>,<-0.230310,-0.536822,-0.811652>,<0.720024,0.464227,0.515809>,<-0.310144,0.930822,0.193343>,<0.135441,0.231989,-0.963243>,<0.570414,4.08877e-2,-0.820339>,<0.381370,0.915541,0.127838>,<-0.863959,0.395990,-0.311073>,<-0.351701,0.904664,-0.240603>,<-9.97439e-2,-0.437108,-0.893861>,<0.707938,-0.389715,-0.589021>,<0.299174,0.945565,0.128071>,<0.326486,-0.480971,-0.813679>,<0.901461,-0.430894,-4.12150e-2>,<0.329577,0.917247,0.223690>,<-0.137641,0.895371,-0.423516>,<9.97439e-2,-0.437108,-0.893861>,<0.351701,0.904664,-0.240603>,<-0.299174,0.945565,0.128071>,<-0.707938,-0.389715,-0.589021>,<-0.329577,0.917247,0.223690>,<-0.901461,-0.430894,-4.12150e-2>,<-0.326486,-0.480971,-0.813679>,<0.137641,0.895371,-0.423516>,<-0.381370,0.915541,0.127838>,<-0.499402,8.67560e-2,-0.862015>,<0.863959,0.395990,-0.311073>,<0.310144,0.930822,0.193343>,<-0.720024,0.464227,0.515809>,<-0.135441,0.231989,-0.963243>,<0.443614,3.80300e-2,-0.895411>,<0.927319,0.359557,0.103919>,<-0.115452,0.628466,0.769221>,<-0.533303,0.793549,-0.293033>,<-0.796946,0.254066,-0.548021>,<0.303539,0.148467,-0.941181>,<0.874641,0.478235,7.93312e-2>,<-0.154633,0.953906,0.257202>,<0.324164,0.400733,-0.856931>,<0.193689,0.416765,-0.888140>,<0.331345,7.56277e-2,-0.940474>,<0.438182,8.75326e-2,-0.894614>,<0.848205,0.117431,-0.516486>,<0.798912,0.423538,-0.427029>,<0.743894,0.407259,-0.529869>,<0.788395,0.109947,-0.605265>,<-9.14835e-2,0.708953,-0.699297>,<9.82498e-2,0.729264,-0.677142>,<-1.36764e-2,0.884068,-0.467159>,<-0.224218,0.818936,-0.528271>,<-0.605272,0.782891,-0.143969>,<-0.531679,0.785055,-0.317815>,<-0.306759,0.923579,-0.230001>,<-0.431084,0.900777,-5.26006e-2>,<-0.193689,0.416765,-0.888140>,<-0.324164,0.400733,-0.856931>,<-0.438182,8.75326e-2,-0.894614>,<-0.331345,7.56277e-2,-0.940474>,<-0.743894,0.407259,-0.529869>,<-0.798912,0.423538,-0.427029>,<-0.848205,0.117431,-0.516486>,<-0.788395,0.109947,-0.605265>,<0.421652,0.893154,0.156478>,<8.42984e-2,0.996016,2.90754e-2>,<0.215247,0.898855,-0.381744>,<0.394988,0.708673,-0.584608>,<0.266581,0.919114,-0.290111>,<-0.139570,0.881739,-0.450619>,<0.163315,0.677300,-0.717352>,<0.356922,0.355922,-0.863670>,<0.464309,0.259112,-0.846923>,<0.319888,0.568104,-0.758241>,<0.755778,0.238539,-0.609835>,<0.798365,0.290696,-0.527361>,<0.705806,0.587473,-0.395871>,<0.680646,0.531764,-0.503933>,<-0.356922,0.355922,-0.863670>,<-0.163315,0.677300,-0.717352>,<-0.319888,0.568104,-0.758241>,<-0.464309,0.259112,-0.846923>,<-0.705806,0.587473,-0.395871>,<-0.798365,0.290696,-0.527361>,<-0.755778,0.238539,-0.609835>,<-0.680646,0.531764,-0.503933>,<-0.266581,0.919114,-0.290111>,<-0.394988,0.708673,-0.584608>,<0.139570,0.881739,-0.450619>,<-8.42984e-2,0.996016,2.90754e-2>,<-0.421652,0.893154,0.156478>,<-0.215247,0.898855,-0.381744>,<0.531679,0.785055,-0.317815>,<0.605272,0.782891,-0.143969>,<0.431084,0.900777,-5.26006e-2>,<0.306759,0.923579,-0.230001>,<-9.82498e-2,0.729264,-0.677142>,<9.14835e-2,0.708953,-0.699297>,<0.224218,0.818936,-0.528271>,<1.36764e-2,0.884068,-0.467159>,<0.153789,0.583533,-0.797394>,<-0.153789,0.583533,-0.797394>,<-3.20301e-15,0.432458,-0.901654>,<0.687650,0.629072,-0.362500>,<-0.687650,0.629072,-0.362500>,<8.18820e-2,-0.977840,-0.192677>,<0.590318,0.308311,-0.745968>,<0.151462,-0.974953,-0.162871>,<0.242716,0.860959,-0.447034>,<-0.242716,0.860959,-0.447034>,<-0.590318,0.308311,-0.745968>,<-8.18820e-2,-0.977840,-0.192677>,<-0.151462,-0.974953,-0.162871>,<-3.22172e-15,0.803415,-0.595419>,<-0.219514,0.927510,-0.302556>,<0.219514,0.927510,-0.302556>,<-1.07237e-14,0.246980,-0.969021>,<0.315214,0.359348,-0.878356>,<0.775927,0.346869,-0.526896>,<-0.315214,0.359348,-0.878356>,<-0.775927,0.346869,-0.526896>,<8.08674e-16,0.876552,-0.481306>,<-5.45423e-2,0.954889,-0.291913>,<5.45423e-2,0.954889,-0.291913>,<-0.107376,0.832878,-0.542941>,<-0.383120,0.912164,-0.145521>,<0.383120,0.912164,-0.145521>,<0.107376,0.832878,-0.542941>,<-0.187392,0.949556,-0.251452>,<0.441907,0.549554,-0.709019>,<-0.554089,2.05480e-2,-0.832204>,<-8.06281e-2,0.556716,-0.826780>,<0.390855,-0.799634,-0.455870>,<0.174850,-2.61784e-2,-0.984247>,<0.934832,0.237805,-0.263700>,<0.627331,-1.74198e-2,-0.778558>,<0.914830,0.125162,0.383954>,<0.911166,9.64858e-2,-0.400583>,<0.146409,0.987564,5.72907e-2>,<0.753465,0.653227,-7.47238e-2>,<5.63183e-2,0.188473,-0.980462>,<0.546757,0.559893,-0.622557>,<0.436927,-0.806052,-0.399219>,<0.649159,-2.77190e-2,-0.760148>,<0.472543,-0.114706,-0.873811>,<-9.96399e-2,0.656304,-0.747888>,<0.769474,0.636495,5.27574e-2>,<0.372828,0.633821,-0.677695>,<-0.501118,0.778479,0.377955>,<2.52516e-2,0.931899,-0.361839>,<-0.894445,0.266252,-0.359273>,<-0.440898,0.813991,-0.378191>,<-0.829027,-3.70110e-2,-0.557982>,<-0.698922,0.704653,-0.122359>,<0.160606,0.448625,-0.879171>,<-0.509209,0.640056,-0.575356>,<0.332523,0.878696,0.342524>,<-0.174354,0.948789,-0.263439>,<-0.421909,0.500188,0.756178>,<-0.282441,0.926996,0.246791>,<0.187392,0.949556,-0.251452>,<8.06281e-2,0.556716,-0.826780>,<-0.934832,0.237805,-0.263700>,<-0.441907,0.549554,-0.709019>,<-0.390855,-0.799634,-0.455870>,<-0.627331,-1.74198e-2,-0.778558>,<0.554089,2.05480e-2,-0.832204>,<-0.174850,-2.61784e-2,-0.984247>,<-0.146409,0.987564,5.72907e-2>,<-0.546757,0.559893,-0.622557>,<-0.914830,0.125162,0.383954>,<-0.753465,0.653227,-7.47238e-2>,<-0.436927,-0.806052,-0.399219>,<-0.911166,9.64858e-2,-0.400583>,<-5.63183e-2,0.188473,-0.980462>,<-0.649159,-2.77190e-2,-0.760148>,<0.122259,0.426319,0.896272>,<0.542113,0.839324,4.06015e-2>,<-0.485156,0.571312,-0.661986>,<5.80385e-2,0.998309,3.20211e-3>,<0.886515,0.238153,-0.396703>,<0.273050,0.826661,-0.492011>,<0.978290,0.183368,-9.65699e-2>,<0.236431,0.691950,-0.682133>,<-0.538155,0.800376,0.264175>,<0.216754,0.936133,-0.276897>,<-0.285035,0.180252,-0.941416>,<-0.249757,0.825287,-0.506481>,<-0.587916,0.467616,-0.660068>,<-3.66014e-2,0.766526,-0.641169>,<0.349744,-0.671535,-0.653238>,<-3.68097e-2,-0.435389,-0.899489>,<0.965731,0.198494,-0.167222>,<0.249974,-0.596464,-0.762721>,<-0.201490,0.979490,2.97759e-4>,<0.449930,0.678614,-0.580556>,<0.548540,-0.711341,-0.439428>,<0.689556,-0.570255,-0.446455>,<0.779951,0.472771,0.410078>,<0.711892,-0.428137,-0.556694>,<-1.83142e-2,0.994673,0.101437>,<0.706657,0.669301,-0.229503>,<2.54300e-2,0.251387,-0.967553>,<0.477088,0.649756,-0.591780>,<0.587916,0.467616,-0.660068>,<3.68097e-2,-0.435389,-0.899489>,<0.201490,0.979490,2.97759e-4>,<3.66014e-2,0.766526,-0.641169>,<-0.965731,0.198494,-0.167222>,<-0.449930,0.678614,-0.580556>,<-0.349744,-0.671535,-0.653238>,<-0.249974,-0.596464,-0.762721>,<-0.779951,0.472771,0.410078>,<-0.706657,0.669301,-0.229503>,<-0.548540,-0.711341,-0.439428>,<-0.845056,-0.282461,-0.453977>,<-2.54300e-2,0.251387,-0.967553>,<-0.689556,-0.570255,-0.446455>,<1.83142e-2,0.994673,0.101437>,<-0.477088,0.649756,-0.591780>,<-0.978290,0.183368,-9.65699e-2>,<-0.216754,0.936133,-0.276897>,<0.367702,0.150903,-0.917618>,<-0.253785,0.746138,-0.615525>,<0.538155,0.800376,0.264175>,<0.249757,0.825287,-0.506481>,<-0.122259,0.426319,0.896272>,<-5.80385e-2,0.998309,3.20211e-3>,<-0.886515,0.238153,-0.396703>,<-0.542113,0.839324,4.06015e-2>,<0.485156,0.571312,-0.661986>,<-0.273050,0.826661,-0.492011>,<0.829027,-3.70110e-2,-0.557982>,<0.509209,0.640056,-0.575356>,<0.421909,0.500188,0.756178>,<0.698922,0.704653,-0.122359>,<-0.332523,0.878696,0.342524>,<0.282441,0.926996,0.246791>,<-0.160606,0.448625,-0.879171>,<0.174354,0.948789,-0.263439>,<-0.472543,-0.114706,-0.873811>,<-0.372828,0.633821,-0.677695>,<0.894445,0.266252,-0.359273>,<9.96399e-2,0.656304,-0.747888>,<0.501118,0.778479,0.377955>,<0.440898,0.813991,-0.378191>,<-0.769474,0.636495,5.27574e-2>,<-2.52516e-2,0.931899,-0.361839>,<0.250080,0.434653,-0.865180>,<0.320115,0.828572,-0.459342>,<0.221505,0.256858,-0.940723>,<-0.215720,0.654618,-0.724527>,<0.395276,4.87721e-2,-0.917267>,<-9.38772e-3,-0.520942,-0.853540>,<0.436349,0.249568,-0.864474>,<0.700575,-0.380556,-0.603632>,<0.853392,0.283523,-0.437422>,<0.888048,-0.446812,-0.108305>,<0.764373,0.440107,-0.471211>,<0.610963,0.790262,4.70138e-2>,<0.746946,0.260419,-0.611763>,<0.299806,0.817148,-0.492326>,<0.819987,8.22597e-2,-0.566440>,<0.494981,-0.405716,-0.768367>,<4.32162e-2,0.699871,-0.712961>,<-0.332935,3.51870e-2,-0.942293>,<8.54629e-2,0.819076,-0.567283>,<0.705918,0.383840,-0.595271>,<-0.174547,0.864527,-0.471304>,<0.169608,0.923669,0.343610>,<-0.237054,0.772766,-0.588760>,<-0.654485,0.744991,-0.128984>,<-0.569565,0.781361,-0.255088>,<-0.958005,0.234166,0.165510>,<-0.407768,0.860010,-0.306771>,<-0.365153,0.438815,-0.821039>,<-0.353315,0.930693,-9.47603e-2>,<0.306448,0.904459,-0.296723>,<-0.501063,0.863927,-5.06609e-2>,<-0.210369,0.902567,0.375655>,<-0.250080,0.434653,-0.865180>,<0.215720,0.654618,-0.724527>,<-0.436349,0.249568,-0.864474>,<-0.320115,0.828572,-0.459342>,<-0.395276,4.87721e-2,-0.917267>,<-0.700575,-0.380556,-0.603632>,<-0.221505,0.256858,-0.940723>,<9.38772e-3,-0.520942,-0.853540>,<-0.764373,0.440107,-0.471211>,<-0.299806,0.817148,-0.492326>,<-0.853392,0.283523,-0.437422>,<-0.610963,0.790262,4.70138e-2>,<-0.819987,8.22597e-2,-0.566440>,<-0.888048,-0.446812,-0.108305>,<-0.746946,0.260419,-0.611763>,<-0.494981,-0.405716,-0.768367>,<0.282910,0.927729,0.243474>,<0.793556,0.468809,0.387927>,<7.34255e-2,0.950407,-0.302216>,<-0.450918,0.855795,0.253553>,<0.465877,0.861638,-0.201339>,<0.275677,0.623303,-0.731775>,<0.474887,0.759492,-0.444583>,<0.626259,0.275156,-0.729444>,<-6.39605e-2,0.948101,-0.311471>,<0.410913,0.865128,0.287582>,<4.76247e-2,0.743845,-0.666653>,<-0.535630,0.680821,-0.499583>,<0.211263,0.577601,-0.788508>,<-0.345551,0.892007,-0.291407>,<0.416139,0.268407,-0.868784>,<0.138481,-0.193049,-0.971368>,<0.450845,0.385708,-0.804965>,<0.742189,-0.311663,-0.593314>,<0.242519,0.644057,-0.725517>,<0.422096,0.819535,-0.387553>,<0.785089,0.232126,-0.574241>,<0.556400,-0.316964,-0.768084>,<0.770747,0.473215,-0.426634>,<0.919746,-0.246663,-0.305326>,<0.681628,0.581564,-0.444035>,<0.410200,0.893148,0.184450>,<0.707141,0.373798,-0.600189>,<0.184274,0.883808,-0.430030>,<-0.211263,0.577601,-0.788508>,<-0.138481,-0.193049,-0.971368>,<-0.242519,0.644057,-0.725517>,<0.345551,0.892007,-0.291407>,<-0.450845,0.385708,-0.804965>,<-0.422096,0.819535,-0.387553>,<-0.416139,0.268407,-0.868784>,<-0.742189,-0.311663,-0.593314>,<-0.770747,0.473215,-0.426634>,<-0.410200,0.893148,0.184450>,<-0.785089,0.232126,-0.574241>,<-0.919746,-0.246663,-0.305326>,<-0.707141,0.373798,-0.600189>,<-0.556400,-0.316964,-0.768084>,<-0.681628,0.581564,-0.444035>,<-0.184274,0.883808,-0.430030>,<-0.474887,0.759492,-0.444583>,<-0.410913,0.865128,0.287582>,<-4.76247e-2,0.743845,-0.666653>,<-0.626259,0.275156,-0.729444>,<6.39605e-2,0.948101,-0.311471>,<0.535630,0.680821,-0.499583>,<-0.282910,0.927729,0.243474>,<0.450918,0.855795,0.253553>,<-0.465877,0.861638,-0.201339>,<-0.793556,0.468809,0.387927>,<-7.34255e-2,0.950407,-0.302216>,<-0.275677,0.623303,-0.731775>,<0.569565,0.781361,-0.255088>,<0.365153,0.438815,-0.821039>,<0.501063,0.863927,-5.06609e-2>,<0.958005,0.234166,0.165510>,<0.353315,0.930693,-9.47603e-2>,<0.210369,0.902567,0.375655>,<0.407768,0.860010,-0.306771>,<-0.306448,0.904459,-0.296723>,<-4.32162e-2,0.699871,-0.712961>,<-0.705918,0.383840,-0.595271>,<0.237054,0.772766,-0.588760>,<0.332935,3.51870e-2,-0.942293>,<0.174547,0.864527,-0.471304>,<0.654485,0.744991,-0.128984>,<-8.54629e-2,0.819076,-0.567283>,<-0.169608,0.923669,0.343610>,<0.335490,0.247965,-0.908823>,<0.805255,0.266303,-0.529761>,<-5.56290e-2,0.795040,-0.604000>,<-0.466321,0.863777,-0.190877>,<-0.335490,0.247965,-0.908823>,<-0.805255,0.266303,-0.529761>,<-1.57612e-17,-0.998234,-5.94055e-2>,<0.294603,0.950923,-9.46302e-2>,<0.155713,0.849818,-0.503550>,<0.342197,0.470393,-0.813407>,<0.746273,0.415418,-0.520100>,<-0.342197,0.470393,-0.813407>,<-0.746273,0.415418,-0.520100>,<-0.155713,0.849818,-0.503550>,<-0.294603,0.950923,-9.46302e-2>,<0.466321,0.863777,-0.190877>,<5.56290e-2,0.795040,-0.604000>,<7.65610e-2,0.697481,-0.712501>,<-4.65819e-2,0.266702,-0.962653>,<0.437134,-0.226319,-0.870456>,<0.643084,0.255557,-0.721896>,<0.907777,0.382719,-0.171659>,<0.602328,0.738130,-0.303918>,<0.563120,0.250984,-0.787339>,<0.785721,-0.221827,-0.577439>,<0.192826,0.438559,-0.877772>,<0.336543,0.884704,-0.322549>,<-0.211160,0.932910,-0.291701>,<-0.438463,0.667549,-0.601771>,<-0.754552,0.522670,-0.396822>,<-0.122586,0.840052,-0.528474>,<-0.139416,0.990156,-1.24300e-2>,<-0.548353,0.815826,0.183676>,<-7.65610e-2,0.697481,-0.712501>,<-0.643084,0.255557,-0.721896>,<-0.437134,-0.226319,-0.870456>,<4.65819e-2,0.266702,-0.962653>,<-0.602328,0.738130,-0.303918>,<-0.907777,0.382719,-0.171659>,<-0.785721,-0.221827,-0.577439>,<-0.563120,0.250984,-0.787339>,<0.273376,0.883960,0.379315>,<-7.31782e-2,0.920243,-0.384445>,<0.575711,0.771012,-0.272209>,<0.577531,0.702583,-0.415734>,<-0.158646,0.971717,-0.174924>,<-2.45860e-2,0.653982,-0.756110>,<-6.94529e-2,0.457999,-0.886235>,<0.363066,-0.629275,-0.687165>,<0.337106,0.772413,-0.538272>,<0.100339,0.833572,-0.543222>,<0.595961,-0.667852,-0.445876>,<0.679739,0.640907,-0.356643>,<0.516166,0.804292,-0.294428>,<0.436276,0.781091,-0.446721>,<6.94529e-2,0.457999,-0.886235>,<-0.100339,0.833572,-0.543222>,<-0.337106,0.772413,-0.538272>,<-0.363066,-0.629275,-0.687165>,<-0.842843,0.468215,-0.265310>,<-0.595961,-0.667852,-0.445876>,<-0.436276,0.781091,-0.446721>,<-0.516166,0.804292,-0.294428>,<-0.577531,0.702583,-0.415734>,<-3.36661e-3,0.585493,-0.810670>,<0.158646,0.971717,-0.174924>,<-0.273376,0.883960,0.379315>,<-0.575711,0.771012,-0.272209>,<7.31782e-2,0.920243,-0.384445>,<0.754552,0.522670,-0.396822>,<0.548353,0.815826,0.183676>,<0.139416,0.990156,-1.24300e-2>,<0.122586,0.840052,-0.528474>,<-0.192826,0.438559,-0.877772>,<0.438463,0.667549,-0.601771>,<0.211160,0.932910,-0.291701>,<-0.336543,0.884704,-0.322549>,<-6.44294e-2,0.821153,-0.567059>,<-0.530298,0.275655,-0.801747>,<0.448444,-0.395384,-0.801605>,<0.955498,0.235990,-0.177008>,<0.869876,0.362149,0.334909>,<0.552364,0.791563,-0.261383>,<-2.41228e-2,0.177829,-0.983766>,<0.739734,-0.369576,-0.562323>,<0.268579,0.354079,-0.895820>,<0.489801,0.844267,-0.217506>,<-0.349275,0.936966,1.00712e-2>,<-0.768296,0.481324,-0.421958>,<-0.789098,0.300998,-0.535467>,<0.140670,0.719645,-0.679944>,<0.309993,0.917358,0.249718>,<-0.440291,0.679932,0.586375>,<6.44294e-2,0.821153,-0.567059>,<-0.955498,0.235990,-0.177008>,<-0.448444,-0.395384,-0.801605>,<0.530298,0.275655,-0.801747>,<-0.552364,0.791563,-0.261383>,<-0.869876,0.362149,0.334909>,<-0.739734,-0.369576,-0.562323>,<2.41228e-2,0.177829,-0.983766>,<0.221006,0.740670,0.634479>,<-0.293966,0.720425,-0.628150>,<0.803005,0.226535,-0.551239>,<0.805261,0.514567,-0.294577>,<-0.458509,0.887009,5.46306e-2>,<-0.338709,2.82540e-2,-0.940467>,<-0.471114,0.265812,-0.841068>,<0.447251,-0.191523,-0.873662>,<0.885203,0.439201,-0.153359>,<-9.73315e-4,0.955112,-0.296244>,<0.774111,-0.227388,-0.590802>,<0.925827,0.250554,0.282963>,<0.414310,0.884055,-0.216320>,<-3.67853e-2,0.228852,-0.972766>,<0.471114,0.265812,-0.841068>,<9.73315e-4,0.955112,-0.296244>,<-0.885203,0.439201,-0.153359>,<-0.447251,-0.191523,-0.873662>,<-0.925827,0.250554,0.282963>,<-0.774111,-0.227388,-0.590802>,<3.67853e-2,0.228852,-0.972766>,<-0.414310,0.884055,-0.216320>,<-0.805261,0.514567,-0.294577>,<0.338709,2.82540e-2,-0.940467>,<0.458509,0.887009,5.46306e-2>,<-0.221006,0.740670,0.634479>,<-0.803005,0.226535,-0.551239>,<0.293966,0.720425,-0.628150>,<0.789098,0.300998,-0.535467>,<0.440291,0.679932,0.586375>,<-0.309993,0.917358,0.249718>,<-0.140670,0.719645,-0.679944>,<-0.268579,0.354079,-0.895820>,<0.768296,0.481324,-0.421958>,<0.349275,0.936966,1.00712e-2>,<-0.489801,0.844267,-0.217506>,<-0.485396,-0.874295,4.00531e-16>,<-0.975802,0.218657,1.66969e-15>,<0.275695,-0.475170,-0.835587>,<0.275695,-0.475170,0.835587>,<0.194228,0.529816,-0.825573>,<0.194228,0.529816,0.825573>,<0.305536,-0.952181,-7.18411e-16>,<0.393512,0.919319,-4.21599e-15>,<0.307019,-0.512846,0.801703>,<0.605083,-0.796162,-1.09377e-15>,<0.307019,-0.512846,-0.801703>,<-7.63234e-2,0.325552,-0.942439>,<-6.76483e-2,0.997709,-6.87080e-16>,<-7.63234e-2,0.325552,0.942439>,<0.464954,-0.375636,0.801695>,<0.841734,-0.539892,-5.57855e-16>,<0.464954,-0.375636,-0.801695>,<-0.189794,0.274824,-0.942576>,<-0.325532,0.945531,2.80899e-15>,<-0.189794,0.274824,0.942576>,<0.505533,-0.535451,0.676557>,<0.653944,-0.756543,-1.31241e-15>,<0.505533,-0.535451,-0.676557>,<-0.143808,-0.442765,-0.885030>,<-0.998253,-5.90893e-2,3.85299e-15>,<-0.143808,-0.442765,0.885030>,<0.486325,-0.558233,0.672208>,<0.808754,-0.588147,-1.32830e-15>,<0.486325,-0.558233,-0.672208>,<-0.302535,-0.455665,-0.837163>,<-0.982066,-0.188536,-5.41313e-16>,<-0.302535,-0.455665,0.837163>,<0.237382,0.459298,0.855976>,<0.812595,0.386787,0.435988>,<0.655289,0.150367,-0.740261>,<-0.341781,0.350545,-0.871954>,<-0.914307,0.405022,-1.40935e-15>,<-0.341915,0.350564,0.871894>,<0.356405,0.884638,0.300651>,<0.477489,0.878637,-5.74964e-5>,<0.352708,0.886645,-0.299094>,<-1.90440e-2,0.955298,-0.295030>,<-0.156701,0.987646,5.80800e-7>,<-1.90440e-2,0.955298,0.295030>,<0.433288,-0.493611,0.754062>,<0.846879,-0.531786,-2.62966e-16>,<0.433288,-0.493611,-0.754062>,<-0.424709,-0.357123,-0.831916>,<-0.948486,-0.316819,-7.24702e-16>,<-0.424709,-0.357123,0.831916>,<0.474348,-0.577854,0.664138>,<0.794708,-0.561509,-0.230537>,<0.535567,-0.724921,-0.433195>,<-0.406500,-0.212181,-0.888671>,<-0.999290,-3.76637e-2,-2.37431e-15>,<-0.406500,-0.212181,0.888671>,<-0.154558,-0.987948,8.38455e-3>,<-0.109748,-0.993081,-4.17788e-2>,<-0.286901,-0.946740,0.146189>,<-0.195828,-0.980413,2.10096e-2>,<-0.149645,-0.988019,-3.77425e-2>,<-0.154018,-0.978194,-0.139335>,<-0.104280,-0.986810,-0.123818>,<-3.95673e-3,-0.968565,-0.248730>,<-3.29644e-2,-0.992009,0.121781>,<0.159593,-0.983956,7.97595e-2>,<-6.37691e-2,-0.997348,3.50794e-2>,<5.22603e-2,-0.986022,0.158206>,<-0.109748,-0.993081,4.17788e-2>,<-0.154558,-0.987948,-8.38455e-3>,<-0.195828,-0.980413,-2.10096e-2>,<-0.286901,-0.946740,-0.146189>,<-0.154018,-0.978194,0.139335>,<-0.149645,-0.988019,3.77425e-2>,<-3.95673e-3,-0.968565,0.248730>,<-0.104280,-0.986810,0.123818>,<1.45447e-2,-0.998291,-5.66015e-2>,<-3.29644e-2,-0.992009,-0.121781>,<5.22603e-2,-0.986022,-0.158206>,<7.96272e-3,-0.999135,-4.08094e-2>,<0.221236,0.229005,-0.947951>,<0.955483,0.285178,7.56635e-2>,<0.280409,0.239915,0.929415>,<-0.738605,0.422063,-0.525667>,<-0.738605,0.422063,0.525667>,<0.403575,0.393542,-0.825985>,<0.351362,0.926376,0.135544>,<0.566817,0.498121,0.656196>,<0.360422,0.925943,-0.112812>,<0.893941,0.447357,2.72269e-2>,<0.159202,0.964399,-0.211160>,<0.530332,0.626727,-0.570930>,<-5.34374e-2,0.991010,-0.122652>,<-0.145162,0.724975,-0.673305>,<-5.34368e-2,0.991010,0.122650>,<-0.630810,0.775937,-1.89859e-15>,<0.159201,0.964401,0.211155>,<-0.145162,0.724975,0.673305>,<7.74157e-2,-0.300582,0.950609>,<0.793013,-0.322533,0.516820>,<0.609985,-0.123146,-0.782786>,<-0.435169,0.115297,-0.892936>,<-0.973624,0.228157,-1.67938e-15>,<-0.391312,0.114166,0.913149>,<0.542066,-0.594486,-0.593929>,<-0.826321,2.04076e-2,-0.562830>,<0.191348,-0.212000,-0.958354>,<0.151960,-0.224048,0.962658>,<0.545869,-0.438460,0.713989>,<-0.826321,2.04076e-2,0.562830>,<-0.134395,-0.990908,-6.33451e-3>,<-0.159284,-0.987071,1.78520e-2>,<-5.35476e-2,-0.997596,4.39906e-2>,<-0.134395,-0.990908,6.33451e-3>,<-0.159284,-0.987071,-1.78520e-2>,<-5.35476e-2,-0.997596,-4.39906e-2>,<0.542415,-0.740763,0.396304>,<-7.65977e-2,-0.991905,0.101282>,<0.622664,0.262383,0.737187>,<0.897908,-0.419738,0.132594>,<1.83554e-2,-0.999831,2.84886e-4>,<0.897908,-0.419738,-0.132594>,<0.622664,0.262383,-0.737187>,<-7.65977e-2,-0.991905,-0.101282>,<0.542415,-0.740763,-0.396304>,<-0.120629,-0.637513,-0.760937>,<-0.173094,-0.980591,-9.20842e-2>,<-0.586450,-0.544134,-0.599996>,<-0.825877,-0.483726,-0.289718>,<-0.115875,-0.993264,-5.15034e-16>,<-0.825877,-0.483726,0.289718>,<-0.586450,-0.544134,0.599996>,<-0.173094,-0.980591,9.20842e-2>,<-0.120629,-0.637513,0.760937>,<0.113936,0.993488,-3.81319e-6>,<0.855341,-0.497264,-0.145332>,<0.468967,-0.237018,-0.850819>,<0.192435,-2.74720e-3,-0.981306>,<-0.835103,0.210064,-0.508406>,<-0.835103,0.210064,0.508406>,<0.255621,-4.12160e-2,0.965898>,<0.259447,0.736745,-0.624414>,<0.723063,0.585053,0.367277>,<0.215055,0.789885,0.574311>,<-0.396888,0.842083,-0.365208>,<-0.396888,0.842083,0.365208>,<0.736627,0.539824,-0.407395>,<-0.809172,-0.587572,-1.78346e-15>,<0.537420,-0.370862,0.757391>,<0.537420,-0.370862,-0.757391>,<0.858722,-0.152479,0.489230>,<0.900213,0.435450,1.22933e-15>,<0.858722,-0.152479,-0.489230>,<0.109959,-0.646464,-0.754979>,<-0.357233,-0.686067,-0.633796>,<-0.729429,-0.490150,-0.477165>,<-0.729429,-0.490150,0.477165>,<-0.357233,-0.686067,0.633796>,<0.109959,-0.646464,0.754979>,<7.69843e-2,-0.981669,0.174356>,<7.69843e-2,-0.981669,-0.174356>,<-3.67498e-2,-0.921388,-0.386903>,<-0.286607,-0.950516,-0.119897>,<-0.286607,-0.950516,0.119897>,<-3.67498e-2,-0.921388,0.386903>,<9.70896e-2,-0.995261,-5.43576e-3>,<-0.213364,-0.962296,-0.168707>,<-0.213364,-0.962296,0.168707>,<-4.54748e-2,-0.986893,0.154839>,<-4.54748e-2,-0.986893,-0.154839>,<-0.472686,-0.881231,0.00000e+0>,<-0.960201,-0.274878,-4.95642e-2>,<3.05204e-2,-0.644219,-0.764232>,<-0.223693,0.714508,-0.662902>,<-0.663047,0.738241,0.123974>,<-0.800220,-0.598571,-3.69012e-2>,<8.89129e-3,-0.265178,-0.964159>,<0.158432,0.767693,-0.620924>,<-0.637360,0.716763,-0.282883>,<-3.05204e-2,-0.644219,-0.764232>,<0.960201,-0.274878,-4.95642e-2>,<0.663047,0.738241,0.123974>,<0.223693,0.714508,-0.662902>,<-8.89129e-3,-0.265178,-0.964159>,<0.800220,-0.598571,-3.69012e-2>,<0.664891,0.730081,-0.157802>,<-4.19747e-2,0.755000,-0.654380>,<3.05204e-2,-0.644219,0.764232>,<-0.960201,-0.274878,4.95642e-2>,<-0.680868,0.732406,-8.47065e-4>,<-9.22284e-2,0.726236,0.681231>,<8.89129e-3,-0.265178,0.964159>,<-0.800220,-0.598571,3.69012e-2>,<-0.637360,0.716763,0.282883>,<0.158432,0.767693,0.620924>,<0.960201,-0.274878,4.95642e-2>,<-3.05204e-2,-0.644219,0.764232>,<9.22284e-2,0.726236,0.681231>,<0.680868,0.732406,-8.47065e-4>,<0.800220,-0.598571,3.69012e-2>,<-8.89129e-3,-0.265178,0.964159>,<-4.19747e-2,0.755000,0.654380>,<0.664891,0.730081,0.157802>,<-0.941580,-0.312015,0.126778>,<-0.238888,-0.832513,-0.499854>,<5.79764e-2,0.309348,-0.949180>,<-0.663664,0.747727,-2.13269e-2>,<-0.513661,-0.816972,-0.262124>,<0.181278,-0.303648,-0.935380>,<1.84858e-2,0.767951,-0.640242>,<-0.933074,0.355845,-5.24203e-2>,<0.238888,-0.832513,-0.499854>,<0.941580,-0.312015,0.126778>,<0.663664,0.747727,-2.13269e-2>,<-5.79764e-2,0.309348,-0.949180>,<-0.181278,-0.303648,-0.935380>,<0.513661,-0.816972,-0.262124>,<0.890540,0.418111,-0.179225>,<-9.87593e-2,0.781321,-0.616266>,<-0.238888,-0.832513,0.499854>,<-0.941580,-0.312015,-0.126778>,<-0.650706,0.756645,-6.38010e-2>,<-7.94057e-2,0.383705,0.920035>,<0.181278,-0.303648,0.935380>,<-0.513661,-0.816972,0.262124>,<-0.933074,0.355845,5.24203e-2>,<1.84858e-2,0.767951,0.640242>,<0.941580,-0.312015,-0.126778>,<0.238888,-0.832513,0.499854>,<7.94057e-2,0.383705,0.920035>,<0.650706,0.756645,-6.38010e-2>,<0.513661,-0.816972,0.262124>,<-0.181278,-0.303648,0.935380>,<-9.87593e-2,0.781321,0.616266>,<0.890540,0.418111,0.179225>,<-0.219823,-0.291135,0.931084>,<0.946282,-0.323319,-3.80490e-3>,<0.528442,0.846751,-6.13282e-2>,<0.329234,0.641438,0.692938>,<-0.139102,-0.265862,0.953923>,<0.960089,-0.273673,-5.77189e-2>,<0.615435,0.667257,0.419533>,<-0.149001,0.849838,0.505542>,<-0.946282,-0.323319,-3.80490e-3>,<0.219823,-0.291135,0.931084>,<-0.329234,0.641438,0.692938>,<-0.528442,0.846751,-6.13282e-2>,<-0.960089,-0.273673,-5.77189e-2>,<0.139102,-0.265862,0.953923>,<0.149001,0.849838,0.505542>,<-0.615435,0.667257,0.419533>,<0.946282,-0.323319,3.80490e-3>,<-0.219823,-0.291135,-0.931084>,<0.329234,0.641438,-0.692938>,<0.528442,0.846751,6.13282e-2>,<0.960089,-0.273673,5.77189e-2>,<-0.139102,-0.265862,-0.953923>,<-0.149001,0.849838,-0.505542>,<0.615435,0.667257,-0.419533>,<0.219823,-0.291135,-0.931084>,<-0.946282,-0.323319,3.80490e-3>,<-0.528442,0.846751,6.13282e-2>,<-0.329234,0.641438,-0.692938>,<0.139102,-0.265862,-0.953923>,<-0.960089,-0.273673,5.77189e-2>,<-0.615435,0.667257,-0.419533>,<0.149001,0.849838,-0.505542>,<0.706652,0.647986,-0.284179>,<0.635779,-3.52592e-2,0.771065>,<0.702165,-0.585432,-0.405259>,<0.393920,-3.08270e-2,-0.918628>,<0.00000e+0,0.00000e+0,0.00000e+0>,<0.544697,0.740474,0.393704>,<-9.47230e-2,0.120840,0.988142>,<0.655778,-0.366865,0.659823>,<0.980901,-0.106205,-0.162955>,<-0.735838,7.99707e-2,-0.672419>,<0.692666,-0.603392,0.395134>,<0.611161,-6.84714e-2,-0.788539>,<0.822731,-0.559435,-0.100723>,<0.202873,2.49202e-2,0.978888>,<0.597025,0.667079,0.445609>,<0.721344,0.660596,-0.208028>,<0.844358,-4.36284e-2,-0.534000>,<0.832986,-6.58259e-2,0.549364>,<0.828695,0.526558,-0.189743>,<0.911575,0.374755,-0.169088>,<0.986405,-6.77562e-2,0.149716>,<0.828695,0.526558,0.189743>,<0.348970,0.734990,-0.581386>,<0.824692,0.292683,0.483962>,<0.450256,-0.850836,0.270829>,<0.592737,-0.481551,-0.645579>,<0.124627,-0.237100,-0.963458>,<0.463081,0.550027,-0.695001>,<0.750847,0.328660,0.572897>,<0.643026,-0.758331,0.107012>,<0.678763,-0.717495,0.156467>,<0.313330,-0.640160,-0.701441>,<0.179354,0.243181,-0.953255>,<0.800513,0.471929,0.369408>,<0.652284,0.494992,0.574028>,<0.806904,-0.531050,0.258636>,<0.321820,-0.919698,-0.224918>,<0.462820,0.287486,-0.838540>,<0.924806,0.285692,-0.251227>,<-1.34623e-2,0.598045,0.801350>,<1.10546e-2,-0.446735,0.894598>,<0.624607,-0.753054,0.206824>,<0.517169,-0.855765,-1.41910e-2>,<0.879001,0.439848,-0.184094>,<-9.17504e-2,0.500209,0.861030>,<0.286009,-0.417477,0.862503>,<0.187324,-0.891749,0.411938>,<0.829085,-0.543372,0.131771>,<0.839725,0.456622,-0.293869>,<8.87940e-2,0.366276,0.926260>,<-0.217953,0.316675,0.923154>,<0.154572,-0.420214,0.894163>,<0.296746,-0.918022,0.263017>,<0.889491,0.454728,-4.50410e-2>,<0.913094,-0.239393,-0.330075>,<0.846442,-0.267584,0.460363>,<0.787364,-0.234980,0.569949>,<0.892690,-0.344680,-0.290345>,<0.707594,-0.682991,0.181200>,<0.668344,-0.562857,-0.486321>,<0.652658,-7.03457e-2,-0.754380>,<0.992861,-6.49759e-3,-0.119097>,<0.296193,-0.504507,0.811013>,<0.695608,-0.676435,0.242001>,<0.946202,1.11112e-2,0.323386>,<0.579511,-0.101706,0.808593>,<0.245065,-0.943192,-0.224349>,<0.198500,-0.960648,0.194302>,<0.348560,-0.886650,0.303902>,<0.175401,-0.968136,-0.178739>,<0.176242,-0.970536,0.164311>,<0.331956,-0.894600,-0.299159>,<3.14206e-2,-0.996992,7.08476e-2>,<6.84072e-3,-0.999429,3.31009e-2>,<5.94107e-3,-0.999075,-4.25993e-2>,<3.31359e-2,-0.995509,-8.86757e-2>,<-3.14206e-2,-0.996992,7.08476e-2>,<-6.84072e-3,-0.999429,3.31009e-2>,<-5.94107e-3,-0.999075,-4.25993e-2>,<-3.31359e-2,-0.995509,-8.86757e-2>,<6.89261e-3,-0.999881,-1.37920e-2>,<3.43458e-2,-0.999315,1.38014e-2>,<-4.72984e-3,-0.999953,-8.47501e-3>,<-6.75326e-3,-0.999877,1.41255e-2>,<2.05144e-4,-1.000000,1.90001e-17>,<2.05144e-4,-1.000000,1.64469e-17>,<2.05144e-4,-1.000000,-6.87714e-17>,<2.05144e-4,-1.000000,-6.14658e-17>,<-2.05144e-4,-1.000000,-4.48614e-17>,<-2.05144e-4,-1.000000,1.34427e-17>,<-2.05144e-4,-1.000000,-6.16746e-17>,<-2.05144e-4,-1.000000,-4.54630e-18>,<-6.89261e-3,-0.999881,-1.37920e-2>,<6.75326e-3,-0.999877,1.41255e-2>,<4.72984e-3,-0.999953,-8.47501e-3>,<-3.43458e-2,-0.999315,1.38014e-2>,<-3.30863e-2,-0.999165,-2.39824e-2>,<-3.26352e-2,-0.999467,6.53891e-17>,<-3.30863e-2,-0.999165,2.39824e-2>,<-2.05770e-2,-0.999691,1.39141e-2>,<-1.49153e-2,-0.999749,-1.66993e-2>,<3.26352e-2,-0.999467,9.87793e-17>,<3.30863e-2,-0.999165,-2.39824e-2>,<1.49153e-2,-0.999749,-1.66993e-2>,<2.05770e-2,-0.999691,1.39141e-2>,<3.30863e-2,-0.999165,2.39824e-2>}
texture_list { 11,
	texture { vetro_WingsMat }
	texture { pneumatici_WingsMat }
	texture { occhiali_WingsMat }
	texture { occhi_WingsMat }
	texture { nari_WingsMat }
	texture { mozzi_WingsMat }
	texture { denti_WingsMat }
	texture { casco_WingsMat }
	texture { Verdolino_WingsMat }
	texture { Giallino_WingsMat }
	texture { Corpo_WingsMat }
}
face_indices {2924,<7,264,1091>,10,<8,1266,160>,10,<10,1270,159>,10,<147,1092,264>,10,<159,1275,10>,10,<159,1276,1275>,10,<160,1263,8>,10,<160,1264,1263>,10,<242,8,1263>,10,<242,1262,1265>,10,<242,1263,1262>,10,<242,1265,466>,10,<246,471,1268>,10,<246,1266,8>,10,<246,1267,1266>,10,<246,1268,1267>,10,<248,6,1097>,10,<248,1094,1096>,10,<260,474,1272>,10,<260,1270,10>,10,<260,1271,1270>,10,<260,1272,1271>,10,<266,10,1275>,10,<266,1274,1277>,10,<266,1275,1274>,10,<266,1277,478>,10,<466,1265,1264>,10,<469,1096,1098>,10,<469,1098,163>,10,<471,160,1269>,10,<474,159,1273>,10,<476,147,264>,10,<478,1276,159>,10,<478,1277,1276>,10,<558,1278,701>,10,<559,1290,700>,10,<700,1287,559>,10,<700,1288,1287>,10,<700,1293,1015>,10,<701,1281,1003>,10,<701,1283,558>,10,<701,1284,1283>,10,<779,1003,1280>,10,<779,1278,558>,10,<779,1279,1278>,10,<779,1280,1279>,10,<783,558,1283>,10,<783,1282,1285>,10,<783,1283,1282>,10,<783,1285,1008>,10,<785,1093,1097>,10,<785,1095,1093>,10,<797,559,1287>,10,<797,1286,1289>,10,<797,1287,1286>,10,<797,1289,1011>,10,<801,147,1013>,10,<801,1092,147>,10,<803,1015,1292>,10,<803,1290,559>,10,<803,1291,1290>,10,<803,1292,1291>,10,<1006,163,1098>,10,<1006,1098,1095>,10,<1008,1285,1284>,10,<1011,1288,700>,10,<1011,1289,1288>,10,<1091,264,1092>,10,<1091,801,7>,10,<1092,801,1091>,10,<1093,1095,1102>,10,<1094,1099,1104>,10,<1095,785,1006>,10,<1095,1098,1103>,10,<1096,469,248>,10,<1096,1104,1103>,10,<1097,6,785>,10,<1097,1093,1101>,10,<1097,1094,248>,10,<1097,1100,1099>,10,<1099,1094,1097>,10,<1099,1105,1110>,10,<1100,1101,1107>,10,<1100,1105,1099>,10,<1100,1106,1105>,10,<1101,1100,1097>,10,<1101,1102,1108>,10,<1102,1101,1093>,10,<1102,1103,1109>,10,<1103,1098,1096>,10,<1103,1102,1095>,10,<1104,1096,1094>,10,<1104,1110,1109>,10,<1105,1111,1116>,10,<1105,1116,1110>,10,<1106,1107,1113>,10,<1106,1111,1105>,10,<1106,1112,1111>,10,<1106,1113,1112>,10,<1107,1106,1100>,10,<1107,1108,1114>,10,<1107,1114,1113>,10,<1108,1107,1101>,10,<1108,1109,1115>,10,<1108,1115,1114>,10,<1109,1103,1104>,10,<1109,1108,1102>,10,<1110,1104,1099>,10,<1110,1115,1109>,10,<1110,1116,1115>,10,<1111,1117,1116>,10,<1112,1113,1119>,10,<1112,1117,1111>,10,<1112,1118,1117>,10,<1112,1119,1118>,10,<1114,1119,1113>,10,<1114,1120,1119>,10,<1115,1120,1114>,10,<1115,1121,1120>,10,<1116,1122,1115>,10,<1117,1122,1116>,10,<1117,1135,1122>,10,<1118,1136,1117>,10,<1119,1136,1118>,10,<1119,1137,1136>,10,<1120,1137,1119>,10,<1120,1138,1137>,10,<1121,1138,1120>,10,<1121,1139,1138>,10,<1122,1121,1115>,10,<1122,1140,1121>,10,<1124,1172,1366>,10,<1124,1381,1380>,10,<1125,1171,1232>,10,<1125,1176,1361>,10,<1125,1182,1237>,10,<1125,1232,1182>,10,<1125,1361,1369>,10,<1126,1174,1235>,10,<1127,1174,1229>,10,<1127,1193,1230>,10,<1127,1229,1193>,10,<1127,1230,1175>,10,<1129,1177,1187>,10,<1129,1178,1372>,10,<1129,1187,1234>,10,<1129,1234,1178>,10,<1130,1177,1233>,10,<1130,1180,1373>,10,<1130,1233,1180>,10,<1130,1373,1179>,10,<1131,1182,1232>,10,<1131,1232,1181>,10,<1132,1184,1235>,10,<1132,1235,1183>,10,<1133,1183,1235>,10,<1133,1185,1225>,10,<1133,1186,1236>,10,<1133,1235,1186>,10,<1133,1236,1185>,10,<1134,1185,1236>,10,<1134,1188,1234>,10,<1134,1234,1187>,10,<1134,1236,1188>,10,<1135,1140,1122>,10,<1135,1155,1259>,10,<1135,1164,1255>,10,<1136,1135,1117>,10,<1136,1156,1250>,10,<1136,1167,1256>,10,<1136,1250,1135>,10,<1136,1256,1156>,10,<1137,1151,1260>,10,<1137,1168,1251>,10,<1137,1251,1136>,10,<1137,1260,1168>,10,<1138,1152,1252>,10,<1138,1159,1257>,10,<1138,1252,1137>,10,<1138,1257,1152>,10,<1139,1140,1254>,10,<1139,1147,1261>,10,<1139,1160,1253>,10,<1139,1253,1138>,10,<1139,1254,1147>,10,<1140,1135,1255>,10,<1140,1139,1121>,10,<1140,1148,1254>,10,<1140,1163,1258>,10,<1140,1255,1163>,10,<1141,1189,1231>,10,<1141,1368,1413>,10,<1142,1370,1419>,10,<1143,1195,1424>,10,<1143,1197,1191>,10,<1143,1424,1426>,10,<1144,1196,1192>,10,<1145,1219,1238>,10,<1146,1222,1248>,10,<1147,1150,1220>,10,<1147,1220,1261>,10,<1148,1149,1201>,10,<1148,1201,1254>,10,<1148,1258,1223>,10,<1149,1222,1247>,10,<1150,1147,1254>,10,<1150,1221,1220>,10,<1150,1254,1201>,10,<1151,1154,1214>,10,<1151,1252,1202>,10,<1152,1153,1202>,10,<1152,1202,1252>,10,<1152,1257,1153>,10,<1153,1216,1244>,10,<1153,1244,1202>,10,<1154,1151,1202>,10,<1154,1202,1244>,10,<1155,1250,1203>,10,<1156,1256,1157>,10,<1157,1203,1250>,10,<1157,1210,1241>,10,<1157,1241,1203>,10,<1158,1155,1203>,10,<1158,1203,1241>,10,<1158,1208,1259>,10,<1158,1209,1239>,10,<1159,1162,1217>,10,<1160,1161,1253>,10,<1160,1261,1220>,10,<1161,1204,1253>,10,<1161,1219,1246>,10,<1161,1246,1204>,10,<1163,1255,1205>,10,<1164,1165,1205>,10,<1164,1208,1165>,10,<1164,1259,1208>,10,<1165,1207,1249>,10,<1166,1223,1258>,10,<1166,1224,1223>,10,<1166,1258,1163>,10,<1167,1170,1211>,10,<1168,1169,1206>,10,<1168,1206,1251>,10,<1168,1260,1169>,10,<1169,1213,1243>,10,<1169,1214,1240>,10,<1169,1240,1213>,10,<1169,1243,1206>,10,<1170,1167,1251>,10,<1170,1206,1243>,10,<1170,1243,1212>,10,<1171,1125,1369>,10,<1171,1126,1184>,10,<1171,1228,1126>,10,<1171,1369,1228>,10,<1173,1234,1188>,10,<1173,1364,1123>,10,<1173,1371,1364>,10,<1174,1126,1192>,10,<1174,1192,1229>,10,<1175,1186,1127>,10,<1175,1194,1128>,10,<1175,1230,1194>,10,<1175,1236,1186>,10,<1176,1385,1384>,10,<1177,1129,1372>,10,<1177,1130,1179>,10,<1177,1179,1225>,10,<1177,1225,1187>,10,<1177,1372,1233>,10,<1178,1173,1123>,10,<1178,1234,1173>,10,<1179,1131,1181>,10,<1179,1181,1225>,10,<1179,1237,1131>,10,<1180,1172,1124>,10,<1180,1233,1172>,10,<1181,1132,1183>,10,<1181,1183,1225>,10,<1181,1232,1132>,10,<1184,1232,1171>,10,<1185,1134,1187>,10,<1185,1187,1225>,10,<1186,1174,1127>,10,<1186,1235,1174>,10,<1188,1128,1173>,10,<1188,1236,1128>,10,<1189,1141,1413>,10,<1189,1364,1371>,10,<1189,1365,1410>,10,<1189,1371,1231>,10,<1189,1409,1408>,10,<1189,1413,1365>,10,<1190,1226,1414>,10,<1190,1359,1366>,10,<1190,1360,1394>,10,<1190,1366,1226>,10,<1190,1393,1392>,10,<1190,1414,1415>,10,<1191,1195,1143>,10,<1191,1227,1195>,10,<1192,1197,1144>,10,<1192,1228,1197>,10,<1193,1145,1200>,10,<1193,1196,1145>,10,<1193,1200,1230>,10,<1193,1229,1196>,10,<1194,1146,1198>,10,<1194,1198,1231>,10,<1194,1200,1146>,10,<1194,1230,1200>,10,<1195,1412,1370>,10,<1196,1219,1145>,10,<1196,1229,1192>,10,<1196,1246,1219>,10,<1197,1228,1191>,10,<1197,1244,1216>,10,<1198,1146,1224>,10,<1198,1207,1141>,10,<1198,1249,1207>,10,<1199,1422,1368>,10,<1199,1423,1422>,10,<1199,1425,1428>,10,<1199,1428,1142>,10,<1200,1222,1146>,10,<1200,1247,1222>,10,<1201,1247,1150>,10,<1204,1159,1253>,10,<1204,1162,1159>,10,<1204,1246,1162>,10,<1205,1166,1163>,10,<1205,1249,1166>,10,<1205,1255,1164>,10,<1207,1165,1208>,10,<1207,1239,1379>,10,<1207,1379,1429>,10,<1207,1429,1141>,10,<1208,1239,1207>,10,<1209,1241,1375>,10,<1211,1170,1212>,10,<1211,1210,1157>,10,<1211,1242,1210>,10,<1211,1256,1167>,10,<1212,1242,1211>,10,<1213,1374,1243>,10,<1213,1376,1374>,10,<1214,1154,1215>,10,<1214,1260,1151>,10,<1215,1197,1143>,10,<1215,1240,1214>,10,<1215,1244,1197>,10,<1216,1144,1197>,10,<1216,1245,1144>,10,<1217,1162,1218>,10,<1217,1216,1153>,10,<1217,1245,1216>,10,<1217,1257,1159>,10,<1218,1196,1144>,10,<1218,1245,1217>,10,<1218,1246,1196>,10,<1219,1161,1220>,10,<1220,1161,1160>,10,<1220,1238,1219>,10,<1221,1200,1145>,10,<1221,1238,1220>,10,<1221,1247,1200>,10,<1222,1149,1223>,10,<1223,1149,1148>,10,<1223,1248,1222>,10,<1224,1248,1223>,10,<1224,1249,1198>,10,<1225,1183,1133>,10,<1226,1366,1406>,10,<1226,1405,1404>,10,<1227,1361,1390>,10,<1228,1192,1126>,10,<1231,1198,1141>,10,<1232,1184,1132>,10,<1233,1363,1172>,10,<1233,1372,1363>,10,<1235,1184,1126>,10,<1236,1175,1128>,10,<1237,1176,1125>,10,<1237,1182,1131>,10,<1237,1358,1176>,10,<1237,1373,1358>,10,<1238,1221,1145>,10,<1239,1208,1158>,10,<1239,1209,1379>,10,<1241,1209,1158>,10,<1241,1210,1378>,10,<1241,1378,1375>,10,<1242,1212,1377>,10,<1242,1377,1378>,10,<1242,1378,1210>,10,<1243,1374,1377>,10,<1243,1377,1212>,10,<1244,1215,1154>,10,<1245,1218,1144>,10,<1246,1218,1162>,10,<1247,1201,1149>,10,<1247,1221,1150>,10,<1248,1224,1146>,10,<1249,1205,1165>,10,<1249,1224,1166>,10,<1250,1155,1135>,10,<1250,1156,1157>,10,<1251,1167,1136>,10,<1251,1206,1170>,10,<1252,1151,1137>,10,<1253,1159,1138>,10,<1256,1211,1157>,10,<1257,1217,1153>,10,<1258,1148,1140>,10,<1259,1155,1158>,10,<1259,1164,1135>,10,<1260,1214,1169>,10,<1261,1160,1139>,10,<1262,1263,1295>,10,<1262,1294,1297>,10,<1262,1295,1294>,10,<1263,1264,1296>,10,<1263,1296,1295>,10,<1264,160,466>,10,<1265,1297,1264>,10,<1266,1269,160>,10,<1266,1298,1301>,10,<1266,1301,1269>,10,<1267,1268,1300>,10,<1267,1298,1266>,10,<1267,1299,1298>,10,<1269,1268,471>,10,<1269,1300,1268>,10,<1269,1301,1300>,10,<1270,1273,159>,10,<1270,1302,1305>,10,<1270,1305,1273>,10,<1271,1272,1304>,10,<1271,1302,1270>,10,<1271,1303,1302>,10,<1273,1272,474>,10,<1273,1304,1272>,10,<1273,1305,1304>,10,<1274,1306,1309>,10,<1274,1309,1277>,10,<1275,1276,1308>,10,<1275,1307,1274>,10,<1275,1308,1307>,10,<1277,1308,1276>,10,<1277,1309,1308>,10,<1278,1281,701>,10,<1278,1310,1313>,10,<1278,1313,1281>,10,<1279,1310,1278>,10,<1279,1311,1310>,10,<1280,1312,1279>,10,<1281,1280,1003>,10,<1281,1313,1280>,10,<1282,1283,1315>,10,<1282,1314,1317>,10,<1282,1315,1314>,10,<1283,1284,1316>,10,<1283,1316,1315>,10,<1284,701,1008>,10,<1285,1317,1284>,10,<1286,1318,1321>,10,<1286,1321,1289>,10,<1287,1288,1320>,10,<1287,1319,1286>,10,<1287,1320,1319>,10,<1289,1320,1288>,10,<1289,1321,1320>,10,<1290,1293,700>,10,<1290,1322,1325>,10,<1290,1325,1293>,10,<1291,1322,1290>,10,<1291,1323,1322>,10,<1292,1324,1291>,10,<1293,1292,1015>,10,<1293,1325,1292>,10,<1295,1327,1326>,10,<1296,1327,1295>,10,<1296,1328,1327>,10,<1297,1265,1262>,10,<1297,1294,1326>,10,<1297,1296,1264>,10,<1297,1329,1328>,10,<1298,1299,1331>,10,<1298,1330,1301>,10,<1300,1299,1267>,10,<1300,1301,1333>,10,<1300,1332,1331>,10,<1302,1334,1305>,10,<1303,1335,1302>,10,<1304,1303,1271>,10,<1304,1305,1337>,10,<1304,1335,1303>,10,<1304,1336,1335>,10,<1307,1306,1274>,10,<1307,1339,1338>,10,<1308,1339,1307>,10,<1308,1340,1339>,10,<1309,1306,1338>,10,<1309,1340,1308>,10,<1309,1341,1340>,10,<1310,1311,1343>,10,<1310,1342,1313>,10,<1312,1311,1279>,10,<1312,1344,1343>,10,<1313,1312,1280>,10,<1313,1345,1312>,10,<1314,1346,1317>,10,<1315,1346,1314>,10,<1315,1347,1346>,10,<1316,1347,1315>,10,<1316,1348,1347>,10,<1317,1285,1282>,10,<1317,1316,1284>,10,<1317,1349,1348>,10,<1318,1350,1321>,10,<1319,1318,1286>,10,<1319,1350,1318>,10,<1319,1351,1350>,10,<1320,1351,1319>,10,<1320,1352,1351>,10,<1321,1352,1320>,10,<1321,1353,1352>,10,<1322,1354,1325>,10,<1323,1355,1322>,10,<1324,1323,1291>,10,<1324,1355,1323>,10,<1324,1356,1355>,10,<1325,1324,1292>,10,<1325,1357,1324>,10,<1326,1294,1295>,10,<1326,1329,1297>,10,<1327,1328,1329>,10,<1327,1329,1326>,10,<1328,1296,1297>,10,<1330,1331,1332>,10,<1330,1332,1333>,10,<1330,1333,1301>,10,<1331,1299,1300>,10,<1331,1330,1298>,10,<1333,1332,1300>,10,<1334,1337,1305>,10,<1335,1334,1302>,10,<1335,1336,1334>,10,<1336,1337,1334>,10,<1337,1336,1304>,10,<1338,1306,1307>,10,<1338,1341,1309>,10,<1339,1340,1341>,10,<1339,1341,1338>,10,<1342,1345,1313>,10,<1343,1311,1312>,10,<1343,1342,1310>,10,<1343,1344,1342>,10,<1344,1345,1342>,10,<1345,1344,1312>,10,<1346,1349,1317>,10,<1347,1348,1349>,10,<1347,1349,1346>,10,<1348,1316,1317>,10,<1350,1353,1321>,10,<1351,1352,1353>,10,<1351,1353,1350>,10,<1354,1355,1356>,10,<1354,1356,1357>,10,<1354,1357,1325>,10,<1355,1354,1322>,10,<1357,1356,1324>,10,<1358,1180,1124>,10,<1358,1373,1180>,10,<1358,1386,1385>,10,<1359,1382,1381>,10,<1359,1392,1362>,10,<1360,1190,1415>,10,<1360,1227,1389>,10,<1360,1362,1395>,10,<1360,1388,1391>,10,<1361,1384,1387>,10,<1361,1387,1362>,10,<1362,1358,1380>,10,<1362,1382,1359>,10,<1362,1383,1382>,10,<1362,1387,1386>,10,<1362,1391,1361>,10,<1363,1123,1397>,10,<1363,1178,1123>,10,<1363,1372,1178>,10,<1363,1402,1401>,10,<1364,1367,1399>,10,<1364,1398,1397>,10,<1364,1408,1411>,10,<1365,1367,1411>,10,<1365,1404,1407>,10,<1365,1413,1414>,10,<1366,1172,1401>,10,<1366,1359,1124>,10,<1367,1363,1396>,10,<1367,1366,1400>,10,<1367,1403,1402>,10,<1367,1407,1406>,10,<1368,1425,1199>,10,<1369,1191,1228>,10,<1369,1227,1191>,10,<1369,1361,1227>,10,<1370,1412,1416>,10,<1371,1128,1194>,10,<1371,1173,1128>,10,<1371,1194,1231>,10,<1373,1237,1179>,10,<1375,1379,1209>,10,<1376,1213,1240>,10,<1376,1240,1215>,10,<1380,1358,1124>,10,<1380,1383,1362>,10,<1381,1124,1359>,10,<1381,1382,1383>,10,<1383,1380,1381>,10,<1384,1361,1176>,10,<1385,1176,1358>,10,<1385,1386,1387>,10,<1385,1387,1384>,10,<1386,1358,1362>,10,<1389,1388,1360>,10,<1389,1390,1391>,10,<1389,1391,1388>,10,<1390,1389,1227>,10,<1391,1362,1360>,10,<1391,1390,1361>,10,<1392,1359,1190>,10,<1392,1395,1362>,10,<1393,1394,1395>,10,<1393,1395,1392>,10,<1394,1393,1190>,10,<1395,1394,1360>,10,<1396,1399,1367>,10,<1397,1123,1364>,10,<1397,1396,1363>,10,<1397,1398,1399>,10,<1399,1396,1397>,10,<1399,1398,1364>,10,<1400,1403,1367>,10,<1401,1172,1363>,10,<1401,1400,1366>,10,<1401,1402,1403>,10,<1401,1403,1400>,10,<1402,1363,1367>,10,<1404,1365,1226>,10,<1405,1406,1407>,10,<1405,1407,1404>,10,<1406,1366,1367>,10,<1406,1405,1226>,10,<1407,1367,1365>,10,<1408,1364,1189>,10,<1409,1410,1411>,10,<1410,1409,1189>,10,<1411,1367,1364>,10,<1411,1408,1409>,10,<1411,1410,1365>,10,<1412,1195,1227>,10,<1412,1227,1360>,10,<1413,1368,1422>,10,<1413,1421,1414>,10,<1413,1422,1421>,10,<1414,1226,1365>,10,<1414,1420,1199>,10,<1415,1142,1418>,10,<1415,1199,1142>,10,<1415,1412,1360>,10,<1415,1414,1199>,10,<1415,1417,1416>,10,<1415,1418,1417>,10,<1416,1412,1415>,10,<1416,1419,1370>,10,<1419,1418,1142>,10,<1420,1423,1199>,10,<1421,1420,1414>,10,<1425,1141,1429>,10,<1425,1368,1141>,10,<1426,1215,1143>,10,<1426,1376,1215>,10,<1427,1195,1370>,10,<1427,1370,1142>,10,<1427,1424,1195>,10,<1428,1427,1142>,10,<3,154,423>,9,<3,254,154>,9,<3,423,148>,9,<6,248,468>,9,<6,468,150>,9,<6,693,1005>,9,<6,1459,1463>,9,<7,155,477>,9,<7,477,264>,9,<7,698,1456>,9,<7,801,1014>,9,<7,1454,155>,9,<7,1455,1454>,9,<10,155,1434>,9,<148,8,242>,9,<148,423,1431>,9,<148,465,240>,9,<148,1430,8>,9,<148,1431,1430>,9,<150,468,246>,9,<150,1430,1461>,9,<150,1460,6>,9,<154,10,1434>,9,<154,475,260>,9,<154,1434,1435>,9,<155,1454,1458>,9,<155,1458,1434>,9,<240,3,148>,9,<242,465,148>,9,<246,8,150>,9,<254,475,154>,9,<260,10,154>,9,<266,155,10>,9,<266,477,155>,9,<423,960,1439>,9,<423,1439,1438>,9,<558,691,779>,9,<558,693,1433>,9,<559,698,803>,9,<691,555,777>,9,<691,960,555>,9,<691,1002,779>,9,<693,558,783>,9,<693,1463,1462>,9,<697,791,555>,9,<697,960,1436>,9,<697,1012,791>,9,<697,1436,1437>,9,<697,1437,559>,9,<698,1014,803>,9,<698,1437,1457>,9,<698,1457,1456>,9,<777,1002,691>,9,<783,1005,693>,9,<797,697,559>,9,<797,1012,697>,9,<960,697,555>,9,<1005,785,6>,9,<1014,698,7>,9,<1430,150,8>,9,<1430,1433,1462>,9,<1430,1442,1445>,9,<1431,423,1438>,9,<1431,1432,1444>,9,<1431,1441,1440>,9,<1431,1443,1430>,9,<1432,960,691>,9,<1432,1440,1439>,9,<1433,691,558>,9,<1433,1432,691>,9,<1433,1445,1444>,9,<1434,1437,1448>,9,<1434,1446,1435>,9,<1434,1447,1446>,9,<1434,1458,1457>,9,<1435,423,154>,9,<1435,1436,1452>,9,<1435,1446,1449>,9,<1435,1450,423>,9,<1435,1451,1450>,9,<1436,960,1453>,9,<1436,1453,1452>,9,<1437,698,559>,9,<1437,1436,1449>,9,<1438,1439,1440>,9,<1438,1441,1431>,9,<1439,960,1432>,9,<1440,1432,1431>,9,<1440,1441,1438>,9,<1443,1442,1430>,9,<1443,1444,1445>,9,<1443,1445,1442>,9,<1444,1432,1433>,9,<1444,1443,1431>,9,<1445,1433,1430>,9,<1447,1448,1446>,9,<1448,1447,1434>,9,<1448,1449,1446>,9,<1449,1436,1435>,9,<1449,1448,1437>,9,<1450,1453,423>,9,<1451,1452,1450>,9,<1452,1451,1435>,9,<1452,1453,1450>,9,<1453,960,423>,9,<1455,1456,1457>,9,<1455,1457,1458>,9,<1455,1458,1454>,9,<1456,1455,7>,9,<1457,1437,1434>,9,<1459,1460,1461>,9,<1459,1461,1462>,9,<1459,1462,1463>,9,<1460,1459,6>,9,<1461,1460,150>,9,<1462,1433,693>,9,<1462,1461,1430>,9,<1463,693,6>,9,<0,162,435>,8,<0,210,453>,8,<0,435,180>,8,<1,188,438>,8,<2,161,455>,8,<2,455,220>,8,<2,690,757>,8,<2,757,992>,8,<2,992,161>,8,<3,240,464>,8,<3,464,144>,8,<4,282,151>,8,<5,204,146>,8,<9,169,276>,8,<9,707,771>,8,<9,708,813>,8,<9,813,169>,8,<11,153,457>,8,<11,159,474>,8,<11,268,478>,8,<11,457,224>,8,<11,474,258>,8,<11,478,159>,8,<12,149,437>,8,<12,160,471>,8,<12,244,466>,8,<12,437,184>,8,<12,466,160>,8,<12,471,252>,8,<13,147,476>,8,<13,222,161>,8,<13,476,262>,8,<13,799,1013>,8,<13,1013,147>,8,<14,144,464>,8,<14,164,182>,8,<14,182,162>,8,<14,216,166>,8,<14,256,472>,8,<14,464,238>,8,<15,143,186>,8,<15,163,1006>,8,<15,250,469>,8,<15,469,163>,8,<15,723,143>,8,<15,1006,787>,8,<16,176,492>,8,<16,200,444>,8,<16,444,173>,8,<16,492,294>,8,<17,208,448>,8,<17,448,174>,8,<17,711,985>,8,<17,985,745>,8,<18,175,488>,8,<18,488,286>,8,<18,823,1025>,8,<18,1025,712>,8,<20,175,230>,8,<21,178,434>,8,<21,298,497>,8,<21,434,177>,8,<22,179,495>,8,<22,180,179>,8,<22,300,494>,8,<22,495,300>,8,<23,182,436>,8,<23,436,181>,8,<24,181,436>,8,<24,183,497>,8,<24,184,183>,8,<24,436,184>,8,<24,497,304>,8,<25,185,498>,8,<25,186,438>,8,<25,498,306>,8,<26,188,439>,8,<26,308,498>,8,<26,439,187>,8,<26,498,185>,8,<27,187,439>,8,<27,189,500>,8,<27,190,189>,8,<27,439,190>,8,<27,500,310>,8,<28,192,441>,8,<28,312,500>,8,<28,441,191>,8,<29,194,442>,8,<29,199,445>,8,<29,314,199>,8,<29,442,193>,8,<30,196,195>,8,<31,197,318>,8,<31,198,444>,8,<31,444,197>,8,<32,199,505>,8,<32,320,197>,8,<32,505,320>,8,<33,202,446>,8,<33,207,449>,8,<33,322,207>,8,<33,449,202>,8,<34,203,324>,8,<34,324,506>,8,<34,506,201>,8,<35,203,447>,8,<35,205,508>,8,<35,206,205>,8,<35,326,507>,8,<35,507,203>,8,<35,508,326>,8,<36,207,509>,8,<36,208,207>,8,<36,328,508>,8,<36,508,205>,8,<36,509,328>,8,<37,209,510>,8,<37,210,450>,8,<37,330,513>,8,<37,510,330>,8,<37,513,215>,8,<38,211,511>,8,<38,212,211>,8,<38,511,332>,8,<39,214,452>,8,<39,334,511>,8,<39,452,213>,8,<40,213,452>,8,<40,336,213>,8,<41,218,454>,8,<41,338,517>,8,<41,454,217>,8,<41,517,223>,8,<42,219,515>,8,<42,220,219>,8,<42,515,340>,8,<43,222,456>,8,<43,342,219>,8,<43,456,221>,8,<44,221,456>,8,<44,223,517>,8,<44,344,221>,8,<44,456,224>,8,<45,225,346>,8,<45,226,458>,8,<45,458,225>,8,<46,228,459>,8,<46,459,227>,8,<47,229,520>,8,<47,350,519>,8,<47,519,227>,8,<48,231,352>,8,<48,232,461>,8,<48,352,523>,8,<49,234,462>,8,<49,462,233>,8,<50,235,523>,8,<50,356,522>,8,<51,238,237>,8,<52,240,465>,8,<52,360,524>,8,<52,465,239>,8,<52,524,237>,8,<53,239,465>,8,<53,465,242>,8,<54,243,527>,8,<54,244,467>,8,<54,364,526>,8,<54,467,243>,8,<54,527,364>,8,<55,246,468>,8,<55,366,531>,8,<55,468,245>,8,<56,245,468>,8,<56,247,529>,8,<56,248,247>,8,<56,468,248>,8,<56,529,368>,8,<57,250,470>,8,<57,470,249>,8,<58,249,470>,8,<58,251,531>,8,<58,252,251>,8,<58,470,252>,8,<58,531,372>,8,<59,253,532>,8,<59,259,475>,8,<59,374,259>,8,<59,475,254>,8,<59,532,374>,8,<60,256,473>,8,<61,257,534>,8,<61,378,533>,8,<61,533,255>,8,<61,534,378>,8,<62,260,475>,8,<62,475,259>,8,<63,261,382>,8,<63,262,261>,8,<64,264,477>,8,<64,384,536>,8,<64,477,263>,8,<64,536,261>,8,<65,263,477>,8,<65,265,538>,8,<65,386,263>,8,<65,477,266>,8,<66,268,479>,8,<66,388,538>,8,<66,479,267>,8,<66,538,265>,8,<67,270,480>,8,<67,480,269>,8,<68,269,480>,8,<68,271,541>,8,<68,272,481>,8,<68,392,269>,8,<68,481,271>,8,<69,273,542>,8,<69,274,273>,8,<69,394,541>,8,<69,541,271>,8,<69,542,394>,8,<70,275,396>,8,<70,276,483>,8,<70,279,485>,8,<71,278,484>,8,<71,398,275>,8,<71,484,277>,8,<72,279,545>,8,<72,400,544>,8,<72,544,277>,8,<72,545,400>,8,<73,281,546>,8,<73,402,287>,8,<74,281,486>,8,<74,283,404>,8,<74,284,487>,8,<74,487,283>,8,<75,285,548>,8,<75,286,285>,8,<75,406,547>,8,<75,547,283>,8,<75,548,406>,8,<76,287,549>,8,<76,288,489>,8,<76,408,548>,8,<76,489,287>,8,<78,289,490>,8,<78,291,412>,8,<78,292,491>,8,<78,490,292>,8,<79,293,414>,8,<79,294,293>,8,<79,414,551>,8,<79,551,291>,8,<80,296,493>,8,<80,493,295>,8,<81,297,417>,8,<81,298,494>,8,<81,417,303>,8,<81,494,297>,8,<82,299,417>,8,<82,300,299>,8,<82,417,297>,8,<83,301,417>,8,<83,302,496>,8,<83,417,299>,8,<84,301,496>,8,<84,303,417>,8,<84,304,303>,8,<84,417,301>,8,<84,496,304>,8,<85,305,418>,8,<85,311,501>,8,<85,418,311>,8,<85,501,306>,8,<86,307,418>,8,<86,308,499>,8,<86,418,305>,8,<86,499,307>,8,<87,307,499>,8,<87,309,418>,8,<87,499,310>,8,<88,311,418>,8,<88,312,501>,8,<88,501,311>,8,<89,313,419>,8,<89,314,502>,8,<89,319,505>,8,<89,502,313>,8,<89,505,314>,8,<90,313,502>,8,<90,315,419>,8,<90,419,313>,8,<91,315,503>,8,<91,317,419>,8,<91,318,504>,8,<91,419,315>,8,<91,503,318>,8,<91,504,317>,8,<92,319,419>,8,<92,320,319>,8,<92,419,317>,8,<93,322,506>,8,<93,327,509>,8,<93,506,321>,8,<93,509,322>,8,<94,321,506>,8,<94,323,420>,8,<94,420,321>,8,<95,323,507>,8,<95,325,420>,8,<95,326,508>,8,<95,420,323>,8,<95,508,325>,8,<96,327,420>,8,<96,328,327>,8,<96,420,325>,8,<97,329,421>,8,<97,330,510>,8,<97,421,335>,8,<98,331,421>,8,<98,421,329>,8,<99,333,421>,8,<99,334,512>,8,<99,512,333>,8,<100,333,512>,8,<100,335,421>,8,<100,421,333>,8,<101,337,422>,8,<101,338,514>,8,<101,422,343>,8,<101,514,337>,8,<102,339,422>,8,<102,340,339>,8,<103,341,422>,8,<103,342,516>,8,<103,422,339>,8,<103,516,341>,8,<104,341,516>,8,<104,343,422>,8,<104,344,343>,8,<104,422,341>,8,<104,516,344>,8,<105,345,424>,8,<105,346,518>,8,<105,424,349>,8,<105,518,345>,8,<106,347,424>,8,<106,348,519>,8,<106,519,347>,8,<107,347,519>,8,<107,349,424>,8,<107,424,347>,8,<107,519,350>,8,<108,351,425>,8,<108,352,521>,8,<108,521,351>,8,<109,353,425>,8,<109,354,522>,8,<109,425,351>,8,<109,522,353>,8,<110,355,425>,8,<110,425,353>,8,<111,357,426>,8,<111,358,357>,8,<111,426,363>,8,<112,359,426>,8,<112,360,525>,8,<112,525,359>,8,<113,359,525>,8,<113,361,426>,8,<113,362,361>,8,<113,426,359>,8,<113,525,362>,8,<114,363,426>,8,<114,364,527>,8,<114,426,361>,8,<114,527,363>,8,<115,365,427>,8,<115,366,528>,8,<115,528,365>,8,<116,365,528>,8,<116,367,427>,8,<116,427,365>,8,<116,528,368>,8,<117,369,427>,8,<117,370,530>,8,<117,427,367>,8,<117,530,369>,8,<118,369,530>,8,<118,371,427>,8,<118,530,372>,8,<119,373,428>,8,<119,379,535>,8,<119,535,374>,8,<120,375,428>,8,<120,376,533>,8,<120,428,373>,8,<121,377,428>,8,<121,378,377>,8,<121,428,375>,8,<122,379,428>,8,<122,380,535>,8,<122,535,379>,8,<123,381,429>,8,<123,382,381>,8,<124,383,429>,8,<124,384,537>,8,<124,429,381>,8,<124,537,383>,8,<125,383,537>,8,<125,385,429>,8,<125,429,383>,8,<125,537,386>,8,<126,387,429>,8,<126,388,539>,8,<126,429,385>,8,<126,539,387>,8,<127,389,430>,8,<127,390,540>,8,<127,430,393>,8,<127,540,389>,8,<128,389,540>,8,<128,391,430>,8,<128,540,392>,8,<129,393,430>,8,<129,394,542>,8,<129,430,391>,8,<130,395,431>,8,<130,396,543>,8,<130,399,545>,8,<130,431,399>,8,<131,395,543>,8,<131,397,431>,8,<131,543,398>,8,<132,399,431>,8,<132,400,545>,8,<132,431,397>,8,<132,545,399>,8,<133,401,432>,8,<133,402,546>,8,<133,432,407>,8,<134,404,547>,8,<134,547,403>,8,<135,405,432>,8,<136,405,548>,8,<136,407,432>,8,<136,408,549>,8,<136,548,408>,8,<136,549,407>,8,<137,409,433>,8,<137,410,550>,8,<137,433,415>,8,<137,550,409>,8,<138,409,550>,8,<138,411,433>,8,<138,412,551>,8,<138,550,412>,8,<138,551,411>,8,<139,413,433>,8,<139,433,411>,8,<140,415,433>,8,<140,416,553>,8,<140,433,413>,8,<140,553,415>,8,<141,0,180>,8,<141,442,194>,8,<142,0,292>,8,<142,5,212>,8,<142,210,0>,8,<142,292,490>,8,<142,450,210>,8,<142,490,290>,8,<143,438,186>,8,<143,975,1>,8,<144,472,3>,8,<145,1,284>,8,<145,4,190>,8,<145,190,439>,8,<145,282,4>,8,<145,439,188>,8,<145,486,282>,8,<146,2,220>,8,<146,218,5>,8,<146,446,202>,8,<146,454,218>,8,<149,4,178>,8,<149,440,190>,8,<151,196,4>,8,<151,443,196>,8,<151,489,288>,8,<152,5,290>,8,<152,19,206>,8,<152,204,5>,8,<152,447,204>,8,<153,5,218>,8,<153,451,212>,8,<156,1,821>,8,<156,18,286>,8,<156,487,284>,8,<156,821,1024>,8,<156,823,18>,8,<156,1024,823>,8,<157,2,202>,8,<157,17,745>,8,<157,449,208>,8,<157,739,2>,8,<157,745,986>,8,<157,986,739>,8,<158,0,194>,8,<158,292,0>,8,<158,445,200>,8,<158,491,292>,8,<161,759,13>,8,<161,992,759>,8,<162,216,14>,8,<162,453,216>,8,<164,12,184>,8,<164,14,238>,8,<164,184,436>,8,<164,244,12>,8,<164,436,182>,8,<164,467,244>,8,<165,15,186>,8,<165,186,441>,8,<165,250,15>,8,<165,470,250>,8,<166,11,258>,8,<166,256,14>,8,<166,473,256>,8,<167,11,224>,8,<167,224,456>,8,<167,268,11>,8,<167,479,268>,8,<168,9,234>,8,<168,16,272>,8,<168,232,16>,8,<168,461,232>,8,<168,480,270>,8,<169,17,278>,8,<169,483,276>,8,<169,815,17>,8,<169,1020,815>,8,<170,9,228>,8,<170,18,763>,8,<170,458,226>,8,<170,763,995>,8,<170,995,765>,8,<171,19,236>,8,<171,485,280>,8,<172,9,270>,8,<172,20,230>,8,<172,230,459>,8,<172,274,20>,8,<172,459,228>,8,<172,482,274>,8,<173,481,272>,8,<174,484,278>,8,<175,18,226>,8,<175,460,230>,8,<176,16,232>,8,<176,19,296>,8,<176,232,463>,8,<176,463,236>,8,<177,434,22>,8,<177,494,298>,8,<178,4,141>,8,<178,141,434>,8,<178,437,149>,8,<179,23,302>,8,<179,182,23>,8,<179,435,182>,8,<180,434,141>,8,<180,435,179>,8,<181,24,304>,8,<181,496,302>,8,<182,435,162>,8,<183,178,21>,8,<183,437,178>,8,<184,437,183>,8,<185,188,26>,8,<185,438,188>,8,<187,27,310>,8,<187,310,499>,8,<188,1,145>,8,<189,192,28>,8,<189,440,192>,8,<190,4,149>,8,<190,440,189>,8,<191,25,306>,8,<191,441,25>,8,<191,501,312>,8,<192,12,165>,8,<192,165,441>,8,<192,440,12>,8,<193,30,316>,8,<193,316,502>,8,<193,442,196>,8,<193,502,314>,8,<194,0,141>,8,<194,445,158>,8,<195,31,318>,8,<195,443,31>,8,<196,30,193>,8,<196,141,4>,8,<196,442,141>,8,<196,443,195>,8,<197,200,32>,8,<197,444,200>,8,<197,504,318>,8,<198,20,173>,8,<198,151,20>,8,<198,173,444>,8,<198,443,151>,8,<199,32,200>,8,<199,200,445>,8,<200,16,158>,8,<201,446,204>,8,<201,506,322>,8,<202,2,146>,8,<202,449,157>,8,<203,34,204>,8,<203,507,324>,8,<204,34,201>,8,<204,446,146>,8,<204,447,203>,8,<205,448,208>,8,<206,19,174>,8,<206,174,448>,8,<206,447,152>,8,<206,448,205>,8,<208,17,157>,8,<208,36,205>,8,<208,449,207>,8,<209,38,332>,8,<209,450,38>,8,<210,37,215>,8,<211,214,39>,8,<211,451,214>,8,<212,5,153>,8,<212,450,142>,8,<212,451,211>,8,<213,512,334>,8,<214,11,166>,8,<214,166,452>,8,<214,451,11>,8,<215,40,216>,8,<215,453,210>,8,<215,513,336>,8,<216,452,166>,8,<216,453,215>,8,<217,42,340>,8,<217,340,514>,8,<217,454,42>,8,<218,41,223>,8,<218,457,153>,8,<219,222,43>,8,<219,455,222>,8,<220,454,146>,8,<220,455,219>,8,<221,516,342>,8,<222,13,167>,8,<222,167,456>,8,<222,455,161>,8,<223,44,224>,8,<223,224,457>,8,<223,457,218>,8,<225,46,348>,8,<225,458,46>,8,<225,518,346>,8,<226,18,170>,8,<226,460,175>,8,<227,230,47>,8,<227,459,230>,8,<228,9,172>,8,<228,458,170>,8,<229,45,346>,8,<229,47,230>,8,<229,460,45>,8,<230,460,229>,8,<231,49,354>,8,<231,354,521>,8,<231,461,49>,8,<231,521,352>,8,<233,236,50>,8,<233,462,236>,8,<234,9,171>,8,<234,171,462>,8,<234,461,168>,8,<235,50,236>,8,<235,232,48>,8,<235,463,232>,8,<236,19,176>,8,<236,462,171>,8,<236,463,235>,8,<237,240,52>,8,<237,464,240>,8,<237,524,358>,8,<238,464,237>,8,<238,467,164>,8,<239,53,362>,8,<239,362,525>,8,<239,525,360>,8,<241,53,242>,8,<241,242,466>,8,<241,244,54>,8,<241,466,244>,8,<243,51,358>,8,<243,358,527>,8,<243,467,51>,8,<245,56,368>,8,<245,528,366>,8,<247,57,370>,8,<247,250,57>,8,<247,469,250>,8,<248,469,247>,8,<249,58,372>,8,<249,372,530>,8,<251,246,55>,8,<251,471,246>,8,<252,165,12>,8,<252,470,165>,8,<252,471,251>,8,<253,59,254>,8,<253,60,376>,8,<253,254,472>,8,<253,472,256>,8,<255,473,61>,8,<256,60,253>,8,<257,61,258>,8,<257,62,380>,8,<257,258,474>,8,<257,260,62>,8,<257,380,534>,8,<257,474,260>,8,<258,473,166>,8,<261,264,64>,8,<261,476,264>,8,<261,536,382>,8,<262,167,13>,8,<262,476,261>,8,<262,479,167>,8,<263,537,384>,8,<265,65,266>,8,<265,266,478>,8,<265,478,268>,8,<267,63,382>,8,<267,382,539>,8,<267,479,63>,8,<268,66,265>,8,<270,9,168>,8,<270,482,172>,8,<271,481,274>,8,<272,16,173>,8,<272,480,168>,8,<273,67,390>,8,<273,390,542>,8,<273,482,67>,8,<274,69,271>,8,<274,173,20>,8,<274,481,173>,8,<274,482,273>,8,<275,483,71>,8,<275,543,396>,8,<276,171,9>,8,<276,485,171>,8,<277,484,280>,8,<277,544,398>,8,<278,17,174>,8,<278,483,169>,8,<279,70,396>,8,<279,72,280>,8,<279,396,545>,8,<280,19,171>,8,<280,72,277>,8,<280,174,19>,8,<280,484,174>,8,<280,485,279>,8,<281,73,282>,8,<281,74,404>,8,<282,486,281>,8,<282,489,151>,8,<283,286,75>,8,<283,487,286>,8,<283,547,404>,8,<284,1,156>,8,<284,486,145>,8,<285,288,76>,8,<285,488,288>,8,<286,487,156>,8,<286,488,285>,8,<287,282,73>,8,<287,489,282>,8,<288,20,151>,8,<288,175,20>,8,<288,488,175>,8,<289,77,290>,8,<289,78,412>,8,<289,412,550>,8,<290,5,142>,8,<290,490,289>,8,<290,493,152>,8,<291,294,79>,8,<291,491,294>,8,<291,551,412>,8,<293,80,416>,8,<293,492,80>,8,<293,552,414>,8,<294,158,16>,8,<294,491,158>,8,<294,492,293>,8,<295,77,410>,8,<295,290,77>,8,<295,410,553>,8,<295,493,290>,8,<295,553,416>,8,<296,19,152>,8,<296,152,493>,8,<296,492,176>,8,<297,494,82>,8,<298,21,177>,8,<299,302,83>,8,<299,495,302>,8,<300,495,299>,8,<302,23,181>,8,<302,495,179>,8,<303,298,81>,8,<303,497,298>,8,<304,496,181>,8,<304,497,303>,8,<305,85,306>,8,<305,306,498>,8,<305,308,86>,8,<305,498,308>,8,<306,501,191>,8,<308,26,187>,8,<308,187,499>,8,<309,87,310>,8,<309,310,500>,8,<309,312,88>,8,<309,500,312>,8,<312,28,191>,8,<314,29,193>,8,<314,505,199>,8,<315,90,316>,8,<315,316,503>,8,<316,30,195>,8,<316,195,503>,8,<317,320,92>,8,<317,504,320>,8,<318,503,195>,8,<320,504,197>,8,<320,505,319>,8,<322,33,201>,8,<322,509,207>,8,<323,94,324>,8,<323,324,507>,8,<325,328,96>,8,<325,508,328>,8,<327,93,321>,8,<327,321,420>,8,<328,509,327>,8,<329,510,98>,8,<330,97,335>,8,<331,98,332>,8,<331,332,511>,8,<331,334,99>,8,<331,511,334>,8,<332,510,209>,8,<334,39,213>,8,<335,100,336>,8,<335,336,513>,8,<335,513,330>,8,<336,40,215>,8,<336,512,213>,8,<337,514,102>,8,<338,41,217>,8,<338,217,514>,8,<339,342,103>,8,<339,515,342>,8,<340,515,339>,8,<342,43,221>,8,<342,515,219>,8,<343,338,101>,8,<343,517,338>,8,<344,516,221>,8,<344,517,343>,8,<345,518,106>,8,<346,520,229>,8,<348,46,227>,8,<348,227,519>,8,<348,518,225>,8,<349,107,350>,8,<349,346,105>,8,<349,350,520>,8,<349,520,346>,8,<351,521,109>,8,<353,522,110>,8,<354,49,233>,8,<354,233,522>,8,<355,110,356>,8,<355,352,108>,8,<355,356,523>,8,<355,523,352>,8,<357,360,112>,8,<357,524,360>,8,<358,51,237>,8,<358,524,357>,8,<360,52,239>,8,<361,526,364>,8,<362,53,241>,8,<362,241,526>,8,<362,526,361>,8,<363,527,111>,8,<364,114,361>,8,<366,55,245>,8,<367,116,368>,8,<367,368,529>,8,<367,370,117>,8,<367,529,370>,8,<368,528,245>,8,<370,57,249>,8,<370,249,530>,8,<370,529,247>,8,<371,118,372>,8,<371,366,115>,8,<371,372,531>,8,<371,531,366>,8,<373,119,374>,8,<373,532,376>,8,<374,532,373>,8,<374,535,259>,8,<375,533,121>,8,<376,60,255>,8,<376,120,373>,8,<376,255,533>,8,<376,532,253>,8,<377,380,122>,8,<377,534,380>,8,<378,534,377>,8,<380,62,259>,8,<380,259,535>,8,<381,384,124>,8,<381,536,384>,8,<382,536,381>,8,<384,64,263>,8,<385,125,386>,8,<385,386,538>,8,<385,388,126>,8,<385,538,388>,8,<386,537,263>,8,<387,539,123>,8,<388,66,267>,8,<388,267,539>,8,<390,67,269>,8,<390,269,540>,8,<391,128,392>,8,<391,392,541>,8,<391,394,129>,8,<391,541,394>,8,<392,540,269>,8,<393,542,127>,8,<397,131,398>,8,<397,398,544>,8,<397,400,132>,8,<397,544,400>,8,<398,71,277>,8,<398,543,275>,8,<401,134,403>,8,<401,403,432>,8,<401,546,134>,8,<402,549,287>,8,<403,406,135>,8,<403,547,406>,8,<404,546,281>,8,<405,135,406>,8,<405,406,548>,8,<407,402,133>,8,<407,549,402>,8,<410,77,289>,8,<410,289,550>,8,<411,551,414>,8,<413,139,414>,8,<413,414,552>,8,<413,552,140>,8,<414,139,411>,8,<415,410,137>,8,<415,553,410>,8,<416,80,295>,8,<416,552,293>,8,<418,307,87>,8,<418,309,88>,8,<419,319,89>,8,<421,331,99>,8,<422,337,102>,8,<424,345,106>,8,<425,355,108>,8,<426,357,112>,8,<427,369,118>,8,<427,371,115>,8,<428,377,122>,8,<428,379,119>,8,<429,387,123>,8,<430,389,128>,8,<431,395,131>,8,<432,403,135>,8,<432,405,136>,8,<433,409,138>,8,<434,180,22>,8,<438,143,1>,8,<438,185,25>,8,<440,149,12>,8,<441,186,25>,8,<443,198,31>,8,<445,194,29>,8,<446,201,33>,8,<447,206,35>,8,<450,209,37>,8,<450,212,38>,8,<451,153,11>,8,<452,216,40>,8,<453,162,0>,8,<454,220,42>,8,<458,228,46>,8,<460,226,45>,8,<461,231,48>,8,<461,234,49>,8,<467,238,51>,8,<472,144,14>,8,<472,254,3>,8,<473,255,60>,8,<473,258,61>,8,<479,262,63>,8,<480,272,68>,8,<482,270,67>,8,<483,275,70>,8,<483,278,71>,8,<485,276,70>,8,<486,284,74>,8,<491,291,78>,8,<492,296,80>,8,<494,177,22>,8,<494,300,82>,8,<496,301,83>,8,<497,183,21>,8,<500,189,28>,8,<502,316,90>,8,<506,324,94>,8,<507,326,95>,8,<510,329,97>,8,<510,332,98>,8,<511,211,39>,8,<512,336,100>,8,<514,340,102>,8,<517,344,44>,8,<518,348,106>,8,<520,350,47>,8,<521,354,109>,8,<522,233,50>,8,<522,356,110>,8,<523,235,48>,8,<523,356,50>,8,<526,241,54>,8,<527,358,111>,8,<531,251,55>,8,<533,375,120>,8,<533,378,121>,8,<538,386,65>,8,<539,382,123>,8,<541,392,68>,8,<542,390,127>,8,<542,393,129>,8,<543,395,130>,8,<545,396,130>,8,<546,401,133>,8,<546,402,73>,8,<546,404,134>,8,<548,285,76>,8,<549,408,76>,8,<552,416,140>,8,<554,702,990>,8,<554,747,687>,8,<555,688,1001>,8,<555,791,1009>,8,<555,1001,777>,8,<555,1009,688>,8,<556,686,733>,8,<556,733,694>,8,<560,696,988>,8,<560,700,1015>,8,<560,795,1011>,8,<560,988,751>,8,<560,1011,700>,8,<560,1015,805>,8,<561,692,977>,8,<561,701,1003>,8,<561,789,1008>,8,<561,977,729>,8,<561,1003,781>,8,<561,1008,701>,8,<562,688,1009>,8,<562,753,702>,8,<562,775,1001>,8,<562,793,705>,8,<562,1001,688>,8,<563,710,981>,8,<563,831,1029>,8,<563,981,737>,8,<563,1029,713>,8,<565,710,811>,8,<565,811,709>,8,<566,714,971>,8,<566,971,715>,8,<567,717,971>,8,<567,837,1032>,8,<567,971,714>,8,<567,1032,716>,8,<568,719,716>,8,<569,721,973>,8,<569,841,1034>,8,<569,973,718>,8,<570,723,978>,8,<571,722,1035>,8,<571,724,976>,8,<571,1035,845>,8,<572,727,976>,8,<572,976,724>,8,<573,726,1037>,8,<573,728,978>,8,<573,978,729>,8,<574,731,982>,8,<576,734,981>,8,<576,735,980>,8,<577,857,1042>,8,<577,1042,736>,8,<578,738,983>,8,<578,739,986>,8,<578,986,744>,8,<580,743,984>,8,<580,863,1045>,8,<581,865,1046>,8,<581,1046,744>,8,<582,746,987>,8,<582,752,1050>,8,<582,867,1047>,8,<582,1050,867>,8,<583,749,987>,8,<583,869,1048>,8,<583,987,746>,8,<584,750,989>,8,<584,751,748>,8,<584,989,751>,8,<585,753,989>,8,<587,757,991>,8,<587,877,1052>,8,<587,1052,756>,8,<588,758,993>,8,<589,761,993>,8,<589,881,1054>,8,<589,993,758>,8,<590,762,995>,8,<590,763,766>,8,<590,995,763>,8,<591,765,995>,8,<591,995,762>,8,<592,764,1056>,8,<592,767,764>,8,<592,887,1057>,8,<592,1056,887>,8,<593,768,998>,8,<593,769,772>,8,<593,772,1060>,8,<594,770,999>,8,<594,771,998>,8,<595,893,1060>,8,<596,775,1004>,8,<596,1004,780>,8,<597,774,1061>,8,<597,776,1002>,8,<597,1002,777>,8,<597,1061,897>,8,<598,779,1002>,8,<598,1002,776>,8,<599,780,1004>,8,<599,1004,781>,8,<600,782,1005>,8,<600,788,1068>,8,<600,1005,783>,8,<601,785,1005>,8,<601,905,1066>,8,<601,1005,782>,8,<601,1066,784>,8,<602,786,1007>,8,<603,789,1007>,8,<603,909,1068>,8,<603,1007,786>,8,<603,1068,788>,8,<604,791,1012>,8,<604,911,1069>,8,<604,1012,796>,8,<604,1069,790>,8,<605,792,1010>,8,<606,795,1010>,8,<606,915,1071>,8,<606,1010,792>,8,<607,796,1012>,8,<607,1012,797>,8,<608,799,1016>,8,<609,798,1073>,8,<609,800,1014>,8,<609,1014,801>,8,<609,1073,921>,8,<610,803,1014>,8,<610,923,1075>,8,<610,1014,800>,8,<611,802,1075>,8,<611,804,1016>,8,<611,1016,805>,8,<611,1075,925>,8,<612,806,1017>,8,<612,807,1019>,8,<613,809,1017>,8,<613,929,1078>,8,<614,931,1079>,8,<615,812,1020>,8,<615,813,1022>,8,<616,815,1020>,8,<616,1020,812>,8,<617,937,1082>,8,<617,1082,816>,8,<618,819,824>,8,<618,939,1083>,8,<619,820,1024>,8,<619,821,1023>,8,<619,1024,821>,8,<620,820,1084>,8,<620,1084,943>,8,<621,825,1025>,8,<621,945,1086>,8,<621,1025,822>,8,<623,828,1028>,8,<623,829,1027>,8,<623,1027,826>,8,<624,828,1088>,8,<624,1088,951>,8,<625,832,1030>,8,<625,833,1029>,8,<626,834,1031>,8,<626,840,954>,8,<626,954,834>,8,<626,1031,835>,8,<627,837,1031>,8,<627,1031,834>,8,<628,836,954>,8,<628,838,1033>,8,<628,954,838>,8,<629,841,1033>,8,<629,1033,838>,8,<630,843,1038>,8,<630,848,955>,8,<630,955,842>,8,<630,1038,848>,8,<631,844,1036>,8,<632,844,955>,8,<632,847,1036>,8,<632,1036,844>,8,<633,846,955>,8,<633,848,1038>,8,<633,849,846>,8,<633,1038,849>,8,<634,851,1042>,8,<634,856,956>,8,<634,1042,856>,8,<635,850,956>,8,<635,853,1039>,8,<635,956,852>,8,<636,854,1041>,8,<636,855,1040>,8,<636,1040,852>,8,<636,1041,855>,8,<638,858,1043>,8,<638,859,1046>,8,<638,1043,859>,8,<638,1046,864>,8,<639,858,957>,8,<639,861,1043>,8,<639,957,860>,8,<639,1043,858>,8,<640,860,957>,8,<640,863,1044>,8,<641,862,957>,8,<641,957,864>,8,<642,866,1047>,8,<642,872,958>,8,<642,958,866>,8,<643,866,958>,8,<643,869,1047>,8,<643,958,868>,8,<643,1047,866>,8,<644,868,958>,8,<644,870,1049>,8,<644,871,868>,8,<644,1049,871>,8,<645,870,958>,8,<645,873,1049>,8,<645,958,872>,8,<647,874,959>,8,<647,877,1051>,8,<648,876,959>,8,<648,878,1053>,8,<648,959,878>,8,<648,1053,879>,8,<649,881,1053>,8,<649,1053,878>,8,<650,882,1055>,8,<650,883,886>,8,<650,886,961>,8,<650,1055,883>,8,<651,885,1055>,8,<651,1055,882>,8,<652,884,961>,8,<652,887,1056>,8,<652,961,886>,8,<652,1056,884>,8,<653,889,892>,8,<653,892,962>,8,<654,890,1059>,8,<654,891,1058>,8,<654,1059,891>,8,<655,890,962>,8,<655,893,1059>,8,<655,962,892>,8,<655,1059,890>,8,<656,895,1064>,8,<656,1064,900>,8,<657,894,963>,8,<657,896,1062>,8,<657,897,894>,8,<657,1062,897>,8,<658,899,1062>,8,<658,1062,896>,8,<659,900,1064>,8,<659,1064,901>,8,<660,902,1065>,8,<660,908,964>,8,<660,1065,903>,8,<661,902,964>,8,<661,905,1065>,8,<661,964,904>,8,<661,1065,902>,8,<662,906,1067>,8,<663,906,964>,8,<663,909,1067>,8,<663,1067,906>,8,<664,911,1072>,8,<664,916,965>,8,<664,1072,916>,8,<665,910,965>,8,<665,912,1070>,8,<665,965,912>,8,<666,915,1070>,8,<666,1070,912>,8,<667,914,965>,8,<667,916,1072>,8,<667,917,914>,8,<667,1072,917>,8,<668,919,1076>,8,<668,924,966>,8,<669,918,966>,8,<669,920,1074>,8,<669,966,920>,8,<669,1074,921>,8,<670,923,1074>,8,<670,1074,920>,8,<672,926,1077>,8,<672,927,1079>,8,<672,1079,930>,8,<673,926,967>,8,<673,929,1077>,8,<673,1077,926>,8,<674,928,967>,8,<674,930,1079>,8,<674,967,930>,8,<675,932,1080>,8,<675,933,1082>,8,<675,936,968>,8,<676,935,1080>,8,<676,1080,932>,8,<677,934,968>,8,<677,968,936>,8,<678,944,969>,8,<678,969,938>,8,<679,940,1084>,8,<679,941,1083>,8,<679,1083,938>,8,<679,1084,941>,8,<680,940,969>,8,<680,969,942>,8,<681,945,1085>,8,<681,1085,942>,8,<682,952,970>,8,<682,970,946>,8,<683,946,970>,8,<683,948,1088>,8,<683,949,1087>,8,<683,1087,946>,8,<683,1088,949>,8,<684,948,970>,8,<684,970,950>,8,<685,952,1090>,8,<685,953,1089>,8,<685,1089,950>,8,<685,1090,953>,8,<686,554,731>,8,<686,971,717>,8,<686,979,733>,8,<687,557,827>,8,<687,829,554>,8,<687,987,749>,8,<687,1027,829>,8,<689,556,819>,8,<689,976,727>,8,<690,557,755>,8,<690,983,741>,8,<690,991,757>,8,<692,556,727>,8,<692,974,715>,8,<694,1026,819>,8,<695,557,741>,8,<695,1030,827>,8,<696,557,749>,8,<696,994,755>,8,<699,554,829>,8,<699,563,737>,8,<699,829,1028>,8,<699,982,731>,8,<702,719,562>,8,<702,972,719>,8,<703,561,781>,8,<703,721,561>,8,<703,781,1004>,8,<703,973,721>,8,<703,1004,775>,8,<704,15,787>,8,<704,723,15>,8,<704,787,1007>,8,<704,978,723>,8,<704,1007,789>,8,<705,753,562>,8,<705,989,753>,8,<705,1010,795>,8,<706,560,805>,8,<706,761,560>,8,<706,993,761>,8,<707,563,769>,8,<707,769,998>,8,<707,998,771>,8,<707,1017,809>,8,<708,564,817>,8,<708,999,773>,8,<708,1022,813>,8,<709,9,765>,8,<709,767,565>,8,<709,996,767>,8,<709,1019,807>,8,<710,563,809>,8,<710,1018,811>,8,<711,17,815>,8,<711,564,743>,8,<711,815,1021>,8,<711,1021,817>,8,<712,565,767>,8,<712,763,18>,8,<712,997,763>,8,<712,1025,825>,8,<713,564,773>,8,<713,769,563>,8,<713,1000,769>,8,<713,1029,833>,8,<714,1031,567>,8,<715,556,692>,8,<715,686,556>,8,<715,971,686>,8,<715,974,720>,8,<716,717,567>,8,<716,839,568>,8,<716,972,717>,8,<716,1032,839>,8,<717,554,686>,8,<717,972,554>,8,<718,568,839>,8,<718,841,569>,8,<718,973,568>,8,<718,1033,841>,8,<719,703,562>,8,<719,972,716>,8,<719,973,703>,8,<720,566,715>,8,<720,721,569>,8,<720,974,721>,8,<720,1034,566>,8,<721,974,561>,8,<722,571,725>,8,<722,975,723>,8,<723,570,722>,8,<723,975,143>,8,<724,847,572>,8,<724,1036,847>,8,<725,689,1>,8,<725,975,722>,8,<725,976,689>,8,<726,573,729>,8,<726,727,572>,8,<726,729,977>,8,<726,977,727>,8,<727,556,689>,8,<727,977,692>,8,<728,573,849>,8,<728,843,570>,8,<728,1038,843>,8,<729,704,561>,8,<729,978,704>,8,<730,574,851>,8,<730,575,733>,8,<730,853,575>,8,<730,979,574>,8,<730,1039,853>,8,<731,554,699>,8,<731,979,686>,8,<732,855,576>,8,<732,980,733>,8,<732,1040,855>,8,<733,575,732>,8,<733,979,730>,8,<733,980,694>,8,<734,577,737>,8,<734,857,577>,8,<734,1041,857>,8,<735,565,694>,8,<735,694,980>,8,<735,710,565>,8,<735,981,710>,8,<736,737,577>,8,<736,851,574>,8,<736,982,737>,8,<736,1042,851>,8,<737,981,734>,8,<737,982,699>,8,<738,579,741>,8,<738,1043,579>,8,<739,690,2>,8,<739,983,690>,8,<740,984,741>,8,<740,1044,580>,8,<741,557,690>,8,<741,579,740>,8,<741,983,738>,8,<741,984,695>,8,<742,581,745>,8,<742,985,580>,8,<742,1045,581>,8,<743,564,695>,8,<743,695,984>,8,<743,985,711>,8,<744,745,581>,8,<744,859,578>,8,<744,986,745>,8,<744,1046,859>,8,<745,985,742>,8,<746,869,583>,8,<746,1047,869>,8,<747,987,687>,8,<747,990,752>,8,<748,988,749>,8,<748,1048,584>,8,<749,557,687>,8,<749,583,748>,8,<749,988,696>,8,<750,873,585>,8,<750,1049,873>,8,<751,705,560>,8,<751,988,748>,8,<751,989,705>,8,<752,582,747>,8,<752,990,753>,8,<753,585,752>,8,<753,990,702>,8,<754,877,587>,8,<754,991,586>,8,<754,1051,877>,8,<755,557,696>,8,<755,991,690>,8,<755,994,760>,8,<756,588,759>,8,<756,879,588>,8,<756,992,757>,8,<756,1052,879>,8,<757,587,756>,8,<758,881,589>,8,<758,1053,881>,8,<759,706,13>,8,<759,992,756>,8,<759,993,706>,8,<760,586,755>,8,<760,761,589>,8,<760,994,761>,8,<760,1054,586>,8,<761,994,560>,8,<762,1055,885>,8,<763,997,766>,8,<764,996,591>,8,<765,9,170>,8,<765,996,709>,8,<766,883,590>,8,<766,997,767>,8,<766,1057,883>,8,<767,592,766>,8,<767,996,764>,8,<767,997,712>,8,<768,891,594>,8,<768,1058,891>,8,<769,1000,772>,8,<770,595,773>,8,<770,1059,595>,8,<771,708,9>,8,<771,999,708>,8,<772,1000,773>,8,<773,564,708>,8,<773,595,772>,8,<773,999,770>,8,<773,1000,713>,8,<774,597,777>,8,<774,775,596>,8,<774,777,1001>,8,<774,1001,775>,8,<775,562,703>,8,<776,597,897>,8,<776,899,598>,8,<776,1062,899>,8,<778,599,781>,8,<778,779,598>,8,<778,1003,779>,8,<778,1063,599>,8,<780,895,596>,8,<780,1064,895>,8,<781,1003,778>,8,<782,600,903>,8,<782,905,601>,8,<782,1065,905>,8,<784,602,787>,8,<784,1006,785>,8,<784,1066,907>,8,<785,601,784>,8,<786,909,603>,8,<786,1067,909>,8,<787,1006,784>,8,<788,600,783>,8,<788,783,1008>,8,<788,789,603>,8,<788,1008,789>,8,<789,561,704>,8,<790,605,793>,8,<790,791,604>,8,<790,913,605>,8,<790,1009,791>,8,<790,1069,913>,8,<792,1070,606>,8,<793,1009,790>,8,<793,1010,705>,8,<794,607,797>,8,<794,797,1011>,8,<794,917,607>,8,<794,1011,795>,8,<794,1071,917>,8,<795,560,705>,8,<795,606,794>,8,<796,911,604>,8,<796,1072,911>,8,<798,609,801>,8,<798,1013,799>,8,<799,13,706>,8,<799,608,798>,8,<799,706,1016>,8,<800,923,610>,8,<800,1074,923>,8,<801,1013,798>,8,<802,611,805>,8,<802,803,610>,8,<802,1015,803>,8,<804,919,608>,8,<804,1076,919>,8,<805,1015,802>,8,<805,1016,706>,8,<806,929,613>,8,<806,1077,929>,8,<807,9,709>,8,<807,707,9>,8,<807,1017,707>,8,<808,614,811>,8,<808,1018,613>,8,<808,1078,614>,8,<809,563,707>,8,<809,1018,710>,8,<810,927,612>,8,<810,1019,811>,8,<810,1079,927>,8,<811,614,810>,8,<811,1018,808>,8,<811,1019,709>,8,<812,935,616>,8,<812,1080,935>,8,<813,1020,169>,8,<814,617,817>,8,<814,815,616>,8,<814,1021,815>,8,<814,1081,617>,8,<816,933,615>,8,<816,1022,817>,8,<816,1082,933>,8,<817,564,711>,8,<817,617,816>,8,<817,1021,814>,8,<817,1022,708>,8,<818,941,619>,8,<818,1023,819>,8,<818,1083,941>,8,<819,556,694>,8,<819,618,818>,8,<819,1023,689>,8,<819,1026,824>,8,<820,620,823>,8,<820,823,1024>,8,<821,1,689>,8,<821,689,1023>,8,<822,823,620>,8,<822,1025,823>,8,<822,1085,621>,8,<824,939,618>,8,<824,1026,621>,8,<824,1086,939>,8,<825,565,712>,8,<825,694,565>,8,<825,1026,694>,8,<826,949,623>,8,<826,1027,827>,8,<826,1087,949>,8,<827,557,695>,8,<827,622,826>,8,<827,1027,687>,8,<827,1030,832>,8,<828,624,831>,8,<828,831,1028>,8,<830,1029,831>,8,<830,1089,953>,8,<831,563,699>,8,<831,624,830>,8,<831,699,1028>,8,<832,622,827>,8,<832,947,622>,8,<832,1090,947>,8,<833,564,713>,8,<833,695,564>,8,<833,1030,695>,8,<834,954,627>,8,<835,714,566>,8,<835,1031,714>,8,<836,628,839>,8,<836,837,627>,8,<836,839,1032>,8,<836,1032,837>,8,<838,954,629>,8,<839,1033,718>,8,<840,626,835>,8,<840,835,1034>,8,<840,841,629>,8,<840,1034,841>,8,<842,631,845>,8,<842,843,630>,8,<842,955,631>,8,<842,1035,843>,8,<843,722,570>,8,<843,1035,722>,8,<845,724,571>,8,<845,1035,842>,8,<845,1036,724>,8,<846,847,632>,8,<846,1037,847>,8,<847,1037,572>,8,<849,1037,846>,8,<849,1038,728>,8,<850,1039,634>,8,<851,1039,730>,8,<852,853,635>,8,<852,956,636>,8,<852,1040,853>,8,<853,732,575>,8,<853,1040,732>,8,<854,637,857>,8,<854,857,1041>,8,<854,956,637>,8,<855,734,576>,8,<855,1041,734>,8,<856,857,637>,8,<856,1042,857>,8,<859,738,578>,8,<859,1043,738>,8,<860,861,639>,8,<860,1044,861>,8,<861,740,579>,8,<861,1044,740>,8,<862,641,865>,8,<862,865,1045>,8,<862,1045,640>,8,<864,858,638>,8,<864,957,858>,8,<864,1046,865>,8,<865,641,864>,8,<867,1050,872>,8,<868,869,643>,8,<868,1048,869>,8,<871,750,584>,8,<871,1048,868>,8,<871,1049,750>,8,<872,642,867>,8,<872,873,645>,8,<872,1050,873>,8,<873,752,585>,8,<873,1050,752>,8,<874,1051,646>,8,<875,754,586>,8,<875,1051,754>,8,<876,648,879>,8,<876,879,1052>,8,<876,1052,877>,8,<877,647,876>,8,<878,959,649>,8,<879,758,588>,8,<879,1053,758>,8,<880,646,875>,8,<880,875,1054>,8,<880,881,649>,8,<880,959,646>,8,<880,1054,881>,8,<882,961,651>,8,<883,762,590>,8,<883,1055,762>,8,<883,1057,886>,8,<884,1056,651>,8,<885,591,762>,8,<885,764,591>,8,<885,1056,764>,8,<886,887,652>,8,<886,1057,887>,8,<888,962,654>,8,<888,1058,653>,8,<889,768,593>,8,<889,1058,768>,8,<889,1060,892>,8,<891,770,594>,8,<891,1059,770>,8,<892,893,655>,8,<892,1060,893>,8,<894,895,656>,8,<894,1061,895>,8,<895,774,596>,8,<895,1061,774>,8,<896,963,658>,8,<897,1061,894>,8,<897,1062,776>,8,<898,659,901>,8,<898,899,658>,8,<898,963,659>,8,<898,1063,899>,8,<899,778,598>,8,<899,1063,778>,8,<900,963,656>,8,<901,1063,898>,8,<901,1064,599>,8,<903,1065,782>,8,<904,662,907>,8,<904,905,661>,8,<904,964,662>,8,<904,1066,905>,8,<907,602,784>,8,<907,786,602>,8,<907,1066,904>,8,<907,1067,786>,8,<908,660,903>,8,<908,903,1068>,8,<908,909,663>,8,<908,1068,909>,8,<910,665,913>,8,<910,1069,911>,8,<911,664,910>,8,<912,965,666>,8,<913,792,605>,8,<913,1069,910>,8,<913,1070,792>,8,<914,915,666>,8,<914,1071,915>,8,<917,796,607>,8,<917,1071,914>,8,<917,1072,796>,8,<918,669,921>,8,<918,921,1073>,8,<918,1073,919>,8,<919,668,918>,8,<919,798,608>,8,<919,1073,798>,8,<920,966,670>,8,<921,800,609>,8,<921,1074,800>,8,<922,671,925>,8,<922,923,670>,8,<922,925,1075>,8,<922,966,671>,8,<922,1075,923>,8,<924,1076,671>,8,<925,804,611>,8,<925,1076,804>,8,<927,806,612>,8,<927,1077,806>,8,<928,674,931>,8,<928,929,673>,8,<928,931,1078>,8,<928,1078,929>,8,<930,967,672>,8,<932,968,676>,8,<933,812,615>,8,<933,1080,812>,8,<934,677,937>,8,<934,935,676>,8,<934,937,1081>,8,<934,1081,935>,8,<935,814,616>,8,<935,1081,814>,8,<936,1082,677>,8,<938,940,679>,8,<938,969,940>,8,<938,1083,678>,8,<940,680,943>,8,<941,820,619>,8,<941,1084,820>,8,<942,943,680>,8,<942,969,681>,8,<942,1085,943>,8,<943,1084,940>,8,<943,1085,620>,8,<944,678,939>,8,<944,939,1086>,8,<944,1086,681>,8,<946,1087,682>,8,<947,826,622>,8,<947,1087,826>,8,<948,684,951>,8,<949,828,623>,8,<949,1088,828>,8,<950,951,684>,8,<950,970,685>,8,<950,1089,951>,8,<951,830,624>,8,<951,1088,948>,8,<951,1089,830>,8,<952,682,947>,8,<952,947,1090>,8,<953,625,830>,8,<953,832,625>,8,<953,1090,832>,8,<954,836,627>,8,<954,840,629>,8,<955,844,631>,8,<955,846,632>,8,<955,848,633>,8,<956,850,634>,8,<956,854,636>,8,<956,856,637>,8,<957,862,640>,8,<958,870,644>,8,<959,874,646>,8,<959,876,647>,8,<959,880,649>,8,<961,882,650>,8,<961,884,651>,8,<962,888,653>,8,<962,890,654>,8,<963,894,656>,8,<963,896,657>,8,<963,898,658>,8,<963,900,659>,8,<964,902,660>,8,<964,906,662>,8,<964,908,663>,8,<965,910,664>,8,<965,914,666>,8,<965,916,667>,8,<966,918,668>,8,<966,922,670>,8,<966,924,671>,8,<967,926,672>,8,<967,928,673>,8,<968,932,675>,8,<968,934,676>,8,<969,944,681>,8,<970,948,683>,8,<970,952,685>,8,<972,702,554>,8,<973,719,568>,8,<974,692,561>,8,<975,725,1>,8,<976,725,571>,8,<978,728,570>,8,<979,731,574>,8,<980,732,576>,8,<981,735,576>,8,<982,736,574>,8,<983,739,578>,8,<984,740,580>,8,<985,743,580>,8,<987,747,582>,8,<989,750,585>,8,<990,747,554>,8,<991,754,587>,8,<991,755,586>,8,<993,759,588>,8,<994,696,560>,8,<996,765,591>,8,<998,768,594>,8,<998,769,593>,8,<999,771,594>,8,<1007,787,602>,8,<1009,793,562>,8,<1010,793,605>,8,<1016,804,608>,8,<1017,806,613>,8,<1017,807,612>,8,<1018,809,613>,8,<1019,810,612>,8,<1020,813,615>,8,<1022,816,615>,8,<1023,818,619>,8,<1026,825,621>,8,<1028,829,623>,8,<1029,830,625>,8,<1030,833,625>,8,<1031,837,567>,8,<1033,839,628>,8,<1034,720,569>,8,<1034,835,566>,8,<1036,845,631>,8,<1037,726,572>,8,<1037,849,573>,8,<1039,850,635>,8,<1039,851,634>,8,<1043,861,579>,8,<1044,860,640>,8,<1044,863,580>,8,<1045,742,580>,8,<1045,863,640>,8,<1045,865,581>,8,<1047,746,582>,8,<1047,867,642>,8,<1048,748,583>,8,<1048,871,584>,8,<1049,870,645>,8,<1051,874,647>,8,<1051,875,646>,8,<1054,760,589>,8,<1054,875,586>,8,<1056,885,651>,8,<1057,766,592>,8,<1058,888,654>,8,<1058,889,653>,8,<1059,893,595>,8,<1060,772,595>,8,<1060,889,593>,8,<1063,901,599>,8,<1064,780,599>,8,<1067,907,662>,8,<1068,903,600>,8,<1070,913,665>,8,<1070,915,606>,8,<1071,794,606>,8,<1075,802,610>,8,<1076,924,668>,8,<1076,925,671>,8,<1077,927,672>,8,<1078,808,613>,8,<1078,931,614>,8,<1079,810,614>,8,<1079,931,674>,8,<1080,933,675>,8,<1081,937,617>,8,<1082,936,675>,8,<1082,937,677>,8,<1083,818,618>,8,<1083,939,678>,8,<1085,822,620>,8,<1085,945,621>,8,<1086,824,621>,8,<1086,945,681>,8,<1087,947,682>,8,<1374,1376,1426>,6,<1374,1426,1424>,6,<1375,1425,1429>,6,<1375,1429,1379>,6,<1377,1374,1424>,6,<1378,1377,1427>,6,<1378,1428,1425>,6,<1424,1427,1377>,6,<1425,1375,1378>,6,<1427,1428,1378>,6,<1417,1418,1419>,4,<1419,1416,1417>,4,<1421,1422,1423>,4,<1423,1420,1421>,4}
normal_indices {2924,<7,264,1091>,<8,1266,160>,<10,1270,159>,<147,1092,264>,<159,1275,10>,<159,1276,1275>,<160,1263,8>,<160,1264,1263>,<242,8,1263>,<242,1262,1265>,<242,1263,1262>,<242,1265,466>,<246,471,1268>,<246,1266,8>,<246,1267,1266>,<246,1268,1267>,<248,6,1097>,<248,1094,1096>,<260,474,1272>,<260,1270,10>,<260,1271,1270>,<260,1272,1271>,<266,10,1275>,<266,1274,1277>,<266,1275,1274>,<266,1277,478>,<466,1265,1264>,<469,1096,1098>,<469,1098,163>,<471,160,1269>,<474,159,1273>,<476,147,264>,<478,1276,159>,<478,1277,1276>,<558,1278,701>,<559,1290,700>,<700,1287,559>,<700,1288,1287>,<700,1293,1015>,<701,1281,1003>,<701,1283,558>,<701,1284,1283>,<779,1003,1280>,<779,1278,558>,<779,1279,1278>,<779,1280,1279>,<783,558,1283>,<783,1282,1285>,<783,1283,1282>,<783,1285,1008>,<785,1093,1097>,<785,1095,1093>,<797,559,1287>,<797,1286,1289>,<797,1287,1286>,<797,1289,1011>,<801,147,1013>,<801,1092,147>,<803,1015,1292>,<803,1290,559>,<803,1291,1290>,<803,1292,1291>,<1006,163,1098>,<1006,1098,1095>,<1008,1285,1284>,<1011,1288,700>,<1011,1289,1288>,<1091,264,1092>,<1091,801,7>,<1092,801,1091>,<1093,1095,1102>,<1094,1099,1104>,<1095,785,1006>,<1095,1098,1103>,<1096,469,248>,<1096,1104,1103>,<1097,6,785>,<1097,1093,1101>,<1097,1094,248>,<1097,1100,1099>,<1099,1094,1097>,<1099,1105,1110>,<1100,1101,1107>,<1100,1105,1099>,<1100,1106,1105>,<1101,1100,1097>,<1101,1102,1108>,<1102,1101,1093>,<1102,1103,1109>,<1103,1098,1096>,<1103,1102,1095>,<1104,1096,1094>,<1104,1110,1109>,<1105,1111,1116>,<1105,1116,1110>,<1106,1107,1113>,<1106,1111,1105>,<1106,1112,1111>,<1106,1113,1112>,<1107,1106,1100>,<1107,1108,1114>,<1107,1114,1113>,<1108,1107,1101>,<1108,1109,1115>,<1108,1115,1114>,<1109,1103,1104>,<1109,1108,1102>,<1110,1104,1099>,<1110,1115,1109>,<1110,1116,1115>,<1111,1117,1116>,<1112,1113,1119>,<1112,1117,1111>,<1112,1118,1117>,<1112,1119,1118>,<1114,1119,1113>,<1114,1120,1119>,<1115,1120,1114>,<1115,1121,1120>,<1116,1122,1115>,<1117,1122,1116>,<1117,1135,1122>,<1118,1136,1117>,<1119,1136,1118>,<1119,1137,1136>,<1120,1137,1119>,<1120,1138,1137>,<1121,1138,1120>,<1121,1139,1138>,<1122,1121,1115>,<1122,1140,1121>,<1124,1172,1366>,<1124,1381,1380>,<1125,1171,1232>,<1125,1176,1361>,<1125,1182,1237>,<1125,1232,1182>,<1125,1361,1369>,<1126,1174,1235>,<1127,1174,1229>,<1127,1193,1230>,<1127,1229,1193>,<1127,1230,1175>,<1129,1177,1187>,<1129,1178,1372>,<1129,1187,1234>,<1129,1234,1178>,<1130,1177,1233>,<1130,1180,1373>,<1130,1233,1180>,<1130,1373,1179>,<1131,1182,1232>,<1131,1232,1181>,<1132,1184,1235>,<1132,1235,1183>,<1133,1183,1235>,<1133,1185,1225>,<1133,1186,1236>,<1133,1235,1186>,<1133,1236,1185>,<1134,1185,1236>,<1134,1188,1234>,<1134,1234,1187>,<1134,1236,1188>,<1135,1140,1122>,<1135,1155,1259>,<1135,1164,1255>,<1136,1135,1117>,<1136,1156,1250>,<1136,1167,1256>,<1136,1250,1135>,<1136,1256,1156>,<1137,1151,1260>,<1137,1168,1251>,<1137,1251,1136>,<1137,1260,1168>,<1138,1152,1252>,<1138,1159,1257>,<1138,1252,1137>,<1138,1257,1152>,<1139,1140,1254>,<1139,1147,1261>,<1139,1160,1253>,<1139,1253,1138>,<1139,1254,1147>,<1140,1135,1255>,<1140,1139,1121>,<1140,1148,1254>,<1140,1163,1258>,<1140,1255,1163>,<1141,1189,1231>,<1141,1368,1413>,<1142,1370,1419>,<1143,1195,1424>,<1143,1197,1191>,<1143,1424,1426>,<1144,1196,1192>,<1145,1219,1238>,<1146,1222,1248>,<1147,1150,1220>,<1147,1220,1261>,<1148,1149,1201>,<1148,1201,1254>,<1148,1258,1223>,<1149,1222,1247>,<1150,1147,1254>,<1150,1221,1220>,<1150,1254,1201>,<1151,1154,1214>,<1151,1252,1202>,<1152,1153,1202>,<1152,1202,1252>,<1152,1257,1153>,<1153,1216,1244>,<1153,1244,1202>,<1154,1151,1202>,<1154,1202,1244>,<1155,1250,1203>,<1156,1256,1157>,<1157,1203,1250>,<1157,1210,1241>,<1157,1241,1203>,<1158,1155,1203>,<1158,1203,1241>,<1158,1208,1259>,<1158,1209,1239>,<1159,1162,1217>,<1160,1161,1253>,<1160,1261,1220>,<1161,1204,1253>,<1161,1219,1246>,<1161,1246,1204>,<1163,1255,1205>,<1164,1165,1205>,<1164,1208,1165>,<1164,1259,1208>,<1165,1207,1249>,<1166,1223,1258>,<1166,1224,1223>,<1166,1258,1163>,<1167,1170,1211>,<1168,1169,1206>,<1168,1206,1251>,<1168,1260,1169>,<1169,1213,1243>,<1169,1214,1240>,<1169,1240,1213>,<1169,1243,1206>,<1170,1167,1251>,<1170,1206,1243>,<1170,1243,1212>,<1171,1125,1369>,<1171,1126,1184>,<1171,1228,1126>,<1171,1369,1228>,<1173,1234,1188>,<1173,1364,1123>,<1173,1371,1364>,<1174,1126,1192>,<1174,1192,1229>,<1175,1186,1127>,<1175,1194,1128>,<1175,1230,1194>,<1175,1236,1186>,<1176,1385,1384>,<1177,1129,1372>,<1177,1130,1179>,<1177,1179,1225>,<1177,1225,1187>,<1177,1372,1233>,<1178,1173,1123>,<1178,1234,1173>,<1179,1131,1181>,<1179,1181,1225>,<1179,1237,1131>,<1180,1172,1124>,<1180,1233,1172>,<1181,1132,1183>,<1181,1183,1225>,<1181,1232,1132>,<1184,1232,1171>,<1185,1134,1187>,<1185,1187,1225>,<1186,1174,1127>,<1186,1235,1174>,<1188,1128,1173>,<1188,1236,1128>,<1189,1141,1413>,<1189,1364,1371>,<1189,1365,1410>,<1189,1371,1231>,<1189,1409,1408>,<1189,1413,1365>,<1190,1226,1414>,<1190,1359,1366>,<1190,1360,1394>,<1190,1366,1226>,<1190,1393,1392>,<1190,1414,1415>,<1191,1195,1143>,<1191,1227,1195>,<1192,1197,1144>,<1192,1228,1197>,<1193,1145,1200>,<1193,1196,1145>,<1193,1200,1230>,<1193,1229,1196>,<1194,1146,1198>,<1194,1198,1231>,<1194,1200,1146>,<1194,1230,1200>,<1195,1412,1370>,<1196,1219,1145>,<1196,1229,1192>,<1196,1246,1219>,<1197,1228,1191>,<1197,1244,1216>,<1198,1146,1224>,<1198,1207,1141>,<1198,1249,1207>,<1199,1422,1368>,<1199,1423,1422>,<1199,1425,1428>,<1199,1428,1142>,<1200,1222,1146>,<1200,1247,1222>,<1201,1247,1150>,<1204,1159,1253>,<1204,1162,1159>,<1204,1246,1162>,<1205,1166,1163>,<1205,1249,1166>,<1205,1255,1164>,<1207,1165,1208>,<1207,1239,1379>,<1207,1379,1429>,<1207,1429,1141>,<1208,1239,1207>,<1209,1241,1375>,<1211,1170,1212>,<1211,1210,1157>,<1211,1242,1210>,<1211,1256,1167>,<1212,1242,1211>,<1213,1374,1243>,<1213,1376,1374>,<1214,1154,1215>,<1214,1260,1151>,<1215,1197,1143>,<1215,1240,1214>,<1215,1244,1197>,<1216,1144,1197>,<1216,1245,1144>,<1217,1162,1218>,<1217,1216,1153>,<1217,1245,1216>,<1217,1257,1159>,<1218,1196,1144>,<1218,1245,1217>,<1218,1246,1196>,<1219,1161,1220>,<1220,1161,1160>,<1220,1238,1219>,<1221,1200,1145>,<1221,1238,1220>,<1221,1247,1200>,<1222,1149,1223>,<1223,1149,1148>,<1223,1248,1222>,<1224,1248,1223>,<1224,1249,1198>,<1225,1183,1133>,<1226,1366,1406>,<1226,1405,1404>,<1227,1361,1390>,<1228,1192,1126>,<1231,1198,1141>,<1232,1184,1132>,<1233,1363,1172>,<1233,1372,1363>,<1235,1184,1126>,<1236,1175,1128>,<1237,1176,1125>,<1237,1182,1131>,<1237,1358,1176>,<1237,1373,1358>,<1238,1221,1145>,<1239,1208,1158>,<1239,1209,1379>,<1241,1209,1158>,<1241,1210,1378>,<1241,1378,1375>,<1242,1212,1377>,<1242,1377,1378>,<1242,1378,1210>,<1243,1374,1377>,<1243,1377,1212>,<1244,1215,1154>,<1245,1218,1144>,<1246,1218,1162>,<1247,1201,1149>,<1247,1221,1150>,<1248,1224,1146>,<1249,1205,1165>,<1249,1224,1166>,<1250,1155,1135>,<1250,1156,1157>,<1251,1167,1136>,<1251,1206,1170>,<1252,1151,1137>,<1253,1159,1138>,<1256,1211,1157>,<1257,1217,1153>,<1258,1148,1140>,<1259,1155,1158>,<1259,1164,1135>,<1260,1214,1169>,<1261,1160,1139>,<1262,1263,1295>,<1262,1294,1297>,<1262,1295,1294>,<1263,1264,1296>,<1263,1296,1295>,<1264,160,466>,<1265,1297,1264>,<1266,1269,160>,<1266,1298,1301>,<1266,1301,1269>,<1267,1268,1300>,<1267,1298,1266>,<1267,1299,1298>,<1269,1268,471>,<1269,1300,1268>,<1269,1301,1300>,<1270,1273,159>,<1270,1302,1305>,<1270,1305,1273>,<1271,1272,1304>,<1271,1302,1270>,<1271,1303,1302>,<1273,1272,474>,<1273,1304,1272>,<1273,1305,1304>,<1274,1306,1309>,<1274,1309,1277>,<1275,1276,1308>,<1275,1307,1274>,<1275,1308,1307>,<1277,1308,1276>,<1277,1309,1308>,<1278,1281,701>,<1278,1310,1313>,<1278,1313,1281>,<1279,1310,1278>,<1279,1311,1310>,<1280,1312,1279>,<1281,1280,1003>,<1281,1313,1280>,<1282,1283,1315>,<1282,1314,1317>,<1282,1315,1314>,<1283,1284,1316>,<1283,1316,1315>,<1284,701,1008>,<1285,1317,1284>,<1286,1318,1321>,<1286,1321,1289>,<1287,1288,1320>,<1287,1319,1286>,<1287,1320,1319>,<1289,1320,1288>,<1289,1321,1320>,<1290,1293,700>,<1290,1322,1325>,<1290,1325,1293>,<1291,1322,1290>,<1291,1323,1322>,<1292,1324,1291>,<1293,1292,1015>,<1293,1325,1292>,<1295,1327,1326>,<1296,1327,1295>,<1296,1328,1327>,<1297,1265,1262>,<1297,1294,1326>,<1297,1296,1264>,<1297,1329,1328>,<1298,1299,1331>,<1298,1330,1301>,<1300,1299,1267>,<1300,1301,1333>,<1300,1332,1331>,<1302,1334,1305>,<1303,1335,1302>,<1304,1303,1271>,<1304,1305,1337>,<1304,1335,1303>,<1304,1336,1335>,<1307,1306,1274>,<1307,1339,1338>,<1308,1339,1307>,<1308,1340,1339>,<1309,1306,1338>,<1309,1340,1308>,<1309,1341,1340>,<1310,1311,1343>,<1310,1342,1313>,<1312,1311,1279>,<1312,1344,1343>,<1313,1312,1280>,<1313,1345,1312>,<1314,1346,1317>,<1315,1346,1314>,<1315,1347,1346>,<1316,1347,1315>,<1316,1348,1347>,<1317,1285,1282>,<1317,1316,1284>,<1317,1349,1348>,<1318,1350,1321>,<1319,1318,1286>,<1319,1350,1318>,<1319,1351,1350>,<1320,1351,1319>,<1320,1352,1351>,<1321,1352,1320>,<1321,1353,1352>,<1322,1354,1325>,<1323,1355,1322>,<1324,1323,1291>,<1324,1355,1323>,<1324,1356,1355>,<1325,1324,1292>,<1325,1357,1324>,<1326,1294,1295>,<1326,1329,1297>,<1327,1328,1329>,<1327,1329,1326>,<1328,1296,1297>,<1330,1331,1332>,<1330,1332,1333>,<1330,1333,1301>,<1331,1299,1300>,<1331,1330,1298>,<1333,1332,1300>,<1334,1337,1305>,<1335,1334,1302>,<1335,1336,1334>,<1336,1337,1334>,<1337,1336,1304>,<1338,1306,1307>,<1338,1341,1309>,<1339,1340,1341>,<1339,1341,1338>,<1342,1345,1313>,<1343,1311,1312>,<1343,1342,1310>,<1343,1344,1342>,<1344,1345,1342>,<1345,1344,1312>,<1346,1349,1317>,<1347,1348,1349>,<1347,1349,1346>,<1348,1316,1317>,<1350,1353,1321>,<1351,1352,1353>,<1351,1353,1350>,<1354,1355,1356>,<1354,1356,1357>,<1354,1357,1325>,<1355,1354,1322>,<1357,1356,1324>,<1358,1180,1124>,<1358,1373,1180>,<1358,1386,1385>,<1359,1382,1381>,<1359,1392,1362>,<1360,1190,1415>,<1360,1227,1389>,<1360,1362,1395>,<1360,1388,1391>,<1361,1384,1387>,<1361,1387,1362>,<1362,1358,1380>,<1362,1382,1359>,<1362,1383,1382>,<1362,1387,1386>,<1362,1391,1361>,<1363,1123,1397>,<1363,1178,1123>,<1363,1372,1178>,<1363,1402,1401>,<1364,1367,1399>,<1364,1398,1397>,<1364,1408,1411>,<1365,1367,1411>,<1365,1404,1407>,<1365,1413,1414>,<1366,1172,1401>,<1366,1359,1124>,<1367,1363,1396>,<1367,1366,1400>,<1367,1403,1402>,<1367,1407,1406>,<1368,1425,1199>,<1369,1191,1228>,<1369,1227,1191>,<1369,1361,1227>,<1370,1412,1416>,<1371,1128,1194>,<1371,1173,1128>,<1371,1194,1231>,<1373,1237,1179>,<1375,1379,1209>,<1376,1213,1240>,<1376,1240,1215>,<1380,1358,1124>,<1380,1383,1362>,<1381,1124,1359>,<1381,1382,1383>,<1383,1380,1381>,<1384,1361,1176>,<1385,1176,1358>,<1385,1386,1387>,<1385,1387,1384>,<1386,1358,1362>,<1389,1388,1360>,<1389,1390,1391>,<1389,1391,1388>,<1390,1389,1227>,<1391,1362,1360>,<1391,1390,1361>,<1392,1359,1190>,<1392,1395,1362>,<1393,1394,1395>,<1393,1395,1392>,<1394,1393,1190>,<1395,1394,1360>,<1396,1399,1367>,<1397,1123,1364>,<1397,1396,1363>,<1397,1398,1399>,<1399,1396,1397>,<1399,1398,1364>,<1400,1403,1367>,<1401,1172,1363>,<1401,1400,1366>,<1401,1402,1403>,<1401,1403,1400>,<1402,1363,1367>,<1404,1365,1226>,<1405,1406,1407>,<1405,1407,1404>,<1406,1366,1367>,<1406,1405,1226>,<1407,1367,1365>,<1408,1364,1189>,<1409,1410,1411>,<1410,1409,1189>,<1411,1367,1364>,<1411,1408,1409>,<1411,1410,1365>,<1412,1195,1227>,<1412,1227,1360>,<1413,1368,1422>,<1413,1421,1414>,<1413,1422,1421>,<1414,1226,1365>,<1414,1420,1199>,<1415,1142,1418>,<1415,1199,1142>,<1415,1412,1360>,<1415,1414,1199>,<1415,1417,1416>,<1415,1418,1417>,<1416,1412,1415>,<1416,1419,1370>,<1419,1418,1142>,<1420,1423,1199>,<1421,1420,1414>,<1425,1141,1429>,<1425,1368,1141>,<1426,1215,1143>,<1426,1376,1215>,<1427,1195,1370>,<1427,1370,1142>,<1427,1424,1195>,<1428,1427,1142>,<3,154,423>,<3,254,154>,<3,423,148>,<6,248,468>,<6,468,150>,<6,693,1005>,<6,1459,1463>,<7,155,477>,<7,477,264>,<7,698,1456>,<7,801,1014>,<7,1454,155>,<7,1455,1454>,<10,155,1434>,<148,8,242>,<148,423,1431>,<148,465,240>,<148,1430,8>,<148,1431,1430>,<150,468,246>,<150,1430,1461>,<150,1460,6>,<154,10,1434>,<154,475,260>,<154,1434,1435>,<155,1454,1458>,<155,1458,1434>,<240,3,148>,<242,465,148>,<246,8,150>,<254,475,154>,<260,10,154>,<266,155,10>,<266,477,155>,<423,960,1439>,<423,1439,1438>,<558,691,779>,<558,693,1433>,<559,698,803>,<691,555,777>,<691,960,555>,<691,1002,779>,<693,558,783>,<693,1463,1462>,<697,791,555>,<697,960,1436>,<697,1012,791>,<697,1436,1437>,<697,1437,559>,<698,1014,803>,<698,1437,1457>,<698,1457,1456>,<777,1002,691>,<783,1005,693>,<797,697,559>,<797,1012,697>,<960,697,555>,<1005,785,6>,<1014,698,7>,<1430,150,8>,<1430,1433,1462>,<1430,1442,1445>,<1431,423,1438>,<1431,1432,1444>,<1431,1441,1440>,<1431,1443,1430>,<1432,960,691>,<1432,1440,1439>,<1433,691,558>,<1433,1432,691>,<1433,1445,1444>,<1434,1437,1448>,<1434,1446,1435>,<1434,1447,1446>,<1434,1458,1457>,<1435,423,154>,<1435,1436,1452>,<1435,1446,1449>,<1435,1450,423>,<1435,1451,1450>,<1436,960,1453>,<1436,1453,1452>,<1437,698,559>,<1437,1436,1449>,<1438,1439,1440>,<1438,1441,1431>,<1439,960,1432>,<1440,1432,1431>,<1440,1441,1438>,<1443,1442,1430>,<1443,1444,1445>,<1443,1445,1442>,<1444,1432,1433>,<1444,1443,1431>,<1445,1433,1430>,<1447,1448,1446>,<1448,1447,1434>,<1448,1449,1446>,<1449,1436,1435>,<1449,1448,1437>,<1450,1453,423>,<1451,1452,1450>,<1452,1451,1435>,<1452,1453,1450>,<1453,960,423>,<1455,1456,1457>,<1455,1457,1458>,<1455,1458,1454>,<1456,1455,7>,<1457,1437,1434>,<1459,1460,1461>,<1459,1461,1462>,<1459,1462,1463>,<1460,1459,6>,<1461,1460,150>,<1462,1433,693>,<1462,1461,1430>,<1463,693,6>,<0,162,435>,<0,210,453>,<0,435,180>,<1,188,438>,<2,161,455>,<2,455,220>,<2,690,757>,<2,757,992>,<2,992,161>,<3,240,464>,<3,464,144>,<4,282,151>,<5,204,146>,<9,169,276>,<9,707,771>,<9,708,813>,<9,813,169>,<11,153,457>,<11,159,474>,<11,268,478>,<11,457,224>,<11,474,258>,<11,478,159>,<12,149,437>,<12,160,471>,<12,244,466>,<12,437,184>,<12,466,160>,<12,471,252>,<13,147,476>,<13,222,161>,<13,476,262>,<13,799,1013>,<13,1013,147>,<14,144,464>,<14,164,182>,<14,182,162>,<14,216,166>,<14,256,472>,<14,464,238>,<15,143,186>,<15,163,1006>,<15,250,469>,<15,469,163>,<15,723,143>,<15,1006,787>,<16,176,492>,<16,200,444>,<16,444,173>,<16,492,294>,<17,208,448>,<17,448,174>,<17,711,985>,<17,985,745>,<18,175,488>,<18,488,286>,<18,823,1025>,<18,1025,712>,<20,175,230>,<21,178,434>,<21,298,497>,<21,434,177>,<22,179,495>,<22,180,179>,<22,300,494>,<22,495,300>,<23,182,436>,<23,436,181>,<24,181,436>,<24,183,497>,<24,184,183>,<24,436,184>,<24,497,304>,<25,185,498>,<25,186,438>,<25,498,306>,<26,188,439>,<26,308,498>,<26,439,187>,<26,498,185>,<27,187,439>,<27,189,500>,<27,190,189>,<27,439,190>,<27,500,310>,<28,192,441>,<28,312,500>,<28,441,191>,<29,194,442>,<29,199,445>,<29,314,199>,<29,442,193>,<30,196,195>,<31,197,318>,<31,198,444>,<31,444,197>,<32,199,505>,<32,320,197>,<32,505,320>,<33,202,446>,<33,207,449>,<33,322,207>,<33,449,202>,<34,203,324>,<34,324,506>,<34,506,201>,<35,203,447>,<35,205,508>,<35,206,205>,<35,326,507>,<35,507,203>,<35,508,326>,<36,207,509>,<36,208,207>,<36,328,508>,<36,508,205>,<36,509,328>,<37,209,510>,<37,210,450>,<37,330,513>,<37,510,330>,<37,513,215>,<38,211,511>,<38,212,211>,<38,511,332>,<39,214,452>,<39,334,511>,<39,452,213>,<40,213,452>,<40,336,213>,<41,218,454>,<41,338,517>,<41,454,217>,<41,517,223>,<42,219,515>,<42,220,219>,<42,515,340>,<43,222,456>,<43,342,219>,<43,456,221>,<44,221,456>,<44,223,517>,<44,344,221>,<44,456,224>,<45,225,346>,<45,226,458>,<45,458,225>,<46,228,459>,<46,459,227>,<47,229,520>,<47,350,519>,<47,519,227>,<48,231,352>,<48,232,461>,<48,352,523>,<49,234,462>,<49,462,233>,<50,235,523>,<50,356,522>,<51,238,237>,<52,240,465>,<52,360,524>,<52,465,239>,<52,524,237>,<53,239,465>,<53,465,242>,<54,243,527>,<54,244,467>,<54,364,526>,<54,467,243>,<54,527,364>,<55,246,468>,<55,366,531>,<55,468,245>,<56,245,468>,<56,247,529>,<56,248,247>,<56,468,248>,<56,529,368>,<57,250,470>,<57,470,249>,<58,249,470>,<58,251,531>,<58,252,251>,<58,470,252>,<58,531,372>,<59,253,532>,<59,259,475>,<59,374,259>,<59,475,254>,<59,532,374>,<60,256,473>,<61,257,534>,<61,378,533>,<61,533,255>,<61,534,378>,<62,260,475>,<62,475,259>,<63,261,382>,<63,262,261>,<64,264,477>,<64,384,536>,<64,477,263>,<64,536,261>,<65,263,477>,<65,265,538>,<65,386,263>,<65,477,266>,<66,268,479>,<66,388,538>,<66,479,267>,<66,538,265>,<67,270,480>,<67,480,269>,<68,269,480>,<68,271,541>,<68,272,481>,<68,392,269>,<68,481,271>,<69,273,542>,<69,274,273>,<69,394,541>,<69,541,271>,<69,542,394>,<70,275,396>,<70,276,483>,<70,279,485>,<71,278,484>,<71,398,275>,<71,484,277>,<72,279,545>,<72,400,544>,<72,544,277>,<72,545,400>,<73,281,546>,<73,402,287>,<74,281,486>,<74,283,404>,<74,284,487>,<74,487,283>,<75,285,548>,<75,286,285>,<75,406,547>,<75,547,283>,<75,548,406>,<76,287,549>,<76,288,489>,<76,408,548>,<76,489,287>,<78,289,490>,<78,291,412>,<78,292,491>,<78,490,292>,<79,293,414>,<79,294,293>,<79,414,551>,<79,551,291>,<80,296,493>,<80,493,295>,<81,297,417>,<81,298,494>,<81,417,303>,<81,494,297>,<82,299,417>,<82,300,299>,<82,417,297>,<83,301,417>,<83,302,496>,<83,417,299>,<84,301,496>,<84,303,417>,<84,304,303>,<84,417,301>,<84,496,304>,<85,305,418>,<85,311,501>,<85,418,311>,<85,501,306>,<86,307,418>,<86,308,499>,<86,418,305>,<86,499,307>,<87,307,499>,<87,309,418>,<87,499,310>,<88,311,418>,<88,312,501>,<88,501,311>,<89,313,419>,<89,314,502>,<89,319,505>,<89,502,313>,<89,505,314>,<90,313,502>,<90,315,419>,<90,419,313>,<91,315,503>,<91,317,419>,<91,318,504>,<91,419,315>,<91,503,318>,<91,504,317>,<92,319,419>,<92,320,319>,<92,419,317>,<93,322,506>,<93,327,509>,<93,506,321>,<93,509,322>,<94,321,506>,<94,323,420>,<94,420,321>,<95,323,507>,<95,325,420>,<95,326,508>,<95,420,323>,<95,508,325>,<96,327,420>,<96,328,327>,<96,420,325>,<97,329,421>,<97,330,510>,<97,421,335>,<98,331,421>,<98,421,329>,<99,333,421>,<99,334,512>,<99,512,333>,<100,333,512>,<100,335,421>,<100,421,333>,<101,337,422>,<101,338,514>,<101,422,343>,<101,514,337>,<102,339,422>,<102,340,339>,<103,341,422>,<103,342,516>,<103,422,339>,<103,516,341>,<104,341,516>,<104,343,422>,<104,344,343>,<104,422,341>,<104,516,344>,<105,345,424>,<105,346,518>,<105,424,349>,<105,518,345>,<106,347,424>,<106,348,519>,<106,519,347>,<107,347,519>,<107,349,424>,<107,424,347>,<107,519,350>,<108,351,425>,<108,352,521>,<108,521,351>,<109,353,425>,<109,354,522>,<109,425,351>,<109,522,353>,<110,355,425>,<110,425,353>,<111,357,426>,<111,358,357>,<111,426,363>,<112,359,426>,<112,360,525>,<112,525,359>,<113,359,525>,<113,361,426>,<113,362,361>,<113,426,359>,<113,525,362>,<114,363,426>,<114,364,527>,<114,426,361>,<114,527,363>,<115,365,427>,<115,366,528>,<115,528,365>,<116,365,528>,<116,367,427>,<116,427,365>,<116,528,368>,<117,369,427>,<117,370,530>,<117,427,367>,<117,530,369>,<118,369,530>,<118,371,427>,<118,530,372>,<119,373,428>,<119,379,535>,<119,535,374>,<120,375,428>,<120,376,533>,<120,428,373>,<121,377,428>,<121,378,377>,<121,428,375>,<122,379,428>,<122,380,535>,<122,535,379>,<123,381,429>,<123,382,381>,<124,383,429>,<124,384,537>,<124,429,381>,<124,537,383>,<125,383,537>,<125,385,429>,<125,429,383>,<125,537,386>,<126,387,429>,<126,388,539>,<126,429,385>,<126,539,387>,<127,389,430>,<127,390,540>,<127,430,393>,<127,540,389>,<128,389,540>,<128,391,430>,<128,540,392>,<129,393,430>,<129,394,542>,<129,430,391>,<130,395,431>,<130,396,543>,<130,399,545>,<130,431,399>,<131,395,543>,<131,397,431>,<131,543,398>,<132,399,431>,<132,400,545>,<132,431,397>,<132,545,399>,<133,401,432>,<133,402,546>,<133,432,407>,<134,404,547>,<134,547,403>,<135,405,432>,<136,405,548>,<136,407,432>,<136,408,549>,<136,548,408>,<136,549,407>,<137,409,433>,<137,410,550>,<137,433,415>,<137,550,409>,<138,409,550>,<138,411,433>,<138,412,551>,<138,550,412>,<138,551,411>,<139,413,433>,<139,433,411>,<140,415,433>,<140,416,553>,<140,433,413>,<140,553,415>,<141,0,180>,<141,442,194>,<142,0,292>,<142,5,212>,<142,210,0>,<142,292,490>,<142,450,210>,<142,490,290>,<143,438,186>,<143,975,1>,<144,472,3>,<145,1,284>,<145,4,190>,<145,190,439>,<145,282,4>,<145,439,188>,<145,486,282>,<146,2,220>,<146,218,5>,<146,446,202>,<146,454,218>,<149,4,178>,<149,440,190>,<151,196,4>,<151,443,196>,<151,489,288>,<152,5,290>,<152,19,206>,<152,204,5>,<152,447,204>,<153,5,218>,<153,451,212>,<156,1,821>,<156,18,286>,<156,487,284>,<156,821,1024>,<156,823,18>,<156,1024,823>,<157,2,202>,<157,17,745>,<157,449,208>,<157,739,2>,<157,745,986>,<157,986,739>,<158,0,194>,<158,292,0>,<158,445,200>,<158,491,292>,<161,759,13>,<161,992,759>,<162,216,14>,<162,453,216>,<164,12,184>,<164,14,238>,<164,184,436>,<164,244,12>,<164,436,182>,<164,467,244>,<165,15,186>,<165,186,441>,<165,250,15>,<165,470,250>,<166,11,258>,<166,256,14>,<166,473,256>,<167,11,224>,<167,224,456>,<167,268,11>,<167,479,268>,<168,9,234>,<168,16,272>,<168,232,16>,<168,461,232>,<168,480,270>,<169,17,278>,<169,483,276>,<169,815,17>,<169,1020,815>,<170,9,228>,<170,18,763>,<170,458,226>,<170,763,995>,<170,995,765>,<171,19,236>,<171,485,280>,<172,9,270>,<172,20,230>,<172,230,459>,<172,274,20>,<172,459,228>,<172,482,274>,<173,481,272>,<174,484,278>,<175,18,226>,<175,460,230>,<176,16,232>,<176,19,296>,<176,232,463>,<176,463,236>,<177,434,22>,<177,494,298>,<178,4,141>,<178,141,434>,<178,437,149>,<179,23,302>,<179,182,23>,<179,435,182>,<180,434,141>,<180,435,179>,<181,24,304>,<181,496,302>,<182,435,162>,<183,178,21>,<183,437,178>,<184,437,183>,<185,188,26>,<185,438,188>,<187,27,310>,<187,310,499>,<188,1,145>,<189,192,28>,<189,440,192>,<190,4,149>,<190,440,189>,<191,25,306>,<191,441,25>,<191,501,312>,<192,12,165>,<192,165,441>,<192,440,12>,<193,30,316>,<193,316,502>,<193,442,196>,<193,502,314>,<194,0,141>,<194,445,158>,<195,31,318>,<195,443,31>,<196,30,193>,<196,141,4>,<196,442,141>,<196,443,195>,<197,200,32>,<197,444,200>,<197,504,318>,<198,20,173>,<198,151,20>,<198,173,444>,<198,443,151>,<199,32,200>,<199,200,445>,<200,16,158>,<201,446,204>,<201,506,322>,<202,2,146>,<202,449,157>,<203,34,204>,<203,507,324>,<204,34,201>,<204,446,146>,<204,447,203>,<205,448,208>,<206,19,174>,<206,174,448>,<206,447,152>,<206,448,205>,<208,17,157>,<208,36,205>,<208,449,207>,<209,38,332>,<209,450,38>,<210,37,215>,<211,214,39>,<211,451,214>,<212,5,153>,<212,450,142>,<212,451,211>,<213,512,334>,<214,11,166>,<214,166,452>,<214,451,11>,<215,40,216>,<215,453,210>,<215,513,336>,<216,452,166>,<216,453,215>,<217,42,340>,<217,340,514>,<217,454,42>,<218,41,223>,<218,457,153>,<219,222,43>,<219,455,222>,<220,454,146>,<220,455,219>,<221,516,342>,<222,13,167>,<222,167,456>,<222,455,161>,<223,44,224>,<223,224,457>,<223,457,218>,<225,46,348>,<225,458,46>,<225,518,346>,<226,18,170>,<226,460,175>,<227,230,47>,<227,459,230>,<228,9,172>,<228,458,170>,<229,45,346>,<229,47,230>,<229,460,45>,<230,460,229>,<231,49,354>,<231,354,521>,<231,461,49>,<231,521,352>,<233,236,50>,<233,462,236>,<234,9,171>,<234,171,462>,<234,461,168>,<235,50,236>,<235,232,48>,<235,463,232>,<236,19,176>,<236,462,171>,<236,463,235>,<237,240,52>,<237,464,240>,<237,524,358>,<238,464,237>,<238,467,164>,<239,53,362>,<239,362,525>,<239,525,360>,<241,53,242>,<241,242,466>,<241,244,54>,<241,466,244>,<243,51,358>,<243,358,527>,<243,467,51>,<245,56,368>,<245,528,366>,<247,57,370>,<247,250,57>,<247,469,250>,<248,469,247>,<249,58,372>,<249,372,530>,<251,246,55>,<251,471,246>,<252,165,12>,<252,470,165>,<252,471,251>,<253,59,254>,<253,60,376>,<253,254,472>,<253,472,256>,<255,473,61>,<256,60,253>,<257,61,258>,<257,62,380>,<257,258,474>,<257,260,62>,<257,380,534>,<257,474,260>,<258,473,166>,<261,264,64>,<261,476,264>,<261,536,382>,<262,167,13>,<262,476,261>,<262,479,167>,<263,537,384>,<265,65,266>,<265,266,478>,<265,478,268>,<267,63,382>,<267,382,539>,<267,479,63>,<268,66,265>,<270,9,168>,<270,482,172>,<271,481,274>,<272,16,173>,<272,480,168>,<273,67,390>,<273,390,542>,<273,482,67>,<274,69,271>,<274,173,20>,<274,481,173>,<274,482,273>,<275,483,71>,<275,543,396>,<276,171,9>,<276,485,171>,<277,484,280>,<277,544,398>,<278,17,174>,<278,483,169>,<279,70,396>,<279,72,280>,<279,396,545>,<280,19,171>,<280,72,277>,<280,174,19>,<280,484,174>,<280,485,279>,<281,73,282>,<281,74,404>,<282,486,281>,<282,489,151>,<283,286,75>,<283,487,286>,<283,547,404>,<284,1,156>,<284,486,145>,<285,288,76>,<285,488,288>,<286,487,156>,<286,488,285>,<287,282,73>,<287,489,282>,<288,20,151>,<288,175,20>,<288,488,175>,<289,77,290>,<289,78,412>,<289,412,550>,<290,5,142>,<290,490,289>,<290,493,152>,<291,294,79>,<291,491,294>,<291,551,412>,<293,80,416>,<293,492,80>,<293,552,414>,<294,158,16>,<294,491,158>,<294,492,293>,<295,77,410>,<295,290,77>,<295,410,553>,<295,493,290>,<295,553,416>,<296,19,152>,<296,152,493>,<296,492,176>,<297,494,82>,<298,21,177>,<299,302,83>,<299,495,302>,<300,495,299>,<302,23,181>,<302,495,179>,<303,298,81>,<303,497,298>,<304,496,181>,<304,497,303>,<305,85,306>,<305,306,498>,<305,308,86>,<305,498,308>,<306,501,191>,<308,26,187>,<308,187,499>,<309,87,310>,<309,310,500>,<309,312,88>,<309,500,312>,<312,28,191>,<314,29,193>,<314,505,199>,<315,90,316>,<315,316,503>,<316,30,195>,<316,195,503>,<317,320,92>,<317,504,320>,<318,503,195>,<320,504,197>,<320,505,319>,<322,33,201>,<322,509,207>,<323,94,324>,<323,324,507>,<325,328,96>,<325,508,328>,<327,93,321>,<327,321,420>,<328,509,327>,<329,510,98>,<330,97,335>,<331,98,332>,<331,332,511>,<331,334,99>,<331,511,334>,<332,510,209>,<334,39,213>,<335,100,336>,<335,336,513>,<335,513,330>,<336,40,215>,<336,512,213>,<337,514,102>,<338,41,217>,<338,217,514>,<339,342,103>,<339,515,342>,<340,515,339>,<342,43,221>,<342,515,219>,<343,338,101>,<343,517,338>,<344,516,221>,<344,517,343>,<345,518,106>,<346,520,229>,<348,46,227>,<348,227,519>,<348,518,225>,<349,107,350>,<349,346,105>,<349,350,520>,<349,520,346>,<351,521,109>,<353,522,110>,<354,49,233>,<354,233,522>,<355,110,356>,<355,352,108>,<355,356,523>,<355,523,352>,<357,360,112>,<357,524,360>,<358,51,237>,<358,524,357>,<360,52,239>,<361,526,364>,<362,53,241>,<362,241,526>,<362,526,361>,<363,527,111>,<364,114,361>,<366,55,245>,<367,116,368>,<367,368,529>,<367,370,117>,<367,529,370>,<368,528,245>,<370,57,249>,<370,249,530>,<370,529,247>,<371,118,372>,<371,366,115>,<371,372,531>,<371,531,366>,<373,119,374>,<373,532,376>,<374,532,373>,<374,535,259>,<375,533,121>,<376,60,255>,<376,120,373>,<376,255,533>,<376,532,253>,<377,380,122>,<377,534,380>,<378,534,377>,<380,62,259>,<380,259,535>,<381,384,124>,<381,536,384>,<382,536,381>,<384,64,263>,<385,125,386>,<385,386,538>,<385,388,126>,<385,538,388>,<386,537,263>,<387,539,123>,<388,66,267>,<388,267,539>,<390,67,269>,<390,269,540>,<391,128,392>,<391,392,541>,<391,394,129>,<391,541,394>,<392,540,269>,<393,542,127>,<397,131,398>,<397,398,544>,<397,400,132>,<397,544,400>,<398,71,277>,<398,543,275>,<401,134,403>,<401,403,432>,<401,546,134>,<402,549,287>,<403,406,135>,<403,547,406>,<404,546,281>,<405,135,406>,<405,406,548>,<407,402,133>,<407,549,402>,<410,77,289>,<410,289,550>,<411,551,414>,<413,139,414>,<413,414,552>,<413,552,140>,<414,139,411>,<415,410,137>,<415,553,410>,<416,80,295>,<416,552,293>,<418,307,87>,<418,309,88>,<419,319,89>,<421,331,99>,<422,337,102>,<424,345,106>,<425,355,108>,<426,357,112>,<427,369,118>,<427,371,115>,<428,377,122>,<428,379,119>,<429,387,123>,<430,389,128>,<431,395,131>,<432,403,135>,<432,405,136>,<433,409,138>,<434,180,22>,<438,143,1>,<438,185,25>,<440,149,12>,<441,186,25>,<443,198,31>,<445,194,29>,<446,201,33>,<447,206,35>,<450,209,37>,<450,212,38>,<451,153,11>,<452,216,40>,<453,162,0>,<454,220,42>,<458,228,46>,<460,226,45>,<461,231,48>,<461,234,49>,<467,238,51>,<472,144,14>,<472,254,3>,<473,255,60>,<473,258,61>,<479,262,63>,<480,272,68>,<482,270,67>,<483,275,70>,<483,278,71>,<485,276,70>,<486,284,74>,<491,291,78>,<492,296,80>,<494,177,22>,<494,300,82>,<496,301,83>,<497,183,21>,<500,189,28>,<502,316,90>,<506,324,94>,<507,326,95>,<510,329,97>,<510,332,98>,<511,211,39>,<512,336,100>,<514,340,102>,<517,344,44>,<518,348,106>,<520,350,47>,<521,354,109>,<522,233,50>,<522,356,110>,<523,235,48>,<523,356,50>,<526,241,54>,<527,358,111>,<531,251,55>,<533,375,120>,<533,378,121>,<538,386,65>,<539,382,123>,<541,392,68>,<542,390,127>,<542,393,129>,<543,395,130>,<545,396,130>,<546,401,133>,<546,402,73>,<546,404,134>,<548,285,76>,<549,408,76>,<552,416,140>,<554,702,990>,<554,747,687>,<555,688,1001>,<555,791,1009>,<555,1001,777>,<555,1009,688>,<556,686,733>,<556,733,694>,<560,696,988>,<560,700,1015>,<560,795,1011>,<560,988,751>,<560,1011,700>,<560,1015,805>,<561,692,977>,<561,701,1003>,<561,789,1008>,<561,977,729>,<561,1003,781>,<561,1008,701>,<562,688,1009>,<562,753,702>,<562,775,1001>,<562,793,705>,<562,1001,688>,<563,710,981>,<563,831,1029>,<563,981,737>,<563,1029,713>,<565,710,811>,<565,811,709>,<566,714,971>,<566,971,715>,<567,717,971>,<567,837,1032>,<567,971,714>,<567,1032,716>,<568,719,716>,<569,721,973>,<569,841,1034>,<569,973,718>,<570,723,978>,<571,722,1035>,<571,724,976>,<571,1035,845>,<572,727,976>,<572,976,724>,<573,726,1037>,<573,728,978>,<573,978,729>,<574,731,982>,<576,734,981>,<576,735,980>,<577,857,1042>,<577,1042,736>,<578,738,983>,<578,739,986>,<578,986,744>,<580,743,984>,<580,863,1045>,<581,865,1046>,<581,1046,744>,<582,746,987>,<582,752,1050>,<582,867,1047>,<582,1050,867>,<583,749,987>,<583,869,1048>,<583,987,746>,<584,750,989>,<584,751,748>,<584,989,751>,<585,753,989>,<587,757,991>,<587,877,1052>,<587,1052,756>,<588,758,993>,<589,761,993>,<589,881,1054>,<589,993,758>,<590,762,995>,<590,763,766>,<590,995,763>,<591,765,995>,<591,995,762>,<592,764,1056>,<592,767,764>,<592,887,1057>,<592,1056,887>,<593,768,998>,<593,769,772>,<593,772,1060>,<594,770,999>,<594,771,998>,<595,893,1060>,<596,775,1004>,<596,1004,780>,<597,774,1061>,<597,776,1002>,<597,1002,777>,<597,1061,897>,<598,779,1002>,<598,1002,776>,<599,780,1004>,<599,1004,781>,<600,782,1005>,<600,788,1068>,<600,1005,783>,<601,785,1005>,<601,905,1066>,<601,1005,782>,<601,1066,784>,<602,786,1007>,<603,789,1007>,<603,909,1068>,<603,1007,786>,<603,1068,788>,<604,791,1012>,<604,911,1069>,<604,1012,796>,<604,1069,790>,<605,792,1010>,<606,795,1010>,<606,915,1071>,<606,1010,792>,<607,796,1012>,<607,1012,797>,<608,799,1016>,<609,798,1073>,<609,800,1014>,<609,1014,801>,<609,1073,921>,<610,803,1014>,<610,923,1075>,<610,1014,800>,<611,802,1075>,<611,804,1016>,<611,1016,805>,<611,1075,925>,<612,806,1017>,<612,807,1019>,<613,809,1017>,<613,929,1078>,<614,931,1079>,<615,812,1020>,<615,813,1022>,<616,815,1020>,<616,1020,812>,<617,937,1082>,<617,1082,816>,<618,819,824>,<618,939,1083>,<619,820,1024>,<619,821,1023>,<619,1024,821>,<620,820,1084>,<620,1084,943>,<621,825,1025>,<621,945,1086>,<621,1025,822>,<623,828,1028>,<623,829,1027>,<623,1027,826>,<624,828,1088>,<624,1088,951>,<625,832,1030>,<625,833,1029>,<626,834,1031>,<626,840,954>,<626,954,834>,<626,1031,835>,<627,837,1031>,<627,1031,834>,<628,836,954>,<628,838,1033>,<628,954,838>,<629,841,1033>,<629,1033,838>,<630,843,1038>,<630,848,955>,<630,955,842>,<630,1038,848>,<631,844,1036>,<632,844,955>,<632,847,1036>,<632,1036,844>,<633,846,955>,<633,848,1038>,<633,849,846>,<633,1038,849>,<634,851,1042>,<634,856,956>,<634,1042,856>,<635,850,956>,<635,853,1039>,<635,956,852>,<636,854,1041>,<636,855,1040>,<636,1040,852>,<636,1041,855>,<638,858,1043>,<638,859,1046>,<638,1043,859>,<638,1046,864>,<639,858,957>,<639,861,1043>,<639,957,860>,<639,1043,858>,<640,860,957>,<640,863,1044>,<641,862,957>,<641,957,864>,<642,866,1047>,<642,872,958>,<642,958,866>,<643,866,958>,<643,869,1047>,<643,958,868>,<643,1047,866>,<644,868,958>,<644,870,1049>,<644,871,868>,<644,1049,871>,<645,870,958>,<645,873,1049>,<645,958,872>,<647,874,959>,<647,877,1051>,<648,876,959>,<648,878,1053>,<648,959,878>,<648,1053,879>,<649,881,1053>,<649,1053,878>,<650,882,1055>,<650,883,886>,<650,886,961>,<650,1055,883>,<651,885,1055>,<651,1055,882>,<652,884,961>,<652,887,1056>,<652,961,886>,<652,1056,884>,<653,889,892>,<653,892,962>,<654,890,1059>,<654,891,1058>,<654,1059,891>,<655,890,962>,<655,893,1059>,<655,962,892>,<655,1059,890>,<656,895,1064>,<656,1064,900>,<657,894,963>,<657,896,1062>,<657,897,894>,<657,1062,897>,<658,899,1062>,<658,1062,896>,<659,900,1064>,<659,1064,901>,<660,902,1065>,<660,908,964>,<660,1065,903>,<661,902,964>,<661,905,1065>,<661,964,904>,<661,1065,902>,<662,906,1067>,<663,906,964>,<663,909,1067>,<663,1067,906>,<664,911,1072>,<664,916,965>,<664,1072,916>,<665,910,965>,<665,912,1070>,<665,965,912>,<666,915,1070>,<666,1070,912>,<667,914,965>,<667,916,1072>,<667,917,914>,<667,1072,917>,<668,919,1076>,<668,924,966>,<669,918,966>,<669,920,1074>,<669,966,920>,<669,1074,921>,<670,923,1074>,<670,1074,920>,<672,926,1077>,<672,927,1079>,<672,1079,930>,<673,926,967>,<673,929,1077>,<673,1077,926>,<674,928,967>,<674,930,1079>,<674,967,930>,<675,932,1080>,<675,933,1082>,<675,936,968>,<676,935,1080>,<676,1080,932>,<677,934,968>,<677,968,936>,<678,944,969>,<678,969,938>,<679,940,1084>,<679,941,1083>,<679,1083,938>,<679,1084,941>,<680,940,969>,<680,969,942>,<681,945,1085>,<681,1085,942>,<682,952,970>,<682,970,946>,<683,946,970>,<683,948,1088>,<683,949,1087>,<683,1087,946>,<683,1088,949>,<684,948,970>,<684,970,950>,<685,952,1090>,<685,953,1089>,<685,1089,950>,<685,1090,953>,<686,554,731>,<686,971,717>,<686,979,733>,<687,557,827>,<687,829,554>,<687,987,749>,<687,1027,829>,<689,556,819>,<689,976,727>,<690,557,755>,<690,983,741>,<690,991,757>,<692,556,727>,<692,974,715>,<694,1026,819>,<695,557,741>,<695,1030,827>,<696,557,749>,<696,994,755>,<699,554,829>,<699,563,737>,<699,829,1028>,<699,982,731>,<702,719,562>,<702,972,719>,<703,561,781>,<703,721,561>,<703,781,1004>,<703,973,721>,<703,1004,775>,<704,15,787>,<704,723,15>,<704,787,1007>,<704,978,723>,<704,1007,789>,<705,753,562>,<705,989,753>,<705,1010,795>,<706,560,805>,<706,761,560>,<706,993,761>,<707,563,769>,<707,769,998>,<707,998,771>,<707,1017,809>,<708,564,817>,<708,999,773>,<708,1022,813>,<709,9,765>,<709,767,565>,<709,996,767>,<709,1019,807>,<710,563,809>,<710,1018,811>,<711,17,815>,<711,564,743>,<711,815,1021>,<711,1021,817>,<712,565,767>,<712,763,18>,<712,997,763>,<712,1025,825>,<713,564,773>,<713,769,563>,<713,1000,769>,<713,1029,833>,<714,1031,567>,<715,556,692>,<715,686,556>,<715,971,686>,<715,974,720>,<716,717,567>,<716,839,568>,<716,972,717>,<716,1032,839>,<717,554,686>,<717,972,554>,<718,568,839>,<718,841,569>,<718,973,568>,<718,1033,841>,<719,703,562>,<719,972,716>,<719,973,703>,<720,566,715>,<720,721,569>,<720,974,721>,<720,1034,566>,<721,974,561>,<722,571,725>,<722,975,723>,<723,570,722>,<723,975,143>,<724,847,572>,<724,1036,847>,<725,689,1>,<725,975,722>,<725,976,689>,<726,573,729>,<726,727,572>,<726,729,977>,<726,977,727>,<727,556,689>,<727,977,692>,<728,573,849>,<728,843,570>,<728,1038,843>,<729,704,561>,<729,978,704>,<730,574,851>,<730,575,733>,<730,853,575>,<730,979,574>,<730,1039,853>,<731,554,699>,<731,979,686>,<732,855,576>,<732,980,733>,<732,1040,855>,<733,575,732>,<733,979,730>,<733,980,694>,<734,577,737>,<734,857,577>,<734,1041,857>,<735,565,694>,<735,694,980>,<735,710,565>,<735,981,710>,<736,737,577>,<736,851,574>,<736,982,737>,<736,1042,851>,<737,981,734>,<737,982,699>,<738,579,741>,<738,1043,579>,<739,690,2>,<739,983,690>,<740,984,741>,<740,1044,580>,<741,557,690>,<741,579,740>,<741,983,738>,<741,984,695>,<742,581,745>,<742,985,580>,<742,1045,581>,<743,564,695>,<743,695,984>,<743,985,711>,<744,745,581>,<744,859,578>,<744,986,745>,<744,1046,859>,<745,985,742>,<746,869,583>,<746,1047,869>,<747,987,687>,<747,990,752>,<748,988,749>,<748,1048,584>,<749,557,687>,<749,583,748>,<749,988,696>,<750,873,585>,<750,1049,873>,<751,705,560>,<751,988,748>,<751,989,705>,<752,582,747>,<752,990,753>,<753,585,752>,<753,990,702>,<754,877,587>,<754,991,586>,<754,1051,877>,<755,557,696>,<755,991,690>,<755,994,760>,<756,588,759>,<756,879,588>,<756,992,757>,<756,1052,879>,<757,587,756>,<758,881,589>,<758,1053,881>,<759,706,13>,<759,992,756>,<759,993,706>,<760,586,755>,<760,761,589>,<760,994,761>,<760,1054,586>,<761,994,560>,<762,1055,885>,<763,997,766>,<764,996,591>,<765,9,170>,<765,996,709>,<766,883,590>,<766,997,767>,<766,1057,883>,<767,592,766>,<767,996,764>,<767,997,712>,<768,891,594>,<768,1058,891>,<769,1000,772>,<770,595,773>,<770,1059,595>,<771,708,9>,<771,999,708>,<772,1000,773>,<773,564,708>,<773,595,772>,<773,999,770>,<773,1000,713>,<774,597,777>,<774,775,596>,<774,777,1001>,<774,1001,775>,<775,562,703>,<776,597,897>,<776,899,598>,<776,1062,899>,<778,599,781>,<778,779,598>,<778,1003,779>,<778,1063,599>,<780,895,596>,<780,1064,895>,<781,1003,778>,<782,600,903>,<782,905,601>,<782,1065,905>,<784,602,787>,<784,1006,785>,<784,1066,907>,<785,601,784>,<786,909,603>,<786,1067,909>,<787,1006,784>,<788,600,783>,<788,783,1008>,<788,789,603>,<788,1008,789>,<789,561,704>,<790,605,793>,<790,791,604>,<790,913,605>,<790,1009,791>,<790,1069,913>,<792,1070,606>,<793,1009,790>,<793,1010,705>,<794,607,797>,<794,797,1011>,<794,917,607>,<794,1011,795>,<794,1071,917>,<795,560,705>,<795,606,794>,<796,911,604>,<796,1072,911>,<798,609,801>,<798,1013,799>,<799,13,706>,<799,608,798>,<799,706,1016>,<800,923,610>,<800,1074,923>,<801,1013,798>,<802,611,805>,<802,803,610>,<802,1015,803>,<804,919,608>,<804,1076,919>,<805,1015,802>,<805,1016,706>,<806,929,613>,<806,1077,929>,<807,9,709>,<807,707,9>,<807,1017,707>,<808,614,811>,<808,1018,613>,<808,1078,614>,<809,563,707>,<809,1018,710>,<810,927,612>,<810,1019,811>,<810,1079,927>,<811,614,810>,<811,1018,808>,<811,1019,709>,<812,935,616>,<812,1080,935>,<813,1020,169>,<814,617,817>,<814,815,616>,<814,1021,815>,<814,1081,617>,<816,933,615>,<816,1022,817>,<816,1082,933>,<817,564,711>,<817,617,816>,<817,1021,814>,<817,1022,708>,<818,941,619>,<818,1023,819>,<818,1083,941>,<819,556,694>,<819,618,818>,<819,1023,689>,<819,1026,824>,<820,620,823>,<820,823,1024>,<821,1,689>,<821,689,1023>,<822,823,620>,<822,1025,823>,<822,1085,621>,<824,939,618>,<824,1026,621>,<824,1086,939>,<825,565,712>,<825,694,565>,<825,1026,694>,<826,949,623>,<826,1027,827>,<826,1087,949>,<827,557,695>,<827,622,826>,<827,1027,687>,<827,1030,832>,<828,624,831>,<828,831,1028>,<830,1029,831>,<830,1089,953>,<831,563,699>,<831,624,830>,<831,699,1028>,<832,622,827>,<832,947,622>,<832,1090,947>,<833,564,713>,<833,695,564>,<833,1030,695>,<834,954,627>,<835,714,566>,<835,1031,714>,<836,628,839>,<836,837,627>,<836,839,1032>,<836,1032,837>,<838,954,629>,<839,1033,718>,<840,626,835>,<840,835,1034>,<840,841,629>,<840,1034,841>,<842,631,845>,<842,843,630>,<842,955,631>,<842,1035,843>,<843,722,570>,<843,1035,722>,<845,724,571>,<845,1035,842>,<845,1036,724>,<846,847,632>,<846,1037,847>,<847,1037,572>,<849,1037,846>,<849,1038,728>,<850,1039,634>,<851,1039,730>,<852,853,635>,<852,956,636>,<852,1040,853>,<853,732,575>,<853,1040,732>,<854,637,857>,<854,857,1041>,<854,956,637>,<855,734,576>,<855,1041,734>,<856,857,637>,<856,1042,857>,<859,738,578>,<859,1043,738>,<860,861,639>,<860,1044,861>,<861,740,579>,<861,1044,740>,<862,641,865>,<862,865,1045>,<862,1045,640>,<864,858,638>,<864,957,858>,<864,1046,865>,<865,641,864>,<867,1050,872>,<868,869,643>,<868,1048,869>,<871,750,584>,<871,1048,868>,<871,1049,750>,<872,642,867>,<872,873,645>,<872,1050,873>,<873,752,585>,<873,1050,752>,<874,1051,646>,<875,754,586>,<875,1051,754>,<876,648,879>,<876,879,1052>,<876,1052,877>,<877,647,876>,<878,959,649>,<879,758,588>,<879,1053,758>,<880,646,875>,<880,875,1054>,<880,881,649>,<880,959,646>,<880,1054,881>,<882,961,651>,<883,762,590>,<883,1055,762>,<883,1057,886>,<884,1056,651>,<885,591,762>,<885,764,591>,<885,1056,764>,<886,887,652>,<886,1057,887>,<888,962,654>,<888,1058,653>,<889,768,593>,<889,1058,768>,<889,1060,892>,<891,770,594>,<891,1059,770>,<892,893,655>,<892,1060,893>,<894,895,656>,<894,1061,895>,<895,774,596>,<895,1061,774>,<896,963,658>,<897,1061,894>,<897,1062,776>,<898,659,901>,<898,899,658>,<898,963,659>,<898,1063,899>,<899,778,598>,<899,1063,778>,<900,963,656>,<901,1063,898>,<901,1064,599>,<903,1065,782>,<904,662,907>,<904,905,661>,<904,964,662>,<904,1066,905>,<907,602,784>,<907,786,602>,<907,1066,904>,<907,1067,786>,<908,660,903>,<908,903,1068>,<908,909,663>,<908,1068,909>,<910,665,913>,<910,1069,911>,<911,664,910>,<912,965,666>,<913,792,605>,<913,1069,910>,<913,1070,792>,<914,915,666>,<914,1071,915>,<917,796,607>,<917,1071,914>,<917,1072,796>,<918,669,921>,<918,921,1073>,<918,1073,919>,<919,668,918>,<919,798,608>,<919,1073,798>,<920,966,670>,<921,800,609>,<921,1074,800>,<922,671,925>,<922,923,670>,<922,925,1075>,<922,966,671>,<922,1075,923>,<924,1076,671>,<925,804,611>,<925,1076,804>,<927,806,612>,<927,1077,806>,<928,674,931>,<928,929,673>,<928,931,1078>,<928,1078,929>,<930,967,672>,<932,968,676>,<933,812,615>,<933,1080,812>,<934,677,937>,<934,935,676>,<934,937,1081>,<934,1081,935>,<935,814,616>,<935,1081,814>,<936,1082,677>,<938,940,679>,<938,969,940>,<938,1083,678>,<940,680,943>,<941,820,619>,<941,1084,820>,<942,943,680>,<942,969,681>,<942,1085,943>,<943,1084,940>,<943,1085,620>,<944,678,939>,<944,939,1086>,<944,1086,681>,<946,1087,682>,<947,826,622>,<947,1087,826>,<948,684,951>,<949,828,623>,<949,1088,828>,<950,951,684>,<950,970,685>,<950,1089,951>,<951,830,624>,<951,1088,948>,<951,1089,830>,<952,682,947>,<952,947,1090>,<953,625,830>,<953,832,625>,<953,1090,832>,<954,836,627>,<954,840,629>,<955,844,631>,<955,846,632>,<955,848,633>,<956,850,634>,<956,854,636>,<956,856,637>,<957,862,640>,<958,870,644>,<959,874,646>,<959,876,647>,<959,880,649>,<961,882,650>,<961,884,651>,<962,888,653>,<962,890,654>,<963,894,656>,<963,896,657>,<963,898,658>,<963,900,659>,<964,902,660>,<964,906,662>,<964,908,663>,<965,910,664>,<965,914,666>,<965,916,667>,<966,918,668>,<966,922,670>,<966,924,671>,<967,926,672>,<967,928,673>,<968,932,675>,<968,934,676>,<969,944,681>,<970,948,683>,<970,952,685>,<972,702,554>,<973,719,568>,<974,692,561>,<975,725,1>,<976,725,571>,<978,728,570>,<979,731,574>,<980,732,576>,<981,735,576>,<982,736,574>,<983,739,578>,<984,740,580>,<985,743,580>,<987,747,582>,<989,750,585>,<990,747,554>,<991,754,587>,<991,755,586>,<993,759,588>,<994,696,560>,<996,765,591>,<998,768,594>,<998,769,593>,<999,771,594>,<1007,787,602>,<1009,793,562>,<1010,793,605>,<1016,804,608>,<1017,806,613>,<1017,807,612>,<1018,809,613>,<1019,810,612>,<1020,813,615>,<1022,816,615>,<1023,818,619>,<1026,825,621>,<1028,829,623>,<1029,830,625>,<1030,833,625>,<1031,837,567>,<1033,839,628>,<1034,720,569>,<1034,835,566>,<1036,845,631>,<1037,726,572>,<1037,849,573>,<1039,850,635>,<1039,851,634>,<1043,861,579>,<1044,860,640>,<1044,863,580>,<1045,742,580>,<1045,863,640>,<1045,865,581>,<1047,746,582>,<1047,867,642>,<1048,748,583>,<1048,871,584>,<1049,870,645>,<1051,874,647>,<1051,875,646>,<1054,760,589>,<1054,875,586>,<1056,885,651>,<1057,766,592>,<1058,888,654>,<1058,889,653>,<1059,893,595>,<1060,772,595>,<1060,889,593>,<1063,901,599>,<1064,780,599>,<1067,907,662>,<1068,903,600>,<1070,913,665>,<1070,915,606>,<1071,794,606>,<1075,802,610>,<1076,924,668>,<1076,925,671>,<1077,927,672>,<1078,808,613>,<1078,931,614>,<1079,810,614>,<1079,931,674>,<1080,933,675>,<1081,937,617>,<1082,936,675>,<1082,937,677>,<1083,818,618>,<1083,939,678>,<1085,822,620>,<1085,945,621>,<1086,824,621>,<1086,945,681>,<1087,947,682>,<1374,1376,1426>,<1374,1426,1424>,<1375,1425,1429>,<1375,1429,1379>,<1377,1374,1424>,<1378,1377,1427>,<1378,1428,1425>,<1424,1427,1377>,<1425,1375,1378>,<1427,1428,1378>,<1417,1418,1419>,<1419,1416,1417>,<1421,1422,1423>,<1423,1420,1421>}
}


//#declare Iris=Eyeball_Texture(x,<1,1,0>,1);
#declare Iris=Eyeball_Texture(<0,0,0.8>,<0.6,0.6,1>,1);

#declare occhio1=object{Eyeball_Macro(.35,Iris) rotate <0,-70,0> scale 0.045 translate <1.30015,0.381908,-2.86193e-2>}
#declare occhio2=object{Eyeball_Macro(.35,Iris) rotate <0,-90,0> scale 0.045 translate <1.26392,0.385833,0.108160>}


#declare tartaruga_sprint=union{
	object {lente1}
	object {supporto_lente1}
	object {occhio1}
	object {lente2}
	object {supporto_lente2}
	object {occhio2}
	object {elmetto}
	object {mozzo1}
	object {ruota1}
	object {mozzo2}
	object {ruota2}
	object {mozzo3}
	object {ruota3}
	object {mozzo4}
	object {ruota4}
	object {Guga}
}
// ---------------------------------------------------------------

// Scene ---------------------------------------------------------
// Turtle
object {tartaruga_sprint translate <0.2,0.25,0>}
// Motion blur on the turtle
motion_blur {
	type 1
	object {tartaruga_sprint translate <0.2,0.25,0>}
	translate -x*clock
}
// Road
box {
  <-1, -1, -1>, <1, 1, 1>
  texture { t_asfalto}
  scale <30.0, 0.1, 2.0>
}

box {
  <-1, -1, -1>, <1, 1, 1>
  texture {t_striscia_asfalto}
  scale <30.0, 0.01, 0.3>
  translate <0,0.1,0>
}

// Grass plane
plane {
  y,0
  texture {erbetta}
  translate  <-0.07925, 0.09, 0.09269>
}

// Grass ---------------------------------

#declare PdV=<0,55,-80>;
#declare PdA=<0,12,10>;

#declare Blanc1=rgb<0.90,0.81,0.81>;

#declare Green1=rgb<230,170,50>/255;
#declare Green2=rgb<110,160,8>/255;
// --------------------------------------
// Grass texture
// --------------------------------------
#declare pigSpotted =pigment {
spotted
    color_map {
        [0.0, 0.2   color Tan*0.1 color Tan*0.4]
        [0.2, 0.3   color Tan*0.4 color Green1]
        [0.3, 1.01   color Green1 color Green1*1.2]
    }
}

#declare pigEarth =pigment {
    spotted
    color_map {
        [0 color Tan*0.3]
        [0.6 color Tan*0.3]
        [0.6 color Green1*0.4]
        [1   color Green1*0.4]
    }
}
#declare pigGreen=pigment{Green2*1.3}
//#declare pigSpotted=pigment{Red}
//#declare pigEarth=pigment{Blue}
#declare txtGrass=texture {                  

                pigment {
                        gradient y
                        turbulence 0.2
                                pigment_map {                                
                                    [0.0 pigEarth]
                                    [0.3 pigGreen]
                                    [0.9 pigSpotted]
                                    [1.00 pigEarth]
                                }
                        }

        finish{ambient 0.01 diffuse 0.7 specular 0.2 roughness 0.015}
        scale <0.001,1,0.001>
 
} 
// --------------------------------------
// Patch parameters
// --------------------------------------
// Final number of triangles = nBlade x nBlade x segBlade x 2 (or 4 if dofold = true)
// --------------------------------------
#declare lPatch=50;               // size of patch
//#declare nBlade=4;                // number of blades per line (there will be nBlade x nBlade blades)
#declare nBlade=10;                // number of blades per line (there will be nBlade x nBlade blades)
#declare ryBlade = 0;            // initial y rotation of blade
#declare segBlade= 15;            // number of blade segments
#declare lBlade = 25;             // length of blade
#declare wBlade = 1;              // width of blade at start
#declare wBladeEnd = 0.3;         // width of blade at the end
#declare doSmooth=false;          // true makes smooth triangles
#declare startBend = <0,1,0.3>;   // bending of blade at start (<0,1,0>=no bending)
#declare vBend = <0,-0.5,0>;         // force bending the blade (<0,1,1> = 45)
#declare pwBend = 3;              // bending power (how slowly the curve bends)
#declare rd = 459;                // seed
#declare stdposBlade = 1;         // standard deviation of blade position 0..1
#declare stdrotBlade = 360;       // standard deviation of rotation
#declare stdBlade = 1.2;           // standard deviation of blade scale;
#declare stdBend = 2;            // standard deviation of blade bending;
#declare dofold = true;          // true creates a central fold in the blade (twice more triangles)
#declare dofile = true;          // true creates a mesh file
#declare fname = "fgrass1.inc"     // name of the mesh file to create

// --------------------------------------
// Prairie parameters
// --------------------------------------
#declare nxPrairie=3;             // number of patches for the first line
#declare addPatches=1;            // number of patches to add at each line
#declare nzPrairie=5;             // number of lines of patches
#declare rd=seed(779);            // random seed
#declare stdscale=1;              // stddev of scale
#declare stdrotate=1;             // stddev of rotation
#declare doTest=false;            // replaces the patch with a sphere

// --------------------------------------
// Create the patch and the prairie
// --------------------------------------
#if (dofile=true) // if the patch is already created, turn off the next line
        //MakeGrassPatch(lPatch,nBlade,ryBlade,segBlade,lBlade,wBlade,wBladeEnd,doSmooth,startBend,vBend,pwBend,rd,stdposBlade,stdrotBlade,stdBlade,stdBend,dofold,dofile,fname)
        #declare objectPatch=#include fname
#else        
        #declare objectPatch=object{MakeGrassPatch(lPatch,nBlade,ryBlade,segBlade,lBlade,wBlade,wBladeEnd,doSmooth,startBend,vBend,pwBend,rd,stdposBlade,stdrotBlade,stdBlade,stdBend,dofold,dofile,fname)}
#end        
object{MakePrairie(lPatch,nxPrairie,addPatches,nzPrairie,objectPatch,rd,stdscale,stdrotate,doTest)
	scale 0.06
	texture{txtGrass scale 40}
	translate <-10,0,5.5>
}
object{MakePrairie(lPatch,nxPrairie,addPatches,nzPrairie,objectPatch,rd,stdscale,stdrotate,doTest)
	scale <0.04,0.02,0.04>
	texture{txtGrass scale 40}
	translate <3.1,0,-12>
}
// ---------------------------------------------------------------
