//Speedy CPU by Aero - IRTC nov-dec 2005

global_settings {
	max_trace_level 50
	assumed_gamma 1.6
	radiosity {
		pretrace_start		0.08
		pretrace_end		0.04
		count			32

		nearest_count		2
		error_bound		0.8
		recursion_limit		4
		low_error_factor	0.5
		gray_threshold		0.0
		minimum_reuse		0.015
		brightness		0.8

		adc_bailout		0.01/2
	}
	ambient_light 0
}

camera {
	location	<-1,1.5,-3.2>
	right		x*image_width/image_height
	look_at		<0.9,0,0>
}

light_source {
	<-15,15,-15>
	color rgb <1,1,1>*0.6
	spotlight
	point_at <0,0,0>
	radius 5
	falloff 7.5
}

//CPU contact - declare
#declare jalka = union {
	sphere_sweep {
		linear_spline
		4
		<0,0.3,0>,0.04
		<0,0.3,-0.16>,0.04
		<0,0.04,-0.16>,0.04
		<0,0.04,-0.25>,0.04
		pigment {color rgb 0.7}
		finish {
			diffuse 0.9
			reflection 0.01

		}
	}
	cylinder {
		<0,0.04,-0.23>
		<0,-0.05,-0.38>
		0.038
		pigment {color rgb 0.7}
		finish {
			diffuse 0.9
			reflection 0.4

		}
	}
}

//circuit routes - declare
#declare reitit = intersection {
	union {
		sphere_sweep {
			linear_spline
			4
			<-0.9,0,-0.9>, 0.05
			<-0.9,0,-1.5>, 0.03
			<-2.0,0,-3.0>, 0.03
			<-2.0,0,-17.0>, 0.03
		}
		sphere_sweep {
			linear_spline
			5
			<-0.7,0,-0.9>, 0.05
			<-0.7,0,-1.6>, 0.03
			<-1.1,0,-2.3>, 0.03
			<-1.1,0,-3.0>, 0.03
			<-1.1,0,-17.0>, 0.03
		}
		sphere_sweep {	
			linear_spline
			5
			<-0.5,0,-0.9>, 0.05
			<-0.5,0,-1.7>, 0.03
			<-0.9,0,-2.4>, 0.03
			<-0.9,0,-3>, 0.03
			<-0.9,0,-17>, 0.03
		}
		sphere_sweep {
			linear_spline
			7
			<-0.3,0,-0.9>, 0.05
			<-0.3,0,-1.8>, 0.03
			<-0.6,0,-2.15>, 0.03
			<-0.6,0,-2.35>, 0.02
			<-0.7,0,-2.65>, 0.02
			<-0.7,0,-3.00>, 0.02
			<-0.7,0,-17.0>, 0.02
		}
		sphere_sweep {
			linear_spline
			4
			<-0.6,0,-2.35>, 0.02
			<-0.5,0,-2.65>, 0.02
			<-0.5,0,-3.00>, 0.02
			<-0.5,0,-17.0>, 0.02
		}
		sphere_sweep {
			linear_spline
			2
			<-0.65,0,-2.55>, 0.02
			<-0.54,0,-2.55>, 0.02
		}
		sphere_sweep {
			linear_spline
			14
			<-0.1,0,-0.9>, 0.05
			<-0.1,0,-1.8>, 0.03
			<-0.4,0,-2.15>, 0.03
			<-0.4,0,-2.37>, 0.02
			<-0.30,0,-2.37>, 0.02
			<-0.45,0,-2.37>, 0.02
			<-0.45,0,-2.52>, 0.02
			<-0.35,0,-2.52>, 0.02
			<-0.45,0,-2.52>, 0.02
			<-0.45,0,-2.65>, 0.02
			<-0.30,0,-2.65>, 0.02
			<-0.40,0,-2.65>, 0.02
			<-0.40,0,-3.00>, 0.02
			<-0.40,0,-17.0>, 0.02
		}
		union {
			sphere_sweep {
				linear_spline
				8
				<0.1,0,-0.9>, 0.05
				<0.1,0,-1.8>, 0.03
				<-0.1,0,-2.15>, 0.03
				<-0.1,0,-2.35>, 0.02
				<-0.2,0,-2.35>, 0.02
				<-0.2,0,-2.65>, 0.02
				<-0.2,0,-3.00>, 0.02
				<-0.2,0,-17.0>, 0.02
			}
			difference {
				union {
					sphere {
						<-0.12,0,-2.43>,0.1
					}
					box {
						<-0.2,-0.01,-2.45>
						<-0.1, 0.02,-2.53>
					}
				}
				sphere {
					<-0.12,0,-2.43>,0.07
				}
			}
		}
		sphere_sweep {
			linear_spline
			4
			<-0.1,0,-2.53>, 0.02
			<-0.05,0,-2.65>, 0.02
			<-0.05,0,-3.00>, 0.02
			<-0.05,0,-17.0>, 0.02
		}	
		difference {
			union {
				sphere_sweep {
					linear_spline
					6
						< 0.3,0,-0.9>, 0.05
					< 0.3,0,-1.8>, 0.03
					< 0.13,0,-2.15>, 0.03
					< 0.13,0,-2.35>, 0.02
					< 0.13,0,-3.00>, 0.02
					< 0.13,0,-17.0>, 0.02
				}	
				sphere {
					< 0.13,0,0>,0.1
					scale <1,1,2>
					translate <0,0,-2.5>
				}
			}
			sphere {
				< 0.13,0,0>,0.075
				scale <1,1,2>
				translate <0,0,-2.5>
			}
		}
		sphere_sweep {
			linear_spline
			7
			< 0.5,0,-0.9>, 0.05
			< 0.5,0,-1.8>, 0.03
			< 0.5,0,-2.15>, 0.03
			< 0.4,0,-2.35>, 0.02
			< 0.4,0,-2.65>, 0.02
			< 0.3,0,-3.00>, 0.02
			< 0.3,0,-17.0>, 0.02
		}
		sphere_sweep {
			linear_spline
			7
			< 0.7,0,-0.9>, 0.05
			< 0.7,0,-1.8>, 0.03
			< 0.7,0,-2.15>, 0.03
			< 0.6,0,-2.35>, 0.02
			< 0.6,0,-2.65>, 0.02
			< 0.4,0,-3.00>, 0.02
			< 0.4,0,-17.0>, 0.02
		}
		sphere_sweep {
			linear_spline
			7
			< 0.9,0,-0.9>, 0.05
			< 0.9,0,-1.8>, 0.03
			< 0.9,0,-2.15>, 0.03
			< 0.8,0,-2.35>, 0.02
			< 0.7,0,-2.65>, 0.02
			< 0.7,0,-3.00>, 0.02
			< 0.7,0,-17.0>, 0.02
		}
	}
	box {
	 	<-18,-0.1,-18>
		< 18,0.001, 18>
	}
	pigment {
		color rgb 0.3
	}
	finish {
		diffuse 0.9
		reflection 0.1
		specular 0.1
		roughness 0.2
	}
}

// resistor - declare
#declare vastus = union {
	blob {
		threshold 0.6
		sphere { 
			<0, 0, -0.4>, 0.2, 1
			}
		cylinder { 
			<0, 0, -0.4>
			<0, 0,  0.4> 
			0.13 
			1.0
			}
		sphere { 
			<0, 0, 0.4>, 0.2, 1
			}
		pigment {color rgb <1,0,0>}
	}
	sphere_sweep {
		cubic_spline
		8
		<0,-1, 0.6>,0.02
		<0,-0.8, 0.6>,0.02
		<0,-0.1, 0.6>,0.02
		<0, 0, 0.3>,0.02
		<0, 0,-0.3>,0.02
		<0,-0.1,-0.6>,0.02
		<0,-0.8,-0.6>,0.02
		<0,-1,-0.6>,0.02
		}
	sphere {
		<0,-0.2,0.62> 0.027
                pigment {color rgb 0.7}
                finish {
                        diffuse 0.9
                        reflection 0.4
                }
	}
	sphere {
		<0,-0.2,-0.62> 0.027
                pigment {color rgb 0.7}
                finish {
                        diffuse 0.9
                        reflection 0.4

                }
	}
	cylinder {
		<0,0,-0.2>
		<0,0,-0.15>
		0.0667
		pigment {color rgb <0.8,0,0>}
	}
	cylinder {
		<0,0,-0.1>
		<0,0,-0.05>
		0.06665
		pigment {color rgb 0.92}
	}
	cylinder {
		<0,0,0.1>
		<0,0,0.05>
		0.06665
		pigment {color rgb <0.4,0.4,0>}
	}
	cylinder {
		<0,0, 0.15>
		<0,0, 0.2>
		0.06668
		pigment {color rgb 0.02}
	}
	pigment {color rgb 0.7}
	finish {
	  	diffuse 0.9
	  	reflection 0.1
	}
}

//condensator - declare
#declare konkka = union {
  difference {
	cylinder {
		<0,0,0>
	 	<0,0.8,0> 0.4
	}
	box {
		<-1,-0.1,-0.5>
		< 1, 0.7999,-0.3>
	}
	pigment {color rgb 0.1}
  	finish {ambient 0.1 diffuse 0.8 reflection 0.1}
  }
  
  intersection {
	cylinder {
		<0,0,0>
		<0,0.8,0> 0.4
	}
	box {
		<-1,-0.1,-0.5>
		< 1, 0.7999,-0.3>
	}
	pigment {color rgb 0.7}
	finish {ambient 0.3 diffuse 0.6}
  }
  cylinder {
	<-0.2,-1,0>
	<-0.2,0.1,0>
	0.02
	pigment {color rgb 0.8}
	finish  {diffuse 0.9 reflection 0.1}
	}
 cylinder {
	<0.2,-1,0>
	<0.2,0.1,0>
	0.02
	pigment {color rgb 0.8}
	finish  {diffuse 0.9 reflection 0.1}
	}	
}

//transistor, TO-220 - declare
#declare to220 = union {
	box {
		<-0.2,0,-0.05>
		< 0.2,0.5, 0.05>
		pigment {color rgb 0.1}
		finish {diffuse 0.8 reflection 0.3}
	}
	difference {
		box {
			<-0.2,0,0.049>
			< 0.2,0.9,0.06>
		}
		cylinder {
			<0,0.7,0.048>	
			<0,0.7,0.061>	
			0.06
		}
		pigment {color rgb 0.8}
		finish  {diffuse 0.9 reflection 0.1 }
		normal  {bozo turbulence 0.3}
	}
	cylinder {
		<-0.1,-1,0>
		<-0.1,0.1,0>
		0.02
		pigment {color rgb 0.8}
		finish  {diffuse 0.9 reflection 0.2}
	}	
	cylinder {
		<0,-1,0>
		<0,0.1,0>
		0.02
		pigment {color rgb 0.8}
		finish  {diffuse 0.9 reflection 0.2}
	}	
	cylinder {
		<0.1,-1,0>
		<0.1,0.1,0>
		0.02
		pigment {color rgb 0.8}
		finish  {diffuse 0.9 reflection 0.2}
	}	
        sphere {
                <-0.1,0,0> 0.027
                pigment {color rgb 0.7}
                finish {
                        diffuse 0.9
                        reflection 0.4
                }
        }
        sphere {
                <0,0,0> 0.027
                pigment {color rgb 0.7}
                finish {
                        diffuse 0.9
                        reflection 0.4
                }
        }
        sphere {
                <0.1,0,0> 0.027
                pigment {color rgb 0.7}
                finish {
                        diffuse 0.9
                        reflection 0.4
                }
        }

}

// circuit board
box {
	<-2,0,-6>
	<10,-0.2,10>
	pigment {color rgb <0,1,0>}
	finish {
		diffuse 0.8
		reflection 0.005
	}
}

// CPU
box {
	<-1,0.2,-1>
	< 1,0.4, 1>
	texture {
		pigment {
			image_map { png "chip.png" }
			scale <2,2,1>
		}
		normal {
			bozo
			turbulence 0.3
		}
		finish {
			diffuse 0.9
			specular 0.05
			roughness 0.1
		}
		rotate <90,0,0>
		translate <-1,0,1>
	}
}

// smoke
sphere_sweep {
	cubic_spline
	7
	<0.2,-0.5,0.1>,	0.1
	<0.2,0.4,0.1>, 0.03
	<0.2,0.6,0.1>, 0.15
	<0.3,0.9,0.2> 0.2
	<0.2,1.7,0.3> 0.22
	<0.2,7,0.3> 0.22
	<0.1,9,0>0.22
	hollow
	texture {
		pigment {
			rgbt <1,1,1,0.95>
		}
		finish {
			ambient 0
			diffuse 0
			reflection 0.01
		}
	}
	interior {
		media {
			intervals 30
			ratio 0.9
			samples 2,4
			confidence 0.9
			variance 1.0/128.0
			method 1
			absorption <1.0,1.0,1.0>*4.9
			emission <0.1,0.1,0.1>
			density {
				spherical
				turbulence 0
				density_map {
					[0.0 color rgb 0 ]
					[1.0 color rgb 1 ]
				}
			}
		}
	}
	translate <0.05,0,-0.2>
}

// CPU contacts

// south
object {jalka translate <-0.9,0,-0.9>}
object {jalka translate <-0.7,0,-0.9>}
object {jalka translate <-0.5,0,-0.9>}
object {jalka translate <-0.3,0,-0.9>}
object {jalka translate <-0.1,0,-0.9>}
object {jalka translate < 0.1,0,-0.9>}
object {jalka translate < 0.3,0,-0.9>}
object {jalka translate < 0.5,0,-0.9>}
object {jalka translate < 0.7,0,-0.9>}
object {jalka translate < 0.9,0,-0.9>}
// north
object {jalka rotate <0,180,0> translate <-0.9,0,0.9>}
object {jalka rotate <0,180,0> translate <-0.7,0,0.9>}
object {jalka rotate <0,180,0> translate <-0.5,0,0.9>}
object {jalka rotate <0,180,0> translate <-0.3,0,0.9>}
object {jalka rotate <0,180,0> translate <-0.1,0,0.9>}
object {jalka rotate <0,180,0> translate < 0.1,0,0.9>}
object {jalka rotate <0,180,0> translate < 0.3,0,0.9>}
object {jalka rotate <0,180,0> translate < 0.5,0,0.9>}
object {jalka rotate <0,180,0> translate < 0.7,0,0.9>}
object {jalka rotate <0,180,0> translate < 0.9,0,0.9>}
//west
object {jalka rotate <0,90,0> translate <-0.9,0,-0.9>}
object {jalka rotate <0,90,0> translate <-0.9,0,-0.7>}
object {jalka rotate <0,90,0> translate <-0.9,0,-0.5>}
object {jalka rotate <0,90,0> translate <-0.9,0,-0.3>}
object {jalka rotate <0,90,0> translate <-0.9,0,-0.1>}
object {jalka rotate <0,90,0> translate <-0.9,0, 0.1>}
object {jalka rotate <0,90,0> translate <-0.9,0, 0.3>}
object {jalka rotate <0,90,0> translate <-0.9,0, 0.5>}
object {jalka rotate <0,90,0> translate <-0.9,0, 0.7>}
object {jalka rotate <0,90,0> translate <-0.9,0, 0.9>}
//east
object {jalka rotate <0,-90,0> translate <0.9,0,-0.9>}
object {jalka rotate <0,-90,0> translate <0.9,0,-0.7>}
object {jalka rotate <0,-90,0> translate <0.9,0,-0.5>}
object {jalka rotate <0,-90,0> translate <0.9,0,-0.3>}
object {jalka rotate <0,-90,0> translate <0.9,0,-0.1>}
object {jalka rotate <0,-90,0> translate <0.9,0, 0.1>}
object {jalka rotate <0,-90,0> translate <0.9,0, 0.3>}
object {jalka rotate <0,-90,0> translate <0.9,0, 0.5>}
object {jalka rotate <0,-90,0> translate <0.9,0, 0.7>}
object {jalka rotate <0,-90,0> translate <0.9,0, 0.9>}

//circuit routes
object {reitit}
object {reitit rotate <0,90,0>}
object {reitit rotate <0,180,0>}
object {reitit rotate <0,-90,0>}
box {
	<1.27,0.001,4.25>
	<1.42,-0.1,4.55>
	pigment {color rgb 0.7}
	finish {
	 	diffuse 0.9
		reflection 0.1
	}
}
box {
	<1.46,0.001,4.25>
	<1.52,-0.1,4.55>
	pigment {color rgb 0.7}
	finish {
	 	diffuse 0.9
		reflection 0.1
	}
}
box {
	<1.56,0.001,4.25>
	<1.62,-0.1,4.55>
	pigment {color rgb 0.7}
	finish {
	 	diffuse 0.9
		reflection 0.1
	}
}

//transistors, TO-220
object {to220 translate <1.5,0.2,3.2>}
object {to220 translate <2.5,0.2,3.2>}
object {to220 translate <2.5,0.2,3.6>}
object {to220 translate <1.5,0.2,4.4>}
object {to220 rotate <0,-47,0> translate <4.53,0.2,2.4>}
object {to220 rotate <0,47,0> translate <4.3,0.2,2.6>}

//resistors
object {vastus rotate <0,27.5,0> translate <2.6,0.2,-0.94>}
object {vastus rotate <0,90,0> translate <0.3,0.2,2>}
object {vastus rotate <0,45,0> translate <1.6,0.2,7>}
object {vastus rotate <0,45,0> translate <2.9,0.2,1.05>}
object {vastus scale  <1,1,0.7> rotate <0,45,0> translate <3.68,0.2,1.8>}
object {vastus rotate <0, -5,0> translate <3.85,0.2,2.68>}
object {vastus rotate <0,-87,0> translate <4.6,0.2,2.1>}
//resistornet #1
object {vastus rotate <0,90,0> translate <-0.76,0.2,6.1>}
object {vastus rotate <0,90,0> translate <-0.92,0.2,5.6>}
object {vastus rotate <0,90,0> translate <-1.02,0.2,5.1>}
object {vastus rotate <0,90,0> translate <-0.92,0.2,4.6>}
object {vastus rotate <0,90,0> translate <-1.02,0.2,4.1>}
object {vastus rotate <0,90,0> translate <-0.92,0.2,3.6>}
object {vastus rotate <0,90,0> translate <-0.76,0.2,3.1>}
object {vastus rotate <0,90,0> translate <-1.36,0.15,2.6>}
//resistornet #2
object {vastus rotate <0,-14,0> translate <0.22,0.15,4.1>}
object {vastus rotate <0,-18,0> translate <0.5,0.15,4.5>}
object {vastus rotate <0,-20,0> translate <0.85,0.15,4.8>}
object {vastus rotate <0,-20,0> translate <1.2,0.15,5.1>}
object {vastus rotate <0,-20,0> translate <1.5,0.15,5.5>}

//condensators
object {konkka translate <1.5,0.1,1.5>}
object {konkka translate <2.5,0.1,1.5>}
object {konkka translate <1.5,0.1,2.5>}
object {konkka translate <2.5,0.1,2.5>}
object {konkka rotate <0,-39,0> translate <0,0.1,6.5>}
object {konkka translate <4.5,0.1,1.5>}
object {konkka rotate <0,20,0> translate <-1.2,0.1,6.8>}
object {konkka rotate <0,20,0> translate <0.8,0.1,6.4>}
object {konkka rotate <0,20,0> scale <1.2,1.4,1.2> translate <-0.8,0.1,8>}
object {konkka rotate <0,20,0> scale <1.5,2.2,1.5> translate <7,0.2,7>}
object {konkka rotate <0,20,0> scale <1.5,2.2,1.5> translate <5,0.2,7>}
object {konkka rotate <0,90,0> scale <1.5,2.5,1.5> translate <5,0.2,0>}
object {konkka rotate <0,90,0> scale <1.5,2.5,1.5> translate <6.5,0.2,2>}
