#include "colors.inc"
#include "woods.inc"
#include "functions.inc"
#include "finish.inc"
#include "golds.inc"
#include "metals.inc"


#version 3.6;
#declare area=1;

#declare factor=3.2;
camera
{ orthographic
  location  <400.0*sqrt(2)/factor, 400.0*sqrt(2)/factor, -400.0>
  direction <-1*sqrt(2)/factor,-1*sqrt(2)/factor,1>
  up        60*y
  right     60*4/3*x
  //look_at   <0.0, 0.0,  0.0>
}
global_settings{ assumed_gamma 1.0 max_trace_level 130 }
default {  finish {ambient 0.8 diffuse 0.2 reflection 0.0 } }
background { White }

// general light definition
light_source {
  <-100, 400, -100>      // position of the light source
  color rgb 0.7     // color of the light
  // spotlight
  // cylinder
  // parallel
#if (area)
  area_light 40*x, 40*z, 9, 9
#end
  // (---for spotlight/cylinder---)
  // radius FLOAT
  // falloff FLOAT
  // tightness FLOAT
  // point_at <VECTOR>   // for spotlight/cylinder/parallel
  // (---for area_light---)
  // adaptive FLOAT
  // jitter FLOAT
  // circular
  // orient
  // (---other modifiers---)
  // looks_like { OBJECT }
  // fade_distance FLOAT
  // fade_power FLOAT
  // media_attenuation BOOL
  // media_interaction BOOL
  // shadowless
}

light_source {
  <10, 70, -100>      // position of the light source
  color rgb 0.5     // color of the light
#if (area)
	area_light 10*x, 10*y, 8, 8
#end
}


light_source {
  <-100, 100, 00>      // position of the light source
  color rgb 0.6     // color of the light
#if (area)
	area_light 10*x, 10*z, 8, 8
#end
}

// T_Wood7 
//box { <-100,-40,-40>,<0,0,0> texture { T_Wood7 rotate 90*y translate <34,45,534> } }
#declare ech=40;

#declare ep=0.1;
#declare liquide=0.5;
#declare curv=3.4;

  union {
  box { <-1*ech*2,0,10>,<ech*2,-ep,-ech+curv> }
	box { <-1*ech*2,-ech,-ech>,<ech*2,-curv,-ech+ep>}
	cylinder { < -1*ech*2,-curv,-ech+curv>,<ech*2,-curv,-ech+curv>,curv }

translate <0,-ep,ep> 
    texture { T_Wood7 rotate 90*y translate <34,45,534> } 

} // end of isosurface -----------------------------------------

//cylinder { <0,0.01,0>,<0,10,0>,10 texture { pigment { Aquamarine }} }

sky_sphere { pigment { colour  White } }


union {
difference {
superellipsoid { <1,0.13> rotate 90*x scale <10,10,10> translate <-20,10,0> }
superellipsoid { <1,0.13> rotate 90*x scale <10-ep,10-ep,10-ep> translate <-20,10,0> 
	texture { T_Chrome_5C normal { dents 0.51 }  } }
//cylinder { <-20,ep,0>,<-20,10,0>,10-ep  }
plane  { -y,-10 } 
texture { T_Copper_3C }
}
cylinder { <-20,1,0>,<-20,1+liquide,0>,9-ep texture { pigment { cylindrical color_map {
				[0 Maroon/3+Red/3]
				[0.5 Red*2 ]
				[0.75 Yellow*2]
				[1 White*3]
				
				
				} scale 9 translate <-20,0,0>
				} finish { Dull } } }
 	translate <-14,0,0>
}

plane { -z,-10 texture { pigment { SteelBlue } finish { Dull } normal { dents 0.151 }  } }

#if (1=1)  
  union {
	box { <-1*ech*0.17,0,10>,<ech*2,ep,-ech+curv> }
	box { <-1*ech*0.17,-ech,-ech>,<ech*2,-curv,-ech-ep>  }
	cylinder { < -1*ech*0.17,-curv,-ech+curv>,<ech*2,-curv,-ech+curv>,curv+ep }

	
	torus { curv+ep*0.5,ep/2 rotate 90*z translate < -1*ech*0.17,-curv,-ech+curv> }
	cylinder { <-1*ech*0.17,ep/2,10>,<-1*ech*0.17,ep/2,-ech+curv>,ep/2 }
	cylinder { <-1*ech*0.17,-ech,-ech-ep/2>,<-1*ech*0.17,-curv,-ech-ep/2>,ep/2 }
    texture { pigment { White*0.92 }  normal { bozo 2.8 } } 

} 
#declare Col1=(Yellow+Orange+3*White)/5;
#declare Col2=(Blue+Cyan)/2;
#declare Col3=(Blue+Cyan)/2;
#declare Col4=(Blue+Cyan+White)/3.5;
#declare Col4c=(Blue+Cyan)/3;
#declare incl=20;
#declare trans=<0,0,-19>;
lathe {
cubic_spline
10,
<0,1><0,1>,<14,0>,<17,2>,<20,2.5>,<20,3>,<16,1.5>,<15,1.5>,<0,1.5>,<0,1.5>
texture { pigment { cylindrical color_map {
			[0.05 White]
			[0.05 Col1 ]
			[0.075 Col1]
			[0.075 White]
			[0.10 White]
			[0.10 Col2 ]
			[0.110 Col2]
			[0.110 White]
			[0.115 White]
			[0.115 Col3]
			[0.125 Col3]
			[0.125 White]
			[0.15 White]
			[0.15 Col4 ]
			[0.165 Col4c ]
			[0.17 Col4c ]
			[0.185 Col4]
			[0.185 White]
		} scale 21 warp { turbulence <0.1,0.05,0.1> } }
finish { Glossy }
}
sturm scale <2/3,1,1> rotate incl*y 
translate trans
}

//box { <-6.5,1.5,-9>,<6.8,11.5,11>   rotate (incl+1)*y  translate trans}
#declare fn_Pigm=function {
    pigment {
      agate
      color_map {
        [0 color rgb 0]
        [1 color rgb 1]
      }
    }
  } // end of function fn_Pigm

	//box { <-4.4,1.5,-10>,<4.3,10,0> 
    isosurface { function { //f_boxed(1,1,1)
			max(abs((x+0.05)/4.35)+y/50,abs((y*2/8.5)-(11.5/8.5))+y*x*x/500,abs(z*2/9.9+1) )-1
		-fn_Pigm(x/2, y*1.8, z).gray*0.015
	}
		contained_by { box {<-5,1.5,-11>,<5,11,1> } }
		texture{ pigment{color rgb<0.98,0.95,0.85>*1.2}
           finish {ambient 0.1 diffuse 0.85 phong 1}}
		// texture { pigment { Aquamarine } }
		rotate incl*y
			translate trans
	}
	
	isosurface {

  function{ f_rounded_box(x,y,z,0.13,1,1,1)
            - f_noise3d( x*6, 6*y, 4*(z*3+cos(6*x)+1/2*sin(y*15)) )*0.3
          }
  contained_by { box { <-2,-2,-1.1>, <2,2,2> } }
  accuracy 0.00002
  max_gradient 16



    texture{ pigment{ boxed
			color_map{
			[0 Black]
			[0.002 Brown]
		    [0.04 (Yellow+Brown)/2]		
			[0.05 Brown]
			[0.09 (Yellow+Orange)/2]
			[0.12 (Brown+White*4)/5]
				
			[0.15 color rgb<1.2,1.2,1.2>]
			//[0.8 color rgb<1.2,1.2,1.2>]
			
		}
	scale <1.275,1.29,1.32>//11 
	warp { turbulence <0.2,0.02,0.02> }
	}
	   
	
	finish {ambient 0.5 diffuse 0.5 phong 1 reflection 0.0}
}
	scale <6,11,9>		
  rotate incl*y
			translate trans
	
} 
 // end of isosurface -------------------------------------------------


#macro boule(aa,bb,cc,dd)
isosurface {
  function{
   f_sphere(x, y, z, 5.3)
   -fn_Pigm(x/2+aa, y/2+bb, z/2+cc).gray*0.5

  }
  contained_by { sphere {<0,0,0>, -6.3 } }
  accuracy 0.003
  max_gradient 6
  scale 0.5
  texture{ pigment{color rgb dd*1.2}
           finish {ambient 0.5/* 0.1 */ diffuse 0.45 /* 0.85 */ phong 1}}
  rotate<0,20,0>
  translate <20.2+aa, 2.3+bb, -10+cc>
} // end of isosurface ------------------------------
#end

boule(-5.6/2,20,-5.6*(sqrt(3)-1)/2,<0.97,0.7,0.8>)
boule(5.6/2,20,-5.6*(sqrt(3)-1)/2,<0.8,0.65,0.45>)
//boule(0,0,4.6)
boule(0,20,5.6/2,<0.8,0.97,0.7>)

#declare palier=22.3-5.6/2;
lathe {
cubic_spline
10,
<6,0>,<6,0.5>,<5,1>,<1,2>,<0.81,3>,
<0.81,palier-3>,<4.6,palier-1>,<5.9,palier+1>,<6.6,palier+3>,<7,palier+6>
texture { T_Chrome_3D }

translate <20.2,0,-10>
}

union {
prism { bezier_spline conic_sweep 
	1,0.95, 16,
<0,0>,<0,-4>,<-1,-7>,<-2,-6>,
<-2,-6>,<-5,-5>,<-18,-1.7>,<-18,0>,
<-18,0>,<-18,1.7>,<-5,5>,<-2,6>,
<-2,6>,<-1,7>,<0,4>,<0,0>


scale <1,-1,1>
translate <0,1,0>
}
sphere_sweep { b_spline 6, 
	-3*x,1.5
	0,3,
	2*x,1,
	14*x,1,
	15*x,3
    18*x,2
 scale <1,1/2,1>
}
rotate -3*y
texture { T_Chrome_2E }
translate <29,1.5,-28>



}

box { <-0.015,-0.015,-0.01>,<1.015,1.015,0> texture { pigment { White }}
	texture { 	pigment { image_map { png "final.png" once
				}  }
	
	}
	
scale <-52,39,1>
translate <25,6,10>
}

sphere_sweep { linear_spline 5,
	<25-52,39+6,10>,1,
	<25-52,6,10>,1,
	<25,6,10>,1,
	<25,6+39,10>,1,
	<25-52,39+6,10>,1
texture { pigment { Pink } finish { Glossy } }
}

sphere_sweep { linear_spline 5,
	<25-52,39+6,9>,.2,
	<25-52,6,9>,.2,
	<25,6,9>,.2,
	<25,6+39,9>,.2,
	<25-52,39+6,9>,.2
texture { pigment { Red } finish { Dull } }
}
#end
// Ice-scream spoon
#declare spoon=
sphere_sweep { linear_spline 3,
	<0,5,0>,5,
	<0,1,0>,1,
	<0,1-60,60*20>,1
	texture { T_Chrome_4B }
	
	scale <1,1,1/20>*1/3
	rotate -45*x
	
}

object {spoon rotate 17*y
    translate <-22,0,-20> }
object { spoon rotate 12*y
	translate <-19,0,-24> }
object { spoon rotate 188*y 
	translate <-22,0,6> }

#include "glass.inc" 
// Glass of water 
difference { 
superellipsoid { <0.3,0.3> }
superellipsoid { <0.3,0.3> scale 0.93 translate 0.1*y }
box { <-1,0.8,-1>,<1,2,1> }
translate y scale <3.2,12,3.2>
translate <32.2,0,-11> 
texture {pigment {  Col_Glass_General } finish { F_Glass1 } }
interior { I_Glass1 }
}
