// Persistence of Vision Ray Tracer Scene Description File
// File: ?.pov
// Vers: 3.5
// Desc: Basic Scene Example
// Date: mm/dd/yy
// Auth: ?
//

#version 3.5;


// ==== Standard POV-Ray Includes ====
#include "colors.inc"	  // Standard Color definitions
//#include "textures.inc"	  // Standard Texture definitions
#include "functions.inc"  // internal functions usable in user defined functions

// several different gold colors, finishes and textures
#include "golds.inc"

// various metal colors, finishes and textures
// brass, copper, chrome, silver
#include "metals.inc"



#declare EisbecherTest = 1;
#declare TischTest = 1;
#declare TischEISTest = 1;
#declare BodenTest = 1;
#declare HoehleTest = 1; 
#declare LoeffelTest = 1; 







#declare R1 = seed(1); 

global_settings {
  assumed_gamma 1.0
}

// ----------------------------------------

camera {
  location  <6.0, 10, -10>
  look_at   <-1.5, 5.5,  0.0>

  aperture 1/12
  focal_point<0,6,0> 
  blur_samples 9  

}

sky_sphere {  pigment {color rgb <0.2,0,0>}}



light_source {
  <0, -100, 0>              
  color rgb <0,0.1,0.1> 
}


#declare i = 1;
#declare I =9;
#while (i < I)  

light_source {
  <-28,-3,0 >          
  color rgb <1, 0.2, 0.01>
  fade_distance 11
    fade_power 5.5

 rotate <0,-20+220*i/I,0>
}



 #declare i = i+1;   
#end




light_source {
  <-3,20,-13>                    // light's position (translated below)
  color rgb <0.3,0.3,1>       // light's color
  spotlight               // this kind of light source 
  point_at <0.0, 6, 0.0>      // direction of spotlight
  radius 10               // hotspot (inner, in degrees)
  tightness 50            // tightness of falloff (1...100) lower is softer, higher is tighter
  falloff 10               // intensity falloff radius (outer, in degrees)
}


light_source {
  <-6,20,-15>                    // light's position (translated below)
  color rgb <0.7,0.0,0.2>       // light's color
  spotlight               // this kind of light source 
  point_at <0.0, 6, 0.0>      // direction of spotlight
  radius 10                // hotspot (inner, in degrees)
  tightness 50            // tightness of falloff (1...100) lower is softer, higher is tighter
  falloff 10               // intensity falloff radius (outer, in degrees)
}

light_source {
  <-12,20,-10>                    // light's position (translated below)
  color rgb <0,0.7,0.2>       // light's color
  spotlight               // this kind of light source 
  point_at <0.0, 6, 0.0>      // direction of spotlight
  radius 10                // hotspot (inner, in degrees)
  tightness 50            // tightness of falloff (1...100) lower is softer, higher is tighter
  falloff 10              // intensity falloff radius (outer, in degrees)
}





// ----------------------------------------


#if (EisbecherTest)



union {

// Becher

union {

sor {
    9, 
    <1, 0>
    <1, 0>
    <1, 0.05>
    <0.5, 0.15>
    <0.2, 0.3>
    <0.3, 0.5>
    <0.2, 0.7>
    <0.5, 1>
    <1, 1.1>
 
}

sor {
    6, 
    <0, 0>
    <0, 0>
    <1, 0.05>
   <1.2, 0.7>
    <1.3, 1>
    <1.5, 1.1>
    open
scale <1.5,0.5,1>
translate <0,1,0>
}    
texture{T_Brass_3C}
}





 // Eis             
 // Mittlere Kugel              
#declare Kugel_Farbe1 =  color rgb   <0.1,0.05,0.03>;             
#declare Kugel_Farbe2 =  color rgb  <0.01,0.01,0.01>;              
#declare Sauce_Farbe1 =  color rgb  <0.9,0.8,0.6>;

union {
  
sphere {0,1
     texture {
        pigment {
                granite
                color_map {
                  [0   color rgb Kugel_Farbe1]
                  [1   color rgb Kugel_Farbe2]
                        } 
                 scale <1,0.5,1>
                }
        normal {granite 0.4 scale <1,0.5,1>}
        finish {phong 0.3}
        }
}


#declare R   = 0.25; 
#declare S = 0.6;    
blob {
  threshold 0.4 
#declare i = 1;
#declare I =200;
#while (i < I)  
  sphere { <0,1,0> R, S rotate <rand(R1)*80,0,0> rotate <0,rand(R1)*360,0> }
 #declare i = i+1;   
#end
texture { 
        pigment {color rgb Sauce_Farbe1}
        normal {bumps 0.5 scale 0.2 }
        finish {phong 0.9}
        } 
}  

#declare R   = 0.09; 
#declare S = 0.9;                                   
#declare A = 8;    

blob {
 threshold 0.6 
#declare i = 1;
#declare I =100;
#while (i < I)  
  sphere { <0,1,0> R+2*R*i/I+0.5*R*rand(R1), S translate <0.9*(i/I),(1-i/I)*1.1,0> rotate <0,i*360/A+15*sin(2*i/I*2*pi),0>  }
 #declare i = i+1;   
#end
translate <0,-0.3,0>
texture { 
        pigment {color rgb 1}
        normal {dents 0.5 scale 0.3 }
        finish {phong 0.2 roughness 0.6}
        }                
}

scale 0.65
translate <0,1.6,0>

}  



//ZWEITE KUGEL
#declare Kugel_Farbe1 =  color rgb  <0.9,0.6,0.3>;              
#declare Kugel_Farbe2 =  color rgb  <0.8,0.4,0.2>;              
#declare Sauce_Farbe1 =  color rgb  <0.1,0.05,0.03>;              

union {
  
sphere {0,1
     texture {
        pigment {
                granite
                color_map {
                  [0   color rgb Kugel_Farbe1]
                  [1   color rgb Kugel_Farbe2]
                        } 
                 scale <1,0.5,1>
                }
        normal {granite 0.4 scale <1,0.5,1>}
        finish {phong 0.3}
        }
}


#declare R   = 0.25; 
#declare S = 0.6;    
blob {
  threshold 0.4 
#declare i = 1;
#declare I =200;
#while (i < I)  
  sphere { <0,1,0> R, S rotate <rand(R1)*80,0,0> rotate <0,rand(R1)*360,0> }
 #declare i = i+1;   
#end
texture { 
        pigment {color rgb Sauce_Farbe1}
        normal {bumps 0.5 scale 0.2 }
        finish {phong 0.9}
        } 
}  

#declare R   = 0.09; 
#declare S = 0.9;                                   
#declare A = 8;    


scale 0.65
translate <-1.1,1.7,0>

}

//DRITTE KUGEL
#declare Kugel_Farbe1 =  color rgb  <0.9,0.6,0.3>;              
#declare Kugel_Farbe2 =  color rgb  <0.8,0.4,0.2>;              
#declare Sauce_Farbe1 =  color rgb  <0.1,0.05,0.03>;              

union {
  
sphere {0,1
     texture {
        pigment {
                granite
                color_map {
                  [0   color rgb Kugel_Farbe1]
                  [1   color rgb Kugel_Farbe2]
                        } 
                 scale <1,0.5,1>
                }
        normal {granite 0.4 scale <1,0.5,1>}
        finish {phong 0.3}
        }
}


#declare R   = 0.25; 
#declare S = 0.6;    
blob {
  threshold 0.4 
#declare i = 1;
#declare I =200;
#while (i < I)  
  sphere { <0,1,0> R, S rotate <rand(R1)*80,0,0> rotate <0,rand(R1)*360,0> }
 #declare i = i+1;   
#end
texture { 
        pigment {color rgb Sauce_Farbe1}
        normal {bumps 0.5 scale 0.2 }
        finish {phong 0.9}
        } 
}  

#declare R   = 0.09; 
#declare S = 0.9;                                   
#declare A = 8;    


scale 0.65
translate <1.1,1.7,0>

}


translate <0.9,6,0.9>
}

#end



#if (HoehleTest)




    // vertikale Strukturen
#declare fn_Pigm0=
function {
 pigment {
  spiral2 10
  color_map {
   [0 color rgb 0]
   [1 color rgb 1]
  }         
  rotate <90,0,0>
  turbulence 0.4
   omega 0.4
  scale 25
 }
}

    // grobe Strukturen
#declare fn_Pigm1=
function {
 pigment {
  granite
  color_map {
   [0 color rgb 0]
   [0.2 color rgb 0.4]
   [0.3 color rgb 0.6]
   [1 color rgb 1]
  }
  //turbulence 0.1
 // omega 0.35
  scale 15
 }
}

 

    // feine Strukturen
#declare fn_Pigm2=
function {
 pigment {
  crackle
  color_map {
   [0 color rgb 0]
   [1 color rgb 1]
  }
   omega 0.4
  scale 5
 }
} 



difference{ 
isosurface {
 function {-15*(fn_Pigm0(x,y,z).gray*0.5)-15*(fn_Pigm1(x,y,z).gray*0.5)-15*(fn_Pigm2(x,y,z).gray*0.5)+45-(sqrt(x*x+y*y*4+z*z))}
 contained_by {sphere{ 0, 60} }  
 accuracy 0.01                      
 max_gradient 4                     
 inverse
  }
 plane {y,-5} 
 
 texture{      
  pigment {
   dents
   color_map{
   [0 color rgb <0.5,0.5,0.5>]
   [0.2 color  rgb <0.3,0.3,0.2>]
   [0.4 color rgb <1,1,0.8>]
   [1 color rgb <1,1,0.9>]
   }
  turbulence 0.2
  omega 0.2
  scale 4
  
  }
  normal{ 
  dents 1
  scale 0.05
  }
  finish {
   phong 0.05
  }
 }


no_shadow
}





#end



#if (BodenTest)
  




// Lavaboden

   // grobe Strukturen
#declare fn_Pigm3=
function {
 pigment {
  granite
  color_map {
   [0 color rgb 0]
   [0.2 color rgb 0.4]
   [0.3 color rgb 0.6]
   [1 color rgb 1]
  }
  turbulence 0.1
  omega 0.35
  scale 6
 }
}

    // feine Strukturen
#declare fn_Pigm4=
function {
 pigment {
  crackle
  color_map {
   [0 color rgb 0]
   [1 color rgb 1]
  }
   omega 0.4
  scale 0.4
 }
} 
 
isosurface {
 function {(-4*fn_Pigm3(x,y,z).gray*0.5)-(0.5*fn_Pigm4(x,y,z).gray*0.5) +(y)}
 contained_by {sphere{ 0, 50} }  
 accuracy 0.01                      
 max_gradient 4                     
 
 texture {       // obere Textur
  pigment {
   bozo 
   pigment_map { 
    [0 color rgb 0.02]
    [0.5 color rgb 0.1]
    [0.8 color rgb 0.05]
   }
   scale 1
  } 
  normal {
  bumps 7 
  scale 0.1
  }
 }
 
 texture{      // untere Textur
  pigment {
    gradient y 
   color_map{
   [0 color rgbf 1]
   [0.30 color  rgb <0.5,0.1,0.05>]
   [0.35 color rgb <0.8,0.3,0.1>]
   [0.5 color rgb <1,1,0.3>]
   [0.8 color rgb <1,1,0.4>]
   }
   translate <0,0,0>
  turbulence 0.05
  omega 0.05
  scale -2
 
  }
  normal{ 
  dents 1
  scale 0.05
  }
  finish {
   phong 0.05
   ambient 0.2
  }
 }
    
translate <0,-0.6,0>
no_shadow
}

#else
          
//Boden ersatz
plane {
  y, 0.5
  
  texture {
        pigment {
        
        
                bumps 
                color_map {
                  [0.2   color rgb <1,0,0>]
  
                  [0.9   color rgb <1,1,0>]
                 
                        }
   

                         
                 }
                 
                 
         finish {ambient 0.3} 
         }  no_shadow 
} 

  
#end
   
#if(TischTest)
merge {


#declare i = 1;
#declare I =100;
#while (i < I)  
box {-1 1 rotate <rand(R1)*90,rand(R1)*90,0> scale 1 translate <6*(1-rand(R1)*rand(R1)),1,0>  rotate <0,360*rand(R1)> }
 #declare i = i+1;   
#end
/*
prism {                                
  linear_sweep  
  linear_spline
  -1,        
   1.5,      
  13,       
  < 4,2>, < 6,0>, < 8,3>, < 8,4>, < 7,7>, <7,8>,
  <9, 9>, <7, 13>, <5, 11>, <4,  13>, <0, 7>, <0,5>, <3,5>
 
scale <1/9,1,1/13>  
translate <-0.5,0,-0.5>
scale <15,1,15>


}*/


#declare fn_Pigm5=
function {
 pigment {
  crackle
  color_map {
   [0 color rgb 0]
   [1 color rgb 1]
  }

  scale 1
 }
}
 

isosurface {
 function {(-0.6*fn_Pigm5(x,y,z).gray*0.5) -0.6-(abs(y)-sqrt(x*x+z*z))}
 contained_by {box{-2,2} }  
 accuracy 0.01                      
 max_gradient 4                     
 

translate <0,3.5,0>
}
 

cylinder {<0,5.5,0> <0,6,0> 4}

#declare i = 1;
#declare I =150;
#while (i < I)  
box {-1 1 rotate <rand(R1)*90,rand(R1)*90,0> scale 1/(3+2*i/I) translate <3.8*(1-i/I),5.8,0>  rotate <0,360*rand(R1)> }
 #declare i = i+1;   
#end


#if(TischEISTest)
texture {
  pigment {
  color rgbft <0.9,0.94,1,0.2,0.1>
  } 
  finish {phong 0.2 reflection 0.15 roughness 0.3 ambient 0.2}
  normal {bumps 0.2 turbulence 0.5 scale 0.5 }
  }
  interior {ior 1.7} 
 #else
  texture { pigment {color rgb 0.8} finish {ambient 0.2}}
 
 #end 
  
  
}
#end


#if(LoeffelTest)

//loeffel


union {
 union  {
  difference {
   sphere {0,1}
   sphere {0,0.95}
   plane {-y,0}
   scale <1,0.75,1>
  } 
  torus { 0.975 0.025}
  scale <2.5,1,1>
 }
difference {
prism {                                
  linear_sweep  
 linear_spline 
  -0.05,          0.05,   13,          
   < 1,0.25>, < 3,0.15>, < 6, 0.15>, < 7,0.15>,  < 8 0.3>, <10,0.35>, 
   <10,-0.35>, < 8, -0.3>, < 7,-0.15>,  < 6, -0.15>,  < 3,-0.15>,< 1,-0.25>,
   < 1,0.25>     
}

   sphere {0,0.95 scale <1,0.75,1> scale <2.5,1,1>}

}

texture{T_Gold_3C}
scale 1/3.5 
rotate <0,10,0> 
rotate <0,0,-4>
translate <0,6.3,-2> 
rotate <0,25,0>
}

#end