global_settings
{
  noise_generator 3
  //radiosity {}
}

#declare m = 10;
#declare cm = m/100;
#declare mm = cm/10;

#include "functions.inc"

// ImPure...
#include "colors.inc"
#include "woods.inc"
#include "stones.inc"
// ... ImPure

camera
{
  location <0, +25*cm, -45*cm>
  look_at <0, 0, 0>
}

// Top light
light_source {<-5*cm, +45*cm, -45*cm>, colour rgb <0.4, 0.4, 0.4>}

// Candle body
object
{
  isosurface
  {
    function {x*x + (1-cos(max(y, 0)*pi)) + z*z - 0.1 - f_bozo(x*10, y*10, z*10)*0.1}
    contained_by {box {-1, +1}}
    max_gradient 4
  }
  hollow
  scale 20*cm
  // ImPure...
  texture // Gail Shaw, with modifications
  {
    pigment {rgbt <0.95, 0.95, 1, 0.9>}
    finish
    {
      ambient 0
      diffuse 0.55
      roughness 0.008
      specular 0.6
      reflection {0,0.2}
    }
    normal {granite 0.1  scale 1*cm}
  }
  // ...ImPure
  interior
  {
    ior 1.3
    media {scattering {1, 1}}
  }
}

// Wick
object
{
  cone {<0, 0, +1*mm>, 1*mm, <0, +6*cm, +5*mm>, 1*mm}
  no_shadow
  texture
  {
    pigment
    {
      gradient y
      colour_map
      {
        [0.0 colour rgb 1]
        [0.8 colour rgb 1]
        [0.9 colour rgb 0]
        [1.0 colour rgb 0]
      }
      scale 6*cm
    }
    finish {ambient 0  diffuse 1}
  }
}

// Flame
light_source
{
  <0, +6*cm, 0>, colour rgb <0.9, 0.8, 0.5>
  //area_light x*5*mm, z*5*mm, 17, 17  adaptive 1  circular  orient
  fade_power 2  fade_distance 30*cm
}

object
{
  sphere {<0, 0, 0>, 5*mm}
  scale <1, 3, 1>
  translate +6*cm*y
  no_shadow
  hollow
  texture {pigment {rgbt 1}}
  interior
  {
    media // Yellow
    {
      emission 18
      density
      {
        spherical
        colour_map
        {
          [0 colour rgb 0]
          [1 colour rgb <0.9, 0.8, 0.5>]
        }
        scale 12*mm
        translate +6.5*cm*y
      }
    }
    media // Blue
    {
      emission 30
      density
      {
        spherical
        colour_map
        {
          [0 colour rgb 0]
          [1 colour rgb <0, 0.1, 0.8>]
        }
        scale 5*mm
        translate +5.5*cm*y
      }
    }
  }
  
  // Quick hack: I have a deadline! :-/
  translate -6*cm*y
  scale 1.5
  translate +6.5*cm*y
}

// Marble stand
object
{
  union
  {
    box {<-30*cm, -30*cm, -30*cm>, <+30*cm, -20*cm, +30*cm>}
    cylinder {<-30*cm, -25*cm, -30*cm>, <-30*cm, -25*cm, +30*cm>, 5*cm}
    cylinder {<+30*cm, -25*cm, -30*cm>, <+30*cm, -25*cm, +30*cm>, 5*cm}
    cylinder {<-30*cm, -25*cm, +30*cm>, <+30*cm, -25*cm, +30*cm>, 5*cm}
    sphere {<-30*cm, -25*cm, +30*cm>, 5*cm}
    sphere {<+30*cm, -25*cm, +30*cm>, 5*cm}
  }
  texture {T_Stone13  scale 5*cm  rotate 30*y}
}

// Walls
object
{
  box {<-50*cm, -30*cm, -50*cm>, <+50*cm, +50*cm, +50*cm>}
  hollow
  texture {T_Wood17  scale 10*cm rotate +91*x  rotate +2*z}
}

#declare T_Ice =
texture
{
  pigment {colour rgbt <1, 1, 1, 0>}
  finish {ambient 0  brilliance 1  specular 0.8}
}

#declare Crystal = 10;

// Ice floor
object
{
  isosurface
  {
    function {y + 22*cm - f_crackle(x*Crystal, 0, z*Crystal)*0.2}
    contained_by {box {<-50*cm, -30*cm, -50*cm>, <+50*cm, -20*cm, +50*cm>}}
    max_gradient 2.25
  }
  texture {T_Ice}
}

// Icey back wall
object
{
  isosurface
  {
    function {-z + 51*cm - f_crackle(x*Crystal, y*Crystal, 0)*0.2 - (x*x + y*y)*0.005}
    contained_by {box {<-50*cm, -30*cm, +48*cm>, <+50*cm, +50*cm, +50*cm>}}
    max_gradient 2.25
  }
  texture {T_Ice}
}

// Ice left wall
object
{
  isosurface
  {
    function {+x + 51*cm - f_crackle(0, y*Crystal, z*Crystal)*0.2 - (y*y + z*z)*0.005}
    contained_by {box {<-50*cm, -30*cm, -50*cm>, <-49*cm, +50*cm, +50*cm>}}
    max_gradient 2.25
  }
  texture {T_Ice}
}

// Ice right wall
object
{
  isosurface
  {
    function {-x + 51*cm - f_crackle(0, y*Crystal, z*Crystal)*0.2 - (y*y + z*z)*0.005}
    contained_by {box {<+50*cm, -30*cm, -50*cm>, <+49*cm, +50*cm, +50*cm>}}
    max_gradient 2.25
  }
  texture {T_Ice}
}

