/*************** Tree made by: ******************

Arbaro 2.0 - creates trees objects for rendering from xml parameter files
(c) 2003-2004 by Wolfram Diestel <diestel@steloj.de> (GPL see file COPYING)


<?xml version='1.0' ?>

<arbaro>
  <species name='my_quaking_aspen'>
    <!-- general params -->
    <param name='Shape' value='7'/>
    <param name='Levels' value='3'/>
    <param name='Scale' value='13.0'/>
    <param name='ScaleV' value='3.0'/>
    <param name='BaseSize' value='0.25'/>
    <param name='Ratio' value='0.015'/>
    <param name='RatioPower' value='1.2'/>
    <param name='Flare' value='0.6'/>
    <param name='Lobes' value='5'/>
    <param name='LobeDepth' value='0.07'/>
    <param name='Smooth' value='0.5'/>
    <param name='Leaves' value='0'/>
    <param name='LeafShape' value='0'/>
    <param name='LeafScale' value='0.17'/>
    <param name='LeafScaleX' value='1.0'/>
    <param name='LeafQuality' value='1.0'/>
    <param name='LeafStemLen' value='0.5'/>
    <param name='LeafDistrib' value='4'/>
    <param name='LeafBend' value='0.3'/>
    <param name='AttractionUp' value='0.5'/>
    <param name='PruneRatio' value='0.0'/>
    <param name='PrunePowerLow' value='0.5'/>
    <param name='PrunePowerHigh' value='0.5'/>
    <param name='PruneWidth' value='0.5'/>
    <param name='PruneWidthPeak' value='0.5'/>
    <param name='0Scale' value='1.0'/>
    <param name='0ScaleV' value='0.2'/>
    <param name='0BaseSplits' value='0'/>
    <!-- level 0 -->
    <param name='0DownAngle' value='0.0'/>
    <param name='0DownAngleV' value='0.0'/>
    <param name='0Rotate' value='0.0'/>
    <param name='0RotateV' value='0.0'/>
    <param name='0Branches' value='1'/>
    <param name='0BranchDist' value='0.0'/>
    <param name='0Length' value='1.0'/>
    <param name='0LengthV' value='0.0'/>
    <param name='0Taper' value='1.0'/>
    <param name='0SegSplits' value='0.0'/>
    <param name='0SplitAngle' value='0.0'/>
    <param name='0SplitAngleV' value='0.0'/>
    <param name='0CurveRes' value='3'/>
    <param name='0Curve' value='0.0'/>
    <param name='0CurveBack' value='0.0'/>
    <param name='0CurveV' value='20.0'/>
    <!-- level 1 -->
    <param name='1DownAngle' value='60.0'/>
    <param name='1DownAngleV' value='-50.0'/>
    <param name='1Rotate' value='140.0'/>
    <param name='1RotateV' value='0.0'/>
    <param name='1Branches' value='60'/>
    <param name='1BranchDist' value='1.0'/>
    <param name='1Length' value='0.3'/>
    <param name='1LengthV' value='0.0'/>
    <param name='1Taper' value='1.0'/>
    <param name='1SegSplits' value='0.0'/>
    <param name='1SplitAngle' value='0.0'/>
    <param name='1SplitAngleV' value='0.0'/>
    <param name='1CurveRes' value='5'/>
    <param name='1Curve' value='-40.0'/>
    <param name='1CurveBack' value='0.0'/>
    <param name='1CurveV' value='50.0'/>
    <!-- level 2 -->
    <param name='2DownAngle' value='45.0'/>
    <param name='2DownAngleV' value='10.0'/>
    <param name='2Rotate' value='140.0'/>
    <param name='2RotateV' value='0.0'/>
    <param name='2Branches' value='30'/>
    <param name='2BranchDist' value='1.0'/>
    <param name='2Length' value='0.6'/>
    <param name='2LengthV' value='0.0'/>
    <param name='2Taper' value='1.0'/>
    <param name='2SegSplits' value='0.0'/>
    <param name='2SplitAngle' value='0.0'/>
    <param name='2SplitAngleV' value='0.0'/>
    <param name='2CurveRes' value='3'/>
    <param name='2Curve' value='-40.0'/>
    <param name='2CurveBack' value='0.0'/>
    <param name='2CurveV' value='75.0'/>
    <!-- level 3 -->
    <param name='3DownAngle' value='45.0'/>
    <param name='3DownAngleV' value='10.0'/>
    <param name='3Rotate' value='77.0'/>
    <param name='3RotateV' value='0.0'/>
  </species>
</arbaro>
************************************************/
#declare my_quaking_aspen_13_height = 14.77107;
#declare my_quaking_aspen_13_stems = 
  mesh2 {
    vertex_vectors { 17295
    /* stem 0*/ 
    /*0*/ <0,0,0>,
    /*1*/ <0.32627,0,-0.01139>,<0.2941,0,0.08433>,<0.22998,0,0.15512>,
            <0.18568,0,0.23766>,<0.11037,0,0.30325>,<0.01054,0,0.30171>,
            <-0.07888,0,0.27508>,<-0.1667,0,0.24715>,<-0.25757,0,0.20124>,
            <-0.29213,0,0.10633>,<-0.28556,0,0.00997>,<-0.29254,0,-0.08388>,
            <-0.26415,0,-0.17817>,<-0.18741,0,-0.23987>,<-0.09802,0,-0.2693>,
            <-0.01042,0,-0.2984>,<0.08867,0,-0.30924>,<0.17165,0,-0.25449>,
            <0.22616,0,-0.17669>,<0.28117,0,-0.10234>,
    /*2*/ <0.31634,0.00825,-0.01105>,<0.29316,0.00825,0.08406>,<0.22828,0.00825,0.15397>,
            <0.17915,0.00825,0.2293>,<0.11113,0.00825,0.30532>,<0.0107,0.00825,0.30653>,
            <-0.07822,0.00825,0.2728>,<-0.16443,0.00825,0.24378>,<-0.25632,0.00825,0.20026>,
            <-0.28706,0.00825,0.10448>,<-0.27772,0.00825,0.0097>,<-0.28727,0.00825,-0.08237>,
            <-0.26641,0.00825,-0.1797>,<-0.18609,0.00825,-0.23818>,<-0.09643,0.00825,-0.26494>,
            <-0.01052,0.00825,-0.30124>,<0.08936,0.00825,-0.31163>,<0.16676,0.00825,-0.24723>,
            <0.2166,0.00825,-0.16923>,<0.27864,0.00825,-0.10142>,
    /*3*/ <0.32273,0.01649,-0.01127>,<0.29061,0.01649,0.08333>,<0.22702,0.01649,0.15313>,
            <0.17974,0.01649,0.23006>,<0.10702,0.01649,0.29404>,<0.01041,0.01649,0.298>,
            <-0.0761,0.01649,0.26539>,<-0.16221,0.01649,0.24048>,<-0.25067,0.01649,0.19585>,
            <-0.27888,0.01649,0.1015>,<-0.27485,0.01649,0.0096>,<-0.28347,0.01649,-0.08128>,
            <-0.26806,0.01649,-0.18081>,<-0.18578,0.01649,-0.23779>,<-0.09574,0.01649,-0.26304>,
            <-0.01033,0.01649,-0.29594>,<0.08839,0.01649,-0.30825>,<0.17065,0.01649,-0.253>,
            <0.21407,0.01649,-0.16725>,<0.27429,0.01649,-0.09983>,
    /*4*/ <0.30628,0.03299,-0.0107>,<0.28188,0.03299,0.08083>,<0.22267,0.03299,0.15019>,
            <0.17971,0.03299,0.23002>,<0.10636,0.03299,0.29221>,<0.01038,0.03299,0.2972>,
            <-0.07595,0.03299,0.26488>,<-0.15937,0.03299,0.23627>,<-0.24783,0.03299,0.19363>,
            <-0.27873,0.03299,0.10145>,<-0.27487,0.03299,0.0096>,<-0.27289,0.03299,-0.07825>,
            <-0.25807,0.03299,-0.17407>,<-0.18351,0.03299,-0.23488>,<-0.09161,0.03299,-0.25169>,
            <-0.00992,0.03299,-0.28396>,<0.08619,0.03299,-0.30057>,<0.16607,0.03299,-0.24621>,
            <0.21093,0.03299,-0.16479>,<0.26802,0.03299,-0.09755>,
    /*5*/ <0.29968,0.06598,-0.01046>,<0.26917,0.06598,0.07718>,<0.21396,0.06598,0.14432>,
            <0.1701,0.06598,0.21772>,<0.10458,0.06598,0.28734>,<0.00989,0.06598,0.28333>,
            <-0.07203,0.06598,0.25121>,<-0.15713,0.06598,0.23296>,<-0.23537,0.06598,0.18389>,
            <-0.27123,0.06598,0.09872>,<-0.26371,0.06598,0.00921>,<-0.26518,0.06598,-0.07604>,
            <-0.24973,0.06598,-0.16845>,<-0.17826,0.06598,-0.22816>,<-0.08929,0.06598,-0.24533>,
            <-0.0097,0.06598,-0.2778>,<0.08326,0.06598,-0.29036>,<0.16064,0.06598,-0.23817>,
            <0.20931,0.06598,-0.16353>,<0.26335,0.06598,-0.09585>,
    /*6*/ <0.2812,0.13196,-0.00982>,<0.26045,0.13196,0.07468>,<0.20289,0.13196,0.13685>,
            <0.15851,0.13196,0.20288>,<0.09629,0.13196,0.26456>,<0.00927,0.13196,0.26555>,
            <-0.06856,0.13196,0.23911>,<-0.14362,0.13196,0.21293>,<-0.22505,0.13196,0.17583>,
            <-0.25392,0.13196,0.09242>,<-0.24944,0.13196,0.00871>,<-0.25064,0.13196,-0.07187>,
            <-0.23325,0.13196,-0.15733>,<-0.16347,0.13196,-0.20923>,<-0.08508,0.13196,-0.23375>,
            <-0.00905,0.13196,-0.25926>,<0.07649,0.13196,-0.26675>,<0.14915,0.13196,-0.22113>,
            <0.19641,0.13196,-0.15346>,<0.24657,0.13196,-0.08974>,
    /*7*/ <0.25291,0.26391,-0.00883>,<0.22704,0.26391,0.0651>,<0.1799,0.26391,0.12134>,
            <0.14484,0.26391,0.18539>,<0.08576,0.26391,0.23562>,<0.00847,0.26391,0.24265>,
            <-0.06034,0.26391,0.21045>,<-0.13091,0.26391,0.19408>,<-0.20209,0.26391,0.15789>,
            <-0.22816,0.26391,0.08304>,<-0.21727,0.26391,0.00759>,<-0.22344,0.26391,-0.06407>,
            <-0.20818,0.26391,-0.14042>,<-0.14713,0.26391,-0.18832>,<-0.07481,0.26391,-0.20553>,
            <-0.00802,0.26391,-0.22966>,<0.06855,0.26391,-0.23908>,<0.13167,0.26391,-0.19521>,
            <0.17257,0.26391,-0.13482>,<0.22172,0.26391,-0.0807>,
    /*8*/ <0.21825,0.52782,-0.00762>,<0.19789,0.52782,0.05674>,<0.15682,0.52782,0.10578>,
            <0.12315,0.52782,0.15763>,<0.07361,0.52782,0.20224>,<0.00732,0.52782,0.20963>,
            <-0.05237,0.52782,0.18262>,<-0.11233,0.52782,0.16653>,<-0.17485,0.52782,0.13661>,
            <-0.19572,0.52782,0.07124>,<-0.1937,0.52782,0.00676>,<-0.19639,0.52782,-0.05631>,
            <-0.17825,0.52782,-0.12023>,<-0.12849,0.52782,-0.16446>,<-0.06591,0.52782,-0.1811>,
            <-0.00694,0.52782,-0.19864>,<0.05917,0.52782,-0.20637>,<0.11729,0.52782,-0.17389>,
            <0.15174,0.52782,-0.11855>,<0.19216,0.52782,-0.06994>,
    /*9*/ <0.18726,1.05564,-0.00654>,<0.1761,1.05564,0.0505>,<0.13553,1.05564,0.09141>,
            <0.10699,1.05564,0.13694>,<0.06458,1.05564,0.17743>,<0.00637,1.05564,0.18245>,
            <-0.04619,1.05564,0.16108>,<-0.09865,1.05564,0.14626>,<-0.14971,1.05564,0.11696>,
            <-0.16862,1.05564,0.06137>,<-0.16739,1.05564,0.00585>,<-0.16694,1.05564,-0.04787>,
            <-0.15773,1.05564,-0.10639>,<-0.11225,1.05564,-0.14367>,<-0.05567,1.05564,-0.15295>,
            <-0.00614,1.05564,-0.17572>,<0.05307,1.05564,-0.18506>,<0.1023,1.05564,-0.15166>,
            <0.1295,1.05564,-0.10117>,<0.1678,1.05564,-0.06107>,
    /*10*/ <0.17011,2.11128,-0.00594>,<0.15137,2.11128,0.0434>,<0.12435,2.11128,0.08387>,
            <0.09584,2.11128,0.12267>,<0.05744,2.11128,0.15781>,<0.00564,2.11128,0.16137>,
            <-0.04076,2.11128,0.14214>,<-0.08826,2.11128,0.13086>,<-0.13355,2.11128,0.10434>,
            <-0.15159,2.11128,0.05518>,<-0.14996,2.11128,0.00524>,<-0.15103,2.11128,-0.04331>,
            <-0.13815,2.11128,-0.09319>,<-0.10029,2.11128,-0.12836>,<-0.05048,2.11128,-0.1387>,
            <-0.00551,2.11128,-0.15779>,<0.04732,2.11128,-0.16503>,<0.09063,2.11128,-0.13436>,
            <0.11667,2.11128,-0.09115>,<0.14567,2.11128,-0.05302>,
    /*11*/ <0.13774,4.22256,-0.00481>,<0.12184,4.22256,0.03494>,<0.09923,4.22256,0.06693>,
            <0.07727,4.22256,0.09891>,<0.04571,4.22256,0.12559>,<0.0044,4.22256,0.12612>,
            <-0.03276,4.22256,0.11425>,<-0.07007,4.22256,0.10388>,<-0.10803,4.22256,0.0844>,
            <-0.12148,4.22256,0.04421>,<-0.11705,4.22256,0.00409>,<-0.12139,4.22256,-0.03481>,
            <-0.1122,4.22256,-0.07568>,<-0.0785,4.22256,-0.10047>,<-0.03969,4.22256,-0.10906>,
            <-0.00442,4.22256,-0.12666>,<0.03739,4.22256,-0.1304>,<0.07173,4.22256,-0.10634>,
            <0.09302,4.22256,-0.07268>,<0.11886,4.22256,-0.04326>,
    /*12*/ <0.16793,8.44236,0.00576>,<0.16196,8.44246,0.02663>,<0.14424,8.44284,0.03957>,
            <0.13341,8.44307,0.05386>,<0.12186,8.44329,0.07446>,<0.10006,8.4438,0.07421>,
            <0.08124,8.44425,0.06586>,<0.06453,8.44465,0.0575>,<0.03984,8.44523,0.05348>,
            <0.03502,8.44539,0.03106>,<0.03845,8.44535,0.01029>,<0.03484,8.44547,-0.00983>,
            <0.03975,8.4454,-0.03092>,<0.05985,8.44495,-0.04032>,<0.07605,8.4446,-0.05144>,
            <0.09539,8.44417,-0.05967>,<0.11642,8.44368,-0.05688>,<0.1321,8.44328,-0.04271>,
            <0.14514,8.44296,-0.02881>,<0.16042,8.44257,-0.0146>,
    /*13*/ <-0.09157,12.65541,-0.23267>

    /* stem 0.0*/ 
    /*0*/ <0,3.21626,0>,
    /*1*/ <-0.01525,3.21626,0.0128>,<-0.00065,3.23411,0.00879>,<0.01485,3.2273,-0.00736>,
            <0.00983,3.20523,-0.01334>,<-0.00877,3.19841,-0.00088>,
    /*2*/ <0.22208,3.08733,0.28944>,<0.23376,3.10161,0.28624>,<0.24616,3.09616,0.27332>,
            <0.24215,3.07851,0.26853>,<0.22726,3.07305,0.2785>,
    /*3*/ <0.44505,3.06473,0.60275>,<0.45231,3.07598,0.5985>,<0.46307,3.07149,0.59068>,
            <0.46247,3.05747,0.59009>,<0.45132,3.0533,0.59755>,
    /*4*/ <0.68552,3.06446,0.90626>,<0.68995,3.07196,0.90283>,<0.69696,3.06894,0.8974>,
            <0.69685,3.05958,0.89747>,<0.68978,3.05681,0.90295>,
    /*5*/ <0.92992,3.07822,1.20568>,<0.93203,3.08197,1.20382>,<0.93552,3.08045,1.2011>,
            <0.93557,3.07578,1.20127>,<0.93211,3.0744,1.2041>,
    /*6*/ <1.19239,3.11216,1.48787>

    /* stem 0.0.0*/ 
    /*0*/ <0.1113,3.15501,0.13264>,
    /*1*/ <0.11858,3.1611,0.12934>,<0.1136,3.14588,0.13617>,<0.10172,3.15805,0.13242>,
            
    /*2*/ <0.15227,3.2975,0.46577>,<0.14894,3.28735,0.47032>,<0.14103,3.29547,0.46782>,
            
    /*3*/ <0.2501,3.49808,0.7517>,<0.24894,3.49364,0.75526>,<0.24479,3.4975,0.75398>,
            
    /*4*/ <0.41158,3.64264,1.04477>

    /* stem 0.0.1*/ 
    /*0*/ <0.14398,3.13703,0.17159>,
    /*1*/ <0.14059,3.1279,0.17021>,<0.14617,3.14015,0.18066>,<0.14517,3.14305,0.16389>,
            
    /*2*/ <0.47729,3.01268,0.13012>,<0.48101,3.02084,0.13708>,<0.48034,3.02278,0.12591>,
            
    /*3*/ <0.83589,2.98418,0.1393>,<0.8362,2.98866,0.14278>,<0.8364,2.98941,0.13715>,
            
    /*4*/ <1.12356,3.08005,0.33224>

    /* stem 0.0.2*/ 
    /*0*/ <0.17608,3.11936,0.20985>,
    /*1*/ <0.17418,3.12722,0.21507>,<0.18512,3.11612,0.20914>,<0.16894,3.11475,0.20532>,
            
    /*2*/ <0.12471,2.92357,0.49758>,<0.132,2.91617,0.49363>,<0.12122,2.91525,0.49108>,
            
    /*3*/ <0.18649,2.84442,0.83263>,<0.19033,2.84072,0.83109>,<0.18504,2.83914,0.8317>,
            
    /*4*/ <0.19468,2.92464,1.17348>

    /* stem 0.0.3*/ 
    /*0*/ <0.21955,3.09544,0.26165>,
    /*1*/ <0.22559,3.09243,0.25518>,<0.21782,3.09024,0.26921>,<0.21523,3.10366,0.26054>,
            
    /*2*/ <0.47957,3.25013,0.42364>,<0.47438,3.24867,0.43299>,<0.47266,3.25762,0.42721>,
            
    /*3*/ <0.74168,3.40084,0.58545>,<0.73923,3.40009,0.5902>,<0.73836,3.40462,0.5874>,
            
    /*4*/ <0.98486,3.55508,0.77258>

    /* stem 0.0.4*/ 
    /*0*/ <0.27344,3.0833,0.33543>,
    /*1*/ <0.26638,3.08033,0.34013>,<0.27867,3.08978,0.33879>,<0.27526,3.07979,0.32736>,
            
    /*2*/ <0.46085,2.8516,0.48186>,<0.46904,2.8579,0.48097>,<0.46677,2.85124,0.47334>,
            
    /*3*/ <0.76987,2.84607,0.61121>,<0.77091,2.85064,0.60898>,<0.77191,2.84623,0.60644>,
            
    /*4*/ <1.04161,3.01778,0.69821>

    /* stem 0.0.5*/ 
    /*0*/ <0.3289,3.07758,0.41507>,
    /*1*/ <0.33275,3.08497,0.41292>,<0.33342,3.07132,0.41886>,<0.32053,3.07645,0.41342>,
            
    /*2*/ <0.25855,3.20412,0.70085>,<0.259,3.19502,0.70482>,<0.2504,3.19844,0.70119>,
            
    /*3*/ <0.36877,3.374,0.94586>,<0.36948,3.36984,0.94847>,<0.36514,3.37223,0.94876>,
            
    /*4*/ <0.52231,3.56654,1.14992>

    /* stem 0.0.6*/ 
    /*0*/ <0.42057,3.06813,0.5467>,
    /*1*/ <0.42137,3.06026,0.54558>,<0.41815,3.07093,0.55378>,<0.42219,3.07319,0.54074>,
            
    /*2*/ <0.70744,3.07889,0.63745>,<0.7053,3.086,0.64292>,<0.70799,3.08751,0.63423>,
            
    /*3*/ <0.94678,3.17686,0.7947>,<0.94422,3.18021,0.79656>,<0.9465,3.18097,0.79262>,
            
    /*4*/ <1.10629,3.34931,0.98434>

    /* stem 0.0.7*/ 
    /*0*/ <0.47711,3.06457,0.62462>,
    /*1*/ <0.47256,3.06955,0.62816>,<0.48466,3.06495,0.6256>,<0.47412,3.05921,0.6201>,
            
    /*2*/ <0.4538,2.88846,0.85322>,<0.46187,2.8854,0.85151>,<0.45484,2.88157,0.84785>,
            
    /*3*/ <0.46855,2.83349,1.13545>,<0.47262,2.8319,1.13496>,<0.46916,2.82921,1.13461>,
            
    /*4*/ <0.53319,2.89987,1.40912>

    /* stem 0.0.8*/ 
    /*0*/ <0.53174,3.06451,0.69504>,
    /*1*/ <0.5375,3.06441,0.69058>,<0.53194,3.06082,0.70132>,<0.5258,3.06831,0.69323>,
            
    /*2*/ <0.63939,3.28882,0.82088>,<0.63569,3.28642,0.82804>,<0.63159,3.29141,0.82265>,
            
    /*3*/ <0.71547,3.53376,0.93047>,<0.71366,3.53273,0.93412>,<0.71144,3.53473,0.93117>,
            
    /*4*/ <0.86692,3.74809,1.02269>

    /* stem 0.0.9*/ 
    /*0*/ <0.59898,3.06444,0.78171>,
    /*1*/ <0.59477,3.0601,0.78497>,<0.6023,3.06931,0.78524>,<0.59986,3.06392,0.77491>,
            
    /*2*/ <0.79897,2.89458,0.82314>,<0.804,2.90073,0.82332>,<0.80237,2.89713,0.81644>,
            
    /*3*/ <1.03842,2.8441,0.92914>,<1.03948,2.84789,0.92863>,<1.04019,2.84523,0.92577>,
            
    /*4*/ <1.26625,2.90642,1.05189>

    /* stem 0.0.10*/ 
    /*0*/ <0.67533,3.06437,0.88013>,
    /*1*/ <0.67628,3.07067,0.8794>,<0.68034,3.06041,0.8807>,<0.66936,3.06202,0.8803>,
            
    /*2*/ <0.67124,3.0982,1.1285>,<0.67395,3.09137,1.12936>,<0.66663,3.09244,1.1291>,
            
    /*3*/ <0.7197,3.17608,1.36069>,<0.72119,3.17279,1.36151>,<0.71758,3.17338,1.36207>,
            
    /*4*/ <0.81611,3.29039,1.56134>

    /* stem 0.0.11*/ 
    /*0*/ <0.7259,3.0663,0.94403>,
    /*1*/ <0.72834,3.06097,0.94232>,<0.72532,3.06763,0.94997>,<0.72403,3.0703,0.9398>,
            
    /*2*/ <0.94636,3.16341,0.94166>,<0.94434,3.16786,0.94676>,<0.94348,3.16964,0.93998>,
            
    /*3*/ <1.16055,3.27393,0.94475>,<1.15944,3.27606,0.94734>,<1.159,3.27701,0.94397>,
            
    /*4*/ <1.37691,3.37971,0.94657>

    /* stem 0.0.12*/ 
    /*0*/ <0.82397,3.07192,1.06674>,
    /*1*/ <0.81988,3.07389,1.06992>,<0.82889,3.07446,1.06666>,<0.82313,3.0674,1.06363>,
            
    /*2*/ <0.88987,2.94508,1.23665>,<0.89588,2.94546,1.23449>,<0.89204,2.94075,1.23246>,
            
    /*3*/ <1.06197,2.94319,1.37808>,<1.06395,2.94401,1.37571>,<1.0634,2.94092,1.37634>,
            
    /*4*/ <1.24055,3.02959,1.47797>

    /* stem 0.0.13*/ 
    /*0*/ <0.88482,3.0754,1.14288>,
    /*1*/ <0.88831,3.07697,1.14001>,<0.88577,3.07214,1.14623>,<0.88038,3.0771,1.14238>,
            
    /*2*/ <0.93066,3.2299,1.27803>,<0.92897,3.22668,1.28218>,<0.92538,3.22999,1.27961>,
            
    /*3*/ <0.96582,3.36039,1.43971>,<0.96482,3.35851,1.44147>,<0.96313,3.36038,1.44033>,
            
    /*4*/ <1.03724,3.51063,1.56774>

    /* stem 0.0.14*/ 
    /*0*/ <0.97114,3.08316,1.24502>,
    /*1*/ <0.97,3.08027,1.2464>,<0.97213,3.08572,1.24702>,<0.97128,3.08349,1.24164>,
            
    /*2*/ <1.15129,3.01058,1.24664>,<1.15271,3.01421,1.24705>,<1.15214,3.01272,1.24347>,
            
    /*3*/ <1.31289,2.96556,1.34395>,<1.31338,2.96746,1.34403>,<1.31398,2.96635,1.34253>,
            
    /*4*/ <1.45753,2.98144,1.47284>

    /* stem 0.0.15*/ 
    /*0*/ <1.01456,3.08885,1.29268>,
    /*1*/ <1.0141,3.09154,1.29278>,<1.01709,3.08789,1.29304>,<1.01249,3.08713,1.29222>,
            
    /*2*/ <0.98348,3.07841,1.47624>,<0.98548,3.07597,1.47641>,<0.98242,3.07547,1.47586>,
            
    /*3*/ <0.99315,3.11352,1.6587>,<0.99417,3.11233,1.65888>,<0.99262,3.11207,1.65901>,
            
    /*4*/ <0.98946,3.16025,1.8391>

    /* stem 0.0.16*/ 
    /*0*/ <1.09908,3.09993,1.38545>,
    /*1*/ <1.09993,3.09899,1.38478>,<1.0989,3.09986,1.38687>,<1.0984,3.10094,1.38469>,
            
    /*2*/ <1.23317,3.20437,1.40707>,<1.23249,3.20495,1.40846>,<1.23216,3.20567,1.407>,
            
    /*3*/ <1.34024,3.33363,1.44251>,<1.33978,3.33383,1.44317>,<1.33962,3.33416,1.44243>,
            
    /*4*/ <1.42333,3.4724,1.49928>

    /* stem 0.0.17*/ 
    /*0*/ <1.14891,3.10646,1.44015>,
    /*1*/ <1.14842,3.10648,1.44059>,<1.14943,3.10687,1.44021>,<1.14888,3.10603,1.43963>,
            
    /*2*/ <1.22613,2.99517,1.52977>,<1.22681,2.99543,1.52951>,<1.22644,2.99487,1.52913>,
            
    /*3*/ <1.33203,2.94564,1.64254>,<1.33231,2.94582,1.64235>,<1.33223,2.94546,1.64227>,
            
    /*4*/ <1.44012,2.99847,1.75166>

    /* stem 0.1*/ 
    /*0*/ <0,3.38179,0>,
    /*1*/ <0.0037,3.38179,-0.02096>,<-0.00493,3.40107,-0.00755>,<-0.00674,3.3937,0.01629>,
            <0.00076,3.36988,0.01762>,<0.00721,3.36251,-0.00541>,
    /*2*/ <-0.38038,3.25728,-0.08436>,<-0.38728,3.2727,-0.07363>,<-0.38873,3.26681,-0.05456>,
            <-0.38273,3.24775,-0.0535>,<-0.37757,3.24186,-0.07192>,
    /*3*/ <-0.77333,3.19233,-0.17184>,<-0.77723,3.20423,-0.16358>,<-0.77973,3.19953,-0.14954>,
            <-0.77738,3.18471,-0.14913>,<-0.77342,3.18026,-0.16291>,
    /*4*/ <-1.16375,3.17599,-0.28843>,<-1.16582,3.18402,-0.28282>,<-1.16851,3.18082,-0.27372>,
            <-1.1681,3.17082,-0.27371>,<-1.16515,3.16784,-0.2828>,
    /*5*/ <-1.55623,3.22363,-0.39293>,<-1.55658,3.22761,-0.38992>,<-1.55803,3.22601,-0.38541>,
            <-1.55857,3.22104,-0.38563>,<-1.55746,3.21957,-0.39028>,
    /*6*/ <-1.93616,3.32982,-0.49952>

    /* stem 0.1.0*/ 
    /*0*/ <-0.15733,3.33069,-0.02774>,
    /*1*/ <-0.16086,3.33733,-0.01992>,<-0.16021,3.32023,-0.02769>,<-0.15091,3.33451,-0.03561>,
            
    /*2*/ <-0.4727,3.4202,-0.23644>,<-0.47226,3.4088,-0.24161>,<-0.46606,3.41832,-0.24689>,
            
    /*3*/ <-0.84879,3.47921,-0.30282>,<-0.84931,3.47345,-0.30524>,<-0.8479,3.4783,-0.30895>,
            
    /*4*/ <-1.23716,3.48041,-0.30026>

    /* stem 0.1.1*/ 
    /*0*/ <-0.24025,3.30375,-0.04236>,
    /*1*/ <-0.23684,3.29391,-0.04361>,<-0.24815,3.30735,-0.04826>,<-0.23577,3.31,-0.03522>,
            
    /*2*/ <-0.48586,3.17826,0.21613>,<-0.4934,3.18722,0.21303>,<-0.48515,3.18898,0.22173>,
            
    /*3*/ <-0.81141,3.12276,0.4027>,<-0.81374,3.12777,0.40021>,<-0.81078,3.12811,0.40548>,
            
    /*4*/ <-1.16759,3.23839,0.46444>

    /* stem 0.1.2*/ 
    /*0*/ <-0.28852,3.28807,-0.05087>,
    /*1*/ <-0.2903,3.29656,-0.05641>,<-0.29526,3.28512,-0.04368>,<-0.28001,3.28254,-0.05253>,
            
    /*2*/ <-0.47106,3.09056,-0.30764>,<-0.47436,3.08293,-0.29915>,<-0.4642,3.08121,-0.30505>,
            
    /*3*/ <-0.75145,3.13136,-0.54223>,<-0.75463,3.12738,-0.53917>,<-0.75115,3.12559,-0.54364>,
            
    /*4*/ <-1.05743,3.28449,-0.68563>

    /* stem 0.1.3*/ 
    /*0*/ <-0.35002,3.2681,-0.06172>,
    /*1*/ <-0.35063,3.26483,-0.05226>,<-0.35375,3.26254,-0.06919>,<-0.34569,3.27692,-0.06371>,
            
    /*2*/ <-0.67202,3.4322,-0.01864>,<-0.6741,3.43067,-0.02993>,<-0.66873,3.44026,-0.02627>,
            
    /*3*/ <-1.0234,3.52163,0.00777>,<-1.02412,3.52067,0.00211>,<-1.02263,3.52594,0.00398>,
            
    /*4*/ <-1.34425,3.64519,-0.11569>

    /* stem 0.1.4*/ 
    /*0*/ <-0.4262,3.25018,-0.07761>,
    /*1*/ <-0.42362,3.24698,-0.08641>,<-0.43358,3.25642,-0.07669>,<-0.42141,3.24713,-0.06973>,
            
    /*2*/ <-0.64996,2.97669,-0.05111>,<-0.6566,2.98299,-0.04463>,<-0.64848,2.97679,-0.03999>,
            
    /*3*/ <-0.95401,2.79539,-0.02338>,<-0.95621,2.79948,-0.02024>,<-0.95346,2.79524,-0.0178>,
            
    /*4*/ <-1.29689,2.7917,-0.11162>

    /* stem 0.1.5*/ 
    /*0*/ <-0.58601,3.22371,-0.11495>,
    /*1*/ <-0.58827,3.23142,-0.11075>,<-0.59004,3.21594,-0.11263>,<-0.57972,3.22378,-0.12147>,
            
    /*2*/ <-0.82505,3.28389,-0.34091>,<-0.82623,3.27357,-0.34217>,<-0.81935,3.27879,-0.34806>,
            
    /*3*/ <-1.10571,3.42286,-0.4505>,<-1.10768,3.41813,-0.45157>,<-1.10497,3.42072,-0.45522>,
            
    /*4*/ <-1.3944,3.58171,-0.50451>

    /* stem 0.1.6*/ 
    /*0*/ <-0.70779,3.20354,-0.14341>,
    /*1*/ <-0.7068,3.1952,-0.14173>,<-0.71183,3.20603,-0.15054>,<-0.70474,3.2094,-0.13795>,
            
    /*2*/ <-0.98506,3.19663,0.01457>,<-0.98841,3.20385,0.00869>,<-0.98368,3.2061,0.01708>,
            
    /*3*/ <-1.29436,3.27049,-0.03051>,<-1.29308,3.27411,-0.03364>,<-1.29355,3.27507,-0.02881>,
            
    /*4*/ <-1.55254,3.43042,-0.13159>

    /* stem 0.1.7*/ 
    /*0*/ <-0.81878,3.19043,-0.17259>,
    /*1*/ <-0.81716,3.19572,-0.17854>,<-0.82593,3.19072,-0.16874>,<-0.81326,3.18486,-0.17049>,
            
    /*2*/ <-0.93553,3.00016,-0.38085>,<-0.94138,2.99683,-0.37432>,<-0.93293,2.99293,-0.37548>,
            
    /*3*/ <-1.1376,2.95532,-0.60289>,<-1.14072,2.95372,-0.59978>,<-1.13775,2.95075,-0.60187>,
            
    /*4*/ <-1.3605,3.10814,-0.74289>

    /* stem 0.1.8*/ 
    /*0*/ <-0.91945,3.18622,-0.20379>,
    /*1*/ <-0.92173,3.18614,-0.19642>,<-0.9224,3.18115,-0.20881>,<-0.91422,3.19138,-0.20616>,
            
    /*2*/ <-1.13553,3.37445,-0.26309>,<-1.13597,3.37112,-0.27135>,<-1.13052,3.37795,-0.26958>,
            
    /*3*/ <-1.31518,3.59813,-0.32075>,<-1.31565,3.59672,-0.32495>,<-1.3124,3.59959,-0.32391>,
            
    /*4*/ <-1.51092,3.81417,-0.34118>

    /* stem 0.1.9*/ 
    /*0*/ <-1.01227,3.18234,-0.23256>,
    /*1*/ <-1.01041,3.17768,-0.23794>,<-1.01737,3.1875,-0.23377>,<-1.00903,3.18184,-0.22598>,
            
    /*2*/ <-1.21115,3.00133,-0.15119>,<-1.21579,3.00788,-0.14842>,<-1.21023,3.00411,-0.14322>,
            
    /*3*/ <-1.4894,2.96103,-0.1302>,<-1.48993,2.96508,-0.12904>,<-1.48927,2.96209,-0.12609>,
            
    /*4*/ <-1.72429,3.03568,-0.2644>

    /* stem 0.1.10*/ 
    /*0*/ <-1.10248,3.17857,-0.26052>,
    /*1*/ <-1.10312,3.18544,-0.25937>,<-1.10787,3.17429,-0.25928>,<-1.09644,3.17597,-0.26292>,
            
    /*2*/ <-1.18865,3.21757,-0.513>,<-1.19182,3.21014,-0.51294>,<-1.1842,3.21126,-0.51537>,
            
    /*3*/ <-1.26443,3.2925,-0.75983>,<-1.26616,3.28889,-0.76043>,<-1.26229,3.28947,-0.76144>,
            
    /*4*/ <-1.43385,3.40901,-0.93327>

    /* stem 0.1.11*/ 
    /*0*/ <-1.2512,3.18625,-0.30387>,
    /*1*/ <-1.25267,3.18069,-0.30103>,<-1.25293,3.1873,-0.30996>,<-1.248,3.19077,-0.30062>,
            
    /*2*/ <-1.4696,3.27999,-0.22334>,<-1.46978,3.2844,-0.22929>,<-1.46649,3.28671,-0.22307>,
            
    /*3*/ <-1.71206,3.34297,-0.21172>,<-1.7117,3.34504,-0.21478>,<-1.71115,3.34655,-0.21144>,
            
    /*4*/ <-1.9388,3.44209,-0.25622>

    /* stem 0.1.12*/ 
    /*0*/ <-1.35434,3.19882,-0.33249>,
    /*1*/ <-1.35259,3.20095,-0.33785>,<-1.35822,3.20197,-0.32912>,<-1.3522,3.19356,-0.3305>,
            
    /*2*/ <-1.53489,3.0872,-0.44012>,<-1.53865,3.08787,-0.43431>,<-1.53463,3.08227,-0.43522>,
            
    /*3*/ <-1.73493,3.02187,-0.55057>,<-1.73672,3.02224,-0.54761>,<-1.73528,3.01918,-0.5484>,
            
    /*4*/ <-1.96642,3.02289,-0.60692>

    /* stem 0.1.13*/ 
    /*0*/ <-1.4807,3.21423,-0.36756>,
    /*1*/ <-1.4818,3.21589,-0.36287>,<-1.48343,3.21046,-0.36963>,<-1.47688,3.21634,-0.37018>,
            
    /*2*/ <-1.62223,3.3642,-0.45021>,<-1.62331,3.36057,-0.45472>,<-1.61895,3.36449,-0.45508>,
            
    /*3*/ <-1.80439,3.48715,-0.47572>,<-1.80525,3.48545,-0.47796>,<-1.80358,3.48781,-0.47847>,
            
    /*4*/ <-1.99368,3.60297,-0.4727>

    /* stem 0.1.14*/ 
    /*0*/ <-1.62234,3.2418,-0.40782>,
    /*1*/ <-1.6226,3.23887,-0.40976>,<-1.62318,3.24492,-0.40922>,<-1.62125,3.2416,-0.40447>,
            
    /*2*/ <-1.81557,3.21566,-0.34746>,<-1.81596,3.21969,-0.3471>,<-1.81467,3.21748,-0.34394>,
            
    /*3*/ <-2.00859,3.23629,-0.283>,<-2.00837,3.23831,-0.28297>,<-2.00793,3.23722,-0.28131>,
            
    /*4*/ <-2.20129,3.30351,-0.27739>

    /* stem 0.1.15*/ 
    /*0*/ <-1.69724,3.2628,-0.42971>,
    /*1*/ <-1.69646,3.26536,-0.42993>,<-1.69956,3.26221,-0.42849>,<-1.69571,3.26084,-0.4307>,
            
    /*2*/ <-1.78954,3.27781,-0.60016>,<-1.7916,3.27571,-0.59919>,<-1.78904,3.27479,-0.60066>,
            
    /*3*/ <-1.84433,3.36372,-0.76484>,<-1.8456,3.36283,-0.76489>,<-1.8443,3.36235,-0.76557>,
            
    /*4*/ <-1.91526,3.49663,-0.88739>

    /* stem 0.1.16*/ 
    /*0*/ <-1.77155,3.28365,-0.45142>,
    /*1*/ <-1.77224,3.28248,-0.45016>,<-1.77234,3.28378,-0.45308>,<-1.77006,3.28467,-0.45101>,
            
    /*2*/ <-1.8821,3.41715,-0.38736>,<-1.88216,3.41801,-0.38931>,<-1.88065,3.41861,-0.38793>,
            
    /*3*/ <-1.98849,3.56435,-0.35235>,<-1.9884,3.56466,-0.35337>,<-1.98769,3.565,-0.35265>,
            
    /*4*/ <-2.14336,3.66479,-0.35963>

    /* stem 0.1.17*/ 
    /*0*/ <-1.88998,3.31686,-0.48602>,
    /*1*/ <-1.88983,3.31687,-0.48652>,<-1.89021,3.31728,-0.48582>,<-1.88989,3.31644,-0.48573>,
            
    /*2*/ <-2.04092,3.25479,-0.5316>,<-2.04117,3.25506,-0.53113>,<-2.04096,3.2545,-0.53107>,
            
    /*3*/ <-2.20785,3.28399,-0.52592>,<-2.20781,3.28414,-0.52567>,<-2.20786,3.28385,-0.52566>,
            
    /*4*/ <-2.33709,3.39349,-0.52989>

    /* stem 0.2*/ 
    /*0*/ <0,3.54304,0>,
    /*1*/ <0.01132,3.54304,0.0196>,<0.00865,3.56372,0.00308>,<-0.00597,3.55582,-0.01769>,
            <-0.01234,3.53025,-0.01402>,<-0.00165,3.52235,0.00903>,
    /*2*/ <0.36709,3.42417,-0.19104>,<0.36496,3.44072,-0.20425>,<0.35326,3.4344,-0.22087>,
            <0.34817,3.41394,-0.21793>,<0.35672,3.40762,-0.19949>,
    /*3*/ <0.73474,3.36406,-0.40603>,<0.73165,3.37684,-0.41508>,<0.72353,3.37194,-0.42792>,
            <0.72159,3.35614,-0.42681>,<0.72852,3.35126,-0.41328>,
    /*4*/ <1.09377,3.37195,-0.64429>,<1.09023,3.38055,-0.64946>,<1.08478,3.37725,-0.65798>,
            <1.08495,3.36661,-0.65807>,<1.09051,3.36333,-0.64961>,
    /*5*/ <1.47472,3.42432,-0.83473>,<1.47291,3.42865,-0.83724>,<1.47085,3.42709,-0.8419>,
            <1.4714,3.42181,-0.84226>,<1.47379,3.4201,-0.83783>,
    /*6*/ <1.80913,3.57962,-1.05742>

    /* stem 0.2.0*/ 
    /*0*/ <0.14697,3.49424,-0.08485>,
    /*1*/ <0.14433,3.50137,-0.09353>,<0.15098,3.48366,-0.0871>,<0.14561,3.4977,-0.07393>,
            
    /*2*/ <0.52785,3.64341,-0.08863>,<0.53228,3.6316,-0.08434>,<0.5287,3.64096,-0.07556>,
            
    /*3*/ <0.83177,3.91302,-0.10952>,<0.83611,3.90834,-0.10763>,<0.83309,3.91212,-0.10305>,
            
    /*4*/ <1.18493,4.0928,-0.21107>

    /* stem 0.2.1*/ 
    /*0*/ <0.1954,3.47816,-0.11282>,
    /*1*/ <0.19372,3.46747,-0.10958>,<0.2058,3.48258,-0.11254>,<0.18669,3.48444,-0.11633>,
            
    /*2*/ <0.25708,3.347,-0.48786>,<0.26514,3.35707,-0.48983>,<0.25239,3.35831,-0.49236>,
            
    /*3*/ <0.4693,3.315,-0.82992>,<0.4722,3.32072,-0.82871>,<0.46664,3.32053,-0.83214>,
            
    /*4*/ <0.78973,3.26235,-1.06648>

    /* stem 0.2.2*/ 
    /*0*/ <0.2627,3.45582,-0.15167>,
    /*1*/ <0.26772,3.46496,-0.14823>,<0.26472,3.45191,-0.16173>,<0.25567,3.4506,-0.14506>,
            
    /*2*/ <0.5608,3.24613,-0.00634>,<0.5588,3.23743,-0.01534>,<0.55277,3.23656,-0.00423>,
            
    /*3*/ <0.93653,3.18048,0.07307>,<0.93668,3.17585,0.06875>,<0.93517,3.17452,0.07476>,
            
    /*4*/ <1.3187,3.25931,0.04478>

    /* stem 0.2.3*/ 
    /*0*/ <0.32215,3.43608,-0.18599>,
    /*1*/ <0.31625,3.43257,-0.19419>,<0.33037,3.43025,-0.18243>,<0.31983,3.44543,-0.18136>,
            
    /*2*/ <0.55217,3.61342,-0.43688>,<0.56158,3.61187,-0.42905>,<0.55455,3.622,-0.42833>,
            
    /*3*/ <0.78832,3.79516,-0.67871>,<0.79303,3.79434,-0.67481>,<0.78954,3.79941,-0.6744>,
            
    /*4*/ <1.10728,3.9009,-0.86527>

    /* stem 0.2.4*/ 
    /*0*/ <0.38658,3.41953,-0.223>,
    /*1*/ <0.39099,3.41602,-0.21428>,<0.39146,3.42665,-0.22878>,<0.3773,3.41592,-0.22594>,
            
    /*2*/ <0.55721,3.14447,-0.41164>,<0.55752,3.15156,-0.42131>,<0.54808,3.14441,-0.41942>,
            
    /*3*/ <0.82517,3.06584,-0.66317>,<0.82361,3.07065,-0.6664>,<0.82104,3.06534,-0.66749>,
            
    /*4*/ <1.17388,3.11408,-0.78894>

    /* stem 0.2.5*/ 
    /*0*/ <0.50021,3.40106,-0.28784>,
    /*1*/ <0.4988,3.40951,-0.29272>,<0.50323,3.39302,-0.29268>,<0.4986,3.40065,-0.27812>,
            
    /*2*/ <0.84072,3.49857,-0.23063>,<0.84367,3.48757,-0.23061>,<0.84058,3.49266,-0.2209>,
            
    /*3*/ <1.19349,3.56258,-0.23454>,<1.19455,3.55699,-0.23456>,<1.1941,3.55978,-0.22962>,
            
    /*4*/ <1.51988,3.68718,-0.31216>

    /* stem 0.2.6*/ 
    /*0*/ <0.59584,3.38552,-0.34241>,
    /*1*/ <0.59391,3.37634,-0.34318>,<0.60398,3.38832,-0.33858>,<0.58963,3.39192,-0.34546>,
            
    /*2*/ <0.74275,3.37443,-0.65485>,<0.74947,3.38242,-0.65178>,<0.7399,3.38482,-0.65637>,
            
    /*3*/ <0.85411,3.3741,-0.98165>,<0.85782,3.37788,-0.98043>,<0.85287,3.37938,-0.98213>,
            
    /*4*/ <1.04411,3.39899,-1.26954>

    /* stem 0.2.7*/ 
    /*0*/ <0.66127,3.37489,-0.37974>,
    /*1*/ <0.66545,3.3807,-0.37409>,<0.6636,3.37465,-0.38856>,<0.65478,3.36932,-0.37659>,
            
    /*2*/ <0.89676,3.14569,-0.30826>,<0.89553,3.14165,-0.31792>,<0.88965,3.1381,-0.30993>,
            
    /*3*/ <1.22569,3.12419,-0.36427>,<1.22479,3.12262,-0.36922>,<1.22521,3.11906,-0.36536>,
            
    /*4*/ <1.50464,3.23221,-0.5174>

    /* stem 0.2.8*/ 
    /*0*/ <0.77854,3.36515,-0.4506>,
    /*1*/ <0.77386,3.36514,-0.4578>,<0.78563,3.36035,-0.45008>,<0.77611,3.36997,-0.44392>,
            
    /*2*/ <0.94876,3.60896,-0.56818>,<0.95661,3.60576,-0.56303>,<0.95026,3.61218,-0.55893>,
            
    /*3*/ <1.1541,3.81828,-0.69573>,<1.15778,3.81639,-0.693>,<1.15505,3.82014,-0.69124>,
            
    /*4*/ <1.36177,3.97351,-0.88207>

    /* stem 0.2.9*/ 
    /*0*/ <0.89418,3.36768,-0.52561>,
    /*1*/ <0.89762,3.36251,-0.52048>,<0.89856,3.37355,-0.52896>,<0.88635,3.36698,-0.52739>,
            
    /*2*/ <0.96546,3.18068,-0.7534>,<0.96609,3.18804,-0.75906>,<0.95795,3.18366,-0.75801>,
            
    /*3*/ <1.16808,3.18793,-0.98023>,<1.16695,3.19235,-0.98114>,<1.16469,3.18889,-0.98327>,
            
    /*4*/ <1.33805,3.26682,-1.21937>

    /* stem 0.2.10*/ 
    /*0*/ <1.00429,3.37009,-0.59703>,
    /*1*/ <1.00346,3.37753,-0.59807>,<1.00583,3.36561,-0.60292>,<1.00359,3.36713,-0.59012>,
            
    /*2*/ <1.28514,3.41278,-0.55309>,<1.28672,3.40483,-0.55632>,<1.28523,3.40585,-0.54778>,
            
    /*3*/ <1.51866,3.56844,-0.502>,<1.52118,3.56517,-0.5034>,<1.52009,3.56543,-0.49918>,
            
    /*4*/ <1.73935,3.75173,-0.49098>

    /* stem 0.2.11*/ 
    /*0*/ <1.11868,3.37601,-0.66641>,
    /*1*/ <1.11775,3.37001,-0.66999>,<1.12495,3.37748,-0.66354>,<1.11333,3.38055,-0.66569>,
            
    /*2*/ <1.19333,3.49686,-0.8976>,<1.19812,3.50184,-0.89331>,<1.19037,3.50389,-0.89474>,
            
    /*3*/ <1.33354,3.67133,-1.05353>,<1.33514,3.67306,-1.05021>,<1.33165,3.67448,-1.05176>,
            
    /*4*/ <1.50439,3.80533,-1.21573>

    /* stem 0.2.12*/ 
    /*0*/ <1.24884,3.3938,-0.72978>,
    /*1*/ <1.2513,3.39591,-0.72413>,<1.24949,3.3974,-0.73516>,<1.24572,3.38809,-0.73004>,
            
    /*2*/ <1.46955,3.2779,-0.77756>,<1.46835,3.27888,-0.78492>,<1.46584,3.27268,-0.7815>,
            
    /*3*/ <1.7096,3.3345,-0.83273>,<1.70866,3.33511,-0.83632>,<1.70972,3.33168,-0.8352>,
            
    /*4*/ <1.91191,3.48661,-0.83092>

    /* stem 0.2.13*/ 
    /*0*/ <1.31356,3.40265,-0.76129>,
    /*1*/ <1.31076,3.40486,-0.76642>,<1.31848,3.39883,-0.76182>,<1.31144,3.40425,-0.75564>,
            
    /*2*/ <1.46204,3.59769,-0.76323>,<1.46718,3.59367,-0.76016>,<1.46249,3.59728,-0.75605>,
            
    /*3*/ <1.60316,3.79509,-0.79349>,<1.60596,3.79334,-0.79204>,<1.60374,3.79525,-0.78993>,
            
    /*4*/ <1.76283,3.97426,-0.84321>

    /* stem 0.2.14*/ 
    /*0*/ <1.43913,3.4198,-0.82243>,
    /*1*/ <1.44065,3.41553,-0.82051>,<1.4421,3.42373,-0.82236>,<1.43464,3.42015,-0.82442>,
            
    /*2*/ <1.52532,3.35599,-1.0239>,<1.52629,3.36146,-1.02514>,<1.52131,3.35907,-1.02651>,
            
    /*3*/ <1.65578,3.41949,-1.20159>,<1.65538,3.42222,-1.20093>,<1.65359,3.42092,-1.20271>,
            
    /*4*/ <1.7878,3.52368,-1.35619>

    /* stem 0.2.15*/ 
    /*0*/ <1.51023,3.4417,-0.86316>,
    /*1*/ <1.50936,3.44541,-0.86187>,<1.51063,3.44098,-0.8671>,<1.51071,3.43871,-0.86052>,
            
    /*2*/ <1.7224,3.48964,-0.84929>,<1.72324,3.48669,-0.85278>,<1.7233,3.48517,-0.84839>,
            
    /*3*/ <1.90515,3.59969,-0.89078>,<1.9056,3.59829,-0.89258>,<1.9064,3.59776,-0.89046>,
            
    /*4*/ <2.04397,3.74544,-0.97383>

    /* stem 0.2.16*/ 
    /*0*/ <1.59321,3.47999,-0.91709>,
    /*1*/ <1.5926,3.4782,-0.9193>,<1.59586,3.47999,-0.91591>,<1.59116,3.48177,-0.91606>,
            
    /*2*/ <1.65157,3.62331,-1.05187>,<1.65375,3.6245,-1.04962>,<1.65061,3.62569,-1.04972>,
            
    /*3*/ <1.74722,3.76214,-1.16911>,<1.7482,3.76257,-1.16782>,<1.74675,3.76337,-1.16807>,
            
    /*4*/ <1.87913,3.89679,-1.25063>

    /* stem 0.2.17*/ 
    /*0*/ <1.677,3.51865,-0.97155>,
    /*1*/ <1.67796,3.51869,-0.97005>,<1.67685,3.52012,-0.97254>,<1.6762,3.51715,-0.97205>,
            
    /*2*/ <1.83459,3.4679,-1.06947>,<1.83385,3.46886,-1.07113>,<1.83342,3.46688,-1.0708>,
            
    /*3*/ <1.99439,3.54479,-1.14357>,<1.99383,3.54525,-1.1443>,<1.99421,3.54431,-1.14446>,
            
    /*4*/ <2.12014,3.67366,-1.2113>

    /* stem 0.2.18*/ 
    /*0*/ <1.76352,3.55858,-1.02778>,
    /*1*/ <1.76314,3.55893,-1.02811>,<1.76392,3.55822,-1.02807>,<1.76349,3.55858,-1.02717>,
            
    /*2*/ <1.88447,3.69056,-1.02357>,<1.88499,3.69008,-1.02355>,<1.8847,3.69033,-1.02295>,
            
    /*3*/ <2.0071,3.81909,-1.04592>,<2.00736,3.81884,-1.04591>,<2.00725,3.819,-1.04561>,
            
    /*4*/ <2.14021,3.93603,-1.07194>

    /* stem 0.3*/ 
    /*0*/ <0,3.72397,0>,
    /*1*/ <-0.0227,3.72397,-0.00826>,<-0.00894,3.74625,0.00272>,<0.01718,3.73774,0.00995>,
            <0.01955,3.7102,0.00343>,<-0.0051,3.70169,-0.00783>,
    /*2*/ <-0.16884,3.61301,0.40737>,<-0.15782,3.63084,0.41615>,<-0.13693,3.62403,0.42193>,
            <-0.13503,3.602,0.41672>,<-0.15475,3.59519,0.40772>,
    /*3*/ <-0.33467,3.5467,0.82428>,<-0.3261,3.56029,0.82997>,<-0.31083,3.555,0.83539>,
            <-0.30997,3.53814,0.83305>,<-0.3247,3.53301,0.82619>,
    /*4*/ <-0.49054,3.54061,1.25143>,<-0.48429,3.54977,1.25391>,<-0.47418,3.54621,1.25768>,
            <-0.47418,3.53485,1.25751>,<-0.48429,3.53139,1.25365>,
    /*5*/ <-0.64042,3.58053,1.67859>,<-0.63711,3.58509,1.67936>,<-0.6321,3.58331,1.68134>,
            <-0.6323,3.57765,1.6818>,<-0.63744,3.57593,1.6801>,
    /*6*/ <-0.8018,3.70532,2.08432>

    /* stem 0.3.0*/ 
    /*0*/ <-0.05465,3.68372,0.15016>,
    /*1*/ <-0.04639,3.69146,0.15524>,<-0.05607,3.67228,0.15474>,<-0.0615,3.68743,0.1405>,
            
    /*2*/ <-0.35406,3.83567,0.42612>,<-0.36052,3.82288,0.42578>,<-0.36414,3.83299,0.41629>,
            
    /*3*/ <-0.56142,4.05909,0.73232>,<-0.56559,4.05343,0.73369>,<-0.56761,4.05827,0.72881>,
            
    /*4*/ <-0.56738,4.28766,1.09981>

    /* stem 0.3.1*/ 
    /*0*/ <-0.08706,3.65986,0.2392>,
    /*1*/ <-0.08803,3.64839,0.23577>,<-0.096,3.66509,0.24528>,<-0.07715,3.6661,0.23654>,
            
    /*2*/ <0.08765,3.52848,0.6012>,<0.08234,3.53961,0.60753>,<0.09491,3.54029,0.60171>,
            
    /*3*/ <0.16033,3.57152,1.01862>,<0.15699,3.57759,1.01862>,<0.16382,3.57739,1.01745>,
            
    /*4*/ <0.13847,3.71929,1.41523>

    /* stem 0.3.2*/ 
    /*0*/ <-0.11353,3.64036,0.31193>,
    /*1*/ <-0.11987,3.65017,0.31226>,<-0.10809,3.63661,0.32156>,<-0.11265,3.63431,0.30198>,
            
    /*2*/ <-0.45224,3.42753,0.41584>,<-0.44438,3.41849,0.42204>,<-0.44743,3.41695,0.40899>,
            
    /*3*/ <-0.80209,3.43188,0.62842>,<-0.79969,3.42711,0.63255>,<-0.80309,3.42536,0.62699>,
            
    /*4*/ <-1.10984,3.465,0.90208>

    /* stem 0.3.3*/ 
    /*0*/ <-0.13882,3.62174,0.38142>,
    /*1*/ <-0.12846,3.61797,0.38418>,<-0.14803,3.61574,0.38436>,<-0.13999,3.63151,0.37571>,
            
    /*2*/ <-0.15161,3.82105,0.73277>,<-0.16466,3.81956,0.73289>,<-0.1593,3.83007,0.72712>,
            
    /*3*/ <-0.25901,3.95906,1.09812>,<-0.26533,3.95787,1.09678>,<-0.26271,3.96372,1.09534>,
            
    /*4*/ <-0.43123,4.06677,1.44803>

    /* stem 0.3.4*/ 
    /*0*/ <-0.16568,3.60717,0.45054>,
    /*1*/ <-0.17511,3.60348,0.44609>,<-0.16597,3.61431,0.459>,<-0.15595,3.60373,0.44655>,
            
    /*2*/ <-0.17424,3.30286,0.70233>,<-0.16815,3.31008,0.71093>,<-0.16147,3.30303,0.70264>,
            
    /*3*/ <-0.16195,3.22324,1.09164>,<-0.15882,3.22871,1.0927>,<-0.15556,3.22335,1.09151>,
            
    /*4*/ <-0.17979,3.32236,1.4742>

    /* stem 0.3.5*/ 
    /*0*/ <-0.2112,3.58946,0.56152>,
    /*1*/ <-0.20677,3.59849,0.56478>,<-0.20976,3.58056,0.56706>,<-0.21707,3.58932,0.55271>,
            
    /*2*/ <-0.51864,3.67343,0.7694>,<-0.52063,3.66148,0.77092>,<-0.52551,3.66731,0.76136>,
            
    /*3*/ <-0.71071,3.82643,1.05653>,<-0.71232,3.82087,1.05847>,<-0.71587,3.82387,1.0545>,
            
    /*4*/ <-0.75274,4.08967,1.32562>

    /* stem 0.3.6*/ 
    /*0*/ <-0.24731,3.57541,0.64952>,
    /*1*/ <-0.24516,3.56546,0.64882>,<-0.25645,3.57842,0.65287>,<-0.24031,3.58233,0.64688>,
            
    /*2*/ <-0.11813,3.5718,0.99512>,<-0.12566,3.58044,0.99782>,<-0.1149,3.58305,0.99383>,
            
    /*3*/ <-0.11875,3.68361,1.3492>,<-0.12273,3.68775,1.34793>,<-0.11699,3.68898,1.34755>,
            
    /*4*/ <-0.16681,3.92309,1.62752>

    /* stem 0.3.7*/ 
    /*0*/ <-0.29491,3.55688,0.76555>,
    /*1*/ <-0.30209,3.56308,0.76359>,<-0.29033,3.5573,0.77408>,<-0.29229,3.55026,0.75897>,
            
    /*2*/ <-0.53337,3.33325,0.90069>,<-0.52553,3.3294,0.90768>,<-0.52684,3.3247,0.89761>,
            
    /*3*/ <-0.7249,3.29084,1.19371>,<-0.72028,3.28961,1.19661>,<-0.72319,3.28553,1.19412>,
            
    /*4*/ <-0.78307,3.47491,1.48939>

    /* stem 0.3.8*/ 
    /*0*/ <-0.3316,3.54624,0.85721>,
    /*1*/ <-0.32289,3.54619,0.86049>,<-0.33814,3.54106,0.86132>,<-0.33376,3.55146,0.84982>,
            
    /*2*/ <-0.40246,3.80717,1.06632>,<-0.41262,3.80375,1.06687>,<-0.4097,3.81068,1.05921>,
            
    /*3*/ <-0.47634,3.99261,1.34304>,<-0.48132,3.99059,1.34312>,<-0.48029,3.99509,1.34038>,
            
    /*4*/ <-0.63678,4.13272,1.61128>

    /* stem 0.3.9*/ 
    /*0*/ <-0.37344,3.54465,0.96821>,
    /*1*/ <-0.37977,3.539,0.96574>,<-0.37514,3.5508,0.97432>,<-0.36541,3.54415,0.96455>,
            
    /*2*/ <-0.28381,3.33295,1.20155>,<-0.28072,3.34082,1.20728>,<-0.27423,3.33638,1.20076>,
            
    /*3*/ <-0.25212,3.29647,1.52708>,<-0.2509,3.3014,1.52755>,<-0.24724,3.29792,1.52681>,
            
    /*4*/ <-0.2287,3.34771,1.85025>

    /* stem 0.3.10*/ 
    /*0*/ <-0.41563,3.54306,1.08013>,
    /*1*/ <-0.41428,3.5513,1.08076>,<-0.41415,3.53806,1.08668>,<-0.41848,3.53982,1.07295>,
            
    /*2*/ <-0.70926,3.58962,1.17871>,<-0.70917,3.58079,1.18266>,<-0.71206,3.58196,1.1735>,
            
    /*3*/ <-0.99009,3.66631,1.29216>,<-0.99047,3.66197,1.29425>,<-0.99211,3.66263,1.28975>,
            
    /*4*/ <-1.22611,3.79549,1.45129>

    /* stem 0.3.11*/ 
    /*0*/ <-0.45193,3.54169,1.17641>,
    /*1*/ <-0.44819,3.53476,1.17772>,<-0.45914,3.54299,1.17958>,<-0.44846,3.54731,1.17194>,
            
    /*2*/ <-0.32059,3.65298,1.42315>,<-0.32789,3.65847,1.42439>,<-0.32077,3.66135,1.4193>,
            
    /*3*/ <-0.26851,3.79418,1.6847>,<-0.27245,3.79651,1.68426>,<-0.26855,3.79825,1.68255>,
            
    /*4*/ <-0.24346,3.92011,1.95672>

    /* stem 0.3.12*/ 
    /*0*/ <-0.50748,3.54729,1.32644>,
    /*1*/ <-0.5139,3.54984,1.32387>,<-0.50441,3.55036,1.3324>,<-0.50412,3.54167,1.32305>,
            
    /*2*/ <-0.64998,3.36712,1.48936>,<-0.64365,3.36746,1.49505>,<-0.64346,3.36167,1.48881>,
            
    /*3*/ <-0.87103,3.32927,1.65604>,<-0.86847,3.3291,1.65944>,<-0.86944,3.32553,1.65733>,
            
    /*4*/ <-1.06203,3.3671,1.85946>

    /* stem 0.3.13*/ 
    /*0*/ <-0.53521,3.55446,1.40286>,
    /*1*/ <-0.52889,3.55683,1.40493>,<-0.53835,3.54921,1.40639>,<-0.5384,3.55735,1.39725>,
            
    /*2*/ <-0.65204,3.73748,1.5664>,<-0.65835,3.7324,1.56737>,<-0.65838,3.73782,1.56128>,
            
    /*3*/ <-0.81399,3.92512,1.67986>,<-0.81704,3.92242,1.68004>,<-0.8166,3.92479,1.67675>,
            
    /*4*/ <-0.87077,4.12312,1.85566>

    /* stem 0.3.14*/ 
    /*0*/ <-0.58583,3.56756,1.54235>,
    /*1*/ <-0.58904,3.56206,1.5417>,<-0.58852,3.57248,1.54542>,<-0.57994,3.56813,1.53992>,
            
    /*2*/ <-0.48968,3.4809,1.76083>,<-0.48934,3.48785,1.76331>,<-0.48362,3.48495,1.75964>,
            
    /*3*/ <-0.43579,3.42955,2.00368>,<-0.43576,3.43315,2.00447>,<-0.43265,3.43147,2.00342>,
            
    /*4*/ <-0.44124,3.46649,2.25524>

    /* stem 0.3.15*/ 
    /*0*/ <-0.62351,3.5773,1.64616>,
    /*1*/ <-0.62418,3.58243,1.64544>,<-0.6207,3.57558,1.65021>,<-0.62566,3.5739,1.64284>,
            
    /*2*/ <-0.82274,3.57391,1.78106>,<-0.82042,3.56935,1.78424>,<-0.82373,3.56822,1.77933>,
            
    /*3*/ <-1.01433,3.66272,1.89339>,<-1.01403,3.66066,1.89556>,<-1.01573,3.66006,1.89314>,
            
    /*4*/ <-1.18762,3.74752,2.03731>

    /* stem 0.3.16*/ 
    /*0*/ <-0.65753,3.59679,1.73297>,
    /*1*/ <-0.65482,3.59421,1.73488>,<-0.66159,3.59677,1.73407>,<-0.65618,3.5994,1.72997>,
            
    /*2*/ <-0.61406,3.75562,1.89231>,<-0.61857,3.75732,1.89177>,<-0.61497,3.75908,1.88904>,
            
    /*3*/ <-0.68675,3.89821,2.05727>,<-0.68889,3.89844,2.05614>,<-0.68707,3.89996,2.05563>,
            
    /*4*/ <-0.77367,3.97344,2.25515>

    /* stem 0.3.17*/ 
    /*0*/ <-0.69876,3.62781,1.83338>,
    /*1*/ <-0.70153,3.62779,1.83224>,<-0.69791,3.62999,1.83526>,<-0.69682,3.62564,1.83263>,
            
    /*2*/ <-0.76851,3.50996,1.99988>,<-0.7661,3.51142,2.00189>,<-0.76537,3.50852,2.00014>,
            
    /*3*/ <-0.75465,3.47203,2.21251>,<-0.75332,3.47314,2.21263>,<-0.75302,3.47147,2.21231>,
            
    /*4*/ <-0.71753,3.4757,2.42499>

    /* stem 0.3.18*/ 
    /*0*/ <-0.73351,3.65395,1.91801>,
    /*1*/ <-0.73197,3.65518,1.91826>,<-0.73413,3.65281,1.91952>,<-0.73443,3.65385,1.91625>,
            
    /*2*/ <-0.86066,3.80247,1.97682>,<-0.8621,3.80089,1.97766>,<-0.8623,3.80158,1.97548>,
            
    /*3*/ <-0.92648,3.9752,2.06245>,<-0.9273,3.97462,2.063>,<-0.92751,3.97505,2.06196>,
            
    /*4*/ <-0.95827,4.12038,2.20234>

    /* stem 0.3.19*/ 
    /*0*/ <-0.78892,3.69563,2.05296>,
    /*1*/ <-0.78902,3.69528,2.05303>,<-0.78917,3.69591,2.05301>,<-0.78858,3.69571,2.05284>,
            
    /*2*/ <-0.73237,3.71449,2.2291>,<-0.73247,3.71491,2.22909>,<-0.73207,3.71478,2.22897>,
            
    /*3*/ <-0.72268,3.7865,2.40032>,<-0.72274,3.7867,2.40025>,<-0.72253,3.78664,2.40026>,
            
    /*4*/ <-0.74391,3.89764,2.54793>

    /* stem 0.4*/ 
    /*0*/ <0,3.84023,0>,
    /*1*/ <0.02364,3.84023,-0.0086>,<0.00548,3.86354,-0.00768>,<-0.02025,3.85464,0.00386>,
            <-0.01799,3.82581,0.01007>,<0.00913,3.81691,0.00237>,
    /*2*/ <-0.13771,3.73524,-0.43719>,<-0.15224,3.75389,-0.43645>,<-0.17282,3.74677,-0.42722>,
            <-0.17101,3.72371,-0.42225>,<-0.14931,3.71658,-0.42841>,
    /*3*/ <-0.37226,3.70937,-0.84717>,<-0.38161,3.72382,-0.84285>,<-0.39625,3.71854,-0.83434>,
            <-0.39595,3.70082,-0.83339>,<-0.38113,3.69516,-0.84132>,
    /*4*/ <-0.59495,3.76353,-1.25696>,<-0.60046,3.77313,-1.25278>,<-0.61063,3.76965,-1.24785>,
            <-0.61141,3.7579,-1.24898>,<-0.60172,3.75412,-1.25461>,
    /*5*/ <-0.78526,3.8833,-1.66878>,<-0.78779,3.88803,-1.66628>,<-0.79315,3.88642,-1.66434>,
            <-0.79392,3.88071,-1.66565>,<-0.78905,3.87878,-1.66839>,
    /*6*/ <-0.90858,4.10999,-2.06076>

    /* stem 0.4.0*/ 
    /*0*/ <-0.06285,3.79809,-0.17269>,
    /*1*/ <-0.07273,3.80614,-0.17105>,<-0.06485,3.78638,-0.17755>,<-0.05098,3.80176,-0.16945>,
            
    /*2*/ <-0.00673,3.96407,-0.5842>,<-0.00148,3.9509,-0.58853>,<0.00777,3.96116,-0.58313>,
            
    /*3*/ <-0.05115,4.23717,-0.93148>,<-0.04886,4.2318,-0.93605>,<-0.04393,4.23645,-0.93304>,
            
    /*4*/ <-0.10683,4.4512,-1.3206>

    /* stem 0.4.1*/ 
    /*0*/ <-0.08909,3.7805,-0.24478>,
    /*1*/ <-0.08611,3.76849,-0.24294>,<-0.0852,3.7864,-0.25511>,<-0.09597,3.78662,-0.23629>,
            
    /*2*/ <-0.45245,3.64986,-0.45114>,<-0.45185,3.6618,-0.45926>,<-0.45902,3.66194,-0.44671>,
            
    /*3*/ <-0.76184,3.66775,-0.76388>,<-0.75942,3.67423,-0.76598>,<-0.76456,3.67375,-0.76092>,
            
    /*4*/ <-1.0118,3.87125,-1.06266>

    /* stem 0.4.2*/ 
    /*0*/ <-0.11416,3.7637,-0.31365>,
    /*1*/ <-0.10923,3.77401,-0.31796>,<-0.12503,3.75995,-0.31776>,<-0.10822,3.75715,-0.30523>,
            
    /*2*/ <0.08348,3.54783,-0.62702>,<0.07295,3.53846,-0.62688>,<0.08416,3.53659,-0.61853>,
            
    /*3*/ <0.21724,3.47365,-1.02477>,<0.21221,3.46879,-1.02561>,<0.21854,3.46691,-1.02313>,
            
    /*4*/ <0.25871,3.53163,-1.44657>

    /* stem 0.4.3*/ 
    /*0*/ <-0.14256,3.74466,-0.39168>,
    /*1*/ <-0.15272,3.74071,-0.38702>,<-0.13738,3.7387,-0.40053>,<-0.13758,3.75458,-0.3875>,
            
    /*2*/ <-0.36503,3.96781,-0.66719>,<-0.3548,3.96647,-0.67619>,<-0.35494,3.97706,-0.66751>,
            
    /*3*/ <-0.53673,4.20704,-0.96579>,<-0.53126,4.20608,-0.96979>,<-0.53144,4.21137,-0.96545>,
            
    /*4*/ <-0.75555,4.3749,-1.27985>

    /* stem 0.4.4*/ 
    /*0*/ <-0.1946,3.73097,-0.49827>,
    /*1*/ <-0.1852,3.72697,-0.50327>,<-0.20071,3.73912,-0.50334>,<-0.19789,3.72683,-0.48821>,
            
    /*2*/ <-0.40845,3.4463,-0.68948>,<-0.41879,3.4544,-0.68953>,<-0.41691,3.44621,-0.67944>,
            
    /*3*/ <-0.77331,3.31043,-0.81067>,<-0.77596,3.3163,-0.80938>,<-0.77579,3.31168,-0.80472>,
            
    /*4*/ <-1.09845,3.41259,-1.02896>

    /* stem 0.4.5*/ 
    /*0*/ <-0.24729,3.72506,-0.59258>,
    /*1*/ <-0.25222,3.73457,-0.59042>,<-0.25277,3.7171,-0.5977>,<-0.23688,3.7235,-0.58961>,
            
    /*2*/ <-0.13122,3.87158,-0.93618>,<-0.13158,3.85993,-0.94104>,<-0.12099,3.86419,-0.93564>,
            
    /*3*/ <-0.03419,4.10404,-1.23283>,<-0.03399,4.09907,-1.23672>,<-0.02879,4.10086,-1.23361>,
            
    /*4*/ <-0.01039,4.35717,-1.52936>

    /* stem 0.4.6*/ 
    /*0*/ <-0.29719,3.71945,-0.68188>,
    /*1*/ <-0.29861,3.70912,-0.68044>,<-0.29308,3.72299,-0.6909>,<-0.29989,3.72624,-0.6743>,
            
    /*2*/ <-0.64576,3.73974,-0.82893>,<-0.64207,3.74898,-0.83591>,<-0.64661,3.75115,-0.82484>,
            
    /*3*/ <-0.82766,3.82727,-1.1517>,<-0.8237,3.83176,-1.15277>,<-0.82877,3.83286,-1.14961>,
            
    /*4*/ <-1.01495,3.97676,-1.4458>

    /* stem 0.4.7*/ 
    /*0*/ <-0.36599,3.71173,-0.80501>,
    /*1*/ <-0.35944,3.71803,-0.80906>,<-0.37576,3.7131,-0.80642>,<-0.36278,3.70405,-0.79953>,
            
    /*2*/ <-0.34757,3.51005,-1.10494>,<-0.35845,3.50676,-1.10318>,<-0.3498,3.50072,-1.09859>,
            
    /*3*/ <-0.38933,3.45499,-1.45855>,<-0.39481,3.45346,-1.45771>,<-0.39066,3.44948,-1.45758>,
            
    /*4*/ <-0.55736,3.57025,-1.75731>

    /* stem 0.4.8*/ 
    /*0*/ <-0.40521,3.71444,-0.87714>,
    /*1*/ <-0.41371,3.71457,-0.87261>,<-0.4044,3.71024,-0.88577>,<-0.3975,3.71851,-0.87302>,
            
    /*2*/ <-0.48913,4.02021,-1.03002>,<-0.48292,4.01732,-1.0388>,<-0.47832,4.02283,-1.0303>,
            
    /*3*/ <-0.56603,4.29453,-1.23739>,<-0.56272,4.29251,-1.24137>,<-0.56066,4.29598,-1.23754>,
            
    /*4*/ <-0.67415,4.55007,-1.45359>

    /* stem 0.4.9*/ 
    /*0*/ <-0.47243,3.7311,-1.00408>,
    /*1*/ <-0.46668,3.72522,-1.0079>,<-0.4744,3.73889,-1.00828>,<-0.47621,3.72919,-0.99606>,
            
    /*2*/ <-0.72443,3.57832,-1.16264>,<-0.72958,3.58743,-1.1629>,<-0.73079,3.58096,-1.15475>,
            
    /*3*/ <-0.90785,3.52292,-1.43613>,<-0.91001,3.52766,-1.43569>,<-0.91224,3.52354,-1.43336>,
            
    /*4*/ <-1.06494,3.61115,-1.71876>

    /* stem 0.4.10*/ 
    /*0*/ <-0.53022,3.74542,-1.11322>,
    /*1*/ <-0.53098,3.75384,-1.11172>,<-0.53682,3.74104,-1.11654>,<-0.52287,3.74138,-1.11141>,
            
    /*2*/ <-0.4238,3.81347,-1.40694>,<-0.42769,3.80494,-1.41016>,<-0.41838,3.80516,-1.40674>,
            
    /*3*/ <-0.40769,4.02123,-1.6455>,<-0.40959,4.01786,-1.6486>,<-0.40468,4.01817,-1.64799>,
            
    /*4*/ <-0.54789,4.23679,-1.83455>

    /* stem 0.4.11*/ 
    /*0*/ <-0.56994,3.75527,-1.18823>,
    /*1*/ <-0.57406,3.74822,-1.18698>,<-0.56677,3.75693,-1.19567>,<-0.569,3.76065,-1.18205>,
            
    /*2*/ <-0.83654,3.89015,-1.26887>,<-0.83169,3.89595,-1.27466>,<-0.83317,3.89844,-1.26558>,
            
    /*3*/ <-1.04581,4.00463,-1.46656>,<-1.04241,4.00712,-1.46878>,<-1.04478,4.00906,-1.46513>,
            
    /*4*/ <-1.11505,4.21618,-1.68352>

    /* stem 0.4.12*/ 
    /*0*/ <-0.62021,3.77421,-1.28872>,
    /*1*/ <-0.61318,3.77658,-1.29119>,<-0.6264,3.77892,-1.28945>,<-0.62104,3.76713,-1.28552>,
            
    /*2*/ <-0.67083,3.66168,-1.55751>,<-0.67964,3.66324,-1.55635>,<-0.67607,3.65538,-1.55373>,
            
    /*3*/ <-0.79214,3.75243,-1.81145>,<-0.796,3.75336,-1.80931>,<-0.79534,3.74927,-1.8111>,
            
    /*4*/ <-0.89813,3.98125,-1.96556>

    /* stem 0.4.13*/ 
    /*0*/ <-0.67085,3.80682,-1.40156>,
    /*1*/ <-0.67678,3.80945,-1.39814>,<-0.67153,3.80352,-1.40807>,<-0.66423,3.80751,-1.39847>,
            
    /*2*/ <-0.64009,4.05514,-1.52812>,<-0.63659,4.05119,-1.53474>,<-0.63172,4.05385,-1.52834>,
            
    /*3*/ <-0.63982,4.28543,-1.68774>,<-0.6381,4.28325,-1.69093>,<-0.63561,4.2852,-1.68812>,
            
    /*4*/ <-0.60964,4.48952,-1.87821>

    /* stem 0.4.14*/ 
    /*0*/ <-0.70967,3.83182,-1.48806>,
    /*1*/ <-0.7073,3.82589,-1.49084>,<-0.70827,3.83791,-1.49114>,<-0.71344,3.83166,-1.48221>,
            
    /*2*/ <-0.93287,3.8061,-1.63532>,<-0.93352,3.81411,-1.63552>,<-0.93697,3.80994,-1.62956>,
            
    /*3*/ <-1.05443,3.8665,-1.86707>,<-1.05413,3.87043,-1.86624>,<-1.05738,3.86837,-1.86507>,
            
    /*4*/ <-1.11018,3.9545,-2.11457>

    /* stem 0.4.15*/ 
    /*0*/ <-0.76541,3.86772,-1.61226>,
    /*1*/ <-0.76377,3.87311,-1.61144>,<-0.77046,3.86661,-1.61465>,<-0.762,3.86344,-1.6107>,
            
    /*2*/ <-0.65731,3.87365,-1.83952>,<-0.66176,3.86931,-1.84166>,<-0.65612,3.8672,-1.83903>,
            
    /*3*/ <-0.65541,3.91439,-2.08783>,<-0.65786,3.91224,-2.08822>,<-0.65474,3.91122,-2.08836>,
            
    /*4*/ <-0.61051,4.04696,-2.29607>

    /* stem 0.4.16*/ 
    /*0*/ <-0.80922,3.92043,-1.73102>,
    /*1*/ <-0.81285,3.91831,-1.73114>,<-0.80702,3.92104,-1.73455>,<-0.80778,3.92193,-1.72736>,
            
    /*2*/ <-0.92765,4.12007,-1.76837>,<-0.92377,4.12189,-1.77064>,<-0.92428,4.12248,-1.76585>,
            
    /*3*/ <-1.05576,4.29764,-1.85314>,<-1.05381,4.29851,-1.8543>,<-1.0543,4.29924,-1.85203>,
            
    /*4*/ <-1.17454,4.46729,-1.96446>

    /* stem 0.4.17*/ 
    /*0*/ <-0.83184,3.96358,-1.80608>,
    /*1*/ <-0.82878,3.96333,-1.80714>,<-0.83345,3.96638,-1.8064>,<-0.83329,3.96102,-1.8047>,
            
    /*2*/ <-0.90477,3.89755,-2.00773>,<-0.90789,3.89958,-2.00723>,<-0.90778,3.89601,-2.0061>,
            
    /*3*/ <-1.01657,3.92031,-2.20139>,<-1.01784,3.9214,-2.20054>,<-1.0181,3.91954,-2.20061>,
            
    /*4*/ <-1.10209,4.03477,-2.37435>

    /* stem 0.4.18*/ 
    /*0*/ <-0.87113,4.03854,-1.93647>,
    /*1*/ <-0.87205,4.03952,-1.93563>,<-0.87174,4.03774,-1.9377>,<-0.8696,4.03836,-1.93609>,
            
    /*2*/ <-0.82188,4.19397,-2.0619>,<-0.82168,4.19278,-2.06328>,<-0.82025,4.19319,-2.0622>,
            
    /*3*/ <-0.79388,4.38227,-2.13899>,<-0.79375,4.38191,-2.13982>,<-0.79304,4.38204,-2.13926>,
            
    /*4*/ <-0.85087,4.56732,-2.20801>

    /* stem 0.4.19*/ 
    /*0*/ <-0.89162,4.07762,-2.00446>,
    /*1*/ <-0.89166,4.07699,-2.00481>,<-0.89135,4.0782,-2.00479>,<-0.89185,4.07767,-2.00378>,
            
    /*2*/ <-1.07109,4.12363,-2.06833>,<-1.07089,4.12443,-2.06832>,<-1.07122,4.12408,-2.06765>,
            
    /*3*/ <-1.1965,4.26466,-2.12196>,<-1.19622,4.26494,-2.12186>,<-1.19649,4.26481,-2.12157>,
            
    /*4*/ <-1.26826,4.43391,-2.18997>

    /* stem 0.5*/ 
    /*0*/ <0,3.98748,0>,
    /*1*/ <-0.01321,3.98748,0.02288>,<0.00021,4.01212,0.00955>,<0.01334,4.00271,-0.01698>,
            <0.00804,3.97225,-0.02004>,<-0.00837,3.96284,0.0046>,
    /*2*/ <0.40499,3.89105,0.25823>,<0.41572,3.91076,0.24756>,<0.42623,3.90323,0.22634>,
            <0.42199,3.87887,0.22389>,<0.40886,3.87134,0.2436>,
    /*3*/ <0.86742,3.8763,0.42809>,<0.87168,3.89145,0.41811>,<0.87782,3.88582,0.40144>,
            <0.87735,3.86719,0.40112>,<0.87092,3.86131,0.41759>,
    /*4*/ <1.33161,3.89949,0.5831>,<1.33353,3.90957,0.57609>,<1.33756,3.90579,0.56497>,
            <1.33814,3.89338,0.5651>,<1.33446,3.88949,0.57631>,
    /*5*/ <1.80647,3.91681,0.7037>,<1.80724,3.92182,0.70011>,<1.80882,3.91988,0.69442>,
            <1.80902,3.91367,0.6945>,<1.80757,3.91177,0.70023>,
    /*6*/ <2.27054,4.02431,0.81642>

    /* stem 0.5.0*/ 
    /*0*/ <0.14176,3.95458,0.08184>,
    /*1*/ <0.14846,3.96316,0.07367>,<0.14746,3.94277,0.08546>,<0.12934,3.95782,0.0864>,
            
    /*2*/ <0.33788,4.16758,0.45143>,<0.33721,4.15398,0.45928>,<0.32513,4.16402,0.45991>,
            
    /*3*/ <0.58199,4.3787,0.79086>,<0.58195,4.37207,0.7951>,<0.57618,4.37733,0.79598>,
            
    /*4*/ <0.91597,4.56989,1.05839>

    /* stem 0.5.1*/ 
    /*0*/ <0.21367,3.9379,0.12336>,
    /*1*/ <0.21029,3.92509,0.12407>,<0.21955,3.94378,0.13369>,<0.21117,3.94481,0.11233>,
            
    /*2*/ <0.62267,3.81157,-0.04321>,<0.62884,3.82403,-0.03679>,<0.62325,3.82472,-0.05103>,
            
    /*3*/ <1.08196,3.81566,0.00118>,<1.08165,3.82259,0.00442>,<1.08239,3.82195,-0.00317>,
            
    /*4*/ <1.46825,3.96387,0.20337>

    /* stem 0.5.2*/ 
    /*0*/ <0.31806,3.91367,0.18363>,
    /*1*/ <0.31676,3.9245,0.19024>,<0.32966,3.90969,0.18015>,<0.30777,3.90683,0.18051>,
            
    /*2*/ <0.35305,3.69319,0.56809>,<0.36165,3.68332,0.56136>,<0.34705,3.68142,0.5616>,
            
    /*3*/ <0.52036,3.57683,0.96113>,<0.52485,3.572,0.95786>,<0.51816,3.56988,0.96008>,
            
    /*4*/ <0.6882,3.49673,1.36448>

    /* stem 0.5.3*/ 
    /*0*/ <0.37609,3.90021,0.21713>,
    /*1*/ <0.38122,3.89603,0.20657>,<0.37818,3.89423,0.22787>,<0.36886,3.91037,0.21696>,
            
    /*2*/ <0.72979,4.14761,0.28117>,<0.72776,4.14641,0.29538>,<0.72155,4.15717,0.2881>,
            
    /*3*/ <1.06225,4.38421,0.43945>,<1.05999,4.383,0.44618>,<1.05761,4.38875,0.44257>,
            
    /*4*/ <1.26223,4.64986,0.7246>

    /* stem 0.5.4*/ 
    /*0*/ <0.46915,3.88933,0.26023>,
    /*1*/ <0.46504,3.88514,0.27074>,<0.4776,3.89792,0.26007>,<0.46482,3.88495,0.24988>,
            
    /*2*/ <0.7685,3.58926,0.26683>,<0.77687,3.59778,0.25971>,<0.76836,3.58914,0.25292>,
            
    /*3*/ <1.16173,3.55117,0.41947>,<1.16391,3.5563,0.41531>,<1.16412,3.54971,0.4131>,
            
    /*4*/ <1.5397,3.6813,0.5619>

    /* stem 0.5.5*/ 
    /*0*/ <0.57394,3.88598,0.29994>,
    /*1*/ <0.57625,3.89605,0.29469>,<0.58089,3.87686,0.29827>,<0.56469,3.88503,0.30684>,
            
    /*2*/ <0.80347,4.00768,0.6177>,<0.80656,3.99488,0.62008>,<0.79576,4.00033,0.62579>,
            
    /*3*/ <1.09589,4.22642,0.79777>,<1.09892,4.22081,0.79977>,<1.09434,4.22371,0.80369>,
            
    /*4*/ <1.44827,4.34266,0.97481>

    /* stem 0.5.6*/ 
    /*0*/ <0.7115,3.88158,0.35206>,
    /*1*/ <0.71191,3.87078,0.35009>,<0.71428,3.88547,0.36196>,<0.70833,3.8885,0.34414>,
            
    /*2*/ <1.08451,3.90984,0.2323>,<1.08609,3.91964,0.24021>,<1.08212,3.92166,0.22833>,
            
    /*3*/ <1.46063,4.02356,0.26862>,<1.45889,4.02819,0.2726>,<1.45916,4.0293,0.26636>,
            
    /*4*/ <1.80802,4.20648,0.24484>

    /* stem 0.5.7*/ 
    /*0*/ <0.80993,3.87843,0.38936>,
    /*1*/ <0.80724,3.88516,0.39704>,<0.81866,3.88014,0.38366>,<0.8039,3.86999,0.38737>,
            
    /*2*/ <1.01063,3.67954,0.64365>,<1.01825,3.67619,0.63473>,<1.00841,3.66942,0.6372>,
            
    /*3*/ <1.20671,3.71695,0.96252>,<1.21174,3.71494,0.95971>,<1.208,3.71099,0.96246>,
            
    /*4*/ <1.41741,3.87603,1.23503>

    /* stem 0.5.8*/ 
    /*0*/ <0.90125,3.87783,0.42303>,
    /*1*/ <0.90458,3.87788,0.41341>,<0.90614,3.87235,0.43008>,<0.89304,3.88326,0.4256>,
            
    /*2*/ <1.1185,4.1672,0.49244>,<1.11954,4.16352,0.50355>,<1.11081,4.17079,0.50057>,
            
    /*3*/ <1.37207,4.42026,0.57782>,<1.3724,4.41816,0.5833>,<1.36857,4.42243,0.58201>,
            
    /*4*/ <1.64898,4.64545,0.66906>

    /* stem 0.5.9*/ 
    /*0*/ <1.00453,3.883,0.45876>,
    /*1*/ <1.00238,3.8767,0.46589>,<1.00874,3.89152,0.4609>,<1.00248,3.88076,0.4495>,
            
    /*2*/ <1.32354,3.72952,0.42832>,<1.32778,3.7394,0.425>,<1.3236,3.73222,0.4174>,
            
    /*3*/ <1.67886,3.74547,0.45265>,<1.67878,3.75081,0.45088>,<1.67923,3.74662,0.44716>,
            
    /*4*/ <1.99856,3.9004,0.42328>

    /* stem 0.5.10*/ 
    /*0*/ <1.11273,3.88841,0.4962>,
    /*1*/ <1.11283,3.89756,0.49457>,<1.12024,3.88327,0.4943>,<1.10512,3.88441,0.49972>,
            
    /*2*/ <1.23027,3.94928,0.81107>,<1.2352,3.93976,0.81088>,<1.22512,3.94051,0.8145>,
            
    /*3*/ <1.42642,4.13593,1.01458>,<1.42974,4.13177,1.01525>,<1.42561,4.13246,1.0186>,
            
    /*4*/ <1.63479,4.38858,1.10796>

    /* stem 0.5.11*/ 
    /*0*/ <1.20051,3.89281,0.52657>,
    /*1*/ <1.20233,3.88511,0.52243>,<1.20311,3.89406,0.53502>,<1.1961,3.89926,0.52225>,
            
    /*2*/ <1.48834,4.01255,0.4171>,<1.48886,4.01852,0.42549>,<1.48418,4.02198,0.41698>,
            
    /*3*/ <1.78039,4.13244,0.32004>,<1.78067,4.13532,0.32431>,<1.77848,4.13723,0.32005>,
            
    /*4*/ <2.03591,4.31549,0.21667>

    /* stem 0.5.12*/ 
    /*0*/ <1.30125,3.89785,0.56142>,
    /*1*/ <1.2985,3.90072,0.56895>,<1.30764,3.90182,0.55742>,<1.29761,3.89101,0.55788>,
            
    /*2*/ <1.50852,3.71205,0.71432>,<1.51461,3.71278,0.70664>,<1.50793,3.70557,0.70694>,
            
    /*3*/ <1.72989,3.69273,0.93808>,<1.73341,3.6929,0.93465>,<1.73158,3.68857,0.93608>,
            
    /*4*/ <1.92941,3.86572,1.11325>

    /* stem 0.5.13*/ 
    /*0*/ <1.3844,3.90134,0.58621>,
    /*1*/ <1.38628,3.90412,0.57875>,<1.38866,3.89516,0.58947>,<1.37827,3.90476,0.59042>,
            
    /*2*/ <1.5823,4.10386,0.70525>,<1.58388,4.0979,0.7124>,<1.57696,4.10429,0.71303>,
            
    /*3*/ <1.82436,4.24528,0.83105>,<1.82464,4.24193,0.83436>,<1.822,4.24578,0.83511>,
            
    /*4*/ <2.08723,4.3777,0.91756>

    /* stem 0.5.14*/ 
    /*0*/ <1.50717,3.90582,0.6188>,
    /*1*/ <1.50641,3.89917,0.6226>,<1.51154,3.91145,0.62172>,<1.50357,3.90685,0.61207>,
            
    /*2*/ <1.73876,3.79416,0.48057>,<1.74219,3.80234,0.47999>,<1.73687,3.79928,0.47356>,
            
    /*3*/ <1.98076,3.81835,0.3153>,<1.98083,3.82274,0.316>,<1.97862,3.82108,0.31252>,
            
    /*4*/ <2.22242,3.9338,0.19773>

    /* stem 0.5.15*/ 
    /*0*/ <1.64977,3.91103,0.65664>,
    /*1*/ <1.64923,3.91797,0.65774>,<1.65479,3.90851,0.65237>,<1.6453,3.90659,0.65981>,
            
    /*2*/ <1.82057,3.89537,0.87055>,<1.82428,3.88907,0.86698>,<1.81795,3.88779,0.87194>,
            
    /*3*/ <2.03578,3.94088,1.03258>,<2.03779,3.9378,1.03082>,<2.03547,3.93711,1.0341>,
            
    /*4*/ <2.25019,4.06234,1.1513>

    /* stem 0.5.16*/ 
    /*0*/ <1.77172,3.91547,0.68901>,
    /*1*/ <1.77296,3.91181,0.68484>,<1.77417,3.91492,0.69411>,<1.76802,3.9197,0.68808>,
            
    /*2*/ <1.96692,4.06597,0.6094>,<1.96773,4.06805,0.61558>,<1.96363,4.07123,0.61156>,
            
    /*3*/ <2.16544,4.21034,0.52732>,<2.16598,4.21139,0.53039>,<2.16395,4.21306,0.52842>,
            
    /*4*/ <2.32014,4.41519,0.48875>

    /* stem 0.5.17*/ 
    /*0*/ <1.8872,3.93524,0.71881>,
    /*1*/ <1.88612,3.93526,0.72305>,<1.88986,3.93832,0.71721>,<1.88562,3.93213,0.71616>,
            
    /*2*/ <2.07984,3.79441,0.77186>,<2.08234,3.79645,0.76797>,<2.07951,3.79232,0.76727>,
            
    /*3*/ <2.31906,3.78928,0.82237>,<2.31955,3.79056,0.82024>,<2.3195,3.78804,0.82021>,
            
    /*4*/ <2.54317,3.8801,0.78336>

    /* stem 0.5.18*/ 
    /*0*/ <1.96403,3.95309,0.73837>,
    /*1*/ <1.96422,3.95527,0.73564>,<1.96677,3.95108,0.73919>,<1.9611,3.95292,0.74027>,
            
    /*2*/ <2.04573,4.1237,0.87727>,<2.04744,4.12091,0.87965>,<2.04365,4.12213,0.88037>,
            
    /*3*/ <2.20412,4.27193,0.96595>,<2.20495,4.27043,0.96702>,<2.20346,4.27154,0.96782>,
            
    /*4*/ <2.36969,4.43065,1.01477>

    /* stem 0.5.19*/ 
    /*0*/ <2.08048,3.98014,0.76802>,
    /*1*/ <2.08084,3.97806,0.76851>,<2.08141,3.98171,0.7692>,<2.07919,3.98066,0.76635>,
            
    /*2*/ <2.25451,3.97688,0.63364>,<2.25489,3.97931,0.63409>,<2.25342,3.97861,0.6322>,
            
    /*3*/ <2.45027,4.0161,0.54106>,<2.45021,4.0173,0.54142>,<2.44975,4.01696,0.54031>,
            
    /*4*/ <2.63272,4.13431,0.50652>

    /* stem 0.5.20*/ 
    /*0*/ <2.218,4.0121,0.80304>,
    /*1*/ <2.21782,4.01261,0.8033>,<2.21847,4.01211,0.80266>,<2.21772,4.01158,0.80315>,
            
    /*2*/ <2.34333,3.97859,0.95845>,<2.34377,3.97826,0.95803>,<2.34327,3.97791,0.95835>,
            
    /*3*/ <2.47809,4.03849,1.09695>,<2.47834,4.03834,1.09677>,<2.47817,4.03816,1.09701>,
            
    /*4*/ <2.63162,4.15371,1.16121>

    /* stem 0.6*/ 
    /*0*/ <0,4.14741,0>,
    /*1*/ <-0.00483,4.14741,-0.02739>,<-0.00587,4.17348,-0.00769>,<0.0012,4.16352,0.02263>,
            <0.00661,4.13129,0.02168>,<0.00289,4.12133,-0.00923>,
    /*2*/ <-0.4997,4.06152,0.06552>,<-0.50054,4.08238,0.08128>,<-0.49488,4.07441,0.10554>,
            <-0.49055,4.04863,0.10477>,<-0.49353,4.04067,0.08004>,
    /*3*/ <-0.98769,4.00418,0.21373>,<-0.98621,4.02004,0.22518>,<-0.98033,4.01416,0.24294>,
            <-0.97818,3.99467,0.24247>,<-0.98273,3.9885,0.22442>,
    /*4*/ <-1.48193,4.06654,0.3204>,<-1.47915,4.07714,0.32753>,<-1.47711,4.0733,0.33986>,
            <-1.47863,4.06033,0.34036>,<-1.48162,4.05615,0.32833>,
    /*5*/ <-1.96143,4.18941,0.44865>,<-1.95925,4.19455,0.45205>,<-1.95818,4.1926,0.45819>,
            <-1.9597,4.18625,0.45859>,<-1.96171,4.18428,0.45269>,
    /*6*/ <-2.40111,4.37305,0.63468>

    /* stem 0.6.0*/ 
    /*0*/ <-0.19064,4.11439,0.03362>,
    /*1*/ <-0.19026,4.1234,0.04462>,<-0.19872,4.10268,0.03428>,<-0.18295,4.11707,0.02195>,
            
    /*2*/ <-0.56469,4.3678,-0.14893>,<-0.57033,4.35398,-0.15582>,<-0.55981,4.36357,-0.16404>,
            
    /*3*/ <-0.93533,4.65919,-0.26464>,<-0.93918,4.65294,-0.26833>,<-0.93408,4.65773,-0.27263>,
            
    /*4*/ <-1.32637,4.93405,-0.17821>

    /* stem 0.6.1*/ 
    /*0*/ <-0.27806,4.09924,0.04903>,
    /*1*/ <-0.27622,4.08579,0.04626>,<-0.28905,4.10594,0.04388>,<-0.26892,4.106,0.05695>,
            
    /*2*/ <-0.52844,3.97598,0.43523>,<-0.53699,3.98941,0.43364>,<-0.52357,3.98945,0.44235>,
            
    /*3*/ <-0.87603,4.04653,0.75834>,<-0.87776,4.0536,0.75502>,<-0.87237,4.05316,0.76092>,
            
    /*4*/ <-1.24768,4.22145,1.00166>

    /* stem 0.6.2*/ 
    /*0*/ <-0.34674,4.08735,0.06114>,
    /*1*/ <-0.34986,4.09893,0.05481>,<-0.35271,4.08424,0.07291>,<-0.33765,4.07888,0.0557>,
            
    /*2*/ <-0.69143,3.87602,-0.17454>,<-0.69333,3.86623,-0.16246>,<-0.68329,3.86266,-0.17394>,
            
    /*3*/ <-1.126,3.82661,-0.33325>,<-1.12765,3.82171,-0.32738>,<-1.12486,3.81891,-0.33414>,
            
    /*4*/ <-1.59134,3.85231,-0.29084>

    /* stem 0.6.3*/ 
    /*0*/ <-0.4378,4.07158,0.0772>,
    /*1*/ <-0.4349,4.06714,0.08925>,<-0.44692,4.06545,0.06994>,<-0.43157,4.08214,0.0724>,
            
    /*2*/ <-0.75832,4.33917,0.2623>,<-0.76633,4.33805,0.24943>,<-0.75609,4.34917,0.25107>,
            
    /*3*/ <-1.10826,4.63346,0.30488>,<-1.11051,4.6319,0.29778>,<-1.10559,4.63756,0.29906>,
            
    /*4*/ <-1.39831,4.98486,0.26283>

    /* stem 0.6.4*/ 
    /*0*/ <-0.54868,4.05532,0.10287>,
    /*1*/ <-0.55154,4.05091,0.09131>,<-0.5551,4.06516,0.10767>,<-0.5394,4.04988,0.10961>,
            
    /*2*/ <-0.84422,3.7734,0.27416>,<-0.84659,3.7829,0.28507>,<-0.83613,3.77272,0.28636>,
            
    /*3*/ <-1.22976,3.60828,0.41511>,<-1.23018,3.61349,0.42025>,<-1.2269,3.60711,0.42175>,
            
    /*4*/ <-1.65364,3.66102,0.53342>

    /* stem 0.6.5*/ 
    /*0*/ <-0.64065,4.04452,0.12973>,
    /*1*/ <-0.6401,4.05515,0.13589>,<-0.64681,4.03499,0.13446>,<-0.63503,4.04342,0.11885>,
            
    /*2*/ <-0.99898,4.18526,-0.06479>,<-1.00346,4.17182,-0.06574>,<-0.9956,4.17744,-0.07615>,
            
    /*3*/ <-1.38151,4.36895,-0.12846>,<-1.38457,4.36255,-0.12889>,<-1.38208,4.3657,-0.13475>,
            
    /*4*/ <-1.71667,4.63815,-0.14642>

    /* stem 0.6.6*/ 
    /*0*/ <-0.72205,4.03496,0.15351>,
    /*1*/ <-0.72018,4.02328,0.15522>,<-0.73116,4.03861,0.1467>,<-0.71482,4.04298,0.15862>,
            
    /*2*/ <-0.97061,4.03676,0.49341>,<-0.97793,4.04698,0.48772>,<-0.96704,4.04989,0.49567>,
            
    /*3*/ <-1.31667,4.15624,0.7065>,<-1.31791,4.16116,0.70183>,<-1.31403,4.16255,0.70735>,
            
    /*4*/ <-1.67293,4.38348,0.71209>

    /* stem 0.6.7*/ 
    /*0*/ <-0.85382,4.01948,0.19201>,
    /*1*/ <-0.85706,4.02669,0.18381>,<-0.85873,4.01995,0.20227>,<-0.84567,4.01181,0.18994>,
            
    /*2*/ <-1.13627,3.75945,0.06461>,<-1.13738,3.75496,0.07692>,<-1.12868,3.74953,0.0687>,
            
    /*3*/ <-1.49968,3.58914,0.1205>,<-1.49838,3.58834,0.12689>,<-1.49683,3.5836,0.12261>,
            
    /*4*/ <-1.8565,3.62596,0.30703>

    /* stem 0.6.8*/ 
    /*0*/ <-0.91791,4.01195,0.21073>,
    /*1*/ <-0.91481,4.01204,0.2214>,<-0.92598,4.0051,0.20735>,<-0.91295,4.01872,0.20344>,
            
    /*2*/ <-1.18563,4.29219,0.29415>,<-1.19308,4.28757,0.28478>,<-1.1844,4.29664,0.28218>,
            
    /*3*/ <-1.48857,4.55004,0.29638>,<-1.49125,4.54701,0.29141>,<-1.48715,4.55183,0.29039>,
            
    /*4*/ <-1.81143,4.77813,0.32318>

    /* stem 0.6.9*/ 
    /*0*/ <-1.07321,4.01564,0.24819>,
    /*1*/ <-1.07561,4.00885,0.24059>,<-1.07935,4.02392,0.24994>,<-1.06466,4.01413,0.25403>,
            
    /*2*/ <-1.27788,3.80887,0.48813>,<-1.28037,3.81892,0.49436>,<-1.27058,3.81239,0.49709>,
            
    /*3*/ <-1.48635,3.77635,0.80412>,<-1.48592,3.7823,0.80506>,<-1.48179,3.77857,0.80741>,
            
    /*4*/ <-1.73124,3.87332,1.07477>

    /* stem 0.6.10*/ 
    /*0*/ <-1.15783,4.02626,0.26549>,
    /*1*/ <-1.15631,4.03618,0.26683>,<-1.16355,4.02109,0.27204>,<-1.15363,4.02152,0.2576>,
            
    /*2*/ <-1.45397,4.10576,0.06443>,<-1.4588,4.0957,0.0679>,<-1.45219,4.09599,0.05828>,
            
    /*3*/ <-1.80965,4.19081,0.04861>,<-1.81104,4.18565,0.05096>,<-1.81065,4.1862,0.04516>,
            
    /*4*/ <-2.13611,4.34035,0.11892>

    /* stem 0.6.11*/ 
    /*0*/ <-1.30163,4.04433,0.29489>,
    /*1*/ <-1.30163,4.0362,0.29987>,<-1.30921,4.04668,0.28961>,<-1.29405,4.0501,0.29519>,
            
    /*2*/ <-1.43994,4.2063,0.57126>,<-1.44499,4.21329,0.56441>,<-1.43489,4.21557,0.56814>,
            
    /*3*/ <-1.63793,4.41122,0.77461>,<-1.63964,4.41403,0.77019>,<-1.63515,4.41566,0.77292>,
            
    /*4*/ <-1.88395,4.61614,0.91398>

    /* stem 0.6.12*/ 
    /*0*/ <-1.44327,4.06212,0.32385>,
    /*1*/ <-1.44461,4.06504,0.31549>,<-1.44735,4.06617,0.33073>,<-1.43784,4.05514,0.32534>,
            
    /*2*/ <-1.70126,3.85731,0.2872>,<-1.70309,3.85806,0.29736>,<-1.69675,3.85071,0.29377>,
            
    /*3*/ <-2.01905,3.80264,0.36682>,<-2.01809,3.80396,0.37172>,<-2.01762,3.79903,0.37024>,
            
    /*4*/ <-2.34031,3.87548,0.39561>

    /* stem 0.6.13*/ 
    /*0*/ <-1.55058,4.0848,0.34941>,
    /*1*/ <-1.54791,4.08765,0.35699>,<-1.55713,4.07936,0.34896>,<-1.54669,4.0874,0.34228>,
            
    /*2*/ <-1.75055,4.33142,0.33359>,<-1.75669,4.3259,0.32823>,<-1.74973,4.33125,0.32378>,
            
    /*3*/ <-1.97754,4.55222,0.35521>,<-1.9806,4.5494,0.35258>,<-1.97767,4.55263,0.3503>,
            
    /*4*/ <-2.1979,4.78061,0.33268>

    /* stem 0.6.14*/ 
    /*0*/ <-1.63128,4.10542,0.37003>,
    /*1*/ <-1.63394,4.09853,0.36649>,<-1.63538,4.11243,0.36894>,<-1.62451,4.10531,0.37465>,
            
    /*2*/ <-1.80375,4.03943,0.61603>,<-1.80471,4.04871,0.61766>,<-1.79746,4.04395,0.62147>,
            
    /*3*/ <-2.0203,4.1017,0.82719>,<-2.01949,4.10634,0.8267>,<-2.01708,4.10385,0.82991>,
            
    /*4*/ <-2.27456,4.26932,0.87162>

    /* stem 0.6.15*/ 
    /*0*/ <-1.72577,4.12956,0.39417>,
    /*1*/ <-1.72432,4.13703,0.39239>,<-1.72988,4.12781,0.40058>,<-1.7231,4.12385,0.38955>,
            
    /*2*/ <-1.97461,4.14549,0.23554>,<-1.97832,4.13935,0.241>,<-1.9738,4.13671,0.23365>,
            
    /*3*/ <-2.21209,4.19375,0.06776>,<-2.21441,4.19067,0.0701>,<-2.21207,4.18944,0.06644>,
            
    /*4*/ <-2.48981,4.2923,0.04794>

    /* stem 0.6.16*/ 
    /*0*/ <-1.83813,4.15827,0.42288>,
    /*1*/ <-1.83784,4.15393,0.42833>,<-1.84323,4.15762,0.41817>,<-1.83331,4.16326,0.42215>,
            
    /*2*/ <-1.99809,4.33196,0.57556>,<-2.00168,4.33443,0.56879>,<-1.99507,4.33818,0.57144>,
            
    /*3*/ <-2.1699,4.52624,0.68581>,<-2.17131,4.52713,0.68214>,<-2.16812,4.52911,0.68361>,
            
    /*4*/ <-2.40274,4.66029,0.76834>

    /* stem 0.6.17*/ 
    /*0*/ <-1.90477,4.1753,0.43991>,
    /*1*/ <-1.90631,4.17529,0.4339>,<-1.90591,4.1803,0.44339>,<-1.9021,4.1703,0.44243>,
            
    /*2*/ <-2.15154,4.07542,0.49896>,<-2.15127,4.07877,0.50528>,<-2.14873,4.0721,0.50464>,
            
    /*3*/ <-2.41491,4.09641,0.56618>,<-2.41403,4.0982,0.56916>,<-2.4143,4.09463,0.56922>,
            
    /*4*/ <-2.62664,4.23491,0.66877>

    /* stem 0.6.18*/ 
    /*0*/ <-2.0155,4.21251,0.47675>,
    /*1*/ <-2.01306,4.21525,0.47993>,<-2.01964,4.21033,0.47809>,<-2.01381,4.21194,0.47222>,
            
    /*2*/ <-2.14752,4.42149,0.40316>,<-2.15191,4.41821,0.40193>,<-2.14803,4.41929,0.39802>,
            
    /*3*/ <-2.28218,4.62683,0.32427>,<-2.28436,4.62518,0.32363>,<-2.2824,4.62572,0.3217>,
            
    /*4*/ <-2.44528,4.82606,0.33345>

    /* stem 0.6.19*/ 
    /*0*/ <-2.14439,4.26617,0.52954>,
    /*1*/ <-2.14572,4.26322,0.5293>,<-2.14585,4.26871,0.52816>,<-2.14161,4.26657,0.53114>,
            
    /*2*/ <-2.26794,4.30314,0.73193>,<-2.26803,4.3068,0.73117>,<-2.26521,4.30537,0.73316>,
            
    /*3*/ <-2.39897,4.4372,0.88289>,<-2.39851,4.43874,0.88193>,<-2.39744,4.43818,0.88336>,
            
    /*4*/ <-2.55111,4.59215,0.98516>

    /* stem 0.6.20*/ 
    /*0*/ <-2.23405,4.3035,0.56626>,
    /*1*/ <-2.23379,4.30524,0.56511>,<-2.23438,4.30364,0.56833>,<-2.23398,4.30161,0.56533>,
            
    /*2*/ <-2.45826,4.31397,0.52902>,<-2.45866,4.31289,0.53117>,<-2.45839,4.31154,0.52916>,
            
    /*3*/ <-2.67165,4.3893,0.5511>,<-2.67173,4.38876,0.55219>,<-2.67205,4.38815,0.55118>,
            
    /*4*/ <-2.83393,4.54706,0.53114>

    /* stem 0.6.21*/ 
    /*0*/ <-2.33044,4.34362,0.60573>,
    /*1*/ <-2.33024,4.3433,0.60654>,<-2.33123,4.34345,0.60536>,<-2.32984,4.34412,0.6053>,
            
    /*2*/ <-2.41235,4.51939,0.69654>,<-2.41301,4.51949,0.69576>,<-2.41209,4.51994,0.69571>,
            
    /*3*/ <-2.51203,4.68483,0.78897>,<-2.51235,4.68486,0.78857>,<-2.51191,4.68512,0.78857>,
            
    /*4*/ <-2.6425,4.84105,0.85556>

    /* stem 0.7*/ 
    /*0*/ <0.00108,4.26915,0.00009>,
    /*1*/ <0.02319,4.2686,0.01865>,<0.01112,4.29608,0.00281>,<-0.01483,4.28634,-0.01679>,
            <-0.01879,4.25284,-0.01306>,<0.00471,4.24188,0.00885>,
    /*2*/ <0.35202,4.18478,-0.38459>,<0.34236,4.20677,-0.39727>,<0.3216,4.19897,-0.41294>,
            <0.31843,4.17217,-0.40996>,<0.33723,4.1634,-0.39244>,
    /*3*/ <0.72995,4.17317,-0.74781>,<0.72221,4.18984,-0.75658>,<0.70877,4.18387,-0.77067>,
            <0.70821,4.16351,-0.77061>,<0.7213,4.1569,-0.75647>,
    /*4*/ <1.11753,4.14663,-1.10334>,<1.11275,4.15773,-1.10951>,<1.10393,4.15376,-1.11904>,
            <1.10326,4.14021,-1.11875>,<1.11167,4.13579,-1.10905>,
    /*5*/ <1.48132,4.19797,-1.48225>,<1.47814,4.20348,-1.48462>,<1.47365,4.20147,-1.4893>,
            <1.47406,4.19471,-1.48982>,<1.4788,4.19255,-1.48547>,
    /*6*/ <1.83464,4.31878,-1.85424>

    /* stem 0.7.0*/ 
    /*0*/ <0.09989,4.24426,-0.11837>,
    /*1*/ <0.09223,4.25398,-0.1268>,<0.10478,4.23142,-0.12432>,<0.10266,4.24739,-0.10399>,
            
    /*2*/ <0.5295,4.47789,-0.25717>,<0.53787,4.46284,-0.25551>,<0.53646,4.47349,-0.24196>,
            
    /*3*/ <0.84213,4.72353,-0.56809>,<0.84726,4.71659,-0.56852>,<0.84861,4.72258,-0.56244>,
            
    /*4*/ <1.09741,4.985,-0.92041>

    /* stem 0.7.1*/ 
    /*0*/ <0.18656,4.22244,-0.22228>,
    /*1*/ <0.18682,4.20839,-0.21911>,<0.19881,4.22936,-0.22529>,<0.17404,4.22955,-0.22243>,
            
    /*2*/ <0.13088,4.10463,-0.6966>,<0.13887,4.11861,-0.70072>,<0.12236,4.11873,-0.69881>,
            
    /*3*/ <0.03048,4.08042,-1.17904>,<0.03481,4.08739,-1.18036>,<0.02668,4.0878,-1.17869>,
            
    /*4*/ <-0.09005,4.26319,-1.62165>

    /* stem 0.7.2*/ 
    /*0*/ <0.23018,4.21145,-0.27457>,
    /*1*/ <0.23701,4.22337,-0.27138>,<0.22592,4.20908,-0.28781>,<0.22761,4.20189,-0.26453>,
            
    /*2*/ <0.65652,4.00385,-0.36952>,<0.64913,3.99433,-0.38048>,<0.65026,3.98953,-0.36495>,
            
    /*3*/ <1.07752,3.92343,-0.58953>,<1.0738,3.91883,-0.59512>,<1.0767,3.91542,-0.58831>,
            
    /*4*/ <1.31459,3.94837,-1.01053>

    /* stem 0.7.3*/ 
    /*0*/ <0.31076,4.19115,-0.37118>,
    /*1*/ <0.30045,4.18681,-0.37887>,<0.32246,4.18427,-0.371>,<0.30938,4.20238,-0.36368>,
            
    /*2*/ <0.46162,4.4465,-0.73362>,<0.47629,4.4448,-0.72837>,<0.46757,4.45688,-0.72349>,
            
    /*3*/ <0.72813,4.56384,-1.10098>,<0.73461,4.56239,-1.09683>,<0.73148,4.56957,-1.09681>,
            
    /*4*/ <1.10565,4.71467,-1.33666>

    /* stem 0.7.4*/ 
    /*0*/ <0.38279,4.18373,-0.44502>,
    /*1*/ <0.39112,4.17904,-0.43601>,<0.38659,4.19339,-0.45309>,<0.37066,4.17878,-0.44597>,
            
    /*2*/ <0.53807,3.87145,-0.73858>,<0.53504,3.88102,-0.74996>,<0.52442,3.87127,-0.74521>,
            
    /*3*/ <0.81675,3.80557,-1.09414>,<0.81369,3.81152,-1.09772>,<0.81078,3.80458,-1.09872>,
            
    /*4*/ <1.10469,3.95313,-1.4159>

    /* stem 0.7.5*/ 
    /*0*/ <0.44582,4.1818,-0.50431>,
    /*1*/ <0.44175,4.19297,-0.50901>,<0.44842,4.17211,-0.51223>,<0.44729,4.18032,-0.4917>,
            
    /*2*/ <0.86468,4.32911,-0.54032>,<0.86913,4.3152,-0.54247>,<0.86838,4.32067,-0.52879>,
            
    /*3*/ <1.29504,4.44564,-0.54875>,<1.29701,4.43856,-0.5495>,<1.29634,4.44151,-0.54277>,
            
    /*4*/ <1.66568,4.66748,-0.65151>

    /* stem 0.7.6*/ 
    /*0*/ <0.53468,4.17908,-0.5879>,
    /*1*/ <0.53289,4.16703,-0.58941>,<0.54609,4.18362,-0.58774>,<0.52506,4.18659,-0.58655>,
            
    /*2*/ <0.51728,4.22705,-1.01569>,<0.52608,4.23811,-1.01457>,<0.51206,4.2401,-1.01378>,
            
    /*3*/ <0.49309,4.44407,-1.39049>,<0.49748,4.44903,-1.38796>,<0.49048,4.44973,-1.3871>,
            
    /*4*/ <0.60851,4.61649,-1.76777>

    /* stem 0.7.7*/ 
    /*0*/ <0.61762,4.17654,-0.66592>,
    /*1*/ <0.62403,4.18398,-0.65935>,<0.61589,4.17877,-0.67739>,<0.61294,4.16686,-0.66102>,
            
    /*2*/ <0.9671,3.96702,-0.75524>,<0.96168,3.96354,-0.76726>,<0.95971,3.95561,-0.75635>,
            
    /*3*/ <1.33787,3.93458,-0.94005>,<1.33484,3.93312,-0.94599>,<1.33654,3.9281,-0.94169>,
            
    /*4*/ <1.56495,4.03208,-1.27678>

    /* stem 0.7.8*/ 
    /*0*/ <0.69877,4.17405,-0.74226>,
    /*1*/ <0.69099,4.17424,-0.75053>,<0.70778,4.16718,-0.74308>,<0.69755,4.18074,-0.73316>,
            
    /*2*/ <0.89966,4.46659,-0.93487>,<0.91085,4.46188,-0.9299>,<0.90403,4.47092,-0.92328>,
            
    /*3*/ <1.07368,4.77932,-1.12068>,<1.07957,4.77738,-1.11853>,<1.07597,4.78152,-1.11494>,
            
    /*4*/ <1.33395,5.076,-1.21118>

    /* stem 0.7.9*/ 
    /*0*/ <0.7502,4.17128,-0.78924>,
    /*1*/ <0.75551,4.16402,-0.78277>,<0.7557,4.17982,-0.79366>,<0.73939,4.16999,-0.7913>,
            
    /*2*/ <0.84021,3.94695,-1.10216>,<0.84033,3.95748,-1.10941>,<0.82946,3.95093,-1.10784>,
            
    /*3*/ <0.90847,3.82533,-1.47411>,<0.90822,3.83138,-1.47618>,<0.9029,3.82784,-1.476>,
            
    /*4*/ <1.0635,3.89547,-1.83197>

    /* stem 0.7.10*/ 
    /*0*/ <0.85132,4.1644,-0.87998>,
    /*1*/ <0.85061,4.17479,-0.88156>,<0.85309,4.15795,-0.88811>,<0.85027,4.16047,-0.87027>,
            
    /*2*/ <1.22445,4.20509,-0.82691>,<1.2261,4.19386,-0.83128>,<1.22422,4.19554,-0.81938>,
            
    /*3*/ <1.54458,4.40056,-0.84852>,<1.54741,4.39574,-0.85093>,<1.54734,4.39653,-0.8449>,
            
    /*4*/ <1.81266,4.64842,-0.94746>

    /* stem 0.7.11*/ 
    /*0*/ <0.97559,4.15595,-0.99148>,
    /*1*/ <0.97188,4.1475,-0.99498>,<0.98518,4.15658,-0.98925>,<0.96971,4.16377,-0.99022>,
            
    /*2*/ <1.04403,4.25782,-1.32887>,<1.0529,4.26387,-1.32505>,<1.04258,4.26866,-1.32569>,
            
    /*3*/ <1.0985,4.48533,-1.60388>,<1.10266,4.48791,-1.60098>,<1.09729,4.48975,-1.60051>,
            
    /*4*/ <1.1866,4.77539,-1.79792>

    /* stem 0.7.12*/ 
    /*0*/ <1.08093,4.14879,-1.086>,
    /*1*/ <1.08692,4.15182,-1.07956>,<1.08074,4.15277,-1.09442>,<1.07512,4.14178,-1.08404>,
            
    /*2*/ <1.31788,3.92653,-1.19286>,<1.31376,3.92716,-1.20276>,<1.31001,3.91984,-1.19584>,
            
    /*3*/ <1.53914,3.8165,-1.43067>,<1.53571,3.8179,-1.43456>,<1.53552,3.81296,-1.43246>,
            
    /*4*/ <1.76614,3.81964,-1.68616>

    /* stem 0.7.13*/ 
    /*0*/ <1.13732,4.15066,-1.13995>,
    /*1*/ <1.13109,4.15382,-1.14563>,<1.14292,4.14413,-1.1426>,<1.13794,4.15403,-1.13163>,
            
    /*2*/ <1.34847,4.38166,-1.25255>,<1.35635,4.3752,-1.25052>,<1.35303,4.3818,-1.24321>,
            
    /*3*/ <1.55962,4.62105,-1.34584>,<1.56366,4.61794,-1.34483>,<1.56178,4.62104,-1.34111>,
            
    /*4*/ <1.78893,4.84499,-1.43518>

    /* stem 0.7.14*/ 
    /*0*/ <1.21123,4.16096,-1.21526>,
    /*1*/ <1.21474,4.15351,-1.21283>,<1.21625,4.16766,-1.21717>,<1.20268,4.16171,-1.21579>,
            
    /*2*/ <1.22407,4.06136,-1.51896>,<1.22508,4.0708,-1.52185>,<1.21604,4.06683,-1.52094>,
            
    /*3*/ <1.3467,4.0697,-1.81497>,<1.34668,4.07466,-1.81488>,<1.34273,4.07219,-1.81659>,
            
    /*4*/ <1.47095,4.12522,-2.1048>

    /* stem 0.7.15*/ 
    /*0*/ <1.28104,4.17069,-1.28641>,
    /*1*/ <1.28158,4.17872,-1.28479>,<1.27988,4.16813,-1.29412>,<1.28168,4.16523,-1.28033>,
            
    /*2*/ <1.58609,4.16432,-1.32742>,<1.58496,4.15727,-1.33364>,<1.58615,4.15533,-1.32444>,
            
    /*3*/ <1.86478,4.24411,-1.42667>,<1.86461,4.24072,-1.42997>,<1.8664,4.23977,-1.42569>,
            
    /*4*/ <2.05589,4.45835,-1.53419>

    /* stem 0.7.16*/ 
    /*0*/ <1.36367,4.18221,-1.37061>,
    /*1*/ <1.35982,4.17744,-1.37503>,<1.37112,4.18134,-1.36968>,<1.36006,4.18786,-1.36711>,
            
    /*2*/ <1.41032,4.35356,-1.60444>,<1.41785,4.35616,-1.60087>,<1.41048,4.36051,-1.59916>,
            
    /*3*/ <1.44213,4.46846,-1.87142>,<1.44611,4.4699,-1.87035>,<1.44262,4.47244,-1.86968>,
            
    /*4*/ <1.50395,4.66616,-2.08067>

    /* stem 0.7.17*/ 
    /*0*/ <1.43391,4.192,-1.44219>,
    /*1*/ <1.43852,4.19193,-1.43767>,<1.43449,4.19587,-1.44733>,<1.42872,4.18821,-1.44156>,
            
    /*2*/ <1.57016,3.98677,-1.57845>,<1.56747,3.98939,-1.58489>,<1.56363,3.98429,-1.58105>,
            
    /*3*/ <1.73983,3.83715,-1.74578>,<1.73827,3.8387,-1.74879>,<1.73687,3.83554,-1.74739>,
            
    /*4*/ <1.92501,3.82351,-1.95755>

    /* stem 0.7.18*/ 
    /*0*/ <1.53907,4.21894,-1.54999>,
    /*1*/ <1.53598,4.22196,-1.55201>,<1.54119,4.21557,-1.55263>,<1.54006,4.21929,-1.54533>,
            
    /*2*/ <1.73402,4.3867,-1.60549>,<1.73749,4.38243,-1.6059>,<1.73675,4.38491,-1.60104>,
            
    /*3*/ <1.92845,4.52075,-1.72119>,<1.92997,4.51846,-1.72132>,<1.93015,4.5201,-1.71912>,
            
    /*4*/ <2.09179,4.63728,-1.89107>

    /* stem 0.7.19*/ 
    /*0*/ <1.629,4.24932,-1.64256>,
    /*1*/ <1.62991,4.24613,-1.64272>,<1.63129,4.25171,-1.64273>,<1.62579,4.25011,-1.64222>,
            
    /*2*/ <1.60518,4.25247,-1.88858>,<1.6061,4.25619,-1.88859>,<1.60243,4.25513,-1.88825>,
            
    /*3*/ <1.63277,4.33626,-2.12006>,<1.63318,4.33801,-2.11939>,<1.63136,4.33752,-2.11978>,
            
    /*4*/ <1.67967,4.51239,-2.28767>

    /* stem 0.7.20*/ 
    /*0*/ <1.68165,4.2671,-1.69675>,
    /*1*/ <1.68221,4.26917,-1.69553>,<1.68167,4.26709,-1.69923>,<1.68107,4.26505,-1.69551>,
            
    /*2*/ <1.91121,4.20486,-1.69346>,<1.91085,4.20346,-1.69592>,<1.91045,4.20211,-1.69344>,
            
    /*3*/ <2.12402,4.21051,-1.79956>,<2.12346,4.20991,-1.80073>,<2.12399,4.20909,-1.79969>,
            
    /*4*/ <2.32485,4.23712,-1.92419>

    /* stem 0.7.21*/ 
    /*0*/ <1.77528,4.29873,-1.79313>,
    /*1*/ <1.77468,4.29842,-1.79381>,<1.7762,4.29845,-1.79313>,<1.77496,4.29932,-1.79245>,
            
    /*2*/ <1.8276,4.47298,-1.91912>,<1.82861,4.473,-1.91867>,<1.82779,4.47358,-1.91821>,
            
    /*3*/ <1.91798,4.65008,-2.01657>,<1.91844,4.65001,-2.01628>,<1.91803,4.65033,-2.01608>,
            
    /*4*/ <2.03231,4.81105,-2.11656>

    /* stem 0.8*/ 
    /*0*/ <0.00616,4.48852,0.00052>,
    /*1*/ <-0.02464,4.48923,0.00052>,<-0.00268,4.51786,0.00368>,<0.03149,4.50594,0.00247>,
            <0.03066,4.46994,-0.00144>,<-0.00403,4.45962,-0.00265>,
    /*2*/ <-0.01986,4.42903,0.55352>,<-0.00229,4.45193,0.55605>,<0.02505,4.44239,0.55508>,
            <0.02438,4.4136,0.55195>,<-0.00337,4.40534,0.55099>,
    /*3*/ <-0.02832,4.48981,1.10569>,<-0.01513,4.50701,1.10414>,<0.00536,4.49991,1.10547>,
            <0.00484,4.47831,1.10784>,<-0.01598,4.47208,1.10798>,
    /*4*/ <-0.09915,4.62175,1.63922>,<-0.0904,4.63319,1.63765>,<-0.07688,4.62894,1.64065>,
            <-0.07727,4.61487,1.64408>,<-0.09103,4.61042,1.64319>,
    /*5*/ <-0.24806,4.83524,2.12876>,<-0.24369,4.84091,2.12768>,<-0.23719,4.83929,2.13044>,
            <-0.23756,4.83262,2.13324>,<-0.24427,4.83011,2.1322>,
    /*6*/ <-0.40061,5.12841,2.5761>

    /* stem 0.8.0*/ 
    /*0*/ <0.00575,4.47048,0.16655>,
    /*1*/ <0.01821,4.4804,0.16766>,<0.00583,4.45663,0.1745>,<-0.00681,4.47441,0.15749>,
            
    /*2*/ <-0.21464,4.71746,0.58853>,<-0.2229,4.70161,0.59309>,<-0.23132,4.71347,0.58175>,
            
    /*3*/ <-0.25004,5.01226,1.03048>,<-0.25421,5.0053,1.03486>,<-0.25923,5.01155,1.0303>,
            
    /*4*/ <-0.36602,5.33887,1.44021>

    /* stem 0.8.1*/ 
    /*0*/ <0.00558,4.46328,0.23284>,
    /*1*/ <0.0025,4.448,0.23117>,<-0.00287,4.47194,0.24282>,<0.01711,4.46992,0.22452>,
            
    /*2*/ <0.34616,4.34195,0.61806>,<0.34258,4.35791,0.62583>,<0.3559,4.35656,0.61363>,
            
    /*3*/ <0.61482,4.29658,1.0718>,<0.61209,4.30483,1.07433>,<0.61979,4.30384,1.06967>,
            
    /*4*/ <0.79039,4.40943,1.5586>

    /* stem 0.8.2*/ 
    /*0*/ <0.00533,4.4526,0.33118>,
    /*1*/ <-0.00199,4.46592,0.3326>,<0.01828,4.45015,0.33888>,<-0.00028,4.44174,0.32204>,
            
    /*2*/ <-0.27112,4.2697,0.72719>,<-0.25761,4.25919,0.73138>,<-0.26998,4.25358,0.72015>,
            
    /*3*/ <-0.51457,4.41203,1.15297>,<-0.5092,4.40697,1.1578>,<-0.51671,4.40364,1.15461>,
            
    /*4*/ <-0.69968,4.64911,1.57177>

    /* stem 0.8.3*/ 
    /*0*/ <0.0051,4.44223,0.42664>,
    /*1*/ <0.01893,4.43686,0.42609>,<-0.00464,4.43668,0.43639>,<0.001,4.45316,0.41745>,
            
    /*2*/ <0.16067,4.78073,0.76745>,<0.14495,4.78061,0.77432>,<0.14872,4.7916,0.76169>,
            
    /*3*/ <0.30566,5.01222,1.19107>,<0.29768,5.01174,1.19415>,<0.30011,5.01858,1.18958>,
            
    /*4*/ <0.31918,5.15373,1.67641>

    /* stem 0.8.4*/ 
    /*0*/ <0.00484,4.43124,0.52787>,
    /*1*/ <-0.00882,4.42665,0.52734>,<0.00867,4.4414,0.53736>,<0.01468,4.42567,0.51891>,
            
    /*2*/ <0.10002,4.07921,0.85917>,<0.11168,4.08904,0.86585>,<0.11569,4.07855,0.85355>,
            
    /*3*/ <0.14553,3.80547,1.2654>,<0.15129,3.8107,1.26837>,<0.15358,3.80418,1.26372>,
            
    /*4*/ <0.29933,3.81012,1.73528>

    /* stem 0.8.5*/ 
    /*0*/ <0.00273,4.43701,0.63104>,
    /*1*/ <0.01001,4.4489,0.62992>,<0.00709,4.42692,0.6397>,<-0.00892,4.4352,0.62351>,
            
    /*2*/ <-0.25199,4.63732,0.98546>,<-0.25394,4.62267,0.99197>,<-0.26461,4.62819,0.98118>,
            
    /*3*/ <-0.33638,4.85966,1.39998>,<-0.33713,4.85254,1.40372>,<-0.34361,4.85611,1.40048>,
            
    /*4*/ <-0.23997,5.14605,1.77105>

    /* stem 0.8.6*/ 
    /*0*/ <-0.00142,4.45432,0.788>,
    /*1*/ <0.00057,4.44123,0.7895>,<-0.01092,4.46046,0.79505>,<0.00607,4.46127,0.77945>,
            
    /*2*/ <0.30436,4.53042,1.12487>,<0.2967,4.54324,1.12857>,<0.30802,4.54378,1.11817>,
            
    /*3*/ <0.56581,4.57358,1.50132>,<0.56193,4.5799,1.50337>,<0.56819,4.5805,1.49895>,
            
    /*4*/ <0.64019,4.68961,1.94237>

    /* stem 0.8.7*/ 
    /*0*/ <-0.00492,4.46888,0.92001>,
    /*1*/ <-0.0145,4.47725,0.91883>,<0.00505,4.4716,0.92753>,<-0.0053,4.4578,0.91367>,
            
    /*2*/ <-0.21948,4.28453,1.26394>,<-0.20645,4.28076,1.26974>,<-0.21335,4.27156,1.2605>,
            
    /*3*/ <-0.40585,4.21669,1.66124>,<-0.39929,4.21487,1.66408>,<-0.40361,4.20966,1.66116>,
            
    /*4*/ <-0.58697,4.37792,2.03284>

    /* stem 0.8.8*/ 
    /*0*/ <-0.00845,4.48362,1.05359>,
    /*1*/ <0.00376,4.48336,1.05394>,<-0.01493,4.47861,1.06266>,<-0.01418,4.48888,1.04417>,
            
    /*2*/ <0.00162,4.85858,1.26217>,<-0.01084,4.85541,1.26798>,<-0.01034,4.86226,1.25565>,
            
    /*3*/ <-0.06577,5.14933,1.5721>,<-0.07194,5.1463,1.57368>,<-0.07167,5.15147,1.56889>,
            
    /*4*/ <-0.12142,5.40894,1.90907>

    /* stem 0.8.9*/ 
    /*0*/ <-0.01876,4.50474,1.16808>,
    /*1*/ <-0.02787,4.49735,1.1686>,<-0.01999,4.51583,1.17175>,<-0.00843,4.50105,1.16389>,
            
    /*2*/ <0.08945,4.38583,1.55079>,<0.09471,4.39815,1.55289>,<0.10241,4.3883,1.54765>,
            
    /*3*/ <0.16752,4.53027,1.93465>,<0.16947,4.53623,1.93206>,<0.17402,4.5313,1.933>,
            
    /*4*/ <0.05369,4.78273,2.24321>

    /* stem 0.8.10*/ 
    /*0*/ <-0.03293,4.52907,1.26632>,
    /*1*/ <-0.03068,4.53992,1.26395>,<-0.02837,4.5242,1.27548>,<-0.03973,4.52308,1.25952>,
            
    /*2*/ <-0.34992,4.64988,1.48357>,<-0.34837,4.63941,1.49126>,<-0.35595,4.63866,1.48062>,
            
    /*3*/ <-0.51808,4.78827,1.82168>,<-0.5164,4.78279,1.82482>,<-0.52218,4.78318,1.82179>,
            
    /*4*/ <-0.64483,4.95079,2.16742>

    /* stem 0.8.11*/ 
    /*0*/ <-0.04498,4.54977,1.34992>,
    /*1*/ <-0.0398,4.54057,1.35294>,<-0.05354,4.55341,1.35574>,<-0.0416,4.55532,1.34107>,
            
    /*2*/ <0.20119,4.75435,1.57691>,<0.19203,4.76291,1.57878>,<0.19999,4.76418,1.569>,
            
    /*3*/ <0.24465,5.04305,1.84302>,<0.23895,5.04537,1.84149>,<0.24413,5.0474,1.83844>,
            
    /*4*/ <0.2145,5.32809,2.11145>

    /* stem 0.8.12*/ 
    /*0*/ <-0.06646,4.58666,1.4989>,
    /*1*/ <-0.076,4.59003,1.49669>,<-0.06018,4.5924,1.5048>,<-0.06321,4.57755,1.49521>,
            
    /*2*/ <-0.20392,4.41831,1.80302>,<-0.19337,4.41988,1.80843>,<-0.19539,4.40998,1.80203>,
            
    /*3*/ <-0.21089,4.48611,2.17138>,<-0.20507,4.48746,2.17128>,<-0.20682,4.48183,2.17229>,
            
    /*4*/ <-0.22704,4.65102,2.50599>

    /* stem 0.8.13*/ 
    /*0*/ <-0.08193,4.61322,1.60617>,
    /*1*/ <-0.07262,4.61658,1.60668>,<-0.08558,4.60759,1.61347>,<-0.0876,4.61549,1.59836>,
            
    /*2*/ <-0.19174,4.91125,1.7765>,<-0.20038,4.90526,1.78103>,<-0.20172,4.91052,1.77095>,
            
    /*3*/ <-0.25069,5.18714,1.99914>,<-0.25499,5.18428,2.00161>,<-0.25602,5.18768,1.99713>,
            
    /*4*/ <-0.36968,5.38123,2.27943>

    /* stem 0.8.14*/ 
    /*0*/ <-0.10773,4.65046,1.70649>,
    /*1*/ <-0.11268,4.6426,1.70836>,<-0.11093,4.65888,1.70943>,<-0.09957,4.64989,1.7017>,
            
    /*2*/ <0.06186,4.60698,2.00623>,<0.06303,4.61784,2.00695>,<0.0706,4.61185,2.0018>,
            
    /*3*/ <0.1188,4.80375,2.28943>,<0.11842,4.80829,2.28639>,<0.12328,4.80587,2.28711>,
            
    /*4*/ <0.06848,5.108,2.45062>

    /* stem 0.8.15*/ 
    /*0*/ <-0.13869,4.69311,1.80414>,
    /*1*/ <-0.13975,4.70121,1.80027>,<-0.13524,4.6925,1.81248>,<-0.14108,4.68561,1.79968>,
            
    /*2*/ <-0.44654,4.7199,1.93037>,<-0.44354,4.71409,1.93851>,<-0.44743,4.7095,1.92998>,
            
    /*3*/ <-0.69168,4.81173,2.13667>,<-0.68963,4.8088,2.14048>,<-0.69315,4.80675,2.13722>,
            
    /*4*/ <-0.87858,5.00541,2.33266>

    /* stem 0.8.16*/ 
    /*0*/ <-0.17676,4.74555,1.92421>,
    /*1*/ <-0.17078,4.74092,1.92812>,<-0.18474,4.74556,1.92716>,<-0.17475,4.75016,1.91734>,
            
    /*2*/ <-0.10345,4.9899,2.1131>,<-0.11276,4.99299,2.11246>,<-0.1061,4.99605,2.10591>,
            
    /*3*/ <-0.19031,5.25669,2.26646>,<-0.19481,5.25637,2.26453>,<-0.1913,5.25887,2.26216>,
            
    /*4*/ <-0.28888,5.46518,2.48383>

    /* stem 0.8.17*/ 
    /*0*/ <-0.21346,4.7961,2.03996>,
    /*1*/ <-0.22046,4.79564,2.03794>,<-0.21072,4.80249,2.04218>,<-0.2092,4.79018,2.03975>,
            
    /*2*/ <-0.29555,4.73017,2.32262>,<-0.28906,4.73474,2.32544>,<-0.28804,4.72653,2.32382>,
            
    /*3*/ <-0.30679,4.78642,2.6199>,<-0.30329,4.78875,2.61962>,<-0.30302,4.78462,2.62042>,
            
    /*4*/ <-0.385,4.94241,2.86529>

    /* stem 0.8.18*/ 
    /*0*/ <-0.25762,4.8642,2.17394>,
    /*1*/ <-0.25321,4.86754,2.17331>,<-0.25943,4.86292,2.17904>,<-0.2602,4.86213,2.16947>,
            
    /*2*/ <-0.42602,5.09129,2.16882>,<-0.43016,5.08821,2.17264>,<-0.43068,5.08768,2.16626>,
            
    /*3*/ <-0.58134,5.31745,2.23678>,<-0.5832,5.31563,2.23866>,<-0.58396,5.31604,2.23556>,
            
    /*4*/ <-0.69157,5.56147,2.32667>

    /* stem 0.8.19*/ 
    /*0*/ <-0.28383,4.91263,2.24766>,
    /*1*/ <-0.285,4.90878,2.24977>,<-0.28685,4.91598,2.2472>,<-0.27962,4.91312,2.24601>,
            
    /*2*/ <-0.20403,5.01548,2.48616>,<-0.20527,5.02028,2.48445>,<-0.20045,5.01837,2.48365>,
            
    /*3*/ <-0.18394,5.17961,2.70235>,<-0.18465,5.18166,2.70087>,<-0.18212,5.18103,2.70111>,
            
    /*4*/ <-0.21775,5.38003,2.88295>

    /* stem 0.8.20*/ 
    /*0*/ <-0.31998,4.97943,2.34934>,
    /*1*/ <-0.32122,4.98162,2.34747>,<-0.31843,4.98028,2.35193>,<-0.3203,4.97639,2.34864>,
            
    /*2*/ <-0.53914,4.9724,2.48239>,<-0.53727,4.97152,2.48536>,<-0.53852,4.96892,2.48317>,
            
    /*3*/ <-0.72001,5.06382,2.639>,<-0.71899,5.06339,2.64044>,<-0.72017,5.06219,2.63978>,
            
    /*4*/ <-0.78456,5.23797,2.81582>

    /* stem 0.8.21*/ 
    /*0*/ <-0.35172,5.03806,2.43859>,
    /*1*/ <-0.35007,5.03764,2.43945>,<-0.35332,5.03817,2.4396>,<-0.35175,5.03838,2.43671>,
            
    /*2*/ <-0.31039,5.27439,2.47782>,<-0.31255,5.27474,2.47793>,<-0.31151,5.27488,2.476>,
            
    /*3*/ <-0.27696,5.49066,2.58335>,<-0.27805,5.4908,2.58341>,<-0.2775,5.49114,2.58252>,
            
    /*4*/ <-0.19199,5.68741,2.6978>

    /* stem 0.8.22*/ 
    /*0*/ <-0.38011,5.09052,2.51843>,
    /*1*/ <-0.38085,5.09023,2.51836>,<-0.37999,5.09129,2.51862>,<-0.37948,5.09004,2.51833>,
            
    /*2*/ <-0.38307,5.03739,2.74337>,<-0.3825,5.03809,2.74354>,<-0.38216,5.03726,2.74334>,
            
    /*3*/ <-0.39402,5.10295,2.96482>,<-0.39373,5.1033,2.96474>,<-0.39357,5.10288,2.96487>,
            
    /*4*/ <-0.39794,5.28348,3.1092>

    /* stem 0.9*/ 
    /*0*/ <0.00986,4.6482,0.00083>,
    /*1*/ <0.03454,4.64767,-0.01989>,<0.01668,4.67863,-0.00732>,<-0.01061,4.66754,0.01651>,
            <-0.00961,4.62973,0.01867>,<0.01829,4.61745,-0.00383>,
    /*2*/ <-0.34146,4.61283,-0.45694>,<-0.35575,4.6376,-0.44689>,<-0.37758,4.62873,-0.42782>,
            <-0.37678,4.59848,-0.4261>,<-0.35446,4.58866,-0.44409>,
    /*3*/ <-0.70366,4.6576,-0.90373>,<-0.71296,4.67618,-0.89451>,<-0.73033,4.66958,-0.88141>,
            <-0.73175,4.64692,-0.88252>,<-0.71527,4.63951,-0.89632>,
    /*4*/ <-1.01159,4.78766,-1.37251>,<-1.01713,4.79994,-1.36558>,<-1.02992,4.79596,-1.35848>,
            <-1.03228,4.7812,-1.36103>,<-1.02095,4.77608,-1.36969>,
    /*5*/ <-1.29066,5.04477,-1.80793>,<-1.29272,5.05043,-1.80334>,<-1.29939,5.04863,-1.80023>,
            <-1.30146,5.04185,-1.80291>,<-1.29606,5.03946,-1.80767>,
    /*6*/ <-1.60186,5.29307,-2.22694>

    /* stem 0.9.0*/ 
    /*0*/ <-0.08944,4.63885,-0.11724>,
    /*1*/ <-0.09958,4.64983,-0.10959>,<-0.09596,4.62588,-0.12567>,<-0.07279,4.64085,-0.11647>,
            
    /*2*/ <-0.11179,4.95588,-0.57724>,<-0.10938,4.93991,-0.58796>,<-0.09393,4.94989,-0.58183>,
            
    /*3*/ <-0.15239,5.29866,-1.01559>,<-0.15125,5.29118,-1.02165>,<-0.14351,5.29611,-1.01852>,
            
    /*4*/ <-0.37864,5.56164,-1.45315>

    /* stem 0.9.1*/ 
    /*0*/ <-0.14667,4.63346,-0.18528>,
    /*1*/ <-0.14406,4.61729,-0.18619>,<-0.14658,4.64257,-0.19893>,<-0.14936,4.64053,-0.17073>,
            
    /*2*/ <-0.6836,4.53919,-0.24513>,<-0.68528,4.55604,-0.25362>,<-0.68714,4.55468,-0.23482>,
            
    /*3*/ <-1.22515,4.53054,-0.3389>,<-1.22465,4.53903,-0.34305>,<-1.22625,4.5384,-0.33374>,
            
    /*4*/ <-1.60609,4.70502,-0.69509>

    /* stem 0.9.2*/ 
    /*0*/ <-0.20153,4.6283,-0.25052>,
    /*1*/ <-0.19576,4.64202,-0.25646>,<-0.21731,4.62654,-0.24826>,<-0.19153,4.61632,-0.24683>,
            
    /*2*/ <-0.24729,4.44226,-0.75344>,<-0.26166,4.43194,-0.74797>,<-0.24447,4.42512,-0.74701>,
            
    /*3*/ <-0.45342,4.50743,-1.24253>,<-0.46092,4.50259,-1.24009>,<-0.45361,4.49825,-1.24375>,
            
    /*4*/ <-0.6974,4.6706,-1.69275>

    /* stem 0.9.3*/ 
    /*0*/ <-0.27135,4.62172,-0.33353>,
    /*1*/ <-0.28241,4.61665,-0.32382>,<-0.26975,4.61522,-0.34759>,<-0.26188,4.63329,-0.32918>,
            
    /*2*/ <-0.61487,4.96849,-0.5272>,<-0.60642,4.96754,-0.54304>,<-0.60118,4.97959,-0.53077>,
            
    /*3*/ <-1.01439,5.16861,-0.80089>,<-1.00975,5.16763,-0.80853>,<-1.00913,5.17528,-0.80384>,
            
    /*4*/ <-1.22162,5.44749,-1.19762>

    /* stem 0.9.4*/ 
    /*0*/ <-0.33551,4.61568,-0.40981>,
    /*1*/ <-0.32447,4.61027,-0.41867>,<-0.34502,4.62619,-0.41514>,<-0.33703,4.61057,-0.39564>,
            
    /*2*/ <-0.64277,4.24269,-0.58241>,<-0.65647,4.2533,-0.58005>,<-0.65114,4.24289,-0.56705>,
            
    /*3*/ <-1.01478,3.95003,-0.78264>,<-1.02068,3.95627,-0.78098>,<-1.01904,3.95009,-0.77501>,
            
    /*4*/ <-1.3945,3.85824,-1.11536>

    /* stem 0.9.5*/ 
    /*0*/ <-0.39893,4.61797,-0.48798>,
    /*1*/ <-0.40389,4.63082,-0.48278>,<-0.40835,4.60821,-0.49368>,<-0.38455,4.6149,-0.48749>,
            
    /*2*/ <-0.34246,4.83295,-0.93701>,<-0.34543,4.81788,-0.94428>,<-0.32956,4.82234,-0.94015>,
            
    /*3*/ <-0.41312,5.09368,-1.35638>,<-0.41487,5.08652,-1.36061>,<-0.40688,5.08936,-1.3602>,
            
    /*4*/ <-0.62557,5.34691,-1.732>

    /* stem 0.9.6*/ 
    /*0*/ <-0.4813,4.62827,-0.59195>,
    /*1*/ <-0.4841,4.61442,-0.5911>,<-0.47875,4.63422,-0.60454>,<-0.48105,4.63617,-0.5802>,
            
    /*2*/ <-0.9564,4.71145,-0.64338>,<-0.95284,4.72465,-0.65234>,<-0.95437,4.72595,-0.63612>,
            
    /*3*/ <-1.33056,4.94779,-0.84947>,<-1.32543,4.95337,-0.85254>,<-1.32877,4.95451,-0.84517>,
            
    /*4*/ <-1.66832,5.22406,-1.06231>

    /* stem 0.9.7*/ 
    /*0*/ <-0.53281,4.63471,-0.65696>,
    /*1*/ <-0.52397,4.64336,-0.6631>,<-0.54621,4.63794,-0.65617>,<-0.52824,4.62283,-0.6516>,
            
    /*2*/ <-0.60365,4.42369,-1.07665>,<-0.61848,4.42007,-1.07203>,<-0.6065,4.41,-1.06899>,
            
    /*3*/ <-0.7329,4.45776,-1.52954>,<-0.74044,4.45607,-1.52758>,<-0.7354,4.45019,-1.52945>,
            
    /*4*/ <-0.87352,4.65839,-1.93538>

    /* stem 0.9.8*/ 
    /*0*/ <-0.61089,4.64447,-0.75551>,
    /*1*/ <-0.62129,4.64472,-0.74724>,<-0.61098,4.63639,-0.76605>,<-0.60041,4.6523,-0.75322>,
            
    /*2*/ <-0.81084,4.97673,-1.00282>,<-0.80396,4.97119,-1.01535>,<-0.79692,4.98179,-1.0068>,
            
    /*3*/ <-1.00947,5.27463,-1.29185>,<-1.00574,5.27147,-1.29776>,<-1.00259,5.27731,-1.29392>,
            
    /*4*/ <-1.17811,5.58568,-1.586>

    /* stem 0.9.9*/ 
    /*0*/ <-0.68215,4.65338,-0.84544>,
    /*1*/ <-0.67499,4.64499,-0.85195>,<-0.68743,4.66334,-0.85151>,<-0.68402,4.6518,-0.83288>,
            
    /*2*/ <-1.0407,4.40339,-0.93472>,<-1.049,4.41562,-0.93443>,<-1.04673,4.40793,-0.92201>,
            
    /*3*/ <-1.47361,4.28791,-0.96225>,<-1.47558,4.29502,-0.96186>,<-1.47492,4.29103,-0.95568>,
            
    /*4*/ <-1.87085,4.32815,-1.16159>

    /* stem 0.9.10*/ 
    /*0*/ <-0.74998,4.67133,-0.94037>,
    /*1*/ <-0.74988,4.68323,-0.93717>,<-0.76019,4.66631,-0.94509>,<-0.73988,4.66446,-0.93885>,
            
    /*2*/ <-0.61823,4.78525,-1.33559>,<-0.6251,4.77397,-1.34087>,<-0.61155,4.77274,-1.33672>,
            
    /*3*/ <-0.4587,4.93535,-1.70656>,<-0.46165,4.92993,-1.71009>,<-0.45506,4.92932,-1.7075>,
            
    /*4*/ <-0.33347,5.11017,-2.08079>

    /* stem 0.9.11*/ 
    /*0*/ <-0.83171,4.70639,-1.06792>,
    /*1*/ <-0.83817,4.69677,-1.06642>,<-0.82729,4.70887,-1.07844>,<-0.82968,4.71352,-1.0589>,
            
    /*2*/ <-1.17677,4.91443,-1.15966>,<-1.16952,4.92249,-1.16767>,<-1.17111,4.92559,-1.15464>,
            
    /*3*/ <-1.44725,5.09414,-1.41595>,<-1.44224,5.09744,-1.41902>,<-1.44538,5.10023,-1.41375>,
            
    /*4*/ <-1.73796,5.18788,-1.69308>

    /* stem 0.9.12*/ 
    /*0*/ <-0.90897,4.73953,-1.18849>,
    /*1*/ <-0.89967,4.74281,-1.19355>,<-0.91801,4.74594,-1.18881>,<-0.90924,4.72984,-1.18311>,
            
    /*2*/ <-1.01943,4.56075,-1.52364>,<-1.03165,4.56284,-1.52048>,<-1.02581,4.5521,-1.51669>,
            
    /*3*/ <-1.23155,4.60834,-1.85429>,<-1.23671,4.60987,-1.85082>,<-1.23561,4.60377,-1.85241>,
            
    /*4*/ <-1.43795,4.8095,-2.12494>

    /* stem 0.9.13*/ 
    /*0*/ <-0.99563,4.7767,-1.32372>,
    /*1*/ <-1.00327,4.78055,-1.31777>,<-0.99793,4.77052,-1.3318>,<-0.98569,4.77901,-1.3216>,
            
    /*2*/ <-1.02316,5.08026,-1.54354>,<-1.0196,5.07357,-1.55289>,<-1.01145,5.07923,-1.54609>,
            
    /*3*/ <-1.13015,5.37183,-1.75271>,<-1.12862,5.36886,-1.75771>,<-1.12458,5.37234,-1.75493>,
            
    /*4*/ <-1.27193,5.63804,-1.9767>

    /* stem 0.9.14*/ 
    /*0*/ <-1.04128,4.80592,-1.39579>,
    /*1*/ <-1.03945,4.79792,-1.40161>,<-1.04063,4.81519,-1.39963>,<-1.04377,4.80464,-1.38612>,
            
    /*2*/ <-1.39273,4.78714,-1.49215>,<-1.39352,4.79865,-1.49083>,<-1.39561,4.79162,-1.48183>,
            
    /*3*/ <-1.72429,4.84689,-1.63332>,<-1.72374,4.85258,-1.63232>,<-1.72609,4.84913,-1.62827>,
            
    /*4*/ <-1.98924,5.02602,-1.81015>

    /* stem 0.9.15*/ 
    /*0*/ <-1.09909,4.86017,-1.48851>,
    /*1*/ <-1.09512,4.86854,-1.48608>,<-1.10839,4.85976,-1.49077>,<-1.09376,4.85221,-1.48867>,
            
    /*2*/ <-1.01734,4.92554,-1.82276>,<-1.02619,4.91968,-1.82589>,<-1.01644,4.91466,-1.82449>,
            
    /*3*/ <-1.01704,5.01502,-2.16144>,<-1.02154,5.01194,-2.1623>,<-1.01651,5.00971,-2.16289>,
            
    /*4*/ <-1.11637,5.17893,-2.45418>

    /* stem 0.9.16*/ 
    /*0*/ <-1.14621,4.90439,-1.56408>,
    /*1*/ <-1.15372,4.89939,-1.56233>,<-1.14262,4.90447,-1.57254>,<-1.14231,4.90932,-1.55738>,
            
    /*2*/ <-1.34623,5.16545,-1.64351>,<-1.33883,5.16884,-1.65031>,<-1.33862,5.17207,-1.64021>,
            
    /*3*/ <-1.44851,5.45977,-1.77979>,<-1.44396,5.46015,-1.78248>,<-1.44435,5.46226,-1.77763>,
            
    /*4*/ <-1.56892,5.70367,-1.98046>

    /* stem 0.9.17*/ 
    /*0*/ <-1.20595,4.96046,-1.65989>,
    /*1*/ <-1.19878,4.96011,-1.66456>,<-1.2102,4.96785,-1.65911>,<-1.20887,4.95341,-1.656>,
            
    /*2*/ <-1.37551,4.88771,-1.92524>,<-1.38313,4.89287,-1.92161>,<-1.38224,4.88324,-1.91953>,
            
    /*3*/ <-1.52291,5.06704,-2.1502>,<-1.52563,5.06924,-2.14671>,<-1.52728,5.06513,-2.14891>,
            
    /*4*/ <-1.58876,5.34455,-2.30168>

    /* stem 0.9.18*/ 
    /*0*/ <-1.26592,5.01674,-1.75607>,
    /*1*/ <-1.26925,5.02108,-1.75146>,<-1.26962,5.01356,-1.76131>,<-1.25888,5.01558,-1.75545>,
            
    /*2*/ <-1.21225,5.25945,-1.93794>,<-1.2125,5.25444,-1.94451>,<-1.20534,5.25578,-1.9406>,
            
    /*3*/ <-1.21733,5.49747,-2.13272>,<-1.2175,5.49488,-2.13593>,<-1.21384,5.49614,-2.13448>,
            
    /*4*/ <-1.31174,5.731,-2.3092>

    /* stem 0.9.19*/ 
    /*0*/ <-1.32304,5.06691,-1.8417>,
    /*1*/ <-1.32372,5.06168,-1.84428>,<-1.32111,5.0715,-1.84482>,<-1.32428,5.06756,-1.83599>,
            
    /*2*/ <-1.60099,5.13326,-1.9118>,<-1.59926,5.13981,-1.91216>,<-1.60137,5.13718,-1.90627>,
            
    /*3*/ <-1.82891,5.27772,-2.03065>,<-1.82719,5.28064,-2.03044>,<-1.82917,5.27965,-2.02787>,
            
    /*4*/ <-2.0217,5.4698,-2.14335>

    /* stem 0.9.20*/ 
    /*0*/ <-1.38363,5.11606,-1.92541>,
    /*1*/ <-1.38073,5.11963,-1.9254>,<-1.38816,5.11677,-1.9251>,<-1.38199,5.11177,-1.92572>,
            
    /*2*/ <-1.39849,5.13241,-2.20503>,<-1.40345,5.1305,-2.20483>,<-1.39933,5.12717,-2.20524>,
            
    /*3*/ <-1.44957,5.24674,-2.45531>,<-1.45207,5.24583,-2.45522>,<-1.45015,5.24434,-2.45629>,
            
    /*4*/ <-1.60505,5.4348,-2.59356>

    /* stem 0.9.21*/ 
    /*0*/ <-1.43456,5.15737,-1.99578>,
    /*1*/ <-1.43755,5.15631,-1.99424>,<-1.43428,5.15733,-1.9993>,<-1.43185,5.15846,-1.99381>,
            
    /*2*/ <-1.53082,5.40834,-2.00482>,<-1.52864,5.40902,-2.00819>,<-1.52702,5.40977,-2.00453>,
            
    /*3*/ <-1.64443,5.64673,-2.05552>,<-1.64328,5.64693,-2.05719>,<-1.6426,5.64764,-2.0554>,
            
    /*4*/ <-1.69615,5.89566,-2.14416>

    /* stem 0.9.22*/ 
    /*0*/ <-1.52282,5.22895,-2.11772>,
    /*1*/ <-1.5217,5.22843,-2.11884>,<-1.52322,5.23057,-2.11765>,<-1.52353,5.22787,-2.11668>,
            
    /*2*/ <-1.70497,5.19074,-2.28304>,<-1.70598,5.19217,-2.28225>,<-1.70619,5.19037,-2.2816>,
            
    /*3*/ <-1.8813,5.27473,-2.43768>,<-1.88154,5.2754,-2.43704>,<-1.88197,5.27454,-2.43702>,
            
    /*4*/ <-2.0201,5.42352,-2.58111>

    /* stem 0.9.23*/ 
    /*0*/ <-1.57724,5.27309,-2.19291>,
    /*1*/ <-1.57733,5.2735,-2.19261>,<-1.57763,5.27285,-2.19314>,<-1.57675,5.27294,-2.19299>,
            
    /*2*/ <-1.5609,5.41749,-2.37963>,<-1.5611,5.41705,-2.37999>,<-1.56051,5.41711,-2.37989>,
            
    /*3*/ <-1.57718,5.5948,-2.53533>,<-1.57729,5.59461,-2.53553>,<-1.57699,5.59466,-2.53551>,
            
    /*4*/ <-1.61199,5.81333,-2.61889>

    /* stem 0.10*/ 
    /*0*/ <0.01312,4.7889,0.0011>,
    /*1*/ <0.0073,4.78897,0.03408>,<0.01366,4.82068,0.01164>,<0.01926,4.80847,-0.02537>,
            <0.01637,4.76921,-0.02579>,<0.00898,4.75716,0.01095>,
    /*2*/ <0.59409,4.74474,0.13083>,<0.59917,4.77011,0.11287>,<0.60366,4.76034,0.08327>,
            <0.60135,4.72894,0.08293>,<0.59543,4.71929,0.11232>,
    /*3*/ <1.18995,4.73774,0.18457>,<1.19158,4.7568,0.1707>,<1.19376,4.7494,0.14837>,
            <1.19347,4.72579,0.14844>,<1.19112,4.71858,0.17081>,
    /*4*/ <1.76958,4.86375,0.24359>,<1.76795,4.87619,0.23406>,<1.77067,4.8714,0.21931>,
            <1.77397,4.85601,0.21972>,<1.7733,4.85128,0.23472>,
    /*5*/ <2.32241,5.089,0.26094>,<2.32027,5.09478,0.25605>,<2.32158,5.09234,0.24868>,
            <2.32454,5.08505,0.24902>,<2.32505,5.08299,0.2566>,
    /*6*/ <2.86992,5.32388,0.22309>

    /* stem 0.10.0*/ 
    /*0*/ <0.18463,4.77595,0.03137>,
    /*1*/ <0.18776,4.78706,0.01838>,<0.19326,4.76089,0.03219>,<0.17287,4.7799,0.04354>,
            
    /*2*/ <0.59719,5.03548,0.33732>,<0.60085,5.01803,0.34653>,<0.58726,5.03071,0.3541>,
            
    /*3*/ <1.01464,5.17542,0.71115>,<1.01458,5.16609,0.71485>,<1.00863,5.17312,0.71885>,
            
    /*4*/ <1.47663,5.27387,1.03938>

    /* stem 0.10.1*/ 
    /*0*/ <0.26833,4.76963,0.04614>,
    /*1*/ <0.26659,4.75293,0.04887>,<0.27732,4.77913,0.05701>,<0.26107,4.77683,0.03254>,
            
    /*2*/ <0.73501,4.66045,-0.25351>,<0.74217,4.67791,-0.24808>,<0.73133,4.67638,-0.26439>,
            
    /*3*/ <1.28983,4.76968,-0.31225>,<1.28854,4.77866,-0.30848>,<1.28779,4.77725,-0.31817>,
            
    /*4*/ <1.78861,4.97521,-0.14126>

    /* stem 0.10.2*/ 
    /*0*/ <0.36427,4.76239,0.06307>,
    /*1*/ <0.36388,4.77673,0.07139>,<0.37596,4.75976,0.0516>,<0.35295,4.75067,0.06621>,
            
    /*2*/ <0.69513,4.5561,0.45595>,<0.70319,4.54479,0.44276>,<0.68785,4.53872,0.45249>,
            
    /*3*/ <1.11557,4.58066,0.80897>,<1.12078,4.57499,0.80327>,<1.11527,4.57116,0.8101>,
            
    /*4*/ <1.57049,4.78027,1.05016>

    /* stem 0.10.3*/ 
    /*0*/ <0.46518,4.75477,0.08088>,
    /*1*/ <0.46741,4.74923,0.06588>,<0.47074,4.74637,0.09349>,<0.4574,4.76871,0.08326>,
            
    /*2*/ <0.9363,5.01825,0.04201>,<0.93851,5.01634,0.06042>,<0.92962,5.03123,0.0536>,
            
    /*3*/ <1.34678,5.37001,0.09588>,<1.34684,5.36865,0.1051>,<1.34154,5.37538,0.10141>,
            
    /*4*/ <1.75821,5.71628,0.15638>

    /* stem 0.10.4*/ 
    /*0*/ <0.55895,4.74769,0.09742>,
    /*1*/ <0.55599,4.74235,0.11192>,<0.56828,4.7602,0.09539>,<0.55258,4.74052,0.08495>,
            
    /*2*/ <0.97828,4.42474,0.07563>,<0.98647,4.43664,0.06461>,<0.97601,4.42352,0.05765>,
            
    /*3*/ <1.49883,4.34656,0.1361>,<1.5006,4.35341,0.1304>,<1.4997,4.34496,0.1272>,
            
    /*4*/ <2.00985,4.40027,0.26374>

    /* stem 0.10.5*/ 
    /*0*/ <0.67939,4.74373,0.11262>,
    /*1*/ <0.68032,4.75688,0.10501>,<0.68922,4.73251,0.10964>,<0.66864,4.74181,0.12321>,
            
    /*2*/ <0.99997,4.9375,0.46623>,<1.00591,4.92125,0.46931>,<0.99218,4.92745,0.47836>,
            
    /*3*/ <1.45539,5.10752,0.6305>,<1.45824,5.09926,0.63139>,<1.4543,5.10329,0.63813>,
            
    /*4*/ <1.89887,5.23632,0.8601>

    /* stem 0.10.6*/ 
    /*0*/ <0.79779,4.74233,0.12462>,
    /*1*/ <0.79787,4.72783,0.12212>,<0.80512,4.74785,0.13611>,<0.79037,4.7513,0.11563>,
            
    /*2*/ <1.20607,4.78418,-0.16242>,<1.21091,4.79753,-0.1531>,<1.20107,4.79983,-0.16675>,
            
    /*3*/ <1.70005,4.86393,-0.20308>,<1.6995,4.87051,-0.19774>,<1.69861,4.87174,-0.2061>,
            
    /*4*/ <2.16114,5.0428,-0.11728>

    /* stem 0.10.7*/ 
    /*0*/ <0.89769,4.74115,0.13475>,
    /*1*/ <0.8967,4.75037,0.14561>,<0.9074,4.74323,0.12447>,<0.88898,4.72984,0.13416>,
            
    /*2*/ <1.22162,4.48402,0.39528>,<1.22875,4.47926,0.38118>,<1.21647,4.47033,0.38764>,
            
    /*3*/ <1.61831,4.44016,0.67191>,<1.62266,4.43762,0.66538>,<1.61874,4.43212,0.67012>,
            
    /*4*/ <2.07035,4.56256,0.81078>

    /* stem 0.10.8*/ 
    /*0*/ <1.04005,4.73946,0.14918>,
    /*1*/ <1.04143,4.73941,0.13556>,<1.04654,4.73009,0.15675>,<1.03218,4.74889,0.15522>,
            
    /*2*/ <1.41314,5.02663,0.17663>,<1.41655,5.02042,0.19076>,<1.40698,5.03295,0.18974>,
            
    /*3*/ <1.79824,5.29605,0.21358>,<1.79987,5.29287,0.22063>,<1.79538,5.29935,0.22017>,
            
    /*4*/ <2.21098,5.52042,0.25454>

    /* stem 0.10.9*/ 
    /*0*/ <1.133,4.73836,0.1586>,
    /*1*/ <1.13187,4.72986,0.16876>,<1.14126,4.74874,0.15951>,<1.12587,4.73648,0.14753>,
            
    /*2*/ <1.47247,4.47736,-0.01053>,<1.47873,4.48995,-0.0167>,<1.46847,4.48178,-0.02468>,
            
    /*3*/ <1.93116,4.48319,-0.06421>,<1.93085,4.49046,-0.06666>,<1.93033,4.48468,-0.07169>,
            
    /*4*/ <2.35406,4.64052,0.02671>

    /* stem 0.10.10*/ 
    /*0*/ <1.25916,4.75229,0.1722>,
    /*1*/ <1.25678,4.76457,0.16967>,<1.26895,4.74639,0.16652>,<1.25176,4.74591,0.18041>,
            
    /*2*/ <1.52472,4.88124,0.50516>,<1.53283,4.86911,0.50305>,<1.52137,4.86879,0.51232>,
            
    /*3*/ <1.73913,5.05027,0.85505>,<1.74375,5.04452,0.85508>,<1.73753,5.04426,0.85901>,
            
    /*4*/ <1.97954,5.30079,1.13184>

    /* stem 0.10.11*/ 
    /*0*/ <1.37676,4.77789,0.18554>,
    /*1*/ <1.37968,4.76749,0.17972>,<1.38354,4.78173,0.19502>,<1.36706,4.78444,0.18189>,
            
    /*2*/ <1.6301,4.99274,-0.08821>,<1.63267,5.00223,-0.07801>,<1.62168,5.00404,-0.08676>,
            
    /*3*/ <1.89986,5.24064,-0.31527>,<1.90068,5.24495,-0.30971>,<1.89555,5.2462,-0.31444>,
            
    /*4*/ <2.10805,5.55867,-0.51887>

    /* stem 0.10.12*/ 
    /*0*/ <1.55962,4.81769,0.20629>,
    /*1*/ <1.55758,4.82156,0.21692>,<1.56705,4.82324,0.19949>,<1.55424,4.80828,0.20246>,
            
    /*2*/ <1.86195,4.58856,0.35607>,<1.86827,4.58968,0.34444>,<1.85973,4.57971,0.34642>,
            
    /*3*/ <2.20792,4.55957,0.56541>,<2.21142,4.56004,0.55979>,<2.20955,4.55408,0.56204>,
            
    /*4*/ <2.54881,4.71301,0.72726>

    /* stem 0.10.13*/ 
    /*0*/ <1.7177,4.8521,0.22422>,
    /*1*/ <1.71807,4.85571,0.21401>,<1.72463,4.84445,0.22753>,<1.7104,4.85615,0.23113>,
            
    /*2*/ <1.97092,5.12921,0.32359>,<1.97529,5.1217,0.3326>,<1.9658,5.12951,0.33501>,
            
    /*3*/ <2.2521,5.39194,0.36562>,<2.25474,5.38848,0.37012>,<2.25047,5.39281,0.3716>,
            
    /*4*/ <2.54257,5.64887,0.37865>

    /* stem 0.10.14*/ 
    /*0*/ <1.81173,4.88031,0.23205>,
    /*1*/ <1.81485,4.87207,0.23765>,<1.81339,4.88998,0.23562>,<1.80696,4.87888,0.22287>,
            
    /*2*/ <2.14718,4.88226,0.06124>,<2.1462,4.8942,0.05989>,<2.14192,4.8868,0.05139>,
            
    /*3*/ <2.43081,5.08556,-0.0871>,<2.42753,5.0906,-0.08655>,<2.42723,5.08734,-0.09162>,
            
    /*4*/ <2.66383,5.33873,-0.24119>

    /* stem 0.10.15*/ 
    /*0*/ <1.94226,4.93357,0.23772>,
    /*1*/ <1.93851,4.94262,0.23901>,<1.94916,4.93202,0.23082>,<1.9391,4.92607,0.24333>,
            
    /*2*/ <2.19669,5.01171,0.47938>,<2.20379,5.00464,0.47392>,<2.19708,5.00068,0.48226>,
            
    /*3*/ <2.45196,5.18358,0.662>,<2.45596,5.18033,0.65955>,<2.45356,5.17868,0.66445>,
            
    /*4*/ <2.63498,5.48329,0.73212>

    /* stem 0.10.16*/ 
    /*0*/ <2.04529,4.97561,0.2422>,
    /*1*/ <2.04796,4.96981,0.23524>,<2.05126,4.97759,0.24924>,<2.03665,4.97942,0.24211>,
            
    /*2*/ <2.16828,5.24208,0.05868>,<2.17048,5.24727,0.06802>,<2.16074,5.24849,0.06326>,
            
    /*3*/ <2.37553,5.49981,-0.04455>,<2.37601,5.50154,-0.03941>,<2.37202,5.50348,-0.04258>,
            
    /*4*/ <2.62401,5.72959,-0.11664>

    /* stem 0.10.17*/ 
    /*0*/ <2.1537,5.01984,0.24691>,
    /*1*/ <2.15323,5.02006,0.25564>,<2.15645,5.02688,0.2425>,<2.15142,5.01258,0.24259>,
            
    /*2*/ <2.46607,4.9101,0.2723>,<2.46822,4.91464,0.26353>,<2.46487,4.90511,0.26359>,
            
    /*3*/ <2.78914,4.98467,0.28859>,<2.78886,4.98703,0.28413>,<2.78999,4.98211,0.28432>,
            
    /*4*/ <3.06185,5.1707,0.24914>

    /* stem 0.10.18*/ 
    /*0*/ <2.27803,5.07058,0.25231>,
    /*1*/ <2.27658,5.07474,0.24657>,<2.28398,5.06646,0.25238>,<2.27353,5.07052,0.25798>,
            
    /*2*/ <2.43952,5.31042,0.37961>,<2.44445,5.3049,0.38348>,<2.43748,5.30761,0.38721>,
            
    /*3*/ <2.61217,5.55337,0.48309>,<2.61474,5.55074,0.48507>,<2.6114,5.55227,0.48704>,
            
    /*4*/ <2.74623,5.83725,0.51117>

    /* stem 0.10.19*/ 
    /*0*/ <2.37145,5.10975,0.25149>,
    /*1*/ <2.37387,5.10431,0.25284>,<2.37386,5.11483,0.25385>,<2.36663,5.1101,0.24777>,
            
    /*2*/ <2.55908,5.1291,0.0134>,<2.55907,5.13611,0.01407>,<2.55425,5.13296,0.01002>,
            
    /*3*/ <2.73716,5.31229,-0.15398>,<2.73579,5.31511,-0.15237>,<2.73431,5.31387,-0.15532>,
            
    /*4*/ <2.94966,5.52558,-0.1941>

    /* stem 0.10.20*/ 
    /*0*/ <2.4757,5.15453,0.24555>,
    /*1*/ <2.47411,5.15852,0.24775>,<2.47829,5.15488,0.24149>,<2.47469,5.15019,0.2474>,
            
    /*2*/ <2.71846,5.1679,0.4038>,<2.72125,5.16547,0.39963>,<2.71886,5.16235,0.40357>,
            
    /*3*/ <2.96738,5.27952,0.50062>,<2.96874,5.27835,0.49849>,<2.96844,5.27696,0.50088>,
            
    /*4*/ <3.1891,5.45333,0.43141>

    /* stem 0.10.21*/ 
    /*0*/ <2.56948,5.19482,0.24021>,
    /*1*/ <2.56988,5.19343,0.23682>,<2.57231,5.19479,0.24255>,<2.56625,5.19623,0.24124>,
            
    /*2*/ <2.64907,5.44354,0.14538>,<2.65069,5.44444,0.1492>,<2.64664,5.4454,0.14833>,
            
    /*3*/ <2.75956,5.66083,0.0131>,<2.76051,5.66145,0.0149>,<2.75857,5.66216,0.01443>,
            
    /*4*/ <2.93373,5.8698,-0.04455>

    /* stem 0.10.22*/ 
    /*0*/ <2.68746,5.2455,0.23348>,
    /*1*/ <2.68782,5.24494,0.23562>,<2.68802,5.24753,0.23276>,<2.68654,5.24402,0.23208>,
            
    /*2*/ <2.92634,5.15668,0.17105>,<2.92647,5.15841,0.16914>,<2.92548,5.15607,0.1687>,
            
    /*3*/ <3.17134,5.15096,0.07654>,<3.17105,5.1519,0.07571>,<3.17089,5.15066,0.07537>,
            
    /*4*/ <3.37542,5.29284,-0.00795>

    /* stem 0.10.23*/ 
    /*0*/ <2.82056,5.30268,0.2259>,
    /*1*/ <2.82034,5.30314,0.22558>,<2.82105,5.30238,0.22572>,<2.82028,5.30251,0.22641>,
            
    /*2*/ <2.95988,5.45915,0.35287>,<2.96036,5.45864,0.35297>,<2.95984,5.45873,0.35343>,
            
    /*3*/ <3.14639,5.61479,0.38415>,<3.14661,5.61452,0.38418>,<3.14646,5.61465,0.38446>,
            
    /*4*/ <3.29442,5.80972,0.37536>

    /* stem 0.11*/ 
    /*0*/ <0.01743,4.9751,0.00146>,
    /*1*/ <-0.00015,4.97557,-0.02899>,<0.01228,5.00869,-0.0076>,<0.03183,4.99539,0.02632>,
            <0.03147,4.95405,0.02589>,<0.01171,4.9418,-0.00829>,
    /*2*/ <-0.53459,4.97685,0.28762>,<-0.52465,5.00335,0.30473>,<-0.50901,4.99271,0.33187>,
            <-0.5093,4.95964,0.33153>,<-0.52511,4.94984,0.30418>,
    /*3*/ <-1.00577,5.0658,0.68993>,<-0.99381,5.08511,0.69991>,<-0.97981,5.07664,0.71856>,
            <-0.98312,5.05211,0.72011>,<-0.99916,5.04541,0.70241>,
    /*4*/ <-1.44961,5.26518,1.07611>,<-1.4398,5.27747,1.08122>,<-1.43117,5.27205,1.09423>,
            <-1.43564,5.2564,1.09717>,<-1.44704,5.25216,1.08597>,
    /*5*/ <-1.84199,5.57639,1.44418>,<-1.83609,5.58193,1.44588>,<-1.832,5.57934,1.45258>,
            <-1.83537,5.5722,1.45503>,<-1.84155,5.57037,1.44984>,
    /*6*/ <-2.16698,5.98022,1.78691>

    /* stem 0.11.0*/ 
    /*0*/ <-0.12493,4.97546,0.08364>,
    /*1*/ <-0.11782,4.98706,0.09592>,<-0.13368,4.96038,0.08928>,<-0.12331,4.97896,0.06572>,
            
    /*2*/ <-0.63836,5.28824,0.10421>,<-0.64894,5.27045,0.09978>,<-0.64202,5.28284,0.08408>,
            
    /*3*/ <-1.15747,5.57405,0.20096>,<-1.16285,5.56519,0.19884>,<-1.16056,5.57198,0.19105>,
            
    /*4*/ <-1.64913,5.86803,0.38181>

    /* stem 0.11.1*/ 
    /*0*/ <-0.20872,4.97568,0.132>,
    /*1*/ <-0.21043,4.95809,0.12913>,<-0.22285,4.98649,0.12998>,<-0.19289,4.98246,0.1369>,
            
    /*2*/ <-0.3516,4.88499,0.69714>,<-0.35988,4.90393,0.69771>,<-0.33991,4.90124,0.70233>,
            
    /*3*/ <-0.64795,5.00167,1.19746>,<-0.65014,5.01118,1.19404>,<-0.64154,5.00952,1.19953>,
            
    /*4*/ <-0.90101,5.41359,1.54078>

    /* stem 0.11.2*/ 
    /*0*/ <-0.32186,4.97597,0.19731>,
    /*1*/ <-0.32606,4.9911,0.18996>,<-0.32662,4.97265,0.21364>,<-0.31289,4.96416,0.18832>,
            
    /*2*/ <-0.81598,4.75737,0.00282>,<-0.81635,4.74508,0.01861>,<-0.8072,4.73942,0.00173>,
            
    /*3*/ <-1.37737,4.72059,0.11089>,<-1.37551,4.71545,0.11927>,<-1.37686,4.7106,0.11062>,
            
    /*4*/ <-1.91155,4.9146,0.17537>

    /* stem 0.11.3*/ 
    /*0*/ <-0.37273,4.9761,0.22667>,
    /*1*/ <-0.36476,4.97005,0.24051>,<-0.38672,4.96828,0.22077>,<-0.36671,4.98998,0.21874>,
            
    /*2*/ <-0.69065,5.30093,0.56598>,<-0.70529,5.29975,0.55282>,<-0.69196,5.31422,0.55147>,
            
    /*3*/ <-0.98468,5.54589,0.98128>,<-0.99287,5.54553,0.9758>,<-0.98697,5.55342,0.97534>,
            
    /*4*/ <-1.32666,5.81784,1.34401>

    /* stem 0.11.4*/ 
    /*0*/ <-0.49593,4.97642,0.29779>,
    /*1*/ <-0.50371,4.97099,0.28433>,<-0.50348,4.98689,0.308>,<-0.4806,4.97137,0.30103>,
            
    /*2*/ <-0.70139,4.54842,0.57572>,<-0.70124,4.55902,0.5915>,<-0.68598,4.54867,0.58685>,
            
    /*3*/ <-1.08173,4.19158,0.73957>,<-1.08232,4.19595,0.74799>,<-1.07616,4.18883,0.74676>,
            
    /*4*/ <-1.51027,4.07378,1.0664>

    /* stem 0.11.5*/ 
    /*0*/ <-0.55001,4.98201,0.33662>,
    /*1*/ <-0.543,4.99557,0.34197>,<-0.55596,4.97127,0.34715>,<-0.55109,4.9792,0.32073>,
            
    /*2*/ <-1.02445,5.24404,0.32775>,<-1.03309,5.22785,0.33121>,<-1.02985,5.23313,0.31359>,
            
    /*3*/ <-1.5274,5.4475,0.3064>,<-1.53099,5.439,0.3078>,<-1.52939,5.44202,0.29911>,
            
    /*4*/ <-2.02467,5.59796,0.46005>

    /* stem 0.11.6*/ 
    /*0*/ <-0.66809,5.00417,0.43527>,
    /*1*/ <-0.66841,4.98896,0.4383>,<-0.6813,5.01228,0.43489>,<-0.65455,5.01126,0.43263>,
            
    /*2*/ <-0.62119,5.09483,0.94862>,<-0.62978,5.11038,0.94635>,<-0.61195,5.1097,0.94484>,
            
    /*3*/ <-0.68191,5.32794,1.41611>,<-0.68595,5.3349,1.4122>,<-0.67706,5.33494,1.41333>,
            
    /*4*/ <-0.84348,5.75089,1.68348>

    /* stem 0.11.7*/ 
    /*0*/ <-0.77793,5.02478,0.52704>,
    /*1*/ <-0.78391,5.03467,0.51766>,<-0.77828,5.02728,0.54172>,<-0.77158,5.01239,0.52175>,
            
    /*2*/ <-1.22619,4.79118,0.5509>,<-1.22244,4.78625,0.56694>,<-1.21798,4.77633,0.55363>,
            
    /*3*/ <-1.70722,4.75782,0.69875>,<-1.70471,4.75575,0.70671>,<-1.70607,4.74957,0.70088>,
            
    /*4*/ <-2.16936,4.95702,0.71677>

    /* stem 0.11.8*/ 
    /*0*/ <-0.84878,5.03808,0.58624>,
    /*1*/ <-0.83955,5.03754,0.59741>,<-0.86164,5.03144,0.58714>,<-0.84515,5.04525,0.57418>,
            
    /*2*/ <-1.04273,5.45049,0.77904>,<-1.05746,5.44643,0.77219>,<-1.04646,5.45564,0.76355>,
            
    /*3*/ <-1.31652,5.83202,0.93858>,<-1.32321,5.829,0.93455>,<-1.31803,5.83433,0.93068>,
            
    /*4*/ <-1.64794,6.18822,1.03307>

    /* stem 0.11.9*/ 
    /*0*/ <-0.93559,5.05437,0.65878>,
    /*1*/ <-0.94363,5.04585,0.65107>,<-0.94117,5.06575,0.66476>,<-0.92198,5.05149,0.6605>,
            
    /*2*/ <-1.04517,4.79133,1.04645>,<-1.04352,4.8046,1.05558>,<-1.03074,4.79509,1.05274>,
            
    /*3*/ <-1.18019,4.65737,1.49001>,<-1.17883,4.66487,1.49276>,<-1.1729,4.65937,1.4929>,
            
    /*4*/ <-1.35657,4.72418,1.93372>

    /* stem 0.11.10*/ 
    /*0*/ <-1.01873,5.07677,0.7286>,
    /*1*/ <-1.01363,5.08931,0.72804>,<-1.02327,5.07182,0.74038>,<-1.01931,5.06918,0.71739>,
            
    /*2*/ <-1.44127,5.2545,0.6354>,<-1.4477,5.24284,0.64362>,<-1.44506,5.24108,0.6283>,
            
    /*3*/ <-1.78997,5.55221,0.71217>,<-1.79363,5.54688,0.71659>,<-1.79503,5.54722,0.7089>,
            
    /*4*/ <-2.11102,5.85217,0.87213>

    /* stem 0.11.11*/ 
    /*0*/ <-1.10955,5.11721,0.80574>,
    /*1*/ <-1.10845,5.10629,0.81276>,<-1.1213,5.12131,0.80186>,<-1.09891,5.12403,0.80259>,
            
    /*2*/ <-1.15037,5.35066,1.19141>,<-1.15893,5.36068,1.18414>,<-1.144,5.36249,1.18463>,
            
    /*3*/ <-1.18579,5.71011,1.46891>,<-1.1897,5.71383,1.46368>,<-1.1822,5.71441,1.46389>,
            
    /*4*/ <-1.26499,6.03834,1.76978>

    /* stem 0.11.12*/ 
    /*0*/ <-1.23312,5.17224,0.91068>,
    /*1*/ <-1.23936,5.17666,0.90102>,<-1.23327,5.1783,0.92141>,<-1.22673,5.16175,0.90962>,
            
    /*2*/ <-1.58556,4.95053,1.02626>,<-1.5815,4.95162,1.03985>,<-1.57714,4.94059,1.03199>,
            
    /*3*/ <-1.97493,4.90061,1.20474>,<-1.97214,4.90151,1.21123>,<-1.97259,4.89499,1.20842>,
            
    /*4*/ <-2.32019,5.04842,1.41779>

    /* stem 0.11.13*/ 
    /*0*/ <-1.32464,5.21299,0.98841>,
    /*1*/ <-1.31648,5.21639,0.99623>,<-1.33339,5.20581,0.99176>,<-1.32404,5.21677,0.97724>,
            
    /*2*/ <-1.55252,5.54604,1.09306>,<-1.5638,5.53898,1.09007>,<-1.55757,5.54628,1.08039>,
            
    /*3*/ <-1.69129,5.89911,1.26021>,<-1.69772,5.89695,1.25956>,<-1.69479,5.90049,1.25453>,
            
    /*4*/ <-1.8452,6.22095,1.47562>

    /* stem 0.11.14*/ 
    /*0*/ <-1.40801,5.25012,1.05922>,
    /*1*/ <-1.41428,5.24104,1.0566>,<-1.41294,5.26025,1.06042>,<-1.39681,5.24906,1.06064>,
            
    /*2*/ <-1.46888,5.17009,1.44951>,<-1.46799,5.1829,1.45205>,<-1.45724,5.17543,1.4522>,
            
    /*3*/ <-1.57222,5.22201,1.83691>,<-1.57132,5.22847,1.83634>,<-1.56635,5.22462,1.83818>,
            
    /*4*/ <-1.72532,5.38969,2.1705>

    /* stem 0.11.15*/ 
    /*0*/ <-1.46823,5.2863,1.11215>,
    /*1*/ <-1.46507,5.29573,1.10751>,<-1.46912,5.28558,1.12307>,<-1.47051,5.27759,1.10587>,
            
    /*2*/ <-1.84075,5.40697,1.08636>,<-1.84344,5.40021,1.09674>,<-1.84438,5.39488,1.08527>,
            
    /*3*/ <-2.18925,5.57588,1.14665>,<-2.19012,5.57235,1.15184>,<-2.19212,5.57025,1.1462>,
            
    /*4*/ <-2.43369,5.86828,1.23486>

    /* stem 0.11.16*/ 
    /*0*/ <-1.54666,5.34785,1.18381>,
    /*1*/ <-1.54416,5.34164,1.19188>,<-1.55671,5.34997,1.18174>,<-1.53909,5.35195,1.17782>,
            
    /*2*/ <-1.52837,5.64506,1.41614>,<-1.53674,5.65062,1.40938>,<-1.52499,5.65194,1.40676>,
            
    /*3*/ <-1.6284,5.94796,1.61976>,<-1.63235,5.9496,1.61547>,<-1.62664,5.95162,1.61527>,
            
    /*4*/ <-1.82756,6.24308,1.74785>

    /* stem 0.11.17*/ 
    /*0*/ <-1.65441,5.43242,1.28228>,
    /*1*/ <-1.66081,5.4329,1.27486>,<-1.65301,5.44022,1.28806>,<-1.6494,5.42414,1.28391>,
            
    /*2*/ <-1.91857,5.31829,1.4943>,<-1.91337,5.32318,1.5031>,<-1.91096,5.31246,1.50033>,
            
    /*3*/ <-2.11978,5.39348,1.78174>,<-2.11539,5.3961,1.78418>,<-2.11623,5.39057,1.78505>,
            
    /*4*/ <-2.3174,5.56914,2.02182>

    /* stem 0.11.18*/ 
    /*0*/ <-1.72765,5.48991,1.34921>,
    /*1*/ <-1.72081,5.49456,1.3527>,<-1.73446,5.48732,1.35446>,<-1.72768,5.48785,1.34047>,
            
    /*2*/ <-1.88772,5.7867,1.28291>,<-1.89683,5.78188,1.28408>,<-1.89231,5.78223,1.27475>,
            
    /*3*/ <-2.10261,6.05462,1.26063>,<-2.10667,6.05146,1.26127>,<-2.1049,6.05248,1.2565>,
            
    /*4*/ <-2.23116,6.35583,1.36092>

    /* stem 0.11.19*/ 
    /*0*/ <-1.8141,5.55776,1.42821>,
    /*1*/ <-1.81793,5.55149,1.4294>,<-1.81771,5.56409,1.42669>,<-1.80666,5.55769,1.42852>,
            
    /*2*/ <-1.82979,5.62245,1.74878>,<-1.82964,5.63086,1.74698>,<-1.82227,5.62659,1.7482>,
            
    /*3*/ <-1.88902,5.83843,1.98987>,<-1.88852,5.84168,1.9871>,<-1.88513,5.84018,1.98928>,
            
    /*4*/ <-1.99403,6.10805,2.1438>

    /* stem 0.11.20*/ 
    /*0*/ <-1.86316,5.60764,1.47587>,
    /*1*/ <-1.86243,5.61211,1.47124>,<-1.86195,5.60916,1.48206>,<-1.86511,5.60165,1.47432>,
            
    /*2*/ <-2.16495,5.69909,1.51015>,<-2.16464,5.69712,1.51736>,<-2.16674,5.69211,1.51221>,
            
    /*3*/ <-2.41367,5.87233,1.6023>,<-2.41315,5.87123,1.60584>,<-2.41537,5.86925,1.60357>,
            
    /*4*/ <-2.56244,6.14893,1.63997>

    /* stem 0.11.21*/ 
    /*0*/ <-1.9243,5.68261,1.53846>,
    /*1*/ <-1.92195,5.68093,1.54276>,<-1.92945,5.68315,1.53836>,<-1.92149,5.68375,1.53426>,
            
    /*2*/ <-1.8945,5.96778,1.63758>,<-1.8995,5.96925,1.63464>,<-1.8942,5.96965,1.63191>,
            
    /*3*/ <-1.92667,6.26533,1.69134>,<-1.92913,6.26539,1.68964>,<-1.92644,6.2659,1.68842>,
            
    /*4*/ <-2.02437,6.54636,1.75109>

    /* stem 0.11.22*/ 
    /*0*/ <-2.01398,5.79259,1.63027>,
    /*1*/ <-2.01661,5.79196,1.62845>,<-2.01345,5.79561,1.63139>,<-2.01186,5.7902,1.63097>,
            
    /*2*/ <-2.16252,5.73064,1.86314>,<-2.16041,5.73307,1.8651>,<-2.15935,5.72947,1.86482>,
            
    /*3*/ <-2.31636,5.80358,2.08942>,<-2.31501,5.80478,2.08996>,<-2.31498,5.803,2.09055>,
            
    /*4*/ <-2.36493,5.97912,2.30662>

    /* stem 0.11.23*/ 
    /*0*/ <-2.05626,5.84445,1.67357>,
    /*1*/ <-2.05441,5.84591,1.67362>,<-2.05739,5.8439,1.67557>,<-2.05699,5.84353,1.67151>,
            
    /*2*/ <-2.22255,6.0586,1.6376>,<-2.22453,6.05726,1.6389>,<-2.22426,6.05701,1.6362>,
            
    /*3*/ <-2.43277,6.23379,1.64712>,<-2.43353,6.23285,1.64775>,<-2.43353,6.23292,1.64639>,
            
    /*4*/ <-2.63946,6.39649,1.72206>

    /* stem 0.11.24*/ 
    /*0*/ <-2.12521,5.929,1.74415>,
    /*1*/ <-2.12556,5.92833,1.74462>,<-2.12574,5.92964,1.74383>,<-2.12433,5.92903,1.744>,
            
    /*2*/ <-2.09339,6.06229,1.96264>,<-2.0935,6.06317,1.96212>,<-2.09257,6.06276,1.96223>,
            
    /*3*/ <-2.09776,6.26707,2.11964>,<-2.09782,6.26738,2.11923>,<-2.09735,6.26726,2.1194>,
            
    /*4*/ <-2.21513,6.46568,2.23488>

    /* stem 0.12*/ 
    /*0*/ <0.02016,5.0933,0.00169>,
    /*1*/ <0.05421,5.09249,0.01409>,<0.03143,5.12751,0.00575>,<-0.00692,5.11526,-0.00819>,
            <-0.00784,5.07266,-0.00847>,<0.02995,5.05859,0.0053>,
    /*2*/ <0.26526,5.09187,-0.58688>,<0.24704,5.11989,-0.59355>,<0.21636,5.11008,-0.60471>,
            <0.21562,5.07601,-0.60493>,<0.24585,5.06475,-0.59391>,
    /*3*/ <0.48842,5.18818,-1.17497>,<0.47377,5.209,-1.17731>,<0.45136,5.20182,-1.18729>,
            <0.45215,5.17655,-1.19112>,<0.47506,5.16813,-1.18351>,
    /*4*/ <0.70719,5.37004,-1.74485>,<0.69675,5.3835,-1.74469>,<0.68207,5.37887,-1.75201>,
            <0.68345,5.36255,-1.75669>,<0.69897,5.35708,-1.75227>,
    /*5*/ <0.83394,5.60572,-2.32514>,<0.82828,5.61197,-2.3239>,<0.82072,5.60927,-2.32675>,
            <0.8217,5.60136,-2.32975>,<0.82987,5.59916,-2.32875>,
    /*6*/ <0.95337,5.92393,-2.86376>

    /* stem 0.12.0*/ 
    /*0*/ <0.07105,5.09312,-0.1381>,
    /*1*/ <0.05766,5.10564,-0.14299>,<0.07352,5.07737,-0.14838>,<0.08197,5.09635,-0.12292>,
            
    /*2*/ <0.47075,5.39895,-0.4988>,<0.48133,5.3801,-0.50239>,<0.48696,5.39276,-0.48542>,
            
    /*3*/ <0.9394,5.73857,-0.72105>,<0.94533,5.7295,-0.72267>,<0.94598,5.73484,-0.71312>,
            
    /*4*/ <1.20131,6.17679,-1.06681>

    /* stem 0.12.1*/ 
    /*0*/ <0.11999,5.09295,-0.27254>,
    /*1*/ <0.1226,5.07481,-0.27157>,<0.1337,5.10391,-0.27786>,<0.10368,5.10011,-0.2682>,
            
    /*2*/ <-0.0555,5.02472,-0.84436>,<-0.0481,5.04412,-0.84855>,<-0.06812,5.04159,-0.84211>,
            
    /*3*/ <-0.12038,5.05067,-1.44345>,<-0.11633,5.06045,-1.44355>,<-0.12677,5.05906,-1.44248>,
            
    /*4*/ <-0.17805,5.30578,-1.98815>

    /* stem 0.12.2*/ 
    /*0*/ <0.14292,5.09286,-0.33552>,
    /*1*/ <0.15173,5.10829,-0.33233>,<0.13544,5.08992,-0.35168>,<0.14158,5.08038,-0.32255>,
            
    /*2*/ <0.65371,4.85353,-0.52157>,<0.64284,4.84128,-0.53447>,<0.64694,4.83493,-0.51505>,
            
    /*3*/ <1.14869,4.83065,-0.84256>,<1.14396,4.82458,-0.84959>,<1.14898,4.82028,-0.84153>,
            
    /*4*/ <1.56389,5.06815,-1.19097>

    /* stem 0.12.3*/ 
    /*0*/ <0.18286,5.09272,-0.44525>,
    /*1*/ <0.16725,5.08709,-0.45093>,<0.19759,5.08631,-0.4523>,<0.18375,5.10476,-0.43252>,
            
    /*2*/ <0.16525,5.51047,-0.84715>,<0.18547,5.50994,-0.84807>,<0.17625,5.52224,-0.83488>,
            
    /*3*/ <0.24863,5.94494,-1.22468>,<0.25866,5.94373,-1.22399>,<0.25388,5.95009,-1.21772>,
            
    /*4*/ <0.41646,6.33162,-1.62365>

    /* stem 0.12.4*/ 
    /*0*/ <0.22467,5.09257,-0.56012>,
    /*1*/ <0.23956,5.08639,-0.55469>,<0.22425,5.10679,-0.56944>,<0.2102,5.08452,-0.55622>,
            
    /*2*/ <0.27889,4.78046,-1.02829>,<0.26868,4.79405,-1.03813>,<0.25931,4.77921,-1.02932>,
            
    /*3*/ <0.39936,4.80171,-1.58159>,<0.39346,4.80949,-1.58266>,<0.38988,4.80042,-1.5838>,
            
    /*4*/ <0.46787,4.88738,-2.13678>

    /* stem 0.12.5*/ 
    /*0*/ <0.25923,5.10139,-0.6508>,
    /*1*/ <0.25105,5.11579,-0.65164>,<0.2595,5.09122,-0.6639>,<0.26714,5.09715,-0.63685>,
            
    /*2*/ <0.71224,5.36039,-0.83551>,<0.71787,5.34401,-0.84368>,<0.72296,5.34796,-0.82565>,
            
    /*3*/ <1.17503,5.54757,-1.0767>,<1.17691,5.53881,-1.08008>,<1.18029,5.54146,-1.07152>,
            
    /*4*/ <1.47305,5.75,-1.49549>

    /* stem 0.12.6*/ 
    /*0*/ <0.31491,5.12467,-0.79259>,
    /*1*/ <0.31282,5.10924,-0.79594>,<0.32826,5.13206,-0.79712>,<0.30364,5.13269,-0.7847>,
            
    /*2*/ <0.08261,5.2465,-1.25893>,<0.0929,5.26172,-1.25972>,<0.07649,5.26214,-1.25144>,
            
    /*3*/ <-0.05413,5.49722,-1.7142>,<-0.04824,5.50402,-1.71231>,<-0.05694,5.50454,-1.70941>,
            
    /*4*/ <0.02937,5.74983,-2.17879>

    /* stem 0.12.7*/ 
    /*0*/ <0.35365,5.14086,-0.89125>,
    /*1*/ <0.36438,5.15039,-0.88547>,<0.34574,5.1449,-0.90391>,<0.35083,5.12731,-0.88436>,
            
    /*2*/ <0.72348,4.91979,-1.18625>,<0.71106,4.91613,-1.19855>,<0.71445,4.90441,-1.18551>,
            
    /*3*/ <0.98089,4.84314,-1.63469>,<0.97316,4.84222,-1.63906>,<0.97717,4.83507,-1.63554>,
            
    /*4*/ <0.97669,4.98637,-2.13762>

    /* stem 0.12.8*/ 
    /*0*/ <0.39211,5.15695,-0.9892>,
    /*1*/ <0.37812,5.15733,-0.99463>,<0.40255,5.14852,-0.99594>,<0.39567,5.16499,-0.97704>,
            
    /*2*/ <0.50897,5.55102,-1.29011>,<0.52526,5.54514,-1.29098>,<0.52066,5.55613,-1.27838>,
            
    /*3*/ <0.76052,5.94908,-1.49165>,<0.76805,5.94486,-1.49076>,<0.76514,5.94993,-1.48436>,
            
    /*4*/ <0.99953,6.33851,-1.71621>

    /* stem 0.12.9*/ 
    /*0*/ <0.4541,5.18286,-1.14706>,
    /*1*/ <0.46459,5.17351,-1.14448>,<0.45698,5.19514,-1.15377>,<0.44074,5.17994,-1.14293>,
            
    /*2*/ <0.37518,4.96155,-1.5757>,<0.37011,4.97597,-1.58189>,<0.35928,4.96583,-1.57467>,
            
    /*3*/ <0.50845,4.96236,-2.04557>,<0.50549,4.97001,-2.04648>,<0.50061,4.96351,-2.04786>,
            
    /*4*/ <0.61565,5.16322,-2.47953>

    /* stem 0.12.10*/ 
    /*0*/ <0.48602,5.20313,-1.22779>,
    /*1*/ <0.48267,5.21632,-1.2249>,<0.48277,5.19768,-1.24017>,<0.49263,5.19539,-1.2183>,
            
    /*2*/ <0.90448,5.35712,-1.40027>,<0.90455,5.34469,-1.41045>,<0.91112,5.34316,-1.39587>,
            
    /*3*/ <1.269,5.57644,-1.61484>,<1.26949,5.5705,-1.62022>,<1.27374,5.57011,-1.61341>,
            
    /*4*/ <1.55608,5.829,-1.90111>

    /* stem 0.12.11*/ 
    /*0*/ <0.53329,5.24121,-1.34668>,
    /*1*/ <0.528,5.2303,-1.35227>,<0.54494,5.24601,-1.35111>,<0.52693,5.24732,-1.33664>,
            
    /*2*/ <0.30473,5.49909,-1.65451>,<0.31603,5.50957,-1.65373>,<0.30402,5.51044,-1.64409>,
            
    /*3*/ <0.22272,5.81537,-1.98341>,<0.22902,5.81928,-1.98131>,<0.22222,5.82089,-1.97806>,
            
    /*4*/ <0.33247,6.12234,-2.31182>

    /* stem 0.12.12*/ 
    /*0*/ <0.56284,5.26501,-1.421>,
    /*1*/ <0.57387,5.26896,-1.41535>,<0.5564,5.273,-1.42899>,<0.55825,5.25307,-1.41866>,
            
    /*2*/ <0.80683,5.10802,-1.76765>,<0.79519,5.11072,-1.77675>,<0.79642,5.09743,-1.76986>,
            
    /*3*/ <1.10798,5.03386,-2.09391>,<1.10268,5.0349,-2.09913>,<1.10395,5.02802,-2.09638>,
            
    /*4*/ <1.34027,5.17167,-2.45623>

    /* stem 0.12.13*/ 
    /*0*/ <0.59914,5.29425,-1.5123>,
    /*1*/ <0.58777,5.29868,-1.5154>,<0.60619,5.28841,-1.52093>,<0.60345,5.29566,-1.50056>,
            
    /*2*/ <0.77216,5.68192,-1.62697>,<0.78444,5.67508,-1.63067>,<0.78261,5.67991,-1.61708>,
            
    /*3*/ <0.82612,6.08787,-1.77974>,<0.83263,6.08605,-1.78241>,<0.83208,6.08867,-1.77565>,
            
    /*4*/ <0.82236,6.50611,-1.91357>

    /* stem 0.12.14*/ 
    /*0*/ <0.63285,5.3214,-1.59709>,
    /*1*/ <0.63938,5.31113,-1.59778>,<0.63744,5.33185,-1.60139>,<0.62173,5.32123,-1.59209>,
            
    /*2*/ <0.46606,5.23169,-1.98126>,<0.46476,5.2455,-1.98366>,<0.45429,5.23843,-1.97746>,
            
    /*3*/ <0.27656,5.40017,-2.33151>,<0.2775,5.40666,-2.32895>,<0.2716,5.40311,-2.32747>,
            
    /*4*/ <0.09251,5.71639,-2.55733>

    /* stem 0.12.15*/ 
    /*0*/ <0.67591,5.35609,-1.7054>,
    /*1*/ <0.67688,5.36708,-1.7015>,<0.67245,5.35407,-1.71639>,<0.67841,5.34713,-1.69831>,
            
    /*2*/ <1.07046,5.37351,-1.82868>,<1.06751,5.36484,-1.83861>,<1.07148,5.36021,-1.82656>,
            
    /*3*/ <1.36615,5.61022,-1.98538>,<1.36599,5.60669,-1.99114>,<1.37013,5.60482,-1.98615>,
            
    /*4*/ <1.67424,5.8412,-2.13667>

    /* stem 0.12.16*/ 
    /*0*/ <0.706,5.39214,-1.80342>,
    /*1*/ <0.69846,5.38516,-1.80801>,<0.71619,5.39326,-1.80807>,<0.70335,5.39801,-1.79419>,
            
    /*2*/ <0.56382,5.68606,-2.03559>,<0.57564,5.69146,-2.03562>,<0.56708,5.69463,-2.02637>,
            
    /*3*/ <0.54023,5.98489,-2.3029>,<0.54643,5.98645,-2.30178>,<0.54171,5.98921,-2.29828>,
            
    /*4*/ <0.63935,6.27964,-2.55672>

    /* stem 0.12.17*/ 
    /*0*/ <0.73884,5.45008,-1.94557>,
    /*1*/ <0.74915,5.45041,-1.94306>,<0.73448,5.45801,-1.95114>,<0.73288,5.44183,-1.94252>,
            
    /*2*/ <0.83064,5.26867,-2.26872>,<0.82086,5.27374,-2.27411>,<0.8198,5.26296,-2.26836>,
            
    /*3*/ <0.92195,5.28035,-2.6391>,<0.91669,5.28324,-2.64036>,<0.91693,5.27711,-2.64049>,
            
    /*4*/ <1.04735,5.41258,-2.97405>

    /* stem 0.12.18*/ 
    /*0*/ <0.76169,5.49041,-2.04451>,
    /*1*/ <0.75336,5.49625,-2.04405>,<0.76451,5.48624,-2.05337>,<0.7672,5.48873,-2.03611>,
            
    /*2*/ <0.96062,5.79173,-2.11901>,<0.96805,5.78506,-2.12522>,<0.96985,5.78672,-2.11372>,
            
    /*3*/ <1.07406,6.13689,-2.16838>,<1.07837,6.13501,-2.17192>,<1.07932,6.13553,-2.16614>,
            
    /*4*/ <1.08004,6.48364,-2.29079>

    /* stem 0.12.19*/ 
    /*0*/ <0.78757,5.53609,-2.15658>,
    /*1*/ <0.79022,5.52755,-2.15945>,<0.79333,5.54342,-2.15772>,<0.77917,5.5373,-2.15257>,
            
    /*2*/ <0.64666,5.59287,-2.47612>,<0.64873,5.60345,-2.47497>,<0.63929,5.59937,-2.47153>,
            
    /*3*/ <0.54032,5.82381,-2.72616>,<0.54216,5.82794,-2.72318>,<0.53705,5.82623,-2.72258>,
            
    /*4*/ <0.42156,6.02886,-2.98855>

    /* stem 0.12.20*/ 
    /*0*/ <0.81228,5.57969,-2.26356>,
    /*1*/ <0.81539,5.58629,-2.26016>,<0.80667,5.58038,-2.26928>,<0.81479,5.57241,-2.26125>,
            
    /*2*/ <1.05715,5.59232,-2.49856>,<1.05134,5.58838,-2.50465>,<1.05675,5.58307,-2.49929>,
            
    /*3*/ <1.27599,5.6069,-2.75806>,<1.27288,5.60484,-2.76083>,<1.27591,5.60227,-2.75842>,
            
    /*4*/ <1.50839,5.72335,-2.97527>

    /* stem 0.12.21*/ 
    /*0*/ <0.83764,5.63252,-2.37242>,
    /*1*/ <0.83192,5.63039,-2.37503>,<0.84299,5.63319,-2.37628>,<0.83799,5.63397,-2.36596>,
            
    /*2*/ <0.74897,5.93785,-2.43853>,<0.75636,5.93971,-2.43936>,<0.75302,5.94024,-2.43248>,
            
    /*3*/ <0.73563,6.25543,-2.50878>,<0.73945,6.25558,-2.50894>,<0.73765,6.25624,-2.50563>,
            
    /*4*/ <0.69559,6.56314,-2.60363>

    /* stem 0.12.22*/ 
    /*0*/ <0.86464,5.70051,-2.48706>,
    /*1*/ <0.86952,5.69913,-2.48672>,<0.86341,5.7051,-2.48887>,<0.86098,5.6973,-2.48558>,
            
    /*2*/ <0.85445,5.58332,-2.77215>,<0.85038,5.5873,-2.77358>,<0.84876,5.5821,-2.77139>,
            
    /*3*/ <0.87132,5.62274,-3.07769>,<0.86925,5.62482,-3.07755>,<0.86849,5.62201,-3.07796>,
            
    /*4*/ <0.82537,5.71367,-3.3692>

    /* stem 0.12.23*/ 
    /*0*/ <0.89157,5.76833,-2.60141>,
    /*1*/ <0.88941,5.77094,-2.60037>,<0.89173,5.76742,-2.60482>,<0.89357,5.76663,-2.59902>,
            
    /*2*/ <1.10447,5.9641,-2.64245>,<1.10601,5.96175,-2.64543>,<1.10724,5.96123,-2.64156>,
            
    /*3*/ <1.29988,6.1762,-2.68762>,<1.30073,6.17511,-2.68912>,<1.3014,6.1749,-2.68719>,
            
    /*4*/ <1.47979,6.40615,-2.68661>

    /* stem 0.12.24*/ 
    /*0*/ <0.90982,5.81428,-2.67888>,
    /*1*/ <0.90976,5.81214,-2.68017>,<0.91155,5.816,-2.67941>,<0.90816,5.8147,-2.67707>,
            
    /*2*/ <0.73603,5.93047,-2.86678>,<0.73722,5.93304,-2.86627>,<0.73496,5.93218,-2.86471>,
            
    /*3*/ <0.56958,6.12237,-2.98843>,<0.57043,6.12343,-2.98793>,<0.56931,6.12296,-2.98714>,
            
    /*4*/ <0.41852,6.35183,-3.04892>

    /* stem 0.12.25*/ 
    /*0*/ <0.9418,5.89479,-2.81463>,
    /*1*/ <0.94223,5.89518,-2.81431>,<0.94141,5.89506,-2.8151>,<0.94176,5.89415,-2.8145>,
            
    /*2*/ <1.12445,5.84489,-2.99537>,<1.1239,5.84481,-2.9959>,<1.12413,5.8442,-2.9955>,
            
    /*3*/ <1.27076,5.91433,-3.20094>,<1.27046,5.9143,-3.20117>,<1.27068,5.914,-3.20111>,
            
    /*4*/ <1.3648,6.06558,-3.39273>

    /* stem 0.13*/ 
    /*0*/ <0.02387,5.25313,0.00201>,
    /*1*/ <-0.01155,5.25392,0.0149>,<0.01333,5.28921,0.00491>,<0.05277,5.27463,-0.0091>,
            <0.05227,5.23034,-0.00776>,<0.01251,5.21754,0.00707>,
    /*2*/ <0.22097,5.26987,0.63053>,<0.24088,5.2981,0.62253>,<0.27244,5.28644,0.61133>,
            <0.27203,5.251,0.6124>,<0.24022,5.24076,0.62427>,
    /*3*/ <0.44425,5.36226,1.2424>,<0.45839,5.38326,1.23427>,<0.4825,5.37464,1.22708>,
            <0.48326,5.34832,1.23078>,<0.45962,5.34067,1.24025>,
    /*4*/ <0.66395,5.50039,1.84729>,<0.67306,5.51422,1.84095>,<0.68928,5.50855,1.83657>,
            <0.69019,5.49122,1.84019>,<0.67454,5.48618,1.84682>,
    /*5*/ <0.86179,5.70362,2.44086>,<0.86615,5.7104,2.43716>,<0.87442,5.70771,2.43543>,
            <0.87517,5.69928,2.43806>,<0.86737,5.69676,2.44142>,
    /*6*/ <1.11882,5.94178,2.99903>

    /* stem 0.13.0*/ 
    /*0*/ <0.08749,5.25767,0.17647>,
    /*1*/ <0.10174,5.26995,0.17095>,<0.09185,5.24162,0.18683>,<0.06888,5.26145,0.17162>,
            
    /*2*/ <0.02299,5.59422,0.71235>,<0.0164,5.57533,0.72294>,<0.00109,5.58855,0.71279>,
            
    /*3*/ <0.23573,5.92676,1.20488>,<0.23346,5.91811,1.21181>,<0.2256,5.92601,1.20987>,
            
    /*4*/ <0.52836,6.2618,1.65828>

    /* stem 0.13.1*/ 
    /*0*/ <0.11168,5.2594,0.24282>,
    /*1*/ <0.10832,5.24049,0.24454>,<0.10732,5.27133,0.25733>,<0.11941,5.26639,0.22659>,
            
    /*2*/ <0.68402,5.16633,0.4829>,<0.68335,5.18689,0.49143>,<0.69141,5.1836,0.47093>,
            
    /*3*/ <1.15733,5.32887,0.86823>,<1.15293,5.33902,0.8695>,<1.16024,5.33711,0.86133>,
            
    /*4*/ <1.54325,5.62609,1.26592>

    /* stem 0.13.2*/ 
    /*0*/ <0.16459,5.26318,0.3879>,
    /*1*/ <0.15604,5.27948,0.39059>,<0.18096,5.25981,0.39606>,<0.15677,5.25026,0.37703>,
            
    /*2*/ <-0.13002,5.04249,0.87312>,<-0.11341,5.02938,0.87677>,<-0.12953,5.02301,0.86408>,
            
    /*3*/ <-0.35327,5.21911,1.40354>,<-0.3462,5.21287,1.40868>,<-0.35581,5.20894,1.40592>,
            
    /*4*/ <-0.47117,5.58754,1.87159>

    /* stem 0.13.3*/ 
    /*0*/ <0.18589,5.26471,0.44632>,
    /*1*/ <0.202,5.25808,0.44062>,<0.17906,5.25951,0.46251>,<0.17662,5.27654,0.43583>,
            
    /*2*/ <0.47982,5.71894,0.70936>,<0.46452,5.71989,0.72395>,<0.46289,5.73124,0.70616>,
            
    /*3*/ <0.8348,6.16798,0.88735>,<0.8285,6.16978,0.89566>,<0.82676,6.1748,0.88651>,
            
    /*4*/ <1.19211,6.60879,1.08696>

    /* stem 0.13.4*/ 
    /*0*/ <0.23379,5.26813,0.57765>,
    /*1*/ <0.21808,5.26242,0.58352>,<0.24227,5.28111,0.58621>,<0.24102,5.26085,0.5632>,
            
    /*2*/ <0.49258,4.8677,0.91628>,<0.50871,4.88016,0.91807>,<0.50788,4.86665,0.90273>,
            
    /*3*/ <0.63637,4.51604,1.35706>,<0.64485,4.52149,1.35875>,<0.64508,4.51353,1.35233>,
            
    /*4*/ <0.74356,4.66246,1.91319>

    /* stem 0.13.5*/ 
    /*0*/ <0.27157,5.27877,0.68349>,
    /*1*/ <0.27928,5.29337,0.67858>,<0.27895,5.26871,0.69537>,<0.25649,5.27422,0.67652>,
            
    /*2*/ <0.00087,5.57246,1.09186>,<0.00065,5.55602,1.10306>,<-0.01432,5.55969,1.09049>,
            
    /*3*/ <-0.11497,5.87165,1.56258>,<-0.11477,5.86333,1.56802>,<-0.12331,5.86641,1.56397>,
            
    /*4*/ <-0.24709,6.23422,1.98279>

    /* stem 0.13.6*/ 
    /*0*/ <0.3241,5.30125,0.83277>,
    /*1*/ <0.32727,5.28508,0.83409>,<0.31642,5.3092,0.84507>,<0.32859,5.30948,0.81915>,
            
    /*2*/ <0.81445,5.40513,1.0641>,<0.80721,5.42121,1.07142>,<0.81533,5.42139,1.05414>,
            
    /*3*/ <1.25345,5.70423,1.22738>,<1.24769,5.71137,1.23003>,<1.25118,5.71109,1.22114>,
            
    /*4*/ <1.64118,6.05298,1.41007>

    /* stem 0.13.7*/ 
    /*0*/ <0.34749,5.31127,0.89925>,
    /*1*/ <0.33545,5.32183,0.90189>,<0.36252,5.31466,0.90431>,<0.34448,5.29731,0.89154>,
            
    /*2*/ <0.23341,5.07838,1.37688>,<0.25145,5.0736,1.3785>,<0.23943,5.06203,1.36998>,
            
    /*3*/ <0.16523,5.05788,1.913>,<0.17423,5.05556,1.91414>,<0.16777,5.04887,1.91305>,
            
    /*4*/ <0.01243,5.18907,2.41591>

    /* stem 0.13.8*/ 
    /*0*/ <0.39548,5.33181,1.03564>,
    /*1*/ <0.4102,5.33151,1.03051>,<0.39186,5.32527,1.04934>,<0.38437,5.33864,1.02708>,
            
    /*2*/ <0.49919,5.7885,1.27504>,<0.48696,5.78434,1.2876>,<0.48197,5.79326,1.27276>,
            
    /*3*/ <0.53741,6.12242,1.68206>,<0.53068,6.11817,1.68627>,<0.52891,6.12508,1.68077>,
            
    /*4*/ <0.70446,6.45705,2.04987>

    /* stem 0.13.9*/ 
    /*0*/ <0.4336,5.34813,1.144>,
    /*1*/ <0.42295,5.33874,1.14916>,<0.43712,5.36058,1.15181>,<0.44073,5.34508,1.13104>,
            
    /*2*/ <0.78276,5.07953,1.40501>,<0.79221,5.09409,1.40678>,<0.79461,5.08376,1.39293>,
            
    /*3*/ <1.18247,5.06917,1.72973>,<1.18415,5.07755,1.72803>,<1.18789,5.0713,1.72324>,
            
    /*4*/ <1.40283,5.21341,2.16831>

    /* stem 0.13.10*/ 
    /*0*/ <0.48474,5.37427,1.28962>,
    /*1*/ <0.48637,5.38813,1.28589>,<0.49437,5.36795,1.29832>,<0.47347,5.36674,1.28464>,
            
    /*2*/ <0.22078,5.52038,1.67983>,<0.22612,5.50693,1.68812>,<0.21218,5.50612,1.679>,
            
    /*3*/ <0.25547,5.70714,2.13345>,<0.259,5.70009,2.13615>,<0.25072,5.70098,2.13643>,
            
    /*4*/ <0.36218,6.05015,2.46854>

    /* stem 0.13.11*/ 
    /*0*/ <0.51896,5.39654,1.3874>,
    /*1*/ <0.5262,5.38456,1.38759>,<0.51283,5.40119,1.39908>,<0.51785,5.40385,1.37552>,
            
    /*2*/ <0.92269,5.63151,1.50005>,<0.91377,5.6426,1.50771>,<0.91712,5.64437,1.492>,
            
    /*3*/ <1.33824,5.83334,1.62854>,<1.33427,5.83898,1.63275>,<1.33606,5.84026,1.62497>,
            
    /*4*/ <1.6674,6.10829,1.84738>

    /* stem 0.13.12*/ 
    /*0*/ <0.54947,5.41638,1.47457>,
    /*1*/ <0.53715,5.42116,1.47779>,<0.56048,5.42415,1.47643>,<0.55078,5.40383,1.46949>,
            
    /*2*/ <0.58855,5.24865,1.911>,<0.60411,5.25064,1.91009>,<0.59764,5.23709,1.90546>,
            
    /*3*/ <0.73329,5.32203,2.35108>,<0.74059,5.32339,2.34852>,<0.73839,5.3161,2.35046>,
            
    /*4*/ <0.90091,5.56444,2.71583>

    /* stem 0.13.13*/ 
    /*0*/ <0.59297,5.44467,1.59885>,
    /*1*/ <0.60432,5.44881,1.59394>,<0.59281,5.43755,1.60977>,<0.58179,5.44767,1.59284>,
            
    /*2*/ <0.56935,5.82605,1.8422>,<0.56167,5.81854,1.85276>,<0.55433,5.82529,1.84147>,
            
    /*3*/ <0.52184,6.10144,2.20073>,<0.51798,6.09611,2.20439>,<0.51435,6.1011,2.20007>,
            
    /*4*/ <0.51019,6.46429,2.47016>

    /* stem 0.13.14*/ 
    /*0*/ <0.62377,5.4647,1.68683>,
    /*1*/ <0.61836,5.45411,1.69113>,<0.62277,5.47545,1.69343>,<0.63017,5.46455,1.67592>,
            
    /*2*/ <0.99036,5.35746,1.90841>,<0.9933,5.37168,1.90994>,<0.99823,5.36442,1.89827>,
            
    /*3*/ <1.31669,5.4399,2.19725>,<1.31594,5.44707,2.19614>,<1.32057,5.4432,2.19202>,
            
    /*4*/ <1.47549,5.56903,2.58787>

    /* stem 0.13.15*/ 
    /*0*/ <0.65224,5.48322,1.76817>,
    /*1*/ <0.64959,5.49509,1.76639>,<0.66332,5.47995,1.77235>,<0.6438,5.47462,1.76576>,
            
    /*2*/ <0.50608,5.51962,2.17198>,<0.51523,5.50953,2.17595>,<0.50221,5.50598,2.17156>,
            
    /*3*/ <0.35377,5.64717,2.55214>,<0.35782,5.64237,2.55543>,<0.35126,5.64065,2.55338>,
            
    /*4*/ <0.29966,5.84401,2.93108>

    /* stem 0.13.16*/ 
    /*0*/ <0.68905,5.51168,1.87627>,
    /*1*/ <0.69832,5.50438,1.87579>,<0.68211,5.51179,1.88581>,<0.68674,5.51887,1.8672>,
            
    /*2*/ <0.93561,5.80076,2.04775>,<0.92481,5.8057,2.05442>,<0.92789,5.81042,2.04202>,
            
    /*3*/ <1.03972,6.04354,2.37202>,<1.03314,6.04448,2.3735>,<1.03632,6.04877,2.36927>,
            
    /*4*/ <1.15582,6.36033,2.61733>

    /* stem 0.13.17*/ 
    /*0*/ <0.73602,5.56176,2.02304>,
    /*1*/ <0.72539,5.56187,2.0264>,<0.7425,5.57066,2.02477>,<0.74016,5.55276,2.01794>,
            
    /*2*/ <0.83888,5.41334,2.37704>,<0.85028,5.41921,2.37595>,<0.84872,5.40727,2.3714>,
            
    /*3*/ <0.92922,5.38672,2.76242>,<0.93479,5.38976,2.76137>,<0.9345,5.38334,2.761>,
            
    /*4*/ <0.99764,5.59361,3.0945>

    /* stem 0.13.18*/ 
    /*0*/ <0.76614,5.59388,2.11717>,
    /*1*/ <0.77339,5.60036,2.11264>,<0.7691,5.58716,2.12499>,<0.75593,5.59413,2.11389>,
            
    /*2*/ <0.69304,5.86877,2.37652>,<0.69018,5.85997,2.38475>,<0.6814,5.86461,2.37735>,
            
    /*3*/ <0.68192,6.12253,2.66499>,<0.68057,6.118,2.66899>,<0.67601,6.12107,2.66612>,
            
    /*4*/ <0.74349,6.37896,2.94462>

    /* stem 0.13.19*/ 
    /*0*/ <0.80946,5.64008,2.25257>,
    /*1*/ <0.80865,5.63083,2.25598>,<0.80661,5.6477,2.2582>,<0.81312,5.64171,2.24352>,
            
    /*2*/ <1.14706,5.65623,2.39553>,<1.14571,5.66748,2.39701>,<1.15004,5.66349,2.38722>,
            
    /*3*/ <1.34789,5.78559,2.67495>,<1.34572,5.79081,2.67415>,<1.3505,5.78926,2.67143>,
            
    /*4*/ <1.44827,6.04764,2.91322>

    /* stem 0.13.20*/ 
    /*0*/ <0.84542,5.67843,2.36495>,
    /*1*/ <0.84076,5.68544,2.36404>,<0.85361,5.67902,2.36704>,<0.84189,5.67082,2.36376>,
            
    /*2*/ <0.75608,5.6697,2.70539>,<0.76465,5.66542,2.70739>,<0.75684,5.65995,2.7052>,
            
    /*3*/ <0.61213,5.81144,2.99038>,<0.6158,5.80972,2.99312>,<0.61178,5.80702,2.99243>,
            
    /*4*/ <0.50177,6.07753,3.19098>

    /* stem 0.13.21*/ 
    /*0*/ <0.88754,5.72125,2.48022>,
    /*1*/ <0.89381,5.7187,2.47851>,<0.88502,5.72029,2.48666>,<0.8838,5.72477,2.47549>,
            
    /*2*/ <1.03576,6.00682,2.57859>,<1.02989,6.00788,2.58402>,<1.02908,6.01086,2.57658>,
            
    /*3*/ <1.19449,6.27097,2.71299>,<1.19154,6.2714,2.7157>,<1.19133,6.27332,2.71217>,
            
    /*4*/ <1.38455,6.52642,2.82081>

    /* stem 0.13.22*/ 
    /*0*/ <0.94234,5.7735,2.60314>,
    /*1*/ <0.93791,5.77206,2.60573>,<0.94428,5.77843,2.60373>,<0.94482,5.77002,2.59996>,
            
    /*2*/ <1.11592,5.67355,2.85155>,<1.12017,5.6778,2.85021>,<1.12053,5.6722,2.84771>,
            
    /*3*/ <1.37185,5.69337,3.04338>,<1.37295,5.69569,3.0417>,<1.3737,5.6928,3.041>,
            
    /*4*/ <1.6055,5.80435,3.23044>

    /* stem 0.13.23*/ 
    /*0*/ <1.0051,5.83335,2.74394>,
    /*1*/ <1.00639,5.83603,2.74223>,<1.00715,5.83145,2.74593>,<1.00177,5.83258,2.74367>,
            
    /*2*/ <0.94525,6.01307,2.97561>,<0.94576,6.01001,2.97808>,<0.94217,6.01077,2.97657>,
            
    /*3*/ <0.97428,6.24383,3.16271>,<0.9746,6.24258,3.16421>,<0.97275,6.24316,3.16378>,
            
    /*4*/ <1.02275,6.44265,3.38121>

    /* stem 0.13.24*/ 
    /*0*/ <1.03832,5.86502,2.81844>,
    /*1*/ <1.03894,5.86277,2.81912>,<1.03741,5.86658,2.82008>,<1.03859,5.86571,2.81613>,
            
    /*2*/ <1.30585,5.95551,2.87853>,<1.30484,5.95805,2.87917>,<1.30562,5.95747,2.87654>,
            
    /*3*/ <1.46782,6.17814,2.96812>,<1.46668,6.17896,2.96814>,<1.46746,6.17886,2.96698>,
            
    /*4*/ <1.57563,6.42053,3.08235>

    /* stem 0.13.25*/ 
    /*0*/ <1.10407,5.92772,2.96595>,
    /*1*/ <1.10373,5.928,2.96598>,<1.10448,5.92785,2.96607>,<1.104,5.92731,2.96579>,
            
    /*2*/ <1.05383,5.8397,3.21399>,<1.05433,5.83959,3.21406>,<1.05402,5.83923,3.21386>,
            
    /*3*/ <1.01613,5.86366,3.47812>,<1.01638,5.86361,3.47816>,<1.01621,5.86342,3.47816>,
            
    /*4*/ <0.97284,5.98649,3.71225>

    /* stem 0.14*/ 
    /*0*/ <0.02744,5.40766,0.00231>,
    /*1*/ <0.047,5.40727,-0.03158>,<0.03636,5.44462,-0.00693>,<0.0134,5.43089,0.03048>,
            <0.00985,5.38506,0.02895>,<0.03061,5.37046,-0.0094>,
    /*2*/ <-0.5425,5.46407,-0.36346>,<-0.55101,5.49394,-0.34374>,<-0.56938,5.48296,-0.31381>,
            <-0.57222,5.4463,-0.31503>,<-0.55561,5.43462,-0.34572>,
    /*3*/ <-1.09973,5.64601,-0.70387>,<-1.10299,5.6678,-0.68726>,<-1.11885,5.66006,-0.66604>,
            <-1.12539,5.63348,-0.66954>,<-1.11357,5.62479,-0.69292>,
    /*4*/ <-1.67417,5.87158,-0.99127>,<-1.67486,5.88549,-0.97925>,<-1.68458,5.87993,-0.96466>,
            <-1.6899,5.86257,-0.96766>,<-1.68346,5.85741,-0.9841>,
    /*5*/ <-2.18912,6.26886,-1.1898>,<-2.18745,6.27462,-1.18282>,<-2.19247,6.27188,-1.17562>,
            <-2.19725,6.26443,-1.17814>,<-2.19517,6.26257,-1.18691>,
    /*6*/ <-2.66266,6.73694,-1.3245>

    /* stem 0.14.0*/ 
    /*0*/ <-0.1377,5.42365,-0.0932>,
    /*1*/ <-0.14448,5.43683,-0.07927>,<-0.14871,5.4072,-0.09784>,<-0.11991,5.42693,-0.10249>,
            
    /*2*/ <-0.44992,5.77087,-0.55396>,<-0.45275,5.75112,-0.56633>,<-0.43354,5.76427,-0.56943>,
            
    /*3*/ <-0.73122,6.14362,-1.01374>,<-0.73286,6.13419,-1.02053>,<-0.72298,6.14047,-1.02148>,
            
    /*4*/ <-0.97582,6.65477,-1.34056>

    /* stem 0.14.1*/ 
    /*0*/ <-0.22167,5.43179,-0.14176>,
    /*1*/ <-0.22145,5.41222,-0.1454>,<-0.22838,5.44442,-0.1556>,<-0.21516,5.43872,-0.12427>,
            
    /*2*/ <-0.81643,5.36726,0.0975>,<-0.82105,5.38872,0.09071>,<-0.81223,5.38492,0.11159>,
            
    /*3*/ <-1.45607,5.36313,0.02402>,<-1.45586,5.37413,0.02068>,<-1.45711,5.37152,0.0318>,
            
    /*4*/ <-1.99344,5.59877,-0.2465>

    /* stem 0.14.2*/ 
    /*0*/ <-0.28912,5.43832,-0.18077>,
    /*1*/ <-0.28292,5.4551,-0.18867>,<-0.30785,5.43631,-0.17554>,<-0.27658,5.42356,-0.17809>,
            
    /*2*/ <-0.42256,5.22769,-0.76469>,<-0.43918,5.21516,-0.75594>,<-0.41833,5.20666,-0.75764>,
            
    /*3*/ <-0.74603,5.32132,-1.29799>,<-0.75476,5.31548,-1.29383>,<-0.74667,5.31017,-1.29966>,
            
    /*4*/ <-1.17389,5.55889,-1.70139>

    /* stem 0.14.3*/ 
    /*0*/ <-0.39566,5.44864,-0.24238>,
    /*1*/ <-0.40509,5.44234,-0.22713>,<-0.40009,5.44209,-0.25967>,<-0.38181,5.46149,-0.24035>,
            
    /*2*/ <-0.81575,5.9012,-0.29938>,<-0.81241,5.90104,-0.32107>,<-0.80022,5.91397,-0.30819>,
            
    /*3*/ <-1.21106,6.3747,-0.36342>,<-1.2095,6.37466,-0.37428>,<-1.20312,6.38085,-0.36785>,
            
    /*4*/ <-1.64663,6.79822,-0.48784>

    /* stem 0.14.4*/ 
    /*0*/ <-0.5048,5.45921,-0.3055>,
    /*1*/ <-0.49662,5.45275,-0.32073>,<-0.51424,5.47505,-0.30611>,<-0.50353,5.44983,-0.28966>,
            
    /*2*/ <-1.00214,5.14959,-0.45623>,<-1.01389,5.16446,-0.44649>,<-1.00675,5.14765,-0.43552>,
            
    /*3*/ <-1.55275,5.09029,-0.70021>,<-1.55631,5.09846,-0.69438>,<-1.55693,5.08853,-0.69057>,
            
    /*4*/ <-2.05059,5.31637,-0.96028>

    /* stem 0.14.5*/ 
    /*0*/ <-0.60728,5.48053,-0.36718>,
    /*1*/ <-0.60833,5.49563,-0.3576>,<-0.62179,5.47023,-0.36928>,<-0.59173,5.47572,-0.37466>,
            
    /*2*/ <-0.74998,5.79027,-0.84896>,<-0.75896,5.77334,-0.85675>,<-0.73891,5.777,-0.86033>,
            
    /*3*/ <-0.99006,6.17963,-1.21702>,<-0.99528,6.17206,-1.22175>,<-0.98586,6.17471,-1.2251>,
            
    /*4*/ <-1.41695,6.49832,-1.4705>

    /* stem 0.14.6*/ 
    /*0*/ <-0.68845,5.5072,-0.41811>,
    /*1*/ <-0.69413,5.49067,-0.41771>,<-0.69087,5.51693,-0.43242>,<-0.68034,5.51399,-0.40419>,
            
    /*2*/ <-1.20074,5.67597,-0.20944>,<-1.19857,5.69347,-0.21925>,<-1.19155,5.69151,-0.20042>,
            
    /*3*/ <-1.68735,5.98378,-0.1336>,<-1.68351,5.99135,-0.13906>,<-1.68211,5.99111,-0.12907>,
            
    /*4*/ <-2.0057,6.46932,-0.14382>

    /* stem 0.14.7*/ 
    /*0*/ <-0.77993,5.53726,-0.47551>,
    /*1*/ <-0.77048,5.54755,-0.48518>,<-0.79428,5.54303,-0.46847>,<-0.77503,5.5212,-0.47287>,
            
    /*2*/ <-1.06315,5.38073,-0.93851>,<-1.07902,5.37772,-0.92737>,<-1.06618,5.36317,-0.9303>,
            
    /*3*/ <-1.44785,5.56098,-1.30729>,<-1.45494,5.55977,-1.30061>,<-1.45259,5.55241,-1.30666>,
            
    /*4*/ <-1.91561,5.87003,-1.38413>

    /* stem 0.14.8*/ 
    /*0*/ <-0.86789,5.56617,-0.53069>,
    /*1*/ <-0.8766,5.56647,-0.51665>,<-0.8747,5.5602,-0.54452>,<-0.85236,5.57184,-0.53091>,
            
    /*2*/ <-1.05949,6.07049,-0.64726>,<-1.05822,6.06632,-0.66584>,<-1.04333,6.07407,-0.65676>,
            
    /*3*/ <-1.31714,6.51977,-0.83857>,<-1.31601,6.5167,-0.84753>,<-1.30936,6.52223,-0.84351>,
            
    /*4*/ <-1.64794,6.89781,-1.0669>

    /* stem 0.14.9*/ 
    /*0*/ <-0.96958,5.59959,-0.5945>,
    /*1*/ <-0.96556,5.58947,-0.60621>,<-0.97329,5.61476,-0.59796>,<-0.9699,5.59454,-0.57933>,
            
    /*2*/ <-1.48235,5.45388,-0.65922>,<-1.4875,5.47074,-0.65372>,<-1.48524,5.45726,-0.64129>,
            
    /*3*/ <-1.92858,5.52598,-0.9468>,<-1.92963,5.53442,-0.94321>,<-1.93347,5.52713,-0.93905>,
            
    /*4*/ <-2.31631,5.66033,-1.29264>

    /* stem 0.14.10*/ 
    /*0*/ <-1.06211,5.63,-0.65255>,
    /*1*/ <-1.05991,5.64476,-0.64833>,<-1.07647,5.62417,-0.65317>,<-1.04995,5.62107,-0.65616>,
            
    /*2*/ <-1.09954,5.78875,-1.14986>,<-1.11058,5.77502,-1.15309>,<-1.0929,5.77296,-1.15508>,
            
    /*3*/ <-1.05445,6.03341,-1.60754>,<-1.05986,6.02739,-1.61137>,<-1.05101,6.02602,-1.61123>,
            
    /*4*/ <-1.10231,6.31919,-2.04288>

    /* stem 0.14.11*/ 
    /*0*/ <-1.14419,5.65911,-0.70047>,
    /*1*/ <-1.15145,5.64669,-0.6959>,<-1.14455,5.66314,-0.715>,<-1.13658,5.66749,-0.6905>,
            
    /*2*/ <-1.56927,5.92868,-0.60994>,<-1.56467,5.93964,-0.62267>,<-1.55936,5.94254,-0.60634>,
            
    /*3*/ <-1.97062,6.24504,-0.65268>,<-1.96657,6.24943,-0.65902>,<-1.96555,6.25185,-0.65071>,
            
    /*4*/ <-2.28476,6.5654,-0.9003>

    /* stem 0.14.12*/ 
    /*0*/ <-1.27161,5.70946,-0.76615>,
    /*1*/ <-1.26392,5.71428,-0.77738>,<-1.28102,5.71821,-0.75955>,<-1.2699,5.69589,-0.76151>,
            
    /*2*/ <-1.62155,5.56273,-1.08118>,<-1.63295,5.56535,-1.0693>,<-1.62554,5.55047,-1.07061>,
            
    /*3*/ <-2.05218,5.57728,-1.32229>,<-2.05619,5.57895,-1.31517>,<-2.0551,5.57104,-1.31759>,
            
    /*4*/ <-2.47708,5.80221,-1.43356>

    /* stem 0.14.13*/ 
    /*0*/ <-1.40793,5.76333,-0.83642>,
    /*1*/ <-1.41254,5.76762,-0.82418>,<-1.41629,5.75643,-0.84489>,<-1.39495,5.76594,-0.84018>,
            
    /*2*/ <-1.54989,6.17455,-1.02378>,<-1.5524,6.1671,-1.03759>,<-1.53817,6.17344,-1.03445>,
            
    /*3*/ <-1.84081,6.53047,-1.12763>,<-1.8426,6.52706,-1.13458>,<-1.83653,6.53216,-1.13411>,
            
    /*4*/ <-2.20973,6.78839,-1.27618>

    /* stem 0.14.14*/ 
    /*0*/ <-1.4827,5.79288,-0.87496>,
    /*1*/ <-1.48296,5.78202,-0.88279>,<-1.48625,5.80479,-0.87993>,<-1.47889,5.79182,-0.86217>,
            
    /*2*/ <-1.92174,5.7066,-0.75601>,<-1.92393,5.72178,-0.7541>,<-1.91902,5.71313,-0.74226>,
            
    /*3*/ <-2.38371,5.73675,-0.73742>,<-2.38324,5.74442,-0.73661>,<-2.38329,5.73987,-0.73036>,
            
    /*4*/ <-2.75262,6.01523,-0.78366>

    /* stem 0.14.15*/ 
    /*0*/ <-1.6279,5.85026,-0.94981>,
    /*1*/ <-1.62328,5.86205,-0.94973>,<-1.63922,5.84785,-0.94465>,<-1.62121,5.84087,-0.95506>,
            
    /*2*/ <-1.81916,5.93689,-1.33898>,<-1.82979,5.92742,-1.33559>,<-1.81778,5.92276,-1.34252>,
            
    /*3*/ <-2.04067,6.15101,-1.65286>,<-2.04648,6.1467,-1.65178>,<-2.04138,6.1448,-1.65667>,
            
    /*4*/ <-2.23918,6.45935,-1.89805>

    /* stem 0.14.16*/ 
    /*0*/ <-1.71326,5.89616,-0.99019>,
    /*1*/ <-1.72114,5.88933,-0.9838>,<-1.71545,5.8986,-1.00198>,<-1.7032,5.90055,-0.9848>,
            
    /*2*/ <-1.93357,6.24557,-0.87269>,<-1.92977,6.25176,-0.88481>,<-1.9216,6.25305,-0.87336>,
            
    /*3*/ <-2.16136,6.60626,-0.82008>,<-2.15903,6.60871,-0.82628>,<-2.15545,6.61011,-0.82036>,
            
    /*4*/ <-2.40772,6.95705,-0.84914>

    /* stem 0.14.17*/ 
    /*0*/ <-1.8172,5.97694,-1.03195>,
    /*1*/ <-1.81247,5.97752,-1.0426>,<-1.82148,5.98657,-1.02694>,<-1.81764,5.96673,-1.02631>,
            
    /*2*/ <-2.18317,5.90065,-1.2072>,<-2.18918,5.90668,-1.19676>,<-2.18662,5.89346,-1.19634>,
            
    /*3*/ <-2.54877,5.98814,-1.37711>,<-2.55076,5.99114,-1.37142>,<-2.5519,5.98457,-1.37233>,
            
    /*4*/ <-2.86062,6.23061,-1.49745>

    /* stem 0.14.18*/ 
    /*0*/ <-1.90014,6.04141,-1.06528>,
    /*1*/ <-1.89989,6.04682,-1.05545>,<-1.90998,6.03845,-1.0698>,<-1.89057,6.03896,-1.07058>,
            
    /*2*/ <-1.91699,6.39491,-1.25094>,<-1.92371,6.38933,-1.2605>,<-1.91077,6.38967,-1.26103>,
            
    /*3*/ <-1.92988,6.77283,-1.37562>,<-1.9334,6.77106,-1.38076>,<-1.92693,6.77116,-1.38114>,
            
    /*4*/ <-1.91662,7.16411,-1.45322>

    /* stem 0.14.19*/ 
    /*0*/ <-1.98495,6.10732,-1.09935>,
    /*1*/ <-1.98969,6.09883,-1.10397>,<-1.98502,6.11688,-1.10431>,<-1.98014,6.10625,-1.08978>,
            
    /*2*/ <-2.31968,6.1909,-0.92596>,<-2.31656,6.20293,-0.92619>,<-2.31331,6.19585,-0.9165>,
            
    /*3*/ <-2.56318,6.48084,-0.8369>,<-2.5587,6.485,-0.83803>,<-2.5594,6.48266,-0.83231>,
            
    /*4*/ <-2.77053,6.80481,-0.87082>

    /* stem 0.14.20*/ 
    /*0*/ <-2.05218,6.15957,-1.12636>,
    /*1*/ <-2.04568,6.16681,-1.12854>,<-2.06069,6.16177,-1.12167>,<-2.05016,6.15014,-1.12888>,
            
    /*2*/ <-2.21688,6.21658,-1.45884>,<-2.2269,6.21322,-1.45426>,<-2.21987,6.20546,-1.45907>,
            
    /*3*/ <-2.35227,6.438,-1.7267>,<-2.35765,6.43679,-1.72504>,<-2.35506,6.43354,-1.72903>,
            
    /*4*/ <-2.59192,6.71787,-1.80008>

    /* stem 0.14.21*/ 
    /*0*/ <-2.16773,6.24938,-1.17279>,
    /*1*/ <-2.17231,6.24672,-1.16652>,<-2.17115,6.25062,-1.18014>,<-2.15972,6.25079,-1.1717>,
            
    /*2*/ <-2.24277,6.58528,-1.07814>,<-2.242,6.58787,-1.08722>,<-2.23438,6.58799,-1.0816>,
            
    /*3*/ <-2.37182,6.90434,-0.98604>,<-2.37156,6.90578,-0.99054>,<-2.36788,6.90642,-0.98763>,
            
    /*4*/ <-2.54376,7.18823,-0.85612>

    /* stem 0.14.22*/ 
    /*0*/ <-2.25487,6.33079,-1.20153>,
    /*1*/ <-2.25396,6.32969,-1.20816>,<-2.25614,6.33706,-1.19927>,<-2.25449,6.32562,-1.19715>,
            
    /*2*/ <-2.58999,6.27498,-1.24243>,<-2.59144,6.27989,-1.2365>,<-2.59034,6.27227,-1.23509>,
            
    /*3*/ <-2.89754,6.39329,-1.33306>,<-2.89757,6.39566,-1.32994>,<-2.89904,6.39204,-1.32967>,
            
    /*4*/ <-3.08535,6.60438,-1.52477>

    /* stem 0.14.23*/ 
    /*0*/ <-2.32952,6.40514,-1.22404>,
    /*1*/ <-2.32755,6.40834,-1.21996>,<-2.33498,6.40464,-1.22478>,<-2.32601,6.40243,-1.22736>,
            
    /*2*/ <-2.32358,6.66505,-1.42607>,<-2.32853,6.66259,-1.42928>,<-2.32254,6.66111,-1.431>,
            
    /*3*/ <-2.46169,6.88348,-1.63134>,<-2.46388,6.88131,-1.6322>,<-2.46113,6.88154,-1.63382>,
            
    /*4*/ <-2.64552,7.0896,-1.81063>

    /* stem 0.14.24*/ 
    /*0*/ <-2.40672,6.48203,-1.24732>,
    /*1*/ <-2.40959,6.47895,-1.24795>,<-2.40674,6.4855,-1.24978>,<-2.40383,6.48164,-1.24422>,
            
    /*2*/ <-2.60557,6.62219,-1.04585>,<-2.60367,6.62656,-1.04706>,<-2.60172,6.62398,-1.04336>,
            
    /*3*/ <-2.80835,6.83447,-0.9285>,<-2.80697,6.8363,-0.9294>,<-2.80655,6.83545,-0.92713>,
            
    /*4*/ <-2.98719,7.09074,-0.88135>

    /* stem 0.14.25*/ 
    /*0*/ <-2.5206,6.59545,-1.28166>,
    /*1*/ <-2.519,6.59671,-1.28286>,<-2.52188,6.59649,-1.27996>,<-2.52093,6.59317,-1.28216>,
            
    /*2*/ <-2.72547,6.66954,-1.48226>,<-2.72739,6.66939,-1.48033>,<-2.72676,6.66718,-1.4818>,
            
    /*3*/ <-2.90028,6.78196,-1.69285>,<-2.90134,6.78193,-1.692>,<-2.90107,6.78085,-1.69279>,
            
    /*4*/ <-3.1077,6.97549,-1.77815>

    /* stem 0.14.26*/ 
    /*0*/ <-2.61553,6.69,-1.31029>,
    /*1*/ <-2.61582,6.68993,-1.30956>,<-2.61602,6.68998,-1.3109>,<-2.61476,6.6901,-1.31039>,
            
    /*2*/ <-2.64763,6.96748,-1.29595>,<-2.64776,6.96751,-1.29685>,<-2.64693,6.96759,-1.29651>,
            
    /*3*/ <-2.69818,7.24096,-1.32626>,<-2.69822,7.24091,-1.3267>,<-2.69782,7.241,-1.32653>,
            
    /*4*/ <-2.7532,7.51227,-1.28675>

    /* stem 0.15*/ 
    /*0*/ <0.03208,5.6079,0.0027>,
    /*1*/ <0.03919,5.60766,0.04305>,<0.03137,5.64668,0.01591>,<0.02453,5.63211,-0.02949>,
            <0.02813,5.58408,-0.03041>,<0.03719,5.56897,0.01442>,
    /*2*/ <0.73061,5.66195,-0.08681>,<0.72434,5.69316,-0.10852>,<0.71887,5.68151,-0.14484>,
            <0.72175,5.64309,-0.14558>,<0.729,5.63099,-0.10972>,
    /*3*/ <1.40174,5.8557,-0.17244>,<1.39336,5.87851,-0.18809>,<1.39248,5.87046,-0.21584>,
            <1.4003,5.84268,-0.21734>,<1.40603,5.83356,-0.19051>,
    /*4*/ <2.0423,6.14167,-0.24624>,<2.03479,6.15618,-0.25645>,<2.03512,6.15117,-0.27505>,
            <2.04283,6.13356,-0.27633>,<2.04727,6.12769,-0.25852>,
    /*5*/ <2.62838,6.52884,-0.31364>,<2.6235,6.53548,-0.31864>,<2.62406,6.53319,-0.32798>,
            <2.62929,6.52514,-0.32876>,<2.63196,6.52245,-0.3199>,
    /*6*/ <3.12658,7.02359,-0.3854>

    /* stem 0.15.0*/ 
    /*0*/ <0.19307,5.6205,-0.0256>,
    /*1*/ <0.18919,5.63435,-0.04153>,<0.20617,5.60382,-0.02885>,<0.18386,5.62334,-0.00643>,
            
    /*2*/ <0.7248,6.01014,0.16433>,<0.73612,5.98978,0.17278>,<0.72125,6.00279,0.18772>,
            
    /*3*/ <1.34731,6.24469,0.33845>,<1.35063,6.23337,0.34225>,<1.34541,6.2413,0.35021>,
            
    /*4*/ <2.00839,6.36662,0.20971>

    /* stem 0.15.1*/ 
    /*0*/ <0.29897,5.62879,-0.04422>,
    /*1*/ <0.30114,5.60818,-0.04103>,<0.31266,5.64222,-0.03573>,<0.2831,5.63598,-0.0559>,
            
    /*2*/ <0.68525,5.57049,-0.59232>,<0.69293,5.59318,-0.58879>,<0.67322,5.58902,-0.60224>,
            
    /*3*/ <1.25298,5.84111,-0.8453>,<1.25068,5.85153,-0.83957>,<1.24653,5.84975,-0.85081>,
            
    /*4*/ <1.88515,6.06083,-0.90829>

    /* stem 0.15.2*/ 
    /*0*/ <0.39474,5.63629,-0.06105>,
    /*1*/ <0.39519,5.65396,-0.0506>,<0.40541,5.6344,-0.07849>,<0.38361,5.62051,-0.05407>,
            
    /*2*/ <0.91726,5.43171,0.28899>,<0.92407,5.41867,0.27039>,<0.90953,5.40941,0.28668>,
            
    /*3*/ <1.42949,5.51608,0.68862>,<1.4362,5.50928,0.6816>,<1.43007,5.50439,0.69049>,
            
    /*4*/ <1.94056,5.82774,0.96529>

    /* stem 0.15.3*/ 
    /*0*/ <0.4983,5.6444,-0.07926>,
    /*1*/ <0.49554,5.63767,-0.09796>,<0.51453,5.6388,-0.06888>,<0.48483,5.65672,-0.07094>,
            
    /*2*/ <0.82105,6.15127,-0.32368>,<0.83371,6.15202,-0.30429>,<0.8139,6.16397,-0.30567>,
            
    /*3*/ <1.36205,6.47579,-0.47724>,<1.36613,6.47428,-0.46651>,<1.35979,6.48365,-0.46903>,
            
    /*4*/ <1.87971,6.83813,-0.62437>

    /* stem 0.15.4*/ 
    /*0*/ <0.55348,5.64872,-0.08896>,
    /*1*/ <0.55722,5.64185,-0.07075>,<0.56357,5.66427,-0.09595>,<0.53965,5.64003,-0.10018>,
            
    /*2*/ <1,5.24802,-0.3174>,<1.00424,5.26297,-0.33419>,<0.98829,5.24681,-0.33701>,
            
    /*3*/ <1.48198,4.90619,-0.56886>,<1.48358,4.91417,-0.5769>,<1.4764,4.90547,-0.57882>,
            
    /*4*/ <2.08607,4.73204,-0.69418>

    /* stem 0.15.5*/ 
    /*0*/ <0.66066,5.65711,-0.1078>,
    /*1*/ <0.65773,5.67386,-0.117>,<0.67007,5.64274,-0.11666>,<0.65417,5.65473,-0.08974>,
            
    /*2*/ <1.20376,5.88688,0.11063>,<1.21199,5.86613,0.11086>,<1.20139,5.87413,0.1288>,
            
    /*3*/ <1.74417,6.1772,0.23722>,<1.74948,6.16739,0.23753>,<1.74503,6.17162,0.24685>,
            
    /*4*/ <2.24686,6.53649,0.34949>

    /* stem 0.15.6*/ 
    /*0*/ <0.78214,5.67862,-0.1257>,
    /*1*/ <0.78675,5.66091,-0.12989>,<0.79386,5.68923,-0.11557>,<0.7658,5.68572,-0.13163>,
            
    /*2*/ <1.05623,5.85956,-0.64426>,<1.06097,5.87844,-0.63471>,<1.04226,5.8761,-0.64541>,
            
    /*3*/ <1.35562,6.22896,-1.03807>,<1.35595,6.2368,-1.03059>,<1.3476,6.23623,-1.03748>,
            
    /*4*/ <1.73516,6.65627,-1.26407>

    /* stem 0.15.7*/ 
    /*0*/ <0.92521,5.71982,-0.14221>,
    /*1*/ <0.92373,5.73074,-0.12783>,<0.93492,5.72504,-0.15659>,<0.917,5.70367,-0.1422>,
            
    /*2*/ <1.41083,5.47955,0.10573>,<1.41829,5.47575,0.08655>,<1.40634,5.4615,0.09614>,
            
    /*3*/ <1.98897,5.49598,0.24188>,<1.99148,5.49459,0.23182>,<1.99023,5.48631,0.2381>,
            
    /*4*/ <2.50121,5.79802,0.25472>

    /* stem 0.15.8*/ 
    /*0*/ <1.06975,5.76143,-0.15888>,
    /*1*/ <1.06765,5.76178,-0.17621>,<1.08482,5.7559,-0.15202>,<1.05677,5.76663,-0.14841>,
            
    /*2*/ <1.27308,6.30153,-0.18457>,<1.28453,6.29761,-0.16844>,<1.26583,6.30476,-0.16604>,
            
    /*3*/ <1.67306,6.71143,-0.0922>,<1.67648,6.7064,-0.08417>,<1.66919,6.71327,-0.08308>,
            
    /*4*/ <2.08216,7.10665,0.00857>

    /* stem 0.15.9*/ 
    /*0*/ <1.16414,5.78861,-0.16977>,
    /*1*/ <1.16867,5.77784,-0.15739>,<1.16887,5.80495,-0.16899>,<1.15487,5.78305,-0.18293>,
            
    /*2*/ <1.64176,5.65735,-0.44324>,<1.64189,5.67542,-0.45098>,<1.63256,5.66082,-0.46027>,
            
    /*3*/ <2.20354,5.68612,-0.47544>,<2.20294,5.69513,-0.47934>,<2.203,5.68723,-0.48519>,
            
    /*4*/ <2.68257,5.98719,-0.44055>

    /* stem 0.15.10*/ 
    /*0*/ <1.31491,5.83203,-0.18717>,
    /*1*/ <1.3102,5.84756,-0.18915>,<1.32716,5.82599,-0.19615>,<1.30736,5.82254,-0.1762>,
            
    /*2*/ <1.66961,5.99955,0.19385>,<1.68091,5.98517,0.18919>,<1.66771,5.98287,0.20249>,
            
    /*3*/ <2.07559,6.25443,0.45274>,<2.08153,6.24747,0.45043>,<2.07666,6.24704,0.4585>,
            
    /*4*/ <2.46725,6.57548,0.65685>

    /* stem 0.15.11*/ 
    /*0*/ <1.4486,5.87838,-0.20194>,
    /*1*/ <1.45317,5.8661,-0.21067>,<1.45681,5.88243,-0.18915>,<1.43581,5.88659,-0.20602>,
            
    /*2*/ <1.75213,6.19169,-0.5025>,<1.75455,6.20258,-0.48815>,<1.74055,6.20535,-0.4994>,
            
    /*3*/ <1.99849,6.59486,-0.74633>,<1.99892,6.59944,-0.73849>,<1.99176,6.60049,-0.74398>,
            
    /*4*/ <2.27788,7.0283,-0.87082>

    /* stem 0.15.12*/ 
    /*0*/ <1.5783,5.93616,-0.21522>,
    /*1*/ <1.57782,5.94056,-0.20075>,<1.58209,5.94606,-0.22601>,<1.57499,5.92186,-0.21889>,
            
    /*2*/ <2.07107,5.8107,-0.15021>,<2.07392,5.81437,-0.16705>,<2.06918,5.79824,-0.1623>,
            
    /*3*/ <2.5737,5.7851,-0.06044>,<2.57536,5.78684,-0.06884>,<2.57446,5.77856,-0.06619>,
            
    /*4*/ <3.05361,5.90754,0.06811>

    /* stem 0.15.13*/ 
    /*0*/ <1.67339,5.97852,-0.22495>,
    /*1*/ <1.66983,5.98343,-0.23832>,<1.68561,5.9706,-0.22305>,<1.66473,5.98153,-0.21348>,
            
    /*2*/ <1.92958,6.40115,-0.14865>,<1.9401,6.3926,-0.13846>,<1.92618,6.39989,-0.13209>,
            
    /*3*/ <2.19819,6.81904,-0.0979>,<2.20364,6.815,-0.09281>,<2.19689,6.81894,-0.08952>,
            
    /*4*/ <2.54244,7.18013,-0.06111>

    /* stem 0.15.14*/ 
    /*0*/ <1.75262,6.01382,-0.23306>,
    /*1*/ <1.75839,6.00232,-0.22677>,<1.75663,6.02695,-0.22902>,<1.74284,6.01218,-0.24339>,
            
    /*2*/ <2.11231,6.00081,-0.56499>,<2.11114,6.01724,-0.56649>,<2.10195,6.00739,-0.57607>,
            
    /*3*/ <2.49009,6.1596,-0.836>,<2.48745,6.1674,-0.83523>,<2.48486,6.16276,-0.84156>,
            
    /*4*/ <2.78708,6.50087,-1.02701>

    /* stem 0.15.15*/ 
    /*0*/ <1.87711,6.06928,-0.2458>,
    /*1*/ <1.87196,6.08159,-0.24253>,<1.88683,6.06824,-0.25546>,<1.87254,6.058,-0.23942>,
            
    /*2*/ <2.20776,6.12934,0.08732>,<2.21768,6.12044,0.07871>,<2.20815,6.11361,0.0894>,
            
    /*3*/ <2.58968,6.3501,0.25298>,<2.59433,6.34575,0.24824>,<2.59263,6.34319,0.25555>,
            
    /*4*/ <2.94671,6.65195,0.18326>

    /* stem 0.15.16*/ 
    /*0*/ <1.99995,6.124,-0.25837>,
    /*1*/ <2.00221,6.1165,-0.26897>,<2.00884,6.12455,-0.24867>,<1.98879,6.13096,-0.25749>,
            
    /*2*/ <2.2052,6.4719,-0.47208>,<2.20963,6.47727,-0.45854>,<2.19626,6.48154,-0.46443>,
            
    /*3*/ <2.52576,6.71486,-0.68506>,<2.52826,6.71753,-0.67839>,<2.52286,6.72129,-0.68221>,
            
    /*4*/ <2.88662,6.97234,-0.7989>

    /* stem 0.15.17*/ 
    /*0*/ <2.08804,6.17342,-0.26732>,
    /*1*/ <2.0895,6.17314,-0.25465>,<2.09085,6.18402,-0.27384>,<2.08378,6.16309,-0.27348>,
            
    /*2*/ <2.50724,6.03111,-0.31019>,<2.50814,6.03837,-0.32298>,<2.50342,6.02441,-0.32275>,
            
    /*3*/ <2.94307,6.07519,-0.38964>,<2.94163,6.07904,-0.39576>,<2.94231,6.07171,-0.39609>,
            
    /*4*/ <3.26584,6.38004,-0.37851>

    /* stem 0.15.18*/ 
    /*0*/ <2.23987,6.27352,-0.28265>,
    /*1*/ <2.23463,6.28017,-0.29116>,<2.25137,6.27025,-0.28382>,<2.23362,6.27013,-0.27298>,
            
    /*2*/ <2.35664,6.62996,-0.08739>,<2.3678,6.62335,-0.08249>,<2.35596,6.62326,-0.07526>,
            
    /*3*/ <2.56168,6.9857,0.01003>,<2.56713,6.98202,0.01223>,<2.56208,6.98372,0.01667>,
            
    /*4*/ <2.72315,7.37516,0.00102>

    /* stem 0.15.19*/ 
    /*0*/ <2.3485,6.34513,-0.29362>,
    /*1*/ <2.35487,6.33564,-0.29255>,<2.35068,6.35427,-0.28703>,<2.33996,6.34548,-0.30127>,
            
    /*2*/ <2.61065,6.48012,-0.57444>,<2.60786,6.49254,-0.57076>,<2.60071,6.48668,-0.58025>,
            
    /*3*/ <2.86738,6.72121,-0.7814>,<2.86475,6.72656,-0.77853>,<2.86226,6.72431,-0.78424>,
            
    /*4*/ <3.1274,7.01652,-0.88738>

    /* stem 0.15.20*/ 
    /*0*/ <2.46839,6.42417,-0.30572>,
    /*1*/ <2.46409,6.4316,-0.29982>,<2.47252,6.4266,-0.31498>,<2.46857,6.41431,-0.30238>,
            
    /*2*/ <2.81018,6.49323,-0.13129>,<2.81579,6.4899,-0.14139>,<2.81316,6.4817,-0.13299>,
            
    /*3*/ <3.13026,6.65644,0.01666>,<3.13336,6.65491,0.01175>,<3.13311,6.65115,0.01644>,
            
    /*4*/ <3.35778,6.92957,0.17385>

    /* stem 0.15.21*/ 
    /*0*/ <2.5423,6.47289,-0.31319>,
    /*1*/ <2.54303,6.4704,-0.3222>,<2.54969,6.47203,-0.30746>,<2.53418,6.47625,-0.30989>,
            
    /*2*/ <2.65238,6.82328,-0.4076>,<2.65682,6.82437,-0.39777>,<2.64648,6.82718,-0.39939>,
            
    /*3*/ <2.84089,7.14541,-0.47474>,<2.84285,7.14537,-0.46969>,<2.83817,7.14788,-0.47076>,
            
    /*4*/ <3.12254,7.39408,-0.52521>

    /* stem 0.15.22*/ 
    /*0*/ <2.67811,6.57923,-0.32824>,
    /*1*/ <2.68077,6.5774,-0.32162>,<2.67759,6.58632,-0.33016>,<2.67598,6.57398,-0.33294>,
            
    /*2*/ <3.0109,6.56557,-0.46038>,<3.00878,6.57152,-0.46607>,<3.0077,6.56329,-0.46792>,
            
    /*3*/ <3.32571,6.73215,-0.43642>,<3.32443,6.73505,-0.43925>,<3.32639,6.73152,-0.44057>,
            
    /*4*/ <3.62266,6.92143,-0.37144>

    /* stem 0.15.23*/ 
    /*0*/ <2.77112,6.67139,-0.34009>,
    /*1*/ <2.76723,6.67501,-0.3425>,<2.77636,6.67067,-0.34257>,<2.76978,6.66848,-0.33521>,
            
    /*2*/ <2.8927,6.93204,-0.15407>,<2.89879,6.92915,-0.15411>,<2.8944,6.9277,-0.14921>,
            
    /*3*/ <3.02416,7.2207,-0.02602>,<3.02724,7.21933,-0.02604>,<3.02527,7.21902,-0.02332>,
            
    /*4*/ <3.16411,7.51494,0.07947>

    /* stem 0.15.24*/ 
    /*0*/ <2.81501,6.71487,-0.34569>,
    /*1*/ <2.81839,6.71128,-0.34705>,<2.81615,6.71817,-0.34194>,<2.81049,6.71517,-0.34807>,
            
    /*2*/ <2.94951,6.9227,-0.57152>,<2.94801,6.92729,-0.56811>,<2.94424,6.92529,-0.5722>,
            
    /*3*/ <3.10732,7.1842,-0.7103>,<3.10622,7.18598,-0.70822>,<3.10473,7.18555,-0.71074>,
            
    /*4*/ <3.34462,7.38792,-0.82932>

    /* stem 0.15.25*/ 
    /*0*/ <2.93001,6.82882,-0.36034>,
    /*1*/ <2.92889,6.83028,-0.35769>,<2.93075,6.83056,-0.36296>,<2.93039,6.82561,-0.36038>,
            
    /*2*/ <3.22471,6.86348,-0.25295>,<3.22595,6.86366,-0.25647>,<3.22571,6.86037,-0.25474>,
            
    /*3*/ <3.52545,6.91728,-0.17358>,<3.52592,6.91733,-0.17539>,<3.52596,6.91572,-0.17446>,
            
    /*4*/ <3.78443,7.09754,-0.17298>

    /* stem 0.15.26*/ 
    /*0*/ <3.02239,6.92035,-0.37212>,
    /*1*/ <3.02216,6.92036,-0.37381>,<3.02396,6.92048,-0.37146>,<3.02104,6.92021,-0.37107>,
            
    /*2*/ <2.99498,7.21896,-0.36797>,<2.99618,7.21904,-0.3664>,<2.99423,7.21886,-0.36614>,
            
    /*3*/ <3.05255,7.51242,-0.34418>,<3.05313,7.51225,-0.3434>,<3.05217,7.51243,-0.34327>,
            
    /*4*/ <3.12314,7.80382,-0.34768>

    /* stem 0.15.27*/ 
    /*0*/ <3.09097,6.98831,-0.38086>,
    /*1*/ <3.09129,6.98804,-0.38045>,<3.09097,6.98889,-0.38088>,<3.09066,6.98799,-0.38124>,
            
    /*2*/ <3.31582,6.98169,-0.56111>,<3.31561,6.98226,-0.5614>,<3.3154,6.98166,-0.56164>,
            
    /*3*/ <3.52198,7.05637,-0.74834>,<3.5218,7.05665,-0.74843>,<3.52175,7.05636,-0.7486>,
            
    /*4*/ <3.73666,7.2171,-0.85402>

    /* stem 0.16*/ 
    /*0*/ <0.03633,5.79129,0.00305>,
    /*1*/ <0.00364,5.7921,-0.02439>,<0.03062,5.8317,-0.00948>,<0.06549,5.81545,0.02275>,
            <0.06006,5.76582,0.02775>,<0.02183,5.75138,-0.00138>,
    /*2*/ <-0.45255,5.89849,0.53557>,<-0.43097,5.93017,0.5475>,<-0.40307,5.91717,0.57327>,
            <-0.40742,5.87746,0.57728>,<-0.438,5.86592,0.55397>,
    /*3*/ <-0.9481,6.15349,1.00027>,<-0.93013,6.17669,1.00703>,<-0.91289,6.16861,1.03035>,
            <-0.9202,6.14043,1.03801>,<-0.94196,6.13108,1.01942>,
    /*4*/ <-1.32601,6.58599,1.45528>,<-1.31049,6.59868,1.45633>,<-1.29888,6.59303,1.47169>,
            <-1.30723,6.57685,1.48015>,<-1.324,6.5725,1.47>,
    /*5*/ <-1.58832,7.1247,1.87475>,<-1.57958,7.12959,1.87405>,<-1.57376,7.12664,1.88168>,
            <-1.5789,7.11993,1.88709>,<-1.5879,7.11873,1.88281>,
    /*6*/ <-1.75435,7.74494,2.22276>

    /* stem 0.16.0*/ 
    /*0*/ <-0.06609,5.81487,0.12578>,
    /*1*/ <-0.0514,5.82878,0.13537>,<-0.07555,5.79854,0.13783>,<-0.07133,5.8173,0.10415>,
            
    /*2*/ <-0.5869,6.26221,0.30976>,<-0.603,6.24205,0.31139>,<-0.60019,6.25455,0.28894>,
            
    /*3*/ <-1.04403,6.63354,0.70344>,<-1.05169,6.62319,0.70451>,<-1.05337,6.63149,0.69474>,
            
    /*4*/ <-1.38382,6.94228,1.24444>

    /* stem 0.16.1*/ 
    /*0*/ <-0.14395,5.8328,0.21907>,
    /*1*/ <-0.14918,5.81161,0.21878>,<-0.15968,5.84791,0.2201>,<-0.12299,5.83889,0.21834>,
            
    /*2*/ <-0.11811,5.80185,0.91393>,<-0.1251,5.82606,0.91481>,<-0.10065,5.82004,0.91363>,
            
    /*3*/ <-0.26664,5.88346,1.58987>,<-0.26977,5.89551,1.58784>,<-0.2579,5.89249,1.59082>,
            
    /*4*/ <-0.60622,6.17776,2.12348>

    /* stem 0.16.2*/ 
    /*0*/ <-0.18807,5.84296,0.27193>,
    /*1*/ <-0.19429,5.8616,0.26316>,<-0.18695,5.84098,0.29333>,<-0.18296,5.8263,0.25931>,
            
    /*2*/ <-0.84622,5.64385,0.28058>,<-0.84133,5.6301,0.30069>,<-0.83867,5.62031,0.27801>,
            
    /*3*/ <-1.51418,5.69569,0.41636>,<-1.51271,5.68898,0.42671>,<-1.51532,5.68332,0.41596>,
            
    /*4*/ <-2.05481,6.09952,0.52935>

    /* stem 0.16.3*/ 
    /*0*/ <-0.25363,5.85806,0.3505>,
    /*1*/ <-0.23926,5.85056,0.36394>,<-0.27371,5.85192,0.35206>,<-0.24793,5.8717,0.33551>,
            
    /*2*/ <-0.36859,6.36679,0.77939>,<-0.39156,6.36769,0.77147>,<-0.37437,6.38088,0.76044>,
            
    /*3*/ <-0.45392,6.97201,1.07012>,<-0.46536,6.97249,1.06603>,<-0.45629,6.977,1.05929>,
            
    /*4*/ <-0.63222,7.52266,1.41784>

    /* stem 0.16.4*/ 
    /*0*/ <-0.32767,5.87511,0.43922>,
    /*1*/ <-0.34321,5.86853,0.42752>,<-0.32937,5.89277,0.44955>,<-0.31045,5.86402,0.44059>,
            
    /*2*/ <-0.58927,5.54434,0.94852>,<-0.58004,5.5605,0.96321>,<-0.56743,5.54134,0.95724>,
            
    /*3*/ <-0.68648,5.49026,1.60602>,<-0.68025,5.50018,1.60783>,<-0.67478,5.48966,1.60779>,
            
    /*4*/ <-0.68878,5.70252,2.23429>

    /* stem 0.16.5*/ 
    /*0*/ <-0.38935,5.88931,0.51313>,
    /*1*/ <-0.37977,5.90634,0.51785>,<-0.39689,5.87766,0.52766>,<-0.39139,5.88394,0.49387>,
            
    /*2*/ <-0.94457,6.22529,0.48519>,<-0.95598,6.20617,0.49173>,<-0.95231,6.21036,0.4692>,
            
    /*3*/ <-1.39561,6.62788,0.71165>,<-1.40178,6.61888,0.71561>,<-1.4036,6.62289,0.70487>,
            
    /*4*/ <-1.70597,7.13717,0.96405>

    /* stem 0.16.6*/ 
    /*0*/ <-0.47363,5.92184,0.60074>,
    /*1*/ <-0.47599,5.90391,0.60812>,<-0.48913,5.93197,0.59454>,<-0.45576,5.92964,0.59956>,
            
    /*2*/ <-0.54499,6.1575,1.18533>,<-0.55376,6.17621,1.17629>,<-0.5315,6.17465,1.17963>,
            
    /*3*/ <-0.69698,6.46784,1.71859>,<-0.70104,6.47645,1.71254>,<-0.69021,6.47638,1.71567>,
            
    /*4*/ <-0.87913,6.97905,2.05202>

    /* stem 0.16.7*/ 
    /*0*/ <-0.54174,5.95645,0.66308>,
    /*1*/ <-0.54872,5.96761,0.64925>,<-0.54005,5.9632,0.68086>,<-0.53645,5.93853,0.65912>,
            
    /*2*/ <-1.12168,5.76524,0.78393>,<-1.1159,5.76229,0.805>,<-1.1135,5.74585,0.79051>,
            
    /*3*/ <-1.61809,6.01645,1.05662>,<-1.61334,6.01533,1.06651>,<-1.61965,6.00723,1.06247>,
            
    /*4*/ <-2.07517,6.31059,1.36>

    /* stem 0.16.8*/ 
    /*0*/ <-0.64441,6.00862,0.75704>,
    /*1*/ <-0.63185,6.00903,0.77054>,<-0.6607,6.00043,0.75985>,<-0.64069,6.01639,0.74074>,
            
    /*2*/ <-0.86518,6.53233,0.96342>,<-0.88441,6.5266,0.95629>,<-0.87107,6.53724,0.94355>,
            
    /*3*/ <-1.14773,7.0266,1.1683>,<-1.15698,7.02306,1.16439>,<-1.15065,7.02916,1.15838>,
            
    /*4*/ <-1.54264,7.40319,1.42944>

    /* stem 0.16.9*/ 
    /*0*/ <-0.70844,6.04115,0.81564>,
    /*1*/ <-0.72066,6.02999,0.80848>,<-0.71246,6.05856,0.81809>,<-0.69219,6.0349,0.82035>,
            
    /*2*/ <-0.92162,5.90985,1.35378>,<-0.91615,5.9289,1.36019>,<-0.90263,5.91313,1.36169>,
            
    /*3*/ <-1.17398,6.05777,1.87291>,<-1.16949,6.06716,1.87252>,<-1.16459,6.05923,1.87716>,
            
    /*4*/ <-1.46048,6.36695,2.29134>

    /* stem 0.16.10*/ 
    /*0*/ <-0.7884,6.08178,0.88883>,
    /*1*/ <-0.78214,6.09801,0.88666>,<-0.79158,6.07569,0.90495>,<-0.79149,6.07164,0.87486>,
            
    /*2*/ <-1.32545,6.29767,0.85812>,<-1.33175,6.28279,0.87031>,<-1.33169,6.28009,0.85025>,
            
    /*3*/ <-1.76556,6.65457,0.96258>,<-1.76956,6.64789,0.96904>,<-1.77211,6.64761,0.95925>,
            
    /*4*/ <-2.1398,7.04452,1.17044>

    /* stem 0.16.11*/ 
    /*0*/ <-0.9051,6.14108,0.99563>,
    /*1*/ <-0.90292,6.12765,1.00548>,<-0.92055,6.14713,0.993>,<-0.89185,6.14845,0.98842>,
            
    /*2*/ <-0.84826,6.46699,1.44666>,<-0.86001,6.47998,1.43833>,<-0.84088,6.48087,1.43529>,
            
    /*3*/ <-0.92943,6.80234,1.88719>,<-0.93524,6.80802,1.8819>,<-0.92572,6.80983,1.88228>,
            
    /*4*/ <-1.06008,7.21052,2.24823>

    /* stem 0.16.12*/ 
    /*0*/ <-0.96258,6.19005,1.05636>,
    /*1*/ <-0.97168,6.19509,1.04372>,<-0.95807,6.20069,1.06796>,<-0.95799,6.17436,1.05741>,
            
    /*2*/ <-1.42369,6.07887,1.33002>,<-1.41461,6.08261,1.34618>,<-1.41455,6.06506,1.33915>,
            
    /*3*/ <-1.9121,6.21834,1.52518>,<-1.90827,6.22026,1.53361>,<-1.91149,6.21156,1.53175>,
            
    /*4*/ <-2.32518,6.52172,1.71688>

    /* stem 0.16.13*/ 
    /*0*/ <-1.02992,6.26595,1.13514>,
    /*1*/ <-1.01662,6.2698,1.1428>,<-1.04333,6.2637,1.14323>,<-1.02981,6.26436,1.1194>,
            
    /*2*/ <-1.13988,6.78443,1.0871>,<-1.15769,6.78036,1.08738>,<-1.14867,6.7808,1.0715>,
            
    /*3*/ <-1.26181,7.2867,0.95752>,<-1.27071,7.28463,0.95756>,<-1.26587,7.28382,0.94985>,
            
    /*4*/ <-1.49883,7.75826,1.02589>

    /* stem 0.16.14*/ 
    /*0*/ <-1.12956,6.37827,1.25171>,
    /*1*/ <-1.14054,6.36805,1.25217>,<-1.13292,6.39286,1.25068>,<-1.11521,6.3739,1.25228>,
            
    /*2*/ <-1.14689,6.40503,1.76008>,<-1.14181,6.42157,1.75909>,<-1.13,6.40893,1.76015>,
            
    /*3*/ <-1.17334,6.61892,2.22384>,<-1.17059,6.62646,2.22059>,<-1.16486,6.62069,2.22359>,
            
    /*4*/ <-1.17495,6.91612,2.63841>

    /* stem 0.16.15*/ 
    /*0*/ <-1.18982,6.44619,1.3222>,
    /*1*/ <-1.18574,6.45781,1.31449>,<-1.18964,6.44668,1.33672>,<-1.19407,6.43408,1.3154>,
            
    /*2*/ <-1.65462,6.61802,1.31719>,<-1.65722,6.6106,1.33201>,<-1.66017,6.6022,1.31779>,
            
    /*3*/ <-1.97297,6.9547,1.48744>,<-1.97334,6.95073,1.49481>,<-1.97872,6.94873,1.4887>,
            
    /*4*/ <-2.20108,7.34191,1.69496>

    /* stem 0.16.16*/ 
    /*0*/ <-1.29302,6.56252,1.44294>,
    /*1*/ <-1.28888,6.55507,1.45366>,<-1.3059,6.56714,1.44237>,<-1.28427,6.56537,1.43279>,
            
    /*2*/ <-1.15901,6.95179,1.67367>,<-1.17036,6.95984,1.66614>,<-1.15594,6.95866,1.65976>,
            
    /*3*/ <-1.12199,7.3647,1.90033>,<-1.12784,7.36771,1.89594>,<-1.12034,7.36837,1.89351>,
            
    /*4*/ <-1.22329,7.80064,2.05329>

    /* stem 0.16.17*/ 
    /*0*/ <-1.33413,6.62716,1.49874>,
    /*1*/ <-1.34445,6.62838,1.49045>,<-1.32773,6.638,1.50303>,<-1.3302,6.6151,1.50274>,
            
    /*2*/ <-1.62695,6.65446,1.85309>,<-1.6158,6.66088,1.86148>,<-1.61745,6.64561,1.86129>,
            
    /*3*/ <-1.91673,6.86304,2.14171>,<-1.91082,6.86613,2.14552>,<-1.91361,6.8593,2.14765>,
            
    /*4*/ <-2.1378,7.19673,2.36919>

    /* stem 0.16.18*/ 
    /*0*/ <-1.38973,6.73874,1.58439>,
    /*1*/ <-1.37803,6.7433,1.58606>,<-1.39764,6.73782,1.59426>,<-1.39354,6.73509,1.57286>,
            
    /*2*/ <-1.5297,7.15077,1.50498>,<-1.54278,7.14712,1.51044>,<-1.54004,7.1453,1.49618>,
            
    /*3*/ <-1.72155,7.54876,1.47364>,<-1.72776,7.54605,1.47642>,<-1.72666,7.54601,1.46918>,
            
    /*4*/ <-1.88177,7.96043,1.46114>

    /* stem 0.16.19*/ 
    /*0*/ <-1.42899,6.8175,1.64485>,
    /*1*/ <-1.4368,6.80964,1.65002>,<-1.43258,6.82892,1.64232>,<-1.41758,6.81395,1.64222>,
            
    /*2*/ <-1.30485,6.9395,2.03753>,<-1.30203,6.95235,2.0324>,<-1.29203,6.94237,2.03233>,
            
    /*3*/ <-1.20487,7.23181,2.33913>,<-1.20408,7.23675,2.33415>,<-1.19855,7.23282,2.33613>,
            
    /*4*/ <-1.22932,7.60499,2.55076>

    /* stem 0.16.20*/ 
    /*0*/ <-1.47565,6.91114,1.71674>,
    /*1*/ <-1.47501,6.91846,1.70761>,<-1.47103,6.91421,1.72705>,<-1.48092,6.90074,1.71554>,
            
    /*2*/ <-1.83624,7.08609,1.82161>,<-1.8336,7.08326,1.83457>,<-1.84019,7.07428,1.8269>,
            
    /*3*/ <-2.0864,7.35842,2.00764>,<-2.08415,7.35643,2.0137>,<-2.08952,7.35339,2.01092>,
            
    /*4*/ <-2.24403,7.6987,2.18231>

    /* stem 0.16.21*/ 
    /*0*/ <-1.5219,7.00394,1.78798>,
    /*1*/ <-1.51611,7.00066,1.79602>,<-1.53151,7.00767,1.78964>,<-1.51808,7.00351,1.77827>,
            
    /*2*/ <-1.36814,7.36921,1.83572>,<-1.3784,7.37389,1.83147>,<-1.36945,7.37111,1.82389>,
            
    /*3*/ <-1.27824,7.74559,1.93286>,<-1.28353,7.74746,1.93067>,<-1.27869,7.74723,1.92708>,
            
    /*4*/ <-1.24366,8.13307,2.02363>

    /* stem 0.16.22*/ 
    /*0*/ <-1.56303,7.08647,1.85133>,
    /*1*/ <-1.57129,7.08517,1.84766>,<-1.5596,7.09491,1.85198>,<-1.5582,7.07934,1.85434>,
            
    /*2*/ <-1.72929,7.12378,2.1974>,<-1.72149,7.13027,2.20028>,<-1.72056,7.11989,2.20185>,
            
    /*3*/ <-1.76439,7.33227,2.52235>,<-1.75975,7.33459,2.5214>,<-1.75994,7.33015,2.52423>,
            
    /*4*/ <-1.9158,7.61476,2.73513>

    /* stem 0.16.23*/ 
    /*0*/ <-1.59254,7.16292,1.9016>,
    /*1*/ <-1.58543,7.166,1.8996>,<-1.59508,7.16331,1.90917>,<-1.59711,7.15946,1.89602>,
            
    /*2*/ <-1.75037,7.49429,1.82903>,<-1.75681,7.49249,1.83541>,<-1.75816,7.48992,1.82664>,
            
    /*3*/ <-1.84896,7.85427,1.83943>,<-1.85211,7.85334,1.84268>,<-1.85328,7.85315,1.83821>,
            
    /*4*/ <-1.9625,8.18943,1.96188>

    /* stem 0.16.24*/ 
    /*0*/ <-1.62006,7.26194,1.95624>,
    /*1*/ <-1.62291,7.25846,1.96112>,<-1.62294,7.2675,1.95401>,<-1.61434,7.25987,1.95357>,
            
    /*2*/ <-1.43905,7.45173,2.20307>,<-1.43907,7.45776,2.19834>,<-1.43334,7.45267,2.19804>,
            
    /*3*/ <-1.29975,7.6894,2.43526>,<-1.29996,7.69215,2.4326>,<-1.2968,7.69001,2.43289>,
            
    /*4*/ <-1.23709,7.99257,2.61974>

    /* stem 0.16.25*/ 
    /*0*/ <-1.64946,7.36769,2.01459>,
    /*1*/ <-1.65067,7.36987,2.01004>,<-1.64695,7.37045,2.0182>,<-1.65077,7.36276,2.01553>,
            
    /*2*/ <-1.95225,7.47411,2.14179>,<-1.94977,7.4745,2.14723>,<-1.95232,7.46938,2.14546>,
            
    /*3*/ <-2.11539,7.71941,2.32207>,<-2.11343,7.71909,2.3243>,<-2.11593,7.71746,2.32427>,
            
    /*4*/ <-2.17325,8.05283,2.38757>

    /* stem 0.16.26*/ 
    /*0*/ <-1.68149,7.4829,2.07816>,
    /*1*/ <-1.67867,7.48247,2.08035>,<-1.68476,7.48355,2.07954>,<-1.68106,7.48267,2.07459>,
            
    /*2*/ <-1.62059,7.80596,2.06612>,<-1.62465,7.80668,2.06558>,<-1.62218,7.80609,2.06228>,
            
    /*3*/ <-1.70947,8.12282,2.04396>,<-1.71145,8.12225,2.04364>,<-1.71016,8.1225,2.04202>,
            
    /*4*/ <-1.74364,8.4248,2.16866>

    /* stem 0.16.27*/ 
    /*0*/ <-1.71807,7.61445,2.15076>,
    /*1*/ <-1.71981,7.61403,2.15066>,<-1.71754,7.61614,2.15046>,<-1.71686,7.61319,2.15115>,
            
    /*2*/ <-1.75203,7.67741,2.45281>,<-1.75052,7.67882,2.45268>,<-1.75006,7.67686,2.45314>,
            
    /*3*/ <-1.84453,7.87552,2.67298>,<-1.84374,7.87614,2.67276>,<-1.84363,7.8754,2.67347>,
            
    /*4*/ <-2.00403,8.13641,2.72557>

    /* stem 0.16.28*/ 
    /*0*/ <-1.74387,7.70727,2.20197>,
    /*1*/ <-1.74351,7.70752,2.2017>,<-1.74389,7.70731,2.20249>,<-1.74422,7.70697,2.20173>,
            
    /*2*/ <-1.92486,7.9417,2.17586>,<-1.92511,7.94157,2.17639>,<-1.92533,7.94134,2.17588>,
            
    /*3*/ <-2.06443,8.20297,2.20124>,<-2.06455,8.20288,2.20151>,<-2.0647,8.20283,2.20125>,
            
    /*4*/ <-2.18869,8.46223,2.27703>

    /* stem 0.17*/ 
    /*0*/ <0.03954,5.93011,0.00332>,
    /*1*/ <0.08352,5.92909,0.00332>,<0.05409,5.97108,0.01001>,<0.00456,5.95645,0.00746>,
            <0.00337,5.90541,-0.00081>,<0.05218,5.88851,-0.00337>,
    /*2*/ <0.07748,6.04894,-0.73557>,<0.05394,6.08253,-0.73021>,<0.01431,6.07083,-0.73226>,
            <0.01336,6.03,-0.73887>,<0.05241,6.01647,-0.74092>,
    /*3*/ <0.11472,6.15652,-1.47335>,<0.09721,6.182,-1.47073>,<0.0675,6.17358,-1.47381>,
            <0.06665,6.1429,-1.47833>,<0.09583,6.13235,-1.47805>,
    /*4*/ <0.20593,6.47413,-2.14306>,<0.19393,6.48998,-2.13734>,<0.17442,6.48538,-2.14243>,
            <0.17436,6.46669,-2.1513>,<0.19384,6.45974,-2.15169>,
    /*5*/ <0.2702,6.92225,-2.73999>,<0.26396,6.92919,-2.73553>,<0.25425,6.92703,-2.73835>,
            <0.25448,6.91875,-2.74454>,<0.26434,6.91579,-2.74555>,
    /*6*/ <0.31435,7.5036,-3.20975>

    /* stem 0.17.0*/ 
    /*0*/ <0.04007,5.95285,-0.1371>,
    /*1*/ <0.02266,5.96796,-0.13472>,<0.03824,5.93535,-0.1522>,<0.0593,5.95522,-0.12438>,
            
    /*2*/ <0.32169,6.383,-0.65759>,<0.33209,6.36126,-0.66924>,<0.34612,6.37451,-0.6507>,
            
    /*3*/ <0.30256,6.9333,-1.12833>,<0.3078,6.92547,-1.13784>,<0.31584,6.93259,-1.12986>,
            
    /*4*/ <0.18759,7.52827,-1.53569>

    /* stem 0.17.1*/ 
    /*0*/ <0.04044,5.9691,-0.23749>,
    /*1*/ <0.04387,5.94693,-0.24106>,<0.05407,5.98443,-0.24726>,<0.02339,5.97595,-0.22414>,
            
    /*2*/ <-0.39427,5.97875,-0.81061>,<-0.38748,6.00375,-0.81474>,<-0.40793,5.99809,-0.79933>,
            
    /*3*/ <-0.75497,6.09999,-1.4227>,<-0.75039,6.11228,-1.4231>,<-0.76169,6.10968,-1.41696>,
            
    /*4*/ <-1.06671,6.43914,-1.97812>

    /* stem 0.17.2*/ 
    /*0*/ <0.04093,5.99012,-0.3673>,
    /*1*/ <0.05242,6.00877,-0.36424>,<0.02233,5.99043,-0.37927>,<0.04803,5.97116,-0.3584>,
            
    /*2*/ <0.42072,5.86872,-0.94704>,<0.40066,5.85649,-0.95706>,<0.4178,5.84364,-0.94314>,
            
    /*3*/ <0.75496,6.09096,-1.51736>,<0.74621,6.08537,-1.52479>,<0.75662,6.0789,-1.5212>,
            
    /*4*/ <1.106,6.50441,-1.96171>

    /* stem 0.17.3*/ 
    /*0*/ <0.04124,6.00388,-0.45224>,
    /*1*/ <0.02066,5.99701,-0.45343>,<0.05633,5.99529,-0.46532>,<0.04674,6.01932,-0.43798>,
            
    /*2*/ <-0.10725,6.4858,-0.928>,<-0.08347,6.48465,-0.93593>,<-0.08986,6.50067,-0.9177>,
            
    /*3*/ <-0.10662,6.95677,-1.43985>,<-0.0944,6.95475,-1.44184>,<-0.09805,6.96358,-1.43372>,
            
    /*4*/ <-0.1508,7.47188,-1.90121>

    /* stem 0.17.4*/ 
    /*0*/ <0.04164,6.02113,-0.55882>,
    /*1*/ <0.06143,6.0135,-0.55998>,<0.03699,6.03996,-0.56749>,<0.0265,6.00994,-0.54898>,
            
    /*2*/ <-0.09845,5.7079,-1.14627>,<-0.11475,5.72554,-1.15128>,<-0.12174,5.70553,-1.13894>,
            
    /*3*/ <-0.34862,5.85036,-1.76813>,<-0.35462,5.86004,-1.76359>,<-0.36007,5.84905,-1.76394>,
            
    /*4*/ <-0.69218,6.23553,-2.21506>

    /* stem 0.17.5*/ 
    /*0*/ <0.04209,6.04065,-0.67937>,
    /*1*/ <0.03215,6.05858,-0.6765>,<0.03461,6.02669,-0.69268>,<0.05951,6.03669,-0.66891>,
            
    /*2*/ <0.39203,6.32848,-1.16703>,<0.39366,6.30721,-1.17782>,<0.41026,6.31388,-1.16198>,
            
    /*3*/ <0.52366,6.60447,-1.75583>,<0.52388,6.59368,-1.76095>,<0.53392,6.59839,-1.7565>,
            
    /*4*/ <0.36494,6.92613,-2.31409>

    /* stem 0.17.6*/ 
    /*0*/ <0.0446,6.05512,-0.77243>,
    /*1*/ <0.04054,6.03551,-0.77554>,<0.05961,6.06412,-0.78267>,<0.03365,6.06575,-0.75908>,
            
    /*2*/ <-0.37876,6.20428,-1.24857>,<-0.36605,6.22335,-1.25332>,<-0.38335,6.22444,-1.23759>,
            
    /*3*/ <-0.63799,6.46391,-1.79298>,<-0.63014,6.47259,-1.7927>,<-0.64041,6.47381,-1.78722>,
            
    /*4*/ <-0.55595,6.87099,-2.3017>

    /* stem 0.17.7*/ 
    /*0*/ <0.05348,6.0759,-0.915>,
    /*1*/ <0.06883,6.08783,-0.9123>,<0.03777,6.0822,-0.92493>,<0.05385,6.05765,-0.90776>,
            
    /*2*/ <0.32246,5.87371,-1.4559>,<0.30175,5.86995,-1.46432>,<0.31247,5.85358,-1.45287>,
            
    /*3*/ <0.46752,5.90989,-2.07382>,<0.45662,5.90843,-2.07657>,<0.46344,5.89944,-2.0755>,
            
    /*4*/ <0.52125,6.19279,-2.64089>

    /* stem 0.17.8*/ 
    /*0*/ <0.06193,6.09564,-1.0505>,
    /*1*/ <0.04295,6.09633,-1.05159>,<0.07197,6.08751,-1.06447>,<0.07087,6.10309,-1.03545>,
            
    /*2*/ <0.08567,6.64232,-1.34321>,<0.10502,6.63644,-1.35179>,<0.10429,6.64683,-1.33245>,
            
    /*3*/ <0.106,7.04025,-1.81809>,<0.11556,7.03596,-1.8214>,<0.11546,7.04439,-1.81435>,
            
    /*4*/ <0.12667,7.40157,-2.32207>

    /* stem 0.17.9*/ 
    /*0*/ <0.06906,6.11231,-1.16493>,
    /*1*/ <0.08289,6.10003,-1.16586>,<0.07099,6.12902,-1.17266>,<0.05331,6.10788,-1.15627>,
            
    /*2*/ <-0.14738,5.8894,-1.68598>,<-0.15531,5.90873,-1.69051>,<-0.1671,5.89463,-1.67959>,
            
    /*3*/ <-0.45785,5.7726,-2.19677>,<-0.46076,5.78286,-2.19745>,<-0.4669,5.77591,-2.19213>,
            
    /*4*/ <-0.68714,5.91717,-2.74089>

    /* stem 0.17.10*/ 
    /*0*/ <0.07609,6.12875,-1.27774>,
    /*1*/ <0.07346,6.14641,-1.27533>,<0.06592,6.11965,-1.2895>,<0.0889,6.1202,-1.2684>,
            
    /*2*/ <0.4659,6.25753,-1.70559>,<0.46087,6.23969,-1.71503>,<0.47619,6.24006,-1.70096>,
            
    /*3*/ <0.6875,6.41657,-2.23061>,<0.68435,6.40757,-2.23477>,<0.69383,6.40832,-2.23054>,
            
    /*4*/ <0.65994,6.81683,-2.66299>

    /* stem 0.17.11*/ 
    /*0*/ <0.0847,6.14887,-1.41581>,
    /*1*/ <0.07561,6.13427,-1.4185>,<0.10017,6.15102,-1.42349>,<0.07833,6.1613,-1.40544>,
            
    /*2*/ <-0.18016,6.38399,-1.87026>,<-0.16379,6.39515,-1.87359>,<-0.17835,6.40201,-1.86155>,
            
    /*3*/ <-0.39111,6.60953,-2.35652>,<-0.38266,6.61481,-2.35784>,<-0.39031,6.61878,-2.35268>,
            
    /*4*/ <-0.29472,6.78536,-2.89779>

    /* stem 0.17.12*/ 
    /*0*/ <0.10025,6.19513,-1.55432>,
    /*1*/ <0.11587,6.19937,-1.54997>,<0.08958,6.20687,-1.55972>,<0.0953,6.17916,-1.55326>,
            
    /*2*/ <0.28013,6.11059,-2.07608>,<0.2626,6.11559,-2.08257>,<0.26641,6.09712,-2.07826>,
            
    /*3*/ <0.41515,6.09317,-2.61775>,<0.40614,6.09573,-2.62017>,<0.40844,6.08637,-2.61929>,
            
    /*4*/ <0.5218,6.32074,-3.11572>

    /* stem 0.17.13*/ 
    /*0*/ <0.12275,6.26655,-1.70498>,
    /*1*/ <0.10784,6.2724,-1.70444>,<0.12794,6.25904,-1.71817>,<0.13248,6.2682,-1.69235>,
            
    /*2*/ <0.28945,6.73879,-1.90195>,<0.30285,6.72988,-1.9111>,<0.30588,6.73599,-1.89389>,
            
    /*3*/ <0.43642,7.21104,-2.1121>,<0.4432,7.2069,-2.11686>,<0.44484,7.21018,-2.10835>,
            
    /*4*/ <0.68256,7.65939,-2.2823>

    /* stem 0.17.14*/ 
    /*0*/ <0.14103,6.32455,-1.82735>,
    /*1*/ <0.14865,6.312,-1.83216>,<0.14707,6.33859,-1.8296>,<0.12737,6.32306,-1.82029>,
            
    /*2*/ <-0.09567,6.34625,-2.2918>,<-0.09672,6.36398,-2.2901>,<-0.10986,6.35362,-2.28388>,
            
    /*3*/ <-0.31224,6.63736,-2.6726>,<-0.31094,6.64474,-2.66778>,<-0.31855,6.64017,-2.66696>,
            
    /*4*/ <-0.42983,7.05749,-2.96066>

    /* stem 0.17.15*/ 
    /*0*/ <0.15356,6.3643,-1.91123>,
    /*1*/ <0.15619,6.37754,-1.90456>,<0.14396,6.36348,-1.92279>,<0.16052,6.35189,-1.90633>,
            
    /*2*/ <0.53926,6.46036,-2.23156>,<0.5311,6.45098,-2.24372>,<0.54214,6.44326,-2.23274>,
            
    /*3*/ <0.86976,6.70507,-2.52901>,<0.86662,6.70097,-2.536>,<0.87321,6.6975,-2.53152>,
            
    /*4*/ <1.05148,7.06283,-2.84319>

    /* stem 0.17.16*/ 
    /*0*/ <0.17539,6.43361,-2.05744>,
    /*1*/ <0.16447,6.42593,-2.06272>,<0.18752,6.43498,-2.06502>,<0.1742,6.43991,-2.0446>,
            
    /*2*/ <-0.01169,6.83161,-2.27556>,<0.00368,6.83765,-2.27709>,<-0.0052,6.84094,-2.26348>,
            
    /*3*/ <-0.13101,7.20054,-2.57622>,<-0.12307,7.20291,-2.57658>,<-0.12807,7.20604,-2.57075>,
            
    /*4*/ <-0.29121,7.52596,-2.90596>

    /* stem 0.17.17*/ 
    /*0*/ <0.19304,6.50305,-2.18226>,
    /*1*/ <0.20672,6.5025,-2.181>,<0.18674,6.51521,-2.18359>,<0.18565,6.49145,-2.18219>,
            
    /*2*/ <0.24433,6.47284,-2.65205>,<0.231,6.48131,-2.65378>,<0.23028,6.46548,-2.65284>,
            
    /*3*/ <0.23371,6.63786,-3.09681>,<0.22696,6.64174,-3.09528>,<0.22672,6.6343,-3.09804>,
            
    /*4*/ <0.14033,6.88282,-3.49209>

    /* stem 0.17.18*/ 
    /*0*/ <0.20461,6.57402,-2.27673>,
    /*1*/ <0.19431,6.58125,-2.27256>,<0.20506,6.56974,-2.28928>,<0.21446,6.57106,-2.26836>,
            
    /*2*/ <0.41761,6.96283,-2.39677>,<0.42478,6.95516,-2.40792>,<0.43104,6.95603,-2.39397>,
            
    /*3*/ <0.6235,7.35556,-2.51458>,<0.62723,7.35199,-2.52023>,<0.63036,7.35243,-2.51326>,
            
    /*4*/ <0.77185,7.75576,-2.68321>

    /* stem 0.17.19*/ 
    /*0*/ <0.21842,6.65869,-2.38945>,
    /*1*/ <0.22089,6.64861,-2.39672>,<0.22564,6.66906,-2.39033>,<0.20872,6.65839,-2.3813>,
            
    /*2*/ <-0.04791,6.81205,-2.70752>,<-0.04475,6.82569,-2.70326>,<-0.05603,6.81858,-2.69724>,
            
    /*3*/ <-0.18842,7.15612,-2.95264>,<-0.18534,7.1608,-2.94794>,<-0.19227,7.15866,-2.94697>,
            
    /*4*/ <-0.25466,7.52874,-3.18186>

    /* stem 0.17.20*/ 
    /*0*/ <0.23319,6.7493,-2.51008>,
    /*1*/ <0.23895,6.75741,-2.50328>,<0.22549,6.75295,-2.51859>,<0.23513,6.73753,-2.50836>,
            
    /*2*/ <0.55388,6.76587,-2.7871>,<0.54491,6.76289,-2.79731>,<0.55134,6.75261,-2.79049>,
            
    /*3*/ <0.77049,7.02411,-3.04003>,<0.766,7.0229,-3.0452>,<0.77163,7.01888,-3.04447>,
            
    /*4*/ <0.91609,7.38866,-3.1975>

    /* stem 0.17.21*/ 
    /*0*/ <0.24538,6.82403,-2.60957>,
    /*1*/ <0.23542,6.8215,-2.61269>,<0.25353,6.8233,-2.61651>,<0.24718,6.8273,-2.5995>,
            
    /*2*/ <0.17595,7.20996,-2.72613>,<0.18803,7.21116,-2.72868>,<0.18379,7.21383,-2.71734>,
            
    /*3*/ <0.1834,7.59562,-2.86502>,<0.18953,7.59525,-2.86587>,<0.18727,7.59724,-2.86046>,
            
    /*4*/ <0.34026,7.93387,-3.0358>

    /* stem 0.17.22*/ 
    /*0*/ <0.25758,6.89887,-2.7092>,
    /*1*/ <0.26631,6.89598,-2.7103>,<0.25575,6.90792,-2.70842>,<0.25067,6.89271,-2.70888>,
            
    /*2*/ <0.22256,6.92222,-3.10099>,<0.21552,6.93018,-3.09974>,<0.21213,6.92003,-3.10004>,
            
    /*3*/ <0.22418,7.13263,-3.4345>,<0.22069,7.13609,-3.43238>,<0.21892,7.13182,-3.43508>,
            
    /*4*/ <0.2418,7.47612,-3.62744>

    /* stem 0.17.23*/ 
    /*0*/ <0.26795,6.99403,-2.79845>,
    /*1*/ <0.26381,6.99834,-2.79357>,<0.26573,6.99331,-2.8058>,<0.27432,6.99044,-2.79597>,
            
    /*2*/ <0.47194,7.29986,-2.88737>,<0.47322,7.29651,-2.89552>,<0.47895,7.2946,-2.88896>,
            
    /*3*/ <0.70083,7.5714,-3.01945>,<0.70123,7.56922,-3.02331>,<0.70409,7.56842,-3.02>,
            
    /*4*/ <0.92663,7.8383,-3.16386>

    /* stem 0.17.24*/ 
    /*0*/ <0.27644,7.08724,-2.87368>,
    /*1*/ <0.27563,7.08336,-2.87858>,<0.28095,7.09164,-2.87386>,<0.27273,7.08673,-2.86861>,
            
    /*2*/ <0.04104,7.32003,-3.02451>,<0.0446,7.32555,-3.02135>,<0.03912,7.32228,-3.01785>,
            
    /*3*/ <-0.11229,7.58586,-3.21964>,<-0.11029,7.58834,-3.21787>,<-0.11356,7.58739,-3.21659>,
            
    /*4*/ <-0.19915,7.89135,-3.39757>

    /* stem 0.17.25*/ 
    /*0*/ <0.28315,7.16096,-2.93318>,
    /*1*/ <0.28696,7.16295,-2.93028>,<0.27939,7.16404,-2.93499>,<0.2831,7.15589,-2.93427>,
            
    /*2*/ <0.47527,7.22308,-3.222>,<0.47022,7.2238,-3.22514>,<0.4727,7.21836,-3.22466>,
            
    /*3*/ <0.63411,7.45467,-3.4334>,<0.63156,7.45506,-3.43491>,<0.6335,7.45294,-3.43577>,
            
    /*4*/ <0.71313,7.7471,-3.61354>

    /* stem 0.17.26*/ 
    /*0*/ <0.29103,7.24745,-3.003>,
    /*1*/ <0.28716,7.24756,-3.00331>,<0.29323,7.24776,-3.00617>,<0.29268,7.24705,-2.99951>,
            
    /*2*/ <0.29453,7.58451,-2.96674>,<0.29858,7.58464,-2.96865>,<0.29822,7.58417,-2.96421>,
            
    /*3*/ <0.26734,7.90434,-3.07471>,<0.26935,7.9042,-3.07567>,<0.26918,7.9049,-3.07356>,
            
    /*4*/ <0.30596,8.14477,-3.31085>

    /* stem 0.17.27*/ 
    /*0*/ <0.3011,7.35814,-3.09234>,
    /*1*/ <0.30285,7.35721,-3.0933>,<0.30124,7.36021,-3.09158>,<0.29922,7.35702,-3.09213>,
            
    /*2*/ <0.20424,7.46881,-3.37868>,<0.20317,7.47081,-3.37753>,<0.20182,7.46868,-3.3779>,
            
    /*3*/ <0.23533,7.67322,-3.62512>,<0.23481,7.67414,-3.62442>,<0.23407,7.67339,-3.62513>,
            
    /*4*/ <0.29871,7.90993,-3.83385>

    /* stem 0.17.28*/ 
    /*0*/ <0.31013,7.45728,-3.17236>,
    /*1*/ <0.30998,7.45772,-3.17184>,<0.30985,7.45738,-3.173>,<0.31057,7.45675,-3.17225>,
            
    /*2*/ <0.54749,7.63472,-3.25083>,<0.54741,7.6345,-3.2516>,<0.54789,7.63407,-3.25111>,
            
    /*3*/ <0.68233,7.85029,-3.42216>,<0.68221,7.8501,-3.4225>,<0.68256,7.85001,-3.42233>,
            
    /*4*/ <0.78264,8.0602,-3.62183>

    /* stem 0.18*/ 
    /*0*/ <0.04416,6.12939,0.00371>,
    /*1*/ <0.01019,6.13012,0.03222>,<0.02936,6.17112,0.00633>,<0.06898,6.15445,-0.02318>,
            <0.0743,6.10315,-0.01553>,<0.03796,6.08812,0.01871>,
    /*2*/ <0.49544,6.26404,0.59313>,<0.51078,6.29684,0.57242>,<0.54247,6.2835,0.54881>,
            <0.54673,6.24246,0.55493>,<0.51766,6.23044,0.58232>,
    /*3*/ <0.92589,6.4939,1.16439>,<0.93602,6.51807,1.14731>,<0.96176,6.50899,1.13203>,
            <0.96753,6.47921,1.13966>,<0.94536,6.46988,1.15966>,
    /*4*/ <1.37958,6.83202,1.66547>,<1.38435,6.84671,1.65146>,<1.40115,6.84033,1.64089>,
            <1.40678,6.82169,1.64838>,<1.39344,6.81656,1.66357>,
    /*5*/ <1.78926,7.29064,2.10138>,<1.79072,7.29711,2.09333>,<1.79943,7.29421,2.0884>,
            <1.80337,7.28595,2.0934>,<1.79708,7.28374,2.10142>,
    /*6*/ <2.1049,7.78446,2.57343>

    /* stem 0.18.0*/ 
    /*0*/ <0.13568,6.15504,0.11209>,
    /*1*/ <0.14785,6.16952,0.09838>,<0.14672,6.13843,0.12426>,<0.11246,6.15716,0.11362>,
            
    /*2*/ <0.22383,6.63126,0.66693>,<0.22307,6.61053,0.68419>,<0.20023,6.62302,0.67709>,
            
    /*3*/ <0.19169,6.99362,1.31109>,<0.19041,6.98195,1.31774>,<0.17943,6.98852,1.31347>,
            
    /*4*/ <0.31495,7.55171,1.77029>

    /* stem 0.18.1*/ 
    /*0*/ <0.21888,6.17835,0.21062>,
    /*1*/ <0.21814,6.15635,0.21645>,<0.21583,6.19443,0.22645>,<0.22267,6.18426,0.18896>,
            
    /*2*/ <0.92767,6.17338,0.34131>,<0.92613,6.19876,0.34797>,<0.93069,6.19199,0.32298>,
            
    /*3*/ <1.54747,6.5444,0.4311>,<1.54066,6.55549,0.433>,<1.54445,6.5521,0.42088>,
            
    /*4*/ <2.01218,6.92415,0.82927>

    /* stem 0.18.2*/ 
    /*0*/ <0.28023,6.19554,0.28328>,
    /*1*/ <0.26971,6.21475,0.28762>,<0.30253,6.1946,0.28406>,<0.26846,6.17727,0.27816>,
            
    /*2*/ <0.24181,6.03595,0.97317>,<0.26369,6.02252,0.9708>,<0.24098,6.01097,0.96686>,
            
    /*3*/ <0.201,6.03889,1.67753>,<0.2118,6.03189,1.67829>,<0.20034,6.02602,1.67765>,
            
    /*4*/ <0.30544,6.28354,2.33305>

    /* stem 0.18.3*/ 
    /*0*/ <0.35611,6.2168,0.37314>,
    /*1*/ <0.37255,6.20913,0.36107>,<0.35385,6.21035,0.39383>,<0.34194,6.23093,0.36452>,
            
    /*2*/ <0.76674,6.74018,0.57368>,<0.75427,6.74099,0.59552>,<0.74633,6.75471,0.57598>,
            
    /*3*/ <1.19417,7.16999,0.91346>,<1.18692,7.16928,0.92372>,<1.18479,7.1782,0.91511>,
            
    /*4*/ <1.59758,7.62631,1.24811>

    /* stem 0.18.4*/ 
    /*0*/ <0.42125,6.23505,0.45028>,
    /*1*/ <0.40664,6.22821,0.46423>,<0.43347,6.25188,0.45502>,<0.42363,6.22508,0.43158>,
            
    /*2*/ <0.87441,5.81515,0.74031>,<0.89229,5.83093,0.73417>,<0.88574,5.81306,0.71854>,
            
    /*3*/ <1.44794,5.73837,1.10672>,<1.45299,5.74807,1.10105>,<1.45446,5.73676,1.0964>,
            
    /*4*/ <1.98352,6.05561,1.39108>

    /* stem 0.18.5*/ 
    /*0*/ <0.50211,6.25771,0.54603>,
    /*1*/ <0.50822,6.27522,0.53672>,<0.51609,6.24536,0.55512>,<0.48201,6.25255,0.54625>,
            
    /*2*/ <0.42706,6.60155,1.11287>,<0.43231,6.58164,1.12513>,<0.40958,6.58643,1.11922>,
            
    /*3*/ <0.42316,6.82377,1.74382>,<0.42559,6.81274,1.74783>,<0.41422,6.81626,1.74652>,
            
    /*4*/ <0.57908,7.12949,2.31412>

    /* stem 0.18.6*/ 
    /*0*/ <0.54139,6.27365,0.59588>,
    /*1*/ <0.54797,6.25448,0.59869>,<0.53848,6.28593,0.61198>,<0.53771,6.28053,0.57696>,
            
    /*2*/ <1.16976,6.46838,0.55193>,<1.16344,6.48935,0.56079>,<1.16292,6.48575,0.53745>,
            
    /*3*/ <1.71089,6.84086,0.63725>,<1.70425,6.84976,0.64126>,<1.70665,6.84892,0.62973>,
            
    /*4*/ <2.15825,7.2858,0.83145>

    /* stem 0.18.7*/ 
    /*0*/ <0.6193,6.31595,0.70198>,
    /*1*/ <0.60471,6.32803,0.70788>,<0.63818,6.322,0.70289>,<0.61502,6.29781,0.69516>,
            
    /*2*/ <0.65611,6.0889,1.30214>,<0.67842,6.08488,1.29881>,<0.66298,6.06875,1.29366>,
            
    /*3*/ <0.54898,6.12217,1.92877>,<0.55993,6.11952,1.93086>,<0.55209,6.11121,1.92996>,
            
    /*4*/ <0.61653,6.43746,2.48366>

    /* stem 0.18.8*/ 
    /*0*/ <0.71079,6.36561,0.82655>,
    /*1*/ <0.72619,6.36569,0.81521>,<0.71222,6.35938,0.84457>,<0.69396,6.37176,0.81986>,
            
    /*2*/ <0.85728,6.94357,1.00804>,<0.84797,6.93936,1.02761>,<0.8358,6.94762,1.01114>,
            
    /*3*/ <1.21707,7.38081,1.26086>,<1.21285,7.37864,1.27083>,<1.20813,7.38626,1.26437>,
            
    /*4*/ <1.60416,7.78143,1.53993>

    /* stem 0.18.9*/ 
    /*0*/ <0.76524,6.39517,0.9007>,
    /*1*/ <0.75593,6.38367,0.91212>,<0.76854,6.41284,0.90587>,<0.77126,6.38901,0.8841>,
            
    /*2*/ <1.28679,6.21411,1.16397>,<1.2952,6.23355,1.1598>,<1.29701,6.21767,1.14529>,
            
    /*3*/ <1.75211,6.21685,1.56032>,<1.75489,6.22678,1.55713>,<1.75912,6.21814,1.55222>,
            
    /*4*/ <2.1319,6.43737,1.9869>

    /* stem 0.18.10*/ 
    /*0*/ <0.82986,6.43025,0.98867>,
    /*1*/ <0.82909,6.44732,0.98243>,<0.84534,6.42384,0.99575>,<0.81513,6.41959,0.98784>,
            
    /*2*/ <0.66078,6.63198,1.5255>,<0.67161,6.61632,1.53438>,<0.65148,6.61349,1.5291>,
            
    /*3*/ <0.64552,6.93069,2.0405>,<0.65111,6.92311,2.04516>,<0.64061,6.92264,2.04512>,
            
    /*4*/ <0.73021,7.30821,2.49492>

    /* stem 0.18.11*/ 
    /*0*/ <0.90427,6.47064,1.09>,
    /*1*/ <0.91418,6.45616,1.0885>,<0.89795,6.4754,1.10574>,<0.90068,6.48037,1.07576>,
            
    /*2*/ <1.38919,6.77819,1.18502>,<1.37838,6.79102,1.19652>,<1.38019,6.79433,1.17653>,
            
    /*3*/ <1.80237,7.13623,1.38869>,<1.79536,7.14155,1.39379>,<1.79779,7.14416,1.38427>,
            
    /*4*/ <2.04819,7.6104,1.62473>

    /* stem 0.18.12*/ 
    /*0*/ <0.97117,6.51207,1.17566>,
    /*1*/ <0.95738,6.51781,1.184>,<0.98356,6.52296,1.17111>,<0.97258,6.49545,1.17186>,
            
    /*2*/ <1.22378,6.42489,1.67689>,<1.24124,6.42832,1.6683>,<1.23392,6.40998,1.6688>,
            
    /*3*/ <1.41514,6.435,2.20909>,<1.42434,6.43654,2.20584>,<1.42105,6.42732,2.20719>,
            
    /*4*/ <1.75516,6.75778,2.53109>

    /* stem 0.18.13*/ 
    /*0*/ <1.10136,6.61063,1.32325>,
    /*1*/ <1.11141,6.61509,1.31141>,<1.10729,6.60547,1.33737>,<1.08537,6.61133,1.32097>,
            
    /*2*/ <1.10349,7.12158,1.50286>,<1.10075,7.11517,1.52017>,<1.08614,7.11907,1.50924>,
            
    /*3*/ <1.13362,7.63285,1.67641>,<1.13233,7.63002,1.68521>,<1.12499,7.63226,1.6799>,
            
    /*4*/ <1.12539,8.11926,1.91608>

    /* stem 0.18.14*/ 
    /*0*/ <1.14987,6.64736,1.37825>,
    /*1*/ <1.14756,6.63537,1.38829>,<1.14936,6.66226,1.38348>,<1.1527,6.64443,1.36297>,
            
    /*2*/ <1.67024,6.62229,1.48482>,<1.67144,6.64022,1.48161>,<1.67366,6.62833,1.46794>,
            
    /*3*/ <2.15464,6.70189,1.68884>,<2.1541,6.71078,1.68685>,<2.15762,6.70494,1.68078>,
            
    /*4*/ <2.41763,7.04908,1.99553>

    /* stem 0.18.15*/ 
    /*0*/ <1.26468,6.73427,1.50841>,
    /*1*/ <1.25872,6.74753,1.5048>,<1.27956,6.73268,1.50911>,<1.25575,6.72259,1.51131>,
            
    /*2*/ <1.25132,6.87248,1.99754>,<1.26521,6.86258,2.00041>,<1.24934,6.85585,2.00188>,
            
    /*3*/ <1.34503,7.12616,2.42595>,<1.35209,7.12135,2.42734>,<1.34444,7.11884,2.4305>,
            
    /*4*/ <1.63057,7.45746,2.68419>

    /* stem 0.18.16*/ 
    /*0*/ <1.3447,6.79485,1.59913>,
    /*1*/ <1.35558,6.78623,1.59529>,<1.34298,6.79855,1.61295>,<1.33554,6.79977,1.58916>,
            
    /*2*/ <1.63912,7.18264,1.52691>,<1.63071,7.19086,1.53868>,<1.62576,7.19167,1.52282>,
            
    /*3*/ <1.91665,7.58772,1.56997>,<1.91155,7.59068,1.57584>,<1.91016,7.59248,1.56784>,
            
    /*4*/ <2.17223,7.99064,1.69206>

    /* stem 0.18.17*/ 
    /*0*/ <1.41489,6.85632,1.67788>,
    /*1*/ <1.40438,6.85681,1.68696>,<1.4205,6.8681,1.67311>,<1.41978,6.84405,1.67358>,
            
    /*2*/ <1.7199,6.85442,2.04527>,<1.73065,6.86195,2.03604>,<1.73017,6.84592,2.03635>,
            
    /*3*/ <2.09625,6.92362,2.33366>,<2.10021,6.92728,2.32772>,<2.10091,6.91935,2.32872>,
            
    /*4*/ <2.45228,7.21602,2.46267>

    /* stem 0.18.18*/ 
    /*0*/ <1.48065,6.93121,1.74996>,
    /*1*/ <1.48516,6.93766,1.73914>,<1.48869,6.92938,1.76049>,<1.4681,6.92658,1.75024>,
            
    /*2*/ <1.33973,7.33692,1.92221>,<1.34208,7.3314,1.93645>,<1.32836,7.32954,1.92961>,
            
    /*3*/ <1.39861,7.73832,2.14307>,<1.40001,7.73456,2.14967>,<1.39279,7.73662,2.14786>,
            
    /*4*/ <1.44296,8.09147,2.44003>

    /* stem 0.18.19*/ 
    /*0*/ <1.5752,7.0389,1.8536>,
    /*1*/ <1.57824,7.02911,1.86101>,<1.57283,7.05021,1.85873>,<1.57454,7.03738,1.84106>,
            
    /*2*/ <2.00436,7.13811,1.82328>,<2.00075,7.15218,1.82176>,<2.00189,7.14362,1.80998>,
            
    /*3*/ <2.35579,7.36375,1.96646>,<2.3523,7.37005,1.96528>,<2.35636,7.36708,1.95999>,
            
    /*4*/ <2.66978,7.61327,2.15097>

    /* stem 0.18.20*/ 
    /*0*/ <1.62261,7.09289,1.90557>,
    /*1*/ <1.61396,7.10154,1.90448>,<1.63438,7.09567,1.90338>,<1.61951,7.08147,1.90884>,
            
    /*2*/ <1.66916,7.20317,2.31948>,<1.68277,7.19925,2.31875>,<1.67286,7.18979,2.32238>,
            
    /*3*/ <1.7158,7.50052,2.6236>,<1.72276,7.4992,2.6239>,<1.71829,7.49562,2.62808>,
            
    /*4*/ <1.72694,7.7971,2.93555>

    /* stem 0.18.21*/ 
    /*0*/ <1.67883,7.15692,1.96719>,
    /*1*/ <1.68844,7.15344,1.96204>,<1.67849,7.15794,1.97859>,<1.66956,7.15938,1.96094>,
            
    /*2*/ <1.81204,7.5518,1.9318>,<1.8054,7.55481,1.94283>,<1.79944,7.55576,1.93107>,
            
    /*3*/ <1.97623,7.9171,2.05365>,<1.9723,7.91716,2.05896>,<1.97028,7.91995,2.05332>,
            
    /*4*/ <2.14428,8.27629,2.18642>

    /* stem 0.18.22*/ 
    /*0*/ <1.74562,7.23298,2.04039>,
    /*1*/ <1.73981,7.23061,2.04815>,<1.74828,7.24248,2.03887>,<1.74876,7.22586,2.03415>,
            
    /*2*/ <2.0695,7.17612,2.27378>,<2.07514,7.18403,2.26759>,<2.07547,7.17295,2.26444>,
            
    /*3*/ <2.2465,7.36525,2.58072>,<2.24887,7.36904,2.57708>,<2.25168,7.36419,2.57843>,
            
    /*4*/ <2.32064,7.65301,2.85286>

    /* stem 0.18.23*/ 
    /*0*/ <1.82009,7.3289,2.13288>,
    /*1*/ <1.82048,7.33445,2.12689>,<1.82657,7.32761,2.1377>,<1.81321,7.32463,2.13406>,
            
    /*2*/ <1.69382,7.60345,2.37121>,<1.69787,7.59889,2.37841>,<1.68897,7.59691,2.37598>,
            
    /*3*/ <1.7262,7.84674,2.6685>,<1.72841,7.84342,2.67102>,<1.72371,7.8438,2.67122>,
            
    /*4*/ <1.79302,8.17167,2.86175>

    /* stem 0.18.24*/ 
    /*0*/ <1.86972,7.40828,2.20965>,
    /*1*/ <1.87342,7.40333,2.21238>,<1.86649,7.41267,2.21364>,<1.86924,7.40884,2.20294>,
            
    /*2*/ <2.16944,7.62578,2.2085>,<2.16482,7.632,2.20935>,<2.16665,7.62945,2.20221>,
            
    /*3*/ <2.40706,7.90221,2.2765>,<2.40409,7.90472,2.27679>,<2.40579,7.90411,2.27334>,
            
    /*4*/ <2.61363,8.13046,2.48153>

    /* stem 0.18.25*/ 
    /*0*/ <1.91279,7.47717,2.27627>,
    /*1*/ <1.90788,7.47962,2.27691>,<1.91728,7.48021,2.27525>,<1.9132,7.47168,2.27666>,
            
    /*2*/ <1.96968,7.50798,2.62808>,<1.97594,7.50837,2.62697>,<1.97322,7.50269,2.62791>,
            
    /*3*/ <1.9738,7.73216,2.90505>,<1.97695,7.73253,2.90472>,<1.9758,7.73023,2.9066>,
            
    /*4*/ <2.06473,8.03159,3.07869>

    /* stem 0.18.26*/ 
    /*0*/ <1.9691,7.56724,2.36337>,
    /*1*/ <1.97227,7.56744,2.36111>,<1.96947,7.56711,2.36725>,<1.96555,7.56716,2.36175>,
            
    /*2*/ <1.95821,7.9081,2.37439>,<1.95635,7.90788,2.37849>,<1.95373,7.90791,2.37482>,
            
    /*3*/ <2.03319,8.23999,2.36052>,<2.03236,8.24027,2.3626>,<2.03102,8.2405,2.36081>,
            
    /*4*/ <2.12635,8.524,2.52575>

    /* stem 0.18.27*/ 
    /*0*/ <2.02623,7.65863,2.45175>,
    /*1*/ <2.02542,7.65744,2.45349>,<2.02616,7.66088,2.45179>,<2.0271,7.65755,2.44996>,
            
    /*2*/ <2.31854,7.66415,2.5925>,<2.31903,7.66645,2.59136>,<2.31966,7.66423,2.59015>,
            
    /*3*/ <2.61037,7.71035,2.72688>,<2.61048,7.71149,2.72626>,<2.61091,7.7104,2.72569>,
            
    /*4*/ <2.8287,7.83751,2.93034>

    /* stem 0.18.28*/ 
    /*0*/ <2.09176,7.76343,2.5531>,
    /*1*/ <2.09166,7.76372,2.55287>,<2.0921,7.76343,2.55325>,<2.09151,7.76316,2.55318>,
            
    /*2*/ <1.98962,7.92128,2.79364>,<1.98992,7.92109,2.79389>,<1.98953,7.92091,2.79384>,
            
    /*3*/ <1.93114,8.0697,3.05397>,<1.9313,8.06958,3.05407>,<1.93109,8.06951,3.05407>,
            
    /*4*/ <1.99157,8.22141,3.31193>

    /* stem 0.19*/ 
    /*0*/ <0.04659,6.23416,0.00391>,
    /*1*/ <0.05421,6.23407,-0.03935>,<0.05864,6.27473,-0.00783>,<0.04641,6.25933,0.03992>,
            <0.03442,6.20914,0.03791>,<0.03924,6.19353,-0.01108>,
    /*2*/ <-0.66283,6.41008,-0.15722>,<-0.65929,6.44262,-0.132>,<-0.66907,6.43029,-0.09381>,
            <-0.67867,6.39014,-0.09541>,<-0.67481,6.37765,-0.1346>,
    /*3*/ <-1.3532,6.67647,-0.2658>,<-1.34745,6.69989,-0.24634>,<-1.35576,6.69094,-0.21787>,
            <-1.36664,6.66199,-0.21973>,<-1.36505,6.65305,-0.24935>,
    /*4*/ <-1.97067,7.06057,-0.42926>,<-1.96512,7.07542,-0.41601>,<-1.97314,7.07082,-0.39754>,
            <-1.98366,7.05314,-0.39937>,<-1.98213,7.0468,-0.41897>,
    /*5*/ <-2.53908,7.5361,-0.53627>,<-2.53506,7.54259,-0.5293>,<-2.53898,7.54017,-0.52006>,
            <-2.54542,7.53219,-0.52131>,<-2.54548,7.52968,-0.53132>,
    /*6*/ <-3.05232,8.07624,-0.60245>

    /* stem 0.19.0*/ 
    /*0*/ <-0.07558,6.26421,-0.01769>,
    /*1*/ <-0.0752,6.27875,0.00041>,<-0.09391,6.25038,-0.02109>,<-0.05762,6.26349,-0.03238>,
            
    /*2*/ <-0.39024,6.79244,-0.41578>,<-0.40272,6.77353,-0.4301>,<-0.37852,6.78227,-0.43763>,
            
    /*3*/ <-0.93103,7.18993,-0.70777>,<-0.93604,7.17899,-0.71368>,<-0.92703,7.18654,-0.72011>,
            
    /*4*/ <-1.53848,7.50955,-0.96378>

    /* stem 0.19.1*/ 
    /*0*/ <-0.19906,6.29458,-0.03952>,
    /*1*/ <-0.20355,6.27292,-0.04426>,<-0.20911,6.31106,-0.05132>,<-0.18451,6.29976,-0.02299>,
            
    /*2*/ <-0.7415,6.28882,0.4293>,<-0.74521,6.31425,0.42459>,<-0.72881,6.30672,0.44348>,
            
    /*3*/ <-1.39551,6.48096,0.65757>,<-1.39347,6.49319,0.65347>,<-1.39023,6.48975,0.66565>,
            
    /*4*/ <-1.98402,6.87392,0.78405>

    /* stem 0.19.2*/ 
    /*0*/ <-0.31467,6.32302,-0.05997>,
    /*1*/ <-0.30832,6.34158,-0.07009>,<-0.32892,6.32395,-0.04313>,<-0.30678,6.30352,-0.06667>,
            
    /*2*/ <-0.84615,6.27332,-0.51664>,<-0.85989,6.26158,-0.49866>,<-0.84512,6.24795,-0.51436>,
            
    /*3*/ <-1.46327,6.47369,-0.77904>,<-1.46934,6.46807,-0.76935>,<-1.46693,6.46152,-0.78002>,
            
    /*4*/ <-2.025,6.8617,-0.93792>

    /* stem 0.19.3*/ 
    /*0*/ <-0.38618,6.34061,-0.07261>,
    /*1*/ <-0.39145,6.33342,-0.05278>,<-0.39978,6.33747,-0.08928>,<-0.3673,6.35092,-0.07577>,
            
    /*2*/ <-0.69778,6.94157,0.07812>,<-0.70333,6.94427,0.05379>,<-0.68168,6.95323,0.06279>,
            
    /*3*/ <-1.09125,7.5142,0.09237>,<-1.09268,7.51367,0.07991>,<-1.08312,7.52012,0.08486>,
            
    /*4*/ <-1.57188,7.98315,-0.08565>

    /* stem 0.19.4*/ 
    /*0*/ <-0.5142,6.3721,-0.09525>,
    /*1*/ <-0.51243,6.36503,-0.11509>,<-0.5252,6.38969,-0.09124>,<-0.50496,6.36157,-0.07941>,
            
    /*2*/ <-1.07455,5.99755,-0.02683>,<-1.08307,6.014,-0.01093>,<-1.06957,5.99525,-0.00305>,
            
    /*3*/ <-1.73484,5.99402,-0.1695>,<-1.7368,6.00278,-0.16123>,<-1.73742,5.99105,-0.15795>,
            
    /*4*/ <-2.34644,6.24263,-0.32322>

    /* stem 0.19.5*/ 
    /*0*/ <-0.62437,6.39919,-0.11473>,
    /*1*/ <-0.62202,6.41657,-0.10388>,<-0.64091,6.38727,-0.11163>,<-0.61019,6.39374,-0.12867>,
            
    /*2*/ <-0.95271,6.74714,-0.57468>,<-0.9653,6.7276,-0.57985>,<-0.94483,6.73192,-0.5912>,
            
    /*3*/ <-1.28574,7.14125,-0.98913>,<-1.29262,7.13212,-0.99245>,<-1.28253,7.13444,-0.99835>,
            
    /*4*/ <-1.61157,7.6669,-1.2234>

    /* stem 0.19.6*/ 
    /*0*/ <-0.7315,6.43435,-0.13326>,
    /*1*/ <-0.73904,6.41584,-0.131>,<-0.73802,6.44611,-0.1482>,<-0.71743,6.44109,-0.12056>,
            
    /*2*/ <-1.20054,6.65842,0.25682>,<-1.19986,6.6786,0.24535>,<-1.18614,6.67526,0.26378>,
            
    /*3*/ <-1.70272,7.03208,0.44085>,<-1.69924,7.04049,0.43363>,<-1.69539,7.04027,0.44458>,
            
    /*4*/ <-2.15922,7.48321,0.54899>

    /* stem 0.19.7*/ 
    /*0*/ <-0.83069,6.47271,-0.15014>,
    /*1*/ <-0.82374,6.4845,-0.16421>,<-0.84366,6.47957,-0.1371>,<-0.82467,6.45405,-0.14911>,
            
    /*2*/ <-1.30368,6.3053,-0.54256>,<-1.31696,6.30201,-0.52449>,<-1.3043,6.285,-0.53249>,
            
    /*3*/ <-1.87388,6.32583,-0.82463>,<-1.879,6.32456,-0.8146>,<-1.87627,6.31545,-0.82077>,
            
    /*4*/ <-2.33234,6.67367,-1.09196>

    /* stem 0.19.8*/ 
    /*0*/ <-0.94,6.51498,-0.16874>,
    /*1*/ <-0.94321,6.51497,-0.14991>,<-0.95258,6.5068,-0.18057>,<-0.92422,6.52316,-0.17574>,
            
    /*2*/ <-1.24568,7.05612,-0.20777>,<-1.25192,7.05067,-0.22821>,<-1.23302,7.06158,-0.22499>,
            
    /*3*/ <-1.75164,7.41599,-0.2213>,<-1.75416,7.41224,-0.23136>,<-1.74782,7.42119,-0.23024>,
            
    /*4*/ <-2.27771,7.7299,-0.33807>

    /* stem 0.19.9*/ 
    /*0*/ <-1.09406,6.57455,-0.19496>,
    /*1*/ <-1.09585,6.56352,-0.20954>,<-1.10072,6.59166,-0.19552>,<-1.08562,6.56847,-0.17982>,
            
    /*2*/ <-1.62239,6.36915,0.00966>,<-1.62564,6.38791,0.01901>,<-1.61558,6.37245,0.02947>,
            
    /*3*/ <-2.21273,6.44319,0.11285>,<-2.21092,6.45287,0.1168>,<-2.21085,6.44443,0.12322>,
            
    /*4*/ <-2.72884,6.7265,0.24872>

    /* stem 0.19.10*/ 
    /*0*/ <-1.16623,6.60246,-0.20724>,
    /*1*/ <-1.16052,6.61904,-0.20309>,<-1.18142,6.59606,-0.19994>,<-1.15675,6.59227,-0.2187>,
            
    /*2*/ <-1.47375,6.83425,-0.65852>,<-1.48768,6.81893,-0.65642>,<-1.47124,6.8164,-0.66892>,
            
    /*3*/ <-1.8078,7.23684,-0.929>,<-1.81596,7.23038,-0.92872>,<-1.8095,7.23026,-0.93688>,
            
    /*4*/ <-2.12196,7.67794,-1.16974>

    /* stem 0.19.11*/ 
    /*0*/ <-1.28845,6.64972,-0.22804>,
    /*1*/ <-1.29522,6.6356,-0.22035>,<-1.29444,6.65491,-0.24358>,<-1.27568,6.65865,-0.2202>,
            
    /*2*/ <-1.68603,6.97172,0.03945>,<-1.68551,6.98459,0.02396>,<-1.673,6.98708,0.03955>,
            
    /*3*/ <-2.14339,7.32701,0.01877>,<-2.13979,7.33129,0.01039>,<-2.13731,7.33501,0.01942>,
            
    /*4*/ <-2.55139,7.71285,-0.11921>

    /* stem 0.19.12*/ 
    /*0*/ <-1.42207,6.71665,-0.25782>,
    /*1*/ <-1.41531,6.72086,-0.27259>,<-1.4289,6.72845,-0.24804>,<-1.42199,6.70063,-0.25282>,
            
    /*2*/ <-1.91157,6.6395,-0.51637>,<-1.92063,6.64456,-0.5>,<-1.91602,6.62601,-0.50319>,
            
    /*3*/ <-2.40299,6.77143,-0.74545>,<-2.40646,6.77394,-0.73676>,<-2.40743,6.76483,-0.73992>,
            
    /*4*/ <-2.9083,7.01421,-0.73754>

    /* stem 0.19.13*/ 
    /*0*/ <-1.53338,6.78605,-0.28891>,
    /*1*/ <-1.53426,6.79147,-0.27366>,<-1.54686,6.78158,-0.2967>,<-1.51902,6.7851,-0.29635>,
            
    /*2*/ <-1.59577,7.29652,-0.46246>,<-1.60417,7.28993,-0.47782>,<-1.58561,7.29228,-0.47758>,
            
    /*3*/ <-1.77501,7.72547,-0.74657>,<-1.77836,7.71978,-0.7532>,<-1.76961,7.72303,-0.75381>,
            
    /*4*/ <-1.98254,8.17904,-0.9584>

    /* stem 0.19.14*/ 
    /*0*/ <-1.65519,6.86199,-0.32293>,
    /*1*/ <-1.66016,6.85011,-0.33166>,<-1.65804,6.87664,-0.32736>,<-1.64736,6.85923,-0.30975>,
            
    /*2*/ <-2.11041,6.8468,-0.06173>,<-2.109,6.86449,-0.05886>,<-2.10188,6.85288,-0.04713>,
            
    /*3*/ <-2.60798,6.93576,0.07885>,<-2.6062,6.9445,0.0799>,<-2.60525,6.93886,0.08683>,
            
    /*4*/ <-3.00431,7.27793,0.1358>

    /* stem 0.19.15*/ 
    /*0*/ <-1.77093,6.93416,-0.35525>,
    /*1*/ <-1.76279,6.94666,-0.35646>,<-1.78434,6.93456,-0.3486>,<-1.76566,6.92124,-0.3607>,
            
    /*2*/ <-1.98474,7.04172,-0.8036>,<-1.9991,7.03365,-0.79835>,<-1.98666,7.02477,-0.80642>,
            
    /*3*/ <-2.29472,7.2912,-1.11743>,<-2.30154,7.28708,-1.11409>,<-2.29736,7.28373,-1.12088>,
            
    /*4*/ <-2.70239,7.56719,-1.24492>

    /* stem 0.19.16*/ 
    /*0*/ <-1.90861,7.02,-0.39371>,
    /*1*/ <-1.91594,7.01263,-0.38393>,<-1.91341,7.02078,-0.40712>,<-1.89649,7.02658,-0.39007>,
            
    /*2*/ <-2.16599,7.41704,-0.27344>,<-2.16431,7.42248,-0.2889>,<-2.15303,7.42634,-0.27754>,
            
    /*3*/ <-2.41934,7.79278,-0.09532>,<-2.41937,7.79636,-0.10273>,<-2.41328,7.79795,-0.09741>,
            
    /*4*/ <-2.6122,8.23106,0.00517>

    /* stem 0.19.17*/ 
    /*0*/ <-2.02132,7.10027,-0.42169>,
    /*1*/ <-2.01864,7.1002,-0.4351>,<-2.02239,7.11214,-0.41499>,<-2.02294,7.08846,-0.41498>,
            
    /*2*/ <-2.48139,7.11089,-0.52302>,<-2.48389,7.11885,-0.50961>,<-2.48426,7.10307,-0.50961>,
            
    /*3*/ <-2.8358,7.3797,-0.67349>,<-2.83607,7.38337,-0.66651>,<-2.84044,7.37691,-0.66774>,
            
    /*4*/ <-3.13235,7.74738,-0.66544>

    /* stem 0.19.18*/ 
    /*0*/ <-2.09581,7.16277,-0.43689>,
    /*1*/ <-2.09249,7.1694,-0.42589>,<-2.10854,7.15996,-0.43934>,<-2.08641,7.15895,-0.44542>,
            
    /*2*/ <-2.13767,7.56442,-0.65592>,<-2.14837,7.55813,-0.66488>,<-2.13362,7.55745,-0.66894>,
            
    /*3*/ <-2.2742,7.96671,-0.8292>,<-2.27949,7.96316,-0.83344>,<-2.27247,7.96432,-0.83627>,
            
    /*4*/ <-2.53478,8.31689,-0.97322>

    /* stem 0.19.19*/ 
    /*0*/ <-2.20291,7.25263,-0.45873>,
    /*1*/ <-2.21026,7.24297,-0.4624>,<-2.20409,7.26396,-0.46429>,<-2.19438,7.25095,-0.4495>,
            
    /*2*/ <-2.51045,7.36231,-0.16019>,<-2.50633,7.3763,-0.16145>,<-2.49986,7.36762,-0.1516>,
            
    /*3*/ <-2.82029,7.60728,0.04155>,<-2.81667,7.6134,0.03981>,<-2.81526,7.60999,0.04613>,
            
    /*4*/ <-3.1762,7.83192,0.17585>

    /* stem 0.19.20*/ 
    /*0*/ <-2.2872,7.32336,-0.47592>,
    /*1*/ <-2.27941,7.3315,-0.48063>,<-2.2964,7.32711,-0.46881>,<-2.2858,7.31146,-0.47833>,
            
    /*2*/ <-2.53293,7.36903,-0.82466>,<-2.54426,7.3661,-0.81678>,<-2.53719,7.35567,-0.82313>,
            
    /*3*/ <-2.80294,7.60647,-1.05588>,<-2.80818,7.60496,-1.05141>,<-2.80702,7.60083,-1.05701>,
            
    /*4*/ <-2.91629,7.95707,-1.27217>

    /* stem 0.19.21*/ 
    /*0*/ <-2.39326,7.41235,-0.49756>,
    /*1*/ <-2.39766,7.40947,-0.48781>,<-2.39986,7.41462,-0.50616>,<-2.38226,7.41294,-0.4987>,
            
    /*2*/ <-2.40599,7.8068,-0.3785>,<-2.40745,7.81024,-0.39073>,<-2.39572,7.80912,-0.38576>,
            
    /*3*/ <-2.48032,8.14927,-0.16603>,<-2.4815,8.15243,-0.17147>,<-2.47557,8.15225,-0.16909>,
            
    /*4*/ <-2.69535,8.42741,0.0477>

    /* stem 0.19.22*/ 
    /*0*/ <-2.47696,7.48257,-0.51463>,
    /*1*/ <-2.47724,7.47995,-0.52404>,<-2.47738,7.49203,-0.51218>,<-2.47625,7.47575,-0.50767>,
            
    /*2*/ <-2.87499,7.45849,-0.50268>,<-2.87508,7.46655,-0.49477>,<-2.87434,7.45569,-0.49177>,
            
    /*3*/ <-3.24871,7.57978,-0.56735>,<-3.24817,7.5837,-0.56333>,<-3.25007,7.57855,-0.56201>,
            
    /*4*/ <-3.53016,7.86171,-0.59695>

    /* stem 0.19.23*/ 
    /*0*/ <-2.57379,7.57098,-0.53248>,
    /*1*/ <-2.56944,7.5758,-0.52744>,<-2.5819,7.57017,-0.5314>,<-2.57004,7.56697,-0.53859>,
            
    /*2*/ <-2.63131,7.87216,-0.76202>,<-2.63962,7.86841,-0.76466>,<-2.63171,7.86627,-0.76945>,
            
    /*3*/ <-2.75455,8.19536,-0.92554>,<-2.75865,8.19326,-0.92667>,<-2.75499,8.19312,-0.9297>,
            
    /*4*/ <-2.90522,8.52717,-1.04292>

    /* stem 0.19.24*/ 
    /*0*/ <-2.65377,7.65542,-0.54417>,
    /*1*/ <-2.65875,7.65074,-0.54394>,<-2.65365,7.66004,-0.54923>,<-2.64891,7.6555,-0.53935>,
            
    /*2*/ <-2.86273,7.88114,-0.34037>,<-2.85933,7.88734,-0.3439>,<-2.85617,7.88432,-0.33731>,
            
    /*3*/ <-3.09989,8.14149,-0.23036>,<-3.09785,8.14422,-0.23235>,<-3.09696,8.14344,-0.22858>,
            
    /*4*/ <-3.40206,8.35235,-0.23344>

    /* stem 0.19.25*/ 
    /*0*/ <-2.73747,7.7438,-0.55641>,
    /*1*/ <-2.7343,7.7463,-0.56001>,<-2.73926,7.74647,-0.55206>,<-2.73885,7.73863,-0.55716>,
            
    /*2*/ <-3.02207,7.84817,-0.7398>,<-3.02538,7.84829,-0.7345>,<-3.0251,7.84306,-0.7379>,
            
    /*3*/ <-3.30409,7.97465,-0.91274>,<-3.30573,7.97467,-0.91008>,<-3.30574,7.97214,-0.91191>,
            
    /*4*/ <-3.59897,8.15666,-0.98754>

    /* stem 0.19.26*/ 
    /*0*/ <-2.85084,7.8635,-0.57299>,
    /*1*/ <-2.85142,7.86342,-0.56958>,<-2.85347,7.86314,-0.57521>,<-2.84762,7.86395,-0.57418>,
            
    /*2*/ <-2.89691,8.1947,-0.57049>,<-2.89828,8.19452,-0.57424>,<-2.89438,8.19505,-0.57356>,
            
    /*3*/ <-2.91503,8.52685,-0.60724>,<-2.91567,8.52661,-0.60912>,<-2.91371,8.52676,-0.60874>,
            
    /*4*/ <-3.06994,8.8102,-0.69439>

    /* stem 0.19.27*/ 
    /*0*/ <-2.9304,7.94751,-0.58463>,
    /*1*/ <-2.93108,7.94662,-0.58639>,<-2.92987,7.94954,-0.58461>,<-2.93025,7.94638,-0.58287>,
            
    /*2*/ <-3.23183,8.026,-0.5094>,<-3.23102,8.02795,-0.50821>,<-3.23128,8.02584,-0.50705>,
            
    /*3*/ <-3.50251,8.19223,-0.46658>,<-3.50188,8.1931,-0.46602>,<-3.50234,8.19219,-0.46538>,
            
    /*4*/ <-3.67401,8.45211,-0.54204>

    /* stem 0.19.28*/ 
    /*0*/ <-3.02573,8.04817,-0.59857>,
    /*1*/ <-3.02542,8.04848,-0.59843>,<-3.02617,8.04821,-0.59845>,<-3.02559,8.04781,-0.59882>,
            
    /*2*/ <-3.07468,8.21146,-0.84993>,<-3.07518,8.21128,-0.84994>,<-3.07479,8.21102,-0.85019>,
            
    /*3*/ <-3.09786,8.39575,-1.09018>,<-3.09811,8.39568,-1.09021>,<-3.09792,8.39555,-1.09033>,
            
    /*4*/ <-3.16206,8.61613,-1.28906>

    /* stem 0.20*/ 
    /*0*/ <0.05167,6.45388,0.00434>,
    /*1*/ <0.07319,6.45331,0.04162>,<0.0503,6.4935,0.0211>,<0.02931,6.47894,-0.02258>,
            <0.03922,6.42974,-0.02905>,<0.06634,6.4139,0.01062>,
    /*2*/ <0.68904,6.62513,-0.32115>,<0.67074,6.65728,-0.33757>,<0.65394,6.64563,-0.37251>,
            <0.66187,6.60627,-0.37769>,<0.68357,6.5936,-0.34595>,
    /*3*/ <1.28451,6.90308,-0.64866>,<1.26806,6.92622,-0.65941>,<1.25725,6.9182,-0.68662>,
            <1.26703,6.8901,-0.69269>,<1.28388,6.88076,-0.66923>,
    /*4*/ <1.87678,7.2407,-0.91922>,<1.86521,7.25585,-0.92601>,<1.85944,7.25134,-0.94488>,
            <1.86744,7.2334,-0.94975>,<1.87816,7.22682,-0.93389>,
    /*5*/ <2.47894,7.62435,-1.08438>,<2.47323,7.63201,-1.08772>,<2.47156,7.63059,-1.0976>,
            <2.47624,7.62205,-1.10037>,<2.4808,7.6182,-1.0922>,
    /*6*/ <3.0004,8.13649,-1.15821>

    /* stem 0.20.0*/ 
    /*0*/ <0.18576,6.491,-0.07248>,
    /*1*/ <0.17426,6.50535,-0.08561>,<0.20087,6.47693,-0.08165>,<0.18214,6.49072,-0.05018>,
            
    /*2*/ <0.69033,6.99277,0.00819>,<0.70808,6.97383,0.01083>,<0.69558,6.98302,0.03181>,
            
    /*3*/ <1.11841,7.48233,-0.27775>,<1.12835,7.47389,-0.27757>,<1.12624,7.48171,-0.26734>,
            
    /*4*/ <1.49193,7.8747,-0.74454>

    /* stem 0.20.1*/ 
    /*0*/ <0.28198,6.51764,-0.12761>,
    /*1*/ <0.28815,6.49645,-0.12707>,<0.297,6.53359,-0.1249>,<0.26078,6.52288,-0.13086>,
            
    /*2*/ <0.396,6.51793,-0.82076>,<0.4019,6.54269,-0.81931>,<0.37775,6.53555,-0.82329>,
            
    /*3*/ <0.65227,6.63966,-1.46448>,<0.65447,6.65184,-1.46143>,<0.64328,6.64846,-1.46652>,
            
    /*4*/ <0.84191,6.94341,-2.07106>

    /* stem 0.20.2*/ 
    /*0*/ <0.36462,6.54052,-0.17496>,
    /*1*/ <0.36636,6.5586,-0.16319>,<0.36536,6.54156,-0.19656>,<0.36215,6.52141,-0.16513>,
            
    /*2*/ <1.05155,6.47382,-0.14739>,<1.05089,6.46247,-0.16963>,<1.04874,6.44904,-0.14868>,
            
    /*3*/ <1.69778,6.70208,-0.16356>,<1.69944,6.6969,-0.1748>,<1.702,6.69036,-0.16447>,
            
    /*4*/ <2.29074,7.04632,-0.23959>

    /* stem 0.20.3*/ 
    /*0*/ <0.43208,6.5592,-0.21361>,
    /*1*/ <0.42351,6.55239,-0.23185>,<0.45206,6.55389,-0.20861>,<0.42066,6.57132,-0.20037>,
            
    /*2*/ <0.65394,7.11359,-0.54125>,<0.67298,7.11458,-0.52575>,<0.65204,7.12621,-0.52026>,
            
    /*3*/ <0.94298,7.70899,-0.71446>,<0.95136,7.70763,-0.70559>,<0.94081,7.71343,-0.70321>,
            
    /*4*/ <1.3076,8.26503,-0.86342>

    /* stem 0.20.4*/ 
    /*0*/ <0.5369,6.58822,-0.27367>,
    /*1*/ <0.54802,6.58108,-0.25771>,<0.54124,6.60676,-0.28183>,<0.52145,6.57683,-0.28145>,
            
    /*2*/ <0.9697,6.29686,-0.68792>,<0.96518,6.31398,-0.704>,<0.95199,6.29403,-0.70375>,
            
    /*3*/ <1.34509,6.46095,-1.21986>,<1.33784,6.47016,-1.22223>,<1.33568,6.45944,-1.22709>,
            
    /*4*/ <1.77589,6.90861,-1.45783>

    /* stem 0.20.5*/ 
    /*0*/ <0.61833,6.61077,-0.32032>,
    /*1*/ <0.60982,6.62798,-0.32685>,<0.62646,6.59779,-0.33362>,<0.6187,6.60653,-0.30048>,
            
    /*2*/ <1.18889,6.92776,-0.27035>,<1.19998,6.90763,-0.27486>,<1.19481,6.91346,-0.25277>,
            
    /*3*/ <1.71689,7.30859,-0.3066>,<1.72357,7.29927,-0.30902>,<1.72194,7.30259,-0.2979>,
            
    /*4*/ <2.3101,7.57408,-0.39306>

    /* stem 0.20.6*/ 
    /*0*/ <0.69758,6.63751,-0.36471>,
    /*1*/ <0.70223,6.61949,-0.37165>,<0.71085,6.64779,-0.3541>,<0.67967,6.64525,-0.36839>,
            
    /*2*/ <0.9265,6.8916,-0.90947>,<0.93225,6.91047,-0.89777>,<0.91145,6.90877,-0.9073>,
            
    /*3*/ <1.23989,7.25821,-1.33808>,<1.24141,7.26635,-1.33015>,<1.23208,7.26652,-1.33683>,
            
    /*4*/ <1.55949,7.78381,-1.53388>

    /* stem 0.20.7*/ 
    /*0*/ <0.80244,6.68609,-0.42067>,
    /*1*/ <0.80552,6.69722,-0.40522>,<0.80124,6.69403,-0.43821>,<0.80056,6.667,-0.41858>,
            
    /*2*/ <1.42396,6.62439,-0.48421>,<1.42111,6.62226,-0.5062>,<1.42065,6.60424,-0.49311>,
            
    /*3*/ <1.99536,6.81794,-0.65191>,<1.99265,6.81693,-0.66267>,<1.99716,6.80832,-0.65723>,
            
    /*4*/ <2.52482,7.11508,-0.80863>

    /* stem 0.20.8*/ 
    /*0*/ <0.89899,6.73081,-0.47219>,
    /*1*/ <0.89,6.73124,-0.48866>,<0.91556,6.72211,-0.47077>,<0.89141,6.73909,-0.45715>,
            
    /*2*/ <1.18011,7.25404,-0.62623>,<1.19714,7.24795,-0.61429>,<1.18105,7.25927,-0.60521>,
            
    /*3*/ <1.59886,7.70735,-0.6321>,<1.60513,7.70176,-0.62526>,<1.59771,7.70866,-0.62141>,
            
    /*4*/ <2.03153,8.13172,-0.72286>

    /* stem 0.20.9*/ 
    /*0*/ <1.0056,6.7802,-0.52908>,
    /*1*/ <1.01604,6.76905,-0.51919>,<1.01145,6.79695,-0.53312>,<0.98931,6.77459,-0.53494>,
            
    /*2*/ <1.26441,6.56431,-1.02299>,<1.26135,6.58291,-1.03228>,<1.24659,6.568,-1.03349>,
            
    /*3*/ <1.6196,6.61053,-1.50368>,<1.61606,6.62026,-1.50547>,<1.61122,6.61202,-1.50984>,
            
    /*4*/ <1.97263,6.88387,-1.90289>

    /* stem 0.20.10*/ 
    /*0*/ <1.12919,6.83745,-0.59503>,
    /*1*/ <1.12217,6.8535,-0.59425>,<1.13744,6.83219,-0.60958>,<1.12795,6.82666,-0.58127>,
            
    /*2*/ <1.62383,7.05642,-0.38641>,<1.63401,7.04221,-0.39663>,<1.62768,7.03853,-0.37775>,
            
    /*3*/ <2.12872,7.3293,-0.31338>,<2.13347,7.32211,-0.31868>,<2.13251,7.3212,-0.30864>,
            
    /*4*/ <2.59787,7.66706,-0.34541>

    /* stem 0.20.11*/ 
    /*0*/ <1.22289,6.88085,-0.64504>,
    /*1*/ <1.22356,6.8674,-0.65546>,<1.23665,6.88538,-0.63607>,<1.20846,6.88978,-0.64358>,
            
    /*2*/ <1.38865,7.20842,-1.07584>,<1.39738,7.22041,-1.06291>,<1.37858,7.22334,-1.06791>,
            
    /*3*/ <1.70557,7.60368,-1.33407>,<1.70802,7.60752,-1.32536>,<1.70006,7.6108,-1.33011>,
            
    /*4*/ <1.91974,8.0568,-1.598>

    /* stem 0.20.12*/ 
    /*0*/ <1.30784,6.92387,-0.68706>,
    /*1*/ <1.31227,6.92806,-0.67164>,<1.30683,6.93549,-0.69885>,<1.30441,6.90805,-0.6907>,
            
    /*2*/ <1.84201,6.84135,-0.80625>,<1.83839,6.84631,-0.82439>,<1.83677,6.82801,-0.81895>,
            
    /*3*/ <2.35787,6.93108,-0.98543>,<2.35453,6.93358,-0.99405>,<2.35675,6.92445,-0.99225>,
            
    /*4*/ <2.80303,7.22539,-1.12953>

    /* stem 0.20.13*/ 
    /*0*/ <1.43186,6.99404,-0.74177>,
    /*1*/ <1.4233,6.99968,-0.75396>,<1.4456,6.98646,-0.74451>,<1.42669,6.996,-0.72683>,
            
    /*2*/ <1.68909,7.46282,-0.71971>,<1.70396,7.45401,-0.71342>,<1.69136,7.46037,-0.70163>,
            
    /*3*/ <1.99049,7.88888,-0.83054>,<1.99799,7.88444,-0.8276>,<1.99302,7.88948,-0.82172>,
            
    /*4*/ <2.28382,8.33698,-0.81055>

    /* stem 0.20.14*/ 
    /*0*/ <1.58714,7.0819,-0.81025>,
    /*1*/ <1.59555,7.0699,-0.80658>,<1.59292,7.09582,-0.80908>,<1.57295,7.08,-0.81509>,
            
    /*2*/ <1.76128,7.04455,-1.29052>,<1.75952,7.06183,-1.29219>,<1.74621,7.05128,-1.29619>,
            
    /*3*/ <1.86672,7.1215,-1.78817>,<1.86547,7.13008,-1.78717>,<1.85878,7.12493,-1.78939>,
            
    /*4*/ <1.96706,7.26662,-2.26957>

    /* stem 0.20.15*/ 
    /*0*/ <1.70959,7.15119,-0.86426>,
    /*1*/ <1.70503,7.16369,-0.85856>,<1.71662,7.15114,-0.87691>,<1.70711,7.13874,-0.8573>,
            
    /*2*/ <2.13638,7.2075,-0.62166>,<2.14411,7.19914,-0.63389>,<2.13777,7.19087,-0.62082>,
            
    /*3*/ <2.47524,7.54405,-0.51413>,<2.48032,7.54087,-0.51996>,<2.48066,7.53801,-0.51211>,
            
    /*4*/ <2.77149,7.93158,-0.43919>

    /* stem 0.20.16*/ 
    /*0*/ <1.79694,7.20062,-0.90279>,
    /*1*/ <1.79591,7.19321,-0.91465>,<1.80952,7.20285,-0.89699>,<1.78541,7.2058,-0.89673>,
            
    /*2*/ <1.84288,7.59992,-1.16744>,<1.85196,7.60635,-1.15567>,<1.83588,7.60832,-1.15549>,
            
    /*3*/ <2.01575,7.89268,-1.50455>,<2.02064,7.89617,-1.49911>,<2.0132,7.89912,-1.50036>,
            
    /*4*/ <2.19414,8.29893,-1.69524>

    /* stem 0.20.17*/ 
    /*0*/ <1.92753,7.27839,-0.94986>,
    /*1*/ <1.93186,7.2767,-0.93733>,<1.92786,7.29051,-0.95545>,<1.92288,7.26796,-0.95678>,
            
    /*2*/ <2.35607,7.19272,-1.09998>,<2.3534,7.20193,-1.11206>,<2.35008,7.18689,-1.11294>,
            
    /*3*/ <2.77246,7.32851,-1.24807>,<2.76917,7.33298,-1.25342>,<2.77097,7.32567,-1.25507>,
            
    /*4*/ <3.17623,7.54427,-1.30513>

    /* stem 0.20.18*/ 
    /*0*/ <2.02131,7.33772,-0.97423>,
    /*1*/ <2.01429,7.34595,-0.98122>,<2.03312,7.33438,-0.97816>,<2.01653,7.33282,-0.96332>,
            
    /*2*/ <2.19029,7.68658,-0.74875>,<2.20284,7.67886,-0.74671>,<2.19178,7.67783,-0.73682>,
            
    /*3*/ <2.33733,8.09888,-0.66516>,<2.34418,8.09625,-0.66392>,<2.33935,8.09683,-0.6583>,
            
    /*4*/ <2.45425,8.52585,-0.72879>

    /* stem 0.20.19*/ 
    /*0*/ <2.11651,7.39793,-0.99897>,
    /*1*/ <2.12285,7.38735,-1.0003>,<2.12162,7.40753,-0.993>,<2.10505,7.39892,-1.00363>,
            
    /*2*/ <2.28545,7.53664,-1.3746>,<2.28462,7.55009,-1.36973>,<2.27357,7.54435,-1.37682>,
            
    /*3*/ <2.57703,7.78438,-1.58203>,<2.57512,7.79004,-1.57808>,<2.57181,7.78873,-1.58429>,
            
    /*4*/ <2.77287,8.11192,-1.7922>

    /* stem 0.20.20*/ 
    /*0*/ <2.22332,7.4655,-1.02674>,
    /*1*/ <2.22048,7.47342,-1.01835>,<2.22859,7.46908,-1.03676>,<2.22087,7.45399,-1.0251>,
            
    /*2*/ <2.59673,7.41641,-0.84297>,<2.60214,7.41352,-0.85524>,<2.59699,7.40345,-0.84747>,
            
    /*3*/ <2.96191,7.61977,-0.84115>,<2.96286,7.61826,-0.84777>,<2.96519,7.61401,-0.84291>,
            
    /*4*/ <3.28451,7.86002,-0.96013>

    /* stem 0.20.21*/ 
    /*0*/ <2.32057,7.52702,-1.05202>,
    /*1*/ <2.31899,7.52519,-1.06256>,<2.33054,7.52643,-1.04786>,<2.31218,7.52944,-1.04563>,
            
    /*2*/ <2.37482,7.91946,-1.13573>,<2.38252,7.92029,-1.12594>,<2.37028,7.92229,-1.12445>,
            
    /*3*/ <2.51807,8.29716,-1.17297>,<2.52155,8.2964,-1.16783>,<2.51574,8.29865,-1.16737>,
            
    /*4*/ <2.6391,8.67869,-1.10633>

    /* stem 0.20.22*/ 
    /*0*/ <2.44864,7.60804,-1.0853>,
    /*1*/ <2.45281,7.60437,-1.07822>,<2.44935,7.61687,-1.08686>,<2.44378,7.60287,-1.09083>,
            
    /*2*/ <2.76476,7.54234,-1.29736>,<2.76246,7.55068,-1.30312>,<2.75874,7.54134,-1.30577>,
            
    /*3*/ <3.10838,7.66034,-1.42799>,<3.10613,7.66437,-1.43037>,<3.10671,7.65987,-1.43289>,
            
    /*4*/ <3.39629,7.91078,-1.48873>

    /* stem 0.20.23*/ 
    /*0*/ <2.53392,7.68175,-1.0997>,
    /*1*/ <2.52858,7.68702,-1.10124>,<2.54024,7.68132,-1.10401>,<2.53294,7.6769,-1.09385>,
            
    /*2*/ <2.70181,7.92519,-0.87311>,<2.70958,7.92139,-0.87495>,<2.70472,7.91844,-0.86818>,
            
    /*3*/ <2.96872,8.18374,-0.84486>,<2.97171,8.18086,-0.84637>,<2.97095,8.18117,-0.84203>,
            
    /*4*/ <3.26886,8.37337,-0.95877>

    /* stem 0.20.24*/ 
    /*0*/ <2.59368,7.74,-1.10719>,
    /*1*/ <2.59758,7.7356,-1.11035>,<2.59601,7.74334,-1.1019>,<2.58744,7.74108,-1.10933>,
            
    /*2*/ <2.7163,8.00001,-1.32801>,<2.71525,8.00517,-1.32237>,<2.70954,8.00367,-1.32733>,
            
    /*3*/ <2.84973,8.30846,-1.4657>,<2.84882,8.31033,-1.46245>,<2.84627,8.31014,-1.46534>,
            
    /*4*/ <2.92986,8.6217,-1.62985>

    /* stem 0.20.25*/ 
    /*0*/ <2.70422,7.84777,-1.12106>,
    /*1*/ <2.70326,7.84934,-1.11656>,<2.70431,7.85092,-1.12477>,<2.7051,7.84305,-1.12186>,
            
    /*2*/ <3.03906,7.90242,-1.06494>,<3.03976,7.90347,-1.07042>,<3.04029,7.89823,-1.06848>,
            
    /*3*/ <3.25468,8.15939,-0.99406>,<3.25493,8.15995,-0.9968>,<3.25668,8.15813,-0.99557>,
            
    /*4*/ <3.32685,8.47761,-0.8872>

    /* stem 0.20.26*/ 
    /*0*/ <2.78151,7.92311,-1.13075>,
    /*1*/ <2.7805,7.92371,-1.13415>,<2.785,7.92308,-1.12989>,<2.77903,7.92255,-1.12822>,
            
    /*2*/ <2.7689,8.24854,-1.07237>,<2.7719,8.24812,-1.06953>,<2.76792,8.24777,-1.06841>,
            
    /*3*/ <2.792,8.57474,-1.02214>,<2.7935,8.57443,-1.02074>,<2.79152,8.57447,-1.02014>,
            
    /*4*/ <2.88228,8.89204,-0.99701>

    /* stem 0.20.27*/ 
    /*0*/ <2.88979,8.02866,-1.14434>,
    /*1*/ <2.89093,8.02762,-1.14339>,<2.88981,8.03047,-1.14411>,<2.88862,8.02791,-1.14551>,
            
    /*2*/ <3.10328,8.05315,-1.37142>,<3.10253,8.05505,-1.3719>,<3.10174,8.05335,-1.37283>,
            
    /*3*/ <3.32172,8.18784,-1.55021>,<3.32114,8.18871,-1.55027>,<3.32102,8.18795,-1.55098>,
            
    /*4*/ <3.46998,8.39829,-1.72793>

    /* stem 0.20.28*/ 
    /*0*/ <2.93538,8.07311,-1.15005>,
    /*1*/ <2.93466,8.07388,-1.1499>,<2.93604,8.07316,-1.1509>,<2.93546,8.0723,-1.14937>,
            
    /*2*/ <3.13676,8.23213,-0.98523>,<3.13768,8.23165,-0.9859>,<3.1373,8.23108,-0.98488>,
            
    /*3*/ <3.32421,8.43911,-0.86287>,<3.32467,8.43888,-0.8632>,<3.32455,8.43866,-0.86264>,
            
    /*4*/ <3.53684,8.65578,-0.89232>

    /* stem 0.21*/ 
    /*0*/ <0.05509,6.60135,0.00463>,
    /*1*/ <0.01521,6.6023,-0.00989>,<0.0475,6.64034,-0.01034>,<0.09028,6.62449,0.0099>,
            <0.08442,6.57666,0.02285>,<0.03803,6.56294,0.01062>,
    /*2*/ <-0.2108,6.80849,0.64927>,<-0.18496,6.83893,0.64891>,<-0.15074,6.82625,0.6651>,
            <-0.15542,6.78798,0.67546>,<-0.19254,6.777,0.66568>,
    /*3*/ <-0.43313,7.09282,1.27955>,<-0.41294,7.11479,1.27699>,<-0.38771,7.10577,1.29035>,
            <-0.3923,7.07822,1.30115>,<-0.42037,7.07022,1.29448>,
    /*4*/ <-0.63383,7.43599,1.88833>,<-0.61986,7.44992,1.88525>,<-0.60312,7.444,1.89437>,
            <-0.60675,7.42641,1.90309>,<-0.62572,7.42146,1.89936>,
    /*5*/ <-0.83631,7.81089,2.47673>,<-0.82923,7.8177,2.47492>,<-0.82094,7.81488,2.4797>,
            <-0.82289,7.80633,2.48448>,<-0.83238,7.80387,2.48264>,
    /*6*/ <-1.05952,8.24573,3.01387>

    /* stem 0.21.0*/ 
    /*0*/ <0.00622,6.64445,0.1417>,
    /*1*/ <0.02395,6.65782,0.14383>,<-0.00122,6.63291,0.15928>,<-0.00409,6.64264,0.122>,
            
    /*2*/ <-0.40837,7.19185,0.31655>,<-0.42514,7.17524,0.32686>,<-0.42706,7.18173,0.302>,
            
    /*3*/ <-0.60973,7.84135,0.49542>,<-0.61965,7.83654,0.50209>,<-0.6211,7.83953,0.48964>,
            
    /*4*/ <-0.90069,8.45954,0.68649>

    /* stem 0.21.1*/ 
    /*0*/ <-0.02069,6.66819,0.21718>,
    /*1*/ <-0.02681,6.64757,0.22148>,<-0.03423,6.68482,0.22175>,<-0.00104,6.67217,0.2083>,
            
    /*2*/ <0.25341,6.70529,0.85863>,<0.24846,6.73012,0.85881>,<0.27059,6.72169,0.84984>,
            
    /*3*/ <0.43586,6.82336,1.52293>,<0.43284,6.83559,1.52171>,<0.44462,6.83169,1.51917>,
            
    /*4*/ <0.54172,6.96424,2.19876>

    /* stem 0.21.2*/ 
    /*0*/ <-0.05771,6.70084,0.321>,
    /*1*/ <-0.06559,6.71885,0.31253>,<-0.0456,6.70171,0.33864>,<-0.06194,6.68196,0.31184>,
            
    /*2*/ <-0.62355,6.65012,0.70329>,<-0.61022,6.6387,0.7207>,<-0.62111,6.62553,0.70283>,
            
    /*3*/ <-1.09804,6.76391,1.18091>,<-1.091,6.75832,1.18939>,<-1.09917,6.75175,1.18283>,
            
    /*4*/ <-1.35078,6.96376,1.7856>

    /* stem 0.21.3*/ 
    /*0*/ <-0.09154,6.73068,0.41588>,
    /*1*/ <-0.0739,6.72337,0.42447>,<-0.11,6.72673,0.42493>,<-0.09072,6.74193,0.39824>,
            
    /*2*/ <-0.0228,7.28904,0.78368>,<-0.04687,7.29128,0.78399>,<-0.03401,7.30142,0.7662>,
            
    /*3*/ <-0.07612,7.81855,1.19588>,<-0.08817,7.81826,1.19487>,<-0.08161,7.8249,1.18719>,
            
    /*4*/ <-0.3178,8.13601,1.73713>

    /* stem 0.21.4*/ 
    /*0*/ <-0.12511,6.76029,0.51005>,
    /*1*/ <-0.14401,6.75401,0.50528>,<-0.12246,6.77739,0.52098>,<-0.10887,6.74947,0.50387>,
            
    /*2*/ <-0.16081,6.40347,1.06368>,<-0.14645,6.41905,1.07415>,<-0.13739,6.40044,1.06273>,
            
    /*3*/ <-0.44477,6.47306,1.6523>,<-0.43678,6.48124,1.65531>,<-0.43473,6.46983,1.65763>,
            
    /*4*/ <-0.89096,6.7355,2.0581>

    /* stem 0.21.5*/ 
    /*0*/ <-0.16382,6.79443,0.61859>,
    /*1*/ <-0.15242,6.81076,0.61752>,<-0.16453,6.78387,0.63549>,<-0.17449,6.78866,0.60277>,
            
    /*2*/ <-0.6519,7.16453,0.82129>,<-0.65998,7.1466,0.83326>,<-0.66661,7.1498,0.81145>,
            
    /*3*/ <-1.07979,7.43968,1.2191>,<-1.08201,7.42947,1.22393>,<-1.08817,7.433,1.21487>,
            
    /*4*/ <-1.39471,7.72199,1.70534>

    /* stem 0.21.6*/ 
    /*0*/ <-0.20719,6.84269,0.73796>,
    /*1*/ <-0.20696,6.82511,0.74602>,<-0.22265,6.85409,0.74008>,<-0.19195,6.84886,0.7278>,
            
    /*2*/ <0.04359,7.07382,1.26632>,<0.03313,7.09314,1.26236>,<0.0536,7.08965,1.25417>,
            
    /*3*/ <0.31517,7.47904,1.6692>,<0.30891,7.48737,1.66519>,<0.31887,7.48519,1.66066>,
            
    /*4*/ <0.38615,7.9326,2.09951>

    /* stem 0.21.7*/ 
    /*0*/ <-0.24318,6.88715,0.83601>,
    /*1*/ <-0.25483,6.89855,0.82657>,<-0.23365,6.89366,0.85089>,<-0.24107,6.86925,0.83058>,
            
    /*2*/ <-0.71364,6.72787,1.19909>,<-0.69952,6.72462,1.2153>,<-0.70446,6.70834,1.20176>,
            
    /*3*/ <-1.17919,6.98149,1.49889>,<-1.17385,6.98037,1.5083>,<-1.1804,6.97244,1.50479>,
            
    /*4*/ <-1.45573,7.38467,1.87253>

    /* stem 0.21.8*/ 
    /*0*/ <-0.28458,6.93829,0.94878>,
    /*1*/ <-0.26749,6.93797,0.9552>,<-0.29861,6.93504,0.96>,<-0.28764,6.94188,0.93114>,
            
    /*2*/ <-0.309,7.52324,1.07812>,<-0.32974,7.52128,1.08132>,<-0.32243,7.52584,1.06208>,
            
    /*3*/ <-0.39968,8.07489,1.29522>,<-0.40994,8.07281,1.29646>,<-0.40646,8.07695,1.28741>,
            
    /*4*/ <-0.48569,8.53354,1.67055>

    /* stem 0.21.9*/ 
    /*0*/ <-0.32938,6.99364,1.07081>,
    /*1*/ <-0.34376,6.98345,1.07015>,<-0.33069,7.01041,1.0761>,<-0.31368,6.98705,1.06618>,
            
    /*2*/ <-0.24642,6.82056,1.6209>,<-0.23771,6.83853,1.62486>,<-0.22637,6.82296,1.61825>,
            
    /*3*/ <-0.34844,7.08323,2.13261>,<-0.34361,7.09159,2.12938>,<-0.33843,7.08426,2.13418>,
            
    /*4*/ <-0.45346,7.36591,2.63111>

    /* stem 0.21.10*/ 
    /*0*/ <-0.37602,7.05127,1.19788>,
    /*1*/ <-0.3707,7.06661,1.19288>,<-0.37279,7.04588,1.21368>,<-0.38458,7.0413,1.18709>,
            
    /*2*/ <-0.85882,7.28795,1.37127>,<-0.86021,7.27413,1.38513>,<-0.86807,7.27108,1.36741>,
            
    /*3*/ <-1.23367,7.63054,1.61277>,<-1.23486,7.62418,1.62014>,<-1.24055,7.62357,1.61217>,
            
    /*4*/ <-1.60103,7.96318,1.88416>

    /* stem 0.21.11*/ 
    /*0*/ <-0.43328,7.13185,1.35817>,
    /*1*/ <-0.42821,7.11929,1.36704>,<-0.44671,7.13984,1.3624>,<-0.42493,7.13641,1.34509>,
            
    /*2*/ <-0.13386,7.45905,1.67025>,<-0.14619,7.47275,1.66716>,<-0.13166,7.47047,1.65562>,
            
    /*3*/ <0.06571,7.93119,1.85867>,<0.05825,7.93574,1.85537>,<0.06582,7.93468,1.85>,
            
    /*4*/ <0.16623,8.41402,2.08457>

    /* stem 0.21.12*/ 
    /*0*/ <-0.47008,7.19239,1.46501>,
    /*1*/ <-0.48293,7.19748,1.4577>,<-0.46158,7.20226,1.47367>,<-0.46572,7.17743,1.46366>,
            
    /*2*/ <-0.76779,7.07348,1.8832>,<-0.75356,7.07667,1.89385>,<-0.75633,7.06012,1.88718>,
            
    /*3*/ <-0.8972,7.19844,2.38008>,<-0.88854,7.20016,2.38198>,<-0.89188,7.19186,2.38321>,
            
    /*4*/ <-1.0613,7.51479,2.76642>

    /* stem 0.21.13*/ 
    /*0*/ <-0.50273,7.24612,1.55981>,
    /*1*/ <-0.4884,7.25031,1.56236>,<-0.51116,7.24065,1.57115>,<-0.50863,7.24738,1.54591>,
            
    /*2*/ <-0.65213,7.72414,1.67218>,<-0.66731,7.7177,1.67804>,<-0.66562,7.72218,1.66121>,
            
    /*3*/ <-0.91058,8.15959,1.76728>,<-0.91764,8.15498,1.76963>,<-0.91658,8.15742,1.76129>,
            
    /*4*/ <-1.14624,8.57155,1.96172>

    /* stem 0.21.14*/ 
    /*0*/ <-0.53252,7.29513,1.6463>,
    /*1*/ <-0.54175,7.2841,1.64937>,<-0.53661,7.30905,1.64876>,<-0.5192,7.29225,1.64077>,
            
    /*2*/ <-0.35186,7.26077,2.11214>,<-0.34843,7.2774,2.11173>,<-0.33682,7.2662,2.1064>,
            
    /*3*/ <-0.20588,7.42386,2.565>,<-0.20505,7.43175,2.56197>,<-0.19845,7.42641,2.56177>,
            
    /*4*/ <-0.23577,7.7156,2.97104>

    /* stem 0.21.15*/ 
    /*0*/ <-0.56677,7.3515,1.74576>,
    /*1*/ <-0.56656,7.36389,1.73882>,<-0.56118,7.35056,1.75879>,<-0.57258,7.34005,1.73968>,
            
    /*2*/ <-0.99766,7.47571,1.93443>,<-0.99407,7.46682,1.94774>,<-1.00167,7.45981,1.93501>,
            
    /*3*/ <-1.35589,7.78554,2.02394>,<-1.35653,7.78267,2.03159>,<-1.36096,7.77929,2.02557>,
            
    /*4*/ <-1.61548,8.12515,2.25677>

    /* stem 0.21.16*/ 
    /*0*/ <-0.60465,7.41383,1.85574>,
    /*1*/ <-0.5964,7.40582,1.86311>,<-0.61725,7.4166,1.8602>,<-0.6003,7.41905,1.8439>,
            
    /*2*/ <-0.43531,7.78665,2.08779>,<-0.44921,7.79383,2.08585>,<-0.43791,7.79547,2.07498>,
            
    /*3*/ <-0.49996,8.2198,2.26978>,<-0.50719,8.22009,2.26666>,<-0.50102,8.22274,2.26254>,
            
    /*4*/ <-0.77336,8.5365,2.48671>

    /* stem 0.21.17*/ 
    /*0*/ <-0.63968,7.47445,1.95479>,
    /*1*/ <-0.652,7.47469,1.9502>,<-0.63414,7.48547,1.95936>,<-0.63289,7.46319,1.95481>,
            
    /*2*/ <-0.80517,7.38052,2.36929>,<-0.79326,7.3877,2.37539>,<-0.79243,7.37285,2.37236>,
            
    /*3*/ <-0.99578,7.45113,2.77661>,<-0.98953,7.45473,2.77898>,<-0.9902,7.44723,2.77997>,
            
    /*4*/ <-1.14455,7.72716,3.10772>

    /* stem 0.21.18*/ 
    /*0*/ <-0.68869,7.56181,2.09115>,
    /*1*/ <-0.67819,7.56848,2.09064>,<-0.69362,7.55878,2.10217>,<-0.69426,7.55816,2.08063>,
            
    /*2*/ <-0.91558,7.93385,2.08702>,<-0.92586,7.92738,2.09471>,<-0.92629,7.92697,2.08034>,
            
    /*3*/ <-1.14735,8.27121,2.23735>,<-1.15167,8.26673,2.24093>,<-1.15327,8.26864,2.23419>,
            
    /*4*/ <-1.25543,8.60862,2.48939>

    /* stem 0.21.19*/ 
    /*0*/ <-0.72993,7.63532,2.20589>,
    /*1*/ <-0.73414,7.62535,2.21076>,<-0.73632,7.64531,2.20635>,<-0.71933,7.6353,2.20056>,
            
    /*2*/ <-0.54999,7.72893,2.57217>,<-0.55144,7.74224,2.56923>,<-0.54012,7.73556,2.56537>,
            
    /*3*/ <-0.45762,7.94922,2.91763>,<-0.45892,7.95507,2.91431>,<-0.45259,7.95245,2.91429>,
            
    /*4*/ <-0.42311,8.30636,3.13619>

    /* stem 0.21.20*/ 
    /*0*/ <-0.76209,7.69264,2.29536>,
    /*1*/ <-0.76544,7.70102,2.28879>,<-0.75632,7.6948,2.30467>,<-0.76452,7.68209,2.29262>,
            
    /*2*/ <-1.11076,7.72371,2.49979>,<-1.10468,7.71957,2.51037>,<-1.11015,7.7111,2.50234>,
            
    /*3*/ <-1.32991,7.96177,2.74063>,<-1.32651,7.95981,2.74574>,<-1.33185,7.95664,2.74401>,
            
    /*4*/ <-1.4567,8.26768,2.97375>

    /* stem 0.21.21*/ 
    /*0*/ <-0.80256,7.76476,2.40794>,
    /*1*/ <-0.7948,7.76181,2.41262>,<-0.81115,7.76405,2.41201>,<-0.80173,7.76844,2.39918>,
            
    /*2*/ <-0.75443,8.11742,2.56389>,<-0.76532,8.11891,2.56349>,<-0.75905,8.12184,2.55494>,
            
    /*3*/ <-0.84077,8.46891,2.70983>,<-0.8461,8.46809,2.70874>,<-0.84285,8.47045,2.70497>,
            
    /*4*/ <-0.99339,8.78696,2.87343>

    /* stem 0.21.22*/ 
    /*0*/ <-0.85487,7.86063,2.54097>,
    /*1*/ <-0.86195,7.85848,2.53967>,<-0.85335,7.86785,2.54244>,<-0.84931,7.85558,2.54082>,
            
    /*2*/ <-0.90678,7.79627,2.89944>,<-0.90104,7.80251,2.90129>,<-0.89835,7.79433,2.90021>,
            
    /*3*/ <-0.9041,7.84419,3.26522>,<-0.90116,7.84735,3.26481>,<-0.89987,7.84324,3.26534>,
            
    /*4*/ <-0.86635,8.0973,3.5304>

    /* stem 0.21.23*/ 
    /*0*/ <-0.8824,7.91244,2.60459>,
    /*1*/ <-0.87816,7.917,2.60272>,<-0.88362,7.91153,2.61092>,<-0.88544,7.9088,2.60014>,
            
    /*2*/ <-1.1441,8.15536,2.5871>,<-1.14774,8.15171,2.59257>,<-1.14896,8.14989,2.58538>,
            
    /*3*/ <-1.31634,8.42372,2.74782>,<-1.3176,8.42136,2.75045>,<-1.31961,8.42194,2.74733>,
            
    /*4*/ <-1.46288,8.73488,2.84373>

    /* stem 0.21.24*/ 
    /*0*/ <-0.92915,8.00041,2.71262>,
    /*1*/ <-0.92943,7.99664,2.71556>,<-0.93298,8.0032,2.71193>,<-0.92504,8.00138,2.71036>,
            
    /*2*/ <-0.83335,8.1943,2.97477>,<-0.83572,8.19867,2.97235>,<-0.83043,8.19746,2.97131>,
            
    /*3*/ <-0.92155,8.38162,3.24396>,<-0.9227,8.3835,3.24229>,<-0.92004,8.38373,3.243>,
            
    /*4*/ <-0.99854,8.57593,3.51196>

    /* stem 0.21.25*/ 
    /*0*/ <-0.96688,8.07139,2.79979>,
    /*1*/ <-0.96879,8.07311,2.79756>,<-0.96536,8.07304,2.80235>,<-0.96647,8.06803,2.79945>,
            
    /*2*/ <-1.23007,8.02222,2.98508>,<-1.22778,8.02217,2.98827>,<-1.22852,8.01883,2.98634>,
            
    /*3*/ <-1.40745,8.19354,3.19717>,<-1.40597,8.19348,3.19846>,<-1.40733,8.19207,3.19847>,
            
    /*4*/ <-1.4413,8.42845,3.42032>

    /* stem 0.21.26*/ 
    /*0*/ <-1.00456,8.14231,2.88687>,
    /*1*/ <-1.0027,8.14234,2.88766>,<-1.00616,8.14205,2.88808>,<-1.00483,8.14254,2.88489>,
            
    /*2*/ <-1.02426,8.45059,2.92613>,<-1.02657,8.45039,2.92641>,<-1.02568,8.45072,2.92428>,
            
    /*3*/ <-1.01439,8.73956,3.04104>,<-1.01554,8.73952,3.04122>,<-1.01512,8.73991,3.04021>,
            
    /*4*/ <-1.03793,9.03034,3.1501>

    /* stem 0.21.27*/ 
    /*0*/ <-1.03298,8.19578,2.95254>,
    /*1*/ <-1.03381,8.19527,2.9526>,<-1.03301,8.19676,2.95257>,<-1.03213,8.19532,2.95245>,
            
    /*2*/ <-1.00634,8.18606,3.25187>,<-1.00581,8.18705,3.25185>,<-1.00522,8.18609,3.25177>,
            
    /*3*/ <-1.06516,8.33268,3.50772>,<-1.06487,8.33312,3.50753>,<-1.0646,8.33272,3.50782>,
            
    /*4*/ <-1.1441,8.54881,3.7013>

    /* stem 0.22*/ 
    /*0*/ <0.05887,6.7647,0.00495>,
    /*1*/ <0.09814,6.76382,-0.00935>,<0.07605,6.80214,0.01207>,<0.03022,6.78872,0.02365>,
            <0.02398,6.74211,0.00938>,<0.06596,6.72673,-0.01101>,
    /*2*/ <-0.13803,6.99077,-0.64756>,<-0.1557,7.02142,-0.63043>,<-0.19236,7.01069,-0.62117>,
            <-0.19735,6.9734,-0.63258>,<-0.16377,6.96109,-0.64889>,
    /*3*/ <-0.34274,7.30314,-1.25901>,<-0.35516,7.32516,-1.24384>,<-0.38323,7.31788,-1.23855>,
            <-0.38816,7.29136,-1.25044>,<-0.36313,7.28225,-1.26309>,
    /*4*/ <-0.52091,7.70478,-1.8257>,<-0.52862,7.71839,-1.8138>,<-0.54761,7.71409,-1.81116>,
            <-0.55164,7.69781,-1.82142>,<-0.53513,7.69206,-1.83041>,
    /*5*/ <-0.62258,8.1302,-2.39216>,<-0.62641,8.13714,-2.38635>,<-0.63612,8.13567,-2.38585>,
            <-0.63829,8.12782,-2.39135>,<-0.62992,8.12445,-2.39525>,
    /*6*/ <-0.73489,8.59328,-2.92872>

    /* stem 0.22.0*/ 
    /*0*/ <0.01371,6.80956,-0.12185>,
    /*1*/ <-0.00032,6.82332,-0.11198>,<0.00746,6.79846,-0.13979>,<0.03401,6.80688,-0.11378>,
            
    /*2*/ <0.23404,7.34254,-0.51932>,<0.23923,7.32597,-0.53786>,<0.25693,7.33158,-0.52052>,
            
    /*3*/ <0.38196,7.92025,-0.88201>,<0.38481,7.91325,-0.89222>,<0.39386,7.91621,-0.88382>,
            
    /*4*/ <0.4599,8.38001,-1.40589>

    /* stem 0.22.1*/ 
    /*0*/ <-0.02678,6.84978,-0.23555>,
    /*1*/ <-0.02596,6.82968,-0.24294>,<-0.02066,6.86606,-0.24806>,<-0.03371,6.85359,-0.21564>,
            
    /*2*/ <-0.66697,6.89676,-0.47511>,<-0.66344,6.921,-0.47852>,<-0.67214,6.91269,-0.45691>,
            
    /*3*/ <-1.13685,7.20137,-0.87541>,<-1.13101,7.21221,-0.87419>,<-1.13989,7.20904,-0.86619>,
            
    /*4*/ <-1.34225,7.54951,-1.42846>

    /* stem 0.22.2*/ 
    /*0*/ <-0.05617,6.87897,-0.31808>,
    /*1*/ <-0.04399,6.89601,-0.31639>,<-0.07541,6.88059,-0.32638>,<-0.04912,6.86032,-0.31147>,
            
    /*2*/ <0.20607,6.76936,-0.9293>,<0.18512,6.75908,-0.93596>,<0.20265,6.74556,-0.92602>,
            
    /*3*/ <0.33035,7.01192,-1.54053>,<0.31991,7.00729,-1.5446>,<0.33008,7.00071,-1.54514>,
            
    /*4*/ <0.43085,7.55255,-1.92465>

    /* stem 0.22.3*/ 
    /*0*/ <-0.08725,6.90984,-0.40534>,
    /*1*/ <-0.10631,6.90357,-0.40077>,<-0.07868,6.90448,-0.42326>,<-0.07677,6.92147,-0.392>,
            
    /*2*/ <-0.34706,7.45165,-0.68401>,<-0.32864,7.45225,-0.699>,<-0.32737,7.46358,-0.67816>,
            
    /*3*/ <-0.56734,7.98555,-1.00907>,<-0.55785,7.98525,-1.0162>,<-0.55751,7.99153,-1.00613>,
            
    /*4*/ <-0.84431,8.51458,-1.2939>

    /* stem 0.22.4*/ 
    /*0*/ <-0.12486,6.9472,-0.51095>,
    /*1*/ <-0.10804,6.9403,-0.51938>,<-0.13064,6.96612,-0.51415>,<-0.13591,6.93517,-0.49932>,
            
    /*2*/ <-0.45194,6.75161,-1.03525>,<-0.46701,6.76883,-1.03176>,<-0.47052,6.74819,-1.02188>,
            
    /*3*/ <-0.72045,6.85671,-1.61588>,<-0.72669,6.86544,-1.61154>,<-0.73097,6.85469,-1.6115>,
            
    /*4*/ <-0.7466,7.14549,-2.19385>

    /* stem 0.22.5*/ 
    /*0*/ <-0.15945,6.98155,-0.60806>,
    /*1*/ <-0.16649,6.99782,-0.5998>,<-0.17017,6.97185,-0.62123>,<-0.14169,6.97498,-0.60315>,
            
    /*2*/ <0.09309,7.33981,-1.0677>,<0.09064,7.32249,-1.08199>,<0.10962,7.32457,-1.06993>,
            
    /*3*/ <0.21476,7.72774,-1.55336>,<0.21342,7.71921,-1.56064>,<0.22363,7.72141,-1.55633>,
            
    /*4*/ <0.1341,8.19688,-1.97094>

    /* stem 0.22.6*/ 
    /*0*/ <-0.18074,7.00939,-0.67137>,
    /*1*/ <-0.18707,6.99245,-0.67795>,<-0.17062,7.02101,-0.6829>,<-0.18452,7.0147,-0.65327>,
            
    /*2*/ <-0.71551,7.27066,-0.86673>,<-0.70454,7.2897,-0.87003>,<-0.71381,7.28549,-0.85028>,
            
    /*3*/ <-1.12329,7.66014,-1.14433>,<-1.11559,7.66814,-1.14464>,<-1.12236,7.66728,-1.13588>,
            
    /*4*/ <-1.40069,8.18084,-1.36021>

    /* stem 0.22.7*/ 
    /*0*/ <-0.23501,7.09545,-0.84072>,
    /*1*/ <-0.21971,7.10562,-0.84046>,<-0.25109,7.10318,-0.84508>,<-0.23422,7.07756,-0.83662>,
            
    /*2*/ <-0.12919,6.9733,-1.42136>,<-0.15011,6.97168,-1.42444>,<-0.13886,6.9546,-1.4188>,
            
    /*3*/ <-0.11207,7.03966,-2.01907>,<-0.12264,7.03899,-2.01954>,<-0.11674,7.03022,-2.02035>,
            
    /*4*/ <-0.35619,7.34094,-2.48135>

    /* stem 0.22.8*/ 
    /*0*/ <-0.27584,7.16021,-0.96813>,
    /*1*/ <-0.29262,7.16078,-0.96246>,<-0.27237,7.15732,-0.98527>,<-0.26253,7.16252,-0.95666>,
            
    /*2*/ <-0.30098,7.73659,-1.06418>,<-0.28748,7.73428,-1.07939>,<-0.28092,7.73774,-1.06032>,
            
    /*3*/ <-0.44419,8.25914,-1.27931>,<-0.43759,8.25787,-1.28702>,<-0.43451,8.26229,-1.27833>,
            
    /*4*/ <-0.66157,8.68909,-1.61013>

    /* stem 0.22.9*/ 
    /*0*/ <-0.31609,7.22403,-1.09372>,
    /*1*/ <-0.30553,7.21373,-1.10234>,<-0.31606,7.24083,-1.09684>,<-0.32666,7.21754,-1.08198>,
            
    /*2*/ <-0.70605,7.14369,-1.49781>,<-0.71307,7.16176,-1.49414>,<-0.72013,7.14623,-1.48424>,
            
    /*3*/ <-0.95953,7.3555,-1.96001>,<-0.9612,7.36401,-1.9553>,<-0.9679,7.35678,-1.95494>,
            
    /*4*/ <-0.93831,7.7832,-2.33216>

    /* stem 0.22.10*/ 
    /*0*/ <-0.34006,7.26206,-1.16855>,
    /*1*/ <-0.34006,7.27695,-1.16098>,<-0.3533,7.25727,-1.17754>,<-0.32684,7.25196,-1.16712>,
            
    /*2*/ <-0.11489,7.50256,-1.61742>,<-0.12372,7.48943,-1.62847>,<-0.10608,7.48589,-1.62151>,
            
    /*3*/ <-0.0964,7.82144,-2.07133>,<-0.10118,7.81474,-2.07633>,<-0.09154,7.81458,-2.07605>,
            
    /*4*/ <-0.11927,8.21909,-2.45881>

    /* stem 0.22.11*/ 
    /*0*/ <-0.37811,7.33136,-1.28986>,
    /*1*/ <-0.38859,7.32014,-1.29463>,<-0.36699,7.33684,-1.3001>,<-0.37874,7.33709,-1.27485>,
            
    /*2*/ <-0.72475,7.71026,-1.4548>,<-0.71035,7.72139,-1.45845>,<-0.71818,7.72156,-1.44161>,
            
    /*3*/ <-1.01001,8.05421,-1.7553>,<-1.00239,8.05928,-1.75688>,<-1.0078,8.06117,-1.74957>,
            
    /*4*/ <-1.24697,8.43068,-2.06113>

    /* stem 0.22.12*/ 
    /*0*/ <-0.41414,7.41631,-1.41037>,
    /*1*/ <-0.39929,7.42012,-1.41213>,<-0.42505,7.42718,-1.41128>,<-0.41808,7.40163,-1.40771>,
            
    /*2*/ <-0.44375,7.33636,-1.92451>,<-0.46093,7.34107,-1.92395>,<-0.45628,7.32404,-1.92157>,
            
    /*3*/ <-0.63649,7.47489,-2.39046>,<-0.64423,7.47713,-2.38667>,<-0.64297,7.46884,-2.38967>,
            
    /*4*/ <-0.83587,7.7491,-2.78609>

    /* stem 0.22.13*/ 
    /*0*/ <-0.43567,7.46707,-1.48237>,
    /*1*/ <-0.44804,7.47187,-1.47528>,<-0.43672,7.46119,-1.49618>,<-0.42226,7.46813,-1.47564>,
            
    /*2*/ <-0.37947,7.93423,-1.6798>,<-0.37192,7.92712,-1.69373>,<-0.36228,7.93174,-1.68004>,
            
    /*3*/ <-0.35765,8.27432,-2.06172>,<-0.35395,8.26839,-2.06688>,<-0.349,8.27358,-2.06198>,
            
    /*4*/ <-0.57623,8.55375,-2.42596>

    /* stem 0.22.14*/ 
    /*0*/ <-0.45886,7.52174,-1.55992>,
    /*1*/ <-0.45451,7.51097,-1.56882>,<-0.4547,7.53552,-1.56254>,<-0.46738,7.51873,-1.54842>,
            
    /*2*/ <-0.8612,7.58366,-1.84775>,<-0.86132,7.60003,-1.84357>,<-0.86978,7.58884,-1.83415>,
            
    /*3*/ <-1.15909,7.90108,-2.0972>,<-1.15624,7.90752,-2.09253>,<-1.16301,7.90315,-2.09001>,
            
    /*4*/ <-1.33698,8.29397,-2.34781>

    /* stem 0.22.15*/ 
    /*0*/ <-0.49299,7.6022,-1.67406>,
    /*1*/ <-0.48785,7.61354,-1.66761>,<-0.5047,7.60319,-1.68172>,<-0.48643,7.58987,-1.67287>,
            
    /*2*/ <-0.22622,7.7121,-2.0593>,<-0.23746,7.70521,-2.0687>,<-0.22527,7.69632,-2.0628>,
            
    /*3*/ <0.03189,7.96725,-2.37046>,<0.02726,7.96462,-2.37655>,<0.03389,7.96049,-2.37443>,
            
    /*4*/ <0.07386,8.35969,-2.64446>

    /* stem 0.22.16*/ 
    /*0*/ <-0.52844,7.68577,-1.79262>,
    /*1*/ <-0.53996,7.67904,-1.79392>,<-0.5212,7.68882,-1.80347>,<-0.52418,7.68946,-1.78046>,
            
    /*2*/ <-0.76563,8.08163,-1.83451>,<-0.75312,8.08815,-1.84088>,<-0.75511,8.08858,-1.82554>,
            
    /*3*/ <-0.8376,8.46914,-2.08185>,<-0.83009,8.46946,-2.08365>,<-0.83271,8.47303,-2.0773>,
            
    /*4*/ <-0.85693,8.82671,-2.37629>

    /* stem 0.22.17*/ 
    /*0*/ <-0.54515,7.74335,-1.87126>,
    /*1*/ <-0.53259,7.74202,-1.87432>,<-0.55095,7.7549,-1.87252>,<-0.55189,7.73312,-1.86694>,
            
    /*2*/ <-0.6511,7.63872,-2.29748>,<-0.66334,7.6473,-2.29628>,<-0.66397,7.63279,-2.29256>,
            
    /*3*/ <-0.73573,7.80947,-2.70668>,<-0.74136,7.81356,-2.70388>,<-0.74267,7.80665,-2.70649>,
            
    /*4*/ <-0.71344,8.1268,-3.02605>

    /* stem 0.22.18*/ 
    /*0*/ <-0.56173,7.81854,-1.9719>,
    /*1*/ <-0.56919,7.82591,-1.96516>,<-0.56521,7.81491,-1.9833>,<-0.5508,7.8148,-1.96723>,
            
    /*2*/ <-0.37342,8.17519,-2.13827>,<-0.37077,8.16785,-2.15037>,<-0.36116,8.16778,-2.13965>,
            
    /*3*/ <-0.25488,8.49147,-2.4152>,<-0.25405,8.48663,-2.42046>,<-0.2485,8.48829,-2.41619>,
            
    /*4*/ <-0.13456,8.71185,-2.77311>

    /* stem 0.22.19*/ 
    /*0*/ <-0.5857,7.92722,-2.11737>,
    /*1*/ <-0.58629,7.9178,-2.12431>,<-0.57904,7.93636,-2.12043>,<-0.59179,7.92751,-2.10736>,
            
    /*2*/ <-0.90774,8.08836,-2.32222>,<-0.90291,8.10073,-2.31964>,<-0.91141,8.09483,-2.31092>,
            
    /*3*/ <-1.15277,8.25464,-2.61045>,<-1.15025,8.26078,-2.60913>,<-1.15569,8.25856,-2.60578>,
            
    /*4*/ <-1.23751,8.53527,-2.90433>

    /* stem 0.22.20*/ 
    /*0*/ <-0.60566,8.01768,-2.23844>,
    /*1*/ <-0.59852,8.02446,-2.23455>,<-0.61533,8.0211,-2.24104>,<-0.60312,8.00748,-2.23973>,
            
    /*2*/ <-0.47471,8.09989,-2.603>,<-0.48592,8.09765,-2.60733>,<-0.47778,8.08858,-2.60645>,
            
    /*3*/ <-0.40256,8.31123,-2.92849>,<-0.40822,8.31014,-2.9305>,<-0.40368,8.30633,-2.93197>,
            
    /*4*/ <-0.34258,8.64957,-3.12282>

    /* stem 0.22.21*/ 
    /*0*/ <-0.61992,8.08232,-2.32497>,
    /*1*/ <-0.62908,8.08067,-2.32469>,<-0.61522,8.08121,-2.33293>,<-0.61545,8.08509,-2.31727>,
            
    /*2*/ <-0.6946,8.44659,-2.41633>,<-0.68536,8.44695,-2.42183>,<-0.68551,8.44954,-2.41139>,
            
    /*3*/ <-0.60761,8.77626,-2.59565>,<-0.60291,8.7742,-2.59723>,<-0.60325,8.77683,-2.59255>,
            
    /*4*/ <-0.59376,9.10881,-2.78367>

    /* stem 0.22.22*/ 
    /*0*/ <-0.63562,8.15303,-2.41579>,
    /*1*/ <-0.62903,8.15034,-2.41937>,<-0.63671,8.16085,-2.41482>,<-0.64111,8.14789,-2.41317>,
            
    /*2*/ <-0.80207,8.16762,-2.74473>,<-0.80719,8.17462,-2.7417>,<-0.81012,8.16598,-2.7406>,
            
    /*3*/ <-0.80425,8.37156,-3.05093>,<-0.80668,8.37482,-3.04878>,<-0.80885,8.37144,-3.05101>,
            
    /*4*/ <-0.76773,8.65627,-3.28287>

    /* stem 0.22.23*/ 
    /*0*/ <-0.66011,8.26164,-2.54234>,
    /*1*/ <-0.66182,8.26584,-2.5384>,<-0.6627,8.26136,-2.54774>,<-0.65581,8.25772,-2.54086>,
            
    /*2*/ <-0.41974,8.48157,-2.66662>,<-0.42033,8.47859,-2.67284>,<-0.41574,8.47616,-2.66826>,
            
    /*3*/ <-0.24581,8.77902,-2.70893>,<-0.24555,8.77841,-2.71232>,<-0.24309,8.77728,-2.71017>,
            
    /*4*/ <-0.14568,9.11248,-2.70509>

    /* stem 0.22.24*/ 
    /*0*/ <-0.67481,8.32685,-2.61831>,
    /*1*/ <-0.6767,8.32331,-2.62098>,<-0.67117,8.32949,-2.62003>,<-0.67657,8.32775,-2.61392>,
            
    /*2*/ <-0.89615,8.54184,-2.75268>,<-0.89247,8.54596,-2.75205>,<-0.89607,8.5448,-2.74797>,
            
    /*3*/ <-1.03717,8.73715,-2.98709>,<-1.03521,8.73909,-2.98668>,<-1.03757,8.73915,-2.9852>,
            
    /*4*/ <-1.10162,8.96188,-3.22947>

    /* stem 0.22.25*/ 
    /*0*/ <-0.69253,8.40541,-2.70984>,
    /*1*/ <-0.68952,8.40686,-2.70918>,<-0.6953,8.40734,-2.71019>,<-0.69275,8.40203,-2.71015>,
            
    /*2*/ <-0.63306,8.43119,-3.02516>,<-0.63691,8.43151,-3.02584>,<-0.63522,8.42798,-3.02581>,
            
    /*3*/ <-0.5082,8.58296,-3.27899>,<-0.51,8.58326,-3.2797>,<-0.50901,8.58164,-3.28018>,
            
    /*4*/ <-0.54703,8.81364,-3.50055>

    /* stem 0.22.26*/ 
    /*0*/ <-0.71168,8.49036,-2.80882>,
    /*1*/ <-0.71347,8.49051,-2.80834>,<-0.71121,8.4901,-2.8106>,<-0.71036,8.49047,-2.80751>,
            
    /*2*/ <-0.69786,8.79345,-2.84925>,<-0.69635,8.79318,-2.85076>,<-0.69578,8.79342,-2.8487>,
            
    /*3*/ <-0.67818,9.09603,-2.89123>,<-0.67742,9.09588,-2.89198>,<-0.67714,9.096,-2.89095>,
            
    /*4*/ <-0.64898,9.4005,-2.88>

    /* stem 0.22.27*/ 
    /*0*/ <-0.72215,8.53681,-2.86293>,
    /*1*/ <-0.72155,8.53624,-2.86353>,<-0.72215,8.53782,-2.86301>,<-0.72276,8.53635,-2.86225>,
            
    /*2*/ <-0.93809,8.52147,-3.0669>,<-0.93849,8.52252,-3.06655>,<-0.9389,8.52154,-3.06605>,
            
    /*3*/ <-1.14682,8.67926,-3.20895>,<-1.14676,8.6797,-3.20855>,<-1.14715,8.67926,-3.20846>,
            
    /*4*/ <-1.28547,8.90456,-3.34496>

    /* stem 0.23*/ 
    /*0*/ <0.06126,6.86777,0.00515>,
    /*1*/ <0.04057,6.86817,0.04099>,<0.04465,6.90538,0.0099>,<0.07169,6.8906,-0.02776>,
            <0.08431,6.84427,-0.01994>,<0.06508,6.83041,0.02255>,
    /*2*/ <0.63257,7.08504,0.37066>,<0.63584,7.1148,0.34579>,<0.65746,7.10298,0.31567>,
            <0.66756,7.06591,0.32192>,<0.65217,7.05482,0.35591>,
    /*3*/ <1.19226,7.37113,0.70212>,<1.19305,7.39276,0.68253>,<1.2106,7.38453,0.6607>,
            <1.22065,7.35781,0.66679>,<1.20932,7.34953,0.69239>,
    /*4*/ <1.63858,7.82399,1.01777>,<1.63647,7.83655,1.00305>,<1.65016,7.83263,0.98979>,
            <1.66074,7.81765,0.99631>,<1.65358,7.81232,1.0136>,
    /*5*/ <1.99668,8.32204,1.37439>,<1.9955,8.32827,1.36701>,<2.00308,8.32728,1.36099>,
            <2.00895,8.32044,1.36465>,<2.005,8.3172,1.37293>,
    /*6*/ <2.2858,8.8882,1.6937>

    /* stem 0.23.0*/ 
    /*0*/ <0.16132,6.90469,0.06248>,
    /*1*/ <0.16604,6.91791,0.04571>,<0.17709,6.89269,0.07173>,<0.14081,6.90347,0.07>,
            
    /*2*/ <0.29741,7.43195,0.49761>,<0.30477,7.41513,0.51495>,<0.28059,7.42232,0.51381>,
            
    /*3*/ <0.53434,7.92773,0.92525>,<0.53792,7.91897,0.93361>,<0.52634,7.92395,0.93426>,
            
    /*4*/ <1.03254,8.23433,1.30438>

    /* stem 0.23.1*/ 
    /*0*/ <0.28232,6.94935,0.13182>,
    /*1*/ <0.2859,6.92949,0.13836>,<0.28528,6.9656,0.14512>,<0.27578,6.95295,0.11196>,
            
    /*2*/ <0.93082,6.98532,-0.06771>,<0.93041,7.00939,-0.0632>,<0.92408,7.00096,-0.08531>,
            
    /*3*/ <1.49434,7.22494,-0.37211>,<1.49151,7.23632,-0.36861>,<1.48751,7.23205,-0.37937>,
            
    /*4*/ <2.02868,7.61511,-0.53159>

    /* stem 0.23.2*/ 
    /*0*/ <0.32843,6.96636,0.15824>,
    /*1*/ <0.31848,6.98375,0.1644>,<0.34815,6.9675,0.15122>,<0.31866,6.94784,0.15909>,
            
    /*2*/ <0.54989,6.88662,0.78848>,<0.56967,6.87578,0.77969>,<0.55001,6.86267,0.78494>,
            
    /*3*/ <0.8582,7.04966,1.35965>,<0.86842,7.0445,1.35573>,<0.86035,7.03797,1.36195>,
            
    /*4*/ <1.3174,7.26338,1.8032>

    /* stem 0.23.3*/ 
    /*0*/ <0.42076,7.00044,0.21114>,
    /*1*/ <0.43218,6.99358,0.19561>,<0.42481,6.99441,0.23027>,<0.40527,7.01332,0.20754>,
            
    /*2*/ <0.83695,7.50777,0.27548>,<0.83204,7.50832,0.29859>,<0.81901,7.52092,0.28344>,
            
    /*3*/ <1.39281,7.8494,0.34484>,<1.39123,7.84978,0.35654>,<1.38682,7.85835,0.34971>,
            
    /*4*/ <1.81599,8.33408,0.49673>

    /* stem 0.23.4*/ 
    /*0*/ <0.50447,7.03133,0.25911>,
    /*1*/ <0.49685,7.025,0.27649>,<0.51548,7.04803,0.2585>,<0.50108,7.02096,0.24233>,
            
    /*2*/ <1.03386,6.67858,0.37816>,<1.04628,6.69394,0.36617>,<1.03668,6.67589,0.35539>,
            
    /*3*/ <1.60676,6.87474,0.6104>,<1.60729,6.88303,0.60238>,<1.61175,6.8726,0.60021>,
            
    /*4*/ <2.12167,7.16864,0.8694>

    /* stem 0.23.5*/ 
    /*0*/ <0.58747,7.06196,0.30667>,
    /*1*/ <0.58797,7.078,0.29548>,<0.60412,7.05292,0.31155>,<0.57033,7.05496,0.31298>,
            
    /*2*/ <0.63182,7.43427,0.81932>,<0.64258,7.41755,0.83003>,<0.62006,7.41891,0.83099>,
            
    /*3*/ <0.85426,7.94135,1.11927>,<0.86068,7.93476,1.12582>,<0.8502,7.93744,1.12906>,
            
    /*4*/ <1.05986,8.48779,1.36728>

    /* stem 0.23.6*/ 
    /*0*/ <0.6974,7.10958,0.37141>,
    /*1*/ <0.70554,7.09249,0.3725>,<0.69725,7.12099,0.38656>,<0.6894,7.11526,0.35519>,
            
    /*2*/ <1.24162,7.3435,0.19263>,<1.23609,7.3625,0.20201>,<1.23086,7.35868,0.18109>,
            
    /*3*/ <1.69634,7.76831,0.20214>,<1.68967,7.77546,0.20707>,<1.69022,7.77512,0.19615>,
            
    /*4*/ <2.19358,8.10327,0.35042>

    /* stem 0.23.7*/ 
    /*0*/ <0.82534,7.17549,0.4494>,
    /*1*/ <0.81404,7.18621,0.45889>,<0.83984,7.18269,0.441>,<0.82215,7.15757,0.44831>,
            
    /*2*/ <1.14702,7.09392,0.94821>,<1.16422,7.09158,0.93628>,<1.15242,7.07483,0.94115>,
            
    /*3*/ <1.53199,7.24087,1.38077>,<1.54005,7.2398,1.37408>,<1.5368,7.23155,1.37977>,
            
    /*4*/ <1.94808,7.54828,1.68245>

    /* stem 0.23.8*/ 
    /*0*/ <0.93841,7.23373,0.51831>,
    /*1*/ <0.94757,7.23375,0.50327>,<0.94527,7.22643,0.53279>,<0.92239,7.24102,0.51887>,
            
    /*2*/ <1.18202,7.74444,0.65347>,<1.18049,7.73955,0.67315>,<1.16524,7.74928,0.66387>,
            
    /*3*/ <1.46263,8.21486,0.85007>,<1.46143,8.21168,0.85965>,<1.45441,8.21766,0.85536>,
            
    /*4*/ <1.88062,8.51682,1.119>

    /* stem 0.23.9*/ 
    /*0*/ <1.05612,7.29437,0.59006>,
    /*1*/ <1.05312,7.28438,0.60342>,<1.05876,7.31097,0.5923>,<1.05649,7.28776,0.57445>,
            
    /*2*/ <1.60707,7.19279,0.65224>,<1.61082,7.21051,0.64482>,<1.60931,7.19504,0.63292>,
            
    /*3*/ <2.16525,7.16511,0.72763>,<2.16629,7.1741,0.72391>,<2.1667,7.1663,0.71802>,
            
    /*4*/ <2.64434,7.30718,0.98706>

    /* stem 0.23.10*/ 
    /*0*/ <1.16895,7.35249,0.65883>,
    /*1*/ <1.16488,7.36721,0.65305>,<1.18459,7.34782,0.659>,<1.15736,7.34244,0.66443>,
            
    /*2*/ <1.22416,7.5745,1.15497>,<1.2373,7.56157,1.15893>,<1.21914,7.55799,1.16256>,
            
    /*3*/ <1.55278,7.88389,1.4593>,<1.55908,7.87689,1.45975>,<1.55234,7.87761,1.46631>,
            
    /*4*/ <1.9309,8.23448,1.63739>

    /* stem 0.23.11*/ 
    /*0*/ <1.26005,7.42736,0.72097>,
    /*1*/ <1.2719,7.41717,0.71904>,<1.25689,7.43314,0.73527>,<1.25137,7.43178,0.70859>,
            
    /*2*/ <1.60034,7.82373,0.63036>,<1.59032,7.83438,0.64118>,<1.58665,7.83347,0.62339>,
            
    /*3*/ <1.92901,8.23313,0.70684>,<1.92287,8.23716,0.7122>,<1.92288,8.23882,0.70326>,
            
    /*4*/ <2.1397,8.6788,0.90521>

    /* stem 0.23.12*/ 
    /*0*/ <1.33265,7.50172,0.77396>,
    /*1*/ <1.32174,7.50519,0.78405>,<1.33951,7.5128,0.76603>,<1.33671,7.48718,0.77181>,
            
    /*2*/ <1.68189,7.5486,1.15118>,<1.69373,7.55368,1.13918>,<1.69186,7.53659,1.14303>,
            
    /*3*/ <2.03798,7.86527,1.35171>,<2.04142,7.8666,1.34371>,<2.04442,7.86003,1.34875>,
            
    /*4*/ <2.18401,8.34483,1.46951>

    /* stem 0.23.13*/ 
    /*0*/ <1.40159,7.57233,0.82429>,
    /*1*/ <1.40666,7.57675,0.81113>,<1.41094,7.57052,0.83559>,<1.38715,7.56972,0.82615>,
            
    /*2*/ <1.33553,8.0548,0.94985>,<1.33838,8.05064,0.96616>,<1.32253,8.05011,0.95986>,
            
    /*3*/ <1.44723,8.51479,1.1176>,<1.44869,8.51167,1.12541>,<1.44087,8.51435,1.12327>,
            
    /*4*/ <1.64198,8.95311,1.26726>

    /* stem 0.23.14*/ 
    /*0*/ <1.45067,7.62261,0.86012>,
    /*1*/ <1.45341,7.6127,0.87028>,<1.44772,7.63623,0.86393>,<1.4509,7.61889,0.84616>,
            
    /*2*/ <1.93288,7.72621,0.84523>,<1.92909,7.7419,0.84099>,<1.9312,7.73033,0.82915>,
            
    /*3*/ <2.33857,7.93331,1.03115>,<2.3359,7.94085,1.02877>,<2.3406,7.93627,1.02362>,
            
    /*4*/ <2.61102,8.27886,1.25597>

    /* stem 0.23.15*/ 
    /*0*/ <1.53433,7.70829,0.92119>,
    /*1*/ <1.52554,7.71872,0.91859>,<1.54797,7.71009,0.91936>,<1.52947,7.69606,0.92561>,
            
    /*2*/ <1.56953,7.86231,1.37157>,<1.58449,7.85656,1.37209>,<1.57215,7.84721,1.37625>,
            
    /*3*/ <1.72643,8.11018,1.74747>,<1.73371,8.10691,1.74668>,<1.7282,8.10337,1.75131>,
            
    /*4*/ <1.80942,8.46782,2.05017>

    /* stem 0.23.16*/ 
    /*0*/ <1.61269,7.78856,0.9784>,
    /*1*/ <1.62313,7.78234,0.97283>,<1.61232,7.79044,0.99162>,<1.60264,7.7929,0.97074>,
            
    /*2*/ <1.83413,8.19046,0.92315>,<1.82692,8.19586,0.93567>,<1.82048,8.1975,0.92176>,
            
    /*3*/ <2.14669,8.52806,0.91043>,<2.14364,8.5312,0.91679>,<2.14108,8.53332,0.90983>,
            
    /*4*/ <2.47486,8.84868,0.96644>

    /* stem 0.23.17*/ 
    /*0*/ <1.67652,7.86492,1.03352>,
    /*1*/ <1.66849,7.86336,1.04348>,<1.67919,7.87676,1.0292>,<1.68188,7.85465,1.02789>,
            
    /*2*/ <2.01761,7.88936,1.3237>,<2.02474,7.8983,1.31418>,<2.02654,7.88356,1.31331>,
            
    /*3*/ <2.27728,8.14217,1.58729>,<2.27962,8.14604,1.58138>,<2.28333,8.13997,1.58354>,
            
    /*4*/ <2.4682,8.49185,1.79332>

    /* stem 0.23.18*/ 
    /*0*/ <1.76322,7.98702,1.12266>,
    /*1*/ <1.76432,7.99365,1.11252>,<1.77299,7.98484,1.12958>,<1.75237,7.98258,1.12589>,
            
    /*2*/ <1.6849,8.34694,1.33978>,<1.69068,8.34106,1.35115>,<1.67693,8.33955,1.34869>,
            
    /*3*/ <1.61747,8.73342,1.50625>,<1.62029,8.73135,1.51234>,<1.61339,8.73063,1.51124>,
            
    /*4*/ <1.52343,9.07834,1.74209>

    /* stem 0.23.19*/ 
    /*0*/ <1.82623,8.07574,1.18744>,
    /*1*/ <1.83189,8.06743,1.19332>,<1.82174,8.08487,1.19312>,<1.82505,8.07493,1.17588>,
            
    /*2*/ <2.18396,8.2755,1.14085>,<2.17719,8.28713,1.14071>,<2.1794,8.2805,1.12922>,
            
    /*3*/ <2.45867,8.58218,1.17893>,<2.45371,8.58672,1.17876>,<2.45668,8.58476,1.17305>,
            
    /*4*/ <2.6629,8.92452,1.28529>

    /* stem 0.23.20*/ 
    /*0*/ <1.89678,8.1751,1.25998>,
    /*1*/ <1.88783,8.18099,1.26062>,<1.90581,8.17947,1.25617>,<1.8967,8.16484,1.26314>,
            
    /*2*/ <1.99089,8.29104,1.62603>,<2.00288,8.29003,1.62306>,<1.99681,8.28028,1.62771>,
            
    /*3*/ <2.09644,8.55613,1.89758>,<2.10237,8.55562,1.89584>,<2.10012,8.55195,1.9003>,
            
    /*4*/ <2.14952,8.88471,2.10948>

    /* stem 0.23.21*/ 
    /*0*/ <1.95013,8.25022,1.31482>,
    /*1*/ <1.95764,8.24902,1.30916>,<1.95137,8.25159,1.32413>,<1.94137,8.25005,1.31119>,
            
    /*2*/ <1.97185,8.62707,1.25325>,<1.96767,8.62878,1.26323>,<1.961,8.62776,1.2546>,
            
    /*3*/ <2.0132,8.99874,1.17608>,<2.01121,9.00003,1.18101>,<2.00782,8.99952,1.17674>,
            
    /*4*/ <1.98013,9.37957,1.20603>

    /* stem 0.23.22*/ 
    /*0*/ <2.03355,8.38617,1.40437>,
    /*1*/ <2.03091,8.38379,1.4108>,<2.03343,8.39334,1.40277>,<2.03633,8.38137,1.39954>,
            
    /*2*/ <2.35784,8.42351,1.5572>,<2.35952,8.42988,1.55184>,<2.36146,8.42189,1.54968>,
            
    /*3*/ <2.67846,8.49985,1.70338>,<2.67901,8.503,1.70059>,<2.68036,8.49909,1.69966>,
            
    /*4*/ <2.94552,8.63612,1.90281>

    /* stem 0.23.23*/ 
    /*0*/ <2.06371,8.44618,1.43895>,
    /*1*/ <2.06198,8.44992,1.43396>,<2.0694,8.44712,1.44189>,<2.05974,8.44149,1.44101>,
            
    /*2*/ <1.91045,8.67462,1.65754>,<1.91539,8.67275,1.66283>,<1.90896,8.669,1.66224>,
            
    /*3*/ <1.90918,8.90727,1.92192>,<1.91194,8.90539,1.9236>,<1.90838,8.90454,1.92434>,
            
    /*4*/ <1.89124,9.11325,2.20617>

    /* stem 0.23.24*/ 
    /*0*/ <2.1103,8.53891,1.4924>,
    /*1*/ <2.11423,8.53603,1.49397>,<2.10824,8.54237,1.49556>,<2.10843,8.53833,1.48767>,
            
    /*2*/ <2.32888,8.76973,1.37949>,<2.32488,8.77395,1.38055>,<2.32501,8.77126,1.37529>,
            
    /*3*/ <2.5946,8.97606,1.37723>,<2.59283,8.97836,1.37777>,<2.59342,8.97757,1.37498>,
            
    /*4*/ <2.83417,9.19947,1.45776>

    /* stem 0.23.25*/ 
    /*0*/ <2.15795,8.63374,1.54705>,
    /*1*/ <2.15455,8.63479,1.54818>,<2.16031,8.63625,1.54565>,<2.15897,8.63016,1.54733>,
            
    /*2*/ <2.27133,8.69048,1.84414>,<2.27517,8.69145,1.84246>,<2.27428,8.68739,1.84357>,
            
    /*3*/ <2.38825,8.86458,2.08962>,<2.39005,8.86496,2.0885>,<2.38992,8.86324,2.08978>,
            
    /*4*/ <2.46476,9.16623,2.17571>

    /* stem 0.23.26*/ 
    /*0*/ <2.21499,8.74726,1.61248>,
    /*1*/ <2.21628,8.74753,1.61089>,<2.21572,8.74717,1.61441>,<2.21296,8.7471,1.61214>,
            
    /*2*/ <2.18662,9.05072,1.63813>,<2.18625,9.05048,1.64047>,<2.1844,9.05043,1.63896>,
            
    /*3*/ <2.25307,9.32843,1.74779>,<2.25286,9.32805,1.7489>,<2.25197,9.32851,1.74826>,
            
    /*4*/ <2.30556,9.55412,1.94773>

    /* stem 0.23.27*/ 
    /*0*/ <2.25349,8.82391,1.65665>,
    /*1*/ <2.25345,8.82345,1.65748>,<2.25311,8.82476,1.65656>,<2.25392,8.8235,1.65592>,
            
    /*2*/ <2.50863,8.94556,1.73854>,<2.50841,8.94644,1.73793>,<2.50894,8.94559,1.7375>,
            
    /*3*/ <2.71115,9.13906,1.82895>,<2.71095,9.13943,1.8286>,<2.71134,9.1391,1.82844>,
            
    /*4*/ <2.9139,9.34181,1.89527>

    /* stem 0.24*/ 
    /*0*/ <0.06591,7.06846,0.00554>,
    /*1*/ <0.05886,7.06871,-0.03443>,<0.07823,7.10424,-0.00915>,<0.08057,7.09033,0.03643>,
            <0.06265,7.04621,0.03932>,<0.04923,7.03284,-0.00447>,
    /*2*/ <-0.57694,7.33494,0.08748>,<-0.56145,7.36336,0.1077>,<-0.55957,7.35224,0.14417>,
            <-0.57391,7.31694,0.14648>,<-0.58464,7.30625,0.11145>,
    /*3*/ <-1.16236,7.6585,0.31009>,<-1.14658,7.67763,0.32439>,<-1.1424,7.66762,0.35088>,
            <-1.1556,7.6423,0.35295>,<-1.16794,7.63667,0.32774>,
    /*4*/ <-1.70026,8.05077,0.52668>,<-1.68822,8.06256,0.53564>,<-1.68595,8.0562,0.55349>,
            <-1.69657,8.04049,0.55556>,<-1.70542,8.03713,0.53899>,
    /*5*/ <-2.24713,8.4504,0.69917>,<-2.24133,8.45649,0.7037>,<-2.24064,8.45369,0.71279>,
            <-2.24601,8.44587,0.71389>,<-2.25002,8.44384,0.70547>,
    /*6*/ <-2.69324,8.96503,0.86137>

    /* stem 0.24.0*/ 
    /*0*/ <-0.07082,7.1256,0.02998>,
    /*1*/ <-0.06284,7.13817,0.04523>,<-0.08943,7.11567,0.03302>,<-0.06019,7.12297,0.0117>,
            
    /*2*/ <-0.39435,7.66784,-0.22794>,<-0.41207,7.65283,-0.23608>,<-0.39258,7.6577,-0.25029>,
            
    /*3*/ <-0.73284,8.18701,-0.51333>,<-0.74148,8.17927,-0.51743>,<-0.73168,8.18181,-0.52442>,
            
    /*4*/ <-1.12495,8.73699,-0.44109>

    /* stem 0.24.1*/ 
    /*0*/ <-0.15016,7.15875,0.04417>,
    /*1*/ <-0.15852,7.13972,0.04184>,<-0.1595,7.17541,0.03563>,<-0.13244,7.16113,0.05503>,
            
    /*2*/ <-0.51235,7.23412,0.60469>,<-0.513,7.25791,0.60055>,<-0.49496,7.24839,0.61349>,
            
    /*3*/ <-0.98224,7.52118,0.99298>,<-0.97973,7.53199,0.9882>,<-0.97386,7.52824,0.99807>,
            
    /*4*/ <-1.46614,7.98192,1.07279>

    /* stem 0.24.2*/ 
    /*0*/ <-0.24449,7.19818,0.06103>,
    /*1*/ <-0.23962,7.21462,0.04989>,<-0.2525,7.20049,0.07971>,<-0.24136,7.17942,0.0535>,
            
    /*2*/ <-0.84677,7.2125,-0.20647>,<-0.85537,7.20309,-0.18659>,<-0.84794,7.18904,-0.20406>,
            
    /*3*/ <-1.4255,7.45255,-0.39951>,<-1.43065,7.44821,-0.38981>,<-1.43008,7.44167,-0.39963>,
            
    /*4*/ <-1.93077,7.87414,-0.41197>

    /* stem 0.24.3*/ 
    /*0*/ <-0.34796,7.24141,0.07953>,
    /*1*/ <-0.34727,7.23499,0.0984>,<-0.36402,7.23766,0.0683>,<-0.3326,7.25159,0.07189>,
            
    /*2*/ <-0.6152,7.79004,0.29001>,<-0.62636,7.79182,0.26994>,<-0.60542,7.8011,0.27233>,
            
    /*3*/ <-1.02496,8.29159,0.2354>,<-1.02731,8.2886,0.22453>,<-1.01868,8.29589,0.22676>,
            
    /*4*/ <-1.48168,8.74154,0.16052>

    /* stem 0.24.4*/ 
    /*0*/ <-0.4225,7.27256,0.09285>,
    /*1*/ <-0.42821,7.26648,0.07514>,<-0.42565,7.2911,0.09833>,<-0.41364,7.26011,0.1051>,
            
    /*2*/ <-0.99107,7.10192,0.32028>,<-0.98936,7.11834,0.33574>,<-0.98135,7.09767,0.34026>,
            
    /*3*/ <-1.56081,7.25757,0.56022>,<-1.55607,7.26575,0.56641>,<-1.55713,7.25533,0.57067>,
            
    /*4*/ <-1.936,7.74717,0.71837>

    /* stem 0.24.5*/ 
    /*0*/ <-0.5191,7.31293,0.11012>,
    /*1*/ <-0.51123,7.32818,0.11853>,<-0.53258,7.30289,0.11923>,<-0.5135,7.30772,0.09261>,
            
    /*2*/ <-0.95346,7.68737,-0.1332>,<-0.96769,7.67051,-0.13274>,<-0.95498,7.67373,-0.15049>,
            
    /*3*/ <-1.30048,8.19678,-0.17323>,<-1.30965,8.19064,-0.17314>,<-1.30481,8.19319,-0.18272>,
            
    /*4*/ <-1.75579,8.59066,-0.0121>

    /* stem 0.24.6*/ 
    /*0*/ <-0.61886,7.36097,0.13688>,
    /*1*/ <-0.62633,7.3445,0.14127>,<-0.62959,7.37449,0.12992>,<-0.60067,7.36391,0.13943>,
            
    /*2*/ <-0.73565,7.55124,0.70373>,<-0.73782,7.57123,0.69616>,<-0.71854,7.56418,0.7025>,
            
    /*3*/ <-0.8972,7.95597,1.1347>,<-0.89698,7.9639,1.12746>,<-0.88813,7.96148,1.13305>,
            
    /*4*/ <-1.14388,8.42315,1.43919>

    /* stem 0.24.7*/ 
    /*0*/ <-0.72815,7.42122,0.1769>,
    /*1*/ <-0.72699,7.43258,0.16294>,<-0.73235,7.42746,0.19329>,<-0.7251,7.40361,0.17447>,
            
    /*2*/ <-1.30331,7.34508,0.05185>,<-1.30688,7.34167,0.07208>,<-1.30204,7.32576,0.05953>,
            
    /*3*/ <-1.87355,7.50095,0.02777>,<-1.87451,7.49937,0.03801>,<-1.87635,7.49159,0.03135>,
            
    /*4*/ <-2.32625,7.87696,-0.03209>

    /* stem 0.24.8*/ 
    /*0*/ <-0.8636,7.4959,0.2265>,
    /*1*/ <-0.85834,7.49451,0.24295>,<-0.87927,7.49013,0.2219>,<-0.85318,7.50306,0.21466>,
            
    /*2*/ <-1.08389,8.01072,0.35265>,<-1.09785,8.0078,0.33861>,<-1.08045,8.01642,0.33378>,
            
    /*3*/ <-1.47694,8.42986,0.39395>,<-1.48203,8.42596,0.38626>,<-1.47492,8.43279,0.3846>,
            
    /*4*/ <-1.86882,8.84129,0.3044>

    /* stem 0.24.9*/ 
    /*0*/ <-1.00107,7.57169,0.27685>,
    /*1*/ <-1.00985,7.56327,0.26554>,<-1.00246,7.58822,0.27783>,<-0.99089,7.56359,0.28718>,
            
    /*2*/ <-1.42105,7.50953,0.63309>,<-1.41612,7.52616,0.64128>,<-1.40841,7.50974,0.64751>,
            
    /*3*/ <-1.89422,7.64505,0.88703>,<-1.89028,7.65319,0.89023>,<-1.88973,7.6452,0.8955>,
            
    /*4*/ <-2.31971,7.99466,0.94825>

    /* stem 0.24.10*/ 
    /*0*/ <-1.09153,7.62157,0.30998>,
    /*1*/ <-1.08335,7.6354,0.31149>,<-1.10132,7.61664,0.32184>,<-1.08993,7.61266,0.29661>,
            
    /*2*/ <-1.49724,7.89877,0.08316>,<-1.50922,7.88626,0.09006>,<-1.50163,7.88361,0.07324>,
            
    /*3*/ <-1.97061,8.157,0.13045>,<-1.97436,8.14953,0.13457>,<-1.97479,8.15045,0.1253>,
            
    /*4*/ <-2.28947,8.52564,0.36122>

    /* stem 0.24.11*/ 
    /*0*/ <-1.19108,7.6828,0.34717>,
    /*1*/ <-1.19622,7.67102,0.35604>,<-1.20106,7.69068,0.33811>,<-1.17596,7.6867,0.34736>,
            
    /*2*/ <-1.28638,8.0116,0.74712>,<-1.28961,8.02471,0.73516>,<-1.27287,8.02205,0.74133>,
            
    /*3*/ <-1.3673,8.46849,1.00258>,<-1.36812,8.47282,0.99471>,<-1.36003,8.47206,0.99862>,
            
    /*4*/ <-1.46748,8.93479,1.22574>

    /* stem 0.24.12*/ 
    /*0*/ <-1.27152,7.74129,0.37826>,
    /*1*/ <-1.273,7.74675,0.36418>,<-1.27316,7.75053,0.39019>,<-1.2684,7.7266,0.38042>,
            
    /*2*/ <-1.77536,7.63996,0.38106>,<-1.77547,7.64248,0.3984>,<-1.7723,7.62653,0.39189>,
            
    /*3*/ <-2.26368,7.79313,0.39755>,<-2.26305,7.79445,0.40618>,<-2.2656,7.78665,0.40312>,
            
    /*4*/ <-2.53424,8.20806,0.53443>

    /* stem 0.24.13*/ 
    /*0*/ <-1.37459,7.81624,0.4181>,
    /*1*/ <-1.3676,7.81922,0.43058>,<-1.3886,7.81213,0.41838>,<-1.36756,7.81736,0.40535>,
            
    /*2*/ <-1.5101,8.2946,0.39118>,<-1.5241,8.28987,0.38305>,<-1.51007,8.29336,0.37436>,
            
    /*3*/ <-1.82376,8.67328,0.46921>,<-1.82985,8.66917,0.46507>,<-1.82466,8.67434,0.46089>,
            
    /*4*/ <-2.15215,8.94631,0.72275>

    /* stem 0.24.14*/ 
    /*0*/ <-1.48784,7.89859,0.46188>,
    /*1*/ <-1.49673,7.88919,0.45656>,<-1.49,7.91225,0.45975>,<-1.47679,7.89433,0.46933>,
            
    /*2*/ <-1.75639,7.91343,0.85981>,<-1.7519,7.9288,0.86194>,<-1.7431,7.91686,0.86833>,
            
    /*3*/ <-2.07445,8.11574,1.15871>,<-2.07061,8.12282,1.1581>,<-2.06852,8.11757,1.16388>,
            
    /*4*/ <-2.45272,8.32406,1.36728>

    /* stem 0.24.15*/ 
    /*0*/ <-1.56616,7.95554,0.49216>,
    /*1*/ <-1.55944,7.96673,0.48848>,<-1.57249,7.95506,0.50415>,<-1.56655,7.94482,0.48385>,
            
    /*2*/ <-1.95066,8.13113,0.291>,<-1.95936,8.12334,0.30144>,<-1.9554,8.11652,0.28791>,
            
    /*3*/ <-2.31147,8.31263,0.05597>,<-2.3165,8.3089,0.06067>,<-2.31397,8.30544,0.05412>,
            
    /*4*/ <-2.64152,8.61859,-0.06926>

    /* stem 0.24.16*/ 
    /*0*/ <-1.67224,8.03267,0.53316>,
    /*1*/ <-1.67384,8.02497,0.54351>,<-1.68258,8.03677,0.52645>,<-1.66029,8.03627,0.52953>,
            
    /*2*/ <-1.70195,8.39111,0.80631>,<-1.70777,8.39898,0.79494>,<-1.69291,8.39864,0.79699>,
            
    /*3*/ <-1.81172,8.7509,1.05601>,<-1.81455,8.75432,1.04996>,<-1.80733,8.75527,1.05177>,
            
    /*4*/ <-1.90036,9.1417,1.26529>

    /* stem 0.24.17*/ 
    /*0*/ <-1.7467,8.0869,0.5575>,
    /*1*/ <-1.74996,8.08743,0.54534>,<-1.74715,8.0973,0.5646>,<-1.74299,8.07597,0.56255>,
            
    /*2*/ <-2.16562,7.9955,0.65708>,<-2.16375,8.00207,0.66992>,<-2.16097,7.98786,0.66855>,
            
    /*3*/ <-2.56155,8.16579,0.74331>,<-2.55896,8.16893,0.74934>,<-2.56177,8.16223,0.74965>,
            
    /*4*/ <-2.89986,8.43629,0.82132>

    /* stem 0.24.18*/ 
    /*0*/ <-1.83847,8.15378,0.58503>,
    /*1*/ <-1.83169,8.15977,0.5931>,<-1.85003,8.15118,0.58758>,<-1.83369,8.1504,0.57442>,
            
    /*2*/ <-1.95538,8.52791,0.41778>,<-1.9676,8.52218,0.4141>,<-1.95671,8.52166,0.40532>,
            
    /*3*/ <-2.20656,8.8611,0.32855>,<-2.2119,8.85679,0.32721>,<-2.20756,8.85868,0.32206>,
            
    /*4*/ <-2.51522,9.15244,0.28863>

    /* stem 0.24.19*/ 
    /*0*/ <-1.98324,8.25928,0.62847>,
    /*1*/ <-1.99005,8.2502,0.62785>,<-1.98705,8.26948,0.62517>,<-1.97263,8.25818,0.63238>,
            
    /*2*/ <-2.11876,8.32577,1.00325>,<-2.11676,8.33862,1.00146>,<-2.10714,8.33109,1.00627>,
            
    /*3*/ <-2.41622,8.45481,1.24214>,<-2.4147,8.46105,1.24076>,<-2.41189,8.45803,1.24587>,
            
    /*4*/ <-2.70756,8.65025,1.44342>

    /* stem 0.24.20*/ 
    /*0*/ <-2.07126,8.32343,0.65487>,
    /*1*/ <-2.06744,8.33123,0.64866>,<-2.07604,8.32582,0.66412>,<-2.0703,8.31323,0.65184>,
            
    /*2*/ <-2.41267,8.35077,0.46713>,<-2.41841,8.34717,0.47744>,<-2.41458,8.33877,0.46926>,
            
    /*3*/ <-2.77607,8.49317,0.44853>,<-2.77722,8.49112,0.45423>,<-2.77838,8.48752,0.44936>,
            
    /*4*/ <-3.07628,8.73792,0.49436>

    /* stem 0.24.21*/ 
    /*0*/ <-2.20331,8.41966,0.69449>,
    /*1*/ <-2.20287,8.41687,0.70275>,<-2.21108,8.42066,0.69063>,<-2.19599,8.42145,0.69009>,
            
    /*2*/ <-2.21699,8.76816,0.8192>,<-2.22246,8.77069,0.81111>,<-2.2124,8.77121,0.81075>,
            
    /*3*/ <-2.30705,9.10984,0.93043>,<-2.3097,9.11055,0.9262>,<-2.30482,9.11179,0.92635>,
            
    /*4*/ <-2.50943,9.38906,1.06469>

    /* stem 0.24.22*/ 
    /*0*/ <-2.28431,8.49519,0.72053>,
    /*1*/ <-2.28801,8.49386,0.71426>,<-2.28277,8.50216,0.72251>,<-2.28216,8.48956,0.72483>,
            
    /*2*/ <-2.5953,8.51214,0.89428>,<-2.59181,8.51768,0.89979>,<-2.5914,8.50928,0.90134>,
            
    /*3*/ <-2.8038,8.68663,1.12768>,<-2.8004,8.68876,1.12915>,<-2.80152,8.68504,1.13093>,
            
    /*4*/ <-3.02423,8.92821,1.26877>

    /* stem 0.24.23*/ 
    /*0*/ <-2.36447,8.58729,0.74814>,
    /*1*/ <-2.35996,8.59061,0.75016>,<-2.36922,8.58631,0.75159>,<-2.36423,8.58495,0.74267>,
            
    /*2*/ <-2.51101,8.8694,0.62308>,<-2.51718,8.86653,0.62403>,<-2.51385,8.86562,0.61809>,
            
    /*3*/ <-2.57189,9.19778,0.55815>,<-2.57527,9.19723,0.55849>,<-2.57378,9.1969,0.55541>,
            
    /*4*/ <-2.56982,9.53768,0.58583>

    /* stem 0.24.24*/ 
    /*0*/ <-2.41762,8.64836,0.76645>,
    /*1*/ <-2.42093,8.645,0.76809>,<-2.41916,8.65224,0.76371>,<-2.41278,8.64785,0.76755>,
            
    /*2*/ <-2.46381,8.82391,1.044>,<-2.46264,8.82874,1.04108>,<-2.45838,8.82581,1.04364>,
            
    /*3*/ <-2.53784,9.07047,1.2538>,<-2.53708,9.07241,1.25181>,<-2.53512,9.07142,1.25367>,
            
    /*4*/ <-2.67665,9.34485,1.37812>

    /* stem 0.24.25*/ 
    /*0*/ <-2.50686,8.75089,0.79718>,
    /*1*/ <-2.506,8.75249,0.79434>,<-2.50744,8.75265,0.8>,<-2.50714,8.74753,0.7972>,
            
    /*2*/ <-2.81026,8.77682,0.7169>,<-2.81123,8.77692,0.72068>,<-2.81103,8.77351,0.71881>,
            
    /*3*/ <-3.07206,8.95062,0.73741>,<-3.07199,8.95052,0.73936>,<-3.07296,8.94917,0.73835>,
            
    /*4*/ <-3.25943,9.19792,0.7908>

    /* stem 0.24.26*/ 
    /*0*/ <-2.58858,8.84478,0.82532>,
    /*1*/ <-2.58807,8.84468,0.82714>,<-2.59041,8.8448,0.82485>,<-2.58725,8.84486,0.82397>,
            
    /*2*/ <-2.58912,9.14382,0.84349>,<-2.59069,9.1439,0.84196>,<-2.58858,9.14394,0.84137>,
            
    /*3*/ <-2.6503,9.4231,0.93226>,<-2.6511,9.42316,0.93152>,<-2.65008,9.42346,0.93125>,
            
    /*4*/ <-2.76859,9.68115,1.02806>

    /* stem 0.24.27*/ 
    /*0*/ <-2.65556,8.92174,0.84839>,
    /*1*/ <-2.65602,8.92147,0.84796>,<-2.65543,8.92241,0.84838>,<-2.65524,8.92134,0.84884>,
            
    /*2*/ <-2.86413,8.96735,1.04025>,<-2.86374,8.96797,1.04053>,<-2.86361,8.96726,1.04084>,
            
    /*3*/ <-3.04193,9.11979,1.20633>,<-3.04164,9.12006,1.20639>,<-3.04168,9.11975,1.20663>,
            
    /*4*/ <-3.20612,9.33695,1.29728>

    /* stem 0.25*/ 
    /*0*/ <0.07028,7.25723,0.00591>,
    /*1*/ <0.10079,7.25647,0.03151>,<0.07098,7.29205,0.02526>,<0.0402,7.2795,-0.00774>,
            <0.05099,7.23618,-0.02188>,<0.08844,7.22195,0.00238>,
    /*2*/ <0.50842,7.51801,-0.45883>,<0.48457,7.54647,-0.46383>,<0.45995,7.53643,-0.49023>,
            <0.46858,7.50178,-0.50154>,<0.49854,7.49039,-0.48213>,
    /*3*/ <0.95021,7.77563,-0.9176>,<0.93313,7.79748,-0.92206>,<0.91572,7.79075,-0.94307>,
            <0.92205,7.76473,-0.95159>,<0.94337,7.75539,-0.93585>,
    /*4*/ <1.36325,8.12175,-1.34754>,<1.35045,8.13534,-1.3491>,<1.33928,8.13114,-1.36354>,
            <1.34518,8.11496,-1.3709>,<1.35999,8.10916,-1.36101>,
    /*5*/ <1.75082,8.51054,-1.76467>,<1.74404,8.51699,-1.76507>,<1.7385,8.51491,-1.77232>,
            <1.74185,8.50718,-1.77641>,<1.74947,8.50448,-1.77168>,
    /*6*/ <2.09194,8.90659,-2.21487>

    /* stem 0.25.0*/ 
    /*0*/ <0.15226,7.30902,-0.09024>,
    /*1*/ <0.13685,7.3218,-0.09649>,<0.16227,7.29703,-0.10423>,<0.15766,7.30824,-0.06999>,
            
    /*2*/ <0.59027,7.80903,-0.19489>,<0.60721,7.79252,-0.20005>,<0.60414,7.79999,-0.17722>,
            
    /*3*/ <1.00523,8.29001,-0.41269>,<1.01362,8.28171,-0.41538>,<1.01346,8.28682,-0.4044>,
            
    /*4*/ <1.46789,8.66059,-0.73251>

    /* stem 0.25.1*/ 
    /*0*/ <0.23394,7.36063,-0.18603>,
    /*1*/ <0.24127,7.34201,-0.18981>,<0.24659,7.37655,-0.18511>,<0.21396,7.36332,-0.18318>,
            
    /*2*/ <0.16021,7.44805,-0.83258>,<0.16376,7.47107,-0.82944>,<0.142,7.46225,-0.82815>,
            
    /*3*/ <0.35709,7.85839,-1.31161>,<0.35749,7.86729,-1.30394>,<0.3476,7.8651,-1.3099>,
            
    /*4*/ <0.64482,8.33681,-1.6584>

    /* stem 0.25.2*/ 
    /*0*/ <0.31012,7.40876,-0.27538>,
    /*1*/ <0.31375,7.42442,-0.26384>,<0.3058,7.41135,-0.29452>,<0.3108,7.3905,-0.26777>,
            
    /*2*/ <0.93591,7.38195,-0.41321>,<0.93061,7.37324,-0.43366>,<0.93394,7.35934,-0.41583>,
            
    /*3*/ <1.45454,7.57254,-0.73599>,<1.45022,7.56826,-0.74567>,<1.45679,7.56174,-0.73897>,
            
    /*4*/ <1.92434,7.85967,-1.06338>

    /* stem 0.25.3*/ 
    /*0*/ <0.37662,7.45077,-0.35337>,
    /*1*/ <0.36425,7.44501,-0.36702>,<0.39541,7.44667,-0.35501>,<0.3702,7.46063,-0.33807>,
            
    /*2*/ <0.45892,7.98572,-0.67195>,<0.47969,7.98683,-0.66395>,<0.46288,7.99614,-0.65265>,
            
    /*3*/ <0.46627,8.48715,-1.0459>,<0.47692,8.48909,-1.04326>,<0.46876,8.4937,-1.03724>,
            
    /*4*/ <0.60498,8.89404,-1.50363>

    /* stem 0.25.4*/ 
    /*0*/ <0.45302,7.49904,-0.44297>,
    /*1*/ <0.46798,7.49277,-0.43359>,<0.45254,7.51674,-0.4491>,<0.43854,7.4876,-0.44622>,
            
    /*2*/ <0.72029,7.31917,-0.96423>,<0.70999,7.33515,-0.97457>,<0.70066,7.31572,-0.97265>,
            
    /*3*/ <0.93026,7.42241,-1.53367>,<0.92334,7.43065,-1.53483>,<0.92039,7.42065,-1.53774>,
            
    /*4*/ <1.24659,7.75619,-1.93757>

    /* stem 0.25.5*/ 
    /*0*/ <0.53629,7.54869,-0.53228>,
    /*1*/ <0.52617,7.56369,-0.53375>,<0.54402,7.54146,-0.54704>,<0.53869,7.54091,-0.51604>,
            
    /*2*/ <1.01465,7.8947,-0.44396>,<1.02654,7.87987,-0.45282>,<1.02299,7.87951,-0.43216>,
            
    /*3*/ <1.45596,8.24028,-0.64531>,<1.46047,8.23201,-0.64991>,<1.46298,8.23455,-0.64005>,
            
    /*4*/ <1.81139,8.61324,-0.94506>

    /* stem 0.25.6*/ 
    /*0*/ <0.5988,7.58464,-0.59559>,
    /*1*/ <0.6005,7.56861,-0.60301>,<0.6132,7.59444,-0.59225>,<0.58269,7.59086,-0.59152>,
            
    /*2*/ <0.55885,7.81557,-1.13206>,<0.56731,7.83279,-1.12489>,<0.54697,7.8304,-1.1244>,
            
    /*3*/ <0.79023,8.14035,-1.56289>,<0.79343,8.14728,-1.55607>,<0.78417,8.1482,-1.56034>,
            
    /*4*/ <1.13283,8.37203,-1.97587>

    /* stem 0.25.7*/ 
    /*0*/ <0.6649,7.62266,-0.66255>,
    /*1*/ <0.67199,7.6323,-0.65007>,<0.66354,7.62893,-0.67862>,<0.65916,7.60674,-0.65897>,
            
    /*2*/ <1.18553,7.41435,-0.78154>,<1.1799,7.4121,-0.80057>,<1.17697,7.3973,-0.78747>,
            
    /*3*/ <1.75385,7.41134,-0.80023>,<1.7536,7.40966,-0.81007>,<1.75376,7.40198,-0.80369>,
            
    /*4*/ <2.27364,7.63112,-0.89546>

    /* stem 0.25.8*/ 
    /*0*/ <0.73382,7.66229,-0.73237>,
    /*1*/ <0.72162,7.66312,-0.74394>,<0.7481,7.65405,-0.73576>,<0.73173,7.66972,-0.7174>,
            
    /*2*/ <0.94995,8.13471,-0.94289>,<0.96761,8.12866,-0.93743>,<0.9567,8.13911,-0.92519>,
            
    /*3*/ <1.21604,8.56188,-1.18939>,<1.2246,8.55837,-1.18643>,<1.21972,8.56464,-1.18083>,
            
    /*4*/ <1.33348,9.03578,-1.46199>

    /* stem 0.25.9*/ 
    /*0*/ <0.82586,7.71524,-0.82561>,
    /*1*/ <0.83722,7.70497,-0.82023>,<0.82976,7.73063,-0.82894>,<0.8106,7.7101,-0.82767>,
            
    /*2*/ <0.94959,7.56836,-1.33414>,<0.94461,7.58547,-1.33994>,<0.93184,7.57178,-1.3391>,
            
    /*3*/ <1.04744,7.79112,-1.82523>,<1.04342,7.79911,-1.82247>,<1.03826,7.79244,-1.82654>,
            
    /*4*/ <1.18228,8.17179,-2.19001>

    /* stem 0.25.10*/ 
    /*0*/ <0.89354,7.75416,-0.89417>,
    /*1*/ <0.88805,7.76869,-0.89134>,<0.89647,7.74958,-0.90899>,<0.8961,7.74422,-0.88218>,
            
    /*2*/ <1.38771,7.94358,-0.84944>,<1.39332,7.93084,-0.8612>,<1.39307,7.92727,-0.84333>,
            
    /*3*/ <1.78654,8.28512,-0.80156>,<1.79153,8.2802,-0.80738>,<1.79194,8.27848,-0.79844>,
            
    /*4*/ <2.15208,8.66778,-0.84091>

    /* stem 0.25.11*/ 
    /*0*/ <0.98002,7.8157,-0.98179>,
    /*1*/ <0.97862,7.80467,-0.99215>,<0.99381,7.82071,-0.97785>,<0.96763,7.82171,-0.97538>,
            
    /*2*/ <0.9573,8.16178,-1.36189>,<0.96743,8.17247,-1.35235>,<0.94997,8.17314,-1.3507>,
            
    /*3*/ <0.96261,8.56984,-1.67762>,<0.96762,8.57426,-1.67194>,<0.95888,8.57478,-1.67141>,
            
    /*4*/ <1.07152,8.99551,-1.94631>

    /* stem 0.25.12*/ 
    /*0*/ <1.07603,7.89496,-1.0791>,
    /*1*/ <1.08442,7.89863,-1.06783>,<1.07379,7.90443,-1.08988>,<1.06988,7.88181,-1.07959>,
            
    /*2*/ <1.47871,7.72061,-1.30944>,<1.47162,7.72447,-1.32414>,<1.46901,7.70939,-1.31728>,
            
    /*3*/ <1.91619,7.66135,-1.5314>,<1.91276,7.66321,-1.53882>,<1.91301,7.65525,-1.53619>,
            
    /*4*/ <2.33295,7.78518,-1.76847>

    /* stem 0.25.13*/ 
    /*0*/ <1.15076,7.95665,-1.15484>,
    /*1*/ <1.13965,7.96138,-1.16195>,<1.16146,7.95074,-1.16169>,<1.15117,7.95783,-1.14089>,
            
    /*2*/ <1.35386,8.38989,-1.2022>,<1.3684,8.38279,-1.20203>,<1.36154,8.38752,-1.18816>,
            
    /*3*/ <1.55905,8.79684,-1.3518>,<1.56629,8.79325,-1.35184>,<1.56368,8.79701,-1.34517>,
            
    /*4*/ <1.84413,9.13366,-1.54416>

    /* stem 0.25.14*/ 
    /*0*/ <1.23954,8.02994,-1.24482>,
    /*1*/ <1.24807,8.01961,-1.2448>,<1.24421,8.04249,-1.2452>,<1.22633,8.02771,-1.24444>,
            
    /*2*/ <1.23382,8.01306,-1.70775>,<1.23124,8.02831,-1.70802>,<1.21933,8.01846,-1.70751>,
            
    /*3*/ <1.455,8.20558,-2.06643>,<1.45273,8.21261,-2.06414>,<1.44834,8.20853,-2.06903>,
            
    /*4*/ <1.81557,8.4485,-2.22458>

    /* stem 0.25.15*/ 
    /*0*/ <1.30156,8.08114,-1.30768>,
    /*1*/ <1.29918,8.09208,-1.30112>,<1.30172,8.08126,-1.32065>,<1.30378,8.07008,-1.30127>,
            
    /*2*/ <1.74135,8.18065,-1.29702>,<1.74304,8.17344,-1.31004>,<1.74441,8.16599,-1.29712>,
            
    /*3*/ <2.17972,8.28504,-1.29054>,<2.18076,8.28133,-1.29696>,<2.18151,8.27777,-1.29041>,
            
    /*4*/ <2.49539,8.57477,-1.42762>

    /* stem 0.25.16*/ 
    /*0*/ <1.38833,8.15871,-1.39683>,
    /*1*/ <1.38418,8.15248,-1.40667>,<1.40031,8.16168,-1.39599>,<1.3805,8.16197,-1.38782>,
            
    /*2*/ <1.30706,8.52886,-1.60716>,<1.31782,8.53499,-1.60004>,<1.30461,8.53518,-1.5946>,
            
    /*3*/ <1.30741,8.83517,-1.91123>,<1.31288,8.83844,-1.90801>,<1.30617,8.84016,-1.90628>,
            
    /*4*/ <1.30321,9.15345,-2.20549>

    /* stem 0.25.17*/ 
    /*0*/ <1.46225,8.2317,-1.47419>,
    /*1*/ <1.471,8.23129,-1.46623>,<1.46008,8.24174,-1.48008>,<1.45568,8.22208,-1.47627>,
            
    /*2*/ <1.73499,8.11381,-1.76802>,<1.72771,8.12078,-1.77725>,<1.72478,8.10767,-1.77472>,
            
    /*3*/ <2.10448,8.17911,-1.94502>,<2.10148,8.18249,-1.95015>,<2.10245,8.17574,-1.9506>,
            
    /*4*/ <2.42934,8.36082,-2.13543>

    /* stem 0.25.18*/ 
    /*0*/ <1.52939,8.29799,-1.54445>,
    /*1*/ <1.52034,8.30432,-1.54712>,<1.53596,8.29372,-1.55267>,<1.53186,8.29593,-1.53356>,
            
    /*2*/ <1.75263,8.63429,-1.53555>,<1.76304,8.62723,-1.53926>,<1.76031,8.6287,-1.52651>,
            
    /*3*/ <1.87195,8.98947,-1.67859>,<1.87745,8.98675,-1.6809>,<1.87732,8.98923,-1.67483>,
            
    /*4*/ <2.02246,9.30562,-1.88011>

    /* stem 0.25.19*/ 
    /*0*/ <1.56766,8.33578,-1.58451>,
    /*1*/ <1.573,8.3267,-1.58798>,<1.57337,8.34496,-1.58203>,<1.55662,8.33569,-1.58351>,
            
    /*2*/ <1.53644,8.45237,-1.96135>,<1.53669,8.46454,-1.95739>,<1.52552,8.45836,-1.95838>,
            
    /*3*/ <1.59571,8.67864,-2.28168>,<1.59564,8.6839,-2.27804>,<1.5902,8.6817,-2.2806>,
            
    /*4*/ <1.75281,8.98121,-2.48352>

    /* stem 0.25.20*/ 
    /*0*/ <1.63363,8.40092,-1.65355>,
    /*1*/ <1.63424,8.40805,-1.64624>,<1.63174,8.40366,-1.66321>,<1.63492,8.39106,-1.65118>,
            
    /*2*/ <2.00891,8.43934,-1.71254>,<2.00725,8.43641,-1.72386>,<2.00937,8.42801,-1.71584>,
            
    /*3*/ <2.31482,8.66218,-1.72872>,<2.31516,8.66135,-1.73456>,<2.318,8.65771,-1.73088>,
            
    /*4*/ <2.51139,8.98198,-1.66689>

    /* stem 0.25.21*/ 
    /*0*/ <1.72761,8.49372,-1.7519>,
    /*1*/ <1.72286,8.49164,-1.7584>,<1.73589,8.49394,-1.75271>,<1.72409,8.49557,-1.7446>,
            
    /*2*/ <1.70561,8.8405,-1.85356>,<1.7143,8.84203,-1.84976>,<1.70643,8.84312,-1.84435>,
            
    /*3*/ <1.75474,9.17341,-1.98718>,<1.75906,9.17364,-1.98509>,<1.75516,9.17517,-1.98273>,
            
    /*4*/ <1.85664,9.44178,-2.20707>

    /* stem 0.25.22*/ 
    /*0*/ <1.76391,8.53247,-1.79436>,
    /*1*/ <1.77039,8.53048,-1.79107>,<1.76275,8.53964,-1.79635>,<1.7586,8.52729,-1.79565>,
            
    /*2*/ <1.90933,8.46599,-2.11005>,<1.90423,8.4721,-2.11356>,<1.90147,8.46386,-2.1131>,
            
    /*3*/ <2.12079,8.55327,-2.37918>,<2.11793,8.55627,-2.38049>,<2.11766,8.55221,-2.38201>,
            
    /*4*/ <2.24385,8.81697,-2.58147>

    /* stem 0.25.23*/ 
    /*0*/ <1.83599,8.61467,-1.88676>,
    /*1*/ <1.83182,8.61879,-1.88635>,<1.83812,8.61316,-1.89202>,<1.83804,8.61208,-1.8819>,
            
    /*2*/ <2.07015,8.85501,-1.85917>,<2.07435,8.85126,-1.86295>,<2.0743,8.85054,-1.85621>,
            
    /*3*/ <2.22604,9.14949,-1.81996>,<2.22864,9.14839,-1.82183>,<2.22866,9.14793,-1.81847>,
            
    /*4*/ <2.38826,9.44352,-1.84478>

    /* stem 0.25.24*/ 
    /*0*/ <1.93469,8.72724,-2.01328>,
    /*1*/ <1.93551,8.72432,-2.01524>,<1.9372,8.72976,-2.01265>,<1.93135,8.72765,-2.01196>,
            
    /*2*/ <1.84965,8.8759,-2.27545>,<1.85078,8.87952,-2.27373>,<1.84688,8.87811,-2.27326>,
            
    /*3*/ <1.80595,9.09433,-2.49625>,<1.8066,9.0958,-2.49493>,<1.80458,9.0953,-2.49502>,
            
    /*4*/ <1.83049,9.36573,-2.65105>

    /* stem 0.25.25*/ 
    /*0*/ <1.99667,8.79794,-2.09275>,
    /*1*/ <1.99746,8.79912,-2.09108>,<1.99602,8.79894,-2.09458>,<1.99654,8.79576,-2.09258>,
            
    /*2*/ <2.27243,8.77289,-2.20389>,<2.27147,8.77277,-2.20622>,<2.27181,8.77065,-2.20489>,
            
    /*3*/ <2.51932,8.77442,-2.37174>,<2.51861,8.77437,-2.37278>,<2.519,8.77331,-2.37223>,
            
    /*4*/ <2.71867,8.89525,-2.55786>

    /* stem 0.25.26*/ 
    /*0*/ <2.043,8.85078,-2.15214>,
    /*1*/ <2.04212,8.85076,-2.15284>,<2.04404,8.85069,-2.15254>,<2.04283,8.85089,-2.15103>,
            
    /*2*/ <2.05747,9.13647,-2.17911>,<2.05875,9.13642,-2.17891>,<2.05794,9.13656,-2.1779>,
            
    /*3*/ <2.21034,9.3753,-2.22692>,<2.21089,9.37498,-2.22675>,<2.21054,9.3753,-2.2263>,
            
    /*4*/ <2.31682,9.63111,-2.30266>

    /* stem 0.26*/ 
    /*0*/ <0.07331,7.38817,0.00616>,
    /*1*/ <0.034,7.38908,0.00616>,<0.06195,7.42252,-0.00924>,<0.1056,7.40849,-0.00336>,
            <0.10462,7.36638,0.01568>,<0.06037,7.35439,0.02157>,
    /*2*/ <0.04838,7.66964,0.6273>,<0.07074,7.69639,0.61497>,<0.10566,7.68517,0.61968>,
            <0.10488,7.65148,0.63491>,<0.06948,7.64189,0.63962>,
    /*3*/ <0.0619,8.02068,1.21139>,<0.07864,8.03955,1.19988>,<0.10484,8.03165,1.20438>,
            <0.10429,8.00789,1.21867>,<0.07775,8.00111,1.22301>,
    /*4*/ <0.1249,8.37222,1.79408>,<0.1361,8.38432,1.78571>,<0.15348,8.37833,1.78768>,
            <0.15302,8.36252,1.79726>,<0.13536,8.35874,1.80122>,
    /*5*/ <0.10783,8.74414,2.36293>,<0.11337,8.75043,2.35905>,<0.12211,8.7481,2.36096>,
            <0.12197,8.74036,2.36601>,<0.11314,8.73791,2.36723>,
    /*6*/ <0.08418,9.22317,2.84724>

    /* stem 0.26.0*/ 
    /*0*/ <0.07438,7.43419,0.10797>,
    /*1*/ <0.09059,7.446,0.10247>,<0.07426,7.42466,0.12646>,<0.05829,7.4319,0.09499>,
            
    /*2*/ <-0.21071,7.97549,0.3772>,<-0.2216,7.96127,0.39319>,<-0.23225,7.96609,0.37221>,
            
    /*3*/ <-0.39471,8.4903,0.75959>,<-0.39985,8.48278,0.76741>,<-0.40625,8.48727,0.7583>,
            
    /*4*/ <-0.47911,8.98461,1.20055>

    /* stem 0.26.1*/ 
    /*0*/ <0.07595,7.50212,0.25827>,
    /*1*/ <0.07206,7.4842,0.26641>,<0.06775,7.51868,0.26607>,<0.08806,7.50348,0.24233>,
            
    /*2*/ <0.58419,7.55783,0.65737>,<0.58132,7.58082,0.65714>,<0.59486,7.57068,0.64132>,
            
    /*3*/ <1.02069,7.8688,1.02992>,<1.01611,7.87901,1.02693>,<1.02472,7.87446,1.02065>,
            
    /*4*/ <1.40292,8.25397,1.38634>

    /* stem 0.26.2*/ 
    /*0*/ <0.07717,7.55436,0.37385>,
    /*1*/ <0.06778,7.56997,0.3669>,<0.09065,7.5565,0.38777>,<0.07307,7.53662,0.36689>,
            
    /*2*/ <-0.37559,7.49375,0.81261>,<-0.36034,7.48477,0.82653>,<-0.37206,7.47151,0.8126>,
            
    /*3*/ <-0.69707,7.72959,1.29994>,<-0.68942,7.72547,1.3071>,<-0.69834,7.71925,1.30422>,
            
    /*4*/ <-0.7004,8.1055,1.80973>

    /* stem 0.26.3*/ 
    /*0*/ <0.07825,7.60116,0.47738>,
    /*1*/ <0.09596,7.59482,0.48006>,<0.06496,7.59805,0.49059>,<0.07384,7.61059,0.46149>,
            
    /*2*/ <0.23943,8.13127,0.75501>,<0.21876,8.13342,0.76203>,<0.22468,8.14178,0.74263>,
            
    /*3*/ <0.33405,8.63615,1.10247>,<0.32347,8.63627,1.10535>,<0.3268,8.64176,1.09646>,
            
    /*4*/ <0.34109,9.09318,1.52169>

    /* stem 0.26.4*/ 
    /*0*/ <0.07927,7.64476,0.57386>,
    /*1*/ <0.06173,7.63939,0.57647>,<0.08407,7.66243,0.57672>,<0.092,7.63247,0.56839>,
            
    /*2*/ <0.19305,7.51327,1.15545>,<0.20795,7.52862,1.15562>,<0.21323,7.50865,1.15007>,
            
    /*3*/ <0.19886,7.81924,1.67992>,<0.20598,7.82615,1.67592>,<0.20933,7.81736,1.68101>,
            
    /*4*/ <0.17845,8.26419,2.09266>

    /* stem 0.26.5*/ 
    /*0*/ <0.08019,7.69125,0.66443>,
    /*1*/ <0.08953,7.70447,0.65639>,<0.08346,7.68709,0.68172>,<0.06756,7.68218,0.65519>,
            
    /*2*/ <-0.32349,8.0948,0.83166>,<-0.32754,8.08321,0.84855>,<-0.33814,8.07994,0.83086>,
            
    /*3*/ <-0.70824,8.51736,0.99295>,<-0.7107,8.51196,1.00154>,<-0.71606,8.51045,0.99271>,
            
    /*4*/ <-0.96429,8.90244,1.36768>

    /* stem 0.26.6*/ 
    /*0*/ <0.08103,7.74385,0.75192>,
    /*1*/ <0.08375,7.72891,0.76088>,<0.07053,7.75635,0.7586>,<0.08881,7.7463,0.73629>,
            
    /*2*/ <0.54073,7.97654,1.02373>,<0.53192,7.99484,1.02221>,<0.54411,7.98814,1.00733>,
            
    /*3*/ <0.93993,8.29176,1.30974>,<0.93443,8.30021,1.30829>,<0.94148,8.29748,1.30146>,
            
    /*4*/ <1.28461,8.59108,1.67079>

    /* stem 0.26.7*/ 
    /*0*/ <0.08241,7.82909,0.89368>,
    /*1*/ <0.06967,7.83868,0.88804>,<0.09484,7.83606,0.9028>,<0.08271,7.81254,0.89021>,
            
    /*2*/ <-0.21378,7.73108,1.36195>,<-0.197,7.72933,1.37179>,<-0.20508,7.71365,1.3634>,
            
    /*3*/ <-0.55665,7.9082,1.76494>,<-0.54941,7.90758,1.77147>,<-0.55523,7.89989,1.76989>,
            
    /*4*/ <-0.86312,8.11519,2.18911>

    /* stem 0.26.8*/ 
    /*0*/ <0.0833,7.88432,0.98552>,
    /*1*/ <0.09975,7.88397,0.98557>,<0.07497,7.88174,0.99948>,<0.07517,7.88724,0.97152>,
            
    /*2*/ <0.10539,8.42333,1.09171>,<0.08887,8.42184,1.10098>,<0.08901,8.42551,1.08234>,
            
    /*3*/ <0.00185,8.89793,1.35363>,<-0.00629,8.89438,1.357>,<-0.0062,8.89898,1.34869>,
            
    /*4*/ <-0.07632,9.32677,1.68816>

    /* stem 0.26.9*/ 
    /*0*/ <0.08396,7.92543,1.0539>,
    /*1*/ <0.07142,7.91682,1.0592>,<0.0849,7.94117,1.0572>,<0.09557,7.9183,1.0453>,
            
    /*2*/ <0.34435,7.80823,1.5125>,<0.35333,7.82446,1.51117>,<0.36045,7.80921,1.50324>,
            
    /*3*/ <0.61083,7.94694,1.96445>,<0.61352,7.95492,1.9605>,<0.61883,7.94732,1.95972>,
            
    /*4*/ <0.82561,8.2983,2.31599>

    /* stem 0.26.10*/ 
    /*0*/ <0.08501,7.99093,1.16282>,
    /*1*/ <0.08802,8.004,1.15493>,<0.09316,7.98753,1.17565>,<0.07387,7.98125,1.15789>,
            
    /*2*/ <-0.26545,8.25677,1.44936>,<-0.26203,8.24579,1.46317>,<-0.27489,8.2416,1.45133>,
            
    /*3*/ <-0.63577,8.56701,1.64991>,<-0.63544,8.56251,1.65768>,<-0.64112,8.55991,1.65121>,
            
    /*4*/ <-0.90556,8.96374,1.86061>

    /* stem 0.26.11*/ 
    /*0*/ <0.09306,8.06846,1.29148>,
    /*1*/ <0.10018,8.05694,1.29776>,<0.08088,8.07414,1.29797>,<0.09813,8.0743,1.27871>,
            
    /*2*/ <0.38787,8.38301,1.55814>,<0.37501,8.39448,1.55828>,<0.38651,8.39458,1.54544>,
            
    /*3*/ <0.60544,8.69981,1.88848>,<0.5986,8.70502,1.88811>,<0.60518,8.70616,1.88267>,
            
    /*4*/ <0.66755,9.09262,2.20489>

    /* stem 0.26.12*/ 
    /*0*/ <0.10136,8.12131,1.37905>,
    /*1*/ <0.08791,8.1264,1.37725>,<0.11215,8.13037,1.38242>,<0.10401,8.10715,1.37748>,
            
    /*2*/ <0.00126,8.05418,1.85874>,<0.01742,8.05683,1.86219>,<0.01199,8.04134,1.85889>,
            
    /*3*/ <-0.04552,8.22246,2.32035>,<-0.03726,8.22375,2.32079>,<-0.04049,8.21639,2.32314>,
            
    /*4*/ <-0.0286,8.43444,2.76725>

    /* stem 0.26.13*/ 
    /*0*/ <0.11389,8.20122,1.51148>,
    /*1*/ <0.12697,8.20445,1.50829>,<0.11038,8.1988,1.52464>,<0.10434,8.20042,1.5015>,
            
    /*2*/ <0.02287,8.66501,1.56769>,<0.01181,8.66124,1.57859>,<0.00778,8.66232,1.56316>,
            
    /*3*/ <-0.03483,9.10197,1.74664>,<-0.04019,9.09919,1.75188>,<-0.04258,9.10181,1.74472>,
            
    /*4*/ <0.0886,9.43961,2.05672>

    /* stem 0.26.14*/ 
    /*0*/ <0.12339,8.26171,1.61172>,
    /*1*/ <0.11645,8.25225,1.61809>,<0.12083,8.2746,1.61409>,<0.13288,8.25829,1.60298>,
            
    /*2*/ <0.43148,8.25481,1.95575>,<0.4344,8.26971,1.95309>,<0.44243,8.25884,1.94568>,
            
    /*3*/ <0.6527,8.42061,2.32689>,<0.65294,8.42761,2.3237>,<0.65869,8.42263,2.3225>,
            
    /*4*/ <0.87646,8.70133,2.61928>

    /* stem 0.26.15*/ 
    /*0*/ <0.1342,8.33062,1.72591>,
    /*1*/ <0.1323,8.34154,1.71951>,<0.14218,8.33038,1.73591>,<0.12813,8.31995,1.72232>,
            
    /*2*/ <-0.20528,8.43873,1.9939>,<-0.19869,8.4313,2.00483>,<-0.20806,8.42434,1.99577>,
            
    /*3*/ <-0.46678,8.74803,2.1697>,<-0.46501,8.74573,2.17649>,<-0.47082,8.7428,2.173>,
            
    /*4*/ <-0.63806,9.1064,2.37146>

    /* stem 0.26.16*/ 
    /*0*/ <0.13811,8.40808,1.84953>,
    /*1*/ <0.14732,8.40159,1.85418>,<0.12922,8.41214,1.85682>,<0.1378,8.41053,1.83759>,
            
    /*2*/ <0.36444,8.76463,1.92065>,<0.35237,8.77166,1.92241>,<0.35809,8.77059,1.90959>,
            
    /*3*/ <0.59143,9.08873,2.08111>,<0.58553,9.09241,2.08219>,<0.58898,9.09301,2.07609>,
            
    /*4*/ <0.81401,9.36648,2.31828>

    /* stem 0.26.17*/ 
    /*0*/ <0.13491,8.45604,1.92282>,
    /*1*/ <0.12309,8.45596,1.92236>,<0.14072,8.46629,1.92398>,<0.14093,8.44587,1.92213>,
            
    /*2*/ <0.111,8.41824,2.33816>,<0.12275,8.42512,2.33924>,<0.1229,8.41151,2.33801>,
            
    /*3*/ <0.06235,8.67382,2.66399>,<0.06839,8.67674,2.66269>,<0.06803,8.67134,2.66686>,
            
    /*4*/ <0.16405,8.99409,2.91432>

    /* stem 0.26.18*/ 
    /*0*/ <0.13019,8.52677,2.03093>,
    /*1*/ <0.13896,8.53292,2.0273>,<0.13004,8.52287,2.04154>,<0.12158,8.52453,2.02396>,
            
    /*2*/ <-0.04917,8.86677,2.14931>,<-0.05512,8.86007,2.15881>,<-0.06076,8.86118,2.14708>,
            
    /*3*/ <-0.1298,9.18913,2.37439>,<-0.13249,9.18533,2.37897>,<-0.13618,9.18776,2.37416>,
            
    /*4*/ <-0.18187,9.50733,2.61452>

    /* stem 0.26.19*/ 
    /*0*/ <0.12516,8.60211,2.14608>,
    /*1*/ <0.12313,8.59324,2.1518>,<0.1188,8.61072,2.14708>,<0.13356,8.60238,2.13937>,
            
    /*2*/ <0.34753,8.72852,2.43477>,<0.34464,8.74017,2.43162>,<0.35448,8.73461,2.42648>,
            
    /*3*/ <0.43583,8.94716,2.74065>,<0.4338,8.95222,2.73767>,<0.43975,8.95051,2.73718>,
            
    /*4*/ <0.37731,9.21418,3.01309>

    /* stem 0.26.20*/ 
    /*0*/ <0.12179,8.65267,2.22336>,
    /*1*/ <0.11703,8.65974,2.21853>,<0.12971,8.65486,2.22869>,<0.11864,8.64341,2.22285>,
            
    /*2*/ <-0.09911,8.71528,2.51934>,<-0.09066,8.71203,2.52612>,<-0.09804,8.70439,2.52223>,
            
    /*3*/ <-0.18986,8.89214,2.83641>,<-0.18512,8.89027,2.83886>,<-0.18987,8.88723,2.8392>,
            
    /*4*/ <-0.1662,9.12578,3.12823>

    /* stem 0.26.21*/ 
    /*0*/ <0.11829,8.70519,2.30362>,
    /*1*/ <0.1264,8.70275,2.30557>,<0.11239,8.70608,2.30994>,<0.11607,8.70672,2.29536>,
            
    /*2*/ <0.21868,9.05175,2.34405>,<0.20934,9.05397,2.34696>,<0.2118,9.05439,2.33725>,
            
    /*3*/ <0.3277,9.37657,2.46207>,<0.32304,9.37763,2.46358>,<0.3245,9.37883,2.45894>,
            
    /*4*/ <0.28904,9.70291,2.61872>

    /* stem 0.26.22*/ 
    /*0*/ <0.11307,8.78394,2.4034>,
    /*1*/ <0.10624,8.78208,2.4048>,<0.11495,8.7909,2.40327>,<0.11801,8.77884,2.40213>,
            
    /*2*/ <0.18186,8.76924,2.74393>,<0.18766,8.77513,2.74291>,<0.1897,8.76709,2.74215>,
            
    /*3*/ <0.23738,8.89431,3.06386>,<0.24011,8.89707,3.06234>,<0.24141,8.89331,3.06358>,
            
    /*4*/ <0.2374,9.13843,3.31139>

    /* stem 0.26.23*/ 
    /*0*/ <0.1075,8.86863,2.48898>,
    /*1*/ <0.11052,8.87226,2.48559>,<0.10855,8.86845,2.49471>,<0.10342,8.86519,2.48666>,
            
    /*2*/ <-0.11936,9.10806,2.53649>,<-0.12067,9.10552,2.54257>,<-0.12409,9.10334,2.53721>,
            
    /*3*/ <-0.33179,9.36248,2.56694>,<-0.33264,9.36142,2.57002>,<-0.33434,9.36033,2.56733>,
            
    /*4*/ <-0.41706,9.68086,2.61171>

    /* stem 0.26.24*/ 
    /*0*/ <0.09837,9.00737,2.62918>,
    /*1*/ <0.09891,9.0049,2.63166>,<0.09567,9.00964,2.62949>,<0.10054,9.00758,2.62639>,
            
    /*2*/ <0.28102,9.20144,2.78661>,<0.27886,9.20461,2.78517>,<0.28211,9.20323,2.7831>,
            
    /*3*/ <0.48611,9.39806,2.9098>,<0.48501,9.39964,2.90911>,<0.48649,9.39884,2.90794>,
            
    /*4*/ <0.68718,9.59148,3.04375>

    /* stem 0.26.25*/ 
    /*0*/ <0.09521,9.05553,2.67785>,
    /*1*/ <0.09314,9.05676,2.6765>,<0.09713,9.05705,2.6791>,<0.09535,9.05279,2.67794>,
            
    /*2*/ <-0.0707,9.05643,2.92936>,<-0.06804,9.05663,2.93109>,<-0.06922,9.05378,2.93032>,
            
    /*3*/ <-0.14808,9.15788,3.2025>,<-0.14655,9.15791,3.20293>,<-0.14741,9.1566,3.20317>,
            
    /*4*/ <-0.16837,9.3693,3.41608>

    /* stem 0.26.26*/ 
    /*0*/ <0.0868,9.18337,2.80702>,
    /*1*/ <0.08745,9.18338,2.80706>,<0.08644,9.18331,2.80757>,<0.0865,9.18342,2.80645>,
            
    /*2*/ <0.08145,9.46152,2.83357>,<0.08078,9.46147,2.83391>,<0.08081,9.46154,2.83316>,
            
    /*3*/ <0.17225,9.7139,2.91149>,<0.17194,9.71395,2.9117>,<0.17195,9.71406,2.91133>,
            
    /*4*/ <0.223,9.91727,3.09636>

    /* stem 0.27*/ 
    /*0*/ <0.0774,7.56483,0.0065>,
    /*1*/ <0.10698,7.56419,-0.01832>,<0.09776,7.59729,0.01136>,<0.06041,7.58553,0.03433>,
            <0.04654,7.54516,0.01884>,<0.07532,7.53198,-0.0137>,
    /*2*/ <-0.27893,7.87165,-0.47397>,<-0.2863,7.89812,-0.45022>,<-0.31619,7.88871,-0.43185>,
            <-0.32728,7.85642,-0.44424>,<-0.30425,7.84588,-0.47027>,
    /*3*/ <-0.7232,8.20833,-0.85612>,<-0.72693,8.22647,-0.83614>,<-0.74745,8.21769,-0.82052>,
            <-0.7564,8.19413,-0.83085>,<-0.74142,8.18834,-0.85285>,
    /*4*/ <-1.052,8.61031,-1.27594>,<-1.0543,8.62249,-1.26267>,<-1.06997,8.61876,-1.25427>,
            <-1.07735,8.60427,-1.26236>,<-1.06625,8.59905,-1.27575>,
    /*5*/ <-1.33856,9.08606,-1.65345>,<-1.33925,9.09148,-1.64621>,<-1.34728,9.0899,-1.64227>,
            <-1.35156,9.08351,-1.64709>,<-1.34617,9.08113,-1.654>,
    /*6*/ <-1.54075,9.6559,-1.9456>

    /* stem 0.27.0*/ 
    /*0*/ <0.01502,7.61528,-0.06911>,
    /*1*/ <0.00704,7.62722,-0.05457>,<0.00285,7.60673,-0.08312>,<0.03516,7.61191,-0.06965>,
            
    /*2*/ <0.08735,8.14884,-0.44817>,<0.08456,8.13518,-0.4672>,<0.1061,8.13864,-0.45822>,
            
    /*3*/ <-0.19533,8.60424,-0.8264>,<-0.19695,8.59628,-0.83495>,<-0.18705,8.60267,-0.83465>,
            
    /*4*/ <-0.57173,8.87054,-1.2983>

    /* stem 0.27.1*/ 
    /*0*/ <-0.05388,7.67101,-0.15263>,
    /*1*/ <-0.05722,7.65354,-0.16153>,<-0.04989,7.68714,-0.16356>,<-0.05453,7.67235,-0.1328>,
            
    /*2*/ <-0.68475,7.79467,-0.18836>,<-0.67986,7.81706,-0.18971>,<-0.68296,7.80721,-0.1692>,
            
    /*3*/ <-1.24792,8.10495,-0.25704>,<-1.24244,8.11504,-0.25732>,<-1.24604,8.11073,-0.24731>,
            
    /*4*/ <-1.61355,8.58613,-0.48287>

    /* stem 0.27.2*/ 
    /*0*/ <-0.13858,7.73951,-0.2553>,
    /*1*/ <-0.12614,7.75415,-0.2558>,<-0.15736,7.74294,-0.25308>,<-0.13224,7.72145,-0.25703>,
            
    /*2*/ <-0.19734,7.78511,-0.87676>,<-0.21816,7.77763,-0.87495>,<-0.20141,7.7633,-0.87758>,
            
    /*3*/ <-0.36326,8.03973,-1.4213>,<-0.37366,8.0361,-1.41994>,<-0.3662,8.02976,-1.42517>,
            
    /*4*/ <-0.59238,8.4367,-1.84628>

    /* stem 0.27.3*/ 
    /*0*/ <-0.18928,7.78052,-0.31676>,
    /*1*/ <-0.2048,7.77508,-0.30759>,<-0.18793,7.77788,-0.33535>,<-0.17512,7.78859,-0.30735>,
            
    /*2*/ <-0.4505,8.33002,-0.40738>,<-0.43925,8.33188,-0.42589>,<-0.43071,8.33902,-0.40722>,
            
    /*3*/ <-0.57477,8.81815,-0.76762>,<-0.56711,8.81501,-0.77466>,<-0.56455,8.8217,-0.76649>,
            
    /*4*/ <-0.54957,9.21455,-1.23953>

    /* stem 0.27.4*/ 
    /*0*/ <-0.26181,7.83917,-0.40467>,
    /*1*/ <-0.25057,7.83334,-0.41783>,<-0.26864,7.8561,-0.40534>,<-0.26621,7.82808,-0.39085>,
            
    /*2*/ <-0.72481,7.63316,-0.72544>,<-0.73685,7.64833,-0.71711>,<-0.73524,7.62966,-0.70744>,
            
    /*3*/ <-1.09194,7.80614,-1.16573>,<-1.09597,7.81368,-1.15955>,<-1.10032,7.80408,-1.15967>,
            
    /*4*/ <-1.27572,8.22002,-1.5585>

    /* stem 0.27.5*/ 
    /*0*/ <-0.33323,7.89566,-0.48115>,
    /*1*/ <-0.33426,7.90844,-0.46888>,<-0.34805,7.88821,-0.48746>,<-0.31739,7.89034,-0.48711>,
            
    /*2*/ <-0.35722,8.30829,-0.89577>,<-0.36641,8.2948,-0.90815>,<-0.34598,8.29622,-0.90792>,
            
    /*3*/ <-0.48215,8.7644,-1.23708>,<-0.48703,8.75825,-1.24366>,<-0.47703,8.76011,-1.24484>,
            
    /*4*/ <-0.8221,9.17569,-1.47628>

    /* stem 0.27.6*/ 
    /*0*/ <-0.41185,7.95597,-0.55053>,
    /*1*/ <-0.41947,7.94113,-0.55478>,<-0.40848,7.96771,-0.56266>,<-0.4076,7.95907,-0.53414>,
            
    /*2*/ <-0.92845,8.18371,-0.46557>,<-0.92112,8.20143,-0.47082>,<-0.92053,8.19567,-0.4518>,
            
    /*3*/ <-1.3499,8.54202,-0.31263>,<-1.3445,8.54979,-0.31566>,<-1.34379,8.54662,-0.30627>,
            
    /*4*/ <-1.59799,9.05506,-0.25358>

    /* stem 0.27.7*/ 
    /*0*/ <-0.46803,7.99907,-0.6001>,
    /*1*/ <-0.45563,8.00918,-0.60537>,<-0.48351,8.00526,-0.59775>,<-0.46495,7.98277,-0.59719>,
            
    /*2*/ <-0.58835,7.88643,-1.13588>,<-0.60694,7.88382,-1.1308>,<-0.59456,7.86883,-1.13043>,
            
    /*3*/ <-0.7326,7.83201,-1.67399>,<-0.74187,7.83059,-1.67145>,<-0.73585,7.82301,-1.6723>,
            
    /*4*/ <-1.06746,7.88937,-2.12095>

    /* stem 0.27.8*/ 
    /*0*/ <-0.56281,8.07177,-0.68374>,
    /*1*/ <-0.57391,8.07083,-0.67197>,<-0.56647,8.06687,-0.69875>,<-0.54803,8.0776,-0.6805>,
            
    /*2*/ <-0.7413,8.57188,-0.79743>,<-0.73634,8.56924,-0.81529>,<-0.72405,8.5764,-0.80312>,
            
    /*3*/ <-1.05743,8.99835,-0.89905>,<-1.05563,8.9976,-0.9082>,<-1.05018,9.00294,-0.90278>,
            
    /*4*/ <-1.38791,9.38428,-1.09205>

    /* stem 0.27.9*/ 
    /*0*/ <-0.64731,8.13659,-0.75831>,
    /*1*/ <-0.6424,8.12858,-0.77083>,<-0.65142,8.15162,-0.75975>,<-0.6481,8.12956,-0.74434>,
            
    /*2*/ <-1.14063,7.98574,-0.86818>,<-1.14664,8.00111,-0.8608>,<-1.14443,7.9864,-0.85052>,
            
    /*3*/ <-1.62698,8.12655,-1.02229>,<-1.62638,8.13417,-1.01747>,<-1.62975,8.12668,-1.01369>,
            
    /*4*/ <-2.06713,8.41586,-1.0705>

    /* stem 0.27.10*/ 
    /*0*/ <-0.70468,8.1806,-0.80894>,
    /*1*/ <-0.70155,8.19346,-0.80131>,<-0.71917,8.17609,-0.81069>,<-0.69332,8.17225,-0.81482>,
            
    /*2*/ <-0.73296,8.45789,-1.24419>,<-0.74471,8.44631,-1.25044>,<-0.72747,8.44375,-1.2532>,
            
    /*3*/ <-0.79275,8.86284,-1.55377>,<-0.79904,8.85857,-1.55825>,<-0.79061,8.8579,-1.56076>,
            
    /*4*/ <-0.94591,9.28319,-1.81196>

    /* stem 0.27.11*/ 
    /*0*/ <-0.7569,8.22915,-0.86271>,
    /*1*/ <-0.76792,8.21918,-0.86376>,<-0.75271,8.23691,-0.87472>,<-0.75008,8.23137,-0.84966>,
            
    /*2*/ <-1.10082,8.58242,-0.74856>,<-1.09068,8.59423,-0.75586>,<-1.08893,8.59054,-0.73916>,
            
    /*3*/ <-1.42623,8.96827,-0.78671>,<-1.42017,8.97311,-0.79042>,<-1.42109,8.97318,-0.78187>,
            
    /*4*/ <-1.728,9.3521,-0.91986>

    /* stem 0.27.12*/ 
    /*0*/ <-0.84028,8.33282,-0.97226>,
    /*1*/ <-0.82799,8.33611,-0.9785>,<-0.84885,8.34311,-0.96764>,<-0.84399,8.31924,-0.97065>,
            
    /*2*/ <-1.05365,8.34424,-1.40808>,<-1.06756,8.3489,-1.40084>,<-1.06431,8.333,-1.40285>,
            
    /*3*/ <-1.30287,8.51353,-1.78867>,<-1.30908,8.5156,-1.78377>,<-1.30888,8.50818,-1.7872>,
            
    /*4*/ <-1.58175,8.87334,-1.95901>

    /* stem 0.27.13*/ 
    /*0*/ <-0.88561,8.38919,-1.03183>,
    /*1*/ <-0.89372,8.3935,-1.02157>,<-0.89113,8.38553,-1.0439>,<-0.87197,8.38852,-1.03001>,
            
    /*2*/ <-0.84884,8.83829,-1.17933>,<-0.84711,8.83298,-1.19422>,<-0.83433,8.83498,-1.18496>,
            
    /*3*/ <-0.88913,9.27306,-1.36257>,<-0.88832,9.27012,-1.36991>,<-0.8819,9.27243,-1.36583>,
            
    /*4*/ <-1.00588,9.67898,-1.57757>

    /* stem 0.27.14*/ 
    /*0*/ <-0.97393,8.49901,-1.14788>,
    /*1*/ <-0.97347,8.48974,-1.157>,<-0.96927,8.51089,-1.15043>,<-0.97905,8.4964,-1.1362>,
            
    /*2*/ <-1.38068,8.62026,-1.30394>,<-1.37788,8.63436,-1.29956>,<-1.3844,8.6247,-1.29008>,
            
    /*3*/ <-1.7452,8.77307,-1.52214>,<-1.74364,8.78008,-1.51995>,<-1.74803,8.77571,-1.5157>,
            
    /*4*/ <-1.9911,9.05262,-1.77967>

    /* stem 0.27.15*/ 
    /*0*/ <-1.0317,8.57084,-1.22379>,
    /*1*/ <-1.025,8.58058,-1.21967>,<-1.0438,8.57232,-1.22664>,<-1.0263,8.55962,-1.22505>,
            
    /*2*/ <-0.91787,8.67645,-1.63322>,<-0.93041,8.67095,-1.63787>,<-0.91874,8.66248,-1.63681>,
            
    /*3*/ <-0.87993,8.93189,-1.98424>,<-0.88622,8.92941,-1.98679>,<-0.88005,8.92608,-1.98855>,
            
    /*4*/ <-0.96995,9.18273,-2.33242>

    /* stem 0.27.16*/ 
    /*0*/ <-1.07799,8.63473,-1.2853>,
    /*1*/ <-1.08887,8.62968,-1.28361>,<-1.07433,8.63762,-1.29648>,<-1.07078,8.6369,-1.27582>,
            
    /*2*/ <-1.25825,9.018,-1.24096>,<-1.24856,9.02329,-1.24954>,<-1.24619,9.02281,-1.23577>,
            
    /*3*/ <-1.43269,9.40425,-1.28323>,<-1.42751,9.40618,-1.28752>,<-1.42692,9.40721,-1.28063>,
            
    /*4*/ <-1.63228,9.75759,-1.41137>

    /* stem 0.27.17*/ 
    /*0*/ <-1.1325,8.72708,-1.35959>,
    /*1*/ <-1.1235,8.72655,-1.36685>,<-1.13614,8.73734,-1.35563>,<-1.13785,8.71737,-1.35627>,
            
    /*2*/ <-1.38231,8.75889,-1.68338>,<-1.39074,8.76608,-1.6759>,<-1.39188,8.75277,-1.67632>,
            
    /*3*/ <-1.56869,8.94717,-1.99534>,<-1.57253,8.95058,-1.99106>,<-1.57457,8.94466,-1.99341>,
            
    /*4*/ <-1.74622,9.25684,-2.19849>

    /* stem 0.27.18*/ 
    /*0*/ <-1.17593,8.80068,-1.41878>,
    /*1*/ <-1.17919,8.80613,-1.40961>,<-1.18307,8.7992,-1.42722>,<-1.16553,8.79671,-1.41951>,
            
    /*2*/ <-1.05852,9.14749,-1.57409>,<-1.06111,9.14286,-1.58583>,<-1.04941,9.14121,-1.58069>,
            
    /*3*/ <-0.89415,9.45787,-1.76248>,<-0.89544,9.45516,-1.76817>,<-0.88983,9.45398,-1.76523>,
            
    /*4*/ <-0.91,9.75509,-2.02642>

    /* stem 0.27.19*/ 
    /*0*/ <-1.21664,8.86966,-1.47427>,
    /*1*/ <-1.22018,8.86211,-1.48106>,<-1.21267,8.87891,-1.47809>,<-1.21708,8.86798,-1.46364>,
            
    /*2*/ <-1.57188,9.02061,-1.46845>,<-1.56687,9.03181,-1.46647>,<-1.56981,9.02452,-1.45684>,
            
    /*3*/ <-1.83877,9.29391,-1.53113>,<-1.83461,9.29834,-1.52986>,<-1.83811,9.29596,-1.5253>,
            
    /*4*/ <-2.05654,9.53417,-1.73887>

    /* stem 0.27.20*/ 
    /*0*/ <-1.27825,8.97405,-1.55823>,
    /*1*/ <-1.27064,8.97966,-1.55684>,<-1.28698,8.97789,-1.55873>,<-1.27712,8.96461,-1.55912>,
            
    /*2*/ <-1.23525,9.01668,-1.92153>,<-1.24614,9.0155,-1.92279>,<-1.23957,9.00665,-1.92305>,
            
    /*3*/ <-1.22544,9.14626,-2.26544>,<-1.2309,9.14564,-2.26587>,<-1.22754,9.14152,-2.26733>,
            
    /*4*/ <-1.2385,9.38492,-2.54494>

    /* stem 0.27.21*/ 
    /*0*/ <-1.31674,9.03928,-1.61069>,
    /*1*/ <-1.32431,9.0376,-1.60722>,<-1.31616,9.04097,-1.61899>,<-1.30976,9.03926,-1.60586>,
            
    /*2*/ <-1.36781,9.38588,-1.54077>,<-1.36238,9.38812,-1.54861>,<-1.35811,9.38698,-1.53986>,
            
    /*3*/ <-1.35038,9.73863,-1.60476>,<-1.34743,9.73782,-1.60859>,<-1.34552,9.73853,-1.60413>,
            
    /*4*/ <-1.34356,10.09132,-1.6604>

    /* stem 0.27.22*/ 
    /*0*/ <-1.36139,9.13526,-1.67408>,
    /*1*/ <-1.35755,9.13362,-1.67977>,<-1.36188,9.14198,-1.67197>,<-1.36474,9.13018,-1.6705>,
            
    /*2*/ <-1.63452,9.17633,-1.87633>,<-1.63741,9.18191,-1.87113>,<-1.63932,9.17404,-1.87015>,
            
    /*3*/ <-1.85238,9.34863,-2.07629>,<-1.85325,9.35115,-2.07321>,<-1.85544,9.34775,-2.07375>,
            
    /*4*/ <-1.99685,9.58926,-2.272>

    /* stem 0.27.23*/ 
    /*0*/ <-1.40483,9.26137,-1.73984>,
    /*1*/ <-1.40436,9.26396,-1.73519>,<-1.40931,9.26185,-1.74273>,<-1.40083,9.2583,-1.74161>,
            
    /*2*/ <-1.27735,9.51827,-1.89163>,<-1.28065,9.51686,-1.89665>,<-1.27499,9.51449,-1.89591>,
            
    /*3*/ <-1.21043,9.79705,-2.04329>,<-1.21215,9.79617,-2.0457>,<-1.20914,9.79549,-2.04562>,
            
    /*4*/ <-1.22369,10.09173,-2.17823>

    /* stem 0.27.24*/ 
    /*0*/ <-1.4384,9.35881,-1.79066>,
    /*1*/ <-1.44114,9.35676,-1.79279>,<-1.43593,9.3614,-1.79252>,<-1.43813,9.35828,-1.78668>,
            
    /*2*/ <-1.64602,9.58587,-1.74749>,<-1.64255,9.58896,-1.74731>,<-1.64401,9.58688,-1.74341>,
            
    /*3*/ <-1.75947,9.85723,-1.84771>,<-1.75736,9.85819,-1.84753>,<-1.75883,9.85824,-1.84572>,
            
    /*4*/ <-1.78173,10.11887,-2.01391>

    /* stem 0.27.25*/ 
    /*0*/ <-1.47951,9.47813,-1.85288>,
    /*1*/ <-1.47721,9.47884,-1.85303>,<-1.48119,9.47964,-1.85204>,<-1.48012,9.4759,-1.85358>,
            
    /*2*/ <-1.52615,9.57665,-2.1257>,<-1.5288,9.57719,-2.12504>,<-1.52809,9.5747,-2.12606>,
            
    /*3*/ <-1.58478,9.76723,-2.34135>,<-1.58607,9.7674,-2.34085>,<-1.58582,9.76641,-2.3418>,
            
    /*4*/ <-1.68953,10.02565,-2.43411>

    /* stem 0.27.26*/ 
    /*0*/ <-1.51614,9.58447,-1.90835>,
    /*1*/ <-1.5169,9.58453,-1.90774>,<-1.51626,9.58466,-1.90929>,<-1.51527,9.58423,-1.90801>,
            
    /*2*/ <-1.46029,9.85349,-1.86138>,<-1.45987,9.85358,-1.86241>,<-1.45921,9.85329,-1.86156>,
            
    /*3*/ <-1.44381,10.12938,-1.82571>,<-1.4436,10.12944,-1.82622>,<-1.44325,10.12936,-1.82579>,
            
    /*4*/ <-1.55372,10.38538,-1.82046>

    /* stem 0.28*/ 
    /*0*/ <0.08065,7.70512,0.00678>,
    /*1*/ <0.07404,7.7052,0.04427>,<0.06274,7.73756,0.0155>,<0.07619,7.72509,-0.02532>,
            <0.09581,7.68503,-0.02178>,<0.09448,7.67273,0.02123>,
    /*2*/ <0.66054,8.00075,0.13931>,<0.65149,8.02664,0.11629>,<0.66226,8.01666,0.08363>,
            <0.67795,7.98461,0.08647>,<0.67689,7.97478,0.12088>,
    /*3*/ <1.21316,8.37615,0.12603>,<1.20175,8.39262,0.10815>,<1.20765,8.38355,0.08357>,
            <1.22271,8.36148,0.08626>,<1.22611,8.35691,0.1125>,
    /*4*/ <1.66816,8.85742,0.13441>,<1.65862,8.86681,0.12252>,<1.66411,8.86217,0.10613>,
            <1.67704,8.84991,0.10788>,<1.67954,8.84698,0.12536>,
    /*5*/ <2.09534,9.36523,0.13854>,<2.09029,9.3696,0.13259>,<2.09313,9.3674,0.1244>,
            <2.09995,9.36166,0.12529>,<2.10131,9.36032,0.13403>,
    /*6*/ <2.38557,9.95973,0.18153>

    /* stem 0.28.0*/ 
    /*0*/ <0.20118,7.766,0.0279>,
    /*1*/ <0.19821,7.77749,0.01178>,<0.21876,7.7568,0.03052>,<0.18659,7.76372,0.04139>,
            
    /*2*/ <0.41983,8.28763,0.34267>,<0.43354,8.27384,0.35516>,<0.41209,8.27845,0.36241>,
            
    /*3*/ <0.70683,8.69176,0.76335>,<0.71225,8.68286,0.76836>,<0.70188,8.68621,0.7722>,
            
    /*4*/ <1.03599,9.09863,1.14357>

    /* stem 0.28.1*/ 
    /*0*/ <0.32536,7.82872,0.04966>,
    /*1*/ <0.33315,7.81164,0.05448>,<0.32765,7.84406,0.0613>,<0.31528,7.83048,0.03319>,
            
    /*2*/ <0.85903,7.97139,-0.25405>,<0.85536,7.993,-0.2495>,<0.84712,7.98395,-0.26824>,
            
    /*3*/ <1.34586,8.33405,-0.43552>,<1.34052,8.3432,-0.4319>,<1.33917,8.33974,-0.44246>,
            
    /*4*/ <1.8587,8.67025,-0.5793>

    /* stem 0.28.2*/ 
    /*0*/ <0.42039,7.87672,0.06631>,
    /*1*/ <0.41157,7.8914,0.07432>,<0.43298,7.87964,0.0525>,<0.41662,7.85912,0.0721>,
            
    /*2*/ <0.86518,7.92807,0.49148>,<0.87945,7.92023,0.47693>,<0.86855,7.90655,0.49>,
            
    /*3*/ <1.33746,8.28927,0.6473>,<1.34338,8.28525,0.63905>,<1.34376,8.2805,0.64888>,
            
    /*4*/ <1.73247,8.76111,0.68483>

    /* stem 0.28.3*/ 
    /*0*/ <0.5237,7.9289,0.08441>,
    /*1*/ <0.52946,7.92323,0.06789>,<0.53379,7.92536,0.09938>,<0.50785,7.93811,0.08597>,
            
    /*2*/ <0.82263,8.4458,-0.0024>,<0.82551,8.44722,0.0186>,<0.80822,8.45572,0.00966>,
            
    /*3*/ <1.17557,8.93572,-0.00999>,<1.17632,8.93545,0.0006>,<1.16854,8.94099,-0.00404>,
            
    /*4*/ <1.54628,9.41015,-0.04248>

    /* stem 0.28.4*/ 
    /*0*/ <0.63045,7.98282,0.10311>,
    /*1*/ <0.63021,7.97738,0.12013>,<0.63512,7.9996,0.09916>,<0.62601,7.97147,0.09005>,
            
    /*2*/ <1.1929,7.81185,0.06882>,<1.19617,7.82666,0.05484>,<1.1901,7.80791,0.04877>,
            
    /*3*/ <1.76963,7.93451,0.06389>,<1.76807,7.94198,0.05695>,<1.77009,7.93236,0.05381>,
            
    /*4*/ <2.22939,8.2212,0.28999>

    /* stem 0.28.5*/ 
    /*0*/ <0.74167,8.05233,0.10848>,
    /*1*/ <0.7337,8.06388,0.09838>,<0.75855,8.04923,0.10641>,<0.73276,8.04389,0.12066>,
            
    /*2*/ <0.85859,8.47402,0.47845>,<0.87517,8.46425,0.4838>,<0.85797,8.46069,0.4933>,
            
    /*3*/ <1.01403,8.9942,0.6497>,<1.02285,8.99065,0.65276>,<1.0151,8.99089,0.65906>,
            
    /*4*/ <1.07706,9.53996,0.80975>

    /* stem 0.28.6*/ 
    /*0*/ <0.84367,8.12179,0.10736>,
    /*1*/ <0.85307,8.10797,0.10612>,<0.84654,8.13279,0.11967>,<0.83141,8.1246,0.0963>,
            
    /*2*/ <1.20897,8.38617,-0.22168>,<1.20462,8.40271,-0.21265>,<1.19453,8.39726,-0.22823>,
            
    /*3*/ <1.61865,8.7424,-0.3553>,<1.61457,8.74927,-0.34986>,<1.61221,8.74847,-0.35921>,
            
    /*4*/ <2.00384,9.11816,-0.20507>

    /* stem 0.28.7*/ 
    /*0*/ <0.93863,8.18645,0.10632>,
    /*1*/ <0.93216,8.19614,0.11767>,<0.94562,8.19291,0.09314>,<0.93812,8.1703,0.10816>,
            
    /*2*/ <1.41218,8.20733,0.37413>,<1.42115,8.20518,0.35778>,<1.41615,8.19011,0.36779>,
            
    /*3*/ <1.86211,8.43218,0.57688>,<1.86643,8.4312,0.5686>,<1.86695,8.42436,0.57501>,
            
    /*4*/ <2.25327,8.79485,0.68299>

    /* stem 0.28.8*/ 
    /*0*/ <1.05182,8.26352,0.10508>,
    /*1*/ <1.05259,8.26214,0.08949>,<1.06496,8.26336,0.11362>,<1.03791,8.26506,0.11214>,
            
    /*2*/ <1.08788,8.78739,0.05005>,<1.09613,8.7882,0.06614>,<1.07809,8.78934,0.06515>,
            
    /*3*/ <1.2074,9.29676,-0.01548>,<1.21155,9.2969,-0.00744>,<1.20274,9.29889,-0.00802>,
            
    /*4*/ <1.38581,9.78877,-0.08407>

    /* stem 0.28.9*/ 
    /*0*/ <1.18062,8.35122,0.10367>,
    /*1*/ <1.18546,8.3443,0.11608>,<1.18254,8.36602,0.1021>,<1.17385,8.34334,0.09284>,
            
    /*2*/ <1.63467,8.26439,-0.11003>,<1.63272,8.27887,-0.11935>,<1.62693,8.26375,-0.12552>,
            
    /*3*/ <2.02942,8.55897,-0.24799>,<2.02396,8.56498,-0.25102>,<2.02683,8.5587,-0.25626>,
            
    /*4*/ <2.42137,8.88221,-0.26861>

    /* stem 0.28.10*/ 
    /*0*/ <1.26562,8.42856,0.1051>,
    /*1*/ <1.25551,8.43823,0.10119>,<1.27896,8.4293,0.09941>,<1.26239,8.41816,0.1147>,
            
    /*2*/ <1.40017,8.73248,0.47248>,<1.4158,8.72653,0.4713>,<1.40475,8.7191,0.48149>,
            
    /*3*/ <1.60794,9.0946,0.73797>,<1.6155,9.09117,0.73686>,<1.61085,9.08899,0.74348>,
            
    /*4*/ <1.79908,9.47502,0.99066>

    /* stem 0.28.11*/ 
    /*0*/ <1.3245,8.49098,0.10717>,
    /*1*/ <1.33398,8.48223,0.10133>,<1.32832,8.49943,0.11786>,<1.3112,8.49127,0.10232>,
            
    /*2*/ <1.4541,8.83059,-0.21408>,<1.45033,8.84206,-0.20306>,<1.43892,8.83662,-0.21342>,
            
    /*3*/ <1.57954,9.27093,-0.38079>,<1.57672,9.2744,-0.37395>,<1.57176,9.27338,-0.38037>,
            
    /*4*/ <1.75621,9.71484,-0.46474>

    /* stem 0.28.12*/ 
    /*0*/ <1.40265,8.57382,0.10991>,
    /*1*/ <1.39815,8.57766,0.12224>,<1.40591,8.58326,0.10056>,<1.40391,8.56053,0.10692>,
            
    /*2*/ <1.84289,8.58212,0.27837>,<1.84806,8.58585,0.26392>,<1.84673,8.57069,0.26816>,
            
    /*3*/ <2.17856,8.90358,0.35096>,<2.1792,8.90476,0.34317>,<2.18366,8.8993,0.34672>,
            
    /*4*/ <2.50605,9.23241,0.43272>

    /* stem 0.28.13*/ 
    /*0*/ <1.48841,8.66471,0.11291>,
    /*1*/ <1.48624,8.66718,0.10017>,<1.50065,8.66248,0.11719>,<1.47833,8.66448,0.12138>,
            
    /*2*/ <1.54155,9.11283,0.18148>,<1.55115,9.10969,0.19283>,<1.53627,9.11103,0.19562>,
            
    /*3*/ <1.80215,9.48433,0.14674>,<1.80669,9.48174,0.15225>,<1.80071,9.48609,0.15399>,
            
    /*4*/ <2.12095,9.79605,0.05131>

    /* stem 0.28.14*/ 
    /*0*/ <1.56048,8.74111,0.11544>,
    /*1*/ <1.56788,8.73388,0.12285>,<1.55786,8.75309,0.11882>,<1.5557,8.73635,0.10465>,
            
    /*2*/ <1.92375,8.87682,-0.10043>,<1.91707,8.88963,-0.10312>,<1.91562,8.87847,-0.11256>,
            
    /*3*/ <2.28791,9.1279,-0.09855>,<2.28385,9.13391,-0.09975>,<2.28651,9.13008,-0.10543>,
            
    /*4*/ <2.47198,9.49485,0.07108>

    /* stem 0.28.15*/ 
    /*0*/ <1.62119,8.80546,0.11757>,
    /*1*/ <1.61221,8.8139,0.11851>,<1.62987,8.80662,0.10884>,<1.62149,8.79586,0.12535>,
            
    /*2*/ <1.85981,9.04075,0.39209>,<1.87158,9.0359,0.38565>,<1.86599,9.02873,0.39665>,
            
    /*3*/ <2.11985,9.35641,0.53234>,<2.12531,9.35361,0.5287>,<2.12411,9.3516,0.53544>,
            
    /*4*/ <2.32991,9.72068,0.43083>

    /* stem 0.28.16*/ 
    /*0*/ <1.71189,8.90718,0.12042>,
    /*1*/ <1.71846,8.90186,0.11218>,<1.7171,8.9126,0.12952>,<1.70012,8.90707,0.11957>,
            
    /*2*/ <1.72879,9.25811,-0.10387>,<1.72789,9.26528,-0.09231>,<1.71657,9.26158,-0.09894>,
            
    /*3*/ <1.65529,9.64346,-0.25052>,<1.65477,9.64584,-0.24415>,<1.64923,9.64355,-0.2474>,
            
    /*4*/ <1.55822,10.04982,-0.23228>

    /* stem 0.28.17*/ 
    /*0*/ <1.78401,8.99311,0.1224>,
    /*1*/ <1.78302,8.99368,0.13369>,<1.78268,9.00245,0.11611>,<1.78634,8.98319,0.11741>,
            
    /*2*/ <2.17802,9.07056,0.16069>,<2.17779,9.07641,0.14896>,<2.18023,9.06356,0.14983>,
            
    /*3*/ <2.52295,9.27985,0.14002>,<2.52126,9.28215,0.13413>,<2.52467,9.27658,0.13461>,
            
    /*4*/ <2.75244,9.60864,0.0954>

    /* stem 0.28.18*/ 
    /*0*/ <1.88844,9.11754,0.12527>,
    /*1*/ <1.88393,9.12153,0.11644>,<1.89908,9.11757,0.12632>,<1.88232,9.11351,0.13305>,
            
    /*2*/ <1.86806,9.46614,0.28467>,<1.87816,9.4635,0.29126>,<1.86698,9.4608,0.29575>,
            
    /*3*/ <2.06177,9.78048,0.3928>,<2.06622,9.77696,0.39524>,<2.06143,9.77873,0.39871>,
            
    /*4*/ <2.3027,10.07447,0.44505>

    /* stem 0.28.19*/ 
    /*0*/ <1.98072,9.22749,0.12781>,
    /*1*/ <1.98783,9.22147,0.13042>,<1.98012,9.23628,0.13179>,<1.97423,9.22472,0.1212>,
            
    /*2*/ <2.19824,9.35885,-0.13647>,<2.19311,9.36873,-0.13556>,<2.18918,9.36102,-0.14262>,
            
    /*3*/ <2.3633,9.6333,-0.31827>,<2.35941,9.63688,-0.31648>,<2.35867,9.63414,-0.32129>,
            
    /*4*/ <2.53237,9.95455,-0.3693>

    /* stem 0.28.20*/ 
    /*0*/ <2.05474,9.31568,0.12984>,
    /*1*/ <2.04887,9.32053,0.13327>,<2.0595,9.31864,0.12365>,<2.05585,9.30788,0.13259>,
            
    /*2*/ <2.28546,9.43564,0.36825>,<2.29254,9.43438,0.36184>,<2.29011,9.42721,0.3678>,
            
    /*3*/ <2.58951,9.58177,0.47573>,<2.59164,9.58044,0.47161>,<2.59171,9.57749,0.47542>,
            
    /*4*/ <2.83471,9.82647,0.5392>

    /* stem 0.28.21*/ 
    /*0*/ <2.12444,9.42326,0.13594>,
    /*1*/ <2.12735,9.42237,0.12978>,<2.12822,9.42541,0.14125>,<2.11774,9.42202,0.13677>,
            
    /*2*/ <2.05686,9.74291,0.05225>,<2.05744,9.74493,0.05989>,<2.05045,9.74268,0.05691>,
            
    /*3*/ <1.94246,10.0614,0.06142>,<1.94289,10.06146,0.06536>,<1.93946,10.06028,0.06376>,
            
    /*4*/ <1.98515,10.39536,0.07111>

    /* stem 0.28.22*/ 
    /*0*/ <2.17623,9.52966,0.14498>,
    /*1*/ <2.17724,9.52871,0.1503>,<2.17389,9.5344,0.14342>,<2.17755,9.52587,0.14121>,
            
    /*2*/ <2.4692,9.66267,0.11651>,<2.46696,9.66646,0.11192>,<2.4694,9.66078,0.11045>,
            
    /*3*/ <2.69438,9.89401,0.10378>,<2.69273,9.89552,0.10152>,<2.69491,9.89335,0.10071>,
            
    /*4*/ <2.84639,10.17896,0.10982>

    /* stem 0.28.23*/ 
    /*0*/ <2.25037,9.68198,0.15793>,
    /*1*/ <2.24786,9.68338,0.15584>,<2.25373,9.6831,0.15765>,<2.24952,9.67946,0.16028>,
            
    /*2*/ <2.19459,9.89566,0.36481>,<2.19851,9.89547,0.36602>,<2.1957,9.89304,0.36778>,
            
    /*3*/ <2.16118,10.14033,0.53944>,<2.16315,10.1402,0.54001>,<2.1617,10.13923,0.5411>,
            
    /*4*/ <2.2462,10.42699,0.58571>

    /* stem 0.28.24*/ 
    /*0*/ <2.30067,9.78532,0.16671>,
    /*1*/ <2.30268,9.78436,0.16656>,<2.30027,9.7868,0.16833>,<2.29907,9.78481,0.16524>,
            
    /*2*/ <2.39124,9.99811,-0.00623>,<2.38963,9.99974,-0.00504>,<2.38883,9.99841,-0.0071>,
            
    /*3*/ <2.37914,10.26858,-0.10841>,<2.37821,10.26887,-0.10756>,<2.3779,10.26841,-0.10873>,
            
    /*4*/ <2.31879,10.55018,-0.08467>

    /* stem 0.28.25*/ 
    /*0*/ <2.35218,9.89114,0.1757>,
    /*1*/ <2.35159,9.89137,0.17631>,<2.35238,9.89169,0.17505>,<2.35256,9.89035,0.17575>,
            
    /*2*/ <2.553,9.9974,0.32993>,<2.55353,9.99761,0.3291>,<2.55364,9.99672,0.32956>,
            
    /*3*/ <2.76266,10.13968,0.43594>,<2.76286,10.13974,0.43548>,<2.76299,10.13934,0.43576>,
            
    /*4*/ <2.92943,10.34937,0.49608>

    /* stem 0.29*/ 
    /*0*/ <0.08529,7.90551,0.00717>,
    /*1*/ <0.06666,7.906,-0.02512>,<0.09554,7.93606,-0.01158>,<0.11026,7.92389,0.02786>,
            <0.09047,7.88632,0.03871>,<0.06352,7.87526,0.00596>,
    /*2*/ <-0.4116,8.24153,0.26467>,<-0.38849,8.26557,0.2755>,<-0.37672,8.25584,0.30706>,
            <-0.39255,8.22579,0.31573>,<-0.41411,8.21694,0.28954>,
    /*3*/ <-0.89988,8.62943,0.43802>,<-0.88275,8.64773,0.44595>,<-0.87748,8.64346,0.47136>,
            <-0.89136,8.62252,0.47913>,<-0.90521,8.61385,0.45852>,
    /*4*/ <-1.31577,9.11146,0.58045>,<-1.30239,9.12179,0.5851>,<-1.29948,9.1195,0.60224>,
            <-1.31106,9.10775,0.60818>,<-1.32113,9.10279,0.59471>,
    /*5*/ <-1.73605,9.59373,0.70505>,<-1.72943,9.59898,0.70738>,<-1.72812,9.59803,0.716>,
            <-1.73393,9.59219,0.71899>,<-1.73884,9.58953,0.71222>,
    /*6*/ <-2.07686,10.12641,0.86762>

    /* stem 0.29.0*/ 
    /*0*/ <-0.01356,7.97434,0.06528>,
    /*1*/ <-0.00037,7.98495,0.07516>,<-0.03051,7.96937,0.07379>,<-0.00981,7.96871,0.04688>,
            
    /*2*/ <-0.27117,8.51625,-0.14616>,<-0.29127,8.50586,-0.14708>,<-0.27747,8.50542,-0.16502>,
            
    /*3*/ <-0.59745,9.03329,-0.32338>,<-0.60703,9.02728,-0.32364>,<-0.60063,9.02813,-0.33294>,
            
    /*4*/ <-0.99068,9.53163,-0.3611>

    /* stem 0.29.1*/ 
    /*0*/ <-0.09163,8.0287,0.11117>,
    /*1*/ <-0.1018,8.0126,0.11295>,<-0.09979,8.04441,0.10389>,<-0.0733,8.02911,0.11666>,
            
    /*2*/ <-0.27369,8.19204,0.6847>,<-0.27235,8.21325,0.67866>,<-0.25469,8.20305,0.68717>,
            
    /*3*/ <-0.45933,8.48925,1.20268>,<-0.45798,8.499,1.19769>,<-0.44961,8.49446,1.20329>,
            
    /*4*/ <-0.79513,8.91322,1.51394>

    /* stem 0.29.2*/ 
    /*0*/ <-0.1775,8.0885,0.16165>,
    /*1*/ <-0.17487,8.10245,0.1496>,<-0.17807,8.09198,0.17993>,<-0.17956,8.07108,0.15542>,
            
    /*2*/ <-0.77843,8.1814,0.119>,<-0.78056,8.17442,0.13923>,<-0.78155,8.16048,0.12289>,
            
    /*3*/ <-1.33029,8.43381,0.14517>,<-1.33145,8.43046,0.15531>,<-1.33469,8.42421,0.14719>,
            
    /*4*/ <-1.82746,8.77202,0.05567>

    /* stem 0.29.3*/ 
    /*0*/ <-0.28284,8.16185,0.22357>,
    /*1*/ <-0.27716,8.15635,0.23974>,<-0.30046,8.16324,0.22021>,<-0.27089,8.16596,0.21076>,
            
    /*2*/ <-0.27058,8.71979,0.42245>,<-0.28611,8.72439,0.40943>,<-0.26639,8.7262,0.40313>,
            
    /*3*/ <-0.44275,9.2078,0.70824>,<-0.45046,9.20919,0.70141>,<-0.44115,9.21348,0.69969>,
            
    /*4*/ <-0.66137,9.66293,1.01767>

    /* stem 0.29.4*/ 
    /*0*/ <-0.3501,8.20869,0.26311>,
    /*1*/ <-0.36108,8.20375,0.25028>,<-0.35158,8.22469,0.27028>,<-0.33763,8.19763,0.26876>,
            
    /*2*/ <-0.72564,7.99333,0.65139>,<-0.71931,8.00729,0.66473>,<-0.71001,7.98925,0.66371>,
            
    /*3*/ <-1.18291,8.0044,1.00947>,<-1.17847,8.01162,1.01507>,<-1.17696,8.00182,1.01729>,
            
    /*4*/ <-1.64138,8.1486,1.33691>

    /* stem 0.29.5*/ 
    /*0*/ <-0.45492,8.28707,0.31029>,
    /*1*/ <-0.44391,8.29954,0.31376>,<-0.46864,8.28489,0.32007>,<-0.45222,8.27679,0.29703>,
            
    /*2*/ <-0.74011,8.64621,-0.0193>,<-0.7566,8.63644,-0.01509>,<-0.74565,8.63104,-0.03045>,
            
    /*3*/ <-1.07369,9.05635,-0.21478>,<-1.08165,9.05116,-0.21233>,<-1.07768,9.05014,-0.22125>,
            
    /*4*/ <-1.44057,9.48385,-0.2492>

    /* stem 0.29.6*/ 
    /*0*/ <-0.53979,8.35404,0.33913>,
    /*1*/ <-0.54728,8.34134,0.34657>,<-0.54829,8.36374,0.32882>,<-0.52381,8.35703,0.342>,
            
    /*2*/ <-0.68167,8.67335,0.76558>,<-0.68234,8.68828,0.75375>,<-0.66603,8.68381,0.76253>,
            
    /*3*/ <-0.78093,9.15428,1.02476>,<-0.78006,9.15898,1.01652>,<-0.77241,9.15759,1.02203>,
            
    /*4*/ <-0.89895,9.68354,1.12998>

    /* stem 0.29.7*/ 
    /*0*/ <-0.64173,8.43447,0.37377>,
    /*1*/ <-0.64099,8.44155,0.35952>,<-0.64295,8.44328,0.38699>,<-0.64126,8.41858,0.37481>,
            
    /*2*/ <-1.17474,8.42104,0.32745>,<-1.17604,8.42219,0.34576>,<-1.17492,8.40573,0.33764>,
            
    /*3*/ <-1.62099,8.71188,0.31995>,<-1.62087,8.71245,0.32913>,<-1.6253,8.70553,0.325>,
            
    /*4*/ <-1.83252,9.19976,0.27735>

    /* stem 0.29.8*/ 
    /*0*/ <-0.74504,8.51598,0.40888>,
    /*1*/ <-0.73918,8.51733,0.423>,<-0.75956,8.51136,0.40701>,<-0.73639,8.51925,0.39663>,
            
    /*2*/ <-0.90056,9.01014,0.43732>,<-0.91415,9.00616,0.42666>,<-0.8987,9.01142,0.41974>,
            
    /*3*/ <-1.15955,9.45484,0.35379>,<-1.16514,9.45064,0.34834>,<-1.15775,9.45434,0.34513>,
            
    /*4*/ <-1.5455,9.77465,0.2156>

    /* stem 0.29.9*/ 
    /*0*/ <-0.83837,8.58961,0.4406>,
    /*1*/ <-0.84774,8.58102,0.43296>,<-0.83939,8.60437,0.43964>,<-0.82798,8.58344,0.44918>,
            
    /*2*/ <-1.16462,8.58699,0.82484>,<-1.15905,8.60256,0.82929>,<-1.15145,8.5886,0.83565>,
            
    /*3*/ <-1.55519,8.74367,1.10152>,<-1.55132,8.75119,1.10286>,<-1.55007,8.74469,1.1083>,
            
    /*4*/ <-1.93603,9.04421,1.23852>

    /* stem 0.29.10*/ 
    /*0*/ <-0.93211,8.67828,0.4718>,
    /*1*/ <-0.92187,8.68788,0.46931>,<-0.93997,8.67914,0.48366>,<-0.93449,8.6678,0.46242>,
            
    /*2*/ <-1.24713,8.96725,0.23629>,<-1.2592,8.96142,0.24586>,<-1.25554,8.95386,0.23169>,
            
    /*3*/ <-1.4564,9.39934,0.16811>,<-1.4627,9.39712,0.17292>,<-1.463,9.39569,0.16482>,
            
    /*4*/ <-1.54917,9.87096,0.09103>

    /* stem 0.29.11*/ 
    /*0*/ <-0.98435,8.73833,0.48871>,
    /*1*/ <-0.9896,8.73081,0.49918>,<-0.99283,8.74376,0.4791>,<-0.97061,8.74041,0.48785>,
            
    /*2*/ <-1.03155,9.13024,0.75881>,<-1.03371,9.13887,0.74542>,<-1.01889,9.13664,0.75125>,
            
    /*3*/ <-1.19627,9.53064,0.96176>,<-1.1971,9.53405,0.95452>,<-1.1902,9.53483,0.95857>,
            
    /*4*/ <-1.42741,9.92925,1.09082>

    /* stem 0.29.12*/ 
    /*0*/ <-1.07772,8.84567,0.51894>,
    /*1*/ <-1.07958,8.84772,0.50592>,<-1.0757,8.85601,0.52708>,<-1.07789,8.83329,0.52382>,
            
    /*2*/ <-1.53309,8.8807,0.58048>,<-1.5305,8.88623,0.59459>,<-1.53196,8.87108,0.59242>,
            
    /*3*/ <-1.96381,9.03325,0.6343>,<-1.96206,9.03592,0.64129>,<-1.9647,9.02875,0.64047>,
            
    /*4*/ <-2.20123,9.42733,0.63823>

    /* stem 0.29.13*/ 
    /*0*/ <-1.15232,8.93143,0.5431>,
    /*1*/ <-1.14473,8.93534,0.55267>,<-1.16507,8.93232,0.54425>,<-1.14717,8.92664,0.53237>,
            
    /*2*/ <-1.13486,9.34407,0.3724>,<-1.14842,9.34205,0.36678>,<-1.13648,9.33827,0.35886>,
            
    /*3*/ <-1.21529,9.77359,0.28091>,<-1.22202,9.77185,0.27837>,<-1.21624,9.77195,0.27375>,
            
    /*4*/ <-1.34397,10.16354,0.1022>

    /* stem 0.29.14*/ 
    /*0*/ <-1.19115,8.97606,0.55567>,
    /*1*/ <-1.20079,8.96826,0.55358>,<-1.19148,8.98782,0.55118>,<-1.18117,8.97212,0.56223>,
            
    /*2*/ <-1.38819,9.10727,0.92612>,<-1.38198,9.12031,0.92452>,<-1.37511,9.10984,0.93188>,
            
    /*3*/ <-1.55315,9.39558,1.21682>,<-1.54888,9.40081,1.21414>,<-1.54652,9.39665,1.2196>,
            
    /*4*/ <-1.72064,9.75432,1.40851>

    /* stem 0.29.15*/ 
    /*0*/ <-1.27015,9.06689,0.58125>,
    /*1*/ <-1.26311,9.07469,0.57529>,<-1.27437,9.06971,0.5922>,<-1.27297,9.05626,0.57624>,
            
    /*2*/ <-1.60942,9.24695,0.39964>,<-1.61693,9.24363,0.41091>,<-1.61599,9.23467,0.40027>,
            
    /*3*/ <-1.96966,9.47415,0.4093>,<-1.97134,9.47133,0.41545>,<-1.97342,9.46828,0.40954>,
            
    /*4*/ <-2.32891,9.69364,0.46821>

    /* stem 0.29.16*/ 
    /*0*/ <-1.3564,9.16552,0.60706>,
    /*1*/ <-1.35803,9.16148,0.61774>,<-1.36537,9.16941,0.60094>,<-1.34581,9.16567,0.6025>,
            
    /*2*/ <-1.29778,9.53799,0.76507>,<-1.30267,9.54327,0.75387>,<-1.28963,9.54078,0.75491>,
            
    /*3*/ <-1.28929,9.92423,0.89914>,<-1.29177,9.92635,0.89334>,<-1.28518,9.92592,0.89418>,
            
    /*4*/ <-1.33614,10.31514,1.00966>

    /* stem 0.29.17*/ 
    /*0*/ <-1.42411,9.24258,0.6259>,
    /*1*/ <-1.42825,9.24145,0.61565>,<-1.42249,9.25272,0.63015>,<-1.42159,9.23358,0.6319>,
            
    /*2*/ <-1.7941,9.2381,0.76785>,<-1.79026,9.24561,0.77751>,<-1.78966,9.23285,0.77868>,
            
    /*3*/ <-2.14273,9.39979,0.86212>,<-2.13991,9.40334,0.86666>,<-2.14222,9.39753,0.8681>,
            
    /*4*/ <-2.40639,9.68424,0.94461>

    /* stem 0.29.18*/ 
    /*0*/ <-1.53325,9.36681,0.65627>,
    /*1*/ <-1.52582,9.3721,0.66135>,<-1.54237,9.36485,0.66093>,<-1.53155,9.3635,0.64652>,
            
    /*2*/ <-1.66647,9.69345,0.52575>,<-1.67751,9.68862,0.52547>,<-1.67029,9.68772,0.51586>,
            
    /*3*/ <-1.81276,10.00672,0.37709>,<-1.81821,10.00416,0.37694>,<-1.81451,10.00365,0.37222>,
            
    /*4*/ <-2.0221,10.27881,0.22197>

    /* stem 0.29.19*/ 
    /*0*/ <-1.62133,9.46708,0.68078>,
    /*1*/ <-1.6281,9.46073,0.68244>,<-1.62295,9.47426,0.67489>,<-1.61295,9.46624,0.685>,
            
    /*2*/ <-1.7448,9.66158,0.9572>,<-1.74137,9.6706,0.95217>,<-1.7347,9.66526,0.95891>,
            
    /*3*/ <-1.89846,9.91959,1.15618>,<-1.89629,9.92341,1.15297>,<-1.89357,9.92166,1.15735>,
            
    /*4*/ <-2.1016,10.15535,1.33593>

    /* stem 0.29.20*/ 
    /*0*/ <-1.68163,9.53571,0.69756>,
    /*1*/ <-1.67838,9.54011,0.69122>,<-1.68228,9.53916,0.70515>,<-1.68423,9.52785,0.6963>,
            
    /*2*/ <-1.99737,9.65671,0.61243>,<-1.99996,9.65608,0.62171>,<-2.00126,9.64854,0.61581>,
            
    /*3*/ <-2.23404,9.89816,0.53396>,<-2.23562,9.89815,0.53853>,<-2.23759,9.89516,0.53528>,
            
    /*4*/ <-2.43328,10.18336,0.56083>

    /* stem 0.29.21*/ 
    /*0*/ <-1.78199,9.66992,0.73401>,
    /*1*/ <-1.78101,9.66873,0.74022>,<-1.78757,9.67239,0.73206>,<-1.77741,9.66863,0.72974>,
            
    /*2*/ <-1.66048,9.97162,0.77656>,<-1.66485,9.97405,0.77112>,<-1.65808,9.97154,0.76957>,
            
    /*3*/ <-1.56651,10.28448,0.80765>,<-1.56877,10.28545,0.80489>,<-1.56528,10.28448,0.80416>,
            
    /*4*/ <-1.63572,10.60204,0.85242>

    /* stem 0.29.22*/ 
    /*0*/ <-1.8403,9.76019,0.76043>,
    /*1*/ <-1.84367,9.75911,0.7567>,<-1.83848,9.76496,0.76093>,<-1.83876,9.7565,0.76365>,
            
    /*2*/ <-2.0801,9.82955,0.95211>,<-2.07665,9.83345,0.95493>,<-2.07683,9.82781,0.95674>,
            
    /*3*/ <-2.23554,9.99328,1.1728>,<-2.23307,9.99478,1.17345>,<-2.23369,9.99226,1.17488>,
            
    /*4*/ <-2.41466,10.18982,1.34067>

    /* stem 0.29.23*/ 
    /*0*/ <-1.90071,9.8537,0.7878>,
    /*1*/ <-1.89746,9.85564,0.78834>,<-1.90366,9.85423,0.79017>,<-1.901,9.85123,0.7849>,
            
    /*2*/ <-2.00102,10.07566,0.61101>,<-2.00516,10.07471,0.61223>,<-2.00339,10.07272,0.60872>,
            
    /*3*/ <-2.08835,10.32634,0.46982>,<-2.09045,10.32594,0.4704>,<-2.08966,10.32515,0.4685>,
            
    /*4*/ <-2.143,10.62091,0.4946>

    /* stem 0.29.24*/ 
    /*0*/ <-1.96684,9.95608,0.81777>,
    /*1*/ <-1.96838,9.95472,0.81898>,<-1.96764,9.95774,0.81625>,<-1.96449,9.95577,0.81806>,
            
    /*2*/ <-1.96933,10.14721,1.03037>,<-1.96883,10.14922,1.02855>,<-1.96673,10.14791,1.02976>,
            
    /*3*/ <-2.04358,10.37102,1.19199>,<-2.0433,10.37187,1.19095>,<-2.04231,10.37155,1.19185>,
            
    /*4*/ <-2.12015,10.60618,1.33552>

    /* stem 0.29.25*/ 
    /*0*/ <-2.05192,10.0878,0.85632>,
    /*1*/ <-2.05184,10.08799,0.85582>,<-2.05192,10.08813,0.85675>,<-2.052,10.08727,0.8564>,
            
    /*2*/ <-2.31482,10.122,0.82903>,<-2.31487,10.1221,0.82964>,<-2.31492,10.12152,0.82941>,
            
    /*3*/ <-2.54299,10.25759,0.80531>,<-2.54299,10.25763,0.80562>,<-2.54313,10.25738,0.80549>,
            
    /*4*/ <-2.73789,10.43914,0.81474>

    /* stem 0.30*/ 
    /*0*/ <0.08826,8.03354,0.00742>,
    /*1*/ <0.12281,8.03272,0.02>,<0.09342,8.0633,0.02841>,<0.0569,8.05276,0.00781>,
            <0.06371,8.01566,-0.01333>,<0.10444,8.00327,-0.0058>,
    /*2*/ <0.31216,8.36378,-0.49995>,<0.28865,8.38824,-0.49322>,<0.25943,8.37981,-0.50969>,
            <0.26488,8.35013,-0.52661>,<0.29747,8.34022,-0.52058>,
    /*3*/ <0.47275,8.78841,-0.95839>,<0.45398,8.80443,-0.95037>,<0.4324,8.79875,-0.96359>,
            <0.43782,8.77922,-0.97978>,<0.46276,8.77283,-0.97656>,
    /*4*/ <0.60341,9.20465,-1.4348>,<0.59079,9.21511,-1.42928>,<0.5762,9.21065,-1.43743>,
            <0.5798,9.19743,-1.44799>,<0.59662,9.19373,-1.44636>,
    /*5*/ <0.77037,9.71255,-1.79235>,<0.76388,9.71715,-1.78895>,<0.75691,9.71603,-1.79395>,
            <0.75909,9.71075,-1.80044>,<0.76741,9.70859,-1.79945>,
    /*6*/ <0.9459,10.21274,-2.15938>

    /* stem 0.30.0*/ 
    /*0*/ <0.13099,8.10558,-0.10524>,
    /*1*/ <0.11514,8.11656,-0.10423>,<0.1382,8.10061,-0.12243>,<0.13962,8.09958,-0.08905>,
            
    /*2*/ <0.47803,8.62906,-0.10394>,<0.4934,8.61842,-0.11608>,<0.49435,8.61774,-0.09382>,
            
    /*3*/ <0.79616,9.16919,-0.09776>,<0.80428,9.16459,-0.10385>,<0.80476,9.16418,-0.09273>,
            
    /*4*/ <1.07679,9.71722,-0.21969>

    /* stem 0.30.1*/ 
    /*0*/ <0.15976,8.15409,-0.18109>,
    /*1*/ <0.16577,8.13806,-0.18906>,<0.17031,8.16972,-0.18219>,<0.1432,8.1545,-0.17203>,
            
    /*2*/ <-0.1199,8.29819,-0.71153>,<-0.11687,8.31929,-0.70695>,<-0.13495,8.30915,-0.70018>,
            
    /*3*/ <-0.29057,8.43772,-1.28574>,<-0.28899,8.44832,-1.28374>,<-0.29876,8.44383,-1.28193>,
            
    /*4*/ <-0.48427,8.81716,-1.73517>

    /* stem 0.30.2*/ 
    /*0*/ <0.1903,8.20559,-0.26161>,
    /*1*/ <0.19645,8.21908,-0.25065>,<0.17947,8.2096,-0.27599>,<0.19498,8.18808,-0.2582>,
            
    /*2*/ <0.68295,8.27685,-0.6049>,<0.67164,8.27053,-0.6218>,<0.68198,8.25618,-0.60993>,
            
    /*3*/ <1.04708,8.54921,-1.0005>,<1.04086,8.54605,-1.00854>,<1.04894,8.53991,-1.00533>,
            
    /*4*/ <1.29925,8.9763,-1.34417>

    /* stem 0.30.3*/ 
    /*0*/ <0.23252,8.27677,-0.37292>,
    /*1*/ <0.21774,8.27191,-0.38164>,<0.24834,8.27612,-0.38114>,<0.23149,8.28227,-0.35599>,
            
    /*2*/ <0.14945,8.82697,-0.56305>,<0.16985,8.82978,-0.56272>,<0.15862,8.83388,-0.54595>,
            
    /*3*/ <0.3223,9.28587,-0.89113>,<0.33215,9.28387,-0.88888>,<0.32668,9.29022,-0.88289>,
            
    /*4*/ <0.54032,9.70022,-1.24695>

    /* stem 0.30.4*/ 
    /*0*/ <0.26911,8.33846,-0.46939>,
    /*1*/ <0.28533,8.33302,-0.46672>,<0.26622,8.35448,-0.47528>,<0.25579,8.32789,-0.46617>,
            
    /*2*/ <0.30347,8.14074,-1.00673>,<0.29074,8.15504,-1.01244>,<0.28378,8.13732,-1.00636>,
            
    /*3*/ <0.40283,8.33857,-1.53677>,<0.39583,8.3456,-1.53555>,<0.39336,8.33669,-1.53935>,
            
    /*4*/ <0.44683,8.74782,-1.93766>

    /* stem 0.30.5*/ 
    /*0*/ <0.29674,8.39541,-0.54328>,
    /*1*/ <0.28573,8.40654,-0.53696>,<0.29619,8.39135,-0.55966>,<0.30831,8.38834,-0.53321>,
            
    /*2*/ <0.64592,8.82128,-0.65465>,<0.6529,8.81116,-0.66978>,<0.66098,8.80915,-0.65215>,
            
    /*3*/ <0.91713,9.27137,-0.85033>,<0.92044,9.26619,-0.8579>,<0.92563,9.26665,-0.84966>,
            
    /*4*/ <1.10336,9.73005,-1.11516>

    /* stem 0.30.6*/ 
    /*0*/ <0.33012,8.47999,-0.63412>,
    /*1*/ <0.3308,8.46792,-0.6451>,<0.34171,8.49148,-0.63389>,<0.31783,8.48056,-0.62337>,
            
    /*2*/ <0.03864,8.77356,-0.99113>,<0.04591,8.78927,-0.98365>,<0.02999,8.78198,-0.97664>,
            
    /*3*/ <-0.23317,9.156,-1.27487>,<-0.2287,9.16281,-1.27011>,<-0.23687,9.15939,-1.26689>,
            
    /*4*/ <-0.3813,9.59516,-1.56486>

    /* stem 0.30.7*/ 
    /*0*/ <0.36119,8.55875,-0.71872>,
    /*1*/ <0.37049,8.56623,-0.70833>,<0.35007,8.56678,-0.72659>,<0.36301,8.54323,-0.72122>,
            
    /*2*/ <0.71674,8.6673,-1.09938>,<0.70313,8.66767,-1.11155>,<0.71176,8.65197,-1.10797>,
            
    /*3*/ <0.87044,8.95026,-1.52408>,<0.86212,8.94939,-1.52776>,<0.86859,8.9432,-1.52956>,
            
    /*4*/ <0.92725,9.34348,-1.87737>

    /* stem 0.30.8*/ 
    /*0*/ <0.40122,8.6602,-0.82768>,
    /*1*/ <0.38693,8.66041,-0.83273>,<0.41258,8.65702,-0.83721>,<0.40416,8.66315,-0.81311>,
            
    /*2*/ <0.43836,9.15958,-0.94165>,<0.45546,9.15732,-0.94464>,<0.44984,9.16141,-0.92857>,
            
    /*3*/ <0.51538,9.54344,-1.27245>,<0.52373,9.54101,-1.27344>,<0.52155,9.54679,-1.26723>,
            
    /*4*/ <0.46934,9.94772,-1.58389>

    /* stem 0.30.9*/ 
    /*0*/ <0.42867,8.72976,-0.90239>,
    /*1*/ <0.44127,8.72247,-0.90454>,<0.42875,8.74442,-0.90126>,<0.41599,8.72237,-0.90138>,
            
    /*2*/ <0.37499,8.76369,-1.39923>,<0.36664,8.77833,-1.39704>,<0.35813,8.76362,-1.39713>,
            
    /*3*/ <0.31163,9.04532,-1.81155>,<0.30779,9.05133,-1.80694>,<0.30321,9.04511,-1.81048>,
            
    /*4*/ <0.24236,9.3958,-2.16329>

    /* stem 0.30.10*/ 
    /*0*/ <0.46516,8.8287,-1.01127>,
    /*1*/ <0.45994,8.83924,-1.00354>,<0.46167,8.82754,-1.02486>,<0.47387,8.81932,-1.00542>,
            
    /*2*/ <0.83913,9.11122,-1.12664>,<0.84029,9.10342,-1.14086>,<0.84842,9.09794,-1.1279>,
            
    /*3*/ <0.96823,9.46933,-1.42129>,<0.96761,9.46438,-1.4277>,<0.97469,9.46506,-1.42377>,
            
    /*4*/ <1.11554,9.77516,-1.76534>

    /* stem 0.30.11*/ 
    /*0*/ <0.48073,8.87578,-1.0649>,
    /*1*/ <0.47664,8.86651,-1.07423>,<0.49267,8.88242,-1.06657>,<0.47287,8.87841,-1.05391>,
            
    /*2*/ <0.25471,9.21078,-1.31247>,<0.2654,9.22138,-1.30736>,<0.2522,9.21871,-1.29892>,
            
    /*3*/ <0.15888,9.52836,-1.64954>,<0.16446,9.53322,-1.64664>,<0.15698,9.53375,-1.64401>,
            
    /*4*/ <0.11849,9.84259,-2.00194>

    /* stem 0.30.12*/ 
    /*0*/ <0.51313,8.97376,-1.17653>,
    /*1*/ <0.52397,8.97748,-1.17012>,<0.50441,8.98277,-1.18046>,<0.511,8.96104,-1.179>,
            
    /*2*/ <0.74097,9.01643,-1.56883>,<0.72793,9.01995,-1.57573>,<0.73232,9.00547,-1.57475>,
            
    /*3*/ <0.92316,9.28235,-1.88878>,<0.91626,9.28391,-1.89151>,<0.92016,9.27799,-1.89421>,
            
    /*4*/ <1.0216,9.55072,-2.2446>

    /* stem 0.30.13*/ 
    /*0*/ <0.5338,9.03628,-1.24775>,
    /*1*/ <0.52147,9.03934,-1.24865>,<0.54038,9.03322,-1.25821>,<0.53955,9.0363,-1.23639>,
            
    /*2*/ <0.63532,9.46481,-1.30446>,<0.64792,9.46073,-1.31083>,<0.64737,9.46278,-1.29629>,
            
    /*3*/ <0.75697,9.87601,-1.41992>,<0.76312,9.8734,-1.42298>,<0.76309,9.8754,-1.4159>,
            
    /*4*/ <0.8654,10.25459,-1.62469>

    /* stem 0.30.14*/ 
    /*0*/ <0.55368,9.09641,-1.31625>,
    /*1*/ <0.5618,9.08838,-1.32094>,<0.55666,9.10835,-1.31528>,<0.54258,9.09249,-1.31252>,
            
    /*2*/ <0.40073,9.16248,-1.71572>,<0.3973,9.17579,-1.71195>,<0.38791,9.16522,-1.71011>,
            
    /*3*/ <0.31431,9.40503,-2.06538>,<0.31318,9.41072,-2.06123>,<0.30777,9.40639,-2.0629>,
            
    /*4*/ <0.17028,9.69439,-2.35451>

    /* stem 0.30.15*/ 
    /*0*/ <0.58131,9.17995,-1.41142>,
    /*1*/ <0.58084,9.18889,-1.40371>,<0.57604,9.18095,-1.42195>,<0.58704,9.17001,-1.4086>,
            
    /*2*/ <0.93253,9.34289,-1.56701>,<0.92933,9.3376,-1.57917>,<0.93666,9.33031,-1.57027>,
            
    /*3*/ <1.17222,9.67095,-1.64421>,<1.17185,9.6697,-1.65091>,<1.17685,9.66692,-1.64719>,
            
    /*4*/ <1.36654,10.03149,-1.7222>

    /* stem 0.30.16*/ 
    /*0*/ <0.6016,9.24007,-1.46418>,
    /*1*/ <0.5953,9.23611,-1.47292>,<0.61212,9.24424,-1.46612>,<0.5974,9.23984,-1.45351>,
            
    /*2*/ <0.43974,9.60895,-1.52428>,<0.45095,9.61437,-1.51975>,<0.44114,9.61144,-1.51134>,
            
    /*3*/ <0.39196,10.00599,-1.60556>,<0.39791,10.00729,-1.60296>,<0.39252,10.00743,-1.59911>,
            
    /*4*/ <0.42235,10.39668,-1.71704>

    /* stem 0.30.17*/ 
    /*0*/ <0.64895,9.37836,-1.56093>,
    /*1*/ <0.65896,9.37768,-1.557>,<0.64418,9.38797,-1.56186>,<0.64372,9.36943,-1.56391>,
            
    /*2*/ <0.7981,9.41394,-1.91544>,<0.78824,9.4208,-1.91868>,<0.78794,9.40844,-1.92005>,
            
    /*3*/ <0.88795,9.68663,-2.17442>,<0.88222,9.689,-2.17399>,<0.88345,9.68459,-2.1782>,
            
    /*4*/ <0.93112,10.04871,-2.30182>

    /* stem 0.30.18*/ 
    /*0*/ <0.67727,9.46105,-1.61877>,
    /*1*/ <0.66822,9.46562,-1.61667>,<0.68092,9.46102,-1.62846>,<0.68266,9.45652,-1.61119>,
            
    /*2*/ <0.84909,9.78597,-1.55141>,<0.85756,9.7829,-1.55927>,<0.85872,9.7799,-1.54776>,
            
    /*3*/ <1.0421,10.0976,-1.62771>,<1.04553,10.09459,-1.63157>,<1.04715,10.095,-1.62583>,
            
    /*4*/ <1.20091,10.39637,-1.78607>

    /* stem 0.30.19*/ 
    /*0*/ <0.71394,9.56818,-1.69371>,
    /*1*/ <0.71782,9.56239,-1.70009>,<0.71909,9.57513,-1.6899>,<0.70492,9.56702,-1.69113>,
            
    /*2*/ <0.61338,9.78419,-1.96006>,<0.61423,9.79268,-1.95327>,<0.60479,9.78727,-1.95409>,
            
    /*3*/ <0.65859,10.04178,-2.20282>,<0.65906,10.0455,-2.19886>,<0.65415,10.04437,-2.20097>,
            
    /*4*/ <0.70013,10.33266,-2.4069>

    /* stem 0.30.20*/ 
    /*0*/ <0.74729,9.66558,-1.76184>,
    /*1*/ <0.74927,9.66958,-1.75515>,<0.74261,9.66906,-1.76738>,<0.74999,9.65809,-1.76299>,
            
    /*2*/ <1.02666,9.7926,-1.914>,<1.02222,9.79226,-1.92215>,<1.02714,9.78494,-1.91922>,
            
    /*3*/ <1.19488,10.07093,-2.01651>,<1.19258,10.07087,-2.02055>,<1.1966,10.06859,-2.02013>,
            
    /*4*/ <1.26897,10.40007,-2.07316>

    /* stem 0.30.21*/ 
    /*0*/ <0.77355,9.74046,-1.81504>,
    /*1*/ <0.76808,9.73943,-1.8192>,<0.77988,9.74135,-1.81778>,<0.77269,9.74061,-1.80814>,
            
    /*2*/ <0.71824,10.06647,-1.83132>,<0.72611,10.06776,-1.83037>,<0.72131,10.06726,-1.82395>,
            
    /*3*/ <0.63844,10.35451,-1.97017>,<0.64228,10.35568,-1.97>,<0.6398,10.35647,-1.96694>,
            
    /*4*/ <0.60545,10.5817,-2.20828>

    /* stem 0.30.22*/ 
    /*0*/ <0.82232,9.87412,-1.91249>,
    /*1*/ <0.82709,9.87272,-1.91202>,<0.82108,9.87892,-1.91201>,<0.81881,9.87071,-1.91344>,
            
    /*2*/ <0.86753,9.91473,-2.21684>,<0.86353,9.91886,-2.21683>,<0.86202,9.91339,-2.21778>,
            
    /*3*/ <0.90317,9.98874,-2.51626>,<0.90115,9.99077,-2.51601>,<0.90041,9.98809,-2.51676>,
            
    /*4*/ <0.92625,10.21606,-2.72668>

    /* stem 0.30.23*/ 
    /*0*/ <0.85897,9.97453,-1.9857>,
    /*1*/ <0.8566,9.97656,-1.98411>,<0.85932,9.97466,-1.98919>,<0.86099,9.97238,-1.98381>,
            
    /*2*/ <1.05873,10.18942,-1.9569>,<1.06055,10.18815,-1.96029>,<1.06166,10.18663,-1.9567>,
            
    /*3*/ <1.26004,10.40299,-1.98665>,<1.26074,10.4021,-1.98833>,<1.26152,10.40162,-1.98653>,
            
    /*4*/ <1.41685,10.61793,-2.11374>

    /* stem 0.30.24*/ 
    /*0*/ <0.89968,10.08608,-2.06703>,
    /*1*/ <0.89983,10.08495,-2.06851>,<0.90113,10.08713,-2.06651>,<0.89808,10.08616,-2.06608>,
            
    /*2*/ <0.81183,10.28978,-2.23379>,<0.81269,10.29124,-2.23245>,<0.81066,10.29059,-2.23217>,
            
    /*3*/ <0.76054,10.51071,-2.39381>,<0.761,10.51135,-2.39308>,<0.75994,10.51114,-2.39303>,
            
    /*4*/ <0.84074,10.76435,-2.47348>

    /* stem 0.30.25*/ 
    /*0*/ <0.93424,10.18079,-2.13608>,
    /*1*/ <0.9345,10.18095,-2.13573>,<0.93396,10.18108,-2.13632>,<0.93426,10.18033,-2.1362>,
            
    /*2*/ <1.13059,10.2327,-2.30296>,<1.13023,10.23278,-2.30335>,<1.13043,10.23229,-2.30327>,
            
    /*3*/ <1.28895,10.35227,-2.47536>,<1.28874,10.3523,-2.47553>,<1.28889,10.35208,-2.47554>,
            
    /*4*/ <1.33692,10.50189,-2.68615>

    /* stem 0.31*/ 
    /*0*/ <0.09304,8.24017,0.00782>,
    /*1*/ <0.05925,8.24093,0.02012>,<0.07682,8.26914,-0.00603>,<0.11681,8.25732,-0.01304>,
            <0.12395,8.2218,0.00877>,<0.08838,8.21167,0.02927>,
    /*2*/ <0.25473,8.58406,0.51484>,<0.26879,8.60663,0.49393>,<0.30078,8.59717,0.48831>,
            <0.30649,8.56876,0.50576>,<0.27803,8.56065,0.52216>,
    /*3*/ <0.50912,9.01647,0.9074>,<0.51782,9.02962,0.88753>,<0.54114,9.02118,0.88214>,
            <0.54684,9.00281,0.89869>,<0.52705,8.9999,0.9143>,
    /*4*/ <0.68769,9.51129,1.25604>,<0.69303,9.5193,1.24213>,<0.70931,9.51534,1.23975>,
            <0.71402,9.50488,1.25218>,<0.70065,9.50237,1.26225>,
    /*5*/ <0.80708,10.05157,1.56164>,<0.80961,10.05517,1.55441>,<0.81793,10.05388,1.55362>,
            <0.82055,10.04949,1.56036>,<0.81385,10.04806,1.56531>,
    /*6*/ <0.95725,10.63215,1.7666>

    /* stem 0.31.0*/ 
    /*0*/ <0.1327,8.31231,0.1123>,
    /*1*/ <0.14425,8.32221,0.10108>,<0.13902,8.3056,0.1288>,<0.11484,8.30913,0.10702>,
            
    /*2*/ <-0.03516,8.84031,0.38414>,<-0.03864,8.82924,0.40262>,<-0.05476,8.83159,0.3881>,
            
    /*3*/ <-0.1016,9.34075,0.73832>,<-0.10313,9.33445,0.7471>,<-0.11167,9.33758,0.74107>,
            
    /*4*/ <0.1034,9.76509,1.135>

    /* stem 0.31.1*/ 
    /*0*/ <0.16949,8.37923,0.20921>,
    /*1*/ <0.16955,8.36411,0.21963>,<0.16381,8.3952,0.21625>,<0.17511,8.37837,0.19176>,
            
    /*2*/ <0.73239,8.49211,0.39142>,<0.72856,8.51284,0.38917>,<0.7361,8.50162,0.37284>,
            
    /*3*/ <1.08234,8.94255,0.59958>,<1.07552,8.94971,0.59577>,<1.08353,8.94628,0.58974>,
            
    /*4*/ <1.13768,9.51704,0.77804>

    /* stem 0.31.2*/ 
    /*0*/ <0.20178,8.43796,0.29428>,
    /*1*/ <0.19076,8.45116,0.28935>,<0.21902,8.44144,0.29749>,<0.19555,8.42129,0.29601>,
            
    /*2*/ <0.06797,8.5525,0.85667>,<0.08681,8.54603,0.86209>,<0.07116,8.53259,0.86111>,
            
    /*3*/ <-0.10842,8.8012,1.35709>,<-0.09952,8.79857,1.36163>,<-0.10759,8.79214,1.36198>,
            
    /*4*/ <-0.13466,9.25671,1.72798>

    /* stem 0.31.3*/ 
    /*0*/ <0.23025,8.48975,0.36929>,
    /*1*/ <0.24668,8.48439,0.36676>,<0.22424,8.49212,0.38552>,<0.21983,8.49275,0.3556>,
            
    /*2*/ <0.41844,9.03588,0.35313>,<0.40348,9.04103,0.36563>,<0.40054,9.04145,0.34568>,
            
    /*3*/ <0.50516,9.58418,0.52081>,<0.49682,9.58386,0.52647>,<0.49629,9.58688,0.51686>,
            
    /*4*/ <0.561,10.09072,0.7938>

    /* stem 0.31.4*/ 
    /*0*/ <0.26846,8.55925,0.46995>,
    /*1*/ <0.25451,8.55473,0.47837>,<0.27399,8.57521,0.47071>,<0.27688,8.54782,0.46077>,
            
    /*2*/ <0.57209,8.4264,0.92442>,<0.58508,8.44006,0.91931>,<0.58701,8.42179,0.91269>,
            
    /*3*/ <0.86919,8.63161,1.35765>,<0.87348,8.63808,1.35174>,<0.87753,8.62931,1.35313>,
            
    /*4*/ <0.94321,9.01118,1.7645>

    /* stem 0.31.5*/ 
    /*0*/ <0.3096,8.63205,0.54936>,
    /*1*/ <0.31374,8.6414,0.53653>,<0.31939,8.63138,0.56251>,<0.29568,8.62338,0.54905>,
            
    /*2*/ <0.04352,9.06172,0.76264>,<0.04729,9.05504,0.77997>,<0.03148,9.04971,0.77099>,
            
    /*3*/ <-0.00567,9.52307,1.05409>,<-0.00321,9.51845,1.06198>,<-0.01233,9.51905,1.05949>,
            
    /*4*/ <0.23162,9.93667,1.32377>

    /* stem 0.31.6*/ 
    /*0*/ <0.36224,8.72395,0.63324>,
    /*1*/ <0.3682,8.71234,0.64221>,<0.35545,8.73652,0.64005>,<0.36307,8.72297,0.61747>,
            
    /*2*/ <0.83658,8.96507,0.64863>,<0.82808,8.98119,0.64719>,<0.83316,8.97216,0.63214>,
            
    /*3*/ <1.19137,9.31843,0.83008>,<1.18539,9.32522,0.8288>,<1.19114,9.32288,0.82209>,
            
    /*4*/ <1.50525,9.68674,1.05178>

    /* stem 0.31.7*/ 
    /*0*/ <0.40572,8.79985,0.70254>,
    /*1*/ <0.393,8.80834,0.70122>,<0.41949,8.80664,0.70281>,<0.40468,8.78457,0.70358>,
            
    /*2*/ <0.36846,8.84269,1.21836>,<0.38612,8.84156,1.21942>,<0.37625,8.82685,1.21993>,
            
    /*3*/ <0.38705,9.0824,1.67631>,<0.3959,9.08181,1.67634>,<0.39102,9.07534,1.67992>,
            
    /*4*/ <0.44589,9.51463,1.95533>

    /* stem 0.31.8*/ 
    /*0*/ <0.4544,8.88484,0.78011>,
    /*1*/ <0.46764,8.88314,0.77366>,<0.45349,8.88659,0.7948>,<0.44209,8.88477,0.77187>,
            
    /*2*/ <0.49925,9.38296,0.71831>,<0.48982,9.38526,0.7324>,<0.48222,9.38405,0.71712>,
            
    /*3*/ <0.56864,9.83237,0.93896>,<0.56337,9.83014,0.94532>,<0.56027,9.83404,0.93836>,
            
    /*4*/ <0.5755,10.28733,1.15668>

    /* stem 0.31.9*/ 
    /*0*/ <0.49341,8.95292,0.84226>,
    /*1*/ <0.48564,8.94748,0.85309>,<0.49409,8.96717,0.84033>,<0.5005,8.94411,0.83335>,
            
    /*2*/ <0.88252,8.97007,1.14274>,<0.88815,8.9832,1.13423>,<0.89242,8.96782,1.12958>,
            
    /*3*/ <1.26173,9.13036,1.41387>,<1.26304,9.13656,1.40849>,<1.26688,9.12927,1.40743>,
            
    /*4*/ <1.63396,9.39037,1.60542>

    /* stem 0.31.10*/ 
    /*0*/ <0.54241,9.05435,0.92665>,
    /*1*/ <0.54083,9.06264,0.91573>,<0.55388,9.0551,0.93429>,<0.53252,9.04529,0.92992>,
            
    /*2*/ <0.33516,9.38561,1.19667>,<0.34386,9.38058,1.20904>,<0.32962,9.37405,1.20613>,
            
    /*3*/ <0.24238,9.71112,1.53127>,<0.24721,9.70736,1.53637>,<0.23948,9.70546,1.53607>,
            
    /*4*/ <0.34689,10.09802,1.78476>

    /* stem 0.31.11*/ 
    /*0*/ <0.58535,9.17794,1.01436>,
    /*1*/ <0.59458,9.1706,1.02018>,<0.57725,9.18531,1.02164>,<0.58423,9.17791,1.00126>,
            
    /*2*/ <0.88485,9.52118,0.99228>,<0.8733,9.53098,0.99325>,<0.87795,9.52605,0.97967>,
            
    /*3*/ <0.97431,9.94974,1.12734>,<0.96691,9.95142,1.12709>,<0.97125,9.95246,1.12095>,
            
    /*4*/ <1.10319,10.35454,1.29162>

    /* stem 0.31.12*/ 
    /*0*/ <0.61903,9.27488,1.08315>,
    /*1*/ <0.60689,9.27809,1.08457>,<0.62783,9.28385,1.08188>,<0.62237,9.26269,1.08301>,
            
    /*2*/ <0.66461,9.28646,1.52188>,<0.67857,9.29031,1.52009>,<0.67492,9.2762,1.52084>,
            
    /*3*/ <0.76023,9.47832,1.90738>,<0.76694,9.47992,1.90499>,<0.7657,9.47361,1.90844>,
            
    /*4*/ <0.8095,9.81804,2.18345>

    /* stem 0.31.13*/ 
    /*0*/ <0.65283,9.37215,1.15219>,
    /*1*/ <0.66216,9.3742,1.14473>,<0.65417,9.37364,1.16415>,<0.64214,9.36861,1.14769>,
            
    /*2*/ <0.53978,9.78105,1.10976>,<0.53445,9.78068,1.12271>,<0.52643,9.77732,1.11173>,
            
    /*3*/ <0.40034,10.16293,1.24554>,<0.39831,10.16009,1.25161>,<0.39386,10.16038,1.24621>,
            
    /*4*/ <0.36227,10.54839,1.42244>

    /* stem 0.31.14*/ 
    /*0*/ <0.69175,9.48418,1.2317>,
    /*1*/ <0.68922,9.47826,1.24128>,<0.68829,9.49514,1.2306>,<0.69775,9.47915,1.22322>,
            
    /*2*/ <1.03918,9.60774,1.40914>,<1.03856,9.61899,1.40202>,<1.04487,9.60833,1.3971>,
            
    /*3*/ <1.2987,9.92354,1.46344>,<1.29562,9.92696,1.45862>,<1.30076,9.923,1.45712>,
            
    /*4*/ <1.47029,10.27558,1.58049>

    /* stem 0.31.15*/ 
    /*0*/ <0.71078,9.55782,1.27739>,
    /*1*/ <0.70556,9.56352,1.26931>,<0.7206,9.56145,1.28134>,<0.7062,9.54849,1.28151>,
            
    /*2*/ <0.51659,9.7773,1.54749>,<0.52661,9.77592,1.55551>,<0.51701,9.76728,1.55563>,
            
    /*3*/ <0.4445,10.07298,1.80466>,<0.44992,10.07157,1.80788>,<0.44435,10.06876,1.80955>,
            
    /*4*/ <0.44431,10.393,2.04223>

    /* stem 0.31.16*/ 
    /*0*/ <0.73484,9.67313,1.34316>,
    /*1*/ <0.74457,9.66966,1.3457>,<0.72826,9.67656,1.35079>,<0.73169,9.67319,1.333>,
            
    /*2*/ <0.87855,10.02531,1.30424>,<0.86767,10.02991,1.30763>,<0.86996,10.02766,1.29577>,
            
    /*3*/ <1.0881,10.32411,1.41014>,<1.08306,10.32701,1.41212>,<1.08494,10.32774,1.40632>,
            
    /*4*/ <1.23662,10.62182,1.59907>

    /* stem 0.31.17*/ 
    /*0*/ <0.75656,9.77725,1.40255>,
    /*1*/ <0.74708,9.77716,1.40618>,<0.76062,9.78592,1.39917>,<0.76199,9.76867,1.40231>,
            
    /*2*/ <0.87851,9.8488,1.74201>,<0.88754,9.85464,1.73733>,<0.88845,9.84314,1.73943>,
            
    /*3*/ <0.90055,10.0979,2.00964>,<0.90492,10.10061,2.00682>,<0.90611,10.09635,2.01068>,
            
    /*4*/ <0.90523,10.40898,2.20564>

    /* stem 0.31.18*/ 
    /*0*/ <0.78353,9.90654,1.4763>,
    /*1*/ <0.78824,9.90965,1.46913>,<0.78694,9.9074,1.48472>,<0.77541,9.90258,1.47506>,
            
    /*2*/ <0.62998,10.21942,1.50327>,<0.62911,10.21792,1.51366>,<0.62142,10.2147,1.50721>,
            
    /*3*/ <0.49172,10.53642,1.55396>,<0.49136,10.53548,1.55914>,<0.48735,10.53424,1.55595>,
            
    /*4*/ <0.40954,10.85613,1.66941>

    /* stem 0.31.19*/ 
    /*0*/ <0.80574,10.01298,1.53702>,
    /*1*/ <0.80684,10.00903,1.54354>,<0.80091,10.01899,1.53692>,<0.80946,10.01092,1.53059>,
            
    /*2*/ <1.05897,10.21439,1.62231>,<1.05502,10.22103,1.61789>,<1.06072,10.21565,1.61367>,
            
    /*3*/ <1.22899,10.48154,1.73117>,<1.22645,10.48421,1.72867>,<1.23021,10.4825,1.727>,
            
    /*4*/ <1.32127,10.77666,1.85917>

    /* stem 0.31.20*/ 
    /*0*/ <0.82347,10.09074,1.57305>,
    /*1*/ <0.81846,10.09329,1.56938>,<0.82919,10.09417,1.57375>,<0.82274,10.08477,1.57602>,
            
    /*2*/ <0.70077,10.23797,1.83436>,<0.70793,10.23855,1.83728>,<0.70363,10.23229,1.83879>,
            
    /*3*/ <0.66741,10.47977,2.04742>,<0.67119,10.47958,2.04826>,<0.66865,10.47746,2.05028>,
            
    /*4*/ <0.71426,10.78443,2.14676>

    /* stem 0.31.21*/ 
    /*0*/ <0.86333,10.25209,1.63073>,
    /*1*/ <0.86792,10.25108,1.63037>,<0.86178,10.25478,1.63427>,<0.8603,10.2504,1.62754>,
            
    /*2*/ <0.90738,10.4988,1.46055>,<0.90329,10.50127,1.46315>,<0.9023,10.49835,1.45867>,
            
    /*3*/ <0.92954,10.7978,1.4147>,<0.92737,10.79822,1.41629>,<0.92704,10.79783,1.41362>,
            
    /*4*/ <1.0425,11.07629,1.38064>

    /* stem 0.31.22*/ 
    /*0*/ <0.88062,10.32203,1.65573>,
    /*1*/ <0.87775,10.32183,1.65828>,<0.88133,10.32533,1.65391>,<0.88277,10.31893,1.65501>,
            
    /*2*/ <1.06368,10.40028,1.87176>,<1.06607,10.40261,1.86884>,<1.06703,10.39834,1.86958>,
            
    /*3*/ <1.12499,10.60689,2.0704>,<1.12613,10.60803,2.06888>,<1.12716,10.60652,2.07013>,
            
    /*4*/ <1.15238,10.86724,2.20382>

    /* stem 0.31.23*/ 
    /*0*/ <0.91056,10.44321,1.69905>,
    /*1*/ <0.91096,10.4439,1.69685>,<0.91197,10.44393,1.70078>,<0.90876,10.44179,1.69953>,
            
    /*2*/ <0.74766,10.66507,1.73747>,<0.74834,10.6651,1.74009>,<0.7462,10.66367,1.73926>,
            
    /*3*/ <0.69753,10.92786,1.81276>,<0.69799,10.9276,1.814>,<0.69668,10.92743,1.81372>,
            
    /*4*/ <0.64463,11.17886,1.91994>

    /* stem 0.31.24*/ 
    /*0*/ <0.93823,10.55517,1.73908>,
    /*1*/ <0.93869,10.55479,1.73982>,<0.93771,10.55597,1.7392>,<0.93828,10.55476,1.73822>,
            
    /*2*/ <1.15031,10.70008,1.68137>,<1.14966,10.70086,1.68096>,<1.15003,10.70005,1.68031>,
            
    /*3*/ <1.30079,10.91611,1.6831>,<1.30037,10.91641,1.6829>,<1.30073,10.91616,1.68255>,
            
    /*4*/ <1.35078,11.1565,1.77804>

    /* stem 0.32*/ 
    /*0*/ <0.09606,8.37073,0.00807>,
    /*1*/ <0.11379,8.37038,-0.02264>,<0.11884,8.39791,0.00826>,<0.09241,8.38788,0.0389>,
            <0.07103,8.35415,0.02694>,<0.08424,8.34333,-0.01109>,
    /*2*/ <-0.32627,8.738,-0.27266>,<-0.32223,8.76003,-0.24794>,<-0.34337,8.752,-0.22343>,
            <-0.36048,8.72501,-0.23299>,<-0.34991,8.71636,-0.26342>,
    /*3*/ <-0.76379,9.10654,-0.52537>,<-0.76078,9.12309,-0.50686>,<-0.77674,9.11717,-0.48853>,
            <-0.78961,9.09696,-0.49571>,<-0.7816,9.09039,-0.51849>,
    /*4*/ <-1.17426,9.53212,-0.73234>,<-1.17095,9.54186,-0.71922>,<-1.18156,9.53783,-0.707>,
            <-1.19143,9.5256,-0.71257>,<-1.18692,9.52207,-0.72823>,
    /*5*/ <-1.57088,9.98527,-0.90366>,<-1.56884,9.98969,-0.89689>,<-1.57406,9.98756,-0.89075>,
            <-1.57933,9.98182,-0.89372>,<-1.57736,9.98041,-0.9017>,
    /*6*/ <-1.90951,10.49283,-1.04162>

    /* stem 0.32.0*/ 
    /*0*/ <0.01688,8.43741,-0.0384>,
    /*1*/ <0.01588,8.44728,-0.02253>,<0.0012,8.43195,-0.04702>,<0.03356,8.43299,-0.04564>,
            
    /*2*/ <0.01332,8.96339,-0.35127>,<0.00353,8.95317,-0.36759>,<0.0251,8.95387,-0.36667>,
            
    /*3*/ <-0.16647,9.46595,-0.64936>,<-0.17127,9.45988,-0.65689>,<-0.16095,9.46285,-0.65811>,
            
    /*4*/ <-0.44949,9.95686,-0.87877>

    /* stem 0.32.1*/ 
    /*0*/ <-0.08471,8.52294,-0.09801>,
    /*1*/ <-0.09227,8.50851,-0.10583>,<-0.0841,8.53871,-0.10682>,<-0.07776,8.5216,-0.08138>,
            
    /*2*/ <-0.61608,8.66332,0.12874>,<-0.61063,8.68345,0.12809>,<-0.60641,8.67205,0.14504>,
            
    /*3*/ <-1.06459,9.04726,0.04705>,<-1.05783,9.0552,0.04656>,<-1.06191,9.05238,0.05574>,
            
    /*4*/ <-1.38999,9.45616,-0.23611>

    /* stem 0.32.2*/ 
    /*0*/ <-0.12952,8.56067,-0.1243>,
    /*1*/ <-0.11717,8.57305,-0.12759>,<-0.14538,8.56544,-0.1178>,<-0.12601,8.54353,-0.12752>,
            
    /*2*/ <-0.32704,8.6293,-0.67262>,<-0.34585,8.62422,-0.6661>,<-0.33293,8.60961,-0.67258>,
            
    /*3*/ <-0.7114,8.95454,-0.97306>,<-0.71905,8.95115,-0.9671>,<-0.71662,8.9461,-0.9757>,
            
    /*4*/ <-0.97056,9.47107,-1.06353>

    /* stem 0.32.3*/ 
    /*0*/ <-0.22215,8.63867,-0.17867>,
    /*1*/ <-0.23326,8.63407,-0.16635>,<-0.22654,8.6371,-0.19524>,<-0.20666,8.64485,-0.17442>,
            
    /*2*/ <-0.4423,9.16523,-0.16433>,<-0.43782,9.16725,-0.18359>,<-0.42456,9.17241,-0.16971>,
            
    /*3*/ <-0.69904,9.66959,-0.24151>,<-0.69631,9.66962,-0.25107>,<-0.69039,9.67368,-0.2442>,
            
    /*4*/ <-1.09535,10.07122,-0.31987>

    /* stem 0.32.4*/ 
    /*0*/ <-0.31713,8.71864,-0.2344>,
    /*1*/ <-0.31224,8.71389,-0.24956>,<-0.32085,8.73458,-0.23149>,<-0.3183,8.70746,-0.22216>,
            
    /*2*/ <-0.84147,8.61768,-0.38411>,<-0.84722,8.63147,-0.37206>,<-0.84551,8.61339,-0.36584>,
            
    /*3*/ <-1.35865,8.82543,-0.33542>,<-1.35558,8.83166,-0.32879>,<-1.35882,8.82303,-0.32612>,
            
    /*4*/ <-1.7728,9.165,-0.18639>

    /* stem 0.32.5*/ 
    /*0*/ <-0.36509,8.7592,-0.26278>,
    /*1*/ <-0.36192,8.77073,-0.25167>,<-0.38044,8.75421,-0.26523>,<-0.3529,8.75265,-0.27145>,
            
    /*2*/ <-0.42726,9.15228,-0.63702>,<-0.43961,9.14127,-0.64606>,<-0.42124,9.14022,-0.65021>,
            
    /*3*/ <-0.66155,9.54532,-0.93401>,<-0.66751,9.53906,-0.93775>,<-0.65926,9.5408,-0.94195>,
            
    /*4*/ <-1.02249,9.93003,-1.07262>

    /* stem 0.32.6*/ 
    /*0*/ <-0.48619,8.86202,-0.33502>,
    /*1*/ <-0.49545,8.84967,-0.33709>,<-0.48324,8.87163,-0.34692>,<-0.47988,8.86478,-0.32104>,
            
    /*2*/ <-0.90974,9.14447,-0.20533>,<-0.9016,9.15911,-0.21188>,<-0.89936,9.15455,-0.19463>,
            
    /*3*/ <-1.26286,9.53514,-0.18033>,<-1.25687,9.54088,-0.18382>,<-1.25742,9.53982,-0.1749>,
            
    /*4*/ <-1.62477,9.91492,-0.1567>

    /* stem 0.32.7*/ 
    /*0*/ <-0.54949,8.91577,-0.37277>,
    /*1*/ <-0.5386,8.9235,-0.38002>,<-0.56042,8.92323,-0.36532>,<-0.54944,8.90058,-0.37298>,
            
    /*2*/ <-0.8296,8.92582,-0.8041>,<-0.84414,8.92564,-0.7943>,<-0.83682,8.91054,-0.7994>,
            
    /*3*/ <-1.10727,9.09611,-1.20004>,<-1.1145,9.09606,-1.19509>,<-1.11229,9.08894,-1.1997>,
            
    /*4*/ <-1.35996,9.49092,-1.4102>

    /* stem 0.32.8*/ 
    /*0*/ <-0.64774,8.99919,-0.43138>,
    /*1*/ <-0.65509,8.99939,-0.41878>,<-0.65458,8.99561,-0.44376>,<-0.63355,9.00258,-0.4316>,
            
    /*2*/ <-0.76798,9.47726,-0.49776>,<-0.76764,9.47473,-0.51441>,<-0.75363,9.47938,-0.50631>,
            
    /*3*/ <-0.89855,9.95514,-0.52828>,<-0.8987,9.95463,-0.53669>,<-0.8916,9.95683,-0.53272>,
            
    /*4*/ <-1.21156,10.33316,-0.60544>

    /* stem 0.32.9*/ 
    /*0*/ <-0.72083,9.06126,-0.47498>,
    /*1*/ <-0.72005,9.05376,-0.48695>,<-0.72258,9.07528,-0.47551>,<-0.71986,9.05472,-0.46247>,
            
    /*2*/ <-1.20123,8.99646,-0.47683>,<-1.20292,9.0108,-0.4692>,<-1.20111,8.9971,-0.46051>,
            
    /*3*/ <-1.65848,9.15421,-0.52356>,<-1.6566,9.16104,-0.51951>,<-1.65928,9.15449,-0.51544>,
            
    /*4*/ <-2.02213,9.47562,-0.54437>

    /* stem 0.32.10*/ 
    /*0*/ <-0.81926,9.15363,-0.53043>,
    /*1*/ <-0.8125,9.16337,-0.52391>,<-0.8328,9.15357,-0.53033>,<-0.8125,9.14396,-0.53705>,
            
    /*2*/ <-0.81883,9.42193,-0.91292>,<-0.83237,9.41539,-0.9172>,<-0.81884,9.40898,-0.92168>,
            
    /*3*/ <-0.91239,9.745,-1.23614>,<-0.91914,9.74144,-1.23784>,<-0.91262,9.73949,-1.24168>,
            
    /*4*/ <-1.16609,10.12253,-1.33951>

    /* stem 0.32.11*/ 
    /*0*/ <-0.896,9.23387,-0.57061>,
    /*1*/ <-0.90579,9.22548,-0.56866>,<-0.89539,9.24071,-0.5817>,<-0.88681,9.23541,-0.56149>,
            
    /*2*/ <-1.14718,9.55845,-0.37879>,<-1.14024,9.5686,-0.38749>,<-1.13452,9.56507,-0.37401>,
            
    /*3*/ <-1.34949,9.9655,-0.4001>,<-1.34421,9.96794,-0.40488>,<-1.34326,9.9688,-0.39746>,
            
    /*4*/ <-1.51107,10.3806,-0.48495>

    /* stem 0.32.12*/ 
    /*0*/ <-0.95859,9.29932,-0.60339>,
    /*1*/ <-0.95037,9.30268,-0.61239>,<-0.96438,9.30819,-0.59649>,<-0.96102,9.28709,-0.6013>,
            
    /*2*/ <-1.28148,9.31639,-0.90398>,<-1.29082,9.32006,-0.89338>,<-1.28858,9.30599,-0.89658>,
            
    /*3*/ <-1.58273,9.5233,-1.15021>,<-1.5866,9.52491,-1.14424>,<-1.5879,9.51871,-1.14786>,
            
    /*4*/ <-1.8519,9.81126,-1.34867>

    /* stem 0.32.13*/ 
    /*0*/ <-1.07468,9.42071,-0.66419>,
    /*1*/ <-1.07761,9.42352,-0.65299>,<-1.08321,9.41897,-0.67231>,<-1.06322,9.41963,-0.66726>,
            
    /*2*/ <-1.06488,9.83045,-0.75607>,<-1.06862,9.82742,-0.76895>,<-1.05529,9.82786,-0.76558>,
            
    /*3*/ <-1.03739,10.23313,-0.87338>,<-1.03922,10.23144,-0.87979>,<-1.03258,10.23151,-0.87801>,
            
    /*4*/ <-1.08624,10.64516,-0.93368>

    /* stem 0.32.14*/ 
    /*0*/ <-1.16019,9.51011,-0.70896>,
    /*1*/ <-1.16331,9.50298,-0.71726>,<-1.15893,9.5212,-0.71118>,<-1.15833,9.50616,-0.69846>,
            
    /*2*/ <-1.55075,9.56806,-0.62227>,<-1.54783,9.58021,-0.61822>,<-1.54743,9.57019,-0.60974>,
            
    /*3*/ <-1.90935,9.75519,-0.61233>,<-1.90645,9.76076,-0.61042>,<-1.90857,9.75646,-0.60594>,
            
    /*4*/ <-2.17533,10.06039,-0.62352>

    /* stem 0.32.15*/ 
    /*0*/ <-1.20654,9.56131,-0.7314>,
    /*1*/ <-1.19877,9.56891,-0.72922>,<-1.21713,9.56331,-0.7288>,<-1.20373,9.55172,-0.73618>,
            
    /*2*/ <-1.25856,9.72728,-1.08662>,<-1.2708,9.72355,-1.08634>,<-1.26186,9.71582,-1.09126>,
            
    /*3*/ <-1.34354,10.05097,-1.29289>,<-1.34975,10.04945,-1.2928>,<-1.34603,10.04738,-1.29757>,
            
    /*4*/ <-1.32741,10.42384,-1.41977>

    /* stem 0.32.16*/ 
    /*0*/ <-1.29794,9.66666,-0.77266>,
    /*1*/ <-1.30586,9.66166,-0.76791>,<-1.29947,9.67122,-0.782>,<-1.28851,9.6671,-0.76808>,
            
    /*2*/ <-1.40236,9.98442,-0.59643>,<-1.3981,9.99079,-0.60582>,<-1.3908,9.98805,-0.59654>,
            
    /*3*/ <-1.53807,10.32501,-0.50329>,<-1.53563,10.3274,-0.50829>,<-1.53245,10.32726,-0.50314>,
            
    /*4*/ <-1.71297,10.64361,-0.40086>

    /* stem 0.32.17*/ 
    /*0*/ <-1.39548,9.77908,-0.8167>,
    /*1*/ <-1.391,9.77953,-0.8255>,<-1.39704,9.78736,-0.81153>,<-1.39841,9.77037,-0.81308>,
            
    /*2*/ <-1.71148,9.81981,-0.98308>,<-1.7155,9.82503,-0.97376>,<-1.71641,9.81371,-0.9748>,
            
    /*3*/ <-1.95751,10.04926,-1.10876>,<-1.95834,10.05132,-1.1035>,<-1.96148,10.04693,-1.10538>,
            
    /*4*/ <-2.16173,10.33453,-1.18751>

    /* stem 0.32.18*/ 
    /*0*/ <-1.46904,9.86387,-0.84991>,
    /*1*/ <-1.46851,9.86753,-0.84172>,<-1.47685,9.86391,-0.85436>,<-1.46176,9.86016,-0.85366>,
            
    /*2*/ <-1.38663,10.17046,-0.9859>,<-1.39219,10.16804,-0.99433>,<-1.38213,10.16555,-0.99386>,
            
    /*3*/ <-1.38506,10.48937,-1.1178>,<-1.38791,10.48776,-1.12182>,<-1.38273,10.48763,-1.12209>,
            
    /*4*/ <-1.46281,10.80674,-1.22917>

    /* stem 0.32.19*/ 
    /*0*/ <-1.52639,9.92997,-0.87581>,
    /*1*/ <-1.53072,9.92464,-0.87983>,<-1.52414,9.93674,-0.87933>,<-1.52433,9.92853,-0.86826>,
            
    /*2*/ <-1.80989,10.07475,-0.77335>,<-1.80551,10.08282,-0.77301>,<-1.80563,10.07735,-0.76563>,
            
    /*3*/ <-2.10916,10.22114,-0.7813>,<-2.10718,10.22528,-0.78114>,<-2.10833,10.22313,-0.77725>,
            
    /*4*/ <-2.31497,10.42751,-0.94515>

    /* stem 0.32.20*/ 
    /*0*/ <-1.59193,10.01196,-0.90502>,
    /*1*/ <-1.58627,10.0155,-0.90573>,<-1.59739,10.01485,-0.90237>,<-1.59214,10.00554,-0.90696>,
            
    /*2*/ <-1.68216,10.10609,-1.19868>,<-1.68957,10.10566,-1.19644>,<-1.68608,10.09945,-1.1995>,
            
    /*3*/ <-1.79782,10.30675,-1.42066>,<-1.80138,10.30638,-1.41917>,<-1.80019,10.30397,-1.42196>,
            
    /*4*/ <-1.92434,10.56949,-1.5552>

    /* stem 0.32.21*/ 
    /*0*/ <-1.68513,10.15308,-0.94511>,
    /*1*/ <-1.6883,10.15193,-0.94177>,<-1.68659,10.1548,-0.94928>,<-1.6805,10.1525,-0.94427>,
            
    /*2*/ <-1.67267,10.43142,-0.83273>,<-1.67153,10.43334,-0.83774>,<-1.66747,10.43181,-0.83439>,
            
    /*3*/ <-1.65356,10.72403,-0.76573>,<-1.65298,10.7246,-0.76834>,<-1.65095,10.72407,-0.76657>,
            
    /*4*/ <-1.72576,11.01557,-0.76778>

    /* stem 0.32.22*/ 
    /*0*/ <-1.74692,10.24663,-0.97168>,
    /*1*/ <-1.74629,10.2461,-0.97502>,<-1.74616,10.24967,-0.97026>,<-1.74829,10.24413,-0.96977>,
            
    /*2*/ <-2.009,10.34153,-1.03835>,<-2.00892,10.34391,-1.03518>,<-2.01034,10.34022,-1.03485>,
            
    /*3*/ <-2.19571,10.55322,-1.08872>,<-2.1952,10.55408,-1.08701>,<-2.19669,10.55276,-1.08706>,
            
    /*4*/ <-2.22924,10.81343,-1.20326>

    /* stem 0.32.23*/ 
    /*0*/ <-1.81184,10.34493,-0.99961>,
    /*1*/ <-1.81103,10.34593,-0.99799>,<-1.81387,10.34501,-0.99996>,<-1.81061,10.34386,-1.00088>,
            
    /*2*/ <-1.776,10.56745,-1.152>,<-1.7779,10.56684,-1.15332>,<-1.77572,10.56607,-1.15393>,
            
    /*3*/ <-1.79517,10.80935,-1.27486>,<-1.79612,10.80897,-1.27547>,<-1.79503,10.80883,-1.27593>,
            
    /*4*/ <-1.83288,11.03187,-1.42696>

    /* stem 0.32.24*/ 
    /*0*/ <-1.86369,10.42345,-1.02191>,
    /*1*/ <-1.86445,10.42289,-1.02214>,<-1.86349,10.42423,-1.02245>,<-1.86313,10.42323,-1.02116>,
            
    /*2*/ <-2.01708,10.5668,-0.86778>,<-2.01644,10.5677,-0.86798>,<-2.0162,10.56703,-0.86712>,
            
    /*3*/ <-2.10306,10.77084,-0.73022>,<-2.10264,10.77115,-0.73042>,<-2.10257,10.77086,-0.72995>,
            
    /*4*/ <-2.09316,11.02044,-0.65604>

    /* stem 0.33*/ 
    /*0*/ <0.09297,8.55048,0.00212>,
    /*1*/ <0.09898,8.5527,0.03629>,<0.07421,8.57694,0.01463>,<0.07537,8.56461,-0.02432>,
            <0.10086,8.53275,-0.02672>,<0.11545,8.52539,0.01074>,
    /*2*/ <0.56677,8.93566,-0.07796>,<0.54695,8.95505,-0.09529>,<0.54788,8.94518,-0.12645>,
            <0.56827,8.9197,-0.12838>,<0.57995,8.91381,-0.09841>,
    /*3*/ <0.92838,9.4079,-0.24665>,<0.90958,9.41825,-0.25852>,<0.90983,9.41014,-0.28166>,
            <0.92878,9.39476,-0.28409>,<0.94024,9.39338,-0.26246>,
    /*4*/ <1.16793,9.93362,-0.46495>,<1.15359,9.93742,-0.47183>,<1.15351,9.93135,-0.48701>,
            <1.16779,9.92381,-0.48952>,<1.1767,9.92521,-0.47588>,
    /*5*/ <1.36755,10.49345,-0.61896>,<1.36029,10.49518,-0.62229>,<1.36054,10.49302,-0.63017>,
            <1.36796,10.48995,-0.6317>,<1.37229,10.49022,-0.62477>,
    /*6*/ <1.52608,11.06772,-0.77303>

    /* stem 0.33.0*/ 
    /*0*/ <0.20051,8.63839,-0.02251>,
    /*1*/ <0.19079,8.64662,-0.03553>,<0.2177,8.63335,-0.02578>,<0.19302,8.63519,-0.00621>,
            
    /*2*/ <0.38667,9.17642,0.16177>,<0.40461,9.16758,0.16828>,<0.38816,9.1688,0.18132>,
            
    /*3*/ <0.63251,9.71455,0.24239>,<0.6415,9.71008,0.2455>,<0.63406,9.71242,0.25256>,
            
    /*4*/ <1.06141,10.12128,0.34569>

    /* stem 0.33.1*/ 
    /*0*/ <0.26302,8.6895,-0.03683>,
    /*1*/ <0.27453,8.67599,-0.03482>,<0.26484,8.7043,-0.02701>,<0.24971,8.6882,-0.04865>,
            
    /*2*/ <0.61671,8.91335,-0.4506>,<0.61025,8.93223,-0.4454>,<0.60017,8.92149,-0.45982>,
            
    /*3*/ <1.05483,9.21299,-0.70317>,<1.05075,9.22188,-0.69991>,<1.04808,9.21804,-0.7091>,
            
    /*4*/ <1.42729,9.61428,-0.92203>

    /* stem 0.33.2*/ 
    /*0*/ <0.36179,8.77023,-0.05945>,
    /*1*/ <0.35394,8.78246,-0.05007>,<0.36962,8.77442,-0.07428>,<0.3618,8.75383,-0.05399>,
            
    /*2*/ <0.84465,8.87329,0.23136>,<0.85511,8.86793,0.21522>,<0.84989,8.8542,0.22875>,
            
    /*3*/ <1.40148,8.99852,0.30385>,<1.40351,8.99518,0.29467>,<1.40391,8.98894,0.30245>,
            
    /*4*/ <1.8267,9.36633,0.19937>

    /* stem 0.33.3*/ 
    /*0*/ <0.45297,8.84477,-0.08033>,
    /*1*/ <0.45382,8.83929,-0.09616>,<0.46702,8.84851,-0.07198>,<0.43806,8.84652,-0.07286>,
            
    /*2*/ <0.42278,9.36762,-0.27481>,<0.43158,9.37377,-0.25869>,<0.41227,9.37244,-0.25927>,
            
    /*3*/ <0.40125,9.85796,-0.53758>,<0.4058,9.86222,-0.53017>,<0.39613,9.86174,-0.53029>,
            
    /*4*/ <0.58844,10.37959,-0.61962>

    /* stem 0.33.4*/ 
    /*0*/ <0.50552,8.88773,-0.09237>,
    /*1*/ <0.51171,8.88433,-0.07749>,<0.50429,8.90337,-0.0974>,<0.50055,8.8755,-0.10222>,
            
    /*2*/ <1.01449,8.85527,-0.2993>,<1.00954,8.86796,-0.31258>,<1.00705,8.84938,-0.31579>,
            
    /*3*/ <1.45205,9.06522,-0.56341>,<1.44636,9.07093,-0.56846>,<1.44854,9.06227,-0.57175>,
            
    /*4*/ <1.67835,9.46982,-0.86323>

    /* stem 0.33.5*/ 
    /*0*/ <0.598,8.98084,-0.12139>,
    /*1*/ <0.58545,8.98832,-0.12765>,<0.61146,8.97956,-0.12973>,<0.59707,8.97463,-0.10679>,
            
    /*2*/ <0.76148,9.44717,0.08138>,<0.77882,9.44133,0.07999>,<0.76923,9.43804,0.09529>,
            
    /*3*/ <0.99207,9.86532,0.32386>,<1.00032,9.86141,0.32292>,<0.99531,9.85981,0.33044>,
            
    /*4*/ <1.2725,10.24499,0.57501>

    /* stem 0.33.6*/ 
    /*0*/ <0.65988,9.0615,-0.14902>,
    /*1*/ <0.67099,9.05158,-0.15311>,<0.66351,9.07445,-0.14143>,<0.64515,9.05847,-0.15253>,
            
    /*2*/ <0.72392,9.30513,-0.60564>,<0.71893,9.32038,-0.59785>,<0.70669,9.30973,-0.60525>,
            
    /*3*/ <0.83074,9.64438,-0.98786>,<0.82796,9.65113,-0.98274>,<0.8222,9.64693,-0.98809>,
            
    /*4*/ <1.00094,10.08816,-1.20391>

    /* stem 0.33.7*/ 
    /*0*/ <0.72868,9.15116,-0.17974>,
    /*1*/ <0.72401,9.15883,-0.1678>,<0.72989,9.15796,-0.19299>,<0.73213,9.13668,-0.17844>,
            
    /*2*/ <1.2055,9.28047,-0.06393>,<1.20942,9.27989,-0.08072>,<1.21091,9.2657,-0.07102>,
            
    /*3*/ <1.58884,9.61122,-0.06679>,<1.58956,9.61044,-0.07535>,<1.59407,9.60524,-0.07015>,
            
    /*4*/ <1.77127,10.05397,-0.23448>

    /* stem 0.33.8*/ 
    /*0*/ <0.80745,9.25383,-0.21492>,
    /*1*/ <0.804,9.25175,-0.22872>,<0.82077,9.25795,-0.21139>,<0.7976,9.25178,-0.20465>,
            
    /*2*/ <0.66903,9.72303,-0.26079>,<0.68021,9.72716,-0.24923>,<0.66477,9.72304,-0.24474>,
            
    /*3*/ <0.65571,10.21061,-0.32023>,<0.66147,10.21155,-0.31432>,<0.65342,10.21158,-0.31231>,
            
    /*4*/ <0.72783,10.68361,-0.43033>

    /* stem 0.33.9*/ 
    /*0*/ <0.87215,9.33814,-0.24381>,
    /*1*/ <0.88162,9.33407,-0.23447>,<0.86969,9.35169,-0.24577>,<0.86514,9.32866,-0.25119>,
            
    /*2*/ <1.21672,9.34802,-0.57512>,<1.20876,9.35977,-0.58266>,<1.20573,9.34441,-0.58627>,
            
    /*3*/ <1.58301,9.46836,-0.85677>,<1.57859,9.47414,-0.86017>,<1.57861,9.46674,-0.8633>,
            
    /*4*/ <1.99005,9.65453,-1.02221>

    /* stem 0.33.10*/ 
    /*0*/ <0.93686,9.43438,-0.27853>,
    /*1*/ <0.92466,9.43992,-0.27867>,<0.94499,9.43581,-0.2891>,<0.94095,9.42742,-0.26783>,
            
    /*2*/ <1.10228,9.82545,-0.09268>,<1.11584,9.82272,-0.09964>,<1.11315,9.81712,-0.08546>,
            
    /*3*/ <1.27415,10.24863,-0.01676>,<1.28068,10.24672,-0.02045>,<1.28008,10.24559,-0.01282>,
            
    /*4*/ <1.34753,10.70174,0.03957>

    /* stem 0.33.11*/ 
    /*0*/ <0.98873,9.54767,-0.32406>,
    /*1*/ <0.9966,9.54099,-0.33172>,<0.99325,9.55765,-0.31734>,<0.97634,9.54437,-0.32312>,
            
    /*2*/ <0.89522,9.81682,-0.66924>,<0.89299,9.82793,-0.65965>,<0.88172,9.81908,-0.6635>,
            
    /*3*/ <0.81668,10.13904,-0.97061>,<0.81573,10.14399,-0.96516>,<0.80992,10.14016,-0.96774>,
            
    /*4*/ <0.94963,10.52773,-1.14779>

    /* stem 0.33.12*/ 
    /*0*/ <1.0546,9.69154,-0.38189>,
    /*1*/ <1.05427,9.6962,-0.37066>,<1.05206,9.69858,-0.39147>,<1.05747,9.67983,-0.38353>,
            
    /*2*/ <1.46714,9.80042,-0.40622>,<1.46567,9.802,-0.4201>,<1.46928,9.78951,-0.4148>,
            
    /*3*/ <1.77093,10.07323,-0.5333>,<1.76837,10.07313,-0.53984>,<1.77331,10.06852,-0.53792>,
            
    /*4*/ <1.98342,10.4275,-0.64071>

    /* stem 0.33.13*/ 
    /*0*/ <1.09302,9.77545,-0.41561>,
    /*1*/ <1.08631,9.77465,-0.42523>,<1.10405,9.77944,-0.41645>,<1.0887,9.77225,-0.40515>,
            
    /*2*/ <0.9529,10.16265,-0.35953>,<0.96473,10.16584,-0.35367>,<0.9545,10.16105,-0.34614>,
            
    /*3*/ <0.80414,10.54938,-0.35754>,<0.80987,10.55162,-0.35466>,<0.80468,10.54961,-0.35077>,
            
    /*4*/ <0.74054,10.95956,-0.32703>

    /* stem 0.33.14*/ 
    /*0*/ <1.12794,9.85173,-0.44627>,
    /*1*/ <1.13821,9.84854,-0.4425>,<1.12475,9.86265,-0.44557>,<1.12086,9.844,-0.45074>,
            
    /*2*/ <1.29091,9.91873,-0.81076>,<1.28194,9.92814,-0.8128>,<1.27935,9.9157,-0.81625>,
            
    /*3*/ <1.38271,10.09322,-1.16601>,<1.37763,10.09734,-1.16535>,<1.3768,10.09157,-1.1684>,
            
    /*4*/ <1.42537,10.40929,-1.41623>

    /* stem 0.33.15*/ 
    /*0*/ <1.19294,10.01116,-0.4991>,
    /*1*/ <1.18389,10.01539,-0.49536>,<1.19644,10.01379,-0.50883>,<1.19849,10.00429,-0.49311>,
            
    /*2*/ <1.38524,10.30531,-0.34636>,<1.39361,10.30424,-0.35534>,<1.39497,10.29791,-0.34486>,
            
    /*3*/ <1.53869,10.65093,-0.2885>,<1.54262,10.65002,-0.29316>,<1.54419,10.64837,-0.28744>,
            
    /*4*/ <1.64107,11.01834,-0.25667>

    /* stem 0.33.16*/ 
    /*0*/ <1.21526,10.0733,-0.51543>,
    /*1*/ <1.21924,10.06954,-0.52427>,<1.22121,10.0789,-0.50902>,<1.20532,10.07144,-0.513>,
            
    /*2*/ <1.11582,10.38409,-0.70025>,<1.11714,10.39033,-0.69008>,<1.10654,10.38536,-0.69274>,
            
    /*3*/ <1.09882,10.68626,-0.91929>,<1.09953,10.68982,-0.91451>,<1.09401,10.68823,-0.91628>,
            
    /*4*/ <1.19531,10.99133,-1.11436>

    /* stem 0.33.17*/ 
    /*0*/ <1.25621,10.18735,-0.54541>,
    /*1*/ <1.2588,10.18889,-0.53598>,<1.25025,10.19377,-0.55002>,<1.25957,10.17938,-0.55022>,
            
    /*2*/ <1.54499,10.37585,-0.64883>,<1.53929,10.3791,-0.65819>,<1.5455,10.3695,-0.65833>,
            
    /*3*/ <1.69718,10.68453,-0.75502>,<1.69334,10.68503,-0.75922>,<1.69826,10.68228,-0.76016>,
            
    /*4*/ <1.80913,11.02188,-0.80954>

    /* stem 0.33.18*/ 
    /*0*/ <1.30076,10.31143,-0.57802>,
    /*1*/ <1.29355,10.31254,-0.58361>,<1.30891,10.31504,-0.58025>,<1.29981,10.3067,-0.5702>,
            
    /*2*/ <1.2127,10.60187,-0.41665>,<1.22293,10.60354,-0.41441>,<1.21687,10.59797,-0.40771>,
            
    /*3*/ <1.24963,10.9381,-0.35343>,<1.25486,10.93745,-0.3528>,<1.25162,10.93702,-0.34862>,
            
    /*4*/ <1.33768,11.27025,-0.34318>

    /* stem 0.33.19*/ 
    /*0*/ <1.33766,10.4142,-0.60503>,
    /*1*/ <1.3451,10.41149,-0.60519>,<1.33603,10.42108,-0.60146>,<1.33185,10.41004,-0.60845>,
            
    /*2*/ <1.39504,10.5726,-0.88905>,<1.38899,10.57899,-0.88656>,<1.38621,10.57163,-0.89122>,
            
    /*3*/ <1.48016,10.77461,-1.13558>,<1.4771,10.7777,-1.13415>,<1.47588,10.7745,-1.13719>,
            
    /*4*/ <1.54093,11.00884,-1.36064>

    /* stem 0.33.20*/ 
    /*0*/ <1.37858,10.5385,-0.6374>,
    /*1*/ <1.37429,10.54077,-0.63324>,<1.37859,10.54059,-0.64345>,<1.38288,10.53415,-0.63552>,
            
    /*2*/ <1.57413,10.77001,-0.55507>,<1.577,10.76989,-0.56188>,<1.57986,10.76559,-0.55659>,
            
    /*3*/ <1.63676,11.07521,-0.527>,<1.63812,11.07527,-0.53043>,<1.64035,11.07455,-0.52757>,
            
    /*4*/ <1.5628,11.37863,-0.55452>

    /* stem 0.33.21*/ 
    /*0*/ <1.41068,10.65366,-0.66691>,
    /*1*/ <1.41102,10.65233,-0.67173>,<1.41388,10.657,-0.66501>,<1.40714,10.65164,-0.66401>,
            
    /*2*/ <1.22394,10.87421,-0.74456>,<1.22585,10.87732,-0.74008>,<1.22135,10.87375,-0.73941>,
            
    /*3*/ <1.12572,11.15769,-0.74958>,<1.12716,11.15825,-0.74714>,<1.12443,11.15731,-0.74702>,
            
    /*4*/ <1.1173,11.45596,-0.72493>

    /* stem 0.33.22*/ 
    /*0*/ <1.45104,10.79848,-0.70403>,
    /*1*/ <1.45289,10.79865,-0.70135>,<1.44946,10.80112,-0.70508>,<1.45078,10.79567,-0.70565>,
            
    /*2*/ <1.67384,10.86897,-0.85945>,<1.67155,10.87062,-0.86193>,<1.67244,10.86698,-0.86231>,
            
    /*3*/ <1.89132,11.00488,-0.97266>,<1.89017,11.0057,-0.9739>,<1.89098,11.00406,-0.97432>,
            
    /*4*/ <2.05295,11.23391,-0.96906>

    /* stem 0.33.23*/ 
    /*0*/ <1.48474,10.91939,-0.73502>,
    /*1*/ <1.48306,10.91972,-0.73555>,<1.48612,10.92011,-0.7359>,<1.48504,10.91834,-0.7336>,
            
    /*2*/ <1.47491,11.13178,-0.57664>,<1.47695,11.13204,-0.57688>,<1.47623,11.13086,-0.57534>,
            
    /*3*/ <1.48966,11.3745,-0.47101>,<1.49068,11.37452,-0.4712>,<1.49032,11.37415,-0.4703>,
            
    /*4*/ <1.5038,11.62282,-0.37925>

    /* stem 0.33.24*/ 
    /*0*/ <1.51464,11.02666,-0.76251>,
    /*1*/ <1.51507,11.02649,-0.76269>,<1.51464,11.02702,-0.76217>,<1.51421,11.02647,-0.76267>,
            
    /*2*/ <1.50433,11.19849,-0.94568>,<1.50404,11.19884,-0.94533>,<1.50376,11.19847,-0.94566>,
            
    /*3*/ <1.5136,11.38045,-1.11881>,<1.51345,11.38062,-1.11864>,<1.51331,11.38046,-1.11882>,
            
    /*4*/ <1.50009,11.61885,-1.19745>

    /* stem 0.34*/ 
    /*0*/ <0.08875,8.64446,-0.00325>,
    /*1*/ <0.06244,8.64202,-0.02528>,<0.09231,8.66924,-0.02685>,<0.11726,8.66222,0.00419>,
            <0.10281,8.63066,0.02495>,<0.06893,8.61818,0.00674>,
    /*2*/ <-0.25922,9.02142,0.32762>,<-0.23532,9.04319,0.32636>,<-0.21536,9.03758,0.3512>,
            <-0.22692,9.01233,0.3678>,<-0.25403,9.00235,0.35323>,
    /*3*/ <-0.46984,9.46886,0.69193>,<-0.44954,9.48163,0.68824>,<-0.43358,9.47547,0.70545>,
            <-0.44402,9.45889,0.71977>,<-0.46643,9.45481,0.71142>,
    /*4*/ <-0.65865,9.92338,1.05298>,<-0.64491,9.93144,1.05019>,<-0.6342,9.92713,1.06152>,
            <-0.64132,9.91639,1.07131>,<-0.65644,9.91408,1.06602>,
    /*5*/ <-0.798,10.41891,1.38092>,<-0.79087,10.42223,1.37904>,<-0.78554,10.42007,1.38473>,
            <-0.78937,10.41543,1.39012>,<-0.79708,10.41471,1.38777>,
    /*6*/ <-0.87602,10.96233,1.64694>

    /* stem 0.34.0*/ 
    /*0*/ <0.01384,8.73129,0.0766>,
    /*1*/ <0.02854,8.74131,0.0795>,<0.00435,8.72496,0.09056>,<0.00862,8.7276,0.05975>,
            
    /*2*/ <-0.30986,9.22837,0.07433>,<-0.32598,9.21747,0.08171>,<-0.32313,9.21923,0.06117>,
            
    /*3*/ <-0.7185,9.58679,0.31609>,<-0.72419,9.57855,0.31891>,<-0.72575,9.58303,0.30964>,
            
    /*4*/ <-1.06023,9.99896,0.56919>

    /* stem 0.34.1*/ 
    /*0*/ <-0.02676,8.77834,0.11988>,
    /*1*/ <-0.03533,8.76453,0.12686>,<-0.03587,8.79205,0.11338>,<-0.00907,8.77845,0.1194>,
            
    /*2*/ <-0.0199,9.02608,0.64879>,<-0.02026,9.04443,0.63981>,<-0.0024,9.03537,0.64382>,
            
    /*3*/ <-0.06203,9.40519,1.09353>,<-0.06202,9.41302,1.08697>,<-0.05321,9.40953,1.09078>,
            
    /*4*/ <-0.20609,9.8659,1.42341>

    /* stem 0.34.2*/ 
    /*0*/ <-0.08199,8.84236,0.17876>,
    /*1*/ <-0.08325,8.8534,0.16557>,<-0.07603,8.84778,0.194>,<-0.08669,8.82589,0.1767>,
            
    /*2*/ <-0.61516,8.98153,0.33118>,<-0.61035,8.97778,0.35013>,<-0.61746,8.9632,0.3386>,
            
    /*3*/ <-1.0544,9.21943,0.61007>,<-1.0503,9.21696,0.61881>,<-1.05657,9.21068,0.6143>,
            
    /*4*/ <-1.45171,9.59223,0.77747>

    /* stem 0.34.3*/ 
    /*0*/ <-0.15281,8.92444,0.25425>,
    /*1*/ <-0.14287,8.9211,0.26721>,<-0.16935,8.92479,0.25631>,<-0.14622,8.92742,0.23923>,
            
    /*2*/ <-0.11972,9.46437,0.3822>,<-0.13737,9.46683,0.37494>,<-0.12195,9.46859,0.36355>,
            
    /*3*/ <-0.17366,10.01987,0.35008>,<-0.1823,10.01887,0.34595>,<-0.17438,10.01932,0.3405>,
            
    /*4*/ <-0.30745,10.55928,0.36195>

    /* stem 0.34.4*/ 
    /*0*/ <-0.20684,8.98706,0.31184>,
    /*1*/ <-0.22049,8.98164,0.30492>,<-0.20497,9.00291,0.3148>,<-0.19505,8.97662,0.3158>,
            
    /*2*/ <-0.43902,8.91803,0.79868>,<-0.42868,8.93221,0.80527>,<-0.42206,8.91468,0.80594>,
            
    /*3*/ <-0.68518,9.19123,1.2005>,<-0.6782,9.19748,1.20064>,<-0.67778,9.18986,1.20608>,
            
    /*4*/ <-0.82423,9.55214,1.58424>

    /* stem 0.34.5*/ 
    /*0*/ <-0.25043,9.04878,0.36571>,
    /*1*/ <-0.23794,9.05779,0.362>,<-0.2541,9.04619,0.3809>,<-0.25924,9.04235,0.35423>,
            
    /*2*/ <-0.55416,9.48623,0.3612>,<-0.56493,9.4785,0.37379>,<-0.56836,9.47594,0.35602>,
            
    /*3*/ <-0.8506,9.92747,0.38631>,<-0.85599,9.92359,0.3926>,<-0.85798,9.92275,0.38372>,
            
    /*4*/ <-1.05731,10.31771,0.68419>

    /* stem 0.34.6*/ 
    /*0*/ <-0.29424,9.13958,0.43885>,
    /*1*/ <-0.29852,9.12916,0.44922>,<-0.30377,9.15093,0.43504>,<-0.28044,9.13864,0.4323>,
            
    /*2*/ <-0.09818,9.42622,0.82269>,<-0.10168,9.44073,0.81324>,<-0.08613,9.43253,0.81141>,
            
    /*3*/ <-0.06656,9.80519,1.17443>,<-0.06865,9.81117,1.16827>,<-0.06018,9.80911,1.16973>,
            
    /*4*/ <-0.14096,10.10226,1.59008>

    /* stem 0.34.7*/ 
    /*0*/ <-0.34015,9.23471,0.51549>,
    /*1*/ <-0.34546,9.2417,0.50364>,<-0.33231,9.24215,0.52554>,<-0.34267,9.2203,0.5173>,
            
    /*2*/ <-0.76529,9.34467,0.75865>,<-0.75652,9.34497,0.77325>,<-0.76343,9.3304,0.76776>,
            
    /*3*/ <-1.08264,9.62785,1.02359>,<-1.07737,9.62764,1.03027>,<-1.0834,9.62169,1.02942>,
            
    /*4*/ <-1.18907,10.05979,1.25536>

    /* stem 0.34.8*/ 
    /*0*/ <-0.38282,9.32315,0.58673>,
    /*1*/ <-0.37099,9.32251,0.59462>,<-0.39553,9.32429,0.59305>,<-0.38195,9.32266,0.57253>,
            
    /*2*/ <-0.3388,9.80846,0.57725>,<-0.35516,9.80965,0.5762>,<-0.34611,9.80856,0.56252>,
            
    /*3*/ <-0.43814,10.28478,0.62356>,<-0.44618,10.28324,0.62281>,<-0.44166,10.28484,0.61613>,
            
    /*4*/ <-0.59105,10.72579,0.7634>

    /* stem 0.34.9*/ 
    /*0*/ <-0.43035,9.42166,0.66609>,
    /*1*/ <-0.44284,9.41613,0.66547>,<-0.42885,9.43523,0.66538>,<-0.41937,9.41362,0.66741>,
            
    /*2*/ <-0.47432,9.44638,1.13456>,<-0.46499,9.45911,1.13449>,<-0.45868,9.44471,1.13585>,
            
    /*3*/ <-0.52341,9.68489,1.53933>,<-0.5184,9.69042,1.53675>,<-0.51568,9.68419,1.54075>,
            
    /*4*/ <-0.58963,10.04288,1.83887>

    /* stem 0.34.10*/ 
    /*0*/ <-0.47967,9.53103,0.75292>,
    /*1*/ <-0.4721,9.53941,0.74637>,<-0.47975,9.53113,0.76598>,<-0.48716,9.52254,0.74642>,
            
    /*2*/ <-0.8128,9.83847,0.74417>,<-0.81789,9.83295,0.75724>,<-0.82283,9.82722,0.7442>,
            
    /*3*/ <-1.06871,10.20086,0.83319>,<-1.07088,10.1978,0.83973>,<-1.07487,10.19653,0.83346>,
            
    /*4*/ <-1.28949,10.57116,0.97337>

    /* stem 0.34.11*/ 
    /*0*/ <-0.51333,9.60972,0.81474>,
    /*1*/ <-0.51285,9.60206,0.82475>,<-0.52265,9.61817,0.81369>,<-0.50449,9.60894,0.80577>,
            
    /*2*/ <-0.26841,9.90129,1.03664>,<-0.27494,9.91203,1.02927>,<-0.26284,9.90588,1.02399>,
            
    /*3*/ <-0.19967,10.24595,1.30222>,<-0.20342,10.25026,1.29769>,<-0.19623,10.24948,1.29685>,
            
    /*4*/ <-0.21527,10.59021,1.57678>

    /* stem 0.34.12*/ 
    /*0*/ <-0.54173,9.67612,0.86689>,
    /*1*/ <-0.54955,9.67965,0.85814>,<-0.5348,9.68444,0.87264>,<-0.54084,9.66428,0.8699>,
            
    /*2*/ <-0.85464,9.73039,1.15684>,<-0.84482,9.73358,1.1665>,<-0.84884,9.72014,1.16467>,
            
    /*3*/ <-1.164,9.93594,1.36931>,<-1.15941,9.93772,1.37439>,<-1.16307,9.93169,1.37489>,
            
    /*4*/ <-1.43372,10.26325,1.43155>

    /* stem 0.34.13*/ 
    /*0*/ <-0.59116,9.79169,0.95767>,
    /*1*/ <-0.58025,9.79362,0.96116>,<-0.59952,9.78981,0.96552>,<-0.59371,9.79166,0.94634>,
            
    /*2*/ <-0.66021,10.19687,0.97587>,<-0.67306,10.19433,0.97877>,<-0.66919,10.19557,0.96599>,
            
    /*3*/ <-0.74342,10.58803,1.07075>,<-0.74977,10.58639,1.07218>,<-0.74811,10.58825,1.06595>,
            
    /*4*/ <-0.81305,10.93694,1.27648>

    /* stem 0.34.14*/ 
    /*0*/ <-0.61888,9.85651,1.00858>,
    /*1*/ <-0.62791,9.85041,1.01144>,<-0.62009,9.86733,1.00569>,<-0.60865,9.8518,1.00862>,
            
    /*2*/ <-0.57648,9.96023,1.39359>,<-0.57127,9.97152,1.38976>,<-0.56364,9.96116,1.39171>,
            
    /*3*/ <-0.58379,10.19215,1.72132>,<-0.5812,10.19708,1.71795>,<-0.57733,10.19285,1.72103>,
            
    /*4*/ <-0.72523,10.42512,2.01414>

    /* stem 0.34.15*/ 
    /*0*/ <-0.65753,9.95813,1.08371>,
    /*1*/ <-0.6541,9.96438,1.07569>,<-0.65405,9.95985,1.09372>,<-0.66445,9.95017,1.08173>,
            
    /*2*/ <-0.94973,10.20267,1.13959>,<-0.9497,10.19965,1.15161>,<-0.95663,10.1932,1.14362>,
            
    /*3*/ <-1.16538,10.5178,1.17311>,<-1.16578,10.51693,1.17923>,<-1.17001,10.51443,1.17547>,
            
    /*4*/ <-1.37809,10.83667,1.20955>

    /* stem 0.34.16*/ 
    /*0*/ <-0.68662,10.05754,1.1487>,
    /*1*/ <-0.68309,10.05303,1.15719>,<-0.69536,10.06289,1.14899>,<-0.68142,10.05672,1.13992>,
            
    /*2*/ <-0.49403,10.361,1.23835>,<-0.50221,10.36757,1.23288>,<-0.49291,10.36346,1.22683>,
            
    /*3*/ <-0.49337,10.66898,1.44283>,<-0.4978,10.6712,1.43959>,<-0.49219,10.67222,1.43802>,
            
    /*4*/ <-0.54844,10.93179,1.69731>

    /* stem 0.34.17*/ 
    /*0*/ <-0.71783,10.16421,1.21843>,
    /*1*/ <-0.72608,10.16512,1.21335>,<-0.71184,10.17182,1.21938>,<-0.71558,10.15571,1.22256>,
            
    /*2*/ <-0.89423,10.26272,1.50993>,<-0.88474,10.26718,1.51395>,<-0.88723,10.25644,1.51607>,
            
    /*3*/ <-1.02954,10.47835,1.75658>,<-1.02439,10.48018,1.75787>,<-1.02655,10.47575,1.76056>,
            
    /*4*/ <-1.11598,10.77417,1.93196>

    /* stem 0.34.18*/ 
    /*0*/ <-0.75519,10.29189,1.3019>,
    /*1*/ <-0.74695,10.29446,1.30165>,<-0.75952,10.29196,1.30937>,<-0.75911,10.28925,1.29467>,
            
    /*2*/ <-0.84977,10.60827,1.24082>,<-0.85814,10.60661,1.24596>,<-0.85787,10.6048,1.23616>,
            
    /*3*/ <-0.9687,10.90205,1.35308>,<-0.97236,10.89968,1.3555>,<-0.97306,10.90119,1.3508>,
            
    /*4*/ <-1.08238,11.19471,1.47204>

    /* stem 0.34.19*/ 
    /*0*/ <-0.77838,10.37113,1.3537>,
    /*1*/ <-0.78301,10.36699,1.35797>,<-0.78083,10.37756,1.35063>,<-0.7713,10.36884,1.35251>,
            
    /*2*/ <-0.68459,10.53098,1.61959>,<-0.68314,10.53803,1.6147>,<-0.67678,10.53222,1.61595>,
            
    /*3*/ <-0.61076,10.68484,1.89459>,<-0.61004,10.68851,1.89237>,<-0.60678,10.68572,1.89306>,
            
    /*4*/ <-0.64091,10.89886,2.13595>

    /* stem 0.34.20*/ 
    /*0*/ <-0.80285,10.48759,1.41795>,
    /*1*/ <-0.80278,10.4902,1.41255>,<-0.7998,10.49002,1.42251>,<-0.80598,10.48253,1.41879>,
            
    /*2*/ <-1.05041,10.65519,1.49126>,<-1.04843,10.65507,1.4979>,<-1.05255,10.65007,1.49542>,
            
    /*3*/ <-1.24089,10.88068,1.57758>,<-1.2397,10.88047,1.58083>,<-1.24241,10.87855,1.57985>,
            
    /*4*/ <-1.31019,11.16704,1.66602>

    /* stem 0.34.21*/ 
    /*0*/ <-0.81923,10.59384,1.4692>,
    /*1*/ <-0.81631,10.59264,1.47263>,<-0.82335,10.59576,1.47022>,<-0.81803,10.59312,1.46475>,
            
    /*2*/ <-0.69551,10.85988,1.46123>,<-0.7002,10.86196,1.45963>,<-0.69665,10.8602,1.45598>,
            
    /*3*/ <-0.72037,11.15329,1.45785>,<-0.7229,11.15307,1.45698>,<-0.72088,11.15322,1.45521>,
            
    /*4*/ <-0.78678,11.41607,1.56966>

    /* stem 0.34.22*/ 
    /*0*/ <-0.83424,10.69123,1.51618>,
    /*1*/ <-0.83758,10.69109,1.5154>,<-0.83241,10.69402,1.51537>,<-0.83274,10.68859,1.51776>,
            
    /*2*/ <-0.89905,10.80453,1.76435>,<-0.89561,10.80648,1.76433>,<-0.89583,10.80286,1.76593>,
            
    /*3*/ <-1.00462,10.95047,1.97873>,<-1.00294,10.95153,1.97884>,<-1.00313,10.94986,1.97988>,
            
    /*4*/ <-1.09156,11.18668,2.10225>

    /* stem 0.34.23*/ 
    /*0*/ <-0.84853,10.78392,1.56088>,
    /*1*/ <-0.84658,10.78464,1.56001>,<-0.84911,10.78451,1.56298>,<-0.84989,10.78259,1.55966>,
            
    /*2*/ <-0.97115,11.00142,1.46369>,<-0.97284,11.00133,1.46567>,<-0.97336,11.00005,1.46346>,
            
    /*3*/ <-1.01272,11.2603,1.41044>,<-1.01358,11.26036,1.41143>,<-1.01399,11.26005,1.41023>,
            
    /*4*/ <-1.02849,11.52684,1.43267>

    /* stem 0.34.24*/ 
    /*0*/ <-0.86904,10.91701,1.62508>,
    /*1*/ <-0.86924,10.91676,1.62555>,<-0.86927,10.91751,1.6249>,<-0.86861,10.91678,1.62479>,
            
    /*2*/ <-0.70489,11.04353,1.76495>,<-0.70491,11.04403,1.76452>,<-0.70447,11.04355,1.76444>,
            
    /*3*/ <-0.62451,11.24276,1.89289>,<-0.62456,11.24296,1.89262>,<-0.62426,11.24281,1.89267>,
            
    /*4*/ <-0.64798,11.48536,1.94881>

    /* stem 0.35*/ 
    /*0*/ <0.08083,8.82066,-0.01333>,
    /*1*/ <0.11451,8.82217,-0.01339>,<0.09011,8.84696,0.00562>,<0.05288,8.8354,-0.00156>,
            <0.05427,8.80347,-0.025>,<0.09236,8.79529,-0.03232>,
    /*2*/ <0.09097,9.17619,-0.49697>,<0.07145,9.19602,-0.48176>,<0.04166,9.18677,-0.4875>,
            <0.04277,9.16123,-0.50626>,<0.07324,9.15469,-0.51211>,
    /*3*/ <0.04999,9.5498,-0.96533>,<0.03537,9.56392,-0.95299>,<0.01306,9.55676,-0.95707>,
            <0.01389,9.53821,-0.97194>,<0.03672,9.53391,-0.97704>,
    /*4*/ <-0.05859,9.95835,-1.39394>,<-0.06819,9.96626,-1.38411>,<-0.08288,9.96061,-1.386>,
            <-0.08237,9.94921,-1.397>,<-0.06736,9.94781,-1.40191>,
    /*5*/ <-0.20868,10.37791,-1.7968>,<-0.21338,10.38142,-1.79147>,<-0.22063,10.37829,-1.79216>,
            <-0.22041,10.37284,-1.79791>,<-0.21303,10.37261,-1.80078>,
    /*6*/ <-0.35529,10.84964,-2.13687>

    /* stem 0.35.0*/ 
    /*0*/ <0.07717,8.89778,-0.11859>,
    /*1*/ <0.06323,8.90634,-0.11184>,<0.07637,8.89111,-0.13496>,<0.0919,8.8959,-0.10898>,
            
    /*2*/ <0.27245,9.40653,-0.32912>,<0.28121,9.39638,-0.34454>,<0.29156,9.39957,-0.32721>,
            
    /*3*/ <0.52048,9.89283,-0.53884>,<0.52488,9.88746,-0.54634>,<0.52977,9.88879,-0.53747>,
            
    /*4*/ <0.77497,10.3064,-0.86497>

    /* stem 0.35.1*/ 
    /*0*/ <0.0747,8.94975,-0.18952>,
    /*1*/ <0.0783,8.93615,-0.19961>,<0.08367,8.96445,-0.19128>,<0.06213,8.94865,-0.17766>,
            
    /*2*/ <-0.30367,9.12661,-0.58272>,<-0.30009,9.14548,-0.57717>,<-0.31445,9.13495,-0.56809>,
            
    /*3*/ <-0.57135,9.38014,-1.02189>,<-0.56893,9.38914,-1.01828>,<-0.57751,9.38481,-1.01555>,
            
    /*4*/ <-0.65555,9.86483,-1.32109>

    /* stem 0.35.2*/ 
    /*0*/ <0.0719,9.0089,-0.27025>,
    /*1*/ <0.07982,9.02105,-0.26162>,<0.05891,9.01278,-0.28031>,<0.07696,8.99287,-0.26882>,
            
    /*2*/ <0.43161,9.09081,-0.6937>,<0.41767,9.08529,-0.70616>,<0.42971,9.07201,-0.6985>,
            
    /*3*/ <0.74732,9.25696,-1.12597>,<0.74039,9.25417,-1.13222>,<0.74734,9.24789,-1.12955>,
            
    /*4*/ <0.86135,9.66644,-1.49094>

    /* stem 0.35.3*/ 
    /*0*/ <0.06861,9.07818,-0.3648>,
    /*1*/ <0.05344,9.07298,-0.36809>,<0.07934,9.08033,-0.37698>,<0.07305,9.08123,-0.34934>,
            
    /*2*/ <-0.1075,9.59351,-0.42159>,<-0.09023,9.59841,-0.42752>,<-0.09442,9.59901,-0.40909>,
            
    /*3*/ <-0.18575,10.1303,-0.50581>,<-0.17672,10.13129,-0.50843>,<-0.17915,10.13235,-0.49936>,
            
    /*4*/ <-0.33245,10.65391,-0.56364>

    /* stem 0.35.4*/ 
    /*0*/ <0.06566,9.14045,-0.4498>,
    /*1*/ <0.08079,9.13674,-0.45305>,<0.0609,9.15564,-0.4503>,<0.05527,9.12899,-0.44605>,
            
    /*2*/ <-0.04902,9.08181,-0.96895>,<-0.06227,9.09441,-0.96712>,<-0.06603,9.07664,-0.96428>,
            
    /*3*/ <-0.2074,9.40214,-1.37051>,<-0.21267,9.40693,-1.3647>,<-0.21615,9.39967,-1.36913>,
            
    /*4*/ <-0.37352,9.82883,-1.64833>

    /* stem 0.35.5*/ 
    /*0*/ <0.05899,9.22988,-0.5657>,
    /*1*/ <0.05089,9.23973,-0.55725>,<0.05361,9.22519,-0.57923>,<0.07246,9.22472,-0.56062>,
            
    /*2*/ <0.2925,9.63209,-0.79218>,<0.29431,9.6224,-0.80683>,<0.30688,9.62209,-0.79442>,
            
    /*3*/ <0.43559,10.04155,-1.07254>,<0.43631,10.03647,-1.07973>,<0.44328,10.03766,-1.07444>,
            
    /*4*/ <0.51586,10.39536,-1.44188>

    /* stem 0.35.6*/ 
    /*0*/ <0.05215,9.30451,-0.65919>,
    /*1*/ <0.0501,9.29299,-0.66823>,<0.05996,9.3162,-0.66376>,<0.0464,9.30433,-0.64557>,
            
    /*2*/ <-0.3699,9.5093,-0.84043>,<-0.36333,9.52477,-0.83745>,<-0.37237,9.51686,-0.82532>,
            
    /*3*/ <-0.74532,9.78771,-1.02825>,<-0.74108,9.79486,-1.02634>,<-0.74645,9.79144,-1.02066>,
            
    /*4*/ <-0.95827,10.19868,-1.22783>

    /* stem 0.35.7*/ 
    /*0*/ <0.04767,9.35343,-0.72048>,
    /*1*/ <0.05839,9.36137,-0.71492>,<0.03521,9.35972,-0.72422>,<0.04942,9.3392,-0.72229>,
            
    /*2*/ <0.23115,9.43825,-1.17066>,<0.2157,9.43715,-1.17686>,<0.22517,9.42347,-1.17558>,
            
    /*3*/ <0.31424,9.6987,-1.58019>,<0.30623,9.69792,-1.5824>,<0.31181,9.69223,-1.58488>,
            
    /*4*/ <0.29449,10.06011,-1.91534>

    /* stem 0.35.8*/ 
    /*0*/ <0.0388,9.45033,-0.84187>,
    /*1*/ <0.02503,9.44946,-0.84156>,<0.0456,9.4479,-0.85363>,<0.04576,9.45364,-0.83043>,
            
    /*2*/ <-0.00202,9.9096,-0.95522>,<0.01169,9.90856,-0.96326>,<0.0118,9.91239,-0.9478>,
            
    /*3*/ <-0.01602,10.33286,-1.17034>,<-0.00909,10.33132,-1.17396>,<-0.00916,10.33493,-1.16686>,
            
    /*4*/ <-0.14559,10.7266,-1.39944>

    /* stem 0.35.9*/ 
    /*0*/ <0.03362,9.50682,-0.91264>,
    /*1*/ <0.04418,9.50074,-0.91826>,<0.03275,9.52021,-0.91274>,<0.02394,9.49951,-0.90691>,
            
    /*2*/ <-0.1852,9.48485,-1.32112>,<-0.19282,9.49783,-1.31744>,<-0.1987,9.48402,-1.31355>,
            
    /*3*/ <-0.31851,9.65955,-1.7298>,<-0.32166,9.66566,-1.72623>,<-0.32592,9.65933,-1.72755>,
            
    /*4*/ <-0.32327,9.90538,-2.12241>

    /* stem 0.35.10*/ 
    /*0*/ <0.0153,9.6067,-1.02588>,
    /*1*/ <0.01271,9.61545,-1.01692>,<0.00856,9.60648,-1.03674>,<0.02464,9.59817,-1.02398>,
            
    /*2*/ <0.30639,9.89125,-1.2072>,<0.30362,9.88527,-1.22041>,<0.31434,9.87974,-1.2119>,
            
    /*3*/ <0.57487,10.12189,-1.48047>,<0.5726,10.11783,-1.48621>,<0.57846,10.11569,-1.48226>,
            
    /*4*/ <0.68875,10.43926,-1.77061>

    /* stem 0.35.11*/ 
    /*0*/ <-0.01199,9.71619,-1.14068>,
    /*1*/ <-0.01762,9.70778,-1.14736>,<-0.00339,9.72313,-1.14566>,<-0.01496,9.71766,-1.12902>,
            
    /*2*/ <-0.31113,9.99694,-1.25653>,<-0.30164,10.00717,-1.2554>,<-0.30936,10.00352,-1.24431>,
            
    /*3*/ <-0.48524,10.36554,-1.38728>,<-0.47928,10.36892,-1.38587>,<-0.48421,10.36833,-1.38094>,
            
    /*4*/ <-0.52338,10.73073,-1.60415>

    /* stem 0.35.12*/ 
    /*0*/ <-0.03769,9.8193,-1.24879>,
    /*1*/ <-0.02717,9.82365,-1.24714>,<-0.04681,9.82629,-1.24918>,<-0.03909,9.80794,-1.25004>,
            
    /*2*/ <0.01654,9.86098,-1.65112>,<0.00345,9.86274,-1.65248>,<0.0086,9.85051,-1.65305>,
            
    /*3*/ <-0.01301,10.04602,-2.0137>,<-0.01959,10.04654,-2.01296>,<-0.01699,10.04118,-2.01591>,
            
    /*4*/ <-0.10112,10.23372,-2.3657>

    /* stem 0.35.13*/ 
    /*0*/ <-0.05712,9.89725,-1.33053>,
    /*1*/ <-0.06747,9.89851,-1.32687>,<-0.05505,9.89736,-1.34137>,<-0.04885,9.89589,-1.32334>,
            
    /*2*/ <-0.01168,10.28863,-1.31425>,<-0.00341,10.28787,-1.32392>,<0.00073,10.28689,-1.3119>,
            
    /*3*/ <-0.00469,10.68037,-1.27994>,<-0.00058,10.68077,-1.28479>,<0.00158,10.68021,-1.27882>,
            
    /*4*/ <-0.05151,11.07035,-1.25114>

    /* stem 0.35.14*/ 
    /*0*/ <-0.08157,9.98487,-1.41987>,
    /*1*/ <-0.07621,9.97961,-1.42725>,<-0.08132,9.99539,-1.41967>,<-0.08719,9.9796,-1.41269>,
            
    /*2*/ <-0.38046,9.99292,-1.65281>,<-0.38387,10.00344,-1.64776>,<-0.38778,9.99291,-1.6431>,
            
    /*3*/ <-0.65635,10.17583,-1.84099>,<-0.65613,10.18038,-1.83697>,<-0.65988,10.17569,-1.83604>,
            
    /*4*/ <-0.90941,10.40573,-2.0052>

    /* stem 0.35.15*/ 
    /*0*/ <-0.1082,10.06292,-1.49478>,
    /*1*/ <-0.10678,10.07008,-1.48782>,<-0.11691,10.06248,-1.49985>,<-0.10092,10.0562,-1.49665>,
            
    /*2*/ <0.03098,10.28899,-1.74622>,<0.02423,10.28392,-1.75425>,<0.03489,10.27973,-1.75211>,
            
    /*3*/ <0.07888,10.5668,-1.97764>,<0.0754,10.56422,-1.98153>,<0.08113,10.56317,-1.98161>,
            
    /*4*/ <0.11226,10.85762,-2.19644>

    /* stem 0.35.16*/ 
    /*0*/ <-0.14846,10.18091,-1.608>,
    /*1*/ <-0.15529,10.17536,-1.61135>,<-0.14284,10.18558,-1.61395>,<-0.14723,10.18178,-1.5987>,
            
    /*2*/ <-0.37175,10.44447,-1.60658>,<-0.36345,10.45129,-1.60831>,<-0.36638,10.44875,-1.59814>,
            
    /*3*/ <-0.52134,10.75176,-1.66245>,<-0.51645,10.75406,-1.66312>,<-0.51871,10.75386,-1.65818>,
            
    /*4*/ <-0.65435,11.07084,-1.65426>

    /* stem 0.35.17*/ 
    /*0*/ <-0.16641,10.23352,-1.65849>,
    /*1*/ <-0.15763,10.23526,-1.6598>,<-0.17231,10.24033,-1.65783>,<-0.16928,10.22497,-1.65786>,
            
    /*2*/ <-0.20844,10.22587,-1.9922>,<-0.21822,10.22925,-1.99088>,<-0.2162,10.21901,-1.9909>,
            
    /*3*/ <-0.38034,10.36829,-2.24622>,<-0.38426,10.36942,-2.24297>,<-0.38423,10.36488,-2.24555>,
            
    /*4*/ <-0.50561,10.56554,-2.48759>

    /* stem 0.35.18*/ 
    /*0*/ <-0.20543,10.3479,-1.76826>,
    /*1*/ <-0.21092,10.35002,-1.7641>,<-0.20622,10.34767,-1.77542>,<-0.19916,10.34601,-1.76527>,
            
    /*2*/ <-0.10877,10.64909,-1.78605>,<-0.10564,10.64752,-1.7936>,<-0.10093,10.64641,-1.78683>,
            
    /*3*/ <-0.13475,10.95826,-1.84373>,<-0.13328,10.95769,-1.84757>,<-0.13066,10.9585,-1.84444>,
            
    /*4*/ <-0.19532,11.25311,-1.94249>

    /* stem 0.35.19*/ 
    /*0*/ <-0.22702,10.41642,-1.82453>,
    /*1*/ <-0.226,10.41306,-1.82961>,<-0.2241,10.42182,-1.82376>,<-0.23094,10.41439,-1.82021>,
            
    /*2*/ <-0.45614,10.55828,-1.96914>,<-0.45487,10.56412,-1.96524>,<-0.45943,10.55917,-1.96288>,
            
    /*3*/ <-0.64694,10.78927,-2.03682>,<-0.6454,10.7913,-2.03433>,<-0.64819,10.78924,-2.03348>,
            
    /*4*/ <-0.81488,11.03368,-2.11149>

    /* stem 0.35.20*/ 
    /*0*/ <-0.25272,10.50323,-1.88711>,
    /*1*/ <-0.2503,10.50619,-1.88399>,<-0.25687,10.50479,-1.88928>,<-0.25099,10.4987,-1.88806>,
            
    /*2*/ <-0.0945,10.61184,-2.10801>,<-0.09888,10.6109,-2.11154>,<-0.09496,10.60685,-2.11072>,
            
    /*3*/ <-0.03137,10.80206,-2.32101>,<-0.03378,10.80135,-2.32237>,<-0.03136,10.79994,-2.32292>,
            
    /*4*/ <-0.03819,11.03779,-2.49404>

    /* stem 0.35.21*/ 
    /*0*/ <-0.28368,10.60781,-1.96251>,
    /*1*/ <-0.28684,10.60651,-1.96301>,<-0.28184,10.60894,-1.9652>,<-0.28237,10.60797,-1.95933>,
            
    /*2*/ <-0.39448,10.85933,-1.93054>,<-0.39115,10.86095,-1.932>,<-0.3915,10.8603,-1.92808>,
            
    /*3*/ <-0.54324,11.09105,-1.90776>,<-0.54172,11.0921,-1.90851>,<-0.54187,11.09182,-1.90654>,
            
    /*4*/ <-0.5937,11.36238,-1.93259>

    /* stem 0.35.22*/ 
    /*0*/ <-0.31841,10.72508,-2.04707>,
    /*1*/ <-0.31679,10.72504,-2.04779>,<-0.31908,10.72662,-2.0465>,<-0.31935,10.72359,-2.04691>,
            
    /*2*/ <-0.42108,10.76556,-2.28121>,<-0.42261,10.76662,-2.28035>,<-0.42278,10.7646,-2.28062>,
            
    /*3*/ <-0.58421,10.89956,-2.43169>,<-0.5847,10.89991,-2.43086>,<-0.585,10.89903,-2.43131>,
            
    /*4*/ <-0.74879,11.05953,-2.55149>

    /* stem 0.35.23*/ 
    /*0*/ <-0.34444,10.81299,-2.11045>,
    /*1*/ <-0.34469,10.81321,-2.11005>,<-0.34463,10.81304,-2.11093>,<-0.34399,10.81273,-2.11037>,
            
    /*2*/ <-0.21684,11.02038,-2.14155>,<-0.2168,11.02026,-2.14214>,<-0.21638,11.02006,-2.14176>,
            
    /*3*/ <-0.15484,11.24634,-2.21469>,<-0.15484,11.24624,-2.21498>,<-0.15459,11.24623,-2.21481>,
            
    /*4*/ <-0.17335,11.45578,-2.34138>

    /* stem 0.36*/ 
    /*0*/ <0.07284,8.9984,-0.0235>,
    /*1*/ <0.04754,8.99848,-0.00225>,<0.05063,9.02042,-0.03414>,<0.08441,9.01193,-0.05132>,
            <0.10219,8.98475,-0.03005>,<0.07941,8.97643,0.00028>,
    /*2*/ <0.31884,9.41943,0.3089>,<0.32131,9.43699,0.28339>,<0.34833,9.4302,0.26964>,
            <0.36256,9.40845,0.28666>,<0.34433,9.4018,0.31092>,
    /*3*/ <0.56047,9.87174,0.59901>,<0.56175,9.88395,0.57922>,<0.5824,9.87956,0.56937>,
            <0.59389,9.86463,0.58308>,<0.58033,9.8598,0.6014>,
    /*4*/ <0.75359,10.3731,0.84129>,<0.75383,10.37988,0.82732>,<0.7679,10.37764,0.82114>,
            <0.77636,10.36948,0.83128>,<0.76752,10.36667,0.84374>,
    /*5*/ <0.848,10.92199,1.0318>,<0.84787,10.9246,1.02448>,<0.85513,10.9244,1.02173>,
            <0.85975,10.92165,1.02735>,<0.85534,10.92017,1.03356>,
    /*6*/ <0.86828,11.50632,1.10884>

    /* stem 0.36.0*/ 
    /*0*/ <0.12452,9.08012,0.03773>,
    /*1*/ <0.1296,9.08791,0.02303>,<0.13485,9.08036,0.05172>,<0.1091,9.07208,0.03843>,
            
    /*2*/ <-0.11956,9.57517,0.20223>,<-0.11606,9.57013,0.22135>,<-0.13322,9.56461,0.21249>,
            
    /*3*/ <-0.13752,10.12699,0.35736>,<-0.13551,10.12447,0.36687>,<-0.14503,10.12504,0.36373>,
            
    /*4*/ <-0.00719,10.64956,0.5613>

    /* stem 0.36.1*/ 
    /*0*/ <0.16034,9.13676,0.08017>,
    /*1*/ <0.16576,9.12501,0.09127>,<0.15173,9.1504,0.08571>,<0.16352,9.13487,0.06352>,
            
    /*2*/ <0.65096,9.41142,0.1486>,<0.6416,9.42835,0.14489>,<0.64946,9.418,0.1301>,
            
    /*3*/ <0.96704,9.88618,0.11868>,<0.95905,9.89143,0.1163>,<0.96454,9.88733,0.10923>,
            
    /*4*/ <1.16568,10.4135,0.17809>

    /* stem 0.36.2*/ 
    /*0*/ <0.2194,9.23014,0.15013>,
    /*1*/ <0.20654,9.24015,0.14761>,<0.2347,9.23541,0.14698>,<0.21695,9.21485,0.15579>,
            
    /*2*/ <0.25333,9.42141,0.66545>,<0.2721,9.41825,0.66503>,<0.26026,9.40454,0.6709>,
            
    /*3*/ <0.29065,9.72071,1.12402>,<0.30008,9.71938,1.12422>,<0.29431,9.71326,1.12868>,
            
    /*4*/ <0.34537,10.14999,1.46304>

    /* stem 0.36.3*/ 
    /*0*/ <0.27394,9.31638,0.21474>,
    /*1*/ <0.28792,9.31252,0.20808>,<0.27295,9.3186,0.23052>,<0.26093,9.31801,0.20562>,
            
    /*2*/ <0.39516,9.8339,0.14399>,<0.38517,9.83796,0.15895>,<0.37716,9.83757,0.14235>,
            
    /*3*/ <0.69161,10.2721,0.21313>,<0.68688,10.27418,0.22076>,<0.68407,10.27737,0.21258>,
            
    /*4*/ <0.9885,10.68907,0.37361>

    /* stem 0.36.4*/ 
    /*0*/ <0.31055,9.37427,0.25811>,
    /*1*/ <0.30176,9.37057,0.27048>,<0.31189,9.38918,0.25367>,<0.318,9.36306,0.25019>,
            
    /*2*/ <0.72318,9.42791,0.58068>,<0.72994,9.44032,0.56947>,<0.73401,9.42291,0.56715>,
            
    /*3*/ <1.12169,9.64235,0.85174>,<1.1234,9.64799,0.84491>,<1.12749,9.63996,0.84526>,
            
    /*4*/ <1.40865,10.01429,1.08945>

    /* stem 0.36.5*/ 
    /*0*/ <0.35223,9.44452,0.30827>,
    /*1*/ <0.3516,9.45304,0.29568>,<0.36408,9.44577,0.31772>,<0.341,9.43475,0.31141>,
            
    /*2*/ <0.10449,9.81842,0.5613>,<0.11281,9.81358,0.57599>,<0.09742,9.80623,0.57178>,
            
    /*3*/ <-0.05233,10.22555,0.83425>,<-0.04791,10.22265,0.84126>,<-0.05627,10.22025,0.84004>,
            
    /*4*/ <0.0295,10.58518,1.19506>

    /* stem 0.36.6*/ 
    /*0*/ <0.41991,9.57392,0.39248>,
    /*1*/ <0.42889,9.5648,0.39928>,<0.41408,9.58507,0.39968>,<0.41675,9.5719,0.37848>,
            
    /*2*/ <0.81058,9.85139,0.26939>,<0.80071,9.86491,0.26966>,<0.8025,9.85612,0.25552>,
            
    /*3*/ <1.14063,10.21963,0.23977>,<1.13446,10.22528,0.2401>,<1.13706,10.22235,0.23271>,
            
    /*4*/ <1.40211,10.63294,0.31542>

    /* stem 0.36.7*/ 
    /*0*/ <0.45046,9.63234,0.4305>,
    /*1*/ <0.43758,9.63807,0.43204>,<0.46131,9.64036,0.42616>,<0.45248,9.61859,0.43329>,
            
    /*2*/ <0.54566,9.74522,0.89311>,<0.56148,9.74675,0.88919>,<0.55559,9.73224,0.89394>,
            
    /*3*/ <0.59657,9.93725,1.33435>,<0.60459,9.93822,1.33308>,<0.60179,9.93129,1.33641>,
            
    /*4*/ <0.73333,10.25318,1.67717>

    /* stem 0.36.8*/ 
    /*0*/ <0.49746,9.72221,0.48898>,
    /*1*/ <0.50802,9.72235,0.48028>,<0.49953,9.7246,0.5023>,<0.48483,9.71969,0.48437>,
            
    /*2*/ <0.43897,10.18356,0.41086>,<0.4333,10.18506,0.42554>,<0.4235,10.18179,0.41358>,
            
    /*3*/ <0.37272,10.65122,0.4167>,<0.36997,10.65081,0.4241>,<0.365,10.65018,0.41799>,
            
    /*4*/ <0.38241,11.11459,0.50297>

    /* stem 0.36.9*/ 
    /*0*/ <0.56053,9.84281,0.56746>,
    /*1*/ <0.55695,9.83734,0.57873>,<0.55875,9.85557,0.56555>,<0.56589,9.83551,0.55809>,
            
    /*2*/ <0.96916,9.92197,0.74548>,<0.97036,9.93412,0.73669>,<0.97512,9.92075,0.73171>,
            
    /*3*/ <1.1907,10.19792,1.02553>,<1.19042,10.20344,1.02042>,<1.19624,10.19867,1.0205>,
            
    /*4*/ <1.37449,10.54395,1.25331>

    /* stem 0.36.10*/ 
    /*0*/ <0.59983,9.9361,0.61796>,
    /*1*/ <0.59478,9.94264,0.6085>,<0.6112,9.93914,0.62234>,<0.59351,9.9265,0.62304>,
            
    /*2*/ <0.41183,10.21503,0.90018>,<0.42278,10.2127,0.90941>,<0.41098,10.20428,0.90988>,
            
    /*3*/ <0.37661,10.56559,1.16201>,<0.38246,10.56346,1.16574>,<0.37585,10.56127,1.16779>,
            
    /*4*/ <0.51543,10.95919,1.29676>

    /* stem 0.36.11*/ 
    /*0*/ <0.65237,10.07617,0.68684>,
    /*1*/ <0.66259,10.07088,0.68981>,<0.64632,10.08239,0.69496>,<0.64821,10.07525,0.67574>,
            
    /*2*/ <0.86991,10.41865,0.58092>,<0.85906,10.42632,0.58435>,<0.86032,10.42156,0.57154>,
            
    /*3*/ <1.04156,10.77662,0.71423>,<1.03535,10.77904,0.71588>,<1.03792,10.78015,0.70961>,
            
    /*4*/ <1.20967,11.13262,0.85838>

    /* stem 0.36.12*/ 
    /*0*/ <0.69165,10.1809,0.73833>,
    /*1*/ <0.68123,10.18274,0.74254>,<0.69779,10.18961,0.73431>,<0.69594,10.17035,0.73814>,
            
    /*2*/ <0.84336,10.24004,1.10865>,<0.8544,10.24462,1.10317>,<0.85316,10.23178,1.10572>,
            
    /*3*/ <1.01185,10.43256,1.42204>,<1.01686,10.43447,1.41824>,<1.01721,10.4288,1.42153>,
            
    /*4*/ <1.11265,10.76648,1.62604>

    /* stem 0.36.13*/ 
    /*0*/ <0.73604,10.29924,0.79652>,
    /*1*/ <0.74191,10.30139,0.78768>,<0.7406,10.29983,0.80632>,<0.72561,10.29651,0.79556>,
            
    /*2*/ <0.63987,10.67452,0.81481>,<0.63899,10.67349,0.82724>,<0.629,10.67127,0.82006>,
            
    /*3*/ <0.53474,11.04717,0.80638>,<0.5342,11.04721,0.8126>,<0.52927,11.04574,0.80904>,
            
    /*4*/ <0.494,11.43054,0.84849>

    /* stem 0.36.14*/ 
    /*0*/ <0.77563,10.4458,0.85865>,
    /*1*/ <0.77685,10.44225,0.8681>,<0.77016,10.45422,0.85705>,<0.77988,10.44093,0.85081>,
            
    /*2*/ <1.08012,10.64781,0.90258>,<1.07567,10.65579,0.89522>,<1.08215,10.64693,0.89105>,
            
    /*3*/ <1.36184,10.87845,0.9554>,<1.35942,10.88232,0.95171>,<1.36313,10.87825,0.94968>,
            
    /*4*/ <1.58566,11.13995,1.08418>

    /* stem 0.36.15*/ 
    /*0*/ <0.79204,10.54665,0.89443>,
    /*1*/ <0.78501,10.54989,0.88853>,<0.80066,10.55118,0.89468>,<0.79046,10.53888,0.90009>,
            
    /*2*/ <0.66833,10.76115,1.14888>,<0.67876,10.76201,1.15298>,<0.67197,10.75382,1.15659>,
            
    /*3*/ <0.53969,10.96468,1.40962>,<0.54484,10.96518,1.41182>,<0.54148,10.96098,1.41345>,
            
    /*4*/ <0.41102,11.21569,1.62451>

    /* stem 0.36.16*/ 
    /*0*/ <0.80733,10.64058,0.92775>,
    /*1*/ <0.81655,10.63908,0.92775>,<0.80337,10.64527,0.93479>,<0.80207,10.63739,0.92072>,
            
    /*2*/ <0.86118,10.93392,0.75843>,<0.85239,10.93804,0.76313>,<0.85153,10.93279,0.75375>,
            
    /*3*/ <1.00486,11.20991,0.61875>,<1.0009,11.213,0.6207>,<1.00043,11.21078,0.61581>,
            
    /*4*/ <1.11958,11.52433,0.54269>

    /* stem 0.36.17*/ 
    /*0*/ <0.82669,10.75957,0.96996>,
    /*1*/ <0.81993,10.75882,0.97517>,<0.82753,10.76649,0.96498>,<0.83263,10.75339,0.96974>,
            
    /*2*/ <0.98858,10.91047,1.21152>,<0.99365,10.91558,1.20473>,<0.99705,10.90685,1.20791>,
            
    /*3*/ <1.18242,11.11191,1.38436>,<1.18429,11.11376,1.38017>,<1.18644,11.10985,1.38233>,
            
    /*4*/ <1.3221,11.38481,1.49985>

    /* stem 0.36.18*/ 
    /*0*/ <0.84335,10.86193,1.00628>,
    /*1*/ <0.84499,10.86409,0.99946>,<0.84737,10.86431,1.01194>,<0.8377,10.85741,1.00744>,
            
    /*2*/ <0.65306,11.11069,1.03392>,<0.65465,11.11084,1.04224>,<0.6482,11.10624,1.03924>,
            
    /*3*/ <0.50693,11.36923,1.13956>,<0.50825,11.36839,1.1435>,<0.50454,11.36686,1.14214>,
            
    /*4*/ <0.39288,11.64162,1.24723>

    /* stem 0.36.19*/ 
    /*0*/ <0.85398,10.95221,1.0319>,
    /*1*/ <0.85692,10.95137,1.03738>,<0.84939,10.95645,1.03142>,<0.85564,10.9488,1.0269>,
            
    /*2*/ <1.05919,11.16287,0.95894>,<1.05417,11.16626,0.95496>,<1.05834,11.16116,0.95195>,
            
    /*3*/ <1.25496,11.39289,0.96239>,<1.25268,11.39489,0.96041>,<1.25515,11.39281,0.95877>,
            
    /*4*/ <1.44123,11.61604,1.04612>

    /* stem 0.36.20*/ 
    /*0*/ <0.85789,11.10363,1.05293>,
    /*1*/ <0.85367,11.10397,1.05124>,<0.86104,11.10674,1.05184>,<0.85896,11.10017,1.0557>,
            
    /*2*/ <0.77819,11.26058,1.27661>,<0.7831,11.26242,1.277>,<0.78172,11.25805,1.27958>,
            
    /*3*/ <0.74449,11.47001,1.46674>,<0.74705,11.47059,1.46657>,<0.74621,11.46884,1.46835>,
            
    /*4*/ <0.75524,11.72501,1.59291>

    /* stem 0.36.21*/ 
    /*0*/ <0.86128,11.23486,1.07115>,
    /*1*/ <0.8642,11.23491,1.0702>,<0.86046,11.23636,1.0737>,<0.85917,11.2333,1.06955>,
            
    /*2*/ <0.81169,11.45441,0.92433>,<0.8092,11.45537,0.92666>,<0.80834,11.45333,0.92389>,
            
    /*3*/ <0.85897,11.68769,0.80107>,<0.85776,11.68848,0.80209>,<0.85728,11.68776,0.80055>,
            
    /*4*/ <0.90772,11.94982,0.76688>

    /* stem 0.36.22*/ 
    /*0*/ <0.86378,11.3321,1.08465>,
    /*1*/ <0.86274,11.3319,1.08631>,<0.86332,11.33352,1.08336>,<0.86529,11.33089,1.08428>,
            
    /*2*/ <1.02251,11.49349,1.20622>,<1.0229,11.49457,1.20426>,<1.02421,11.49281,1.20487>,
            
    /*3*/ <1.19864,11.67458,1.25507>,<1.19864,11.67488,1.25397>,<1.19936,11.67408,1.25433>,
            
    /*4*/ <1.33587,11.89122,1.2375>

    /* stem 0.36.23*/ 
    /*0*/ <0.86611,11.42239,1.09719>,
    /*1*/ <0.86598,11.42252,1.09626>,<0.86681,11.42285,1.09764>,<0.86555,11.42179,1.09767>,
            
    /*2*/ <0.71104,11.60735,1.14465>,<0.71159,11.60758,1.14558>,<0.71075,11.60687,1.14559>,
            
    /*3*/ <0.66757,11.8416,1.20614>,<0.66791,11.84155,1.20656>,<0.66738,11.84144,1.20663>,
            
    /*4*/ <0.68255,12.06688,1.30393>

    /* stem 0.37*/ 
    /*0*/ <0.06757,9.11547,-0.03019>,
    /*1*/ <0.07325,9.11389,-0.06224>,<0.08895,9.13885,-0.03779>,<0.07511,9.1315,-0.00285>,
            <0.05085,9.102,-0.00569>,<0.0497,9.09112,-0.04239>,
    /*2*/ <-0.36735,9.48483,-0.15188>,<-0.35478,9.5048,-0.13233>,<-0.36585,9.49892,-0.10437>,
            <-0.38526,9.47531,-0.10664>,<-0.38619,9.46661,-0.13601>,
    /*3*/ <-0.75337,9.91194,-0.2412>,<-0.74228,9.92532,-0.22616>,<-0.75142,9.92174,-0.20538>,
            <-0.76816,9.90615,-0.20758>,<-0.76937,9.90009,-0.22971>,
    /*4*/ <-1.07398,10.40184,-0.24293>,<-1.06466,10.40809,-0.2325>,<-1.07016,10.40473,-0.21861>,
            <-1.08289,10.39639,-0.22045>,<-1.08525,10.39461,-0.23548>,
    /*5*/ <-1.32979,10.92529,-0.21298>,<-1.32466,10.92756,-0.20777>,<-1.32744,10.92589,-0.20083>,
            <-1.3343,10.92259,-0.20175>,<-1.33575,10.92222,-0.20927>,
    /*6*/ <-1.52519,11.47368,-0.18667>

    /* stem 0.37.0*/ 
    /*0*/ <-0.00027,9.17269,-0.04502>,
    /*1*/ <0.00445,9.18188,-0.03119>,<-0.01645,9.16682,-0.04636>,<0.01117,9.16938,-0.0575>,
            
    /*2*/ <-0.14982,9.66063,-0.30371>,<-0.16375,9.6506,-0.31383>,<-0.14533,9.6523,-0.32125>,
            
    /*3*/ <-0.39867,10.03939,-0.65757>,<-0.40438,10.03218,-0.66141>,<-0.39551,10.0342,-0.66547>,
            
    /*4*/ <-0.72892,10.46513,-0.84573>

    /* stem 0.37.1*/ 
    /*0*/ <-0.08907,9.24758,-0.06443>,
    /*1*/ <-0.09901,9.23473,-0.06851>,<-0.08844,9.26113,-0.07425>,<-0.07976,9.24687,-0.05052>,
            
    /*2*/ <-0.51255,9.46915,0.22361>,<-0.5055,9.48675,0.21978>,<-0.49972,9.47724,0.2356>,
            
    /*3*/ <-0.88065,9.84105,0.42348>,<-0.87505,9.84833,0.42047>,<-0.8739,9.8447,0.42936>,
            
    /*4*/ <-1.22911,10.27356,0.47952>

    /* stem 0.37.2*/ 
    /*0*/ <-0.16653,9.3129,-0.08136>,
    /*1*/ <-0.15616,9.32338,-0.08833>,<-0.17669,9.31803,-0.06969>,<-0.16672,9.29729,-0.08606>,
            
    /*2*/ <-0.53421,9.43855,-0.46451>,<-0.5479,9.43498,-0.45208>,<-0.54125,9.42116,-0.463>,
            
    /*3*/ <-0.86498,9.75905,-0.75237>,<-0.87195,9.75752,-0.74622>,<-0.87093,9.75187,-0.75368>,
            
    /*4*/ <-1.18349,10.18244,-0.88197>

    /* stem 0.37.3*/ 
    /*0*/ <-0.26269,9.394,-0.10238>,
    /*1*/ <-0.26868,9.39057,-0.08821>,<-0.2722,9.39518,-0.11488>,<-0.24718,9.39626,-0.10403>,
            
    /*2*/ <-0.3316,9.90882,0.00498>,<-0.33395,9.91189,-0.0128>,<-0.31727,9.91262,-0.00556>,
            
    /*3*/ <-0.49018,10.41519,0.02201>,<-0.49098,10.41533,0.01295>,<-0.4831,10.41766,0.01685>,
            
    /*4*/ <-0.74312,10.87925,-0.02289>

    /* stem 0.37.4*/ 
    /*0*/ <-0.33397,9.45412,-0.11796>,
    /*1*/ <-0.33479,9.44938,-0.13254>,<-0.33556,9.46902,-0.11463>,<-0.33156,9.44396,-0.1067>,
            
    /*2*/ <-0.84681,9.38503,-0.07763>,<-0.84733,9.39813,-0.0657>,<-0.84466,9.38142,-0.06041>,
            
    /*3*/ <-1.35816,9.46875,-0.03959>,<-1.35674,9.47526,-0.03376>,<-1.35789,9.46694,-0.03092>,
            
    /*4*/ <-1.75001,9.80983,-0.02853>

    /* stem 0.37.5*/ 
    /*0*/ <-0.39974,9.51699,-0.13317>,
    /*1*/ <-0.39166,9.5262,-0.12459>,<-0.41439,9.51531,-0.13062>,<-0.39318,9.50945,-0.14431>,
            
    /*2*/ <-0.49379,9.90648,-0.44535>,<-0.50894,9.89922,-0.44937>,<-0.4948,9.89532,-0.4585>,
            
    /*3*/ <-0.68294,10.33657,-0.6351>,<-0.69044,10.33262,-0.63677>,<-0.68419,10.33273,-0.64274>,
            
    /*4*/ <-0.9031,10.77079,-0.77928>

    /* stem 0.37.6*/ 
    /*0*/ <-0.50133,9.62963,-0.15844>,
    /*1*/ <-0.51205,9.62021,-0.15735>,<-0.50081,9.63862,-0.16957>,<-0.49114,9.63007,-0.1484>,
            
    /*2*/ <-0.77063,9.95086,0.09433>,<-0.76313,9.96313,0.08618>,<-0.75668,9.95743,0.10029>,
            
    /*3*/ <-0.93059,10.41122,0.16719>,<-0.92482,10.4141,0.16202>,<-0.92317,10.4134,0.17009>,
            
    /*4*/ <-0.96352,10.88688,0.0504>

    /* stem 0.37.7*/ 
    /*0*/ <-0.57923,9.71601,-0.17781>,
    /*1*/ <-0.57084,9.72143,-0.18735>,<-0.58456,9.72405,-0.16792>,<-0.58229,9.70254,-0.17816>,
            
    /*2*/ <-0.94852,9.81195,-0.46128>,<-0.95767,9.81369,-0.44833>,<-0.95615,9.79935,-0.45515>,
            
    /*3*/ <-1.24837,10.08574,-0.70459>,<-1.25289,10.08669,-0.69808>,<-1.25433,10.08065,-0.70309>,
            
    /*4*/ <-1.57299,10.38256,-0.88579>

    /* stem 0.37.8*/ 
    /*0*/ <-0.62316,9.76473,-0.18874>,
    /*1*/ <-0.62562,9.76549,-0.17545>,<-0.63342,9.76529,-0.19756>,<-0.61045,9.76339,-0.19321>,
            
    /*2*/ <-0.58271,10.23021,-0.19889>,<-0.5879,10.23008,-0.21364>,<-0.5726,10.22881,-0.21073>,
            
    /*3*/ <-0.66102,10.68977,-0.19061>,<-0.66371,10.68951,-0.19794>,<-0.65611,10.69078,-0.19661>,
            
    /*4*/ <-0.73591,11.14224,-0.28511>

    /* stem 0.37.9*/ 
    /*0*/ <-0.71351,9.86492,-0.21121>,
    /*1*/ <-0.71778,9.8587,-0.22176>,<-0.70975,9.8773,-0.21206>,<-0.713,9.85875,-0.19981>,
            
    /*2*/ <-1.13705,9.99475,-0.12693>,<-1.13169,10.00715,-0.12046>,<-1.13386,9.99479,-0.1123>,
            
    /*3*/ <-1.38389,10.36586,-0.04069>,<-1.3778,10.36937,-0.0381>,<-1.38212,10.36542,-0.03343>,
            
    /*4*/ <-1.5474,10.78597,-0.03138>

    /* stem 0.37.10*/ 
    /*0*/ <-0.78632,9.95811,-0.22274>,
    /*1*/ <-0.77635,9.96468,-0.21912>,<-0.79751,9.9605,-0.21777>,<-0.78511,9.94916,-0.23134>,
            
    /*2*/ <-0.85738,10.25447,-0.53536>,<-0.87148,10.25168,-0.53446>,<-0.86321,10.24412,-0.54351>,
            
    /*3*/ <-0.81744,10.60473,-0.78801>,<-0.82459,10.60503,-0.78881>,<-0.8206,10.60123,-0.79346>,
            
    /*4*/ <-0.83611,11.00129,-0.96953>

    /* stem 0.37.11*/ 
    /*0*/ <-0.89185,10.11984,-0.22539>,
    /*1*/ <-0.90088,10.11402,-0.22081>,<-0.89351,10.12699,-0.23448>,<-0.88115,10.11851,-0.22088>,
            
    /*2*/ <-0.9683,10.42979,0.03726>,<-0.96339,10.43844,0.02814>,<-0.95515,10.43279,0.03721>,
            
    /*3*/ <-1.0487,10.793,0.21933>,<-1.04594,10.79629,0.21412>,<-1.04212,10.79449,0.21938>,
            
    /*4*/ <-1.0509,11.17445,0.38048>

    /* stem 0.37.12*/ 
    /*0*/ <-0.96511,10.23212,-0.22723>,
    /*1*/ <-0.96082,10.23476,-0.23716>,<-0.96574,10.23983,-0.21921>,<-0.96878,10.22178,-0.22532>,
            
    /*2*/ <-1.3234,10.33818,-0.36227>,<-1.32668,10.34155,-0.3503>,<-1.32871,10.32952,-0.35437>,
            
    /*3*/ <-1.63355,10.57539,-0.4349>,<-1.63417,10.57659,-0.42862>,<-1.63733,10.57165,-0.43128>,
            
    /*4*/ <-1.86027,10.88678,-0.52942>

    /* stem 0.37.13*/ 
    /*0*/ <-1.03601,10.34078,-0.22901>,
    /*1*/ <-1.03407,10.34221,-0.21866>,<-1.04595,10.3414,-0.23268>,<-1.028,10.33872,-0.23567>,
            
    /*2*/ <-0.98881,10.71578,-0.2826>,<-0.99674,10.71524,-0.29195>,<-0.98477,10.71345,-0.29394>,
            
    /*3*/ <-1.0256,11.08815,-0.36057>,<-1.02954,11.08686,-0.3651>,<-1.02353,11.08721,-0.36626>,
            
    /*4*/ <-1.0991,11.4548,-0.43734>

    /* stem 0.37.14*/ 
    /*0*/ <-1.08893,10.42895,-0.22875>,
    /*1*/ <-1.09638,10.4256,-0.23488>,<-1.08453,10.43798,-0.23053>,<-1.0859,10.42326,-0.22083>,
            
    /*2*/ <-1.34506,10.59148,-0.018>,<-1.33717,10.59974,-0.0151>,<-1.33808,10.58993,-0.00864>,
            
    /*3*/ <-1.54091,10.79053,0.22554>,<-1.53632,10.79414,0.22635>,<-1.53694,10.78937,0.22975>,
            
    /*4*/ <-1.61023,11.13973,0.32626>

    /* stem 0.37.15*/ 
    /*0*/ <-1.1524,10.55926,-0.22291>,
    /*1*/ <-1.14376,10.56349,-0.22342>,<-1.15868,10.56194,-0.21612>,<-1.15475,10.55234,-0.22918>,
            
    /*2*/ <-1.27841,10.80479,-0.44133>,<-1.28836,10.80376,-0.43646>,<-1.28574,10.79736,-0.44517>,
            
    /*3*/ <-1.43035,11.09143,-0.57769>,<-1.43502,11.09035,-0.57487>,<-1.43432,11.08829,-0.57999>,
            
    /*4*/ <-1.64047,11.37324,-0.6034>

    /* stem 0.37.16*/ 
    /*0*/ <-1.20747,10.67232,-0.21784>,
    /*1*/ <-1.21336,10.66917,-0.2116>,<-1.2103,10.67819,-0.22425>,<-1.19874,10.6696,-0.21766>,
            
    /*2*/ <-1.13512,10.92827,-0.01113>,<-1.13308,10.93428,-0.01956>,<-1.12537,10.92855,-0.01517>,
            
    /*3*/ <-1.11938,11.23067,0.13677>,<-1.11846,11.23295,0.1321>,<-1.11443,11.23128,0.13507>,
            
    /*4*/ <-1.18522,11.55702,0.18905>

    /* stem 0.37.17*/ 
    /*0*/ <-1.26366,10.78771,-0.21266>,
    /*1*/ <-1.26291,10.78844,-0.22082>,<-1.26156,10.79397,-0.20776>,<-1.26652,10.78072,-0.20941>,
            
    /*2*/ <-1.56299,10.9026,-0.23545>,<-1.56209,10.90628,-0.22675>,<-1.5654,10.89745,-0.22784>,
            
    /*3*/ <-1.85438,11.03842,-0.21998>,<-1.85343,11.04004,-0.21562>,<-1.85545,11.03578,-0.21618>,
            
    /*4*/ <-2.12359,11.20048,-0.15048>

    /* stem 0.37.18*/ 
    /*0*/ <-1.29714,10.85644,-0.20958>,
    /*1*/ <-1.29342,10.85797,-0.20341>,<-1.30445,10.85732,-0.20979>,<-1.29355,10.85402,-0.21554>,
            
    /*2*/ <-1.25626,11.15191,-0.30189>,<-1.26362,11.15147,-0.30615>,<-1.25635,11.14927,-0.30998>,
            
    /*3*/ <-1.34644,11.45049,-0.30162>,<-1.35007,11.44943,-0.30358>,<-1.34663,11.45047,-0.30586>,
            
    /*4*/ <-1.5055,11.6939,-0.18901>

    /* stem 0.37.19*/ 
    /*0*/ <-1.34986,10.97959,-0.20454>,
    /*1*/ <-1.35518,10.97776,-0.20621>,<-1.34746,10.98432,-0.20704>,<-1.34695,10.97669,-0.20035>,
            
    /*2*/ <-1.4777,11.15077,0.0005>,<-1.47255,11.15514,-0.00005>,<-1.47221,11.15005,0.00441>,
            
    /*3*/ <-1.58521,11.39018,0.138>,<-1.58235,11.39187,0.13733>,<-1.58264,11.3901,0.1402>,
            
    /*4*/ <-1.61933,11.65727,0.26232>

    /* stem 0.37.20*/ 
    /*0*/ <-1.38222,11.07078,-0.20124>,
    /*1*/ <-1.3781,11.07231,-0.20313>,<-1.3841,11.07303,-0.19746>,<-1.38446,11.06699,-0.20312>,
            
    /*2*/ <-1.5238,11.24392,-0.37705>,<-1.5278,11.24441,-0.37326>,<-1.52804,11.24038,-0.37704>,
            
    /*3*/ <-1.61391,11.50964,-0.42213>,<-1.61564,11.50943,-0.41998>,<-1.61648,11.50871,-0.42251>,
            
    /*4*/ <-1.67986,11.78594,-0.40706>

    /* stem 0.37.21*/ 
    /*0*/ <-1.41838,11.17268,-0.19755>,
    /*1*/ <-1.41985,11.17205,-0.19436>,<-1.42024,11.17442,-0.20006>,<-1.41505,11.17159,-0.19823>,
            
    /*2*/ <-1.32279,11.40878,-0.10356>,<-1.32305,11.41036,-0.10736>,<-1.31959,11.40847,-0.10614>,
            
    /*3*/ <-1.32333,11.6792,-0.1341>,<-1.32358,11.67897,-0.13614>,<-1.32168,11.67907,-0.13534>,
            
    /*4*/ <-1.39761,11.92911,-0.21003>

    /* stem 0.37.22*/ 
    /*0*/ <-1.47193,11.32359,-0.19209>,
    /*1*/ <-1.47234,11.32351,-0.19383>,<-1.47112,11.32504,-0.19144>,<-1.47233,11.32223,-0.19102>,
            
    /*2*/ <-1.69681,11.42789,-0.14531>,<-1.696,11.4289,-0.14372>,<-1.69681,11.42703,-0.14344>,
            
    /*3*/ <-1.88384,11.59479,-0.11744>,<-1.88333,11.59523,-0.11666>,<-1.88399,11.59446,-0.11647>,
            
    /*4*/ <-1.99779,11.81734,-0.15018>

    /* stem 0.37.23*/ 
    /*0*/ <-1.51295,11.4392,-0.18791>,
    /*1*/ <-1.51264,11.4393,-0.18767>,<-1.51333,11.43932,-0.18782>,<-1.51288,11.43898,-0.18825>,
            
    /*2*/ <-1.47973,11.63829,-0.31314>,<-1.48019,11.6383,-0.31324>,<-1.4799,11.63807,-0.31353>,
            
    /*3*/ <-1.47973,11.85965,-0.39927>,<-1.47996,11.85963,-0.39931>,<-1.47981,11.85957,-0.39948>,
            
    /*4*/ <-1.52262,12.0895,-0.44114>

    /* stem 0.38*/ 
    /*0*/ <0.05754,9.33867,-0.04296>,
    /*1*/ <0.07337,9.34095,-0.01556>,<0.04301,9.36043,-0.02502>,<0.03273,9.34984,-0.05927>,
            <0.05674,9.32381,-0.07098>,<0.08185,9.31831,-0.04396>,
    /*2*/ <0.40102,9.74664,-0.24592>,<0.37673,9.76223,-0.25349>,<0.3685,9.75376,-0.28089>,
            <0.38771,9.73293,-0.29026>,<0.4078,9.72853,-0.26864>,
    /*3*/ <0.66846,10.20821,-0.4471>,<0.64877,10.21778,-0.45175>,<0.64315,10.2122,-0.47268>,
            <0.65936,10.1992,-0.48097>,<0.67501,10.19673,-0.46516>,
    /*4*/ <0.84769,10.72828,-0.59616>,<0.83359,10.73257,-0.59853>,<0.83027,10.72979,-0.6128>,
            <0.84231,10.72379,-0.61926>,<0.85307,10.72286,-0.60897>,
    /*5*/ <0.95899,11.25255,-0.79546>,<0.95169,11.25378,-0.79642>,<0.94988,11.25162,-0.80333>,
            <0.95606,11.24905,-0.80663>,<0.96168,11.24963,-0.80177>,
    /*6*/ <0.98015,11.80616,-0.92928>

    /* stem 0.38.0*/ 
    /*0*/ <0.11019,9.40331,-0.07875>,
    /*1*/ <0.09683,9.40992,-0.08648>,<0.12474,9.40175,-0.087>,<0.10902,9.39827,-0.06278>,
            
    /*2*/ <0.25382,9.91737,0.08833>,<0.27243,9.91192,0.08798>,<0.26195,9.9096,0.10413>,
            
    /*3*/ <0.49126,10.42333,0.09542>,<0.50007,10.41929,0.09497>,<0.49599,10.42109,0.10359>,
            
    /*4*/ <0.7961,10.88718,0.17125>

    /* stem 0.38.1*/ 
    /*0*/ <0.16746,9.47362,-0.11768>,
    /*1*/ <0.17925,9.46257,-0.12028>,<0.17136,9.48882,-0.11302>,<0.15176,9.46947,-0.11974>,
            
    /*2*/ <0.2035,9.61994,-0.64397>,<0.19824,9.63744,-0.63913>,<0.18517,9.62454,-0.64361>,
            
    /*3*/ <0.23794,10.01292,-1.02838>,<0.23475,10.01933,-1.02221>,<0.22866,10.01457,-1.02764>,
            
    /*4*/ <0.25808,10.5073,-1.26528>

    /* stem 0.38.2*/ 
    /*0*/ <0.24448,9.56818,-0.17004>,
    /*1*/ <0.23961,9.57829,-0.15892>,<0.24604,9.57302,-0.18499>,<0.24778,9.55321,-0.1662>,
            
    /*2*/ <0.74568,9.71105,-0.06573>,<0.74997,9.70754,-0.08311>,<0.75112,9.69433,-0.07058>,
            
    /*3*/ <1.25803,9.85207,-0.11043>,<1.25801,9.84964,-0.11922>,<1.26025,9.84355,-0.11281>,
            
    /*4*/ <1.73881,10.07337,-0.15082>

    /* stem 0.38.3*/ 
    /*0*/ <0.28604,9.6192,-0.19829>,
    /*1*/ <0.28218,9.61446,-0.21252>,<0.30084,9.62223,-0.19487>,<0.27508,9.62091,-0.18746>,
            
    /*2*/ <0.21567,10.11307,-0.35507>,<0.22811,10.11825,-0.3433>,<0.21093,10.11737,-0.33836>,
            
    /*3*/ <0.27358,10.581,-0.57857>,<0.27988,10.58316,-0.5726>,<0.2713,10.58502,-0.57091>,
            
    /*4*/ <0.27649,11.06487,-0.77697>

    /* stem 0.38.4*/ 
    /*0*/ <0.35168,9.69979,-0.24291>,
    /*1*/ <0.36202,9.69722,-0.23234>,<0.34798,9.71388,-0.24652>,<0.34503,9.68827,-0.24987>,
            
    /*2*/ <0.72312,9.70261,-0.5914>,<0.71376,9.71372,-0.60086>,<0.7118,9.69664,-0.60309>,
            
    /*3*/ <1.14719,9.91612,-0.76803>,<1.14251,9.92165,-0.77279>,<1.14494,9.91403,-0.77614>,
            
    /*4*/ <1.54196,10.19711,-0.92507>

    /* stem 0.38.5*/ 
    /*0*/ <0.4132,9.78724,-0.28581>,
    /*1*/ <0.40046,9.79402,-0.28742>,<0.42299,9.78754,-0.29652>,<0.41614,9.78015,-0.27348>,
            
    /*2*/ <0.60043,10.20489,-0.09608>,<0.61545,10.20057,-0.10215>,<0.61088,10.19564,-0.08679>,
            
    /*3*/ <0.80144,10.6515,-0.16456>,<0.80827,10.64799,-0.16791>,<0.80791,10.64941,-0.15966>,
            
    /*4*/ <0.98522,11.11024,-0.19679>

    /* stem 0.38.6*/ 
    /*0*/ <0.46551,9.87655,-0.32364>,
    /*1*/ <0.47432,9.86833,-0.33087>,<0.47025,9.88831,-0.31757>,<0.45195,9.87301,-0.32247>,
            
    /*2*/ <0.3723,10.11833,-0.73035>,<0.36958,10.13165,-0.72148>,<0.35738,10.12145,-0.72475>,
            
    /*3*/ <0.47069,10.46694,-1.04783>,<0.46926,10.47259,-1.04217>,<0.46321,10.46997,-1.04691>,
            
    /*4*/ <0.61541,10.85725,-1.29173>

    /* stem 0.38.7*/ 
    /*0*/ <0.52757,9.98252,-0.36852>,
    /*1*/ <0.52645,9.98832,-0.35637>,<0.52528,9.98975,-0.3797>,<0.53098,9.96948,-0.36949>,
            
    /*2*/ <0.97757,10.10545,-0.37567>,<0.9768,10.1064,-0.39122>,<0.9806,10.09289,-0.38441>,
            
    /*3*/ <1.33622,10.39876,-0.4183>,<1.33518,10.39901,-0.42603>,<1.33992,10.39367,-0.42291>,
            
    /*4*/ <1.49566,10.80409,-0.58625>

    /* stem 0.38.8*/ 
    /*0*/ <0.57816,10.06889,-0.40511>,
    /*1*/ <0.57163,10.06794,-0.41639>,<0.59058,10.07296,-0.40507>,<0.57227,10.06578,-0.39387>,
            
    /*2*/ <0.4332,10.49721,-0.36751>,<0.44583,10.50056,-0.35997>,<0.43362,10.49577,-0.3525>,
            
    /*3*/ <0.3777,10.94757,-0.35829>,<0.38421,10.94836,-0.35456>,<0.37776,10.94749,-0.35075>,
            
    /*4*/ <0.37698,11.37073,-0.51867>

    /* stem 0.38.9*/ 
    /*0*/ <0.62905,10.15577,-0.44191>,
    /*1*/ <0.63976,10.15176,-0.43656>,<0.62535,10.16774,-0.44041>,<0.62203,10.1478,-0.44874>,
            
    /*2*/ <0.8597,10.26734,-0.8007>,<0.85009,10.278,-0.80326>,<0.84789,10.2647,-0.80881>,
            
    /*3*/ <1.06039,10.48826,-1.12597>,<1.0549,10.49305,-1.12619>,<1.05469,10.48709,-1.13037>,
            
    /*4*/ <1.2514,10.804,-1.36721>

    /* stem 0.38.10*/ 
    /*0*/ <0.68377,10.27766,-0.48307>,
    /*1*/ <0.67316,10.28229,-0.47975>,<0.68802,10.27967,-0.49416>,<0.69013,10.271,-0.4753>,
            
    /*2*/ <0.87271,10.63015,-0.34222>,<0.88262,10.6284,-0.35183>,<0.88403,10.62262,-0.33926>,
            
    /*3*/ <0.97478,11.04003,-0.33143>,<0.97957,11.03903,-0.33637>,<0.98131,11.03842,-0.32967>,
            
    /*4*/ <0.98242,11.45663,-0.40614>

    /* stem 0.38.11*/ 
    /*0*/ <0.73346,10.41946,-0.52219>,
    /*1*/ <0.7386,10.41512,-0.5314>,<0.73907,10.42675,-0.51543>,<0.72271,10.41652,-0.51973>,
            
    /*2*/ <0.60107,10.72716,-0.75051>,<0.60138,10.73491,-0.73986>,<0.59048,10.72809,-0.74273>,
            
    /*3*/ <0.54645,11.08907,-0.92539>,<0.54683,11.09203,-0.91951>,<0.54099,11.09003,-0.92182>,
            
    /*4*/ <0.57394,11.48167,-1.02378>

    /* stem 0.38.12*/ 
    /*0*/ <0.76318,10.50428,-0.54558>,
    /*1*/ <0.76528,10.50647,-0.53497>,<0.75692,10.51117,-0.55151>,<0.76734,10.49519,-0.55027>,
            
    /*2*/ <1.08644,10.70739,-0.64392>,<1.08086,10.71052,-0.65494>,<1.08781,10.69987,-0.65412>,
            
    /*3*/ <1.21774,11.03056,-0.83094>,<1.21315,11.02994,-0.83533>,<1.21881,11.02713,-0.83621>,
            
    /*4*/ <1.25831,11.38944,-0.98862>

    /* stem 0.38.13*/ 
    /*0*/ <0.81695,10.65772,-0.58791>,
    /*1*/ <0.80925,10.65851,-0.5948>,<0.82636,10.66141,-0.59019>,<0.81523,10.65323,-0.57872>,
            
    /*2*/ <0.71673,10.98993,-0.4482>,<0.72813,10.99186,-0.44513>,<0.72071,10.98641,-0.43748>,
            
    /*3*/ <0.5884,11.33176,-0.37385>,<0.59388,11.3335,-0.37219>,<0.59011,11.33121,-0.36814>,
            
    /*4*/ <0.50617,11.69203,-0.31475>

    /* stem 0.38.14*/ 
    /*0*/ <0.85759,10.80176,-0.6346>,
    /*1*/ <0.86713,10.79979,-0.6343>,<0.85437,10.81061,-0.63213>,<0.85129,10.79488,-0.63737>,
            
    /*2*/ <0.89661,10.90649,-0.97175>,<0.8881,10.9137,-0.97031>,<0.88605,10.90321,-0.97381>,
            
    /*3*/ <0.85555,11.12711,-1.24914>,<0.85128,11.12966,-1.24653>,<0.8503,11.12526,-1.24989>,
            
    /*4*/ <0.81134,11.43075,-1.42847>

    /* stem 0.38.15*/ 
    /*0*/ <0.8726,10.87057,-0.66003>,
    /*1*/ <0.86576,10.87408,-0.65454>,<0.87403,10.87411,-0.66866>,<0.87802,10.8635,-0.65687>,
            
    /*2*/ <1.09129,11.10262,-0.52517>,<1.0968,11.10264,-0.53458>,<1.09946,11.09557,-0.52672>,
            
    /*3*/ <1.27304,11.39658,-0.55406>,<1.27469,11.39512,-0.55905>,<1.27764,11.39373,-0.55468>,
            
    /*4*/ <1.28174,11.73702,-0.60978>

    /* stem 0.38.16*/ 
    /*0*/ <0.89456,10.97122,-0.69722>,
    /*1*/ <0.89574,10.9679,-0.70552>,<0.90071,10.97678,-0.69367>,<0.88723,10.96898,-0.69246>,
            
    /*2*/ <0.73277,11.23009,-0.83041>,<0.73608,11.23601,-0.82252>,<0.7271,11.23081,-0.82171>,
            
    /*3*/ <0.63051,11.5299,-0.93462>,<0.63249,11.53211,-0.93034>,<0.62756,11.53042,-0.93036>,
            
    /*4*/ <0.54716,11.80224,-1.10592>

    /* stem 0.38.17*/ 
    /*0*/ <0.91706,11.07435,-0.73533>,
    /*1*/ <0.9215,11.07598,-0.72828>,<0.91176,11.0802,-0.73845>,<0.91791,11.06687,-0.73924>,
            
    /*2*/ <1.15708,11.19543,-0.90814>,<1.15058,11.19824,-0.91492>,<1.15469,11.18936,-0.91545>,
            
    /*3*/ <1.34837,11.4047,-1.05471>,<1.34477,11.40586,-1.05783>,<1.34789,11.40225,-1.05892>,
            
    /*4*/ <1.48354,11.62172,-1.24737>

    /* stem 0.38.18*/ 
    /*0*/ <0.94508,11.2028,-0.78279>,
    /*1*/ <0.93861,11.20332,-0.78522>,<0.95035,11.20557,-0.78635>,<0.94628,11.19953,-0.7768>,
            
    /*2*/ <0.90515,11.4639,-0.63472>,<0.91298,11.4654,-0.63547>,<0.91027,11.46137,-0.6291>,
            
    /*3*/ <0.9488,11.75743,-0.57176>,<0.95271,11.75704,-0.57251>,<0.95132,11.75645,-0.56881>,
            
    /*4*/ <1.0235,12.04691,-0.52266>

    /* stem 0.38.19*/ 
    /*0*/ <0.95796,11.30329,-0.81276>,
    /*1*/ <0.9633,11.30259,-0.81477>,<0.95657,11.30806,-0.80987>,<0.95399,11.29922,-0.81366>,
            
    /*2*/ <0.88521,11.43157,-1.06253>,<0.88073,11.43522,-1.05926>,<0.87901,11.42932,-1.06179>,
            
    /*3*/ <0.8888,11.64655,-1.25625>,<0.8866,11.64826,-1.25443>,<0.88554,11.64616,-1.25678>,
            
    /*4*/ <0.93599,11.8895,-1.40715>

    /* stem 0.38.20*/ 
    /*0*/ <0.96205,11.39601,-0.83425>,
    /*1*/ <0.95982,11.39704,-0.83025>,<0.96047,11.39772,-0.83832>,<0.96586,11.39328,-0.83417>,
            
    /*2*/ <1.1213,11.62196,-0.79947>,<1.12174,11.62242,-0.80485>,<1.12533,11.61946,-0.80209>,
            
    /*3*/ <1.24598,11.87108,-0.80855>,<1.24601,11.87098,-0.81126>,<1.2481,11.86998,-0.80984>,
            
    /*4*/ <1.26194,12.14871,-0.81871>

    /* stem 0.38.21*/ 
    /*0*/ <0.96835,11.53881,-0.86733>,
    /*1*/ <0.96774,11.53816,-0.87026>,<0.97029,11.54107,-0.86664>,<0.96702,11.5372,-0.8651>,
            
    /*2*/ <0.7695,11.70785,-0.86554>,<0.77121,11.70979,-0.86313>,<0.76902,11.70721,-0.8621>,
            
    /*3*/ <0.64739,11.92602,-0.78813>,<0.6487,11.92636,-0.78701>,<0.64732,11.9254,-0.78648>,
            
    /*4*/ <0.58222,12.14863,-0.66797>

    /* stem 0.38.22*/ 
    /*0*/ <0.97353,11.65602,-0.89449>,
    /*1*/ <0.97487,11.65621,-0.89344>,<0.97233,11.65725,-0.89458>,<0.97338,11.65461,-0.89546>,
            
    /*2*/ <1.1008,11.76671,-1.0743>,<1.0991,11.7674,-1.07506>,<1.09981,11.76564,-1.07565>,
            
    /*3*/ <1.19865,11.97735,-1.15627>,<1.19776,11.97764,-1.15659>,<1.19836,11.97713,-1.15719>,
            
    /*4*/ <1.26204,12.21274,-1.19293>

    /* stem 0.38.23*/ 
    /*0*/ <0.97746,11.74509,-0.91513>,
    /*1*/ <0.97676,11.74512,-0.91512>,<0.97782,11.74548,-0.91558>,<0.9778,11.74467,-0.91468>,
            
    /*2*/ <0.98797,11.92034,-0.75809>,<0.98868,11.92058,-0.7584>,<0.98866,11.92004,-0.7578>,
            
    /*3*/ <1.01875,12.08605,-0.59347>,<1.0191,12.08615,-0.59364>,<1.01909,12.08586,-0.59335>,
            
    /*4*/ <1.02173,12.25117,-0.42554>

    /* stem 0.39*/ 
    /*0*/ <0.05128,9.47789,-0.05092>,
    /*1*/ <0.022,9.47596,-0.06152>,<0.04868,9.49685,-0.07555>,<0.07895,9.49153,-0.05555>,
            <0.07098,9.46736,-0.02915>,<0.03579,9.45774,-0.03284>,
    /*2*/ <-0.12293,9.8976,0.28082>,<-0.10159,9.91431,0.26959>,<-0.07738,9.91005,0.28559>,
            <-0.08375,9.89071,0.30671>,<-0.11191,9.88302,0.30376>,
    /*3*/ <-0.25197,10.36955,0.55717>,<-0.23532,10.38004,0.54733>,<-0.21745,10.37779,0.55997>,
            <-0.22306,10.36592,0.57763>,<-0.2444,10.36083,0.5759>,
    /*4*/ <-0.38576,10.84157,0.83118>,<-0.37468,10.84861,0.82464>,<-0.3628,10.84724,0.83313>,
            <-0.36653,10.83934,0.84492>,<-0.38073,10.83583,0.84371>,
    /*5*/ <-0.53214,11.30966,1.10528>,<-0.52665,11.31332,1.10208>,<-0.52073,11.31274,1.10638>,
            <-0.52257,11.30873,1.11224>,<-0.52962,11.30683,1.11156>,
    /*6*/ <-0.62673,11.78102,1.39775>

    /* stem 0.39.0*/ 
    /*0*/ <0.01911,9.56777,0.02167>,
    /*1*/ <0.03317,9.57548,0.01835>,<0.01315,9.5678,0.03693>,<0.011,9.56002,0.00973>,
            
    /*2*/ <-0.2492,10.03213,-0.08998>,<-0.26255,10.02701,-0.0776>,<-0.26398,10.02182,-0.09573>,
            
    /*3*/ <-0.48619,10.52463,-0.06469>,<-0.49246,10.52139,-0.05839>,<-0.49438,10.52094,-0.06764>,
            
    /*4*/ <-0.72836,11.00894,0.01912>

    /* stem 0.39.1*/ 
    /*0*/ <0.00393,9.61016,0.0559>,
    /*1*/ <-0.00215,9.59951,0.06639>,<-0.00386,9.62399,0.05301>,<0.01781,9.60697,0.0483>,
            
    /*2*/ <0.27404,9.84127,0.46373>,<0.2729,9.85759,0.45481>,<0.28735,9.84625,0.45167>,
            
    /*3*/ <0.5258,10.24727,0.7253>,<0.52362,10.25315,0.71841>,<0.53162,10.24839,0.71811>,
            
    /*4*/ <0.70405,10.64996,1.03834>

    /* stem 0.39.2*/ 
    /*0*/ <-0.0247,9.69015,0.1205>,
    /*1*/ <-0.02911,9.69861,0.10806>,<-0.01723,9.69705,0.13244>,<-0.02776,9.67478,0.12101>,
            
    /*2*/ <-0.49122,9.79577,0.34454>,<-0.48331,9.79473,0.36079>,<-0.49033,9.77988,0.35317>,
            
    /*3*/ <-0.94124,9.98961,0.5371>,<-0.93789,9.98924,0.54551>,<-0.94239,9.98216,0.54212>,
            
    /*4*/ <-1.33498,10.26318,0.75838>

    /* stem 0.39.3*/ 
    /*0*/ <-0.05346,9.77048,0.18538>,
    /*1*/ <-0.04116,9.76793,0.19399>,<-0.06655,9.77474,0.19188>,<-0.05266,9.76877,0.17028>,
            
    /*2*/ <0.09145,10.26315,0.14235>,<0.07452,10.26769,0.14095>,<0.08378,10.26371,0.12655>,
            
    /*3*/ <0.22199,10.74479,0.2627>,<0.21357,10.74727,0.26221>,<0.2187,10.74766,0.25508>,
            
    /*4*/ <0.30477,11.22099,0.44134>

    /* stem 0.39.4*/ 
    /*0*/ <-0.08253,9.85171,0.25098>,
    /*1*/ <-0.09665,9.84752,0.24991>,<-0.07907,9.86606,0.25104>,<-0.07188,9.84154,0.252>,
            
    /*2*/ <-0.13242,9.85661,0.7508>,<-0.1207,9.86897,0.75156>,<-0.11591,9.85262,0.7522>,
            
    /*3*/ <-0.2296,10.16612,1.13469>,<-0.22321,10.17123,1.13229>,<-0.22176,10.16487,1.13778>,
            
    /*4*/ <-0.182,10.55393,1.45272>

    /* stem 0.39.5*/ 
    /*0*/ <-0.12333,9.98239,0.33771>,
    /*1*/ <-0.11362,9.98945,0.33034>,<-0.12393,9.98379,0.3517>,<-0.13243,9.97394,0.33108>,
            
    /*2*/ <-0.42355,10.35651,0.28279>,<-0.43042,10.35274,0.29703>,<-0.43608,10.34617,0.28328>,
            
    /*3*/ <-0.67659,10.73882,0.43761>,<-0.67855,10.73485,0.44442>,<-0.68335,10.73432,0.43789>,
            
    /*4*/ <-0.96177,11.10215,0.57882>

    /* stem 0.39.6*/ 
    /*0*/ <-0.15713,10.10056,0.40643>,
    /*1*/ <-0.15832,10.09355,0.41789>,<-0.167,10.10889,0.40256>,<-0.14606,10.09923,0.39883>,
            
    /*2*/ <0.04423,10.44426,0.64809>,<0.03844,10.45449,0.63787>,<0.05241,10.44805,0.63539>,
            
    /*3*/ <0.07797,10.78096,0.96555>,<0.07498,10.7861,0.96051>,<0.08269,10.78501,0.96085>,
            
    /*4*/ <0.02973,11.13383,1.26603>

    /* stem 0.39.7*/ 
    /*0*/ <-0.1824,10.18891,0.45781>,
    /*1*/ <-0.18963,10.19275,0.44764>,<-0.17299,10.19668,0.46243>,<-0.18459,10.17729,0.46334>,
            
    /*2*/ <-0.48452,10.38267,0.73465>,<-0.47343,10.38529,0.74451>,<-0.48116,10.37237,0.74512>,
            
    /*3*/ <-0.72178,10.69843,0.95468>,<-0.716,10.69958,0.95938>,<-0.72126,10.69446,0.96107>,
            
    /*4*/ <-0.72187,11.0638,1.22521>

    /* stem 0.39.8*/ 
    /*0*/ <-0.20964,10.28415,0.51319>,
    /*1*/ <-0.19786,10.285,0.51751>,<-0.21935,10.28636,0.52089>,<-0.21173,10.28108,0.50117>,
            
    /*2*/ <-0.19231,10.71014,0.40583>,<-0.20663,10.71104,0.40808>,<-0.20155,10.70752,0.39493>,
            
    /*3*/ <-0.11967,11.12644,0.28901>,<-0.1267,11.128,0.28995>,<-0.12432,11.12576,0.28346>,
            
    /*4*/ <0.06553,11.51941,0.2302>

    /* stem 0.39.9*/ 
    /*0*/ <-0.25104,10.42691,0.59593>,
    /*1*/ <-0.2615,10.4221,0.5989>,<-0.25066,10.43773,0.59104>,<-0.24098,10.42089,0.59784>,
            
    /*2*/ <-0.22827,10.59482,0.9794>,<-0.22104,10.60524,0.97416>,<-0.21459,10.59401,0.97869>,
            
    /*3*/ <-0.30371,10.80665,1.33153>,<-0.30016,10.812,1.32914>,<-0.29698,10.80711,1.33276>,
            
    /*4*/ <-0.49284,11.15497,1.46767>

    /* stem 0.39.10*/ 
    /*0*/ <-0.28111,10.52845,0.65447>,
    /*1*/ <-0.2764,10.53464,0.64614>,<-0.27787,10.53004,0.66527>,<-0.28905,10.52067,0.65198>,
            
    /*2*/ <-0.56653,10.81263,0.69409>,<-0.56751,10.80957,0.70684>,<-0.57496,10.80332,0.69798>,
            
    /*3*/ <-0.77072,11.15646,0.74713>,<-0.77129,11.15519,0.75356>,<-0.77591,11.15309,0.74937>,
            
    /*4*/ <-0.89803,11.52502,0.85507>

    /* stem 0.39.11*/ 
    /*0*/ <-0.30643,10.61395,0.70376>,
    /*1*/ <-0.30372,10.60925,0.7133>,<-0.31626,10.61869,0.70256>,<-0.2993,10.61391,0.6954>,
            
    /*2*/ <-0.1556,10.95147,0.83559>,<-0.16396,10.95776,0.82844>,<-0.15266,10.95457,0.82366>,
            
    /*3*/ <-0.09696,11.30941,0.98563>,<-0.10136,11.31181,0.98175>,<-0.09529,11.31159,0.97992>,
            
    /*4*/ <-0.09304,11.66576,1.14997>

    /* stem 0.39.12*/ 
    /*0*/ <-0.33875,10.72313,0.76669>,
    /*1*/ <-0.34702,10.7243,0.7604>,<-0.33309,10.73146,0.7695>,<-0.33613,10.71362,0.77016>,
            
    /*2*/ <-0.56594,10.77275,1.06326>,<-0.55666,10.77752,1.06933>,<-0.55868,10.76562,1.06977>,
            
    /*3*/ <-0.71471,11.04804,1.27233>,<-0.7092,11.0497,1.27415>,<-0.71231,11.04561,1.27731>,
            
    /*4*/ <-0.82414,11.38033,1.41184>

    /* stem 0.39.13*/ 
    /*0*/ <-0.36065,10.7971,0.80934>,
    /*1*/ <-0.3509,10.79969,0.80986>,<-0.36649,10.79772,0.81756>,<-0.36457,10.7939,0.80059>,
            
    /*2*/ <-0.44088,11.14371,0.7222>,<-0.45128,11.1424,0.72733>,<-0.45,11.13985,0.71602>,
            
    /*3*/ <-0.60134,11.47384,0.70432>,<-0.60608,11.47173,0.707>,<-0.60571,11.47159,0.70118>,
            
    /*4*/ <-0.7674,11.75023,0.87838>

    /* stem 0.39.14*/ 
    /*0*/ <-0.38561,10.87789,0.85609>,
    /*1*/ <-0.39224,10.87283,0.86108>,<-0.38793,10.88655,0.85232>,<-0.37666,10.8743,0.85486>,
            
    /*2*/ <-0.28532,11.03289,1.15894>,<-0.28244,11.04203,1.1531>,<-0.27493,11.03386,1.1548>,
            
    /*3*/ <-0.28174,11.26295,1.42836>,<-0.2804,11.26711,1.42484>,<-0.27635,11.26413,1.42733>,
            
    /*4*/ <-0.38783,11.50673,1.66235>

    /* stem 0.39.15*/ 
    /*0*/ <-0.43339,11.02469,0.94145>,
    /*1*/ <-0.43262,11.0294,0.93378>,<-0.42902,11.0274,0.94887>,<-0.43854,11.01727,0.94169>,
            
    /*2*/ <-0.69592,11.21324,1.02371>,<-0.69352,11.2119,1.03377>,<-0.69986,11.20516,1.02898>,
            
    /*3*/ <-0.87643,11.46979,1.13544>,<-0.87486,11.46882,1.14032>,<-0.87919,11.46657,1.13848>,
            
    /*4*/ <-0.90223,11.7499,1.31502>

    /* stem 0.39.16*/ 
    /*0*/ <-0.46434,11.11976,0.99673>,
    /*1*/ <-0.45961,11.11737,1.00349>,<-0.47173,11.12396,0.99793>,<-0.46167,11.11795,0.98877>,
            
    /*2*/ <-0.30463,11.39676,0.99023>,<-0.31272,11.40115,0.98652>,<-0.30601,11.39714,0.98041>,
            
    /*3*/ <-0.19789,11.69343,0.93>,<-0.20232,11.69469,0.92816>,<-0.19883,11.69282,0.92517>,
            
    /*4*/ <-0.12067,11.9897,1.01917>

    /* stem 0.39.17*/ 
    /*0*/ <-0.50799,11.25386,1.07471>,
    /*1*/ <-0.51448,11.2532,1.07222>,<-0.50458,11.25993,1.07403>,<-0.50489,11.24846,1.07789>,
            
    /*2*/ <-0.62296,11.34501,1.33691>,<-0.61636,11.3495,1.33811>,<-0.61657,11.34185,1.34068>,
            
    /*3*/ <-0.74932,11.55091,1.51453>,<-0.74582,11.5529,1.51475>,<-0.74668,11.55004,1.51746>,
            
    /*4*/ <-0.7865,11.83999,1.58877>

    /* stem 0.39.18*/ 
    /*0*/ <-0.5396,11.37242,1.14583>,
    /*1*/ <-0.53476,11.37436,1.14435>,<-0.54128,11.37295,1.15095>,<-0.54275,11.36994,1.14219>,
            
    /*2*/ <-0.65601,11.62217,1.0796>,<-0.66035,11.62123,1.084>,<-0.66133,11.61923,1.07816>,
            
    /*3*/ <-0.79845,11.85138,1.16886>,<-0.79998,11.84964,1.17096>,<-0.80115,11.85003,1.16808>,
            
    /*4*/ <-0.87896,12.11346,1.23869>

    /* stem 0.39.19*/ 
    /*0*/ <-0.55895,11.46319,1.2018>,
    /*1*/ <-0.56072,11.46092,1.20487>,<-0.56089,11.46664,1.20035>,<-0.55525,11.46201,1.20016>,
            
    /*2*/ <-0.43101,11.61133,1.38833>,<-0.43113,11.61514,1.38532>,<-0.42737,11.61206,1.38519>,
            
    /*3*/ <-0.32815,11.82535,1.51896>,<-0.32849,11.82673,1.51699>,<-0.3264,11.82554,1.51729>,
            
    /*4*/ <-0.28729,12.04692,1.6681>

    /* stem 0.39.20*/ 
    /*0*/ <-0.57619,11.54401,1.25163>,
    /*1*/ <-0.57698,11.54548,1.24897>,<-0.57395,11.54521,1.25348>,<-0.57763,11.54134,1.25243>,
            
    /*2*/ <-0.756,11.68053,1.37815>,<-0.75398,11.68035,1.38116>,<-0.75643,11.67777,1.38046>,
            
    /*3*/ <-0.89241,11.86325,1.50023>,<-0.89133,11.8631,1.50168>,<-0.89282,11.86208,1.50155>,
            
    /*4*/ <-0.97213,12.08277,1.6116>

    /* stem 0.39.21*/ 
    /*0*/ <-0.59818,11.64713,1.3152>,
    /*1*/ <-0.59675,11.64682,1.31621>,<-0.59973,11.64751,1.31597>,<-0.59805,11.64708,1.31344>,
            
    /*2*/ <-0.54198,11.88457,1.31209>,<-0.54397,11.88503,1.31193>,<-0.54284,11.88474,1.31024>,
            
    /*3*/ <-0.47163,12.09526,1.41221>,<-0.4726,12.0956,1.41219>,<-0.47198,12.09577,1.41139>,
            
    /*4*/ <-0.42897,12.28598,1.55829>

    /* stem 0.39.22*/ 
    /*0*/ <-0.6159,11.73024,1.36644>,
    /*1*/ <-0.61656,11.73011,1.36643>,<-0.61568,11.73087,1.36637>,<-0.61546,11.72974,1.36653>,
            
    /*2*/ <-0.62759,11.76112,1.59619>,<-0.62701,11.76163,1.59615>,<-0.62686,11.76087,1.59626>,
            
    /*3*/ <-0.66848,11.86032,1.80198>,<-0.66818,11.86057,1.80192>,<-0.66812,11.86022,1.80209>,
            
    /*4*/ <-0.7093,11.96978,2.00255>

    /* stem 0.40*/ 
    /*0*/ <0.04364,9.64781,-0.06064>,
    /*1*/ <0.07232,9.6485,-0.07113>,<0.05903,9.66881,-0.04466>,<0.02447,9.6601,-0.04028>,
            <0.0164,9.6344,-0.06404>,<0.04598,9.62724,-0.0831>,
    /*2*/ <-0.07731,10.03406,-0.43729>,<-0.08794,10.05031,-0.41612>,<-0.11559,10.04334,-0.41261>,
            <-0.12204,10.02279,-0.43162>,<-0.09838,10.01705,-0.44687>,
    /*3*/ <-0.14991,10.44193,-0.79789>,<-0.15779,10.45451,-0.78227>,<-0.17914,10.45165,-0.78155>,
            <-0.18444,10.43729,-0.79672>,<-0.16638,10.43129,-0.80682>,
    /*4*/ <-0.16033,10.90199,-1.10098>,<-0.16544,10.90938,-1.08976>,<-0.17978,10.90889,-1.09028>,
            <-0.18355,10.9012,-1.10182>,<-0.17153,10.89694,-1.10843>,
    /*5*/ <-0.1645,11.40072,-1.33912>,<-0.16706,11.40364,-1.33308>,<-0.17423,11.4035,-1.33341>,
            <-0.17611,11.4005,-1.33966>,<-0.17009,11.39878,-1.34319>,
    /*6*/ <-0.11561,11.93343,-1.47574>

    /* stem 0.40.0*/ 
    /*0*/ <0.01217,9.73216,-0.14118>,
    /*1*/ <0.00296,9.73926,-0.13015>,<0.00601,9.72824,-0.15545>,<0.02755,9.729,-0.13794>,
            
    /*2*/ <0.14601,10.21898,-0.32692>,<0.14804,10.21163,-0.34379>,<0.1624,10.21213,-0.33212>,
            
    /*3*/ <0.1731,10.70529,-0.5528>,<0.17399,10.70144,-0.56117>,<0.18152,10.70335,-0.55614>,
            
    /*4*/ <0.08725,11.16426,-0.81927>

    /* stem 0.40.1*/ 
    /*0*/ <-0.01426,9.80301,-0.20882>,
    /*1*/ <-0.01517,9.79209,-0.21991>,<-0.00803,9.81693,-0.21208>,<-0.01958,9.80002,-0.19448>,
            
    /*2*/ <-0.48909,9.97549,-0.35455>,<-0.48433,9.99206,-0.34933>,<-0.49203,9.98078,-0.33759>,
            
    /*3*/ <-0.74403,10.38478,-0.56952>,<-0.73869,10.39052,-0.56511>,<-0.74637,10.38772,-0.56134>,
            
    /*4*/ <-1.01397,10.82648,-0.66721>

    /* stem 0.40.2*/ 
    /*0*/ <-0.02782,9.83936,-0.24353>,
    /*1*/ <-0.01762,9.84906,-0.23736>,<-0.04253,9.84358,-0.24498>,<-0.02332,9.82544,-0.24825>,
            
    /*2*/ <0.08086,10.03852,-0.71091>,<0.06425,10.03487,-0.71599>,<0.07705,10.02277,-0.71816>,
            
    /*3*/ <0.03062,10.29933,-1.15831>,<0.0222,10.29661,-1.15904>,<0.02875,10.29178,-1.16259>,
            
    /*4*/ <-0.04581,10.6384,-1.54362>

    /* stem 0.40.3*/ 
    /*0*/ <-0.06714,9.94474,-0.34415>,
    /*1*/ <-0.08127,9.94083,-0.34273>,<-0.06115,9.946,-0.35755>,<-0.05899,9.9474,-0.33216>,
            
    /*2*/ <-0.21184,10.42462,-0.35836>,<-0.19843,10.42807,-0.36823>,<-0.19699,10.429,-0.35131>,
            
    /*3*/ <-0.35823,10.82458,-0.62232>,<-0.35092,10.82447,-0.62667>,<-0.35153,10.82899,-0.61949>,
            
    /*4*/ <-0.61729,11.19238,-0.84088>

    /* stem 0.40.4*/ 
    /*0*/ <-0.08366,9.98902,-0.38642>,
    /*1*/ <-0.07201,9.98579,-0.39436>,<-0.0876,10.00282,-0.38465>,<-0.09137,9.97845,-0.38026>,
            
    /*2*/ <-0.35886,9.95787,-0.79524>,<-0.36926,9.96923,-0.78877>,<-0.37177,9.95298,-0.78584>,
            
    /*3*/ <-0.5727,10.15456,-1.19426>,<-0.57697,10.15987,-1.18944>,<-0.58023,10.15243,-1.19136>,
            
    /*4*/ <-0.67069,10.44426,-1.58103>

    /* stem 0.40.5*/ 
    /*0*/ <-0.10889,10.08612,-0.47565>,
    /*1*/ <-0.11261,10.09467,-0.46534>,<-0.11729,10.08435,-0.48658>,<-0.09677,10.07935,-0.47503>,
            
    /*2*/ <0.1031,10.45505,-0.69267>,<0.09998,10.44817,-0.70683>,<0.11366,10.44484,-0.69913>,
            
    /*3*/ <0.07682,10.83319,-0.98224>,<0.07477,10.82844,-0.98838>,<0.0825,10.83006,-0.98696>,
            
    /*4*/ <-0.04374,11.18941,-1.27648>

    /* stem 0.40.6*/ 
    /*0*/ <-0.12344,10.17476,-0.55441>,
    /*1*/ <-0.12893,10.16615,-0.56308>,<-0.11448,10.18376,-0.55866>,<-0.12692,10.17437,-0.54147>,
            
    /*2*/ <-0.46898,10.47039,-0.64308>,<-0.45934,10.48213,-0.64013>,<-0.46764,10.47587,-0.62868>,
            
    /*3*/ <-0.59568,10.85394,-0.87152>,<-0.58943,10.85765,-0.86888>,<-0.59604,10.85786,-0.86486>,
            
    /*4*/ <-0.61672,11.27909,-1.0567>

    /* stem 0.40.7*/ 
    /*0*/ <-0.14369,10.29808,-0.66399>,
    /*1*/ <-0.13231,10.30278,-0.6608>,<-0.15371,10.30583,-0.66497>,<-0.14504,10.28564,-0.66619>,
            
    /*2*/ <-0.0433,10.36689,-1.09031>,<-0.05757,10.36893,-1.09309>,<-0.05178,10.35546,-1.0939>,
            
    /*3*/ <-0.08183,10.57293,-1.48205>,<-0.08912,10.57326,-1.48123>,<-0.08606,10.56749,-1.48457>,
            
    /*4*/ <-0.15258,10.9034,-1.76841>

    /* stem 0.40.8*/ 
    /*0*/ <-0.1575,10.38224,-0.73876>,
    /*1*/ <-0.16927,10.38317,-0.73553>,<-0.15449,10.3806,-0.75052>,<-0.14874,10.38293,-0.73024>,
            
    /*2*/ <-0.14632,10.80866,-0.79088>,<-0.13647,10.80695,-0.80087>,<-0.13264,10.8085,-0.78735>,
            
    /*3*/ <-0.22287,11.18867,-0.97366>,<-0.21801,11.18733,-0.97861>,<-0.21615,11.19059,-0.97261>,
            
    /*4*/ <-0.43592,11.48079,-1.20374>

    /* stem 0.40.9*/ 
    /*0*/ <-0.16796,10.48604,-0.82136>,
    /*1*/ <-0.16128,10.48078,-0.8294>,<-0.16573,10.49708,-0.81823>,<-0.17687,10.48025,-0.81646>,
            
    /*2*/ <-0.41574,10.61823,-1.12515>,<-0.4187,10.6291,-1.1177>,<-0.42612,10.61788,-1.11653>,
            
    /*3*/ <-0.59683,10.95588,-1.28789>,<-0.59648,10.959,-1.28191>,<-0.60192,10.95533,-1.28349>,
            
    /*4*/ <-0.79121,11.31976,-1.33067>

    /* stem 0.40.10*/ 
    /*0*/ <-0.16884,10.57459,-0.88007>,
    /*1*/ <-0.16782,10.58079,-0.87072>,<-0.17613,10.57765,-0.8881>,<-0.16258,10.56532,-0.88139>,
            
    /*2*/ <0.11803,10.79719,-1.05013>,<0.11249,10.79509,-1.06171>,<0.12153,10.78687,-1.05723>,
            
    /*3*/ <0.34656,11.08175,-1.21397>,<0.34376,11.08074,-1.21975>,<0.3491,11.07741,-1.21809>,
            
    /*4*/ <0.36667,11.43837,-1.39574>

    /* stem 0.40.11*/ 
    /*0*/ <-0.16998,10.68868,-0.95571>,
    /*1*/ <-0.17758,10.68445,-0.96197>,<-0.16176,10.69397,-0.9601>,<-0.1706,10.68761,-0.94507>,
            
    /*2*/ <-0.37476,11.0137,-0.93865>,<-0.36421,11.02004,-0.9374>,<-0.3701,11.0158,-0.92739>,
            
    /*3*/ <-0.55909,11.35106,-0.93969>,<-0.55371,11.35406,-0.9391>,<-0.55687,11.35235,-0.93406>,
            
    /*4*/ <-0.57753,11.73494,-0.97081>

    /* stem 0.40.12*/ 
    /*0*/ <-0.17077,10.76727,-1.00781>,
    /*1*/ <-0.16047,10.76782,-1.00714>,<-0.17657,10.77534,-1.005>,<-0.17526,10.75864,-1.0113>,
            
    /*2*/ <-0.14816,10.9004,-1.35573>,<-0.1589,10.90542,-1.35431>,<-0.15803,10.89428,-1.35851>,
            
    /*3*/ <-0.12102,11.16854,-1.61308>,<-0.12644,11.17058,-1.6116>,<-0.12586,11.16643,-1.61585>,
            
    /*4*/ <-0.04734,11.45002,-1.84599>

    /* stem 0.40.13*/ 
    /*0*/ <-0.17154,10.84461,-1.05909>,
    /*1*/ <-0.17968,10.84773,-1.05427>,<-0.17106,10.84529,-1.06902>,<-0.16387,10.84081,-1.05398>,
            
    /*2*/ <-0.03281,11.17743,-1.02623>,<-0.02707,11.17581,-1.03606>,<-0.02227,11.17282,-1.02604>,
            
    /*3*/ <0.06072,11.50085,-1.16115>,<0.06302,11.49831,-1.16577>,<0.06627,11.49931,-1.16113>,
            
    /*4*/ <0.15794,11.84061,-1.23843>

    /* stem 0.40.14*/ 
    /*0*/ <-0.17192,10.96203,-1.12632>,
    /*1*/ <-0.1695,10.95807,-1.13453>,<-0.16703,10.96938,-1.12301>,<-0.17924,10.95864,-1.12143>,
            
    /*2*/ <-0.3823,11.17564,-1.29861>,<-0.38065,11.18318,-1.29093>,<-0.38879,11.17602,-1.28988>,
            
    /*3*/ <-0.61234,11.42556,-1.37198>,<-0.61071,11.4284,-1.36762>,<-0.61477,11.42479,-1.36716>,
            
    /*4*/ <-0.75442,11.73435,-1.43596>

    /* stem 0.40.15*/ 
    /*0*/ <-0.17148,11.09083,-1.18828>,
    /*1*/ <-0.16771,11.0943,-1.18104>,<-0.17829,11.09499,-1.19217>,<-0.16843,11.0832,-1.19164>,
            
    /*2*/ <0.04116,11.26036,-1.37279>,<0.03411,11.26081,-1.38022>,<0.04068,11.25296,-1.37986>,
            
    /*3*/ <0.1195,11.5293,-1.54453>,<0.11537,11.52866,-1.54749>,<0.11983,11.52652,-1.54882>,
            
    /*4*/ <0.21899,11.83812,-1.5886>

    /* stem 0.40.16*/ 
    /*0*/ <-0.17104,11.21736,-1.24915>,
    /*1*/ <-0.17859,11.21586,-1.25232>,<-0.16481,11.2197,-1.25416>,<-0.16971,11.21651,-1.24097>,
            
    /*2*/ <-0.25355,11.51517,-1.20781>,<-0.24436,11.51773,-1.20903>,<-0.24763,11.5156,-1.20024>,
            
    /*3*/ <-0.21364,11.81468,-1.2885>,<-0.20889,11.81398,-1.28887>,<-0.21079,11.81537,-1.28468>,
            
    /*4*/ <-0.15801,12.09084,-1.42185>

    /* stem 0.40.17*/ 
    /*0*/ <-0.17055,11.35838,-1.31698>,
    /*1*/ <-0.16414,11.35761,-1.31853>,<-0.17257,11.36389,-1.31388>,<-0.17493,11.35364,-1.31853>,
            
    /*2*/ <-0.21358,11.48619,-1.57709>,<-0.21921,11.49037,-1.57399>,<-0.22078,11.48354,-1.57709>,
            
    /*3*/ <-0.22611,11.69829,-1.77851>,<-0.22886,11.70006,-1.77651>,<-0.22979,11.69747,-1.77918>,
            
    /*4*/ <-0.16989,11.98251,-1.82062>

    /* stem 0.40.18*/ 
    /*0*/ <-0.16374,11.46607,-1.35446>,
    /*1*/ <-0.16683,11.46747,-1.3503>,<-0.16405,11.46881,-1.35907>,<-0.16035,11.46193,-1.35402>,
            
    /*2*/ <0.03384,11.64026,-1.26191>,<0.0357,11.64115,-1.26776>,<0.03816,11.63657,-1.2644>,
            
    /*3*/ <0.2305,11.83069,-1.20596>,<0.23119,11.83089,-1.20898>,<0.23267,11.82883,-1.20718>,
            
    /*4*/ <0.39407,12.05266,-1.16295>

    /* stem 0.40.19*/ 
    /*0*/ <-0.15185,11.58154,-1.38443>,
    /*1*/ <-0.15218,11.58056,-1.38833>,<-0.14878,11.58386,-1.38318>,<-0.15458,11.5802,-1.38177>,
            
    /*2*/ <-0.2987,11.79734,-1.42892>,<-0.29644,11.79954,-1.42548>,<-0.3003,11.7971,-1.42454>,
            
    /*3*/ <-0.38369,12.0435,-1.47709>,<-0.38241,12.0443,-1.47531>,<-0.38461,12.04361,-1.47495>,
            
    /*4*/ <-0.49028,12.27552,-1.54672>

    /* stem 0.40.20*/ 
    /*0*/ <-0.1408,11.68885,-1.41227>,
    /*1*/ <-0.13883,11.68916,-1.41029>,<-0.14267,11.69089,-1.41273>,<-0.14089,11.68649,-1.4138>,
            
    /*2*/ <0.0147,11.79279,-1.58028>,<0.01215,11.79394,-1.5819>,<0.01333,11.79101,-1.58262>,
            
    /*3*/ <0.09584,12.00231,-1.69307>,<0.09434,12.0026,-1.69361>,<0.09537,12.00173,-1.6945>,
            
    /*4*/ <0.12472,12.22371,-1.80895>

    /* stem 0.40.21*/ 
    /*0*/ <-0.12968,11.79681,-1.44029>,
    /*1*/ <-0.13123,11.79692,-1.44046>,<-0.12872,11.79723,-1.44146>,<-0.12908,11.79628,-1.43894>,
            
    /*2*/ <-0.12419,12.01921,-1.35583>,<-0.12252,12.01942,-1.35649>,<-0.12276,12.01878,-1.35481>,
            
    /*3*/ <-0.12075,12.25539,-1.32731>,<-0.11992,12.25542,-1.32766>,<-0.12003,12.25531,-1.32677>,
            
    /*4*/ <-0.08197,12.47846,-1.4007>

    /* stem 0.40.22*/ 
    /*0*/ <-0.11844,11.90587,-1.46859>,
    /*1*/ <-0.11819,11.9058,-1.46875>,<-0.11844,11.90611,-1.46838>,<-0.11871,11.90571,-1.46863>,
            
    /*2*/ <-0.18358,12.04854,-1.62904>,<-0.18374,12.04875,-1.62879>,<-0.18393,12.04848,-1.62896>,
            
    /*3*/ <-0.25119,12.21529,-1.76311>,<-0.25127,12.21538,-1.76297>,<-0.25137,12.21526,-1.76307>,
            
    /*4*/ <-0.26128,12.43278,-1.81737>

    /* stem 0.41*/ 
    /*0*/ <0.03802,9.77274,-0.06779>,
    /*1*/ <0.02299,9.77356,-0.04176>,<0.01371,9.79002,-0.07163>,<0.03804,9.78261,-0.09619>,
            <0.06234,9.76156,-0.0815>,<0.05304,9.75596,-0.04785>,
    /*2*/ <0.3131,10.21115,0.10524>,<0.30569,10.22433,0.08134>,<0.32514,10.2184,0.06169>,
            <0.34459,10.20156,0.07345>,<0.33714,10.19708,0.10037>,
    /*3*/ <0.5925,10.67059,0.20437>,<0.58594,10.67873,0.18591>,<0.60016,10.67355,0.17105>,
            <0.61551,10.66221,0.18032>,<0.61077,10.66039,0.20092>,
    /*4*/ <0.76871,11.16799,0.33114>,<0.76398,11.17292,0.31877>,<0.77443,11.17178,0.30932>,
            <0.78564,11.16615,0.31585>,<0.7821,11.1638,0.32934>,
    /*5*/ <0.94097,11.68584,0.36675>,<0.9383,11.68722,0.36035>,<0.94334,11.68594,0.35556>,
            <0.94912,11.68378,0.359>,<0.94766,11.68372,0.36592>,
    /*6*/ <1.08754,12.20881,0.31125>

    /* stem 0.41.0*/ 
    /*0*/ <0.08722,9.84776,-0.0417>,
    /*1*/ <0.08629,9.85351,-0.05649>,<0.10116,9.84767,-0.03408>,<0.07422,9.84209,-0.03455>,
            
    /*2*/ <-0.01748,10.33742,0.14408>,<-0.00757,10.33353,0.15902>,<-0.02553,10.3298,0.15871>,
            
    /*3*/ <-0.11905,10.76532,0.45113>,<-0.11399,10.76175,0.45791>,<-0.12298,10.75994,0.45744>,
            
    /*4*/ <-0.09799,11.277,0.59631>

    /* stem 0.41.1*/ 
    /*0*/ <0.14868,9.94146,-0.00912>,
    /*1*/ <0.15776,9.93251,-0.00051>,<0.14203,9.95389,-0.00295>,<0.14624,9.93798,-0.02392>,
            
    /*2*/ <0.56639,10.22288,-0.13875>,<0.5559,10.23714,-0.14037>,<0.55871,10.22653,-0.15435>,
            
    /*3*/ <0.81226,10.67031,-0.25425>,<0.80449,10.67462,-0.25441>,<0.80769,10.67094,-0.26184>,
            
    /*4*/ <1.03562,11.13621,-0.20119>

    /* stem 0.41.2*/ 
    /*0*/ <0.19923,10.01853,0.01767>,
    /*1*/ <0.18656,10.02646,0.01876>,<0.21068,10.02379,0.00956>,<0.20044,10.00535,0.0247>,
            
    /*2*/ <0.37395,10.25991,0.42979>,<0.39003,10.25812,0.42366>,<0.3832,10.24583,0.43374>,
            
    /*3*/ <0.5648,10.58309,0.77168>,<0.57272,10.58205,0.76836>,<0.57,10.57689,0.77475>,
            
    /*4*/ <0.79376,10.95984,1.02522>

    /* stem 0.41.3*/ 
    /*0*/ <0.24528,10.08875,0.04209>,
    /*1*/ <0.25558,10.0854,0.03228>,<0.24908,10.09242,0.05571>,<0.23118,10.08842,0.03827>,
            
    /*2*/ <0.27797,10.56482,-0.10056>,<0.27363,10.5695,-0.08493>,<0.2617,10.56684,-0.09656>,
            
    /*3*/ <0.49165,11.01331,-0.07959>,<0.48916,11.0142,-0.07158>,<0.48419,11.01685,-0.07786>,
            
    /*4*/ <0.80808,11.37218,0.0578>

    /* stem 0.41.4*/ 
    /*0*/ <0.31004,10.1875,0.07642>,
    /*1*/ <0.30673,10.18498,0.08989>,<0.31024,10.20073,0.07156>,<0.31316,10.17678,0.06781>,
            
    /*2*/ <0.77398,10.22353,0.20697>,<0.77631,10.23403,0.19475>,<0.77826,10.21806,0.19225>,
            
    /*3*/ <1.15866,10.50224,0.30033>,<1.15731,10.5065,0.29353>,<1.16212,10.49993,0.29333>,
            
    /*4*/ <1.35783,10.91564,0.44979>

    /* stem 0.41.5*/ 
    /*0*/ <0.36671,10.27963,0.10011>,
    /*1*/ <0.36138,10.28537,0.08896>,<0.37962,10.28227,0.10362>,<0.35915,10.27125,0.10775>,
            
    /*2*/ <0.21845,10.64892,0.35018>,<0.23061,10.64685,0.35995>,<0.21696,10.63951,0.3627>,
            
    /*3*/ <0.1739,11.06327,0.56653>,<0.18014,11.06166,0.57103>,<0.17293,11.05963,0.57344>,
            
    /*4*/ <0.25877,11.52099,0.62321>

    /* stem 0.41.6*/ 
    /*0*/ <0.42969,10.38434,0.12388>,
    /*1*/ <0.44011,10.37725,0.12752>,<0.42468,10.39329,0.13204>,<0.4243,10.38247,0.11207>,
            
    /*2*/ <0.7131,10.69506,-0.0499>,<0.70282,10.70576,-0.04689>,<0.70257,10.69855,-0.0602>,
            
    /*3*/ <0.90575,11.10709,-0.01647>,<0.89906,11.11014,-0.01466>,<0.90119,11.10973,-0.02191>,
            
    /*4*/ <1.01872,11.5193,0.14049>

    /* stem 0.41.7*/ 
    /*0*/ <0.50829,10.51499,0.15354>,
    /*1*/ <0.498,10.52007,0.15843>,<0.5156,10.52174,0.14603>,<0.51125,10.50317,0.15615>,
            
    /*2*/ <0.73193,10.65269,0.50207>,<0.74367,10.65381,0.4938>,<0.74077,10.64142,0.50055>,
            
    /*3*/ <0.87089,10.86021,0.85723>,<0.87731,10.86129,0.85415>,<0.87615,10.85537,0.85807>,
            
    /*4*/ <0.98373,11.20748,1.09532>

    /* stem 0.41.8*/ 
    /*0*/ <0.55129,10.58648,0.16976>,
    /*1*/ <0.55698,10.58548,0.15911>,<0.5574,10.59013,0.17958>,<0.53949,10.58385,0.1706>,
            
    /*2*/ <0.45818,10.99089,0.07261>,<0.45846,10.99399,0.08625>,<0.44652,10.9898,0.08027>,
            
    /*3*/ <0.39584,11.36897,-0.10933>,<0.39587,11.37206,-0.10305>,<0.38985,11.36975,-0.10578>,
            
    /*4*/ <0.30371,11.77355,-0.21007>

    /* stem 0.41.9*/ 
    /*0*/ <0.62066,10.72558,0.20349>,
    /*1*/ <0.62193,10.72225,0.21439>,<0.61578,10.73569,0.20111>,<0.62427,10.71881,0.19496>,
            
    /*2*/ <0.98672,10.90246,0.22294>,<0.98262,10.91142,0.21409>,<0.98827,10.90017,0.20999>,
            
    /*3*/ <1.20047,11.24163,0.29335>,<1.19703,11.24483,0.28868>,<1.20261,11.24164,0.28709>,
            
    /*4*/ <1.25901,11.64528,0.28233>

    /* stem 0.41.10*/ 
    /*0*/ <0.65513,10.82455,0.22972>,
    /*1*/ <0.64752,10.82896,0.22306>,<0.66571,10.82753,0.22874>,<0.65217,10.81715,0.23734>,
            
    /*2*/ <0.59187,11.11824,0.4847>,<0.604,11.11729,0.48849>,<0.59497,11.11036,0.49422>,
            
    /*3*/ <0.49126,11.45197,0.6644>,<0.49712,11.45248,0.66684>,<0.4926,11.44938,0.67007>,
            
    /*4*/ <0.45197,11.84041,0.71241>

    /* stem 0.41.11*/ 
    /*0*/ <0.68289,10.90421,0.25083>,
    /*1*/ <0.693,10.90076,0.25055>,<0.67983,10.91118,0.25833>,<0.67584,10.90069,0.24361>,
            
    /*2*/ <0.78233,11.19258,0.01821>,<0.77355,11.19952,0.0234>,<0.7709,11.19253,0.01359>,
            
    /*3*/ <0.7335,11.5549,-0.10704>,<0.72874,11.55563,-0.10318>,<0.72779,11.55353,-0.1089>,
            
    /*4*/ <0.79709,11.91206,-0.2284>

    /* stem 0.41.12*/ 
    /*0*/ <0.72083,11.01311,0.27969>,
    /*1*/ <0.71307,11.01407,0.28626>,<0.72407,11.02122,0.2744>,<0.72534,11.00405,0.27842>,
            
    /*2*/ <0.95428,11.09477,0.554>,<0.96161,11.09953,0.5461>,<0.96246,11.08808,0.54878>,
            
    /*3*/ <1.1664,11.32313,0.75238>,<1.16916,11.32489,0.74748>,<1.17124,11.32031,0.75055>,
            
    /*4*/ <1.38869,11.61272,0.81344>

    /* stem 0.41.13*/ 
    /*0*/ <0.7553,11.11207,0.30592>,
    /*1*/ <0.75743,11.11381,0.29654>,<0.76122,11.11537,0.31297>,<0.74725,11.10703,0.30825>,
            
    /*2*/ <0.57072,11.41682,0.31389>,<0.57325,11.41785,0.32484>,<0.56394,11.4123,0.3217>,
            
    /*3*/ <0.51825,11.75464,0.41739>,<0.52009,11.75338,0.42258>,<0.5146,11.75291,0.42134>,
            
    /*4*/ <0.47945,12.04735,0.61853>

    /* stem 0.41.14*/ 
    /*0*/ <0.78879,11.2108,0.32421>,
    /*1*/ <0.79316,11.20875,0.33223>,<0.78466,11.21913,0.32314>,<0.78855,11.20453,0.31726>,
            
    /*2*/ <1.08411,11.33821,0.20324>,<1.07844,11.34513,0.19717>,<1.08103,11.3354,0.19326>,
            
    /*3*/ <1.28306,11.61721,0.2127>,<1.27938,11.61999,0.20988>,<1.28329,11.61728,0.2073>,
            
    /*4*/ <1.42759,11.92651,0.25162>

    /* stem 0.41.15*/ 
    /*0*/ <0.83124,11.34069,0.33442>,
    /*1*/ <0.82339,11.34348,0.33153>,<0.83863,11.34328,0.33034>,<0.83171,11.3353,0.34139>,
            
    /*2*/ <0.84482,11.60149,0.53151>,<0.85498,11.60135,0.53073>,<0.85037,11.59603,0.53809>,
            
    /*3*/ <0.88221,11.92158,0.58173>,<0.88724,11.92113,0.58107>,<0.88523,11.92064,0.58572>,
            
    /*4*/ <0.86101,12.24466,0.62479>

    /* stem 0.41.16*/ 
    /*0*/ <0.88797,11.51427,0.34807>,
    /*1*/ <0.89515,11.51214,0.34523>,<0.88744,11.51952,0.35409>,<0.88133,11.51114,0.34489>,
            
    /*2*/ <0.88114,11.74208,0.14509>,<0.876,11.747,0.151>,<0.87193,11.74141,0.14486>,
            
    /*3*/ <0.8041,12.02299,0.04804>,<0.80168,12.02369,0.05192>,<0.79962,12.02185,0.04821>,
            
    /*4*/ <0.76535,12.32566,0.05905>

    /* stem 0.41.17*/ 
    /*0*/ <0.93088,11.64554,0.35839>,
    /*1*/ <0.92775,11.64612,0.36403>,<0.93122,11.65058,0.35434>,<0.93368,11.63992,0.35681>,
            
    /*2*/ <1.17321,11.73187,0.48915>,<1.17552,11.73484,0.48268>,<1.17716,11.72773,0.48433>,
            
    /*3*/ <1.38788,11.91824,0.54182>,<1.38804,11.91912,0.53818>,<1.39014,11.91632,0.53953>,
            
    /*4*/ <1.58191,12.1169,0.61929>

    /* stem 0.41.18*/ 
    /*0*/ <0.96348,11.75672,0.35466>,
    /*1*/ <0.96245,11.75651,0.34957>,<0.96744,11.75958,0.35639>,<0.96053,11.75406,0.35801>,
            
    /*2*/ <0.79557,11.97294,0.37609>,<0.7989,11.97499,0.38063>,<0.79429,11.9713,0.38171>,
            
    /*3*/ <0.64168,12.19974,0.3684>,<0.64326,12.20091,0.37065>,<0.64082,12.19928,0.37123>,
            
    /*4*/ <0.49695,12.4331,0.37567>

    /* stem 0.41.19*/ 
    /*0*/ <0.98854,11.84803,0.34589>,
    /*1*/ <0.99168,11.84742,0.34852>,<0.98638,11.85157,0.34602>,<0.98755,11.8451,0.34313>,
            
    /*2*/ <1.15683,11.95526,0.17431>,<1.1533,11.95803,0.17264>,<1.15408,11.95372,0.17071>,
            
    /*3*/ <1.27339,12.12501,0.00976>,<1.27128,12.12605,0.00932>,<1.27202,12.12422,0.00796>,
            
    /*4*/ <1.38936,12.32598,-0.11419>

    /* stem 0.41.20*/ 
    /*0*/ <1.01603,11.94822,0.33627>,
    /*1*/ <1.01314,11.94902,0.33629>,<1.01799,11.94973,0.33457>,<1.01696,11.94593,0.33795>,
            
    /*2*/ <1.05841,12.10561,0.52669>,<1.06164,12.10608,0.52555>,<1.06096,12.10354,0.5278>,
            
    /*3*/ <1.0411,12.28899,0.69588>,<1.04272,12.28947,0.69553>,<1.04242,12.2883,0.69676>,
            
    /*4*/ <0.98677,12.47321,0.85668>

    /* stem 0.41.21*/ 
    /*0*/ <1.03811,12.02868,0.32854>,
    /*1*/ <1.0396,12.02814,0.32721>,<1.03855,12.02992,0.33014>,<1.03618,12.02798,0.32828>,
            
    /*2*/ <0.98724,12.22048,0.19249>,<0.98654,12.22166,0.19444>,<0.98496,12.22036,0.1932>,
            
    /*3*/ <0.88649,12.43153,0.1339>,<0.88624,12.43173,0.13505>,<0.88545,12.43117,0.13436>,
            
    /*4*/ <0.83132,12.66469,0.11215>

    /* stem 0.41.22*/ 
    /*0*/ <1.0752,12.16384,0.31557>,
    /*1*/ <1.07513,12.16391,0.31607>,<1.07505,12.16421,0.31523>,<1.07543,12.16341,0.31539>,
            
    /*2*/ <1.27596,12.26131,0.33098>,<1.2759,12.26151,0.33041>,<1.27615,12.26098,0.33052>,
            
    /*3*/ <1.43319,12.41894,0.30893>,<1.4331,12.419,0.30865>,<1.43331,12.41879,0.30871>,
            
    /*4*/ <1.51161,12.62549,0.34364>

    /* stem 0.42*/ 
    /*0*/ <0.03097,9.92962,-0.07676>,
    /*1*/ <0.02588,9.92773,-0.10573>,<0.05012,9.94729,-0.09054>,<0.0479,9.94243,-0.0563>,
            <0.02229,9.91986,-0.05033>,<0.00868,9.91078,-0.08088>,
    /*2*/ <-0.32219,10.3336,-0.06496>,<-0.3028,10.34925,-0.0528>,<-0.30458,10.34536,-0.02541>,
            <-0.32507,10.3273,-0.02063>,<-0.33596,10.32004,-0.04507>,
    /*3*/ <-0.63413,10.76715,-0.0778>,<-0.61912,10.77838,-0.06881>,<-0.62178,10.77735,-0.04821>,
            <-0.63844,10.76547,-0.04448>,<-0.64607,10.75918,-0.06276>,
    /*4*/ <-0.86776,11.25081,-0.07966>,<-0.8566,11.25633,-0.07356>,<-0.85844,11.25565,-0.05984>,
            <-0.87074,11.24972,-0.05745>,<-0.8765,11.24673,-0.0697>,
    /*5*/ <-1.08543,11.73893,-0.11448>,<-1.07983,11.74168,-0.11145>,<-1.08092,11.74177,-0.10461>,
            <-1.08719,11.73906,-0.1034>,<-1.08997,11.7373,-0.1095>,
    /*6*/ <-1.25024,12.24534,-0.17558>

    /* stem 0.42.0*/ 
    /*0*/ <-0.02212,9.99129,-0.07144>,
    /*1*/ <-0.01263,9.99859,-0.06141>,<-0.03751,9.99096,-0.0688>,<-0.01622,9.98431,-0.08411>,
            
    /*2*/ <-0.0721,10.44318,-0.33699>,<-0.08868,10.43809,-0.34192>,<-0.07449,10.43366,-0.35213>,
            
    /*3*/ <-0.09399,10.92826,-0.53563>,<-0.10242,10.9268,-0.53847>,<-0.09545,10.9249,-0.54387>,
            
    /*4*/ <-0.09629,11.42305,-0.71454>

    /* stem 0.42.1*/ 
    /*0*/ <-0.12721,10.11336,-0.06091>,
    /*1*/ <-0.13853,10.10361,-0.06092>,<-0.12747,10.12511,-0.07011>,<-0.11563,10.11134,-0.05169>,
            
    /*2*/ <-0.37057,10.38029,0.29506>,<-0.3632,10.39463,0.28894>,<-0.35531,10.38545,0.30122>,
            
    /*3*/ <-0.58896,10.72071,0.6026>,<-0.58467,10.72709,0.59869>,<-0.58122,10.72313,0.60553>,
            
    /*4*/ <-0.84101,11.1139,0.80034>

    /* stem 0.42.2*/ 
    /*0*/ <-0.17826,10.17266,-0.05579>,
    /*1*/ <-0.17018,10.18042,-0.06515>,<-0.18504,10.17933,-0.04472>,<-0.17957,10.15822,-0.05751>,
            
    /*2*/ <-0.57301,10.24821,-0.34939>,<-0.58292,10.24748,-0.33577>,<-0.57927,10.23341,-0.3443>,
            
    /*3*/ <-0.86348,10.60776,-0.52584>,<-0.86816,10.60752,-0.51883>,<-0.87017,10.60265,-0.5254>,
            
    /*4*/ <-1.11108,11.03909,-0.54806>

    /* stem 0.42.3*/ 
    /*0*/ <-0.27063,10.27995,-0.04653>,
    /*1*/ <-0.2719,10.27768,-0.03278>,<-0.28179,10.28386,-0.05404>,<-0.25821,10.27833,-0.05279>,
            
    /*2*/ <-0.16784,10.73981,0.04852>,<-0.17444,10.74393,0.03434>,<-0.15872,10.74025,0.03518>,
            
    /*3*/ <-0.19091,11.22136,0.04174>,<-0.19426,11.22117,0.03439>,<-0.18622,11.22156,0.03516>,
            
    /*4*/ <-0.40463,11.62494,-0.11204>

    /* stem 0.42.4*/ 
    /*0*/ <-0.33958,10.36482,-0.04305>,
    /*1*/ <-0.34489,10.36048,-0.05473>,<-0.33427,10.37725,-0.04223>,<-0.33958,10.35673,-0.03219>,
            
    /*2*/ <-0.75991,10.53165,0.07564>,<-0.75283,10.54283,0.08398>,<-0.75637,10.52914,0.09067>,
            
    /*3*/ <-1.16227,10.76403,0.05004>,<-1.15923,10.76989,0.05424>,<-1.16287,10.76398,0.05784>,
            
    /*4*/ <-1.48007,11.10775,0.04041>

    /* stem 0.42.5*/ 
    /*0*/ <-0.40088,10.44968,-0.04669>,
    /*1*/ <-0.39096,10.45703,-0.04229>,<-0.41298,10.45149,-0.04198>,<-0.3987,10.44052,-0.05581>,
            
    /*2*/ <-0.47588,10.76036,-0.3705>,<-0.49056,10.75667,-0.37029>,<-0.48104,10.74935,-0.37951>,
            
    /*3*/ <-0.45209,11.11696,-0.64791>,<-0.45957,11.11666,-0.64903>,<-0.45491,11.11281,-0.65358>,
            
    /*4*/ <-0.54042,11.47505,-0.91554>

    /* stem 0.42.6*/ 
    /*0*/ <-0.48808,10.57039,-0.05187>,
    /*1*/ <-0.49766,10.56366,-0.04753>,<-0.48974,10.57807,-0.06158>,<-0.47684,10.56945,-0.0465>,
            
    /*2*/ <-0.59814,10.8901,0.22512>,<-0.59285,10.89971,0.21574>,<-0.58425,10.89396,0.2258>,
            
    /*3*/ <-0.76687,11.2692,0.36359>,<-0.76365,11.27269,0.35816>,<-0.76024,11.2719,0.36447>,
            
    /*4*/ <-0.9096,11.67238,0.26846>

    /* stem 0.42.7*/ 
    /*0*/ <-0.52752,10.625,-0.05421>,
    /*1*/ <-0.52241,10.62824,-0.06482>,<-0.5295,10.6334,-0.04557>,<-0.53066,10.61336,-0.05225>,
            
    /*2*/ <-0.91293,10.70422,-0.22516>,<-0.91766,10.70767,-0.21233>,<-0.91843,10.6943,-0.21678>,
            
    /*3*/ <-1.25267,10.91036,-0.38387>,<-1.25478,10.91201,-0.37735>,<-1.257,10.90603,-0.38037>,
            
    /*4*/ <-1.53509,11.21636,-0.48651>

    /* stem 0.42.8*/ 
    /*0*/ <-0.58687,10.70715,-0.05774>,
    /*1*/ <-0.58538,10.70872,-0.04613>,<-0.59775,10.70646,-0.06225>,<-0.57747,10.70628,-0.06482>,
            
    /*2*/ <-0.58941,11.12123,-0.10541>,<-0.59765,11.11972,-0.11616>,<-0.58414,11.11961,-0.11787>,
            
    /*3*/ <-0.74187,11.50734,-0.14261>,<-0.74575,11.50536,-0.14785>,<-0.73947,11.50773,-0.14898>,
            
    /*4*/ <-0.95226,11.86639,-0.16452>

    /* stem 0.42.9*/ 
    /*0*/ <-0.66027,10.82795,-0.06134>,
    /*1*/ <-0.66795,10.82411,-0.06856>,<-0.65645,10.83846,-0.06227>,<-0.65641,10.82128,-0.05317>,
            
    /*2*/ <-0.95689,10.95281,0.17584>,<-0.94923,10.96238,0.18004>,<-0.9492,10.95093,0.1861>,
            
    /*3*/ <-1.14138,11.16424,0.46389>,<-1.13616,11.16803,0.46451>,<-1.13671,11.16267,0.4681>,
            
    /*4*/ <-1.3961,11.38446,0.6777>

    /* stem 0.42.10*/ 
    /*0*/ <-0.72684,10.96511,-0.06351>,
    /*1*/ <-0.7173,10.96975,-0.06349>,<-0.73466,10.96905,-0.05751>,<-0.72857,10.95655,-0.06952>,
            
    /*2*/ <-0.82896,11.19277,-0.35208>,<-0.84053,11.19231,-0.34809>,<-0.83647,11.18397,-0.3561>,
            
    /*3*/ <-0.92242,11.40775,-0.65268>,<-0.9283,11.40766,-0.65098>,<-0.92613,11.40334,-0.65474>,
            
    /*4*/ <-1.0475,11.6984,-0.86557>

    /* stem 0.42.11*/ 
    /*0*/ <-0.78256,11.07991,-0.06532>,
    /*1*/ <-0.78957,11.07661,-0.05884>,<-0.7852,11.08592,-0.073>,<-0.7729,11.0772,-0.06413>,
            
    /*2*/ <-0.73085,11.37171,0.14975>,<-0.72794,11.37792,0.14031>,<-0.71973,11.37211,0.14623>,
            
    /*3*/ <-0.74912,11.64379,0.39177>,<-0.74776,11.64764,0.38761>,<-0.74354,11.64513,0.39075>,
            
    /*4*/ <-0.76363,11.90084,0.65188>

    /* stem 0.42.12*/ 
    /*0*/ <-0.82292,11.16308,-0.06664>,
    /*1*/ <-0.82133,11.1637,-0.07622>,<-0.82002,11.17026,-0.06074>,<-0.82741,11.15527,-0.06295>,
            
    /*2*/ <-1.13562,11.32424,-0.11479>,<-1.13476,11.32862,-0.10447>,<-1.13968,11.31862,-0.10594>,
            
    /*3*/ <-1.40198,11.5299,-0.22329>,<-1.40208,11.53248,-0.21829>,<-1.40524,11.52791,-0.21916>,
            
    /*4*/ <-1.50286,11.82775,-0.38603>

    /* stem 0.42.13*/ 
    /*0*/ <-0.87978,11.28259,-0.0706>,
    /*1*/ <-0.87582,11.28503,-0.06265>,<-0.88863,11.28464,-0.07216>,<-0.8749,11.2781,-0.077>,
            
    /*2*/ <-0.7845,11.58029,-0.20226>,<-0.79304,11.58003,-0.2086>,<-0.78388,11.57567,-0.21183>,
            
    /*3*/ <-0.78202,11.91668,-0.18072>,<-0.78635,11.91695,-0.18379>,<-0.78152,11.91706,-0.186>,
            
    /*4*/ <-0.779,12.25397,-0.22045>

    /* stem 0.42.14*/ 
    /*0*/ <-0.93049,11.39573,-0.08003>,
    /*1*/ <-0.93789,11.39217,-0.083>,<-0.92717,11.4028,-0.08393>,<-0.92641,11.39222,-0.07315>,
            
    /*2*/ <-1.10686,11.58348,0.11689>,<-1.09972,11.59057,0.11627>,<-1.09921,11.58352,0.12345>,
            
    /*3*/ <-1.29558,11.82276,0.22605>,<-1.29179,11.82604,0.22553>,<-1.2924,11.82357,0.22988>,
            
    /*4*/ <-1.43936,12.11333,0.23794>

    /* stem 0.42.15*/ 
    /*0*/ <-0.98456,11.51638,-0.09008>,
    /*1*/ <-0.97743,11.51934,-0.09289>,<-0.98858,11.52033,-0.0841>,<-0.98767,11.50946,-0.09325>,
            
    /*2*/ <-1.13168,11.68349,-0.30339>,<-1.13912,11.68415,-0.29753>,<-1.13851,11.6769,-0.30362>,
            
    /*3*/ <-1.22354,11.93756,-0.44949>,<-1.22722,11.93797,-0.44653>,<-1.22768,11.9355,-0.45055>,
            
    /*4*/ <-1.25792,12.23113,-0.53558>

    /* stem 0.42.16*/ 
    /*0*/ <-1.00862,11.57006,-0.09455>,
    /*1*/ <-1.01245,11.56892,-0.08769>,<-1.01266,11.57225,-0.10104>,<-1.00075,11.56902,-0.09493>,
            
    /*2*/ <-0.96931,11.85883,-0.01826>,<-0.96944,11.86105,-0.02716>,<-0.9615,11.8589,-0.02309>,
            
    /*3*/ <-0.96791,12.15635,0.02874>,<-0.968,12.15711,0.02422>,<-0.96398,12.15674,0.0264>,
            
    /*4*/ <-0.94111,12.45677,0.01927>

    /* stem 0.42.17*/ 
    /*0*/ <-1.05566,11.67503,-0.1033>,
    /*1*/ <-1.05652,11.6741,-0.10985>,<-1.05373,11.68099,-0.101>,<-1.05674,11.67,-0.09904>,
            
    /*2*/ <-1.33123,11.75406,-0.08293>,<-1.32936,11.75866,-0.07702>,<-1.33137,11.75133,-0.07572>,
            
    /*3*/ <-1.53557,11.95554,-0.06282>,<-1.53365,11.95724,-0.05995>,<-1.53626,11.95451,-0.05917>,
            
    /*4*/ <-1.66443,12.207,-0.00827>

    /* stem 0.42.18*/ 
    /*0*/ <-1.09936,11.78461,-0.11462>,
    /*1*/ <-1.09561,11.7863,-0.11117>,<-1.10449,11.78606,-0.11394>,<-1.09798,11.78148,-0.11877>,
            
    /*2*/ <-1.05491,12.00757,-0.26601>,<-1.06083,12.00741,-0.26786>,<-1.0565,12.00436,-0.27108>,
            
    /*3*/ <-1.04348,12.26102,-0.36627>,<-1.04646,12.26084,-0.36711>,<-1.04424,12.25996,-0.36909>,
            
    /*4*/ <-1.02075,12.52983,-0.40666>

    /* stem 0.42.19*/ 
    /*0*/ <-1.15198,11.9453,-0.13588>,
    /*1*/ <-1.1553,11.94421,-0.13591>,<-1.15086,11.94754,-0.13832>,<-1.14978,11.94415,-0.13342>,
            
    /*2*/ <-1.21909,12.13858,0.01239>,<-1.21613,12.1408,0.01078>,<-1.21541,12.13854,0.01405>,
            
    /*3*/ <-1.2825,12.36595,0.10278>,<-1.28093,12.36678,0.10183>,<-1.28071,12.36609,0.10371>,
            
    /*4*/ <-1.41168,12.58135,0.07826>

    /* stem 0.42.20*/ 
    /*0*/ <-1.18851,12.05684,-0.15064>,
    /*1*/ <-1.18684,12.0572,-0.15203>,<-1.18887,12.05822,-0.14897>,<-1.18981,12.05509,-0.15092>,
            
    /*2*/ <-1.33143,12.18689,-0.29039>,<-1.33278,12.18757,-0.28835>,<-1.33341,12.18548,-0.28965>,
            
    /*3*/ <-1.46672,12.33751,-0.41637>,<-1.46736,12.33782,-0.41532>,<-1.46775,12.33685,-0.41605>,
            
    /*4*/ <-1.56577,12.53899,-0.49671>

    /* stem 0.42.21*/ 
    /*0*/ <-1.23389,12.19542,-0.16898>,
    /*1*/ <-1.23401,12.19545,-0.16841>,<-1.23424,12.19567,-0.16937>,<-1.23342,12.19513,-0.16916>,
            
    /*2*/ <-1.11532,12.38116,-0.15451>,<-1.11547,12.38131,-0.15514>,<-1.11492,12.38094,-0.155>,
            
    /*3*/ <-1.00612,12.57054,-0.12345>,<-1.00619,12.57063,-0.12377>,<-1.00591,12.57045,-0.1237>,
            
    /*4*/ <-0.92145,12.7608,-0.05009>

    /* stem 0.43*/ 
    /*0*/ <0.02526,10.0567,-0.08403>,
    /*1*/ <0.04744,10.05876,-0.06546>,<0.01728,10.07438,-0.06247>,<-0.00185,10.06557,-0.08927>,
            <0.01648,10.0445,-0.10883>,<0.04694,10.04029,-0.09411>,
    /*2*/ <0.23074,10.47249,-0.33936>,<0.20662,10.48498,-0.33697>,<0.19131,10.47793,-0.35841>,
            <0.20597,10.46108,-0.37405>,<0.23034,10.45771,-0.36228>,
    /*3*/ <0.39265,10.93077,-0.54461>,<0.37399,10.9387,-0.54194>,<0.36314,10.93518,-0.55892>,
            <0.3751,10.92506,-0.57208>,<0.39334,10.92234,-0.56323>,
    /*4*/ <0.51452,11.42684,-0.67968>,<0.50165,11.43072,-0.67738>,<0.4947,11.4294,-0.68904>,
            <0.50328,11.42471,-0.69854>,<0.51553,11.42312,-0.69276>,
    /*5*/ <0.54419,11.94858,-0.76646>,<0.53754,11.94923,-0.76507>,<0.53409,11.94853,-0.77091>,
            <0.5386,11.94744,-0.7759>,<0.54484,11.94748,-0.77315>,
    /*6*/ <0.52204,12.47641,-0.79243>

    /* stem 0.43.0*/ 
    /*0*/ <0.0583,10.1296,-0.13159>,
    /*1*/ <0.04404,10.13485,-0.13345>,<0.06856,10.13112,-0.14285>,<0.06231,10.12282,-0.11845>,
            
    /*2*/ <0.19236,10.59165,0.05999>,<0.20871,10.58917,0.05372>,<0.20454,10.58363,0.06999>,
            
    /*3*/ <0.3494,11.07938,0.13207>,<0.35733,11.07741,0.12869>,<0.35589,11.07659,0.13738>,
            
    /*4*/ <0.41785,11.58971,0.08856>

    /* stem 0.43.1*/ 
    /*0*/ <0.1125,10.24915,-0.20958>,
    /*1*/ <0.12221,10.24041,-0.21624>,<0.11707,10.26119,-0.20257>,<0.09822,10.24585,-0.20994>,
            
    /*2*/ <0.06855,10.50755,-0.63481>,<0.06513,10.52141,-0.6257>,<0.05256,10.51118,-0.63062>,
            
    /*3*/ <0.03456,10.78232,-1.05034>,<0.03296,10.78923,-1.04572>,<0.02658,10.78437,-1.04841>,
            
    /*4*/ <0.15144,11.13645,-1.38238>

    /* stem 0.43.2*/ 
    /*0*/ <0.14566,10.3223,-0.25731>,
    /*1*/ <0.14447,10.33044,-0.24565>,<0.14048,10.3269,-0.26978>,<0.15203,10.30955,-0.25649>,
            
    /*2*/ <0.57455,10.53599,-0.35128>,<0.57189,10.53363,-0.36737>,<0.57959,10.52207,-0.35851>,
            
    /*3*/ <0.94264,10.85198,-0.34664>,<0.94285,10.85196,-0.35488>,<0.94742,10.84658,-0.35063>,
            
    /*4*/ <1.1194,11.29969,-0.42572>

    /* stem 0.43.3*/ 
    /*0*/ <0.18649,10.41236,-0.31606>,
    /*1*/ <0.17911,10.40852,-0.32706>,<0.19944,10.4168,-0.31765>,<0.1809,10.41175,-0.30347>,
            
    /*2*/ <0.02318,10.85433,-0.37216>,<0.03674,10.85985,-0.36588>,<0.02438,10.85648,-0.35643>,
            
    /*3*/ <-0.15107,11.27692,-0.4935>,<-0.14454,11.28049,-0.49068>,<-0.15079,11.27929,-0.4859>,
            
    /*4*/ <-0.21687,11.73282,-0.60998>

    /* stem 0.43.4*/ 
    /*0*/ <0.2289,10.51469,-0.37348>,
    /*1*/ <0.24087,10.5127,-0.36813>,<0.22312,10.5266,-0.37258>,<0.2227,10.50477,-0.37974>,
            
    /*2*/ <0.43457,10.63916,-0.76505>,<0.42274,10.64843,-0.76802>,<0.42246,10.63388,-0.77279>,
            
    /*3*/ <0.53671,10.95067,-1.08913>,<0.52979,10.95384,-1.08835>,<0.53087,10.94821,-1.09343>,
            
    /*4*/ <0.58015,11.32403,-1.35401>

    /* stem 0.43.5*/ 
    /*0*/ <0.26146,10.6045,-0.41295>,
    /*1*/ <0.25016,10.60986,-0.41006>,<0.26609,10.60532,-0.42489>,<0.26813,10.59832,-0.40389>,
            
    /*2*/ <0.46211,10.98898,-0.30436>,<0.47273,10.98594,-0.31425>,<0.47409,10.98128,-0.30025>,
            
    /*3*/ <0.63181,11.40192,-0.31185>,<0.63681,11.39984,-0.31691>,<0.6384,11.39932,-0.30969>,
            
    /*4*/ <0.79472,11.80716,-0.40777>

    /* stem 0.43.6*/ 
    /*0*/ <0.29402,10.69428,-0.4524>,
    /*1*/ <0.29955,10.68819,-0.46169>,<0.29994,10.70356,-0.44666>,<0.28256,10.69109,-0.44884>,
            
    /*2*/ <0.13058,10.9728,-0.74335>,<0.13084,10.98304,-0.73334>,<0.11926,10.97473,-0.73479>,
            
    /*3*/ <0.02034,11.36467,-0.90188>,<0.02116,11.36759,-0.89538>,<0.01478,11.36499,-0.89737>,
            
    /*4*/ <-0.01806,11.75266,-1.09267>

    /* stem 0.43.7*/ 
    /*0*/ <0.33775,10.81489,-0.5054>,
    /*1*/ <0.34009,10.81885,-0.49448>,<0.33097,10.8213,-0.51269>,<0.34221,10.80454,-0.50902>,
            
    /*2*/ <0.67915,11.01384,-0.64176>,<0.67308,11.01548,-0.6539>,<0.68057,11.0043,-0.65146>,
            
    /*3*/ <0.92286,11.34437,-0.7085>,<0.91988,11.34541,-0.71457>,<0.92541,11.34142,-0.71412>,
            
    /*4*/ <1.10132,11.71603,-0.77693>

    /* stem 0.43.8*/ 
    /*0*/ <0.3568,10.86743,-0.52848>,
    /*1*/ <0.34814,10.86719,-0.53618>,<0.36739,10.87082,-0.53178>,<0.35488,10.86429,-0.51749>,
            
    /*2*/ <0.25641,11.25556,-0.4391>,<0.26925,11.25798,-0.43617>,<0.2609,11.25363,-0.42664>,
            
    /*3*/ <0.22543,11.63255,-0.27484>,<0.23201,11.6326,-0.27359>,<0.22774,11.63025,-0.26899>,
            
    /*4*/ <0.31777,12.00569,-0.128>

    /* stem 0.43.9*/ 
    /*0*/ <0.39403,10.98697,-0.57111>,
    /*1*/ <0.40476,10.98443,-0.57037>,<0.39008,10.9959,-0.56593>,<0.38723,10.98057,-0.57704>,
            
    /*2*/ <0.47496,11.20384,-0.89095>,<0.46518,11.21149,-0.88799>,<0.46328,11.20126,-0.8954>,
            
    /*3*/ <0.53277,11.47379,-1.17369>,<0.52773,11.47712,-1.17161>,<0.52696,11.47261,-1.17607>,
            
    /*4*/ <0.55692,11.84344,-1.31142>

    /* stem 0.43.10*/ 
    /*0*/ <0.42681,11.11587,-0.6052>,
    /*1*/ <0.41895,11.11945,-0.59922>,<0.4278,11.1192,-0.61512>,<0.43368,11.10895,-0.60127>,
            
    /*2*/ <0.64098,11.40305,-0.48356>,<0.64688,11.40288,-0.49416>,<0.6508,11.39605,-0.48493>,
            
    /*3*/ <0.90667,11.67096,-0.44056>,<0.90883,11.66978,-0.4461>,<0.91104,11.66681,-0.4413>,
            
    /*4*/ <1.05152,12.00265,-0.55005>

    /* stem 0.43.11*/ 
    /*0*/ <0.45136,11.21239,-0.63073>,
    /*1*/ <0.45313,11.20943,-0.64022>,<0.45723,11.21941,-0.62646>,<0.44373,11.20833,-0.62552>,
            
    /*2*/ <0.22895,11.47256,-0.76036>,<0.23169,11.47921,-0.75118>,<0.22269,11.47182,-0.75055>,
            
    /*3*/ <0.15198,11.80144,-0.89999>,<0.15376,11.804,-0.89506>,<0.14818,11.80243,-0.89568>,
            
    /*4*/ <0.22559,12.09811,-1.09958>

    /* stem 0.43.12*/ 
    /*0*/ <0.49197,11.37204,-0.67295>,
    /*1*/ <0.49649,11.37306,-0.66475>,<0.48697,11.3792,-0.6765>,<0.49244,11.36386,-0.67761>,
            
    /*2*/ <0.77506,11.48493,-0.83589>,<0.76871,11.48903,-0.84372>,<0.77236,11.4788,-0.84446>,
            
    /*3*/ <0.95318,11.7542,-0.95846>,<0.94906,11.75548,-0.96177>,<0.95297,11.75211,-0.96348>,
            
    /*4*/ <1.05658,12.07143,-1.04837>

    /* stem 0.43.13*/ 
    /*0*/ <0.51091,11.50335,-0.69962>,
    /*1*/ <0.50265,11.50337,-0.70292>,<0.51726,11.50823,-0.70349>,<0.51281,11.49847,-0.69243>,
            
    /*2*/ <0.42821,11.75812,-0.50813>,<0.43794,11.76136,-0.50851>,<0.43498,11.75486,-0.50114>,
            
    /*3*/ <0.33414,12.04448,-0.37759>,<0.33897,12.0462,-0.37779>,<0.33729,12.04374,-0.37361>,
            
    /*4*/ <0.27214,12.35833,-0.29953>

    /* stem 0.43.14*/ 
    /*0*/ <0.51542,11.57272,-0.71064>,
    /*1*/ <0.52358,11.57177,-0.71325>,<0.51313,11.57968,-0.7061>,<0.50955,11.5667,-0.71255>,
            
    /*2*/ <0.45147,11.7266,-0.98478>,<0.4445,11.73187,-0.98001>,<0.44211,11.72322,-0.98431>,
            
    /*3*/ <0.32633,11.95592,-1.17347>,<0.32335,11.95739,-1.16977>,<0.3218,11.95391,-1.17298>,
            
    /*4*/ <0.26663,12.23034,-1.32768>

    /* stem 0.43.15*/ 
    /*0*/ <0.52205,11.67462,-0.72683>,
    /*1*/ <0.51776,11.67599,-0.71995>,<0.52051,11.67905,-0.73358>,<0.52787,11.66882,-0.72695>,
            
    /*2*/ <0.72844,11.88381,-0.63326>,<0.73028,11.88585,-0.64235>,<0.73519,11.87903,-0.63793>,
            
    /*3*/ <0.92367,12.11368,-0.56839>,<0.92438,12.11444,-0.57303>,<0.92716,12.1114,-0.57067>,
            
    /*4*/ <1.05838,12.39114,-0.56373>

    /* stem 0.43.16*/ 
    /*0*/ <0.53014,11.79903,-0.74659>,
    /*1*/ <0.52905,11.79794,-0.75389>,<0.53507,11.80414,-0.74428>,<0.52632,11.79501,-0.7416>,
            
    /*2*/ <0.31802,12.00148,-0.74997>,<0.32203,12.00561,-0.74357>,<0.3162,11.99953,-0.74178>,
            
    /*3*/ <0.21259,12.27387,-0.77521>,<0.2151,12.27518,-0.77197>,<0.21113,12.27372,-0.77117>,
            
    /*4*/ <0.14321,12.55898,-0.7662>

    /* stem 0.43.17*/ 
    /*0*/ <0.53579,11.88578,-0.76037>,
    /*1*/ <0.54064,11.88615,-0.75607>,<0.53148,11.89062,-0.76084>,<0.53524,11.88057,-0.76421>,
            
    /*2*/ <0.70153,12.01179,-0.95157>,<0.69542,12.01478,-0.95475>,<0.69793,12.00807,-0.957>,
            
    /*3*/ <0.82533,12.22261,-1.09302>,<0.82199,12.22378,-1.09427>,<0.82397,12.22128,-1.09625>,
            
    /*4*/ <0.86738,12.48127,-1.19966>

    /* stem 0.43.18*/ 
    /*0*/ <0.53732,12.02343,-0.77345>,
    /*1*/ <0.53235,12.02326,-0.77358>,<0.53978,12.02653,-0.77646>,<0.53982,12.0205,-0.77031>,
            
    /*2*/ <0.52242,12.21301,-0.58742>,<0.52737,12.21519,-0.58934>,<0.5274,12.21117,-0.58524>,
            
    /*3*/ <0.55366,12.46747,-0.5146>,<0.55612,12.4676,-0.51607>,<0.55614,12.46681,-0.51331>,
            
    /*4*/ <0.63201,12.71922,-0.55221>

    /* stem 0.43.19*/ 
    /*0*/ <0.53417,12.11683,-0.77736>,
    /*1*/ <0.53726,12.11683,-0.77982>,<0.53388,12.11958,-0.77454>,<0.53135,12.11408,-0.77773>,
            
    /*2*/ <0.40894,12.26848,-0.93935>,<0.40668,12.27031,-0.93583>,<0.405,12.26665,-0.93796>,
            
    /*3*/ <0.3202,12.47538,-1.05852>,<0.31921,12.47608,-1.05659>,<0.31806,12.47475,-1.05804>,
            
    /*4*/ <0.32597,12.70687,-1.16397>

    /* stem 0.43.20*/ 
    /*0*/ <0.52789,12.30284,-0.78516>,
    /*1*/ <0.52751,12.3029,-0.78329>,<0.52679,12.30379,-0.78639>,<0.52938,12.30183,-0.78579>,
            
    /*2*/ <0.66415,12.48976,-0.7624>,<0.66367,12.49035,-0.76446>,<0.66539,12.48904,-0.76406>,
            
    /*3*/ <0.7473,12.69622,-0.83078>,<0.74685,12.69607,-0.83177>,<0.74788,12.69573,-0.83157>,
            
    /*4*/ <0.74551,12.92813,-0.81972>

    /* stem 0.43.21*/ 
    /*0*/ <0.52362,12.42941,-0.79046>,
    /*1*/ <0.52338,12.42938,-0.79092>,<0.52403,12.42973,-0.79041>,<0.52346,12.42912,-0.79007>,
            
    /*2*/ <0.38944,12.58833,-0.72782>,<0.38987,12.58856,-0.72748>,<0.3895,12.58815,-0.72726>,
            
    /*3*/ <0.25531,12.7569,-0.75468>,<0.25548,12.75706,-0.75451>,<0.25526,12.75691,-0.75438>,
            
    /*4*/ <0.16805,12.9482,-0.8092>

    /* stem 0.44*/ 
    /*0*/ <0.01829,10.21174,-0.0929>,
    /*1*/ <-0.0101,10.21047,-0.09284>,<0.00882,10.22586,-0.11567>,<0.04082,10.22174,-0.10702>,
            <0.04168,10.2038,-0.07886>,<0.01021,10.19683,-0.07009>,
    /*2*/ <-0.02354,10.64881,0.1867>,<-0.0084,10.66112,0.16844>,<0.0172,10.65783,0.17536>,
            <0.01789,10.64348,0.19789>,<-0.00729,10.6379,0.20491>,
    /*3*/ <-0.00609,11.09988,0.44774>,<0.00534,11.1079,0.43336>,<0.02453,11.10462,0.43815>,
            <0.02495,11.09457,0.45549>,<0.00603,11.09164,0.46141>,
    /*4*/ <0.03193,11.60155,0.5825>,<0.03945,11.60396,0.57172>,<0.05225,11.60222,0.57514>,
            <0.05264,11.59873,0.58803>,<0.04008,11.59831,0.59258>,
    /*5*/ <0.03541,12.11182,0.67909>,<0.03914,12.11287,0.67365>,<0.04557,12.11255,0.67546>,
            <0.04581,12.11131,0.68202>,<0.03953,12.11086,0.68426>,
    /*6*/ <0.02063,12.62226,0.77653>

    /* stem 0.44.0*/ 
    /*0*/ <0.01546,10.2765,-0.05157>,
    /*1*/ <0.02674,10.28222,-0.05976>,<0.01479,10.27919,-0.03676>,<0.00485,10.2681,-0.05819>,
            
    /*2*/ <-0.25413,10.70017,-0.14566>,<-0.2621,10.69815,-0.13033>,<-0.26873,10.69076,-0.14462>,
            
    /*3*/ <-0.5469,11.10956,-0.23432>,<-0.55089,11.10845,-0.22667>,<-0.55405,11.10464,-0.23383>,
            
    /*4*/ <-0.66617,11.60249,-0.18049>

    /* stem 0.44.1*/ 
    /*0*/ <0.0099,10.40406,0.02983>,
    /*1*/ <0.00776,10.39632,0.04182>,<0.00069,10.4146,0.02631>,<0.02124,10.40127,0.02137>,
            
    /*2*/ <0.27897,10.7211,0.29418>,<0.27425,10.73328,0.28384>,<0.28796,10.7244,0.28055>,
            
    /*3*/ <0.40057,11.11498,0.56398>,<0.39767,11.12004,0.55803>,<0.40565,11.11764,0.55794>,
            
    /*4*/ <0.36579,11.55466,0.78443>

    /* stem 0.44.2*/ 
    /*0*/ <0.00553,10.50403,0.09362>,
    /*1*/ <-0.00173,10.51019,0.08347>,<0.0166,10.51044,0.09915>,<0.00174,10.49146,0.09826>,
            
    /*2*/ <-0.28165,10.71387,0.4137>,<-0.26943,10.71404,0.42415>,<-0.27933,10.70138,0.42356>,
            
    /*3*/ <-0.45588,11.04853,0.70693>,<-0.44926,11.04809,0.71148>,<-0.45557,11.04338,0.7131>,
            
    /*4*/ <-0.55698,11.46203,0.92415>

    /* stem 0.44.3*/ 
    /*0*/ <0.00244,10.57503,0.13893>,
    /*1*/ <0.0153,10.5731,0.14282>,<-0.00725,10.57701,0.14823>,<-0.00075,10.57496,0.12573>,
            
    /*2*/ <0.08614,11.03552,0.12122>,<0.07111,11.03813,0.12483>,<0.07544,11.03676,0.10983>,
            
    /*3*/ <0.20624,11.46694,0.25183>,<0.19882,11.46846,0.25385>,<0.20129,11.46997,0.24657>,
            
    /*4*/ <0.29715,11.89202,0.42642>

    /* stem 0.44.4*/ 
    /*0*/ <0.00017,10.68778,0.20864>,
    /*1*/ <-0.01197,10.68565,0.21286>,<0.0033,10.69924,0.20331>,<0.00917,10.67844,0.20975>,
            
    /*2*/ <0.10605,10.84492,0.6195>,<0.11623,10.85398,0.61314>,<0.12015,10.84011,0.61743>,
            
    /*3*/ <0.1437,11.16943,0.93196>,<0.14856,11.17316,0.92759>,<0.15108,11.1681,0.93254>,
            
    /*4*/ <0.04296,11.55482,1.14457>

    /* stem 0.44.5*/ 
    /*0*/ <0.00258,10.7801,0.26211>,
    /*1*/ <0.00864,10.78551,0.2525>,<0.00665,10.78184,0.27389>,<-0.00754,10.77295,0.25994>,
            
    /*2*/ <-0.25115,11.13784,0.2925>,<-0.25248,11.1354,0.30676>,<-0.26194,11.12947,0.29747>,
            
    /*3*/ <-0.42962,11.52076,0.4147>,<-0.42973,11.51857,0.42162>,<-0.43544,11.51728,0.41732>,
            
    /*4*/ <-0.48986,11.95444,0.42802>

    /* stem 0.44.6*/ 
    /*0*/ <0.00466,10.85923,0.30794>,
    /*1*/ <0.00703,10.85318,0.31828>,<-0.00371,10.86812,0.30786>,<0.01065,10.85639,0.2977>,
            
    /*2*/ <0.30963,11.14164,0.41278>,<0.30247,11.15159,0.40584>,<0.31204,11.14377,0.39906>,
            
    /*3*/ <0.57677,11.47517,0.45993>,<0.57241,11.47926,0.4562>,<0.57751,11.47564,0.45294>,
            
    /*4*/ <0.65019,11.87062,0.60779>

    /* stem 0.44.7*/ 
    /*0*/ <0.0076,10.97164,0.37305>,
    /*1*/ <-0.0015,10.97548,0.36682>,<0.01632,10.97892,0.37575>,<0.00798,10.96051,0.37657>,
            
    /*2*/ <-0.19342,11.07797,0.71788>,<-0.18154,11.08026,0.72384>,<-0.1871,11.06799,0.72438>,
            
    /*3*/ <-0.3354,11.30768,1.02979>,<-0.32912,11.30852,1.03209>,<-0.33282,11.30332,1.03424>,
            
    /*4*/ <-0.36912,11.63428,1.2806>

    /* stem 0.44.8*/ 
    /*0*/ <0.00939,11.04005,0.41267>,
    /*1*/ <0.02074,11.03995,0.41233>,<0.00402,11.04101,0.42262>,<0.00342,11.03919,0.40305>,
            
    /*2*/ <0.01946,11.44174,0.37506>,<0.00831,11.44245,0.38192>,<0.00791,11.44124,0.36888>,
            
    /*3*/ <-0.05849,11.83168,0.45197>,<-0.06396,11.83001,0.45516>,<-0.06417,11.83124,0.44873>,
            
    /*4*/ <-0.15831,12.2117,0.54485>

    /* stem 0.44.9*/ 
    /*0*/ <0.01512,11.16434,0.4646>,
    /*1*/ <0.00706,11.16296,0.47167>,<0.01493,11.17269,0.45776>,<0.02337,11.15736,0.46438>,
            
    /*2*/ <0.19977,11.37975,0.72817>,<0.20501,11.38624,0.71889>,<0.21063,11.37602,0.72331>,
            
    /*3*/ <0.37085,11.60336,0.99341>,<0.37353,11.60674,0.9889>,<0.37646,11.60174,0.99122>,
            
    /*4*/ <0.46772,11.90886,1.21045>

    /* stem 0.44.10*/ 
    /*0*/ <0.02433,11.30717,0.503>,
    /*1*/ <0.02581,11.3097,0.49322>,<0.0297,11.31181,0.51035>,<0.01748,11.29999,0.50544>,
            
    /*2*/ <-0.23643,11.56806,0.52414>,<-0.23383,11.56946,0.53555>,<-0.24197,11.56159,0.53228>,
            
    /*3*/ <-0.39026,11.8855,0.63676>,<-0.38799,11.88475,0.64215>,<-0.39333,11.88261,0.64088>,
            
    /*4*/ <-0.47841,12.22396,0.75549>

    /* stem 0.44.11*/ 
    /*0*/ <0.03276,11.43798,0.53818>,
    /*1*/ <0.03783,11.43554,0.54604>,<0.02561,11.44447,0.53885>,<0.03484,11.43394,0.52964>,
            
    /*2*/ <0.2656,11.69622,0.47627>,<0.25745,11.70217,0.47147>,<0.2636,11.69515,0.46533>,
            
    /*3*/ <0.49347,11.95679,0.53561>,<0.48993,11.96046,0.53333>,<0.49372,11.95788,0.53014>,
            
    /*4*/ <0.72744,12.18852,0.66136>

    /* stem 0.44.12*/ 
    /*0*/ <0.03823,11.52281,0.56098>,
    /*1*/ <0.02939,11.5241,0.55829>,<0.04478,11.52901,0.55861>,<0.04052,11.51532,0.56605>,
            
    /*2*/ <-0.02954,11.69915,0.8468>,<-0.01928,11.70242,0.84701>,<-0.02212,11.69329,0.85197>,
            
    /*3*/ <-0.05069,12.01062,0.98668>,<-0.04541,12.01136,0.98594>,<-0.04721,12.00918,0.99052>,
            
    /*4*/ <-0.0168,12.33506,1.09247>

    /* stem 0.44.13*/ 
    /*0*/ <0.04311,11.63758,0.58894>,
    /*1*/ <0.05133,11.63824,0.58568>,<0.04085,11.64215,0.59619>,<0.03716,11.63236,0.58495>,
            
    /*2*/ <-0.0462,11.88984,0.39857>,<-0.05319,11.89245,0.40558>,<-0.05564,11.88592,0.39809>,
            
    /*3*/ <-0.11791,12.18008,0.26312>,<-0.12129,12.18103,0.26684>,<-0.1228,12.17866,0.26257>,
            
    /*4*/ <-0.18107,12.49414,0.19049>

    /* stem 0.44.14*/ 
    /*0*/ <0.0427,11.73394,0.60722>,
    /*1*/ <0.03873,11.73253,0.61458>,<0.03936,11.7393,0.60155>,<0.05002,11.73,0.60552>,
            
    /*2*/ <0.19962,11.97237,0.74428>,<0.20005,11.97688,0.73559>,<0.20715,11.97068,0.73824>,
            
    /*3*/ <0.28778,12.24275,0.88192>,<0.28791,12.24497,0.87756>,<0.29192,12.24277,0.87931>,
            
    /*4*/ <0.35448,12.51651,1.02597>

    /* stem 0.44.15*/ 
    /*0*/ <0.04216,11.86141,0.63139>,
    /*1*/ <0.04049,11.86286,0.62372>,<0.04691,11.86639,0.63545>,<0.03908,11.85499,0.635>,
            
    /*2*/ <-0.19904,12.02403,0.70894>,<-0.19476,12.02638,0.71677>,<-0.19998,12.01878,0.71647>,
            
    /*3*/ <-0.36371,12.27382,0.69811>,<-0.36175,12.27532,0.70201>,<-0.3656,12.27279,0.70219>,
            
    /*4*/ <-0.44066,12.56103,0.74853>

    /* stem 0.44.16*/ 
    /*0*/ <0.04165,11.98036,0.65395>,
    /*1*/ <0.04729,11.97956,0.65827>,<0.03643,11.98491,0.65569>,<0.04124,11.9766,0.64788>,
            
    /*2*/ <0.18177,12.18989,0.51772>,<0.17453,12.19345,0.516>,<0.17774,12.18792,0.51079>,
            
    /*3*/ <0.35592,12.41089,0.47218>,<0.35269,12.41327,0.47119>,<0.35465,12.41112,0.46826>,
            
    /*4*/ <0.43512,12.67447,0.55146>

    /* stem 0.44.17*/ 
    /*0*/ <0.04126,12.07149,0.67123>,
    /*1*/ <0.03514,12.07142,0.67144>,<0.04417,12.07556,0.66768>,<0.04449,12.06749,0.67458>,
            
    /*2*/ <0.04244,12.25039,0.88058>,<0.04846,12.25315,0.87807>,<0.04868,12.24777,0.88267>,
            
    /*3*/ <0.05613,12.50566,0.98335>,<0.05911,12.50626,0.98155>,<0.05926,12.50493,0.98483>,
            
    /*4*/ <0.00786,12.7626,1.06837>

    /* stem 0.44.18*/ 
    /*0*/ <0.03925,12.15783,0.68768>,
    /*1*/ <0.04308,12.15864,0.6843>,<0.03915,12.16046,0.69214>,<0.03553,12.15441,0.68661>,
            
    /*2*/ <-0.10047,12.34934,0.56964>,<-0.10309,12.35056,0.57486>,<-0.1055,12.34653,0.57118>,
            
    /*3*/ <-0.20475,12.55031,0.43343>,<-0.20621,12.55122,0.43587>,<-0.2075,12.54928,0.43399>,
            
    /*4*/ <-0.17317,12.79014,0.32721>

    /* stem 0.44.19*/ 
    /*0*/ <0.03469,12.27154,0.70944>,
    /*1*/ <0.03416,12.27079,0.71323>,<0.03222,12.2739,0.70755>,<0.03769,12.26992,0.70753>,
            
    /*2*/ <0.17817,12.46801,0.77083>,<0.17687,12.47009,0.76705>,<0.18052,12.46743,0.76703>,
            
    /*3*/ <0.33578,12.6632,0.78607>,<0.33498,12.66401,0.78412>,<0.33674,12.6626,0.78413>,
            
    /*4*/ <0.39318,12.9067,0.80489>

    /* stem 0.44.20*/ 
    /*0*/ <0.02843,12.42784,0.73934>,
    /*1*/ <0.02727,12.42814,0.73753>,<0.03001,12.42922,0.73985>,<0.02799,12.42616,0.74064>,
            
    /*2*/ <-0.12348,12.55832,0.85607>,<-0.12165,12.55904,0.85762>,<-0.123,12.55701,0.85814>,
            
    /*3*/ <-0.26015,12.73578,0.91451>,<-0.25928,12.7362,0.9153>,<-0.26014,12.73539,0.9157>,
            
    /*4*/ <-0.39461,12.90385,1.00074>

    /* stem 0.44.21*/ 
    /*0*/ <0.0238,12.54327,0.76142>,
    /*1*/ <0.02464,12.54325,0.76169>,<0.02322,12.5438,0.76181>,<0.02354,12.54275,0.76076>,
            
    /*2*/ <0.07385,12.70005,0.61896>,<0.07291,12.70043,0.61904>,<0.07312,12.69972,0.61834>,
            
    /*3*/ <0.12091,12.90205,0.55308>,<0.12042,12.90219,0.55315>,<0.12057,12.90201,0.5527>,
            
    /*4*/ <0.16299,13.11011,0.50489>

    /* stem 0.45*/ 
    /*0*/ <0.01107,10.37225,-0.10208>,
    /*1*/ <0.03237,10.37218,-0.11997>,<0.03104,10.3886,-0.09172>,<0.00212,10.38242,-0.07779>,
            <-0.01443,10.36218,-0.09742>,<0.00426,10.35585,-0.12349>,
    /*2*/ <-0.1746,10.77335,-0.35918>,<-0.17566,10.78648,-0.33658>,<-0.1988,10.78154,-0.32544>,
            <-0.21204,10.76534,-0.34114>,<-0.19708,10.76028,-0.36199>,
    /*3*/ <-0.37892,11.20818,-0.53755>,<-0.37876,11.21581,-0.51948>,<-0.39588,11.21151,-0.51093>,
            <-0.40663,11.20122,-0.52371>,<-0.39615,11.19916,-0.54016>,
    /*4*/ <-0.51933,11.68869,-0.63962>,<-0.51847,11.69173,-0.62693>,<-0.53017,11.68961,-0.62147>,
            <-0.53826,11.68527,-0.63078>,<-0.53156,11.6847,-0.642>,
    /*5*/ <-0.62142,12.18729,-0.68594>,<-0.62081,12.18806,-0.67947>,<-0.6267,12.18717,-0.67677>,
            <-0.63095,12.18586,-0.68157>,<-0.62768,12.18593,-0.68723>,
    /*6*/ <-0.66898,12.69575,-0.67197>

    /* stem 0.45.0*/ 
    /*0*/ <-0.02469,10.44303,-0.14492>,
    /*1*/ <-0.02853,10.4489,-0.13201>,<-0.03354,10.44445,-0.15655>,<-0.01201,10.43573,-0.14618>,
            
    /*2*/ <0.20484,10.87201,-0.26074>,<0.2015,10.86904,-0.27709>,<0.21585,10.86323,-0.27018>,
            
    /*3*/ <0.25172,11.35677,-0.36564>,<0.24985,11.35527,-0.37377>,<0.25791,11.35505,-0.37117>,
            
    /*4*/ <0.26058,11.85446,-0.3355>

    /* stem 0.45.1*/ 
    /*0*/ <-0.07905,10.55059,-0.21001>,
    /*1*/ <-0.0842,10.54198,-0.21993>,<-0.07099,10.56157,-0.2137>,<-0.08195,10.54822,-0.19641>,
            
    /*2*/ <-0.47688,10.82239,-0.25243>,<-0.46807,10.83545,-0.24828>,<-0.47537,10.82655,-0.23675>,
            
    /*3*/ <-0.78023,11.1885,-0.34529>,<-0.77459,11.19387,-0.34291>,<-0.77988,11.19085,-0.3375>,
            
    /*4*/ <-0.98171,11.61904,-0.43835>

    /* stem 0.45.2*/ 
    /*0*/ <-0.13164,10.65467,-0.27301>,
    /*1*/ <-0.12051,10.66192,-0.27032>,<-0.14383,10.66058,-0.27262>,<-0.13058,10.64152,-0.27609>,
            
    /*2*/ <-0.08597,10.76876,-0.72435>,<-0.10152,10.76786,-0.72588>,<-0.09268,10.75515,-0.7282>,
            
    /*3*/ <-0.11543,11.03008,-1.1101>,<-0.12323,11.02938,-1.11006>,<-0.11884,11.02417,-1.11392>,
            
    /*4*/ <-0.22914,11.37795,-1.40132>

    /* stem 0.45.3*/ 
    /*0*/ <-0.15948,10.70977,-0.30636>,
    /*1*/ <-0.17132,10.70699,-0.30106>,<-0.15864,10.71383,-0.31895>,<-0.14849,10.70848,-0.29905>,
            
    /*2*/ <-0.20806,11.14406,-0.16483>,<-0.1996,11.14863,-0.17676>,<-0.19284,11.14506,-0.16349>,
            
    /*3*/ <-0.13267,11.59958,-0.14436>,<-0.1283,11.5992,-0.15063>,<-0.12514,11.59836,-0.1437>,
            
    /*4*/ <-0.09836,12.04989,-0.22834>

    /* stem 0.45.4*/ 
    /*0*/ <-0.20491,10.80224,-0.35693>,
    /*1*/ <-0.19841,10.80066,-0.36783>,<-0.20589,10.81386,-0.3517>,<-0.21041,10.79219,-0.35126>,
            
    /*2*/ <-0.57343,10.87419,-0.59677>,<-0.57842,10.88299,-0.58602>,<-0.58143,10.86854,-0.58573>,
            
    /*3*/ <-0.77595,11.20604,-0.81255>,<-0.77715,11.20954,-0.80616>,<-0.78216,11.20479,-0.80877>,
            
    /*4*/ <-0.9375,11.56581,-1.01948>

    /* stem 0.45.5*/ 
    /*0*/ <-0.24816,10.89623,-0.39626>,
    /*1*/ <-0.24687,10.90146,-0.38517>,<-0.25875,10.89746,-0.40246>,<-0.23887,10.88977,-0.40115>,
            
    /*2*/ <-0.09599,11.25876,-0.57589>,<-0.1039,11.25609,-0.58742>,<-0.09065,11.25096,-0.58654>,
            
    /*3*/ <0.08006,11.59383,-0.78546>,<0.07615,11.59236,-0.79122>,<0.08259,11.58945,-0.79046>,
            
    /*4*/ <0.15558,12.01552,-0.8283>

    /* stem 0.45.6*/ 
    /*0*/ <-0.29159,10.99059,-0.43574>,
    /*1*/ <-0.29952,10.98433,-0.44198>,<-0.28537,10.99922,-0.44101>,<-0.28987,10.98821,-0.42424>,
            
    /*2*/ <-0.59482,11.26274,-0.33838>,<-0.58539,11.27267,-0.33774>,<-0.58839,11.26533,-0.32655>,
            
    /*3*/ <-0.84059,11.60161,-0.31438>,<-0.83507,11.60567,-0.3142>,<-0.83778,11.6033,-0.30836>,
            
    /*4*/ <-1.04002,11.9702,-0.32223>

    /* stem 0.45.7*/ 
    /*0*/ <-0.33671,11.08863,-0.47676>,
    /*1*/ <-0.32623,11.093,-0.47784>,<-0.34524,11.09514,-0.47291>,<-0.33866,11.07774,-0.47953>,
            
    /*2*/ <-0.41554,11.20357,-0.85709>,<-0.42821,11.205,-0.85381>,<-0.42382,11.19339,-0.85822>,
            
    /*3*/ <-0.48883,11.4657,-1.15535>,<-0.49507,11.46631,-1.15335>,<-0.49347,11.46171,-1.15778>,
            
    /*4*/ <-0.5962,11.79949,-1.3582>

    /* stem 0.45.8*/ 
    /*0*/ <-0.37424,11.17018,-0.51088>,
    /*1*/ <-0.38239,11.16952,-0.5035>,<-0.37657,11.17183,-0.52152>,<-0.36376,11.16918,-0.50763>,
            
    /*2*/ <-0.36025,11.55868,-0.4497>,<-0.35637,11.56022,-0.46171>,<-0.34783,11.55846,-0.45245>,
            
    /*3*/ <-0.36773,11.9469,-0.52009>,<-0.3657,11.94592,-0.52604>,<-0.3615,11.94685,-0.52135>,
            
    /*4*/ <-0.40939,12.29483,-0.70011>

    /* stem 0.45.9*/ 
    /*0*/ <-0.40648,11.26085,-0.53818>,
    /*1*/ <-0.40469,11.25909,-0.54849>,<-0.40206,11.26922,-0.53338>,<-0.4127,11.25425,-0.53267>,
            
    /*2*/ <-0.70955,11.47171,-0.63409>,<-0.7078,11.47847,-0.62401>,<-0.71489,11.46849,-0.62354>,
            
    /*3*/ <-0.81964,11.83474,-0.67901>,<-0.81741,11.83615,-0.67348>,<-0.82323,11.83431,-0.67407>,
            
    /*4*/ <-0.74246,12.20389,-0.7339>

    /* stem 0.45.10*/ 
    /*0*/ <-0.4402,11.3798,-0.56435>,
    /*1*/ <-0.43534,11.38299,-0.55608>,<-0.44933,11.3835,-0.56659>,<-0.43592,11.3729,-0.57037>,
            
    /*2*/ <-0.28064,11.64941,-0.75414>,<-0.28997,11.64975,-0.76114>,<-0.28103,11.64269,-0.76366>,
            
    /*3*/ <-0.17175,11.97494,-0.87884>,<-0.17643,11.97522,-0.88232>,<-0.17148,11.97282,-0.88427>,
            
    /*4*/ <-0.15292,12.33905,-0.90803>

    /* stem 0.45.11*/ 
    /*0*/ <-0.47275,11.49464,-0.58962>,
    /*1*/ <-0.48146,11.49158,-0.59233>,<-0.46843,11.50176,-0.59445>,<-0.46836,11.49059,-0.58207>,
            
    /*2*/ <-0.62799,11.72848,-0.37777>,<-0.6193,11.73527,-0.37919>,<-0.61925,11.72782,-0.37094>,
            
    /*3*/ <-0.77592,12.02129,-0.25168>,<-0.77127,12.02415,-0.25274>,<-0.77195,12.02168,-0.24781>,
            
    /*4*/ <-0.93006,12.32109,-0.15212>

    /* stem 0.45.12*/ 
    /*0*/ <-0.50445,11.60649,-0.61423>,
    /*1*/ <-0.49616,11.60807,-0.61777>,<-0.50805,11.61237,-0.6082>,<-0.50916,11.59904,-0.61672>,
            
    /*2*/ <-0.63968,11.78091,-0.86942>,<-0.64761,11.78378,-0.86303>,<-0.64835,11.7749,-0.86872>,
            
    /*3*/ <-0.77042,12.02356,-1.06386>,<-0.7741,12.02457,-1.06021>,<-0.77505,12.02101,-1.064>,
            
    /*4*/ <-0.90222,12.30814,-1.18865>

    /* stem 0.45.13*/ 
    /*0*/ <-0.53791,11.74072,-0.63745>,
    /*1*/ <-0.54196,11.74069,-0.62985>,<-0.54191,11.74377,-0.64444>,<-0.52987,11.73771,-0.63806>,
            
    /*2*/ <-0.4261,12.03347,-0.57019>,<-0.42607,12.03552,-0.57992>,<-0.41804,12.03148,-0.57566>,
            
    /*3*/ <-0.377,12.33812,-0.4872>,<-0.37699,12.33946,-0.49199>,<-0.37274,12.33817,-0.48976>,
            
    /*4*/ <-0.4547,12.64911,-0.49167>

    /* stem 0.45.14*/ 
    /*0*/ <-0.56083,11.85747,-0.64916>,
    /*1*/ <-0.56241,11.85636,-0.65708>,<-0.55601,11.86359,-0.64678>,<-0.56407,11.85244,-0.64362>,
            
    /*2*/ <-0.80609,12.03985,-0.63125>,<-0.80182,12.04467,-0.62438>,<-0.80719,12.03724,-0.62227>,
            
    /*3*/ <-0.99496,12.27962,-0.60345>,<-0.99223,12.28142,-0.60007>,<-0.99576,12.27852,-0.59895>,
            
    /*4*/ <-1.11254,12.56218,-0.59645>

    /* stem 0.45.15*/ 
    /*0*/ <-0.57201,11.91439,-0.65487>,
    /*1*/ <-0.56593,11.91607,-0.65007>,<-0.57911,11.91766,-0.65356>,<-0.57099,11.90945,-0.66098>,
            
    /*2*/ <-0.49383,12.14684,-0.8262>,<-0.50262,12.1479,-0.82853>,<-0.49721,12.14243,-0.83348>,
            
    /*3*/ <-0.42538,12.42892,-0.89283>,<-0.42973,12.42974,-0.894>,<-0.42675,12.42827,-0.89715>,
            
    /*4*/ <-0.50788,12.71059,-0.95523>

    /* stem 0.45.16*/ 
    /*0*/ <-0.59378,12.02523,-0.66599>,
    /*1*/ <-0.601,12.02385,-0.66567>,<-0.59102,12.02916,-0.67158>,<-0.5893,12.0227,-0.66071>,
            
    /*2*/ <-0.63812,12.26458,-0.51672>,<-0.63147,12.26812,-0.52066>,<-0.63032,12.26381,-0.51341>,
            
    /*3*/ <-0.67974,12.51303,-0.38243>,<-0.67641,12.51472,-0.38446>,<-0.67586,12.51279,-0.38071>,
            
    /*4*/ <-0.77483,12.78185,-0.38283>

    /* stem 0.45.17*/ 
    /*0*/ <-0.61764,12.14678,-0.67818>,
    /*1*/ <-0.61322,12.14724,-0.68222>,<-0.61825,12.15095,-0.67389>,<-0.62146,12.14215,-0.67842>,
            
    /*2*/ <-0.77762,12.28993,-0.84291>,<-0.78097,12.2924,-0.83736>,<-0.78311,12.28653,-0.84038>,
            
    /*3*/ <-0.95057,12.47341,-0.94283>,<-0.95172,12.4741,-0.93963>,<-0.95324,12.47163,-0.94153>,
            
    /*4*/ <-1.03691,12.72875,-0.96543>

    /* stem 0.45.18*/ 
    /*0*/ <-0.63066,12.24716,-0.68098>,
    /*1*/ <-0.63131,12.24701,-0.67613>,<-0.63366,12.24986,-0.68378>,<-0.62702,12.24462,-0.68305>,
            
    /*2*/ <-0.47367,12.45008,-0.65028>,<-0.47523,12.45198,-0.65538>,<-0.4708,12.44849,-0.65489>,
            
    /*3*/ <-0.34325,12.67329,-0.64397>,<-0.34422,12.67394,-0.64655>,<-0.34179,12.67251,-0.64627>,
            
    /*4*/ <-0.27168,12.91826,-0.68591>

    /* stem 0.45.19*/ 
    /*0*/ <-0.64084,12.36635,-0.67859>,
    /*1*/ <-0.64276,12.36625,-0.68163>,<-0.63832,12.36888,-0.67814>,<-0.64145,12.36393,-0.676>,
            
    /*2*/ <-0.8082,12.51468,-0.5809>,<-0.80523,12.51643,-0.57857>,<-0.80732,12.51313,-0.57714>,
            
    /*3*/ <-0.9269,12.7272,-0.57551>,<-0.92536,12.72804,-0.5744>,<-0.92696,12.72712,-0.57344>,
            
    /*4*/ <-0.97431,12.96649,-0.58504>

    /* stem 0.45.20*/ 
    /*0*/ <-0.6538,12.518,-0.67554>,
    /*1*/ <-0.65195,12.51814,-0.67495>,<-0.65519,12.51903,-0.67466>,<-0.65426,12.51682,-0.67702>,
            
    /*2*/ <-0.61925,12.68745,-0.82065>,<-0.62141,12.68804,-0.82045>,<-0.62078,12.68657,-0.82203>,
            
    /*3*/ <-0.62962,12.87434,-0.94719>,<-0.63071,12.87444,-0.94696>,<-0.63038,12.87385,-0.94786>,
            
    /*4*/ <-0.62569,13.06987,-1.05985>

    /* stem 0.45.21*/ 
    /*0*/ <-0.66497,12.64875,-0.67291>,
    /*1*/ <-0.66544,12.6487,-0.67272>,<-0.66486,12.64912,-0.67325>,<-0.6646,12.64841,-0.67277>,
            
    /*2*/ <-0.61161,12.77458,-0.51348>,<-0.61123,12.77486,-0.51383>,<-0.61105,12.77439,-0.51352>,
            
    /*3*/ <-0.57677,12.9534,-0.40901>,<-0.57659,12.95349,-0.40923>,<-0.57648,12.95334,-0.409>,
            
    /*4*/ <-0.54435,13.15287,-0.35185>

    /* stem 0.46*/ 
    /*0*/ <0.00138,10.58786,-0.11441>,
    /*1*/ <-0.00332,10.58917,-0.08784>,<-0.02215,10.60059,-0.11072>,<-0.00846,10.59442,-0.13869>,
            <0.01883,10.57918,-0.13311>,<0.022,10.57594,-0.10168>,
    /*2*/ <0.23717,11.02556,-0.07225>,<0.2221,11.0347,-0.09054>,<0.23306,11.02977,-0.11292>,
            <0.25489,11.01758,-0.10846>,<0.25743,11.01498,-0.08332>,
    /*3*/ <0.39946,11.49698,-0.07339>,<0.38707,11.50134,-0.08718>,<0.39568,11.49854,-0.10394>,
            <0.4134,11.49245,-0.1005>,<0.41574,11.49148,-0.08162>,
    /*4*/ <0.50342,11.9821,-0.13654>,<0.49464,11.98288,-0.14568>,<0.50028,11.98036,-0.15677>,
            <0.51256,11.97802,-0.15449>,<0.5145,11.9791,-0.14199>,
    /*5*/ <0.50243,12.47882,-0.16075>,<0.49795,12.47863,-0.16524>,<0.50083,12.47843,-0.17089>,
            <0.5071,12.47849,-0.16989>,<0.50809,12.47873,-0.16363>,
    /*6*/ <0.42522,12.96893,-0.21067>

    /* stem 0.46.0*/ 
    /*0*/ <0.05629,10.68796,-0.10962>,
    /*1*/ <0.05036,10.6918,-0.12188>,<0.07027,10.68923,-0.10781>,<0.04825,10.68285,-0.09916>,
            
    /*2*/ <-0.0104,11.13975,0.05328>,<0.00288,11.13803,0.06265>,<-0.01181,11.13379,0.06842>,
            
    /*3*/ <-0.03138,11.56958,0.27926>,<-0.02474,11.56769,0.28362>,<-0.03216,11.56583,0.28648>,
            
    /*4*/ <0.03094,12.03335,0.4037>

    /* stem 0.46.1*/ 
    /*0*/ <0.08928,10.74808,-0.10674>,
    /*1*/ <0.10059,10.74165,-0.10197>,<0.08564,10.76043,-0.10159>,<0.0816,10.74217,-0.11665>,
            
    /*2*/ <0.36019,10.96009,-0.43664>,<0.35022,10.97261,-0.43639>,<0.34753,10.96044,-0.44642>,
            
    /*3*/ <0.57232,11.28593,-0.71451>,<0.56632,11.29106,-0.71319>,<0.56598,11.286,-0.71939>,
            
    /*4*/ <0.84858,11.67169,-0.74738>

    /* stem 0.46.2*/ 
    /*0*/ <0.15819,10.87371,-0.10072>,
    /*1*/ <0.14717,10.87954,-0.09622>,<0.16562,10.87975,-0.1099>,<0.1618,10.86183,-0.09604>,
            
    /*2*/ <0.3944,11.0822,0.23364>,<0.4067,11.08234,0.22452>,<0.40416,11.0704,0.23376>,
            
    /*3*/ <0.56044,11.48078,0.38504>,<0.56613,11.48043,0.37993>,<0.56705,11.47739,0.3869>,
            
    /*4*/ <0.64451,11.92912,0.43352>

    /* stem 0.46.3*/ 
    /*0*/ <0.21985,10.9861,-0.09534>,
    /*1*/ <0.22568,10.98343,-0.10634>,<0.22669,10.98977,-0.08524>,<0.20719,10.9851,-0.09443>,
            
    /*2*/ <0.18122,11.40807,-0.228>,<0.18189,11.41229,-0.21394>,<0.1689,11.40918,-0.22006>,
            
    /*3*/ <0.12847,11.84793,-0.27347>,<0.1288,11.84879,-0.26618>,<0.12232,11.84767,-0.26946>,
            
    /*4*/ <0.11805,12.28929,-0.31851>

    /* stem 0.46.4*/ 
    /*0*/ <0.26093,11.083,-0.09298>,
    /*1*/ <0.26284,11.08224,-0.08086>,<0.25411,11.09214,-0.09757>,<0.26585,11.07462,-0.10052>,
            
    /*2*/ <0.61567,11.32624,-0.12527>,<0.60985,11.33284,-0.13641>,<0.61768,11.32116,-0.13838>,
            
    /*3*/ <0.92925,11.61704,-0.18425>,<0.92572,11.61983,-0.18974>,<0.93038,11.61458,-0.19082>,
            
    /*4*/ <1.1837,11.9573,-0.25985>

    /* stem 0.46.5*/ 
    /*0*/ <0.31035,11.22747,-0.0917>,
    /*1*/ <0.30196,11.2304,-0.09927>,<0.3213,11.23115,-0.09341>,<0.3078,11.22084,-0.08244>,
            
    /*2*/ <0.22465,11.56906,0.12402>,<0.23754,11.56956,0.12793>,<0.22854,11.56269,0.13524>,
            
    /*3*/ <0.19462,11.93528,0.31265>,<0.20115,11.93502,0.31432>,<0.19649,11.93249,0.31849>,
            
    /*4*/ <0.16,12.34547,0.31901>

    /* stem 0.46.6*/ 
    /*0*/ <0.35166,11.34822,-0.09064>,
    /*1*/ <0.36222,11.34461,-0.09056>,<0.34861,11.35666,-0.08401>,<0.34416,11.34339,-0.09734>,
            
    /*2*/ <0.44933,11.6046,-0.37853>,<0.44026,11.61264,-0.37416>,<0.43729,11.60379,-0.38304>,
            
    /*3*/ <0.54607,11.94163,-0.56664>,<0.54121,11.94471,-0.56374>,<0.54026,11.94182,-0.56941>,
            
    /*4*/ <0.6494,12.31252,-0.66621>

    /* stem 0.46.7*/ 
    /*0*/ <0.38677,11.45085,-0.08973>,
    /*1*/ <0.37894,11.45347,-0.0829>,<0.38948,11.45759,-0.09761>,<0.3919,11.44149,-0.08868>,
            
    /*2*/ <0.63931,11.61978,0.14618>,<0.64633,11.62252,0.13637>,<0.64794,11.6118,0.14233>,
            
    /*3*/ <0.87492,11.86848,0.32087>,<0.87793,11.86943,0.31555>,<0.8798,11.86496,0.3194>,
            
    /*4*/ <1.0507,12.18602,0.44727>

    /* stem 0.46.8*/ 
    /*0*/ <0.41462,11.55435,-0.09627>,
    /*1*/ <0.4162,11.55281,-0.10632>,<0.42134,11.55988,-0.09079>,<0.40632,11.55034,-0.09169>,
            
    /*2*/ <0.22403,11.86227,-0.18018>,<0.22746,11.86698,-0.16983>,<0.21745,11.86062,-0.17044>,
            
    /*3*/ <0.02407,12.1755,-0.20675>,<0.02607,12.17728,-0.20145>,<0.02109,12.17407,-0.20181>,
            
    /*4*/ <-0.1162,12.51955,-0.21943>

    /* stem 0.46.9*/ 
    /*0*/ <0.42841,11.61931,-0.10402>,
    /*1*/ <0.43346,11.61927,-0.09536>,<0.4211,11.62599,-0.10552>,<0.43068,11.61266,-0.11117>,
            
    /*2*/ <0.67345,11.85223,-0.23813>,<0.66521,11.85671,-0.2449>,<0.67159,11.84782,-0.24867>,
            
    /*3*/ <0.82497,12.18078,-0.26194>,<0.82052,12.18265,-0.26514>,<0.82516,12.18032,-0.26771>,
            
    /*4*/ <0.93428,12.52161,-0.20066>

    /* stem 0.46.10*/ 
    /*0*/ <0.44996,11.72082,-0.11612>,
    /*1*/ <0.44107,11.72231,-0.11945>,<0.45753,11.72422,-0.12096>,<0.45127,11.71594,-0.10795>,
            
    /*2*/ <0.42609,12.02155,0.06363>,<0.43706,12.02281,0.06262>,<0.43289,12.0173,0.07129>,
            
    /*3*/ <0.32769,12.34805,0.1376>,<0.33297,12.34974,0.13731>,<0.33087,12.34802,0.14215>,
            
    /*4*/ <0.3301,12.69965,0.14524>

    /* stem 0.46.11*/ 
    /*0*/ <0.47041,11.81716,-0.12761>,
    /*1*/ <0.47883,11.815,-0.13068>,<0.46934,11.82395,-0.12148>,<0.46306,11.81252,-0.13068>,
            
    /*2*/ <0.44088,12.03882,-0.38274>,<0.43455,12.04479,-0.37661>,<0.43036,12.03716,-0.38274>,
            
    /*3*/ <0.45996,12.3605,-0.48981>,<0.45679,12.36206,-0.48583>,<0.45468,12.36063,-0.4905>,
            
    /*4*/ <0.51148,12.69505,-0.51228>

    /* stem 0.46.12*/ 
    /*0*/ <0.49531,11.93449,-0.14161>,
    /*1*/ <0.49116,11.93626,-0.13412>,<0.49451,11.93989,-0.14844>,<0.50027,11.92731,-0.14227>,
            
    /*2*/ <0.75027,12.10431,-0.03375>,<0.7525,12.10673,-0.0433>,<0.75634,12.09834,-0.03919>,
            
    /*3*/ <0.96776,12.34179,-0.08754>,<0.96707,12.34134,-0.09252>,<0.97064,12.3386,-0.09021>,
            
    /*4*/ <1.07228,12.62154,-0.2155>

    /* stem 0.46.13*/ 
    /*0*/ <0.50474,12.07351,-0.15064>,
    /*1*/ <0.50318,12.07319,-0.15869>,<0.51089,12.07816,-0.14783>,<0.50016,12.06917,-0.1454>,
            
    /*2*/ <0.31068,12.31147,-0.12782>,<0.31581,12.31478,-0.12058>,<0.30866,12.30878,-0.11896>,
            
    /*3*/ <0.16451,12.58198,-0.11497>,<0.16728,12.58335,-0.11138>,<0.16321,12.5811,-0.11051>,
            
    /*4*/ <0.0617,12.85761,-0.02158>

    /* stem 0.46.14*/ 
    /*0*/ <0.50448,12.14789,-0.15347>,
    /*1*/ <0.51063,12.1481,-0.14849>,<0.49861,12.15317,-0.15276>,<0.50418,12.1424,-0.15917>,
            
    /*2*/ <0.65253,12.33297,-0.33572>,<0.64452,12.33635,-0.33857>,<0.64823,12.32917,-0.34284>,
            
    /*3*/ <0.77737,12.58572,-0.43277>,<0.77328,12.58729,-0.43405>,<0.77583,12.5849,-0.43699>,
            
    /*4*/ <0.8104,12.84586,-0.57812>

    /* stem 0.46.15*/ 
    /*0*/ <0.5039,12.30659,-0.15952>,
    /*1*/ <0.49664,12.30657,-0.1594>,<0.50745,12.3111,-0.16398>,<0.50762,12.3021,-0.15519>,
            
    /*2*/ <0.50187,12.50226,0.04063>,<0.50908,12.50528,0.03758>,<0.5092,12.49928,0.04344>,
            
    /*3*/ <0.45416,12.76023,0.13558>,<0.45775,12.76156,0.13386>,<0.45772,12.76011,0.1378>,
            
    /*4*/ <0.34701,12.99636,0.23949>

    /* stem 0.46.16*/ 
    /*0*/ <0.50357,12.39959,-0.16307>,
    /*1*/ <0.50829,12.39945,-0.16717>,<0.50407,12.40297,-0.15782>,<0.49834,12.39635,-0.16421>,
            
    /*2*/ <0.40275,12.61222,-0.29285>,<0.39993,12.61457,-0.28662>,<0.39611,12.61016,-0.29087>,
            
    /*3*/ <0.33469,12.86642,-0.34865>,<0.33352,12.86687,-0.34526>,<0.33125,12.8657,-0.34782>,
            
    /*4*/ <0.30821,13.13302,-0.32585>

    /* stem 0.46.17*/ 
    /*0*/ <0.49046,12.55918,-0.1734>,
    /*1*/ <0.48973,12.55947,-0.16896>,<0.48747,12.56093,-0.1763>,<0.49417,12.55714,-0.17496>,
            
    /*2*/ <0.61161,12.777,-0.16467>,<0.6101,12.77798,-0.16956>,<0.61457,12.77545,-0.16867>,
            
    /*3*/ <0.65694,13.00351,-0.2614>,<0.65583,13.00279,-0.26365>,<0.65838,13.00243,-0.26328>,
            
    /*4*/ <0.68949,13.23033,-0.35983>

    /* stem 0.46.18*/ 
    /*0*/ <0.47819,12.63624,-0.18041>,
    /*1*/ <0.47634,12.63566,-0.18353>,<0.4807,12.63891,-0.18023>,<0.47752,12.63415,-0.17748>,
            
    /*2*/ <0.30775,12.79026,-0.11094>,<0.31065,12.79242,-0.10874>,<0.30853,12.78925,-0.10691>,
            
    /*3*/ <0.20019,13.00355,-0.12965>,<0.20178,13.00445,-0.1286>,<0.20011,13.0037,-0.12754>,
            
    /*4*/ <0.22138,13.23465,-0.19122>

    /* stem 0.46.19*/ 
    /*0*/ <0.45305,12.79414,-0.19477>,
    /*1*/ <0.45484,12.79449,-0.19416>,<0.45155,12.79498,-0.19389>,<0.45275,12.79297,-0.19627>,
            
    /*2*/ <0.46854,12.96611,-0.33227>,<0.46635,12.96644,-0.33208>,<0.46714,12.9651,-0.33367>,
            
    /*3*/ <0.44672,13.17588,-0.39744>,<0.44563,13.17583,-0.39724>,<0.44602,13.17556,-0.39825>,
            
    /*4*/ <0.45148,13.37796,-0.48597>

    /* stem 0.46.20*/ 
    /*0*/ <0.43973,12.87782,-0.20238>,
    /*1*/ <0.4388,12.87771,-0.20202>,<0.43989,12.87845,-0.20315>,<0.44049,12.87731,-0.20198>,
            
    /*2*/ <0.47339,13.03451,-0.06589>,<0.47412,13.03501,-0.06664>,<0.47452,13.03424,-0.06587>,
            
    /*3*/ <0.52954,13.23656,-0.04516>,<0.52985,13.23652,-0.04565>,<0.5301,13.2364,-0.04514>,
            
    /*4*/ <0.55421,13.44551,-0.03967>

    /* stem 0.47*/ 
    /*0*/ <-0.00413,10.71031,-0.12141>,
    /*1*/ <-0.01737,10.7084,-0.14435>,<0.01003,10.72273,-0.14013>,<0.01787,10.71989,-0.11004>,
            <-0.00469,10.7038,-0.09567>,<-0.02647,10.6967,-0.11687>,
    /*2*/ <-0.24977,11.12845,-0.03888>,<-0.22784,11.13992,-0.03551>,<-0.22157,11.13765,-0.01144>,
            <-0.23962,11.12478,0.00006>,<-0.25705,11.11909,-0.0169>,
    /*3*/ <-0.42466,11.58472,0.004>,<-0.40726,11.59132,0.00616>,<-0.4033,11.59132,0.02446>,
            <-0.41824,11.58473,0.03362>,<-0.43144,11.58065,0.02098>,
    /*4*/ <-0.47337,12.07477,0.02849>,<-0.46102,12.07601,0.02981>,<-0.45841,12.07579,0.04202>,
            <-0.46915,12.07441,0.04824>,<-0.47839,12.07379,0.03987>,
    /*5*/ <-0.47701,12.55868,-0.04894>,<-0.4708,12.55887,-0.04831>,<-0.46951,12.5599,-0.04229>,
            <-0.47492,12.56036,-0.0392>,<-0.47955,12.5596,-0.04331>,
    /*6*/ <-0.39322,13.04224,-0.08807>

    /* stem 0.47.0*/ 
    /*0*/ <-0.0492,10.79078,-0.10207>,
    /*1*/ <-0.03735,10.79619,-0.09695>,<-0.06136,10.79322,-0.0956>,<-0.04888,10.78294,-0.11365>,
            
    /*2*/ <-0.10491,11.18759,-0.3668>,<-0.12092,11.18562,-0.3659>,<-0.11259,11.17876,-0.37793>,
            
    /*3*/ <-0.1683,11.59046,-0.61977>,<-0.17631,11.58953,-0.61937>,<-0.17217,11.58632,-0.62552>,
            
    /*4*/ <-0.29367,12.02611,-0.77824>

    /* stem 0.47.1*/ 
    /*0*/ <-0.09495,10.87247,-0.08243>,
    /*1*/ <-0.1058,10.86541,-0.07831>,<-0.09647,10.88279,-0.09115>,<-0.08258,10.86923,-0.07784>,
            
    /*2*/ <-0.15815,11.16335,0.27971>,<-0.15194,11.17493,0.27115>,<-0.14268,11.1659,0.28002>,
            
    /*3*/ <-0.29462,11.50041,0.57458>,<-0.29144,11.50587,0.56992>,<-0.28716,11.5026,0.57563>,
            
    /*4*/ <-0.51862,11.852,0.78799>

    /* stem 0.47.2*/ 
    /*0*/ <-0.16801,11.00292,-0.05107>,
    /*1*/ <-0.16314,11.00824,-0.06183>,<-0.16745,11.00936,-0.03985>,<-0.17345,10.99118,-0.05155>,
            
    /*2*/ <-0.56427,11.19479,-0.14625>,<-0.56715,11.19554,-0.13159>,<-0.57114,11.18342,-0.13939>,
            
    /*3*/ <-0.93923,11.44537,-0.14869>,<-0.93954,11.44507,-0.14123>,<-0.943,11.43986,-0.14533>,
            
    /*4*/ <-1.23079,11.78299,-0.20253>

    /* stem 0.47.3*/ 
    /*0*/ <-0.20079,11.06145,-0.03701>,
    /*1*/ <-0.19798,11.06007,-0.02473>,<-0.21236,11.06526,-0.04047>,<-0.19202,11.05901,-0.04582>,
            
    /*2*/ <-0.06527,11.48164,-0.01211>,<-0.07486,11.4851,-0.0226>,<-0.0613,11.48094,-0.02617>,
            
    /*3*/ <-0.01003,11.86996,0.18501>,<-0.01474,11.87306,0.18035>,<-0.0076,11.87285,0.17875>,
            
    /*4*/ <0.07488,12.2968,0.26883>

    /* stem 0.47.4*/ 
    /*0*/ <-0.26733,11.20228,-0.01446>,
    /*1*/ <-0.27605,11.19954,-0.02226>,<-0.26017,11.21171,-0.01652>,<-0.26577,11.19559,-0.00459>,
            
    /*2*/ <-0.5411,11.45019,0.19222>,<-0.53051,11.4583,0.19605>,<-0.53425,11.44756,0.204>,
            
    /*3*/ <-0.78267,11.79119,0.25072>,<-0.77707,11.79493,0.25242>,<-0.78063,11.79157,0.25734>,
            
    /*4*/ <-0.98869,12.15795,0.29879>

    /* stem 0.47.5*/ 
    /*0*/ <-0.30441,11.29749,-0.00645>,
    /*1*/ <-0.29359,11.30169,-0.00633>,<-0.31176,11.30013,0.00212>,<-0.30787,11.29064,-0.01516>,
            
    /*2*/ <-0.42302,11.6304,-0.21613>,<-0.43513,11.62937,-0.21049>,<-0.43254,11.62304,-0.22201>,
            
    /*3*/ <-0.62569,11.98727,-0.25165>,<-0.63084,11.98475,-0.24819>,<-0.63069,11.98417,-0.25486>,
            
    /*4*/ <-0.83044,12.34006,-0.2019>

    /* stem 0.47.6*/ 
    /*0*/ <-0.34318,11.39705,0.00192>,
    /*1*/ <-0.35103,11.39341,0.00898>,<-0.34595,11.40394,-0.00643>,<-0.33257,11.39382,0.0032>,
            
    /*2*/ <-0.28147,11.70794,0.24274>,<-0.27809,11.71496,0.23247>,<-0.26917,11.70822,0.23889>,
            
    /*3*/ <-0.18785,12.02558,0.46442>,<-0.18622,12.02886,0.45911>,<-0.18179,12.02537,0.46224>,
            
    /*4*/ <-0.17787,12.34746,0.69729>

    /* stem 0.47.7*/ 
    /*0*/ <-0.39046,11.51846,0.01212>,
    /*1*/ <-0.38893,11.51993,0.00169>,<-0.38788,11.52615,0.01902>,<-0.39458,11.50931,0.01565>,
            
    /*2*/ <-0.74137,11.66555,-0.02586>,<-0.74067,11.66969,-0.01431>,<-0.74514,11.65847,-0.01655>,
            
    /*3*/ <-0.91999,12.00313,-0.02256>,<-0.91829,12.00403,-0.01673>,<-0.92361,12.00122,-0.01798>,
            
    /*4*/ <-1.12488,12.31605,0.06039>

    /* stem 0.47.8*/ 
    /*0*/ <-0.42246,11.63895,0.01997>,
    /*1*/ <-0.4174,11.63912,0.02876>,<-0.43128,11.64388,0.01911>,<-0.41871,11.63385,0.01206>,
            
    /*2*/ <-0.23992,11.9404,-0.08338>,<-0.24917,11.94357,-0.08981>,<-0.24079,11.93688,-0.09451>,
            
    /*3*/ <-0.14826,12.29034,-0.14641>,<-0.15321,12.29114,-0.14942>,<-0.14836,12.28938,-0.15218>,
            
    /*4*/ <-0.13683,12.65643,-0.17383>

    /* stem 0.47.9*/ 
    /*0*/ <-0.43383,11.74762,0.02439>,
    /*1*/ <-0.44291,11.7468,0.02105>,<-0.4279,11.75438,0.02073>,<-0.43067,11.74167,0.03138>,
            
    /*2*/ <-0.55067,11.97678,0.26778>,<-0.54067,11.98183,0.26757>,<-0.54251,11.97335,0.27466>,
            
    /*3*/ <-0.62517,12.31164,0.35437>,<-0.61981,12.31308,0.35361>,<-0.62157,12.31138,0.35865>,
            
    /*4*/ <-0.66934,12.66256,0.37197>

    /* stem 0.47.10*/ 
    /*0*/ <-0.44242,11.82975,0.02772>,
    /*1*/ <-0.43366,11.83079,0.02454>,<-0.44555,11.83518,0.0347>,<-0.44805,11.82327,0.02394>,
            
    /*2*/ <-0.54778,12.06138,-0.20406>,<-0.5557,12.06431,-0.19728>,<-0.55737,12.05637,-0.20446>,
            
    /*3*/ <-0.62142,12.34708,-0.38034>,<-0.62528,12.34835,-0.37676>,<-0.62649,12.34535,-0.38111>,
            
    /*4*/ <-0.67981,12.66792,-0.49046>

    /* stem 0.47.11*/ 
    /*0*/ <-0.45484,11.94854,0.03255>,
    /*1*/ <-0.45926,11.94777,0.04025>,<-0.45767,11.9543,0.02636>,<-0.44761,11.94356,0.03104>,
            
    /*2*/ <-0.26829,12.18335,0.16992>,<-0.26723,12.1877,0.16065>,<-0.26052,12.18055,0.16377>,
            
    /*3*/ <-0.18919,12.50263,0.2018>,<-0.18935,12.50322,0.19669>,<-0.18494,12.5019,0.19898>,
            
    /*4*/ <-0.17716,12.8322,0.1949>

    /* stem 0.47.12*/ 
    /*0*/ <-0.46372,12.03339,0.036>,
    /*1*/ <-0.46522,12.03357,0.02755>,<-0.45801,12.03877,0.03946>,<-0.46793,12.02782,0.04098>,
            
    /*2*/ <-0.69593,12.24929,0.07623>,<-0.69112,12.25276,0.08417>,<-0.69773,12.24545,0.08519>,
            
    /*3*/ <-0.85756,12.50988,-0.00592>,<-0.8556,12.51234,-0.0021>,<-0.85986,12.50988,-0.00153>,
            
    /*4*/ <-0.91947,12.80913,-0.09931>

    /* stem 0.47.13*/ 
    /*0*/ <-0.46878,12.13017,0.02833>,
    /*1*/ <-0.4625,12.13113,0.03352>,<-0.47571,12.13444,0.02943>,<-0.46814,12.12495,0.02204>,
            
    /*2*/ <-0.35336,12.35708,-0.14479>,<-0.36216,12.35929,-0.14752>,<-0.35712,12.35296,-0.15245>,
            
    /*3*/ <-0.35732,12.64509,-0.25523>,<-0.362,12.64481,-0.25589>,<-0.35904,12.64352,-0.25936>,
            
    /*4*/ <-0.39853,12.94684,-0.29928>

    /* stem 0.47.14*/ 
    /*0*/ <-0.47072,12.27939,0.00305>,
    /*1*/ <-0.47835,12.27929,0.00306>,<-0.46695,12.28231,-0.00291>,<-0.46686,12.27656,0.00899>,
            
    /*2*/ <-0.4789,12.54015,0.129>,<-0.4713,12.54216,0.12502>,<-0.47124,12.53833,0.13295>,
            
    /*3*/ <-0.55431,12.78707,0.25741>,<-0.55072,12.78904,0.25579>,<-0.55055,12.78706,0.25972>,
            
    /*4*/ <-0.65785,13.05579,0.28612>

    /* stem 0.47.15*/ 
    /*0*/ <-0.47211,12.38618,-0.01505>,
    /*1*/ <-0.46658,12.38548,-0.01963>,<-0.47186,12.39115,-0.00983>,<-0.47788,12.38191,-0.01568>,
            
    /*2*/ <-0.58586,12.56972,-0.18808>,<-0.58937,12.5735,-0.18155>,<-0.59339,12.56734,-0.18545>,
            
    /*3*/ <-0.67124,12.7904,-0.33123>,<-0.67287,12.79206,-0.32777>,<-0.67519,12.78959,-0.33019>,
            
    /*4*/ <-0.73147,13.04249,-0.42837>

    /* stem 0.47.16*/ 
    /*0*/ <-0.47344,12.48864,-0.03241>,
    /*1*/ <-0.4745,12.48963,-0.0265>,<-0.47678,12.4915,-0.03662>,<-0.46904,12.48479,-0.03411>,
            
    /*2*/ <-0.30061,12.68849,-0.03066>,<-0.30213,12.68974,-0.03741>,<-0.29697,12.68527,-0.03574>,
            
    /*3*/ <-0.2031,12.92734,-0.08996>,<-0.20436,12.92707,-0.09322>,<-0.20112,12.92593,-0.0925>,
            
    /*4*/ <-0.16027,13.17918,-0.15726>

    /* stem 0.47.17*/ 
    /*0*/ <-0.46549,12.61223,-0.04918>,
    /*1*/ <-0.46776,12.61223,-0.05334>,<-0.46124,12.61427,-0.0488>,<-0.46748,12.61018,-0.04541>,
            
    /*2*/ <-0.57623,12.82802,0.00778>,<-0.57189,12.82938,0.01081>,<-0.57604,12.82665,0.01307>,
            
    /*3*/ <-0.70986,13.0373,0.00922>,<-0.70795,13.03852,0.01074>,<-0.71001,13.0372,0.01194>,
            
    /*4*/ <-0.78907,13.2727,-0.01077>

    /* stem 0.47.18*/ 
    /*0*/ <-0.44762,12.71857,-0.0588>,
    /*1*/ <-0.44434,12.71814,-0.05748>,<-0.4496,12.72135,-0.05778>,<-0.44892,12.71622,-0.06113>,
            
    /*2*/ <-0.35703,12.84596,-0.2358>,<-0.36054,12.8481,-0.236>,<-0.36009,12.84468,-0.23823>,
            
    /*3*/ <-0.32812,13.03356,-0.37705>,<-0.33006,13.03414,-0.3767>,<-0.32964,13.03289,-0.37827>,
            
    /*4*/ <-0.32908,13.25871,-0.44841>

    /* stem 0.47.19*/ 
    /*0*/ <-0.42734,12.83924,-0.06971>,
    /*1*/ <-0.42942,12.83965,-0.06902>,<-0.42644,12.84048,-0.07133>,<-0.42616,12.83758,-0.06878>,
            
    /*2*/ <-0.35035,12.98069,0.0822>,<-0.34836,12.98124,0.08066>,<-0.34817,12.97932,0.08236>,
            
    /*3*/ <-0.24529,13.13091,0.20672>,<-0.24438,13.13103,0.20581>,<-0.24425,13.13016,0.20675>,
            
    /*4*/ <-0.1591,13.32136,0.27954>

    /* stem 0.47.20*/ 
    /*0*/ <-0.39846,13.01108,-0.08525>,
    /*1*/ <-0.39829,13.01103,-0.08554>,<-0.39835,13.01132,-0.08502>,<-0.39875,13.01091,-0.08518>,
            
    /*2*/ <-0.50685,13.15211,-0.17755>,<-0.5069,13.15231,-0.17721>,<-0.50716,13.15203,-0.17731>,
            
    /*3*/ <-0.56692,13.32818,-0.25205>,<-0.56693,13.32825,-0.25187>,<-0.56709,13.32816,-0.25195>,
            
    /*4*/ <-0.5511,13.49969,-0.35441>

    /* stem 0.48*/ 
    /*0*/ <-0.01077,10.85804,-0.12986>,
    /*1*/ <0.01364,10.85965,-0.12103>,<-0.01117,10.87131,-0.1075>,<-0.03542,10.86464,-0.12488>,
            <-0.0256,10.84885,-0.14914>,<0.00472,10.84576,-0.14676>,
    /*2*/ <0.06988,11.27183,-0.36652>,<0.05004,11.28116,-0.3557>,<0.03064,11.27583,-0.3696>,
            <0.03849,11.26319,-0.38901>,<0.06275,11.26072,-0.38711>,
    /*3*/ <0.12123,11.72199,-0.53081>,<0.10613,11.72714,-0.52176>,<0.09177,11.72489,-0.53295>,
            <0.098,11.71835,-0.54892>,<0.11621,11.71656,-0.54759>,
    /*4*/ <0.17355,12.18097,-0.67089>,<0.16345,12.18408,-0.66474>,<0.15392,12.18298,-0.67232>,
            <0.15813,12.17919,-0.68315>,<0.17026,12.17795,-0.68227>,
    /*5*/ <0.16343,12.65844,-0.74819>,<0.1583,12.65891,-0.74489>,<0.15355,12.65826,-0.74868>,
            <0.15574,12.65739,-0.75432>,<0.16185,12.6575,-0.75402>,
    /*6*/ <0.08857,13.13245,-0.6918>

    /* stem 0.48.0*/ 
    /*0*/ <0.00136,10.93986,-0.1782>,
    /*1*/ <-0.01131,10.94375,-0.17478>,<0.00521,10.93988,-0.19133>,<0.01017,10.93594,-0.16849>,
            
    /*2*/ <0.14192,11.38759,-0.1315>,<0.15293,11.38501,-0.14254>,<0.15624,11.38238,-0.12731>,
            
    /*3*/ <0.39936,11.77972,-0.20115>,<0.40388,11.77589,-0.20639>,<0.40587,11.77594,-0.19874>,
            
    /*4*/ <0.70963,12.13422,-0.23135>

    /* stem 0.48.1*/ 
    /*0*/ <0.01667,11.0432,-0.23926>,
    /*1*/ <0.02299,11.03663,-0.24879>,<0.02119,11.05489,-0.2352>,<0.00583,11.03806,-0.23379>,
            
    /*2*/ <-0.23664,11.24751,-0.56021>,<-0.23784,11.25968,-0.55115>,<-0.24808,11.24846,-0.55021>,
            
    /*3*/ <-0.43142,11.59045,-0.79452>,<-0.4309,11.59499,-0.78843>,<-0.43712,11.59074,-0.78948>,
            
    /*4*/ <-0.53381,11.99587,-0.97962>

    /* stem 0.48.2*/ 
    /*0*/ <0.02633,11.10837,-0.27777>,
    /*1*/ <0.02879,11.11452,-0.26674>,<0.01863,11.11375,-0.28656>,<0.03157,11.09683,-0.28>,
            
    /*2*/ <0.38237,11.31024,-0.45974>,<0.37559,11.30973,-0.47295>,<0.38422,11.29845,-0.46858>,
            
    /*3*/ <0.62448,11.67454,-0.54088>,<0.62155,11.67503,-0.54769>,<0.62778,11.67113,-0.54659>,
            
    /*4*/ <0.86461,12.03371,-0.66016>

    /* stem 0.48.3*/ 
    /*0*/ <0.04319,11.22217,-0.345>,
    /*1*/ <0.03368,11.21928,-0.35228>,<0.05328,11.22734,-0.34982>,<0.04261,11.21988,-0.33291>,
            
    /*2*/ <-0.13263,11.61192,-0.28387>,<-0.11957,11.61729,-0.28223>,<-0.12668,11.61232,-0.27096>,
            
    /*3*/ <-0.32376,11.99792,-0.28124>,<-0.31744,12.0011,-0.28049>,<-0.32117,11.99922,-0.27474>,
            
    /*4*/ <-0.43793,12.40791,-0.35564>

    /* stem 0.48.4*/ 
    /*0*/ <0.05514,11.30888,-0.38742>,
    /*1*/ <0.06698,11.30758,-0.38695>,<0.05,11.31844,-0.3825>,<0.04845,11.30063,-0.39281>,
            
    /*2*/ <0.10035,11.51522,-0.75066>,<0.08904,11.52247,-0.7477>,<0.088,11.5106,-0.75457>,
            
    /*3*/ <0.13597,11.83042,-1.02634>,<0.13019,11.83327,-1.02392>,<0.12989,11.82876,-1.02911>,
            
    /*4*/ <0.16463,12.2111,-1.20202>

    /* stem 0.48.5*/ 
    /*0*/ <0.07144,11.43951,-0.43455>,
    /*1*/ <0.06281,11.44293,-0.42803>,<0.07161,11.44212,-0.44559>,<0.07991,11.43346,-0.43003>,
            
    /*2*/ <0.26439,11.78264,-0.34639>,<0.27025,11.7821,-0.35809>,<0.27579,11.77632,-0.34772>,
            
    /*3*/ <0.41797,12.15266,-0.30341>,<0.42079,12.15223,-0.30931>,<0.42404,12.15026,-0.30398>,
            
    /*4*/ <0.5127,12.5435,-0.27776>

    /* stem 0.48.6*/ 
    /*0*/ <0.08893,11.57962,-0.48511>,
    /*1*/ <0.09078,11.57582,-0.49499>,<0.09581,11.58656,-0.48064>,<0.0802,11.57647,-0.47969>,
            
    /*2*/ <-0.10881,11.87094,-0.64188>,<-0.10546,11.87809,-0.63232>,<-0.11587,11.87137,-0.63168>,
            
    /*3*/ <-0.23411,12.20467,-0.78833>,<-0.23214,12.20768,-0.78327>,<-0.23791,12.20542,-0.78349>,
            
    /*4*/ <-0.19026,12.57681,-0.87967>

    /* stem 0.48.7*/ 
    /*0*/ <0.10167,11.68175,-0.52196>,
    /*1*/ <0.10679,11.68421,-0.51336>,<0.09452,11.68815,-0.52571>,<0.1037,11.67288,-0.5268>,
            
    /*2*/ <0.36526,11.85449,-0.72015>,<0.35708,11.85711,-0.72839>,<0.36321,11.84694,-0.72912>,
            
    /*3*/ <0.55365,12.1228,-0.89589>,<0.54907,12.12366,-0.89959>,<0.55333,12.11975,-0.90099>,
            
    /*4*/ <0.60309,12.46485,-1.03466>

    /* stem 0.48.8*/ 
    /*0*/ <0.11382,11.77924,-0.5537>,
    /*1*/ <0.10461,11.7793,-0.5573>,<0.12133,11.78249,-0.55927>,<0.11553,11.77592,-0.54454>,
            
    /*2*/ <0.05944,12.11155,-0.42668>,<0.07059,12.11368,-0.42799>,<0.06672,12.1093,-0.41817>,
            
    /*3*/ <0.04471,12.46816,-0.38117>,<0.05035,12.46854,-0.382>,<0.04829,12.46778,-0.37673>,
            
    /*4*/ <0.05971,12.82433,-0.42978>

    /* stem 0.48.9*/ 
    /*0*/ <0.12561,11.87386,-0.58219>,
    /*1*/ <0.13449,11.87193,-0.58496>,<0.12395,11.88113,-0.5763>,<0.11839,11.86854,-0.58532>,
            
    /*2*/ <0.09299,12.0851,-0.85675>,<0.08596,12.09124,-0.85098>,<0.08226,12.08284,-0.857>,
            
    /*3*/ <0.16809,12.4039,-0.97181>,<0.16454,12.40608,-0.96823>,<0.16285,12.40466,-0.97326>,
            
    /*4*/ <0.3071,12.71911,-1.01735>

    /* stem 0.48.10*/ 
    /*0*/ <0.13697,11.96508,-0.60965>,
    /*1*/ <0.1324,11.96787,-0.60226>,<0.13439,11.96789,-0.61795>,<0.14411,11.95947,-0.60875>,
            
    /*2*/ <0.33885,12.23239,-0.57841>,<0.34017,12.2324,-0.58886>,<0.34666,12.22679,-0.58273>,
            
    /*3*/ <0.4451,12.54459,-0.52108>,<0.44596,12.54528,-0.52623>,<0.4498,12.54341,-0.52315>,
            
    /*4*/ <0.50533,12.87559,-0.51492>

    /* stem 0.48.11*/ 
    /*0*/ <0.14624,12.03956,-0.63208>,
    /*1*/ <0.14476,12.03722,-0.64045>,<0.15254,12.04543,-0.63019>,<0.14142,12.03602,-0.62559>,
            
    /*2*/ <-0.07212,12.28051,-0.66693>,<-0.06693,12.28598,-0.66009>,<-0.07434,12.27971,-0.65703>,
            
    /*3*/ <-0.2176,12.57009,-0.7115>,<-0.21458,12.57219,-0.70797>,<-0.21905,12.57016,-0.70661>,
            
    /*4*/ <-0.37173,12.85701,-0.67566>

    /* stem 0.48.12*/ 
    /*0*/ <0.15763,12.13101,-0.65961>,
    /*1*/ <0.16403,12.13185,-0.65416>,<0.1524,12.13749,-0.66102>,<0.15646,12.12368,-0.66365>,
            
    /*2*/ <0.34823,12.23108,-0.89024>,<0.34048,12.23484,-0.89481>,<0.34319,12.22563,-0.89657>,
            
    /*3*/ <0.49055,12.43888,-1.0799>,<0.48622,12.44035,-1.0816>,<0.4886,12.43671,-1.08381>,
            
    /*4*/ <0.61506,12.68928,-1.2255>

    /* stem 0.48.13*/ 
    /*0*/ <0.16338,12.22475,-0.68158>,
    /*1*/ <0.1553,12.22464,-0.6817>,<0.16746,12.22809,-0.68769>,<0.16736,12.22152,-0.67534>,
            
    /*2*/ <0.15219,12.49295,-0.53919>,<0.1603,12.49525,-0.54318>,<0.16023,12.49087,-0.53495>,
            
    /*3*/ <0.06116,12.77012,-0.46015>,<0.06502,12.77195,-0.46201>,<0.06498,12.77066,-0.45753>,
            
    /*4*/ <-0.03687,13.05744,-0.46911>

    /* stem 0.48.14*/ 
    /*0*/ <0.16166,12.37962,-0.70604>,
    /*1*/ <0.16747,12.37895,-0.7107>,<0.16126,12.38546,-0.70137>,<0.15625,12.37446,-0.70605>,
            
    /*2*/ <0.0241,12.52784,-0.90693>,<0.01996,12.53217,-0.90071>,<0.01661,12.52484,-0.90383>,
            
    /*3*/ <-0.13894,12.75133,-0.98224>,<-0.13995,12.75202,-0.9781>,<-0.14241,12.74942,-0.98051>,
            
    /*4*/ <-0.28269,12.99586,-1.01184>

    /* stem 0.48.15*/ 
    /*0*/ <0.16072,12.46422,-0.7194>,
    /*1*/ <0.15936,12.4653,-0.71246>,<0.15724,12.46802,-0.72437>,<0.16557,12.45934,-0.72138>,
            
    /*2*/ <0.35626,12.65679,-0.70605>,<0.35484,12.6586,-0.71399>,<0.3604,12.65281,-0.712>,
            
    /*3*/ <0.56067,12.83951,-0.73095>,<0.5597,12.84011,-0.73492>,<0.56243,12.83719,-0.73388>,
            
    /*4*/ <0.70865,13.06798,-0.76775>

    /* stem 0.48.16*/ 
    /*0*/ <0.15936,12.5873,-0.73884>,
    /*1*/ <0.15646,12.58645,-0.74399>,<0.16408,12.59095,-0.73863>,<0.15753,12.58449,-0.73389>,
            
    /*2*/ <0.00067,12.78635,-0.68695>,<0.00575,12.78935,-0.68338>,<0.00139,12.78504,-0.68022>,
            
    /*3*/ <-0.09054,13.0294,-0.68072>,<-0.08774,13.03043,-0.679>,<-0.09052,13.02934,-0.67727>,
            
    /*4*/ <-0.0888,13.2851,-0.72655>

    /* stem 0.48.17*/ 
    /*0*/ <0.15417,12.68796,-0.74636>,
    /*1*/ <0.1587,12.68842,-0.74463>,<0.15039,12.68961,-0.74375>,<0.15341,12.68584,-0.75068>,
            
    /*2*/ <0.17721,12.90848,-0.85643>,<0.17167,12.90928,-0.85584>,<0.17367,12.90676,-0.86046>,
            
    /*3*/ <0.18311,13.15528,-0.86874>,<0.18032,13.15538,-0.86834>,<0.18136,13.15523,-0.87095>,
            
    /*4*/ <0.17197,13.39975,-0.83171>

    /* stem 0.48.18*/ 
    /*0*/ <0.12959,12.85451,-0.72591>,
    /*1*/ <0.12676,12.85397,-0.72492>,<0.13016,12.85696,-0.72763>,<0.13185,12.8526,-0.72518>,
            
    /*2*/ <0.17006,12.97583,-0.53816>,<0.17233,12.97782,-0.53997>,<0.17346,12.97492,-0.53834>,
            
    /*3*/ <0.17151,13.17035,-0.4209>,<0.17261,13.17106,-0.42208>,<0.17325,13.17022,-0.42068>,
            
    /*4*/ <0.11561,13.38234,-0.36193>

    /* stem 0.48.19*/ 
    /*0*/ <0.11278,12.96837,-0.71194>,
    /*1*/ <0.11367,12.96869,-0.71347>,<0.11305,12.96943,-0.71051>,<0.11163,12.967,-0.71184>,
            
    /*2*/ <-0.04448,13.09661,-0.77753>,<-0.04489,13.0971,-0.77556>,<-0.04584,13.09548,-0.77644>,
            
    /*3*/ <-0.16855,13.26718,-0.80907>,<-0.16864,13.26731,-0.80805>,<-0.16932,13.26672,-0.80856>,
            
    /*4*/ <-0.26535,13.45679,-0.82147>

    /* stem 0.48.20*/ 
    /*0*/ <0.09658,13.07818,-0.69846>,
    /*1*/ <0.09668,13.07812,-0.69788>,<0.09618,13.07857,-0.69865>,<0.09688,13.07784,-0.69885>,
            
    /*2*/ <0.23917,13.2177,-0.70998>,<0.23884,13.218,-0.7105>,<0.2393,13.21752,-0.71063>,
            
    /*3*/ <0.36822,13.36479,-0.66984>,<0.36808,13.36497,-0.67009>,<0.36834,13.36476,-0.67016>,
            
    /*4*/ <0.48353,13.52258,-0.62814>

    /* stem 0.49*/ 
    /*0*/ <-0.01732,11.00377,-0.1382>,
    /*1*/ <-0.04064,11.00321,-0.12967>,<-0.03217,11.013,-0.15584>,<-0.00317,11.01004,-0.15763>,
            <0.00627,10.99841,-0.13256>,<-0.01689,10.99419,-0.11528>,
    /*2*/ <0.01971,11.43858,0.04959>,<0.02649,11.44642,0.02865>,<0.04968,11.44404,0.02722>,
            <0.05724,11.43474,0.04727>,<0.03871,11.43136,0.0611>,
    /*3*/ <0.02888,11.89609,0.17133>,<0.03379,11.90043,0.15508>,<0.05131,11.9004,0.15453>,
            <0.05722,11.89605,0.17044>,<0.04336,11.89339,0.18082>,
    /*4*/ <-0.02037,12.36639,0.2028>,<-0.01705,12.36756,0.19166>,<-0.00544,12.3689,0.19148>,
            <-0.0016,12.36857,0.20251>,<-0.01083,12.36701,0.2095>,
    /*5*/ <-0.10485,12.82609,0.1196>,<-0.103,12.82547,0.1141>,<-0.09726,12.82656,0.11399>,
            <-0.09557,12.82786,0.11942>,<-0.10025,12.82756,0.12289>,
    /*6*/ <-0.24247,13.24143,-0.06384>

    /* stem 0.49.0*/ 
    /*0*/ <-0.00651,11.08828,-0.10306>,
    /*1*/ <0.00018,11.09186,-0.11372>,<-0.00304,11.09288,-0.09131>,<-0.01666,11.08011,-0.10415>,
            
    /*2*/ <-0.28669,11.45206,-0.16762>,<-0.28884,11.45274,-0.15269>,<-0.29792,11.44422,-0.16125>,
            
    /*3*/ <-0.49856,11.8392,-0.01843>,<-0.49803,11.83681,-0.01129>,<-0.50412,11.83507,-0.01541>,
            
    /*4*/ <-0.60307,12.17919,0.28038>

    /* stem 0.49.1*/ 
    /*0*/ <0.00431,11.17284,-0.0679>,
    /*1*/ <0.00629,11.16781,-0.05641>,<-0.00441,11.18195,-0.06944>,<0.01106,11.16876,-0.07787>,
            
    /*2*/ <0.31976,11.48425,0.0236>,<0.31263,11.49368,0.01491>,<0.32294,11.48489,0.00929>,
            
    /*3*/ <0.55644,11.87101,-0.01818>,<0.55141,11.87365,-0.02282>,<0.55714,11.86986,-0.02539>,
            
    /*4*/ <0.62034,12.31914,-0.03403>

    /* stem 0.49.2*/ 
    /*0*/ <0.02055,11.29975,-0.01514>,
    /*1*/ <0.01144,11.3038,-0.02209>,<0.03052,11.30652,-0.01364>,<0.01968,11.28892,-0.0097>,
            
    /*2*/ <-0.16677,11.49202,0.32843>,<-0.15405,11.49384,0.33406>,<-0.16128,11.4821,0.33669>,
            
    /*3*/ <-0.29115,11.82171,0.58315>,<-0.2846,11.82239,0.58557>,<-0.28913,11.81815,0.58884>,
            
    /*4*/ <-0.30568,12.17983,0.83241>

    /* stem 0.49.3*/ 
    /*0*/ <0.03,11.37365,0.01558>,
    /*1*/ <0.04175,11.37229,0.01524>,<0.02493,11.37897,0.02486>,<0.02333,11.3697,0.00666>,
            
    /*2*/ <0.07579,11.74971,-0.17997>,<0.06458,11.75416,-0.17356>,<0.06351,11.74798,-0.1857>,
            
    /*3*/ <0.15197,12.1666,-0.21986>,<0.14628,12.16803,-0.21637>,<0.14605,12.16742,-0.22317>,
            
    /*4*/ <0.33781,12.54428,-0.15959>

    /* stem 0.49.4*/ 
    /*0*/ <0.03916,11.5196,0.06451>,
    /*1*/ <0.03054,11.51781,0.07145>,<0.03882,11.5281,0.05721>,<0.04813,11.51288,0.06487>,
            
    /*2*/ <0.20552,11.76312,0.34609>,<0.21103,11.76998,0.3366>,<0.21724,11.75983,0.3417>,
            
    /*3*/ <0.32619,12.06112,0.59626>,<0.3288,12.06432,0.59127>,<0.33236,12.06007,0.59461>,
            
    /*4*/ <0.37102,12.43355,0.75615>

    /* stem 0.49.5*/ 
    /*0*/ <0.04029,11.63285,0.09507>,
    /*1*/ <0.04221,11.63559,0.08486>,<0.04477,11.63846,0.10307>,<0.03389,11.6245,0.09729>,
            
    /*2*/ <-0.26993,11.87522,0.09421>,<-0.26822,11.87713,0.10635>,<-0.27548,11.86783,0.1025>,
            
    /*3*/ <-0.51243,12.18422,0.11285>,<-0.51122,12.18487,0.1189>,<-0.51593,12.18128,0.11704>,
            
    /*4*/ <-0.72048,12.50864,0.03741>

    /* stem 0.49.6*/ 
    /*0*/ <0.04143,11.74818,0.1262>,
    /*1*/ <0.04653,11.7458,0.13481>,<0.03369,11.75494,0.12651>,<0.04408,11.74379,0.11729>,
            
    /*2*/ <0.28899,12.02908,0.0653>,<0.28043,12.03517,0.05976>,<0.28735,12.02773,0.05361>,
            
    /*3*/ <0.45086,12.36952,0.10105>,<0.44622,12.37206,0.09835>,<0.45086,12.37018,0.09515>,
            
    /*4*/ <0.53034,12.73185,0.18046>

    /* stem 0.49.7*/ 
    /*0*/ <0.04212,11.81753,0.14491>,
    /*1*/ <0.03274,11.81852,0.14159>,<0.04892,11.82458,0.14288>,<0.0447,11.80949,0.15027>,
            
    /*2*/ <-0.0558,11.99647,0.45446>,<-0.04501,12.00051,0.45532>,<-0.04782,11.99045,0.46025>,
            
    /*3*/ <-0.0583,12.31217,0.64965>,<-0.05264,12.31283,0.64873>,<-0.05449,12.30995,0.65338>,
            
    /*4*/ <0.03525,12.6361,0.80532>

    /* stem 0.49.8*/ 
    /*0*/ <0.03514,11.96502,0.17121>,
    /*1*/ <0.04397,11.96625,0.16817>,<0.03222,11.96933,0.17906>,<0.02923,11.95949,0.1664>,
            
    /*2*/ <-0.06329,12.24323,-0.02175>,<-0.07112,12.24528,-0.01449>,<-0.07311,12.23872,-0.02293>,
            
    /*3*/ <-0.17606,12.50202,-0.23296>,<-0.18005,12.5032,-0.22946>,<-0.18089,12.49958,-0.23344>,
            
    /*4*/ <-0.26738,12.81173,-0.37439>

    /* stem 0.49.9*/ 
    /*0*/ <0.0259,12.04558,0.17689>,
    /*1*/ <0.02128,12.0445,0.18467>,<0.02256,12.05092,0.17032>,<0.03385,12.04131,0.17568>,
            
    /*2*/ <0.18755,12.31348,0.31701>,<0.1884,12.31777,0.30744>,<0.19592,12.31135,0.31102>,
            
    /*3*/ <0.29107,12.63653,0.37121>,<0.29102,12.63745,0.36603>,<0.29539,12.63566,0.36834>,
            
    /*4*/ <0.34103,12.94724,0.50496>

    /* stem 0.49.10*/ 
    /*0*/ <0.0073,12.2077,0.18832>,
    /*1*/ <0.00593,12.20813,0.17995>,<0.01292,12.2129,0.19197>,<0.00304,12.20207,0.19302>,
            
    /*2*/ <-0.22716,12.42579,0.23222>,<-0.2225,12.42897,0.24023>,<-0.22908,12.42175,0.24093>,
            
    /*3*/ <-0.35011,12.71587,0.30694>,<-0.34699,12.71626,0.3107>,<-0.35139,12.71423,0.31138>,
            
    /*4*/ <-0.29399,13.0338,0.31165>

    /* stem 0.49.11*/ 
    /*0*/ <-0.00617,12.3251,0.19659>,
    /*1*/ <-0.00011,12.32542,0.20186>,<-0.01247,12.33003,0.1974>,<-0.00593,12.31984,0.19051>,
            
    /*2*/ <0.13999,12.53557,0.02393>,<0.13175,12.53864,0.02095>,<0.13611,12.53185,0.01636>,
            
    /*3*/ <0.24343,12.80075,-0.09561>,<0.23911,12.80192,-0.09685>,<0.24181,12.79954,-0.09979>,
            
    /*4*/ <0.17821,13.09891,-0.14778>

    /* stem 0.49.12*/ 
    /*0*/ <-0.02341,12.4313,0.18828>,
    /*1*/ <-0.0309,12.42983,0.18817>,<-0.0204,12.43619,0.18325>,<-0.01893,12.42789,0.19343>,
            
    /*2*/ <-0.07535,12.65334,0.37691>,<-0.06835,12.65758,0.37363>,<-0.06737,12.65205,0.38042>,
            
    /*3*/ <-0.10039,12.92278,0.49774>,<-0.09675,12.9241,0.49564>,<-0.09645,12.92233,0.49966>,
            
    /*4*/ <-0.07799,13.2054,0.58398>

    /* stem 0.49.13*/ 
    /*0*/ <-0.04295,12.53193,0.1704>,
    /*1*/ <-0.03728,12.53224,0.1659>,<-0.04343,12.53658,0.17594>,<-0.04814,12.52699,0.16936>,
            
    /*2*/ <-0.17984,12.71461,0.00237>,<-0.18394,12.7175,0.00907>,<-0.18708,12.71111,0.00468>,
            
    /*3*/ <-0.28372,12.9349,-0.14188>,<-0.28569,12.93626,-0.13845>,<-0.28762,12.93363,-0.14107>,
            
    /*4*/ <-0.4026,13.19211,-0.16295>

    /* stem 0.49.14*/ 
    /*0*/ <-0.06159,12.62793,0.15333>,
    /*1*/ <-0.06309,12.62882,0.15999>,<-0.06567,12.63064,0.14849>,<-0.05601,12.62433,0.15151>,
            
    /*2*/ <0.08518,12.85626,0.16055>,<0.08346,12.85747,0.15289>,<0.0899,12.85327,0.1549>,
            
    /*3*/ <0.20295,13.09923,0.18354>,<0.20215,13.10001,0.17973>,<0.20557,13.09826,0.18071>,
            
    /*4*/ <0.25141,13.35355,0.26321>

    /* stem 0.49.15*/ 
    /*0*/ <-0.08615,12.75441,0.13085>,
    /*1*/ <-0.08873,12.75303,0.1259>,<-0.08299,12.7592,0.13121>,<-0.08672,12.751,0.13545>,
            
    /*2*/ <-0.29534,12.88494,0.19901>,<-0.29151,12.88905,0.20255>,<-0.294,12.88359,0.20537>,
            
    /*3*/ <-0.4022,13.11618,0.17789>,<-0.39967,13.11753,0.17956>,<-0.40235,13.11644,0.18119>,
            
    /*4*/ <-0.54319,13.32642,0.14274>

    /* stem 0.49.16*/ 
    /*0*/ <-0.11505,12.87002,0.09901>,
    /*1*/ <-0.11123,12.87191,0.10031>,<-0.11893,12.872,0.09993>,<-0.11498,12.86617,0.09678>,
            
    /*2*/ <-0.10086,12.99186,-0.10832>,<-0.10599,12.99192,-0.10857>,<-0.10336,12.98804,-0.11067>,
            
    /*3*/ <-0.11476,13.17261,-0.26657>,<-0.11732,13.1725,-0.26649>,<-0.11603,13.17109,-0.26821>,
            
    /*4*/ <-0.15263,13.35308,-0.42174>

    /* stem 0.49.17*/ 
    /*0*/ <-0.14632,12.9612,0.05903>,
    /*1*/ <-0.14943,12.96063,0.06017>,<-0.14587,12.96279,0.05611>,<-0.14367,12.96017,0.06081>,
            
    /*2*/ <-0.1446,13.16085,0.16987>,<-0.14223,13.16229,0.16717>,<-0.14076,13.16054,0.1703>,
            
    /*3*/ <-0.16802,13.38772,0.18318>,<-0.1668,13.38794,0.18169>,<-0.16611,13.3879,0.1835>,
            
    /*4*/ <-0.229,13.60621,0.20768>

    /* stem 0.49.18*/ 
    /*0*/ <-0.19376,13.09947,-0.0016>,
    /*1*/ <-0.19281,13.09919,-0.00298>,<-0.19366,13.10095,-0.00077>,<-0.19483,13.09826,-0.00104>,
            
    /*2*/ <-0.3454,13.17711,-0.12329>,<-0.34597,13.17829,-0.12182>,<-0.34675,13.17649,-0.122>,
            
    /*3*/ <-0.46359,13.29845,-0.24621>,<-0.46383,13.29901,-0.24544>,<-0.46438,13.29823,-0.24567>,
            
    /*4*/ <-0.56868,13.47577,-0.28394>

    /* stem 0.49.19*/ 
    /*0*/ <-0.22758,13.19802,-0.04481>,
    /*1*/ <-0.22754,13.19824,-0.04434>,<-0.22798,13.19813,-0.04512>,<-0.22721,13.19769,-0.04497>,
            
    /*2*/ <-0.12707,13.34767,-0.1213>,<-0.12736,13.3476,-0.12182>,<-0.12685,13.3473,-0.12172>,
            
    /*3*/ <-0.01767,13.49914,-0.17981>,<-0.0178,13.49913,-0.18008>,<-0.01755,13.49897,-0.18002>,
            
    /*4*/ <0.05345,13.67091,-0.24131>

    /* stem 0.50*/ 
    /*0*/ <-0.02609,11.19884,-0.14936>,
    /*1*/ <-0.01513,11.19825,-0.16832>,<-0.00682,11.20883,-0.14636>,<-0.02514,11.20561,-0.12854>,
            <-0.04477,11.19304,-0.13949>,<-0.03858,11.18849,-0.16407>,
    /*2*/ <-0.20785,11.60267,-0.28722>,<-0.20121,11.61114,-0.26966>,<-0.21586,11.60856,-0.2554>,
            <-0.23156,11.5985,-0.26416>,<-0.22661,11.59486,-0.28383>,
    /*3*/ <-0.37485,12.02924,-0.3637>,<-0.36922,12.03397,-0.35011>,<-0.38014,12.03176,-0.3394>,
            <-0.39251,12.02567,-0.34637>,<-0.38924,12.02411,-0.36139>,
    /*4*/ <-0.52815,12.46845,-0.3638>,<-0.5239,12.47,-0.35454>,<-0.53092,12.46764,-0.34739>,
            <-0.53951,12.46464,-0.35222>,<-0.5378,12.46514,-0.36236>,
    /*5*/ <-0.68178,12.90414,-0.3176>,<-0.67954,12.90447,-0.31298>,<-0.68295,12.90294,-0.30944>,
            <-0.6873,12.90166,-0.31187>,<-0.68658,12.9024,-0.31692>,
    /*6*/ <-0.81975,13.33916,-0.23528>

    /* stem 0.50.0*/ 
    /*0*/ <-0.06876,11.28939,-0.17684>,
    /*1*/ <-0.06753,11.29323,-0.16608>,<-0.07886,11.29045,-0.1822>,<-0.05989,11.28449,-0.18223>,
            
    /*2*/ <0.05846,11.69489,-0.32805>,<0.05091,11.69304,-0.33879>,<0.06356,11.68906,-0.33881>,
            
    /*3*/ <0.13303,12.07997,-0.55314>,<0.12908,12.07792,-0.55806>,<0.13557,12.07656,-0.55823>,
            
    /*4*/ <-0.00318,12.40747,-0.83316>

    /* stem 0.50.1*/ 
    /*0*/ <-0.10901,11.3748,-0.20275>,
    /*1*/ <-0.11639,11.36939,-0.20909>,<-0.10295,11.38306,-0.2071>,<-0.10768,11.37194,-0.19208>,
            
    /*2*/ <-0.42425,11.65972,-0.09113>,<-0.41528,11.66883,-0.08981>,<-0.41844,11.66142,-0.0798>,
            
    /*3*/ <-0.7519,11.94029,-0.01167>,<-0.74769,11.9451,-0.01103>,<-0.74942,11.94163,-0.0059>,
            
    /*4*/ <-1.08253,12.21524,0.07818>

    /* stem 0.50.2*/ 
    /*0*/ <-0.13857,11.43753,-0.22179>,
    /*1*/ <-0.12868,11.44197,-0.22249>,<-0.14676,11.44315,-0.21739>,<-0.14027,11.42745,-0.22549>,
            
    /*2*/ <-0.23109,11.59967,-0.60994>,<-0.24314,11.60045,-0.60654>,<-0.23881,11.58999,-0.61194>,
            
    /*3*/ <-0.35752,11.87328,-0.91707>,<-0.36333,11.87331,-0.91471>,<-0.36175,11.86912,-0.9191>,
            
    /*4*/ <-0.5222,12.20373,-1.13904>

    /* stem 0.50.3*/ 
    /*0*/ <-0.18845,11.54338,-0.25392>,
    /*1*/ <-0.19607,11.5419,-0.24695>,<-0.19081,11.54529,-0.26389>,<-0.17848,11.54294,-0.25091>,
            
    /*2*/ <-0.19969,11.95071,-0.16947>,<-0.19618,11.95297,-0.18076>,<-0.18797,11.9514,-0.17211>,
            
    /*3*/ <-0.26718,12.35886,-0.12843>,<-0.26545,12.35977,-0.13412>,<-0.2614,12.35999,-0.12967>,
            
    /*4*/ <-0.38518,12.75758,-0.11762>

    /* stem 0.50.4*/ 
    /*0*/ <-0.22818,11.63305,-0.27768>,
    /*1*/ <-0.22637,11.6319,-0.28752>,<-0.22443,11.641,-0.27277>,<-0.23373,11.62626,-0.27276>,
            
    /*2*/ <-0.56079,11.84284,-0.37033>,<-0.5595,11.8489,-0.36051>,<-0.5657,11.83908,-0.3605>,
            
    /*3*/ <-0.81047,12.15112,-0.44679>,<-0.80913,12.15352,-0.44168>,<-0.81359,12.14982,-0.44207>,
            
    /*4*/ <-0.95942,12.49794,-0.58892>

    /* stem 0.50.5*/ 
    /*0*/ <-0.28625,11.7833,-0.30596>,
    /*1*/ <-0.28196,11.78643,-0.29811>,<-0.29527,11.78562,-0.30769>,<-0.2815,11.77784,-0.31209>,
            
    /*2*/ <-0.16648,12.09901,-0.48963>,<-0.17535,12.09847,-0.49602>,<-0.16617,12.09328,-0.49896>,
            
    /*3*/ <-0.13264,12.41473,-0.70788>,<-0.13726,12.41345,-0.71052>,<-0.13245,12.41163,-0.71239>,
            
    /*4*/ <-0.0718,12.71642,-0.93814>

    /* stem 0.50.6*/ 
    /*0*/ <-0.32433,11.88182,-0.32451>,
    /*1*/ <-0.33226,11.87825,-0.32717>,<-0.3207,11.88879,-0.3291>,<-0.32001,11.87842,-0.31725>,
            
    /*2*/ <-0.51058,12.11817,-0.10663>,<-0.50287,12.1252,-0.10791>,<-0.50241,12.11828,-0.10002>,
            
    /*3*/ <-0.70755,12.35662,0.09851>,<-0.70381,12.36027,0.09792>,<-0.70361,12.35694,0.10198>,
            
    /*4*/ <-0.89787,12.6667,0.1733>

    /* stem 0.50.7*/ 
    /*0*/ <-0.36153,11.97807,-0.34262>,
    /*1*/ <-0.35381,11.98043,-0.34594>,<-0.36581,11.98347,-0.33726>,<-0.36497,11.97031,-0.34466>,
            
    /*2*/ <-0.5227,12.12724,-0.62654>,<-0.5307,12.12927,-0.62075>,<-0.53014,12.1205,-0.62568>,
            
    /*3*/ <-0.60659,12.39551,-0.84747>,<-0.61058,12.39666,-0.84462>,<-0.61106,12.39338,-0.84842>,
            
    /*4*/ <-0.71611,12.69391,-1.01473>

    /* stem 0.50.8*/ 
    /*0*/ <-0.40572,12.1002,-0.35283>,
    /*1*/ <-0.40941,12.099,-0.34552>,<-0.40993,12.10364,-0.35907>,<-0.39783,12.09797,-0.35389>,
            
    /*2*/ <-0.30623,12.41055,-0.2451>,<-0.30658,12.41365,-0.25413>,<-0.29851,12.40987,-0.25068>,
            
    /*3*/ <-0.29833,12.7435,-0.16366>,<-0.2986,12.74467,-0.16828>,<-0.29434,12.74406,-0.16622>,
            
    /*4*/ <-0.40775,13.0683,-0.14558>

    /* stem 0.50.9*/ 
    /*0*/ <-0.44413,12.21178,-0.35381>,
    /*1*/ <-0.44566,12.21119,-0.3615>,<-0.44151,12.21857,-0.35083>,<-0.44523,12.20558,-0.34909>,
            
    /*2*/ <-0.7552,12.30732,-0.30477>,<-0.75244,12.31224,-0.29766>,<-0.75491,12.30358,-0.2965>,
            
    /*3*/ <-1.03075,12.47852,-0.24855>,<-1.02874,12.48069,-0.24511>,<-1.03099,12.47682,-0.24435>,
            
    /*4*/ <-1.23057,12.73787,-0.21559>

    /* stem 0.50.10*/ 
    /*0*/ <-0.47176,12.29203,-0.35452>,
    /*1*/ <-0.46613,12.29401,-0.34985>,<-0.47885,12.29427,-0.35306>,<-0.4703,12.28781,-0.36064>,
            
    /*2*/ <-0.41951,12.55805,-0.52245>,<-0.42799,12.55822,-0.52458>,<-0.4223,12.55391,-0.52963>,
            
    /*3*/ <-0.51461,12.81228,-0.69297>,<-0.51869,12.81069,-0.69311>,<-0.51583,12.80965,-0.69625>,
            
    /*4*/ <-0.65556,13.07315,-0.81035>

    /* stem 0.50.11*/ 
    /*0*/ <-0.52244,12.43924,-0.35582>,
    /*1*/ <-0.5291,12.43695,-0.35557>,<-0.52073,12.44466,-0.35999>,<-0.51749,12.43612,-0.35189>,
            
    /*2*/ <-0.58423,12.62874,-0.13132>,<-0.57865,12.63388,-0.13427>,<-0.57649,12.62819,-0.12887>,
            
    /*3*/ <-0.66662,12.83733,0.06776>,<-0.66385,12.8399,0.06625>,<-0.66285,12.83739,0.0693>,
            
    /*4*/ <-0.73141,13.12931,0.09741>

    /* stem 0.50.12*/ 
    /*0*/ <-0.54523,12.50507,-0.35238>,
    /*1*/ <-0.54056,12.50714,-0.35689>,<-0.54603,12.50845,-0.34652>,<-0.54911,12.49964,-0.35374>,
            
    /*2*/ <-0.74036,12.67929,-0.48177>,<-0.744,12.68016,-0.47486>,<-0.74605,12.67429,-0.47967>,
            
    /*3*/ <-0.86037,12.9199,-0.59246>,<-0.86226,12.92055,-0.58907>,<-0.86396,12.9184,-0.59189>,
            
    /*4*/ <-0.96732,13.15721,-0.72395>

    /* stem 0.50.13*/ 
    /*0*/ <-0.5889,12.63068,-0.3402>,
    /*1*/ <-0.58959,12.62983,-0.33393>,<-0.59309,12.63424,-0.3434>,<-0.58403,12.62796,-0.34326>,
            
    /*2*/ <-0.43514,12.85384,-0.289>,<-0.43748,12.85678,-0.29532>,<-0.43143,12.8526,-0.29522>,
            
    /*3*/ <-0.34064,13.07894,-0.16359>,<-0.3416,13.08099,-0.16649>,<-0.33824,13.07949,-0.16633>,
            
    /*4*/ <-0.24996,13.32526,-0.07791>

    /* stem 0.50.14*/ 
    /*0*/ <-0.62112,12.72333,-0.33121>,
    /*1*/ <-0.62427,12.72273,-0.33633>,<-0.61856,12.72863,-0.32983>,<-0.62053,12.71863,-0.32746>,
            
    /*2*/ <-0.84296,12.79618,-0.20807>,<-0.83916,12.8001,-0.20374>,<-0.84047,12.79344,-0.20216>,
            
    /*3*/ <-1.05419,12.94613,-0.16222>,<-1.05233,12.94813,-0.16005>,<-1.05403,12.94534,-0.15883>,
            
    /*4*/ <-1.23044,13.13969,-0.12785>

    /* stem 0.50.15*/ 
    /*0*/ <-0.66786,12.85776,-0.31816>,
    /*1*/ <-0.66347,12.85913,-0.31665>,<-0.67182,12.85977,-0.31625>,<-0.66828,12.85437,-0.32159>,
            
    /*2*/ <-0.65985,13.03389,-0.49089>,<-0.66542,13.03431,-0.49063>,<-0.66306,13.03071,-0.49419>,
            
    /*3*/ <-0.69873,13.27328,-0.53514>,<-0.70147,13.27294,-0.53468>,<-0.70043,13.27263,-0.53725>,
            
    /*4*/ <-0.75412,13.51322,-0.51914>

    /* stem 0.50.16*/ 
    /*0*/ <-0.69321,12.93382,-0.30824>,
    /*1*/ <-0.69675,12.93244,-0.30675>,<-0.69316,12.93706,-0.3107>,<-0.68973,12.93194,-0.30725>,
            
    /*2*/ <-0.67203,13.07545,-0.11926>,<-0.66963,13.07852,-0.12189>,<-0.66735,13.07511,-0.11959>,
            
    /*3*/ <-0.67367,13.26592,0.02212>,<-0.67248,13.26715,0.0205>,<-0.67132,13.26594,0.02214>,
            
    /*4*/ <-0.69675,13.48308,0.11459>

    /* stem 0.50.17*/ 
    /*0*/ <-0.72626,13.03967,-0.28918>,
    /*1*/ <-0.72503,13.04053,-0.29179>,<-0.72571,13.04125,-0.28668>,<-0.72804,13.03725,-0.28908>,
            
    /*2*/ <-0.90343,13.16898,-0.33264>,<-0.90388,13.16946,-0.32923>,<-0.90543,13.1668,-0.33083>,
            
    /*3*/ <-1.00862,13.3659,-0.3409>,<-1.00866,13.36596,-0.33917>,<-1.00997,13.36522,-0.34005>,
            
    /*4*/ <-1.03013,13.58651,-0.36814>

    /* stem 0.50.18*/ 
    /*0*/ <-0.77719,13.20282,-0.25982>,
    /*1*/ <-0.77686,13.20269,-0.2585>,<-0.77838,13.20341,-0.26017>,<-0.77633,13.20237,-0.26079>,
            
    /*2*/ <-0.68624,13.38404,-0.26333>,<-0.68726,13.38452,-0.26444>,<-0.6859,13.38383,-0.26486>,
            
    /*3*/ <-0.66985,13.58616,-0.26964>,<-0.67041,13.58619,-0.2702>,<-0.66965,13.58612,-0.27041>,
            
    /*4*/ <-0.69584,13.7779,-0.33079>

    /* stem 0.50.19*/ 
    /*0*/ <-0.80627,13.296,-0.24305>,
    /*1*/ <-0.80661,13.29594,-0.24331>,<-0.80601,13.29634,-0.24311>,<-0.8062,13.29572,-0.24272>,
            
    /*2*/ <-0.91514,13.40232,-0.12778>,<-0.91474,13.40258,-0.12765>,<-0.91487,13.40217,-0.12739>,
            
    /*3*/ <-1.01576,13.54698,-0.0544>,<-1.01554,13.5471,-0.05434>,<-1.01565,13.54694,-0.05418>,
            
    /*4*/ <-1.07676,13.7202,-0.00222>

    /* stem 0.51*/ 
    /*0*/ <-0.0304,11.29467,-0.15484>,
    /*1*/ <-0.02686,11.29598,-0.13472>,<-0.04711,11.30248,-0.14597>,<-0.04426,11.29819,-0.16947>,
            <-0.02225,11.28904,-0.17275>,<-0.0115,11.28768,-0.15127>,
    /*2*/ <0.1396,11.7183,-0.19565>,<0.1234,11.7235,-0.20465>,<0.12568,11.72006,-0.22345>,
            <0.14328,11.71275,-0.22607>,<0.15189,11.71165,-0.20889>,
    /*3*/ <0.24185,12.15782,-0.28075>,<0.22908,12.15962,-0.28723>,<0.23074,12.15664,-0.30126>,
            <0.24454,12.15301,-0.30345>,<0.25141,12.15374,-0.29077>,
    /*4*/ <0.26806,12.61319,-0.30451>,<0.25939,12.61352,-0.30867>,<0.26064,12.61303,-0.3182>,
            <0.27009,12.6124,-0.31993>,<0.27467,12.6125,-0.31147>,
    /*5*/ <0.24968,13.07003,-0.33583>,<0.24535,13.06974,-0.3379>,<0.24598,13.06948,-0.34266>,
            <0.25071,13.06961,-0.34354>,<0.253,13.06995,-0.33932>,
    /*6*/ <0.17837,13.52062,-0.37871>

    /* stem 0.51.0*/ 
    /*0*/ <-0.00165,11.36734,-0.16462>,
    /*1*/ <-0.00944,11.36945,-0.17182>,<0.00851,11.37047,-0.16658>,<-0.00402,11.36209,-0.15547>,
            
    /*2*/ <-0.08838,11.76021,0.0338>,<-0.07642,11.76089,0.03729>,<-0.08477,11.7553,0.0447>,
            
    /*3*/ <-0.08989,12.14242,0.27096>,<-0.08382,12.1417,0.27224>,<-0.08813,12.1393,0.27607>,
            
    /*4*/ <-0.02869,12.55686,0.431>

    /* stem 0.51.1*/ 
    /*0*/ <0.0297,11.4466,-0.1753>,
    /*1*/ <0.03949,11.44278,-0.17491>,<0.02681,11.45431,-0.16876>,<0.02281,11.44271,-0.18222>,
            
    /*2*/ <0.16415,11.74209,-0.46976>,<0.15569,11.74977,-0.46566>,<0.15303,11.74204,-0.47463>,
            
    /*3*/ <0.41507,12.08509,-0.56937>,<0.41085,12.08887,-0.56719>,<0.41074,12.08724,-0.57304>,
            
    /*4*/ <0.60642,12.4758,-0.62657>

    /* stem 0.51.2*/ 
    /*0*/ <0.08241,11.57983,-0.19324>,
    /*1*/ <0.07534,11.58345,-0.18713>,<0.08364,11.58377,-0.20237>,<0.08825,11.57228,-0.19021>,
            
    /*2*/ <0.354,11.85871,-0.033>,<0.35953,11.85892,-0.04316>,<0.36261,11.85126,-0.03505>,
            
    /*3*/ <0.6521,12.1581,-0.04084>,<0.65345,12.15665,-0.04627>,<0.65615,12.15409,-0.04184>,
            
    /*4*/ <0.94099,12.46337,-0.02199>

    /* stem 0.51.3*/ 
    /*0*/ <0.11943,11.67341,-0.20584>,
    /*1*/ <0.12088,11.67157,-0.21522>,<0.12587,11.67865,-0.20088>,<0.11153,11.67002,-0.20141>,
            
    /*2*/ <-0.08142,12.01377,-0.31036>,<-0.07809,12.01848,-0.3008>,<-0.08766,12.01273,-0.30115>,
            
    /*3*/ <-0.1989,12.39099,-0.41422>,<-0.19704,12.39296,-0.40934>,<-0.20231,12.39119,-0.40981>,
            
    /*4*/ <-0.19255,12.79821,-0.4533>

    /* stem 0.51.4*/ 
    /*0*/ <0.15198,11.78221,-0.22372>,
    /*1*/ <0.15667,11.78259,-0.21572>,<0.14609,11.78902,-0.22598>,<0.15317,11.77502,-0.22947>,
            
    /*2*/ <0.44811,11.97582,-0.39924>,<0.44106,11.9801,-0.40608>,<0.44578,11.97077,-0.4084>,
            
    /*3*/ <0.67911,12.25799,-0.55077>,<0.67508,12.25967,-0.55387>,<0.67847,12.25593,-0.55568>,
            
    /*4*/ <0.83757,12.60496,-0.65276>

    /* stem 0.51.5*/ 
    /*0*/ <0.17047,11.86121,-0.23829>,
    /*1*/ <0.16217,11.86257,-0.24149>,<0.17759,11.86444,-0.24275>,<0.17166,11.85663,-0.23063>,
            
    /*2*/ <0.14152,12.19028,-0.04044>,<0.15181,12.19153,-0.04129>,<0.14785,12.18632,-0.03321>,
            
    /*3*/ <0.07053,12.54193,0.09619>,<0.07558,12.54309,0.09592>,<0.07362,12.54101,0.10026>,
            
    /*4*/ <-0.04305,12.90648,0.14065>

    /* stem 0.51.6*/ 
    /*0*/ <0.19546,11.96795,-0.25798>,
    /*1*/ <0.2033,11.9656,-0.26072>,<0.19458,11.97473,-0.25272>,<0.1885,11.9635,-0.26049>,
            
    /*2*/ <0.16437,12.19011,-0.55433>,<0.15856,12.19619,-0.549>,<0.15451,12.18871,-0.55418>,
            
    /*3*/ <0.174,12.49663,-0.76441>,<0.17111,12.49901,-0.76113>,<0.16905,12.4965,-0.7649>,
            
    /*4*/ <0.2011,12.85638,-0.85489>

    /* stem 0.51.7*/ 
    /*0*/ <0.22984,12.1148,-0.28506>,
    /*1*/ <0.22603,12.11695,-0.27822>,<0.22943,12.11957,-0.29161>,<0.23406,12.10787,-0.28535>,
            
    /*2*/ <0.51677,12.28806,-0.1734>,<0.51904,12.28981,-0.18233>,<0.52212,12.282,-0.17815>,
            
    /*3*/ <0.74365,12.55338,-0.12048>,<0.74425,12.55383,-0.12511>,<0.74703,12.55097,-0.12265>,
            
    /*4*/ <0.90289,12.86858,-0.11307>

    /* stem 0.51.8*/ 
    /*0*/ <0.24402,12.23203,-0.29599>,
    /*1*/ <0.24261,12.23179,-0.30358>,<0.24919,12.23704,-0.29318>,<0.24025,12.22728,-0.29121>,
            
    /*2*/ <-0.00151,12.46346,-0.26328>,<0.00287,12.46696,-0.25635>,<-0.00309,12.46045,-0.25503>,
            
    /*3*/ <-0.18698,12.74616,-0.24041>,<-0.18449,12.74755,-0.23699>,<-0.18814,12.7451,-0.23623>,
            
    /*4*/ <-0.38104,13.01549,-0.30549>

    /* stem 0.51.9*/ 
    /*0*/ <0.25093,12.34879,-0.30107>,
    /*1*/ <0.25659,12.34866,-0.29639>,<0.24568,12.35387,-0.30034>,<0.25052,12.34384,-0.30648>,
            
    /*2*/ <0.42086,12.5483,-0.49317>,<0.41359,12.55177,-0.4958>,<0.41682,12.54508,-0.49989>,
            
    /*3*/ <0.63341,12.7586,-0.61703>,<0.63024,12.76088,-0.61868>,<0.63201,12.75776,-0.62094>,
            
    /*4*/ <0.74702,13.06086,-0.65396>

    /* stem 0.51.10*/ 
    /*0*/ <0.25666,12.44562,-0.30528>,
    /*1*/ <0.24965,12.44604,-0.30524>,<0.2604,12.44967,-0.30964>,<0.25995,12.44116,-0.30096>,
            
    /*2*/ <0.26663,12.66898,-0.08584>,<0.2738,12.6714,-0.08878>,<0.2735,12.66573,-0.08298>,
            
    /*3*/ <0.3435,12.94513,0.04262>,<0.34692,12.94522,0.04044>,<0.3469,12.94351,0.04412>,
            
    /*4*/ <0.4732,13.23014,0.02346>

    /* stem 0.51.11*/ 
    /*0*/ <0.2642,12.5728,-0.31081>,
    /*1*/ <0.26922,12.57231,-0.31509>,<0.26423,12.57754,-0.30619>,<0.25914,12.56854,-0.31115>,
            
    /*2*/ <0.12568,12.75584,-0.50081>,<0.12236,12.75932,-0.49488>,<0.11896,12.75332,-0.49818>,
            
    /*3*/ <-0.02729,12.9613,-0.65385>,<-0.02872,12.9627,-0.65059>,<-0.03058,12.95993,-0.65246>,
            
    /*4*/ <-0.15043,13.21117,-0.75982>

    /* stem 0.51.12*/ 
    /*0*/ <0.26344,12.69416,-0.31741>,
    /*1*/ <0.2624,12.69449,-0.31127>,<0.25974,12.69724,-0.32136>,<0.26818,12.69075,-0.31959>,
            
    /*2*/ <0.43282,12.92037,-0.2965>,<0.43105,12.92221,-0.30322>,<0.43668,12.91788,-0.30204>,
            
    /*3*/ <0.5852,13.15394,-0.35179>,<0.58385,13.15406,-0.35512>,<0.58688,13.15224,-0.35447>,
            
    /*4*/ <0.65292,13.41611,-0.43566>

    /* stem 0.51.13*/ 
    /*0*/ <0.25907,12.80732,-0.32417>,
    /*1*/ <0.2561,12.80691,-0.32922>,<0.26293,12.81168,-0.32338>,<0.25818,12.80338,-0.31991>,
            
    /*2*/ <0.06142,12.96203,-0.22533>,<0.06597,12.96521,-0.22143>,<0.06281,12.95968,-0.21912>,
            
    /*3*/ <-0.10634,13.15075,-0.13013>,<-0.10382,13.15211,-0.12831>,<-0.10577,13.14969,-0.12696>,
            
    /*4*/ <-0.14355,13.41744,-0.11357>

    /* stem 0.51.14*/ 
    /*0*/ <0.25501,12.91256,-0.33046>,
    /*1*/ <0.26019,12.91287,-0.32863>,<0.25103,12.91543,-0.32796>,<0.25381,12.90939,-0.33479>,
            
    /*2*/ <0.3023,13.11123,-0.48664>,<0.29619,13.11293,-0.48619>,<0.29805,13.10891,-0.49075>,
            
    /*3*/ <0.36661,13.33187,-0.60066>,<0.3636,13.33286,-0.60048>,<0.36459,13.33126,-0.60303>,
            
    /*4*/ <0.44705,13.57512,-0.58626>

    /* stem 0.51.15*/ 
    /*0*/ <0.25128,13.00925,-0.33623>,
    /*1*/ <0.24694,13.00918,-0.33461>,<0.25247,13.01229,-0.33953>,<0.25443,13.00629,-0.33456>,
            
    /*2*/ <0.31023,13.17225,-0.16244>,<0.31392,13.17432,-0.16572>,<0.31522,13.17032,-0.16241>,
            
    /*3*/ <0.32275,13.38914,-0.04893>,<0.32454,13.38999,-0.05073>,<0.32536,13.38877,-0.04849>,
            
    /*4*/ <0.35307,13.63241,-0.03198>

    /* stem 0.51.16*/ 
    /*0*/ <0.24078,13.12195,-0.34435>,
    /*1*/ <0.24256,13.12196,-0.3475>,<0.24157,13.1244,-0.34181>,<0.23819,13.11949,-0.34374>,
            
    /*2*/ <0.08378,13.26591,-0.43579>,<0.08312,13.26754,-0.43199>,<0.08086,13.26426,-0.43328>,
            
    /*3*/ <-0.03069,13.463,-0.47897>,<-0.03074,13.46343,-0.47693>,<-0.03229,13.46234,-0.47779>,
            
    /*4*/ <-0.08795,13.68764,-0.48157>

    /* stem 0.51.17*/ 
    /*0*/ <0.22147,13.24532,-0.35498>,
    /*1*/ <0.2219,13.2456,-0.35253>,<0.21949,13.24643,-0.35603>,<0.22301,13.24394,-0.35637>,
            
    /*2*/ <0.34184,13.4212,-0.39449>,<0.34023,13.42176,-0.39682>,<0.34258,13.4201,-0.39705>,
            
    /*3*/ <0.36839,13.63307,-0.43217>,<0.36746,13.63299,-0.43327>,<0.36887,13.63278,-0.4335>,
            
    /*4*/ <0.34836,13.8318,-0.51692>

    /* stem 0.51.18*/ 
    /*0*/ <0.20433,13.35476,-0.36441>,
    /*1*/ <0.20319,13.3545,-0.36536>,<0.20525,13.35594,-0.36464>,<0.20456,13.35385,-0.36324>,
            
    /*2*/ <0.08217,13.47141,-0.25106>,<0.08354,13.47237,-0.25058>,<0.08308,13.47098,-0.24965>,
            
    /*3*/ <0.01116,13.64216,-0.16599>,<0.01197,13.64244,-0.16587>,<0.01158,13.64197,-0.16525>,
            
    /*4*/ <-0.07962,13.82148,-0.13543>

    /* stem 0.51.19*/ 
    /*0*/ <0.18395,13.48497,-0.37564>,
    /*1*/ <0.18427,13.48502,-0.37564>,<0.18377,13.48513,-0.37543>,<0.18382,13.48476,-0.37584>,
            
    /*2*/ <0.16122,13.62114,-0.50257>,<0.16088,13.62122,-0.50243>,<0.16091,13.62097,-0.5027>,
            
    /*3*/ <0.12941,13.79036,-0.57691>,<0.12925,13.79037,-0.57682>,<0.12925,13.7903,-0.57699>,
            
    /*4*/ <0.05465,13.9497,-0.64176>

    /* stem 0.52*/ 
    /*0*/ <-0.03991,11.50632,-0.16694>,
    /*1*/ <-0.05313,11.50509,-0.17801>,<-0.03449,11.51188,-0.18238>,<-0.02334,11.51098,-0.16542>,
            <-0.03509,11.50363,-0.15056>,<-0.0535,11.49999,-0.15835>,
    /*2*/ <-0.17693,11.91978,-0.07071>,<-0.16202,11.92522,-0.07421>,<-0.1531,11.9245,-0.06064>,
            <-0.1625,11.91862,-0.04876>,<-0.17723,11.9157,-0.05498>,
    /*3*/ <-0.30546,12.34348,-0.03248>,<-0.29419,12.34721,-0.03525>,<-0.28791,12.34827,-0.02485>,
            <-0.2953,12.3452,-0.01566>,<-0.30615,12.34224,-0.02037>,
    /*4*/ <-0.32763,12.79006,-0.01448>,<-0.31974,12.79056,-0.01636>,<-0.3155,12.79055,-0.00942>,
            <-0.32078,12.79004,-0.00326>,<-0.32827,12.78974,-0.00638>,
    /*5*/ <-0.31957,13.22992,-0.08371>,<-0.31562,13.22972,-0.08465>,<-0.31349,13.23025,-0.08122>,
            <-0.31613,13.23078,-0.07818>,<-0.31988,13.23058,-0.07972>,
    /*6*/ <-0.23726,13.65437,-0.1936>

    /* stem 0.52.0*/ 
    /*0*/ <-0.06708,11.59536,-0.14436>,
    /*1*/ <-0.05839,11.59797,-0.14418>,<-0.07251,11.59716,-0.13732>,<-0.07034,11.59096,-0.1516>,
            
    /*2*/ <-0.17104,11.97635,-0.32534>,<-0.18045,11.97581,-0.32077>,<-0.17901,11.97168,-0.33029>,
            
    /*3*/ <-0.3137,12.33631,-0.52328>,<-0.31836,12.33579,-0.52094>,<-0.31751,12.33357,-0.5256>,
            
    /*4*/ <-0.41999,12.75659,-0.54378>

    /* stem 0.52.1*/ 
    /*0*/ <-0.0965,11.69178,-0.11992>,
    /*1*/ <-0.10265,11.68855,-0.11458>,<-0.09864,11.69773,-0.12598>,<-0.0882,11.68906,-0.11919>,
            
    /*2*/ <-0.02337,11.99891,0.16004>,<-0.0207,12.00503,0.15244>,<-0.01374,11.99925,0.15697>,
            
    /*3*/ <-0.00597,12.36674,0.36655>,<-0.0047,12.36912,0.36227>,<-0.00109,12.36726,0.36529>,
            
    /*4*/ <-0.10587,12.76565,0.46099>

    /* stem 0.52.2*/ 
    /*0*/ <-0.12132,11.77314,-0.09929>,
    /*1*/ <-0.12031,11.7755,-0.10739>,<-0.119,11.77838,-0.09301>,<-0.12464,11.76553,-0.09746>,
            
    /*2*/ <-0.49749,11.93979,-0.10343>,<-0.49662,11.94171,-0.09384>,<-0.50038,11.93315,-0.0968>,
            
    /*3*/ <-0.72144,12.2685,-0.19972>,<-0.72136,12.26995,-0.19503>,<-0.72496,12.26702,-0.19664>,
            
    /*4*/ <-0.82835,12.60772,-0.40451>

    /* stem 0.52.3*/ 
    /*0*/ <-0.15747,11.89165,-0.06924>,
    /*1*/ <-0.15324,11.89118,-0.06232>,<-0.16527,11.89394,-0.06909>,<-0.15391,11.88982,-0.07631>,
            
    /*2*/ <-0.04437,12.26946,-0.10676>,<-0.05238,12.27129,-0.11127>,<-0.04482,12.26855,-0.11608>,
            
    /*3*/ <0.01783,12.63493,-0.25048>,<0.01366,12.63482,-0.25262>,<0.01748,12.63329,-0.25486>,
            
    /*4*/ <0.02083,13.02704,-0.20084>

    /* stem 0.52.4*/ 
    /*0*/ <-0.18089,11.96771,-0.05786>,
    /*1*/ <-0.188,11.96575,-0.06066>,<-0.17685,11.97362,-0.06117>,<-0.17783,11.96376,-0.05176>,
            
    /*2*/ <-0.35068,12.21609,0.18472>,<-0.34325,12.22134,0.18438>,<-0.3439,12.21477,0.19065>,
            
    /*3*/ <-0.49153,12.53424,0.3532>,<-0.48753,12.53634,0.35266>,<-0.48836,12.53396,0.35645>,
            
    /*4*/ <-0.62882,12.88951,0.41767>

    /* stem 0.52.5*/ 
    /*0*/ <-0.20788,12.05486,-0.05045>,
    /*1*/ <-0.20106,12.05718,-0.05294>,<-0.21155,12.05887,-0.04512>,<-0.21101,12.04852,-0.05328>,
            
    /*2*/ <-0.37058,12.25921,-0.3202>,<-0.37757,12.26033,-0.31498>,<-0.37722,12.25343,-0.32043>,
            
    /*3*/ <-0.56192,12.56923,-0.41345>,<-0.56462,12.56862,-0.41003>,<-0.56558,12.56685,-0.41394>,
            
    /*4*/ <-0.75072,12.87883,-0.51072>

    /* stem 0.52.6*/ 
    /*0*/ <-0.24089,12.16149,-0.04137>,
    /*1*/ <-0.24431,12.1599,-0.03513>,<-0.24391,12.16615,-0.04609>,<-0.23446,12.15842,-0.04288>,
            
    /*2*/ <-0.07362,12.43565,0.12579>,<-0.07336,12.43981,0.11848>,<-0.06705,12.43466,0.12062>,
            
    /*3*/ <0.00299,12.72025,0.33411>,<0.0032,12.72271,0.3307>,<0.00665,12.72076,0.3321>,
            
    /*4*/ <0.03119,12.9754,0.5887>

    /* stem 0.52.7*/ 
    /*0*/ <-0.28196,12.29412,-0.03008>,
    /*1*/ <-0.28317,12.29433,-0.03686>,<-0.27856,12.29928,-0.02703>,<-0.28415,12.28877,-0.02634>,
            
    /*2*/ <-0.58163,12.45711,0.0237>,<-0.57855,12.46041,0.03025>,<-0.58229,12.4534,0.03071>,
            
    /*3*/ <-0.82617,12.69031,0.09604>,<-0.82409,12.69155,0.09919>,<-0.82675,12.68863,0.0996>,
            
    /*4*/ <-1.02775,12.96585,0.04927>

    /* stem 0.52.8*/ 
    /*0*/ <-0.30038,12.39194,-0.02407>,
    /*1*/ <-0.29537,12.39206,-0.01978>,<-0.3057,12.39571,-0.02305>,<-0.30007,12.38804,-0.02939>,
            
    /*2*/ <-0.1551,12.63914,-0.19395>,<-0.16198,12.64157,-0.19613>,<-0.15823,12.63646,-0.20036>,
            
    /*3*/ <-0.12199,12.95686,-0.29024>,<-0.12574,12.95707,-0.2909>,<-0.12338,12.95598,-0.29369>,
            
    /*4*/ <-0.03373,13.27488,-0.25062>

    /* stem 0.52.9*/ 
    /*0*/ <-0.30735,12.51809,-0.01961>,
    /*1*/ <-0.31358,12.51775,-0.01968>,<-0.30438,12.52177,-0.02369>,<-0.30409,12.51476,-0.01546>,
            
    /*2*/ <-0.32703,12.75943,0.18669>,<-0.32089,12.76211,0.18401>,<-0.3207,12.75744,0.1895>,
            
    /*3*/ <-0.30864,13.05813,0.29577>,<-0.30555,13.05862,0.29398>,<-0.3055,13.05738,0.29736>,
            
    /*4*/ <-0.21371,13.36205,0.28423>

    /* stem 0.52.10*/ 
    /*0*/ <-0.31293,12.61909,-0.01603>,
    /*1*/ <-0.30834,12.61948,-0.01981>,<-0.31345,12.623,-0.01157>,<-0.317,12.6148,-0.01673>,
            
    /*2*/ <-0.47395,12.80395,-0.19909>,<-0.47736,12.80629,-0.19359>,<-0.47973,12.80083,-0.19703>,
            
    /*3*/ <-0.67572,12.99683,-0.32623>,<-0.67703,12.99754,-0.32312>,<-0.67832,12.99495,-0.32499>,
            
    /*4*/ <-0.72541,13.28387,-0.41771>

    /* stem 0.52.11*/ 
    /*0*/ <-0.31989,12.74504,-0.01158>,
    /*1*/ <-0.32091,12.74478,-0.00607>,<-0.32256,12.7488,-0.01476>,<-0.3162,12.74152,-0.01391>,
            
    /*2*/ <-0.10755,12.93682,0.04038>,<-0.10865,12.9395,0.03459>,<-0.10441,12.93464,0.03516>,
            
    /*3*/ <-0.01291,13.20418,0.10259>,<-0.01373,13.20518,0.09962>,<-0.01076,13.204,0.10017>,
            
    /*4*/ <0.0932,13.45758,0.1973>

    /* stem 0.52.12*/ 
    /*0*/ <-0.32143,12.86762,-0.02256>,
    /*1*/ <-0.32402,12.86691,-0.02709>,<-0.3169,12.8703,-0.02252>,<-0.32336,12.86563,-0.01809>,
            
    /*2*/ <-0.4627,13.10116,0.01809>,<-0.45795,13.10343,0.02114>,<-0.46226,13.10031,0.02409>,
            
    /*3*/ <-0.54794,13.36333,0.031>,<-0.5454,13.3641,0.03249>,<-0.54787,13.36322,0.03404>,
            
    /*4*/ <-0.51152,13.63383,-0.01022>

    /* stem 0.52.13*/ 
    /*0*/ <-0.32058,12.93631,-0.03373>,
    /*1*/ <-0.31582,12.93654,-0.03197>,<-0.32381,12.94011,-0.0328>,<-0.3221,12.93229,-0.03642>,
            
    /*2*/ <-0.23973,13.05773,-0.25809>,<-0.24505,13.06011,-0.25864>,<-0.24391,13.05489,-0.26105>,
            
    /*3*/ <-0.15494,13.23984,-0.43433>,<-0.15764,13.24096,-0.4345>,<-0.15683,13.23882,-0.43632>,
            
    /*4*/ <-0.0355,13.47159,-0.49229>

    /* stem 0.52.14*/ 
    /*0*/ <-0.31881,13.07912,-0.05693>,
    /*1*/ <-0.32319,13.07942,-0.05541>,<-0.31748,13.08155,-0.06066>,<-0.31577,13.07639,-0.05474>,
            
    /*2*/ <-0.25697,13.27043,0.09206>,<-0.25316,13.27185,0.08856>,<-0.25202,13.2684,0.09251>,
            
    /*3*/ <-0.24313,13.5141,0.146>,<-0.24132,13.51444,0.14406>,<-0.24052,13.51385,0.14655>,
            
    /*4*/ <-0.23145,13.76414,0.14697>

    /* stem 0.52.15*/ 
    /*0*/ <-0.31767,13.17088,-0.07185>,
    /*1*/ <-0.31569,13.17032,-0.07518>,<-0.31658,13.17372,-0.06937>,<-0.32076,13.16862,-0.07099>,
            
    /*2*/ <-0.46074,13.32447,-0.18633>,<-0.46133,13.32673,-0.18245>,<-0.46412,13.32333,-0.18353>,
            
    /*3*/ <-0.55906,13.5272,-0.26656>,<-0.55914,13.52801,-0.26444>,<-0.56089,13.52683,-0.26528>,
            
    /*4*/ <-0.64891,13.73049,-0.35447>

    /* stem 0.52.16*/ 
    /*0*/ <-0.30275,13.30579,-0.10146>,
    /*1*/ <-0.30227,13.30642,-0.09873>,<-0.30407,13.30766,-0.10314>,<-0.3019,13.30329,-0.10251>,
            
    /*2*/ <-0.10642,13.39558,-0.15459>,<-0.10762,13.39641,-0.15753>,<-0.10617,13.39349,-0.1571>,
            
    /*3*/ <0.04211,13.54802,-0.21888>,<0.04127,13.54827,-0.22027>,<0.04245,13.54714,-0.22022>,
            
    /*4*/ <0.13257,13.74366,-0.27323>

    /* stem 0.52.17*/ 
    /*0*/ <-0.28296,13.41111,-0.1293>,
    /*1*/ <-0.28445,13.41104,-0.1306>,<-0.28128,13.41205,-0.12976>,<-0.28316,13.41023,-0.12753>,
            
    /*2*/ <-0.36135,13.58822,-0.05067>,<-0.35924,13.5889,-0.05011>,<-0.36049,13.58768,-0.04862>,
            
    /*3*/ <-0.36423,13.79204,-0.00333>,<-0.3631,13.79201,-0.00314>,<-0.36383,13.7918,-0.00228>,
            
    /*4*/ <-0.37346,13.9936,-0.05711>

    /* stem 0.52.18*/ 
    /*0*/ <-0.26343,13.5151,-0.15678>,
    /*1*/ <-0.26231,13.5149,-0.15673>,<-0.26389,13.51594,-0.15618>,<-0.26409,13.51445,-0.15744>,
            
    /*2*/ <-0.23386,13.63736,-0.30699>,<-0.23491,13.63806,-0.30662>,<-0.23504,13.63706,-0.30746>,
            
    /*3*/ <-0.16666,13.79469,-0.40218>,<-0.16718,13.79504,-0.40198>,<-0.1672,13.7947,-0.40255>,
            
    /*4*/ <-0.06019,13.95674,-0.42968>

    /* stem 0.52.19*/ 
    /*0*/ <-0.24826,13.59587,-0.17813>,
    /*1*/ <-0.24862,13.59601,-0.17785>,<-0.24819,13.59607,-0.17856>,<-0.24796,13.59553,-0.17798>,
            
    /*2*/ <-0.13848,13.72405,-0.10059>,<-0.13819,13.72409,-0.10106>,<-0.13804,13.72373,-0.10068>,
            
    /*3*/ <-0.00379,13.84614,-0.06218>,<-0.00369,13.84611,-0.06243>,<-0.0036,13.84594,-0.06223>,
            
    /*4*/ <0.08321,13.99996,-0.0052>

    /* stem 0.53*/ 
    /*0*/ <-0.0456,11.63288,-0.17418>,
    /*1*/ <-0.03024,11.63357,-0.17421>,<-0.0411,11.63906,-0.16084>,<-0.05818,11.63601,-0.1659>,
            <-0.05788,11.62864,-0.18241>,<-0.04061,11.62714,-0.18755>,
    /*2*/ <-0.05159,12.03352,-0.35303>,<-0.06028,12.03791,-0.34233>,<-0.07395,12.03547,-0.34639>,
            <-0.07371,12.02958,-0.35959>,<-0.05989,12.02837,-0.3637>,
    /*3*/ <-0.13013,12.45529,-0.45163>,<-0.13645,12.45621,-0.44287>,<-0.1466,12.45371,-0.44578>,
            <-0.14654,12.45125,-0.45635>,<-0.13636,12.45223,-0.45996>,
    /*4*/ <-0.23376,12.88038,-0.48954>,<-0.23779,12.87996,-0.48355>,<-0.24452,12.87819,-0.4855>,
            <-0.24465,12.87752,-0.4927>,<-0.238,12.87887,-0.4952>,
    /*5*/ <-0.36203,13.30007,-0.47807>,<-0.36394,13.29942,-0.47507>,<-0.36728,13.29845,-0.47606>,
            <-0.36743,13.2985,-0.47967>,<-0.36419,13.2995,-0.48091>,
    /*6*/ <-0.51022,13.70623,-0.40308>

    /* stem 0.53.0*/ 
    /*0*/ <-0.04832,11.69234,-0.20075>,
    /*1*/ <-0.05464,11.69419,-0.19596>,<-0.04891,11.69328,-0.20883>,<-0.0414,11.68953,-0.19748>,
            
    /*2*/ <0.09364,12.09714,-0.16087>,<0.09746,12.09654,-0.16945>,<0.10247,12.09404,-0.16188>,
            
    /*3*/ <0.18689,12.49435,-0.30156>,<0.18844,12.49257,-0.30564>,<0.19142,12.49315,-0.30204>,
            
    /*4*/ <0.24858,12.88982,-0.46068>

    /* stem 0.53.1*/ 
    /*0*/ <-0.05181,11.76883,-0.23494>,
    /*1*/ <-0.05031,11.76571,-0.24207>,<-0.04832,11.7756,-0.23276>,<-0.05682,11.76518,-0.23>,
            
    /*2*/ <-0.37144,11.98497,-0.40277>,<-0.37011,11.99156,-0.39656>,<-0.37577,11.98462,-0.39472>,
            
    /*3*/ <-0.65522,12.29497,-0.4454>,<-0.65339,12.29716,-0.44182>,<-0.65678,12.29415,-0.44118>,
            
    /*4*/ <-0.77494,12.68813,-0.35091>

    /* stem 0.53.2*/ 
    /*0*/ <-0.05632,11.8674,-0.27901>,
    /*1*/ <-0.05262,11.87027,-0.27298>,<-0.06173,11.87152,-0.28247>,<-0.05461,11.86042,-0.28157>,
            
    /*2*/ <0.22698,12.02939,-0.52354>,<0.2209,12.03022,-0.52987>,<0.22565,12.02282,-0.52927>,
            
    /*3*/ <0.34598,12.33442,-0.76695>,<0.34224,12.33407,-0.76926>,<0.3458,12.33174,-0.77044>,
            
    /*4*/ <0.40533,12.72465,-0.86647>

    /* stem 0.53.3*/ 
    /*0*/ <-0.06261,12.005,-0.34051>,
    /*1*/ <-0.06935,12.00369,-0.34275>,<-0.05767,12.0075,-0.34516>,<-0.0608,12.00382,-0.33361>,
            
    /*2*/ <-0.16794,12.36975,-0.25262>,<-0.16015,12.37229,-0.25423>,<-0.16224,12.36983,-0.24653>,
            
    /*3*/ <-0.30648,12.73256,-0.27075>,<-0.30266,12.734,-0.27162>,<-0.30393,12.73371,-0.26765>,
            
    /*4*/ <-0.44469,13.09607,-0.29505>

    /* stem 0.53.4*/ 
    /*0*/ <-0.07069,12.07096,-0.36189>,
    /*1*/ <-0.06416,12.07153,-0.36446>,<-0.07331,12.07605,-0.35778>,<-0.0746,12.06531,-0.36343>,
            
    /*2*/ <-0.2031,12.24981,-0.67147>,<-0.2092,12.25282,-0.66701>,<-0.21006,12.24566,-0.67078>,
            
    /*3*/ <-0.41008,12.53649,-0.81768>,<-0.41225,12.53669,-0.81425>,<-0.41346,12.53427,-0.81729>,
            
    /*4*/ <-0.49689,12.90635,-0.78781>

    /* stem 0.53.5*/ 
    /*0*/ <-0.09034,12.18074,-0.38754>,
    /*1*/ <-0.09369,12.1815,-0.38174>,<-0.09316,12.18271,-0.39333>,<-0.08418,12.17802,-0.38754>,
            
    /*2*/ <0.05507,12.51518,-0.34192>,<0.05542,12.51599,-0.34965>,<0.06141,12.51286,-0.34579>,
            
    /*3*/ <-0.02098,12.87372,-0.35027>,<-0.02094,12.87366,-0.35416>,<-0.01767,12.8744,-0.35219>,
            
    /*4*/ <-0.10739,13.22982,-0.37923>

    /* stem 0.53.6*/ 
    /*0*/ <-0.10766,12.27745,-0.41013>,
    /*1*/ <-0.10873,12.27582,-0.4163>,<-0.10446,12.28291,-0.40874>,<-0.10977,12.27363,-0.40536>,
            
    /*2*/ <-0.41577,12.45461,-0.40787>,<-0.41293,12.45934,-0.40283>,<-0.41647,12.45316,-0.40057>,
            
    /*3*/ <-0.59609,12.74401,-0.30167>,<-0.59328,12.74493,-0.29938>,<-0.59606,12.74275,-0.29815>,
            
    /*4*/ <-0.57017,13.0967,-0.2649>

    /* stem 0.53.7*/ 
    /*0*/ <-0.13281,12.41797,-0.44296>,
    /*1*/ <-0.12824,12.41965,-0.43931>,<-0.13804,12.4211,-0.44292>,<-0.13217,12.41318,-0.44666>,
            
    /*2*/ <-0.01031,12.62176,-0.68297>,<-0.01684,12.62273,-0.68538>,<-0.01292,12.61744,-0.68787>,
            
    /*3*/ <0.13948,12.87625,-0.84489>,<0.13641,12.87713,-0.84637>,<0.13855,12.87485,-0.84798>,
            
    /*4*/ <0.21127,13.17015,-0.99573>

    /* stem 0.53.8*/ 
    /*0*/ <-0.16304,12.55451,-0.46032>,
    /*1*/ <-0.16861,12.55321,-0.46009>,<-0.16103,12.55776,-0.46458>,<-0.15948,12.55254,-0.45629>,
            
    /*2*/ <-0.22087,12.81661,-0.28444>,<-0.21582,12.81965,-0.28743>,<-0.21478,12.81617,-0.28191>,
            
    /*3*/ <-0.17418,13.12942,-0.22287>,<-0.17155,13.12943,-0.22487>,<-0.17118,13.12874,-0.22166>,
            
    /*4*/ <-0.16091,13.44987,-0.22466>

    /* stem 0.53.9*/ 
    /*0*/ <-0.19302,12.68131,-0.47164>,
    /*1*/ <-0.18906,12.68193,-0.47526>,<-0.19408,12.68525,-0.46812>,<-0.19591,12.67676,-0.47156>,
            
    /*2*/ <-0.389,12.80409,-0.6708>,<-0.39235,12.80631,-0.66604>,<-0.39357,12.80065,-0.66833>,
            
    /*3*/ <-0.57385,13.0098,-0.8005>,<-0.57506,13.01049,-0.79772>,<-0.57634,13.00825,-0.79945>,
            
    /*4*/ <-0.68263,13.29484,-0.81164>

    /* stem 0.53.10*/ 
    /*0*/ <-0.22234,12.80535,-0.48272>,
    /*1*/ <-0.2231,12.80561,-0.47772>,<-0.22579,12.80722,-0.48592>,<-0.21812,12.8032,-0.48453>,
            
    /*2*/ <-0.08925,13.06263,-0.47266>,<-0.09104,13.06371,-0.47812>,<-0.08593,13.06103,-0.4772>,
            
    /*3*/ <-0.09882,13.34838,-0.52239>,<-0.09992,13.34789,-0.52506>,<-0.09703,13.34805,-0.52467>,
            
    /*4*/ <-0.09043,13.63746,-0.53848>

    /* stem 0.53.11*/ 
    /*0*/ <-0.25555,12.932,-0.48787>,
    /*1*/ <-0.25799,12.93138,-0.49188>,<-0.25265,12.93573,-0.48741>,<-0.25599,12.9289,-0.48432>,
            
    /*2*/ <-0.46382,13.07921,-0.38749>,<-0.46027,13.08211,-0.38451>,<-0.46249,13.07756,-0.38245>,
            
    /*3*/ <-0.63238,13.29275,-0.41192>,<-0.63066,13.29429,-0.41046>,<-0.63263,13.29287,-0.4092>,
            
    /*4*/ <-0.77691,13.49939,-0.5183>

    /* stem 0.53.12*/ 
    /*0*/ <-0.28377,13.02669,-0.48531>,
    /*1*/ <-0.27966,13.02788,-0.48393>,<-0.2874,13.02839,-0.48328>,<-0.28424,13.02381,-0.48872>,
            
    /*2*/ <-0.28196,13.22761,-0.65381>,<-0.28712,13.22796,-0.65338>,<-0.28502,13.2249,-0.657>,
            
    /*3*/ <-0.23717,13.44789,-0.7875>,<-0.23971,13.44842,-0.78749>,<-0.23869,13.44704,-0.78943>,
            
    /*4*/ <-0.25389,13.7064,-0.82859>

    /* stem 0.53.13*/ 
    /*0*/ <-0.31925,13.14577,-0.4821>,
    /*1*/ <-0.32296,13.14462,-0.48052>,<-0.31903,13.14895,-0.48481>,<-0.31577,13.14374,-0.48095>,
            
    /*2*/ <-0.29094,13.30321,-0.29348>,<-0.28832,13.30609,-0.29635>,<-0.28615,13.30262,-0.29377>,
            
    /*3*/ <-0.31244,13.4577,-0.10231>,<-0.31116,13.45937,-0.1035>,<-0.31004,13.45777,-0.10207>,
            
    /*4*/ <-0.32362,13.64815,0.05533>

    /* stem 0.53.14*/ 
    /*0*/ <-0.34176,13.22128,-0.48006>,
    /*1*/ <-0.34015,13.22185,-0.48328>,<-0.34092,13.22339,-0.47721>,<-0.3442,13.2186,-0.47969>,
            
    /*2*/ <-0.51483,13.37187,-0.54283>,<-0.51535,13.3729,-0.53878>,<-0.51753,13.3697,-0.54043>,
            
    /*3*/ <-0.6588,13.56097,-0.55642>,<-0.65877,13.56115,-0.55432>,<-0.66024,13.55997,-0.55525>,
            
    /*4*/ <-0.7402,13.78428,-0.55027>

    /* stem 0.53.15*/ 
    /*0*/ <-0.38014,13.34168,-0.47014>,
    /*1*/ <-0.37946,13.34143,-0.46748>,<-0.38238,13.3431,-0.47086>,<-0.37857,13.34049,-0.47207>,
            
    /*2*/ <-0.25714,13.52681,-0.48222>,<-0.25908,13.52792,-0.48448>,<-0.25654,13.52618,-0.48529>,
            
    /*3*/ <-0.22497,13.73587,-0.55359>,<-0.22617,13.73571,-0.55461>,<-0.2247,13.73533,-0.55506>,
            
    /*4*/ <-0.23782,13.95521,-0.58866>

    /* stem 0.53.16*/ 
    /*0*/ <-0.42431,13.46548,-0.44736>,
    /*1*/ <-0.42572,13.46518,-0.44848>,<-0.42347,13.46709,-0.44737>,<-0.42374,13.46416,-0.44625>,
            
    /*2*/ <-0.55498,13.53283,-0.30223>,<-0.55348,13.53411,-0.30149>,<-0.55366,13.53215,-0.30074>,
            
    /*3*/ <-0.67248,13.66461,-0.19502>,<-0.67162,13.66516,-0.19476>,<-0.67195,13.66437,-0.19414>,
            
    /*4*/ <-0.73853,13.83767,-0.10334>

    /* stem 0.53.17*/ 
    /*0*/ <-0.46284,13.57345,-0.4275>,
    /*1*/ <-0.4619,13.57379,-0.42753>,<-0.46349,13.57382,-0.42683>,<-0.46314,13.57274,-0.42815>,
            
    /*2*/ <-0.51515,13.70982,-0.55308>,<-0.51621,13.70984,-0.55261>,<-0.51598,13.70912,-0.55349>,
            
    /*3*/ <-0.50012,13.87933,-0.64275>,<-0.50066,13.87947,-0.64258>,<-0.50057,13.87919,-0.64309>,
            
    /*4*/ <-0.49074,14.06249,-0.70162>

    /* stem 0.53.18*/ 
    /*0*/ <-0.49746,13.67046,-0.40966>,
    /*1*/ <-0.49764,13.67037,-0.40948>,<-0.49753,13.67067,-0.40982>,<-0.49721,13.67036,-0.40967>,
            
    /*2*/ <-0.43908,13.78744,-0.28583>,<-0.43901,13.78765,-0.28606>,<-0.4388,13.78744,-0.28596>,
            
    /*3*/ <-0.41814,13.90689,-0.15275>,<-0.4181,13.90699,-0.15285>,<-0.41799,13.90691,-0.15279>,
            
    /*4*/ <-0.46397,14.02157,-0.02174>

    /* stem 0.54*/ 
    /*0*/ <-0.05307,11.79907,-0.18369>,
    /*1*/ <-0.06293,11.7991,-0.1754>,<-0.06373,11.80222,-0.1902>,<-0.0498,11.80098,-0.19599>,
            <-0.04039,11.7971,-0.18478>,<-0.04851,11.79593,-0.17206>,
    /*2*/ <0.01065,12.2138,-0.09333>,<0.01002,12.2163,-0.10516>,<0.02116,12.21531,-0.1098>,
            <0.02869,12.2122,-0.10083>,<0.02219,12.21126,-0.09065>,
    /*3*/ <0.04671,12.6391,-0.05016>,<0.04612,12.6401,-0.05917>,<0.05453,12.63979,-0.06258>,
            <0.06032,12.6386,-0.05569>,<0.05549,12.63817,-0.04801>,
    /*4*/ <0.02738,13.06302,0.00688>,<0.02694,13.06383,0.00089>,<0.03254,13.06442,-0.00134>,
            <0.03645,13.06398,0.00327>,<0.03326,13.06312,0.00835>,
    /*5*/ <-0.03287,13.48715,0.02954>,<-0.03307,13.4873,0.02652>,<-0.03029,13.48777,0.02542>,
            <-0.02837,13.48792,0.02775>,<-0.02996,13.48754,0.0303>,
    /*6*/ <-0.1771,13.89061,0.04479>

    /* stem 0.54.0*/ 
    /*0*/ <-0.0448,11.84697,-0.17401>,
    /*1*/ <-0.04351,11.84809,-0.18066>,<-0.0406,11.84953,-0.16923>,<-0.05029,11.8433,-0.17215>,
            
    /*2*/ <-0.27581,12.20138,-0.16368>,<-0.27387,12.20233,-0.15606>,<-0.28032,12.19818,-0.158>,
            
    /*3*/ <-0.5265,12.53277,-0.07974>,<-0.52528,12.53277,-0.07597>,<-0.52844,12.53064,-0.07703>,
            
    /*4*/ <-0.79132,12.85636,-0.0153>

    /* stem 0.54.1*/ 
    /*0*/ <-0.02291,11.97373,-0.14842>,
    /*1*/ <-0.01977,11.97207,-0.14291>,<-0.02713,11.97875,-0.14841>,<-0.02183,11.97036,-0.15394>,
            
    /*2*/ <0.28226,12.22736,-0.24083>,<0.27736,12.23181,-0.2445>,<0.28089,12.22622,-0.24819>,
            
    /*3*/ <0.53121,12.54604,-0.2905>,<0.52845,12.54794,-0.29225>,<0.53082,12.54578,-0.29426>,
            
    /*4*/ <0.67577,12.91347,-0.19149>

    /* stem 0.54.2*/ 
    /*0*/ <-0.01061,12.04492,-0.13405>,
    /*1*/ <-0.01649,12.04635,-0.13609>,<-0.0058,12.04899,-0.13509>,<-0.00955,12.03944,-0.13096>,
            
    /*2*/ <-0.09125,12.22615,0.21169>,<-0.08412,12.2279,0.21235>,<-0.08662,12.22154,0.2151>,
            
    /*3*/ <-0.12645,12.51287,0.48613>,<-0.12281,12.51344,0.48602>,<-0.12423,12.511,0.48839>,
            
    /*4*/ <-0.20985,12.89154,0.57544>

    /* stem 0.54.3*/ 
    /*0*/ <0.00723,12.14823,-0.11319>,
    /*1*/ <0.01295,12.14768,-0.11534>,<0.00623,12.15099,-0.10779>,<0.0025,12.14602,-0.11642>,
            
    /*2*/ <-0.02407,12.48713,-0.29479>,<-0.02855,12.48934,-0.28976>,<-0.03103,12.48603,-0.29551>,
            
    /*3*/ <-0.0104,12.8596,-0.39352>,<-0.01262,12.8604,-0.39087>,<-0.0139,12.8596,-0.39408>,
            
    /*4*/ <0.02426,13.24355,-0.40852>

    /* stem 0.54.4*/ 
    /*0*/ <0.02325,12.27255,-0.09376>,
    /*1*/ <0.02032,12.27225,-0.08871>,<0.02192,12.27668,-0.09768>,<0.02753,12.26871,-0.09489>,
            
    /*2*/ <0.2676,12.50049,0.06629>,<0.26867,12.50344,0.06031>,<0.27241,12.49813,0.06217>,
            
    /*3*/ <0.40358,12.80605,0.22433>,<0.40402,12.80745,0.22129>,<0.4065,12.80563,0.22268>,
            
    /*4*/ <0.35512,13.17277,0.24634>

    /* stem 0.54.5*/ 
    /*0*/ <0.03343,12.39946,-0.08038>,
    /*1*/ <0.03249,12.4001,-0.08582>,<0.03765,12.40214,-0.07795>,<0.03014,12.39613,-0.07737>,
            
    /*2*/ <-0.18157,12.6743,-0.01431>,<-0.17813,12.67565,-0.00906>,<-0.18314,12.67164,-0.00868>,
            
    /*3*/ <-0.36002,12.97223,-0.08162>,<-0.35868,12.97362,-0.07906>,<-0.36145,12.97203,-0.07876>,
            
    /*4*/ <-0.37435,13.32588,-0.11328>

    /* stem 0.54.6*/ 
    /*0*/ <0.04075,12.4908,-0.07076>,
    /*1*/ <0.04482,12.49012,-0.06735>,<0.03651,12.49374,-0.06931>,<0.04091,12.48855,-0.07561>,
            
    /*2*/ <0.19589,12.77208,-0.19408>,<0.19035,12.77449,-0.19539>,<0.19328,12.77103,-0.19959>,
            
    /*3*/ <0.25292,13.10273,-0.27243>,<0.24989,13.10316,-0.27288>,<0.25169,13.10229,-0.27524>,
            
    /*4*/ <0.26251,13.44167,-0.33165>

    /* stem 0.54.7*/ 
    /*0*/ <0.04851,12.58771,-0.06054>,
    /*1*/ <0.04339,12.58812,-0.06052>,<0.05131,12.5906,-0.06373>,<0.05084,12.5844,-0.05737>,
            
    /*2*/ <0.06491,12.82476,0.17184>,<0.07019,12.82641,0.1697>,<0.06988,12.82228,0.17394>,
            
    /*3*/ <0.02554,13.14835,0.23289>,<0.02815,13.14893,0.23162>,<0.02801,13.14836,0.23452>,
            
    /*4*/ <0.04011,13.4799,0.21084>

    /* stem 0.54.8*/ 
    /*0*/ <0.05058,12.68017,-0.04944>,
    /*1*/ <0.05433,12.68079,-0.05257>,<0.05027,12.68294,-0.04538>,<0.04712,12.67679,-0.05039>,
            
    /*2*/ <-0.11753,12.89938,-0.21324>,<-0.12024,12.90081,-0.20844>,<-0.12234,12.89671,-0.21178>,
            
    /*3*/ <-0.18869,13.16133,-0.38315>,<-0.19015,13.16238,-0.38094>,<-0.19147,13.16077,-0.38287>,
            
    /*4*/ <-0.20135,13.46698,-0.4807>

    /* stem 0.54.9*/ 
    /*0*/ <0.04205,12.84997,-0.02595>,
    /*1*/ <0.04127,12.84932,-0.02152>,<0.03998,12.85338,-0.02815>,<0.04489,12.84722,-0.0282>,
            
    /*2*/ <0.27078,13.03204,0.0438>,<0.26991,13.03475,0.03938>,<0.27319,13.03064,0.03935>,
            
    /*3*/ <0.39926,13.25005,0.20398>,<0.39902,13.2517,0.20195>,<0.40119,13.25024,0.2022>,
            
    /*4*/ <0.44503,13.52739,0.31088>

    /* stem 0.54.10*/ 
    /*0*/ <0.03522,12.98601,-0.00713>,
    /*1*/ <0.03308,12.98641,-0.01079>,<0.03837,12.98871,-0.00621>,<0.0342,12.98291,-0.0044>,
            
    /*2*/ <-0.15188,13.15939,0.11784>,<-0.14836,13.16093,0.1209>,<-0.15114,13.15706,0.1221>,
            
    /*3*/ <-0.2772,13.37426,0.25569>,<-0.27514,13.37464,0.25698>,<-0.27686,13.3731,0.25783>,
            
    /*4*/ <-0.3579,13.6348,0.33441>

    /* stem 0.54.11*/ 
    /*0*/ <0.02181,13.12845,0.00732>,
    /*1*/ <0.02547,13.12891,0.00871>,<0.01876,13.1301,0.00921>,<0.02119,13.12634,0.00405>,
            
    /*2*/ <0.05251,13.34924,-0.13921>,<0.04804,13.35003,-0.13888>,<0.04966,13.34752,-0.14232>,
            
    /*3*/ <0.0475,13.60244,-0.22312>,<0.04524,13.60251,-0.2228>,<0.04609,13.60186,-0.22481>,
            
    /*4*/ <0.01431,13.86702,-0.21726>

    /* stem 0.54.12*/ 
    /*0*/ <0.00932,13.21352,0.0122>,
    /*1*/ <0.00582,13.21294,0.01344>,<0.01,13.2163,0.00976>,<0.01213,13.21133,0.01339>,
            
    /*2*/ <0.04956,13.37386,0.20823>,<0.05235,13.3761,0.20578>,<0.05377,13.37278,0.2082>,
            
    /*3*/ <0.0519,13.59024,0.34559>,<0.05326,13.59114,0.34417>,<0.05404,13.59005,0.34588>,
            
    /*4*/ <0.02471,13.83337,0.42233>

    /* stem 0.54.13*/ 
    /*0*/ <-0.01004,13.34534,0.01975>,
    /*1*/ <-0.00833,13.34576,0.0168>,<-0.0096,13.34758,0.02233>,<-0.01218,13.34268,0.02014>,
            
    /*2*/ <-0.18982,13.47869,-0.06796>,<-0.19067,13.47991,-0.06428>,<-0.19239,13.47663,-0.06574>,
            
    /*3*/ <-0.34061,13.65016,-0.14281>,<-0.34095,13.6507,-0.14093>,<-0.34209,13.64932,-0.14179>,
            
    /*4*/ <-0.44931,13.86031,-0.18544>

    /* stem 0.54.14*/ 
    /*0*/ <-0.02348,13.43693,0.025>,
    /*1*/ <-0.02299,13.43684,0.02785>,<-0.02591,13.43812,0.024>,<-0.02154,13.43583,0.02317>,
            
    /*2*/ <0.08122,13.64069,0.01552>,<0.07928,13.64154,0.01295>,<0.08219,13.64002,0.0124>,
            
    /*3*/ <0.12532,13.85319,-0.0603>,<0.12418,13.853,-0.0615>,<0.12577,13.85257,-0.06179>,
            
    /*4*/ <0.17275,14.07715,-0.05689>

    /* stem 0.54.15*/ 
    /*0*/ <-0.05565,13.55573,0.03076>,
    /*1*/ <-0.05719,13.55523,0.02937>,<-0.05464,13.55762,0.03061>,<-0.05511,13.55435,0.03231>,
            
    /*2*/ <-0.20243,13.64399,0.15976>,<-0.20073,13.64558,0.16059>,<-0.20104,13.64341,0.16172>,
            
    /*3*/ <-0.32553,13.79146,0.25513>,<-0.32452,13.79212,0.25542>,<-0.32494,13.79126,0.2562>,
            
    /*4*/ <-0.44346,13.95667,0.32413>

    /* stem 0.54.16*/ 
    /*0*/ <-0.08826,13.64566,0.03453>,
    /*1*/ <-0.08679,13.6462,0.03454>,<-0.08934,13.6463,0.03547>,<-0.08866,13.64449,0.03357>,
            
    /*2*/ <-0.13414,13.7799,-0.11058>,<-0.13584,13.77997,-0.10997>,<-0.13539,13.77876,-0.11123>,
            
    /*3*/ <-0.16464,13.91711,-0.25683>,<-0.1655,13.91719,-0.25657>,<-0.16528,13.91658,-0.2572>,
            
    /*4*/ <-0.19184,14.06497,-0.39311>

    /* stem 0.54.17*/ 
    /*0*/ <-0.11729,13.7257,0.03788>,
    /*1*/ <-0.11804,13.7254,0.03855>,<-0.11749,13.72643,0.03715>,<-0.11633,13.72527,0.03794>,
            
    /*2*/ <-0.06355,13.86301,0.16195>,<-0.06319,13.8637,0.16102>,<-0.06241,13.86292,0.16155>,
            
    /*3*/ <-0.04409,14.02063,0.27103>,<-0.04391,14.02094,0.27055>,<-0.0435,14.02066,0.27089>,
            
    /*4*/ <-0.04159,14.19604,0.35082>

    /* stem 0.54.18*/ 
    /*0*/ <-0.15054,13.81738,0.04172>,
    /*1*/ <-0.15046,13.81742,0.04126>,<-0.15041,13.81772,0.04201>,<-0.15074,13.81699,0.04189>,
            
    /*2*/ <-0.31411,13.89239,0.02235>,<-0.31408,13.89259,0.02285>,<-0.31429,13.8921,0.02277>,
            
    /*3*/ <-0.43644,14.0255,0.01372>,<-0.43638,14.02557,0.01397>,<-0.43658,14.02539,0.01392>,
            
    /*4*/ <-0.54947,14.16677,0.01934>

    /* stem 0.55*/ 
    /*0*/ <-0.0585,11.91981,-0.19059>,
    /*1*/ <-0.05658,11.91927,-0.20147>,<-0.04819,11.92338,-0.19242>,<-0.05406,11.92255,-0.18084>,
            <-0.06606,11.91793,-0.18274>,<-0.06762,11.9159,-0.19549>,
    /*2*/ <-0.20169,12.31341,-0.24432>,<-0.19498,12.3167,-0.23708>,<-0.19967,12.31603,-0.22782>,
            <-0.20928,12.31233,-0.22933>,<-0.21052,12.31071,-0.23953>,
    /*3*/ <-0.29437,12.72306,-0.28567>,<-0.28912,12.72483,-0.28016>,<-0.29276,12.72474,-0.27326>,
            <-0.30024,12.72293,-0.27449>,<-0.30124,12.72189,-0.28216>,
    /*4*/ <-0.33465,13.1412,-0.32653>,<-0.33108,13.14192,-0.32282>,<-0.33354,13.14215,-0.31824>,
            <-0.33863,13.14158,-0.31912>,<-0.33932,13.14098,-0.32425>,
    /*5*/ <-0.37162,13.5553,-0.39802>,<-0.36983,13.55579,-0.39619>,<-0.37107,13.55608,-0.39392>,
            <-0.37362,13.55578,-0.39435>,<-0.37396,13.5553,-0.39688>,
    /*6*/ <-0.35303,13.97391,-0.45003>

    /* stem 0.55.0*/ 
    /*0*/ <-0.08285,11.98609,-0.19817>,
    /*1*/ <-0.08016,11.98764,-0.19321>,<-0.08825,11.98802,-0.19929>,<-0.08013,11.9826,-0.202>,
            
    /*2*/ <0.07731,12.31869,-0.38485>,<0.07191,12.31895,-0.3889>,<0.07732,12.31533,-0.39071>,
            
    /*3*/ <0.12541,12.70957,-0.51076>,<0.12259,12.70933,-0.51261>,<0.12558,12.70853,-0.51397>,
            
    /*4*/ <0.19835,13.10499,-0.6071>

    /* stem 0.55.1*/ 
    /*0*/ <-0.11345,12.06942,-0.20769>,
    /*1*/ <-0.11844,12.06739,-0.20947>,<-0.11129,12.07409,-0.21006>,<-0.11064,12.06678,-0.20354>,
            
    /*2*/ <-0.30714,12.2948,0.06446>,<-0.30237,12.29927,0.06407>,<-0.30194,12.2944,0.06842>,
            
    /*3*/ <-0.40235,12.6687,0.18342>,<-0.39938,12.66975,0.18254>,<-0.39989,12.66865,0.18558>,
            
    /*4*/ <-0.49202,13.05006,0.08998>

    /* stem 0.55.2*/ 
    /*0*/ <-0.15578,12.18464,-0.22085>,
    /*1*/ <-0.15097,12.18618,-0.22283>,<-0.15793,12.18727,-0.21663>,<-0.15842,12.18048,-0.22309>,
            
    /*2*/ <-0.33102,12.42992,-0.46536>,<-0.33566,12.43065,-0.46123>,<-0.33598,12.42612,-0.46554>,
            
    /*3*/ <-0.53916,12.74381,-0.56138>,<-0.54097,12.74339,-0.55886>,<-0.54174,12.74205,-0.56158>,
            
    /*4*/ <-0.67668,13.10536,-0.59035>

    /* stem 0.55.3*/ 
    /*0*/ <-0.17964,12.24962,-0.22828>,
    /*1*/ <-0.18217,12.24921,-0.22366>,<-0.18227,12.25108,-0.23261>,<-0.17448,12.24855,-0.22856>,
            
    /*2*/ <-0.10219,12.61312,-0.15013>,<-0.10226,12.61436,-0.15609>,<-0.09706,12.61268,-0.15339>,
            
    /*3*/ <-0.10341,12.96315,-0.00527>,<-0.10348,12.96433,-0.00808>,<-0.10081,12.96378,-0.00672>,
            
    /*4*/ <-0.20228,13.29379,0.15256>

    /* stem 0.55.4*/ 
    /*0*/ <-0.2125,12.355,-0.23999>,
    /*1*/ <-0.21332,12.3543,-0.24493>,<-0.20941,12.35869,-0.23844>,<-0.21478,12.35203,-0.2366>,
            
    /*2*/ <-0.49628,12.58662,-0.22983>,<-0.49367,12.58956,-0.22551>,<-0.49725,12.58511,-0.22428>,
            
    /*3*/ <-0.63981,12.91125,-0.13469>,<-0.63773,12.91159,-0.13268>,<-0.64023,12.91028,-0.13197>,
            
    /*4*/ <-0.75752,13.23996,-0.02314>

    /* stem 0.55.5*/ 
    /*0*/ <-0.24245,12.48788,-0.25411>,
    /*1*/ <-0.2389,12.489,-0.25111>,<-0.24654,12.49036,-0.25401>,<-0.24191,12.48428,-0.25722>,
            
    /*2*/ <-0.11044,12.71185,-0.48845>,<-0.11553,12.71276,-0.49038>,<-0.11245,12.7087,-0.49252>,
            
    /*3*/ <-0.12196,12.96177,-0.73454>,<-0.12469,12.96143,-0.73478>,<-0.12297,12.95995,-0.73636>,
            
    /*4*/ <-0.18094,13.24704,-0.92853>

    /* stem 0.55.6*/ 
    /*0*/ <-0.26643,12.59428,-0.26542>,
    /*1*/ <-0.27089,12.59328,-0.26535>,<-0.26474,12.597,-0.26868>,<-0.26365,12.59255,-0.26223>,
            
    /*2*/ <-0.32656,12.86212,-0.0702>,<-0.32246,12.86461,-0.07242>,<-0.32174,12.86164,-0.06812>,
            
    /*3*/ <-0.38106,13.16068,0.07611>,<-0.37896,13.16168,0.07486>,<-0.37867,13.16057,0.07724>,
            
    /*4*/ <-0.53727,13.44652,0.16002>

    /* stem 0.55.7*/ 
    /*0*/ <-0.28757,12.68812,-0.27539>,
    /*1*/ <-0.28428,12.68856,-0.27824>,<-0.28794,12.69089,-0.27202>,<-0.2905,12.6849,-0.27591>,
            
    /*2*/ <-0.46922,12.88518,-0.45965>,<-0.47167,12.88674,-0.4555>,<-0.47337,12.88275,-0.45809>,
            
    /*3*/ <-0.64419,13.1337,-0.57617>,<-0.64514,13.13412,-0.57386>,<-0.64632,13.13254,-0.57545>,
            
    /*4*/ <-0.69414,13.45454,-0.59186>

    /* stem 0.55.8*/ 
    /*0*/ <-0.3015,12.7859,-0.28557>,
    /*1*/ <-0.30225,12.78625,-0.28147>,<-0.30348,12.7884,-0.28829>,<-0.29877,12.78304,-0.28697>,
            
    /*2*/ <-0.07058,12.9959,-0.25842>,<-0.0714,12.99733,-0.26296>,<-0.06826,12.99376,-0.26208>,
            
    /*3*/ <0.06945,13.26992,-0.20225>,<0.06898,13.27063,-0.20451>,<0.07105,13.26947,-0.204>,
            
    /*4*/ <0.16742,13.5657,-0.16911>

    /* stem 0.55.9*/ 
    /*0*/ <-0.31398,12.91663,-0.29903>,
    /*1*/ <-0.31591,12.91609,-0.30242>,<-0.31125,12.91945,-0.29875>,<-0.31476,12.91433,-0.29593>,
            
    /*2*/ <-0.52412,13.10836,-0.21206>,<-0.52101,13.1106,-0.20962>,<-0.52335,13.10719,-0.20774>,
            
    /*3*/ <-0.6792,13.3592,-0.17398>,<-0.67746,13.36011,-0.17282>,<-0.67908,13.35894,-0.17173>,
            
    /*4*/ <-0.82636,13.61226,-0.12079>

    /* stem 0.55.10*/ 
    /*0*/ <-0.32655,13.04842,-0.3126>,
    /*1*/ <-0.32312,13.04888,-0.31136>,<-0.3293,13.05045,-0.31121>,<-0.32725,13.04594,-0.31524>,
            
    /*2*/ <-0.2792,13.245,-0.50844>,<-0.28332,13.24605,-0.50834>,<-0.28196,13.24304,-0.51102>,
            
    /*3*/ <-0.23691,13.49923,-0.62087>,<-0.23899,13.49965,-0.62072>,<-0.23822,13.49875,-0.62248>,
            
    /*4*/ <-0.27189,13.77535,-0.66416>

    /* stem 0.55.11*/ 
    /*0*/ <-0.33851,13.17628,-0.32837>,
    /*1*/ <-0.34174,13.17621,-0.32719>,<-0.33768,13.17838,-0.33097>,<-0.33611,13.17426,-0.32695>,
            
    /*2*/ <-0.28148,13.36846,-0.15358>,<-0.27877,13.3699,-0.15611>,<-0.27773,13.36716,-0.15343>,
            
    /*3*/ <-0.26084,13.55538,0.03394>,<-0.25946,13.55632,0.03287>,<-0.25892,13.55494,0.03419>,
            
    /*4*/ <-0.18935,13.79512,0.12519>

    /* stem 0.55.12*/ 
    /*0*/ <-0.34921,13.29749,-0.34994>,
    /*1*/ <-0.34759,13.29714,-0.35269>,<-0.34854,13.29993,-0.34797>,<-0.35152,13.29539,-0.34915>,
            
    /*2*/ <-0.51805,13.4395,-0.46991>,<-0.51868,13.44136,-0.46676>,<-0.52066,13.43833,-0.46755>,
            
    /*3*/ <-0.65216,13.63431,-0.55468>,<-0.65226,13.635,-0.55296>,<-0.65357,13.63383,-0.55357>,
            
    /*4*/ <-0.77444,13.8181,-0.67406>

    /* stem 0.55.13*/ 
    /*0*/ <-0.36006,13.42025,-0.37178>,
    /*1*/ <-0.35957,13.4208,-0.36894>,<-0.36214,13.42173,-0.37323>,<-0.35846,13.41822,-0.37318>,
            
    /*2*/ <-0.20166,13.58582,-0.4287>,<-0.20337,13.58644,-0.43156>,<-0.20092,13.58411,-0.43153>,
            
    /*3*/ <-0.07363,13.74565,-0.54724>,<-0.07475,13.74561,-0.54852>,<-0.07342,13.74455,-0.54852>,
            
    /*4*/ <0.0346,13.93821,-0.63015>

    /* stem 0.55.14*/ 
    /*0*/ <-0.36833,13.5139,-0.38845>,
    /*1*/ <-0.37018,13.51346,-0.38997>,<-0.36667,13.5156,-0.38899>,<-0.36814,13.51263,-0.38637>,
            
    /*2*/ <-0.49356,13.6682,-0.28369>,<-0.49123,13.66962,-0.28303>,<-0.4922,13.66764,-0.28129>,
            
    /*3*/ <-0.54756,13.88521,-0.26161>,<-0.5462,13.88553,-0.2614>,<-0.54702,13.88522,-0.2603>,
            
    /*4*/ <-0.54012,14.10925,-0.27757>

    /* stem 0.55.15*/ 
    /*0*/ <-0.36988,13.60277,-0.40198>,
    /*1*/ <-0.36792,13.60269,-0.40195>,<-0.37082,13.60414,-0.40092>,<-0.3709,13.60149,-0.40306>,
            
    /*2*/ <-0.36033,13.73681,-0.5683>,<-0.36226,13.73778,-0.56762>,<-0.36232,13.73602,-0.56904>,
            
    /*3*/ <-0.31703,13.87861,-0.72208>,<-0.31797,13.87918,-0.72182>,<-0.318,13.87835,-0.72259>,
            
    /*4*/ <-0.27749,14.07235,-0.80347>

    /* stem 0.55.16*/ 
    /*0*/ <-0.36506,13.70907,-0.41574>,
    /*1*/ <-0.36614,13.70923,-0.41486>,<-0.36509,13.70966,-0.41701>,<-0.36394,13.70831,-0.41535>,
            
    /*2*/ <-0.27988,13.87462,-0.3401>,<-0.27918,13.8749,-0.34153>,<-0.27842,13.874,-0.34043>,
            
    /*3*/ <-0.2134,14.04849,-0.26463>,<-0.21305,14.04867,-0.26534>,<-0.21264,14.04826,-0.26476>,
            
    /*4*/ <-0.23622,14.2446,-0.22779>

    /* stem 0.55.17*/ 
    /*0*/ <-0.36101,13.79811,-0.42727>,
    /*1*/ <-0.36084,13.79798,-0.42818>,<-0.36053,13.79874,-0.42679>,<-0.36166,13.7976,-0.42684>,
            
    /*2*/ <-0.4921,13.92893,-0.47046>,<-0.49189,13.92944,-0.46954>,<-0.49264,13.92867,-0.46957>,
            
    /*3*/ <-0.5625,14.09491,-0.53068>,<-0.56237,14.09514,-0.53021>,<-0.56285,14.09491,-0.53027>,
            
    /*4*/ <-0.54173,14.27893,-0.57388>

    /* stem 0.55.18*/ 
    /*0*/ <-0.35472,13.93686,-0.44523>,
    /*1*/ <-0.35462,13.93688,-0.44507>,<-0.35488,13.93696,-0.44527>,<-0.35465,13.93674,-0.44537>,
            
    /*2*/ <-0.25961,14.06529,-0.51242>,<-0.25979,14.06535,-0.51255>,<-0.25963,14.0652,-0.51263>,
            
    /*3*/ <-0.20779,14.2276,-0.54436>,<-0.20788,14.22761,-0.54442>,<-0.20779,14.22757,-0.54447>,
            
    /*4*/ <-0.15483,14.38526,-0.59328>

    /* stem 0.56*/ 
    /*0*/ <-0.06702,12.10936,-0.20143>,
    /*1*/ <-0.06293,12.10995,-0.19434>,<-0.07236,12.11158,-0.1956>,<-0.07442,12.11014,-0.20492>,
            <-0.06626,12.10762,-0.20942>,<-0.05916,12.1075,-0.20289>,
    /*2*/ <0.01521,12.50578,-0.2743>,<0.00767,12.50709,-0.27531>,<0.00602,12.50593,-0.28277>,
            <0.01254,12.50392,-0.28637>,<0.01823,12.50382,-0.28114>,
    /*3*/ <0.01724,12.91411,-0.32535>,<0.01148,12.91408,-0.32596>,<0.01027,12.9134,-0.33158>,
            <0.01529,12.91302,-0.33446>,<0.0196,12.91345,-0.3306>,
    /*4*/ <-0.03577,13.32182,-0.33092>,<-0.03958,13.32133,-0.33128>,<-0.04041,13.32118,-0.33505>,
            <-0.03711,13.32159,-0.33702>,<-0.03424,13.32198,-0.33446>,
    /*5*/ <-0.13944,13.71949,-0.31264>,<-0.1413,13.71902,-0.31282>,<-0.14173,13.719,-0.31471>,
            <-0.14013,13.71946,-0.31568>,<-0.13871,13.71976,-0.3144>,
    /*6*/ <-0.33288,14.08267,-0.30526>

    /* stem 0.56.0*/ 
    /*0*/ <-0.05656,12.16184,-0.21184>,
    /*1*/ <-0.0606,12.16233,-0.21342>,<-0.05317,12.16362,-0.21394>,<-0.05591,12.15957,-0.20818>,
            
    /*2*/ <-0.103,12.50074,0.00458>,<-0.09805,12.5016,0.00424>,<-0.09988,12.4989,0.00808>,
            
    /*3*/ <-0.12091,12.8749,0.15787>,<-0.11842,12.87514,0.15759>,<-0.11937,12.87422,0.15974>,
            
    /*4*/ <-0.18303,13.27443,0.16704>

    /* stem 0.56.1*/ 
    /*0*/ <-0.03517,12.26907,-0.23312>,
    /*1*/ <-0.03132,12.26805,-0.23441>,<-0.0357,12.27223,-0.23041>,<-0.0385,12.26694,-0.23453>,
            
    /*2*/ <-0.06647,12.51905,-0.53269>,<-0.06939,12.52183,-0.53002>,<-0.07125,12.51831,-0.53276>,
            
    /*3*/ <-0.06778,12.84375,-0.75139>,<-0.06923,12.84483,-0.74978>,<-0.07019,12.84359,-0.75163>,
            
    /*4*/ <-0.12646,13.1753,-0.95139>

    /* stem 0.56.2*/ 
    /*0*/ <-0.02126,12.33886,-0.24696>,
    /*1*/ <-0.02323,12.33992,-0.24355>,<-0.02181,12.34099,-0.25039>,<-0.01874,12.33565,-0.24694>,
            
    /*2*/ <0.26837,12.5689,-0.14864>,<0.26932,12.56961,-0.1532>,<0.27137,12.56605,-0.1509>,
            
    /*3*/ <0.49105,12.85503,-0.02768>,<0.49163,12.85553,-0.02991>,<0.49292,12.854,-0.02867>,
            
    /*4*/ <0.6813,13.18294,0.0254>

    /* stem 0.56.3*/ 
    /*0*/ <0.00172,12.45409,-0.26982>,
    /*1*/ <0.00102,12.45348,-0.2736>,<0.00509,12.45569,-0.26869>,<-0.00095,12.45311,-0.26716>,
            
    /*2*/ <-0.14876,12.78906,-0.29871>,<-0.14604,12.79053,-0.29544>,<-0.15007,12.78881,-0.29442>,
            
    /*3*/ <-0.23071,13.14812,-0.31213>,<-0.22926,13.14852,-0.31046>,<-0.2314,13.14805,-0.30999>,
            
    /*4*/ <-0.10512,13.48598,-0.38764>

    /* stem 0.56.4*/ 
    /*0*/ <0.01244,12.57806,-0.28882>,
    /*1*/ <0.01528,12.57833,-0.28645>,<0.00937,12.58007,-0.28827>,<0.01267,12.57579,-0.29173>,
            
    /*2*/ <0.15095,12.84017,-0.48076>,<0.14701,12.84133,-0.48197>,<0.14921,12.83848,-0.48428>,
            
    /*3*/ <0.23682,13.15225,-0.62206>,<0.23477,13.15261,-0.62253>,<0.23604,13.15162,-0.62395>,
            
    /*4*/ <0.26293,13.49979,-0.67894>

    /* stem 0.56.5*/ 
    /*0*/ <0.01331,12.70269,-0.30396>,
    /*1*/ <0.00979,12.70271,-0.30396>,<0.01508,12.70438,-0.30648>,<0.01505,12.70097,-0.30144>,
            
    /*2*/ <0.01276,12.98299,-0.11489>,<0.01628,12.9841,-0.11657>,<0.01626,12.98183,-0.11321>,
            
    /*3*/ <0.01358,13.30375,-0.00806>,<0.01534,13.30407,-0.00902>,<0.01534,13.30343,-0.00709>,
            
    /*4*/ <-0.04519,13.6193,0.0975>

    /* stem 0.56.6*/ 
    /*0*/ <0.0145,12.87424,-0.32481>,
    /*1*/ <0.017,12.87397,-0.32688>,<0.01442,12.8767,-0.32267>,<0.01209,12.87204,-0.32486>,
            
    /*2*/ <-0.14045,13.05174,-0.53742>,<-0.14217,13.05356,-0.53462>,<-0.14372,13.05046,-0.53608>,
            
    /*3*/ <-0.22842,13.28998,-0.72734>,<-0.22924,13.29084,-0.72589>,<-0.23023,13.28964,-0.72694>,
            
    /*4*/ <-0.35821,13.51841,-0.90561>

    /* stem 0.56.7*/ 
    /*0*/ <0.00597,12.98242,-0.33029>,
    /*1*/ <0.00546,12.98239,-0.32724>,<0.00434,12.98433,-0.33211>,<0.00811,12.98055,-0.33153>,
            
    /*2*/ <0.21617,13.19888,-0.29093>,<0.21542,13.20017,-0.29418>,<0.21794,13.19766,-0.29379>,
            
    /*3*/ <0.36709,13.44674,-0.20083>,<0.36678,13.44751,-0.20241>,<0.36825,13.44652,-0.20217>,
            
    /*4*/ <0.41253,13.74024,-0.13466>

    /* stem 0.56.8*/ 
    /*0*/ <-0.00212,13.04569,-0.33094>,
    /*1*/ <-0.00364,13.04547,-0.33352>,<0.00026,13.04751,-0.33074>,<-0.00299,13.04409,-0.32855>,
            
    /*2*/ <-0.17992,13.26825,-0.24821>,<-0.17732,13.26961,-0.24635>,<-0.17949,13.26733,-0.24489>,
            
    /*3*/ <-0.27416,13.54804,-0.27311>,<-0.27277,13.54859,-0.27222>,<-0.27423,13.54818,-0.27138>,
            
    /*4*/ <-0.24259,13.84014,-0.2295>

    /* stem 0.56.9*/ 
    /*0*/ <-0.01991,13.18475,-0.33235>,
    /*1*/ <-0.01729,13.1851,-0.33142>,<-0.022,13.18629,-0.33128>,<-0.02045,13.18287,-0.33436>,
            
    /*2*/ <0.02564,13.38034,-0.52719>,<0.02251,13.38113,-0.52709>,<0.02354,13.37885,-0.52914>,
            
    /*3*/ <0.04129,13.65201,-0.59148>,<0.0397,13.65216,-0.59127>,<0.04029,13.65178,-0.59272>,
            
    /*4*/ <0.00145,13.92174,-0.52859>

    /* stem 0.56.10*/ 
    /*0*/ <-0.0301,13.26435,-0.33316>,
    /*1*/ <-0.0326,13.26404,-0.33222>,<-0.02958,13.26626,-0.33497>,<-0.02813,13.26274,-0.3323>,
            
    /*2*/ <0.02222,13.4379,-0.13283>,<0.02423,13.43939,-0.13466>,<0.02519,13.43704,-0.13288>,
            
    /*3*/ <0.00719,13.6517,0.03114>,<0.00818,13.65247,0.03023>,<0.00871,13.65161,0.03141>,
            
    /*4*/ <-0.09364,13.89704,0.08166>

    /* stem 0.56.11*/ 
    /*0*/ <-0.05285,13.38127,-0.33079>,
    /*1*/ <-0.05168,13.38168,-0.33298>,<-0.05273,13.38299,-0.32895>,<-0.05415,13.37914,-0.33044>,
            
    /*2*/ <-0.26221,13.49493,-0.4241>,<-0.26292,13.49579,-0.42141>,<-0.26386,13.49323,-0.42241>,
            
    /*3*/ <-0.40428,13.69882,-0.48432>,<-0.40447,13.69912,-0.48291>,<-0.40541,13.69826,-0.4836>,
            
    /*4*/ <-0.40875,13.95451,-0.48014>

    /* stem 0.56.12*/ 
    /*0*/ <-0.08333,13.49915,-0.32495>,
    /*1*/ <-0.08289,13.49915,-0.32265>,<-0.08541,13.49987,-0.32575>,<-0.08169,13.49842,-0.32646>,
            
    /*2*/ <0.00177,13.72439,-0.33939>,<0.00009,13.72487,-0.34146>,<0.00258,13.7239,-0.34193>,
            
    /*3*/ <0.07662,13.95184,-0.36927>,<0.07576,13.95199,-0.3703>,<0.07701,13.95154,-0.37053>,
            
    /*4*/ <0.12365,14.18289,-0.4205>

    /* stem 0.56.13*/ 
    /*0*/ <-0.12392,13.65613,-0.31718>,
    /*1*/ <-0.12535,13.65582,-0.31839>,<-0.12267,13.65753,-0.31752>,<-0.12373,13.65504,-0.31563>,
            
    /*2*/ <-0.25233,13.79646,-0.20324>,<-0.25054,13.7976,-0.20265>,<-0.25125,13.79594,-0.2014>,
            
    /*3*/ <-0.33325,13.9928,-0.13925>,<-0.33223,13.99316,-0.13906>,<-0.33279,13.99267,-0.13825>,
            
    /*4*/ <-0.374,14.20984,-0.11917>

    /* stem 0.56.14*/ 
    /*0*/ <-0.16758,13.77087,-0.3128>,
    /*1*/ <-0.16633,13.77153,-0.31279>,<-0.16863,13.77133,-0.31198>,<-0.16778,13.76976,-0.31364>,
            
    /*2*/ <-0.23128,13.89674,-0.46414>,<-0.23281,13.8966,-0.4636>,<-0.23224,13.89555,-0.46471>,
            
    /*3*/ <-0.30996,14.05319,-0.57426>,<-0.31069,14.05306,-0.57393>,<-0.31048,14.05268,-0.57461>,
            
    /*4*/ <-0.38931,14.22934,-0.6482>

    /* stem 0.56.15*/ 
    /*0*/ <-0.20263,13.83698,-0.3112>,
    /*1*/ <-0.20338,13.83656,-0.3105>,<-0.20295,13.83766,-0.31202>,<-0.20156,13.83671,-0.31109>,
            
    /*2*/ <-0.17632,13.9917,-0.19064>,<-0.17603,13.99243,-0.19165>,<-0.1751,13.99179,-0.19103>,
            
    /*3*/ <-0.1914,14.16252,-0.09193>,<-0.19126,14.16285,-0.09247>,<-0.19079,14.16266,-0.09207>,
            
    /*4*/ <-0.22772,14.35702,-0.09979>

    /* stem 0.56.16*/ 
    /*0*/ <-0.27043,13.96486,-0.30811>,
    /*1*/ <-0.27035,13.96492,-0.30863>,<-0.2704,13.96529,-0.30779>,<-0.27053,13.96438,-0.30791>,
            
    /*2*/ <-0.4469,13.99374,-0.33293>,<-0.44693,13.99399,-0.33236>,<-0.44702,13.99338,-0.33244>,
            
    /*3*/ <-0.56102,14.13219,-0.35264>,<-0.56097,14.13227,-0.35235>,<-0.56119,14.13207,-0.35242>,
            
    /*4*/ <-0.61532,14.30416,-0.3607>

    /* stem 0.56.17*/ 
    /*0*/ <-0.3021,14.02461,-0.30666>,
    /*1*/ <-0.30198,14.02466,-0.30643>,<-0.30236,14.02464,-0.30669>,<-0.30196,14.02451,-0.30686>,
            
    /*2*/ <-0.27126,14.18517,-0.36137>,<-0.27151,14.18516,-0.36155>,<-0.27125,14.18507,-0.36166>,
            
    /*3*/ <-0.24897,14.35469,-0.33968>,<-0.2491,14.35472,-0.33977>,<-0.24896,14.35471,-0.33983>,
            
    /*4*/ <-0.23746,14.52652,-0.34837>

    /* stem 0.57*/ 
    /*0*/ <-0.07321,12.24704,-0.20931>,
    /*1*/ <-0.07898,12.24666,-0.2114>,<-0.07312,12.24814,-0.21535>,<-0.06739,12.2481,-0.21096>,
            <-0.06971,12.24659,-0.20429>,<-0.07687,12.2457,-0.20456>,
    /*2*/ <-0.12948,12.64044,-0.13967>,<-0.1248,12.64162,-0.14283>,<-0.12022,12.64159,-0.13932>,
            <-0.12207,12.64038,-0.13398>,<-0.1278,12.63967,-0.1342>,
    /*3*/ <-0.16692,13.04173,-0.12351>,<-0.16335,13.04216,-0.12594>,<-0.15994,13.04239,-0.12328>,
            <-0.16139,13.04209,-0.11921>,<-0.16571,13.04168,-0.11935>,
    /*4*/ <-0.13752,13.43707,-0.19983>,<-0.13513,13.43659,-0.20137>,<-0.13287,13.43678,-0.19959>,
            <-0.13386,13.43736,-0.19694>,<-0.13674,13.43754,-0.19709>,
    /*5*/ <-0.03982,13.79187,-0.36561>,<-0.03868,13.79126,-0.36625>,<-0.03755,13.79137,-0.36536>,
            <-0.03799,13.79205,-0.36417>,<-0.03939,13.79236,-0.36432>,
    /*6*/ <0.04452,14.11298,-0.59463>

    /* stem 0.57.0*/ 
    /*0*/ <-0.07826,12.2855,-0.20234>,
    /*1*/ <-0.07523,12.2861,-0.20344>,<-0.07917,12.28655,-0.19937>,<-0.08039,12.28386,-0.20422>,
            
    /*2*/ <-0.2011,12.62955,-0.36204>,<-0.20373,12.62985,-0.35932>,<-0.20454,12.62806,-0.36256>,
            
    /*3*/ <-0.31399,13.01042,-0.39752>,<-0.31519,13.0102,-0.39607>,<-0.31577,13.00986,-0.39784>,
            
    /*4*/ <-0.39096,13.3985,-0.3484>

    /* stem 0.57.1*/ 
    /*0*/ <-0.09188,12.38928,-0.18355>,
    /*1*/ <-0.09339,12.38859,-0.18086>,<-0.09311,12.39136,-0.18557>,<-0.08913,12.38788,-0.18421>,
            
    /*2*/ <0.09578,12.67405,-0.00288>,<0.09596,12.6759,-0.00602>,<0.09862,12.67357,-0.00511>,
            
    /*3*/ <0.10657,13.05612,0.0521>,<0.10649,13.05639,0.0503>,<0.10811,13.05622,0.05113>,
            
    /*4*/ <0.05242,13.42057,0.16619>

    /* stem 0.57.2*/ 
    /*0*/ <-0.10274,12.47208,-0.16855>,
    /*1*/ <-0.10333,12.47254,-0.17151>,<-0.10054,12.47368,-0.16716>,<-0.10436,12.47003,-0.16697>,
            
    /*2*/ <-0.35235,12.73863,-0.07996>,<-0.35048,12.73939,-0.07706>,<-0.35304,12.73695,-0.07694>,
            
    /*3*/ <-0.57249,13.03042,0.00709>,<-0.57151,13.03074,0.00852>,<-0.5729,13.02966,0.00862>,
            
    /*4*/ <-0.78293,13.34088,-0.01065>

    /* stem 0.57.3*/ 
    /*0*/ <-0.1192,12.59748,-0.14583>,
    /*1*/ <-0.11695,12.59744,-0.14399>,<-0.12164,12.59888,-0.14512>,<-0.119,12.59612,-0.14839>,
            
    /*2*/ <0.01112,12.89863,-0.29473>,<0.00799,12.89959,-0.29548>,<0.00975,12.89775,-0.29766>,
            
    /*3*/ <0.12353,13.24049,-0.3004>,<0.12197,13.241,-0.30074>,<0.12303,13.24063,-0.30199>,
            
    /*4*/ <0.17143,13.59585,-0.26424>

    /* stem 0.57.4*/ 
    /*0*/ <-0.12855,12.679,-0.1365>,
    /*1*/ <-0.13135,12.67873,-0.13649>,<-0.12731,12.68071,-0.13835>,<-0.127,12.67755,-0.13465>,
            
    /*2*/ <-0.15552,12.94337,0.0919>,<-0.15283,12.94469,0.09067>,<-0.15262,12.94258,0.09313>,
            
    /*3*/ <-0.12247,13.26295,0.23258>,<-0.12112,13.26319,0.23173>,<-0.12104,13.26253,0.23321>,
            
    /*4*/ <-0.06805,13.60251,0.30014>

    /* stem 0.57.5*/ 
    /*0*/ <-0.146,12.86041,-0.12938>,
    /*1*/ <-0.14402,12.86067,-0.13106>,<-0.14611,12.86191,-0.12726>,<-0.14786,12.85866,-0.12983>,
            
    /*2*/ <-0.31606,13.08497,-0.29843>,<-0.31745,13.0858,-0.2959>,<-0.31862,13.08363,-0.29761>,
            
    /*3*/ <-0.35119,13.38272,-0.43156>,<-0.35187,13.3832,-0.43031>,<-0.35268,13.38261,-0.43143>,
            
    /*4*/ <-0.29997,13.68693,-0.54403>

    /* stem 0.57.6*/ 
    /*0*/ <-0.1549,12.953,-0.12575>,
    /*1*/ <-0.15532,12.95286,-0.12329>,<-0.15611,12.95469,-0.12713>,<-0.15327,12.95145,-0.12683>,
            
    /*2*/ <0.07784,13.16213,-0.07278>,<0.07731,13.16335,-0.07534>,<0.0792,13.16119,-0.07514>,
            
    /*3*/ <0.25901,13.4218,-0.04988>,<0.25859,13.42222,-0.05119>,<0.25976,13.42139,-0.05104>,
            
    /*4*/ <0.32579,13.7319,-0.04062>

    /* stem 0.57.7*/ 
    /*0*/ <-0.16147,13.06984,-0.12766>,
    /*1*/ <-0.16264,13.06953,-0.12969>,<-0.15941,13.07098,-0.12765>,<-0.16237,13.069,-0.12564>,
            
    /*2*/ <-0.30782,13.33192,-0.08497>,<-0.30566,13.33289,-0.08361>,<-0.30763,13.33157,-0.08227>,
            
    /*3*/ <-0.46101,13.58125,-0.00516>,<-0.45992,13.58171,-0.00448>,<-0.46085,13.58094,-0.00384>,
            
    /*4*/ <-0.58827,13.85621,-0.01185>

    /* stem 0.57.8*/ 
    /*0*/ <-0.15355,13.18072,-0.14919>,
    /*1*/ <-0.15145,13.18073,-0.14841>,<-0.15503,13.1822,-0.14841>,<-0.15415,13.17925,-0.15076>,
            
    /*2*/ <-0.07481,13.36803,-0.35556>,<-0.0772,13.36902,-0.35557>,<-0.07661,13.36705,-0.35713>,
            
    /*3*/ <-0.04398,13.63059,-0.47396>,<-0.04523,13.63083,-0.47378>,<-0.04483,13.63028,-0.47488>,
            
    /*4*/ <0.00631,13.90592,-0.54806>

    /* stem 0.57.9*/ 
    /*0*/ <-0.14429,13.31029,-0.17435>,
    /*1*/ <-0.14625,13.31056,-0.17368>,<-0.14368,13.31113,-0.17616>,<-0.14294,13.30918,-0.17321>,
            
    /*2*/ <-0.06932,13.53805,-0.0423>,<-0.06761,13.53843,-0.04395>,<-0.06711,13.53712,-0.04198>,
            
    /*3*/ <0.00788,13.78509,0.04698>,<0.0087,13.78515,0.0461>,<0.009,13.78467,0.04716>,
            
    /*4*/ <0.08341,14.04605,0.0808>

    /* stem 0.57.10*/ 
    /*0*/ <-0.13746,13.40582,-0.1929>,
    /*1*/ <-0.13646,13.40543,-0.19457>,<-0.13668,13.40705,-0.19155>,<-0.13923,13.40499,-0.19257>,
            
    /*2*/ <-0.25381,13.60832,-0.3117>,<-0.25396,13.6094,-0.30969>,<-0.25566,13.60802,-0.31038>,
            
    /*3*/ <-0.2996,13.84069,-0.42349>,<-0.29964,13.84118,-0.42245>,<-0.30059,13.84076,-0.42293>,
            
    /*4*/ <-0.30048,14.09197,-0.49783>

    /* stem 0.57.11*/ 
    /*0*/ <-0.12297,13.4821,-0.22006>,
    /*1*/ <-0.1226,13.4828,-0.21834>,<-0.12383,13.48317,-0.22135>,<-0.12248,13.48032,-0.22048>,
            
    /*2*/ <0.10128,13.56401,-0.30089>,<0.10045,13.56426,-0.3029>,<0.10136,13.56235,-0.30232>,
            
    /*3*/ <0.26949,13.74013,-0.36501>,<0.26901,13.74023,-0.36599>,<0.26982,13.73951,-0.36584>,
            
    /*4*/ <0.44022,13.91733,-0.41949>

    /* stem 0.57.12*/ 
    /*0*/ <-0.09453,13.58661,-0.26902>,
    /*1*/ <-0.09587,13.58644,-0.27015>,<-0.09299,13.58729,-0.26957>,<-0.09471,13.58609,-0.26735>,
            
    /*2*/ <-0.17132,13.80406,-0.21105>,<-0.1694,13.80462,-0.21066>,<-0.17054,13.80382,-0.20918>,
            
    /*3*/ <-0.22911,14.02996,-0.1643>,<-0.22813,14.03018,-0.16412>,<-0.22874,14.02986,-0.16336>,
            
    /*4*/ <-0.24288,14.26696,-0.1501>

    /* stem 0.57.13*/ 
    /*0*/ <-0.04734,13.76,-0.35025>,
    /*1*/ <-0.04604,13.75969,-0.35015>,<-0.04775,13.76124,-0.35001>,<-0.04822,13.75905,-0.3506>,
            
    /*2*/ <-0.01881,13.80983,-0.55653>,<-0.01995,13.81087,-0.55643>,<-0.02027,13.80941,-0.55683>,
            
    /*3*/ <-0.01193,13.88353,-0.75756>,<-0.01251,13.88402,-0.7574>,<-0.01267,13.88331,-0.75767>,
            
    /*4*/ <-0.06064,14.0131,-0.92111>

    /* stem 0.57.14*/ 
    /*0*/ <-0.03237,13.81617,-0.38257>,
    /*1*/ <-0.03316,13.81677,-0.38202>,<-0.03222,13.81632,-0.38369>,<-0.03172,13.81543,-0.38201>,
            
    /*2*/ <0.10505,13.96492,-0.3442>,<0.10568,13.96462,-0.34531>,<0.10601,13.96402,-0.34419>,
            
    /*3*/ <0.15589,14.16204,-0.31398>,<0.15625,14.16203,-0.31453>,<0.15652,14.16187,-0.31395>,
            
    /*4*/ <0.18287,14.35083,-0.39228>

    /* stem 0.57.15*/ 
    /*0*/ <-0.00349,13.92763,-0.4622>,
    /*1*/ <-0.00343,13.92721,-0.46277>,<-0.00299,13.92811,-0.46206>,<-0.00406,13.92757,-0.46179>,
            
    /*2*/ <-0.0945,14.05498,-0.56868>,<-0.09421,14.05558,-0.56821>,<-0.09493,14.05522,-0.56802>,
            
    /*3*/ <-0.07302,14.2245,-0.65034>,<-0.07285,14.22465,-0.65>,<-0.07326,14.22467,-0.65005>,
            
    /*4*/ <-0.06808,14.40771,-0.69794>

    /* stem 0.57.16*/ 
    /*0*/ <0.01039,13.98121,-0.50048>,
    /*1*/ <0.01067,13.9814,-0.50011>,<0.0101,13.98151,-0.50077>,<0.01039,13.98071,-0.50057>,
            
    /*2*/ <0.1494,14.00219,-0.61485>,<0.14903,14.00226,-0.61529>,<0.14922,14.00173,-0.61516>,
            
    /*3*/ <0.24182,14.11296,-0.72451>,<0.24159,14.11298,-0.72468>,<0.24179,14.11277,-0.72472>,
            
    /*4*/ <0.28148,14.25547,-0.82923>

    /* stem 0.57.17*/ 
    /*0*/ <0.03832,14.08904,-0.57753>,
    /*1*/ <0.03824,14.08904,-0.57756>,<0.03839,14.08906,-0.57758>,<0.03834,14.08902,-0.57744>,
            
    /*2*/ <0.02441,14.24813,-0.53613>,<0.02452,14.24815,-0.53615>,<0.02448,14.24812,-0.53605>,
            
    /*3*/ <-0.00024,14.40285,-0.58778>,<-0.00019,14.40286,-0.58779>,<-0.00021,14.40287,-0.58775>,
            
    /*4*/ <0.01214,14.54584,-0.66915>

    /* stem 0.58*/ 
    /*0*/ <-0.08216,12.4461,-0.2207>,
    /*1*/ <-0.07921,12.44617,-0.22178>,<-0.08028,12.44696,-0.21832>,<-0.08395,12.44656,-0.21815>,
            <-0.08515,12.44553,-0.22149>,<-0.08222,12.44529,-0.22374>,
    /*2*/ <-0.12525,12.82259,-0.32114>,<-0.12611,12.82322,-0.31838>,<-0.12905,12.8229,-0.31824>,
            <-0.13001,12.82207,-0.32092>,<-0.12766,12.82188,-0.32271>,
    /*3*/ <-0.12437,13.2098,-0.38106>,<-0.12499,13.21013,-0.37895>,<-0.12721,13.21015,-0.37889>,
            <-0.12796,13.20983,-0.38095>,<-0.1262,13.20962,-0.38229>,
    /*4*/ <-0.1459,13.59932,-0.42107>,<-0.14632,13.59944,-0.41966>,<-0.1478,13.59937,-0.41961>,
            <-0.14829,13.5992,-0.421>,<-0.14712,13.59917,-0.4219>,
    /*5*/ <-0.14953,13.991,-0.40482>,<-0.14974,13.99096,-0.40411>,<-0.15048,13.99096,-0.40409>,
            <-0.15073,13.99098,-0.40479>,<-0.15015,13.99101,-0.40524>,
    /*6*/ <-0.15462,14.37753,-0.33949>

    /* stem 0.58.0*/ 
    /*0*/ <-0.088,12.49442,-0.23348>,
    /*1*/ <-0.08885,12.49469,-0.23206>,<-0.08843,12.49521,-0.23488>,<-0.0867,12.49335,-0.23348>,
            
    /*2*/ <0.15024,12.78445,-0.14343>,<0.15052,12.7848,-0.14531>,<0.15167,12.78356,-0.14437>,
            
    /*3*/ <0.29756,13.13859,-0.188>,<0.29755,13.13848,-0.18896>,<0.29833,13.13822,-0.18846>,
            
    /*4*/ <0.28266,13.50482,-0.30894>

    /* stem 0.58.1*/ 
    /*0*/ <-0.10203,12.61063,-0.26422>,
    /*1*/ <-0.10228,12.6102,-0.26574>,<-0.10099,12.61179,-0.26388>,<-0.10282,12.6099,-0.26304>,
            
    /*2*/ <-0.37406,12.86202,-0.29219>,<-0.3732,12.86308,-0.29095>,<-0.37443,12.86182,-0.29039>,
            
    /*3*/ <-0.60554,13.12721,-0.41014>,<-0.60516,13.12781,-0.40955>,<-0.60588,13.1273,-0.40929>,
            
    /*4*/ <-0.77071,13.4113,-0.58321>

    /* stem 0.58.2*/ 
    /*0*/ <-0.11024,12.67866,-0.28222>,
    /*1*/ <-0.10908,12.67905,-0.28127>,<-0.11163,12.67934,-0.28206>,<-0.11002,12.67759,-0.28332>,
            
    /*2*/ <-0.0078,12.93891,-0.51356>,<-0.0095,12.9391,-0.51409>,<-0.00843,12.93793,-0.51492>,
            
    /*3*/ <0.06104,13.24225,-0.70052>,<0.06018,13.24231,-0.70075>,<0.06075,13.24185,-0.70127>,
            
    /*4*/ <0.01652,13.59555,-0.77076>

    /* stem 0.58.3*/ 
    /*0*/ <-0.12224,12.77797,-0.30849>,
    /*1*/ <-0.12372,12.77779,-0.30847>,<-0.1216,12.77881,-0.30954>,<-0.12139,12.7773,-0.30746>,
            
    /*2*/ <-0.15339,13.05885,-0.10108>,<-0.15198,13.05953,-0.10179>,<-0.15184,13.05852,-0.1004>,
            
    /*3*/ <-0.18888,13.3394,0.10607>,<-0.18817,13.33975,0.10571>,<-0.1881,13.33924,0.10641>,
            
    /*4*/ <-0.30875,13.64377,0.23173>

    /* stem 0.58.4*/ 
    /*0*/ <-0.12728,12.90997,-0.33385>,
    /*1*/ <-0.1262,12.90983,-0.33474>,<-0.12733,12.91106,-0.33296>,<-0.12832,12.90902,-0.33385>,
            
    /*2*/ <-0.29067,13.08985,-0.56353>,<-0.29142,13.09067,-0.56234>,<-0.29208,13.08931,-0.56294>,
            
    /*3*/ <-0.39426,13.35557,-0.73802>,<-0.39458,13.35589,-0.73735>,<-0.39503,13.35541,-0.73782>,
            
    /*4*/ <-0.45622,13.65779,-0.86695>

    /* stem 0.58.5*/ 
    /*0*/ <-0.12687,13.02009,-0.35095>,
    /*1*/ <-0.12711,13.0203,-0.34965>,<-0.12768,13.02063,-0.35188>,<-0.12581,13.01935,-0.35133>,
            
    /*2*/ <0.05571,13.28402,-0.35756>,<0.05533,13.28424,-0.35904>,<0.05657,13.28339,-0.35868>,
            
    /*3*/ <0.16814,13.58394,-0.37828>,<0.16791,13.58398,-0.37901>,<0.16862,13.58372,-0.37884>,
            
    /*4*/ <0.19027,13.90053,-0.42645>

    /* stem 0.58.6*/ 
    /*0*/ <-0.12639,13.14453,-0.37028>,
    /*1*/ <-0.12702,13.14436,-0.37136>,<-0.12531,13.14519,-0.37026>,<-0.12685,13.14404,-0.3692>,
            
    /*2*/ <-0.28446,13.40142,-0.31944>,<-0.28332,13.40197,-0.31871>,<-0.28434,13.4012,-0.318>,
            
    /*3*/ <-0.40234,13.68335,-0.30678>,<-0.40175,13.68358,-0.30642>,<-0.40232,13.68333,-0.30605>,
            
    /*4*/ <-0.35317,13.98224,-0.26315>

    /* stem 0.58.7*/ 
    /*0*/ <-0.12942,13.27074,-0.38671>,
    /*1*/ <-0.1283,13.27084,-0.3863>,<-0.13027,13.27146,-0.38631>,<-0.12968,13.26991,-0.38753>,
            
    /*2*/ <-0.06818,13.46026,-0.59831>,<-0.0695,13.46067,-0.59832>,<-0.0691,13.45964,-0.59913>,
            
    /*3*/ <-0.00537,13.68262,-0.77444>,<-0.00602,13.68282,-0.77443>,<-0.00581,13.68238,-0.77491>,
            
    /*4*/ <0.03276,13.92923,-0.92338>

    /* stem 0.58.8*/ 
    /*0*/ <-0.1332,13.34115,-0.39398>,
    /*1*/ <-0.13428,13.34113,-0.3936>,<-0.13293,13.3418,-0.39489>,<-0.1324,13.34051,-0.39347>,
            
    /*2*/ <-0.07537,13.55546,-0.21992>,<-0.07446,13.55591,-0.22078>,<-0.07411,13.55505,-0.21984>,
            
    /*3*/ <-0.03182,13.81254,-0.11225>,<-0.03139,13.81267,-0.11273>,<-0.03118,13.8124,-0.11216>,
            
    /*4*/ <-0.03311,14.09385,-0.09157>

    /* stem 0.58.9*/ 
    /*0*/ <-0.14033,13.47375,-0.40768>,
    /*1*/ <-0.13979,13.47368,-0.4086>,<-0.13998,13.47439,-0.4069>,<-0.14123,13.47317,-0.40754>,
            
    /*2*/ <-0.28431,13.67384,-0.50779>,<-0.28444,13.67431,-0.50666>,<-0.28527,13.6735,-0.50709>,
            
    /*3*/ <-0.38053,13.91247,-0.57558>,<-0.38055,13.91263,-0.57498>,<-0.38104,13.91236,-0.57525>,
            
    /*4*/ <-0.37841,14.17786,-0.59426>

    /* stem 0.58.10*/ 
    /*0*/ <-0.14319,13.52677,-0.41316>,
    /*1*/ <-0.14301,13.52689,-0.41214>,<-0.14396,13.5273,-0.41362>,<-0.14259,13.52613,-0.41372>,
            
    /*2*/ <0.02018,13.72264,-0.46183>,<0.01955,13.72292,-0.46282>,<0.02046,13.72214,-0.46288>,
            
    /*3*/ <0.07664,13.95065,-0.57296>,<0.07622,13.95055,-0.57338>,<0.07678,13.95037,-0.57347>,
            
    /*4*/ <0.08667,14.17866,-0.69686>

    /* stem 0.58.11*/ 
    /*0*/ <-0.14769,13.67726,-0.41746>,
    /*1*/ <-0.14842,13.67728,-0.41807>,<-0.14697,13.67788,-0.41755>,<-0.14768,13.67662,-0.41675>,
            
    /*2*/ <-0.26504,13.83309,-0.27504>,<-0.26408,13.83349,-0.27469>,<-0.26455,13.83265,-0.27416>,
            
    /*3*/ <-0.32225,14.06061,-0.2177>,<-0.32172,14.06071,-0.21757>,<-0.32206,14.06052,-0.21718>,
            
    /*4*/ <-0.33314,14.29984,-0.18615>

    /* stem 0.58.12*/ 
    /*0*/ <-0.14851,13.78251,-0.41315>,
    /*1*/ <-0.14761,13.78251,-0.41314>,<-0.14896,13.78304,-0.41259>,<-0.14895,13.78197,-0.41371>,
            
    /*2*/ <-0.14828,13.94777,-0.57151>,<-0.14918,13.94812,-0.57115>,<-0.14917,13.9474,-0.57189>,
            
    /*3*/ <-0.14729,14.15041,-0.67793>,<-0.14773,14.15053,-0.67771>,<-0.14773,14.15029,-0.67816>,
            
    /*4*/ <-0.15918,14.37111,-0.7375>

    /* stem 0.58.13*/ 
    /*0*/ <-0.14947,13.906,-0.40809>,
    /*1*/ <-0.15006,13.90598,-0.4076>,<-0.14946,13.90652,-0.40866>,<-0.14888,13.90552,-0.40801>,
            
    /*2*/ <-0.05011,14.04619,-0.28043>,<-0.04971,14.04655,-0.28113>,<-0.04933,14.04588,-0.2807>,
            
    /*3*/ <0.02337,14.22505,-0.1886>,<0.02354,14.22518,-0.18899>,<0.02378,14.22494,-0.18871>,
            
    /*4*/ <0.07368,14.42746,-0.14034>

    /* stem 0.58.14*/ 
    /*0*/ <-0.15071,14.04132,-0.39613>,
    /*1*/ <-0.15061,14.04141,-0.39666>,<-0.15047,14.04163,-0.39575>,<-0.15106,14.04092,-0.39598>,
            
    /*2*/ <-0.30106,14.16957,-0.40265>,<-0.30096,14.16971,-0.40204>,<-0.30136,14.16924,-0.40219>,
            
    /*3*/ <-0.43473,14.30682,-0.35339>,<-0.43462,14.30683,-0.3531>,<-0.43485,14.30663,-0.35317>,
            
    /*4*/ <-0.50263,14.47122,-0.26699>

    /* stem 0.58.15*/ 
    /*0*/ <-0.15163,14.11983,-0.3829>,
    /*1*/ <-0.15142,14.11977,-0.38254>,<-0.15196,14.12008,-0.38291>,<-0.15149,14.11964,-0.38325>,
            
    /*2*/ <-0.04218,14.26793,-0.42156>,<-0.04254,14.26814,-0.42181>,<-0.04223,14.26785,-0.42204>,
            
    /*3*/ <0.06104,14.42173,-0.38886>,<0.06088,14.42186,-0.38898>,<0.06107,14.42176,-0.3891>,
            
    /*4*/ <0.08495,14.606,-0.359>

    /* stem 0.58.16*/ 
    /*0*/ <-0.15278,14.21901,-0.3662>,
    /*1*/ <-0.15302,14.21902,-0.36628>,<-0.15261,14.21919,-0.36626>,<-0.15271,14.21881,-0.36604>,
            
    /*2*/ <-0.20052,14.31208,-0.22453>,<-0.20025,14.3122,-0.22451>,<-0.20031,14.31195,-0.22437>,
            
    /*3*/ <-0.17386,14.45174,-0.12054>,<-0.17372,14.45175,-0.12058>,<-0.17376,14.45167,-0.12046>,
            
    /*4*/ <-0.12082,14.61596,-0.08541>

    /* stem 0.58.17*/ 
    /*0*/ <-0.15415,14.33689,-0.34634>,
    /*1*/ <-0.15409,14.3369,-0.34636>,<-0.15417,14.33692,-0.34628>,<-0.15419,14.33685,-0.34637>,
            
    /*2*/ <-0.1947,14.46465,-0.43688>,<-0.19475,14.46467,-0.43683>,<-0.19477,14.46462,-0.43688>,
            
    /*3*/ <-0.22221,14.61401,-0.49257>,<-0.22224,14.61401,-0.49254>,<-0.22225,14.614,-0.49257>,
            
    /*4*/ <-0.24923,14.77107,-0.52022>

    /* stem 0.59*/ 
    /*0*/ <-0.08824,12.58132,-0.22843>,
    /*1*/ <-0.0888,12.58135,-0.22746>,<-0.08932,12.58146,-0.22866>,<-0.08835,12.58137,-0.22954>,
            <-0.08723,12.58122,-0.22888>,<-0.0875,12.5812,-0.2276>,
    /*2*/ <-0.04344,12.96268,-0.21343>,<-0.04386,12.96277,-0.21438>,<-0.04309,12.9627,-0.21508>,
            <-0.04219,12.96257,-0.21456>,<-0.04241,12.96256,-0.21354>,
    /*3*/ <-0.07543,13.34537,-0.22615>,<-0.07575,13.34532,-0.22687>,<-0.07517,13.34535,-0.2274>,
            <-0.07449,13.34542,-0.22701>,<-0.07465,13.34544,-0.22624>,
    /*4*/ <-0.14272,13.72255,-0.2557>,<-0.14293,13.72248,-0.25617>,<-0.14255,13.72252,-0.25653>,
            <-0.1421,13.72262,-0.25627>,<-0.14221,13.72264,-0.25576>,
    /*5*/ <-0.2613,14.07981,-0.33309>,<-0.26139,14.07973,-0.33332>,<-0.2612,14.07975,-0.3335>,
            <-0.26099,14.07985,-0.33337>,<-0.26105,14.07988,-0.33312>,
    /*6*/ <-0.3982,14.42097,-0.44508>

    /* stem 0.59.0*/ 
    /*0*/ <-0.08495,12.60909,-0.22739>,
    /*1*/ <-0.08505,12.60913,-0.22798>,<-0.08446,12.60935,-0.22716>,<-0.08533,12.6088,-0.22704>,
            
    /*2*/ <-0.28045,12.93191,-0.17574>,<-0.28006,12.93205,-0.17519>,<-0.28064,12.93169,-0.17511>,
            
    /*3*/ <-0.38129,13.28365,-0.06965>,<-0.38107,13.28364,-0.06939>,<-0.38139,13.28353,-0.06934>,
            
    /*4*/ <-0.38908,13.64471,0.05154>

    /* stem 0.59.1*/ 
    /*0*/ <-0.07133,12.72385,-0.22311>,
    /*1*/ <-0.0709,12.72378,-0.22274>,<-0.0717,12.72427,-0.22304>,<-0.07139,12.72348,-0.22355>,
            
    /*2*/ <0.13911,12.93949,-0.4327>,<0.13858,12.93982,-0.4329>,<0.13878,12.93929,-0.43324>,
            
    /*3*/ <0.19257,13.27851,-0.56305>,<0.19224,13.27855,-0.56308>,<0.19242,13.27842,-0.56333>,
            
    /*4*/ <0.18502,13.64117,-0.61912>

    /* stem 0.59.2*/ 
    /*0*/ <-0.0606,12.81429,-0.21973>,
    /*1*/ <-0.06115,12.81436,-0.21973>,<-0.06028,12.81464,-0.22003>,<-0.06037,12.81389,-0.21944>,
            
    /*2*/ <-0.03522,13.03071,0.06192>,<-0.03464,13.0309,0.06172>,<-0.0347,13.0304,0.06211>,
            
    /*3*/ <-0.08401,13.29006,0.3009>,<-0.08372,13.29018,0.30083>,<-0.08375,13.28996,0.30106>,
            
    /*4*/ <-0.10507,13.60208,0.47123>

    /* stem 0.59.3*/ 
    /*0*/ <-0.04799,12.92059,-0.21577>,
    /*1*/ <-0.04759,12.92055,-0.21611>,<-0.04793,12.92086,-0.21532>,<-0.04845,12.92035,-0.21588>,
            
    /*2*/ <-0.15583,13.20549,-0.37395>,<-0.15606,13.20569,-0.37343>,<-0.1564,13.20535,-0.3738>,
            
    /*3*/ <-0.31785,13.49391,-0.46583>,<-0.31794,13.49395,-0.46554>,<-0.31811,13.49379,-0.46574>,
            
    /*4*/ <-0.37363,13.83237,-0.45361>

    /* stem 0.59.4*/ 
    /*0*/ <-0.04734,13.01443,-0.21589>,
    /*1*/ <-0.04743,13.01444,-0.21539>,<-0.04766,13.01466,-0.21621>,<-0.04693,13.0142,-0.21607>,
            
    /*2*/ <0.12709,13.29563,-0.18995>,<0.12694,13.29578,-0.19049>,<0.12742,13.29547,-0.1904>,
            
    /*3*/ <0.19362,13.61997,-0.21385>,<0.19351,13.61998,-0.21413>,<0.1938,13.61992,-0.21408>,
            
    /*4*/ <0.17454,13.93923,-0.30275>

    /* stem 0.59.5*/ 
    /*0*/ <-0.05792,13.14055,-0.22002>,
    /*1*/ <-0.05816,13.14052,-0.22044>,<-0.0576,13.1409,-0.21996>,<-0.058,13.14024,-0.21967>,
            
    /*2*/ <-0.2855,13.32806,-0.10441>,<-0.28513,13.32831,-0.1041>,<-0.2854,13.32787,-0.10391>,
            
    /*3*/ <-0.48758,13.52638,0.03762>,<-0.48737,13.52649,0.03777>,<-0.48751,13.52627,0.03786>,
            
    /*4*/ <-0.55771,13.77308,0.22355>

    /* stem 0.59.6*/ 
    /*0*/ <-0.06862,13.26813,-0.2242>,
    /*1*/ <-0.0682,13.26817,-0.22405>,<-0.06895,13.26837,-0.22402>,<-0.06871,13.26784,-0.22454>,
            
    /*2*/ <-0.01585,13.48533,-0.42633>,<-0.01635,13.48547,-0.42631>,<-0.01619,13.48511,-0.42665>,
            
    /*3*/ <0.05492,13.75458,-0.54158>,<0.05467,13.75465,-0.54157>,<0.05477,13.75453,-0.54178>,
            
    /*4*/ <0.09349,14.01423,-0.68964>

    /* stem 0.59.7*/ 
    /*0*/ <-0.08511,13.4014,-0.23109>,
    /*1*/ <-0.0855,13.40134,-0.23095>,<-0.08504,13.40166,-0.23142>,<-0.08479,13.40119,-0.23092>,
            
    /*2*/ <-0.04843,13.61647,-0.04741>,<-0.04813,13.61669,-0.04773>,<-0.04796,13.61637,-0.04739>,
            
    /*3*/ <-0.05072,13.88169,0.05744>,<-0.05057,13.88176,0.05727>,<-0.05048,13.88168,0.05748>,
            
    /*4*/ <-0.00842,14.13373,0.18407>

    /* stem 0.59.8*/ 
    /*0*/ <-0.10445,13.50963,-0.23952>,
    /*1*/ <-0.10425,13.50964,-0.23986>,<-0.1044,13.50992,-0.23925>,<-0.10471,13.50933,-0.23944>,
            
    /*2*/ <-0.30594,13.65382,-0.35167>,<-0.30604,13.65401,-0.35126>,<-0.30625,13.65362,-0.35138>,
            
    /*3*/ <-0.48385,13.84998,-0.41374>,<-0.48386,13.85004,-0.41352>,<-0.484,13.84989,-0.4136>,
            
    /*4*/ <-0.61093,14.08929,-0.43719>

    /* stem 0.59.9*/ 
    /*0*/ <-0.11386,13.5623,-0.24361>,
    /*1*/ <-0.1138,13.56234,-0.24323>,<-0.11414,13.56251,-0.24379>,<-0.11366,13.56204,-0.24382>,
            
    /*2*/ <0.06692,13.75008,-0.2942>,<0.0667,13.7502,-0.29457>,<0.06702,13.74989,-0.29459>,
            
    /*3*/ <0.16515,13.9797,-0.38453>,<0.165,13.97969,-0.3847>,<0.1652,13.9796,-0.38473>,
            
    /*4*/ <0.1367,14.24346,-0.39512>

    /* stem 0.59.10*/ 
    /*0*/ <-0.13593,13.6858,-0.25323>,
    /*1*/ <-0.13621,13.68573,-0.25345>,<-0.13572,13.68609,-0.25328>,<-0.13588,13.68558,-0.25294>,
            
    /*2*/ <-0.28874,13.82673,-0.11357>,<-0.28842,13.82697,-0.11345>,<-0.28853,13.82663,-0.11323>,
            
    /*3*/ <-0.41292,14.03878,-0.06538>,<-0.41274,14.03887,-0.06533>,<-0.41284,14.03877,-0.06519>,
            
    /*4*/ <-0.47688,14.27814,-0.10184>

    /* stem 0.59.11*/ 
    /*0*/ <-0.1627,13.78335,-0.26922>,
    /*1*/ <-0.16238,13.78345,-0.26923>,<-0.16293,13.78353,-0.26906>,<-0.16279,13.78305,-0.26937>,
            
    /*2*/ <-0.20564,13.89918,-0.47275>,<-0.20601,13.89923,-0.47264>,<-0.20591,13.89891,-0.47285>,
            
    /*3*/ <-0.24245,14.11081,-0.57536>,<-0.24263,14.11082,-0.57529>,<-0.2426,14.11074,-0.57546>,
            
    /*4*/ <-0.21479,14.34712,-0.58341>

    /* stem 0.59.12*/ 
    /*0*/ <-0.20998,13.92567,-0.29998>,
    /*1*/ <-0.21021,13.92564,-0.29977>,<-0.21003,13.92582,-0.30024>,<-0.2097,13.92556,-0.29991>,
            
    /*2*/ <-0.15732,14.11718,-0.20602>,<-0.15719,14.1173,-0.20633>,<-0.15698,14.11713,-0.20611>,
            
    /*3*/ <-0.17545,14.31728,-0.11721>,<-0.17539,14.31735,-0.11736>,<-0.17527,14.3173,-0.11723>,
            
    /*4*/ <-0.21962,14.53242,-0.124>

    /* stem 0.59.13*/ 
    /*0*/ <-0.23715,14.00744,-0.31764>,
    /*1*/ <-0.23709,14.0074,-0.3179>,<-0.23707,14.00767,-0.31752>,<-0.23729,14.00726,-0.31751>,
            
    /*2*/ <-0.41607,14.10264,-0.36935>,<-0.41605,14.10282,-0.36909>,<-0.4162,14.10254,-0.36908>,
            
    /*3*/ <-0.57164,14.24182,-0.35513>,<-0.57158,14.24187,-0.35499>,<-0.57168,14.24175,-0.35499>,
            
    /*4*/ <-0.64028,14.43425,-0.31024>

    /* stem 0.59.14*/ 
    /*0*/ <-0.27417,14.11212,-0.34387>,
    /*1*/ <-0.27409,14.11221,-0.34371>,<-0.27435,14.11219,-0.34394>,<-0.27407,14.11197,-0.34397>,
            
    /*2*/ <-0.18229,14.24189,-0.45755>,<-0.18246,14.24187,-0.45771>,<-0.18228,14.24173,-0.45772>,
            
    /*3*/ <-0.16757,14.39667,-0.57602>,<-0.16766,14.39664,-0.57607>,<-0.16756,14.3966,-0.57611>,
            
    /*4*/ <-0.21732,14.55194,-0.68381>

    /* stem 0.59.15*/ 
    /*0*/ <-0.31973,14.22558,-0.38105>,
    /*1*/ <-0.31984,14.22553,-0.38109>,<-0.31968,14.22567,-0.38112>,<-0.31967,14.22554,-0.38094>,
            
    /*2*/ <-0.41468,14.34884,-0.29031>,<-0.41458,14.34894,-0.29033>,<-0.41457,14.34885,-0.29021>,
            
    /*3*/ <-0.49808,14.47678,-0.19479>,<-0.49802,14.47682,-0.19481>,<-0.49802,14.47678,-0.19475>,
            
    /*4*/ <-0.59992,14.5917,-0.10066>

    /* stem 0.59.16*/ 
    /*0*/ <-0.3511,14.30369,-0.40665>,
    /*1*/ <-0.35103,14.30371,-0.40667>,<-0.35114,14.30374,-0.4066>,<-0.35113,14.30362,-0.40666>,
            
    /*2*/ <-0.42376,14.36483,-0.54712>,<-0.42383,14.36486,-0.54708>,<-0.42382,14.36478,-0.54711>,
            
    /*3*/ <-0.45078,14.49677,-0.65012>,<-0.45082,14.49678,-0.6501>,<-0.45082,14.49676,-0.65013>,
            
    /*4*/ <-0.51083,14.65207,-0.68225>

    }
    normal_vectors { 17295
    /* stem 0*/ 
    /*0*/<-0,-1,-0>,
    /*1*/<0.63737,0.76922,-0.04546>,<0.85705,0.11405,0.50245>,<0.793,0.24151,0.55931>,
            <0.49011,0.78094,0.38719>,<0.33176,-0.25843,0.90728>,<-0.13238,-0.49841,0.85677>,
            <-0.28282,0.27615,0.91856>,<-0.34037,0.43491,0.83367>,<-0.73409,0.1891,0.65219>,
            <-0.83408,0.53936,0.11574>,<-0.72486,0.68889,0.00216>,<-0.83199,0.5475,-0.08969>,
            <-0.7874,-0.31363,-0.5307>,<-0.46207,0.24843,-0.85133>,<-0.27362,0.49063,-0.82729>,
            <-0.20213,-0.32044,-0.92545>,<0.22458,-0.28841,-0.9308>,<0.48403,0.72198,-0.49442>,
            <0.45663,0.82667,-0.3288>,<0.81244,0.30518,-0.49679>,
    /*2*/<0.99024,0.11439,-0.07956>,<0.86101,0.2082,0.46402>,<0.77041,0.21084,0.60167>,
            <0.73393,0.38136,0.56207>,<0.38895,0.36333,0.84659>,<-0.17534,0.13709,0.97492>,
            <-0.29324,0.49254,0.8194>,<-0.33765,0.4305,0.83706>,<-0.67387,0.44094,0.59284>,
            <-0.77258,0.62996,0.0792>,<-0.85366,0.52083,0.00215>,<-0.87358,0.48451,-0.04598>,
            <-0.80644,-0.27414,-0.52394>,<-0.43826,0.15311,-0.88571>,<-0.31445,0.3675,-0.87525>,
            <-0.24819,0.11835,-0.96145>,<0.29068,0.05572,-0.9552>,<0.75062,0.05745,-0.65823>,
            <0.62046,0.62302,-0.47632>,<0.77426,0.3939,-0.49534>,
    /*3*/<0.99366,0.06719,-0.09017>,<0.79395,0.3853,0.47031>,<0.77533,0.24206,0.58333>,
            <0.76358,-0.05564,0.64331>,<0.3177,0.52408,0.79019>,<-0.14662,0.40979,0.90032>,
            <-0.29167,0.38176,0.87703>,<-0.34133,0.35773,0.86921>,<-0.68326,0.45199,0.57347>,
            <-0.91199,0.39469,0.1118>,<-0.98575,0.16633,0.025>,<-0.87504,0.48341,-0.02505>,
            <-0.8308,0.20132,-0.51889>,<-0.42148,0.13598,-0.89659>,<-0.28562,0.42211,-0.86038>,
            <-0.20314,0.55578,-0.80613>,<0.20995,0.41368,-0.88589>,<0.74688,-0.11997,-0.65404>,
            <0.7882,0.29914,-0.53783>,<0.74088,0.42042,-0.52378>,
    /*4*/<0.87747,0.47467,-0.06885>,<0.80243,0.4207,0.42323>,<0.78643,0.30318,0.53815>,
            <0.75925,0.21589,0.61395>,<0.36526,0.13602,0.92092>,<-0.1494,0.21819,0.9644>,
            <-0.32947,0.21739,0.9188>,<-0.37199,0.20403,0.90553>,<-0.70874,0.32511,0.62609>,
            <-0.98289,0.12081,0.13905>,<-0.98636,0.16152,-0.03185>,<-0.91471,0.396,-0.0806>,
            <-0.77704,0.44733,-0.44284>,<-0.40744,0.22851,-0.88418>,<-0.25135,0.40457,-0.87928>,
            <-0.24959,0.38691,-0.88769>,<0.19518,0.37176,-0.90758>,<0.69218,0.35596,-0.62784>,
            <0.81401,0.14912,-0.56139>,<0.81856,0.25855,-0.51294>,
    /*5*/<0.97186,0.2333,-0.0327>,<0.84406,0.24984,0.47449>,<0.79145,0.25125,0.55721>,
            <0.75011,0.34196,0.56603>,<0.36547,0.25145,0.89622>,<-0.19655,0.31623,0.9281>,
            <-0.27564,0.29348,0.91536>,<-0.36583,0.22905,0.90206>,<-0.72255,0.31614,0.6148>,
            <-0.95698,0.24767,0.15113>,<-0.96345,0.26598,-0.03208>,<-0.97163,0.22523,-0.07215>,
            <-0.83096,0.28929,-0.47519>,<-0.4095,0.29003,-0.86498>,<-0.27966,0.19193,-0.94072>,
            <-0.25158,0.22189,-0.94206>,<0.21437,0.32744,-0.92023>,<0.68358,0.28451,-0.67214>,
            <0.80108,0.15195,-0.57895>,<0.84093,0.20203,-0.50202>,
    /*6*/<0.96741,0.23965,-0.08176>,<0.86396,0.19155,0.4657>,<0.76814,0.20145,0.60777>,
            <0.7527,0.21561,0.62205>,<0.37027,0.28649,0.88364>,<-0.15411,0.21217,0.96501>,
            <-0.3187,0.20369,0.92571>,<-0.36027,0.25255,0.89801>,<-0.72365,0.20468,0.65912>,
            <-0.96341,0.23144,0.13523>,<-0.97441,0.22397,-0.01882>,<-0.97284,0.21302,-0.09056>,
            <-0.81602,0.25603,-0.51822>,<-0.43739,0.26592,-0.85906>,<-0.30199,0.20271,-0.93151>,
            <-0.19815,0.2416,-0.94993>,<0.22464,0.28161,-0.93286>,<0.66604,0.26068,-0.69889>,
            <0.7812,0.23206,-0.57954>,<0.83667,0.22516,-0.49929>,
    /*7*/<0.98476,0.17018,-0.03591>,<0.85493,0.17993,0.48654>,<0.81574,0.1555,0.55712>,
            <0.76718,0.14547,0.62471>,<0.38103,0.18039,0.9068>,<-0.17108,0.14458,0.97459>,
            <-0.32219,0.16474,0.93223>,<-0.33851,0.1431,0.93002>,<-0.74182,0.17269,0.64798>,
            <-0.98237,0.16152,0.09417>,<-0.9862,0.16314,-0.02831>,<-0.98651,0.15424,-0.0549>,
            <-0.83803,0.17951,-0.51525>,<-0.42917,0.15225,-0.8903>,<-0.28241,0.16004,-0.94585>,
            <-0.22929,0.16492,-0.95928>,<0.23646,0.17059,-0.95655>,<0.70223,0.16107,-0.69349>,
            <0.77576,0.16191,-0.6099>,<0.82999,0.15371,-0.53618>,
    /*8*/<0.99451,0.09455,-0.04482>,<0.87409,0.07665,0.47967>,<0.80177,0.07672,0.59268>,
            <0.75746,0.08927,0.64675>,<0.40799,0.09151,0.90839>,<-0.15588,0.0863,0.984>,
            <-0.33589,0.07561,0.93886>,<-0.34569,0.08327,0.93465>,<-0.7505,0.09504,0.654>,
            <-0.98635,0.09018,0.13775>,<-0.99757,0.06941,0.00564>,<-0.98992,0.08095,-0.11624>,
            <-0.84354,0.09124,-0.52926>,<-0.47185,0.08082,-0.87797>,<-0.27026,0.07715,-0.95969>,
            <-0.20074,0.07904,-0.97645>,<0.19463,0.08472,-0.97721>,<0.68841,0.07285,-0.72165>,
            <0.80841,0.07648,-0.58363>,<0.85219,0.08216,-0.51674>,
    /*9*/<0.99651,0.03743,-0.07467>,<0.88316,0.03291,0.46791>,<0.78308,0.0306,0.62117>,
            <0.77451,0.0326,0.63172>,<0.41134,0.03478,0.91082>,<-0.14948,0.03511,0.98814>,
            <-0.32463,0.0305,0.94535>,<-0.38749,0.03134,0.92134>,<-0.77131,0.03988,0.63521>,
            <-0.98773,0.03518,0.15219>,<-0.99933,0.03313,-0.01528>,<-0.99597,0.03611,-0.08206>,
            <-0.86726,0.03451,-0.49666>,<-0.41171,0.0332,-0.91071>,<-0.29218,0.03547,-0.95571>,
            <-0.28935,0.0292,-0.95678>,<0.21792,0.03079,-0.97548>,<0.7418,0.03421,-0.66975>,
            <0.80854,0.0344,-0.58744>,<0.85063,0.03495,-0.52459>,
    /*10*/<0.99819,0.01579,-0.05794>,<0.88877,0.01908,0.45796>,<0.81885,0.01356,0.57384>,
            <0.74395,0.01547,0.66806>,<0.39387,0.01798,0.91899>,<-0.16148,0.01799,0.98671>,
            <-0.30798,0.01619,0.95126>,<-0.37224,0.01613,0.928>,<-0.76702,0.01737,0.64138>,
            <-0.98717,0.01588,0.15887>,<-0.99986,0.01604,-0.00533>,<-0.99325,0.01494,-0.11503>,
            <-0.85889,0.01857,-0.51182>,<-0.45871,0.01728,-0.88842>,<-0.29842,0.01464,-0.95432>,
            <-0.26554,0.01544,-0.96398>,<0.23766,0.01839,-0.97118>,<0.73256,0.01742,-0.68048>,
            <0.82737,0.01478,-0.56146>,<0.84476,0.01749,-0.53485>,
    /*11*/<0.99927,0.00414,-0.0379>,<0.87861,0.0034,0.47753>,<0.82054,0.00465,0.57157>,
            <0.74159,0.00568,0.67083>,<0.34977,0.01064,0.93678>,<-0.1476,0.01597,0.98892>,
            <-0.28606,0.01622,0.95807>,<-0.36397,0.01843,0.93123>,<-0.75826,0.02332,0.65153>,
            <-0.99399,0.02595,0.10631>,<-0.99966,0.02619,0.00062>,<-0.99816,0.02574,-0.05494>,
            <-0.8368,0.02536,-0.54692>,<-0.41304,0.0214,-0.91046>,<-0.33375,0.01847,-0.94248>,
            <-0.27255,0.01802,-0.96197>,<0.25803,0.01452,-0.96603>,<0.72356,0.00785,-0.69021>,
            <0.80066,0.00528,-0.5991>,<0.83176,0.00435,-0.55512>,
    /*12*/<0.99895,0.02615,-0.0375>,<0.81976,0.03884,0.57139>,<0.70074,0.04112,0.71223>,
            <0.83625,0.03822,0.54702>,<0.5004,0.04487,0.86463>,<-0.21184,0.03916,0.97652>,
            <-0.42565,0.03425,0.90424>,<-0.30663,0.0372,0.9511>,<-0.68857,0.02858,0.72461>,
            <-0.9997,0.00428,0.02409>,<-0.99997,0.00316,0.00703>,<-0.99967,0.00288,-0.02552>,
            <-0.77701,-0.00987,-0.62941>,<-0.49662,-0.01442,-0.86785>,<-0.48118,-0.01585,-0.87648>,
            <-0.13509,-0.01389,-0.99074>,<0.41978,-0.00461,-0.90761>,<0.70066,0.00288,-0.71349>,
            <0.70565,0.00201,-0.70856>,<0.83237,0.00834,-0.55416>,
    /*13*/<-0.04484,0.99736,-0.05705>

    /* stem 0.0*/ 
    /*0*/<-0.60599,0.33349,-0.72219>,
    /*1*/<-0.75976,-0.00343,0.65019>,<-0.02661,0.89313,0.44901>,<0.75194,0.55067,-0.36241>,
            <0.49996,-0.55754,-0.66271>,<-0.43433,-0.9,-0.03689>,
    /*2*/<-0.78749,0.00785,0.61628>,<-0.11639,0.93414,0.33741>,<0.72522,0.5624,-0.39719>,
            <0.57217,-0.58688,-0.57288>,<-0.36365,-0.92996,0.05409>,
    /*3*/<-0.7993,0.01014,0.60085>,<-0.21871,0.95341,0.2078>,<0.67296,0.57857,-0.46085>,
            <0.64182,-0.59646,-0.48199>,<-0.26796,-0.94758,0.17402>,
    /*4*/<-0.77935,0.0138,0.62644>,<-0.23659,0.95516,0.17805>,<0.642,0.5766,-0.50534>,
            <0.64201,-0.59861,-0.47905>,<-0.23639,-0.94635,0.22032>,
    /*5*/<-0.75446,0.01705,0.65612>,<-0.25509,0.95466,0.15347>,<0.60619,0.57385,-0.55066>,
            <0.63855,-0.59948,-0.48257>,<-0.20225,-0.94334,0.26308>,
    /*6*/<0.67087,0.08794,0.73634>

    /* stem 0.0.0*/ 
    /*0*/<-0.09905,-0.3797,-0.91979>,
    /*1*/<0.72549,0.60945,-0.31973>,<0.22922,-0.90482,0.35883>,<-0.95199,0.30583,-0.01375>,
            
    /*2*/<0.70708,0.5469,-0.44827>,<0.25126,-0.86683,0.43066>,<-0.94127,0.33618,0.03161>,
            
    /*3*/<0.64095,0.49826,-0.58388>,<0.26447,-0.86973,0.41668>,<-0.90351,0.38169,0.19488>,
            
    /*4*/<0.44883,0.40112,0.79853>

    /* stem 0.0.1*/ 
    /*0*/<-0.93707,0.33026,0.11324>,
    /*1*/<-0.33553,-0.93142,-0.141>,<0.23165,0.31384,0.92078>,<0.12962,0.6085,-0.7829>,
            
    /*2*/<-0.2053,-0.96797,-0.14455>,<0.12484,0.33518,0.93385>,<0.10648,0.61321,-0.78271>,
            
    /*3*/<0.10632,-0.99313,-0.04892>,<-0.32528,0.35832,0.8751>,<0.16971,0.63503,-0.75362>,
            
    /*4*/<0.80258,0.25868,0.53754>

    /* stem 0.0.2*/ 
    /*0*/<0.14244,0.57153,-0.80812>,
    /*1*/<-0.19867,0.8112,0.54999>,<0.93733,-0.34223,-0.06553>,<-0.74256,-0.48462,-0.46234>,
            
    /*2*/<-0.21869,0.88367,0.41389>,<0.93706,-0.31858,-0.1429>,<-0.76342,-0.60204,-0.23396>,
            
    /*3*/<-0.2797,0.95994,0.01696>,<0.9734,-0.20926,-0.09324>,<-0.70261,-0.70711,0.07965>,
            
    /*4*/<0.02104,0.23657,0.97139>

    /* stem 0.0.3*/ 
    /*0*/<-0.74603,-0.45667,-0.48465>,
    /*1*/<0.65328,-0.31828,-0.68697>,<-0.17838,-0.55267,0.81409>,<-0.45458,0.88339,-0.11392>,
            
    /*2*/<0.64009,-0.32626,-0.69559>,<-0.17502,-0.55085,0.81605>,<-0.44436,0.88935,-0.10771>,
            
    /*3*/<0.65819,-0.30077,-0.69016>,<-0.18475,-0.57529,0.79681>,<-0.45199,0.88709,-0.09369>,
            
    /*4*/<0.71429,0.44656,0.53887>

    /* stem 0.0.4*/ 
    /*0*/<-0.57869,0.69196,-0.43163>,
    /*1*/<-0.78021,-0.33671,0.52716>,<0.58797,0.71483,0.37855>,<0.2079,-0.39685,-0.89403>,
            
    /*2*/<-0.5852,-0.41955,0.69391>,<0.27742,0.93097,0.23735>,<0.27419,-0.40878,-0.87047>,
            
    /*3*/<-0.19312,-0.47134,0.86055>,<-0.26248,0.96318,-0.05815>,<0.42671,-0.43963,-0.79034>,
            
    /*4*/<0.81545,0.51247,0.26909>

    /* stem 0.0.5*/ 
    /*0*/<0.22764,-0.37967,-0.89668>,
    /*1*/<0.44541,0.86202,-0.24193>,<0.52318,-0.7241,0.4494>,<-0.97471,-0.12772,-0.18338>,
            
    /*2*/<0.42144,0.78712,-0.45037>,<0.51338,-0.75849,0.40141>,<-0.99603,0.03466,0.082>,
            
    /*3*/<0.30353,0.64645,-0.69998>,<0.59335,-0.75504,0.27903>,<-0.89104,0.12836,0.43539>,
            
    /*4*/<0.48237,0.60727,0.63131>

    /* stem 0.0.6*/ 
    /*0*/<-0.9512,-0.05318,-0.30396>,
    /*1*/<0.10831,-0.98455,-0.13762>,<-0.29437,0.3511,0.88886>,<0.21129,0.63485,-0.74318>,
            
    /*2*/<0.24571,-0.96717,-0.06486>,<-0.45324,0.3178,0.83282>,<0.22152,0.63908,-0.73655>,
            
    /*3*/<0.47494,-0.8696,0.13503>,<-0.71857,0.25129,0.64847>,<0.2549,0.61248,-0.74826>,
            
    /*4*/<0.533,0.56459,0.63019>

    /* stem 0.0.7*/ 
    /*0*/<0.07006,0.61987,-0.78157>,
    /*1*/<-0.59862,0.64773,0.47128>,<0.9898,0.04456,0.13529>,<-0.39303,-0.70861,-0.586>,
            
    /*2*/<-0.61679,0.71375,0.33187>,<0.99572,0.06943,0.06108>,<-0.41265,-0.83413,-0.36598>,
            
    /*3*/<-0.64022,0.76393,0.08074>,<0.98362,0.13041,-0.12446>,<-0.35018,-0.93239,0.0896>,
            
    /*4*/<0.21791,0.23607,0.94699>

    /* stem 0.0.8*/ 
    /*0*/<-0.37239,-0.80486,-0.46209>,
    /*1*/<0.79326,-0.00665,-0.60885>,<0.02996,-0.49996,0.86553>,<-0.81349,0.52764,-0.24461>,
            
    /*2*/<0.79743,0.00589,-0.60339>,<0.04556,-0.45609,0.88877>,<-0.83786,0.47259,-0.27324>,
            
    /*3*/<0.75488,-0.08934,-0.64975>,<0.05883,-0.41278,0.90893>,<-0.80465,0.53138,-0.2649>,
            
    /*4*/<0.55025,0.7689,0.3256>

    /* stem 0.0.9*/ 
    /*0*/<-0.76354,0.62861,-0.1478>,
    /*1*/<-0.60579,-0.63766,0.47583>,<0.49019,0.70288,0.51544>,<0.13536,-0.08148,-0.98744>,
            
    /*2*/<-0.51118,-0.68094,0.52442>,<0.2652,0.85123,0.45286>,<0.25815,-0.1231,-0.95823>,
            
    /*3*/<-0.29757,-0.71138,0.63671>,<-0.14469,0.95635,0.25387>,<0.44186,-0.21428,-0.87112>,
            
    /*4*/<0.85424,0.22844,0.46701>

    /* stem 0.0.10*/ 
    /*0*/<0.01885,-0.11825,-0.99281>,
    /*1*/<0.14803,0.98332,-0.10572>,<0.78202,-0.6157,0.09677>,<-0.93053,-0.36459,0.03435>,
            
    /*2*/<0.13354,0.96546,-0.22374>,<0.78034,-0.62033,0.0791>,<-0.92753,-0.33239,0.17089>,
            
    /*3*/<0.06898,0.90322,-0.4236>,<0.78799,-0.61519,0.02472>,<-0.86255,-0.2737,0.42554>,
            
    /*4*/<0.38548,0.46401,0.79756>

    /* stem 0.0.11*/ 
    /*0*/<-0.90847,-0.41792,0.00509>,
    /*1*/<0.40762,-0.86925,-0.27973>,<-0.08721,0.22164,0.97122>,<-0.29736,0.65821,-0.69162>,
            
    /*2*/<0.42563,-0.8606,-0.27965>,<-0.09805,0.21646,0.97135>,<-0.30456,0.65485,-0.69168>,
            
    /*3*/<0.43145,-0.8521,-0.29626>,<-0.09681,0.19852,0.9753>,<-0.31187,0.66473,-0.67887>,
            
    /*4*/<0.90189,0.43193,0.00507>

    /* stem 0.0.12*/ 
    /*0*/<-0.30911,0.57724,-0.75581>,
    /*1*/<-0.73534,0.35093,0.57976>,<0.89106,0.45384,-0.00679>,<-0.148,-0.81919,-0.5541>,
            
    /*2*/<-0.67695,0.34487,0.65023>,<0.71645,0.60998,-0.33857>,<0.02276,-0.91209,-0.40935>,
            
    /*3*/<-0.59072,0.27085,0.76006>,<0.30707,0.67279,-0.6731>,<0.31732,-0.94209,-0.10856>,
            
    /*4*/<0.79925,0.39136,0.4561>

    /* stem 0.0.13*/ 
    /*0*/<-0.20691,-0.72968,-0.65173>,
    /*1*/<0.73218,0.33329,-0.59399>,<0.19973,-0.67805,0.70735>,<-0.92721,0.36133,-0.09856>,
            
    /*2*/<0.74663,0.37604,-0.54876>,<0.18741,-0.72985,0.65741>,<-0.92577,0.36678,-0.09176>,
            
    /*3*/<0.74784,0.3161,-0.58379>,<0.16747,-0.73071,0.66183>,<-0.90015,0.42984,-0.07042>,
            
    /*4*/<0.34546,0.71737,0.60501>

    /* stem 0.0.14*/ 
    /*0*/<-0.93147,0.36379,-0.0036>,
    /*1*/<-0.32842,-0.85292,0.40579>,<0.29755,0.75165,0.58864>,<0.04717,0.09491,-0.99437>,
            
    /*2*/<-0.38423,-0.83963,0.38391>,<0.13967,0.83223,0.53655>,<0.30015,0.02231,-0.95363>,
            
    /*3*/<-0.40817,-0.79673,0.44567>,<-0.17756,0.9138,0.36529>,<0.59032,-0.09287,-0.80181>,
            
    /*4*/<0.74202,0.07717,0.66592>

    /* stem 0.0.15*/ 
    /*0*/<0.16501,0.06562,-0.98411>,
    /*1*/<-0.17069,0.98443,0.04198>,<0.92551,-0.35322,0.13659>,<-0.75724,-0.63217,-0.16416>,
            
    /*2*/<-0.17215,0.98274,-0.06771>,<0.92881,-0.36092,0.0839>,<-0.77883,-0.62722,0.00355>,
            
    /*3*/<-0.18102,0.96002,-0.21353>,<0.94286,-0.32667,0.06558>,<-0.76,-0.62949,0.16169>,
            
    /*4*/<-0.02064,0.25536,0.96663>

    /* stem 0.0.16*/ 
    /*0*/<-0.77934,-0.61322,-0.12876>,
    /*1*/<0.59631,-0.65622,-0.46238>,<-0.12252,-0.0479,0.99131>,<-0.46727,0.70924,-0.52786>,
            
    /*2*/<0.67822,-0.58331,-0.44695>,<-0.15227,-0.07958,0.98513>,<-0.51298,0.66542,-0.54227>,
            
    /*3*/<0.81129,-0.44404,-0.38032>,<-0.24232,-0.15233,0.95816>,<-0.55836,0.59902,-0.57393>,
            
    /*4*/<0.48706,0.80853,0.33022>

    /* stem 0.0.17*/ 
    /*0*/<-0.47745,0.68528,-0.54993>,
    /*1*/<-0.73973,0.0223,0.67253>,<0.7806,0.61782,0.09466>,<-0.0389,-0.64294,-0.76492>,
            
    /*2*/<-0.73312,0.01824,0.67986>,<0.68283,0.72938,-0.04191>,<0.0802,-0.74567,-0.66147>,
            
    /*3*/<-0.72089,0.0123,0.69294>,<0.38269,0.83735,-0.39038>,<0.39504,-0.84562,-0.35897>,
            
    /*4*/<0.66451,0.32524,0.6728>

    /* stem 0.1*/ 
    /*0*/<0.93799,0.30467,0.16539>,
    /*1*/<0.16387,-0.00317,-0.98648>,<-0.24145,0.90262,-0.35634>,<-0.3266,0.55664,0.76387>,
            <0.02611,-0.56298,0.82606>,<0.32923,-0.90896,-0.25571>,
    /*2*/<0.18972,0.00403,-0.98183>,<-0.16614,0.92483,-0.34218>,<-0.30605,0.56258,0.76801>,
            <-0.03639,-0.57975,0.81398>,<0.27001,-0.92494,-0.26754>,
    /*3*/<0.25095,0.01175,-0.96793>,<-0.02406,0.94947,-0.31293>,<-0.27975,0.57228,0.77087>,
            <-0.16209,-0.59667,0.78595>,<0.16583,-0.94295,-0.28869>,
    /*4*/<0.27222,0.01116,-0.96217>,<0.10986,0.95383,-0.27953>,<-0.21851,0.57791,0.7863>,
            <-0.25799,-0.59585,0.76053>,<0.04512,-0.94639,-0.31985>,
    /*5*/<0.26627,0.01432,-0.96379>,<0.24507,0.93965,-0.23875>,<-0.1289,0.56791,0.81294>,
            <-0.33789,-0.58553,0.73687>,<-0.09361,-0.92781,-0.36111>,
    /*6*/<-0.92686,0.25997,-0.27083>

    /* stem 0.1.0*/ 
    /*0*/<0.80559,-0.21897,0.55052>,
    /*1*/<-0.33337,0.61424,0.71524>,<-0.27305,-0.962,0>,<0.58392,0.35388,-0.73062>,
            
    /*2*/<-0.19604,0.60151,0.77443>,<-0.2254,-0.97416,0.01471>,<0.40015,0.40775,-0.82074>,
            
    /*3*/<-0.01782,0.6146,0.78864>,<-0.10201,-0.98727,0.12207>,<0.09264,0.37293,-0.92323>,
            
    /*4*/<-0.99986,0.00881,0.01394>

    /* stem 0.1.1*/ 
    /*0*/<0.65587,0.31468,-0.68616>,
    /*1*/<0.31955,-0.94086,-0.11255>,<-0.75865,0.3401,-0.55569>,<0.42088,0.59202,0.68729>,
            
    /*2*/<0.24277,-0.96814,-0.0614>,<-0.64303,0.38302,-0.66318>,<0.37178,0.58279,0.72258>,
            
    /*3*/<-0.07597,-0.99635,0.03904>,<-0.28125,0.42451,-0.86064>,<0.31812,0.54547,0.77541>,
            
    /*4*/<-0.94091,0.2968,0.1631>

    /* stem 0.1.2*/ 
    /*0*/<0.48781,0.5465,0.68072>,
    /*1*/<-0.17751,0.81978,-0.54448>,<-0.65896,-0.29208,0.69315>,<0.82297,-0.54282,-0.16751>,
            
    /*2*/<0.05789,0.93137,-0.35945>,<-0.65457,-0.28983,0.69823>,<0.64704,-0.62572,-0.43568>,
            
    /*3*/<0.37346,0.92071,-0.11322>,<-0.59504,-0.24001,0.76702>,<0.20263,-0.68795,-0.6969>,
            
    /*4*/<-0.82045,0.42063,-0.38721>

    /* stem 0.1.3*/ 
    /*0*/<0.88374,-0.45694,-0.10105>,
    /*1*/<-0.06867,-0.32155,0.9444>,<-0.3797,-0.54971,-0.74408>,<0.42402,0.88385,-0.19754>,
            
    /*2*/<-0.04253,-0.33083,0.94273>,<-0.3036,-0.5791,-0.75662>,<0.32143,0.92764,-0.19021>,
            
    /*3*/<-0.22904,-0.27195,0.93466>,<-0.12334,-0.66665,-0.73509>,<0.30327,0.93721,-0.17223>,
            
    /*4*/<-0.88176,0.33647,-0.3306>

    /* stem 0.1.4*/ 
    /*0*/<0.63642,0.76591,-0.09135>,
    /*1*/<0.26039,-0.33625,-0.90506>,<-0.76585,0.63586,0.09574>,<0.488,-0.32061,0.81183>,
            
    /*2*/<0.21168,-0.37173,-0.90389>,<-0.64779,0.75705,0.08509>,<0.40873,-0.38341,0.82821>,
            
    /*3*/<0.19514,-0.40521,-0.89315>,<-0.29678,0.94695,0.12329>,<0.04933,-0.5428,0.83842>,
            
    /*4*/<-0.96624,-0.01411,-0.25727>

    /* stem 0.1.5*/ 
    /*0*/<0.71046,-0.16462,0.68422>,
    /*1*/<-0.25551,0.85194,0.45708>,<-0.45184,-0.85637,0.24994>,<0.6881,0.00889,-0.72556>,
            
    /*2*/<-0.07432,0.80978,0.58201>,<-0.48127,-0.84386,0.23723>,<0.55631,0.0779,-0.82731>,
            
    /*3*/<0.19403,0.73079,0.65445>,<-0.51858,-0.80635,0.28439>,<0.30567,0.09181,-0.9477>,
            
    /*4*/<-0.86222,0.48199,-0.15576>

    /* stem 0.1.6*/ 
    /*0*/<0.87087,0.00423,-0.49149>,
    /*1*/<0.10763,-0.97375,0.20054>,<-0.47924,0.28976,-0.82847>,<0.34823,0.68388,0.64112>,
            
    /*2*/<-0.06749,-0.97605,0.20682>,<-0.12758,0.25879,-0.95747>,<0.22092,0.72419,0.65326>,
            
    /*3*/<-0.40745,-0.90508,0.12172>,<0.32811,0.256,-0.90929>,<0.05076,0.63921,0.76736>,
            
    /*4*/<-0.81117,0.49258,-0.31522>

    /* stem 0.1.7*/ 
    /*0*/<0.38602,0.63487,0.66928>,
    /*1*/<0.19641,0.64507,-0.73845>,<-0.88324,0.02972,0.46798>,<0.67656,-0.69169,0.25266>,
            
    /*2*/<0.30025,0.70778,-0.63946>,<-0.82754,0.06118,0.55806>,<0.53567,-0.84383,0.03174>,
            
    /*3*/<0.53134,0.72363,-0.44049>,<-0.6555,0.11062,0.74705>,<0.05667,-0.90939,-0.41207>,
            
    /*4*/<-0.72666,0.5074,-0.46316>

    /* stem 0.1.8*/ 
    /*0*/<0.7333,-0.64351,0.21947>,
    /*1*/<-0.30206,-0.00543,0.95327>,<-0.38887,-0.65159,-0.65132>,<0.67158,0.674,-0.30775>,
            
    /*2*/<-0.30375,-0.00268,0.95275>,<-0.43758,-0.60096,-0.66885>,<0.72534,0.62224,-0.29445>,
            
    /*3*/<-0.26169,-0.0526,0.96372>,<-0.50062,-0.53152,-0.68328>,<0.74591,0.60424,-0.28019>,
            
    /*4*/<-0.67164,0.73833,-0.06144>

    /* stem 0.1.9*/ 
    /*0*/<0.71239,0.63329,-0.30241>,
    /*1*/<0.24685,-0.63924,-0.72831>,<-0.6996,0.69601,-0.16165>,<0.4341,-0.07334,0.89787>,
            
    /*2*/<0.15394,-0.67127,-0.72505>,<-0.43554,0.87085,-0.22786>,<0.2683,-0.12684,0.95495>,
            
    /*3*/<0.09668,-0.70731,-0.70026>,<0.08253,0.98396,-0.15813>,<-0.26035,-0.23488,0.93651>,
            
    /*4*/<-0.83566,0.25968,-0.48397>

    /* stem 0.1.10*/ 
    /*0*/<0.31808,-0.1277,0.93943>,
    /*1*/<-0.09486,0.9831,0.15654>,<-0.77383,-0.61019,0.16985>,<0.86044,-0.3696,-0.35078>,
            
    /*2*/<-0.0721,0.97023,0.23119>,<-0.79416,-0.59683,0.11449>,<0.85554,-0.36472,-0.36747>,
            
    /*3*/<0.00787,0.91401,0.40562>,<-0.75618,-0.64224,0.12538>,<0.76247,-0.26158,-0.59179>,
            
    /*4*/<-0.62896,0.44042,-0.64065>

    /* stem 0.1.11*/ 
    /*0*/<0.86656,-0.3884,-0.31341>,
    /*1*/<-0.23592,-0.86374,0.44531>,<-0.27734,0.16668,-0.9462>,<0.49109,0.70699,0.50891>,
            
    /*2*/<-0.22125,-0.86889,0.4428>,<-0.15728,0.13188,-0.97871>,<0.35884,0.76377,0.53655>,
            
    /*3*/<-0.3226,-0.84623,0.42406>,<0.07321,0.0467,-0.99622>,<0.22239,0.79587,0.56315>,
            
    /*4*/<-0.90535,0.38753,-0.17365>

    /* stem 0.1.12*/ 
    /*0*/<0.76362,0.47504,0.43729>,
    /*1*/<0.28345,0.34889,-0.89327>,<-0.651,0.51762,0.55522>,<0.34822,-0.87853,0.32698>,
            
    /*2*/<0.31689,0.36316,-0.87618>,<-0.59834,0.54275,0.58941>,<0.26087,-0.92413,0.27916>,
            
    /*3*/<0.28567,0.38284,-0.87854>,<-0.37112,0.60351,0.70572>,<0.06086,-0.97961,0.19146>,
            
    /*4*/<-0.96975,0.00753,-0.24399>

    /* stem 0.1.13*/ 
    /*0*/<0.63384,-0.67016,0.38617>,
    /*1*/<-0.22045,0.3315,0.91734>,<-0.5403,-0.73535,-0.40907>,<0.74623,0.4192,-0.51712>,
            
    /*2*/<-0.11947,0.25753,0.95886>,<-0.5136,-0.75772,-0.40258>,<0.62853,0.53597,-0.56364>,
            
    /*3*/<0.05507,0.17825,0.98244>,<-0.50376,-0.79487,-0.33824>,<0.43189,0.63142,-0.64404>,
            
    /*4*/<-0.85208,0.52298,0.02107>

    /* stem 0.1.14*/ 
    /*0*/<0.94589,0.11851,-0.30206>,
    /*1*/<-0.07742,-0.83177,-0.5497>,<-0.24346,0.88541,-0.39595>,<0.30454,-0.05569,0.95087>,
            
    /*2*/<-0.16708,-0.83442,-0.52519>,<-0.1555,0.88981,-0.42902>,<0.30365,-0.05519,0.95118>,
            
    /*3*/<-0.27582,-0.83017,-0.4845>,<0.10154,0.86414,-0.4929>,<0.16831,-0.00704,0.98571>,
            
    /*4*/<-0.94556,0.32452,0.02467>

    /* stem 0.1.15*/ 
    /*0*/<0.47744,-0.0684,0.876>,
    /*1*/<0.28977,0.95297,-0.08877>,<-0.86588,-0.21948,0.44953>,<0.56952,-0.73255,-0.37286>,
            
    /*2*/<0.38268,0.9174,0.10922>,<-0.91957,-0.17817,0.3502>,<0.5454,-0.70624,-0.45141>,
            
    /*3*/<0.50849,0.77818,0.36862>,<-0.9468,-0.17628,0.26923>,<0.44894,-0.59767,-0.66426>,
            
    /*4*/<-0.36271,0.68755,-0.62905>

    /* stem 0.1.16*/ 
    /*0*/<0.59576,-0.72666,-0.3421>,
    /*1*/<-0.37733,-0.62604,0.68241>,<-0.42924,0.07636,-0.89996>,<0.80061,0.55695,0.22097>,
            
    /*2*/<-0.4244,-0.56957,0.7039>,<-0.39219,0.02471,-0.91955>,<0.80643,0.54946,0.21855>,
            
    /*3*/<-0.44295,-0.54342,0.71308>,<-0.22145,-0.11575,-0.96828>,<0.67283,0.69808,0.24492>,
            
    /*4*/<-0.8397,0.54178,-0.03704>

    /* stem 0.1.17*/ 
    /*0*/<0.89134,0.36636,0.26701>,
    /*1*/<0.28219,0.00983,-0.95931>,<-0.4491,0.80029,0.3973>,<0.16419,-0.81124,0.56119>,
            
    /*2*/<0.13456,0.01807,-0.99074>,<-0.12405,0.87889,0.46061>,<0.02678,-0.82206,0.56877>,
            
    /*3*/<-0.02535,-0.03796,-0.99896>,<0.37135,0.78578,0.49462>,<-0.35608,-0.749,0.55875>,
            
    /*4*/<-0.76276,0.64622,-0.02445>

    /* stem 0.2*/ 
    /*0*/<-0.83231,0.27633,0.48053>,
    /*1*/<0.50873,-0.00291,0.86092>,<0.39084,0.91107,0.13115>,<-0.25508,0.56196,-0.78685>,
            <-0.53638,-0.56777,-0.62444>,<-0.06433,-0.91688,0.39394>,
    /*2*/<0.5067,-0.00209,0.86212>,<0.33444,0.92803,0.16406>,<-0.28813,0.57149,-0.76836>,
            <-0.50005,-0.57745,-0.64538>,<-0.00897,-0.93204,0.36224>,
    /*3*/<0.52903,-0.0029,0.8486>,<0.22041,0.94764,0.23108>,<-0.38111,0.58702,-0.71426>,
            <-0.44308,-0.58569,-0.67871>,<0.11893,-0.95054,0.28694>,
    /*4*/<0.50121,-0.00172,0.86532>,<0.10301,0.94916,0.29746>,<-0.42477,0.58804,-0.68831>,
            <-0.35345,-0.5843,-0.73052>,<0.21853,-0.9484,0.22973>,
    /*5*/<0.50036,-0.00164,0.86582>,<-0.03787,0.92256,0.38399>,<-0.51303,0.57486,-0.63744>,
            <-0.26549,-0.56381,-0.78207>,<0.36089,-0.92116,0.14568>,
    /*6*/<0.78198,0.36084,-0.50823>

    /* stem 0.2.0*/ 
    /*0*/<-0.93557,-0.3531,-0.00492>,
    /*1*/<-0.22039,0.62105,-0.75214>,<0.35604,-0.91402,-0.19445>,<-0.10926,0.30292,0.94673>,
            
    /*2*/<-0.34539,0.54709,-0.76249>,<0.513,-0.83271,-0.20838>,<-0.1321,0.28773,0.94856>,
            
    /*3*/<-0.47488,0.49508,-0.72759>,<0.53546,-0.81837,-0.2087>,<-0.02975,0.32691,0.94459>,
            
    /*4*/<0.85888,0.44412,-0.25511>

    /* stem 0.2.1*/ 
    /*0*/<-0.15621,0.30854,0.9383>,
    /*1*/<-0.14738,-0.94931,0.27764>,<0.92147,0.38812,0.0158>,<-0.7697,0.55251,-0.31982>,
            
    /*2*/<-0.09503,-0.9798,0.17596>,<0.86528,0.44489,0.23101>,<-0.73346,0.54485,-0.40642>,
            
    /*3*/<-0.04131,-0.99355,0.10562>,<0.66068,0.55183,0.5089>,<-0.60448,0.46299,-0.64826>,
            
    /*4*/<0.79689,-0.14029,-0.58761>

    /* stem 0.2.2*/ 
    /*0*/<-0.75134,0.55004,-0.36461>,
    /*1*/<0.46423,0.82714,0.31675>,<0.19045,-0.36175,-0.91261>,<-0.63367,-0.48078,0.60607>,
            
    /*2*/<0.29567,0.91403,0.27771>,<0.17087,-0.35506,-0.9191>,<-0.44855,-0.56467,0.69278>,
            
    /*3*/<-0.02954,0.96855,0.24704>,<0.08809,-0.31221,-0.94592>,<-0.01796,-0.6713,0.74097>,
            
    /*4*/<0.97521,0.20995,-0.06988>

    /* stem 0.2.3*/ 
    /*0*/<-0.60967,-0.46824,0.63958>,
    /*1*/<-0.54601,-0.32434,-0.77245>,<0.77438,-0.54158,0.32715>,<-0.21139,0.87896,0.42748>,
            
    /*2*/<-0.54514,-0.32367,-0.77335>,<0.77437,-0.54158,0.32717>,<-0.21224,0.87832,0.42839>,
            
    /*3*/<-0.48672,-0.2919,-0.82334>,<0.66141,-0.61943,0.4229>,<-0.14665,0.90635,0.39627>,
            
    /*4*/<0.82605,0.27256,-0.49331>

    /* stem 0.2.4*/ 
    /*0*/<-0.44767,0.72808,0.51913>,
    /*1*/<0.42852,-0.34472,0.83519>,<0.47354,0.67872,-0.56134>,<-0.88965,-0.35418,-0.28824>,
            
    /*2*/<0.49185,-0.37509,0.78574>,<0.28914,0.87345,-0.39178>,<-0.78913,-0.43747,-0.43115>,
            
    /*3*/<0.46289,-0.42579,0.77746>,<-0.02372,0.9876,-0.15519>,<-0.41874,-0.59058,-0.68984>,
            
    /*4*/<0.93601,0.12495,-0.32904>

    /* stem 0.2.5*/ 
    /*0*/<-0.95184,-0.2561,-0.16854>,
    /*1*/<-0.1343,0.85948,-0.4932>,<0.31507,-0.81318,-0.48936>,<-0.15461,-0.03927,0.98719>,
            
    /*2*/<-0.14726,0.85671,-0.49434>,<0.23958,-0.83487,-0.49558>,<-0.06451,-0.02073,0.9977>,
            
    /*3*/<-0.28897,0.82659,-0.48295>,<0.18584,-0.84034,-0.50921>,<0.12333,0.03412,0.99178>,
            
    /*4*/<0.90832,0.35516,-0.22094>

    /* stem 0.2.6*/ 
    /*0*/<-0.42911,0.01439,0.90314>,
    /*1*/<-0.20137,-0.97535,-0.0902>,<0.86828,0.29646,0.39775>,<-0.65521,0.6785,-0.33218>,
            
    /*2*/<-0.20548,-0.97536,-0.08035>,<0.88971,0.29671,0.34697>,<-0.67242,0.6804,-0.2914>,
            
    /*3*/<-0.22629,-0.9627,-0.14831>,<0.87257,0.24124,0.42477>,<-0.6247,0.7242,-0.29203>,
            
    /*4*/<0.54775,0.06331,-0.83425>

    /* stem 0.2.7*/ 
    /*0*/<-0.69207,0.69317,-0.20136>,
    /*1*/<0.46376,0.63072,0.62218>,<0.26099,-0.03273,-0.96479>,<-0.70598,-0.6168,0.34806>,
            
    /*2*/<0.3323,0.68082,0.65274>,<0.07068,0.01148,-0.99743>,<-0.33225,-0.86301,0.38056>,
            
    /*3*/<0.13115,0.72722,0.67376>,<-0.32926,0.18033,-0.92686>,<0.22879,-0.94834,0.2198>,
            
    /*4*/<0.83097,0.3279,-0.44941>

    /* stem 0.2.8*/ 
    /*0*/<-0.54219,-0.76262,0.35277>,
    /*1*/<-0.53929,0.00562,-0.8421>,<0.83137,-0.55274,0.0575>,<-0.27751,0.5676,0.77513>,
            
    /*2*/<-0.53694,0.00752,-0.84359>,<0.79348,-0.60268,0.08464>,<-0.23831,0.61401,0.75246>,
            
    /*3*/<-0.586,-0.03231,-0.80967>,<0.72292,-0.67746,0.13579>,<-0.12168,0.73641,0.6655>,
            
    /*4*/<0.64473,0.48557,-0.59038>

    /* stem 0.2.9*/ 
    /*0*/<-0.22756,0.60545,0.76266>,
    /*1*/<0.42917,-0.64709,0.63014>,<0.54624,0.72315,-0.42271>,<-0.96936,-0.09214,-0.2277>,
            
    /*2*/<0.49005,-0.66208,0.56701>,<0.36001,0.92687,-0.10634>,<-0.87748,-0.13568,-0.46003>,
            
    /*3*/<0.64646,-0.65281,0.39488>,<0.08305,0.9691,0.23229>,<-0.70484,-0.31193,-0.6371>,
            
    /*4*/<0.56562,0.25432,-0.78448>

    /* stem 0.2.10*/ 
    /*0*/<-0.9791,-0.13129,-0.15531>,
    /*1*/<-0.10171,0.98554,-0.13548>,<0.21169,-0.59225,-0.77745>,<-0.08424,-0.38985,0.91702>,
            
    /*2*/<-0.31899,0.9296,-0.1846>,<0.3517,-0.5342,-0.76872>,<-0.03016,-0.36098,0.93208>,
            
    /*3*/<-0.56987,0.79918,-0.19118>,<0.47077,-0.47398,-0.74412>,<0.11781,-0.30896,0.94375>,
            
    /*4*/<0.76329,0.64501,0.03671>

    /* stem 0.2.11*/ 
    /*0*/<-0.27742,-0.46018,0.84337>,
    /*1*/<-0.12841,-0.84754,-0.51496>,<0.89206,0.21224,0.39897>,<-0.75644,0.64726,0.09408>,
            
    /*2*/<-0.05483,-0.77002,-0.63566>,<0.83544,0.10535,0.53939>,<-0.74674,0.66004,0.08205>,
            
    /*3*/<0.00766,-0.72163,-0.69223>,<0.70902,0.03339,0.70439>,<-0.7074,0.70618,-0.0298>,
            
    /*4*/<0.63009,0.48791,-0.60409>

    /* stem 0.2.12*/ 
    /*0*/<-0.86319,0.46222,0.2031>,
    /*1*/<0.3852,0.32062,0.86535>,<0.10847,0.5484,-0.82915>,<-0.47153,-0.88088,-0.0414>,
            
    /*2*/<0.27599,0.31859,0.90682>,<-0.08822,0.56178,-0.82257>,<-0.11866,-0.98308,-0.13957>,
            
    /*3*/<-0.00679,0.2672,0.96362>,<-0.34944,0.59476,-0.72398>,<0.40783,-0.88306,-0.23212>,
            
    /*4*/<0.79819,0.60221,0.01509>

    /* stem 0.2.13*/ 
    /*0*/<-0.61338,-0.78976,-0.00604>,
    /*1*/<-0.44283,0.36095,-0.82074>,<0.79246,-0.60409,-0.08417>,<-0.33401,0.26324,0.90506>,
            
    /*2*/<-0.4857,0.30681,-0.81851>,<0.80195,-0.59115,-0.08619>,<-0.30427,0.30644,0.90195>,
            
    /*3*/<-0.53708,0.25846,-0.80296>,<0.77599,-0.62359,-0.09471>,<-0.22187,0.38412,0.89623>,
            
    /*4*/<0.64689,0.7332,-0.20966>

    /* stem 0.2.14*/ 
    /*0*/<-0.37324,0.26714,0.88844>,
    /*1*/<0.3113,-0.86925,0.38406>,<0.60604,0.7954,0.00734>,<-0.90929,0.06808,-0.41056>,
            
    /*2*/<0.42576,-0.87201,0.24149>,<0.48124,0.82719,0.2901>,<-0.86764,0.08445,-0.48997>,
            
    /*3*/<0.57295,-0.81863,0.0396>,<0.22858,0.79043,0.56831>,<-0.78671,0.03864,-0.61611>,
            
    /*4*/<0.58227,0.45048,-0.67677>

    /* stem 0.2.15*/ 
    /*0*/<-0.97618,-0.20861,-0.05969>,
    /*1*/<-0.21064,0.92316,0.32155>,<0.10396,-0.17693,-0.97872>,<0.1247,-0.74239,0.65826>,
            
    /*2*/<-0.31682,0.88521,0.34064>,<0.02706,-0.21672,-0.97586>,<0.32884,-0.67659,0.65886>,
            
    /*3*/<-0.4732,0.78872,0.39244>,<-0.1402,-0.2693,-0.9528>,<0.64449,-0.51621,0.56406>,
            
    /*4*/<0.63436,0.67385,-0.37882>

    /* stem 0.2.16*/ 
    /*0*/<-0.28639,-0.70422,0.64966>,
    /*1*/<-0.20835,-0.61221,-0.76275>,<0.91583,0.0047,0.40155>,<-0.70342,0.61749,0.352>,
            
    /*2*/<-0.19242,-0.58738,-0.7861>,<0.88327,-0.06306,0.46461>,<-0.68051,0.66012,0.31803>,
            
    /*3*/<-0.12323,-0.51486,-0.84837>,<0.77818,-0.20867,0.59236>,<-0.639,0.72598,0.25423>,
            
    /*4*/<0.64198,0.65345,-0.40107>

    /* stem 0.2.17*/ 
    /*0*/<-0.816,0.26397,0.51425>,
    /*1*/<0.54045,0.02036,0.84113>,<-0.08323,0.8237,-0.56088>,<-0.44968,-0.8465,-0.28501>,
            
    /*2*/<0.49003,0.00441,0.8717>,<-0.31892,0.81539,-0.48315>,<-0.16558,-0.85749,-0.48713>,
            
    /*3*/<0.43021,0.02364,0.90242>,<-0.64562,0.71388,-0.2712>,<0.20884,-0.73072,-0.64995>,
            
    /*4*/<0.65504,0.67002,-0.34928>

    /* stem 0.2.18*/ 
    /*0*/<-0.67682,-0.73573,-0.02471>,
    /*1*/<-0.61369,0.58395,-0.5314>,<0.65909,-0.58906,-0.46756>,<-0.04308,0.00763,0.99904>,
            
    /*2*/<-0.63663,0.56097,-0.52916>,<0.63111,-0.62108,-0.46471>,<0.0088,0.06288,0.99798>,
            
    /*3*/<-0.6378,0.56037,-0.5284>,<0.56782,-0.68046,-0.4632>,<0.07277,0.12166,0.9899>,
            
    /*4*/<0.7426,0.65366,-0.14587>

    /* stem 0.3*/ 
    /*0*/<0.33166,0.24424,-0.91123>,
    /*1*/<-0.94317,-0.0026,-0.33231>,<-0.37333,0.9196,0.12227>,<0.70756,0.56735,0.42127>,
            <0.80575,-0.57255,0.15148>,<-0.21445,-0.9248,-0.31425>,
    /*2*/<-0.93653,0.00178,-0.35058>,<-0.35506,0.93197,0.0732>,<0.71216,0.57039,0.40926>,
            <0.78996,-0.58199,0.19301>,<-0.22887,-0.93335,-0.27653>,
    /*3*/<-0.93448,0.00232,-0.356>,<-0.31668,0.948,-0.03171>,<0.73416,0.58163,0.35032>,
            <0.76431,-0.58957,0.26123>,<-0.26668,-0.94772,-0.17525>,
    /*4*/<-0.94144,0.00493,-0.33713>,<-0.27709,0.95211,-0.12924>,<0.76555,0.58342,0.27122>,
            <0.74466,-0.59092,0.31032>,<-0.31005,-0.94844,-0.06577>,
    /*5*/<-0.93644,0.00414,-0.35081>,<-0.2267,0.93788,-0.26267>,<0.79174,0.57619,0.20286>,
            <0.71058,-0.57823,0.40091>,<-0.35767,-0.932,0.05869>,
    /*6*/<-0.36523,0.27475,0.88945>

    /* stem 0.3.0*/ 
    /*0*/<0.70172,-0.33781,-0.62728>,
    /*1*/<0.65944,0.62651,0.41548>,<-0.12095,-0.91915,0.37487>,<-0.55853,0.30229,-0.77244>,
            
    /*2*/<0.76187,0.56603,0.3149>,<-0.165,-0.88508,0.43521>,<-0.59674,0.33712,-0.72818>,
            
    /*3*/<0.90414,0.4272,-0.00495>,<-0.1779,-0.8355,0.5199>,<-0.72103,0.46016,-0.51805>,
            
    /*4*/<-0.00577,0.53098,0.84736>

    /* stem 0.3.1*/ 
    /*0*/<-0.41476,0.29264,-0.86159>,
    /*1*/<-0.07698,-0.95771,-0.27724>,<-0.74049,0.43256,0.51437>,<0.82925,0.51684,-0.21266>,
            
    /*2*/<-0.03149,-0.99572,-0.08692>,<-0.83099,0.45616,0.31839>,<0.83163,0.51834,-0.1993>,
            
    /*3*/<-0.01179,-0.97342,0.22871>,<-0.86924,0.49175,-0.051>,<0.86145,0.48394,-0.15398>,
            
    /*4*/<-0.05183,0.34008,0.93897>

    /* stem 0.3.2*/ 
    /*0*/<0.80944,0.53088,-0.25093>,
    /*1*/<-0.54979,0.83476,0.03011>,<0.4587,-0.32652,0.82643>,<0.06821,-0.52325,-0.84945>,
            
    /*2*/<-0.33957,0.93532,-0.09935>,<0.46718,-0.32369,0.82278>,<-0.19016,-0.60301,-0.77474>,
            
    /*3*/<-0.11729,0.96542,-0.23281>,<0.55182,-0.26543,0.7906>,<-0.45583,-0.70585,-0.54222>,
            
    /*4*/<-0.74587,0.08926,0.66008>

    /* stem 0.3.3*/ 
    /*0*/<0.04875,-0.49946,-0.86496>,
    /*1*/<0.9111,-0.32696,0.251>,<-0.80972,-0.52257,0.26696>,<-0.10274,0.86359,-0.49362>,
            
    /*2*/<0.90086,-0.30476,0.30914>,<-0.79709,-0.58553,0.14768>,<-0.11818,0.89328,-0.43369>,
            
    /*3*/<0.856,-0.28386,0.43208>,<-0.76107,-0.64582,-0.06069>,<-0.1057,0.93219,-0.34619>,
            
    /*4*/<-0.41794,0.26369,0.86937>

    /* stem 0.3.4*/ 
    /*0*/<0.00577,0.7642,-0.64496>,
    /*1*/<-0.85229,-0.34073,-0.39687>,<-0.0269,0.63769,0.76982>,<0.87903,-0.31837,-0.35489>,
            
    /*2*/<-0.87819,-0.41191,-0.24315>,<-0.03618,0.86889,0.49367>,<0.89918,-0.36792,-0.23686>,
            
    /*3*/<-0.86846,-0.49575,0.00161>,<-0.00411,0.99971,-0.02353>,<0.88443,-0.46578,0.02889>,
            
    /*4*/<-0.05319,0.24623,0.96775>

    /* stem 0.3.5*/ 
    /*0*/<0.81587,-0.2049,-0.54072>,
    /*1*/<0.41119,0.85606,0.31318>,<0.12836,-0.83901,0.52875>,<-0.56224,-0.01135,-0.8269>,
            
    /*2*/<0.54964,0.81577,0.18006>,<0.12495,-0.83552,0.53507>,<-0.69489,0.0589,-0.7167>,
            
    /*3*/<0.73853,0.64749,-0.18795>,<0.16222,-0.7516,0.63936>,<-0.87421,0.14097,-0.46463>,
            
    /*4*/<-0.10455,0.69906,0.70738>

    /* stem 0.3.6*/ 
    /*0*/<-0.34627,-0.00819,-0.9381>,
    /*1*/<0.21386,-0.97498,-0.06061>,<-0.89381,0.29569,0.33716>,<0.68952,0.67952,-0.25063>,
            
    /*2*/<0.23676,-0.96417,0.11966>,<-0.95563,0.26043,0.13763>,<0.69065,0.68629,-0.22807>,
            
    /*3*/<0.20556,-0.84489,0.49387>,<-0.95723,0.22554,-0.18121>,<0.74984,0.60799,-0.26092>,
            
    /*4*/<-0.12829,0.64058,0.7571>

    /* stem 0.3.7*/ 
    /*0*/<0.66068,0.64396,-0.38577>,
    /*1*/<-0.74755,0.63383,-0.19855>,<0.46575,0.03761,0.88412>,<0.2637,-0.68909,-0.675>,
            
    /*2*/<-0.70722,0.65839,-0.25761>,<0.65361,0.10804,0.74908>,<0.04522,-0.88891,-0.45585>,
            
    /*3*/<-0.64265,0.64797,-0.40882>,<0.90666,0.21001,0.36588>,<-0.28157,-0.94617,0.15962>,
            
    /*4*/<-0.17042,0.5266,0.83286>

    /* stem 0.3.8*/ 
    /*0*/<0.22433,-0.7636,-0.60547>,
    /*1*/<0.93366,0.00217,0.35816>,<-0.70559,-0.54984,0.44701>,<-0.23417,0.56845,-0.78869>,
            
    /*2*/<0.94524,-0.02533,0.3254>,<-0.69113,-0.619,0.37306>,<-0.2722,0.67331,-0.68743>,
            
    /*3*/<0.92072,0.01048,0.39008>,<-0.60697,-0.76587,0.2122>,<-0.31783,0.75613,-0.57206>,
            
    /*4*/<-0.46074,0.40954,0.7874>

    /* stem 0.3.9*/ 
    /*0*/<-0.28657,0.63489,-0.71749>,
    /*1*/<-0.71404,-0.64477,-0.27281>,<-0.18975,0.68979,0.6987>,<0.91152,-0.06216,-0.40653>,
            
    /*2*/<-0.71031,-0.6875,-0.15098>,<-0.26697,0.86638,0.42204>,<0.95981,-0.10231,-0.26134>,
            
    /*3*/<-0.68997,-0.72,0.07449>,<-0.28865,0.95736,0.01214>,<0.97177,-0.22682,-0.06498>,
            
    /*4*/<0.06529,0.14995,0.98654>

    /* stem 0.3.10*/ 
    /*0*/<0.94051,-0.13113,-0.31345>,
    /*1*/<0.15384,0.98501,0.07798>,<0.16903,-0.59603,0.78497>,<-0.34803,-0.38548,-0.85456>,
            
    /*2*/<0.21522,0.97501,0.0551>,<0.15717,-0.59274,0.78991>,<-0.39682,-0.37429,-0.83812>,
            
    /*3*/<0.36564,0.93071,-0.00945>,<0.15692,-0.60148,0.78332>,<-0.55009,-0.31492,-0.77345>,
            
    /*4*/<-0.75112,0.42103,0.50848>

    /* stem 0.3.11*/ 
    /*0*/<-0.42832,-0.38535,-0.81734>,
    /*1*/<0.47186,-0.86487,0.1713>,<-0.8996,0.16709,0.40348>,<0.43911,0.708,-0.55309>,
            
    /*2*/<0.49595,-0.83189,0.24899>,<-0.9495,0.10994,0.29386>,<0.44923,0.72837,-0.51736>,
            
    /*3*/<0.50114,-0.80064,0.32838>,<-0.99,0.0591,0.12806>,<0.49161,0.7549,-0.4341>,
            
    /*4*/<0.08769,0.41154,0.90716>

    /* stem 0.3.12*/ 
    /*0*/<0.49087,0.6459,-0.58468>,
    /*1*/<-0.87519,0.3407,-0.34347>,<0.41156,0.41036,0.81377>,<0.45078,-0.76797,-0.455>,
            
    /*2*/<-0.74383,0.42866,-0.5128>,<0.444,0.42379,0.78947>,<0.25332,-0.92019,-0.29848>,
            
    /*3*/<-0.56724,0.52834,-0.63174>,<0.58336,0.46066,0.66894>,<-0.02305,-0.99969,-0.00913>,
            
    /*4*/<-0.68322,0.13896,0.71687>

    /* stem 0.3.13*/ 
    /*0*/<0.44537,-0.66758,-0.59664>,
    /*1*/<0.89144,0.34081,0.29863>,<-0.44806,-0.73752,0.50527>,<-0.45496,0.41407,-0.78839>,
            
    /*2*/<0.84948,0.403,0.34055>,<-0.46097,-0.72258,0.51516>,<-0.3996,0.34279,-0.85018>,
            
    /*3*/<0.91133,0.28141,0.30048>,<-0.51654,-0.67478,0.52713>,<-0.36843,0.42506,-0.82679>,
            
    /*4*/<-0.20198,0.73222,0.65042>

    /* stem 0.3.14*/ 
    /*0*/<-0.38709,0.32684,-0.86217>,
    /*1*/<-0.49753,-0.86236,-0.0938>,<-0.4168,0.7671,0.48768>,<0.92408,0.08702,-0.37215>,
            
    /*2*/<-0.49553,-0.86453,-0.08389>,<-0.44972,0.80236,0.3924>,<0.95639,0.06498,-0.28478>,
            
    /*3*/<-0.49598,-0.86812,0.01925>,<-0.51263,0.85485,0.08026>,<0.99526,0.04317,-0.08719>,
            
    /*4*/<-0.02561,0.13824,0.99007>

    /* stem 0.3.15*/ 
    /*0*/<0.82621,0.0283,-0.56265>,
    /*1*/<-0.13404,0.98179,-0.13459>,<0.53316,-0.32958,0.77917>,<-0.41704,-0.65282,-0.63238>,
            
    /*2*/<0.04597,0.96593,-0.2547>,<0.45944,-0.30433,0.83445>,<-0.51051,-0.62898,-0.58631>,
            
    /*3*/<0.18827,0.9164,-0.35324>,<0.43433,-0.30817,0.8464>,<-0.63715,-0.60357,-0.47931>,
            
    /*4*/<-0.7187,0.35897,0.59549>

    /* stem 0.3.16*/ 
    /*0*/<-0.18183,-0.70072,-0.68988>,
    /*1*/<0.64563,-0.61049,0.45877>,<-0.96428,-0.00182,0.26487>,<0.32199,0.62516,-0.71098>,
            
    /*2*/<0.63011,-0.53786,0.56006>,<-0.97915,-0.18859,0.07547>,<0.30223,0.70992,-0.63613>,
            
    /*3*/<0.62591,-0.5147,0.58594>,<-0.92304,-0.33214,-0.19414>,<0.29966,0.87577,-0.37845>,
            
    /*4*/<-0.3758,0.32547,0.86766>

    /* stem 0.3.17*/ 
    /*0*/<0.31498,0.54662,-0.77589>,
    /*1*/<-0.92696,-0.00679,-0.37511>,<0.27915,0.72477,0.62991>,<0.64342,-0.72559,-0.244>,
            
    /*2*/<-0.98306,-0.07226,-0.16842>,<0.31357,0.86434,0.39319>,<0.64424,-0.73583,-0.20857>,
            
    /*3*/<-0.97712,-0.1867,0.10187>,<0.32857,0.94358,0.04128>,<0.64961,-0.74881,-0.13149>,
            
    /*4*/<0.1676,0.01618,0.98572>

    /* stem 0.3.18*/ 
    /*0*/<0.62781,-0.72343,-0.28723>,
    /*1*/<0.77138,0.62365,0.1266>,<-0.31293,-0.56901,0.76046>,<-0.46457,-0.04759,-0.88426>,
            
    /*2*/<0.86656,0.49531,0.06108>,<-0.32585,-0.54257,0.77424>,<-0.5283,0.06565,-0.84652>,
            
    /*3*/<0.93947,0.33644,-0.06479>,<-0.28505,-0.60647,0.74226>,<-0.67872,0.28231,-0.67797>,
            
    /*4*/<-0.1527,0.71229,0.68507>

    /* stem 0.3.19*/ 
    /*0*/<-0.30447,-0.10269,-0.94697>,
    /*1*/<-0.25925,-0.94757,0.18682>,<-0.66378,0.73576,0.13434>,<0.92365,0.21202,-0.31926>,
            
    /*2*/<-0.25013,-0.92443,0.28785>,<-0.71314,0.69909,-0.05195>,<0.9395,0.24005,-0.24438>,
            
    /*3*/<-0.25802,-0.84217,0.47346>,<-0.71805,0.5913,-0.3671>,<0.96053,0.25475,-0.11171>,
            
    /*4*/<-0.1143,0.59704,0.79403>

    /* stem 0.4*/ 
    /*0*/<0.33337,0.22347,0.91593>,
    /*1*/<0.93607,-0.00239,-0.35181>,<0.21411,0.92456,-0.3152>,<-0.80868,0.57049,0.14345>,
            <-0.71883,-0.57528,0.3903>,<0.35948,-0.92934,0.08422>,
    /*2*/<0.90516,-0.01545,-0.4248>,<0.23556,0.93493,-0.26538>,<-0.76658,0.59195,0.24892>,
            <-0.71319,-0.5725,0.40448>,<0.31895,-0.94771,-0.01072>,
    /*3*/<0.87314,-0.01157,-0.48734>,<0.2899,0.94726,-0.13661>,<-0.70157,0.59589,0.39078>,
            <-0.72992,-0.5779,0.36503>,<0.24363,-0.95356,-0.17711>,
    /*4*/<0.89192,-0.01686,-0.45188>,<0.36567,0.93073,0.00529>,<-0.67291,0.59331,0.44178>,
            <-0.78763,-0.56079,0.25526>,<0.1796,-0.93785,-0.29696>,
    /*5*/<0.92421,-0.04367,-0.37938>,<0.4517,0.87129,0.19188>,<-0.65155,0.58451,0.48357>,
            <-0.8589,-0.50316,0.0955>,<0.11589,-0.89144,-0.43807>,
    /*6*/<-0.25276,0.4822,-0.83881>

    /* stem 0.4.0*/ 
    /*0*/<-0.14023,-0.35917,0.92267>,
    /*1*/<-0.7676,0.62994,0.11818>,<-0.15431,-0.90882,-0.38761>,<0.92593,0.28919,0.24293>,
            
    /*2*/<-0.78878,0.54158,0.29072>,<-0.16373,-0.8503,-0.50018>,<0.92549,0.32401,0.19619>,
            
    /*3*/<-0.74763,0.50234,0.4344>,<-0.19757,-0.82269,-0.53306>,<0.94061,0.33129,0.07422>,
            
    /*4*/<-0.1316,0.48316,-0.86559>

    /* stem 0.4.1*/ 
    /*0*/<0.83463,0.28016,0.47424>,
    /*1*/<0.23048,-0.96253,0.14289>,<0.30281,0.46864,-0.82987>,<-0.55716,0.48588,0.67342>,
            
    /*2*/<0.11827,-0.99214,0.04082>,<0.47338,0.4994,-0.72561>,<-0.58691,0.4861,0.64749>,
            
    /*3*/<-0.12553,-0.96162,-0.24398>,<0.70824,0.51542,-0.48243>,<-0.60038,0.42365,0.67828>,
            
    /*4*/<-0.57081,0.45539,-0.68323>

    /* stem 0.4.2*/ 
    /*0*/<-0.45336,0.51955,0.72425>,
    /*1*/<0.40794,0.83915,-0.35973>,<-0.88571,-0.31234,-0.34346>,<0.49068,-0.5416,0.68257>,
            
    /*2*/<0.35896,0.90694,-0.22045>,<-0.90223,-0.30147,-0.30839>,<0.59035,-0.62196,0.51444>,
            
    /*3*/<0.29461,0.95471,0.04162>,<-0.94383,-0.2515,-0.21434>,<0.68116,-0.71822,0.14205>,
            
    /*4*/<0.09963,0.14426,-0.98451>

    /* stem 0.4.3*/ 
    /*0*/<0.51542,-0.53953,0.66577>,
    /*1*/<-0.86171,-0.32826,0.38691>,<0.43203,-0.49777,-0.75205>,<0.41507,0.84132,0.34627>,
            
    /*2*/<-0.8884,-0.29803,0.34918>,<0.44622,-0.51518,-0.73177>,<0.42666,0.82808,0.36366>,
            
    /*3*/<-0.88152,-0.31182,0.35451>,<0.4889,-0.53641,-0.68792>,<0.37887,0.86972,0.3163>,
            
    /*4*/<-0.53145,0.39842,-0.74754>

    /* stem 0.4.4*/ 
    /*0*/<0.54475,0.6979,0.46496>,
    /*1*/<0.82115,-0.35861,-0.44397>,<-0.54218,0.70958,-0.45004>,<-0.29431,-0.37061,0.88093>,
            
    /*2*/<0.64491,-0.50644,-0.57237>,<-0.39954,0.82637,-0.39684>,<-0.25139,-0.34747,0.90336>,
            
    /*3*/<0.38086,-0.62056,-0.68545>,<0.03665,0.98837,-0.14757>,<-0.41697,-0.28936,0.86163>,
            
    /*4*/<-0.80043,0.24695,-0.54619>

    /* stem 0.4.5*/ 
    /*0*/<-0.30519,-0.35842,0.88226>,
    /*1*/<-0.44831,0.87361,0.18927>,<-0.49782,-0.72431,-0.47702>,<0.95466,-0.13928,0.26309>,
            
    /*2*/<-0.4932,0.81523,0.30357>,<-0.47591,-0.67391,-0.56512>,<0.96292,-0.12246,0.2404>,
            
    /*3*/<-0.52062,0.70975,0.47457>,<-0.45791,-0.63012,-0.62711>,<0.98918,-0.05953,0.13407>,
            
    /*4*/<0.05608,0.65419,-0.75424>

    /* stem 0.4.6*/ 
    /*0*/<0.9177,-0.07174,0.39075>,
    /*1*/<-0.14356,-0.98061,0.13342>,<0.38258,0.33669,-0.86039>,<-0.26452,0.64591,0.71612>,
            
    /*2*/<-0.22395,-0.97406,0.03235>,<0.68182,0.30254,-0.66602>,<-0.37883,0.70236,0.60264>,
            
    /*3*/<-0.31587,-0.93343,-0.1701>,<0.85653,0.32177,-0.40352>,<-0.55794,0.61661,0.55542>,
            
    /*4*/<-0.49696,0.38579,-0.7773>

    /* stem 0.4.7*/ 
    /*0*/<-0.03883,0.56898,0.82143>,
    /*1*/<0.65843,0.6279,-0.41498>,<-0.97984,0.13266,-0.14937>,<0.32248,-0.77622,0.54174>,
            
    /*2*/<0.67686,0.66879,-0.30753>,<-0.98545,0.16461,-0.04239>,<0.32224,-0.89081,0.32034>,
            
    /*3*/<0.69464,0.7007,-0.16278>,<-0.93041,0.20663,0.30272>,<0.18544,-0.96714,-0.17395>,
            
    /*4*/<-0.45811,0.32502,-0.82734>

    /* stem 0.4.8*/ 
    /*0*/<0.22234,-0.86853,0.44297>,
    /*1*/<-0.88493,0.02125,0.46523>,<0.08134,-0.42779,-0.90021>,<0.79751,0.43032,0.42285>,
            
    /*2*/<-0.89302,0.04665,0.44759>,<0.10093,-0.49885,-0.86079>,<0.78798,0.47194,0.39542>,
            
    /*3*/<-0.89507,0.04233,0.44392>,<0.13449,-0.5782,-0.80474>,<0.75448,0.55793,0.34565>,
            
    /*4*/<-0.31542,0.7266,-0.61038>

    /* stem 0.4.9*/ 
    /*0*/<0.76462,0.4449,0.46628>,
    /*1*/<0.62717,-0.65265,-0.4251>,<-0.22419,0.85505,-0.46759>,<-0.4237,-0.21445,0.88005>,
            
    /*2*/<0.66312,-0.64099,-0.38653>,<-0.11672,0.93142,-0.34473>,<-0.61155,-0.29305,0.73494>,
            
    /*3*/<0.67981,-0.58285,-0.44513>,<0.12091,0.99243,-0.02175>,<-0.80517,-0.37248,0.46148>,
            
    /*4*/<-0.46295,0.25834,-0.8479>

    /* stem 0.4.10*/ 
    /*0*/<-0.3345,-0.1953,0.92194>,
    /*1*/<-0.08556,0.98218,0.16731>,<-0.76522,-0.50832,-0.39503>,<0.85977,-0.46862,0.20297>,
            
    /*2*/<-0.13332,0.89267,0.43053>,<-0.76293,-0.48444,-0.42808>,<0.93254,-0.36039,0.0221>,
            
    /*3*/<-0.10135,0.69722,0.70965>,<-0.76272,-0.54563,-0.34721>,<0.89434,-0.13473,-0.42663>,
            
    /*4*/<-0.43974,0.681,-0.58555>

    /* stem 0.4.11*/ 
    /*0*/<0.85275,-0.4511,0.26331>,
    /*1*/<-0.50598,-0.84948,0.14957>,<0.37689,0.20492,-0.90331>,<0.10634,0.65659,0.74671>,
            
    /*2*/<-0.52983,-0.83803,0.13031>,<0.54891,0.13011,-0.8257>,<-0.01341,0.73926,0.67328>,
            
    /*3*/<-0.69152,-0.71316,-0.11493>,<0.79745,-0.0531,-0.60105>,<-0.14806,0.74106,0.65491>,
            
    /*4*/<-0.22854,0.67623,-0.70034>

    /* stem 0.4.12*/ 
    /*0*/<0.18702,0.38589,0.90339>,
    /*1*/<0.89731,0.30008,-0.3237>,<-0.79407,0.59931,-0.10137>,<-0.10818,-0.90959,0.40118>,
            
    /*2*/<0.89729,0.30193,-0.32203>,<-0.75003,0.62183,0.22535>,<-0.25311,-0.96152,0.10688>,
            
    /*3*/<0.91411,0.26635,-0.30573>,<-0.52211,0.51689,0.6784>,<-0.46562,-0.79298,-0.39293>,
            
    /*4*/<-0.35046,0.77631,-0.52395>

    /* stem 0.4.13*/ 
    /*0*/<-0.12384,-0.87947,0.45955>,
    /*1*/<-0.80791,0.36531,0.46242>,<-0.09201,-0.44309,-0.89174>,<0.90316,0.1008,0.4173>,
            
    /*2*/<-0.8091,0.35012,0.47198>,<-0.09459,-0.50072,-0.86042>,<0.91121,0.17254,0.37406>,
            
    /*3*/<-0.80789,0.40336,0.42967>,<-0.10996,-0.60874,-0.78571>,<0.91287,0.22659,0.3396>,
            
    /*4*/<0.10059,0.7308,-0.67514>

    /* stem 0.4.14*/ 
    /*0*/<0.83688,0.08106,0.54135>,
    /*1*/<0.33325,-0.85211,-0.40355>,<0.19369,0.87372,-0.44621>,<-0.54864,-0.02371,0.83572>,
            
    /*2*/<0.33624,-0.8517,-0.40194>,<0.36724,0.89494,-0.25343>,<-0.74648,0.01542,0.66523>,
            
    /*3*/<0.38148,-0.83357,-0.39954>,<0.54292,0.83857,0.04516>,<-0.94112,0.01153,0.33787>,
            
    /*4*/<-0.20429,0.32043,-0.92498>

    /* stem 0.4.15*/ 
    /*0*/<-0.42516,-0.00927,0.90507>,
    /*1*/<0.29055,0.94688,0.13786>,<-0.88375,-0.19484,-0.42547>,<0.60282,-0.75183,0.26714>,
            
    /*2*/<0.28839,0.94613,0.14719>,<-0.94254,-0.22813,-0.24407>,<0.6524,-0.75482,0.06797>,
            
    /*3*/<0.29638,0.87939,0.3726>,<-0.97635,-0.14354,-0.16169>,<0.68414,-0.70057,-0.20286>,
            
    /*4*/<0.18075,0.53372,-0.82612>

    /* stem 0.4.16*/ 
    /*0*/<0.49347,-0.85519,0.15853>,
    /*1*/<-0.86634,-0.49854,-0.0303>,<0.51964,0.15093,-0.84095>,<0.33786,0.36292,0.86841>,
            
    /*2*/<-0.84029,-0.54196,-0.01417>,<0.55557,0.1021,-0.82518>,<0.27788,0.46135,0.84258>,
            
    /*3*/<-0.81709,-0.57645,0.00812>,<0.60805,-0.00409,-0.79389>,<0.20215,0.59492,0.77795>,
            
    /*4*/<-0.51006,0.71813,-0.47342>

    /* stem 0.4.17*/ 
    /*0*/<0.33419,0.29357,0.89562>,
    /*1*/<0.94044,-0.07636,-0.33128>,<-0.49764,0.86136,-0.10205>,<-0.44764,-0.78926,0.42035>,
            
    /*2*/<0.90517,-0.07574,-0.41826>,<-0.41501,0.90434,0.09969>,<-0.50685,-0.79856,0.32466>,
            
    /*3*/<0.86015,-0.09904,-0.50034>,<-0.24578,0.85956,0.44805>,<-0.65342,-0.75486,0.05683>,
            
    /*4*/<-0.37702,0.5097,-0.77335>

    /* stem 0.4.18*/ 
    /*0*/<-0.24239,-0.75242,0.61247>,
    /*1*/<-0.57929,0.6204,0.5287>,<-0.383,-0.50358,-0.77442>,<0.96416,-0.11102,0.24099>,
            
    /*2*/<-0.61744,0.49908,0.60802>,<-0.36923,-0.40746,-0.83525>,<0.97023,-0.08277,0.2276>,
            
    /*3*/<-0.59866,0.25342,0.75986>,<-0.35977,-0.35783,-0.8617>,<0.9852,0.13043,0.11125>,
            
    /*4*/<-0.27864,0.90055,-0.33373>

    /* stem 0.4.19*/ 
    /*0*/<0.91566,-0.23689,0.32473>,
    /*1*/<-0.0547,-0.87231,-0.48588>,<0.37067,0.8065,-0.46061>,<-0.31932,0.06668,0.9453>,
            
    /*2*/<-0.24893,-0.76632,-0.59227>,<0.58999,0.69523,-0.41057>,<-0.3219,0.06925,0.94424>,
            
    /*3*/<-0.4463,-0.55938,-0.6985>,<0.86099,0.46047,-0.21601>,<-0.39671,0.10574,0.91183>,
            
    /*4*/<-0.36665,0.86288,-0.34787>

    /* stem 0.5*/ 
    /*0*/<-0.84905,0.19703,-0.4902>,
    /*1*/<-0.4908,-0.00213,0.87127>,<0.01694,0.93023,0.36658>,<0.51394,0.5741,-0.63739>,
            <0.31336,-0.57836,-0.7532>,<-0.3076,-0.93449,0.17921>,
    /*2*/<-0.41945,-0.01317,0.90768>,<-0.03079,0.93899,0.34256>,<0.41354,0.59253,-0.6913>,
            <0.299,-0.57585,-0.76092>,<-0.21578,-0.94999,0.22572>,
    /*3*/<-0.33075,-0.00738,0.94369>,<-0.10547,0.94867,0.29818>,<0.27898,0.59349,-0.75495>,
            <0.29192,-0.58186,-0.75909>,<-0.08548,-0.95312,0.29028>,
    /*4*/<-0.2815,-0.00276,0.95956>,<-0.11835,0.9496,0.29026>,<0.22252,0.59054,-0.77572>,
            <0.27007,-0.58439,-0.76521>,<-0.04154,-0.95067,0.30742>,
    /*5*/<-0.24175,0.00454,0.97033>,<-0.1849,0.94544,0.26826>,<0.14236,0.5802,-0.80194>,
            <0.28664,-0.58437,-0.75918>,<0.04947,-0.94054,0.33605>,
    /*6*/<0.94541,0.21967,0.24073>

    /* stem 0.5.0*/ 
    /*0*/<-0.40828,-0.44158,-0.79895>,
    /*1*/<0.49663,0.63443,-0.59234>,<0.42309,-0.86387,0.27335>,<-0.90788,0.24225,0.34216>,
            
    /*2*/<0.46988,0.61032,-0.63774>,<0.41986,-0.86724,0.2676>,<-0.87855,0.27309,0.39189>,
            
    /*3*/<0.3829,0.55973,-0.7349>,<0.40118,-0.88691,0.22902>,<-0.77346,0.34835,0.52954>,
            
    /*4*/<0.71565,0.41298,0.56328>

    /* stem 0.5.1*/ 
    /*0*/<-0.89549,0.25649,0.36374>,
    /*1*/<-0.24623,-0.96793,0.04986>,<0.45202,0.44137,0.77516>,<-0.17993,0.51916,-0.83552>,
            
    /*2*/<-0.12624,-0.99069,0.05094>,<0.18032,0.49936,0.84742>,<-0.04821,0.52161,-0.85182>,
            
    /*3*/<0.13044,-0.98159,0.13955>,<-0.32289,0.54397,0.77449>,<0.18119,0.45436,-0.8722>,
            
    /*4*/<0.84107,0.31314,0.44108>

    /* stem 0.5.2*/ 
    /*0*/<-0.08066,0.51227,-0.85503>,
    /*1*/<-0.10145,0.84411,0.52648>,<0.9105,-0.3175,-0.26494>,<-0.80673,-0.5413,-0.23702>,
            
    /*2*/<-0.13388,0.88844,0.43903>,<0.89172,-0.29069,-0.34689>,<-0.77378,-0.63081,-0.05776>,
            
    /*3*/<-0.19199,0.93098,0.31049>,<0.88554,-0.2173,-0.41061>,<-0.68397,-0.71865,0.12539>,
            
    /*4*/<0.37587,-0.17137,0.91069>

    /* stem 0.5.3*/ 
    /*0*/<-0.80287,-0.57345,-0.16293>,
    /*1*/<0.41912,-0.32984,-0.8459>,<0.17547,-0.47419,0.86276>,<-0.57164,0.82042,-0.0122>,
            
    /*2*/<0.48722,-0.286,-0.82512>,<0.10746,-0.52711,0.84297>,<-0.5683,0.82276,-0.01014>,
            
    /*3*/<0.71305,-0.13544,-0.6879>,<-0.03906,-0.62011,0.78354>,<-0.62213,0.77663,-0.09899>,
            
    /*4*/<0.46363,0.60635,0.64605>

    /* stem 0.5.4*/ 
    /*0*/<-0.71277,0.7014,0.00097>,
    /*1*/<-0.33507,-0.35521,0.87267>,<0.70805,0.70604,-0.01355>,<-0.35272,-0.37075,-0.85915>,
            
    /*2*/<-0.34975,-0.34968,0.86913>,<0.4578,0.88155,-0.11531>,<-0.03595,-0.52373,-0.85113>,
            
    /*3*/<-0.31409,-0.2925,0.90321>,<-0.01588,0.97052,-0.2405>,<0.34636,-0.65152,-0.67495>,
            
    /*4*/<0.88822,0.30415,0.34434>

    /* stem 0.5.5*/ 
    /*0*/<-0.55557,-0.2802,-0.78283>,
    /*1*/<0.2045,0.87179,-0.44515>,<0.60465,-0.78476,-0.13621>,<-0.79346,-0.07913,0.60345>,
            
    /*2*/<0.05486,0.80288,-0.59361>,<0.62585,-0.7703,-0.12229>,<-0.68855,0.01144,0.7251>,
            
    /*3*/<-0.04237,0.76442,-0.64333>,<0.55658,-0.79871,-0.22865>,<-0.48664,0.03527,0.87289>,
            
    /*4*/<0.85748,0.29002,0.425>

    /* stem 0.5.6*/ 
    /*0*/<-0.94914,-0.09031,0.30163>,
    /*1*/<0.04538,-0.98221,-0.1822>,<0.26141,0.35446,0.89779>,<-0.28023,0.63028,-0.72403>,
            
    /*2*/<0.17321,-0.96741,-0.18469>,<0.04429,0.31734,0.94728>,<-0.20279,0.65489,-0.72801>,
            
    /*3*/<0.37663,-0.9127,-0.15854>,<-0.14138,0.33856,0.93026>,<-0.21343,0.58549,-0.78208>,
            
    /*4*/<0.88731,0.45698,-0.062>

    /* stem 0.5.7*/ 
    /*0*/<-0.53279,0.53512,-0.65558>,
    /*1*/<-0.25029,0.63201,0.73343>,<0.83127,0.15707,-0.53322>,<-0.56616,-0.80396,-0.18198>,
            
    /*2*/<-0.45724,0.71896,0.52348>,<0.83496,0.15899,-0.52684>,<-0.44122,-0.89476,0.06885>,
            
    /*3*/<-0.65089,0.7301,0.20806>,<0.79772,0.1602,-0.58136>,<-0.13452,-0.90212,0.40998>,
            
    /*4*/<0.54884,0.42553,0.71951>

    /* stem 0.5.8*/ 
    /*0*/<-0.58372,-0.78544,-0.20582>,
    /*1*/<0.33209,0.01207,-0.94317>,<0.48572,-0.53116,0.69422>,<-0.80169,0.54079,0.25463>,
            
    /*2*/<0.3264,0.0052,-0.94522>,<0.44868,-0.57533,0.68387>,<-0.75951,0.59146,0.27076>,
            
    /*3*/<0.31743,-0.0019,-0.94828>,<0.38379,-0.64765,0.65822>,<-0.68212,0.6677,0.29812>,
            
    /*4*/<0.75455,0.61121,0.23893>

    /* stem 0.5.9*/ 
    /*0*/<-0.902,0.42021,0.09905>,
    /*1*/<-0.21231,-0.64958,0.73005>,<0.43992,0.8711,0.21831>,<-0.20287,-0.23304,-0.95107>,
            
    /*2*/<-0.12068,-0.66071,0.74088>,<0.19096,0.95533,0.22557>,<-0.05876,-0.24786,-0.96701>,
            
    /*3*/<0.16605,-0.62183,0.76534>,<-0.22829,0.94948,0.21535>,<0.08617,-0.31258,-0.94598>,
            
    /*4*/<0.89963,0.43002,-0.07587>

    /* stem 0.5.10*/ 
    /*0*/<-0.34397,-0.16038,-0.92518>,
    /*1*/<0.01431,0.98595,-0.16643>,<0.81061,-0.55184,-0.19591>,<-0.81557,-0.42975,0.38751>,
            
    /*2*/<-0.11936,0.92668,-0.35639>,<0.80267,-0.55878,-0.20851>,<-0.72111,-0.32768,0.61042>,
            
    /*3*/<-0.37335,0.73013,-0.5723>,<0.8021,-0.52329,-0.28776>,<-0.43504,-0.17641,0.88296>,
            
    /*4*/<0.6077,0.74726,0.26888>

    /* stem 0.5.11*/ 
    /*0*/<-0.86762,-0.37801,0.32301>,
    /*1*/<0.21122,-0.85919,-0.46602>,<0.29902,0.14363,0.94338>,<-0.48679,0.72578,-0.48608>,
            
    /*2*/<0.20608,-0.86145,-0.46416>,<0.28769,0.13889,0.9476>,<-0.4702,0.73276,-0.4919>,
            
    /*3*/<0.26374,-0.81656,-0.51349>,<0.29639,0.11966,0.94754>,<-0.54182,0.70951,-0.45059>,
            
    /*4*/<0.77513,0.54638,-0.31725>

    /* stem 0.5.12*/ 
    /*0*/<-0.65851,0.59117,-0.46571>,
    /*1*/<-0.31694,0.33179,0.88852>,<0.75601,0.46071,-0.46496>,<-0.42141,-0.80836,-0.41106>,
            
    /*2*/<-0.47807,0.3886,0.78768>,<0.70732,0.47955,-0.51935>,<-0.22318,-0.9483,-0.22566>,
            
    /*3*/<-0.69013,0.42862,0.5831>,<0.53256,0.47151,-0.70289>,<0.23999,-0.95632,0.1669>,
            
    /*4*/<0.62287,0.54898,0.55736>

    /* stem 0.5.13*/ 
    /*0*/<-0.6403,-0.65342,-0.40381>,
    /*1*/<0.23549,0.34445,-0.90879>,<0.52551,-0.74981,0.40203>,<-0.74394,0.42277,0.51752>,
            
    /*2*/<0.24647,0.35095,-0.90337>,<0.44683,-0.81844,0.36125>,<-0.67618,0.47646,0.56193>,
            
    /*3*/<0.20938,0.32798,-0.92119>,<0.35996,-0.87829,0.31472>,<-0.54936,0.56587,0.61481>,
            
    /*4*/<0.8582,0.43427,0.27369>

    /* stem 0.5.14*/ 
    /*0*/<-0.79525,0.36741,0.48228>,
    /*1*/<-0.09258,-0.86701,0.48962>,<0.57468,0.7272,0.3754>,<-0.46113,0.13012,-0.87774>,
            
    /*2*/<0.09975,-0.91818,0.3834>,<0.45422,0.7537,0.47499>,<-0.50847,0.13354,-0.85066>,
            
    /*3*/<0.38429,-0.89774,0.21538>,<0.16243,0.75585,0.63428>,<-0.52162,0.15425,-0.83912>,
            
    /*4*/<0.83039,0.38742,-0.40045>

    /* stem 0.5.15*/ 
    /*0*/<-0.62436,0.074,-0.77762>,
    /*1*/<-0.07191,0.9841,0.1624>,<0.71712,-0.35676,-0.59871>,<-0.62916,-0.62924,0.45631>,
            
    /*2*/<-0.15006,0.98391,0.09692>,<0.66947,-0.36573,-0.64657>,<-0.51025,-0.62737,0.58826>,
            
    /*3*/<-0.34686,0.93752,-0.02747>,<0.61397,-0.33968,-0.7125>,<-0.25837,-0.5853,0.76855>,
            
    /*4*/<0.78005,0.45137,0.43334>

    /* stem 0.5.16*/ 
    /*0*/<-0.75052,-0.59053,0.29664>,
    /*1*/<0.22343,-0.64061,-0.73464>,<0.4368,-0.09331,0.8947>,<-0.64376,0.74688,-0.16657>,
            
    /*2*/<0.20563,-0.65433,-0.72771>,<0.44129,-0.09016,0.89282>,<-0.63035,0.75695,-0.17229>,
            
    /*3*/<0.28161,-0.55293,-0.7842>,<0.44174,-0.12275,0.88871>,<-0.71139,0.69042,-0.13129>,
            
    /*4*/<0.59854,0.78609,-0.15431>

    /* stem 0.5.17*/ 
    /*0*/<-0.79107,0.57619,-0.20548>,
    /*1*/<-0.24315,0.00172,0.96999>,<0.61298,0.70177,-0.363>,<-0.35566,-0.71381,-0.60331>,
            
    /*2*/<-0.22625,0.00043,0.97407>,<0.37686,0.80729,-0.45416>,<-0.12471,-0.8025,-0.58348>,
            
    /*3*/<-0.03894,0.04447,0.99825>,<-0.1516,0.85414,-0.49745>,<0.17006,-0.84458,-0.50771>,
            
    /*4*/<0.91562,0.37149,-0.15375>

    /* stem 0.5.18*/ 
    /*0*/<-0.34763,-0.72081,-0.59965>,
    /*1*/<0.05562,0.6267,-0.77727>,<0.78544,-0.57086,0.23916>,<-0.83588,-0.04509,0.54706>,
            
    /*2*/<0.01454,0.58377,-0.81179>,<0.72117,-0.66725,0.18627>,<-0.74085,0.0972,0.6646>,
            
    /*3*/<-0.10028,0.49264,-0.86443>,<0.6722,-0.73573,0.08278>,<-0.56575,0.25664,0.78362>,
            
    /*4*/<0.70527,0.679,0.20385>

    /* stem 0.5.19*/ 
    /*0*/<-0.79035,0.00854,0.6126>,
    /*1*/<0.16791,-0.95987,0.22464>,<0.43084,0.72273,0.54041>,<-0.59095,0.23705,-0.7711>,
            
    /*2*/<0.21913,-0.95532,0.19838>,<0.31175,0.71887,0.62132>,<-0.52287,0.24967,-0.81503>,
            
    /*3*/<0.41887,-0.89658,0.14384>,<-0.00971,0.63817,0.76983>,<-0.40337,0.26594,-0.87554>,
            
    /*4*/<0.83059,0.53446,-0.15645>

    /* stem 0.5.20*/ 
    /*0*/<-0.6197,0.1672,-0.76683>,
    /*1*/<-0.30655,0.84728,0.43376>,<0.77967,0.01248,-0.62607>,<-0.47128,-0.86025,0.19458>,
            
    /*2*/<-0.43819,0.84134,0.31643>,<0.75141,0.00396,-0.65982>,<-0.33228,-0.86231,0.38212>,
            
    /*3*/<-0.59271,0.78739,0.16946>,<0.59998,-0.05567,-0.79808>,<0.0206,-0.76287,0.64622>,
            
    /*4*/<0.75782,0.56993,0.31762>

    /* stem 0.6*/ 
    /*0*/<0.97079,0.16814,-0.17118>,
    /*1*/<-0.18421,-0.00183,-0.98289>,<-0.2217,0.93563,-0.27467>,<0.03258,0.57755,0.8157>,
            <0.22723,-0.58121,0.78138>,<0.09325,-0.93929,-0.33021>,
    /*2*/<-0.23683,-0.00984,-0.9715>,<-0.21236,0.93725,-0.27651>,<0.09135,0.58736,0.80415>,
            <0.25412,-0.57718,0.77607>,<0.05142,-0.94569,-0.32099>,
    /*3*/<-0.25102,-0.00728,-0.96795>,<-0.08043,0.94934,-0.30379>,<0.18656,0.59091,0.78487>,
            <0.18207,-0.58252,0.79216>,<-0.08846,-0.95239,-0.29178>,
    /*4*/<-0.23593,-0.00819,-0.97173>,<0.08634,0.93372,-0.34744>,<0.27481,0.58754,0.7611>,
            <0.06962,-0.56813,0.81999>,<-0.24592,-0.93633,-0.2506>,
    /*5*/<-0.31767,0.01962,-0.948>,<0.17156,0.9146,-0.36616>,<0.41069,0.55035,0.72694>,
            <0.06764,-0.57075,0.81833>,<-0.38193,-0.89859,-0.21602>,
    /*6*/<-0.86352,0.35951,0.35367>

    /* stem 0.6.0*/ 
    /*0*/<0.76827,-0.5078,0.38974>,
    /*1*/<0.0191,0.63855,0.76934>,<-0.57463,-0.81729,0.04289>,<0.53308,0.19357,-0.82362>,
            
    /*2*/<0.09175,0.58953,0.80252>,<-0.60453,-0.79589,0.03324>,<0.49283,0.22627,-0.84019>,
            
    /*3*/<0.31312,0.46533,0.82791>,<-0.61028,-0.79118,0.03981>,<0.28768,0.37241,-0.88235>,
            
    /*4*/<-0.80085,0.56945,0.1854>

    /* stem 0.6.1*/ 
    /*0*/<0.52815,0.23993,-0.81455>,
    /*1*/<0.12779,-0.97307,-0.19186>,<-0.79786,0.48065,-0.36385>,<0.65471,0.48544,0.5794>,
            
    /*2*/<-0.00346,-0.99837,-0.05705>,<-0.68479,0.49374,-0.53598>,<0.64534,0.48753,0.58809>,
            
    /*3*/<-0.23383,-0.96464,0.12161>,<-0.42675,0.51306,-0.74475>,<0.63154,0.45476,0.62797>,
            
    /*4*/<-0.78149,0.3576,0.51128>

    /* stem 0.6.2*/ 
    /*0*/<0.73223,0.46814,0.49466>,
    /*1*/<-0.23729,0.84913,-0.47187>,<-0.44703,-0.23378,0.86343>,<0.6631,-0.62892,-0.40589>,
            
    /*2*/<-0.10694,0.89963,-0.42336>,<-0.39074,-0.22129,0.89351>,<0.48196,-0.70636,-0.51843>,
            
    /*3*/<0.02415,0.92882,-0.36973>,<-0.13386,-0.16759,0.97673>,<0.08269,-0.80046,-0.59365>,
            
    /*4*/<-0.99415,0.0639,0.08709>

    /* stem 0.6.3*/ 
    /*0*/<0.70612,-0.59248,-0.38776>,
    /*1*/<0.21301,-0.33144,0.91912>,<-0.69959,-0.45933,-0.54735>,<0.46621,0.80785,-0.36058>,
            
    /*2*/<0.10257,-0.24206,0.96483>,<-0.639,-0.51866,-0.56805>,<0.51125,0.77432,-0.37289>,
            
    /*3*/<-0.11073,-0.11001,0.98774>,<-0.55839,-0.53293,-0.63576>,<0.65752,0.66971,-0.34519>,
            
    /*4*/<-0.6355,0.76767,-0.08265>

    /* stem 0.6.4*/ 
    /*0*/<0.6631,0.63,-0.40423>,
    /*1*/<-0.23151,-0.35312,-0.90648>,<-0.51194,0.76913,0.38256>,<0.72444,-0.43407,0.53551>,
            
    /*2*/<-0.21394,-0.34262,-0.91479>,<-0.40736,0.84652,0.34272>,<0.60552,-0.51779,0.60435>,
            
    /*3*/<-0.24406,-0.32036,-0.91531>,<-0.06627,0.97016,0.23324>,<0.30476,-0.62,0.72299>,
            
    /*4*/<-0.95907,0.11605,0.25831>

    /* stem 0.6.5*/ 
    /*0*/<0.83176,-0.30992,0.46058>,
    /*1*/<0.03687,0.86732,0.49639>,<-0.50947,-0.7721,0.37988>,<0.44888,-0.08639,-0.8894>,
            
    /*2*/<0.15875,0.82798,0.53781>,<-0.48679,-0.78305,0.38713>,<0.3116,-0.01974,-0.95001>,
            
    /*3*/<0.39565,0.7262,0.56223>,<-0.52553,-0.72923,0.43823>,<0.11215,0.02271,-0.99343>,
            
    /*4*/<-0.77437,0.63169,-0.03644>

    /* stem 0.6.6*/ 
    /*0*/<0.59335,-0.02278,-0.80462>,
    /*1*/<0.15096,-0.97698,0.15074>,<-0.76765,0.30616,-0.563>,<0.59985,0.67146,0.4351>,
            
    /*2*/<0.0226,-0.96683,0.25442>,<-0.62519,0.27246,-0.73137>,<0.56442,0.68401,0.46213>,
            
    /*3*/<-0.3145,-0.87539,0.36711>,<-0.21055,0.17913,-0.96103>,<0.49433,0.67659,0.54577>,
            
    /*4*/<-0.8473,0.53087,0.0163>

    /* stem 0.6.7*/ 
    /*0*/<0.69304,0.65483,0.30148>,
    /*1*/<-0.29116,0.62663,-0.72288>,<-0.43772,0.03531,0.89842>,<0.70938,-0.68038,-0.18402>,
            
    /*2*/<-0.33487,0.60594,-0.72159>,<-0.22046,0.17984,0.95867>,<0.55578,-0.81036,-0.18553>,
            
    /*3*/<-0.35763,0.55385,-0.7519>,<0.22127,0.37891,0.89859>,<0.12854,-0.98782,-0.0877>,
            
    /*4*/<-0.88568,0.09626,0.4542>

    /* stem 0.6.8*/ 
    /*0*/<0.68065,-0.70686,-0.19251>,
    /*1*/<0.27319,0.01433,0.96185>,<-0.73255,-0.60978,-0.30255>,<0.44028,0.61527,-0.65391>,
            
    /*2*/<0.20204,0.08012,0.97609>,<-0.68171,-0.66304,-0.30927>,<0.45745,0.60003,-0.65628>,
            
    /*3*/<0.12596,0.10327,0.98665>,<-0.59396,-0.72053,-0.35785>,<0.44693,0.63579,-0.62931>,
            
    /*4*/<-0.81349,0.57648,0.07684>

    /* stem 0.6.9*/ 
    /*0*/<0.53858,0.53638,-0.64979>,
    /*1*/<-0.23481,-0.65337,-0.71971>,<-0.59206,0.78706,0.1732>,<0.81192,-0.14858,0.56454>,
            
    /*2*/<-0.3744,-0.73139,-0.56999>,<-0.49752,0.86739,0.01019>,<0.81846,-0.14483,0.55601>,
            
    /*3*/<-0.53976,-0.77209,-0.33547>,<-0.2453,0.92719,-0.28309>,<0.7704,-0.12885,0.62441>,
            
    /*4*/<-0.65391,0.24998,0.71408>

    /* stem 0.6.10*/ 
    /*0*/<0.81057,-0.19881,0.55087>,
    /*1*/<0.14271,0.98151,0.12754>,<-0.57275,-0.50946,0.64219>,<0.40767,-0.46656,-0.78494>,
            
    /*2*/<0.18119,0.974,0.13597>,<-0.39206,-0.58381,0.71096>,<0.16909,-0.43138,-0.88618>,
            
    /*3*/<0.32994,0.9392,0.09508>,<-0.14921,-0.5775,0.80264>,<-0.20882,-0.34969,-0.9133>,
            
    /*4*/<-0.88833,0.41678,0.19279>

    /* stem 0.6.11*/ 
    /*0*/<0.39647,-0.47983,-0.78267>,
    /*1*/<-0.00386,-0.84819,0.52968>,<-0.79851,0.2514,-0.54697>,<0.79153,0.6099,0.03868>,
            
    /*2*/<-0.05442,-0.80247,0.59421>,<-0.74039,0.17825,-0.64812>,<0.77085,0.6338,0.06393>,
            
    /*3*/<-0.15315,-0.72679,0.66957>,<-0.58569,0.06162,-0.80819>,<0.71827,0.68095,0.14278>,
            
    /*4*/<-0.70622,0.58048,0.40532>

    /* stem 0.6.12*/ 
    /*0*/<0.77584,0.62393,0.09377>,
    /*1*/<-0.15679,0.32089,-0.93405>,<-0.46286,0.44597,0.76608>,<0.59866,-0.78373,0.16544>,
            
    /*2*/<-0.21429,0.30766,-0.92705>,<-0.19435,0.58595,0.7867>,<0.4135,-0.88602,0.20974>,
            
    /*3*/<-0.15824,0.24242,-0.95718>,<0.12482,0.69263,0.71041>,<-0.0045,-0.96737,0.25333>,
            
    /*4*/<-0.97186,0.2221,0.07852>

    /* stem 0.6.13*/ 
    /*0*/<0.63473,-0.76994,0.06568>,
    /*1*/<0.30678,0.34034,0.88885>,<-0.77393,-0.63099,-0.05367>,<0.45013,0.31131,-0.83694>,
            
    /*2*/<0.33409,0.31266,0.88917>,<-0.74214,-0.66795,-0.05534>,<0.39131,0.37755,-0.83925>,
            
    /*3*/<0.32924,0.32957,0.88486>,<-0.71717,-0.69563,-0.04209>,<0.37198,0.38728,-0.84359>,
            
    /*4*/<-0.68996,0.7211,-0.06298>

    /* stem 0.6.14*/ 
    /*0*/<0.55502,0.19961,-0.80753>,
    /*1*/<-0.33015,-0.84317,-0.42433>,<-0.50534,0.85378,-0.12528>,<0.8207,-0.01592,0.57113>,
            
    /*2*/<-0.41359,-0.84171,-0.34709>,<-0.3678,0.87717,-0.30871>,<0.76043,-0.00457,0.6494>,
            
    /*3*/<-0.52728,-0.8094,-0.25856>,<0.06714,0.79696,-0.6003>,<0.4961,0.08983,0.86361>,
            
    /*4*/<-0.8311,0.53767,0.14206>

    /* stem 0.6.15*/ 
    /*0*/<0.84541,-0.03707,0.53283>,
    /*1*/<0.17837,0.95597,-0.23303>,<-0.534,-0.22458,0.81511>,<0.33328,-0.73041,-0.59617>,
            
    /*2*/<0.23954,0.9515,-0.19304>,<-0.56889,-0.21872,0.7928>,<0.30863,-0.72635,-0.61414>,
            
    /*3*/<0.31236,0.94121,-0.1287>,<-0.41598,-0.31945,0.85142>,<0.05581,-0.66945,-0.74076>,
            
    /*4*/<-0.93727,0.34187,-0.06825>

    /* stem 0.6.16*/ 
    /*0*/<0.56962,-0.62808,-0.53014>,
    /*1*/<0.03583,-0.61754,0.78572>,<-0.73588,-0.08749,-0.67144>,<0.68593,0.72061,-0.10113>,
            
    /*2*/<-0.00675,-0.57269,0.81974>,<-0.70414,-0.12602,-0.69879>,<0.694,0.71193,-0.10735>,
            
    /*3*/<-0.0426,-0.54374,0.83817>,<-0.57379,-0.22357,-0.78789>,<0.60141,0.79711,-0.05396>,
            
    /*4*/<-0.82861,0.47234,0.30051>

    /* stem 0.6.17*/ 
    /*0*/<0.90131,0.36628,-0.23125>,
    /*1*/<-0.25476,-0.00434,-0.967>,<-0.19048,0.80382,0.56355>,<0.42474,-0.80781,0.4087>,
            
    /*2*/<-0.25125,-0.003,-0.96792>,<-0.00106,0.84402,0.53631>,<0.24023,-0.84658,0.47496>,
            
    /*3*/<-0.31938,0.03678,-0.94691>,<0.41824,0.81122,0.40864>,<-0.07877,-0.81914,0.56816>,
            
    /*4*/<-0.77837,0.50798,0.36891>

    /* stem 0.6.18*/ 
    /*0*/<0.51824,-0.80327,0.29357>,
    /*1*/<0.49976,0.56894,0.6531>,<-0.85375,-0.44296,0.27368>,<0.34422,-0.11084,-0.93232>,
            
    /*2*/<0.49776,0.57203,0.65193>,<-0.85378,-0.44292,0.27365>,<0.34626,-0.11399,-0.93119>,
            
    /*3*/<0.53964,0.51471,0.66623>,<-0.80337,-0.52958,0.27229>,<0.25174,0.03592,-0.96713>,
            
    /*4*/<-0.62934,0.77611,0.03976>

    /* stem 0.6.19*/ 
    /*0*/<0.51116,-0.16225,-0.84403>,
    /*1*/<-0.4108,-0.90914,-0.06869>,<-0.45293,0.78634,-0.42014>,<0.85683,0.12498,0.50021>,
            
    /*2*/<-0.51668,-0.85481,0.04832>,<-0.34788,0.71846,-0.60233>,<0.83471,0.14637,0.53089>,
            
    /*3*/<-0.6271,-0.76094,0.16649>,<-0.12479,0.58707,-0.79986>,<0.74932,0.18912,0.63463>,
            
    /*4*/<-0.63672,0.64218,0.42684>

    /* stem 0.6.20*/ 
    /*0*/<0.98622,-0.0409,0.1603>,
    /*1*/<0.11979,0.83023,-0.5444>,<-0.16043,0.06667,0.98479>,<0.03151,-0.89652,-0.44188>,
            
    /*2*/<0.17227,0.81872,-0.54774>,<-0.03228,0.03223,0.99896>,<-0.16341,-0.87676,-0.45232>,
            
    /*3*/<0.43523,0.6902,-0.5781>,<0.05609,0.08105,0.99513>,<-0.47256,-0.75631,-0.45241>,
            
    /*4*/<-0.71257,0.69588,-0.08944>

    /* stem 0.6.21*/ 
    /*0*/<0.38317,-0.82186,-0.42158>,
    /*1*/<0.21978,-0.36078,0.90639>,<-0.88753,-0.19891,-0.41561>,<0.66615,0.56311,-0.48902>,
            
    /*2*/<0.22201,-0.36481,0.90423>,<-0.87152,-0.22996,-0.43308>,<0.64769,0.59895,-0.4709>,
            
    /*3*/<0.19286,-0.32077,0.92732>,<-0.80828,-0.33806,-0.48207>,<0.60797,0.65743,-0.44514>,
            
    /*4*/<-0.60903,0.72909,0.31226>

    /* stem 0.7*/ 
    /*0*/<-0.63236,0.15926,0.75813>,
    /*1*/<0.77271,-0.02073,0.63442>,<0.35461,0.93108,0.08573>,<-0.54397,0.59375,-0.59292>,
            <-0.68123,-0.56653,-0.46366>,<0.13253,-0.9463,0.29488>,
    /*2*/<0.73407,-0.01383,0.67893>,<0.29874,0.94271,0.14853>,<-0.53903,0.5932,-0.59796>,
            <-0.62238,-0.57674,-0.52917>,<0.16462,-0.9515,0.25991>,
    /*3*/<0.68398,-0.01638,0.72932>,<0.25259,0.9449,0.20821>,<-0.51666,0.59993,-0.61085>,
            <-0.56134,-0.57454,-0.59565>,<0.18093,-0.95564,0.23241>,
    /*4*/<0.69916,-0.01751,0.71475>,<0.21767,0.94504,0.24395>,<-0.55453,0.60143,-0.57513>,
            <-0.54845,-0.57317,-0.60883>,<0.22595,-0.95582,0.18801>,
    /*5*/<0.72422,-0.00937,0.6895>,<0.12798,0.93645,0.32661>,<-0.63513,0.58963,-0.49894>,
            <-0.50966,-0.56934,-0.64506>,<0.33022,-0.93966,0.08939>,
    /*6*/<0.67826,0.22912,-0.69819>

    /* stem 0.7.0*/ 
    /*0*/<-0.85534,-0.44691,0.26203>,
    /*1*/<-0.50318,0.65337,-0.56562>,<0.33484,-0.85326,-0.39978>,<0.19354,0.21306,0.95768>,
            
    /*2*/<-0.65228,0.58313,-0.48425>,<0.32587,-0.85912,-0.39461>,<0.34156,0.32152,0.88315>,
            
    /*3*/<-0.8087,0.49952,-0.3106>,<0.2641,-0.85401,-0.44825>,<0.55833,0.37178,0.74165>,
            
    /*4*/<0.49466,0.51963,-0.69664>

    /* stem 0.7.1*/ 
    /*0*/<0.11357,0.22051,0.96875>,
    /*1*/<0.01689,-0.97746,0.21044>,<0.85014,0.47897,-0.21876>,<-0.87035,0.49203,-0.02004>,
            
    /*2*/<0.00182,-0.99128,0.13176>,<0.8501,0.47972,-0.21724>,<-0.86182,0.50384,0.05837>,
            
    /*3*/<-0.09498,-0.9836,-0.15334>,<0.88431,0.44074,-0.15409>,<-0.81429,0.5163,0.26527>,
            
    /*4*/<-0.24544,0.3619,-0.89932>

    /* stem 0.7.2*/ 
    /*0*/<-0.87233,0.44579,0.20077>,
    /*1*/<0.49249,0.84095,0.22419>,<-0.29319,-0.17198,-0.94046>,<-0.17386,-0.68197,0.71041>,
            
    /*2*/<0.41342,0.87176,0.26291>,<-0.37964,-0.15078,-0.91276>,<0.00097,-0.75489,0.65585>,
            
    /*3*/<0.34532,0.89459,0.28366>,<-0.69558,-0.09265,-0.71245>,<0.32722,-0.86092,0.38954>,
            
    /*4*/<0.49343,0.06027,-0.86769>

    /* stem 0.7.3*/ 
    /*0*/<-0.33687,-0.55152,0.76311>,
    /*1*/<-0.75629,-0.31441,-0.57374>,<0.86485,-0.50199,0.00631>,<-0.0988,0.83239,0.54532>,
            
    /*2*/<-0.74136,-0.30649,-0.59703>,<0.79855,-0.58161,0.15507>,<-0.02323,0.89884,0.43766>,
            
    /*3*/<-0.59503,-0.26221,-0.75972>,<0.64373,-0.6735,0.36334>,<-0.03745,0.9356,0.35107>,
            
    /*4*/<0.79927,0.31908,-0.50927>

    /* stem 0.7.4*/ 
    /*0*/<-0.3285,0.67831,0.65725>,
    /*1*/<0.63722,-0.36386,0.67938>,<0.29233,0.72813,-0.61997>,<-0.92008,-0.38383,-0.07836>,
            
    /*2*/<0.66252,-0.37359,0.64923>,<0.13511,0.89668,-0.42155>,<-0.83055,-0.48094,-0.28087>,
            
    /*3*/<0.73225,-0.36607,0.57428>,<-0.16956,0.98509,-0.02896>,<-0.57853,-0.58448,-0.56893>,
            
    /*4*/<0.63838,0.32014,-0.69999>

    /* stem 0.7.5*/ 
    /*0*/<-0.94654,-0.31401,0.07383>,
    /*1*/<-0.30949,0.87689,-0.36781>,<0.21228,-0.75523,-0.62013>,<0.12437,-0.11265,0.98582>,
            
    /*2*/<-0.27964,0.88634,-0.36907>,<0.21016,-0.75604,-0.61987>,<0.09665,-0.12109,0.98792>,
            
    /*3*/<-0.40675,0.82605,-0.39013>,<0.25361,-0.76219,-0.5956>,<0.16537,-0.03444,0.98563>,
            
    /*4*/<0.82973,0.50647,-0.23462>

    /* stem 0.7.6*/ 
    /*0*/<0.03763,-0.13003,0.9908>,
    /*1*/<-0.14638,-0.98029,-0.13268>,<0.92874,0.37072,0.00379>,<-0.78343,0.61328,0.10065>,
            
    /*2*/<-0.16225,-0.93363,-0.31939>,<0.93521,0.34952,0.05682>,<-0.78995,0.57213,0.22056>,
            
    /*3*/<-0.14977,-0.87019,-0.46941>,<0.92056,0.29931,0.25098>,<-0.77087,0.60438,0.20119>,
            
    /*4*/<0.26658,0.39207,-0.88046>

    /* stem 0.7.7*/ 
    /*0*/<-0.82769,0.51426,0.22466>,
    /*1*/<0.55008,0.62504,0.55383>,<-0.13827,0.18421,-0.97311>,<-0.38837,-0.82381,0.41292>,
            
    /*2*/<0.46882,0.65055,0.59748>,<-0.27077,0.2161,-0.93808>,<-0.16578,-0.92885,0.3313>,
            
    /*3*/<0.42382,0.69032,0.58638>,<-0.65055,0.27551,-0.70773>,<0.17917,-0.98111,0.07289>,
            
    /*4*/<0.54796,0.24013,-0.8013>

    /* stem 0.7.8*/ 
    /*0*/<-0.51046,-0.72432,0.46345>,
    /*1*/<-0.67999,0.02326,-0.73285>,<0.79755,-0.59833,-0.07692>,<-0.1032,0.59546,0.79673>,
            
    /*2*/<-0.69493,-0.00034,-0.71908>,<0.82114,-0.56187,-0.10016>,<-0.11157,0.58213,0.80541>,
            
    /*3*/<-0.63487,0.1096,-0.7648>,<0.79588,-0.59583,-0.10755>,<-0.15469,0.51349,0.84404>,
            
    /*4*/<0.63796,0.7347,-0.23069>

    /* stem 0.7.9*/ 
    /*0*/<-0.21872,0.55521,0.80244>,
    /*1*/<0.48146,-0.66025,0.57642>,<0.49832,0.76611,-0.40589>,<-0.97365,-0.12142,-0.19302>,
            
    /*2*/<0.51425,-0.72028,0.46556>,<0.48331,0.8188,-0.3098>,<-0.97762,-0.11378,-0.17695>,
            
    /*3*/<0.57899,-0.77901,0.24066>,<0.39154,0.91836,0.05761>,<-0.9523,-0.08782,-0.29226>,
            
    /*4*/<0.39705,0.17021,-0.90187>

    /* stem 0.7.10*/ 
    /*0*/<-0.98573,-0.08909,-0.14281>,
    /*1*/<-0.0583,0.98718,-0.14856>,<0.1764,-0.61197,-0.77096>,<-0.09071,-0.37274,0.92349>,
            
    /*2*/<-0.30925,0.93782,-0.15766>,<0.23579,-0.58479,-0.77616>,<0.06506,-0.3075,0.94932>,
            
    /*3*/<-0.61097,0.78601,-0.09439>,<0.26323,-0.54276,-0.79757>,<0.36949,-0.22189,0.90235>,
            
    /*4*/<0.7024,0.66176,-0.26212>

    /* stem 0.7.11*/ 
    /*0*/<-0.19756,-0.29948,0.93342>,
    /*1*/<-0.3743,-0.85338,-0.36283>,<0.97381,0.06615,0.21752>,<-0.59408,0.79546,0.11966>,
            
    /*2*/<-0.35697,-0.78265,-0.50993>,<0.97292,0.06467,0.22191>,<-0.6361,0.72747,0.25722>,
            
    /*3*/<-0.27035,-0.60224,-0.75114>,<0.95646,0.02067,0.29112>,<-0.6831,0.59315,0.4261>,
            
    /*4*/<0.24271,0.80158,-0.5464>

    /* stem 0.7.12*/ 
    /*0*/<-0.68128,0.65589,0.32505>,
    /*1*/<0.64984,0.31934,0.68973>,<-0.01377,0.42128,-0.90683>,<-0.61753,-0.75847,0.20825>,
            
    /*2*/<0.707,0.29081,0.64465>,<-0.20011,0.5646,-0.80074>,<-0.52454,-0.84383,0.11316>,
            
    /*3*/<0.74506,0.22968,0.62621>,<-0.43522,0.70146,-0.5644>,<-0.30466,-0.94787,-0.0934>,
            
    /*4*/<0.67072,0.01128,-0.74162>

    /* stem 0.7.13*/ 
    /*0*/<-0.64743,-0.68832,0.3272>,
    /*1*/<-0.68604,0.35705,-0.63392>,<0.62849,-0.71904,-0.29661>,<0.07508,0.38062,0.92168>,
            
    /*2*/<-0.68587,0.35743,-0.63389>,<0.64428,-0.70183,-0.30389>,<0.05931,0.36323,0.92981>,
            
    /*3*/<-0.6626,0.37416,-0.64881>,<0.6423,-0.70741,-0.29498>,<0.03798,0.35186,0.93528>,
            
    /*4*/<0.68335,0.67656,-0.2744>

    /* stem 0.7.14*/ 
    /*0*/<-0.03285,0.29589,0.95466>,
    /*1*/<0.40953,-0.87006,0.27438>,<0.58532,0.77744,-0.2302>,<-0.99396,0.08467,-0.06982>,
            
    /*2*/<0.4301,-0.87536,0.22082>,<0.54399,0.83909,-0.00253>,<-0.96911,0.07753,-0.23411>,
            
    /*3*/<0.49364,-0.86217,0.11396>,<0.43656,0.85998,0.2643>,<-0.91665,0.00496,-0.39965>,
            
    /*4*/<0.39266,0.16583,-0.90461>

    /* stem 0.7.15*/ 
    /*0*/<-0.98988,0.03807,0.13674>,
    /*1*/<0.0737,0.97777,0.19629>,<-0.13297,-0.3124,-0.9406>,<0.08565,-0.66639,0.74067>,
            
    /*2*/<-0.05046,0.97037,0.2363>,<-0.17483,-0.32076,-0.93089>,<0.26341,-0.651,0.71191>,
            
    /*3*/<-0.36612,0.84596,0.3877>,<-0.21969,-0.28287,-0.93366>,<0.60855,-0.53237,0.58842>,
            
    /*4*/<0.61931,0.70439,-0.34682>

    /* stem 0.7.16*/ 
    /*0*/<-0.16764,-0.59448,0.78644>,
    /*1*/<-0.50723,-0.62604,-0.59227>,<0.98708,-0.11078,0.11576>,<-0.47553,0.75213,0.45627>,
            
    /*2*/<-0.53009,-0.69097,-0.49149>,<0.99078,-0.09976,0.09162>,<-0.46838,0.79944,0.37618>,
            
    /*3*/<-0.5742,-0.62636,-0.52723>,<0.98446,-0.16037,0.07162>,<-0.42897,0.79814,0.42304>,
            
    /*4*/<0.2055,0.66724,-0.71593>

    /* stem 0.7.17*/ 
    /*0*/<-0.47312,0.72893,0.49479>,
    /*1*/<0.71805,-0.01672,0.69579>,<0.0928,0.59277,-0.8>,<-0.8,-0.59277,0.09287>,
            
    /*2*/<0.7105,-0.008,0.70365>,<0.03352,0.66132,-0.74936>,<-0.74119,-0.67081,0.02549>,
            
    /*3*/<0.72735,-0.00073,0.68627>,<-0.19472,0.81861,-0.54033>,<-0.55826,-0.80755,-0.19028>,
            
    /*4*/<0.66322,-0.04839,-0.74686>

    /* stem 0.7.18*/ 
    /*0*/<-0.74884,-0.62998,0.20583>,
    /*1*/<-0.64414,0.63686,-0.42367>,<0.44649,-0.70229,-0.55447>,<0.21124,0.07686,0.97441>,
            
    /*2*/<-0.65725,0.62737,-0.41765>,<0.37266,-0.76834,-0.52037>,<0.30738,0.14614,0.9403>,
            
    /*3*/<-0.71262,0.59471,-0.37215>,<0.24546,-0.85368,-0.45932>,<0.48694,0.27208,0.82998>,
            
    /*4*/<0.61676,0.44666,-0.64815>

    /* stem 0.7.19*/ 
    /*0*/<0.09882,-0.02136,0.99488>,
    /*1*/<0.27458,-0.96014,-0.05239>,<0.69026,0.72127,-0.05758>,<-0.96616,0.23915,0.0966>,
            
    /*2*/<0.28692,-0.94202,-0.17398>,<0.70442,0.697,0.1341>,<-0.96574,0.25664,0.0384>,
            
    /*3*/<0.35423,-0.81102,-0.46559>,<0.65865,0.57071,0.49038>,<-0.97091,0.23684,-0.03512>,
            
    /*4*/<0.19106,0.70848,-0.67937>

    /* stem 0.7.20*/ 
    /*0*/<-0.9635,0.2675,-0.01043>,
    /*1*/<0.23066,0.83719,0.4959>,<0.01212,-0.00828,-0.99989>,<-0.23276,-0.83169,0.5041>,
            
    /*2*/<0.22817,0.83767,0.49624>,<-0.22743,0.00492,-0.97378>,<-0.00328,-0.89442,0.44722>,
            
    /*3*/<0.23192,0.81581,0.52978>,<-0.48636,0.08714,-0.8694>,<0.26271,-0.90522,0.33401>,
            
    /*4*/<0.84512,0.11471,-0.52212>

    /* stem 0.7.21*/ 
    /*0*/<-0.23823,-0.78832,0.56727>,
    /*1*/<-0.62295,-0.32269,-0.7126>,<0.95702,-0.29001,-0.00365>,<-0.33303,0.61611,0.71379>,
            
    /*2*/<-0.5919,-0.24457,-0.76801>,<0.93389,-0.3559,0.0344>,<-0.3405,0.60022,0.72374>,
            
    /*3*/<-0.52795,-0.16675,-0.83275>,<0.88127,-0.45367,0.13248>,<-0.34886,0.62289,0.70022>,
            
    /*4*/<0.51585,0.72712,-0.45299>

    /* stem 0.8*/ 
    /*0*/<0.00248,0.10798,-0.99415>,
    /*1*/<-0.9997,0.02195,0.01103>,<-0.28705,0.95114,0.11373>,<0.82225,0.56423,0.07447>,
            <0.79519,-0.60408,-0.05249>,<-0.33083,-0.93922,-0.09169>,
    /*2*/<-0.99973,0.02284,-0.00338>,<-0.28677,0.95799,0.00528>,<0.82352,0.56684,0.02243>,
            <0.79476,-0.60649,0.02296>,<-0.33227,-0.94316,0.00693>,
    /*3*/<-0.99706,0.01358,-0.07537>,<-0.28163,0.94233,-0.18085>,<0.82149,0.56985,-0.02085>,
            <0.78883,-0.58707,0.1819>,<-0.3351,-0.93049,0.14796>,
    /*4*/<-0.97912,-0.0261,-0.20162>,<-0.26428,0.89785,-0.35218>,<0.81204,0.58361,-0.00113>,
            <0.7642,-0.5318,0.36496>,<-0.34304,-0.9079,0.24093>,
    /*5*/<-0.9595,-0.06332,-0.27451>,<-0.22974,0.82734,-0.51258>,<0.81383,0.58041,-0.02833>,
            <0.72803,-0.46144,0.50699>,<-0.36799,-0.8593,0.35521>,
    /*6*/<-0.28486,0.52633,0.80114>

    /* stem 0.8.0*/ 
    /*0*/<0.42651,-0.44826,-0.78559>,
    /*1*/<0.77636,0.62554,0.0772>,<0.00108,-0.8628,0.50554>,<-0.79014,0.25061,-0.55935>,
            
    /*2*/<0.83536,0.54377,-0.0806>,<-0.00273,-0.84461,0.53537>,<-0.82854,0.33618,-0.44778>,
            
    /*3*/<0.83042,0.50974,-0.22488>,<0.04349,-0.79499,0.60507>,<-0.8825,0.30272,-0.35994>,
            
    /*4*/<-0.20798,0.61388,0.76151>

    /* stem 0.8.1*/ 
    /*0*/<-0.64867,0.21042,-0.7314>,
    /*1*/<-0.18984,-0.9768,-0.09912>,<-0.53223,0.54984,0.64374>,<0.74133,0.42071,-0.52291>,
            
    /*2*/<-0.16432,-0.98467,-0.05847>,<-0.60148,0.57152,0.5582>,<0.77702,0.41501,-0.4733>,
            
    /*3*/<-0.08798,-0.98976,0.11242>,<-0.74439,0.58462,0.32264>,<0.82219,0.40307,-0.40191>,
            
    /*4*/<0.33098,0.20385,0.92135>

    /* stem 0.8.2*/ 
    /*0*/<0.52595,0.37142,-0.76513>,
    /*1*/<-0.48509,0.8686,0.10108>,<0.84284,-0.1644,0.51244>,<-0.3733,-0.71518,-0.5909>,
            
    /*2*/<-0.3568,0.91719,-0.17736>,<0.83565,-0.15982,0.5255>,<-0.56081,-0.7365,-0.37823>,
            
    /*3*/<-0.18711,0.85745,-0.47934>,<0.85329,-0.12355,0.5066>,<-0.68599,-0.72758,-0.00651>,
            
    /*4*/<-0.36058,0.46783,0.80692>

    /* stem 0.8.3*/ 
    /*0*/<-0.28991,-0.67763,-0.67585>,
    /*1*/<0.93437,-0.35502,-0.03033>,<-0.65291,-0.36702,0.66257>,<-0.27292,0.74198,-0.61236>,
            
    /*2*/<0.92416,-0.37696,-0.06195>,<-0.68694,-0.41979,0.5932>,<-0.23664,0.82612,-0.51139>,
            
    /*3*/<0.93054,-0.36591,-0.0144>,<-0.73913,-0.56195,0.37135>,<-0.20229,0.92223,-0.32949>,
            
    /*4*/<0.03572,0.27643,0.96037>

    /* stem 0.8.4*/ 
    /*0*/<-0.2117,0.70844,-0.67327>,
    /*1*/<-0.9452,-0.32507,-0.03035>,<0.26754,0.69772,0.66453>,<0.68386,-0.39339,-0.61447>,
            
    /*2*/<-0.95081,-0.30453,-0.05683>,<0.2591,0.75555,0.60168>,<0.70766,-0.47273,-0.52511>,
            
    /*3*/<-0.94329,-0.31452,0.10619>,<0.17639,0.95358,0.24405>,<0.75281,-0.56269,-0.34154>,
            
    /*4*/<0.30287,0.00678,0.95301>

    /* stem 0.8.5*/ 
    /*0*/<0.54063,-0.4007,-0.73971>,
    /*1*/<0.51531,0.85391,-0.07281>,<0.30675,-0.71714,0.62579>,<-0.83781,-0.1251,-0.53143>,
            
    /*2*/<0.55793,0.81041,-0.17872>,<0.32804,-0.75293,0.57052>,<-0.9265,-0.03339,-0.3748>,
            
    /*3*/<0.56941,0.68527,-0.45407>,<0.40846,-0.76113,0.50384>,<-0.99238,0.1159,-0.04189>,
            
    /*4*/<0.20634,0.60388,0.7699>

    /* stem 0.8.6*/ 
    /*0*/<-0.66015,-0.18392,-0.72827>,
    /*1*/<0.15612,-0.9805,0.11933>,<-0.70593,0.46267,0.53628>,<0.56889,0.52315,-0.63457>,
            
    /*2*/<0.1281,-0.98835,0.0822>,<-0.72689,0.45922,0.51063>,<0.62062,0.53509,-0.57315>,
            
    /*3*/<0.14454,-0.98147,0.12582>,<-0.87024,0.40201,0.28471>,<0.69622,0.60122,-0.39218>,
            
    /*4*/<0.16236,0.24202,0.95659>

    /* stem 0.8.7*/ 
    /*0*/<0.46755,0.42658,-0.77422>,
    /*1*/<-0.75448,0.65084,-0.08468>,<0.77563,0.20863,0.59571>,<-0.03457,-0.87171,-0.48881>,
            
    /*2*/<-0.72715,0.67067,-0.14646>,<0.81687,0.22869,0.52955>,<-0.10567,-0.92656,-0.36099>,
            
    /*3*/<-0.63563,0.67108,-0.38161>,<0.87644,0.25179,0.41043>,<-0.29763,-0.95468,-0.00006>,
            
    /*4*/<-0.41338,0.36876,0.83255>

    /* stem 0.8.8*/ 
    /*0*/<-0.00449,-0.87421,-0.48552>,
    /*1*/<0.99936,-0.01281,0.03338>,<-0.53028,-0.40122,0.74688>,<-0.46896,0.43893,-0.76643>,
            
    /*2*/<0.99596,0.03777,0.08146>,<-0.52729,-0.54757,0.64972>,<-0.48503,0.51501,-0.70676>,
            
    /*3*/<0.98921,0.06955,0.12898>,<-0.52447,-0.68704,0.5029>,<-0.46997,0.63616,-0.61191>,
            
    /*4*/<-0.12031,0.60569,0.78655>

    /* stem 0.8.9*/ 
    /*0*/<-0.27536,0.27463,-0.92128>,
    /*1*/<-0.77294,-0.63228,0.05278>,<-0.10155,0.94153,0.32125>,<0.88228,-0.31702,-0.34797>,
            
    /*2*/<-0.76126,-0.61484,0.20608>,<-0.19423,0.98094,-0.0052>,<0.92957,-0.29296,-0.22378>,
            
    /*3*/<-0.71111,-0.62278,0.32628>,<-0.19606,0.85375,-0.48236>,<0.96348,-0.18919,0.18952>,
            
    /*4*/<-0.28105,0.60267,0.74686>

    /* stem 0.8.10*/ 
    /*0*/<0.79074,-0.28201,-0.54332>,
    /*1*/<0.19084,0.96031,-0.20345>,<0.395,-0.42666,0.81359>,<-0.60808,-0.52572,-0.59486>,
            
    /*2*/<0.21232,0.94895,-0.23328>,<0.51086,-0.5077,0.69373>,<-0.76908,-0.46919,-0.43402>,
            
    /*3*/<0.22343,0.92406,-0.31016>,<0.66322,-0.52548,0.53292>,<-0.8991,-0.38887,-0.20098>,
            
    /*4*/<-0.31269,0.41225,0.85573>

    /* stem 0.8.11*/ 
    /*0*/<-0.61865,-0.53707,-0.57343>,
    /*1*/<0.47757,-0.83253,0.28076>,<-0.77416,0.33704,0.5358>,<0.3139,0.51052,-0.80053>,
            
    /*2*/<0.54159,-0.72693,0.42221>,<-0.91479,0.15243,0.37407>,<0.3302,0.56273,-0.75783>,
            
    /*3*/<0.56653,-0.56885,0.59619>,<-0.99618,-0.03574,0.07969>,<0.42395,0.62196,-0.65836>,
            
    /*4*/<-0.07155,0.72086,0.68938>

    /* stem 0.8.12*/ 
    /*0*/<0.35077,0.45647,-0.81767>,
    /*1*/<-0.92433,0.3213,-0.20587>,<0.60344,0.55011,0.57727>,<0.31117,-0.88405,-0.34875>,
            
    /*2*/<-0.93258,0.32812,-0.15046>,<0.74261,0.62898,0.23002>,<0.3034,-0.94962,-0.07856>,
            
    /*3*/<-0.95632,0.26701,-0.119>,<0.74048,0.64816,-0.17772>,<0.22128,-0.9187,0.32716>,
            
    /*4*/<-0.05204,0.44385,0.89459>

    /* stem 0.8.13*/ 
    /*0*/<0.32195,-0.82085,-0.47175>,
    /*1*/<0.93644,0.34634,0.05588>,<-0.37088,-0.56004,0.74081>,<-0.57442,0.23628,-0.78372>,
            
    /*2*/<0.95697,0.28986,0.01334>,<-0.3634,-0.59096,0.72021>,<-0.60382,0.32926,-0.72594>,
            
    /*3*/<0.9492,0.31174,0.04285>,<-0.2927,-0.74094,0.60443>,<-0.65809,0.4304,-0.61779>,
            
    /*4*/<-0.32129,0.54076,0.7774>

    /* stem 0.8.14*/ 
    /*0*/<-0.49815,0.11016,-0.86007>,
    /*1*/<-0.51822,-0.83047,0.20436>,<-0.33316,0.88789,0.31727>,<0.86498,-0.06042,-0.49815>,
            
    /*2*/<-0.49363,-0.7802,0.38421>,<-0.5248,0.84885,-0.0636>,<0.92392,0.00537,-0.38255>,
            
    /*3*/<-0.45271,-0.59515,0.66397>,<-0.57767,0.53957,-0.6125>,<0.99239,0.07773,-0.09552>,
            
    /*4*/<-0.14893,0.87024,0.46958>

    /* stem 0.8.15*/ 
    /*0*/<0.92029,-0.06409,-0.38594>,
    /*1*/<-0.12561,0.89644,-0.42499>,<0.37355,-0.06666,0.92521>,<-0.27287,-0.82805,-0.48977>,
            
    /*2*/<-0.09544,0.88979,-0.44627>,<0.49073,-0.09919,0.86565>,<-0.42656,-0.81078,-0.40084>,
            
    /*3*/<0.01347,0.82235,-0.56882>,<0.62679,-0.10627,0.7719>,<-0.67765,-0.70745,-0.20077>,
            
    /*4*/<-0.56059,0.58821,0.58288>

    /* stem 0.8.16*/ 
    /*0*/<-0.21843,-0.77961,-0.58694>,
    /*1*/<0.70442,-0.5361,0.46517>,<-0.93585,0.00844,0.35229>,<0.23729,0.54857,-0.80173>,
            
    /*2*/<0.70355,-0.36886,0.60742>,<-0.95073,-0.18697,0.24729>,<0.23545,0.55007,-0.80124>,
            
    /*3*/<0.67382,-0.27231,0.68689>,<-0.93154,-0.363,0.02158>,<0.25642,0.66639,-0.70012>,
            
    /*4*/<-0.30481,0.65497,0.69146>

    /* stem 0.8.17*/ 
    /*0*/<0.25672,0.21759,-0.94167>,
    /*1*/<-0.96102,-0.06558,-0.26858>,<0.37331,0.8736,0.3122>,<0.5815,-0.81328,-0.02083>,
            
    /*2*/<-0.98681,-0.05444,-0.15244>,<0.4211,0.90358,0.07886>,<0.57859,-0.81165,0.08032>,
            
    /*3*/<-0.98683,-0.11519,-0.11356>,<0.47141,0.84913,-0.23824>,<0.52995,-0.7469,0.40162>,
            
    /*4*/<-0.26736,0.51663,0.8134>

    /* stem 0.8.18*/ 
    /*0*/<0.60599,-0.7953,0.01664>,
    /*1*/<0.78745,0.60587,-0.11333>,<-0.33036,-0.2243,0.91682>,<-0.46901,-0.36594,-0.80382>,
            
    /*2*/<0.79469,0.59603,-0.11492>,<-0.27264,-0.31501,0.90908>,<-0.54474,-0.27217,-0.79321>,
            
    /*3*/<0.84057,0.52255,-0.14278>,<-0.19876,-0.40083,0.89433>,<-0.65057,-0.10303,-0.75243>,
            
    /*4*/<-0.38459,0.86689,0.31716>

    /* stem 0.8.19*/ 
    /*0*/<-0.29657,-0.38799,-0.87265>,
    /*1*/<-0.25699,-0.8448,0.46933>,<-0.66517,0.7404,-0.09675>,<0.92712,0.11089,-0.358>,
            
    /*2*/<-0.24901,-0.80651,0.53623>,<-0.70488,0.6687,-0.23663>,<0.9426,0.15553,-0.29549>,
            
    /*3*/<-0.25285,-0.71747,0.64907>,<-0.71655,0.50528,-0.48089>,<0.95949,0.22769,-0.16595>,
            
    /*4*/<-0.12581,0.7334,0.66806>

    /* stem 0.8.20*/ 
    /*0*/<0.85129,0.03308,-0.52365>,
    /*1*/<-0.39863,0.69682,-0.59626>,<0.49304,0.27175,0.82648>,<-0.10481,-0.96898,-0.22381>,
            
    /*2*/<-0.33939,0.68028,-0.64965>,<0.597,0.24289,0.76459>,<-0.28407,-0.95389,-0.09693>,
            
    /*3*/<-0.26917,0.64837,-0.71215>,<0.83696,0.10725,0.53666>,<-0.56716,-0.79055,0.23099>,
            
    /*4*/<-0.2528,0.68171,0.68656>

    /* stem 0.8.21*/ 
    /*0*/<-0.1655,-0.9733,-0.15903>,
    /*1*/<0.86451,-0.2183,0.45274>,<-0.84329,0.05878,0.53424>,<-0.01993,0.16713,-0.98573>,
            
    /*2*/<0.85886,-0.27472,0.4323>,<-0.86144,-0.01691,0.50759>,<0.00177,0.30839,-0.95126>,
            
    /*3*/<0.83027,-0.42877,0.3561>,<-0.84297,-0.04002,0.53647>,<0.01931,0.46868,-0.88316>,
            
    /*4*/<0.35175,0.80847,0.47185>

    /* stem 0.8.22*/ 
    /*0*/<0.01071,0.22904,-0.97336>,
    /*1*/<-0.92869,-0.35888,-0.09348>,<0.14326,0.96275,0.2293>,<0.78539,-0.60466,-0.13246>,
            
    /*2*/<-0.93697,-0.34859,-0.02375>,<0.16378,0.98594,-0.03307>,<0.80286,-0.59496,0.03787>,
            
    /*3*/<-0.95245,-0.27451,0.13218>,<0.1963,0.80644,-0.55778>,<0.78882,-0.49957,0.35805>,
            
    /*4*/<-0.01803,0.78065,0.62471>

    /* stem 0.9*/ 
    /*0*/<0.64248,0.06051,0.76391>,
    /*1*/<0.75864,-0.01716,-0.65129>,<0.20447,0.94336,-0.26129>,<-0.64218,0.59925,0.47802>,
            <-0.61126,-0.57393,0.54494>,<0.25449,-0.95489,-0.15301>,
    /*2*/<0.76733,-0.01673,-0.64104>,<0.24953,0.94589,-0.20742>,<-0.62345,0.60013,0.50115>,
            <-0.64405,-0.57441,0.50523>,<0.21544,-0.95569,-0.2006>,
    /*3*/<0.80462,-0.0236,-0.59332>,<0.34708,0.93401,-0.08459>,<-0.59948,0.60129,0.52827>,
            <-0.72621,-0.5594,0.39961>,<0.14172,-0.94536,-0.2936>,
    /*4*/<0.83095,-0.03678,-0.55513>,<0.45939,0.88531,0.07201>,<-0.55691,0.58721,0.5874>,
            <-0.80947,-0.51652,0.27921>,<0.04802,-0.9028,-0.42737>,
    /*5*/<0.81651,-0.02171,-0.57692>,<0.50401,0.85138,0.14534>,<-0.51264,0.55489,0.65521>,
            <-0.82843,-0.50209,0.24821>,<-0.00658,-0.85827,-0.51315>,
    /*6*/<-0.52948,0.42947,-0.73158>

    /* stem 0.9.0*/ 
    /*0*/<0.02788,-0.55404,0.83202>,
    /*1*/<-0.60383,0.65966,0.44747>,<-0.38853,-0.76741,-0.51003>,<0.99152,0.12438,0.03757>,
            
    /*2*/<-0.6023,0.6319,0.48779>,<-0.39091,-0.7504,-0.533>,<0.99036,0.13682,0.02183>,
            
    /*3*/<-0.58197,0.57646,0.57359>,<-0.3611,-0.80619,-0.46868>,<0.95788,0.24887,-0.14331>,
            
    /*4*/<-0.41071,0.47643,-0.77739>

    /* stem 0.9.1*/ 
    /*0*/<0.98242,0.15227,0.10805>,
    /*1*/<0.14909,-0.9872,-0.05663>,<-0.00433,0.55345,-0.83287>,<-0.17414,0.42919,0.88627>,
            
    /*2*/<0.08915,-0.99379,-0.06662>,<0.05691,0.5597,-0.82674>,<-0.17481,0.42963,0.88593>,
            
    /*3*/<-0.08619,-0.98515,-0.14848>,<0.45881,0.53568,-0.7089>,<-0.30807,0.49408,0.81301>,
            
    /*4*/<-0.69438,0.30828,-0.65024>

    /* stem 0.9.2*/ 
    /*0*/<0.09219,0.36277,0.92731>,
    /*1*/<0.35922,0.85243,-0.3799>,<-0.9849,-0.11281,0.13134>,<0.62293,-0.75043,0.22093>,
            
    /*2*/<0.41986,0.87575,-0.23827>,<-0.96365,-0.11481,0.24126>,<0.57341,-0.8161,-0.07195>,
            
    /*3*/<0.50427,0.86293,-0.03245>,<-0.91141,-0.04106,0.40945>,<0.39973,-0.82166,-0.40632>,
            
    /*4*/<-0.44867,0.31195,-0.83749>

    /* stem 0.9.3*/ 
    /*0*/<0.64024,-0.66692,0.3812>,
    /*1*/<-0.71697,-0.31925,0.61971>,<0.09646,-0.41079,-0.90662>,<0.60152,0.74981,0.2756>,
            
    /*2*/<-0.68204,-0.34389,0.64542>,<0.18455,-0.47083,-0.86271>,<0.48739,0.85056,0.19747>,
            
    /*3*/<-0.80628,-0.25458,0.53396>,<0.30327,-0.60492,-0.73627>,<0.44169,0.87527,0.19701>,
            
    /*4*/<-0.40099,0.52756,-0.74893>

    /* stem 0.9.4*/ 
    /*0*/<0.61324,0.71998,0.3249>,
    /*1*/<0.72259,-0.3639,-0.58774>,<-0.63442,0.68678,-0.35474>,<-0.10627,-0.34413,0.93289>,
            
    /*2*/<0.69343,-0.39054,-0.6055>,<-0.57273,0.75422,-0.32114>,<-0.14354,-0.37678,0.91511>,
            
    /*3*/<0.65874,-0.42225,-0.62271>,<-0.36265,0.91626,-0.17018>,<-0.3446,-0.48502,0.80374>,
            
    /*4*/<-0.73353,-0.183,-0.65456>

    /* stem 0.9.5*/ 
    /*0*/<-0.11933,-0.41207,0.9033>,
    /*1*/<-0.33593,0.87656,0.34465>,<-0.639,-0.6594,-0.39607>,<0.97843,-0.20505,0.02488>,
            
    /*2*/<-0.3323,0.83207,0.44411>,<-0.63809,-0.67585,-0.36887>,<0.98575,-0.13499,-0.10038>,
            
    /*3*/<-0.28656,0.75563,0.58898>,<-0.63929,-0.72367,-0.26001>,<0.93155,-0.01729,-0.3632>,
            
    /*4*/<-0.4271,0.51316,-0.74448>

    /* stem 0.9.6*/ 
    /*0*/<0.9758,-0.19056,0.10722>,
    /*1*/<-0.20712,-0.97656,0.05864>,<0.17033,0.42227,-0.89032>,<0.00832,0.55985,0.82855>,
            
    /*2*/<-0.36312,-0.93174,-0.0035>,<0.38924,0.34481,-0.85417>,<-0.03084,0.58228,0.81241>,
            
    /*3*/<-0.53536,-0.8368,-0.11475>,<0.62195,0.29638,-0.72481>,<-0.10756,0.55286,0.8263>,
            
    /*4*/<-0.70121,0.56121,-0.43972>

    /* stem 0.9.7*/ 
    /*0*/<0.16156,0.45641,0.87498>,
    /*1*/<0.63832,0.62206,-0.45342>,<-0.9721,0.22947,0.04872>,<0.32908,-0.86479,0.37926>,
            
    /*2*/<0.69361,0.64826,-0.31411>,<-0.95845,0.23952,0.15492>,<0.27793,-0.95472,0.10617>,
            
    /*3*/<0.76231,0.64382,-0.0662>,<-0.89744,0.281,0.34006>,<0.13211,-0.93947,-0.31615>,
            
    /*4*/<-0.28901,0.42889,-0.85588>

    /* stem 0.9.8*/ 
    /*0*/<0.41974,-0.72219,0.54978>,
    /*1*/<-0.78678,0.02554,0.61671>,<-0.01055,-0.60112,-0.79909>,<0.7852,0.59644,0.1665>,
            
    /*2*/<-0.79378,0.03566,0.60716>,<0.0119,-0.63766,-0.77023>,<0.77044,0.62087,0.1447>,
            
    /*3*/<-0.81468,0.06095,0.57669>,<0.0379,-0.66752,-0.74363>,<0.76511,0.62629,0.14952>,
            
    /*4*/<-0.37441,0.67677,-0.63388>

    /* stem 0.9.9*/ 
    /*0*/<0.81456,0.54792,0.19043>,
    /*1*/<0.55154,-0.6602,-0.50985>,<-0.42051,0.77286,-0.47525>,<-0.15441,-0.12839,0.97963>,
            
    /*2*/<0.40162,-0.7385,-0.5416>,<-0.31988,0.8227,-0.46994>,<-0.10512,-0.10975,0.98838>,
            
    /*3*/<0.22698,-0.80061,-0.55452>,<0.01606,0.92138,-0.38833>,<-0.27202,-0.07445,0.95941>,
            
    /*4*/<-0.88814,0.08257,-0.4521>

    /* stem 0.9.10*/ 
    /*0*/<-0.30497,-0.24544,0.92019>,
    /*1*/<0.01097,0.96781,0.25144>,<-0.82584,-0.40526,-0.39212>,<0.82357,-0.55555,0.11444>,
            
    /*2*/<-0.01105,0.9514,0.30774>,<-0.80661,-0.38586,-0.44777>,<0.82401,-0.55496,0.11415>,
            
    /*3*/<-0.0613,0.92333,0.37909>,<-0.77896,-0.39542,-0.48669>,<0.85146,-0.51775,0.08333>,
            
    /*4*/<0.28947,0.41367,-0.86318>

    /* stem 0.9.11*/ 
    /*0*/<0.82475,-0.51904,0.22446>,
    /*1*/<-0.56073,-0.81836,0.12595>,<0.37118,0.21756,-0.90272>,<0.16624,0.61548,0.77042>,
            
    /*2*/<-0.58357,-0.80492,0.10748>,<0.54556,0.12575,-0.82858>,<0.04646,0.71349,0.69913>,
            
    /*3*/<-0.53361,-0.83505,0.13401>,<0.68988,0.04703,-0.72239>,<-0.18101,0.79601,0.57759>,
            
    /*4*/<-0.70917,0.21932,-0.67006>

    /* stem 0.9.12*/ 
    /*0*/<0.29494,0.45754,0.83885>,
    /*1*/<0.83636,0.29155,-0.46422>,<-0.81806,0.57398,-0.03657>,<-0.02657,-0.87835,0.47729>,
            
    /*2*/<0.83022,0.29355,-0.47388>,<-0.73576,0.63528,0.23467>,<-0.1702,-0.95088,0.25857>,
            
    /*3*/<0.83865,0.26827,-0.47403>,<-0.49351,0.63774,0.59138>,<-0.38818,-0.91254,-0.1288>,
            
    /*4*/<-0.51409,0.51115,-0.6888>

    /* stem 0.9.13*/ 
    /*0*/<0.05972,-0.80107,0.59558>,
    /*1*/<-0.73319,0.37744,0.56566>,<-0.22134,-0.58504,-0.78022>,<0.95287,0.22982,0.19804>,
            
    /*2*/<-0.71834,0.30545,0.62506>,<-0.21868,-0.597,-0.77186>,<0.93725,0.32044,0.13741>,
            
    /*3*/<-0.67996,0.23594,0.69425>,<-0.22836,-0.64777,-0.7268>,<0.90154,0.43243,0.01545>,
            
    /*4*/<-0.38362,0.71067,-0.58973>

    /* stem 0.9.14*/ 
    /*0*/<0.96664,0.03685,0.25349>,
    /*1*/<0.17317,-0.79527,-0.581>,<0.05613,0.92151,-0.38427>,<-0.25595,-0.12726,0.95828>,
            
    /*2*/<0.14476,-0.79194,-0.59319>,<0.16994,0.92246,-0.34668>,<-0.3385,-0.11806,0.93353>,
            
    /*3*/<0.04791,-0.75707,-0.65157>,<0.45408,0.86318,-0.22073>,<-0.50277,-0.07596,0.86107>,
            
    /*4*/<-0.72506,0.48372,-0.49021>

    /* stem 0.9.15*/ 
    /*0*/<-0.22588,-0.17073,0.95908>,
    /*1*/<0.41638,0.87571,0.24445>,<-0.9686,-0.04186,-0.24508>,<0.55839,-0.82918,-0.0256>,
            
    /*2*/<0.41599,0.8775,0.23864>,<-0.98743,-0.06833,-0.1425>,<0.56943,-0.81253,-0.12465>,
            
    /*3*/<0.42658,0.86111,0.27662>,<-0.98607,-0.14603,0.07963>,<0.55804,-0.72767,-0.39885>,
            
    /*4*/<-0.27985,0.47601,-0.83372>

    /* stem 0.9.16*/ 
    /*0*/<0.5765,-0.78159,0.23826>,
    /*1*/<-0.82205,-0.53727,0.1886>,<0.3864,0.01547,-0.9222>,<0.41999,0.54303,0.72713>,
            
    /*2*/<-0.89823,-0.41782,0.13641>,<0.44399,-0.09614,-0.89086>,<0.42842,0.52697,0.734>,
            
    /*3*/<-0.9377,-0.3386,0.0779>,<0.56691,-0.24145,-0.7876>,<0.36833,0.61012,0.70149>,
            
    /*4*/<-0.36453,0.7182,-0.59271>

    /* stem 0.9.17*/ 
    /*0*/<0.53952,0.22441,0.81152>,
    /*1*/<0.83237,-0.04215,-0.55262>,<-0.50111,0.86129,0.08409>,<-0.34556,-0.82509,0.44701>,
            
    /*2*/<0.82933,-0.0368,-0.55755>,<-0.35694,0.83211,0.42449>,<-0.58982,-0.78409,0.19318>,
            
    /*3*/<0.83593,-0.05671,-0.54589>,<-0.08313,0.62048,0.77981>,<-0.80111,-0.54823,-0.24013>,
            
    /*4*/<-0.19647,0.85849,-0.47371>

    /* stem 0.9.18*/ 
    /*0*/<-0.18148,-0.77873,0.60054>,
    /*1*/<-0.46433,0.61192,0.64027>,<-0.51577,-0.43778,-0.73643>,<0.98432,-0.15605,0.0822>,
            
    /*2*/<-0.46675,0.58329,0.66476>,<-0.52034,-0.4885,-0.70044>,<0.9968,-0.07757,0.01908>,
            
    /*3*/<-0.44822,0.49363,0.74527>,<-0.52302,-0.58309,-0.62166>,<0.98343,0.11461,-0.14046>,
            
    /*4*/<-0.31017,0.76257,-0.5677>

    /* stem 0.9.19*/ 
    /*0*/<0.9432,-0.23738,0.23242>,
    /*1*/<-0.12232,-0.88934,-0.44058>,<0.32132,0.7823,-0.53363>,<-0.21784,0.11178,0.96956>,
            
    /*2*/<-0.19017,-0.85969,-0.4741>,<0.48373,0.72938,-0.48374>,<-0.29267,0.15148,0.94414>,
            
    /*3*/<-0.31611,-0.77306,-0.54995>,<0.68935,0.62064,-0.37363>,<-0.38432,0.16204,0.90887>,
            
    /*4*/<-0.65695,0.64738,-0.38643>

    /* stem 0.9.20*/ 
    /*0*/<0.05988,-0.04982,0.99696>,
    /*1*/<0.62872,0.77762,-0.00439>,<-0.98605,0.15466,0.06147>,<0.35635,-0.93146,-0.07343>,
            
    /*2*/<0.65152,0.7529,0.09302>,<-0.98107,0.12703,0.14613>,<0.33866,-0.90004,-0.2743>,
            
    /*3*/<0.67144,0.71419,0.19774>,<-0.8965,-0.03731,0.44146>,<0.17127,-0.72024,-0.67225>,
            
    /*4*/<-0.55068,0.67442,-0.49185>

    /* stem 0.9.21*/ 
    /*0*/<0.35052,-0.93581,0.03742>,
    /*1*/<-0.84925,-0.29595,0.43725>,<0.07756,-0.00615,-0.99697>,<0.76709,0.31436,0.55923>,
            
    /*2*/<-0.84657,-0.30233,0.43807>,<0.10743,-0.07149,-0.99164>,<0.73917,0.38799,0.55053>,
            
    /*3*/<-0.89432,-0.18492,0.40742>,<0.15314,-0.21583,-0.96435>,<0.72243,0.412,0.5553>,
            
    /*4*/<-0.196,0.92423,-0.3277>

    /* stem 0.9.22*/ 
    /*0*/<0.73471,0.15208,0.66112>,
    /*1*/<0.6681,-0.31801,-0.67269>,<-0.24303,0.96903,0.0438>,<-0.42999,-0.65204,0.62447>,
            
    /*2*/<0.6149,-0.3017,-0.72862>,<-0.06089,0.97331,0.22127>,<-0.55671,-0.63308,0.53784>,
            
    /*3*/<0.53958,-0.28495,-0.79225>,<0.1981,0.86414,0.46262>,<-0.74824,-0.56929,0.34066>,
            
    /*4*/<-0.55637,0.59703,-0.57792>

    /* stem 0.9.23*/ 
    /*0*/<-0.06932,-0.60914,0.79003>,
    /*1*/<-0.17832,0.78718,0.59037>,<-0.76078,-0.47949,-0.43738>,<0.93926,-0.30636,-0.15473>,
            
    /*2*/<-0.17671,0.71768,0.67358>,<-0.76125,-0.47229,-0.44434>,<0.94482,-0.23837,-0.22473>,
            
    /*3*/<-0.13819,0.49537,0.85762>,<-0.78909,-0.39014,-0.47447>,<0.92838,-0.09811,-0.35845>,
            
    /*4*/<-0.14724,0.9241,-0.35265>

    /* stem 0.10*/ 
    /*0*/<-0.98207,0.07415,-0.1733>,
    /*1*/<-0.16258,0.00127,0.98669>,<0.02717,0.94819,0.31653>,<0.19462,0.58359,-0.78838>,
            <0.10835,-0.58866,-0.80108>,<-0.11241,-0.94856,0.29597>,
    /*2*/<-0.12629,-0.00054,0.99199>,<0.00911,0.94947,0.31373>,<0.14717,0.58672,-0.7963>,
            <0.09715,-0.58801,-0.803>,<-0.0719,-0.95062,0.30193>,
    /*3*/<-0.09594,0.00397,0.99538>,<-0.11739,0.94817,0.29527>,<0.03935,0.58134,-0.81271>,
            <0.15615,-0.58629,-0.79491>,<0.07248,-0.94374,0.32264>,
    /*4*/<-0.07146,0.01334,0.99735>,<-0.29477,0.91435,0.27763>,<-0.0956,0.55559,-0.82594>,
            <0.24978,-0.56649,-0.7853>,<0.26456,-0.90207,0.34099>,
    /*5*/<-0.00097,0.04694,0.9989>,<-0.36041,0.89364,0.26741>,<-0.20768,0.51159,-0.83375>,
            <0.24658,-0.57203,-0.78229>,<0.37388,-0.85881,0.35024>,
    /*6*/<0.91755,0.39417,-0.05227>

    /* stem 0.10.0*/ 
    /*0*/<-0.71342,-0.4382,-0.54682>,
    /*1*/<0.18735,0.64378,-0.74192>,<0.50352,-0.86238,0.05256>,<-0.66932,0.23183,0.70588>,
            
    /*2*/<0.25895,0.67749,-0.68844>,<0.44329,-0.89638,-0.00166>,<-0.67468,0.22895,0.70171>,
            
    /*3*/<0.34509,0.66817,-0.65914>,<0.30859,-0.9504,-0.03894>,<-0.63255,0.28792,0.71901>,
            
    /*4*/<0.80648,0.17785,0.56388>

    /* stem 0.10.1*/ 
    /*0*/<-0.82785,0.1735,0.53345>,
    /*1*/<-0.09411,-0.98342,0.15501>,<0.53712,0.55675,0.63366>,<-0.4181,0.42144,-0.80472>,
            
    /*2*/<0.04996,-0.9904,0.12892>,<0.25717,0.58019,0.77282>,<-0.30058,0.44361,-0.84431>,
            
    /*3*/<0.26557,-0.95373,0.14094>,<-0.24827,0.56799,0.78469>,<-0.01666,0.42174,-0.90656>,
            
    /*4*/<0.88455,0.35393,0.30383>

    /* stem 0.10.2*/ 
    /*0*/<-0.59833,0.39004,-0.6999>,
    /*1*/<-0.01728,0.86075,0.50873>,<0.71118,-0.16214,-0.68406>,<-0.67597,-0.71031,0.1963>,
            
    /*2*/<-0.15552,0.90337,0.39966>,<0.68347,-0.15882,-0.71249>,<-0.53174,-0.76178,0.37005>,
            
    /*3*/<-0.38163,0.89541,0.22934>,<0.59467,-0.13295,-0.7929>,<-0.19037,-0.77332,0.60476>,
            
    /*4*/<0.81907,0.36982,0.43859>

    /* stem 0.10.3*/ 
    /*0*/<-0.86795,-0.49378,0.05335>,
    /*1*/<0.14668,-0.33813,-0.9296>,<0.35275,-0.51554,0.78089>,<-0.47353,0.8684,0.14712>,
            
    /*2*/<0.22861,-0.2785,-0.93283>,<0.35421,-0.51353,0.78155>,<-0.56239,0.81431,0.1436>,
            
    /*3*/<0.3309,-0.24009,-0.91261>,<0.33288,-0.49949,0.79981>,<-0.64141,0.75844,0.11565>,
            
    /*4*/<0.76358,0.63749,0.10273>

    /* stem 0.10.4*/ 
    /*0*/<-0.79548,0.60306,0.0594>,
    /*1*/<-0.18037,-0.34506,0.92109>,<0.6008,0.78884,-0.12952>,<-0.3968,-0.4617,-0.79334>,
            
    /*2*/<-0.1705,-0.34592,0.92264>,<0.39461,0.90557,-0.15568>,<-0.19078,-0.54838,-0.81418>,
            
    /*3*/<-0.17642,-0.33455,0.92572>,<0.0711,0.98034,-0.18407>,<0.13689,-0.64601,-0.75095>,
            
    /*4*/<0.96321,0.09811,0.2502>

    /* stem 0.10.5*/ 
    /*0*/<-0.62125,-0.35921,-0.69643>,
    /*1*/<0.06702,0.86741,-0.49305>,<0.65221,-0.7341,-0.18902>,<-0.70088,-0.12271,0.70265>,
            
    /*2*/<-0.01037,0.84283,-0.53808>,<0.5536,-0.79463,-0.24916>,<-0.52668,-0.03997,0.84912>,
            
    /*3*/<-0.04875,0.84613,-0.53074>,<0.45162,-0.80632,-0.38195>,<-0.38022,-0.02769,0.92448>,
            
    /*4*/<0.85994,0.25816,0.44029>

    /* stem 0.10.6*/ 
    /*0*/<-0.81524,-0.10288,0.56991>,
    /*1*/<0.01354,-0.98438,-0.17551>,<0.50669,0.37647,0.77559>,<-0.49628,0.61093,-0.61682>,
            
    /*2*/<0.07401,-0.97962,-0.18672>,<0.27051,0.36245,0.89188>,<-0.33124,0.65852,-0.67574>,
            
    /*3*/<0.2646,-0.95302,-0.14743>,<-0.12119,0.32605,0.93755>,<-0.12013,0.62676,-0.7699>,
            
    /*4*/<0.92213,0.34763,0.1698>

    /* stem 0.10.7*/ 
    /*0*/<-0.66419,0.53873,-0.51829>,
    /*1*/<-0.06295,0.64058,0.76531>,<0.68576,0.1403,-0.71417>,<-0.6034,-0.79663,-0.03598>,
            
    /*2*/<-0.2005,0.69574,0.68974>,<0.64038,0.1544,-0.75238>,<-0.43411,-0.89425,0.10887>,
            
    /*3*/<-0.34941,0.73767,0.57771>,<0.4328,0.18045,-0.88324>,<-0.0418,-0.95151,0.30476>,
            
    /*4*/<0.92173,0.25768,0.28984>

    /* stem 0.10.8*/ 
    /*0*/<-0.7893,-0.6091,-0.07748>,
    /*1*/<0.10844,0.00182,-0.9941>,<0.48174,-0.67887,0.55413>,<-0.56727,0.69473,0.44222>,
            
    /*2*/<0.1038,-0.00172,-0.9946>,<0.46801,-0.68926,0.55307>,<-0.54869,0.70836,0.44404>,
            
    /*3*/<0.09907,-0.00312,-0.99508>,<0.41394,-0.72755,0.54711>,<-0.4887,0.74597,0.45244>,
            
    /*4*/<0.87618,0.47575,0.07723>

    /* stem 0.10.9*/ 
    /*0*/<-0.73912,0.55469,0.38214>,
    /*1*/<-0.0779,-0.64493,0.76027>,<0.62827,0.77531,0.06458>,<-0.52902,-0.14641,-0.83588>,
            
    /*2*/<0.00097,-0.65752,0.75344>,<0.31951,0.93527,0.15226>,<-0.32329,-0.18641,-0.92776>,
            
    /*3*/<0.09051,-0.65943,0.7463>,<-0.17636,0.96838,0.17643>,<0.10925,-0.27906,-0.95404>,
            
    /*4*/<0.91955,0.33545,0.2047>

    /* stem 0.10.10*/ 
    /*0*/<-0.60047,-0.27143,-0.75217>,
    /*1*/<-0.18125,0.96476,-0.19074>,<0.77252,-0.45961,-0.43814>,<-0.57405,-0.49736,0.65046>,
            
    /*2*/<-0.21592,0.94586,-0.24235>,<0.81893,-0.43264,-0.37707>,<-0.58278,-0.50284,0.63837>,
            
    /*3*/<-0.28929,0.87913,-0.37873>,<0.8486,-0.4309,-0.30692>,<-0.55491,-0.43079,0.71169>,
            
    /*4*/<0.53812,0.57191,0.61915>

    /* stem 0.10.11*/ 
    /*0*/<-0.58413,-0.51533,0.62707>,
    /*1*/<0.24383,-0.84249,-0.48038>,<0.55832,0.31799,0.76627>,<-0.7855,0.53918,-0.30376>,
            
    /*2*/<0.26879,-0.82159,-0.50273>,<0.52466,0.28718,0.80141>,<-0.77454,0.54942,-0.31342>,
            
    /*3*/<0.34715,-0.73533,-0.58205>,<0.48511,0.24963,0.83807>,<-0.81934,0.50092,-0.27887>,
            
    /*4*/<0.48646,0.73133,-0.47803>

    /* stem 0.10.12*/ 
    /*0*/<-0.74476,0.56823,-0.34992>,
    /*1*/<-0.17108,0.33076,0.92808>,<0.65298,0.47705,-0.58825>,<-0.4609,-0.82383,-0.32996>,
            
    /*2*/<-0.31054,0.37232,0.87461>,<0.57534,0.50334,-0.64469>,<-0.23847,-0.94915,-0.20556>,
            
    /*3*/<-0.48592,0.4229,0.76488>,<0.34308,0.52987,-0.77559>,<0.19379,-0.98099,0.01075>,
            
    /*4*/<0.83179,0.3804,0.40425>

    /* stem 0.10.13*/ 
    /*0*/<-0.65158,-0.70756,-0.27348>,
    /*1*/<0.04061,0.33903,-0.9399>,<0.64503,-0.69963,0.30734>,<-0.66745,0.38035,0.64019>,
            
    /*2*/<-0.0155,0.28607,-0.95808>,<0.64061,-0.70435,0.3058>,<-0.6105,0.44277,0.65669>,
            
    /*3*/<-0.11043,0.22414,-0.96828>,<0.64156,-0.71473,0.2785>,<-0.51157,0.51011,0.69144>,
            
    /*4*/<0.74732,0.66401,0.02457>

    /* stem 0.10.14*/ 
    /*0*/<-0.88575,-0.01978,0.46375>,
    /*1*/<0.30683,-0.78889,0.53245>,<0.16658,0.92638,0.33774>,<-0.44884,-0.13694,-0.88306>,
            
    /*2*/<0.49717,-0.73251,0.46503>,<-0.0479,0.87754,0.47711>,<-0.42069,-0.11983,-0.89925>,
            
    /*3*/<0.72723,-0.59457,0.34298>,<-0.32403,0.75976,0.56371>,<-0.38052,-0.15097,-0.91237>,
            
    /*4*/<0.6252,0.66661,-0.4059>

    /* stem 0.10.15*/ 
    /*0*/<-0.7148,-0.20062,-0.66993>,
    /*1*/<-0.37286,0.91777,0.13667>,<0.70498,-0.1552,-0.69204>,<-0.31247,-0.75705,0.57379>,
            
    /*2*/<-0.46917,0.88047,0.06824>,<0.68388,-0.16724,-0.71017>,<-0.20428,-0.70704,0.67702>,
            
    /*3*/<-0.71518,0.69629,-0.06075>,<0.64206,-0.1732,-0.74684>,<0.06637,-0.49798,0.86464>,
            
    /*4*/<0.50398,0.8414,0.19508>

    /* stem 0.10.16*/ 
    /*0*/<-0.35023,-0.78114,0.51687>,
    /*1*/<0.28583,-0.60711,-0.74143>,<0.63519,0.21727,0.74117>,<-0.91146,0.41115,-0.01384>,
            
    /*2*/<0.30288,-0.58566,-0.75184>,<0.5637,0.09898,0.82003>,<-0.85554,0.51429,-0.05964>,
            
    /*3*/<0.32126,-0.57177,-0.7549>,<0.43311,-0.06283,0.89915>,<-0.73921,0.65701,-0.14802>,
            
    /*4*/<0.72093,0.65876,-0.21516>

    /* stem 0.10.17*/ 
    /*0*/<-0.9418,0.33098,-0.05892>,
    /*1*/<-0.04536,0.02219,0.99872>,<0.32249,0.80144,-0.50368>,<-0.25232,-0.83235,-0.49349>,
            
    /*2*/<-0.05036,0.02343,0.99846>,<0.08405,0.83094,-0.54997>,<-0.0033,-0.86129,-0.5081>,
            
    /*3*/<0.00696,0.06407,0.99792>,<-0.34913,0.7655,-0.54048>,<0.34432,-0.80616,-0.4812>,
            
    /*4*/<0.8208,0.56051,-0.11005>

    /* stem 0.10.18*/ 
    /*0*/<-0.51428,-0.75048,-0.41508>,
    /*1*/<-0.19655,0.5815,-0.78944>,<0.82629,-0.56309,0.01274>,<-0.61795,-0.0012,0.78621>,
            
    /*2*/<-0.21875,0.55122,-0.80517>,<0.82337,-0.5674,0.01052>,<-0.59412,0.0346,0.80363>,
            
    /*3*/<-0.32036,0.39832,-0.85948>,<0.8677,-0.49687,0.0148>,<-0.54076,0.11873,0.83275>,
            
    /*4*/<0.42249,0.90259,0.08265>

    /* stem 0.10.19*/ 
    /*0*/<-0.61246,-0.07565,0.78688>,
    /*1*/<0.3996,-0.89066,0.21689>,<0.39909,0.83344,0.38224>,<-0.78639,0.05875,-0.61494>,
            
    /*2*/<0.56067,-0.82381,0.08359>,<0.24229,0.75666,0.60726>,<-0.76079,0.08252,-0.64373>,
            
    /*3*/<0.69871,-0.71385,-0.04711>,<-0.11828,0.55535,0.82316>,<-0.59528,0.19738,-0.7789>,
            
    /*4*/<0.70431,0.69744,-0.13241>

    /* stem 0.10.20*/ 
    /*0*/<-0.84054,-0.03693,-0.54049>,
    /*1*/<-0.32466,0.8272,0.45863>,<0.54185,0.07252,-0.83734>,<-0.20321,-0.89911,0.38771>,
            
    /*2*/<-0.4118,0.80619,0.42482>,<0.45831,0.04205,-0.8878>,<-0.02134,-0.87079,0.4912>,
            
    /*3*/<-0.49547,0.77739,0.38752>,<0.13076,-0.11706,-0.98448>,<0.41426,-0.71254,0.56628>,
            
    /*4*/<0.76154,0.60345,-0.23643>

    /* stem 0.10.21*/ 
    /*0*/<-0.28551,-0.89859,0.33319>,
    /*1*/<0.11031,-0.37189,-0.9217>,<0.77132,-0.00418,0.63644>,<-0.87784,0.38796,0.28085>,
            
    /*2*/<0.07508,-0.45553,-0.88705>,<0.77261,-0.00197,0.63488>,<-0.85008,0.46834,0.24086>,
            
    /*3*/<0.07682,-0.45032,-0.88956>,<0.70785,-0.16331,0.68723>,<-0.7631,0.61016,0.21301>,
            
    /*4*/<0.62695,0.74986,-0.21128>

    /* stem 0.10.22*/ 
    /*0*/<-0.90948,0.33708,0.24336>,
    /*1*/<0.16483,-0.25211,0.95356>,<0.25295,0.91041,-0.32736>,<-0.41004,-0.66117,-0.62827>,
            
    /*2*/<0.25313,-0.26332,0.93091>,<0.09474,0.95576,-0.27847>,<-0.34385,-0.67176,-0.65613>,
            
    /*3*/<0.41433,-0.253,0.87425>,<-0.34845,0.92847,-0.12859>,<-0.11863,-0.62987,-0.76758>,
            
    /*4*/<0.77874,0.53991,-0.31946>

    /* stem 0.10.23*/ 
    /*0*/<-0.56931,-0.63744,-0.51918>,
    /*1*/<-0.35717,0.76118,-0.54133>,<0.82037,-0.48611,-0.30116>,<-0.4618,-0.2735,0.84377>,
            
    /*2*/<-0.41011,0.71985,-0.56002>,<0.73384,-0.5882,-0.33985>,<-0.3151,-0.13526,0.93937>,
            
    /*3*/<-0.57488,0.58262,-0.57451>,<0.66757,-0.60944,-0.4277>,<-0.10255,0.03426,0.99414>,
            
    /*4*/<0.60387,0.79625,-0.03636>

    /* stem 0.11*/ 
    /*0*/<0.86607,-0.00222,-0.49991>,
    /*1*/<-0.50962,0.01329,-0.8603>,<-0.15612,0.95503,-0.25207>,<0.39958,0.57699,0.71233>,
            <0.38952,-0.5984,0.70014>,<-0.17239,-0.94679,-0.2718>,
    /*2*/<-0.58032,0.01786,-0.81419>,<-0.12091,0.95377,-0.27516>,<0.49432,0.57339,0.65335>,
            <0.41167,-0.59967,0.68624>,<-0.25115,-0.94262,-0.21997>,
    /*3*/<-0.64513,0.03929,-0.76306>,<-0.01245,0.93804,-0.34631>,<0.6267,0.54239,0.55952>,
            <0.38777,-0.59859,0.70095>,<-0.39785,-0.91,-0.11668>,
    /*4*/<-0.65336,0.0461,-0.75565>,<0.11629,0.88212,-0.45644>,<0.71487,0.50416,0.48454>,
            <0.31453,-0.56371,0.76374>,<-0.53098,-0.84738,-0.00254>,
    /*5*/<-0.66954,0.06386,-0.74003>,<0.22984,0.79764,-0.55762>,<0.8027,0.43708,0.40575>,
            <0.25651,-0.51824,0.81586>,<-0.65331,-0.74934,0.10807>,
    /*6*/<-0.53059,0.65069,0.54321>

    /* stem 0.11.0*/ 
    /*0*/<0.86158,-0.5072,-0.02059>,
    /*1*/<0.37963,0.63769,0.67025>,<-0.48598,-0.81799,0.30776>,<0.08009,0.19576,-0.97738>,
            
    /*2*/<0.41635,0.61834,0.66656>,<-0.45842,-0.83498,0.30438>,<0.01574,0.23349,-0.97223>,
            
    /*3*/<0.50599,0.57372,0.64406>,<-0.42175,-0.85213,0.30984>,<-0.1084,0.29664,-0.94882>,
            
    /*4*/<-0.8128,0.49485,0.30738>

    /* stem 0.11.1*/ 
    /*0*/<0.24031,0.13387,-0.96142>,
    /*1*/<-0.09765,-0.98372,-0.15086>,<-0.79137,0.60253,-0.10338>,<0.88173,0.37713,0.28343>,
            
    /*2*/<-0.16271,-0.98621,-0.03009>,<-0.72844,0.60844,-0.31493>,<0.85406,0.38816,0.34629>,
            
    /*3*/<-0.40287,-0.86515,0.29867>,<-0.53486,0.5303,-0.65781>,<0.86361,0.31592,0.3929>,
            
    /*4*/<-0.43144,0.68858,0.58285>

    /* stem 0.11.2*/ 
    /*0*/<0.85576,0.3983,0.33021>,
    /*1*/<-0.25112,0.86853,-0.42732>,<-0.28313,-0.19539,0.93897>,<0.50841,-0.68516,-0.52161>,
            
    /*2*/<-0.20126,0.87966,-0.43093>,<-0.05043,-0.16889,0.98434>,<0.21594,-0.8033,-0.55505>,
            
    /*3*/<0.04701,0.85786,-0.51173>,<0.14309,-0.007,0.98969>,<-0.21213,-0.83631,-0.50555>,
            
    /*4*/<-0.93178,0.3467,0.1076>

    /* stem 0.11.3*/ 
    /*0*/<0.56999,-0.57992,-0.58207>,
    /*1*/<0.46103,-0.34861,0.81604>,<-0.82467,-0.45218,-0.3398>,<0.34647,0.81826,-0.45871>,
            
    /*2*/<0.52343,-0.40348,0.75048>,<-0.83281,-0.44564,-0.32839>,<0.30147,0.86633,-0.39823>,
            
    /*3*/<0.57203,-0.38563,0.72392>,<-0.81043,-0.49617,-0.31147>,<0.22348,0.89376,-0.38892>,
            
    /*4*/<-0.59689,0.47534,0.64635>

    /* stem 0.11.4*/ 
    /*0*/<0.36411,0.77157,-0.52163>,
    /*1*/<-0.47624,-0.33721,-0.81209>,<-0.4623,0.62827,0.62574>,<0.92764,-0.31416,0.20196>,
            
    /*2*/<-0.38889,-0.2332,-0.89128>,<-0.43853,0.65843,0.61169>,<0.83151,-0.47609,0.28622>,
            
    /*3*/<-0.4358,-0.15524,-0.88655>,<-0.2115,0.85277,0.47755>,<0.6317,-0.64704,0.42695>,
            
    /*4*/<-0.78215,-0.21515,0.58477>

    /* stem 0.11.5*/ 
    /*0*/<0.88405,-0.46682,0.02295>,
    /*1*/<0.42506,0.84254,0.33085>,<-0.37622,-0.65916,0.65113>,<-0.07522,-0.16944,-0.98266>,
            
    /*2*/<0.38395,0.86239,0.32995>,<-0.34892,-0.67244,0.65274>,<-0.06154,-0.17593,-0.98248>,
            
    /*3*/<0.35274,0.86325,0.36107>,<-0.20693,-0.76654,0.60795>,<-0.1833,-0.10214,-0.97774>,
            
    /*4*/<-0.91412,0.28623,0.28714>

    /* stem 0.11.6*/ 
    /*0*/<-0.09004,-0.19263,-0.97713>,
    /*1*/<-0.01999,-0.97858,0.20487>,<-0.85095,0.52504,-0.01499>,<0.87361,0.45925,-0.16093>,
            
    /*2*/<-0.02939,-0.94473,0.32652>,<-0.86265,0.47827,-0.16461>,<0.87167,0.4707,-0.13654>,
            
    /*3*/<-0.13053,-0.75391,0.64388>,<-0.81613,0.29615,-0.49621>,<0.88774,0.4474,-0.10837>,
            
    /*4*/<-0.30927,0.79934,0.51518>

    /* stem 0.11.7*/ 
    /*0*/<0.87811,0.47474,-0.05952>,
    /*1*/<-0.41048,0.65964,-0.62959>,<-0.03253,0.16313,0.98607>,<0.41716,-0.83675,-0.35473>,
            
    /*2*/<-0.33669,0.67881,-0.65257>,<0.11263,0.19364,0.97459>,<0.19149,-0.92976,-0.31446>,
            
    /*3*/<-0.00536,0.66144,-0.74998>,<0.20604,0.29236,0.93385>,<-0.21853,-0.9468,-0.23624>,
            
    /*4*/<-0.91583,0.40051,0.02898>

    /* stem 0.11.8*/ 
    /*0*/<0.40444,-0.83432,-0.37463>,
    /*1*/<0.63261,-0.02913,0.77392>,<-0.89087,-0.44952,0.06541>,<0.2464,0.5031,-0.82835>,
            
    /*2*/<0.60277,0.01919,0.79769>,<-0.85716,-0.51355,0.03919>,<0.2383,0.5147,-0.82359>,
            
    /*3*/<0.50667,0.12254,0.85339>,<-0.78636,-0.61731,-0.02384>,<0.26279,0.51596,-0.81531>,
            
    /*4*/<-0.66435,0.72044,0.19903>

    /* stem 0.11.9*/ 
    /*0*/<0.21665,0.53501,-0.8166>,
    /*1*/<-0.57552,-0.61238,-0.542>,<-0.39959,0.80709,0.43466>,<0.9688,-0.2103,0.13114>,
            
    /*2*/<-0.60257,-0.64511,-0.46983>,<-0.36902,0.87444,0.31491>,<0.95687,-0.22843,0.17948>,
            
    /*3*/<-0.66969,-0.68336,-0.29076>,<-0.26321,0.96465,-0.01294>,<0.91572,-0.2506,0.3141>,
            
    /*4*/<-0.37266,0.13231,0.91849>

    /* stem 0.11.10*/ 
    /*0*/<0.91074,-0.36215,0.1985>,
    /*1*/<0.36813,0.92877,-0.04324>,<-0.34336,-0.36175,0.86674>,<-0.05117,-0.55652,-0.82925>,
            
    /*2*/<0.50887,0.85905,-0.05556>,<-0.28439,-0.40817,0.86748>,<-0.26912,-0.43377,-0.85989>,
            
    /*3*/<0.64593,0.75844,-0.08685>,<-0.12156,-0.46171,0.87866>,<-0.54897,-0.28335,-0.78635>,
            
    /*4*/<-0.68025,0.64872,0.34119>

    /* stem 0.11.11*/ 
    /*0*/<0.0918,-0.53191,-0.84181>,
    /*1*/<0.08349,-0.83304,0.54687>,<-0.90229,0.31983,-0.28909>,<0.81616,0.52852,-0.23355>,
            
    /*2*/<0.07144,-0.72754,0.68233>,<-0.90112,0.27388,-0.3361>,<0.83299,0.4615,-0.30518>,
            
    /*3*/<0.03051,-0.64043,0.76741>,<-0.87392,0.23233,-0.42695>,<0.84306,0.43031,-0.32261>,
            
    /*4*/<-0.17475,0.71934,0.67232>

    /* stem 0.11.12*/ 
    /*0*/<0.80613,0.51999,-0.28242>,
    /*1*/<-0.51386,0.3539,-0.78147>,<-0.01993,0.48688,0.87324>,<0.51079,-0.85562,-0.08371>,
            
    /*2*/<-0.47173,0.36661,-0.80192>,<0.12487,0.53646,0.83464>,<0.33076,-0.94371,-0.00112>,
            
    /*3*/<-0.39807,0.37673,-0.83643>,<0.42952,0.57895,0.69306>,<-0.05056,-0.98014,0.19175>,
            
    /*4*/<-0.80309,0.34577,0.48528>

    /* stem 0.11.13*/ 
    /*0*/<0.55977,-0.79357,-0.23855>,
    /*1*/<0.68588,0.29585,0.66486>,<-0.74667,-0.60069,0.28574>,<0.04494,0.32731,-0.94385>,
            
    /*2*/<0.76176,0.17366,0.62415>,<-0.78163,-0.53676,0.31772>,<0.02066,0.38389,-0.92315>,
            
    /*3*/<0.84345,0.06349,0.53344>,<-0.77906,-0.51976,0.35058>,<-0.07639,0.47978,-0.87406>,
            
    /*4*/<-0.36131,0.77274,0.52185>

    /* stem 0.11.14*/ 
    /*0*/<0.14069,0.18358,-0.97288>,
    /*1*/<-0.55405,-0.80237,-0.22189>,<-0.43626,0.89245,0.11496>,<0.98635,-0.09525,0.1343>,
            
    /*2*/<-0.57915,-0.80333,-0.13875>,<-0.40879,0.91126,-0.04992>,<0.97398,-0.0912,0.20749>,
            
    /*3*/<-0.62965,-0.77681,0.01044>,<-0.30795,0.87794,-0.36659>,<0.92722,-0.07604,0.36671>,
            
    /*4*/<-0.38555,0.40863,0.82727>

    /* stem 0.11.15*/ 
    /*0*/<0.95481,-0.29153,0.05783>,
    /*1*/<0.27904,0.86191,-0.42338>,<-0.08915,-0.06281,0.99404>,<-0.2166,-0.79094,-0.57227>,
            
    /*2*/<0.30586,0.85148,-0.42594>,<-0.00117,-0.10234,0.99475>,<-0.33738,-0.75071,-0.56799>,
            
    /*3*/<0.46177,0.74744,-0.47759>,<0.11394,-0.14418,0.98297>,<-0.6115,-0.58613,-0.53152>,
            
    /*4*/<-0.61983,0.75303,0.2208>

    /* stem 0.11.16*/ 
    /*0*/<-0.04402,-0.79804,-0.601>,
    /*1*/<0.23844,-0.58522,0.77502>,<-0.95884,0.20913,-0.19207>,<0.72162,0.39825,-0.56627>,
            
    /*2*/<0.2274,-0.54153,0.80934>,<-0.95381,0.08448,-0.28829>,<0.70907,0.47917,-0.51732>,
            
    /*3*/<0.15732,-0.41894,0.89428>,<-0.86981,-0.16464,-0.46511>,<0.68546,0.59272,-0.42289>,
            
    /*4*/<-0.52548,0.77685,0.34696>

    /* stem 0.11.17*/ 
    /*0*/<0.72722,0.32024,-0.60712>,
    /*1*/<-0.6593,0.0458,-0.75049>,<0.13561,0.792,0.59527>,<0.50372,-0.84659,0.17189>,
            
    /*2*/<-0.73463,0.05826,-0.67596>,<0.3661,0.84588,0.38788>,<0.41166,-0.85625,0.31203>,
            
    /*3*/<-0.79445,0.01602,-0.60711>,<0.59742,0.79698,0.08899>,<0.19081,-0.8118,0.55188>,
            
    /*4*/<-0.56039,0.4918,0.66641>

    /* stem 0.11.18*/ 
    /*0*/<0.47913,-0.85472,0.19972>,
    /*1*/<0.7577,0.52539,0.38713>,<-0.76253,-0.28111,0.58268>,<-0.00768,-0.22195,-0.97503>,
            
    /*2*/<0.73262,0.56194,0.38405>,<-0.7093,-0.37004,0.59997>,<-0.04276,-0.17541,-0.98357>,
            
    /*3*/<0.82007,0.44224,0.3632>,<-0.65286,-0.46092,0.60111>,<-0.1564,0.05887,-0.98594>,
            
    /*4*/<-0.36795,0.88173,0.29524>

    /* stem 0.11.19*/ 
    /*0*/<0.04012,-0.21038,-0.9768>,
    /*1*/<-0.51492,-0.84068,0.16768>,<-0.4847,0.85249,-0.19575>,<0.99871,-0.00703,0.05029>,
            
    /*2*/<-0.55811,-0.76736,0.31571>,<-0.47633,0.75575,-0.44939>,<0.99298,0.03751,0.11219>,
            
    /*3*/<-0.61422,-0.61378,0.49599>,<-0.34923,0.52236,-0.77793>,<0.95524,0.11401,0.27297>,
            
    /*4*/<-0.32524,0.81849,0.4736>

    /* stem 0.11.20*/ 
    /*0*/<0.95306,-0.27893,-0.11781>,
    /*1*/<0.1069,0.69147,-0.71445>,<0.17994,0.23589,0.95497>,<-0.30633,-0.92166,-0.23812>,
            
    /*2*/<0.14313,0.67257,-0.72607>,<0.29381,0.17616,0.93949>,<-0.46901,-0.86023,-0.20011>,
            
    /*3*/<0.30807,0.5028,-0.80764>,<0.424,0.13103,0.89613>,<-0.76989,-0.62627,-0.12274>,
            
    /*4*/<-0.46783,0.87647,0.1137>

    /* stem 0.11.21*/ 
    /*0*/<-0.09306,-0.94375,-0.31729>,
    /*1*/<0.4536,-0.31853,0.83234>,<-0.99381,0.10976,-0.01706>,<0.5418,0.22488,-0.80986>,
            
    /*2*/<0.45249,-0.21589,0.86524>,<-0.99915,0.01056,-0.03987>,<0.54172,0.21952,-0.81139>,
            
    /*3*/<0.41959,-0.08364,0.90385>,<-0.97513,-0.18822,-0.11701>,<0.54445,0.28549,-0.78872>,
            
    /*4*/<-0.31962,0.92575,0.20205>

    /* stem 0.11.22*/ 
    /*0*/<0.51855,0.21737,-0.82696>,
    /*1*/<-0.80954,-0.19418,-0.55402>,<0.15843,0.9244,0.34697>,<0.64513,-0.73273,0.21659>,
            
    /*2*/<-0.82409,-0.18981,-0.53372>,<0.29686,0.93976,0.1695>,<0.55918,-0.73203,0.38916>,
            
    /*3*/<-0.9224,-0.08738,-0.37623>,<0.50859,0.82741,-0.23817>,<0.41823,-0.69737,0.58202>,
            
    /*4*/<-0.1748,0.6194,0.76537>

    /* stem 0.11.23*/ 
    /*0*/<0.61249,-0.77944,0.13163>,
    /*1*/<0.7824,0.62236,0.02276>,<-0.48015,-0.2307,0.8463>,<-0.30754,-0.38493,-0.8702>,
            
    /*2*/<0.71502,0.69874,0.02245>,<-0.39444,-0.32153,0.86084>,<-0.32405,-0.37025,-0.87058>,
            
    /*3*/<0.63457,0.77159,0.04438>,<-0.24299,-0.50159,0.83028>,<-0.4046,-0.27384,-0.87253>,
            
    /*4*/<-0.75386,0.5971,0.27415>

    /* stem 0.11.24*/ 
    /*0*/<-0.1243,-0.51857,-0.84595>,
    /*1*/<-0.39372,-0.75614,0.52273>,<-0.59164,0.72368,-0.35532>,<0.98578,0.03425,-0.16448>,
            
    /*2*/<-0.39906,-0.66643,0.62978>,<-0.61711,0.60443,-0.50381>,<0.98858,0.06747,-0.13475>,
            
    /*3*/<-0.394,-0.59079,0.70408>,<-0.5423,0.35373,-0.76209>,<0.96163,0.27089,0.0435>,
            
    /*4*/<-0.45556,0.76945,0.44767>

    /* stem 0.12*/ 
    /*0*/<-0.34206,0.00123,0.93968>,
    /*1*/<0.94326,-0.02243,0.33128>,<0.31461,0.94381,0.10118>,<-0.74345,0.60572,-0.28353>,
            <-0.76871,-0.56947,-0.29119>,<0.27374,-0.9577,0.08879>,
    /*2*/<0.93967,-0.02269,0.34134>,<0.28836,0.94174,0.17311>,<-0.75653,0.60446,-0.24958>,
            <-0.75002,-0.5665,-0.34139>,<0.29818,-0.95421,0.02382>,
    /*3*/<0.93588,-0.02357,0.35153>,<0.23901,0.92203,0.30452>,<-0.78309,0.59582,-0.17827>,
            <-0.71693,-0.55019,-0.42814>,<0.34521,-0.93311,-0.10064>,
    /*4*/<0.95769,0.00032,0.2878>,<0.2091,0.90056,0.38113>,<-0.82458,0.56186,-0.06613>,
            <-0.71277,-0.54929,-0.43616>,<0.3878,-0.8958,-0.21715>,
    /*5*/<0.97251,0.03328,0.23047>,<0.17866,0.86928,0.46091>,<-0.85949,0.50959,0.04006>,
            <-0.70607,-0.54713,-0.44956>,<0.42601,-0.84164,-0.33191>,
    /*6*/<0.19857,0.49997,-0.84297>

    /* stem 0.12.0*/ 
    /*0*/<-0.66008,-0.48053,0.57739>,
    /*1*/<-0.69905,0.66468,-0.26368>,<0.13701,-0.82526,-0.54788>,<0.58227,0.17531,0.79387>,
            
    /*2*/<-0.67422,0.68438,-0.27757>,<0.20027,-0.78502,-0.58621>,<0.50144,0.11186,0.85793>,
            
    /*3*/<-0.79254,0.56116,-0.23868>,<0.30917,-0.72217,-0.61877>,<0.47506,0.19946,0.85705>,
            
    /*4*/<0.41634,0.71478,-0.56192>

    /* stem 0.12.1*/ 
    /*0*/<0.29446,0.09326,0.9511>,
    /*1*/<0.13897,-0.98935,0.04331>,<0.74443,0.59668,-0.29966>,<-0.89238,0.38983,0.22737>,
            
    /*2*/<0.13233,-0.99119,-0.00629>,<0.77371,0.60526,-0.18717>,<-0.90513,0.39198,0.16461>,
            
    /*3*/<0.11096,-0.96089,-0.25374>,<0.81274,0.58137,0.03819>,<-0.9169,0.3617,0.16872>,
            
    /*4*/<-0.09451,0.41378,-0.90546>

    /* stem 0.12.2*/ 
    /*0*/<-0.85024,0.42034,0.31688>,
    /*1*/<0.49692,0.85029,0.17342>,<-0.40575,-0.16747,-0.89851>,<-0.06532,-0.6956,0.71546>,
            
    /*2*/<0.37948,0.89059,0.25068>,<-0.46695,-0.15842,-0.86998>,<0.13753,-0.76197,0.63284>,
            
    /*3*/<0.12154,0.88586,0.44775>,<-0.55775,-0.10699,-0.82309>,<0.49152,-0.78061,0.38607>,
            
    /*4*/<0.70166,0.40915,-0.58333>

    /* stem 0.12.3*/ 
    /*0*/<0.01242,-0.72693,0.6866>,
    /*1*/<-0.89021,-0.31352,-0.33051>,<0.83941,-0.35802,-0.40892>,<0.05043,0.69353,0.71866>,
            
    /*2*/<-0.88708,-0.25976,-0.3816>,<0.83723,-0.39754,-0.37551>,<0.04885,0.67764,0.73377>,
            
    /*3*/<-0.85981,-0.18667,-0.47526>,<0.83145,-0.4869,-0.26762>,<0.03846,0.69131,0.72154>,
            
    /*4*/<0.28066,0.66461,-0.69247>

    /* stem 0.12.4*/ 
    /*0*/<-0.07836,0.54497,0.83479>,
    /*1*/<0.87617,-0.36845,0.31075>,<-0.02387,0.83054,-0.55645>,<-0.84994,-0.47849,0.22057>,
            
    /*2*/<0.89261,-0.37374,0.25214>,<-0.09018,0.95681,-0.27636>,<-0.84887,-0.52858,0.00407>,
            
    /*3*/<0.91927,-0.37475,0.12042>,<-0.14428,0.98787,0.05749>,<-0.76697,-0.60845,-0.20384>,
            
    /*4*/<0.1303,0.14776,-0.9804>

    /* stem 0.12.5*/ 
    /*0*/<-0.82838,-0.45063,0.33274>,
    /*1*/<-0.48466,0.87301,-0.0543>,<0.02437,-0.60837,-0.79328>,<0.48512,-0.25114,0.83761>,
            
    /*2*/<-0.4496,0.89028,-0.07252>,<-0.0367,-0.6396,-0.76784>,<0.51,-0.24074,0.8258>,
            
    /*3*/<-0.48477,0.87322,-0.04977>,<-0.15955,-0.74062,-0.65271>,<0.70355,-0.12521,0.69953>,
            
    /*4*/<0.53418,0.37473,-0.75778>

    /* stem 0.12.6*/ 
    /*0*/<0.43164,-0.24697,0.86758>,
    /*1*/<-0.1354,-0.96625,-0.21914>,<0.83413,0.46699,-0.2935>,<-0.71158,0.50662,0.48681>,
            
    /*2*/<-0.17252,-0.9301,-0.32427>,<0.88527,0.42417,-0.19073>,<-0.71234,0.50931,0.48288>,
            
    /*3*/<-0.19225,-0.8666,-0.46049>,<0.94228,0.31697,0.10791>,<-0.73415,0.58436,0.34576>,
            
    /*4*/<0.15417,0.46341,-0.87263>

    /* stem 0.12.7*/ 
    /*0*/<-0.69468,0.4356,0.57243>,
    /*1*/<0.70068,0.61133,0.36787>,<-0.50433,0.25655,-0.82452>,<-0.17577,-0.88078,0.43969>,
            
    /*2*/<0.71651,0.60682,0.34406>,<-0.65594,0.31998,-0.68363>,<-0.07832,-0.94915,0.30494>,
            
    /*3*/<0.7571,0.60057,0.25711>,<-0.90035,0.38534,-0.2022>,<0.05445,-0.9966,-0.06178>,
            
    /*4*/<-0.00073,0.28007,-0.95998>

    /* stem 0.12.8*/ 
    /*0*/<-0.24775,-0.77324,0.58371>,
    /*1*/<-0.92944,0.0331,-0.36747>,<0.69772,-0.55384,-0.45437>,<0.23903,0.54353,0.80464>,
            
    /*2*/<-0.88404,0.15172,-0.44209>,<0.68339,-0.58444,-0.4375>,<0.19672,0.46561,0.86285>,
            
    /*3*/<-0.81389,0.21484,-0.53984>,<0.69729,-0.61456,-0.36891>,<0.13,0.42237,0.89705>,
            
    /*4*/<0.46133,0.76683,-0.44626>

    /* stem 0.12.9*/ 
    /*0*/<0.17579,0.44009,0.88058>,
    /*1*/<0.73219,-0.659,0.17212>,<0.19949,0.85523,-0.47831>,<-0.93682,-0.2091,0.28045>,
            
    /*2*/<0.73101,-0.65611,0.18746>,<0.16769,0.95903,-0.22835>,<-0.96357,-0.2673,-0.00909>,
            
    /*3*/<0.80821,-0.5823,0.08793>,<0.08848,0.96871,0.23188>,<-0.87712,-0.35571,-0.3227>,
            
    /*4*/<0.22673,0.40498,-0.88577>

    /* stem 0.12.10*/ 
    /*0*/<-0.88012,-0.30375,0.36488>,
    /*1*/<-0.23249,0.95092,0.20423>,<-0.22515,-0.38884,-0.89337>,<0.48326,-0.55324,0.67852>,
            
    /*2*/<-0.30232,0.92199,0.24195>,<-0.24012,-0.39622,-0.8862>,<0.57096,-0.51359,0.64049>,
            
    /*3*/<-0.39487,0.86748,0.30259>,<-0.31201,-0.43513,-0.84458>,<0.73535,-0.42358,0.52901>,
            
    /*4*/<0.59695,0.53691,-0.59614>

    /* stem 0.12.11*/ 
    /*0*/<0.4871,-0.57396,0.65826>,
    /*1*/<-0.40086,-0.81135,-0.42547>,<0.8674,0.36494,-0.33829>,<-0.48062,0.46301,0.74473>,
            
    /*2*/<-0.42661,-0.7579,-0.49356>,<0.93806,0.26249,-0.22616>,<-0.50017,0.51206,0.6983>,
            
    /*3*/<-0.42617,-0.65,-0.62919>,<0.99714,0.03565,0.0666>,<-0.53926,0.63,0.55883>,
            
    /*4*/<0.23339,0.65766,-0.71625>

    /* stem 0.12.12*/ 
    /*0*/<-0.52358,0.35316,0.77533>,
    /*1*/<0.85301,0.30018,0.42693>,<-0.48995,0.61117,-0.62163>,<-0.34799,-0.92151,0.17238>,
            
    /*2*/<0.79403,0.32733,0.51223>,<-0.49188,0.61268,-0.61861>,<-0.27961,-0.95572,0.09174>,
            
    /*3*/<0.71865,0.36748,0.59035>,<-0.65418,0.59401,-0.4682>,<-0.07913,-0.98143,-0.17473>,
            
    /*4*/<0.52084,0.30846,-0.79598>

    /* stem 0.12.13*/ 
    /*0*/<-0.41076,-0.87503,0.25613>,
    /*1*/<-0.89911,0.36014,-0.24881>,<0.5641,-0.45549,-0.68871>,<0.34677,0.1204,0.93019>,
            
    /*2*/<-0.95508,0.21748,-0.20132>,<0.57706,-0.39925,-0.71247>,<0.36632,0.20736,0.90709>,
            
    /*3*/<-0.99507,0.02755,-0.09524>,<0.56459,-0.28889,-0.77316>,<0.42987,0.28651,0.85622>,
            
    /*4*/<-0.01799,0.95203,-0.30547>

    /* stem 0.12.14*/ 
    /*0*/<0.39965,0.1935,0.89601>,
    /*1*/<0.53174,-0.84438,-0.06542>,<0.37269,0.85469,-0.3614>,<-0.91581,-0.01582,0.40131>,
            
    /*2*/<0.43975,-0.83573,-0.3289>,<0.50759,0.84611,-0.16263>,<-0.90484,-0.02108,0.42523>,
            
    /*3*/<0.23942,-0.65465,-0.71702>,<0.64478,0.74125,0.18658>,<-0.87503,-0.07765,0.4778>,
            
    /*4*/<-0.42666,0.73107,-0.53244>

    /* stem 0.12.15*/ 
    /*0*/<-0.95226,-0.02439,0.30432>,
    /*1*/<0.09152,0.93929,0.33069>,<-0.28684,-0.17246,-0.94233>,<0.22224,-0.76614,0.60303>,
            
    /*2*/<-0.12656,0.88096,0.45595>,<-0.30291,-0.17977,-0.93591>,<0.48923,-0.68787,0.53617>,
            
    /*3*/<-0.31611,0.77157,0.55204>,<-0.35319,-0.12988,-0.92649>,<0.68811,-0.62712,0.365>,
            
    /*4*/<0.74173,0.56558,-0.36049>

    /* stem 0.12.16*/ 
    /*0*/<0.34242,-0.74539,0.57196>,
    /*1*/<-0.67306,-0.61353,-0.413>,<0.90222,0.10632,-0.41796>,<-0.23878,0.52816,0.81488>,
            
    /*2*/<-0.685,-0.56359,-0.46167>,<0.94472,-0.00611,-0.32783>,<-0.2492,0.58685,0.77039>,
            
    /*3*/<-0.67247,-0.43855,-0.5962>,<0.96873,-0.21579,-0.12248>,<-0.28224,0.66243,0.69392>,
            
    /*4*/<0.24106,0.73094,-0.63844>

    /* stem 0.12.17*/ 
    /*0*/<-0.22249,0.47581,0.85094>,
    /*1*/<0.9731,0.02622,0.22888>,<-0.40846,0.74149,-0.53231>,<-0.55845,-0.78095,0.27975>,
            
    /*2*/<0.97177,0.02844,0.23421>,<-0.48933,0.80718,-0.33017>,<-0.52734,-0.84774,0.05697>,
            
    /*3*/<0.95522,0.0179,0.29536>,<-0.55606,0.83097,-0.01702>,<-0.40413,-0.85812,-0.31672>,
            
    /*4*/<0.33748,0.34672,-0.87516>

    /* stem 0.12.18*/ 
    /*0*/<-0.55475,-0.80689,0.20294>,
    /*1*/<-0.81275,0.58102,0.04302>,<0.28186,-0.40154,-0.87139>,<0.54622,-0.15719,0.82276>,
            
    /*2*/<-0.88804,0.45478,0.06753>,<0.31796,-0.31832,-0.89307>,<0.56554,-0.11011,0.81734>,
            
    /*3*/<-0.96421,0.20833,0.16398>,<0.32817,-0.26609,-0.90637>,<0.64527,0.09405,0.75814>,
            
    /*4*/<0.00757,0.94363,-0.33092>

    /* stem 0.12.19*/ 
    /*0*/<0.40333,-0.17659,0.89785>,
    /*1*/<0.27843,-0.90786,-0.31349>,<0.60929,0.78227,-0.1297>,<-0.89843,0.13027,0.41936>,
            
    /*2*/<0.20938,-0.82231,-0.52912>,<0.7125,0.70066,0.03773>,<-0.89135,0.11966,0.43724>,
            
    /*3*/<0.16111,-0.71574,-0.67953>,<0.726,0.65189,0.21901>,<-0.89349,0.07918,0.44206>,
            
    /*4*/<-0.33438,0.57345,-0.74789>

    /* stem 0.12.20*/ 
    /*0*/<-0.71499,-0.02423,0.69871>,
    /*1*/<0.39147,0.81992,0.41772>,<-0.69217,0.08586,-0.71661>,<0.31764,-0.9052,0.28234>,
            
    /*2*/<0.40188,0.82086,0.40582>,<-0.72514,0.08411,-0.68345>,<0.33822,-0.9046,0.25943>,
            
    /*3*/<0.29711,0.80874,0.50761>,<-0.72737,0.07774,-0.68183>,<0.45418,-0.87357,0.17492>,
            
    /*4*/<0.68749,0.34951,-0.63655>

    /* stem 0.12.21*/ 
    /*0*/<0.26132,-0.94468,0.19822>,
    /*1*/<-0.86338,-0.31442,-0.3946>,<0.80583,0.10795,-0.58223>,<0.05222,0.22577,0.97278>,
            
    /*2*/<-0.87996,-0.22492,-0.41843>,<0.82353,0.01573,-0.56706>,<0.05267,0.2267,0.97254>,
            
    /*3*/<-0.87766,-0.19117,-0.43952>,<0.84695,-0.05683,-0.52862>,<0.02653,0.26708,0.96331>,
            
    /*4*/<-0.1293,0.94665,-0.29518>

    /* stem 0.12.22*/ 
    /*0*/<0.04358,0.37701,0.92519>,
    /*1*/<0.96003,-0.27334,0.06022>,<-0.2417,0.9005,-0.3615>,<-0.71905,-0.63337,0.28602>,
            
    /*2*/<0.9614,-0.27218,0.04038>,<-0.26416,0.95618,-0.12628>,<-0.74489,-0.66307,0.07409>,
            
    /*3*/<0.96602,-0.23837,-0.09996>,<-0.24851,0.94538,0.21095>,<-0.70699,-0.69597,-0.12567>,
            
    /*4*/<-0.14372,0.2934,-0.94512>

    /* stem 0.12.23*/ 
    /*0*/<-0.73374,-0.66424,0.1429>,
    /*1*/<-0.60665,0.73916,0.29263>,<0.04797,-0.25468,-0.96584>,<0.56758,-0.47642,0.67148>,
            
    /*2*/<-0.63733,0.70994,0.29966>,<0.05113,-0.25117,-0.96659>,<0.59438,-0.44977,0.66665>,
            
    /*3*/<-0.7098,0.63358,0.30784>,<0.11025,-0.18273,-0.97696>,<0.60614,-0.44024,0.66241>,
            
    /*4*/<0.6132,0.78992,0.00467>

    /* stem 0.12.24*/ 
    /*0*/<0.61816,-0.41844,0.66542>,
    /*1*/<-0.02813,-0.85583,-0.51649>,<0.69168,0.69006,-0.21306>,<-0.66904,0.16948,0.72364>,
            
    /*2*/<-0.14078,-0.76806,-0.62471>,<0.7408,0.64795,-0.17714>,<-0.61626,0.11035,0.77977>,
            
    /*3*/<-0.30775,-0.56162,-0.76803>,<0.81178,0.5754,-0.09965>,<-0.51697,-0.01315,0.8559>,
            
    /*4*/<-0.5381,0.81439,-0.21731>

    /* stem 0.12.25*/ 
    /*0*/<-0.69667,0.19164,0.69132>,
    /*1*/<0.65049,0.57647,0.49451>,<-0.58743,0.39933,-0.7039>,<-0.0613,-0.97628,0.20764>,
            
    /*2*/<0.61569,0.56892,0.54521>,<-0.70988,0.38443,-0.59016>,<0.0943,-0.9954,0.01707>,
            
    /*3*/<0.55959,0.53484,0.63309>,<-0.87496,0.34276,-0.34201>,<0.3155,-0.89574,-0.31322>,
            
    /*4*/<0.35976,0.5783,-0.73221>

    /* stem 0.13*/ 
    /*0*/<-0.3425,-0.02447,-0.9392>,
    /*1*/<-0.93546,0.02137,0.35278>,<-0.27549,0.95729,0.08771>,<0.77063,0.57066,-0.2837>,
            <0.75718,-0.60422,-0.24818>,<-0.29724,-0.9437,0.14518>,
    /*2*/<-0.93786,0.02116,0.34637>,<-0.29531,0.95481,0.03365>,<0.76119,0.56924,-0.31072>,
            <0.77058,-0.60143,-0.21092>,<-0.27933,-0.94017,0.19508>,
    /*3*/<-0.94071,0.02051,0.33859>,<-0.32643,0.94381,-0.05158>,<0.74443,0.56507,-0.35569>,
            <0.79131,-0.59179,-0.15369>,<-0.25003,-0.9283,0.27523>,
    /*4*/<-0.94573,0.01752,0.32449>,<-0.3544,0.92577,-0.13168>,<0.73197,0.55785,-0.39118>,
            <0.81135,-0.57667,-0.09573>,<-0.22537,-0.91058,0.34649>,
    /*5*/<-0.93351,0.02959,0.35734>,<-0.37582,0.90696,-0.19019>,<0.70675,0.53649,-0.46117>,
            <0.81716,-0.57078,-0.08037>,<-0.1963,-0.88359,0.42513>,
    /*6*/<0.37956,0.36192,0.85144>

    /* stem 0.13.0*/ 
    /*0*/<0.11636,-0.51634,-0.84844>,
    /*1*/<0.72578,0.63157,-0.27271>,<0.22132,-0.81363,0.53761>,<-0.95069,0.19797,-0.23875>,
            
    /*2*/<0.70917,0.54939,-0.44187>,<0.21724,-0.82744,0.51783>,<-0.94162,0.33052,-0.06406>,
            
    /*3*/<0.61191,0.45437,-0.64739>,<0.28874,-0.84038,0.45869>,<-0.89031,0.40466,0.20881>,
            
    /*4*/<0.46665,0.53177,0.70672>

    /* stem 0.13.1*/ 
    /*0*/<-0.91572,0.12823,-0.3808>,
    /*1*/<-0.16501,-0.98189,0.09305>,<-0.2169,0.61718,0.75633>,<0.41005,0.36077,-0.83768>,
            
    /*2*/<-0.03517,-0.98092,0.19118>,<-0.43541,0.6151,0.65733>,<0.46017,0.37366,-0.80537>,
            
    /*3*/<0.1546,-0.91641,0.36918>,<-0.68607,0.58867,0.42753>,<0.54364,0.33509,-0.76953>,
            
    /*4*/<0.61584,0.46392,0.6368>

    /* stem 0.13.2*/ 
    /*0*/<0.47446,0.38027,-0.7939>,
    /*1*/<-0.46463,0.8722,0.15293>,<0.8751,-0.1853,0.44705>,<-0.42497,-0.69852,-0.57573>,
            
    /*2*/<-0.36577,0.92013,-0.13993>,<0.87586,-0.18299,0.44653>,<-0.60939,-0.72357,-0.32419>,
            
    /*3*/<-0.21655,0.82467,-0.52253>,<0.90375,-0.13927,0.40477>,<-0.72329,-0.67639,0.13914>,
            
    /*4*/<-0.1961,0.61403,0.76453>

    /* stem 0.13.3*/ 
    /*0*/<-0.47082,-0.76256,-0.44365>,
    /*1*/<0.88362,-0.3539,-0.30656>,<-0.36816,-0.27593,0.88788>,<-0.50111,0.65306,-0.5678>,
            
    /*2*/<0.84224,-0.42033,-0.33757>,<-0.31973,-0.2112,0.92367>,<-0.503,0.64989,-0.56976>,
            
    /*3*/<0.79025,-0.46152,-0.40311>,<-0.25344,-0.18069,0.95032>,<-0.51888,0.66452,-0.53775>,
            
    /*4*/<0.60202,0.72812,0.32774>

    /* stem 0.13.4*/ 
    /*0*/<-0.46054,0.67837,-0.57247>,
    /*1*/<-0.88201,-0.32886,0.33751>,<0.48323,0.72604,0.48924>,<0.41274,-0.41774,-0.80941>,
            
    /*2*/<-0.932,-0.25679,0.25579>,<0.47731,0.73783,0.47726>,<0.46189,-0.51471,-0.72231>,
            
    /*3*/<-0.96575,-0.16747,0.19822>,<0.44668,0.89268,0.05995>,<0.67535,-0.67882,-0.28827>,
            
    /*4*/<0.17352,0.24875,0.9529>

    /* stem 0.13.5*/ 
    /*0*/<0.48299,-0.49719,-0.72078>,
    /*1*/<0.4424,0.85271,-0.2778>,<0.4234,-0.57881,0.69693>,<-0.88037,-0.25891,-0.39739>,
            
    /*2*/<0.46276,0.82267,-0.33026>,<0.45112,-0.62878,0.63335>,<-0.94286,-0.18142,-0.27948>,
            
    /*3*/<0.48359,0.76175,-0.43113>,<0.49272,-0.61651,0.61412>,<-0.979,-0.12859,-0.15817>,
            
    /*4*/<-0.22659,0.64277,0.73178>

    /* stem 0.13.6*/ 
    /*0*/<-0.88459,-0.20774,-0.41754>,
    /*1*/<0.20089,-0.97601,0.08391>,<-0.45522,0.48276,0.74814>,<0.28083,0.49947,-0.81955>,
            
    /*2*/<0.35873,-0.92181,0.14689>,<-0.5002,0.46138,0.73275>,<0.18431,0.45279,-0.87236>,
            
    /*3*/<0.53532,-0.81022,0.23871>,<-0.59624,0.42041,0.68392>,<0.08245,0.40521,-0.9105>,
            
    /*4*/<0.70734,0.62343,0.33317>

    /* stem 0.13.7*/ 
    /*0*/<0.19518,0.44154,-0.87576>,
    /*1*/<-0.74345,0.64641,0.17159>,<0.92468,0.20505,0.32083>,<-0.18706,-0.86464,-0.46626>,
            
    /*2*/<-0.73644,0.67422,0.0555>,<0.94632,0.22002,0.23677>,<-0.23104,-0.93738,-0.26066>,
            
    /*3*/<-0.69021,0.68855,-0.22253>,<0.94277,0.27761,0.18471>,<-0.27669,-0.95932,0.05602>,
            
    /*4*/<-0.28827,0.24838,0.92478>

    /* stem 0.13.8*/ 
    /*0*/<-0.17856,-0.86884,-0.46177>,
    /*1*/<0.94576,-0.01041,-0.32471>,<-0.23007,-0.41033,0.88244>,<-0.71039,0.44652,-0.54403>,
            
    /*2*/<0.96403,0.05459,-0.26013>,<-0.26361,-0.58109,0.76996>,<-0.70734,0.5218,-0.47686>,
            
    /*3*/<0.96019,0.02476,-0.27826>,<-0.30097,-0.67163,0.677>,<-0.64252,0.6633,-0.38366>,
            
    /*4*/<0.32732,0.63736,0.6976>

    /* stem 0.13.9*/ 
    /*0*/<-0.6959,0.51244,-0.50313>,
    /*1*/<-0.69793,-0.62673,0.34656>,<0.23995,0.81877,0.52158>,<0.47851,-0.20716,-0.85329>,
            
    /*2*/<-0.59199,-0.66506,0.45524>,<0.0372,0.92313,0.38268>,<0.54935,-0.21933,-0.80629>,
            
    /*3*/<-0.48383,-0.70385,0.52009>,<-0.24555,0.96822,0.04739>,<0.78811,-0.23676,-0.56818>,
            
    /*4*/<0.42581,0.27491,0.86204>

    /* stem 0.13.10*/ 
    /*0*/<0.53745,-0.27753,-0.79632>,
    /*1*/<0.10789,0.96215,-0.25025>,<0.66186,-0.43494,0.61055>,<-0.7855,-0.51908,-0.33697>,
            
    /*2*/<0.11479,0.94261,-0.31353>,<0.72012,-0.54768,0.426>,<-0.89809,-0.4377,-0.04309>,
            
    /*3*/<0.05004,0.82181,-0.56756>,<0.82993,-0.51647,0.21089>,<-0.89496,-0.2701,0.35509>,
            
    /*4*/<0.21721,0.70449,0.67566>

    /* stem 0.13.11*/ 
    /*0*/<-0.8303,-0.50571,-0.23422>,
    /*1*/<0.52534,-0.85074,0.01602>,<-0.43015,0.3377,0.83722>,<-0.071,0.52778,-0.84641>,
            
    /*2*/<0.48293,-0.87565,0.00293>,<-0.42121,0.34185,0.84007>,<-0.03603,0.54594,-0.83705>,
            
    /*3*/<0.53742,-0.84331,0.0038>,<-0.52193,0.24486,0.81709>,<0.00132,0.60555,-0.79581>,
            
    /*4*/<0.68941,0.56359,0.45506>

    /* stem 0.13.12*/ 
    /*0*/<-0.10082,0.36436,-0.92578>,
    /*1*/<-0.90467,0.34798,0.24592>,<0.81039,0.56753,0.14555>,<0.09721,-0.92607,-0.36462>,
            
    /*2*/<-0.90489,0.34967,0.24271>,<0.79457,0.59888,-0.09999>,<0.17189,-0.97658,-0.1294>,
            
    /*3*/<-0.91591,0.33157,0.22621>,<0.66291,0.58225,-0.47067>,<0.28897,-0.91923,0.26744>,
            
    /*4*/<0.34853,0.52,0.77982>

    /* stem 0.13.13*/ 
    /*0*/<0.06886,-0.83592,-0.54451>,
    /*1*/<0.8696,0.32515,-0.37158>,<-0.01347,-0.53845,0.84255>,<-0.85812,0.23737,-0.45529>,
            
    /*2*/<0.86865,0.39057,-0.3048>,<0.00187,-0.67287,0.73976>,<-0.86869,0.28444,-0.40555>,
            
    /*3*/<0.88272,0.36879,-0.29122>,<-0.02382,-0.69091,0.72255>,<-0.85366,0.33465,-0.39908>,
            
    /*4*/<-0.01738,0.80528,0.59264>

    /* stem 0.13.14*/ 
    /*0*/<-0.83851,0.22691,-0.49539>,
    /*1*/<-0.41966,-0.83954,0.34506>,<-0.07053,0.84713,0.52668>,<0.51421,-0.0141,-0.85755>,
            
    /*2*/<-0.33261,-0.84082,0.42707>,<-0.26671,0.87638,0.40102>,<0.59458,-0.00468,-0.80402>,
            
    /*3*/<-0.26958,-0.84593,0.46014>,<-0.50465,0.85579,0.1138>,<0.82422,0.01808,-0.56598>,
            
    /*4*/<0.35733,0.28459,0.88957>

    /* stem 0.13.15*/ 
    /*0*/<0.33509,-0.06611,-0.93986>,
    /*1*/<-0.21822,0.96642,-0.13568>,<0.89872,-0.26528,0.34919>,<-0.69005,-0.69926,-0.18673>,
            
    /*2*/<-0.17698,0.95128,-0.25247>,<0.88292,-0.25246,0.39587>,<-0.71871,-0.68424,-0.12356>,
            
    /*3*/<-0.11673,0.90188,-0.41592>,<0.88169,-0.28264,0.3778>,<-0.78349,-0.61763,0.06842>,
            
    /*4*/<-0.12676,0.46557,0.87589>

    /* stem 0.13.16*/ 
    /*0*/<-0.57677,-0.70528,-0.4122>,
    /*1*/<0.79026,-0.6117,-0.03623>,<-0.5832,0.01564,0.81218>,<-0.19073,0.61604,-0.76428>,
            
    /*2*/<0.82722,-0.56112,0.02931>,<-0.72216,-0.15961,0.67306>,<-0.14421,0.72448,-0.67404>,
            
    /*3*/<0.86246,-0.48566,0.14249>,<-0.80764,-0.22035,0.54696>,<-0.05335,0.73097,-0.68032>,
            
    /*4*/<0.28653,0.75515,0.58961>

    /* stem 0.13.17*/ 
    /*0*/<-0.2767,0.37372,-0.88531>,
    /*1*/<-0.95068,0.00578,0.31013>,<0.58402,0.79507,0.16365>,<0.37442,-0.81133,-0.44895>,
            
    /*2*/<-0.96255,0.01282,0.27079>,<0.56457,0.82352,0.05552>,<0.42204,-0.85452,-0.30277>,
            
    /*3*/<-0.9769,0.02448,0.2123>,<0.51367,0.80301,-0.30218>,<0.54236,-0.83245,0.11348>,
            
    /*4*/<0.1631,0.52099,0.83784>

    /* stem 0.13.18*/ 
    /*0*/<0.2025,-0.70303,-0.68172>,
    /*1*/<0.67379,0.61069,-0.41601>,<0.27411,-0.62039,0.73483>,<-0.95355,0.02929,-0.29982>,
            
    /*2*/<0.67775,0.58722,-0.44253>,<0.27986,-0.6638,0.69357>,<-0.96831,0.09569,-0.23068>,
            
    /*3*/<0.67268,0.51989,-0.52652>,<0.29661,-0.71418,0.63401>,<-0.97194,0.21738,-0.08992>,
            
    /*4*/<0.16628,0.67149,0.72212>

    /* stem 0.13.19*/ 
    /*0*/<-0.92157,-0.06083,-0.38342>,
    /*1*/<-0.07364,-0.93435,0.34866>,<-0.27938,0.77072,0.57266>,<0.37787,0.16527,-0.91099>,
            
    /*2*/<-0.04387,-0.92196,0.38478>,<-0.52771,0.74938,0.39994>,<0.55922,0.24354,-0.79244>,
            
    /*3*/<0.02657,-0.8048,0.59295>,<-0.81546,0.5769,0.04697>,<0.75973,0.23562,-0.60605>,
            
    /*4*/<0.27317,0.70611,0.65329>

    /* stem 0.13.20*/ 
    /*0*/<0.24495,0.03807,-0.96879>,
    /*1*/<-0.55213,0.82789,-0.09879>,<0.96445,0.06979,0.25488>,<-0.41822,-0.89859,-0.13278>,
            
    /*2*/<-0.48362,0.8017,-0.35127>,<0.93921,0.0979,0.32908>,<-0.49078,-0.87128,0.00299>,
            
    /*3*/<-0.34017,0.62438,-0.70316>,<0.90915,0.10947,0.40182>,<-0.61367,-0.72693,0.30818>,
            
    /*4*/<-0.31664,0.76168,0.56532>

    /* stem 0.13.21*/ 
    /*0*/<-0.42815,-0.85392,-0.2958>,
    /*1*/<0.90097,-0.35948,-0.24295>,<-0.35846,-0.13229,0.92412>,<-0.53362,0.50949,-0.67503>,
            
    /*2*/<0.89092,-0.37824,-0.25137>,<-0.37914,-0.1673,0.91009>,<-0.50474,0.56484,-0.65283>,
            
    /*3*/<0.85183,-0.43797,-0.28733>,<-0.36222,-0.17073,0.91632>,<-0.47718,0.62271,-0.6201>,
            
    /*4*/<0.57101,0.75658,0.31864>

    /* stem 0.13.22*/ 
    /*0*/<-0.55326,0.31021,-0.77309>,
    /*1*/<-0.82782,-0.27307,0.49005>,<0.36735,0.92299,0.11466>,<0.4697,-0.65509,-0.5918>,
            
    /*2*/<-0.70428,-0.2909,0.64758>,<0.21406,0.97631,-0.03163>,<0.4803,-0.65478,-0.58359>,
            
    /*3*/<-0.52585,-0.31946,0.78831>,<-0.0392,0.96139,-0.27239>,<0.57993,-0.62813,-0.51878>,
            
    /*4*/<0.72914,0.34597,0.59047>

    /* stem 0.13.23*/ 
    /*0*/<0.20288,-0.5946,-0.778>,
    /*1*/<0.37422,0.7834,-0.49623>,<0.59508,-0.55324,0.58292>,<-0.97163,-0.22333,-0.07777>,
            
    /*2*/<0.38193,0.67648,-0.62968>,<0.59566,-0.54944,0.58592>,<-0.99402,-0.10374,0.03418>,
            
    /*3*/<0.36131,0.60471,-0.70977>,<0.62352,-0.58971,0.51329>,<-0.97885,-0.00906,0.20437>,
            
    /*4*/<0.16334,0.66657,0.72733>

    /* stem 0.13.24*/ 
    /*0*/<-0.92512,-0.31858,-0.20653>,
    /*1*/<0.25897,-0.92451,0.27966>,<-0.36811,0.64133,0.67319>,<0.11693,0.28586,-0.95111>,
            
    /*2*/<0.46281,-0.80141,0.37888>,<-0.58941,0.49597,0.63766>,<0.1205,0.29046,-0.94927>,
            
    /*3*/<0.64159,-0.58839,0.4921>,<-0.8435,0.29596,0.44824>,<0.19753,0.29911,-0.93355>,
            
    /*4*/<0.37511,0.83771,0.39691>

    /* stem 0.13.25*/ 
    /*0*/<0.18664,0.32922,-0.92562>,
    /*1*/<-0.7679,0.6365,0.07215>,<0.91459,0.28537,0.28651>,<-0.147,-0.92242,-0.35712>,
            
    /*2*/<-0.76073,0.6475,-0.04508>,<0.936,0.28878,0.20126>,<-0.18991,-0.97088,-0.14607>,
            
    /*3*/<-0.72864,0.61628,-0.29879>,<0.94976,0.30565,0.06733>,<-0.24328,-0.93921,0.24229>,
            
    /*4*/<-0.16196,0.45875,0.87368>

    /* stem 0.14*/ 
    /*0*/<0.86264,-0.08355,0.49888>,
    /*1*/<0.48991,-0.00893,-0.87173>,<0.21802,0.94553,-0.24175>,<-0.3689,0.59463,0.71437>,
            <-0.45976,-0.5767,0.67531>,<0.07102,-0.94971,-0.30496>,
    /*2*/<0.50406,-0.011,-0.8636>,<0.2997,0.93407,-0.19415>,<-0.3334,0.58916,0.73603>,
            <-0.51813,-0.56642,0.64087>,<-0.00052,-0.93757,-0.34779>,
    /*3*/<0.48435,-0.00299,-0.87487>,<0.39469,0.90832,-0.13848>,<-0.25377,0.56921,0.78205>,
            <-0.56405,-0.55242,0.61374>,<-0.10774,-0.90578,-0.40983>,
    /*4*/<0.42229,0.03164,-0.90591>,<0.51354,0.85482,-0.07455>,<-0.11952,0.50229,0.8564>,
            <-0.59808,-0.53624,0.59561>,<-0.26434,-0.82859,-0.49353>,
    /*5*/<0.3763,0.07421,-0.92352>,<0.65444,0.75608,-0.00806>,<0.016,0.4026,0.91523>,
            <-0.65546,-0.49722,0.56846>,<-0.43261,-0.70065,-0.56739>,
    /*6*/<-0.6929,0.6901,-0.20894>

    /* stem 0.14.0*/ 
    /*0*/<0.46916,-0.51601,0.71668>,
    /*1*/<-0.33808,0.65338,0.67734>,<-0.54645,-0.80373,-0.23539>,<0.86999,0.16635,-0.46417>,
            
    /*2*/<-0.32892,0.64227,0.69231>,<-0.56314,-0.78399,-0.26121>,<0.87732,0.15781,-0.45321>,
            
    /*3*/<-0.28189,0.53802,0.7944>,<-0.63123,-0.68159,-0.37013>,<0.88558,0.16193,-0.43536>,
            
    /*4*/<-0.3763,0.78575,-0.49092>

    /* stem 0.14.1*/ 
    /*0*/<0.9235,0.07993,-0.37519>,
    /*1*/<0.00118,-0.9838,-0.17924>,<-0.34692,0.63364,-0.69148>,<0.31722,0.3477,0.88232>,
            
    /*2*/<0.0136,-0.98338,-0.18107>,<-0.14046,0.67089,-0.72813>,<0.09332,0.35739,0.92928>,
            
    /*3*/<-0.09785,-0.95401,-0.28337>,<0.32567,0.6574,-0.67953>,<-0.214,0.32211,0.9222>,
            
    /*4*/<-0.83375,0.35577,-0.42224>

    /* stem 0.14.2*/ 
    /*0*/<0.21672,0.34943,0.91156>,
    /*1*/<0.31464,0.85438,-0.41358>,<-0.96028,-0.10656,0.25789>,<0.63897,-0.75858,0.12761>,
            
    /*2*/<0.39573,0.87425,-0.28123>,<-0.92252,-0.11166,0.36945>,<0.54562,-0.82139,-0.16621>,
            
    /*3*/<0.50397,0.85754,-0.10312>,<-0.80006,-0.06529,0.59635>,<0.2735,-0.80573,-0.52536>,
            
    /*4*/<-0.66909,0.38317,-0.63679>

    /* stem 0.14.3*/ 
    /*0*/<0.66744,-0.73674,0.10833>,
    /*1*/<-0.50297,-0.32397,0.80129>,<-0.23961,-0.33707,-0.91048>,<0.72211,0.68363,0.10587>,
            
    /*2*/<-0.50596,-0.3203,0.80088>,<-0.24794,-0.32727,-0.91182>,<0.73395,0.67061,0.1077>,
            
    /*3*/<-0.51325,-0.30717,0.80139>,<-0.21533,-0.36858,-0.90431>,<0.70942,0.69833,0.0952>,
            
    /*4*/<-0.70766,0.67983,-0.19246>

    /* stem 0.14.4*/ 
    /*0*/<0.83135,0.50481,0.23244>,
    /*1*/<0.43483,-0.35522,-0.82749>,<-0.52036,0.85321,-0.03564>,<0.06017,-0.51339,0.85604>,
            
    /*2*/<0.42308,-0.35629,-0.8331>,<-0.3492,0.93611,0.04187>,<-0.1143,-0.57101,0.81295>,
            
    /*3*/<0.36857,-0.33469,-0.86726>,<0.04063,0.97406,0.22261>,<-0.43175,-0.60575,0.66832>,
            
    /*4*/<-0.81889,0.37028,-0.43853>

    /* stem 0.14.5*/ 
    /*0*/<0.24062,-0.5078,0.82719>,
    /*1*/<-0.06074,0.84822,0.52615>,<-0.8123,-0.56956,-0.12559>,<0.86574,-0.26325,-0.42567>,
            
    /*2*/<-0.01314,0.77905,0.62682>,<-0.80964,-0.57481,-0.11866>,<0.82892,-0.17676,-0.5307>,
            
    /*3*/<0.06431,0.69249,0.71856>,<-0.73733,-0.6755,-0.00653>,<0.65747,-0.01403,-0.75335>,
            
    /*4*/<-0.72277,0.54707,-0.42227>

    /* stem 0.14.6*/ 
    /*0*/<0.87944,-0.31093,-0.36043>,
    /*1*/<-0.33381,-0.94227,0.02635>,<-0.14761,0.55996,-0.81526>,<0.45483,0.39171,0.79981>,
            
    /*2*/<-0.43247,-0.90043,0.04677>,<-0.01431,0.49925,-0.86634>,<0.42014,0.41283,0.80812>,
            
    /*3*/<-0.70323,-0.7083,0.06156>,<0.2389,0.34056,-0.90937>,<0.40885,0.3717,0.83347>,
            
    /*4*/<-0.55581,0.83113,-0.01714>

    /* stem 0.14.7*/ 
    /*0*/<0.51264,0.2893,0.8084>,
    /*1*/<0.55101,0.60246,-0.57743>,<-0.84967,0.33653,0.40597>,<0.28323,-0.9477,0.14714>,
            
    /*2*/<0.61831,0.59251,-0.51635>,<-0.74681,0.3148,0.58581>,<0.06199,-0.99109,-0.11787>,
            
    /*3*/<0.61959,0.63328,-0.46375>,<-0.34067,0.22884,0.91191>,<-0.30431,-0.87128,-0.38507>,
            
    /*4*/<-0.82127,0.553,-0.14038>

    /* stem 0.14.8*/ 
    /*0*/<0.33668,-0.91355,0.2282>,
    /*1*/<-0.53049,0.02706,0.84726>,<-0.41546,-0.35173,-0.83886>,<0.93586,0.35203,-0.01523>,
            
    /*2*/<-0.53628,0.03667,0.84324>,<-0.37843,-0.43418,-0.81748>,<0.9057,0.42194,-0.04092>,
            
    /*3*/<-0.54175,0.04051,0.83956>,<-0.29378,-0.57623,-0.76266>,<0.82406,0.5587,-0.09375>,
            
    /*4*/<-0.60485,0.68543,-0.40538>

    /* stem 0.14.9*/ 
    /*0*/<0.96009,0.25884,0.106>,
    /*1*/<0.24193,-0.63541,-0.73329>,<-0.24131,0.94577,-0.21748>,<-0.02922,-0.31806,0.94762>,
            
    /*2*/<0.28811,-0.63839,-0.71376>,<-0.04119,0.9914,-0.12418>,<-0.32102,-0.33713,0.88504>,
            
    /*3*/<0.3817,-0.60389,-0.69973>,<0.22088,0.9753,0.00221>,<-0.62866,-0.36524,0.68657>,
            
    /*4*/<-0.71851,0.24429,-0.6512>

    /* stem 0.14.10*/ 
    /*0*/<0.07434,-0.28459,0.95576>,
    /*1*/<0.14114,0.95445,0.26288>,<-0.92647,-0.37311,-0.04937>,<0.78313,-0.57291,-0.24183>,
            
    /*2*/<0.13815,0.91737,0.3733>,<-0.93232,-0.32716,-0.15412>,<0.78381,-0.57149,-0.243>,
            
    /*3*/<0.12859,0.85298,0.50585>,<-0.91981,-0.33083,-0.21096>,<0.79547,-0.51198,-0.3242>,
            
    /*4*/<-0.0902,0.55468,-0.82716>

    /* stem 0.14.11*/ 
    /*0*/<0.82187,-0.54338,-0.17109>,
    /*1*/<-0.48914,-0.81747,0.30411>,<-0.03179,0.27278,-0.96155>,<0.49668,0.56073,0.66249>,
            
    /*2*/<-0.55075,-0.77755,0.30345>,<0.07636,0.19708,-0.97741>,<0.45333,0.59622,0.66258>,
            
    /*3*/<-0.69515,-0.67506,0.24713>,<0.36466,-0.00559,-0.93112>,<0.33328,0.68619,0.64658>,
            
    /*4*/<-0.62031,0.61922,-0.48143>

    /* stem 0.14.12*/ 
    /*0*/<0.72008,0.30408,0.62371>,
    /*1*/<0.5257,0.33065,-0.78378>,<-0.6584,0.60295,0.45051>,<0.11161,-0.94251,0.315>,
            
    /*2*/<0.4987,0.33069,-0.80121>,<-0.51861,0.63619,0.57123>,<-0.01502,-0.97049,0.24066>,
            
    /*3*/<0.44052,0.33165,-0.83423>,<-0.15477,0.61276,0.77497>,<-0.31968,-0.94246,0.09788>,
            
    /*4*/<-0.85702,0.45926,-0.23365>

    /* stem 0.14.13*/ 
    /*0*/<0.29328,-0.86229,0.41285>,
    /*1*/<-0.33798,0.32004,0.88507>,<-0.61063,-0.49313,-0.61963>,<0.94009,0.19814,-0.27743>,
            
    /*2*/<-0.27343,0.22111,0.93613>,<-0.58003,-0.54532,-0.60514>,<0.86262,0.37131,-0.34354>,
            
    /*3*/<-0.21994,0.1576,0.9627>,<-0.4831,-0.71033,-0.51191>,<0.68264,0.56048,-0.4689>,
            
    /*4*/<-0.78073,0.54581,-0.30422>

    /* stem 0.14.14*/ 
    /*0*/<0.94809,0.17076,-0.26826>,
    /*1*/<-0.02841,-0.8128,-0.58185>,<-0.27438,0.88827,-0.36836>,<0.27537,-0.08041,0.95797>,
            
    /*2*/<-0.05187,-0.81235,-0.58086>,<-0.12182,0.91118,-0.39359>,<0.14869,-0.08101,0.98556>,
            
    /*3*/<-0.24552,-0.74218,-0.62361>,<0.33314,0.84386,-0.42062>,<-0.06005,-0.06007,0.99639>,
            
    /*4*/<-0.79762,0.59385,-0.10556>

    /* stem 0.14.15*/ 
    /*0*/<0.43958,-0.17816,0.88036>,
    /*1*/<0.36047,0.93277,-0.00206>,<-0.89737,-0.18822,0.39913>,<0.52431,-0.73944,-0.42229>,
            
    /*2*/<0.43729,0.8929,0.10724>,<-0.88371,-0.2001,0.42311>,<0.45195,-0.68551,-0.57081>,
            
    /*3*/<0.57487,0.76683,0.28546>,<-0.86847,-0.18075,0.46162>,<0.29279,-0.5665,-0.7703>,
            
    /*4*/<-0.44408,0.70535,-0.55252>

    /* stem 0.14.16*/ 
    /*0*/<0.50085,-0.82438,-0.26373>,
    /*1*/<-0.64882,-0.55068,0.52515>,<-0.18342,0.20748,-0.96089>,<0.81797,0.36668,0.44325>,
            
    /*2*/<-0.66361,-0.52857,0.52937>,<-0.14711,0.14964,-0.97773>,<0.79658,0.40313,0.45049>,
            
    /*3*/<-0.69694,-0.48246,0.53057>,<-0.05315,0.01386,-0.99849>,<0.7371,0.4928,0.46241>,
            
    /*4*/<-0.58017,0.81209,-0.06265>

    /* stem 0.14.17*/ 
    /*0*/<0.89419,0.18574,0.40734>,
    /*1*/<0.39701,0.04807,-0.91656>,<-0.37553,0.82317,0.42588>,<-0.04675,-0.87648,0.47916>,
            
    /*2*/<0.41312,0.04734,-0.90945>,<-0.23432,0.82825,0.50901>,<-0.21949,-0.88324,0.41438>,
            
    /*3*/<0.41898,0.06018,-0.906>,<0.076,0.75521,0.65106>,<-0.52701,-0.80343,0.27706>,
            
    /*4*/<-0.75131,0.58783,-0.29998>

    /* stem 0.14.18*/ 
    /*0*/<0.04258,-0.87566,0.48104>,
    /*1*/<0.02251,0.49038,0.87122>,<-0.87683,-0.25565,-0.40721>,<0.85312,-0.21015,-0.47752>,
            
    /*2*/<0.02619,0.40355,0.91458>,<-0.88067,-0.20904,-0.4251>,<0.85326,-0.16753,-0.49384>,
            
    /*3*/<0.04978,0.25397,0.96593>,<-0.89168,-0.1015,-0.44114>,<0.8391,-0.12511,-0.52939>,
            
    /*4*/<0.03367,0.9821,-0.18531>

    /* stem 0.14.19*/ 
    /*0*/<0.85885,-0.23115,-0.4571>,
    /*1*/<-0.44852,-0.78642,-0.42471>,<-0.01401,0.88988,-0.45598>,<0.43858,-0.09701,0.89344>,
            
    /*2*/<-0.62283,-0.683,-0.38157>,<0.23368,0.76222,-0.60367>,<0.39028,-0.04802,0.91944>,
            
    /*3*/<-0.77659,-0.5421,-0.32099>,<0.57844,0.49501,-0.64836>,<0.20128,0.0788,0.97636>,
            
    /*4*/<-0.54424,0.834,-0.09083>

    /* stem 0.14.20*/ 
    /*0*/<0.45037,-0.13903,0.88195>,
    /*1*/<0.64804,0.7272,-0.22632>,<-0.85818,0.22149,0.46311>,<0.19818,-0.94499,-0.26021>,
            
    /*2*/<0.74623,0.66024,-0.08498>,<-0.84195,0.19981,0.5012>,<0.10866,-0.87241,-0.47654>,
            
    /*3*/<0.78933,0.61212,0.04766>,<-0.68341,-0.0153,0.72988>,<-0.16928,-0.63046,-0.75754>,
            
    /*4*/<-0.63125,0.75069,-0.19492>

    /* stem 0.14.21*/ 
    /*0*/<0.20171,-0.94608,-0.25347>,
    /*1*/<-0.55998,-0.31644,0.7657>,<-0.41915,0.15826,-0.89402>,<0.97449,0.17992,0.13415>,
            
    /*2*/<-0.54321,-0.37137,0.753>,<-0.4116,0.13509,-0.9013>,<0.95302,0.25873,0.15753>,
            
    /*3*/<-0.47706,-0.50386,0.7201>,<-0.43287,0.12566,-0.89266>,<0.90015,0.39412,0.18546>,
            
    /*4*/<-0.48565,0.79212,0.36972>

    /* stem 0.14.22*/ 
    /*0*/<0.98118,0.16098,0.10662>,
    /*1*/<0.12643,-0.16363,-0.97839>,<-0.19423,0.92326,0.33147>,<0.04835,-0.76282,0.6448>,
            
    /*2*/<0.16713,-0.17294,-0.97065>,<0.00161,0.91781,0.39703>,<-0.21502,-0.75292,0.622>,
            
    /*3*/<0.33486,-0.25983,-0.90573>,<0.26934,0.84144,0.46844>,<-0.67431,-0.60119,0.42881>,
            
    /*4*/<-0.54741,0.61585,-0.56664>

    /* stem 0.14.23*/ 
    /*0*/<-0.01407,-0.78298,0.62189>,
    /*1*/<0.35379,0.58223,0.73202>,<-0.98671,-0.08506,-0.13844>,<0.63316,-0.48398,-0.60404>,
            
    /*2*/<0.32239,0.6665,0.67219>,<-0.96426,-0.2648,0.00972>,<0.60527,-0.41303,-0.68048>,
            
    /*3*/<0.28519,0.75313,0.59285>,<-0.85931,-0.47981,0.17712>,<0.56415,-0.26691,-0.78134>,
            
    /*4*/<-0.55672,0.63023,-0.54119>

    /* stem 0.14.24*/ 
    /*0*/<0.62348,-0.45023,-0.63919>,
    /*1*/<-0.67763,-0.7207,-0.1463>,<-0.0073,0.81749,-0.5759>,<0.67652,-0.09071,0.73081>,
            
    /*2*/<-0.71255,-0.69046,-0.12465>,<0.108,0.73159,-0.67314>,<0.60974,-0.0186,0.79238>,
            
    /*3*/<-0.78734,-0.60906,-0.0956>,<0.30984,0.5344,-0.7864>,<0.4772,0.08941,0.87423>,
            
    /*4*/<-0.56955,0.80838,0.14878>

    /* stem 0.14.25*/ 
    /*0*/<0.69541,-0.24735,0.6747>,
    /*1*/<0.67834,0.53011,-0.50876>,<-0.54271,0.43869,0.71625>,<-0.14118,-0.96683,-0.21287>,
            
    /*2*/<0.73406,0.50504,-0.45397>,<-0.55081,0.44349,0.70705>,<-0.18417,-0.94722,-0.26239>,
            
    /*3*/<0.74596,0.52147,-0.41426>,<-0.41092,0.30567,0.8589>,<-0.3633,-0.84075,-0.40143>,
            
    /*4*/<-0.69836,0.65478,-0.28907>

    /* stem 0.14.26*/ 
    /*0*/<0.11408,-0.99224,-0.04952>,
    /*1*/<-0.36739,-0.08751,0.92594>,<-0.61588,-0.03058,-0.78724>,<0.98295,0.12087,-0.13856>,
            
    /*2*/<-0.37863,-0.02869,0.9251>,<-0.60636,-0.11345,-0.78705>,<0.97968,0.14339,-0.14026>,
            
    /*3*/<-0.3804,-0.09031,0.9204>,<-0.60353,-0.10236,-0.79075>,<0.97362,0.1917,-0.12379>,
            
    /*4*/<-0.19709,0.97003,0.14211>

    /* stem 0.15*/ 
    /*0*/<-0.98198,-0.07688,0.17262>,
    /*1*/<0.18497,-0.00504,0.98273>,<-0.00598,0.94722,0.32053>,<-0.17291,0.59169,-0.7874>,
            <-0.08512,-0.5803,-0.80994>,<0.13607,-0.9491,0.28406>,
    /*2*/<0.15769,-0.00875,0.98745>,<-0.10945,0.93489,0.33763>,<-0.20893,0.58702,-0.78215>,
            <-0.0051,-0.56834,-0.82278>,<0.22153,-0.93671,0.2711>,
    /*3*/<0.12695,-0.01756,0.99175>,<-0.27382,0.89095,0.36227>,<-0.28054,0.57265,-0.77031>,
            <0.11442,-0.53156,-0.83926>,<0.36617,-0.89645,0.24961>,
    /*4*/<0.12379,-0.01752,0.99215>,<-0.40503,0.83306,0.37678>,<-0.35941,0.53894,-0.76182>,
            <0.19644,-0.49212,-0.84807>,<0.49506,-0.83627,0.23575>,
    /*5*/<0.1334,-0.0077,0.99103>,<-0.54379,0.74239,0.39134>,<-0.45621,0.47551,-0.75217>,
            <0.2738,-0.43825,-0.85614>,<0.63848,-0.73726,0.22091>,
    /*6*/<0.70746,0.70098,-0.09016>

    /* stem 0.15.0*/ 
    /*0*/<-0.77904,-0.55462,-0.29239>,
    /*1*/<-0.17284,0.65117,-0.73899>,<0.61845,-0.77171,-0.14827>,<-0.42123,0.13789,0.89641>,
            
    /*2*/<-0.11961,0.6771,-0.72611>,<0.5174,-0.8358,-0.18369>,<-0.36838,0.16226,0.9154>,
            
    /*3*/<-0.1559,0.67235,-0.72363>,<0.28907,-0.93938,-0.18441>,<-0.08699,0.28889,0.9534>,
            
    /*4*/<0.96316,0.18493,-0.19527>

    /* stem 0.15.1*/ 
    /*0*/<-0.57187,0.06622,0.81767>,
    /*1*/<0.10963,-0.98354,0.14362>,<0.6588,0.6395,0.39626>,<-0.7506,0.34198,-0.56537>,
            
    /*2*/<0.26119,-0.96333,0.06146>,<0.40001,0.61073,0.68338>,<-0.64993,0.39587,-0.64875>,
            
    /*3*/<0.37817,-0.92573,-0.00456>,<0.006,0.55678,0.83064>,<-0.36281,0.39174,-0.84552>,
            
    /*4*/<0.94376,0.31707,-0.09372>

    /* stem 0.15.2*/ 
    /*0*/<-0.78977,0.32721,-0.51884>,
    /*1*/<0.03028,0.85705,0.51435>,<0.52797,-0.09542,-0.84389>,<-0.53373,-0.77179,0.34565>,
            
    /*2*/<-0.17081,0.90421,0.39144>,<0.57974,-0.09223,-0.80957>,<-0.41569,-0.78742,0.45516>,
            
    /*3*/<-0.4614,0.86535,0.19564>,<0.59303,-0.11239,-0.7973>,<-0.11269,-0.75435,0.64673>,
            
    /*4*/<0.76923,0.48065,0.42101>

    /* stem 0.15.3*/ 
    /*0*/<-0.50047,-0.78843,0.35764>,
    /*1*/<-0.1324,-0.32728,-0.93561>,<0.81414,-0.27068,0.51372>,<-0.66626,0.62235,0.41083>,
            
    /*2*/<-0.11197,-0.31423,-0.94272>,<0.6815,-0.41667,0.60162>,<-0.54295,0.75292,0.37191>,
            
    /*3*/<-0.07263,-0.30393,-0.94992>,<0.54462,-0.52565,0.65352>,<-0.44836,0.84556,0.28984>,
            
    /*4*/<0.79722,0.55541,-0.23658>

    /* stem 0.15.4*/ 
    /*0*/<-0.69181,0.61717,0.37483>,
    /*1*/<0.19576,-0.35291,0.91495>,<0.51638,0.77865,-0.35645>,<-0.69079,-0.44479,-0.57007>,
            
    /*2*/<0.20466,-0.35916,0.91056>,<0.48174,0.80821,-0.33872>,<-0.66409,-0.46566,-0.58493>,
            
    /*3*/<0.15563,-0.3517,0.92308>,<0.34504,0.89355,-0.28726>,<-0.47841,-0.56572,-0.67162>,
            
    /*4*/<0.94327,-0.2751,-0.18591>

    /* stem 0.15.5*/ 
    /*0*/<-0.86691,-0.3477,-0.35717>,
    /*1*/<-0.14258,0.86993,-0.47211>,<0.49586,-0.73997,-0.45451>,<-0.32663,-0.11928,0.9376>,
            
    /*2*/<-0.22536,0.83655,-0.4994>,<0.50535,-0.73471,-0.45256>,<-0.25767,-0.08325,0.96264>,
            
    /*3*/<-0.36016,0.77127,-0.52481>,<0.55552,-0.69526,-0.45608>,<-0.17011,-0.05934,0.98364>,
            
    /*4*/<0.79626,0.57961,0.17329>

    /* stem 0.15.6*/ 
    /*0*/<-0.44162,-0.31409,0.84043>,
    /*1*/<0.25033,-0.93998,-0.23188>,<0.62881,0.56831,0.53068>,<-0.86563,0.38128,-0.3245>,
            
    /*2*/<0.3302,-0.879,-0.344>,<0.56927,0.50137,0.65158>,<-0.86565,0.38212,-0.32347>,
            
    /*3*/<0.45773,-0.75618,-0.46763>,<0.38193,0.35528,0.85317>,<-0.82121,0.42411,-0.38176>,
            
    /*4*/<0.62263,0.68808,-0.37265>

    /* stem 0.15.7*/ 
    /*0*/<-0.81685,0.41555,-0.4001>,
    /*1*/<-0.07374,0.59862,0.79763>,<0.54376,0.28417,-0.78966>,<-0.44517,-0.89543,0.0042>,
            
    /*2*/<-0.13301,0.60739,0.78319>,<0.38959,0.30947,-0.86744>,<-0.216,-0.973,0.08137>,
            
    /*3*/<-0.26862,0.58501,0.76525>,<0.05714,0.32118,-0.94529>,<0.27988,-0.94399,0.17477>,
            
    /*4*/<0.85776,0.51321,0.0293>

    /* stem 0.15.8*/ 
    /*0*/<-0.35449,-0.93474,0.02447>,
    /*1*/<-0.11658,0.029,-0.99276>,<0.86668,-0.30762,0.39273>,<-0.73938,0.30687,0.59929>,
            
    /*2*/<-0.04902,0.11336,-0.99234>,<0.76462,-0.51444,0.3882>,<-0.6809,0.39211,0.61857>,
            
    /*3*/<0.03884,0.19604,-0.97983>,<0.60883,-0.68696,0.39675>,<-0.62749,0.51085,0.58762>,
            
    /*4*/<0.7086,0.68615,0.16459>

    /* stem 0.15.9*/ 
    /*0*/<-0.83897,0.21935,0.49801>,
    /*1*/<0.27453,-0.63505,0.72204>,<0.28641,0.95724,0.04074>,<-0.53569,-0.3288,-0.77777>,
            
    /*2*/<0.18101,-0.63955,0.74714>,<0.13309,0.98861,0.07022>,<-0.27513,-0.36224,-0.89055>,
            
    /*3*/<0.16584,-0.55602,0.81446>,<-0.29845,0.94784,0.11194>,<0.11746,-0.342,-0.93233>,
            
    /*4*/<0.84746,0.52626,0.06972>

    /* stem 0.15.10*/ 
    /*0*/<-0.65448,-0.28746,-0.6993>,
    /*1*/<-0.28103,0.95285,-0.11441>,<0.75584,-0.36678,-0.54238>,<-0.45524,-0.57748,0.6777>,
            
    /*2*/<-0.35002,0.92202,-0.1654>,<0.71591,-0.39326,-0.57691>,<-0.35044,-0.52181,0.77775>,
            
    /*3*/<-0.47484,0.84771,-0.23647>,<0.66975,-0.39321,-0.62993>,<-0.17686,-0.43703,0.88189>,
            
    /*4*/<0.71207,0.59594,0.37122>

    /* stem 0.15.11*/ 
    /*0*/<-0.56732,-0.60701,0.55649>,
    /*1*/<0.29631,-0.77384,-0.5598>,<0.52749,0.2637,0.8076>,<-0.80695,0.52817,-0.26433>,
            
    /*2*/<0.34738,-0.7097,-0.6129>,<0.51301,0.2432,0.82321>,<-0.8444,0.48276,-0.23224>,
            
    /*3*/<0.44874,-0.5813,-0.67877>,<0.43196,0.13786,0.8913>,<-0.85971,0.46348,-0.21469>,
            
    /*4*/<0.53147,0.81194,-0.24146>

    /* stem 0.15.12*/ 
    /*0*/<-0.96207,0.2505,-0.10802>,
    /*1*/<-0.0222,0.28829,0.95729>,<0.25994,0.65183,-0.71243>,<-0.20934,-0.94751,-0.24167>,
            
    /*2*/<-0.08732,0.29687,0.95092>,<0.21984,0.65784,-0.72036>,<-0.10357,-0.96863,-0.22588>,
            
    /*3*/<-0.23392,0.30497,0.92319>,<0.11831,0.65448,-0.74676>,<0.15071,-0.97398,-0.16924>,
            
    /*4*/<0.93478,0.24202,0.26001>

    /* stem 0.15.13*/ 
    /*0*/<-0.51715,-0.83875,-0.17044>,
    /*1*/<-0.23712,0.3426,-0.90906>,<0.83705,-0.53112,0.13136>,<-0.58474,0.21315,0.78271>,
            
    /*2*/<-0.25511,0.31491,-0.91419>,<0.83593,-0.53302,0.13082>,<-0.56641,0.24339,0.78736>,
            
    /*3*/<-0.26101,0.30775,-0.91497>,<0.78282,-0.611,0.1178>,<-0.50055,0.32205,0.80357>,
            
    /*4*/<0.68575,0.72496,0.06461>

    /* stem 0.15.14*/ 
    /*0*/<-0.72692,0.01091,0.68663>,
    /*1*/<0.4098,-0.80318,0.43241>,<0.28742,0.91732,0.27551>,<-0.67596,-0.11447,-0.728>,
            
    /*2*/<0.48429,-0.78686,0.3825>,<0.15007,0.9049,0.39829>,<-0.61527,-0.09385,-0.78271>,
            
    /*3*/<0.68384,-0.67961,0.26549>,<-0.1458,0.777,0.61238>,<-0.51377,-0.07338,-0.85478>,
            
    /*4*/<0.61206,0.68968,-0.38694>

    /* stem 0.15.15*/ 
    /*0*/<-0.70616,-0.10959,-0.69952>,
    /*1*/<-0.36797,0.89704,0.24477>,<0.71444,-0.07433,-0.69574>,<-0.32596,-0.81953,0.47129>,
            
    /*2*/<-0.45472,0.86775,0.20059>,<0.6139,-0.13295,-0.77811>,<-0.11822,-0.76363,0.63475>,
            
    /*3*/<-0.58057,0.79801,0.16162>,<0.32321,-0.26085,-0.90967>,<0.32246,-0.55753,0.76497>,
            
    /*4*/<0.74931,0.64596,-0.14585>

    /* stem 0.15.16*/ 
    /*0*/<-0.44594,-0.77239,0.45227>,
    /*1*/<0.17581,-0.56223,-0.80808>,<0.67927,0.04904,0.73225>,<-0.84222,0.53547,0.06278>,
            
    /*2*/<0.11235,-0.63,-0.76843>,<0.63629,0.00474,0.77143>,<-0.7471,0.66426,-0.02441>,
            
    /*3*/<0.10629,-0.64157,-0.75967>,<0.52505,-0.14251,0.83906>,<-0.60464,0.79198,-0.08474>,
            
    /*4*/<0.7901,0.55691,-0.25609>

    /* stem 0.15.17*/ 
    /*0*/<-0.9405,0.3196,0.1154>,
    /*1*/<0.12351,-0.02467,0.99204>,<0.22878,0.8281,-0.51177>,<-0.32531,-0.8126,-0.48358>,
            
    /*2*/<0.15153,-0.02318,0.98818>,<0.03033,0.86569,-0.49966>,<-0.1645,-0.83533,-0.52456>,
            
    /*3*/<0.12994,-0.06399,0.98945>,<-0.38284,0.79022,-0.47852>,<0.32272,-0.731,-0.60125>,
            
    /*4*/<0.72749,0.68525,0.03445>

    /* stem 0.15.18*/ 
    /*0*/<-0.28444,-0.83259,-0.47528>,
    /*1*/<-0.43399,0.56172,-0.70436>,<0.96011,-0.26391,-0.09237>,<-0.51804,-0.27416,0.81023>,
            
    /*2*/<-0.45624,0.52092,-0.72145>,<0.92548,-0.35755,-0.12507>,<-0.45915,-0.14177,0.87697>,
            
    /*3*/<-0.55078,0.35838,-0.75379>,<0.89593,-0.40426,-0.18409>,<-0.34703,0.07415,0.93492>,
            
    /*4*/<0.37731,0.92565,-0.02828>

    /* stem 0.15.19*/ 
    /*0*/<-0.63348,-0.34713,0.69152>,
    /*1*/<0.56048,-0.82365,0.0864>,<0.19598,0.79977,0.56741>,<-0.7386,0.03366,-0.6733>,
            
    /*2*/<0.62223,-0.78192,0.03783>,<0.10088,0.73703,0.66829>,<-0.70383,0.06548,-0.70734>,
            
    /*3*/<0.71295,-0.70089,-0.02141>,<-0.10021,0.58381,0.80568>,<-0.60288,0.14316,-0.78489>,
            
    /*4*/<0.64503,0.71845,-0.26033>

    /* stem 0.15.20*/ 
    /*0*/<-0.88412,-0.16445,-0.43737>,
    /*1*/<-0.40502,0.71454,0.57043>,<0.40373,0.23511,-0.88415>,<0.02491,-0.94525,0.3254>,
            
    /*2*/<-0.48723,0.68791,0.53795>,<0.37026,0.22166,-0.9021>,<0.14118,-0.91147,0.38639>,
            
    /*3*/<-0.6983,0.5649,0.43962>,<0.34133,0.23064,-0.91121>,<0.36154,-0.78427,0.50419>,
            
    /*4*/<0.57857,0.70647,0.40762>

    /* stem 0.15.21*/ 
    /*0*/<-0.28903,-0.9285,0.23314>,
    /*1*/<0.08045,-0.25791,-0.96281>,<0.78962,-0.08431,0.60777>,<-0.86292,0.36521,0.34927>,
            
    /*2*/<0.08298,-0.25452,-0.9635>,<0.75255,-0.17531,0.63477>,<-0.82637,0.45396,0.3332>,
            
    /*3*/<0.07781,-0.26192,-0.96195>,<0.63264,-0.36447,0.68333>,<-0.69858,0.65346,0.29151>,
            
    /*4*/<0.7435,0.65369,-0.14105>

    /* stem 0.15.22*/ 
    /*0*/<-0.92388,0.0347,0.38111>,
    /*1*/<0.36763,-0.24931,0.89593>,<-0.06511,0.96247,-0.26346>,<-0.28353,-0.71387,-0.64031>,
            
    /*2*/<0.2537,-0.30156,0.91907>,<-0.24276,0.9328,-0.26637>,<0.06898,-0.6639,-0.74463>,
            
    /*3*/<0.05256,-0.32592,0.94394>,<-0.45935,0.86306,-0.21007>,<0.42471,-0.53053,-0.73359>,
            
    /*4*/<0.82936,0.52619,0.18784>

    /* stem 0.15.23*/ 
    /*0*/<-0.36254,-0.75397,-0.54781>,
    /*1*/<-0.66515,0.62464,-0.40915>,<0.89916,-0.1188,-0.42119>,<-0.22783,-0.49299,0.83967>,
            
    /*2*/<-0.68996,0.57795,-0.43581>,<0.88575,-0.1515,-0.43873>,<-0.19193,-0.41417,0.88973>,
            
    /*3*/<-0.72019,0.51956,-0.45976>,<0.85668,-0.19807,-0.4763>,<-0.12959,-0.30749,0.94268>,
            
    /*4*/<0.40451,0.86204,0.30539>

    /* stem 0.15.24*/ 
    /*0*/<-0.39468,-0.62739,0.67128>,
    /*1*/<0.66293,-0.69817,-0.27034>,<0.22431,0.64686,0.72887>,<-0.88121,0.06089,-0.46878>,
            
    /*2*/<0.69299,-0.65569,-0.29972>,<0.15695,0.54406,0.82424>,<-0.84658,0.12969,-0.51622>,
            
    /*3*/<0.64966,-0.70739,-0.27846>,<0.07926,0.43905,0.89496>,<-0.72128,0.27098,-0.63743>,
            
    /*4*/<0.71189,0.60487,-0.35685>

    /* stem 0.15.25*/ 
    /*0*/<-0.93625,-0.10676,-0.33471>,
    /*1*/<-0.34219,0.45457,0.82236>,<0.23162,0.53924,-0.80968>,<0.12015,-0.99271,-0.00926>,
            
    /*2*/<-0.32251,0.45809,0.82833>,<0.18266,0.53266,-0.82638>,<0.14979,-0.98872,-0.00083>,
            
    /*3*/<-0.31169,0.46387,0.82926>,<-0.0504,0.4359,-0.89858>,<0.39015,-0.9201,0.0347>,
            
    /*4*/<0.81965,0.57284,0.00472>

    /* stem 0.15.26*/ 
    /*0*/<0.0909,-0.9957,-0.0176>,
    /*1*/<-0.13195,0.00739,-0.99123>,<0.92057,0.07919,0.38247>,<-0.78914,-0.0809,0.60886>,
            
    /*2*/<-0.12612,0.05493,-0.99049>,<0.92216,-0.06567,0.38121>,<-0.7844,0.01122,0.62016>,
            
    /*3*/<-0.1248,0.06168,-0.99026>,<0.90152,-0.20788,0.37954>,<-0.77733,0.1521,0.61042>,
            
    /*4*/<0.23518,0.97186,-0.01354>

    /* stem 0.15.27*/ 
    /*0*/<-0.77929,0.02233,0.62627>,
    /*1*/<0.5478,-0.46264,0.69706>,<-0.00871,0.99883,-0.04753>,<-0.53751,-0.53624,-0.65079>,
            
    /*2*/<0.6198,-0.44903,0.6436>,<-0.11825,0.99184,0.04755>,<-0.50172,-0.5279,-0.68527>,
            
    /*3*/<0.66704,-0.45392,0.59077>,<-0.35685,0.9089,0.2158>,<-0.32577,-0.44437,-0.83451>,
            
    /*4*/<0.74521,0.55729,-0.36619>

    /* stem 0.16*/ 
    /*0*/<0.63387,-0.14596,-0.75954>,
    /*1*/<-0.77319,0.02069,-0.63384>,<-0.14111,0.94821,-0.28459>,<0.67573,0.56769,0.47023>,
            <0.54849,-0.595,0.58748>,<-0.34699,-0.93306,-0.09487>,
    /*2*/<-0.73128,0.0068,-0.68205>,<-0.0614,0.92544,-0.37388>,<0.68171,0.56615,0.46342>,
            <0.47358,-0.57051,0.671>,<-0.4001,-0.91571,-0.03736>,
    /*3*/<-0.7227,0.00572,-0.69114>,<0.08647,0.84044,-0.53496>,<0.76826,0.52034,0.37285>,
            <0.37712,-0.51147,0.77213>,<-0.54434,-0.83082,0.11588>,
    /*4*/<-0.76787,0.06743,-0.63705>,<0.20091,0.73063,-0.65255>,<0.88605,0.39382,0.24457>,
            <0.33789,-0.47643,0.81169>,<-0.68356,-0.67931,0.267>,
    /*5*/<-0.78532,0.11282,-0.60872>,<0.27231,0.60537,-0.74791>,<0.94914,0.27315,0.15662>,
            <0.30854,-0.42341,0.85178>,<-0.76336,-0.523,0.37915>,
    /*6*/<-0.23651,0.85071,0.46943>

    /* stem 0.16.0*/ 
    /*0*/<0.74668,-0.61646,-0.2499>,
    /*1*/<0.64835,0.62768,0.43087>,<-0.43013,-0.72307,0.54052>,<-0.24175,0.11481,-0.96352>,
            
    /*2*/<0.70312,0.5893,0.39793>,<-0.37143,-0.78149,0.50132>,<-0.36829,0.21725,-0.90397>,
            
    /*3*/<0.79602,0.52786,0.29618>,<-0.2416,-0.86174,0.44613>,<-0.58197,0.35713,-0.7306>,
            
    /*4*/<-0.4702,0.44029,0.76489>

    /* stem 0.16.1*/ 
    /*0*/<-0.04215,0.02417,-0.99882>,
    /*1*/<-0.23913,-0.97098,-0.00294>,<-0.71974,0.69185,0.05759>,<0.96019,0.27837,-0.02331>,
            
    /*2*/<-0.24536,-0.96901,0.02876>,<-0.7135,0.69564,-0.08366>,<0.95355,0.28995,0.08173>,
            
    /*3*/<-0.31551,-0.93572,0.15773>,<-0.62113,0.64513,-0.44499>,<0.90623,0.31765,0.279>,
            
    /*4*/<-0.49068,0.41282,0.76734>

    /* stem 0.16.2*/ 
    /*0*/<0.95125,0.30768,-0.02108>,
    /*1*/<-0.29908,0.86283,-0.40753>,<0.04181,-0.09504,0.99459>,<0.22749,-0.77741,-0.58641>,
            
    /*2*/<-0.16426,0.88417,-0.43734>,<0.1071,-0.09348,0.98984>,<0.01336,-0.81587,-0.57808>,
            
    /*3*/<0.20434,0.81892,-0.5363>,<0.17168,-0.04094,0.9843>,<-0.40805,-0.7627,-0.50178>,
            
    /*4*/<-0.78651,0.59662,0.15952>

    /* stem 0.16.3*/ 
    /*0*/<0.18448,-0.76095,-0.62203>,
    /*1*/<0.68066,-0.34821,0.64455>,<-0.95555,-0.28368,0.08035>,<0.26913,0.65561,-0.70551>,
            
    /*2*/<0.67513,-0.29692,0.67531>,<-0.9661,-0.2347,0.1076>,<0.28986,0.56077,-0.77558>,
            
    /*3*/<0.6529,-0.24676,0.71612>,<-0.96365,-0.25156,0.08999>,<0.30075,0.52586,-0.79562>,
            
    /*4*/<-0.25728,0.81295,0.52241>

    /* stem 0.16.4*/ 
    /*0*/<0.38004,0.4937,-0.7822>,
    /*1*/<-0.76055,-0.32555,-0.56176>,<-0.08633,0.8552,0.51106>,<0.83509,-0.54498,0.07499>,
            
    /*2*/<-0.84641,-0.38475,-0.36818>,<-0.03658,0.95149,0.3055>,<0.8342,-0.54502,0.08408>,
            
    /*3*/<-0.90272,-0.42984,-0.01832>,<0.04886,0.99254,-0.11174>,<0.83543,-0.53062,0.14313>,
            
    /*4*/<-0.01252,0.31638,0.94855>

    /* stem 0.16.5*/ 
    /*0*/<0.86477,-0.49988,0.04787>,
    /*1*/<0.46771,0.85221,0.23449>,<-0.38408,-0.5746,0.72272>,<-0.11039,-0.26214,-0.95869>,
            
    /*2*/<0.59001,0.78147,0.20295>,<-0.33125,-0.6222,0.70933>,<-0.2994,-0.12706,-0.94563>,
            
    /*3*/<0.78864,0.60795,0.0919>,<-0.2568,-0.59498,0.76161>,<-0.53572,0.01408,-0.84428>,
            
    /*4*/<-0.47065,0.7914,0.3901>

    /* stem 0.16.6*/ 
    /*0*/<0.11004,-0.39043,-0.91403>,
    /*1*/<-0.12202,-0.91399,0.38696>,<-0.79502,0.52271,-0.30776>,<0.91364,0.4033,-0.05104>,
            
    /*2*/<-0.13243,-0.89429,0.42745>,<-0.78341,0.48689,-0.38627>,<0.9062,0.42252,-0.01698>,
            
    /*3*/<-0.2132,-0.74458,0.63257>,<-0.73885,0.33854,-0.58267>,<0.91318,0.40748,-0.00831>,
            
    /*4*/<-0.28864,0.79705,0.53047>

    /* stem 0.16.7*/ 
    /*0*/<0.92436,0.31919,-0.20899>,
    /*1*/<-0.37507,0.58144,-0.72197>,<0.07902,0.35022,0.93333>,<0.2677,-0.94146,-0.20494>,
            
    /*2*/<-0.29236,0.56408,-0.77223>,<0.3163,0.31174,0.89597>,<-0.12421,-0.99102,-0.04947>,
            
    /*3*/<-0.1794,0.54872,-0.81653>,<0.6102,0.34705,0.71219>,<-0.45024,-0.88506,0.11808>,
            
    /*4*/<-0.73614,0.47816,0.47902>

    /* stem 0.16.8*/ 
    /*0*/<0.37904,-0.86587,-0.3265>,
    /*1*/<0.6772,0.03098,0.73515>,<-0.88688,-0.43508,0.15538>,<0.19812,0.43051,-0.88057>,
            
    /*2*/<0.66791,0.04823,0.74268>,<-0.86806,-0.47651,0.13931>,<0.18602,0.45312,-0.87183>,
            
    /*3*/<0.63558,0.0824,0.76763>,<-0.78124,-0.6213,0.06032>,<0.11821,0.55361,-0.82435>,
            
    /*4*/<-0.64653,0.62349,0.43961>

    /* stem 0.16.9*/ 
    /*0*/<0.34551,0.20872,-0.91491>,
    /*1*/<-0.68131,-0.6208,-0.38785>,<-0.22658,0.9631,0.14522>,<0.89739,-0.34865,0.27043>,
            
    /*2*/<-0.73127,-0.61182,-0.30153>,<-0.13315,0.98809,-0.07715>,<0.85929,-0.33559,0.38602>,
            
    /*3*/<-0.79516,-0.58036,-0.1758>,<0.05122,0.914,-0.40246>,<0.74261,-0.30757,0.59492>,
            
    /*4*/<-0.49059,0.51494,0.70296>

    /* stem 0.16.10*/ 
    /*0*/<0.93393,-0.35386,0.0505>,
    /*1*/<0.348,0.92927,-0.12392>,<-0.19079,-0.34383,0.91944>,<-0.18546,-0.57473,-0.79705>,
            
    /*2*/<0.47829,0.86626,-0.14433>,<-0.15682,-0.36719,0.91683>,<-0.35616,-0.4813,-0.80094>,
            
    /*3*/<0.62283,0.7591,-0.18935>,<-0.04458,-0.40628,0.91266>,<-0.60637,-0.3374,-0.72005>,
            
    /*4*/<-0.63971,0.68074,0.35688>

    /* stem 0.16.11*/ 
    /*0*/<-0.09904,-0.59879,-0.79476>,
    /*1*/<0.13121,-0.79358,0.59415>,<-0.91843,0.36643,-0.14903>,<0.79019,0.44513,-0.42125>,
            
    /*2*/<0.1292,-0.78585,0.60477>,<-0.92174,0.30323,-0.24178>,<0.78851,0.50826,-0.34631>,
            
    /*3*/<0.10328,-0.71505,0.6914>,<-0.90356,0.18261,-0.3876>,<0.79033,0.54642,-0.27712>,
            
    /*4*/<-0.23238,0.72204,0.65166>

    /* stem 0.16.12*/ 
    /*0*/<0.83113,0.20919,-0.51524>,
    /*1*/<-0.56433,0.3058,-0.76682>,<0.26727,0.64772,0.71346>,<0.27221,-0.95978,0.06877>,
            
    /*2*/<-0.43411,0.29194,-0.85224>,<0.34314,0.64181,0.6858>,<0.04142,-0.98211,0.1837>,
            
    /*3*/<-0.25662,0.28619,-0.92317>,<0.53204,0.59986,0.59758>,<-0.30082,-0.88556,0.35396>,
            
    /*4*/<-0.75721,0.55709,0.34101>

    /* stem 0.16.13*/ 
    /*0*/<0.22333,-0.96961,0.09989>,
    /*1*/<0.83831,0.25306,0.48291>,<-0.84987,-0.13299,0.50994>,<0.00492,-0.09124,-0.99582>,
            
    /*2*/<0.83146,0.28698,0.47573>,<-0.85857,-0.09995,0.50286>,<0.02073,-0.15968,-0.98695>,
            
    /*3*/<0.81265,0.32884,0.48111>,<-0.82622,-0.26015,0.49968>,<-0.02631,-0.05485,-0.99815>,
            
    /*4*/<-0.43733,0.88937,0.13328>

    /* stem 0.16.14*/ 
    /*0*/<0.01965,-0.06592,-0.99763>,
    /*1*/<-0.7319,-0.68022,0.04038>,<-0.22433,0.97273,-0.05885>,<0.95565,-0.29057,0.04787>,
            
    /*2*/<-0.74558,-0.65141,0.14063>,<-0.22266,0.94462,-0.24108>,<0.95682,-0.26732,0.11421>,
            
    /*3*/<-0.75529,-0.57657,0.31161>,<-0.19789,0.85114,-0.48621>,<0.94577,-0.25808,0.19728>,
            
    /*4*/<-0.01051,0.57748,0.81633>

    /* stem 0.16.15*/ 
    /*0*/<0.94358,-0.33116,-0.00026>,
    /*1*/<0.2713,0.80293,-0.53075>,<0.00291,0.03704,0.99931>,<-0.30187,-0.83026,-0.46855>,
            
    /*2*/<0.34249,0.75446,-0.5599>,<0.14122,-0.07609,0.98705>,<-0.57339,-0.70053,-0.42483>,
            
    /*3*/<0.4422,0.65456,-0.6132>,<0.37157,-0.1753,0.91171>,<-0.83781,-0.46274,-0.28973>,
            
    /*4*/<-0.45626,0.78819,0.41302>

    /* stem 0.16.16*/ 
    /*0*/<-0.27816,-0.83552,-0.47385>,
    /*1*/<0.30462,-0.53626,0.78717>,<-0.93792,0.34487,-0.03711>,<0.64137,0.21564,-0.73631>,
            
    /*2*/<0.30859,-0.50783,0.80429>,<-0.96129,0.26171,-0.08622>,<0.65174,0.2726,-0.70776>,
            
    /*3*/<0.29445,-0.37218,0.88022>,<-0.97811,0.0305,-0.20585>,<0.66266,0.3587,-0.65744>,
            
    /*4*/<-0.21171,0.91918,0.3321>

    /* stem 0.16.17*/ 
    /*0*/<0.62105,-0.05754,-0.78166>,
    /*1*/<-0.78229,0.09234,-0.61603>,<0.47538,0.81555,0.32999>,<0.28897,-0.90623,0.30862>,
            
    /*2*/<-0.73968,0.06736,-0.66958>,<0.57168,0.78318,0.24454>,<0.15481,-0.8653,0.47675>,
            
    /*3*/<-0.68211,0.05159,-0.72943>,<0.74169,0.66838,0.05618>,<-0.0616,-0.70569,0.70584>,
            
    /*4*/<-0.48669,0.72523,0.48701>

    /* stem 0.16.18*/ 
    /*0*/<0.33413,-0.92477,0.18207>,
    /*1*/<0.92058,0.36845,0.12951>,<-0.6269,-0.06329,0.77652>,<-0.30326,-0.27865,-0.91126>,
            
    /*2*/<0.90606,0.40385,0.12634>,<-0.60097,-0.1309,0.78848>,<-0.31776,-0.24776,-0.91523>,
            
    /*3*/<0.90619,0.40119,0.13367>,<-0.58224,-0.19488,0.78932>,<-0.334,-0.17979,-0.92527>,
            
    /*4*/<-0.35375,0.93495,-0.02699>

    /* stem 0.16.19*/ 
    /*0*/<-0.3012,-0.29629,-0.90636>,
    /*1*/<-0.63613,-0.63993,0.43107>,<-0.29056,0.93595,-0.19893>,<0.93527,-0.28758,-0.20632>,
            
    /*2*/<-0.6136,-0.5668,0.54976>,<-0.36311,0.84686,-0.38855>,<0.95597,-0.24795,-0.15695>,
            
    /*3*/<-0.5797,-0.45682,0.67473>,<-0.40312,0.59391,-0.69626>,<0.99461,-0.10308,0.01095>,
            
    /*4*/<-0.06246,0.86436,0.49898>

    /* stem 0.16.20*/ 
    /*0*/<0.87159,-0.41058,-0.26788>,
    /*1*/<0.047,0.629,-0.77598>,<0.38602,0.26612,0.88327>,<-0.45767,-0.88352,-0.09971>,
            
    /*2*/<0.06021,0.61902,-0.78306>,<0.51598,0.16953,0.83966>,<-0.60635,-0.79484,-0.02391>,
            
    /*3*/<0.09948,0.55413,-0.82647>,<0.67968,0.04099,0.73236>,<-0.80677,-0.58067,0.10927>,
            
    /*4*/<-0.37985,0.82715,0.41417>

    /* stem 0.16.21*/ 
    /*0*/<-0.37559,-0.92068,-0.1062>,
    /*1*/<0.55767,-0.30698,0.77121>,<-0.91707,0.36509,0.16029>,<0.36922,-0.03403,-0.92872>,
            
    /*2*/<0.55412,-0.31816,0.76924>,<-0.94625,0.2896,0.14401>,<0.39763,0.05562,-0.91586>,
            
    /*3*/<0.55855,-0.28295,0.77972>,<-0.98239,0.14412,0.11893>,<0.42496,0.16313,-0.89039>,
            
    /*4*/<0.09145,0.96791,0.23408>

    /* stem 0.16.22*/ 
    /*0*/<0.41678,-0.09898,-0.9036>,
    /*1*/<-0.9079,-0.14173,-0.3945>,<0.37192,0.9249,0.07897>,<0.52611,-0.78083,0.33692>,
            
    /*2*/<-0.96342,-0.06994,-0.25871>,<0.46237,0.8661,-0.18995>,<0.51564,-0.74443,0.4242>,
            
    /*3*/<-0.96839,-0.13851,-0.20743>,<0.5445,0.71236,-0.44279>,<0.41039,-0.58279,0.70138>,
            
    /*4*/<-0.40043,0.73224,0.55088>

    /* stem 0.16.23*/ 
    /*0*/<0.43458,-0.88027,0.19042>,
    /*1*/<0.88554,0.39101,-0.25087>,<-0.32065,0.05436,0.94564>,<-0.57418,-0.42654,-0.69884>,
            
    /*2*/<0.91102,0.32819,-0.24966>,<-0.29885,-0.01824,0.95413>,<-0.63246,-0.29104,-0.71784>,
            
    /*3*/<0.91613,0.32316,-0.23721>,<-0.20991,-0.2369,0.94859>,<-0.71708,-0.07685,-0.69274>,
            
    /*4*/<-0.29684,0.89774,0.32551>

    /* stem 0.16.24*/ 
    /*0*/<-0.50789,-0.53345,-0.67637>,
    /*1*/<-0.42509,-0.52166,0.73971>,<-0.43007,0.8401,-0.33055>,<0.86452,-0.30861,-0.39669>,
            
    /*2*/<-0.4189,-0.51158,0.75021>,<-0.46854,0.79346,-0.38845>,<0.89622,-0.26728,-0.35404>,
            
    /*3*/<-0.401,-0.4617,0.79122>,<-0.55495,0.63228,-0.5406>,<0.95522,-0.14888,-0.25573>,
            
    /*4*/<0.17145,0.8387,0.5169>

    /* stem 0.16.25*/ 
    /*0*/<0.87476,-0.30408,-0.37727>,
    /*1*/<-0.23697,0.42103,-0.87554>,<0.48004,0.53247,0.69716>,<-0.25621,-0.94894,0.18405>,
            
    /*2*/<-0.24861,0.43563,-0.86511>,<0.69822,0.38732,0.60206>,<-0.42807,-0.84293,0.32593>,
            
    /*3*/<-0.24329,0.30475,-0.92084>,<0.88996,0.17724,0.42019>,<-0.705,-0.47144,0.52983>,
            
    /*4*/<-0.16899,0.96801,0.18547>

    /* stem 0.16.26*/ 
    /*0*/<-0.17941,-0.98292,0.04104>,
    /*1*/<0.78522,-0.1142,0.6086>,<-0.90562,0.18495,0.38162>,<0.12237,-0.05999,-0.99067>,
            
    /*2*/<0.78232,0.07368,0.61851>,<-0.9116,-0.01892,0.41065>,<0.11945,-0.0462,-0.99177>,
            
    /*3*/<0.80307,0.05923,0.59293>,<-0.90341,-0.23319,0.35983>,<0.13627,0.19776,-0.97073>,
            
    /*4*/<-0.10116,0.91888,0.38136>

    /* stem 0.16.27*/ 
    /*0*/<0.10568,-0.20375,-0.9733>,
    /*1*/<-0.96964,-0.23866,-0.05334>,<0.29276,0.94211,-0.16345>,<0.67627,-0.70228,0.22242>,
            
    /*2*/<-0.9599,-0.26519,-0.09089>,<0.36092,0.86758,-0.34212>,<0.65023,-0.59715,0.4697>,
            
    /*3*/<-0.909,-0.37512,-0.18167>,<0.484,0.63919,-0.59765>,<0.45086,-0.23211,0.86189>,
            
    /*4*/<-0.51567,0.83993,0.16914>

    /* stem 0.16.28*/ 
    /*0*/<0.60954,-0.78794,0.08721>,
    /*1*/<0.70034,0.48449,-0.5242>,<-0.02958,0.08805,0.99568>,<-0.67182,-0.57117,-0.47162>,
            
    /*2*/<0.71398,0.46252,-0.52565>,<0.01533,0.01215,0.99981>,<-0.74028,-0.47777,-0.473>,
            
    /*3*/<0.71485,0.46377,-0.52336>,<0.11004,-0.13513,0.9847>,<-0.82678,-0.3297,-0.45577>,
            
    /*4*/<-0.4175,0.87228,0.25458>

    /* stem 0.17*/ 
    /*0*/<-0.00368,-0.15984,0.98714>,
    /*1*/<0.99971,-0.02127,-0.01162>,<0.33069,0.93323,0.14044>,<-0.79527,0.60064,0.08239>,
            <-0.82214,-0.55942,-0.10556>,<0.28722,-0.94378,-0.16366>,
    /*2*/<0.99952,-0.02582,0.01718>,<0.33077,0.93289,0.14252>,<-0.79444,0.60486,0.05493>,
            <-0.8215,-0.55643,-0.1246>,<0.28701,-0.94643,-0.14799>,
    /*3*/<0.99605,-0.04212,0.07823>,<0.32355,0.89919,0.29458>,<-0.79634,0.59872,0.08588>,
            <-0.81358,-0.52278,-0.25454>,<0.29504,-0.91958,-0.25947>,
    /*4*/<0.99448,-0.04607,0.09431>,<0.29996,0.80353,0.51416>,<-0.8087,0.55006,0.20842>,
            <-0.79652,-0.4556,-0.39747>,<0.31757,-0.82459,-0.46818>,
    /*5*/<0.99677,-0.02657,0.07576>,<0.27747,0.68219,0.67648>,<-0.82588,0.45804,0.32883>,
            <-0.78486,-0.38754,-0.48354>,<0.34153,-0.6877,-0.64065>,
    /*6*/<0.07067,0.7762,-0.62651>

    /* stem 0.17.0*/ 
    /*0*/<-0.4009,-0.57431,0.71376>,
    /*1*/<-0.74687,0.65811,0.09524>,<-0.07439,-0.74855,-0.65889>,<0.83396,0.10864,0.54103>,
            
    /*2*/<-0.81523,0.50776,0.27853>,<-0.07145,-0.69791,-0.71261>,<0.86477,0.22716,0.44786>,
            
    /*3*/<-0.79412,0.30843,0.52368>,<-0.12792,-0.60154,-0.78853>,<0.91476,0.31729,0.25007>,
            
    /*4*/<-0.16562,0.81731,-0.55189>

    /* stem 0.17.1*/ 
    /*0*/<0.60759,-0.03397,0.79353>,
    /*1*/<0.14469,-0.97549,-0.1658>,<0.59331,0.67495,-0.43866>,<-0.75718,0.30161,0.5794>,
            
    /*2*/<0.12014,-0.97102,-0.20662>,<0.64527,0.66952,-0.36793>,<-0.77845,0.30751,0.54722>,
            
    /*3*/<0.01878,-0.92528,-0.37882>,<0.75447,0.62229,-0.20865>,<-0.78129,0.29965,0.54754>,
            
    /*4*/<-0.43243,0.46135,-0.7747>

    /* stem 0.17.2*/ 
    /*0*/<-0.529,0.19025,0.82702>,
    /*1*/<0.52518,0.84104,0.12978>,<-0.83526,0.01209,-0.54973>,<0.32671,-0.85911,0.39395>,
            
    /*2*/<0.43486,0.83897,0.32714>,<-0.84503,0.01014,-0.53463>,<0.47388,-0.85681,0.20326>,
            
    /*3*/<0.24893,0.73441,0.6314>,<-0.83826,0.07042,-0.54071>,<0.6128,-0.78464,-0.09394>,
            
    /*4*/<0.50239,0.5961,-0.62632>

    /* stem 0.17.3*/ 
    /*0*/<0.19443,-0.70188,0.68525>,
    /*1*/<-0.94924,-0.30842,-0.06182>,<0.69218,-0.38769,-0.60875>,<0.25096,0.71812,0.64909>,
            
    /*2*/<-0.95946,-0.25359,-0.12299>,<0.70305,-0.45029,-0.55042>,<0.25151,0.72021,0.64656>,
            
    /*3*/<-0.95618,-0.22595,-0.18616>,<0.72924,-0.45229,-0.51347>,<0.22818,0.69982,0.6769>,
            
    /*4*/<-0.07374,0.74086,-0.6676>

    /* stem 0.17.4*/ 
    /*0*/<0.22536,0.45303,0.86254>,
    /*1*/<0.92923,-0.36398,-0.06368>,<-0.22123,0.88146,-0.41724>,<-0.71504,-0.53163,0.45398>,
            
    /*2*/<0.90037,-0.36455,-0.23756>,<-0.11038,0.99088,-0.07726>,<-0.77674,-0.53198,0.33716>,
            
    /*3*/<0.75603,-0.31252,-0.57511>,<0.07464,0.91282,0.40147>,<-0.8114,-0.56351,0.1552>,
            
    /*4*/<-0.49655,0.56218,-0.66135>

    /* stem 0.17.5*/ 
    /*0*/<-0.53576,-0.41452,0.73562>,
    /*1*/<-0.47449,0.87048,0.13084>,<-0.35595,-0.67037,-0.65108>,<0.8471,-0.18722,0.49736>,
            
    /*2*/<-0.49992,0.84355,0.19621>,<-0.39194,-0.72476,-0.56666>,<0.93227,-0.10933,0.34486>,
            
    /*3*/<-0.49764,0.76575,0.40742>,<-0.46645,-0.77998,-0.4172>,<0.99852,0.04972,-0.02209>,
            
    /*4*/<-0.24374,0.49176,-0.83592>

    /* stem 0.17.6*/ 
    /*0*/<0.64298,-0.24798,0.72463>,
    /*1*/<-0.20687,-0.96504,-0.16095>,<0.73364,0.44617,-0.51255>,<-0.5467,0.52656,0.65104>,
            
    /*2*/<-0.24602,-0.94146,-0.23048>,<0.82513,0.40156,-0.39738>,<-0.57822,0.55252,0.60032>,
            
    /*3*/<-0.28056,-0.83515,-0.47308>,<0.97511,0.22069,-0.02156>,<-0.63278,0.60616,0.48183>,
            
    /*4*/<0.12264,0.61278,-0.78068>

    /* stem 0.17.7*/ 
    /*0*/<-0.40626,0.32996,0.8521>,
    /*1*/<0.78605,0.60465,0.12858>,<-0.79622,0.31789,-0.51477>,<0.02269,-0.9327,0.35993>,
            
    /*2*/<0.77493,0.60872,0.17014>,<-0.8679,0.33457,-0.36716>,<0.08828,-0.98341,0.15846>,
            
    /*3*/<0.76004,0.58561,0.28177>,<-0.93511,0.34444,-0.08317>,<0.17735,-0.95224,-0.24857>,
            
    /*4*/<0.0922,0.45042,-0.88805>

    /* stem 0.17.8*/ 
    /*0*/<-0.05866,-0.88039,0.47061>,
    /*1*/<-0.99708,0.04504,-0.06175>,<0.52816,-0.41853,-0.73884>,<0.47071,0.40049,0.78616>,
            
    /*2*/<-0.99844,0.02893,-0.04772>,<0.53587,-0.54194,-0.64742>,<0.49113,0.54328,0.68091>,
            
    /*3*/<-0.99942,0.01396,-0.03103>,<0.50761,-0.68196,-0.52655>,<0.49355,0.6862,0.53435>,
            
    /*4*/<0.0231,0.58245,-0.81254>

    /* stem 0.17.9*/ 
    /*0*/<0.37205,0.35403,0.85805>,
    /*1*/<0.74287,-0.66685,-0.05882>,<0.10038,0.89899,-0.4263>,<-0.85461,-0.24295,0.45894>,
            
    /*2*/<0.70117,-0.69769,-0.14694>,<0.12863,0.91728,-0.37689>,<-0.83721,-0.23302,0.49475>,
            
    /*3*/<0.60405,-0.72867,-0.32275>,<0.28339,0.95073,-0.12569>,<-0.88184,-0.18454,0.43394>,
            
    /*4*/<-0.37147,0.2309,-0.89928>

    /* stem 0.17.10*/ 
    /*0*/<-0.6605,-0.19738,0.72442>,
    /*1*/<-0.13957,0.98212,0.12635>,<-0.55792,-0.50335,-0.65982>,<0.71757,-0.47277,0.51146>,
            
    /*2*/<-0.16312,0.97213,0.16837>,<-0.61867,-0.54023,-0.57044>,<0.81483,-0.44038,0.37698>,
            
    /*3*/<-0.20692,0.85967,0.46707>,<-0.6984,-0.53721,-0.4729>,<0.96306,-0.26888,0.01503>,
            
    /*4*/<-0.04828,0.68487,-0.72707>

    /* stem 0.17.11*/ 
    /*0*/<0.44927,-0.42506,0.7858>,
    /*1*/<-0.52709,-0.8341,-0.16264>,<0.88425,0.12805,-0.44911>,<-0.37074,0.71889,0.58801>,
            
    /*2*/<-0.52606,-0.83501,-0.1613>,<0.90427,0.11026,-0.41248>,<-0.38974,0.7389,0.54967>,
            
    /*3*/<-0.535,-0.80815,-0.24632>,<0.9929,-0.01929,-0.11741>,<-0.40081,0.84067,0.36419>,
            
    /*4*/<0.16198,0.29683,-0.94109>

    /* stem 0.17.12*/ 
    /*0*/<-0.30358,0.1565,0.93986>,
    /*1*/<0.93521,0.25116,0.24961>,<-0.63365,0.6989,-0.3317>,<-0.29245,-0.95476,0.05388>,
            
    /*2*/<0.93825,0.25095,0.23813>,<-0.65439,0.70663,-0.26917>,<-0.27908,-0.96027,0.00167>,
            
    /*3*/<0.93359,0.24265,0.26367>,<-0.73146,0.68007,-0.04969>,<-0.22249,-0.93869,-0.26337>,
            
    /*4*/<0.20043,0.41019,-0.8897>

    /* stem 0.17.13*/ 
    /*0*/<-0.3283,-0.87046,0.36676>,
    /*1*/<-0.92697,0.37389,0.03054>,<0.32659,-0.45972,-0.82583>,<0.61016,0.11176,0.78436>,
            
    /*2*/<-0.93707,0.34653,0.04266>,<0.32727,-0.45679,-0.82718>,<0.61829,0.13676,0.77396>,
            
    /*3*/<-0.91486,0.40276,0.02848>,<0.32011,-0.4612,-0.82754>,<0.6015,0.08841,0.79396>,
            
    /*4*/<0.44805,0.83641,-0.31571>

    /* stem 0.17.14*/ 
    /*0*/<0.4635,-0.05764,0.88422>,
    /*1*/<0.48845,-0.81175,-0.32012>,<0.3865,0.90926,-0.15449>,<-0.88867,-0.0958,0.44842>,
            
    /*2*/<0.41202,-0.74971,-0.51786>,<0.51807,0.85457,0.03624>,<-0.89381,-0.08863,0.4396>,
            
    /*3*/<0.29469,-0.57873,-0.76041>,<0.64343,0.66715,0.37538>,<-0.92459,-0.06233,0.37582>,
            
    /*4*/<-0.22223,0.79889,-0.55892>

    /* stem 0.17.15*/ 
    /*0*/<-0.75225,-0.17091,0.63633>,
    /*1*/<0.18227,0.88098,0.43664>,<-0.63016,-0.05307,-0.77465>,<0.47007,-0.82287,0.31925>,
            
    /*2*/<0.08285,0.83949,0.53703>,<-0.6318,-0.05269,-0.77334>,<0.58405,-0.77698,0.23495>,
            
    /*3*/<-0.04953,0.73397,0.67738>,<-0.69322,-0.10547,-0.71297>,<0.78142,-0.62392,0.01009>,
            
    /*4*/<0.35582,0.70857,-0.60936>

    /* stem 0.17.16*/ 
    /*0*/<0.36634,-0.82135,0.43724>,
    /*1*/<-0.76452,-0.52683,-0.37142>,<0.84059,0.10378,-0.53164>,<-0.08679,0.44709,0.89027>,
            
    /*2*/<-0.76173,-0.53385,-0.3671>,<0.87508,0.03189,-0.48292>,<-0.11636,0.53099,0.83935>,
            
    /*3*/<-0.74239,-0.58901,-0.31925>,<0.89163,-0.03096,-0.45171>,<-0.16055,0.63871,0.75251>,
            
    /*4*/<-0.3338,0.65768,-0.6753>

    /* stem 0.17.17*/ 
    /*0*/<-0.08905,0.06303,0.99403>,
    /*1*/<0.99579,-0.04078,0.08206>,<-0.45701,0.88304,-0.10667>,<-0.53619,-0.84409,-0.00426>,
            
    /*2*/<0.99925,-0.02535,0.0292>,<-0.48141,0.87002,0.10636>,<-0.54658,-0.82378,-0.15043>,
            
    /*3*/<0.99357,0.0243,-0.1106>,<-0.46386,0.77794,0.42385>,<-0.53209,-0.77977,-0.32991>,
            
    /*4*/<-0.18755,0.51716,-0.83509>

    /* stem 0.17.18*/ 
    /*0*/<-0.47879,-0.83619,0.26746>,
    /*1*/<-0.77223,0.55347,0.31198>,<0.0389,-0.31417,-0.94857>,<0.74715,-0.21515,0.62887>,
            
    /*2*/<-0.78347,0.53373,0.31829>,<0.0438,-0.30457,-0.95148>,<0.75269,-0.20451,0.62581>,
            
    /*3*/<-0.80863,0.48288,0.33606>,<0.03253,-0.33742,-0.94079>,<0.79214,-0.12069,0.59829>,
            
    /*4*/<0.31537,0.87635,-0.36407>

    /* stem 0.17.19*/ 
    /*0*/<0.606,-0.36202,0.70831>,
    /*1*/<0.18947,-0.792,-0.58037>,<0.56437,0.822,-0.07621>,<-0.7712,-0.01962,0.63629>,
            
    /*2*/<0.12297,-0.69005,-0.71323>,<0.72001,0.68751,0.09447>,<-0.79941,0.027,0.60018>,
            
    /*3*/<0.0534,-0.54055,-0.83961>,<0.81154,0.4744,0.3411>,<-0.86793,0.09036,0.4884>,
            
    /*4*/<-0.1492,0.83718,-0.52618>

    /* stem 0.17.20*/ 
    /*0*/<-0.74725,-0.02633,0.66402>,
    /*1*/<0.48477,0.67354,0.55798>,<-0.63182,0.30346,-0.71325>,<0.16828,-0.97626,0.1364>,
            
    /*2*/<0.40026,0.61319,0.68102>,<-0.7267,0.24349,-0.64236>,<0.41842,-0.90346,-0.09317>,
            
    /*3*/<0.23359,0.43808,0.86806>,<-0.85501,0.20486,-0.47644>,<0.66032,-0.63182,-0.40593>,
            
    /*4*/<0.34601,0.86481,-0.36383>

    /* stem 0.17.21*/ 
    /*0*/<0.1535,-0.94768,0.27989>,
    /*1*/<-0.92847,-0.2278,-0.29335>,<0.75819,-0.05972,-0.64929>,<0.16625,0.31239,0.93529>,
            
    /*2*/<-0.93394,-0.16606,-0.31652>,<0.76671,-0.13932,-0.6267>,<0.16633,0.32792,0.92995>,
            
    /*3*/<-0.90642,0.0251,-0.42163>,<0.75536,-0.38736,-0.52856>,<0.15864,0.36875,0.91589>,
            
    /*4*/<0.37535,0.82598,-0.42056>

    /* stem 0.17.22*/ 
    /*0*/<0.10365,-0.06414,0.99254>,
    /*1*/<0.94194,-0.31109,-0.12637>,<-0.19777,0.97731,0.07591>,<-0.74661,-0.66471,0.02712>,
            
    /*2*/<0.94259,-0.29863,-0.1495>,<-0.20369,0.92866,0.30999>,<-0.78159,-0.60191,-0.16375>,
            
    /*3*/<0.94966,-0.23577,-0.20627>,<-0.20718,0.67901,0.70429>,<-0.77452,-0.41502,-0.47736>,
            
    /*4*/<0.05213,0.86959,-0.49101>

    /* stem 0.17.23*/ 
    /*0*/<-0.54669,-0.80108,0.24371>,
    /*1*/<-0.5335,0.56426,0.63007>,<-0.28388,-0.08825,-0.95479>,<0.82854,-0.45966,0.31975>,
            
    /*2*/<-0.49492,0.61833,0.61051>,<-0.31029,-0.12138,-0.94286>,<0.81461,-0.47861,0.32765>,
            
    /*3*/<-0.46358,0.68197,0.5657>,<-0.32635,-0.1859,-0.92679>,<0.80193,-0.48153,0.3536>,
            
    /*4*/<0.59383,0.7103,-0.37796>

    /* stem 0.17.24*/ 
    /*0*/<0.6456,-0.64705,0.40563>,
    /*1*/<-0.13243,-0.61199,-0.7797>,<0.71251,0.70102,-0.03004>,<-0.59127,-0.07781,0.80271>,
            
    /*2*/<-0.12557,-0.62146,-0.77332>,<0.77633,0.62975,0.02685>,<-0.66154,0.01195,0.74982>,
            
    /*3*/<-0.13514,-0.58136,-0.80234>,<0.87589,0.46409,0.13206>,<-0.73762,0.13236,0.66212>,
            
    /*4*/<-0.23946,0.83611,-0.49354>

    /* stem 0.17.25*/ 
    /*0*/<-0.538,-0.1725,0.82511>,
    /*1*/<0.73704,0.38538,0.5552>,<-0.72288,0.59392,-0.35312>,<-0.00624,-0.97676,-0.21423>,
            
    /*2*/<0.68816,0.32196,0.65021>,<-0.80397,0.53049,-0.26873>,<0.14649,-0.88456,-0.44282>,
            
    /*3*/<0.61741,0.2709,0.73852>,<-0.92132,0.38476,-0.05585>,<0.29566,-0.64923,-0.70078>,
            
    /*4*/<0.22724,0.83113,-0.50752>

    /* stem 0.17.26*/ 
    /*0*/<-0.01795,-0.99404,-0.10756>,
    /*1*/<-0.99641,0.03038,-0.07905>,<0.56919,0.08208,-0.8181>,<0.42742,-0.10109,0.89838>,
            
    /*2*/<-0.9973,-0.03353,-0.06538>,<0.59066,-0.06094,-0.80462>,<0.43439,0.12306,0.89228>,
            
    /*3*/<-0.99433,-0.04518,-0.09624>,<0.58376,-0.43713,-0.68421>,<0.4495,0.46192,0.76458>,
            
    /*4*/<0.11015,0.70879,-0.69676>

    /* stem 0.17.27*/ 
    /*0*/<0.30453,-0.34574,0.88754>,
    /*1*/<0.79159,-0.42449,-0.43954>,<0.06104,0.93779,0.3418>,<-0.85472,-0.51093,0.09166>,
            
    /*2*/<0.79587,-0.46713,-0.38521>,<0.06351,0.86537,0.49709>,<-0.91336,-0.38582,-0.13009>,
            
    /*3*/<0.8109,-0.49529,-0.31164>,<0.08207,0.70938,0.70003>,<-0.89707,-0.20645,-0.3907>,
            
    /*4*/<0.19873,0.73423,-0.64916>

    /* stem 0.17.28*/ 
    /*0*/<-0.77459,-0.57785,0.25709>,
    /*1*/<-0.21678,0.62541,0.74958>,<-0.40508,0.14252,-0.90311>,<0.62363,-0.76661,0.15294>,
            
    /*2*/<-0.19826,0.65108,0.73266>,<-0.55402,-0.01311,-0.8324>,<0.74482,-0.664,0.0659>,
            
    /*3*/<-0.15354,0.69614,0.7013>,<-0.71216,-0.19369,-0.67477>,<0.86395,-0.50266,-0.03049>,
            
    /*4*/<0.3271,0.68523,-0.65074>

    /* stem 0.18*/ 
    /*0*/<-0.63488,-0.1779,-0.75185>,
    /*1*/<-0.75833,0.01858,0.65161>,<-0.32613,0.94288,0.06795>,<0.56709,0.56705,-0.59738>,
            <0.68694,-0.58953,-0.42493>,<-0.13221,-0.9285,0.34699>,
    /*2*/<-0.7793,0.01139,0.62654>,<-0.37158,0.92832,0.01251>,<0.55998,0.56481,-0.60615>,
            <0.72714,-0.57486,-0.37524>,<-0.10051,-0.91676,0.38658>,
    /*3*/<-0.77523,0.01409,0.63152>,<-0.45339,0.88724,-0.08507>,<0.5054,0.53991,-0.6731>,
            <0.77367,-0.54781,-0.31834>,<-0.01732,-0.87295,0.4875>,
    /*4*/<-0.75107,0.0387,0.65909>,<-0.5373,0.8214,-0.19133>,<0.4297,0.47611,-0.76725>,
            <0.81079,-0.51813,-0.27232>,<0.08111,-0.78897,0.60906>,
    /*5*/<-0.7827,0.00253,0.62239>,<-0.61091,0.7417,-0.27688>,<0.41277,0.46551,-0.78289>,
            <0.87414,-0.44361,-0.19773>,<0.13545,-0.72965,0.67027>,
    /*6*/<0.40993,0.65568,0.63407>

    /* stem 0.18.0*/ 
    /*0*/<-0.10869,-0.63365,-0.76594>,
    /*1*/<0.52226,0.62649,-0.57858>,<0.47366,-0.70408,0.52907>,<-0.99247,0.0977,0.07382>,
            
    /*2*/<0.5279,0.69394,-0.48966>,<0.474,-0.72691,0.49691>,<-0.9981,0.05977,0.01464>,
            
    /*3*/<0.57952,0.5963,-0.5555>,<0.4368,-0.70023,0.56471>,<-0.99124,0.13142,-0.0132>,
            
    /*4*/<0.17352,0.76554,0.61955>

    /* stem 0.18.1*/ 
    /*0*/<-0.9843,-0.01345,-0.17596>,
    /*1*/<-0.02221,-0.96591,0.25794>,<-0.12354,0.70643,0.69692>,<0.17685,0.2599,-0.9493>,
            
    /*2*/<0.22917,-0.9213,0.31415>,<-0.28428,0.66205,0.69345>,<0.11016,0.23371,-0.96605>,
            
    /*3*/<0.41982,-0.83487,0.35601>,<-0.61804,0.56037,0.55138>,<0.21469,0.3287,-0.91971>,
            
    /*4*/<0.64945,0.5183,0.5564>

    /* stem 0.18.2*/ 
    /*0*/<0.0443,0.24315,-0.96898>,
    /*1*/<-0.47166,0.85773,0.20451>,<0.99797,-0.04474,0.04523>,<-0.52771,-0.82065,-0.21922>,
            
    /*2*/<-0.47153,0.87758,0.08666>,<0.99725,-0.04444,0.05927>,<-0.53954,-0.83386,-0.1165>,
            
    /*3*/<-0.46909,0.87297,-0.13368>,<0.99708,-0.0752,-0.013>,<-0.54626,-0.81455,0.19521>,
            
    /*4*/<0.14255,0.35441,0.92416>

    /* stem 0.18.3*/ 
    /*0*/<-0.57534,-0.7608,-0.30028>,
    /*1*/<0.76051,-0.34404,-0.55069>,<-0.09786,-0.28821,0.95255>,<-0.6446,0.65611,-0.39244>,
            
    /*2*/<0.765,-0.34007,-0.54693>,<-0.16575,-0.36357,0.9167>,<-0.58873,0.72803,-0.35124>,
            
    /*3*/<0.78067,-0.32632,-0.53298>,<-0.22408,-0.43093,0.87412>,<-0.53792,0.77714,-0.32663>,
            
    /*4*/<0.58872,0.6533,0.47604>

    /* stem 0.18.4*/ 
    /*0*/<-0.6784,0.60869,-0.41142>,
    /*1*/<-0.67769,-0.32735,0.65847>,<0.57992,0.78248,0.22676>,<0.11898,-0.47415,-0.87237>,
            
    /*2*/<-0.61205,-0.34843,0.70992>,<0.38017,0.92074,0.08786>,<0.2624,-0.52766,-0.80791>,
            
    /*3*/<-0.43093,-0.3391,0.83625>,<-0.09542,0.97242,-0.21282>,<0.5081,-0.56946,-0.64618>,
            
    /*4*/<0.77927,0.46098,0.42455>

    /* stem 0.18.5*/ 
    /*0*/<0.11861,-0.49795,-0.85906>,
    /*1*/<0.29338,0.84897,-0.43952>,<0.6726,-0.58986,0.44685>,<-0.96968,-0.24362,0.0194>,
            
    /*2*/<0.29298,0.87789,-0.37878>,<0.68405,-0.63767,0.35419>,<-0.97156,-0.23079,0.05296>,
            
    /*3*/<0.2989,0.8591,-0.41546>,<0.66231,-0.70803,0.24505>,<-0.97132,-0.13056,0.19873>,
            
    /*4*/<0.23699,0.46758,0.85159>

    /* stem 0.18.6*/ 
    /*0*/<-0.94661,-0.31481,0.06951>,
    /*1*/<0.33142,-0.93355,0.13657>,<-0.13205,0.60356,0.7863>,<-0.16999,0.33975,-0.92503>,
            
    /*2*/<0.44024,-0.88541,0.14915>,<-0.28296,0.5364,0.79512>,<-0.13593,0.36151,-0.92241>,
            
    /*3*/<0.59226,-0.78262,0.19163>,<-0.53101,0.40958,0.7418>,<-0.04547,0.39285,-0.91848>,
            
    /*4*/<0.68416,0.6664,0.29638>

    /* stem 0.18.7*/ 
    /*0*/<-0.07241,0.36587,-0.92785>,
    /*1*/<-0.7347,0.60496,0.30698>,<0.95184,0.30149,0.05569>,<-0.2149,-0.91774,-0.33402>,
            
    /*2*/<-0.75043,0.65754,0.0671>,<0.94749,0.30189,0.1055>,<-0.24446,-0.95639,-0.15988>,
            
    /*3*/<-0.71442,0.66603,-0.21452>,<0.97532,0.22052,-0.01107>,<-0.24851,-0.92428,0.28975>,
            
    /*4*/<0.09782,0.49771,0.86181>

    /* stem 0.18.8*/ 
    /*0*/<-0.21862,-0.92745,-0.3034>,
    /*1*/<0.80738,0.01367,-0.58987>,<0.07703,-0.31643,0.94548>,<-0.87771,0.33122,-0.34631>,
            
    /*2*/<0.7601,-0.07997,-0.64487>,<0.03046,-0.39426,0.9185>,<-0.80074,0.53399,-0.27141>,
            
    /*3*/<0.69034,-0.16874,-0.70353>,<0.01144,-0.52715,0.8497>,<-0.68513,0.71614,-0.1332>,
            
    /*4*/<0.62827,0.64118,0.44065>

    /* stem 0.18.9*/ 
    /*0*/<-0.86303,0.28355,-0.41807>,
    /*1*/<-0.48931,-0.61803,0.61532>,<0.18518,0.94173,0.2808>,<0.33052,-0.33237,-0.88334>,
            
    /*2*/<-0.49919,-0.61625,0.60913>,<0.05837,0.98014,0.18952>,<0.48248,-0.35486,-0.80081>,
            
    /*3*/<-0.4827,-0.58607,0.65079>,<-0.20612,0.97777,-0.03851>,<0.70636,-0.3619,-0.60835>,
            
    /*4*/<0.61571,0.3545,0.70372>

    /* stem 0.18.10*/ 
    /*0*/<0.282,-0.31844,-0.90503>,
    /*1*/<-0.04486,0.94149,-0.33404>,<0.84818,-0.34916,0.39835>,<-0.8119,-0.58264,-0.03676>,
            
    /*2*/<-0.03591,0.90715,-0.41927>,<0.85902,-0.38104,0.34189>,<-0.8477,-0.51892,0.11011>,
            
    /*3*/<-0.04495,0.82111,-0.56899>,<0.88165,-0.40653,0.23964>,<-0.84568,-0.39723,0.35641>,
            
    /*4*/<0.1413,0.64028,0.75503>

    /* stem 0.18.11*/ 
    /*0*/<-0.82197,-0.5451,-0.16501>,
    /*1*/<0.57075,-0.81686,-0.08354>,<-0.35023,0.27565,0.89519>,<-0.19564,0.55771,-0.80665>,
            
    /*2*/<0.61975,-0.7822,-0.06389>,<-0.43927,0.2123,0.87291>,<-0.16196,0.5866,-0.79352>,
            
    /*3*/<0.7768,-0.62872,0.03586>,<-0.59665,0.07222,0.79925>,<-0.14366,0.56584,-0.81191>,
            
    /*4*/<0.42908,0.80726,0.40524>

    /* stem 0.18.12*/ 
    /*0*/<-0.461,0.16026,-0.87281>,
    /*1*/<-0.80162,0.33352,0.49615>,<0.72872,0.63483,-0.25683>,<0.0868,-0.97318,-0.21303>,
            
    /*2*/<-0.84826,0.34032,0.40575>,<0.728,0.63553,-0.25714>,<0.1249,-0.98504,-0.1187>,
            
    /*3*/<-0.84739,0.39513,0.35469>,<0.60233,0.53113,-0.5959>,<0.32306,-0.93114,0.16916>,
            
    /*4*/<0.58986,0.57196,0.57002>

    /* stem 0.18.13*/ 
    /*0*/<0.00842,-0.93809,-0.34628>,
    /*1*/<0.62172,0.28542,-0.72939>,<0.36717,-0.30984,0.87703>,<-0.98914,0.05241,-0.13731>,
            
    /*2*/<0.62124,0.25245,-0.74184>,<0.36757,-0.30704,0.87785>,<-0.9884,0.08305,-0.12716>,
            
    /*3*/<0.61826,0.28934,-0.73078>,<0.37515,-0.3479,0.8592>,<-0.98899,0.08747,-0.11939>,
            
    /*4*/<-0.0091,0.90036,0.43504>

    /* stem 0.18.14*/ 
    /*0*/<-0.98167,0.03212,-0.18786>,
    /*1*/<-0.13667,-0.75845,0.63724>,<-0.02274,0.94273,0.33277>,<0.18859,-0.18524,-0.96443>,
            
    /*2*/<-0.14005,-0.75816,0.63686>,<-0.13606,0.94509,0.29715>,<0.30688,-0.1751,-0.9355>,
            
    /*3*/<-0.09398,-0.70918,0.69873>,<-0.54328,0.83668,0.06936>,<0.58689,-0.05425,-0.80784>,
            
    /*4*/<0.49314,0.64555,0.58316>

    /* stem 0.18.15*/ 
    /*0*/<0.01847,-0.25448,-0.9669>,
    /*1*/<-0.39769,0.88793,-0.23113>,<0.99303,-0.10351,0.05637>,<-0.59589,-0.77692,0.20325>,
            
    /*2*/<-0.41204,0.85629,-0.31144>,<0.98991,-0.14072,-0.01665>,<-0.58942,-0.71796,0.3703>,
            
    /*3*/<-0.45075,0.78898,-0.41753>,<0.9267,-0.28711,-0.24249>,<-0.45313,-0.5184,0.72521>,
            
    /*4*/<0.55744,0.65966,0.5041>

    /* stem 0.18.16*/ 
    /*0*/<-0.58351,-0.79967,0.14155>,
    /*1*/<0.76111,-0.59063,-0.2681>,<-0.11394,0.26484,0.95754>,<-0.63008,0.3492,-0.69358>,
            
    /*2*/<0.78525,-0.55888,-0.26652>,<-0.18187,0.17441,0.96773>,<-0.59183,0.40967,-0.69419>,
            
    /*3*/<0.83067,-0.49709,-0.25078>,<-0.2997,0.01967,0.95383>,<-0.5175,0.5007,-0.6939>,
            
    /*4*/<0.52717,0.81351,0.24554>

    /* stem 0.18.17*/ 
    /*0*/<-0.65356,0.00466,-0.75686>,
    /*1*/<-0.74992,0.03528,0.66059>,<0.41026,0.84773,-0.33622>,<0.35868,-0.88314,-0.30234>,
            
    /*2*/<-0.68471,0.04636,0.72734>,<0.32753,0.84723,-0.41824>,<0.37504,-0.88067,-0.28942>,
            
    /*3*/<-0.53984,0.10271,0.83548>,<0.00562,0.74549,-0.66649>,<0.53723,-0.81315,-0.22399>,
            
    /*4*/<0.73973,0.61288,0.27782>

    /* stem 0.18.18*/ 
    /*0*/<0.31108,-0.86762,-0.3879>,
    /*1*/<0.33396,0.49067,-0.80481>,<0.59807,-0.12816,0.79113>,<-0.94102,-0.33742,0.02489>,
            
    /*2*/<0.33501,0.45511,-0.82501>,<0.61404,-0.28688,0.73529>,<-0.98006,-0.14939,0.13104>,
            
    /*3*/<0.34512,0.49898,-0.79493>,<0.64126,-0.48082,0.598>,<-0.97815,0.00814,0.20774>,
            
    /*4*/<0.09904,0.76725,0.63366>

    /* stem 0.18.19*/ 
    /*0*/<-0.9676,-0.23953,0.07988>,
    /*1*/<0.24924,-0.77197,0.58475>,<-0.17866,0.89666,0.40507>,<-0.04287,-0.11783,-0.99211>,
            
    /*2*/<0.2509,-0.76986,0.58683>,<-0.3997,0.83741,0.37281>,<0.16017,-0.01702,-0.98694>,
            
    /*3*/<0.23959,-0.75585,0.60934>,<-0.6375,0.70751,0.305>,<0.41728,0.06524,-0.90643>,
            
    /*4*/<0.7135,0.55798,0.42377>

    /* stem 0.18.20*/ 
    /*0*/<-0.12144,-0.2426,-0.9625>,
    /*1*/<-0.70352,0.70623,-0.07937>,<0.95884,0.22841,-0.16867>,<-0.25186,-0.92773,0.27548>,
            
    /*2*/<-0.7498,0.61908,-0.23354>,<0.95638,0.19287,-0.21939>,<-0.23743,-0.82186,0.51786>,
            
    /*3*/<-0.77082,0.49329,-0.40312>,<0.93438,0.22003,-0.2802>,<-0.16092,-0.69412,0.70164>,
            
    /*4*/<0.01855,0.69328,0.72043>

    /* stem 0.18.21*/ 
    /*0*/<-0.30322,-0.94985,0.07642>,
    /*1*/<0.84238,-0.29555,-0.4506>,<-0.02682,0.09821,0.9948>,<-0.80726,0.22335,-0.5463>,
            
    /*2*/<0.85426,-0.27045,-0.44395>,<-0.09968,-0.07054,0.99252>,<-0.76673,0.36647,-0.52708>,
            
    /*3*/<0.86755,-0.24592,-0.4323>,<-0.16926,-0.24293,0.95516>,<-0.68778,0.51169,-0.51491>,
            
    /*4*/<0.40975,0.85663,0.31352>

    /* stem 0.18.22*/ 
    /*0*/<-0.81291,0.13711,-0.56602>,
    /*1*/<-0.57499,-0.23897,0.78248>,<0.27333,0.95051,-0.14773>,<0.32178,-0.71493,-0.62075>,
            
    /*2*/<-0.64348,-0.28014,0.71236>,<0.15664,0.92793,-0.33824>,<0.6369,-0.67941,-0.36435>,
            
    /*3*/<-0.76385,-0.29341,0.57485>,<-0.07659,0.79424,-0.60276>,<0.87316,-0.48591,0.03846>,
            
    /*4*/<0.17765,0.71147,0.67989>

    /* stem 0.18.23*/ 
    /*0*/<0.32881,-0.70383,-0.62968>,
    /*1*/<0.04625,0.68345,-0.72853>,<0.79015,-0.15202,0.59376>,<-0.84339,-0.51648,0.14815>,
            
    /*2*/<0.04674,0.72705,-0.68499>,<0.83595,-0.31589,0.44877>,<-0.86429,-0.42751,0.26501>,
            
    /*3*/<0.00853,0.64972,-0.76013>,<0.85544,-0.41089,0.31527>,<-0.87305,-0.21378,0.43828>,
            
    /*4*/<0.17388,0.84977,0.49764>

    /* stem 0.18.24*/ 
    /*0*/<-0.80275,-0.59626,0.00801>,
    /*1*/<0.55312,-0.72906,0.40316>,<-0.47237,0.65408,0.59081>,<-0.06611,0.08585,-0.99411>,
            
    /*2*/<0.59403,-0.69037,0.41293>,<-0.58627,0.56211,0.58337>,<-0.00803,0.14759,-0.98902>,
            
    /*3*/<0.58084,-0.71617,0.38694>,<-0.75632,0.40529,0.51353>,<0.19939,0.34314,-0.91788>,
            
    /*4*/<0.56168,0.61243,0.55627>

    /* stem 0.18.25*/ 
    /*0*/<-0.16818,-0.08157,-0.98238>,
    /*1*/<-0.88767,0.44448,0.1203>,<0.81479,0.55111,-0.18002>,<0.07548,-0.99433,0.07487>,
            
    /*2*/<-0.93057,0.36412,-0.03826>,<0.81988,0.50576,-0.26834>,<0.10215,-0.91598,0.38801>,
            
    /*3*/<-0.92537,0.32767,-0.19057>,<0.77131,0.33069,-0.54381>,<0.19017,-0.65677,0.72972>,
            
    /*4*/<0.24943,0.83859,0.4843>

    /* stem 0.18.26*/ 
    /*0*/<0.03809,-0.9986,-0.03673>,
    /*1*/<0.81294,0.05614,-0.57964>,<0.09638,-0.0291,0.99492>,<-0.90975,-0.01563,-0.41486>,
            
    /*2*/<0.8063,-0.07499,-0.58673>,<0.10104,-0.00323,0.99488>,<-0.90254,0.08684,-0.42175>,
            
    /*3*/<0.81752,-0.09325,-0.5683>,<0.05915,-0.26404,0.9627>,<-0.88257,0.32201,-0.34261>,
            
    /*4*/<0.27597,0.83161,0.48194>

    /* stem 0.18.27*/ 
    /*0*/<-0.90252,-0.01946,-0.4302>,
    /*1*/<-0.35508,-0.52421,0.77403>,<-0.02767,0.99945,0.01823>,<0.38903,-0.4751,-0.78926>,
            
    /*2*/<-0.32244,-0.52073,0.79049>,<-0.08299,0.99652,-0.00747>,<0.41089,-0.4726,-0.77963>,
            
    /*3*/<-0.32383,-0.54517,0.77326>,<-0.24972,0.96238,-0.10711>,<0.60299,-0.41138,-0.6835>,
            
    /*4*/<0.67221,0.39067,0.6289>

    /* stem 0.18.28*/ 
    /*0*/<0.33432,-0.5164,-0.78839>,
    /*1*/<-0.26601,0.75108,-0.60425>,<0.91584,-0.01865,0.40111>,<-0.65025,-0.73179,0.20411>,
            
    /*2*/<-0.27797,0.77757,-0.56402>,<0.93975,-0.0582,0.33688>,<-0.65733,-0.71813,0.22847>,
            
    /*3*/<-0.27118,0.8323,-0.48347>,<0.96889,-0.21758,0.11793>,<-0.6771,-0.63609,0.37005>,
            
    /*4*/<0.19782,0.49727,0.84475>

    /* stem 0.19*/ 
    /*0*/<0.95705,-0.23541,0.16923>,
    /*1*/<0.16237,0.00066,-0.98673>,<0.26321,0.92638,-0.26934>,<-0.01523,0.57569,0.81752>,
            <-0.28817,-0.56676,0.77185>,<-0.17841,-0.92215,-0.34324>,
    /*2*/<0.15943,0.00179,-0.98721>,<0.31981,0.91117,-0.2598>,<0.02249,0.56524,0.82462>,
            <-0.32082,-0.55689,0.76613>,<-0.23615,-0.90518,-0.35338>,
    /*3*/<0.19718,-0.01379,-0.98027>,<0.46492,0.85441,-0.23202>,<0.07445,0.54695,0.83385>,
            <-0.43206,-0.50875,0.74465>,<-0.35595,-0.85521,-0.37672>,
    /*4*/<0.20829,-0.02047,-0.97785>,<0.59839,0.77435,-0.2057>,<0.14806,0.50796,0.84856>,
            <-0.51905,-0.45156,0.72573>,<-0.48205,-0.77818,-0.40256>,
    /*5*/<0.17279,0.01608,-0.98483>,<0.68264,0.70748,-0.18295>,<0.2369,0.43168,0.87036>,
            <-0.54779,-0.42972,0.71782>,<-0.58734,-0.68669,-0.42836>,
    /*6*/<-0.68418,0.72241,-0.10005>

    /* stem 0.19.0*/ 
    /*0*/<0.43003,-0.70809,0.56008>,
    /*1*/<0.0117,0.63378,0.77342>,<-0.79436,-0.58803,-0.15238>,<0.76903,-0.02331,-0.63879>,
            
    /*2*/<0.01957,0.6253,0.78014>,<-0.7058,-0.70355,-0.08291>,<0.66981,0.0843,-0.73773>,
            
    /*3*/<0.02274,0.62958,0.77661>,<-0.55773,-0.82887,0.04383>,<0.51033,0.21108,-0.83367>,
            
    /*4*/<-0.82904,0.44298,-0.34128>

    /* stem 0.19.1*/ 
    /*0*/<0.75255,-0.01211,-0.65842>,
    /*1*/<-0.20642,-0.95731,-0.20234>,<-0.45242,0.72842,-0.51451>,<0.63508,0.22928,0.73763>,
            
    /*2*/<-0.26536,-0.94746,-0.17861>,<-0.26202,0.71971,-0.64293>,<0.51228,0.26636,0.81647>,
            
    /*3*/<-0.45592,-0.87769,-0.14763>,<0.06806,0.6399,-0.76544>,<0.35671,0.24678,0.90103>,
            
    /*4*/<-0.8244,0.53841,0.1746>

    /* stem 0.19.2*/ 
    /*0*/<0.76276,0.08837,0.64061>,
    /*1*/<0.27988,0.83966,-0.46544>,<-0.65338,0.04151,0.75589>,<0.34952,-0.88395,-0.31058>,
            
    /*2*/<0.35367,0.83028,-0.43076>,<-0.53932,0.01319,0.842>,<0.14399,-0.88273,-0.44728>,
            
    /*3*/<0.51674,0.76926,-0.3758>,<-0.34661,0.01694,0.93786>,<-0.20084,-0.78368,-0.5878>,
            
    /*4*/<-0.79518,0.56091,-0.23036>

    /* stem 0.19.3*/ 
    /*0*/<0.44433,-0.87364,-0.19832>,
    /*1*/<-0.2472,-0.32128,0.91415>,<-0.63019,-0.13497,-0.76462>,<0.86345,0.48365,-0.14331>,
            
    /*2*/<-0.27702,-0.27794,0.91979>,<-0.5786,-0.22958,-0.78264>,<0.83601,0.53044,-0.14045>,
            
    /*3*/<-0.37787,-0.17676,0.90883>,<-0.40735,-0.4516,-0.7938>,<0.76055,0.63544,-0.13335>,
            
    /*4*/<-0.69641,0.67375,-0.24715>

    /* stem 0.19.4*/ 
    /*0*/<0.82905,0.54602,-0.12054>,
    /*1*/<0.07511,-0.34005,-0.9374>,<-0.52926,0.8267,0.19092>,<0.42828,-0.50369,0.75025>,
            
    /*2*/<0.13311,-0.33208,-0.93381>,<-0.31253,0.91965,0.23783>,<0.11617,-0.61591,0.77921>,
            
    /*3*/<0.17263,-0.26277,-0.94929>,<0.10439,0.95226,0.28688>,<-0.30015,-0.66924,0.67973>,
            
    /*4*/<-0.90074,0.3642,-0.2367>

    /* stem 0.19.5*/ 
    /*0*/<0.49722,-0.50694,0.70411>,
    /*1*/<0.10911,0.84794,0.51874>,<-0.80708,-0.57293,0.14273>,<0.68252,-0.25926,-0.68334>,
            
    /*2*/<0.14121,0.81516,0.56177>,<-0.81734,-0.56122,0.13034>,<0.66227,-0.23455,-0.71161>,
            
    /*3*/<0.26259,0.67232,0.69212>,<-0.84976,-0.51728,0.10166>,<0.58825,-0.12234,-0.79937>,
            
    /*4*/<-0.48923,0.80025,-0.34679>

    /* stem 0.19.6*/ 
    /*0*/<0.71413,-0.36384,-0.59802>,
    /*1*/<-0.38229,-0.91644,0.11831>,<-0.33181,0.58867,-0.73714>,<0.692,0.33903,0.63733>,
            
    /*2*/<-0.46266,-0.87297,0.15447>,<-0.1886,0.50641,-0.84142>,<0.63023,0.38772,0.67267>,
            
    /*3*/<-0.606,-0.77194,0.19203>,<0.03137,0.38558,-0.92214>,<0.54892,0.40238,0.73265>,
            
    /*4*/<-0.7081,0.68578,0.16821>

    /* stem 0.19.7*/ 
    /*0*/<0.74999,0.27521,0.60148>,
    /*1*/<0.34655,0.5979,-0.72278>,<-0.66855,0.34678,0.65787>,<0.29888,-0.95316,0.04638>,
            
    /*2*/<0.35871,0.59978,-0.71526>,<-0.54689,0.36332,0.75427>,<0.15325,-0.98739,-0.03973>,
            
    /*3*/<0.53481,0.53544,-0.65367>,<-0.35279,0.37038,0.85928>,<-0.22702,-0.93705,-0.26534>,
            
    /*4*/<-0.71597,0.55229,-0.42704>

    /* stem 0.19.8*/ 
    /*0*/<0.48754,-0.86916,0.08285>,
    /*1*/<-0.17282,0.00871,0.98491>,<-0.66306,-0.41927,-0.62014>,<0.82092,0.43723,-0.36732>,
            
    /*2*/<-0.12879,-0.03263,0.99113>,<-0.56498,-0.53256,-0.63022>,<0.68543,0.61363,-0.39197>,
            
    /*3*/<-0.14394,-0.02918,0.98916>,<-0.40623,-0.70707,-0.57882>,<0.52257,0.74726,-0.4105>,
            
    /*4*/<-0.84564,0.50341,-0.17737>

    /* stem 0.19.9*/ 
    /*0*/<0.87488,0.3287,-0.35574>,
    /*1*/<-0.10601,-0.6038,-0.79006>,<-0.37125,0.92815,-0.02685>,<0.45059,-0.33437,0.82775>,
            
    /*2*/<-0.15593,-0.60305,-0.78232>,<-0.13781,0.98662,-0.08709>,<0.28216,-0.34329,0.89585>,
            
    /*3*/<-0.34137,-0.54912,-0.76285>,<0.25781,0.95002,-0.17604>,<0.06423,-0.37622,0.9243>,
            
    /*4*/<-0.85861,0.46416,0.21758>

    /* stem 0.19.10*/ 
    /*0*/<0.52489,-0.37215,0.7655>,
    /*1*/<0.31131,0.9239,0.22246>,<-0.84783,-0.35103,0.39745>,<0.52056,-0.56156,-0.64317>,
            
    /*2*/<0.42825,0.83959,0.3342>,<-0.83644,-0.36341,0.41025>,<0.42025,-0.4502,-0.78785>,
            
    /*3*/<0.5658,0.69942,0.43667>,<-0.82358,-0.33442,0.45813>,<0.24329,-0.34343,-0.90712>,
            
    /*4*/<-0.52413,0.751,-0.4016>

    /* stem 0.19.11*/ 
    /*0*/<0.68098,-0.57416,-0.45454>,
    /*1*/<-0.39485,-0.80348,0.44555>,<-0.35069,0.30309,-0.88609>,<0.72496,0.51775,0.45428>,
            
    /*2*/<-0.4753,-0.75221,0.45636>,<-0.15501,0.15152,-0.97622>,<0.62584,0.61838,0.47532>,
            
    /*3*/<-0.63172,-0.64569,0.42897>,<0.13715,-0.03188,-0.99004>,<0.4708,0.68965,0.55021>,
            
    /*4*/<-0.71245,0.66135,-0.23459>

    /* stem 0.19.12*/ 
    /*0*/<0.884,0.14308,0.44505>,
    /*1*/<0.39363,0.24981,-0.88468>,<-0.41599,0.70194,0.57813>,<-0.00419,-0.95605,0.29319>,
            
    /*2*/<0.42746,0.24602,-0.86992>,<-0.29482,0.69712,0.65354>,<-0.17508,-0.95961,0.22023>,
            
    /*3*/<0.32158,0.3206,-0.89095>,<0.06102,0.63552,0.76967>,<-0.38433,-0.91343,0.13396>,
            
    /*4*/<-0.8995,0.43688,0.00567>

    /* stem 0.19.13*/ 
    /*0*/<0.11389,-0.93403,0.33854>,
    /*1*/<-0.05542,0.34368,0.93745>,<-0.83305,-0.26661,-0.48471>,<0.88507,-0.04919,-0.46285>,
            
    /*2*/<-0.08509,0.43135,0.89817>,<-0.80988,-0.40817,-0.42129>,<0.87227,-0.00721,-0.48897>,
            
    /*3*/<-0.10329,0.45212,0.88596>,<-0.75716,-0.52935,-0.38275>,<0.85202,0.10303,-0.51327>,
            
    /*4*/<-0.38368,0.84083,-0.38184>

    /* stem 0.19.14*/ 
    /*0*/<0.86086,0.01385,-0.50865>,
    /*1*/<-0.32782,-0.76368,-0.55617>,<-0.19193,0.94068,-0.27979>,<0.49422,-0.17741,0.85104>,
            
    /*2*/<-0.31313,-0.76522,-0.56248>,<-0.07312,0.94177,-0.32822>,<0.36468,-0.16293,0.91677>,
            
    /*3*/<-0.44941,-0.68726,-0.5707>,<0.30532,0.83855,-0.45123>,<0.15551,-0.11193,0.98147>,
            
    /*4*/<-0.75785,0.64429,0.10276>

    /* stem 0.19.15*/ 
    /*0*/<0.43146,-0.19528,0.88075>,
    /*1*/<0.53926,0.83735,-0.08967>,<-0.89951,0.02902,0.43593>,<0.34754,-0.86062,-0.37222>,
            
    /*2*/<0.58051,0.81317,-0.04205>,<-0.83645,-0.03196,0.5471>,<0.2309,-0.80112,-0.55217>,
            
    /*3*/<0.59738,0.80189,-0.01083>,<-0.61067,-0.16481,0.77454>,<-0.02398,-0.64797,-0.76129>,
            
    /*4*/<-0.79608,0.55076,-0.25084>

    /* stem 0.19.16*/ 
    /*0*/<0.51728,-0.82348,-0.23303>,
    /*1*/<-0.51841,-0.50839,0.68759>,<-0.34131,0.06282,-0.93785>,<0.8446,0.46964,0.25707>,
            
    /*2*/<-0.4866,-0.5617,0.66911>,<-0.37739,0.11451,-0.91895>,<0.84514,0.46859,0.25721>,
            
    /*3*/<-0.48684,-0.50861,0.71014>,<-0.41095,0.10243,-0.90588>,<0.87867,0.42692,0.21373>,
            
    /*4*/<-0.39921,0.89193,0.21235>

    /* stem 0.19.17*/ 
    /*0*/<0.98032,-0.02265,0.1961>,
    /*1*/<0.18655,-0.00451,-0.98243>,<-0.08747,0.86834,0.4882>,<-0.12754,-0.86317,0.48854>,
            
    /*2*/<0.25709,-0.04099,-0.96552>,<0.08561,0.81397,0.57456>,<-0.43254,-0.79305,0.42893>,
            
    /*3*/<0.26223,0.04898,-0.96376>,<0.45161,0.61805,0.64348>,<-0.70292,-0.63255,0.32525>,
            
    /*4*/<-0.62596,0.77981,0.00808>

    /* stem 0.19.18*/ 
    /*0*/<0.09595,-0.86483,0.49281>,
    /*1*/<0.24964,0.50844,0.82412>,<-0.96044,-0.20367,-0.18995>,<0.70802,-0.2798,-0.64839>,
            
    /*2*/<0.25661,0.48252,0.83745>,<-0.94743,-0.27863,-0.15729>,<0.68787,-0.18125,-0.70284>,
            
    /*3*/<0.24862,0.48373,0.83916>,<-0.87773,-0.47493,-0.06352>,<0.60812,0.0027,-0.79384>,
            
    /*4*/<-0.56474,0.7667,-0.30534>

    /* stem 0.19.19*/ 
    /*0*/<0.68418,-0.2625,-0.68044>,
    /*1*/<-0.58646,-0.75899,-0.28285>,<-0.09952,0.89643,-0.43186>,<0.66638,-0.12992,0.73421>,
            
    /*2*/<-0.6378,-0.72855,-0.24987>,<0.03341,0.83619,-0.54742>,<0.59629,-0.07743,0.79903>,
            
    /*3*/<-0.6383,-0.7299,-0.24456>,<0.18477,0.74587,-0.63995>,<0.43276,-0.00414,0.9015>,
            
    /*4*/<-0.81113,0.50118,0.30147>

    /* stem 0.19.20*/ 
    /*0*/<0.58493,-0.09381,0.80564>,
    /*1*/<0.63238,0.66745,-0.3932>,<-0.75826,0.30801,0.57461>,<0.10922,-0.97279,-0.20435>,
            
    /*2*/<0.69513,0.63332,-0.34014>,<-0.67396,0.24082,0.69842>,<-0.07231,-0.90973,-0.40886>,
            
    /*3*/<0.88292,0.43862,-0.16751>,<-0.54814,0.26157,0.79443>,<-0.30877,-0.6875,-0.65728>,
            
    /*4*/<-0.257,0.82287,-0.5068>

    /* stem 0.19.21*/ 
    /*0*/<0.02377,-0.96169,-0.2731>,
    /*1*/<-0.39766,-0.25112,0.8825>,<-0.59587,0.21437,-0.77394>,<0.99289,0.0626,-0.10122>,
            
    /*2*/<-0.38453,-0.40714,0.82848>,<-0.608,0.26944,-0.74682>,<0.98745,0.14772,-0.0559>,
            
    /*3*/<-0.28392,-0.62706,0.72539>,<-0.61225,0.25032,-0.74999>,<0.90888,0.41438,0.04725>,
            
    /*4*/<-0.5246,0.66986,0.52544>

    /* stem 0.19.22*/ 
    /*0*/<0.99739,0.05599,-0.04568>,
    /*1*/<-0.03716,-0.26908,-0.9624>,<-0.05095,0.96661,0.25114>,<0.06367,-0.6989,0.71238>,
            
    /*2*/<0.01484,-0.28077,-0.95966>,<0.09398,0.95712,0.27403>,<-0.14637,-0.68154,0.71699>,
            
    /*3*/<0.01114,-0.22085,-0.97524>,<0.4608,0.82796,0.31961>,<-0.45855,-0.57321,0.67908>,
            
    /*4*/<-0.70491,0.70454,-0.08202>

    /* stem 0.19.23*/ 
    /*0*/<0.15775,-0.77801,0.60812>,
    /*1*/<0.52843,0.59199,0.60853>,<-0.98769,-0.09248,0.12613>,<0.45587,-0.48281,-0.74771>,
            
    /*2*/<0.53844,0.5639,0.62618>,<-0.97117,-0.16747,0.16965>,<0.427,-0.38388,-0.81873>,
            
    /*3*/<0.56022,0.51324,0.65018>,<-0.93099,-0.27268,0.24272>,<0.36348,-0.22339,-0.90442>,
            
    /*4*/<-0.38947,0.87016,-0.30188>

    /* stem 0.19.24*/ 
    /*0*/<0.55736,-0.62024,-0.55195>,
    /*1*/<-0.73143,-0.68087,0.03772>,<0.01482,0.67761,-0.73527>,<0.70627,0.01477,0.70779>,
            
    /*2*/<-0.73128,-0.68108,0.03693>,<0.09301,0.60286,-0.79241>,<0.6382,0.1006,0.76327>,
            
    /*3*/<-0.65667,-0.75374,0.02548>,<0.2277,0.47221,-0.85157>,<0.41733,0.30512,0.856>,
            
    /*4*/<-0.82348,0.56729,-0.00818>

    /* stem 0.19.25*/ 
    /*0*/<0.8093,-0.2899,0.51086>,
    /*1*/<0.58166,0.46409,-0.66806>,<-0.3346,0.49573,0.80143>,<-0.25941,-0.95539,-0.14117>,
            
    /*2*/<0.5933,0.4594,-0.66102>,<-0.317,0.48851,0.81293>,<-0.28901,-0.94394,-0.15956>,
            
    /*3*/<0.55429,0.49582,-0.66852>,<-0.17337,0.40663,0.89699>,<-0.39381,-0.89401,-0.2137>,
            
    /*4*/<-0.82926,0.5161,-0.21442>

    /* stem 0.19.26*/ 
    /*0*/<0.13663,-0.99062,-0.00068>,
    /*1*/<-0.16994,-0.02063,0.98524>,<-0.76099,-0.10103,-0.64085>,<0.92952,0.13192,-0.34438>,
            
    /*2*/<-0.17498,0.03914,0.98379>,<-0.76066,-0.10406,-0.64075>,<0.93698,0.07559,-0.3411>,
            
    /*3*/<-0.21095,0.13256,0.96847>,<-0.70301,-0.32601,-0.63206>,<0.9082,0.18399,-0.37592>,
            
    /*4*/<-0.46393,0.84769,-0.25727>

    /* stem 0.19.27*/ 
    /*0*/<0.93927,-0.2468,-0.23844>,
    /*1*/<-0.32818,-0.42523,-0.84349>,<0.2535,0.96731,0.00648>,<0.06855,-0.54047,0.83857>,
            
    /*2*/<-0.35256,-0.41274,-0.83985>,<0.3904,0.92048,-0.01752>,<-0.03356,-0.49423,0.86868>,
            
    /*3*/<-0.35546,-0.4267,-0.83161>,<0.6913,0.72249,-0.0109>,<-0.34119,-0.26547,0.90173>,
            
    /*4*/<-0.53604,0.81014,-0.23733>

    /* stem 0.19.28*/ 
    /*0*/<0.16185,-0.53697,0.82793>,
    /*1*/<0.66906,0.67664,0.30744>,<-0.96278,0.09871,0.25163>,<0.29347,-0.77454,-0.56032>,
            
    /*2*/<0.67709,0.64435,0.35549>,<-0.96707,0.11847,0.22527>,<0.29124,-0.76028,-0.58065>,
            
    /*3*/<0.68128,0.60102,0.4179>,<-0.96408,0.07085,0.25599>,<0.27847,-0.67701,-0.68125>,
            
    /*4*/<-0.21106,0.7259,-0.65462>

    /* stem 0.20*/ 
    /*0*/<-0.84367,-0.23359,0.48338>,
    /*1*/<0.50969,-0.01052,0.86029>,<-0.02195,0.92323,0.38361>,<-0.50961,0.58489,-0.63103>,
            <-0.27935,-0.55797,-0.78143>,<0.35061,-0.92596,0.14026>,
    /*2*/<0.49892,-0.0139,0.86653>,<-0.08649,0.9032,0.42042>,<-0.53869,0.57569,-0.61515>,
            <-0.23323,-0.54206,-0.80732>,<0.40798,-0.90654,0.10832>,
    /*3*/<0.4624,-0.03136,0.88611>,<-0.19313,0.85635,0.47893>,<-0.56809,0.56652,-0.59693>,
            <-0.14541,-0.49934,-0.85411>,<0.49129,-0.86876,0.06236>,
    /*4*/<0.38396,-0.0804,0.91984>,<-0.28457,0.80332,0.52316>,<-0.54592,0.58376,-0.601>,
            <-0.04024,-0.43433,-0.89985>,<0.53428,-0.84437,0.03982>,
    /*5*/<0.30992,-0.13776,0.94073>,<-0.42771,0.70093,0.57076>,<-0.56006,0.57894,-0.59259>,
            <0.09287,-0.33257,-0.93849>,<0.63105,-0.77569,0.00941>,
    /*6*/<0.71318,0.69525,-0.08945>

    /* stem 0.20.0*/ 
    /*0*/<-0.71542,-0.68744,-0.12489>,
    /*1*/<-0.50126,0.6423,-0.57981>,<0.67658,-0.61533,-0.4045>,<-0.15274,-0.00528,0.98825>,
            
    /*2*/<-0.65032,0.52557,-0.5485>,<0.639,-0.66313,-0.38979>,<0.02729,0.20458,0.97847>,
            
    /*3*/<-0.81828,0.37183,-0.43836>,<0.49787,-0.76846,-0.40199>,<0.34748,0.42335,0.83668>,
            
    /*4*/<0.5134,0.55221,-0.65687>

    /* stem 0.20.1*/ 
    /*0*/<-0.15649,-0.02053,0.98747>,
    /*1*/<0.28133,-0.95951,0.01403>,<0.68209,0.72256,0.1125>,<-0.9585,0.23759,-0.15757>,
            
    /*2*/<0.29456,-0.9554,-0.02117>,<0.65268,0.71864,0.23993>,<-0.93659,0.25168,-0.24383>,
            
    /*3*/<0.36106,-0.91407,-0.1847>,<0.59106,0.68507,0.42583>,<-0.93468,0.22531,-0.27497>,
            
    /*4*/<0.27325,0.42255,-0.86417>

    /* stem 0.20.2*/ 
    /*0*/<-0.99307,0.11403,-0.02856>,
    /*1*/<0.09065,0.83412,0.54408>,<0.0446,0.04683,-0.99791>,<-0.10414,-0.88453,0.45472>,
            
    /*2*/<-0.08842,0.82133,0.56356>,<0.01343,0.04097,-0.99907>,<0.11479,-0.87278,0.47443>,
            
    /*3*/<-0.30965,0.76294,0.56749>,<-0.07643,0.04384,-0.99611>,<0.4177,-0.80014,0.43048>,
            
    /*4*/<0.85583,0.50665,-0.10423>

    /* stem 0.20.3*/ 
    /*0*/<-0.33419,-0.82078,0.46328>,
    /*1*/<-0.3992,-0.3115,-0.86232>,<0.94276,-0.24117,0.23032>,<-0.53311,0.57831,0.61753>,
            
    /*2*/<-0.35822,-0.21698,-0.90808>,<0.92335,-0.29144,0.24996>,<-0.55584,0.5341,0.63701>,
            
    /*3*/<-0.27334,-0.11222,-0.95535>,<0.86622,-0.38426,0.31938>,<-0.57596,0.52114,0.62983>,
            
    /*4*/<0.5324,0.81504,-0.2286>

    /* stem 0.20.4*/ 
    /*0*/<-0.63866,0.4303,0.63793>,
    /*1*/<0.54329,-0.34943,0.76337>,<0.21581,0.89039,-0.40079>,<-0.73923,-0.55434,-0.38242>,
            
    /*2*/<0.68903,-0.34402,0.63788>,<-0.02339,0.99289,-0.1167>,<-0.67751,-0.5496,-0.48879>,
            
    /*3*/<0.77747,-0.40145,0.48413>,<-0.41423,0.8784,0.23838>,<-0.38164,-0.44688,-0.80911>,
            
    /*4*/<0.65513,0.66825,-0.35249>

    /* stem 0.20.5*/ 
    /*0*/<-0.88045,-0.46682,-0.083>,
    /*1*/<-0.41045,0.8534,-0.32133>,<0.41011,-0.63497,-0.65469>,<0.02762,-0.20396,0.97859>,
            
    /*2*/<-0.49187,0.80872,-0.32256>,<0.41704,-0.62962,-0.65549>,<0.09706,-0.15756,0.98273>,
            
    /*3*/<-0.49922,0.80429,-0.32232>,<0.33149,-0.67107,-0.66315>,<0.1928,-0.11927,0.97396>,
            
    /*4*/<0.90041,0.41345,-0.13531>

    /* stem 0.20.6*/ 
    /*0*/<-0.35115,-0.41379,0.83992>,
    /*1*/<0.23758,-0.90306,-0.35783>,<0.67174,0.52192,0.52571>,<-0.89848,0.39392,-0.19382>,
            
    /*2*/<0.27651,-0.86575,-0.41716>,<0.62248,0.46062,0.63273>,<-0.87751,0.4214,-0.22889>,
            
    /*3*/<0.43386,-0.70083,-0.56621>,<0.46987,0.27148,0.83995>,<-0.85663,0.43403,-0.27893>,
            
    /*4*/<0.50025,0.80879,-0.30922>

    /* stem 0.20.7*/ 
    /*0*/<-0.98693,0.11012,0.11764>,
    /*1*/<0.16996,0.57616,0.79947>,<-0.05227,0.41086,-0.9102>,<-0.08736,-0.9904,0.10711>,
            
    /*2*/<0.11497,0.56718,0.81553>,<-0.20707,0.3888,-0.89775>,<0.13528,-0.98911,0.058>,
            
    /*3*/<0.01151,0.53385,0.8455>,<-0.39851,0.38152,-0.83405>,<0.41641,-0.909,-0.01811>,
            
    /*4*/<0.84401,0.47905,-0.24114>

    /* stem 0.20.8*/ 
    /*0*/<-0.468,-0.85241,0.23318>,
    /*1*/<-0.4741,0.03156,-0.87991>,<0.88739,-0.4551,0.07361>,<-0.39897,0.44962,0.79916>,
            
    /*2*/<-0.38786,0.14972,-0.90948>,<0.82084,-0.56477,0.08519>,<-0.41006,0.43504,0.80161>,
            
    /*3*/<-0.30733,0.19536,-0.93133>,<0.72753,-0.66707,0.16037>,<-0.40237,0.4962,0.76934>,
            
    /*4*/<0.70248,0.69407,-0.15746>

    /* stem 0.20.9*/ 
    /*0*/<-0.42128,0.3487,0.83722>,
    /*1*/<0.5781,-0.61585,0.53528>,<0.32553,0.91706,-0.23027>,<-0.89081,-0.31182,-0.33049>,
            
    /*2*/<0.61847,-0.61888,0.48424>,<0.20521,0.97791,-0.03963>,<-0.82315,-0.32309,-0.46694>,
            
    /*3*/<0.71961,-0.58723,0.37057>,<-0.05159,0.9541,0.29502>,<-0.6629,-0.33314,-0.6705>,
            
    /*4*/<0.59717,0.45097,-0.66334>

    /* stem 0.20.10*/ 
    /*0*/<-0.8614,-0.3593,-0.35901>,
    /*1*/<-0.39159,0.91888,0.04804>,<0.47957,-0.29642,-0.82592>,<-0.06192,-0.6116,0.78874>,
            
    /*2*/<-0.43511,0.89956,0.03827>,<0.41261,-0.33447,-0.84728>,<0.05356,-0.56096,0.82611>,
            
    /*3*/<-0.53146,0.84644,0.03309>,<0.29505,-0.38239,-0.87563>,<0.265,-0.45056,0.8525>,
            
    /*4*/<0.80445,0.59147,-0.05493>

    /* stem 0.20.11*/ 
    /*0*/<-0.29213,-0.5947,0.749>,
    /*1*/<0.04237,-0.78398,-0.61934>,<0.81071,0.27173,0.51856>,<-0.84429,0.53015,0.07824>,
            
    /*2*/<0.10518,-0.71277,-0.69346>,<0.73872,0.13746,0.65984>,<-0.81044,0.5845,0.03926>,
            
    /*3*/<0.20381,-0.60287,-0.77137>,<0.64259,0.08492,0.76149>,<-0.83986,0.5428,-0.00178>,
            
    /*4*/<0.38026,0.79427,-0.47386>

    /* stem 0.20.12*/ 
    /*0*/<-0.95995,0.15416,0.23395>,
    /*1*/<0.27679,0.25108,0.92755>,<-0.05104,0.69934,-0.71296>,<-0.19698,-0.95504,-0.2216>,
            
    /*2*/<0.27725,0.25231,0.92708>,<-0.19295,0.70297,-0.68455>,<-0.06171,-0.96091,-0.2699>,
            
    /*3*/<0.2302,0.22718,0.94625>,<-0.44768,0.65713,-0.60644>,<0.25378,-0.89274,-0.37232>,
            
    /*4*/<0.80712,0.53433,-0.2511>

    /* stem 0.20.13*/ 
    /*0*/<-0.49142,-0.86909,-0.05641>,
    /*1*/<-0.53281,0.36232,-0.76475>,<0.86701,-0.46766,-0.172>,<-0.31958,0.13121,0.93843>,
            
    /*2*/<-0.57604,0.3032,-0.75911>,<0.83399,-0.52698,-0.16356>,<-0.24452,0.25669,0.93505>,
            
    /*3*/<-0.58319,0.31823,-0.74741>,<0.81125,-0.55425,-0.18626>,<-0.21916,0.26282,0.93963>,
            
    /*4*/<0.54196,0.83987,0.03004>

    /* stem 0.20.14*/ 
    /*0*/<-0.32909,0.05731,0.94256>,
    /*1*/<0.55982,-0.79508,0.23336>,<0.38553,0.92017,0.06822>,<-0.93564,-0.12678,-0.3294>,
            
    /*2*/<0.59557,-0.79402,0.12176>,<0.37038,0.91902,0.13497>,<-0.94954,-0.13073,-0.28512>,
            
    /*3*/<0.62242,-0.7813,-0.04653>,<0.35046,0.89895,0.26282>,<-0.96366,-0.1108,-0.24307>,
            
    /*4*/<0.2019,0.27556,-0.93984>

    /* stem 0.20.15*/ 
    /*0*/<-0.87002,-0.09711,-0.48336>,
    /*1*/<-0.30655,0.86452,0.3983>,<0.49441,-0.00241,-0.86922>,<-0.16237,-0.85926,0.48509>,
            
    /*2*/<-0.52956,0.77505,0.34476>,<0.44897,-0.03753,-0.89276>,<0.11634,-0.74432,0.65761>,
            
    /*3*/<-0.75765,0.6005,0.25568>,<0.32459,-0.02657,-0.94548>,<0.45003,-0.55558,0.69915>,
            
    /*4*/<0.59255,0.79062,0.15427>

    /* stem 0.20.16*/ 
    /*0*/<-0.09691,-0.84016,0.5336>,
    /*1*/<-0.07296,-0.52039,-0.85081>,<0.89742,0.16731,0.40822>,<-0.82164,0.37756,0.42704>,
            
    /*2*/<-0.11235,-0.61832,-0.77786>,<0.88359,0.12594,0.45101>,<-0.79117,0.53086,0.30371>,
            
    /*3*/<-0.09254,-0.56565,-0.81943>,<0.8578,-0.01993,0.5136>,<-0.75754,0.59886,0.25981>,
            
    /*4*/<0.36914,0.83745,-0.403>

    /* stem 0.20.17*/ 
    /*0*/<-0.92133,0.183,0.34301>,
    /*1*/<0.33274,-0.12852,0.93422>,<0.03318,0.90587,-0.42226>,<-0.33929,-0.78264,-0.52188>,
            
    /*2*/<0.34901,-0.12358,0.92894>,<-0.18172,0.91236,-0.36684>,<-0.16117,-0.77607,-0.6097>,
            
    /*3*/<0.30096,-0.1509,0.94162>,<-0.4224,0.86485,-0.27131>,<0.15179,-0.71331,-0.68422>,
            
    /*4*/<0.87741,0.46585,-0.1146>

    /* stem 0.20.18*/ 
    /*0*/<-0.38732,-0.76584,-0.51329>,
    /*1*/<-0.54156,0.64653,-0.53732>,<0.92011,-0.25176,-0.30002>,<-0.36742,-0.37276,0.85209>,
            
    /*2*/<-0.61483,0.51313,-0.5989>,<0.91976,-0.25153,-0.3013>,<-0.31925,-0.23083,0.91913>,
            
    /*3*/<-0.73601,0.24677,-0.63039>,<0.90391,-0.26053,-0.33923>,<-0.17619,0.04779,0.9832>,
            
    /*4*/<0.25417,0.95578,-0.14795>

    /* stem 0.20.19*/ 
    /*0*/<-0.37906,-0.33545,0.86243>,
    /*1*/<0.51515,-0.84935,-0.11498>,<0.41561,0.77648,0.47365>,<-0.91994,0.08245,-0.3833>,
            
    /*2*/<0.54163,-0.82945,-0.13656>,<0.27333,0.6856,0.67472>,<-0.82594,0.19908,-0.52744>,
            
    /*3*/<0.66524,-0.71558,-0.21309>,<0.09945,0.54229,0.83429>,<-0.74242,0.18125,-0.64495>,
            
    /*4*/<0.45616,0.74613,-0.48498>

    /* stem 0.20.20*/ 
    /*0*/<-0.89573,0.12977,-0.42525>,
    /*1*/<-0.22999,0.66576,0.70984>,<0.45265,0.30062,-0.83948>,<-0.19726,-0.97006,0.1417>,
            
    /*2*/<-0.28355,0.64875,0.7062>,<0.20793,0.2204,-0.95299>,<0.18025,-0.95829,0.2218>,
            
    /*3*/<-0.30368,0.65126,0.69545>,<-0.24581,0.14664,-0.95816>,<0.56339,-0.79018,0.24126>,
            
    /*4*/<0.76658,0.57918,-0.27731>

    /* stem 0.20.21*/ 
    /*0*/<-0.1366,-0.97235,0.18943>,
    /*1*/<-0.14499,-0.16067,-0.9763>,<0.9228,-0.04596,0.38254>,<-0.77416,0.23261,0.5887>,
            
    /*2*/<-0.12802,-0.10876,-0.98579>,<0.90054,-0.16201,0.40346>,<-0.75771,0.29211,0.58356>,
            
    /*3*/<-0.06343,0.06211,-0.99605>,<0.85228,-0.29883,0.42931>,<-0.78679,0.26646,0.55674>,
            
    /*4*/<0.29799,0.94177,0.15577>

    /* stem 0.20.22*/ 
    /*0*/<-0.81128,0.16375,0.56126>,
    /*1*/<0.46877,-0.40883,0.78302>,<0.08483,0.9805,-0.17729>,<-0.53469,-0.57548,-0.61881>,
            
    /*2*/<0.45712,-0.41032,0.7891>,<-0.12195,0.98837,-0.09083>,<-0.33655,-0.56052,-0.75667>,
            
    /*3*/<0.4617,-0.37816,0.80239>,<-0.48389,0.87338,0.05533>,<0.01873,-0.46884,-0.88308>,
            
    /*4*/<0.74881,0.64535,-0.151>

    /* stem 0.20.23*/ 
    /*0*/<-0.46025,-0.64406,-0.61102>,
    /*1*/<-0.69342,0.69308,-0.19702>,<0.82808,-0.05151,-0.55823>,<-0.1252,-0.62832,0.76782>,
            
    /*2*/<-0.68354,0.70319,-0.19567>,<0.69344,-0.26609,-0.66958>,<0.04852,-0.47704,0.87754>,
            
    /*3*/<-0.62927,0.75447,-0.18653>,<0.33603,-0.5653,-0.75334>,<0.31675,-0.21239,0.92442>,
            
    /*4*/<0.80103,0.51391,-0.30698>

    /* stem 0.20.24*/ 
    /*0*/<-0.33112,-0.72545,0.6034>,
    /*1*/<0.58596,-0.65538,-0.47657>,<0.35195,0.50391,0.7888>,<-0.93181,0.16484,-0.32334>,
            
    /*2*/<0.61931,-0.59281,-0.51481>,<0.31068,0.406,0.85944>,<-0.91746,0.20174,-0.34288>,
            
    /*3*/<0.66374,-0.49884,-0.55732>,<0.2608,0.35636,0.89721>,<-0.92407,0.15868,-0.34773>,
            
    /*4*/<0.22509,0.86093,-0.45621>

    /* stem 0.20.25*/ 
    /*0*/<-0.97562,-0.15589,-0.15447>,
    /*1*/<-0.19346,0.323,0.92641>,<0.02177,0.64822,-0.76114>,<0.18549,-0.96902,-0.16309>,
            
    /*2*/<-0.31342,0.23308,0.92056>,<-0.10253,0.56167,-0.82098>,<0.53946,-0.83643,-0.09676>,
            
    /*3*/<-0.52713,0.00489,0.84977>,<-0.32735,0.43608,-0.83826>,<0.89862,-0.43849,0.01439>,
            
    /*4*/<0.20771,0.92612,0.3149>

    /* stem 0.20.26*/ 
    /*0*/<0.03607,-0.98239,-0.18331>,
    /*1*/<-0.28063,0.16966,-0.9447>,<0.97078,-0.00543,0.2399>,<-0.69055,-0.15356,0.7068>,
            
    /*2*/<-0.28058,0.16757,-0.94509>,<0.9711,-0.05176,0.233>,<-0.68994,-0.10548,0.71614>,
            
    /*3*/<-0.28141,0.16042,-0.94608>,<0.95768,-0.1888,0.21728>,<-0.6728,0.03795,0.73885>,
            
    /*4*/<0.27183,0.95961,0.07251>

    /* stem 0.20.27*/ 
    /*0*/<-0.68044,-0.08057,0.72836>,
    /*1*/<0.62912,-0.5766,0.52129>,<0.01475,0.99255,0.12091>,<-0.63992,-0.41549,-0.64643>,
            
    /*2*/<0.66801,-0.55959,0.49054>,<-0.12472,0.9605,0.24877>,<-0.55724,-0.37625,-0.74021>,
            
    /*3*/<0.80335,-0.45738,0.38137>,<-0.33852,0.82695,0.44895>,<-0.45062,-0.35974,-0.81703>,
            
    /*4*/<0.47557,0.67209,-0.56756>

    /* stem 0.20.28*/ 
    /*0*/<-0.66192,-0.51974,-0.54012>,
    /*1*/<-0.68058,0.71814,0.14518>,<0.61202,0.04341,-0.78965>,<0.07088,-0.75974,0.64636>,
            
    /*2*/<-0.72366,0.68004,0.11769>,<0.58586,0.01561,-0.81026>,<0.14101,-0.69784,0.70223>,
            
    /*3*/<-0.73659,0.67006,0.09197>,<0.40279,-0.19331,-0.89465>,<0.36189,-0.51235,0.7788>,
            
    /*4*/<0.69633,0.71121,-0.09646>

    /* stem 0.21*/ 
    /*0*/<0.322,-0.28402,-0.90313>,
    /*1*/<-0.94313,0.02574,-0.33142>,<-0.18241,0.92182,-0.342>,<0.8252,0.54857,0.13464>,
            <0.68721,-0.57821,0.43979>,<-0.40568,-0.90133,0.15175>,
    /*2*/<-0.94137,0.02415,-0.33652>,<-0.16454,0.90489,-0.39257>,<0.83483,0.53965,0.10875>,
            <0.67499,-0.56573,0.47364>,<-0.42255,-0.88434,0.19847>,
    /*3*/<-0.94194,0.02599,-0.33477>,<-0.13483,0.86867,-0.47669>,<0.85404,0.51736,0.0543>,
            <0.65732,-0.54204,0.52356>,<-0.45237,-0.84572,0.28305>,
    /*4*/<-0.94207,0.02825,-0.33421>,<-0.11404,0.83906,-0.53195>,<0.867,0.49795,0.01893>,
            <0.64511,-0.52331,0.55675>,<-0.47277,-0.8136,0.33846>,
    /*5*/<-0.93279,0.01038,-0.36028>,<-0.09097,0.79681,-0.59734>,<0.87159,0.49023,0.00424>,
            <0.62483,-0.48458,0.61218>,<-0.49015,-0.78106,0.3869>,
    /*6*/<-0.31814,0.59864,0.73513>

    /* stem 0.21.0*/ 
    /*0*/<0.6019,-0.76012,-0.24482>,
    /*1*/<0.78874,0.60692,0.09768>,<-0.33947,-0.50964,0.79059>,<-0.46822,-0.07335,-0.88056>,
            
    /*2*/<0.88915,0.45472,0.05146>,<-0.37492,-0.4297,0.82146>,<-0.50159,0.00398,-0.86509>,
            
    /*3*/<0.93005,0.36691,-0.01976>,<-0.36906,-0.37481,0.85048>,<-0.56806,0.03686,-0.82216>,
            
    /*4*/<-0.4007,0.87574,0.26929>

    /* stem 0.21.1*/ 
    /*0*/<-0.39831,-0.0728,-0.91436>,
    /*1*/<-0.27455,-0.93929,0.20583>,<-0.61323,0.75919,0.21814>,<0.90028,0.18238,-0.39526>,
            
    /*2*/<-0.27011,-0.93681,0.22234>,<-0.64184,0.75342,0.14279>,<0.92173,0.19213,-0.33689>,
            
    /*3*/<-0.25917,-0.93638,0.23667>,<-0.68307,0.73003,0.02197>,<0.94953,0.2141,-0.22925>,
            
    /*4*/<0.14884,0.19191,0.97006>

    /* stem 0.21.2*/ 
    /*0*/<0.81884,0.09162,-0.56666>,
    /*1*/<-0.37657,0.84034,-0.38989>,<0.55694,0.03968,0.82961>,<-0.20597,-0.88289,-0.42199>,
            
    /*2*/<-0.33049,0.83796,-0.43428>,<0.63099,0.03076,0.77518>,<-0.33298,-0.8865,-0.32132>,
            
    /*3*/<-0.29894,0.84268,-0.4478>,<0.82254,-0.00484,0.56868>,<-0.51972,-0.85007,-0.08532>,
            
    /*4*/<-0.37205,0.30056,0.8782>

    /* stem 0.21.3*/ 
    /*0*/<-0.08479,-0.83815,-0.53881>,
    /*1*/<0.84347,-0.34019,0.41574>,<-0.88092,-0.1799,0.43774>,<0.04009,0.5462,-0.83669>,
            
    /*2*/<0.84285,-0.30905,0.44056>,<-0.88619,-0.25565,0.3864>,<0.03797,0.58791,-0.80804>,
            
    /*3*/<0.82839,-0.26855,0.49158>,<-0.86769,-0.46969,0.16282>,<-0.00415,0.75775,-0.65253>,
            
    /*4*/<-0.35093,0.46941,0.81025>

    /* stem 0.21.4*/ 
    /*0*/<0.03503,0.53472,-0.8443>,
    /*1*/<-0.92324,-0.31229,-0.22384>,<0.12908,0.8297,0.54308>,<0.79307,-0.53401,-0.29304>,
            
    /*2*/<-0.90354,-0.31062,-0.29517>,<0.24194,0.91621,0.31942>,<0.75194,-0.65323,0.08879>,
            
    /*3*/<-0.81807,-0.28719,-0.49829>,<0.35187,0.93565,-0.0273>,<0.455,-0.67063,0.58585>,
            
    /*4*/<-0.68568,0.39545,0.61111>

    /* stem 0.21.5*/ 
    /*0*/<0.76842,-0.55686,-0.31533>,
    /*1*/<0.56343,0.82462,-0.05057>,<-0.04401,-0.52391,0.85063>,<-0.54316,-0.28349,-0.79032>,
            
    /*2*/<0.54634,0.83682,-0.03523>,<0.07158,-0.61756,0.78326>,<-0.6464,-0.22506,-0.72905>,
            
    /*3*/<0.5524,0.83145,-0.05954>,<0.22501,-0.71482,0.66212>,<-0.80366,-0.10452,-0.58583>,
            
    /*4*/<-0.48273,0.44637,0.75348>

    /* stem 0.21.6*/ 
    /*0*/<-0.39863,-0.38625,-0.83181>,
    /*1*/<0.01573,-0.90504,0.42504>,<-0.79588,0.59386,0.11797>,<0.7924,0.32306,-0.51743>,
            
    /*2*/<0.08432,-0.83362,0.54586>,<-0.8189,0.56786,0.08333>,<0.757,0.26767,-0.59607>,
            
    /*3*/<0.14191,-0.71877,0.68061>,<-0.89017,0.44885,-0.07827>,<0.74475,0.3017,-0.59525>,
            
    /*4*/<0.11425,0.71371,0.69106>

    /* stem 0.21.7*/ 
    /*0*/<0.7522,0.27129,-0.60049>,
    /*1*/<-0.62614,0.60221,-0.49527>,<0.49837,0.343,0.79623>,<0.10474,-0.95351,-0.28258>,
            
    /*2*/<-0.45161,0.57749,-0.68011>,<0.55197,0.32884,0.76629>,<-0.20561,-0.97385,-0.09665>,
            
    /*3*/<-0.23255,0.55431,-0.79916>,<0.75493,0.26013,0.60201>,<-0.52596,-0.81667,0.23752>,
            
    /*4*/<-0.45181,0.66098,0.59914>

    /* stem 0.21.8*/ 
    /*0*/<0.05974,-0.97617,-0.20862>,
    /*1*/<0.93529,-0.00797,0.35379>,<-0.76909,-0.16844,0.61655>,<-0.16802,0.20614,-0.96399>,
            
    /*2*/<0.93381,0.00139,0.35777>,<-0.76471,-0.2508,0.59356>,<-0.17839,0.27755,-0.944>,
            
    /*3*/<0.94106,-0.03159,0.33675>,<-0.74841,-0.41514,0.51724>,<-0.20697,0.48324,-0.85067>,
            
    /*4*/<-0.134,0.76513,0.62978>

    /* stem 0.21.9*/ 
    /*0*/<-0.15887,0.28548,-0.94512>,
    /*1*/<-0.81381,-0.58046,-0.02786>,<-0.07269,0.94818,0.3093>,<0.89131,-0.37636,-0.25283>,
            
    /*2*/<-0.82713,-0.56127,0.02896>,<-0.04458,0.99201,-0.11798>,<0.94642,-0.32072,0.0378>,
            
    /*3*/<-0.84448,-0.52419,0.10991>,<-0.01766,0.88408,-0.467>,<0.85754,-0.34797,0.37888>,
            
    /*4*/<-0.18879,0.47992,0.85676>

    /* stem 0.21.10*/ 
    /*0*/<0.86104,-0.40091,-0.31287>,
    /*1*/<0.30475,0.90681,-0.29124>,<0.18149,-0.31277,0.93233>,<-0.51215,-0.58197,-0.63167>,
            
    /*2*/<0.39208,0.85449,-0.34077>,<0.20875,-0.33331,0.91942>,<-0.63602,-0.5057,-0.58288>,
            
    /*3*/<0.45886,0.7992,-0.38824>,<0.27746,-0.34974,0.89482>,<-0.75535,-0.43186,-0.49289>,
            
    /*4*/<-0.64561,0.59678,0.47648>

    /* stem 0.21.11*/ 
    /*0*/<-0.546,-0.6189,-0.56467>,
    /*1*/<0.31861,-0.76972,0.55319>,<-0.82406,0.49986,0.26656>,<0.52175,0.28833,-0.8029>,
            
    /*2*/<0.41043,-0.63842,0.65113>,<-0.87884,0.42045,0.22555>,<0.49309,0.23039,-0.83892>,
            
    /*3*/<0.46228,-0.47137,0.75107>,<-0.95672,0.27518,0.0947>,<0.49704,0.22389,-0.83834>,
            
    /*4*/<0.18992,0.88553,0.42398>

    /* stem 0.21.12*/ 
    /*0*/<0.54884,0.23215,-0.80304>,
    /*1*/<-0.82721,0.32327,-0.45959>,<0.53788,0.62866,0.56167>,<0.27304,-0.95882,-0.07825>,
            
    /*2*/<-0.85509,0.33707,-0.39397>,<0.69622,0.64734,0.31021>,<0.21678,-0.97019,0.10835>,
            
    /*3*/<-0.87312,0.25635,-0.41466>,<0.79696,0.60379,-0.01741>,<0.06011,-0.87402,0.48215>,
            
    /*4*/<-0.32032,0.60356,0.73015>

    /* stem 0.21.13*/ 
    /*0*/<0.30975,-0.92604,-0.21566>,
    /*1*/<0.94281,0.2862,0.17086>,<-0.55955,-0.35135,0.75064>,<-0.39241,0.09249,-0.91513>,
            
    /*2*/<0.90566,0.37788,0.19234>,<-0.53763,-0.39984,0.74235>,<-0.37326,0.05224,-0.92625>,
            
    /*3*/<0.87259,0.4297,0.23228>,<-0.51111,-0.51498,0.68816>,<-0.38116,0.1098,-0.91797>,
            
    /*4*/<-0.45072,0.80715,0.38125>

    /* stem 0.21.14*/ 
    /*0*/<-0.37308,0.05394,-0.92623>,
    /*1*/<-0.62371,-0.75061,0.21809>,<-0.27457,0.94528,0.17622>,<0.90924,-0.19625,-0.3671>,
            
    /*2*/<-0.59639,-0.73274,0.32773>,<-0.34903,0.9371,-0.00527>,<0.93595,-0.17935,-0.30305>,
            
    /*3*/<-0.55974,-0.69929,0.44462>,<-0.4127,0.83106,-0.37286>,<0.99353,-0.09168,-0.06696>,
            
    /*4*/<-0.0652,0.57567,0.81507>

    /* stem 0.21.15*/ 
    /*0*/<0.88614,-0.23837,-0.3974>,
    /*1*/<0.00669,0.87443,-0.4851>,<0.3848,-0.06376,0.9208>,<-0.41737,-0.80371,-0.42409>,
            
    /*2*/<0.22153,0.78277,-0.58154>,<0.32294,-0.01622,0.94628>,<-0.54802,-0.7356,-0.3982>,
            
    /*3*/<0.37607,0.6718,-0.63817>,<0.37592,-0.08355,0.92288>,<-0.76882,-0.58602,-0.25592>,
            
    /*4*/<-0.52977,0.70446,0.47231>

    /* stem 0.21.16*/ 
    /*0*/<-0.34817,-0.80361,-0.48269>,
    /*1*/<0.60727,-0.5783,0.54479>,<-0.91947,0.21122,0.3316>,<0.32231,0.39039,-0.86239>,
            
    /*2*/<0.63096,-0.40453,0.662>,<-0.96938,0.00199,0.24555>,<0.32033,0.40452,-0.85659>,
            
    /*3*/<0.57261,-0.17543,0.80084>,<-0.9199,-0.38943,-0.04618>,<0.3002,0.55915,-0.77281>,
            
    /*4*/<-0.57513,0.67073,0.46833>

    /* stem 0.21.17*/ 
    /*0*/<0.3449,0.20634,-0.91568>,
    /*1*/<-0.9403,0.01664,-0.33993>,<0.41763,0.8359,0.35617>,<0.51273,-0.85849,0.01016>,
            
    /*2*/<-0.92398,0.01479,-0.38216>,<0.48012,0.84351,0.24079>,<0.45133,-0.87354,0.1823>,
            
    /*3*/<-0.90345,0.02591,-0.42791>,<0.63074,0.77371,-0.05942>,<0.30405,-0.79087,0.53111>,
            
    /*4*/<-0.33489,0.60555,0.72192>

    /* stem 0.21.18*/ 
    /*0*/<0.5368,-0.84367,0.0087>,
    /*1*/<0.83805,0.54409,-0.04044>,<-0.40124,-0.23488,0.88535>,<-0.45214,-0.28511,-0.84515>,
            
    /*2*/<0.82846,0.55899,-0.03431>,<-0.32057,-0.38063,0.86739>,<-0.54091,-0.17164,-0.82338>,
            
    /*3*/<0.86573,0.49225,-0.09059>,<-0.20353,-0.5606,0.80268>,<-0.68894,0.10394,-0.71733>,
            
    /*4*/<-0.24022,0.77979,0.57813>

    /* stem 0.21.19*/ 
    /*0*/<-0.43655,-0.2395,-0.86722>,
    /*1*/<-0.35068,-0.83765,0.41876>,<-0.53443,0.84391,0.04686>,<0.89749,0.00053,-0.44104>,
            
    /*2*/<-0.33054,-0.80379,0.49464>,<-0.60582,0.78757,-0.11278>,<0.92858,0.04232,-0.36871>,
            
    /*3*/<-0.30195,-0.63033,0.7152>,<-0.69694,0.57884,-0.42333>,<0.96109,0.06848,-0.26762>,
            
    /*4*/<0.07946,0.84589,0.5274>

    /* stem 0.21.20*/ 
    /*0*/<0.85476,-0.06289,-0.51519>,
    /*1*/<-0.30741,0.75135,-0.58393>,<0.50897,0.19461,0.8385>,<-0.2251,-0.94422,-0.24038>,
            
    /*2*/<-0.22994,0.70399,-0.67195>,<0.63199,0.12084,0.76549>,<-0.48999,-0.87045,-0.04717>,
            
    /*3*/<-0.11788,0.60954,-0.78394>,<0.82068,0.04702,0.56945>,<-0.7227,-0.64851,0.23904>,
            
    /*4*/<-0.31401,0.76062,0.5682>

    /* stem 0.21.21*/ 
    /*0*/<-0.11057,-0.91271,-0.39335>,
    /*1*/<0.81468,-0.30287,0.49454>,<-0.90006,-0.06754,0.43051>,<0.08809,0.3928,-0.9154>,
            
    /*2*/<0.81014,-0.18138,0.55747>,<-0.9008,-0.2073,0.38156>,<0.08577,0.40162,-0.91178>,
            
    /*3*/<0.76087,-0.02849,0.64828>,<-0.87682,-0.41364,0.24513>,<0.1031,0.45853,-0.88268>,
            
    /*4*/<-0.38645,0.81795,0.42616>

    /* stem 0.21.22*/ 
    /*0*/<0.12828,0.17107,-0.97687>,
    /*1*/<-0.94286,-0.28815,-0.1673>,<0.20156,0.95857,0.20131>,<0.73868,-0.67391,-0.01405>,
            
    /*2*/<-0.95653,-0.28484,-0.06255>,<0.21282,0.97633,0.03856>,<0.73948,-0.67208,0.03847>,
            
    /*3*/<-0.96304,-0.22232,0.15208>,<0.21671,0.86833,-0.44615>,<0.77044,-0.59402,0.23143>,
            
    /*4*/<0.09612,0.68608,0.72115>

    /* stem 0.21.23*/ 
    /*0*/<0.74002,-0.67105,0.04545>,
    /*1*/<0.64844,0.70461,-0.28818>,<-0.19121,-0.13599,0.97208>,<-0.4707,-0.55641,-0.68473>,
            
    /*2*/<0.67327,0.67482,-0.30219>,<-0.07076,-0.31733,0.94567>,<-0.67353,-0.37268,-0.63833>,
            
    /*3*/<0.74042,0.56701,-0.36093>,<0.06891,-0.36272,0.92935>,<-0.80983,-0.18924,-0.55531>,
            
    /*4*/<-0.40573,0.87433,0.26631>

    /* stem 0.21.24*/ 
    /*0*/<-0.28244,-0.57793,-0.76565>,
    /*1*/<-0.05703,-0.78359,0.61865>,<-0.79871,0.58501,-0.14081>,<0.85972,0.20673,-0.46706>,
            
    /*2*/<-0.05306,-0.80465,0.59138>,<-0.8101,0.48402,-0.33086>,<0.88398,0.38097,-0.271>,
            
    /*3*/<-0.08081,-0.82412,0.56062>,<-0.79819,0.35334,-0.4879>,<0.87606,0.47815,-0.06237>,
            
    /*4*/<-0.22692,0.56787,0.79122>

    /* stem 0.21.25*/ 
    /*0*/<0.80441,0.15455,-0.57363>,
    /*1*/<-0.56633,0.50361,-0.65242>,<0.44182,0.48322,0.75584>,<0.1161,-0.98845,-0.09743>,
            
    /*2*/<-0.52727,0.47993,-0.70119>,<0.66159,0.41412,0.62514>,<-0.15403,-0.97214,0.17668>,
            
    /*3*/<-0.48838,0.50237,-0.71352>,<0.94365,0.24562,0.22179>,<-0.41211,-0.75695,0.50713>,
            
    /*4*/<-0.1056,0.72304,0.68268>

    /* stem 0.21.26*/ 
    /*0*/<0.06724,-0.98995,-0.12439>,
    /*1*/<0.92159,0.01605,0.38783>,<-0.79178,-0.12668,0.59752>,<-0.13024,0.11705,-0.98455>,
            
    /*2*/<0.92922,-0.07428,0.36198>,<-0.79318,-0.16212,0.58701>,<-0.1314,0.24882,-0.95959>,
            
    /*3*/<0.93409,-0.10921,0.33994>,<-0.77445,-0.24078,0.58502>,<-0.15806,0.35559,-0.92118>,
            
    /*4*/<-0.0736,0.9335,0.35095>

    /* stem 0.21.27*/ 
    /*0*/<-0.09044,0.03121,-0.99541>,
    /*1*/<-0.84856,-0.5255,0.06171>,<-0.02691,0.99903,0.03486>,<0.87576,-0.47363,-0.09334>,
            
    /*2*/<-0.85142,-0.51871,0.07757>,<0.00866,0.96889,-0.24734>,<0.90089,-0.40525,0.15545>,
            
    /*3*/<-0.8732,-0.47399,0.1134>,<0.06716,0.7858,-0.61482>,<0.81727,-0.29877,0.49275>,
            
    /*4*/<-0.26349,0.71829,0.64392>

    /* stem 0.22*/ 
    /*0*/<0.3183,-0.31614,0.89372>,
    /*1*/<0.93568,-0.0174,-0.35243>,<0.40734,0.89916,0.15996>,<-0.68905,0.57821,0.4369>,
            <-0.83832,-0.53672,0.09567>,<0.16582,-0.90483,-0.39217>,
    /*2*/<0.93983,-0.02181,-0.34096>,<0.42803,0.87694,0.21856>,<-0.68082,0.56876,0.46152>,
            <-0.85307,-0.51912,0.05284>,<0.14842,-0.88413,-0.44304>,
    /*3*/<0.94517,-0.02982,-0.32522>,<0.46769,0.81814,0.33454>,<-0.66126,0.5425,0.5181>,
            <-0.87969,-0.47476,-0.0272>,<0.11299,-0.8286,-0.54831>,
    /*4*/<0.95783,-0.06081,-0.28083>,<0.49388,0.75986,0.42272>,<-0.65543,0.53918,0.52886>,
            <-0.90232,-0.41726,-0.10821>,<0.09441,-0.78798,-0.60842>,
    /*5*/<0.96281,-0.08607,-0.25608>,<0.51063,0.71976,0.47032>,<-0.6498,0.54066,0.53427>,
            <-0.91401,-0.37586,-0.1527>,<0.08247,-0.76301,-0.6411>,
    /*6*/<-0.1453,0.64439,-0.75077>

    /* stem 0.22.0*/ 
    /*0*/<-0.32799,-0.748,0.57699>,
    /*1*/<-0.63457,0.63362,0.44255>,<-0.28085,-0.49644,-0.82138>,<0.92572,-0.11368,0.36071>,
            
    /*2*/<-0.65852,0.57212,0.48891>,<-0.27462,-0.47257,-0.83741>,<0.93943,-0.0725,0.33497>,
            
    /*3*/<-0.66274,0.56353,0.49316>,<-0.30808,-0.56781,-0.76333>,<0.97044,0.01378,0.24096>,
            
    /*4*/<0.10428,0.6618,-0.74239>

    /* stem 0.22.1*/ 
    /*0*/<0.93537,-0.08813,0.34253>,
    /*1*/<0.02833,-0.93676,-0.34883>,<0.27571,0.76073,-0.5876>,<-0.33329,0.17879,0.92572>,
            
    /*2*/<-0.05793,-0.90707,-0.41697>,<0.50855,0.71527,-0.47934>,<-0.43208,0.22752,0.87267>,
            
    /*3*/<-0.13486,-0.85969,-0.4927>,<0.79229,0.58358,-0.17809>,<-0.66859,0.32384,0.66942>,
            
    /*4*/<-0.30121,0.49921,-0.81244>

    /* stem 0.22.2*/ 
    /*0*/<-0.37707,0.1795,0.90862>,
    /*1*/<0.58358,0.80895,0.07093>,<-0.91144,0.0751,-0.40451>,<0.33962,-0.88965,0.30526>,
            
    /*2*/<0.55922,0.79428,0.23748>,<-0.94852,0.05185,-0.31245>,<0.45213,-0.89175,0.01924>,
            
    /*3*/<0.49917,0.62072,0.6046>,<-0.98105,0.09203,-0.17053>,<0.54917,-0.70291,-0.45203>,
            
    /*4*/<0.15442,0.81004,-0.56568>

    /* stem 0.22.3*/ 
    /*0*/<0.37315,-0.82449,0.42542>,
    /*1*/<-0.93004,-0.29603,0.21771>,<0.41283,-0.25218,-0.8752>,<0.50561,0.57382,0.64427>,
            
    /*2*/<-0.9365,-0.28159,0.20899>,<0.42645,-0.28243,-0.85929>,<0.49936,0.58898,0.63541>,
            
    /*3*/<-0.92591,-0.30681,0.22035>,<0.42421,-0.27693,-0.86218>,<0.48866,0.6073,0.62641>,
            
    /*4*/<-0.42797,0.79602,-0.42801>

    /* stem 0.22.4*/ 
    /*0*/<0.52203,0.29472,0.80039>,
    /*1*/<0.83394,-0.34724,-0.42893>,<-0.29383,0.94103,-0.16774>,<-0.55626,-0.6029,0.57191>,
            
    /*2*/<0.83091,-0.34509,-0.43647>,<-0.20594,0.97819,0.0272>,<-0.67466,-0.61771,0.40406>,
            
    /*3*/<0.85684,-0.37711,-0.35158>,<-0.08643,0.94324,0.32067>,<-0.81849,-0.57436,-0.01382>,
            
    /*4*/<-0.03174,0.44218,-0.89637>

    /* stem 0.22.5*/ 
    /*0*/<-0.40509,-0.5471,0.73252>,
    /*1*/<-0.35557,0.83752,0.41487>,<-0.54385,-0.49036,-0.68101>,<0.9119,-0.33031,0.24357>,
            
    /*2*/<-0.37338,0.80288,0.46472>,<-0.55859,-0.52235,-0.64431>,<0.95182,-0.26318,0.1574>,
            
    /*3*/<-0.38467,0.67843,0.62591>,<-0.58836,-0.56125,-0.58209>,<0.99482,-0.08352,-0.05802>,
            
    /*4*/<-0.13098,0.74661,-0.65224>

    /* stem 0.22.6*/ 
    /*0*/<0.84713,-0.43519,0.30493>,
    /*1*/<-0.3378,-0.87572,-0.34497>,<0.51716,0.60842,-0.60197>,<-0.20539,0.28067,0.93757>,
            
    /*2*/<-0.40046,-0.83209,-0.38375>,<0.63961,0.53459,-0.55238>,<-0.24833,0.3172,0.91527>,
            
    /*3*/<-0.54451,-0.6757,-0.49693>,<0.80818,0.39024,-0.44109>,<-0.28749,0.29908,0.90989>,
            
    /*4*/<-0.44752,0.82335,-0.34903>

    /* stem 0.22.7*/ 
    /*0*/<-0.15868,0.21395,0.96387>,
    /*1*/<0.83443,0.5511,0.0045>,<-0.87398,0.41833,-0.24729>,<0.04439,-0.97596,0.2134>,
            
    /*2*/<0.83279,0.55184,0.0439>,<-0.89822,0.4223,-0.12188>,<0.05752,-0.99743,0.04283>,
            
    /*3*/<0.81354,0.58032,0.03717>,<-0.88617,0.3433,0.31121>,<-0.0025,-0.94155,-0.33685>,
            
    /*4*/<-0.39668,0.50557,-0.76619>

    /* stem 0.22.8*/ 
    /*0*/<0.02386,-0.98503,0.17073>,
    /*1*/<-0.94706,0.04246,0.31822>,<0.19543,-0.15291,-0.96872>,<0.75091,0.1403,0.64533>,
            
    /*2*/<-0.93847,-0.02885,0.34414>,<0.21168,-0.22746,-0.9505>,<0.73641,0.29591,0.60839>,
            
    /*3*/<-0.9125,-0.12067,0.39088>,<0.23523,-0.39979,-0.88591>,<0.68163,0.55239,0.47985>,
            
    /*4*/<-0.38104,0.73421,-0.56191>

    /* stem 0.22.9*/ 
    /*0*/<0.69996,0.12954,0.70233>,
    /*1*/<0.61078,-0.60439,-0.51153>,<-0.0057,0.98183,-0.1897>,<-0.62616,-0.38134,0.68008>,
            
    /*2*/<0.59333,-0.5935,-0.54379>,<0.15436,0.98717,0.04089>,<-0.78164,-0.34102,0.52225>,
            
    /*3*/<0.58382,-0.55977,-0.58806>,<0.34717,0.79116,0.50353>,<-0.97837,-0.1704,0.11728>,
            
    /*4*/<0.04332,0.74834,-0.6619>

    /* stem 0.22.10*/ 
    /*0*/<-0.40448,-0.41417,0.81539>,
    /*1*/<0.00434,0.89561,0.44481>,<-0.78808,-0.28272,-0.5468>,<0.79588,-0.60047,0.07753>,
            
    /*2*/<-0.00628,0.86048,0.50945>,<-0.81785,-0.35519,-0.45272>,<0.85671,-0.50632,-0.09845>,
            
    /*3*/<-0.00178,0.76111,0.64862>,<-0.86399,-0.37611,-0.33474>,<0.87094,-0.36263,-0.33161>,
            
    /*4*/<-0.04113,0.72243,-0.69022>

    /* stem 0.22.11*/ 
    /*0*/<0.62983,-0.71648,0.29996>,
    /*1*/<-0.65844,-0.6904,-0.29967>,<0.68512,0.34829,-0.63977>,<-0.04546,0.36348,0.93049>,
            
    /*2*/<-0.6381,-0.7163,-0.2824>,<0.7509,0.28403,-0.59622>,<-0.1277,0.46557,0.87575>,
            
    /*3*/<-0.64058,-0.71017,-0.29209>,<0.82795,0.1733,-0.53336>,<-0.2017,0.55476,0.80719>,
            
    /*4*/<-0.44549,0.69067,-0.56967>

    /* stem 0.22.12*/ 
    /*0*/<0.07583,0.15831,0.98447>,
    /*1*/<0.96157,0.2452,-0.12352>,<-0.7079,0.70298,-0.06854>,<-0.25592,-0.95287,0.16291>,
            
    /*2*/<0.94228,0.26399,-0.20596>,<-0.67504,0.70949,0.20235>,<-0.3129,-0.94969,0.01329>,
            
    /*3*/<0.92102,0.24797,-0.30038>,<-0.54876,0.63783,0.5404>,<-0.39743,-0.88012,-0.2597>,
            
    /*4*/<-0.37354,0.52868,-0.76221>

    /* stem 0.22.13*/ 
    /*0*/<-0.12633,-0.90941,0.39624>,
    /*1*/<-0.82093,0.32839,0.46715>,<-0.06828,-0.38139,-0.92189>,<0.89293,0.07981,0.44306>,
            
    /*2*/<-0.82232,0.39,0.41436>,<-0.08611,-0.57598,-0.81292>,<0.91512,0.17599,0.36275>,
            
    /*3*/<-0.78988,0.35453,0.5004>,<-0.06797,-0.76485,-0.64061>,<0.87247,0.47084,0.13082>,
            
    /*4*/<-0.43652,0.55206,-0.71041>

    /* stem 0.22.14*/ 
    /*0*/<0.81298,-0.13863,0.56554>,
    /*1*/<0.28937,-0.73484,-0.61341>,<0.27693,0.94306,-0.18423>,<-0.59017,-0.20415,0.78104>,
            
    /*2*/<0.18427,-0.66502,-0.72374>,<0.50456,0.86269,-0.03441>,<-0.6526,-0.15752,0.74115>,
            
    /*3*/<0.05519,-0.55058,-0.83295>,<0.72507,0.65349,0.21731>,<-0.7867,-0.07545,0.61271>,
            
    /*4*/<-0.35616,0.78251,-0.51071>

    /* stem 0.22.15*/ 
    /*0*/<-0.54725,-0.21268,0.80949>,
    /*1*/<0.37196,0.81053,0.45242>,<-0.82955,0.07301,-0.55363>,<0.47354,-0.87734,0.07763>,
            
    /*2*/<0.28361,0.75326,0.59344>,<-0.81358,0.08852,-0.57468>,<0.56143,-0.82729,-0.01962>,
            
    /*3*/<0.17673,0.61934,0.76497>,<-0.86401,-0.02393,-0.50291>,<0.73105,-0.59789,-0.32878>,
            
    /*4*/<0.08903,0.82204,-0.56242>

    /* stem 0.22.16*/ 
    /*0*/<0.49539,-0.86415,0.08855>,
    /*1*/<-0.86384,-0.49412,-0.09816>,<0.53611,0.23542,-0.81066>,<0.3134,0.28369,0.90626>,
            
    /*2*/<-0.90165,-0.40554,-0.15021>,<0.66726,-0.02377,-0.74444>,<0.28334,0.42655,0.85894>,
            
    /*3*/<-0.93118,-0.28217,-0.23082>,<0.7673,-0.30218,-0.56562>,<0.16554,0.60428,0.77939>,
            
    /*4*/<-0.05065,0.76877,-0.63751>

    /* stem 0.22.17*/ 
    /*0*/<0.25327,0.22983,0.9397>,
    /*1*/<0.96402,-0.10426,-0.24453>,<-0.44947,0.88698,-0.106>,<-0.52183,-0.78933,0.32349>,
            
    /*2*/<0.96456,-0.1025,-0.24314>,<-0.42284,0.89075,0.16663>,<-0.62106,-0.78087,0.06729>,
            
    /*3*/<0.97304,-0.14103,-0.18248>,<-0.33961,0.77743,0.5294>,<-0.67045,-0.63081,-0.39059>,
            
    /*4*/<0.05865,0.70205,-0.7097>

    /* stem 0.22.18*/ 
    /*0*/<-0.44311,-0.80636,0.39172>,
    /*1*/<-0.59419,0.59906,0.53672>,<-0.2746,-0.28362,-0.91878>,<0.88145,-0.2924,0.37087>,
            
    /*2*/<-0.58509,0.6246,0.51724>,<-0.32921,-0.40544,-0.85279>,<0.92722,-0.21073,0.3096>,
            
    /*3*/<-0.55094,0.72813,0.40779>,<-0.41861,-0.59985,-0.68187>,<0.96202,-0.11078,0.24949>,
            
    /*4*/<0.27032,0.51136,-0.81574>

    /* stem 0.22.19*/ 
    /*0*/<0.77653,-0.40416,0.48338>,
    /*1*/<-0.05695,-0.80018,-0.59706>,<0.56144,0.78348,-0.26635>,<-0.52646,0.02813,0.84974>,
            
    /*2*/<-0.0153,-0.82937,-0.55849>,<0.61547,0.75737,-0.21814>,<-0.63193,0.08782,0.77004>,
            
    /*3*/<-0.00231,-0.79789,-0.6028>,<0.80043,0.59942,0.00181>,<-0.76706,0.22936,0.59918>,
            
    /*4*/<-0.20426,0.66939,-0.71428>

    /* stem 0.22.20*/ 
    /*0*/<-0.31871,-0.19623,0.92732>,
    /*1*/<0.67729,0.64215,0.35905>,<-0.9111,0.32457,-0.25406>,<0.24233,-0.96147,-0.12978>,
            
    /*2*/<0.66307,0.60858,0.43586>,<-0.9446,0.28174,-0.16836>,<0.29707,-0.90316,-0.30992>,
            
    /*3*/<0.63244,0.44804,0.63189>,<-0.97335,0.22706,-0.03204>,<0.38234,-0.6687,-0.63769>,
            
    /*4*/<0.15721,0.85958,-0.48621>

    /* stem 0.22.21*/ 
    /*0*/<0.17911,-0.95433,0.23912>,
    /*1*/<-0.98515,-0.16942,0.0278>,<0.5025,-0.112,-0.85729>,<0.47829,0.30465,0.82367>,
            
    /*2*/<-0.99829,0.00938,-0.05768>,<0.50054,-0.32046,-0.80422>,<0.48117,0.31556,0.81786>,
            
    /*3*/<-0.98935,0.08332,-0.11931>,<0.54782,-0.45888,-0.69951>,<0.43747,0.3949,0.80788>,
            
    /*4*/<0.02829,0.8699,-0.49242>

    /* stem 0.22.22*/ 
    /*0*/<0.46311,-0.0444,0.88519>,
    /*1*/<0.82371,-0.33704,-0.45598>,<-0.14095,0.98332,0.11494>,<-0.69275,-0.64533,0.32194>,
            
    /*2*/<0.84207,-0.38,-0.38277>,<-0.11977,0.93464,0.33483>,<-0.83464,-0.55079,-0.0033>,
            
    /*3*/<0.88463,-0.37246,-0.28055>,<-0.04568,0.74696,0.6633>,<-0.85191,-0.35329,-0.38657>,
            
    /*4*/<0.10536,0.76892,-0.6306>

    /* stem 0.22.23*/ 
    /*0*/<-0.69264,-0.62273,0.36395>,
    /*1*/<-0.28055,0.70311,0.65339>,<-0.42776,-0.04269,-0.90288>,<0.72022,-0.64971,0.24323>,
            
    /*2*/<-0.40883,0.56241,0.71871>,<-0.38995,0.0174,-0.92067>,<0.79566,-0.56214,0.22568>,
            
    /*3*/<-0.54573,0.28422,0.78829>,<-0.35954,0.10809,-0.92685>,<0.91305,-0.37865,0.15154>,
            
    /*4*/<0.28432,0.95861,0.01543>

    /* stem 0.22.24*/ 
    /*0*/<0.65396,-0.64584,0.39398>,
    /*1*/<-0.39426,-0.73133,-0.55652>,<0.75325,0.55095,-0.35926>,<-0.36835,0.18962,0.91015>,
            
    /*2*/<-0.36485,-0.77293,-0.5191>,<0.82761,0.48337,-0.28534>,<-0.48229,0.32052,0.81527>,
            
    /*3*/<-0.34232,-0.77373,-0.53307>,<0.93937,0.31513,-0.13523>,<-0.58978,0.46803,0.65811>,
            
    /*4*/<-0.19305,0.66388,-0.72249>

    /* stem 0.22.25*/ 
    /*0*/<-0.1785,-0.07709,0.98091>,
    /*1*/<0.88441,0.4259,0.19083>,<-0.81581,0.56826,-0.10739>,<-0.06672,-0.99335,-0.0938>,
            
    /*2*/<0.84888,0.3631,0.38414>,<-0.821,0.56307,-0.09444>,<0.01135,-0.95334,-0.3017>,
            
    /*3*/<0.78438,0.39781,0.47592>,<-0.90335,0.39347,0.1707>,<0.05436,-0.78624,-0.61552>,
            
    /*4*/<-0.11793,0.71768,-0.68632>

    /* stem 0.22.26*/ 
    /*0*/<-0.04907,-0.98988,0.13315>,
    /*1*/<-0.9628,0.08431,0.25672>,<0.25175,-0.13926,-0.95772>,<0.71135,0.06097,0.70019>,
            
    /*2*/<-0.96243,0.09112,0.2558>,<0.25156,-0.14264,-0.95727>,<0.71117,0.05754,0.70067>,
            
    /*3*/<-0.96318,0.09044,0.2532>,<0.26183,-0.06655,-0.96282>,<0.70717,-0.01813,0.70681>,
            
    /*4*/<0.09344,0.99493,0.0372>

    /* stem 0.22.27*/ 
    /*0*/<0.72736,0.0503,0.68441>,
    /*1*/<0.59063,-0.55179,-0.5888>,<0.00485,0.99678,-0.08008>,<-0.59797,-0.44516,0.66653>,
            
    /*2*/<0.45097,-0.48774,-0.74748>,<0.25937,0.96007,0.10488>,<-0.64784,-0.42034,0.63531>,
            
    /*3*/<0.26017,-0.40243,-0.8777>,<0.52829,0.75704,0.38444>,<-0.78898,-0.34275,0.50994>,
            
    /*4*/<-0.46583,0.75696,-0.45828>

    /* stem 0.23*/ 
    /*0*/<-0.82633,-0.30495,-0.47348>,
    /*1*/<-0.49024,0.01344,0.87149>,<-0.39155,0.91225,0.12037>,<0.26153,0.55527,-0.78948>,
            <0.56647,-0.56417,-0.60068>,<0.10185,-0.89904,0.42585>,
    /*2*/<-0.50088,0.00925,0.86547>,<-0.43569,0.89508,0.09493>,<0.24512,0.54874,-0.79925>,
            <0.59974,-0.55006,-0.58117>,<0.13875,-0.88345,0.44751>,
    /*3*/<-0.53502,-0.0115,0.84476>,<-0.58748,0.80924,0.00305>,<0.18675,0.5173,-0.83518>,
            <0.71183,-0.48024,-0.51252>,<0.26564,-0.80759,0.52654>,
    /*4*/<-0.59053,-0.069,0.80406>,<-0.7226,0.68546,-0.08943>,<0.1537,0.50263,-0.85073>,
            <0.82611,-0.36445,-0.42979>,<0.36598,-0.71756,0.59259>,
    /*5*/<-0.61969,-0.11616,0.77621>,<-0.79487,0.5883,-0.1486>,<0.137,0.4911,-0.86026>,
            <0.88593,-0.27281,-0.37509>,<0.41854,-0.64802,0.63631>,
    /*6*/<0.39914,0.7944,0.45784>

    /* stem 0.23.0*/ 
    /*0*/<-0.19077,-0.74394,-0.64044>,
    /*1*/<0.21817,0.61231,-0.75992>,<0.72311,-0.54103,0.42941>,<-0.9353,-0.04793,0.35061>,
            
    /*2*/<0.21224,0.59675,-0.77385>,<0.70925,-0.58262,0.39688>,<-0.91648,0.00776,0.40001>,
            
    /*3*/<0.21478,0.58626,-0.78113>,<0.58913,-0.76898,0.24816>,<-0.79487,0.17236,0.58178>,
            
    /*4*/<0.71702,0.44596,0.53573>

    /* stem 0.23.1*/ 
    /*0*/<-0.95114,-0.07244,0.30015>,
    /*1*/<0.17856,-0.93533,0.30542>,<0.14953,0.76678,0.62425>,<-0.29839,0.17081,-0.93904>,
            
    /*2*/<0.32891,-0.91236,0.24377>,<0.10674,0.75608,0.64571>,<-0.39922,0.14304,-0.90563>,
            
    /*3*/<0.53782,-0.82962,0.14991>,<-0.06548,0.67856,0.73162>,<-0.45165,0.17241,-0.87538>,
            
    /*4*/<0.79133,0.56529,-0.23291>

    /* stem 0.23.2*/ 
    /*0*/<-0.33911,0.1358,-0.93089>,
    /*1*/<-0.47105,0.82822,0.30358>,<0.94421,0.05268,-0.32511>,<-0.46259,-0.88513,0.05055>,
            
    /*2*/<-0.53213,0.82326,0.19772>,<0.91745,0.04207,-0.39563>,<-0.38724,-0.88818,0.24735>,
            
    /*3*/<-0.55922,0.82081,0.11637>,<0.80186,0.02263,-0.59708>,<-0.21428,-0.84336,0.49277>,
            
    /*4*/<0.67657,0.32609,0.66024>

    /* stem 0.23.3*/ 
    /*0*/<-0.6198,-0.77654,-0.11331>,
    /*1*/<0.56485,-0.32695,-0.75766>,<0.20464,-0.28658,0.93594>,<-0.75025,0.63764,-0.17477>,
            
    /*2*/<0.47997,-0.40104,-0.78026>,<0.16318,-0.31974,0.93335>,<-0.62791,0.76137,-0.16138>,
            
    /*3*/<0.48509,-0.3608,-0.79656>,<0.14725,-0.39358,0.90742>,<-0.6123,0.78083,-0.12407>,
            
    /*4*/<0.64578,0.73053,0.22204>

    /* stem 0.23.4*/ 
    /*0*/<-0.82601,0.53863,-0.16609>,
    /*1*/<-0.37248,-0.32195,0.87041>,<0.55872,0.82886,-0.02858>,<-0.1607,-0.52357,-0.83669>,
            
    /*2*/<-0.33084,-0.31265,0.89039>,<0.16552,0.96384,-0.20884>,<0.17683,-0.55505,-0.81281>,
            
    /*3*/<-0.27345,-0.3068,0.91164>,<-0.25207,0.91283,-0.32125>,<0.54914,-0.59575,-0.58612>,
            
    /*4*/<0.79294,0.45104,0.40965>

    /* stem 0.23.5*/ 
    /*0*/<-0.06931,-0.56948,-0.81908>,
    /*1*/<0.02599,0.82559,-0.56367>,<0.85169,-0.4563,0.25772>,<-0.87555,-0.35175,0.33119>,
            
    /*2*/<-0.03537,0.69432,-0.7188>,<0.84728,-0.47111,0.24531>,<-0.85152,-0.17853,0.49299>,
            
    /*3*/<-0.13554,0.50006,-0.85532>,<0.87957,-0.43721,0.18764>,<-0.73408,-0.0381,0.67799>,
            
    /*4*/<0.32254,0.86606,0.38198>

    /* stem 0.23.6*/ 
    /*0*/<-0.87095,-0.39655,0.29016>,
    /*1*/<0.4383,-0.89719,0.05423>,<0.00103,0.60572,0.79568>,<-0.41263,0.30363,-0.8588>,
            
    /*2*/<0.56596,-0.82307,0.04736>,<-0.18108,0.49418,0.85029>,<-0.36803,0.34285,-0.8643>,
            
    /*3*/<0.61943,-0.78396,0.04151>,<-0.41498,0.37179,0.8304>,<-0.17936,0.43579,-0.882>,
            
    /*4*/<0.81067,0.53393,0.24027>

    /* stem 0.23.7*/ 
    /*0*/<-0.54961,0.1481,-0.82219>,
    /*1*/<-0.61414,0.58614,0.52846>,<0.80057,0.39351,-0.45193>,<-0.16969,-0.98415,-0.0515>,
            
    /*2*/<-0.65725,0.58005,0.48121>,<0.72946,0.38112,-0.56801>,<-0.03845,-0.99255,0.11559>,
            
    /*3*/<-0.70755,0.56738,0.42125>,<0.53831,0.33725,-0.77232>,<0.2058,-0.90869,0.36321>,
            
    /*4*/<0.68749,0.519,0.50793>

    /* stem 0.23.8*/ 
    /*0*/<-0.40835,-0.87804,-0.24961>,
    /*1*/<0.52419,0.00979,-0.85154>,<0.39372,-0.40606,0.82468>,<-0.90555,0.42285,0.03441>,
            
    /*2*/<0.53087,0.02065,-0.8472>,<0.36602,-0.46031,0.80879>,<-0.88424,0.46435,0.05007>,
            
    /*3*/<0.53603,0.02391,-0.84386>,<0.22847,-0.63208,0.74046>,<-0.76286,0.63121,0.14009>,
            
    /*4*/<0.72406,0.51938,0.45385>

    /* stem 0.23.9*/ 
    /*0*/<-0.98117,0.16844,-0.09452>,
    /*1*/<-0.16724,-0.59075,0.78933>,<0.16516,0.97724,0.13312>,<0.03159,-0.39155,-0.91961>,
            
    /*2*/<-0.15198,-0.59173,0.79168>,<0.10672,0.98627,0.12601>,<0.07503,-0.3955,-0.9154>,
            
    /*3*/<-0.17875,-0.61021,0.77181>,<-0.11247,0.99152,0.06518>,<0.34308,-0.36857,-0.86398>,
            
    /*4*/<0.84865,0.24607,0.46823>

    /* stem 0.23.10*/ 
    /*0*/<-0.10603,-0.38847,-0.91534>,
    /*1*/<-0.24772,0.90544,-0.34469>,<0.95916,-0.28219,0.01954>,<-0.70827,-0.61164,0.35251>,
            
    /*2*/<-0.29005,0.86817,-0.40269>,<0.89779,-0.42041,-0.13123>,<-0.60409,-0.47369,0.64085>,
            
    /*3*/<-0.39961,0.78061,-0.48058>,<0.76605,-0.50768,-0.39425>,<-0.35211,-0.25728,0.8999>,
            
    /*4*/<0.68864,0.64994,0.32149>

    /* stem 0.23.11*/ 
    /*0*/<-0.62703,-0.76056,0.1685>,
    /*1*/<0.7585,-0.63977,-0.12396>,<-0.19492,0.37456,0.90648>,<-0.54495,0.28781,-0.78753>,
            
    /*2*/<0.77167,-0.62431,-0.12147>,<-0.29387,0.26724,0.91772>,<-0.47389,0.38874,-0.79013>,
            
    /*3*/<0.85374,-0.51542,-0.07394>,<-0.47029,0.02775,0.88207>,<-0.36919,0.50103,-0.78273>,
            
    /*4*/<0.40518,0.83464,0.3731>

    /* stem 0.23.12*/ 
    /*0*/<-0.69078,-0.08636,-0.71789>,
    /*1*/<-0.7084,0.22811,0.66793>,<0.45627,0.72722,-0.5128>,<0.27254,-0.95278,-0.13391>,
            
    /*2*/<-0.68099,0.25165,0.68769>,<0.25989,0.6327,-0.72949>,<0.4727,-0.88109,-0.01513>,
            
    /*3*/<-0.69409,0.16759,0.70011>,<-0.023,0.40606,-0.91356>,<0.79359,-0.5594,0.23934>,
            
    /*4*/<0.27657,0.93173,0.23533>

    /* stem 0.23.13*/ 
    /*0*/<0.1381,-0.9537,-0.26718>,
    /*1*/<0.34212,0.30847,-0.88758>,<0.63137,-0.11322,0.76718>,<-0.97754,-0.16721,0.12826>,
            
    /*2*/<0.33948,0.27987,-0.89801>,<0.62617,-0.25219,0.73778>,<-0.98185,-0.00098,0.18968>,
            
    /*3*/<0.32176,0.21621,-0.9218>,<0.61453,-0.42757,0.66297>,<-0.93273,0.23888,0.27011>,
            
    /*4*/<0.39058,0.87412,0.28872>

    /* stem 0.23.14*/ 
    /*0*/<-0.97374,-0.22339,0.04392>,
    /*1*/<0.19849,-0.68336,0.70258>,<-0.19491,0.94498,0.26274>,<0.02494,-0.25507,-0.9666>,
            
    /*2*/<0.13821,-0.71263,0.68779>,<-0.34989,0.90967,0.22379>,<0.26061,-0.1716,-0.95007>,
            
    /*3*/<0.10214,-0.67476,0.73094>,<-0.65928,0.74412,0.10787>,<0.54986,-0.03667,-0.83445>,
            
    /*4*/<0.55268,0.69334,0.46241>

    /* stem 0.23.15*/ 
    /*0*/<-0.08605,-0.30819,-0.94743>,
    /*1*/<-0.63217,0.75418,-0.17768>,<0.98356,0.13284,-0.12231>,<-0.34889,-0.87806,0.32755>,
            
    /*2*/<-0.63754,0.74493,-0.19652>,<0.96625,0.06602,-0.24899>,<-0.31182,-0.8191,0.48149>,
            
    /*3*/<-0.69827,0.63761,-0.32539>,<0.93205,0.05249,-0.3585>,<-0.2458,-0.66872,0.70171>,
            
    /*4*/<0.16759,0.75648,0.63218>

    /* stem 0.23.16*/ 
    /*0*/<-0.46415,-0.87871,0.11153>,
    /*1*/<0.78531,-0.45688,-0.41778>,<-0.02389,0.14906,0.98854>,<-0.748,0.33323,-0.57398>,
            
    /*2*/<0.72722,-0.54539,-0.41677>,<-0.03939,0.12893,0.99087>,<-0.67429,0.44319,-0.59069>,
            
    /*3*/<0.66104,-0.61543,-0.42927>,<-0.08084,0.03303,0.99618>,<-0.5632,0.60482,-0.56303>,
            
    /*4*/<0.71643,0.68776,0.11706>

    /* stem 0.23.17*/ 
    /*0*/<-0.77261,-0.05683,-0.63233>,
    /*1*/<-0.61588,-0.12082,0.77852>,<0.21456,0.9194,-0.32965>,<0.42352,-0.79695,-0.4307>,
            
    /*2*/<-0.62697,-0.12652,0.7687>,<0.0687,0.86337,-0.49987>,<0.62188,-0.72715,-0.29071>,
            
    /*3*/<-0.63944,-0.11506,0.76018>,<-0.16806,0.69165,-0.70241>,<0.82933,-0.55581,-0.05742>,
            
    /*4*/<0.41955,0.77859,0.46667>

    /* stem 0.23.18*/ 
    /*0*/<0.18492,-0.83159,-0.5237>,
    /*1*/<0.08793,0.55281,-0.82865>,<0.8009,-0.17175,0.57364>,<-0.8941,-0.3574,0.26992>,
            
    /*2*/<0.10234,0.48268,-0.8698>,<0.79605,-0.13943,0.58895>,<-0.90329,-0.31703,0.28908>,
            
    /*3*/<0.08239,0.49461,-0.8652>,<0.80369,-0.1258,0.5816>,<-0.89425,-0.34042,0.29058>,
            
    /*4*/<-0.219,0.81064,0.54305>

    /* stem 0.23.19*/ 
    /*0*/<-0.85851,-0.49795,0.12252>,
    /*1*/<0.49396,-0.70882,0.50356>,<-0.3768,0.78825,0.4865>,<-0.0929,-0.06536,-0.99353>,
            
    /*2*/<0.55046,-0.66054,0.51058>,<-0.53688,0.68161,0.49716>,<-0.01553,0.00952,-0.99983>,
            
    /*3*/<0.62158,-0.57738,0.52941>,<-0.75516,0.4709,0.45605>,<0.13886,0.13316,-0.98132>,
            
    /*4*/<0.50098,0.82458,0.26285>

    /* stem 0.23.20*/ 
    /*0*/<-0.2532,-0.2834,-0.92497>,
    /*1*/<-0.8318,0.5508,0.06872>,<0.84369,0.40983,-0.34673>,<-0.00502,-0.95294,0.30312>,
            
    /*2*/<-0.86605,0.49994,-0.00525>,<0.82466,0.34284,-0.44987>,<0.06094,-0.85697,0.51174>,
            
    /*3*/<-0.91916,0.36544,-0.14698>,<0.7613,0.28786,-0.58099>,<0.15603,-0.63841,0.75372>,
            
    /*4*/<0.12619,0.83521,0.53525>

    /* stem 0.23.21*/ 
    /*0*/<-0.0437,-0.98755,0.15113>,
    /*1*/<0.7924,-0.11827,-0.59843>,<0.13163,0.15245,0.97951>,<-0.92294,-0.00968,-0.38482>,
            
    /*2*/<0.78989,-0.16355,-0.59103>,<0.13423,0.1757,0.97525>,<-0.92099,0.01175,-0.38941>,
            
    /*3*/<0.79383,-0.0442,-0.60653>,<0.15328,0.07307,0.98548>,<-0.9239,-0.00008,-0.38264>,
            
    /*4*/<-0.08005,0.99408,0.07345>

    /* stem 0.23.22*/ 
    /*0*/<-0.90469,-0.108,-0.41215>,
    /*1*/<-0.35388,-0.32269,0.87786>,<-0.01112,0.97655,-0.215>,<0.38346,-0.65166,-0.65445>,
            
    /*2*/<-0.34192,-0.31999,0.88357>,<-0.05592,0.97009,-0.23622>,<0.41632,-0.64552,-0.6403>,
            
    /*3*/<-0.37875,-0.34576,0.85848>,<-0.15875,0.94435,-0.28811>,<0.56497,-0.59937,-0.56707>,
            
    /*4*/<0.73876,0.37591,0.5594>

    /* stem 0.23.23*/ 
    /*0*/<0.43293,-0.64312,-0.63164>,
    /*1*/<-0.26887,0.58217,-0.76732>,<0.87627,0.14961,0.45801>,<-0.61538,-0.71993,0.32095>,
            
    /*2*/<-0.28075,0.65126,-0.70501>,<0.95251,-0.00604,0.30446>,<-0.63741,-0.64881,0.41563>,
            
    /*3*/<-0.30478,0.73867,-0.60123>,<0.97619,-0.14528,0.16105>,<-0.67388,-0.58293,0.45395>,
            
    /*4*/<-0.0529,0.59066,0.80518>

    /* stem 0.23.24*/ 
    /*0*/<-0.6402,-0.68994,0.33783>,
    /*1*/<0.77114,-0.55898,0.30478>,<-0.39928,0.67931,0.61572>,<-0.36214,-0.10987,-0.92563>,
            
    /*2*/<0.68141,-0.65663,0.3233>,<-0.43363,0.65253,0.62143>,<-0.22855,0.00815,-0.9735>,
            
    /*3*/<0.58023,-0.74309,0.33339>,<-0.54855,0.53996,0.63839>,<-0.02815,0.2222,-0.97459>,
            
    /*4*/<0.71314,0.65851,0.24042>

    /* stem 0.23.25*/ 
    /*0*/<-0.35805,-0.17348,-0.91744>,
    /*1*/<-0.90891,0.28419,0.30517>,<0.63647,0.67568,-0.37197>,<0.27657,-0.95787,0.07739>,
            
    /*2*/<-0.91967,0.2723,0.28295>,<0.59395,0.62011,-0.51253>,<0.35763,-0.90262,0.23954>,
            
    /*3*/<-0.94407,0.22329,0.24265>,<0.47728,0.37157,-0.79633>,<0.55554,-0.59952,0.57615>,
            
    /*4*/<0.23328,0.93489,0.26751>

    /* stem 0.23.26*/ 
    /*0*/<0.09557,-0.99159,-0.08731>,
    /*1*/<0.62652,0.13032,-0.76844>,<0.35616,-0.04558,0.93331>,<-0.98332,-0.07804,-0.16429>,
            
    /*2*/<0.62835,0.13982,-0.76527>,<0.34177,-0.23553,0.90979>,<-0.98884,0.09445,-0.11523>,
            
    /*3*/<0.66976,0.26812,-0.69249>,<0.30967,-0.54897,0.77636>,<-0.95783,0.27686,-0.07685>,
            
    /*4*/<0.17304,0.73822,0.65199>

    /* stem 0.23.27*/ 
    /*0*/<-0.86709,-0.41443,-0.2764>,
    /*1*/<-0.049,-0.47932,0.87627>,<-0.40335,0.91006,-0.09534>,<0.45512,-0.42941,-0.78004>,
            
    /*2*/<-0.02007,-0.45623,0.88964>,<-0.52527,0.83874,-0.14358>,<0.53949,-0.36973,-0.75647>,
            
    /*3*/<0.0392,-0.40185,0.91487>,<-0.64531,0.73896,-0.19369>,<0.60855,-0.33562,-0.71905>,
            
    /*4*/<0.68899,0.68853,0.22634>

    /* stem 0.24*/ 
    /*0*/<0.91038,-0.38043,-0.16275>,
    /*1*/<-0.18412,0.01035,-0.98285>,<0.29302,0.88571,-0.36007>,<0.35063,0.54315,0.76292>,
            <-0.0909,-0.54393,0.83419>,<-0.4214,-0.87322,-0.24475>,
    /*2*/<-0.25233,0.04199,-0.96673>,<0.31168,0.87757,-0.36431>,<0.43193,0.50744,0.74561>,
            <-0.06002,-0.55825,0.8275>,<-0.48206,-0.8454,-0.23004>,
    /*3*/<-0.31431,0.08677,-0.94535>,<0.38127,0.84446,-0.37619>,<0.53726,0.44223,0.71818>,
            <-0.06223,-0.56275,0.82428>,<-0.58824,-0.78261,-0.2037>,
    /*4*/<-0.29044,0.07094,-0.95426>,<0.43696,0.80735,-0.39654>,<0.54789,0.43698,0.71335>,
            <-0.11057,-0.52816,0.84192>,<-0.62861,-0.75453,-0.18848>,
    /*5*/<-0.27348,0.05444,-0.96034>,<0.52271,0.73646,-0.42941>,<0.58419,0.40985,0.70054>,
            <-0.17278,-0.47214,0.86442>,<-0.70339,-0.69215,-0.16174>,
    /*6*/<-0.64036,0.73574,0.22054>

    /* stem 0.24.0*/ 
    /*0*/<0.48224,-0.78287,0.39313>,
    /*1*/<0.36937,0.59802,0.7113>,<-0.87807,-0.45808,0.13839>,<0.49364,-0.11547,-0.86197>,
            
    /*2*/<0.36307,0.60796,0.70609>,<-0.87488,-0.46335,0.14106>,<0.49663,-0.12028,-0.85959>,
            
    /*3*/<0.47271,0.47467,0.74245>,<-0.84209,-0.52242,0.13401>,<0.38222,0.11045,-0.91745>,
            
    /*4*/<-0.57135,0.81284,0.11337>

    /* stem 0.24.1*/ 
    /*0*/<0.5311,-0.13114,-0.8371>,
    /*1*/<-0.40554,-0.9083,-0.1026>,<-0.45232,0.79738,-0.39949>,<0.84132,0.115,0.52817>,
            
    /*2*/<-0.46316,-0.88475,-0.05203>,<-0.32089,0.75632,-0.57009>,<0.76926,0.16252,0.61792>,
            
    /*3*/<-0.6068,-0.79477,0.01129>,<0.04101,0.56722,-0.82255>,<0.57526,0.26495,0.77387>,
            
    /*4*/<-0.72607,0.6773,0.1187>

    /* stem 0.24.2*/ 
    /*0*/<0.91883,-0.00511,0.39463>,
    /*1*/<0.22899,0.80387,-0.54896>,<-0.40105,0.11323,0.90903>,<0.14355,-0.91694,-0.37232>,
            
    /*2*/<0.35068,0.78193,-0.51538>,<-0.35234,0.09896,0.93062>,<-0.02977,-0.89242,-0.45021>,
            
    /*3*/<0.52125,0.71479,-0.46623>,<-0.18648,0.03534,0.98182>,<-0.38481,-0.75647,-0.52885>,
            
    /*4*/<-0.76176,0.64742,-0.02375>

    /* stem 0.24.3*/ 
    /*0*/<0.41478,-0.8567,-0.30663>,
    /*1*/<0.03037,-0.31303,0.94926>,<-0.80899,-0.1793,-0.5598>,<0.76581,0.51881,-0.37998>,
            
    /*2*/<-0.0758,-0.17703,0.98128>,<-0.71519,-0.37021,-0.59283>,<0.74716,0.54434,-0.38138>,
            
    /*3*/<-0.20674,-0.05537,0.97683>,<-0.52299,-0.5462,-0.65433>,<0.71038,0.62301,-0.32743>,
            
    /*4*/<-0.7097,0.6965,-0.10594>

    /* stem 0.24.4*/ 
    /*0*/<0.8886,0.26211,-0.37642>,
    /*1*/<-0.30069,-0.31339,-0.90076>,<-0.16997,0.94386,0.28326>,<0.44328,-0.63854,0.6291>,
            
    /*2*/<-0.36735,-0.3041,-0.87896>,<0.07237,0.97774,0.19696>,<0.29811,-0.63483,0.71283>,
            
    /*3*/<-0.50093,-0.24348,-0.83053>,<0.57302,0.8195,0.0087>,<-0.01443,-0.53101,0.84724>,
            
    /*4*/<-0.59473,0.76723,0.24011>

    /* stem 0.24.5*/ 
    /*0*/<0.70582,-0.58486,0.39968>,
    /*1*/<0.40484,0.80386,0.43578>,<-0.71222,-0.51921,0.4724>,<0.28572,-0.26671,-0.92045>,
            
    /*2*/<0.56076,0.66624,0.4916>,<-0.73366,-0.49138,0.46934>,<0.18806,-0.1361,-0.97268>,
            
    /*3*/<0.68143,0.53569,0.49869>,<-0.62698,-0.60666,0.48874>,<-0.09393,0.06817,-0.99324>,
            
    /*4*/<-0.72381,0.6376,0.26374>

    /* stem 0.24.6*/ 
    /*0*/<0.18355,-0.3304,-0.92582>,
    /*1*/<-0.40323,-0.88151,0.24565>,<-0.57826,0.73006,-0.36419>,<0.97588,0.16155,0.14682>,
            
    /*2*/<-0.45305,-0.80939,0.37367>,<-0.55018,0.64315,-0.53259>,<0.96886,0.1806,0.16938>,
            
    /*3*/<-0.52303,-0.67979,0.51413>,<-0.42352,0.47114,-0.77373>,<0.93527,0.2348,0.26484>,
            
    /*4*/<-0.41008,0.75964,0.50476>

    /* stem 0.24.7*/ 
    /*0*/<0.97059,0.14109,0.19506>,
    /*1*/<0.05412,0.6286,-0.77585>,<-0.24279,0.34484,0.90672>,<0.15918,-0.97773,-0.1368>,
            
    /*2*/<0.12474,0.62115,-0.7737>,<-0.10953,0.32923,0.93788>,<-0.06167,-0.98461,-0.1635>,
            
    /*3*/<0.34092,0.53618,-0.77219>,<0.07263,0.32626,0.94249>,<-0.45572,-0.86751,-0.19938>,
            
    /*4*/<-0.7608,0.63983,-0.10864>

    /* stem 0.24.8*/ 
    /*0*/<0.38997,-0.89869,-0.2007>,
    /*1*/<0.29946,-0.07133,0.95144>,<-0.90851,-0.32414,-0.26371>,<0.59728,0.4226,-0.68167>,
            
    /*2*/<0.2428,0.00098,0.97008>,<-0.82364,-0.48457,-0.29464>,<0.54984,0.48844,-0.67758>,
            
    /*3*/<0.09309,0.14688,0.98476>,<-0.68259,-0.64468,-0.34417>,<0.57096,0.52356,-0.63237>,
            
    /*4*/<-0.68107,0.71749,-0.14614>

    /* stem 0.24.9*/ 
    /*0*/<0.74738,0.10205,-0.65652>,
    /*1*/<-0.53623,-0.5079,-0.67416>,<-0.09144,0.99365,0.06557>,<0.60526,-0.48881,0.62827>,
            
    /*2*/<-0.52632,-0.50874,-0.6813>,<0.05727,0.99804,-0.02533>,<0.46131,-0.47479,0.74951>,
            
    /*3*/<-0.5133,-0.49647,-0.70002>,<0.40752,0.8958,-0.17741>,<0.1079,-0.36066,0.92644>,
            
    /*4*/<-0.77296,0.62596,0.10345>

    /* stem 0.24.10*/ 
    /*0*/<0.75989,-0.49526,0.42105>,
    /*1*/<0.49917,0.86189,0.08932>,<-0.61351,-0.30032,0.73035>,<0.09167,-0.54679,-0.83223>,
            
    /*2*/<0.49201,0.86582,0.09098>,<-0.4323,-0.44312,0.78534>,<-0.10838,-0.45587,-0.88342>,
            
    /*3*/<0.61949,0.78499,0.00473>,<-0.17598,-0.55325,0.81422>,<-0.48419,-0.19572,-0.85279>,
            
    /*4*/<-0.58442,0.68994,0.42713>

    /* stem 0.24.11*/ 
    /*0*/<0.17455,-0.6396,-0.74863>,
    /*1*/<-0.33081,-0.74811,0.57524>,<-0.64083,0.51107,-0.57284>,<0.96647,0.25602,0.01981>,
            
    /*2*/<-0.36686,-0.63037,0.68414>,<-0.63054,0.41589,-0.65533>,<0.97331,0.22949,-0.00006>,
            
    /*3*/<-0.41874,-0.48132,0.77005>,<-0.56586,0.30284,-0.76687>,<0.97899,0.20369,0.00942>,
            
    /*4*/<-0.19442,0.88093,0.43147>

    /* stem 0.24.12*/ 
    /*0*/<0.97862,0.20429,-0.02371>,
    /*1*/<-0.10712,0.35729,-0.92783>,<-0.1177,0.60689,0.78602>,<0.19592,-0.97021,0.14251>,
            
    /*2*/<-0.02139,0.34558,-0.93815>,<0.03436,0.59548,0.80264>,<-0.06689,-0.9851,0.15846>,
            
    /*3*/<0.0744,0.3482,-0.93446>,<0.46395,0.41797,0.78106>,<-0.56401,-0.78612,0.25281>,
            
    /*4*/<-0.52571,0.81086,0.25717>

    /* stem 0.24.13*/ 
    /*0*/<0.28157,-0.95693,0.07079>,
    /*1*/<0.47569,0.21332,0.85335>,<-0.96225,-0.27155,0.01852>,<0.47829,0.08631,-0.87395>,
            
    /*2*/<0.47368,0.21376,0.85436>,<-0.88761,-0.46059,-0.00247>,<0.38166,0.26314,-0.88605>,
            
    /*3*/<0.56159,0.14283,0.81499>,<-0.73221,-0.68046,-0.02886>,<0.15513,0.58726,-0.79439>,
            
    /*4*/<-0.65499,0.55049,0.51765>

    /* stem 0.24.14*/ 
    /*0*/<0.5469,-0.04396,-0.83604>,
    /*1*/<-0.64085,-0.67135,-0.37229>,<-0.15945,0.97664,-0.14405>,<0.78437,-0.304,0.54069>,
            
    /*2*/<-0.67079,-0.65688,-0.3443>,<-0.01809,0.95037,-0.3106>,<0.6952,-0.25552,0.67187>,
            
    /*3*/<-0.65396,-0.66696,-0.35707>,<0.14967,0.86924,-0.47119>,<0.48591,-0.19423,0.85216>,
            
    /*4*/<-0.7945,0.42763,0.43117>

    /* stem 0.24.15*/ 
    /*0*/<0.83109,-0.35921,0.42456>,
    /*1*/<0.48722,0.82874,-0.27533>,<-0.47471,-0.03186,0.87956>,<-0.0366,-0.78647,-0.61654>,
            
    /*2*/<0.52147,0.81408,-0.25563>,<-0.51615,-0.01182,0.85642>,<-0.02909,-0.79002,-0.61239>,
            
    /*3*/<0.6271,0.75701,-0.18351>,<-0.51262,-0.06117,0.85643>,<-0.14346,-0.69162,-0.70787>,
            
    /*4*/<-0.6998,0.66151,-0.2696>

    /* stem 0.24.16*/ 
    /*0*/<0.06342,-0.80517,-0.58965>,
    /*1*/<-0.12384,-0.58488,0.80161>,<-0.79662,0.32324,-0.5108>,<0.91864,0.28482,-0.27384>,
            
    /*2*/<-0.12375,-0.58791,0.79941>,<-0.78662,0.26273,-0.55876>,<0.90755,0.35205,-0.22894>,
            
    /*3*/<-0.13423,-0.54244,0.8293>,<-0.77289,0.18421,-0.60722>,<0.90173,0.38072,-0.20475>,
            
    /*4*/<-0.19744,0.85972,0.47106>

    /* stem 0.24.17*/ 
    /*0*/<0.94692,0.20849,-0.24468>,
    /*1*/<-0.26771,0.04034,-0.96266>,<-0.04496,0.82301,0.56624>,<0.28556,-0.86931,0.40342>,
            
    /*2*/<-0.23748,0.03381,-0.9708>,<0.19686,0.8135,0.54723>,<0.01255,-0.86521,0.50125>,
            
    /*3*/<-0.19621,0.03803,-0.97982>,<0.52155,0.73023,0.44131>,<-0.34507,-0.75601,0.55621>,
            
    /*4*/<-0.7705,0.61493,0.16788>

    /* stem 0.24.18*/ 
    /*0*/<0.28498,-0.8687,0.40516>,
    /*1*/<0.5569,0.50217,0.66158>,<-0.95642,-0.20661,0.20634>,<0.39142,-0.27085,-0.87945>,
            
    /*2*/<0.53785,0.53199,0.654>,<-0.89305,-0.36588,0.26192>,<0.32545,-0.16142,-0.93168>,
            
    /*3*/<0.50048,0.58091,0.64192>,<-0.74433,-0.58194,0.32759>,<0.22129,0.01549,-0.97509>,
            
    /*4*/<-0.71944,0.68902,-0.08755>

    /* stem 0.24.19*/ 
    /*0*/<0.32422,-0.17957,-0.92878>,
    /*1*/<-0.60172,-0.79739,-0.04579>,<-0.33796,0.89807,-0.28151>,<0.93056,-0.09563,0.35343>,
            
    /*2*/<-0.55519,-0.82555,-0.10116>,<-0.22727,0.87672,-0.42391>,<0.80226,-0.01547,0.59678>,
            
    /*3*/<-0.56977,-0.804,-0.17013>,<-0.051,0.78256,-0.62048>,<0.60043,0.03479,0.79892>,
            
    /*4*/<-0.72603,0.47599,0.49631>

    /* stem 0.24.20*/ 
    /*0*/<0.88077,-0.05671,0.47013>,
    /*1*/<0.3496,0.73084,-0.58622>,<-0.45562,0.22484,0.86131>,<0.08192,-0.95413,-0.28796>,
            
    /*2*/<0.33618,0.73643,-0.58708>,<-0.24104,0.16303,0.95672>,<-0.1334,-0.93107,-0.33958>,
            
    /*3*/<0.37476,0.68968,-0.61959>,<0.07746,0.09159,0.99278>,<-0.49277,-0.78433,-0.37683>,
            
    /*4*/<-0.76578,0.63332,0.11178>

    /* stem 0.24.21*/ 
    /*0*/<0.03772,-0.94604,-0.32186>,
    /*1*/<0.05046,-0.31241,0.94861>,<-0.88994,0.12231,-0.43938>,<0.83859,0.21241,-0.50164>,
            
    /*2*/<0.04837,-0.30536,0.95101>,<-0.88036,0.03515,-0.47299>,<0.82746,0.29416,-0.47831>,
            
    /*3*/<0.06705,-0.33779,0.93883>,<-0.81994,-0.1528,-0.55167>,<0.75188,0.52802,-0.39481>,
            
    /*4*/<-0.5461,0.75157,0.37003>

    /* stem 0.24.22*/ 
    /*0*/<0.86518,-0.05003,-0.49896>,
    /*1*/<-0.50517,-0.1801,-0.84402>,<0.20235,0.94125,0.27036>,<0.28486,-0.76012,0.58402>,
            
    /*2*/<-0.64205,-0.11458,-0.75805>,<0.42436,0.89963,0.10287>,<0.23418,-0.73261,0.63909>,
            
    /*3*/<-0.72091,-0.12814,-0.68108>,<0.65299,0.75409,-0.07039>,<0.05128,-0.62484,0.77907>,
            
    /*4*/<-0.62345,0.67693,0.39123>

    /* stem 0.24.23*/ 
    /*0*/<0.43779,-0.81938,0.37006>,
    /*1*/<0.75507,0.56259,0.3367>,<-0.80058,-0.15982,0.57752>,<0.03788,-0.38848,-0.92068>,
            
    /*2*/<0.82498,0.40725,0.39186>,<-0.8188,-0.09992,0.56532>,<0.01254,-0.29058,-0.95677>,
            
    /*3*/<0.90702,0.10193,0.40855>,<-0.81836,-0.03158,0.57383>,<-0.0734,-0.05275,-0.99591>,
            
    /*4*/<0.01122,0.99646,0.08335>

    /* stem 0.24.24*/ 
    /*0*/<0.13264,-0.53612,-0.83365>,
    /*1*/<-0.66221,-0.67151,0.33251>,<-0.30908,0.77969,-0.54457>,<0.96929,-0.10011,0.22462>,
            
    /*2*/<-0.68014,-0.62551,0.38229>,<-0.28449,0.68957,-0.66601>,<0.95904,-0.04595,0.27952>,
            
    /*3*/<-0.7028,-0.56501,0.43226>,<-0.18912,0.4795,-0.85692>,<0.90079,0.10852,0.42047>,
            
    /*4*/<-0.42206,0.82446,0.37701>

    /* stem 0.24.25*/ 
    /*0*/<0.96531,-0.07893,0.2489>,
    /*1*/<0.25248,0.47539,-0.84277>,<-0.17628,0.52169,0.83472>,<-0.08655,-0.99623,0.00538>,
            
    /*2*/<0.25185,0.47642,-0.84237>,<0.06195,0.43474,0.89842>,<-0.34017,-0.94036,0.00017>,
            
    /*3*/<0.26781,0.43821,-0.85805>,<0.39889,0.28065,0.873>,<-0.68984,-0.72396,-0.00058>,
            
    /*4*/<-0.59412,0.78696,0.16649>

    /* stem 0.24.26*/ 
    /*0*/<0.00296,-0.99839,-0.05659>,
    /*1*/<0.26944,-0.05159,0.96164>,<-0.96872,0.01329,-0.24781>,<0.69926,0.04463,-0.71347>,
            
    /*2*/<0.2859,-0.14005,0.94797>,<-0.96295,-0.05056,-0.2649>,<0.6917,0.20653,-0.69203>,
            
    /*3*/<0.30598,-0.21643,0.92711>,<-0.9354,-0.21221,-0.28285>,<0.62392,0.43482,-0.64935>,
            
    /*4*/<-0.3942,0.86088,0.32171>

    /* stem 0.24.27*/ 
    /*0*/<0.72557,-0.1595,-0.66941>,
    /*1*/<-0.66931,-0.39271,-0.63071>,<0.19325,0.98088,-0.02306>,<0.47434,-0.58779,0.65536>,
            
    /*2*/<-0.72533,-0.35983,-0.58687>,<0.34071,0.9275,-0.1538>,<0.40505,-0.54409,0.73478>,
            
    /*3*/<-0.77134,-0.33773,-0.53942>,<0.56722,0.75489,-0.32924>,<0.21838,-0.40928,0.88589>,
            
    /*4*/<-0.57263,0.75628,0.31645>

    /* stem 0.25*/ 
    /*0*/<-0.60035,-0.37928,0.70408>,
    /*1*/<0.77271,-0.0146,0.63459>,<0.02444,0.87827,0.47754>,<-0.74801,0.56346,-0.3507>,
            <-0.47715,-0.52397,-0.70554>,<0.46271,-0.88123,-0.0966>,
    /*2*/<0.75224,-0.02742,0.65832>,<0.01889,0.87487,0.48398>,<-0.73048,0.57404,-0.36996>,
            <-0.46061,-0.51392,-0.72369>,<0.45561,-0.88577,-0.08844>,
    /*3*/<0.73436,-0.04268,0.67741>,<-0.02514,0.84337,0.53674>,<-0.74013,0.56998,-0.35684>,
            <-0.42183,-0.48398,-0.7667>,<0.4893,-0.86272,-0.12768>,
    /*4*/<0.74115,-0.03466,0.67044>,<-0.08611,0.79721,0.59752>,<-0.78505,0.53555,-0.31126>,
            <-0.38941,-0.45787,-0.7992>,<0.55355,-0.81027,-0.19246>,
    /*5*/<0.76788,-0.00501,0.64057>,<-0.10214,0.78462,0.6115>,<-0.82252,0.49925,-0.27243>,
            <-0.39715,-0.46742,-0.7898>,<0.58558,-0.77869,-0.22528>,
    /*6*/<0.50352,0.57429,-0.6455>

    /* stem 0.25.0*/ 
    /*0*/<-0.66633,-0.73055,0.14936>,
    /*1*/<-0.72781,0.61673,-0.29989>,<0.48425,-0.56418,-0.66874>,<0.26433,-0.02979,0.96397>,
            
    /*2*/<-0.75756,0.58554,-0.28853>,<0.45495,-0.60076,-0.65735>,<0.32566,0.03871,0.94469>,
            
    /*3*/<-0.75285,0.58815,-0.29546>,<0.34055,-0.71436,-0.61132>,<0.4348,0.13703,0.89004>,
            
    /*4*/<0.67946,0.55652,-0.47815>

    /* stem 0.25.1*/ 
    /*0*/<0.11976,-0.15208,0.98109>,
    /*1*/<0.35865,-0.91271,-0.19579>,<0.62008,0.78374,0.03526>,<-0.98245,0.13368,0.13011>,
            
    /*2*/<0.40473,-0.85281,-0.33002>,<0.62285,0.67505,0.39544>,<-0.97466,0.22363,0.00453>,
            
    /*3*/<0.47408,-0.72456,-0.50027>,<0.46199,0.46509,0.75516>,<-0.92322,0.28274,-0.26024>,
            
    /*4*/<0.44294,0.72088,-0.53305>

    /* stem 0.25.2*/ 
    /*0*/<-0.97217,0.05809,0.22695>,
    /*1*/<0.19335,0.79101,0.58044>,<-0.20795,0.13029,-0.96942>,<0.0446,-0.92309,0.38198>,
            
    /*2*/<0.15125,0.78358,0.6026>,<-0.37499,0.09574,-0.92207>,<0.2654,-0.9186,0.29281>,
            
    /*3*/<0.07463,0.7463,0.66141>,<-0.56778,0.10345,-0.81665>,<0.51963,-0.84248,0.14219>,
            
    /*4*/<0.73375,0.45564,-0.50399>

    /* stem 0.25.3*/ 
    /*0*/<-0.1442,-0.85807,0.49288>,
    /*1*/<-0.63932,-0.28975,-0.71226>,<0.97484,-0.20377,-0.09034>,<-0.33109,0.5199,0.78746>,
            
    /*2*/<-0.64948,-0.37001,-0.66428>,<0.97955,-0.15867,-0.12367>,<-0.33056,0.5501,0.76689>,
            
    /*3*/<-0.68002,-0.43275,-0.59186>,<0.97057,-0.22188,-0.09365>,<-0.27685,0.68423,0.67467>,
            
    /*4*/<0.21393,0.64348,-0.73496>

    /* stem 0.25.4*/ 
    /*0*/<-0.41997,0.28678,0.86104>,
    /*1*/<0.80269,-0.33715,0.49196>,<-0.02134,0.94166,-0.33588>,<-0.76851,-0.61329,-0.18242>,
            
    /*2*/<0.85908,-0.33357,0.38821>,<-0.11926,0.98577,-0.11843>,<-0.7383,-0.61256,-0.28227>,
            
    /*3*/<0.87869,-0.36588,0.30666>,<-0.30833,0.92342,0.22852>,<-0.59243,-0.54393,-0.59428>,
            
    /*4*/<0.52547,0.54129,-0.65642>

    /* stem 0.25.5*/ 
    /*0*/<-0.81281,-0.56299,-0.14962>,
    /*1*/<-0.54912,0.83194,-0.07958>,<0.43353,-0.39227,-0.81128>,<0.14033,-0.42255,0.89541>,
            
    /*2*/<-0.58948,0.80474,-0.07003>,<0.30293,-0.51827,-0.79977>,<0.34878,-0.29251,0.89039>,
            
    /*3*/<-0.67291,0.73965,-0.0104>,<0.08919,-0.6185,-0.78071>,<0.60882,-0.10176,0.78675>,
            
    /*4*/<0.5891,0.63273,-0.50261>

    /* stem 0.25.6*/ 
    /*0*/<0.0702,-0.4128,0.90811>,
    /*1*/<0.09535,-0.89911,-0.42721>,<0.81109,0.55677,0.17927>,<-0.90857,0.35485,0.22041>,
            
    /*2*/<0.11848,-0.86642,-0.48506>,<0.79,0.44771,0.41888>,<-0.88417,0.45917,0.08611>,
            
    /*3*/<0.12606,-0.86515,-0.48541>,<0.68202,0.32248,0.65639>,<-0.80317,0.56202,-0.1976>,
            
    /*4*/<0.58696,0.38741,-0.71091>

    /* stem 0.25.7*/ 
    /*0*/<-0.90015,0.37468,0.22213>,
    /*1*/<0.41924,0.5539,0.71932>,<-0.06919,0.35879,-0.93085>,<-0.32289,-0.92401,0.20482>,
            
    /*2*/<0.22403,0.60046,0.76763>,<-0.04259,0.35809,-0.93272>,<-0.15544,-0.96782,0.19791>,
            
    /*3*/<-0.03848,0.62224,0.78188>,<-0.14171,0.31454,-0.93861>,<0.2273,-0.96264,0.14715>,
            
    /*4*/<0.90713,0.3899,-0.15843>

    /* stem 0.25.8*/ 
    /*0*/<-0.40017,-0.84197,0.36187>,
    /*1*/<-0.7205,0.05731,-0.69108>,<0.85222,-0.4813,-0.20512>,<-0.11969,0.44929,0.88533>,
            
    /*2*/<-0.72153,0.05481,-0.69021>,<0.82962,-0.52788,-0.18185>,<-0.09288,0.49736,0.86256>,
            
    /*3*/<-0.76546,-0.04434,-0.64195>,<0.85106,-0.47351,-0.22691>,<-0.07103,0.53428,0.84232>,
            
    /*4*/<0.20228,0.84603,-0.49326>

    /* stem 0.25.9*/ 
    /*0*/<-0.21372,0.25766,0.9423>,
    /*1*/<0.70195,-0.63512,0.32231>,<0.24243,0.9462,-0.21431>,<-0.938,-0.31877,-0.13614>,
            
    /*2*/<0.78385,-0.6084,0.12422>,<0.19066,0.97215,0.13626>,<-0.92947,-0.29534,-0.22105>,
            
    /*3*/<0.83473,-0.53133,-0.14463>,<0.02699,0.81723,0.57569>,<-0.86537,-0.25457,-0.43167>,
            
    /*4*/<0.2562,0.69473,-0.67209>

    /* stem 0.25.10*/ 
    /*0*/<-0.93751,-0.33848,-0.08069>,
    /*1*/<-0.3384,0.92361,0.18008>,<0.19489,-0.28692,-0.93792>,<0.17137,-0.62663,0.76024>,
            
    /*2*/<-0.50809,0.84459,0.16886>,<0.24982,-0.24736,-0.93616>,<0.26313,-0.568,0.77983>,
            
    /*3*/<-0.67813,0.71429,0.17304>,<0.25708,-0.2387,-0.93645>,<0.4467,-0.4592,0.76785>,
            
    /*4*/<0.68187,0.72788,-0.0724>

    /* stem 0.25.11*/ 
    /*0*/<0.04235,-0.68701,0.72541>,
    /*1*/<-0.09244,-0.71886,-0.68898>,<0.90712,0.33677,0.25242>,<-0.81593,0.40238,0.41514>,
            
    /*2*/<-0.09302,-0.66529,-0.74077>,<0.91024,0.29724,0.28831>,<-0.81606,0.38722,0.42907>,
            
    /*3*/<-0.07541,-0.56586,-0.82105>,<0.89945,0.17426,0.40077>,<-0.81297,0.41512,0.40835>,
            
    /*4*/<0.21087,0.82137,-0.52999>

    /* stem 0.25.12*/ 
    /*0*/<-0.8014,0.35682,0.48003>,
    /*1*/<0.58539,0.24965,0.77136>,<-0.14637,0.64866,-0.74687>,<-0.41553,-0.90876,-0.03856>,
            
    /*2*/<0.52652,0.26453,0.80796>,<-0.19608,0.66181,-0.72357>,<-0.30646,-0.9467,-0.09917>,
            
    /*3*/<0.43749,0.28737,0.85207>,<-0.3778,0.66688,-0.64229>,<-0.03887,-0.96876,-0.24493>,
            
    /*4*/<0.84557,0.25277,-0.47023>

    /* stem 0.25.13*/ 
    /*0*/<-0.43789,-0.89465,0.08867>,
    /*1*/<-0.78859,0.34649,-0.508>,<0.76766,-0.41341,-0.48968>,<0.03369,0.09299,0.9951>,
            
    /*2*/<-0.81602,0.29759,-0.49553>,<0.74556,-0.46536,-0.47705>,<0.08486,0.19721,0.97668>,
            
    /*3*/<-0.81037,0.3025,-0.50179>,<0.65225,-0.61599,-0.44173>,<0.17698,0.32754,0.92811>,
            
    /*4*/<0.58478,0.70302,-0.4047>

    /* stem 0.25.14*/ 
    /*0*/<0.02463,0.02157,0.99946>,
    /*1*/<0.63692,-0.77088,-0.0087>,<0.34827,0.93661,-0.03844>,<-0.9859,-0.16635,0.01824>,
            
    /*2*/<0.64002,-0.76828,-0.01085>,<0.25803,0.92756,0.27028>,<-0.9565,-0.07664,-0.28148>,
            
    /*3*/<0.62944,-0.77573,0.04534>,<0.02536,0.76543,0.64302>,<-0.66718,0.06039,-0.74245>,
            
    /*4*/<0.78486,0.51727,-0.34121>

    /* stem 0.25.15*/ 
    /*0*/<-0.97877,-0.20451,-0.01394>,
    /*1*/<-0.17394,0.8449,0.50585>,<0.02166,0.01137,-0.9997>,<0.18044,-0.85039,0.49425>,
            
    /*2*/<-0.19047,0.8414,0.50573>,<0.02418,0.01209,-0.99963>,<0.19432,-0.84711,0.49462>,
            
    /*3*/<-0.31246,0.79395,0.52155>,<-0.09066,-0.09848,-0.991>,<0.49832,-0.71714,0.48722>,
            
    /*4*/<0.69793,0.65061,-0.29934>

    /* stem 0.25.16*/ 
    /*0*/<0.18115,-0.86375,0.47023>,
    /*1*/<-0.33735,-0.49549,-0.80042>,<0.96661,0.24826,0.06342>,<-0.63443,0.27188,0.72359>,
            
    /*2*/<-0.33567,-0.58303,-0.73986>,<0.97357,0.20459,0.10153>,<-0.66044,0.41162,0.628>,
            
    /*3*/<-0.34183,-0.65121,-0.67755>,<0.9846,0.13362,0.11275>,<-0.64321,0.53739,0.54543>,
            
    /*4*/<-0.01294,0.72813,-0.68532>

    /* stem 0.25.17*/ 
    /*0*/<-0.63883,0.28152,0.71599>,
    /*1*/<0.74484,-0.03764,0.66618>,<-0.17761,0.84524,-0.504>,<-0.54912,-0.81558,-0.18247>,
            
    /*2*/<0.60534,-0.04777,0.79453>,<-0.25135,0.84889,-0.46498>,<-0.31368,-0.87427,-0.37049>,
            
    /*3*/<0.462,0.01605,0.88673>,<-0.45737,0.82116,-0.34135>,<0.00498,-0.82318,-0.56776>,
            
    /*4*/<0.78157,0.43492,-0.4472>

    /* stem 0.25.18*/ 
    /*0*/<-0.56795,-0.82264,-0.02645>,
    /*1*/<-0.79096,0.56502,-0.23481>,<0.5837,-0.36832,-0.72363>,<0.22324,-0.17356,0.95919>,
            
    /*2*/<-0.88684,0.41909,-0.19462>,<0.56804,-0.40865,-0.71438>,<0.32642,0.03747,0.94448>,
            
    /*3*/<-0.94177,0.30084,-0.15019>,<0.47016,-0.53367,-0.70295>,<0.48399,0.25042,0.83848>,
            
    /*4*/<0.36388,0.78562,-0.50039>

    /* stem 0.25.19*/ 
    /*0*/<0.08791,-0.30998,0.94667>,
    /*1*/<0.48035,-0.81597,-0.32166>,<0.5139,0.83063,0.21439>,<-0.99672,-0.00597,0.08073>,
            
    /*2*/<0.48978,-0.78509,-0.37914>,<0.51518,0.76158,0.39316>,<-0.99835,0.05448,-0.01839>,
            
    /*3*/<0.534,-0.69698,-0.47861>,<0.43064,0.54361,0.72045>,<-0.95661,0.18593,-0.22433>,
            
    /*4*/<0.40179,0.75778,-0.51414>

    /* stem 0.25.20*/ 
    /*0*/<-0.98196,-0.08818,0.16729>,
    /*1*/<0.06785,0.69805,0.71283>,<-0.17635,0.26817,-0.94709>,<0.13479,-0.96386,0.22979>,
            
    /*2*/<-0.14139,0.62263,0.76964>,<-0.19479,0.25984,-0.9458>,<0.38311,-0.89597,0.22464>,
            
    /*3*/<-0.48418,0.37688,0.78964>,<-0.22308,0.30029,-0.92739>,<0.72218,-0.66907,0.17551>,
            
    /*4*/<0.51184,0.84231,0.16894>

    /* stem 0.25.21*/ 
    /*0*/<0.05203,-0.96178,0.26885>,
    /*1*/<-0.5721,-0.24204,-0.78366>,<0.99453,0.03418,-0.09868>,<-0.42363,0.22997,0.87616>,
            
    /*2*/<-0.57112,-0.23716,-0.78586>,<0.99621,-0.05692,-0.0657>,<-0.4187,0.31736,0.85086>,
            
    /*3*/<-0.58998,-0.29233,-0.75264>,<0.97513,-0.2212,0.01377>,<-0.3852,0.54999,0.74104>,
            
    /*4*/<0.27713,0.7395,-0.61346>

    /* stem 0.25.22*/ 
    /*0*/<-0.39877,0.18412,0.89838>,
    /*1*/<0.86309,-0.2655,0.42962>,<-0.15223,0.95066,-0.27031>,<-0.70237,-0.68908,-0.17844>,
            
    /*2*/<0.83296,-0.27452,0.48044>,<-0.25811,0.95691,-0.13303>,<-0.59516,-0.6944,-0.40447>,
            
    /*3*/<0.85503,-0.18777,0.48339>,<-0.52396,0.81475,0.24829>,<-0.38719,-0.58663,-0.7113>,
            
    /*4*/<0.35343,0.74344,-0.56779>

    /* stem 0.25.23*/ 
    /*0*/<-0.70381,-0.70574,-0.08113>,
    /*1*/<-0.70624,0.70455,0.06955>,<0.36626,-0.2541,-0.89515>,<0.35227,-0.43813,0.82701>,
            
    /*2*/<-0.80646,0.5888,0.05414>,<0.41189,-0.18525,-0.8922>,<0.38796,-0.38383,0.83795>,
            
    /*3*/<-0.87854,0.473,0.06661>,<0.40257,-0.18644,-0.8962>,<0.48935,-0.27504,0.82758>,
            
    /*4*/<0.4767,0.876,-0.07334>

    /* stem 0.25.24*/ 
    /*0*/<0.27331,-0.48095,0.83306>,
    /*1*/<0.22698,-0.8071,-0.54504>,<0.69424,0.69908,0.17122>,<-0.92437,0.11357,0.36421>,
            
    /*2*/<0.2111,-0.74669,-0.63079>,<0.73116,0.62337,0.27714>,<-0.92947,0.13128,0.34476>,
            
    /*3*/<0.20635,-0.59149,-0.77946>,<0.75718,0.41722,0.5026>,<-0.9423,0.18301,0.28031>,
            
    /*4*/<0.07912,0.86409,-0.49707>

    /* stem 0.25.25*/ 
    /*0*/<-0.92247,0.08659,0.37622>,
    /*1*/<0.36324,0.53872,0.76015>,<-0.29676,0.45595,-0.83908>,<-0.05972,-0.99531,0.07617>,
            
    /*2*/<0.41788,0.53986,0.7307>,<-0.40019,0.46401,-0.79028>,<-0.01679,-0.9986,0.05008>,
            
    /*3*/<0.43976,0.52252,0.73047>,<-0.6273,0.42522,-0.65245>,<0.19466,-0.97496,-0.10753>,
            
    /*4*/<0.66931,0.40625,-0.62208>

    /* stem 0.25.26*/ 
    /*0*/<-0.05239,-0.99436,0.09224>,
    /*1*/<-0.78103,-0.01545,-0.62431>,<0.92947,-0.08104,-0.3599>,<-0.14824,0.10038,0.98384>,
            
    /*2*/<-0.73171,0.13492,-0.66813>,<0.87626,-0.3398,-0.34161>,<-0.11527,0.17063,0.97857>,
            
    /*3*/<-0.70131,0.19577,-0.68545>,<0.82549,-0.49758,-0.26643>,<-0.12564,0.30367,0.94446>,
            
    /*4*/<0.36974,0.89069,-0.26452>

    /* stem 0.26*/ 
    /*0*/<-0.00956,-0.41185,-0.9112>,
    /*1*/<-0.99956,0.0279,0.01053>,<-0.28875,0.87822,-0.38126>,<0.82125,0.52143,-0.23164>,
            <0.79646,-0.54939,0.25262>,<-0.32886,-0.85441,0.40229>,
    /*2*/<-0.99959,0.0273,0.00882>,<-0.28956,0.85409,-0.43208>,<0.82132,0.50714,-0.26123>,
            <0.79677,-0.53314,0.28447>,<-0.32841,-0.82974,0.45131>,
    /*3*/<-0.99823,0.04586,0.03782>,<-0.28953,0.8322,-0.47288>,<0.81997,0.4769,-0.31658>,
            <0.79673,-0.5297,0.29093>,<-0.32706,-0.79578,0.50967>,
    /*4*/<-0.99916,0.03778,0.01586>,<-0.28521,0.82081,-0.4949>,<0.82281,0.47751,-0.30816>,
            <0.79473,-0.5171,0.31781>,<-0.33079,-0.78875,0.51812>,
    /*5*/<-0.99937,-0.00433,-0.03518>,<-0.29107,0.74345,-0.60213>,<0.82003,0.47235,-0.32316>,
            <0.79632,-0.44108,0.4139>,<-0.32814,-0.73586,0.59231>,
    /*6*/<-0.04622,0.70265,0.71003>

    /* stem 0.26.0*/ 
    /*0*/<0.44279,-0.79823,-0.40837>,
    /*1*/<0.77476,0.57607,-0.26057>,<-0.01041,-0.44969,0.89312>,<-0.77813,-0.10154,-0.61984>,
            
    /*2*/<0.78953,0.54503,-0.2821>,<0.01426,-0.51305,0.85824>,<-0.82601,-0.00812,-0.56359>,
            
    /*3*/<0.80775,0.48665,-0.33274>,<0.06578,-0.60757,0.79154>,<-0.88537,0.14542,-0.44155>,
            
    /*4*/<-0.11798,0.74495,0.6566>

    /* stem 0.26.1*/ 
    /*0*/<-0.78776,-0.10433,-0.60708>,
    /*1*/<-0.18623,-0.89197,0.41195>,<-0.40087,0.82655,0.39511>,<0.61147,0.06865,-0.78828>,
            
    /*2*/<-0.07388,-0.85047,0.52081>,<-0.54242,0.78474,0.29993>,<0.61902,0.07441,-0.78184>,
            
    /*3*/<0.06711,-0.75804,0.64874>,<-0.69565,0.70616,0.13197>,<0.64436,0.06825,-0.76167>,
            
    /*4*/<0.58971,0.58581,0.55594>

    /* stem 0.26.2*/ 
    /*0*/<0.70509,0.11215,-0.7002>,
    /*1*/<-0.48882,0.79929,-0.34955>,<0.68429,0.10848,0.7211>,<-0.21718,-0.91123,-0.34999>,
            
    /*2*/<-0.41737,0.78005,-0.46619>,<0.76235,0.08,0.64221>,<-0.409,-0.90132,-0.14262>,
            
    /*3*/<-0.33146,0.75109,-0.57096>,<0.94085,-0.03008,0.33747>,<-0.59258,-0.75223,0.2881>,
            
    /*4*/<-0.00862,0.60124,0.79902>

    /* stem 0.26.3*/ 
    /*0*/<-0.24107,-0.86238,-0.44519>,
    /*1*/<0.93464,-0.32449,0.14542>,<-0.69734,-0.15452,0.69989>,<-0.22992,0.50545,-0.83166>,
            
    /*2*/<0.93831,-0.30833,0.15658>,<-0.71486,-0.21617,0.66502>,<-0.22123,0.55,-0.80533>,
            
    /*3*/<0.9445,-0.2602,0.20053>,<-0.74406,-0.35429,0.56644>,<-0.20349,0.63481,-0.7454>,
            
    /*4*/<0.02096,0.73452,0.67827>

    /* stem 0.26.4*/ 
    /*0*/<-0.20675,0.21077,-0.95542>,
    /*1*/<-0.9445,-0.29194,0.15064>,<0.26135,0.95122,0.16394>,<0.68947,-0.66572,-0.28541>,
            
    /*2*/<-0.94494,-0.28548,0.15997>,<0.26861,0.94498,-0.18672>,<0.78546,-0.61838,0.02571>,
            
    /*3*/<-0.9511,-0.24862,0.1833>,<0.21193,0.77148,-0.59992>,<0.75206,-0.5002,0.42919>,
            
    /*4*/<-0.04328,0.73038,0.68166>

    /* stem 0.26.5*/ 
    /*0*/<0.68931,-0.6638,-0.29022>,
    /*1*/<0.51001,0.73804,-0.4418>,<0.17399,-0.22338,0.95908>,<-0.70496,-0.49448,-0.50845>,
            
    /*2*/<0.53549,0.71291,-0.45279>,<0.16557,-0.2139,0.96272>,<-0.72096,-0.47749,-0.50221>,
            
    /*3*/<0.54427,0.71692,-0.43566>,<0.26747,-0.36492,0.89179>,<-0.83206,-0.35982,-0.42214>,
            
    /*4*/<-0.42482,0.65445,0.62548>

    /* stem 0.26.6*/ 
    /*0*/<-0.78619,-0.41663,-0.45643>,
    /*1*/<0.16205,-0.84317,0.51264>,<-0.58738,0.71288,0.38314>,<0.44913,0.14291,-0.88196>,
            
    /*2*/<0.19535,-0.82089,0.53663>,<-0.64814,0.67783,0.34707>,<0.47157,0.15934,-0.86732>,
            
    /*3*/<0.20864,-0.81751,0.53679>,<-0.73361,0.61722,0.28435>,<0.54727,0.2179,-0.8081>,
            
    /*4*/<0.59407,0.50582,0.62548>

    /* stem 0.26.7*/ 
    /*0*/<0.5114,0.18559,-0.83906>,
    /*1*/<-0.75824,0.56509,-0.3252>,<0.72978,0.40966,0.54735>,<0.01308,-0.98033,-0.19692>,
            
    /*2*/<-0.65811,0.54982,-0.51439>,<0.74838,0.40562,0.52479>,<-0.15005,-0.98868,-0.00178>,
            
    /*3*/<-0.52531,0.53557,-0.66122>,<0.7929,0.4058,0.45458>,<-0.28268,-0.93173,0.22797>,
            
    /*4*/<-0.54991,0.37322,0.74719>

    /* stem 0.26.8*/ 
    /*0*/<-0.02024,-0.98097,-0.19311>,
    /*1*/<0.99992,-0.01145,0.00501>,<-0.50583,-0.14673,0.85006>,<-0.49349,0.18754,-0.84929>,
            
    /*2*/<0.99599,0.07649,0.04649>,<-0.49936,-0.32858,0.80167>,<-0.5083,0.26203,-0.82035>,
            
    /*3*/<0.98618,0.14117,0.08674>,<-0.49533,-0.53445,0.68484>,<-0.49964,0.41865,-0.75835>,
            
    /*4*/<-0.13239,0.78165,0.60951>

    /* stem 0.26.9*/ 
    /*0*/<-0.49756,0.20636,-0.84252>,
    /*1*/<-0.7736,-0.53646,0.33726>,<0.06307,0.97494,0.21335>,<0.72538,-0.44463,-0.52549>,
            
    /*2*/<-0.72583,-0.52552,0.44385>,<-0.05985,0.99818,0.008>,<0.78561,-0.43291,-0.44205>,
            
    /*3*/<-0.61812,-0.45413,0.64164>,<-0.26902,0.88736,-0.37447>,<0.87776,-0.39551,-0.2704>,
            
    /*4*/<0.39104,0.64535,0.65621>

    /* stem 0.26.10*/ 
    /*0*/<0.67152,-0.48988,-0.55594>,
    /*1*/<0.18645,0.84485,-0.50147>,<0.51633,-0.21329,0.8294>,<-0.72269,-0.61703,-0.31145>,
            
    /*2*/<0.25075,0.80047,-0.5444>,<0.45369,-0.15967,0.87674>,<-0.71881,-0.61997,-0.31457>,
            
    /*3*/<0.36867,0.69419,-0.61821>,<0.39981,-0.14222,0.9055>,<-0.79687,-0.53377,-0.283>,
            
    /*4*/<-0.51083,0.76322,0.39567>

    /* stem 0.26.11*/ 
    /*0*/<-0.57233,-0.63579,-0.51789>,
    /*1*/<0.48241,-0.76556,0.42568>,<-0.81052,0.38677,0.43985>,<0.34496,0.39751,-0.85029>,
            
    /*2*/<0.48047,-0.76755,0.42428>,<-0.85658,0.33683,0.39093>,<0.3881,0.45491,-0.80152>,
            
    /*3*/<0.51825,-0.67856,0.52055>,<-0.95404,0.16648,0.24918>,<0.4306,0.5214,-0.7367>,
            
    /*4*/<0.12722,0.76744,0.62837>

    /* stem 0.26.12*/ 
    /*0*/<0.18429,0.14261,-0.97247>,
    /*1*/<-0.92964,0.35015,-0.11478>,<0.74283,0.62408,0.24234>,<0.18141,-0.97841,-0.09906>,
            
    /*2*/<-0.92587,0.34128,-0.16214>,<0.79347,0.60482,0.0678>,<0.15884,-0.97661,0.14493>,
            
    /*3*/<-0.91911,0.35165,-0.17768>,<0.79751,0.57008,-0.19744>,<0.12409,-0.90865,0.3987>,
            
    /*4*/<0.02526,0.4319,0.90157>

    /* stem 0.26.13*/ 
    /*0*/<0.2096,-0.97007,-0.12258>,
    /*1*/<0.94271,0.24261,-0.229>,<-0.25626,-0.16571,0.9523>,<-0.69254,-0.04869,-0.71973>,
            
    /*2*/<0.94474,0.23197,-0.23165>,<-0.2435,-0.27581,0.92986>,<-0.72024,0.06957,-0.69023>,
            
    /*3*/<0.9411,0.12626,-0.31369>,<-0.24043,-0.4846,0.84105>,<-0.73485,0.42745,-0.52658>,
            
    /*4*/<0.26855,0.71157,0.64927>

    /* stem 0.26.14*/ 
    /*0*/<-0.67719,0.00128,-0.73581>,
    /*1*/<-0.51306,-0.70885,0.48405>,<-0.18484,0.96522,0.18489>,<0.71748,-0.25641,-0.64767>,
            
    /*2*/<-0.48669,-0.69501,0.52924>,<-0.30963,0.95066,0.01934>,<0.80942,-0.22145,-0.54387>,
            
    /*3*/<-0.404,-0.6091,0.68248>,<-0.47671,0.84768,-0.23278>,<0.87965,-0.22338,-0.4199>,
            
    /*4*/<0.48006,0.60139,0.63866>

    /* stem 0.26.15*/ 
    /*0*/<0.75877,-0.22622,-0.61081>,
    /*1*/<-0.15594,0.85496,-0.4947>,<0.61625,-0.01666,0.78737>,<-0.48208,-0.8318,-0.27514>,
            
    /*2*/<0.0225,0.74686,-0.6646>,<0.59465,0.00699,0.80395>,<-0.65404,-0.73383,-0.18368>,
            
    /*3*/<0.18535,0.57247,-0.7987>,<0.63047,-0.01098,0.77614>,<-0.83603,-0.54722,0.03996>,
            
    /*4*/<-0.38257,0.80965,0.4451>

    /* stem 0.26.16*/ 
    /*0*/<-0.51423,-0.84281,-0.15886>,
    /*1*/<0.76019,-0.52476,0.38306>,<-0.72456,0.34038,0.59929>,<-0.02099,0.20838,-0.97782>,
            
    /*2*/<0.72435,-0.58707,0.36148>,<-0.74834,0.30797,0.58748>,<0.04332,0.30508,-0.95134>,
            
    /*3*/<0.66097,-0.68923,0.29678>,<-0.7867,0.22983,0.57295>,<0.14411,0.48344,-0.86343>,
            
    /*4*/<0.52634,0.64246,0.55697>

    /* stem 0.26.17*/ 
    /*0*/<0.03837,0.09038,-0.99517>,
    /*1*/<-0.99953,-0.00769,-0.02975>,<0.49026,0.86499,0.10695>,<0.50818,-0.85986,-0.04901>,
            
    /*2*/<-0.99755,-0.02537,-0.06521>,<0.57223,0.80213,-0.17073>,<0.52835,-0.78909,0.31333>,
            
    /*3*/<-0.9947,0.10227,-0.01089>,<0.53309,0.57967,-0.61628>,<0.45418,-0.64375,0.61587>,
            
    /*4*/<0.23416,0.76645,0.5981>

    /* stem 0.26.18*/ 
    /*0*/<0.46055,-0.83526,-0.30038>,
    /*1*/<0.77118,0.55107,-0.31875>,<-0.01814,-0.33727,0.94123>,<-0.76599,-0.19031,-0.61403>,
            
    /*2*/<0.78864,0.50828,-0.34596>,<0.01586,-0.44759,0.8941>,<-0.84184,-0.03835,-0.53837>,
            
    /*3*/<0.80319,0.44997,-0.39041>,<0.09031,-0.5614,0.8226>,<-0.89905,0.1334,-0.41703>,
            
    /*4*/<-0.12197,0.79554,0.5935>

    /* stem 0.26.19*/ 
    /*0*/<-0.58014,-0.34313,-0.73871>,
    /*1*/<-0.18358,-0.82226,0.53869>,<-0.58624,0.804,0.09952>,<0.78599,0.02783,-0.61761>,
            
    /*2*/<-0.17277,-0.80264,0.57089>,<-0.68099,0.72937,-0.06539>,<0.85585,0.11148,-0.50506>,
            
    /*3*/<-0.17869,-0.75051,0.63625>,<-0.75863,0.52277,-0.38883>,<0.93084,0.26375,-0.25293>,
            
    /*4*/<-0.15339,0.68516,0.71205>

    /* stem 0.26.20*/ 
    /*0*/<0.58131,-0.15458,-0.79887>,
    /*1*/<-0.49105,0.72278,-0.48627>,<0.80307,0.22516,0.55171>,<-0.32722,-0.9439,-0.04455>,
            
    /*2*/<-0.48247,0.7145,-0.50666>,<0.90138,0.15456,0.40451>,<-0.42047,-0.895,0.14896>,
            
    /*3*/<-0.48419,0.69963,-0.52544>,<0.99435,0.0332,0.10085>,<-0.50096,-0.73522,0.45661>,
            
    /*4*/<0.05895,0.62983,0.77449>

    /* stem 0.26.21*/ 
    /*0*/<-0.26166,-0.95912,-0.1078>,
    /*1*/<0.93564,-0.27219,0.22471>,<-0.67675,0.11115,0.72778>,<-0.25263,0.184,-0.94991>,
            
    /*2*/<0.92227,-0.32395,0.21088>,<-0.69735,0.0558,0.71456>,<-0.22032,0.2957,-0.92953>,
            
    /*3*/<0.93792,-0.21485,0.2723>,<-0.72981,-0.1882,0.65724>,<-0.2002,0.40947,-0.89008>,
            
    /*4*/<-0.09928,0.89591,0.433>

    /* stem 0.26.22*/ 
    /*0*/<-0.21093,0.0387,-0.97673>,
    /*1*/<-0.94485,-0.25867,0.20088>,<0.26254,0.96485,-0.01139>,<0.68668,-0.70698,-0.16923>,
            
    /*2*/<-0.94097,-0.25021,0.22799>,<0.2379,0.94995,-0.20249>,<0.73164,-0.68142,-0.01917>,
            
    /*3*/<-0.93655,-0.24464,0.25105>,<0.19712,0.81751,-0.54113>,<0.77579,-0.55483,0.30053>,
            
    /*4*/<-0.00642,0.70045,0.71367>

    /* stem 0.26.23*/ 
    /*0*/<0.68686,-0.71128,-0.14938>,
    /*1*/<0.5153,0.62822,-0.58292>,<0.17669,-0.02781,0.98387>,<-0.70399,-0.58798,-0.39834>,
            
    /*2*/<0.54865,0.59274,-0.58961>,<0.15983,-0.00783,0.98711>,<-0.71888,-0.57108,-0.39632>,
            
    /*3*/<0.65222,0.42344,-0.62873>,<0.1598,-0.03325,0.98659>,<-0.84492,-0.37254,-0.38384>,
            
    /*4*/<-0.2525,0.9587,0.13088>

    /* stem 0.26.24*/ 
    /*0*/<-0.58895,-0.63233,-0.50329>,
    /*1*/<0.15294,-0.69533,0.70223>,<-0.76072,0.64279,0.09017>,<0.61452,0.05978,-0.78664>,
            
    /*2*/<0.17283,-0.67669,0.7157>,<-0.74027,0.66421,0.1041>,<0.57597,0.01962,-0.81724>,
            
    /*3*/<0.19437,-0.67293,0.71372>,<-0.72491,0.67575,0.13368>,<0.53825,0.00421,-0.84277>,
            
    /*4*/<0.65039,0.62236,0.4355>

    /* stem 0.26.25*/ 
    /*0*/<0.54606,-0.00027,-0.83775>,
    /*1*/<-0.75185,0.44492,-0.48658>,<0.69634,0.55312,0.45734>,<0.05052,-0.99804,0.03689>,
            
    /*2*/<-0.76919,0.45899,-0.4446>,<0.80991,0.52128,0.26891>,<-0.0044,-0.9818,0.18987>,
            
    /*3*/<-0.79516,0.42707,-0.43051>,<0.91635,0.39536,-0.0632>,<-0.10535,-0.84,0.53226>,
            
    /*4*/<-0.06976,0.70309,0.70767>

    /* stem 0.26.26*/ 
    /*0*/<0.02069,-0.99527,-0.09491>,
    /*1*/<0.99865,0.01686,0.04916>,<-0.54033,-0.09023,0.8366>,<-0.45836,0.0757,-0.88554>,
            
    /*2*/<0.98682,-0.16171,0.00621>,<-0.53732,-0.07892,0.83968>,<-0.42954,0.242,-0.87002>,
            
    /*3*/<0.95901,-0.2811,-0.03583>,<-0.57436,-0.27301,0.77174>,<-0.42151,0.54692,-0.72333>,
            
    /*4*/<0.18234,0.72748,0.66145>

    /* stem 0.27*/ 
    /*0*/<0.56582,-0.45762,0.68587>,
    /*1*/<0.7593,-0.01122,-0.65065>,<0.52064,0.8456,0.11791>,<-0.44652,0.5411,0.71262>,
            <-0.80559,-0.5039,0.31161>,<-0.06036,-0.84526,-0.53094>,
    /*2*/<0.71841,0.02138,-0.69529>,<0.52171,0.84472,0.11948>,<-0.40528,0.50863,0.75964>,
            <-0.78163,-0.52368,0.33883>,<-0.08713,-0.82411,-0.55968>,
    /*3*/<0.72908,0.01902,-0.68417>,<0.56805,0.80312,0.17976>,<-0.38678,0.48436,0.78473>,
            <-0.81678,-0.49474,0.29683>,<-0.12705,-0.78163,-0.61067>,
    /*4*/<0.77067,-0.03758,-0.63613>,<0.65332,0.7096,0.26389>,<-0.37517,0.48568,0.78953>,
            <-0.89136,-0.39924,0.21469>,<-0.18357,-0.72243,-0.66663>,
    /*5*/<0.77448,-0.04228,-0.63118>,<0.72714,0.58219,0.36376>,<-0.33332,0.41342,0.84734>,
            <-0.93716,-0.31402,0.15207>,<-0.2528,-0.59597,-0.76218>,
    /*6*/<-0.29213,0.84799,-0.44223>

    /* stem 0.27.0*/ 
    /*0*/<-0.11795,-0.79837,0.5905>,
    /*1*/<-0.38909,0.59229,0.70555>,<-0.59434,-0.41066,-0.69146>,<0.98709,-0.15686,-0.03242>,
            
    /*2*/<-0.36773,0.53476,0.76079>,<-0.55993,-0.56544,-0.60561>,<0.97299,0.066,-0.22123>,
            
    /*3*/<-0.39072,0.52766,0.75427>,<-0.48652,-0.81008,-0.32722>,<0.85234,0.27615,-0.44413>,
            
    /*4*/<-0.57511,0.40933,-0.70831>

    /* stem 0.27.1*/ 
    /*0*/<0.97656,-0.21019,0.04628>,
    /*1*/<-0.17788,-0.87614,-0.44804>,<0.19053,0.8131,-0.55005>,<-0.04281,0.06953,0.99666>,
            
    /*2*/<-0.28075,-0.84,-0.4643>,<0.32204,0.77235,-0.5475>,<-0.06498,0.08081,0.99461>,
            
    /*3*/<-0.45068,-0.72936,-0.51471>,<0.65077,0.59376,-0.47323>,<-0.17837,0.16841,0.96945>,
            
    /*4*/<-0.5718,0.73926,-0.35571>

    /* stem 0.27.2*/ 
    /*0*/<0.10716,-0.05726,0.99259>,
    /*1*/<0.64634,0.7622,-0.03612>,<-0.97821,0.17873,0.10561>,<0.32858,-0.93917,-0.09997>,
            
    /*2*/<0.67013,0.74105,0.04202>,<-0.96645,0.14432,0.21249>,<0.29334,-0.90634,-0.30414>,
            
    /*3*/<0.71304,0.68129,0.16558>,<-0.908,0.08998,0.40919>,<0.18284,-0.76891,-0.61266>,
            
    /*4*/<-0.35903,0.64162,-0.6778>

    /* stem 0.27.3*/ 
    /*0*/<0.40791,-0.89937,0.15728>,
    /*1*/<-0.82826,-0.27937,0.48573>,<0.06762,-0.13096,-0.98908>,<0.74816,0.43786,0.49854>,
            
    /*2*/<-0.89978,-0.14038,0.41315>,<0.14021,-0.35114,-0.92577>,<0.73738,0.48277,0.47245>,
            
    /*3*/<-0.97442,0.08739,0.20706>,<0.28046,-0.63184,-0.72258>,<0.67702,0.55304,0.48558>,
            
    /*4*/<0.03129,0.64432,-0.76411>

    /* stem 0.27.4*/ 
    /*0*/<0.78464,0.33708,0.5203>,
    /*1*/<0.60719,-0.32295,-0.72596>,<-0.38195,0.92325,-0.04164>,<-0.24914,-0.61056,0.75176>,
            
    /*2*/<0.62994,-0.32638,-0.70473>,<-0.20501,0.96348,0.17227>,<-0.52696,-0.63116,0.56916>,
            
    /*3*/<0.68042,-0.30504,-0.66631>,<0.10278,0.85177,0.51374>,<-0.83802,-0.52128,0.16122>,
            
    /*4*/<-0.29959,0.68719,-0.66183>

    /* stem 0.27.5*/ 
    /*0*/<0.03981,-0.6904,0.72234>,
    /*1*/<-0.05818,0.72705,0.68412>,<-0.83536,-0.41304,-0.36272>,<0.89233,-0.29308,-0.34329>,
            
    /*2*/<-0.04358,0.66317,0.7472>,<-0.83211,-0.43332,-0.34617>,<0.88332,-0.2043,-0.4219>,
            
    /*3*/<0.00733,0.56109,0.82772>,<-0.78657,-0.56523,-0.24862>,<0.77863,0.02383,-0.62703>,
            
    /*4*/<-0.58093,0.70861,-0.4005>

    /* stem 0.27.6*/ 
    /*0*/<0.89612,-0.41631,-0.15381>,
    /*1*/<-0.45181,-0.85759,-0.24579>,<0.18678,0.686,-0.70322>,<0.23801,0.18414,0.95365>,
            
    /*2*/<-0.57009,-0.79256,-0.21646>,<0.22258,0.6628,-0.71495>,<0.31245,0.13417,0.94041>,
            
    /*3*/<-0.80229,-0.57254,-0.16893>,<0.3837,0.49866,-0.77725>,<0.38736,0.09293,0.91723>,
            
    /*4*/<-0.44136,0.89157,0.10151>

    /* stem 0.27.7*/ 
    /*0*/<0.22944,0.21301,0.94973>,
    /*1*/<0.73389,0.59811,-0.32198>,<-0.92172,0.36534,0.13019>,<0.18094,-0.96985,0.16326>,
            
    /*2*/<0.74223,0.60299,-0.2924>,<-0.91518,0.36994,0.15997>,<0.16621,-0.98062,0.1037>,
            
    /*3*/<0.70183,0.62881,-0.33471>,<-0.83836,0.37016,0.40015>,<0.09947,-0.99298,-0.06406>,
            
    /*4*/<-0.59005,0.10855,-0.80003>

    /* stem 0.27.8*/ 
    /*0*/<0.31512,-0.92227,0.22386>,
    /*1*/<-0.68824,-0.04867,0.72385>,<-0.22929,-0.29286,-0.92825>,<0.90813,0.36906,0.19772>,
            
    /*2*/<-0.63722,-0.14674,0.75658>,<-0.21411,-0.31941,-0.92311>,<0.84687,0.50301,0.1726>,
            
    /*3*/<-0.59666,-0.19302,0.77894>,<-0.17562,-0.44016,-0.88058>,<0.75384,0.65099,0.0891>,
            
    /*4*/<-0.61424,0.70846,-0.34756>

    /* stem 0.27.9*/ 
    /*0*/<0.9417,0.27593,0.19253>,
    /*1*/<0.30414,-0.51434,-0.80184>,<-0.27189,0.95772,-0.09408>,<-0.06019,-0.45157,0.89021>,
            
    /*2*/<0.2231,-0.50424,-0.83425>,<0.00298,0.99988,-0.01545>,<-0.22924,-0.44019,0.86815>,
            
    /*3*/<-0.00298,-0.42859,-0.90349>,<0.39249,0.91527,0.09076>,<-0.40355,-0.46406,0.78854>,
            
    /*4*/<-0.83329,0.54374,-0.0999>

    /* stem 0.27.10*/ 
    /*0*/<0.05877,-0.52001,0.85214>,
    /*1*/<0.20429,0.84681,0.4911>,<-0.9491,-0.28995,-0.12305>,<0.74307,-0.54148,-0.39324>,
            
    /*2*/<0.22972,0.73846,0.63397>,<-0.95295,-0.26834,-0.14099>,<0.74369,-0.44155,-0.50196>,
            
    /*3*/<0.27493,0.59232,0.75734>,<-0.95151,-0.29254,-0.09513>,<0.67202,-0.28029,-0.68544>,
            
    /*4*/<-0.29373,0.8194,-0.49225>

    /* stem 0.27.11*/ 
    /*0*/<0.6652,-0.71133,-0.227>,
    /*1*/<-0.74618,-0.66224,-0.06816>,<0.2751,0.52755,-0.80375>,<0.4515,0.15564,0.87859>,
            
    /*2*/<-0.75256,-0.65487,-0.0693>,<0.3743,0.4314,-0.82085>,<0.37297,0.25606,0.89181>,
            
    /*3*/<-0.76412,-0.6403,-0.07827>,<0.52104,0.26222,-0.81226>,<0.23068,0.40391,0.88524>,
            
    /*4*/<-0.6038,0.75219,-0.26391>

    /* stem 0.27.12*/ 
    /*0*/<0.45656,-0.01901,0.88949>,
    /*1*/<0.86283,0.2325,-0.44885>,<-0.60979,0.72615,0.31757>,<-0.26637,-0.9581,0.1053>,
            
    /*2*/<0.86034,0.23499,-0.45233>,<-0.5452,0.70219,0.45791>,<-0.34913,-0.93689,-0.01868>,
            
    /*3*/<0.82044,0.28805,-0.49388>,<-0.3091,0.51743,0.79795>,<-0.55144,-0.796,-0.24962>,
            
    /*4*/<-0.56627,0.74368,-0.35537>

    /* stem 0.27.13*/ 
    /*0*/<-0.08898,-0.94132,0.32558>,
    /*1*/<-0.58823,0.32241,0.74165>,<-0.4001,-0.25624,-0.87992>,<0.99091,-0.03882,0.12882>,
            
    /*2*/<-0.58807,0.29524,0.753>,<-0.39949,-0.31578,-0.86064>,<0.9943,0.04785,0.09529>,
            
    /*3*/<-0.58212,0.25681,0.77148>,<-0.39545,-0.43958,-0.80647>,<0.97791,0.20818,0.01907>,
            
    /*4*/<-0.25194,0.85879,-0.44609>

    /* stem 0.27.14*/ 
    /*0*/<0.90029,-0.28184,0.33172>,
    /*1*/<0.02662,-0.70961,-0.70409>,<0.34944,0.91547,-0.1995>,<-0.40198,-0.19775,0.89404>,
            
    /*2*/<0.05974,-0.7232,-0.68805>,<0.39681,0.90091,-0.17577>,<-0.48525,-0.16856,0.85797>,
            
    /*3*/<0.05369,-0.70668,-0.70549>,<0.59581,0.80134,-0.05341>,<-0.65045,-0.06021,0.75716>,
            
    /*4*/<-0.54292,0.61116,-0.57594>

    /* stem 0.27.15*/ 
    /*0*/<-0.24978,-0.2264,0.94146>,
    /*1*/<0.53745,0.78019,0.32008>,<-0.96402,0.12058,-0.2369>,<0.43372,-0.8943,-0.11011>,
            
    /*2*/<0.52904,0.73008,0.43255>,<-0.98221,0.08108,-0.16935>,<0.48359,-0.81934,-0.30793>,
            
    /*3*/<0.50573,0.71536,0.48217>,<-0.99868,-0.01379,0.04947>,<0.47583,-0.68785,-0.54813>,
            
    /*4*/<-0.20072,0.57925,-0.79005>

    /* stem 0.27.16*/ 
    /*0*/<0.40633,-0.90807,-0.10149>,
    /*1*/<-0.9017,-0.40878,0.14083>,<0.2984,0.247,-0.92193>,<0.59175,0.1876,0.78399>,
            
    /*2*/<-0.90494,-0.40194,0.13975>,<0.33897,0.16607,-0.92602>,<0.56101,0.26425,0.7845>,
            
    /*3*/<-0.89617,-0.41964,0.14417>,<0.41344,0.01579,-0.9104>,<0.47706,0.43438,0.76402>,
            
    /*4*/<-0.47734,0.82605,-0.29965>

    /* stem 0.27.17*/ 
    /*0*/<0.62374,-0.07843,0.77768>,
    /*1*/<0.77105,-0.04572,-0.63513>,<-0.3204,0.88635,0.33427>,<-0.46826,-0.83842,0.27891>,
            
    /*2*/<0.8017,-0.06524,-0.59415>,<-0.25289,0.85242,0.45764>,<-0.59722,-0.79309,0.11971>,
            
    /*3*/<0.80876,-0.02241,-0.58771>,<-0.07231,0.69776,0.71267>,<-0.7527,-0.6488,-0.11185>,
            
    /*4*/<-0.42498,0.75432,-0.50039>

    /* stem 0.27.18*/ 
    /*0*/<-0.30073,-0.86301,0.40594>,
    /*1*/<-0.28964,0.49663,0.81821>,<-0.63707,-0.12494,-0.76061>,<0.93515,-0.34748,-0.06898>,
            
    /*2*/<-0.2672,0.54653,0.79367>,<-0.6339,-0.11934,-0.76415>,<0.9139,-0.40406,-0.03889>,
            
    /*3*/<-0.26887,0.61492,0.74134>,<-0.66704,-0.32489,-0.67045>,<0.94575,-0.30171,-0.12053>,
            
    /*4*/<-0.04238,0.75297,-0.65668>

    /* stem 0.27.19*/ 
    /*0*/<0.9143,-0.40415,-0.02681>,
    /*1*/<-0.33735,-0.69831,-0.63132>,<0.36068,0.8625,-0.35496>,<-0.04883,-0.15293,0.98703>,
            
    /*2*/<-0.3979,-0.65177,-0.64566>,<0.55033,0.76025,-0.34519>,<-0.14468,-0.07393,0.98671>,
            
    /*3*/<-0.38718,-0.68614,-0.61588>,<0.75658,0.59323,-0.27506>,<-0.41213,0.11617,0.90369>,
            
    /*4*/<-0.5684,0.61691,-0.54438>

    /* stem 0.27.20*/ 
    /*0*/<-0.103,-0.10562,0.98906>,
    /*1*/<0.79718,0.58798,0.13707>,<-0.91342,0.40243,-0.06089>,<0.11892,-0.98767,-0.10182>,
            
    /*2*/<0.79654,0.57548,0.18532>,<-0.9241,0.3818,0.01665>,<0.12781,-0.96394,-0.2334>,
            
    /*3*/<0.79781,0.52196,0.30177>,<-0.93135,0.31897,0.17562>,<0.13497,-0.84433,-0.51855>,
            
    /*4*/<-0.02863,0.65293,-0.75687>

    /* stem 0.27.21*/ 
    /*0*/<0.12884,-0.97344,-0.18927>,
    /*1*/<-0.89216,-0.18966,0.40998>,<0.06784,0.20689,-0.97601>,<0.82126,0.00591,0.57053>,
            
    /*2*/<-0.91342,-0.03631,0.40539>,<0.07139,0.01364,-0.99736>,<0.82273,0.03866,0.56711>,
            
    /*3*/<-0.92041,0.09587,0.37901>,<0.12296,-0.15906,-0.97958>,<0.79783,0.08565,0.59676>,
            
    /*4*/<0.01181,0.98819,-0.15279>

    /* stem 0.27.22*/ 
    /*0*/<0.80541,-0.12318,0.57977>,
    /*1*/<0.53895,-0.23182,-0.80981>,<-0.075,0.95264,0.29472>,<-0.48057,-0.71827,0.50313>,
            
    /*2*/<0.54401,-0.23369,-0.80588>,<0.05038,0.90852,0.41478>,<-0.62971,-0.66284,0.40511>,
            
    /*3*/<0.56905,-0.25012,-0.78334>,<0.23725,0.78008,0.57895>,<-0.83144,-0.51796,0.20107>,
            
    /*4*/<-0.41822,0.70136,-0.57722>

    /* stem 0.27.23*/ 
    /*0*/<-0.39195,-0.78645,0.47737>,
    /*1*/<0.09043,0.48866,0.86778>,<-0.83503,0.0941,-0.5421>,<0.75106,-0.56978,-0.33355>,
            
    /*2*/<0.08592,0.47507,0.87574>,<-0.86033,0.02889,-0.50892>,<0.78151,-0.49401,-0.38104>,
            
    /*3*/<0.08106,0.43988,0.89439>,<-0.8949,-0.12141,-0.42943>,<0.81933,-0.308,-0.48357>,
            
    /*4*/<-0.04044,0.91073,-0.41102>

    /* stem 0.27.24*/ 
    /*0*/<0.66241,-0.73526,-0.14354>,
    /*1*/<-0.68261,-0.50619,-0.52708>,<0.60971,0.64509,-0.46057>,<0.06431,-0.12936,0.98951>,
            
    /*2*/<-0.68688,-0.49699,-0.53028>,<0.78066,0.44854,-0.43519>,<-0.05135,0.08786,0.99481>,
            
    /*3*/<-0.69211,-0.4572,-0.55852>,<0.94108,0.07834,-0.32899>,<-0.22757,0.39346,0.89073>,
            
    /*4*/<-0.07458,0.84008,-0.53732>

    /* stem 0.27.25*/ 
    /*0*/<0.16397,-0.33376,0.92829>,
    /*1*/<0.95271,0.29698,-0.06446>,<-0.69714,0.62793,0.34597>,<-0.25691,-0.92217,-0.28913>,
            
    /*2*/<0.95798,0.28327,-0.04498>,<-0.68382,0.55512,0.47353>,<-0.29932,-0.84577,-0.44169>,
            
    /*3*/<0.94985,0.3095,-0.04469>,<-0.59314,0.29319,0.74981>,<-0.40029,-0.61187,-0.68219>,
            
    /*4*/<-0.3539,0.88036,-0.31577>

    /* stem 0.27.26*/ 
    /*0*/<-0.20218,-0.965,-0.16705>,
    /*1*/<-0.78034,0.05689,0.62276>,<-0.1217,0.19516,-0.97319>,<0.90274,-0.2487,0.35101>,
            
    /*2*/<-0.78625,0.01259,0.61778>,<-0.12468,0.16595,-0.97822>,<0.91495,-0.17538,0.36348>,
            
    /*3*/<-0.7606,-0.17739,0.62451>,<-0.1178,0.06249,-0.99107>,<0.90698,0.14012,0.39718>,
            
    /*4*/<-0.39522,0.91838,0.01953>

    /* stem 0.28*/ 
    /*0*/<-0.88188,-0.44543,-0.15453>,
    /*1*/<-0.16349,0.00721,0.98652>,<-0.46039,0.8572,0.23076>,<-0.10706,0.52963,-0.84145>,
            <0.4082,-0.52281,-0.74836>,<0.37332,-0.84568,0.38139>,
    /*2*/<-0.09776,0.04458,0.99421>,<-0.49949,0.83625,0.22625>,<-0.19823,0.48025,-0.85444>,
            <0.39137,-0.53217,-0.75075>,<0.45295,-0.80147,0.39049>,
    /*3*/<-0.06133,0.07759,0.9951>,<-0.6272,0.74933,0.21243>,<-0.31269,0.39366,-0.86444>,
            <0.44475,-0.49522,-0.74629>,<0.59984,-0.69105,0.4033>,
    /*4*/<-0.07976,0.05855,0.99509>,<-0.72528,0.65438,0.21389>,<-0.35751,0.35758,-0.86274>,
            <0.51441,-0.422,-0.74653>,<0.68597,-0.60682,0.40151>,
    /*5*/<-0.10442,0.02538,0.99421>,<-0.81977,0.53308,0.2093>,<-0.3904,0.31598,-0.86472>,
            <0.58549,-0.3241,-0.74307>,<0.76224,-0.50379,0.40642>,
    /*6*/<0.43639,0.89653,0.0762>

    /* stem 0.28.0*/ 
    /*0*/<-0.34093,-0.79421,-0.503>,
    /*1*/<-0.14523,0.58204,-0.80008>,<0.88173,-0.45171,0.13608>,<-0.72595,-0.10578,0.67956>,
            
    /*2*/<-0.09935,0.66478,-0.7404>,<0.85116,-0.51855,0.08144>,<-0.73394,-0.11942,0.66864>,
            
    /*3*/<-0.02983,0.71371,-0.6998>,<0.78278,-0.62022,0.0508>,<-0.73969,-0.07426,0.66883>,
            
    /*4*/<0.50838,0.63615,0.5804>

    /* stem 0.28.1*/ 
    /*0*/<-0.83851,-0.24443,0.48698>,
    /*1*/<0.4101,-0.8788,0.24399>,<0.12682,0.7933,0.59548>,<-0.51113,0.09302,-0.85446>,
            
    /*2*/<0.52306,-0.82753,0.20397>,<-0.02954,0.72607,0.68699>,<-0.46973,0.12122,-0.87445>,
            
    /*3*/<0.60184,-0.77882,0.17674>,<-0.20107,0.65332,0.72989>,<-0.37706,0.14101,-0.91539>,
            
    /*4*/<0.82007,0.52559,-0.22637>

    /* stem 0.28.2*/ 
    /*0*/<-0.73004,-0.06733,-0.68008>,
    /*1*/<-0.45894,0.77706,0.43074>,<0.6732,0.15513,-0.723>,<-0.19189,-0.93013,0.31309>,
            
    /*2*/<-0.54477,0.73811,0.39802>,<0.53424,0.05717,-0.84339>,<0.10414,-0.85328,0.51095>,
            
    /*3*/<-0.68767,0.63683,0.34866>,<0.24924,-0.01146,-0.96837>,<0.46914,-0.61421,0.63456>,
            
    /*4*/<0.63328,0.77124,0.0644>

    /* stem 0.28.3*/ 
    /*0*/<-0.48915,-0.8631,0.12564>,
    /*1*/<0.31803,-0.2994,-0.89956>,<0.55342,-0.18361,0.81242>,<-0.85653,0.50933,0.08332>,
            
    /*2*/<0.33141,-0.28099,-0.90067>,<0.5143,-0.24728,0.82119>,<-0.82902,0.55326,0.08144>,
            
    /*3*/<0.33149,-0.28615,-0.89902>,<0.47389,-0.30228,0.82708>,<-0.78725,0.61263,0.07014>,
            
    /*4*/<0.61798,0.78367,-0.06299>

    /* stem 0.28.4*/ 
    /*0*/<-0.95561,0.28425,0.07751>,
    /*1*/<-0.00357,-0.3071,0.95167>,<0.27116,0.93659,-0.22198>,<-0.2386,-0.63811,-0.73204>,
            
    /*2*/<0.03204,-0.30228,0.95268>,<0.03283,0.9728,-0.22929>,<-0.04765,-0.64413,-0.76343>,
            
    /*3*/<-0.04856,-0.36181,0.93099>,<-0.28828,0.92474,-0.24851>,<0.41007,-0.5792,-0.70454>,
            
    /*4*/<0.78155,0.48394,0.39368>

    /* stem 0.28.5*/ 
    /*0*/<-0.21337,-0.7226,-0.65751>,
    /*1*/<-0.45896,0.67505,-0.57763>,<0.97857,-0.17201,-0.11321>,<-0.51316,-0.48123,0.71069>,
            
    /*2*/<-0.51464,0.54651,-0.66066>,<0.97205,-0.19798,-0.12621>,<-0.47945,-0.31778,0.81801>,
            
    /*3*/<-0.58111,0.34801,-0.73566>,<0.97753,-0.13385,-0.16282>,<-0.38676,-0.18627,0.90317>,
            
    /*4*/<0.10426,0.95659,0.27213>

    /* stem 0.28.6*/ 
    /*0*/<-0.64331,-0.49021,0.58809>,
    /*1*/<0.56714,-0.81973,-0.07992>,<0.17751,0.66154,0.7286>,<-0.72533,0.17291,-0.66633>,
            
    /*2*/<0.59956,-0.79494,-0.09274>,<0.04113,0.56707,0.82265>,<-0.63567,0.26304,-0.72576>,
            
    /*3*/<0.67237,-0.73535,-0.08469>,<-0.29922,0.31187,0.90178>,<-0.39416,0.46487,-0.7928>,
            
    /*4*/<0.69646,0.66556,0.26828>

    /* stem 0.28.7*/ 
    /*0*/<-0.8779,-0.0265,-0.47811>,
    /*1*/<-0.3892,0.5959,0.70244>,<0.43833,0.39765,-0.80607>,<-0.0229,-0.99276,0.11791>,
            
    /*2*/<-0.47264,0.57207,0.67033>,<0.35228,0.3686,-0.86025>,<0.16324,-0.96325,0.2133>,
            
    /*3*/<-0.5892,0.52126,0.61735>,<0.15764,0.29854,-0.94129>,<0.47041,-0.8179,0.3313>,
            
    /*4*/<0.71302,0.67167,0.20116>

    /* stem 0.28.8*/ 
    /*0*/<-0.06734,-0.99414,0.08455>,
    /*1*/<0.04964,-0.0781,-0.99571>,<0.83916,-0.00063,0.54389>,<-0.8868,0.10824,0.44931>,
            
    /*2*/<0.04468,-0.10729,-0.99322>,<0.83218,-0.05327,0.55194>,<-0.87641,0.19143,0.44188>,
            
    /*3*/<0.03325,-0.14238,-0.98925>,<0.81654,-0.1528,0.55671>,<-0.84229,0.32384,0.4309>,
            
    /*4*/<0.33829,0.93061,-0.13972>

    /* stem 0.28.9*/ 
    /*0*/<-0.88538,0.16147,0.43593>,
    /*1*/<0.33161,-0.4625,0.82227>,<0.13684,0.98455,-0.1093>,<-0.44235,-0.5268,-0.72582>,
            
    /*2*/<0.42511,-0.41951,0.80206>,<-0.26185,0.96436,0.03797>,<-0.25885,-0.453,-0.85311>,
            
    /*3*/<0.48811,-0.42556,0.762>,<-0.58206,0.7992,0.14993>,<0.11854,-0.36334,-0.92408>,
            
    /*4*/<0.77503,0.63106,-0.03309>

    /* stem 0.28.10*/ 
    /*0*/<-0.28524,-0.60056,-0.74697>,
    /*1*/<-0.69322,0.67141,-0.26201>,<0.9214,0.05681,-0.38445>,<-0.21981,-0.71062,0.66836>,
            
    /*2*/<-0.70486,0.6515,-0.28056>,<0.89162,-0.01737,-0.45246>,<-0.16997,-0.62438,0.7624>,
            
    /*3*/<-0.72929,0.60918,-0.31151>,<0.84908,-0.07168,-0.52337>,<-0.10891,-0.51559,0.84988>,
            
    /*4*/<0.37884,0.7741,0.50719>

    /* stem 0.28.11*/ 
    /*0*/<-0.25418,-0.71223,0.6543>,
    /*1*/<0.67182,-0.6109,-0.41888>,<0.27233,0.60432,0.74875>,<-0.93673,0.02737,-0.34897>,
            
    /*2*/<0.71338,-0.51491,-0.47535>,<0.23166,0.46326,0.85541>,<-0.92502,0.07561,-0.37231>,
            
    /*3*/<0.75437,-0.40445,-0.51706>,<0.12346,0.24502,0.96162>,<-0.87423,0.18793,-0.44766>,
            
    /*4*/<0.37154,0.91118,-0.17808>

    /* stem 0.28.12*/ 
    /*0*/<-0.94036,-0.01217,-0.33996>,
    /*1*/<-0.32039,0.28115,0.9046>,<0.24708,0.69061,-0.67971>,<0.1006,-0.97141,-0.21503>,
            
    /*2*/<-0.35927,0.25721,0.89709>,<0.01474,0.5858,-0.81032>,<0.45339,-0.87886,-0.14846>,
            
    /*3*/<-0.42354,0.22358,0.87785>,<-0.27229,0.49284,-0.82642>,<0.71348,-0.6991,-0.04695>,
            
    /*4*/<0.69074,0.69983,0.18197>

    /* stem 0.28.13*/ 
    /*0*/<-0.11961,-0.97835,-0.16887>,
    /*1*/<-0.1634,0.19667,-0.96676>,<0.9313,-0.16047,0.327>,<-0.76445,-0.00799,0.64463>,
            
    /*2*/<-0.19553,0.13744,-0.97102>,<0.87655,-0.33768,0.34297>,<-0.6824,0.25336,0.68567>,
            
    /*3*/<-0.26102,0.03829,-0.96457>,<0.76401,-0.57178,0.29894>,<-0.48833,0.55993,0.66933>,
            
    /*4*/<0.69633,0.68367,-0.21843>

    /* stem 0.28.14*/ 
    /*0*/<-0.80752,-0.31669,0.49761>,
    /*1*/<0.5893,-0.56491,0.57758>,<-0.19804,0.94487,0.26076>,<-0.36811,-0.37088,-0.85261>,
            
    /*2*/<0.5254,-0.61064,0.59251>,<-0.36715,0.88223,0.29473>,<-0.13039,-0.23975,-0.96204>,
            
    /*3*/<0.46097,-0.60063,0.65326>,<-0.75496,0.58979,0.28666>,<0.24633,0.06285,-0.96715>,
            
    /*4*/<0.41891,0.8208,0.38833>

    /* stem 0.28.15*/ 
    /*0*/<-0.56474,-0.53026,-0.63237>,
    /*1*/<-0.72112,0.68792,0.08221>,<0.7076,0.09874,-0.69968>,<0.02963,-0.77152,0.63551>,
            
    /*2*/<-0.75077,0.65761,0.06235>,<0.64149,0.00926,-0.76707>,<0.14325,-0.66503,0.73295>,
            
    /*3*/<-0.81877,0.57176,0.05209>,<0.45613,-0.24245,-0.85625>,<0.44277,-0.31902,0.83796>,
            
    /*4*/<0.47751,0.8469,-0.23396>

    /* stem 0.28.16*/ 
    /*0*/<-0.03005,-0.85057,0.525>,
    /*1*/<0.55639,-0.44261,-0.70322>,<0.44147,0.46802,0.76555>,<-0.99702,-0.00132,-0.07719>,
            
    /*2*/<0.54898,-0.32782,-0.76886>,<0.44573,0.43679,0.78137>,<-0.99538,-0.0878,-0.03889>,
            
    /*3*/<0.53339,-0.01864,-0.84566>,<0.47051,0.25224,0.84557>,<-0.98012,-0.19805,-0.01193>,
            
    /*4*/<-0.22765,0.97307,0.03618>

    /* stem 0.28.17*/ 
    /*0*/<-0.9786,-0.1911,-0.07626>,
    /*1*/<-0.07819,0.0522,0.99557>,<-0.10845,0.8255,-0.55389>,<0.21417,-0.87232,-0.43954>,
            
    /*2*/<-0.03912,0.07323,0.99655>,<-0.28258,0.77102,-0.57069>,<0.33759,-0.82715,-0.44929>,
            
    /*3*/<0.01523,0.10254,0.99461>,<-0.59006,0.57622,-0.56551>,<0.58818,-0.66247,-0.46387>,
            
    /*4*/<0.56902,0.81606,-0.10131>

    /* stem 0.28.18*/ 
    /*0*/<0.04528,-0.90137,-0.43067>,
    /*1*/<-0.42267,0.38179,-0.82194>,<0.99472,0.01154,0.102>,<-0.57331,-0.36822,0.73194>,
            
    /*2*/<-0.39841,0.437,-0.80641>,<0.96448,-0.26409,0.006>,<-0.5167,-0.19931,0.83264>,
            
    /*3*/<-0.39065,0.48548,-0.78211>,<0.82917,-0.54854,-0.10764>,<-0.42331,0.08209,0.90226>,
            
    /*4*/<0.62418,0.77058,0.12889>

    /* stem 0.28.19*/ 
    /*0*/<-0.58048,-0.36931,0.72571>,
    /*1*/<0.7394,-0.61927,0.26418>,<-0.05734,0.91201,0.40614>,<-0.66675,-0.283,-0.68946>,
            
    /*2*/<0.81793,-0.54112,0.19542>,<-0.18638,0.79895,0.57178>,<-0.62833,-0.22422,-0.74493>,
            
    /*3*/<0.88512,-0.44892,0.12263>,<-0.41263,0.53261,0.73896>,<-0.48511,-0.0511,-0.87296>,
            
    /*4*/<0.46897,0.87235,-0.1381>

    /* stem 0.28.20*/ 
    /*0*/<-0.66515,-0.33091,-0.66939>,
    /*1*/<-0.69752,0.58294,0.41671>,<0.57515,0.35684,-0.73612>,<0.13811,-0.93195,0.33525>,
            
    /*2*/<-0.61026,0.6387,0.46867>,<0.41648,0.28236,-0.86419>,<0.21168,-0.90383,0.37186>,
            
    /*3*/<-0.59657,0.61579,0.51469>,<0.2048,0.15747,-0.96605>,<0.42205,-0.77242,0.4746>,
            
    /*4*/<0.69101,0.69901,0.18411>

    /* stem 0.28.21*/ 
    /*0*/<0.20615,-0.94964,0.23599>,
    /*1*/<0.42313,-0.12404,-0.89754>,<0.54983,0.31841,0.77221>,<-0.97716,-0.17503,0.12053>,
            
    /*2*/<0.38614,0.01522,-0.92231>,<0.5709,0.26036,0.77864>,<-0.9594,-0.25263,0.12541>,
            
    /*3*/<0.37439,0.07265,-0.92442>,<0.56949,0.05372,0.82024>,<-0.98855,-0.09214,0.11948>,
            
    /*4*/<0.12914,0.99137,0.02252>

    /* stem 0.28.22*/ 
    /*0*/<-0.90496,-0.41378,0.09914>,
    /*1*/<0.18985,-0.1698,0.96702>,<-0.41916,0.8626,-0.28325>,<0.24473,-0.68575,-0.68546>,
            
    /*2*/<0.19945,-0.16057,0.96666>,<-0.56523,0.77511,-0.28234>,<0.37047,-0.59917,-0.70975>,
            
    /*3*/<0.21238,-0.143,0.96667>,<-0.775,0.5718,-0.26911>,<0.56746,-0.41307,-0.71229>,
            
    /*4*/<0.47181,0.88137,0.02419>

    /* stem 0.28.23*/ 
    /*0*/<0.1788,-0.70304,-0.6883>,
    /*1*/<-0.70823,0.39699,-0.58379>,<0.94515,0.3182,-0.0738>,<-0.23902,-0.70693,0.66567>,
            
    /*2*/<-0.70481,0.37309,-0.60337>,<0.95472,0.27801,-0.10592>,<-0.25163,-0.64511,0.72146>,
            
    /*3*/<-0.7047,0.3316,-0.62725>,<0.97405,0.00368,-0.22631>,<-0.22571,-0.3415,0.91238>,
            
    /*4*/<0.27822,0.94866,0.15043>

    /* stem 0.28.24*/ 
    /*0*/<-0.30899,-0.73912,0.59853>,
    /*1*/<0.90008,-0.42996,-0.07059>,<-0.1808,0.6655,0.72417>,<-0.7169,-0.22982,-0.65821>,
            
    /*2*/<0.9547,-0.24288,-0.17191>,<-0.1981,0.51019,0.83694>,<-0.71847,-0.24902,-0.64945>,
            
    /*3*/<0.96546,0.08707,-0.24556>,<-0.25198,0.09708,0.96285>,<-0.71418,-0.19077,-0.67346>,
            
    /*4*/<-0.20648,0.97504,0.0816>

    /* stem 0.28.25*/ 
    /*0*/<-0.73273,-0.3864,-0.56018>,
    /*1*/<-0.66948,0.26782,0.69287>,<0.23398,0.63116,-0.73952>,<0.43784,-0.89775,0.04844>,
            
    /*2*/<-0.63151,0.29422,0.71737>,<0.15152,0.58417,-0.79737>,<0.4825,-0.87284,0.07312>,
            
    /*3*/<-0.60668,0.30324,0.73484>,<-0.01531,0.44225,-0.89676>,<0.64125,-0.75204,0.15243>,
            
    /*4*/<0.60668,0.76396,0.21977>

    /* stem 0.29*/ 
    /*0*/<0.73913,-0.51469,-0.43449>,
    /*1*/<-0.50826,0.01914,-0.86099>,<0.26646,0.82525,-0.49796>,<0.66127,0.49902,0.5601>,
            <0.13055,-0.5087,0.85099>,<-0.59226,-0.80528,-0.02729>,
    /*2*/<-0.44716,-0.02591,-0.89408>,<0.32452,0.7848,-0.528>,<0.63494,0.51834,0.57287>,
            <0.0571,-0.45546,0.88842>,<-0.61147,-0.79107,-0.01804>,
    /*3*/<-0.39425,-0.07745,-0.91573>,<0.44026,0.68118,-0.58494>,<0.65485,0.50798,0.55958>,
            <-0.04597,-0.35699,0.93298>,<-0.6949,-0.71878,0.0216>,
    /*4*/<-0.38771,-0.08195,-0.91813>,<0.50506,0.61577,-0.60477>,<0.68955,0.47415,0.54745>,
            <-0.08882,-0.3112,0.94618>,<-0.75444,-0.65513,0.04047>,
    /*5*/<-0.41257,-0.05207,-0.90944>,<0.5311,0.58244,-0.61538>,<0.73197,0.42433,0.53307>,
            <-0.08924,-0.30834,0.94708>,<-0.79607,-0.6026,0.0561>,
    /*6*/<-0.52689,0.81571,0.23876>

    /* stem 0.29.0*/ 
    /*0*/<0.41885,-0.84087,0.34279>,
    /*1*/<0.66878,0.5495,0.50079>,<-0.86865,-0.24491,0.43066>,<0.18697,-0.27868,-0.94201>,
            
    /*2*/<0.65995,0.56432,0.49599>,<-0.84468,-0.29198,0.44863>,<0.16863,-0.24806,-0.95396>,
            
    /*3*/<0.65313,0.56877,0.49993>,<-0.77004,-0.42601,0.47491>,<0.09322,-0.12309,-0.98801>,
            
    /*4*/<-0.61155,0.78935,-0.05415>

    /* stem 0.29.1*/ 
    /*0*/<0.28118,-0.27924,-0.91813>,
    /*1*/<-0.53427,-0.83905,0.10271>,<-0.42916,0.82361,-0.37079>,<0.95481,0.02401,0.29625>,
            
    /*2*/<-0.56092,-0.81021,0.17009>,<-0.40348,0.79016,-0.46136>,<0.94889,0.03353,0.31383>,
            
    /*3*/<-0.60726,-0.74918,0.26453>,<-0.27263,0.64122,-0.71729>,<0.88292,0.15113,0.44454>,
            
    /*4*/<-0.5446,0.67212,0.50166>

    /* stem 0.29.2*/ 
    /*0*/<0.98892,-0.13718,0.05679>,
    /*1*/<0.131,0.75041,-0.64786>,<-0.04055,0.18818,0.9813>,<-0.12067,-0.9344,-0.33517>,
            
    /*2*/<0.20986,0.72741,-0.65333>,<0.02602,0.16495,0.98596>,<-0.27506,-0.89895,-0.34093>,
            
    /*3*/<0.40302,0.6434,-0.65085>,<0.03833,0.20228,0.97858>,<-0.45901,-0.8232,-0.33415>,
            
    /*4*/<-0.81274,0.56204,-0.1535>

    /* stem 0.29.3*/ 
    /*0*/<-0.01431,-0.94813,-0.31756>,
    /*1*/<0.31541,-0.29605,0.90159>,<-0.97921,0.08686,-0.18332>,<0.66423,0.23799,-0.70863>,
            
    /*2*/<0.32589,-0.33984,0.88221>,<-0.96915,-0.02499,-0.24521>,<0.64469,0.40994,-0.64523>,
            
    /*3*/<0.34161,-0.39625,0.85222>,<-0.93722,-0.18169,-0.29766>,<0.58649,0.60265,-0.54115>,
            
    /*4*/<-0.36564,0.76439,0.53104>

    /* stem 0.29.4*/ 
    /*0*/<0.63333,0.36474,-0.68254>,
    /*1*/<-0.63048,-0.28441,-0.72222>,<-0.09059,0.90548,0.4146>,<0.7019,-0.63211,0.32828>,
            
    /*2*/<-0.61418,-0.2815,-0.73726>,<0.04017,0.94827,0.3149>,<0.57201,-0.67188,0.47052>,
            
    /*3*/<-0.60627,-0.26096,-0.75122>,<0.24772,0.95899,0.13776>,<0.3421,-0.69036,0.63748>,
            
    /*4*/<-0.7945,0.24536,0.55549>

    /* stem 0.29.5*/ 
    /*0*/<0.5181,-0.62133,0.58782>,
    /*1*/<0.64295,0.73981,0.19823>,<-0.81255,-0.12219,0.56995>,<0.154,-0.59892,-0.78586>,
            
    /*2*/<0.66949,0.71023,0.21762>,<-0.76764,-0.18755,0.61282>,<0.07653,-0.51003,-0.85674>,
            
    /*3*/<0.71194,0.66103,0.23702>,<-0.64432,-0.32899,0.69037>,<-0.09663,-0.31827,-0.94306>,
            
    /*4*/<-0.64272,0.76386,-0.05858>

    /* stem 0.29.6*/ 
    /*0*/<0.24834,-0.59465,-0.76467>,
    /*1*/<-0.45597,-0.76294,0.45828>,<-0.51698,0.59376,-0.61659>,<0.9655,0.18699,0.18121>,
            
    /*2*/<-0.51223,-0.6299,0.58382>,<-0.49731,0.47997,-0.72271>,<0.97266,0.16431,0.16415>,
            
    /*3*/<-0.59842,-0.38285,0.70379>,<-0.39025,0.24858,-0.88652>,<0.97052,0.15806,0.18196>,
            
    /*4*/<-0.21979,0.95534,0.19752>

    /* stem 0.29.7*/ 
    /*0*/<0.99705,0.03391,0.06882>,
    /*1*/<0.03674,0.44407,-0.89524>,<-0.08597,0.55266,0.82896>,<0.01955,-0.99774,0.06423>,
            
    /*2*/<0.13661,0.40503,-0.90404>,<0.07525,0.4971,0.86442>,<-0.30159,-0.95172,0.05728>,
            
    /*3*/<0.34453,0.24571,-0.90605>,<0.34554,0.38089,0.85763>,<-0.78422,-0.61928,0.03874>,
            
    /*4*/<-0.39272,0.91539,-0.08848>

    /* stem 0.29.8*/ 
    /*0*/<0.30734,-0.95089,-0.03667>,
    /*1*/<0.37901,0.09738,0.92025>,<-0.94879,-0.2916,-0.12155>,<0.56068,0.22235,-0.79762>,
            
    /*2*/<0.32552,0.21479,0.92081>,<-0.90963,-0.40017,-0.11152>,<0.56565,0.21116,-0.79715>,
            
    /*3*/<0.16406,0.39819,0.90251>,<-0.75083,-0.6515,-0.10866>,<0.55485,0.25535,-0.7918>,
            
    /*4*/<-0.74158,0.61954,-0.25733>

    /* stem 0.29.9*/ 
    /*0*/<0.63496,-0.00617,-0.77252>,
    /*1*/<-0.63818,-0.57918,-0.50723>,<-0.07502,0.99556,-0.05692>,<0.69453,-0.4162,0.58687>,
            
    /*2*/<-0.62543,-0.58257,-0.51908>,<0.05159,0.98511,-0.16399>,<0.57186,-0.38479,0.72451>,
            
    /*3*/<-0.62348,-0.56543,-0.53997>,<0.3218,0.88154,-0.34544>,<0.30032,-0.28492,0.91029>,
            
    /*4*/<-0.76163,0.5907,0.26646>

    /* stem 0.29.10*/ 
    /*0*/<0.65956,-0.57907,0.47923>,
    /*1*/<0.71167,0.67935,-0.1789>,<-0.5577,0.06633,0.82738>,<-0.17324,-0.72876,-0.66249>,
            
    /*2*/<0.81657,0.55897,-0.14412>,<-0.52084,-0.00165,0.85365>,<-0.32786,-0.53991,-0.77525>,
            
    /*3*/<0.94925,0.30167,-0.08902>,<-0.44031,0.0114,0.89777>,<-0.5049,-0.2871,-0.81403>,
            
    /*4*/<-0.18131,0.97049,-0.159>

    /* stem 0.29.11*/ 
    /*0*/<0.09138,-0.83001,-0.55021>,
    /*1*/<-0.37831,-0.53209,0.75747>,<-0.61019,0.39844,-0.68477>,<0.98584,0.15781,-0.05668>,
            
    /*2*/<-0.37832,-0.5348,0.75556>,<-0.58509,0.30094,-0.75306>,<0.96386,0.26641,0.00102>,
            
    /*3*/<-0.39475,-0.51287,0.76233>,<-0.51791,0.11201,-0.84807>,<0.90035,0.42616,0.08804>,
            
    /*4*/<-0.48701,0.82826,0.27716>

    /* stem 0.29.12*/ 
    /*0*/<0.98561,-0.07306,-0.15241>,
    /*1*/<-0.14933,0.15453,-0.97664>,<0.14262,0.77712,0.61297>,<-0.02176,-0.92954,0.36807>,
            
    /*2*/<-0.11287,0.14534,-0.98292>,<0.23209,0.75995,0.60714>,<-0.15025,-0.90838,0.39021>,
            
    /*3*/<-0.02834,0.08913,-0.99562>,<0.51036,0.59664,0.61931>,<-0.56817,-0.68207,0.4604>,
            
    /*4*/<-0.51592,0.85664,-0.00098>

    /* stem 0.29.13*/ 
    /*0*/<-0.02775,-0.91769,0.39633>,
    /*1*/<0.59194,0.31325,0.74262>,<-0.99328,0.07757,0.08592>,<0.40213,-0.36447,-0.83991>,
            
    /*2*/<0.5942,0.29325,0.74895>,<-0.99276,-0.03067,0.11617>,<0.39158,-0.23871,-0.88864>,
            
    /*3*/<0.57424,0.38584,0.72206>,<-0.96914,-0.17367,0.17492>,<0.39665,-0.17995,-0.90016>,
            
    /*4*/<-0.28227,0.87526,-0.39274>

    /* stem 0.29.14*/ 
    /*0*/<0.43366,-0.31033,-0.84595>,
    /*1*/<-0.7708,-0.61733,-0.15739>,<-0.03077,0.93691,-0.3482>,<0.78916,-0.3107,0.5298>,
            
    /*2*/<-0.82436,-0.56024,-0.08098>,<0.05228,0.85655,-0.51341>,<0.76228,-0.26502,0.5905>,
            
    /*3*/<-0.88436,-0.46657,0.01482>,<0.20516,0.65982,-0.72287>,<0.67852,-0.16604,0.71557>,
            
    /*4*/<-0.38931,0.81137,0.43602>

    /* stem 0.29.15*/ 
    /*0*/<0.80973,-0.41165,0.41819>,
    /*1*/<0.57524,0.64978,-0.49687>,<-0.35732,0.23772,0.90322>,<-0.24094,-0.8758,-0.41824>,
            
    /*2*/<0.5157,0.69243,-0.50458>,<-0.16632,0.12321,0.97834>,<-0.37173,-0.81785,-0.43926>,
            
    /*3*/<0.41219,0.74451,-0.52517>,<0.07546,-0.00741,0.99712>,<-0.50951,-0.72225,-0.46771>,
            
    /*4*/<-0.84145,0.52353,0.13368>

    /* stem 0.29.16*/ 
    /*0*/<-0.14607,-0.91782,-0.36916>,
    /*1*/<-0.1394,-0.34143,0.92951>,<-0.77622,0.34581,-0.52716>,<0.91974,0.02151,-0.39194>,
            
    /*2*/<-0.13933,-0.33176,0.93302>,<-0.78298,0.28876,-0.55096>,<0.9243,0.07017,-0.37517>,
            
    /*3*/<-0.14225,-0.30368,0.9421>,<-0.78564,0.16348,-0.59669>,<0.92524,0.16751,-0.34041>,
            
    /*4*/<-0.11595,0.95322,0.27915>

    /* stem 0.29.17*/ 
    /*0*/<0.92678,0.00941,-0.37548>,
    /*1*/<-0.3813,-0.10199,-0.91881>,<0.13701,0.9123,0.38592>,<0.21831,-0.81058,0.54342>,
            
    /*2*/<-0.34819,-0.11237,-0.93066>,<0.30101,0.88726,0.34951>,<0.02375,-0.77757,0.62835>,
            
    /*3*/<-0.33263,-0.0878,-0.93896>,<0.60813,0.75304,0.25122>,<-0.27826,-0.643,0.71353>,
            
    /*4*/<-0.6682,0.71678,0.19932>

    /* stem 0.29.18*/ 
    /*0*/<0.36742,-0.85919,0.35607>,
    /*1*/<0.70829,0.51413,0.48374>,<-0.87772,-0.18066,0.44381>,<0.15924,-0.30963,-0.93743>,
            
    /*2*/<0.70119,0.53042,0.47643>,<-0.87749,-0.18138,0.44398>,<0.16624,-0.3254,-0.93085>,
            
    /*3*/<0.6438,0.62254,0.44494>,<-0.84581,-0.25218,0.47011>,<0.18911,-0.34455,-0.91952>,
            
    /*4*/<-0.55027,0.7285,-0.40803>

    /* stem 0.29.19*/ 
    /*0*/<0.33063,-0.55238,-0.76522>,
    /*1*/<-0.72062,-0.66879,0.18283>,<-0.17469,0.76684,-0.61761>,<0.88664,-0.08357,0.45484>,
            
    /*2*/<-0.73615,-0.64546,0.20363>,<-0.12046,0.68672,-0.71687>,<0.85354,-0.01528,0.5208>,
            
    /*3*/<-0.72169,-0.6661,0.18834>,<-0.05908,0.59229,-0.80356>,<0.76897,0.08914,0.63303>,
            
    /*4*/<-0.57117,0.64984,0.50148>

    /* stem 0.29.20*/ 
    /*0*/<0.91184,-0.33866,0.23207>,
    /*1*/<0.38065,0.52857,-0.75876>,<-0.08496,0.41546,0.90564>,<-0.31757,-0.9359,-0.15244>,
            
    /*2*/<0.4976,0.45125,-0.74079>,<-0.03691,0.37843,0.92489>,<-0.50213,-0.83821,-0.21278>,
            
    /*3*/<0.57895,0.40741,-0.70628>,<0.15,0.23005,0.96155>,<-0.74367,-0.62607,-0.23451>,
            
    /*4*/<-0.56657,0.82091,0.07145>

    /* stem 0.29.21*/ 
    /*0*/<-0.36848,-0.92223,-0.11711>,
    /*1*/<0.15625,-0.17874,0.97141>,<-0.8685,0.39251,-0.30273>,<0.71944,-0.19578,-0.66639>,
            
    /*2*/<0.16127,-0.16282,0.97339>,<-0.8839,0.35196,-0.30797>,<0.72797,-0.17053,-0.66407>,
            
    /*3*/<0.16081,-0.12628,0.97887>,<-0.92697,0.08456,-0.36549>,<0.75097,0.06061,-0.65755>,
            
    /*4*/<-0.20997,0.96721,0.14286>

    /* stem 0.29.22*/ 
    /*0*/<0.75483,-0.22268,-0.61696>,
    /*1*/<-0.65926,-0.20963,-0.72211>,<0.35072,0.93092,0.10191>,<0.29622,-0.71766,0.63026>,
            
    /*2*/<-0.75891,-0.14588,-0.63464>,<0.48174,0.87565,-0.0342>,<0.27366,-0.69937,0.6603>,
            
    /*3*/<-0.80914,-0.13417,-0.57209>,<0.61824,0.76801,-0.16715>,<0.18018,-0.63087,0.75468>,
            
    /*4*/<-0.57374,0.62399,0.53052>

    /* stem 0.29.23*/ 
    /*0*/<0.34052,-0.7332,0.58861>,
    /*1*/<0.84846,0.51087,0.13832>,<-0.77464,0.14094,0.6165>,<-0.07814,-0.64249,-0.7623>,
            
    /*2*/<0.86874,0.46598,0.16778>,<-0.76799,0.12227,0.62868>,<-0.1032,-0.5801,-0.80798>,
            
    /*3*/<0.93281,0.29753,0.20334>,<-0.74173,-0.03197,0.66994>,<-0.22209,-0.23262,-0.94687>,
            
    /*4*/<-0.17781,0.98055,0.08315>

    /* stem 0.29.24*/ 
    /*0*/<0.00511,-0.67169,-0.74082>,
    /*1*/<-0.64698,-0.56523,0.51179>,<-0.33687,0.69824,-0.63165>,<0.98381,-0.1274,0.12605>,
            
    /*2*/<-0.6458,-0.57076,0.50712>,<-0.31552,0.60377,-0.73206>,<0.97498,-0.01524,0.22177>,
            
    /*3*/<-0.65437,-0.55588,0.51265>,<-0.28844,0.46626,-0.8363>,<0.94002,0.09636,0.32722>,
            
    /*4*/<-0.26962,0.82092,0.50339>

    /* stem 0.29.25*/ 
    /*0*/<0.98662,-0.12785,0.10117>,
    /*1*/<0.14064,0.36117,-0.92183>,<-0.0009,0.61952,0.78498>,<-0.14175,-0.98043,0.13664>,
            
    /*2*/<0.20622,0.33274,-0.92019>,<0.112,0.5767,0.80924>,<-0.34171,-0.93184,0.12208>,
            
    /*3*/<0.2667,0.31431,-0.91109>,<0.33019,0.47765,0.81414>,<-0.59943,-0.79309,0.10818>,
            
    /*4*/<-0.7311,0.68138,0.03476>

    /* stem 0.30*/ 
    /*0*/<-0.30439,-0.51319,0.80248>,
    /*1*/<0.94284,-0.01657,0.33282>,<0.14396,0.81486,0.5615>,<-0.84908,0.52827,0.00155>,
            <-0.66391,-0.48028,-0.57319>,<0.44355,-0.81701,-0.36845>,
    /*2*/<0.94456,-0.01268,0.32809>,<0.11987,0.76941,0.62741>,<-0.86685,0.4964,0.04641>,
            <-0.6503,-0.45321,-0.60968>,<0.46903,-0.76821,-0.43574>,
    /*3*/<0.952,0.01038,0.30593>,<0.0994,0.72957,0.67665>,<-0.8868,0.45098,0.10105>,
            <-0.64372,-0.44098,-0.62543>,<0.4928,-0.71329,-0.49836>,
    /*4*/<0.94479,-0.00894,0.32756>,<0.07179,0.6608,0.74712>,<-0.89612,0.42688,0.12141>,
            <-0.6227,-0.38514,-0.68111>,<0.51549,-0.65433,-0.55328>,
    /*5*/<0.93111,-0.05745,0.36018>,<0.05251,0.5775,0.8147>,<-0.89425,0.42685,0.13456>,
            <-0.6011,-0.30177,-0.74001>,<0.52716,-0.60104,-0.60071>,
    /*6*/<0.28284,0.77503,-0.56508>

    /* stem 0.30.0*/ 
    /*0*/<-0.5695,-0.82199,-0.00099>,
    /*1*/<-0.81502,0.57707,0.0523>,<0.37953,-0.2494,-0.89093>,<0.453,-0.3024,0.83866>,
            
    /*2*/<-0.83865,0.54217,0.0521>,<0.39141,-0.22952,-0.89114>,<0.46261,-0.28618,0.8391>,
            
    /*3*/<-0.87191,0.48622,0.05801>,<0.36738,-0.27865,-0.88735>,<0.52673,-0.18325,0.83005>,
            
    /*4*/<0.43804,0.87786,-0.19361>

    /* stem 0.30.1*/ 
    /*0*/<0.46006,-0.25103,0.85166>,
    /*1*/<0.31354,-0.84623,-0.43079>,<0.55399,0.82985,-0.06664>,<-0.88162,0.02407,0.47135>,
            
    /*2*/<0.33543,-0.86382,-0.3759>,<0.56877,0.82196,-0.02963>,<-0.92388,0.04802,0.37966>,
            
    /*3*/<0.29233,-0.80315,-0.51913>,<0.65767,0.74338,0.12188>,<-0.93857,0.05593,0.34052>,
            
    /*4*/<-0.31058,0.60636,-0.73203>

    /* stem 0.30.2*/ 
    /*0*/<-0.80813,-0.103,0.57993>,
    /*1*/<0.3415,0.73283,0.5885>,<-0.57897,0.21854,-0.78551>,<0.26212,-0.94823,0.17932>,
            
    /*2*/<0.29296,0.71021,0.64014>,<-0.67469,0.17532,-0.71697>,<0.42094,-0.90597,0.04508>,
            
    /*3*/<0.19919,0.62492,0.75485>,<-0.80485,0.12471,-0.58023>,<0.63964,-0.74293,-0.19728>,
            
    /*4*/<0.41953,0.71333,-0.56138>

    /* stem 0.30.3*/ 
    /*0*/<0.12454,-0.94138,0.31351>,
    /*1*/<-0.83012,-0.26285,-0.49174>,<0.88544,-0.02665,-0.464>,<-0.05909,0.31805,0.94623>,
            
    /*2*/<-0.81859,-0.19484,-0.54033>,<0.89662,-0.26701,-0.35325>,<-0.02877,0.45997,0.88747>,
            
    /*3*/<-0.79078,-0.11669,-0.60087>,<0.84516,-0.50257,-0.18201>,<-0.04295,0.63989,0.76726>,
            
    /*4*/<0.36278,0.70346,-0.61118>

    /* stem 0.30.4*/ 
    /*0*/<-0.04107,0.33845,0.94009>,
    /*1*/<0.93702,-0.31791,0.14468>,<-0.16666,0.92185,-0.34987>,<-0.76912,-0.61417,0.17681>,
            
    /*2*/<0.9448,-0.30842,0.11054>,<-0.24238,0.97002,-0.01763>,<-0.78534,-0.61035,-0.10348>,
            
    /*3*/<0.97148,-0.23714,0.00059>,<-0.30138,0.82155,0.48396>,<-0.68588,-0.55021,-0.47628>,
            
    /*4*/<0.08629,0.71064,-0.69825>

    /* stem 0.30.5*/ 
    /*0*/<-0.63466,-0.7449,0.20575>,
    /*1*/<-0.646,0.66659,0.37194>,<-0.02617,-0.23277,-0.97218>,<0.69125,-0.41142,0.59405>,
            
    /*2*/<-0.67213,0.63139,0.38676>,<-0.05939,-0.28347,-0.95714>,<0.7569,-0.32708,0.5658>,
            
    /*3*/<-0.70769,0.56889,0.41898>,<-0.13094,-0.37941,-0.91592>,<0.85795,-0.16685,0.48588>,
            
    /*4*/<0.32449,0.82238,-0.46732>

    /* stem 0.30.6*/ 
    /*0*/<0.53436,-0.55208,0.64006>,
    /*1*/<0.03677,-0.73338,-0.67883>,<0.7047,0.70946,0.00804>,<-0.75744,0.04042,0.65165>,
            
    /*2*/<-0.00894,-0.67878,-0.73429>,<0.74028,0.67086,0.04402>,<-0.74475,0.02393,0.66692>,
            
    /*3*/<-0.06123,-0.59286,-0.80298>,<0.82241,0.54707,0.15605>,<-0.76599,0.07384,0.63859>,
            
    /*4*/<-0.2716,0.79761,-0.53856>

    /* stem 0.30.7*/ 
    /*0*/<-0.65671,-0.19469,0.72858>,
    /*1*/<0.59439,0.47483,0.64903>,<-0.69646,0.50964,-0.50518>,<0.1216,-0.97868,-0.16551>,
            
    /*2*/<0.61155,0.49802,0.6148>,<-0.8456,0.42181,-0.32716>,<0.20216,-0.92307,-0.32721>,
            
    /*3*/<0.64031,0.48608,0.59475>,<-0.96257,0.26687,-0.04738>,<0.32427,-0.74539,-0.58245>,
            
    /*4*/<0.11317,0.74414,-0.65837>

    /* stem 0.30.8*/ 
    /*0*/<-0.09088,-0.97229,0.2154>,
    /*1*/<-0.94188,0.02392,-0.3351>,<0.74998,-0.19968,-0.6306>,<0.19458,0.20447,0.95934>,
            
    /*2*/<-0.94992,-0.01366,-0.31218>,<0.75187,-0.36432,-0.54951>,<0.23864,0.42512,0.87311>,
            
    /*3*/<-0.96518,-0.1418,-0.21981>,<0.6985,-0.45751,-0.55026>,<0.26354,0.61358,0.74435>,
            
    /*4*/<-0.09908,0.78674,-0.60928>

    /* stem 0.30.9*/ 
    /*0*/<0.12397,-0.07746,0.98926>,
    /*1*/<0.85532,-0.49413,-0.15578>,<0.0043,0.9977,0.06768>,<-0.86326,-0.50129,0.05903>,
            
    /*2*/<0.85452,-0.44258,-0.27187>,<0.03995,0.94341,0.32923>,<-0.89008,-0.45379,-0.04274>,
            
    /*3*/<0.82827,-0.35271,-0.43538>,<0.06073,0.78192,0.62041>,<-0.89033,-0.40811,-0.20188>,
            
    /*4*/<-0.13015,0.69599,-0.70616>

    /* stem 0.30.10*/ 
    /*0*/<-0.78214,-0.57086,0.24975>,
    /*1*/<-0.36333,0.75415,0.54703>,<-0.24049,-0.0768,-0.96761>,<0.62662,-0.66071,0.41329>,
            
    /*2*/<-0.3903,0.71364,0.5817>,<-0.36243,-0.26909,-0.89232>,<0.84783,-0.46095,0.26212>,
            
    /*3*/<-0.39132,0.71752,0.57623>,<-0.56058,-0.42857,-0.70857>,<0.95647,-0.26749,0.11664>,
            
    /*4*/<0.30121,0.6401,-0.70678>

    /* stem 0.30.11*/ 
    /*0*/<0.47125,-0.72006,0.50936>,
    /*1*/<-0.30138,-0.66628,-0.68208>,<0.86309,0.48903,-0.12622>,<-0.5754,0.19818,0.7935>,
            
    /*2*/<-0.28776,-0.7022,-0.65124>,<0.90837,0.41522,-0.04964>,<-0.63935,0.32392,0.69736>,
            
    /*3*/<-0.26935,-0.73596,-0.62114>,<0.95678,0.28588,0.05326>,<-0.69075,0.47074,0.54888>,
            
    /*4*/<-0.08783,0.65597,-0.74966>

    /* stem 0.30.12*/ 
    /*0*/<-0.48424,-0.08821,0.87048>,
    /*1*/<0.83033,0.28373,0.47962>,<-0.65872,0.68649,-0.30792>,<-0.15765,-0.96769,-0.1968>,
            
    /*2*/<0.80172,0.24931,0.54323>,<-0.7592,0.62515,-0.18109>,<-0.03919,-0.8991,-0.43598>,
            
    /*3*/<0.78966,0.27771,0.5471>,<-0.84554,0.53155,0.05022>,<0.06655,-0.78767,-0.61249>,
            
    /*4*/<0.22331,0.59112,-0.77506>

    /* stem 0.30.13*/ 
    /*0*/<-0.24719,-0.96069,0.12638>,
    /*1*/<-0.96584,0.24903,-0.0717>,<0.51886,-0.2318,-0.82283>,<0.45407,0.01032,0.89091>,
            
    /*2*/<-0.96383,0.25606,-0.07392>,<0.50437,-0.29318,-0.81219>,<0.47017,0.06303,0.88032>,
            
    /*3*/<-0.96509,0.25119,-0.07416>,<0.47101,-0.43288,-0.76861>,<0.50982,0.20663,0.8351>,
            
    /*4*/<0.23504,0.85518,-0.46198>

    /* stem 0.30.14*/ 
    /*0*/<0.36595,-0.16504,0.91588>,
    /*1*/<0.65421,-0.64879,-0.3887>,<0.23784,0.96884,0.06917>,<-0.90249,-0.31534,0.29339>,
            
    /*2*/<0.63905,-0.6111,-0.46709>,<0.30897,0.90963,0.27768>,<-0.94619,-0.26057,0.19192>,
            
    /*3*/<0.59253,-0.49994,-0.63164>,<0.36257,0.78404,0.50381>,<-0.95728,-0.27127,0.10012>,
            
    /*4*/<-0.32691,0.66324,-0.67324>

    /* stem 0.30.15*/ 
    /*0*/<-0.8426,-0.37628,0.38527>,
    /*1*/<-0.03148,0.76011,0.64903>,<-0.43744,0.08838,-0.89489>,<0.49279,-0.83783,0.23495>,
            
    /*2*/<-0.21034,0.62265,0.7537>,<-0.42949,0.09975,-0.89754>,<0.67749,-0.71058,0.18996>,
            
    /*3*/<-0.37494,0.42258,0.82513>,<-0.46453,0.11172,-0.87849>,<0.85648,-0.51385,0.0491>,
            
    /*4*/<0.46236,0.8684,-0.1792>

    /* stem 0.30.16*/ 
    /*0*/<0.38716,-0.91233,0.13328>,
    /*1*/<-0.55309,-0.3358,-0.76245>,<0.91226,0.37256,-0.17023>,<-0.37009,-0.01105,0.92893>,
            
    /*2*/<-0.56412,-0.28385,-0.77537>,<0.95948,0.24068,-0.14653>,<-0.38759,0.06977,0.91919>,
            
    /*3*/<-0.56763,-0.20781,-0.79662>,<0.99626,0.01455,-0.08518>,<-0.42265,0.2201,0.87916>,
            
    /*4*/<0.0693,0.95715,-0.28116>

    /* stem 0.30.17*/ 
    /*0*/<-0.36892,-0.09329,0.92477>,
    /*1*/<0.93253,-0.06242,0.35567>,<-0.43987,0.89298,-0.09545>,<-0.48237,-0.82796,-0.28602>,
            
    /*2*/<0.94117,-0.04296,0.33518>,<-0.59206,0.78639,0.17625>,<-0.43483,-0.72121,-0.53924>,
            
    /*3*/<0.953,-0.01656,0.30252>,<-0.70072,0.47955,0.52823>,<-0.28241,-0.44195,-0.85142>,
            
    /*4*/<0.12061,0.93729,-0.32701>

    /* stem 0.30.18*/ 
    /*0*/<-0.47605,-0.86152,-0.17654>,
    /*1*/<-0.86961,0.44928,0.20474>,<0.35733,0.00466,-0.93397>,<0.52547,-0.43007,0.73411>,
            
    /*2*/<-0.84352,0.4994,0.19768>,<0.26957,-0.16567,-0.94862>,<0.59899,-0.32761,0.73068>,
            
    /*3*/<-0.81651,0.54447,0.19201>,<0.13551,-0.40932,-0.90227>,<0.70307,-0.1183,0.70121>,
            
    /*4*/<0.41751,0.80468,-0.42211>

    /* stem 0.30.19*/ 
    /*0*/<0.28866,-0.61533,0.73351>,
    /*1*/<0.40742,-0.60744,-0.68192>,<0.54174,0.74114,0.39652>,<-0.95679,-0.11742,0.26601>,
            
    /*2*/<0.40821,-0.6347,-0.65615>,<0.55416,0.64324,0.52835>,<-0.99205,0.03151,0.12181>,
            
    /*3*/<0.43019,-0.61003,-0.66543>,<0.56468,0.47649,0.67387>,<-0.98811,0.1516,-0.02546>,
            
    /*4*/<0.11995,0.80819,-0.57658>

    /* stem 0.30.20*/ 
    /*0*/<-0.81183,-0.36309,0.45726>,
    /*1*/<0.25227,0.50049,0.82818>,<-0.57521,0.43618,-0.69201>,<0.34201,-0.92814,-0.1469>,
            
    /*2*/<0.17308,0.40785,0.89649>,<-0.66656,0.34733,-0.6596>,<0.57486,-0.76961,-0.27792>,
            
    /*3*/<0.05176,0.23584,0.97041>,<-0.81599,0.1985,-0.54292>,<0.79145,-0.4178,-0.44614>,
            
    /*4*/<0.21688,0.96334,-0.15795>

    /* stem 0.30.21*/ 
    /*0*/<0.15606,-0.9869,0.0408>,
    /*1*/<-0.78812,-0.14229,-0.59885>,<0.90928,0.1346,-0.39383>,<-0.12443,0.02841,0.99182>,
            
    /*2*/<-0.77179,-0.30044,-0.56043>,<0.91571,0.11071,-0.3863>,<-0.17485,0.21371,0.96112>,
            
    /*3*/<-0.74164,-0.49248,-0.45544>,<0.93902,-0.02911,-0.34264>,<-0.1985,0.56187,0.8030