
// POV-Ray Object File - City
// created 15-Apr-06
// last update 15-Apr-06
// Copyright 2006 Glenn McCarter (glenn@mccarters.net). Some rights reserved.
// This work is licensed under the Creative Commons Attribution License
// To view a copy of this license, visit http://creativecommons.org/licenses/by/2.0/
//
// Required #include files: "GIncludeRH.inc"
//
// Objects:
// NeonJazzSign
// JazzClub
// NightBuilding(RS)
// NightBuildingRow()
//
//
// Intended scale is English system (inches)
// Uses RH coordinate reference system (Z=up)
//
// This file is intended to be included in another POV-Ray scene file,
// but can be rendered alone.
#ifndef (ThisIsMaster) // If this include file was not called by another, then
	#declare RenderMe = 0; // supress self-rendering of other include files
	#declare ThisIsMaster = 1;
	#include "GIncludeRH.inc"
	// renderable sub includes go here
	#declare RenderMe = 1;
#end

//===============================================
//             Includes
//===============================================

// non-renderable sub includes go here

//===============================================
//             Variables
//===============================================

#if (RenderMe = 1)
	#local Radios=0;
#end

//===============================================
//             Textures
//===============================================

#declare TestWhiteTex =
	texture {
		pigment { color rgb<1,1,1> }
	}
#declare BuildingBrickTex =
	texture {
		pigment {
			brick
			rotate x*90
		}
	}
#declare NBDTex = // Night Building Dark Paint
	texture {
//		pigment { color rgb<1,1,1> } // test
		pigment { color rgb<.24,.16,.08> }
	}

#macro WindowGlowTex(Darkness,Rand)
//	pigment { color rgb<0.96,0.92,0.75>*Darkness }
	pigment {
		bozo
		color_map {
			[ 0.0 rgb<0.96,0.92,0.75>*Darkness ]
			[ 1.0 rgb<0.96,0.92,0.75>*Darkness*.45 ]
		}
		scale <.61*Feet,.61*Feet,30*Feet>
		translate 50*Feet*rand(Rand)
	}
	#if (Radios)
		finish { ambient 20 diffuse 0 }
	#else
		finish { ambient 0.8 diffuse 0.4 }
	#end
#end

#declare JazzSignBackgroundTex =
	texture {
		pigment {
			bozo
			color_map {
				[ 0.4 rgb<1,1,1>*0.65 ]
				[ 1.0 rgb<1,1,1>*0.15 ]
			}
			scale <4,4,30>
		}
		finish { ambient .01 diffuse 0.6 }
	}

//===============================================
//             Macros
//===============================================

#macro NBWindow(Rand)
	union {
		box { <-2.0*Feet,-1,0>,<2.0*Feet,1,5*Feet> texture { NBDTex } } // window frame
		box { <-2.0*Feet+4,-1.1,4>,<2.0*Feet-4,1,5*Feet-4> texture { WindowGlowTex(Rand,Rand) } } // lighted curtain
		box { <-1.4,-1.2,0>,<1.4,1,5*Feet> texture { NBDTex } } // main upright divider
		box { <-2.0*Feet,-1.2,2.5*Feet-0.8>,<2.0*Feet,1,2.5*Feet+0.8> texture { NBDTex } } // main horiz divider

		box { <-2.0*Feet,-1.2,1.25*Feet-0.38>,<2.0*Feet,1,1.25*Feet+0.38> texture { NBDTex } } // window frame dividers
		box { <-2.0*Feet,-1.2,3.25*Feet-0.38>,<2.0*Feet,1,3.25*Feet+0.38> texture { NBDTex } } // window frame dividers
		box { <-1*Feet-0.38,-1.2,0>,<-1*Feet+0.38,1,5*Feet> texture { NBDTex } } // window frame dividers
		box { < 1*Feet-0.38,-1.2,0>,<1*Feet+0.38,1,5*Feet> texture { NBDTex } } // window frame dividers
	} // end union
#end

//===============================================
//             Jazz Neon Sign
//===============================================

#declare JHeight=12*Feet;
#declare JazzSignBackground =
	box { <0,0,0>,<JHeight*.25,8,JHeight>
		texture { JazzSignBackgroundTex }
	}
#declare JazzNeon =
		height_field { // starts extruded into +Y, with image upper left corner at <0,y,1>
			png "JazzSign_HFMap.png"
			smooth
			water_level 1/255
//			scale <JHeight*0.25,-1.3,JHeight> // too thick?
			scale <JHeight*0.25,-0.7,JHeight> // test
			//texture { StudioWallTex } // test

			texture {
				pigment { color rgb<1.00,0.67,0.95> }
				#if (Radios)
					finish { ambient 24 diffuse 0 }
				#else
					finish { ambient 1.5 diffuse 0.4 }
				#end
			}
		}
#declare JazzNeonGlow =
	box {
		<0,0,0>,<1,1,1>
			texture {
				pigment {
					image_map { // mapped onto x-y plane, upper left at <0,1,0>, upper right at <1,1,0>
						png "JazzSign_GlowMap.png"
					}
					rotate x*90 //<0,90,-90> translate <0,0,1>
				}
			#if (Radios)
				finish { ambient 20 diffuse 0 }
			#else
				finish { ambient 1.3 diffuse 0.4 }
			#end
			}
		scale <JHeight*.25,0.1,JHeight>
	}
#declare JazzSign =
	union {
		object { JazzSignBackground }
		object { JazzNeonGlow translate <0,-0.05,0> }
		object { JazzNeon translate <0,-1,0> }
	} // end union

//===============================================
//             City Buildings
//===============================================

#macro NightBuilding(RS)
	#local BH=32*Feet+rand(RS)*3.5*Feet;
	union {
		box { // main
			<0,0,0>,<20*Feet,40*Feet,BH>
			texture { BuildingBrickTex }
		}
		box { <-1.6*Feet,-1,0>,<1.6*Feet,1,7*Feet> texture { NBDTex } translate <10*Feet,0,0> } // door
		object { NBWindow(rand(RS)) translate <5*Feet,0,3*Feet> } // window
		object { NBWindow(rand(RS)) translate <(20-5)*Feet,0,3*Feet> } // window

		object { NBWindow(rand(RS)) translate <5*Feet,0,10*Feet+3*Feet> } // window
		object { NBWindow(rand(RS)) translate <10*Feet,0,10*Feet+3*Feet> } // window
		object { NBWindow(rand(RS)) translate <(20-5)*Feet,0,10*Feet+3*Feet> } // window

		object { NBWindow(rand(RS)) translate <5*Feet,0,20*Feet+3*Feet> } // window
		object { NBWindow(rand(RS)) translate <10*Feet,0,20*Feet+3*Feet> } // window

		object { NBWindow(rand(RS)) translate <(20-5)*Feet,0,20*Feet+3*Feet> } // window

	// rooftop structures
	#switch (int(rand(RS)*3))
	#case (1)
		box { <0,0,0>,<4*Feet+rand(RS)*8*Feet,6*Feet+rand(RS)*8*Feet,2*Feet+rand(RS)*3*Feet> translate <rand(RS)*6*Feet,rand(RS)*6*Feet,BH> texture { NBDTex } }
		cylinder { <0,0,0>,<0,0,1*Feet+rand(RS)*1*Feet>,5+rand(RS)*3 translate <6+rand(RS)*1*Feet,24*Feet+rand(RS)*6*Feet,BH> texture { NBDTex } }
		#local CS=rand(RS);
		box { <0,0,0>,<4*Feet+CS,6*Feet+CS,2*Feet+CS> translate <CS*6*Feet,CS*18*Feet,BH> texture { NBDTex } }
		cylinder { <(4*Feet+CS)/2,0,2*Feet+CS>,<(4*Feet+CS)/2,6*Feet+CS,2*Feet+CS>,(4*Feet+CS)/2 translate <CS*6*Feet,CS*18*Feet,BH> texture { NBDTex } }
	#break
	#case (2)
		box { <0,0,0>,<2*Feet+rand(RS)*3*Feet,4*Feet+rand(RS)*4*Feet,1*Feet+rand(RS)*2*Feet> translate <rand(RS)*6*Feet,rand(RS)*16*Feet,BH> texture { NBDTex } }
		cylinder { <0,0,0>,<0,0,2*Feet+rand(RS)*4*Feet>,2+rand(RS)*6 translate <rand(RS)*3*Feet,12+rand(RS)*6*Feet,BH> texture { NBDTex } }
		cylinder { <0,0,0>,<0,0,2*Feet+rand(RS)*3*Feet>,1+rand(RS)*3 translate <6+rand(RS)*13*Feet,6*Feet+rand(RS)*6*Feet,BH> texture { NBDTex } }
	#break
	#else
		cylinder { <0,0,0>,<0,0,2*Feet+rand(RS)*2*Feet>,3+rand(RS)*6 translate <6+rand(RS)*13*Feet,12+rand(RS)*6*Feet,BH> texture { NBDTex } }
		cylinder { <0,0,0>,<0,0,2*Feet+rand(RS)*3*Feet>,1+rand(RS)*3 translate <6+rand(RS)*13*Feet,12+rand(RS)*6*Feet,BH> texture { NBDTex } }
		cylinder { <0,0,0>,<0,0,1*Feet+rand(RS)*1*Feet>,5+rand(RS)*3 translate <6+rand(RS)*1*Feet,24*Feet+rand(RS)*6*Feet,BH> texture { NBDTex } }
		#local CS=rand(RS);
		box { <0,0,0>,<4*Feet+CS,6*Feet+CS,2*Feet+CS> translate <CS*6*Feet,CS*18*Feet,BH> texture { NBDTex } }
		cylinder { <(4*Feet+CS)/2,0,2*Feet+CS>,<(4*Feet+CS)/2,6*Feet+CS,2*Feet+CS>,(4*Feet+CS)/2 translate <CS*6*Feet,CS*18*Feet,BH> texture { NBDTex } }
	#break
	#end

		scale <1,1,0.9+rand(RS)*0.1>
	} // end union
#end

#macro NightBuildingRow()
	#local NRS=seed(32094);
	union {
		object { NightBuilding(NRS) }
		object { NightBuilding(NRS) translate <20*Feet,4,0> }
		object { NightBuilding(NRS) translate <42*Feet,-8,0> }
		object { NightBuilding(NRS) translate <66*Feet,1,0> }
	} // end union
#end

#declare JazzClub =
//	#local JCS=seed(87490);
	#local JCS=seed(21790);
	union {
		object { NightBuilding(JCS) }
		object { JazzSign rotate z*-90 translate <13*Feet,-12,10*Feet> }
	} // end union

//===============================================
//             Viewpoint 01
//===============================================

#if (RenderMe = 1)
global_settings {	max_trace_level 150 }
#declare TestSphere = sphere{ 0,12 pigment { color rgb<1,1,1> } }

	camera {
		perspective
		direction <0.0,     1.0,  0.0>
		sky       <0.0,     0.0,  1.0>  // Use right handed-system!
		up        <0.0,     0.0,  1.0>  // Where Z is up
		right     <1.33333, 0.0,  0.0>

		angle 44
//		location  <-20*Feet, -60*Feet, 53*Feet> // overall
//		look_at <0*Feet,0*Feet,1*Feet>
//		location  <-8*Feet, 0*Feet, 5*Feet> // render
//		look_at <1*Feet,15*Feet,6*Feet>
//		location  <23*Feet, -224*Feet, 5235*Feet> // top down
//		look_at <30*Feet,20*Feet,18*Feet>
//		location  <1*Feet,-50*Feet, 15*Feet> // sign
//		look_at <0*Feet,00*Feet,8*Feet>
		location  <1*Feet,-50*Feet, 65*Feet> // higher up
		look_at <0*Feet,70*Feet,28*Feet>

	}

background { color rgb <0.276,0.567,0.982>*.97 } // sky blue


light_source // external
	{ <140*Feet,-300*Feet,250*Feet>, 0.4 }

light_source // external
	{ <-140*Feet,-200*Feet,130*Feet>, <1.13,1.08,0.83>*.8 }

/*
light_source // internal
	{ <0,0,0>, 1.2
		spotlight point_at <0,2*Feet,-10*Feet> radius 23 falloff 44
		translate <6*Feet,16*Feet,13*Feet>
	}

light_source // internal
	{ <0,0,0> , <1.13,1.08,0.83>*.8
		spotlight point_at <0,2*Feet,-10*Feet> radius 23 falloff 44
		translate <-6*Feet,16*Feet,13*Feet>
	}
*/
plane { z,-0 pigment { checker rgb <1,1,1>, rgb <1,1,1>*.75 } scale 10*Feet }

//#include "GRuler.inc" // for testing only
//object { TestSphere scale 1 translate <0,0,10> }

#object { JazzSign rotate z*-70 translate <3.5*Feet,60*Feet,2*Feet> }
#declare NBS=seed(20495);
//#object { NightBuilding(NBS) rotate z*20 translate <-5*Feet,80*Feet,0> }
#object { NightBuildingRow() rotate z*-20 translate <-30*Feet,120*Feet,0> }
#object { JazzClub rotate z*30 translate <-40*Feet,70*Feet,0> }

#end

