
// POV-Ray Object File - Drum Set
// created 4-Apr-06
// last update 5-Apr-06
// Copyright 2006 Glenn McCarter (glenn@mccarters.net). Some rights reserved.
// This work is licensed under the Creative Commons Attribution License
// To view a copy of this license, visit http://creativecommons.org/licenses/by/2.0/
//
// Required #include files: "GIncludeRH.inc"
//
// Objects:
// DrumSet
//
//
// Intended scale is English system (inches)
// Uses RH coordinate reference system (Z=up)
//
// This file is intended to be included in another POV-Ray scene file,
// but can be rendered alone.
#ifndef (ThisIsMaster) // If this include file was not called by another, then
	#declare RenderMe = 0; // supress self-rendering of other include files
	#declare ThisIsMaster = 1;
	#include "GIncludeRH.inc"
	// renderable sub includes go here
	#declare RenderMe = 1;
#end

//===============================================
//             Includes
//===============================================

// non-renderable sub includes go here

//===============================================
//             Variables
//===============================================


//===============================================
//             Textures
//===============================================

#declare DrumBodyTex =
	texture {
		pigment {
			bozo
			color_map {
				[ 0.4 rgb<.967,.087,.306>*0.0995 ]
				[ 0.7 rgb<.567,.107,.156>*0.0935 ]
			}
			turbulence 0.3
			scale <.31,.31,4>
		}
//		finish { ambient 0.05 diffuse 0.4 specular 0.84 roughness 0.023 }
		finish { ambient 0.05 diffuse 0.4 specular 0.84 roughness 0.023 reflection 0.24 } // reflection test
	}
#declare DrumChromeTex =
	texture {
		pigment { color rgb<.875,.858,.987>*.2 }
		finish { specular 0.99 roughness .005 reflection 0.48 metallic 0.3 brilliance 8 }
	}
#declare DrumHeadTex =
	texture {
		pigment { color rgb<1,1,1> }
	}
#declare BronzeTex =
	texture {
		pigment { color rgb<.983,.658,.087>*.5 }
		normal { dents 0.3 scale 0.5 }
		finish { specular 0.99 roughness .005 reflection 0.38 metallic brilliance 8 }
	}
#declare BlackRubberTex =
	texture {
		pigment { color rgb<1,1,1>*.006 }
	}
#declare SeatLeatherTex =
	texture {
		pigment { color rgb<0.12,0.09,0.06>*.3 }
		normal { bumps 0.35 scale 0.29 }
		finish { specular 0.16 roughness 0.05 }
	}
#declare DrumStickTex =
	texture {
		pigment { color rgb <0.790, 0.605, 0.404>*0.86 }
		finish { ambient 0.1 diffuse 0.6 specular 0.20 roughness 0.18 }
	}

#declare DrumWhiteTex =
	texture {
		pigment { color rgb<1,1,1> }
	}

//===============================================
//             Macros
//===============================================



//===============================================
//             Drums
//===============================================

// Basic drum orientation is with drumhead top in x-y plane, z=up


#macro Drum(Dia,Height)
	#local DR = Dia/2;
	union {
		// If you really want the full drum model, contact me
		superellipsoid { <0.2,0.2> scale <DR*0.9,DR*0.9,1> translate <0,0,-1.0> texture { DrumWhiteTex } }
		difference {
			superellipsoid { <0.15,0.15> scale <DR,DR,Height/2> translate <0,0,-Height/2> }
			superellipsoid { <0.15,0.15> scale <DR*0.9,DR*0.9,Height/2*1.2> translate <0,0,Height/2> }
			texture { DrumBodyTex }
		} // end difference
	} // end union
#end

#declare CymbalS =
	cone {
		<0,0,0>,1,<0,0,-2>,8
		texture { BronzeTex }
	}
#declare CymbalSGroup =
	union {
		object { CymbalS }
		cylinder { <0,0,0>,<0,0,-99>,0.38 texture { DrumChromeTex } }
	} // end union

#declare DrumStick =
	union {
		sor {
			7,
			<0.00,0.00>
			<0.05,0.05>
			<0.10,0.64>
			<0.22,3.60>
			<0.22,11.10>
			<0.11,12.00>
			<0.05,12.23>
		}
		sphere { <0,0,0>,0.16 scale <1,2,1> }
		texture { DrumStickTex }
	} // end union

//===============================================
//             Stands
//===============================================

#macro StandLeg(Length)
	union {
		superellipsoid {
			<.4,.4>
			scale <1.3/2,1.3/2,2/2>
			translate <0,0,1>
			texture { BlackRubberTex }
		}
		superellipsoid { // leg L
			<.9,.1>
			scale <.25/2,1/2,Length/2>
			translate <-0.4,0,Length/2+2>
		}
		superellipsoid { // leg R
			<.9,.1>
			scale <.25/2,1/2,Length/2>
			translate <0.4,0,Length/2+2>
		}
		texture { DrumChromeTex }
	} // end union
#end
#macro StandLegBrace(Length,AngleFromUp)
	union {
		superellipsoid {
			<.9,.1>
			scale <.25/2,1/2,Length/2>
			translate <0,0,Length/2>
			rotate <-AngleFromUp,0,0>
		}
		cylinder { <-0.5,0,0>,<0.5,0,0>,.18 } // shaft
		sphere { <0,0,0>,0.32 translate <-0.60,0,0> } // nut
		sphere { <0,0,0>,0.32 translate < 0.60,0,0> } // screw
		texture { DrumChromeTex }
	} // end union
#end

#macro StandLeg1()
	union {
		object { StandLeg(16) }
		object { StandLegBrace(7,90) translate <0,0,10> }
	}
#end
#macro StandLegGroup()
	union {
		object { StandLeg1() rotate x*-35 translate <0,-11.5,0.5> rotate z*0 }
		object { StandLeg1() rotate x*-35 translate <0,-11.5,0.5> rotate z*120 }
		object { StandLeg1() rotate x*-35 translate <0,-11.5,0.5> rotate z*240 }
	} // end union
#end

#macro StandShaft(Height)
	#local LH=34; // local height
	union {
		cylinder {<0,0,4.5>,<0,0,LH>,0.5 } // main
		cylinder { <0,0,LH>,<0,0,Height>,0.35 } // upper adjustable shaft
		cylinder { <0,0,-2>,<0,0,0>,0.60 translate <0,0,Height> }
		cylinder { <0,0,-1.3>,<0,0,0>,0.7 translate <0,0,LH> } // adj knuckle
		torus { 0.64,0.06 rotate x*90 translate <0,0,LH> }
		cylinder { <0,0,0>,<0,0,1.5>,1.2 translate <0,0,14.5> } // mid attach
		torus { 1.0,0.20 rotate x*90 translate <0,0,16> }
		superellipsoid { <.4,.4> scale <.6/2,1.5/2,1.0/2> translate <0,-1.5,15> rotate z*0 }
		superellipsoid { <.4,.4> scale <.6/2,1.5/2,1.0/2> translate <0,-1.5,15> rotate z*120 }
		superellipsoid { <.4,.4> scale <.6/2,1.5/2,1.0/2> translate <0,-1.5,15> rotate z*240 }
		cylinder { <0,0,0>,<0,0,1.5>,1.2 translate <0,0,4.5> } // bottom attach
		texture { DrumChromeTex }
	} // end union
#end

#macro Stand(Height)
	union {
		object { StandShaft(Height) }
		object { StandLegGroup() }
	} // end union
#end

#declare CymbalHeadGroup =
	union {
		object { CymbalS }
		cylinder { <0,0,-2.5>,<0,0,-0.5>,0.6 texture { BlackRubberTex } }
		sphere { <0,0,0>,0.8 translate <0,0,0.4> texture { BlackRubberTex } }
		superellipsoid { <0.4,0.4> scale <0.45/2,1.8/2,0.75/2> translate <0,0,1.5> texture { DrumChromeTex } }
		cylinder { <0,0,3.4>,<0,0,-5>,0.18 texture { DrumChromeTex } }
	} // end union

#macro CymbalArmGroup(HeadRot)
	union {
		object { CymbalHeadGroup translate <0,0,5> rotate x*HeadRot } 
		difference {
			cylinder { <0,0,-24>,<0,0,0>,0.45 texture { DrumChromeTex } } // main arm
			cylinder { <0,0,-25>,<0,0,1>,0.30 texture { BlackRubberTex } } // main arm
		} // end difference
		cone { <0,0,-0.5>,0.8,<0,0,-2.2>,0.55 }
		cylinder { <-1,0,0>,<1,0,0>,0.8 }
		texture { DrumChromeTex }
	} // end union
#end

#macro BassLeg(Height)
	union {
		superellipsoid {
			<.4,.4>
			scale <1.3/2,1.3/2,2/2>
			translate <0,0,1>
			texture { BlackRubberTex }
		}
		cylinder { <0,0,1>,<0,0,Height>,0.35 }
		cylinder { <0,0,Height/2>,<0,0,Height>,0.52 }
		superellipsoid { <0.5,0.8> scale <1.5/2,1.5/2,1.5/2> translate <0,0,Height/2> }
		cylinder { <0,0,0>,<-1.5,0,0>,0.15 translate <0,0,Height/2> }
		cylinder { <-1.0,0,0>,<-1.8,0,0>,0.75 scale <1,0.7,1> translate <0,0,Height/2> }
		superellipsoid { <0.3,0.7> scale <1.2,1/2,1.5/2> translate <0,0,Height> }
		texture { DrumChromeTex }
	} // end union
#end
#macro KettleLeg(Height)
	union {
		superellipsoid {
			<.4,.4>
			scale <0.9/2,0.9/2,1.5/2>
			translate <0,0,1>
			texture { BlackRubberTex }
		}
		cylinder { <0,0,1>,<0,0,Height*1.18>,0.27 }
		superellipsoid { <0.5,0.5> scale <1.9/2,1.5/2,2.4/2> translate <0,0,Height> }
		superellipsoid { <0.5,0.5> scale <1.9/2,2.2/2,3.0/2> translate <1.1,0,Height> }
		texture { DrumChromeTex }
	} // end union
#end

#declare DoubleDrumArm =
	union {
		superellipsoid { <0.5,1.0> scale <1.4/2,1.4/2,2.4/2> }
		cylinder { <-1.8,0,0>,<1.8,0,0>,0.90 translate <0,1.4,0> }
		cylinder { <-1.8,0,0>,<-1.7,0,0>,0.75 translate <0,1.4,0> texture { BlackRubberTex } }
		cylinder { < 1.8,0,0>,< 1.7,0,0>,0.75 translate <0,1.4,0> texture { BlackRubberTex } }
		cylinder { <-3.0,0,0>,<3.0,0,0>,0.45 translate <0,1.4,0> }
		cylinder { <0,0,0>,<0,0,6>,0.35 rotate x*-39 translate <-3.0,1.4,0> }
		cylinder { <0,0,0>,<0,0,6>,0.35 rotate x*-39 translate < 3.0,1.4,0> }
		superellipsoid { <0.6,0.8> scale <2/2,2/2,2/2> rotate z*-30 translate <0,1,6> rotate <-39,0,0> translate < 3.0,1.4,0> }
		superellipsoid { <0.6,0.8> scale <2/2,2/2,2/2> rotate z*30 translate <0,1,6> rotate <-39,0,0> translate <-3.0,1.4,0> }
		texture { DrumChromeTex }
	} // end union

#macro BassTomArm(Length)
	union {
		cylinder { <0,0,0>,<0,0,10>,0.5 }
		cylinder { <0,0,0>,<0,0,2>,0.65 }
		cylinder { <0,0,0>,<0,0,1.6>,0.65 translate <0,0,9.5> }
		difference {
			cylinder { <-0.6,0,0>,<0.6,0,0>,0.8 }
			cylinder { <-1.0,0,0>,<1.0,0,0>,0.6 }
			translate <0,0,11.5>
		} // end difference
		cylinder { <-0.45,0,0>,<0.45,0,0>,0.7 texture { BlackRubberTex } translate <0,0,11.5> }
		cylinder { <-0.50,0,0>,<0.50,0,0>,0.35 translate <0,0,11.5> }
		cylinder { <-1.80,0,0>,<1.10,0,0>,0.15 translate <0,0,11.5> }
		sphere { <0,0,0>,0.15 translate <-1.80,0,11.5> }
		superellipsoid { <.25,.25> scale <1/2,1/2,2/2> translate <1,0,12.5> }
		cylinder { <0,0,0>,<0,Length,0>,0.5 translate <1,0,12.5> }
		superellipsoid { <0.4,0.4> scale <1.8/2,2.8/2,1.8/2> translate <1,Length+1,12.5> }
		texture { DrumChromeTex }
	} // end union
#end
#declare BassTomSupport =
	union {
		superellipsoid { <0.3,0.2> scale <5/2,2.5/2,2/2> }
		object { BassTomArm(5.0) rotate z*30 translate <-1.5,0,-3> }
		sphere { <0,0,0>,1.4 scale <0.8,0.4,1> rotate x*-20 translate <1,5.8,12.5-3> rotate z*45 }
		object { BassTomArm(2.0) rotate z*-25 translate <1.5,0,-3> }
		sphere { <0,0,0>,1.4 scale <0.8,0.4,1> rotate x*-20 translate <1,3.5,12.5-3> rotate z*-50 }
		texture { DrumChromeTex }
	} // end union

//===============================================
//             Units
//===============================================

#declare HiHat =
	union {
		object { Stand(48) }
		object { CymbalS scale <1,1,0.5> translate <0,0,44> }
		object { CymbalS scale <1,1,0.5> rotate x*180 translate <0,0,40.2> }
		sphere { <0,0,0>,0.8 translate <0,0,44> texture { BlackRubberTex } }
	} // end union

#macro CymbalGroup(Height,HeadRot,ArmRot)
	union {
		object { Stand(Height) }
		object { CymbalArmGroup(HeadRot) translate <0,0,14> rotate x*-ArmRot translate <-1.2,0,Height> }
		cylinder { <-1.8,0,0>,<1,0,0>,0.62 translate <0,0,Height> texture { DrumChromeTex } }
		cylinder { <0,0,0>,<2.5,0,0>,0.25 translate <0,0,Height> texture { DrumChromeTex } }
		cylinder { <2.0,0,-1.6>,<2.0,0,1.6>,0.18 rotate x*-30 translate <0,0,Height> texture { DrumChromeTex } }
	} // end union
#end

#declare DoubleDrum =
	union {
		object { Drum(10,5.5) rotate x*-39 translate <-6,10,41> }
		object { Drum(8.2,5.5) rotate x*-39 translate < 6,8,41> }
		object { DoubleDrumArm translate <0,0,38> }
		object { CymbalGroup(47,30,60) }
	} // end union
#declare KettleDrum =
	union {
		object { Drum(16,16) translate <0,0,28> }
		cylinder { // head
			<0,0,-1>,<0,0,0>,8 translate <0,0,28.8>
			texture { DrumWhiteTex }
		}
		object { KettleLeg(20) translate <-8.6,0,0> rotate z*0 }
		object { KettleLeg(20) translate <-8.6,0,0> rotate z*120 }
		object { KettleLeg(20) translate <-8.6,0,0> rotate z*240 }
	} // end union
#declare BassDrum =
	union {
		object { Drum(22,16) rotate x*90 translate <0,0,15> } // bass
		object { BassLeg(14) rotate <-25,0,-20> translate <-13.4,-2,0> }
		object { BassLeg(14) rotate <-25,0, 20> translate < 13.4,-2,0> }
	} // end union

#declare DrumSeat =
	union {
		object { Stand(1) scale <1,1,.60> }
		cylinder { <0,0,0>,<0,0,3.5>,7 translate <0,0,17.2> }
		sphere { <0,0,0>,7 scale <1,1,0.22> translate <0,0,17.2+3.5> }
		cylinder { <0,0,4>,<0,0,18>,1 texture { DrumChromeTex} }
		texture { SeatLeatherTex }
	} // end union

//===============================================
//             Drum Set
//===============================================

#declare DrumSet = // faces -y
	union {

		object { DrumSeat translate <6.9,43,0> }
		object { BassDrum }

		object { BassTomSupport translate <0,3,26> }
		object { Drum(12.0,9.5) rotate x*-20 translate <-6,14,37> } // front L tom
		object { Drum(10.0,7.5) rotate x*-20 translate < 6,10,39> } // front R tom
		object { DoubleDrum rotate z*-50 translate <-36,22,0> }

		object { KettleDrum rotate z*0 translate <-22,22,0> }
		object { DrumStick rotate <2,0,-60> translate <-2.5,-2,28.9> translate <-22,22,0> }
		object { DrumStick rotate <2,0,-67> translate <-2.0,-2.3,28.9> translate <-22,22,0> }

		object { HiHat rotate z*-12 translate < 20,18,0> }
		object { CymbalGroup(40,30,70) rotate z*-24 translate < -20,8,0> } // cym L
		object { CymbalGroup(45,30,60) rotate z*50 translate < 37,32,0> } // crash R

	} // end union
		

//===============================================
//             Viewpoint 01
//===============================================

#if (RenderMe = 1)
global_settings {	max_trace_level 150 }
#declare TestSphere = sphere{ 0,12 pigment { color rgb<1,1,1> } }

	camera {
		perspective
		direction <0.0,     1.0,  0.0>
		sky       <0.0,     0.0,  1.0>  // Use right handed-system!
		up        <0.0,     0.0,  1.0>  // Where Z is up
		right     <1.33333, 0.0,  0.0>

		angle 34
		location  <1*Feet, -15*Feet, 5.5*Feet> // overall
		look_at <0*Feet,0*Feet,3*Feet>
//		location  <3*Feet, -1*Feet, 35*Feet> // top down
//		look_at <3*Feet,3*Feet,3*Feet>

	}

background { color rgb <0.276,0.567,0.982>*.97 } // sky blue
light_source
{ <140*Feet,-300*Feet,250*Feet>, 1.2
//  spotlight point_at <0,0*Feet,2*Feet> radius 25 falloff 36
}
light_source
{ <-140*Feet,-200*Feet,130*Feet>, <1.13,1.08,0.83>*.8
//  spotlight point_at <0,0,2*Feet> radius 25 falloff 36
}

plane { z,-0 pigment { checker rgb <1,1,1>, rgb <1,1,1>*.75 } scale 1*Feet }

//#include "GRuler.inc" // for testing only
//object { TestSphere scale 1 translate <0,0,10> }

//object { StandLeg scale 3 rotate z*0 translate <0,0,20> }
//object { StandLeg scale 3 rotate z*40 translate <12,0,20> }
//object { StandLegGroup() scale 1 rotate z*0 translate <-20,0,0> }
//object { StandLegGroup() scale 1 rotate z*0 translate <20,0,10> }
//object { Stand(48) scale 1 rotate z*0 translate <-20,0,0> }
//object { Stand(48) scale 3 rotate z*10 translate <10,0,-80> }
//object { HiHat scale 1 rotate z*10 translate <20,0,0> }
//object { CymbalGroup(Height,HeadRot,ArmRot)
//object { CymbalGroup(55,30,60) }
//object { CymbalGroup(55,30,60) rotate z*-60 translate <-40,30,0> }
//object { DoubleDrum translate <20,0,0> }
//object { DoubleDrum rotate z*-60 translate <-40,30,0> }
//object { KettleDrum scale 2 translate <-20,0,-20> }
//#object { Drum(16,16) scale 3 rotate z*0 translate <0,0,40> }
//#object { CymbalS translate <0,0,50> }
/*
#local NB=1;
#while (NB<1000)
	object { Drum(16,16) rotate z*0 translate <0,NB,40> }
	object { Drum(16,16) rotate z*0 translate <-40,NB,40> }
	object { Drum(16,16) rotate z*0 translate <40,NB,40> }
	#local NB=NB+18;
#end
*/
//object { DrumSet rotate z*-20 translate <0,0,0> }
object { DrumSet scale 1 rotate z*40 translate <45,20,0> }
//object { DrumSet rotate <30,0,0> translate <10,-10*Feet,2*Feet> }
object { DrumSet rotate z*200 translate <-60,150,0> }
#end

