
// POV-Ray Test File - Spiral Lab
// created 21-Apr-06
// last update 28-Apr-06
// Copyright 2006 Glenn McCarter (glenn@mccarters.net). Some rights reserved.
// This work is licensed under the Creative Commons Attribution License
// To view a copy of this license, visit http://creativecommons.org/licenses/by/2.0/
//
// Required #include files: "GIncludeRH.inc"
//
// Various methods to create
// helix, coils, screws, spirals
// 
//
//
// Intended scale is English system (inches)
// Uses RH coordinate reference system (Z=up)
//

#ifndef (ThisIsMaster) // If this include file was not called by another, then
	#declare RenderMe = 0; // supress self-rendering of other include files
	#declare ThisIsMaster = 1;
	#include "GIncludeRH.inc"
	// renderable sub includes go here
	#declare RenderMe = 1;
#end

//===============================================
//             Includes
//===============================================

// non-renderable sub includes go here

//===============================================
//             Variables
//===============================================


//===============================================
//             Textures
//===============================================

#declare TestWhiteTex =
	texture {
		pigment { rgb<1,1,1> }
	}

//===============================================
//             Macros
//===============================================

#macro SpiralArray(SphereCount,AnglePerSphere,Rad)
#declare Spirray=array[SphereCount]
	#local N=0;
	#while (N<SphereCount)
		#local Height=N/20;
		#local Theta=radians(N*AnglePerSphere);
		#declare Spirray[N]=<Rad*cos(Theta),Rad*sin(Theta),Height>;
		#local N=N+1;
	#end
	//#debug concat("Array has been declared!","\n")
#end

//===============================================
//             Objects
//===============================================


	#declare Rad=4;	
	#declare SphereCount=400;
	#declare AnglePerSphere=2;
	SpiralArray(SphereCount,AnglePerSphere,Rad)
//#debug concat("Value is:",str(Spirray[16].x,5,3),"\n")

#declare SpiralNote1= // why is this so damn slow?
	sphere_sweep {
		b_spline
		19,
		#declare N=0;
		#while (N<18)
			Spirray[N],1,
//			<Spirray[N].x,Spirray[N].y,Spirray[N].z>,1, // doesn't help
			#declare N=N+1;
		#end
			Spirray[18],1
		texture { TestWhiteTex }
//	bounded_by { cylinder {<0,0,-5>,<0,0,20>,5 } } // doesn't help
	}

#declare SpiralNote2= // why is this so damn slow?
	sphere_sweep {
		b_spline
		48,
		#declare Rad=4;	
		#declare AnglePerSphere=20;
		#declare N=0;
		#while (N<47)
		#local Theta=radians(N*AnglePerSphere);
		#local Height=N/4;
			<Rad*cos(Theta),Rad*sin(Theta),Height>,1,
			#declare N=N+1;
		#end
			<Rad*cos(Theta),Rad*sin(Theta),Height>,1
//			Spirray[18],1
		texture { TestWhiteTex }
//	bounded_by { cylinder {<0,0,-5>,<0,0,20>,5 } } // doesn't help
	}

#declare SpiralNote3= // renders very fast, if using many identical copies
	union {
		#declare N=0;
		#while (N<400)
			sphere {Spirray[N],1 }
			#declare N=N+1;
		#end
		texture { TestWhiteTex }
	bounded_by { cylinder {<0,0,-5>,<0,0,20>,5 } }
	} // end union

#declare SpiralNote4 =
	union {
		#declare Rad=4;	
		#declare AnglePerSphere=2;
		#declare N=0;
		#while (N<400)
			#local Theta=radians(N*AnglePerSphere);
			#local Height=N/20;
			sphere {<Rad*cos(Theta),Rad*sin(Theta),Height>,1 }
			#declare N=N+1;
		#end
		texture { TestWhiteTex }
//	bounded_by { cylinder {<0,0,-5>,<0,0,20>,5 } }
	} // end union

#declare BackboneSpline1 =
	spline {
		natural_spline
	 -0.10,<1,0,-1>
		0.00,<0,0,0>
		0.10,<-0.7,0,1.2>
		0.20,<-1.0,0,2.5>
		0.30,<-1.1,0,4.0>
		0.40,<-1.2,0,5.7>
		0.50,<-1.0,0,7.2>
		0.60,<-0.7,0,9.0>
		0.70,<-0.4,0,10.3>
		0.80,<0.2,0,11.7>
		0.90,<0.7,0,13.2>
		1.00,<1.6,0,14.4>
		1.10,<2.6,0,15.5>
	}
#declare BackboneSpline2 =
	spline {
		natural_spline
	 -0.10,<-0.3,0,-1.2>
		0.00,<0,0,0>
		0.10,<0.4,0,1.3>
		0.20,<0.7,0,2.8>
		0.30,<0.2,0,4.4>
		0.40,<-0.4,0,5.5>
		0.50,<-0.9,0,7.0>
		0.60,<-1.2,0,8.3>
		0.70,<-1.3,0,9.8>
		0.80,<-1.0,0,11.3>
		0.90,<-0.3,0,12.6>
		1.00,<0.6,0,13.4>
		1.10,<1.7,0,14.1>
	}
#declare BackboneSpline3 =
	spline {
		natural_spline
	 -0.10,<1.5,0,-0.2>
		0.00,<0,0,0>
		0.10,<-1.3,0,0.6>
		0.20,<-2.0,0,1.8>
		0.30,<-2.4,0,3.3>
		0.40,<-2.2,0,5.0>
		0.50,<-1.8,0,6.3>
		0.60,<-1.2,0,7.8>
		0.70,<-0.4,0,9.0>
		0.80,<0.4,0,10.2>
		0.90,<1.4,0,11.4>
		1.00,<2.2,0,12.8>
		1.10,<2.6,0,14.4>
	}

#declare SplineTester1=
	union {
		#declare MaxN=10;
		#local N=0;
		#while (N<MaxN)
			sphere {
				<BackboneSpline1(N/MaxN).x,BackboneSpline1(N/MaxN).y,BackboneSpline1(N/MaxN).z>,.5
			}
			#local N=N+1;
		#end
		texture { TestWhiteTex }
	} // end union
#declare SplineTester2=
	union {
		#declare MaxN=10;
		#local N=0;
		#while (N<MaxN)
			sphere {
				<BackboneSpline2(N/MaxN).x,BackboneSpline2(N/MaxN).y,BackboneSpline2(N/MaxN).z>,.5
			}
			#local N=N+1;
		#end
		texture { TestWhiteTex }
	} // end union
#declare SplineTester3=
	union {
		#declare MaxN=10;
		#local N=0;
		#while (N<MaxN)
			sphere {
				<BackboneSpline3(N/MaxN).x,BackboneSpline3(N/MaxN).y,BackboneSpline3(N/MaxN).z>,.5
			}
			#local N=N+1;
		#end
		texture { TestWhiteTex }
	} // end union

// This is John VanSickle's Reorient Macro:
#macro Reorient(Axis1,Axis2)
  #local vX1=vnormalize(Axis1);
  #local vX2=vnormalize(Axis2);
  #local vY=vnormalize(vcross(vX1,vX2));
#if (vlength(vY)>0)
  #local vZ1=vnormalize(vcross(vX1,vY));
  #local vZ2=vnormalize(vcross(vX2,vY));
  matrix < vX1.x, vY.x,vZ1.x, vX1.y,vY.y,vZ1.y, vX1.z,vY.z, vZ1.z, 0,0,0 >
  matrix < vX2.x,vX2.y,vX2.z, vY.x,vY.y, vY.z, vZ2.x,vZ2.y,vZ2.z, 0,0,0 >
#end
#end

#declare PointerCone = cone{<0,0,0>,0.5,<0,0,3>,0 texture { TestWhiteTex } }
#declare SplineCones = // use this for checking local direction within a spline
	union {
		#declare MaxN=8;
		#local N=0;
		#while (N<MaxN)
			object { PointerCone
				Reorient(<0,0,-1>,BackboneSpline1(N/MaxN)-BackboneSpline1((N+0.1)/MaxN))
				translate <BackboneSpline1(N/MaxN).x,BackboneSpline1(N/MaxN).y,BackboneSpline1(N/MaxN).z>
			}
			#local N=N+1;
		#end
		texture { TestWhiteTex }
	} // end union

#declare SplineSpiral1= // a nice increasing-diameter wire-type corkscrew
	union {
		#declare Rad=1.4;	
		#declare AnglePerSphere=10;
		#declare MaxN=240;
		#local N=0;
		#while (N<MaxN)
			#local Theta=radians(N*AnglePerSphere);
			sphere {
				<0,0,0>,0.1+N*0.005
//				translate <Rad*cos(Theta),Rad*sin(Theta),0>
				translate <(.1+N*.008)*cos(Theta),(.1+N*.008)*sin(Theta),0>
				Reorient(<0,0,-1>,BackboneSpline1(N/MaxN)-BackboneSpline1((N+0.1)/MaxN))
				translate <BackboneSpline1(N/MaxN).x,BackboneSpline1(N/MaxN).y,BackboneSpline1(N/MaxN).z>
			}
			#local N=N+1;
		#end
		texture { TestWhiteTex }
	} // end union

#declare SplineScrew1= // cylinder staircase revolving around a central spline
	union {
		#declare Rad=4;	
		#declare AnglePerSphere=10;
		#declare MaxN=240;
		#local N=0;
		#while (N<MaxN)
			#local Theta=radians(N*AnglePerSphere);
			cylinder { <0,0,0>,<Rad*cos(Theta),Rad*sin(Theta),0>,0.3
				Reorient(<0,0,-1>,BackboneSpline1(N/MaxN)-BackboneSpline1((N+0.1)/MaxN))
				translate <BackboneSpline1(N/MaxN).x,BackboneSpline1(N/MaxN).y,BackboneSpline1(N/MaxN).z>
			}
			#local N=N+1;
		#end
		texture { TestWhiteTex }
	} // end union

//===============================================
//             Test Image
//===============================================

#if (RenderMe = 1)
global_settings {	max_trace_level 150 }
#declare TestSphere = sphere{ 0,1 pigment { color rgb<1,1,1> } }

	camera {
		perspective
		direction <0.0,     1.0,  0.0>
		sky       <0.0,     0.0,  1.0>  // Use right handed-system!
		up        <0.0,     0.0,  1.0>  // Where Z is up
		right     <1.33333, 0.0,  0.0>

		angle 34
		location  < 4*Feet, -10*Feet, 6*Feet> // overall
		look_at <1*Feet,1*Feet,1.3*Feet>
//		location  <23*Feet, -224*Feet, 5235*Feet> // top down
//		look_at <30*Feet,20*Feet,18*Feet>
//		location  <3, -14*Feet, 5*Feet> // detail
//		look_at <0,0,46>
	}

background { color rgb <0.276,0.567,0.982>*.07 } // dark blue
light_source
	{ <-240*Feet,200*Feet,250*Feet>, 1.2
	//  spotlight point_at <0,0*Feet,2*Feet> radius 25 falloff 36
	}

light_source
	{ <-140*Feet,-200*Feet,130*Feet>, <1.13,1.08,0.83>*.8
	//  spotlight point_at <0,0,2*Feet> radius 25 falloff 36
	}

plane { z,-0 pigment { checker rgb <.8,.8,1.0>, rgb <.8,.8,1.0>*.75 } scale 1*Feet }

//#include "GRuler.inc" // for testing only
//object { TestSphere scale 3 translate <0,30,3> }

//object { PianoNoteGroup(20,seed(70720),3*Feet) translate <0,0,3> }
//object { SpiralNote(40,30,1,1) scale 2 translate <0,0,6> }
//object { SpiralNote3 scale 1 translate <30,30,6> }
object { SplineTester1 scale 1 rotate z*0 translate <0,0,0> }
object { SplineTester2 scale 1 rotate z*0 translate <10,0,0> }
object { SplineTester3 scale 1 rotate z*0 translate <20,0,0> }
//object { SplineCones scale 1 rotate z*90 translate <0,0,3> }
//object { SplineSpiral1 scale 1 rotate z*90 translate <0,0,3> }
//object { SplineScrew1 scale 1 rotate z*90 translate <0,30,3> }
#end

