// Persistence of Vision Ray Tracer Scene Description File
// File: bambufla.pov
// Vers: 3.6
// Desc: BambuFla intenta recrear el ambiente que quizas hubo en el momento de la inspiracion
// para construir la flauta.
// Acompaando hay un archivo mp3. Contiene una cancion interpretada en flauta, espero que os deleite.
// Date: 04/17/06
// Auth: J.L. Ferrer De E.
// E-mail: rioter56@hotmail.com
// City: Granada
// Country: Spain
// 


// Archivos Incluidos *** Include Files

#include "colors.inc"	
#include "textures.inc"	
#include "functions.inc"
#include "woods.inc"
#include "rand.inc"



// Glovales *** Glovals

global_settings {
///* 
radiosity {

brightness 1         
count 50             
error_bound 1        
gray_threshold 0.0   
low_error_factor 0.5 
minimum_reuse 0.015  
nearest_count 5      
recursion_limit 4      
adc_bailout 0.01/(18*2)   
max_sample 200
media off
normal off
always_sample 1
pretrace_start 0.16
pretrace_end 0.04

} 
//*/ 
}


// Camara *** Camera

camera {  location  <0.0, 0.0, -1.08>  look_at <0, 0, 1>
           right x*image_width/image_height}

// Sol *** Sun

light_source{<-200,  50,  1500   >   color Goldenrod }

light_source{<-10,  150,   -10   >   rgb 1*.3
    spotlight
    radius 1.5
    falloff 2
    tightness 1
    point_at <-0.1, -0.15, -0.80>
  }


// Cielo *** Sky

plane{<0,1,0>,1 hollow  
       texture{ pigment{ bozo turbulence 0.70
                         color_map { [0.5 rgb <0.20, 0.00, 0.35>]
                                     [0.6 rgb <0.40, 0.60, 0.90>]
                                     [1.0 rgb <0.80, 0.80, 0.60>]}
                       }
                finish {ambient .5 diffuse 0} }      
       scale 1000
       }


// Niebla *** Fog
///*
fog{fog_type   2
    distance   500
    color      Orange
    fog_offset 0.2
    fog_alt    5
    turbulence 1.8}
//*/


// Textura Bambu *** Texture Bamboo

#declare Bambu = 
   material  {   
      texture  {      
         pigment {
            wrinkles
            color_map {
               [ 0.0     rgbft <1.0, 1.0, 1.0, 0.0, 0.0> ]
               [ 0.085   rgbft <0.464267, 0.711376, 0.10109, 0.0, 0.0> ]
               [ 0.915   rgbft <0.517647, 0.945098, 0.313725, 0.0, 0.0> ]
               [ 1.0     rgbft <0.810764, 0.923611, 0.743056, 0.0, 0.0> ]
            }
            turbulence 1.0
            octaves 10
            omega 0.0016
            lambda 0.0015
            frequency 0.0
            phase 0.18
            poly_wave 1.018
            scale  <0.8, 0.005, 1.0>
         }      
         finish { ambient 0.1 brilliance 0.3  reflection  { 0.1 , 0.05
               fresnel  off
               falloff  1.0
               exponent 1.0
               metallic 0.0
            }
         }
      }
  }

// Flauta  *** Flute
// La construccion fue, tomando las medidas de una flauta comun
// The construction was taken measures of a commune flute 

#declare Parte_Delantera =
union {
difference {
  cylinder { <0, 0,  0.00>, <0, 0, 0.205>, 0.009 }
  cylinder { <0, 0, -0.01>, <0, 0, 0.210>, 0.007 }
  sphere { <0,0,0>,0.0045 translate  <0.006,  0.006,   0.1565 >}
  sphere { <0,0,0>,0.0055 translate  <0.0,    0.009,   0.1340 >}
  sphere { <0,0,0>,0.005  translate  <0.0,    0.009,   0.1140 >}
  sphere { <0,0,0>,0.004  translate  <0.0,    0.009,   0.0910 >}
  sphere { <0,0,0>,0.005  translate  <0.0,    0.009,   0.0650 >}
  sphere { <0,0,0>,0.005  translate  <0.0,    0.009,   0.0430 >} 
  sphere { <0,0,0>,0.005  translate  <0.0,    0.009,   0.0225 >}
  sphere { <0,0,0>,0.0055 translate  <0.0,   -0.009,   0.01575>}
}
  torus { 0.009, 0.0015 rotate 90*x translate <0.0, 0.0, 0.185>} 
}


#declare Parte_Trasera = 
union {
difference {
  cylinder { <0,     0.0,  0     >, < 0,     0,     -0.12>, 0.009  }
  cylinder { <0,     0.0,  0.01  >, < 0,     0,     -0.13>, 0.007  }
  cylinder { <0.01, -0.016, -0.12>, <-0.01, -0.016, -0.12>, 0.02   }
  box { <-0.005,  0.0, -0.071>, <0.005, 0.01, -0.075> }
  box { <-0.005,  0.0, -0.010>, <0.005, 0.01,  0.010> rotate -25*x translate <0.0, 0.007, -0.063>}
}
  box { <-0.005, 0.005, -0.0052>, <0.005, 0.0072, 0.0052> rotate -20*x translate <0.0, -0.0019, -0.064>}
}

#declare Boquilla = difference {
  cylinder { < 0,     0,     -0.12 >, < 0,     0,     -0.0749>, 0.007 }
  box      { <-0.003, 0.006, -0.123>, < 0.003, 0.009, -0.06  >        }
  cylinder { < 0.01, -0.016, -0.12 >, <-0.01, -0.016, -0.12  >, 0.02  }
 }
 
    

// Cuerpo de la Flauta  **** Body Flute
///*
union {
  object { Parte_Delantera material { Bambu scale .5} finish { phong .9}}
  object { Parte_Trasera   material { Bambu scale .5} finish { phong .6}}
  object { Boquilla        texture  { T_Wood24      }}
  rotate z*20 rotate   x*15 rotate y*-80
  translate <0.03, -0.080, -0.78>
}
//*/


//  Tierra "realizada con un snap del sonido de una flauta esta idea la tome de Sonograms escrito por
//  Paul Bourke January 1998" 
//  Land "was do it with a snap of sound from flute"
//  The idea a take from Sonograms Written by Paul Bourke January 1998 
///*
object {   
  height_field {
    tga "Suelo.tga"
    water_level 0.001
    smooth
  }
  rotate    <  0.0 , 55.0, 0.0>
  scale     <  4.00, 1.0, 1.0> 
  translate < -2.20, -0.40, -0.15> 

  texture{ pigment{ color DarkGreen}  normal { bumps 0.75 scale 0.01  } finish { phong 0.01 } }
 }
//*/


// Agua *** Water
///*
plane{ <0,1,0>, 0 
       texture{ Polished_Chrome
                normal { crackle 0.315 scale <0.35,0.25,0.25> turbulence 0.9 } 
                finish { reflection 0.30}
       }
       translate <0, -0.14, 0>
}

//*/

// Naturaleza 
// Arboles de Bambu "creo que se puede mejorar" **** Bamboo Trees 

///*
#declare X=0;

#while (X<10)
object{
union {
cylinder { <0.5,  0, 1.0>, <0.5,  1.205, 1.0 >, 0.009 }
cylinder { <0.8,  0, 1.0>, <0.75, 1.210, 0.90>, 0.007 }
cylinder { <0.1,  0, 1.0>, <0.1,  2.205, 1.0 >, 0.009 }
cylinder { <0.02, 0, 1.0>, <0.05, 2.210, 0.78>, 0.007 }
cylinder { <0.3,  0, 1.0>, <0.35, 1.505, 1.0 >, 0.009 }
cylinder { <0.15, 0, 1.0>, <0.16, 1.810, 0.94>, 0.007 }
cylinder { <0.23, 0, 1.0>, <0.22, 2.605, 1.0 >, 0.009 }
cylinder { <0.15, 0, 1.0>, <0.27, 3.210, 0.85>, 0.007 }
cylinder { <0.06, 0, 1.0>, <0.05, 1.205, 1.10>, 0.009 }
cylinder { <0.01, 0, 1.0>, <0.02, 1.510, 1.02>, 0.007 }
cylinder { <0.9,  0, 1.0>, <0.85, 1.505, 0.96>, 0.009 }
cylinder { <0.0,  0, 1.0>, <0.0,  2.210, 1.08>, 0.007 }
}
material { Bambu scale RRand(0.5, 1.2, 0.01) translate <0.0, RRand(0.5, 1.2, 0.01), 0.0> } finish { phong 0.9}
translate <RRand(0.5, 1.2, 0.01), 0.0, RRand(0.5, 1.2, 0.01)> 
translate <-0.90, -0.30, -2.00>
rotate    <0.0, -50.0, 0.0>

} 
#declare X=X+1;
#end
//*/ 

// Hoja en primer plano *** Foliage in 1er plane

plane {<0,0,1>,0.5 hollow 
    pigment {
      image_map { gif "hoja_b1.gif" transmit 0, 1 once } scale 0.3 }
    pigment {
      image_map { gif "hoja_b2.gif" transmit 0, 1 once } scale 0.3 }
    finish {ambient .28}
   rotate    <80.0, 63.0,    1.00>
   translate <-0.17, 0.363, -0.85>
}


// Hojas *** Foliage

///*
#include "Hojas.inc"        // This come from Pov-Tree 1.5  Tom Aust and Gena ObukhoV

object{TREE scale 1 translate <-0.2, -0.70,  0.0>}
object{TREE scale 1 translate <-0.2,  0.30,  0.0>}
object{TREE scale 1 translate < 0.5, -0.70,  0.0>   rotate < 0.0, 45.0, 0.0>}
object{TREE scale 1 translate < 0.5,  0.90,  0.0>   rotate < 0.0, 25.0, 0.0>}
//*/



// Sello *** Sing

text { ttf "AVGARDN.TTF", "rioter56@hotmail.com - Jose L. Ferrer *2006", 0.02, 0.0
texture{ pigment{ color rgb<1,1,1> } 
finish { diffuse 0.9 phong 0.1 ambient .25}
              }
    scale .008
    rotate z*90
    rotate y*45
    translate <0.28, 0.028, -0.65>
}

// Fin *** End

