#version unofficial megapov 1.21;

#include "colors.inc"
#include "FernLeaf.inc"

//global_settings {assumed_gamma 1.0}
//background {rgb <1,0.9,0.9>}
//camera {location <0,0,-30> look_at 0}
//light_source {<500,500,-500> color White }


//*****************************Macros below this point******************************
//***********************See end of file for required variables*********************

#macro AddLeaves(Level)
  //Place leaves along spine
  
  #if (Level = 0)
    Spine(s1, s2, s3, 1, true)
  #end

  #debug concat("Level ", str(Level, 0, 0), "\n")

  #if (Level = 0)
    #declare BranchLength = MainLength;
    #declare RandCurve = MainCurve;
    #declare RandZ = MainZ;
  #end

  #if (Level = 1)
    #local Leaf = object{FernLeaf};
    #local XVar = 0.14;
    #declare Level = 0;
  #else
    #local Leaf = object{BranchSpine rotate y*-90};
    #local XVar = 0.5;
    #declare BranchSpine = object{MainBranch};
  #end
        
  #local XVal = XVar; #local YVal = RandCurve*sqrt(XVal); #local ZVal = pow(XVal*RandZ, 2);
  #local LeafRotate1 = degrees(1/(2*sqrt(XVal)));
  #local LeafRotate2 = degrees(1/(2*sqrt(XVal + (XVar/2))));
  #local LeafScale = 1; #local ScaleCount = 1;
    
  #while (XVal <= BranchLength)
    #declare BranchSpine =
    union {
      object {BranchSpine}
      object {Leaf scale LeafScale rotate <-5, 15, LeafRotate1> translate <XVal, YVal, ZVal> texture {LeafPigment}}
      object {Leaf scale <LeafScale, LeafScale, -LeafScale> rotate <5, -15, LeafRotate2> translate <XVal + (XVar/2), YVal, ZVal> texture {LeafPigment}}
    }
    #local XVal = XVal + 2*XVar*LeafScale; #local YVal = RandCurve*sqrt(XVal); #local ZVal = pow(XVal*RandZ, 2);
    #local LeafRotate1 = degrees(1/(2*sqrt(XVal)));
    #local LeafRotate2 = degrees(1/(2*sqrt(XVal + (XVar/2))));
    #if (XVal/BranchLength > 0.5)
      #local LeafScale = 1/pow(ScaleCount, 2);
      #local ScaleCount = ScaleCount + 1/(BranchLength/(2*XVar));
      #debug "Scaling...\n"
    #end
    #debug concat("BranchLength: ", str(BranchLength, 0, 4), "    XVal: ", str(XVal, 0, 4), "\n")
  #end
  
  #declare BranchSpine = 
  union {
    object {BranchSpine}
    object {Leaf scale LeafScale rotate y*90 translate <XVal, YVal, ZVal> texture {LeafPigment}} //Add tip of fern leaf
  }
  
#end //end macro AddLeaves


#macro Spine (s1, s2, s3, Level, ShowLeaves)

  #local RandLength = (abs(rand(s1)-0.5) + 0.5)*10; //Random length of fern leaf
  #local RandCurve = rand(s2) + 1; //Random curve of fern branch
  #local RandZ = rand(s3) - 0.5; //Random z variance of fern branch
  
  #if (Level = 0)
    #declare BranchLength = RandLength;
  #else  
    #declare BranchLength = RandLength/3;
  #end 
  
  //Create spine for fern leaf
  #local XVar = 0.1; 
  #local BranchCount = 0;
  #local XVal0 = 0; #local YVal0 = 0; #local ZVal0 = 0; #local BranchScale0 = 1.1 - BranchCount/BranchLength;
  #local XVal1 = XVar; #local YVal1 = RandCurve*sqrt(XVal1); #local ZVal1 = pow(XVal1*RandZ, 2); #local BranchScale1 = 1.1 - (BranchCount + XVar)/BranchLength;
  #local XVal2 = 2*XVar; #local YVal2 = RandCurve*sqrt(XVal2); #local ZVal2 = pow(XVal2*RandZ, 2); #local BranchScale2 = 1.1 - (BranchCount + 2*XVar)/BranchLength;
  #local XVal3 = 3*XVar; #local YVal3 = RandCurve*sqrt(XVal3); #local ZVal3 = pow(XVal3*RandZ, 2); #local BranchScale3 = 1.1 - (BranchCount + 3*XVar)/BranchLength;
  
  #declare BranchSpine = 
  sphere_sweep {
    cubic_spline
    4,
    <XVal0, YVal0, ZVal0>, 0.1 * BranchScale0
    <XVal1, YVal1, ZVal1>, 0.1 * BranchScale1
    <XVal2, YVal2, ZVal2>, 0.1 * BranchScale2
    <XVal3, YVal3, ZVal3>, 0.1 * BranchScale3
    texture {SpinePigment}
  }
  
  #declare BranchCount = BranchCount + 4*XVar;
  #local XVal0 = XVal1; #local YVal0 = YVal1; #local ZVal0 = ZVal1; #local BranchScale0 = BranchScale1;
  #local XVal1 = XVal2; #local YVal1 = YVal2; #local ZVal1 = ZVal2; #local BranchScale1 = BranchScale2;
  #local XVal2 = XVal3; #local YVal2 = YVal3; #local ZVal2 = ZVal3; #local BranchScale2 = BranchScale3;
  #local XVal3 = XVal3 + XVar; #local YVal3 = RandCurve*sqrt(XVal3); #local ZVal3 = pow(XVal3*RandZ, 2); #local BranchScale3 = 1.1 - BranchCount/BranchLength;
    
  #while (BranchCount <= BranchLength)
    #local BranchCount = BranchCount + XVar;
    #declare BranchSpine =
    union {
      object {BranchSpine}
      sphere_sweep {
        cubic_spline
        4,
        <XVal0, YVal0, ZVal0>, 0.1 * BranchScale0
        <XVal1, YVal1, ZVal1>, 0.1 * BranchScale1
        <XVal2, YVal2, ZVal2>, 0.1 * BranchScale2
        <XVal3, YVal3, ZVal3>, 0.1 * BranchScale3
        texture {SpinePigment}
      }
    }
    
  
    #local XVal0 = XVal1; #local YVal0 = YVal1; #local ZVal0 = ZVal1; #local BranchScale0 = BranchScale1;
    #local XVal1 = XVal2; #local YVal1 = YVal2; #local ZVal1 = ZVal2; #local BranchScale1 = BranchScale2;
    #local XVal2 = XVal3; #local YVal2 = YVal3; #local ZVal2 = ZVal3; #local BranchScale2 = BranchScale3;
    #local XVal3 = XVal3 + XVar; #local YVal3 = RandCurve*sqrt(XVal3); #local ZVal3 = pow(XVal3*RandZ, 2); #local BranchScale3 = 1.1 - BranchCount/BranchLength;
  #end
  
  #if (Level = 0)
    #declare MainBranch = object{BranchSpine};
    #declare MainLength = BranchLength;
    #declare MainCurve = RandCurve;
    #declare MainZ = RandZ;
    #debug concat("LeafLength = ", str(MainLength, 0, 4), "\n")
  #end

  #declare Lvl = Level;
  
  #if (ShowLeaves)
    AddLeaves(Lvl)
  #end
  
#end //end macro Spine

#macro Fern(NumLeaves, ShowLeaves)

  #declare FullFern = sphere{0, 0.00001 texture {SpinePigment}}
  
  #local LeafCounter = 0;
  
  #while (LeafCounter < NumLeaves)

    #local LeafRotation = (360/NumLeaves)*(LeafCounter + 1)+10*rand(seed(6573));

    Spine(s1, s2, s3, 0, ShowLeaves)
    
    #declare FullFern =
    union {
      object{FullFern}
      object {BranchSpine rotate y*LeafRotation}
    }
    
    #local LeafCounter = LeafCounter + 1;
  
  #end
  
#end //end macro FernLeaf
 


//**********************************Variable Section********************************

//#declare LeafPigment = pigment{Green};
//#declare SpinePigment = pigment{Green};

//#declare s1 = seed(432);
//#declare s2 = seed(612);
//#declare s3 = seed(54);
  
//Fern(1, true)
  
//object {FullFern }//rotate <-90, 0, 0>}