#include "roundbox.inc"
#include "window_macro.inc"   
#declare units_feet = 12;

////////////////////////////////// House Walls /////////////////////////////////////////

#declare house_outer =
  prism{
    linear_spline
    -1,9,7
    <.5,.5>,<-22,.5>,<-22,-7.5>,<-25.5,-7.5>,<-25.5,-20.5>,<.5,-20.5>,<.5,.5>
    scale units_feet
    }
    
#declare house_inner =
  prism{
    linear_spline
    -.5,8.5,7
    <0,0>,<-21.15,0>,<-21.15,-8>,<-25,-8>,<-25,-20>,<0,-20>,<0,0>
    scale units_feet
    }
    
#declare walls =
union{
  difference{
    object{ house_outer }
    union{
      object{ house_inner }
      box{ <0,0,1> <-5,6.5,-1> translate <-5.4+2.5,0,0> scale units_feet } //doorwall cutout 
      box{ <0,0,1> <-4,3,-1> translate <-13,50/12,0> scale units_feet } //kitchen window cutout
      }
  }
  box{ <-18,-.5,-11> <-9,9,-11.4> scale units_feet } //divider_wall
  box{ <-3,-.5,-11> <.5,9,-11.4> scale units_feet } //divider_wall
  texture{ wall_tex }               
}

#declare molding_section =
difference{
  box{ <0,0,0> <1,4,-.5> }
  cylinder{ <-1,4.1,-.8> <2,4.1,-.8>, 1.73/2 }
  }

#declare baseboard_molding =
union{
  object{ molding_section scale <34.8,1,1> translate <-34.8,0,0> }
  object{ molding_section scale <12*11,1,1> rotate 90*y }
  translate .7*y
  texture{ molding_tex }
  }
  
  

////////////////////////////////// Floor ////////////////////////////////////////////////

#declare floor_width = 20;
#declare floor_depth = 12;
#declare x_count = 0;
#declare z_count = 0;
#declare s1 = seed(2883);

#declare tile_floor = union{
        #while (x_count < floor_width )
          #while (z_count < floor_depth )
            superellipsoid { 
              <.02,.1>
              rotate 90*x
              translate <-1,0,-1> 
              scale <.5,.05,.5> 
              scale units_feet 
              translate <-x_count*units_feet,0,-z_count*units_feet>
              texture { tile_tex rotate rand(s1)*360*y } 
              }
            #declare z_count = z_count+1;
          #end
          #declare z_count=0;
          #declare x_count=x_count+1;
        #end
        box{ <0,-.1,0> <-floor_width*units_feet,.565,-floor_depth*units_feet> texture{ grout_tex }}
        translate 6*z
}

///////////////////////////////// Ceiling ////////////////////////////////////////////////

#declare ceiling = box{ <0,8,0> <-25,8.1,-25> scale units_feet }

///////////////////////////////// Cabinets /////////////////////////////////////////////////


#include "cabinet_handle.inc"       

#declare cab_screw = 
difference{
  sphere{ <0,0,0>, .1 scale <1,1,.2> }
  box{ <-.04,-1,0> <.04,1,-1> }
} 
  

#declare cab_handle =
union{
 object{ cabinet_handle }
 object{ cab_screw rotate 30*z translate <1.38,0,-.1> }
 object{ cab_screw rotate -130*z translate <-1.38,0,-.1> }
 texture{ brushed }
 scale 2
 }

#declare hinge =
union{
  cylinder{ <0,0,0> <0,.8,0>, .35 }
  cylinder{ <0,.9,0> <0,1.6,0>, .35 }
  cylinder{ <0,1.7,0> <0,2.5,0>, .35 }
  cylinder{ <0,0.5,0> <0,2,0>, .3 }
  sphere{ <0,0,0>, .3 scale <1,.5,1> }
  sphere{ <0,0,0>, .3 scale <1,.5,1> translate 2.5*y }
  box{ <0,0,0> <.75,2.5,-.125> }
  translate <-.35/2,-1.25,0>
  scale <-1,1,1>
  texture{ chrome }
  }       

#declare cab_door_cutter =
union{
  cylinder{ <.038,0,-1.297> <.038,1,-1.297>, 1.235 }
  box{ <-.938,0,-.415> <1,1,-1> }
  
  }

#declare cab_round = .1;

#declare cabinet =      
union{
  prism{ //side sheet
    0,.25,7
    <0,0>,<-20.75,0>,<-20.75,4>,<-23.25,4>,<-23.25,34.5>,<0,34.5>,<0,0>
    texture{ cabinet_tex translate -10*x }
    rotate -90*x
    rotate -90*y
    translate 11.5*x
    }
  prism{ //side sheet
    0,-.25,7
    <0,0>,<-20.75,0>,<-20.75,4>,<-23.25,4>,<-23.25,34.5>,<0,34.5>,<0,0>
    texture{ cabinet_tex translate -10*x }
    rotate -90*x
    rotate -90*y
    translate -11.5*x
    }
  object{ //floor plate
    RoundBox(<-12,0,-21>,<12,4,-20.75>,cab_round)
    texture{ cabinet_tex rotate 90*y translate <0,2,21> }
    }
  object{ //bottom cross-piece
    RoundBox(<-9.5,3.75,-24>,<9.5,6.75,-23.25>,cab_round)
    texture{ cabinet_tex rotate 90*y translate <0,5,-22> }
    }
  object{ //middle cross-piece
    RoundBox(<-9.5,24.25,-24>,<9.5,27.25,-23.25>,cab_round)  
    texture{ cabinet_tex rotate 90*y translate <0,25,-22> }
    }
  object{ //top cross-piece
    RoundBox(<-9.5,32,-24>,<9.5,34.5,-23.25>,cab_round)  
    texture{ cabinet_tex rotate 90*y translate <0,25,-22> }
    }
  object{ //left vertical
    RoundBox(<-12,3.75,-24>,<-9.6,34.5,-23.25>,cab_round) 
    texture{ cabinet_tex rotate 90*x translate <-10,0,-23> }
    }
  object{ //right vertical
    RoundBox(<-12,3.75,-24>,<-9.6,34.5,-23.25>,cab_round) 
    texture{ cabinet_tex rotate 90*x translate <-10,0,-23> }
    scale <-1,1,1>
    }
  box{ //floor sheet
    <-11.4,6.3,0>,<11.4,6.48,-23.2>     
    texture{ cabinet_tex rotate 90*y translate <0,6,-10> }
    }
  box{ //ceiling sheet
    <-11.4,24.45,0>,<11.4,24.8,-23.2>     
    texture{ cabinet_tex rotate 90*y translate <0,24,-10> }
    }    
  object{ //shelf  
    RoundBox(<-11.4,17.1,-11.6>,<11.4,17.86,0>,cab_round)
    texture{ cabinet_tex rotate 90*y translate <0,17,-5> }
    }    
  object{ //drawer
    RoundBox(<-10.52,26.1,-24.82>,<10.52,34,-24.06>,cab_round)  
    texture{ cabinet_tex rotate 90*y translate <0,30,-24> }
    }
  difference{
      box{ //drawer panel
      <-10,26.6,-24.8>,<10,33.5,-25.05>
      }
      union{
        object{ cab_door_cutter scale <1,6.9,.5> translate <10,26.6,-24.77> }
        object{ cab_door_cutter scale <1,6.9,.5> translate <10,26.6,-24.77> scale <-1,1,1> }
        object{ cab_door_cutter scale <1,20,.5> rotate -90*z translate <-10,26.6,-24.78> }
        object{ cab_door_cutter scale <1,20,.5> rotate 90*z translate <10,33.5,-24.78> }
      }      
      texture{ cabinet_tex rotate 90*x translate <0,0,-24> }
    }
    
  box{ //back
    <-12,0,0>,<12,34.5,-.25>
    texture{ cabinet_tex rotate 90*y translate <0,5,-22> }
    }  
  object{ cab_handle translate <0,30,-25.05> }  
}

#declare cabinet_door =
union{ //door
    object{ //door side
      RoundBox(<-10.52,4.5,-24.82>,<-6.52,25.5,-24.06>,cab_round)  
      texture{ cabinet_tex rotate 90*x translate <-8,0,-24> }
    }
    object{ //door side
      RoundBox(<6.52,4.5,-24.82>,<10.52,25.5,-24.06>,cab_round)  
      texture{ cabinet_tex rotate 90*x translate <8,0,-24> }
    }
    object{ //door bottom
      RoundBox(<-6.52,4.5,-24.82>,<6.52,7.75,-24.06>,cab_round)  
      texture{ cabinet_tex rotate 90*y translate <0,6,-24> }
    }
    object{ //door top
      RoundBox(<-6.52,22.25,-24.82>,<6.52,25.5,-24.06>,cab_round)  
      texture{ cabinet_tex rotate 90*y translate <0,6,-24> }
    }
    difference{
      box{ //door panel
      <-6.52,7.75,-24.3>,<6.52,22.25,-24.8>
      }
      union{
        object{ cab_door_cutter scale <1,14.5,1> translate <6.52,7.75,-24.3> }
        object{ cab_door_cutter scale <1,14.5,1> translate <6.52,7.75,-24.3> scale <-1,1,1> }
        object{ cab_door_cutter scale <1,14.5,1> rotate -90*z translate <-6.52,7.75,-24.31> }
        object{ cab_door_cutter scale <1,14.5,1> rotate 90*z translate <6.52,22.25,-24.31> }
      }      
      texture{ cabinet_tex rotate 90*x translate <0,0,-24> }
    }      
    object{ cab_handle rotate 90*z translate <-8.52,21,-24.82> }
    object{ hinge translate <10.52,7.5,-24> }
    object{ hinge translate <10.52,22.5,-24> }
}

#declare wall_cabinet_door =
union{ //door
    object{ //door side
      RoundBox(<.5,55.5,-12.85>,<3.5,84.5,-12.1>,cab_round)  
      texture{ cabinet_tex rotate 90*x translate <2,0,-12> }
    }
    object{ //door side
      RoundBox(<9.67,55.5,-12.85>,<12.67,84.5,-12.1>,cab_round)  
      texture{ cabinet_tex rotate 90*x translate <14,0,-12> }
    }
    object{ //door bottom
      RoundBox(<3.5,55.5,-12.85>,<9.67,58.75,-12.1>,cab_round)  
      texture{ cabinet_tex rotate 90*y translate <0,56,-12> }
    }
    object{ //door top
      RoundBox(<3.5,81.25,-12.85>,<9.67,84.5,-12.1>,cab_round)  
      texture{ cabinet_tex rotate 90*y translate <0,83,-12> }
    }
    difference{
      box{ //door panel
        <3.5,58.75,-12.35>,<9.67,81.25,-12.85>
      }
      union{
        object{ cab_door_cutter scale <1,22.5,1> translate <3.5,58.75,-12.35> }
        object{ cab_door_cutter scale <1,22.5,1> rotate 180*z translate <9.67,81.25,-12.35> }
        object{ cab_door_cutter scale <1,6.17,1> rotate -90*z translate <3.5,58.75,-12.36> }
        object{ cab_door_cutter scale <1,6.17,1> rotate 90*z translate <9.67,81.25,-12.36> }
      }      
      texture{ cabinet_tex rotate 90*x translate <0,0,-12> }
    }
    object{ cab_handle scale .7 rotate 90*z translate <2.5,59,-12.85> }
    object{ hinge translate <12.67,58.5,-12> }
    object{ hinge translate <12.67,81.5,-12> }
}


#declare wall_cabinet =      
union{
  box{ //side plate
    <13.33,54,0>,<13.83,85,-11.25>
    texture{ cabinet_tex rotate 90*x translate <11,0,-5> }
  }
  box{ //side plate
    <-13.33,54,0>,<-13.83,85,-11.25>
    texture{ cabinet_tex rotate 90*x translate <-11,0,-5> }
  }
  object{ //right vertical
    RoundBox(<11.4,54,-12>,<14,85,-11.25>,cab_round)
    texture{ cabinet_tex rotate 90*x translate <11,0,-12> }
  }  
  object{ //left vertical
    RoundBox(<-14,54,-12>,<-11.4,85,-11.25>,cab_round)
    texture{ cabinet_tex rotate 90*x translate <-11,0,-12> }
  }
  object{ //center vertical
    RoundBox(<-1,56.85,-12>,<1,83.15,-11.25>,cab_round)
    texture{ cabinet_tex rotate 90*x translate <0,0,-12> }
  }
  object{ //bottom cross-piece
    RoundBox(<-11.33,54,-12>,<11.33,56.75,-11.25>,cab_round)
    texture{ cabinet_tex rotate 90*y translate <0,55,-12> }
  }  
  object{ //top cross-piece
    RoundBox(<-11.33,83.25,-12>,<11.33,85,-11.25>,cab_round)
    texture{ cabinet_tex rotate 90*y translate <0,84,-12> }
  }  
  box{ //bottom plate
    <-13.33,55,0>,<13.33,55.26,-11.25>
    texture{ cabinet_tex rotate 90*y translate <0,56,-6> }
  }
  box{ //rear cross-piece
    <-13.33,54,0>,<13.33,56.75,-.75>
    texture{ cabinet_tex rotate 90*y translate <0,55,-12> }
  }    
  object{ wall_cabinet_door }
  object{ wall_cabinet_door scale <-1,1,1> }
}

#declare cabinets =
union{
  object{ cabinet translate (-10.4*12-12)*x } //opened door cabinet
  object{ cabinet_door
    translate <-10.52,0,24>
    rotate -50*y
    translate <10.52,0,-24>
    translate (-10.4*12-12)*x
    }
  union{ //sink1
    object{ cabinet } 
    object{ cabinet_door scale <-1,1,1> }
    translate (-10.4*12-36)*x 
  }
  union{ //sink2
    object{ cabinet }
    object{ cabinet_door }
    translate (-10.4*12-60)*x 
  }
  union{ //sink2
    object{ cabinet }
    object{ cabinet_door }
    translate (-10.4*12-84)*x 
  }
  union{ //fridge1
    object{ cabinet scale <1,1,-1> }
    object{ cabinet_door scale <1,1,-1> }
    translate <-135,0,-11*12> 
  }
  union{ //fridge2
    object{ cabinet scale <1,1,-1> }
    object{ cabinet_door scale <-1,1,-1> }
    translate <-159,0,-11*12> 
  }
  union{ //stove
    object{ cabinet scale <.8,1,1> }
    object{ cabinet_door scale <-.8,1,1> }
    rotate -90*y
    translate <-245,0,-85> 
  }
  union{ //stove
    object{ cabinet scale <.8,1,1> }
    object{ cabinet_door scale <.8,1,1> }
    rotate -90*y
    translate <-245,0,-34> 
  }
  object{ //main
    wall_cabinet  
    translate <-10.4*12-12,0,0>
    }
  object{ //main
    wall_cabinet
    rotate -90*y  
    translate <-245,0,-80>
    }
  object{ //main
    wall_cabinet
    rotate -90*y  
    translate <-245,0,-30>
    }  
}

///////////////////////////////// Countertop ///////////////////////////////

#declare countertop_segment =
union{
  box{ <0,0,30>,<-1,1.5,-2> }
  box{ <0,.25,30>,<-1,1.25,-2.25> }
  cylinder{ <0,.25,-2>,<-1,.25,-2>, .25 }
  cylinder{ <0,1.25,-2>,<-1,1.25,-2>, .25 }
  }
  
#declare countertop =

union{
    object{ 
      countertop_segment
      scale <130,1,1>
      texture{ 
        countertop_tex rotate 92*y 
        finish{ phong .8 phong_size 5 ambient 0 diffuse .8 reflection .08 }
        scale 1
        }
      translate <-10.4*12+.25,34.5,-23>
      }
    object{ 
      countertop_segment
      scale <24*.8,1,1>
      texture{ 
        countertop_tex rotate 92*y 
        finish{ phong .8 phong_size 5 ambient 0 diffuse .8 reflection .08 }
        scale 1
        }
      rotate -90*y 
      translate <-222,34.5,-24.5>
      }
    object{ 
      countertop_segment
      scale <24*.8,1,1>
      texture{ 
        countertop_tex rotate 92*y 
        finish{ phong .8 phong_size 5 ambient 0 diffuse .8 reflection .08 }
        scale 1
        }
      rotate -90*y 
      translate <-222,34.5,-75.5>
      }
    object{ 
      countertop_segment
      scale <48,1,1>
      texture{ 
        countertop_tex rotate 92*y 
        finish{ phong .8 phong_size 5 ambient 0 diffuse .8 reflection .08 }
        scale <1,1,-1>
        }
      translate <-124,34.5,-11*12-5>
    }
}


//////////////////////////////////// Table ////////////////////////////////////

#declare table_leg =
union{
  intersection{
    superellipsoid{ 
      <.06, .06>
      translate -1*y
      scale <2,7,2>
      translate 28*y
      }
    sphere{
      <0,24,0>, 5
      }
  }  
  union{
    cone{ <0,0,0>, 1.3 <0,18.7,0>, 2.2 }
    cone{ <0,18.7,0>, 2.2 <0,20,0>, 1.3 }
    }    
  torus{ 1.3, .5 translate 5*y }  
 texture{ table_tex }
 scale <1,1,1>   
}

#declare table =
union{
  superellipsoid{ 
    <.05,.05> 
    translate -1*y 
    scale <21,1,36> 
    translate 30*y 
    }
  box{ 
    <-19,23,-1>,<19,29,1> 
    translate -33*z 
    }
  box{ 
    <-19,23,-1>,<19,29,1> 
    translate 33*z 
    }
  box{ 
    <-1,23,-34>,<1,29,34> 
    translate -18*x 
    }
  box{ 
    <-1,23,-34>,<1,29,34> 
    translate 18*x 
    } 
  object{ table_leg translate <-18,0,-33> }
  object{ table_leg translate <-18,0,33> } 
  object{ table_leg translate <18,0,-33> }  
  object{ table_leg translate <18,0,33> }
  texture{ table_tex }
}


///////////////////////////// Doorwall ////////////////////////////////////////

#declare doorwall_handle =
union{
  union{
    sphere{ <0,0,0>, .5 scale <1,6,.25> }
    cylinder{ <0,1,0> <1,1,-1>, .2 }
    cylinder{ <0,-1,0> <1,-1,-1>, .2 }
    texture{ black_enamel }
  }
  cylinder{ <1,-2.5,-1> <1,2.5,-1>, .4 scale <1,1,.5> texture{ walnut rotate 90*x scale .5 } }
}

#declare doorwall =
union{
  union{
    Window_Frame (64,100,58,94,6,molding_tex,glass_tex,12*<-5.4,2.5,0>,0,0,0)
    box{ <-95,0,0> <-35,1,6> }
    difference{
      box{ <-94,1,3.1> <-65+2,78,5> }
      box{ <-90,5,0> <-65-2,74,8> }
      }
    difference{
      box{ <-65-2,1,1> <-36,78,2.9> }
      box{ <-61,5,0> <-40,74,8> }
      }  
    texture{ molding_tex }     
    }
  box{ <-90,5,4> <-65-2,74,4.25> texture{ glass_tex } interior{ ior 1.3 } }
  box{ <-61,5,2> <-40,74,2.25> texture{ glass_tex } interior{ ior 1.3 } }
  object{ doorwall_handle translate <-38,34,1> }
}

////////////////////////////// Dining Chairs ///////////////////////////////////

#include "chair.inc"
#include "chair_cushion.inc"

#declare chair =
union{
  object{ chair texture{ table_tex } }
  object{ chair texture{ table_tex } scale <-1,1,1> }
  object{ chair_cushion texture{ cushion_tex_stripe } }
  object{ chair_ties texture{ cushion_tex } }
  rotate 180*y
  translate 15*z
    
}

#declare chairs =
union{
  object{ chair rotate -8*y translate <0,0,32> }
  object{ chair rotate 182*y translate <0,0,-32> }
  object{ chair scale <-1,1,1> rotate -99*y translate <-15,0,-16> }
  object{ chair rotate -84*y translate <-15,0,10> }
  object{ chair rotate 82*y translate <15,0,-12> }
  object{ chair rotate 89*y translate <15,0,9> }
  }

////////////////////////////////////Curtain and Rod////////////////////////////////////////////  

#include "curtain1.inc"
#include "curtain2.inc"
#include "curtain_hem.inc"

#declare curtain_rod =
union{
  cylinder{ <-101,0,0> <-29,0,0>, .15 }
  sphere{ <-101,0,0>, .6 }
  sphere{ <-29,0,0>, .6 }
  translate <0,84,-3.08>
  texture{ chrome }
  } 

#declare curtain_holder =
union{
  difference{
    cylinder{ <-.75,0,0> <.75,0,0>, .45 }
    box{ <-1,0,-1> <1,1,1> }
    }
  box{ <-.75,-.25,0> <.75,0,3> }
  box{ <-.75,-2,3> <.75,0,2.75> }
  cylinder{ <0,-2,3> <0,-2,2.75>, .75 }
  prism{
    -.2,.2,4
    <0,0>,<-3,0>,<-3,-2>,<0,0>
    rotate 90*z rotate -90*x
    }
  scale <.6,1,1>
  texture{ chrome }
}

#declare curtains =
union{
  object{ curtain_rod }
  object{ curtain_holder translate <-95-4,84,-3.08> }
  object{ curtain_holder translate <-65,84,-3.08> }
  object{ curtain_holder translate <-35+4,84,-3.08> }
  
  object{ curtain1 texture{ curtain_tex } translate <0,-50.57,.445> scale <2.5,1.65,1.65> translate <-93,84,-4.75> double_illuminate }
  object{ curtain2 texture{ curtain_tex } translate <0,-50.57,.445> scale <-2.5,1.65,1.65> translate <-39,84,-4.75> double_illuminate }
  
  object{ curtain2 texture{ curtain_tex } translate <0,-50.57,.445> scale <1.6,.73,1> translate <-157,88,-5.75> double_illuminate }
  object{ curtain_hem texture{ curtain_tex } translate <0,-50.57,.445> scale <1.6,.73,1> translate <-157,88,-5.75> double_illuminate }
  object{ curtain2 texture{ curtain_tex } translate <0,-50.57,.445> scale <1.6,.73,1> translate <-205,88,-5.75> double_illuminate }
  object{ curtain_hem texture{ curtain_tex } translate <0,-50.57,.445> scale <1.6,.73,1> translate <-205,88,-5.75> double_illuminate }
  }  

/////////////////////////////////////Deck Railing//////////////////////////////////////////////

#declare drs = 5;
#declare drs_start = 15;
#declare drs_max = 120;  
union{
  box{ <-3,33,2> <3,34.5,120> texture{ deck_tex translate <0,33,0> } }
  #while ( drs_start < drs_max )
    box{ <-.75,0,-.75> <.75,33,.75> texture{ deck_tex rotate 91*x } translate drs_start*z }
    #declare drs_start = drs_start + drs;
  #end
  }

/////////////////////////////////////Lamp//////////////////////////////////////////////////////
  
#declare chain_link =
torus{ .5,.1 rotate 90*x scale <1,2,1> }

#declare lamp_arm =
union{
  box{ <-.3,0,-10.5> <.3,2,-10> translate <-.5,-40.25,0> }
  box{ <-.3,0,-10.5> <.3,2,-10> translate <.5,-40.25,0> }
  intersection{
    torus{ 15.53, .25 rotate 90*z translate <0,14,-16.5> }
    box{ <-1,0,0> <1,14.41,-10> }
    translate <-.5,-38.5,0>
    }
  intersection{
    torus{ 15.53, .25 rotate 90*z translate <0,14,-16.5> }
    box{ <-1,0,0> <1,14.41,-10> }
    translate <.5,-38.5,0>
    } 
  }

#declare lamp_globe =
intersection{
  difference{
    sphere{ <0,8.36,0>, 13.35 }
    sphere{ <0,8.36,0>, 13 }
    }
  cylinder{ <0,-15,0> <0,5,0>, 10.1 }
  texture{ frosted_glass }
  }

#declare S1 = seed(515);
#declare y_start = -24.5;
#declare y_end = 0;
#declare step = 1;
#declare waver = .6;  
#declare lamp_cord =
  sphere_sweep {
    b_spline
    (y_end-y_start)/step+1,
    #while ( y_start < y_end )
      <waver*rand(S1)-.5,y_start+step,waver*rand(S1)-.5>, .15
      #declare y_start = y_start+step;
    #end
    tolerance 0.1
    texture{ cord_tex }
 }

  
  

#declare kitchen_lamp =
union{
  union{
    difference{ //ceiling_mount
      sphere{ <0,2.6,0>, 4 }
      box{ <-4,0,-4> <4,8,4> }
      }
    object{ chain_link rotate -30*y translate -2*y }
    object{ chain_link rotate 30*y translate -3.5*y }
    object{ chain_link rotate -30*y translate -5*y }
    object{ chain_link rotate 30*y translate -6.5*y }
    object{ chain_link rotate -30*y translate -8*y }
    object{ chain_link rotate 30*y translate -9.5*y }
    object{ chain_link rotate -30*y translate -11*y }
    object{ chain_link rotate 30*y translate -12.5*y }
    object{ chain_link rotate -30*y translate -14*y }
    object{ chain_link rotate 30*y translate -15.5*y }
    object{ chain_link rotate -30*y translate -17*y }
    object{ chain_link rotate 30*y translate -18.5*y }
    object{ chain_link scale <2,1.3,2> rotate -30*y translate -20.5*y }
    torus{ 10 .3 translate -39.3*y }
    torus{ 10 .3 translate -40*y }
    cylinder{ <0,-24.25,0> <0,-22.75,0>, 1.6 }
    cylinder{ <0,-23.85,0> <0,-23.15,0>, 1.75 }
    cylinder{ <0,-23,0> <0,-40,0>, .3 }
    object{ lamp_arm }
    object{ lamp_arm rotate 120*y }
    object{ lamp_arm rotate -120*y }
    cylinder{ <.25,-22.45,0> <-.25,-22.45,0> 1 }
    cylinder{ <.25,-1,0> <-.25,-1,0> 1 }
    
    texture{ brushed }
    }
  object{ lamp_globe translate <0,-39.5,0> }
  object{ lamp_cord }
  rotate -6*y translate <-60,103,-72> 
}
  
/////////////////////////////////////// Outlets /////////////////////////////////  


#declare outlet_cutter =
cylinder{ <0,0,-1> <0,0,1>, 1.25/2 }

#declare outlet_inner =
difference{
  cylinder{ <0,0,-.125> <0,0,.5>, 1.15/2 }
  union{
    box{ <-.07,-.125,-1> <.07,.125,1> translate <.25,.125,0> }
    box{ <-.07,-.125,-1> <.07,.125,1> translate <-.25,.125,0> }
    cylinder{ <0,-.15,-1> <0,-.15,1>, .1 }
  }
}

#declare wall_outlet =
union{
  difference{
    superellipsoid{ <.01,.3> scale <2.75/2,4.5/2,.2> }
    object{ outlet_cutter translate .8*y }
    object{ outlet_cutter translate -.8*y }
    }
  object{ outlet_inner translate .8*y }
  object{ outlet_inner translate -.8*y }
  sphere{ <0,0,0> .15 scale <1,1,.3> translate -.2*z }
  texture{ molding_tex }
}

#declare wall_switch =
union{
  difference{
    superellipsoid{ <.01,.3> scale <2.75/2,4.5/2,.2> }
    box{ <-.15,-.45,-1> <.15,.45,1> }
    }
  box{ <-.1,-.4,-.125> <.1,.4,.125> }
  box{ <-.1,-.1,-.5> <.1,.1,.2> rotate 40*x }
  sphere{ <0,1.25,0> .15 scale <1,1,.3> translate -.2*z } 
  sphere{ <0,-1.25,0> .15 scale <1,1,.3> translate -.2*z }
  texture{ molding_tex }
}

#declare outlets =
union{
  object{ wall_outlet rotate 90*y translate <0,13.5,-1.5*12> }
  object{ wall_outlet rotate 90*y translate <0,13.5,-6.75*12> }
  object{ wall_outlet translate <-140,45,0> }
  object{ wall_switch translate <-146,45,0> }
  }

///////////////////////////////Vase///////////////////////////////////////  

#if( flowers = 1 )

  #include "flowers.inc"
  #declare vase =
  union{
    union{ 
      object{ flower_bunch translate 10*y rotate 4*x scale .33 translate <0,0,.3>  }
      object{ flower_bunch translate 10*y rotate 4*x scale .33 translate <0,0,.3> rotate 60*y }
      object{ flower_bunch translate 10*y rotate 4*x scale .33 translate <0,0,.3> rotate -90*y }
      object{ flower_bunch translate 10*y rotate 4*x scale .33 translate <0,0,.3> rotate -160*y }
      }
    union{
      difference{
        difference{
          cone{ <0,0,0>, 1.6 <0,11,0>, 1.9 }
          cone{ <0,.75,0>, 1.2 <0,12,0>, 1.75 }
          }
        cylinder{ <0,0,0> <0,10,0>, 4 rotate 20*x translate 10*y }
        texture{ glass_tex }
        interior{ ior 1.5 }
        }
      difference{
        cone{ <0,.75,0>, 1.2 <0,12,0>, 1.75 }
        cylinder{ <0,9,0> <0,13,0>, 5 }
        texture{ water_tex }
        interior{ ior 1.33 }
        }
    }
    scale .75
  }
  
  object{ vase translate <-60,30,-72> }
  
#end

//////////////////////////////Drums///////////////////////////////////////

#include "functions.inc"

#declare paper_towel_rack_top =
union{
  difference{
    sphere{ <0,0,0> .8 }
    cylinder{ <.6,0,0> <1,0,0> 1 }
    texture{ pt_holder } 
    }  
  isosurface {
    function { f_helix1(x,y,z,1,90,0.08,0.125,1,2,0) }
    contained_by { box { <-1,0,-1> <1,1,1> } }
    max_gradient 2
    rotate -90*z
    texture{ chrome }
    translate .4*x 
  }
  translate .8*y
  rotate -24.5*z
  }

#declare paper_towel_rack =
union{
  cylinder{ <0,.125,0> <0,12,0>, 1.125/2 
    texture{ pt_holder rotate 90*x scale 3 }
    }  
  /*sphere{ <0,12.8,0>, .9
    texture{ pt_holder rotate 90*x scale 3 }
    }*/  
  cylinder{ <3.2,.125,0> <3.2,8,0>, .25
    texture{ pt_holder rotate 84*x translate 3.2*x scale 3 }
    }   
  sphere{ <0,0,0>, .25
    scale <1,.2,1> translate <3.2,8,0>
    texture{ pt_holder rotate 90*x scale 3 }
    }   
  difference{
    union{
      cylinder{ <0,.125,0> <0,.7,0>, 3.5 }
      torus{ 3.5, .5 translate .2*y }
      }
    cylinder{ <0,.125,0> <0,-2,0>, 5 }
    texture{ pt_holder rotate 1*x scale 3 translate -3*y }
  }
    
    
}

#include "note.inc"
#include "tape.inc"

#declare concert_note =
union{
  intersection{
    height_field {
        png "concert_note_hf.png"
        smooth
        translate <-.5,0,-.925>
        rotate -90*x
        scale <4.34,7,4.3>
        translate <0,0,2>
      }
    object{ note }
    texture{ note_tex translate -3*y }
    translate 10*y
    double_illuminate
   }
  object{
    tape
    texture{ tape_tex } 
    rotate -6*z
    translate 10*y
    }
  }

#include "pot_handle.inc"
#include "pot_handle2.inc"

#declare pot_base =
  lathe{
  	cubic_spline
  	13,
  	<0.000000,0.000000>,
  	<0.000000,0.000000>,
  	<0.662068,0.028869>,
  	<0.858379,0.240577>,
  	<0.839133,0.700560>,
  	<0.829510,0.923816>,
  	<0.841057,0.962308>,
  	<0.846831,0.954610>,
  	<0.868002,0.973856>,
  	<0.864153,0.996951>,
  	<0.837208,0.996951>,
  	<0.823736,0.960384>,
  	<0.821811,0.814113>
  	//texture{ blank }
  }

#declare fryer_base =
  lathe{
  	cubic_spline
  	12,
  	<0.000000,0.000000>,
  	<0.000000,0.000000>,
  	<0.764028,0.015753>,
  	<0.963568,0.086642>,
  	<1.031832,0.231046>,
  	<1.026581,0.483097>,
  	<1.023955,0.551361>,
  	<1.047585,0.567114>,
  	<1.037083,0.598620>,
  	<1.008202,0.588118>,
  	<1.013453,0.546110>,
  	<1.044960,0.472595>
  	texture{ copper_pan }
  }

#declare lid_base =
  lathe{
  	cubic_spline
  	20,
  	<0.003381,0.447954>,
  	<0.001690,0.451335>,
  	<0.079449,0.437812>,
  	<0.135232,0.405695>,
  	<0.130160,0.375268>,
  	<0.091281,0.348221>,
  	<0.092972,0.302581>,
  	<0.138612,0.287367>,
  	<0.155516,0.270463>,
  	<0.148755,0.243417>,
  	<0.086210,0.233274>,
  	<0.326246,0.209609>,
  	<0.711656,0.155516>,
  	<0.924646,0.101424>,
  	<1.000713,0.072687>,
  	<0.999023,0.038879>,
  	<0.983809,0.037189>,
  	<0.966905,0.040569>,
  	<0.965215,0.000000>,
  	<0.961834,-0.136922>
  	texture{ chrome }
  }
  
#declare handle =
union{
  object{ pot_handle }
  intersection{
    superellipsoid{ 
      <.4,.1>
      rotate -90*y
      scale <1,.3,.8>
      translate <-.8,-.08,0>
      }
    difference{
      cylinder{ <-2.8,-2,0> <-2.8,2,0> 3 }
      cylinder{ <-2.8,-2,0> <-2.8,2,0> 2.8 }
      }
    rotate -8*z
  }
  superellipsoid{ <1,.3> scale .1 rotate 90*y translate <.1,-.1,.59> }
  superellipsoid{ <1,.3> scale .1 rotate 90*y translate <.1,-.1,-.59> }
  rotate 8*z
  translate <0,0,0>
  } 

#declare handle2 =
union{
  object{ pot_handle2 }
  superellipsoid{ <1,.3> rotate 12*y scale .2 translate <2.25,.5,.05> }
  superellipsoid{ <1,.3> rotate -12*y scale .2 translate <-2.25,.5,.05> }
  scale .8
  translate 5*y
  texture{ brushed }
  }

#declare bass_drum = 
union{
  object{ pot_base scale <6/.82,8,6/.82> texture{ chrome2 }}
  object{ handle2 translate 5.95*z }
  object{ handle2 translate 5.95*z rotate 180*y }
  rotate -90*x 
  rotate 46*z
  translate <0,6.45,8>
  }
  
#declare tom =
union{
  object{ handle
    scale 1.6
    translate <3.5,2.8,0>
    texture{ brushed }
    }
  object{ pot_base
    texture{ copper_pot scale 1.1 } 
    scale <3.5/.82,4,3.5/.82>
    }
  rotate 180*z
  translate 8.75*y
  }
  
#declare snare =
union{
  object{ handle
    scale 1.6
    translate <5.8,1.8,0>
    texture{ brushed }
    }
  object{ fryer_base 
    scale <6/1.04,4,6/1.04> 
    }
  rotate 180*z
  translate <0,11.5,0>
  }

#declare cymbal =
  object{ lid_base 
    scale <6,6,6> 
    }

#declare drums =
union{
  
  union{
    object{ bass_drum }
    object{ concert_note scale <-1,1,1> rotate -8*z translate <-.5,2.65,-.05> }
    rotate 10*y
    }
    
  union{    
    object{ tom }
    superellipsoid{
      <1,.1>
      rotate 90*x
      scale .5*<4.25,8.5,4.25>
      translate 4.25*y
      texture{ white_plastic }
      texture{ clorox_tex }
      rotate -60*y    
      }
    rotate -120*y
    translate <20,0,14>
    }
  
  union{
    object{ snare }
    superellipsoid{
      <1,.04>
      rotate 90*x
      scale .5*<4.25,8,4.25>
      translate 4*y
      texture{ white_plastic }
      texture{ oatmeal_tex }
      scale 1.4
      rotate -70*y    
      }
    cylinder{ <0,0,0> <0,.3,0>, 3.08 texture{ tape_tex } }
    rotate -20*y
    translate <-15,0,13>
    }

  union{
    object{ cymbal translate -.8*y rotate 8*x translate 11*y }
    object{ paper_towel_rack rotate 30*y }
    rotate -50*y
    translate <12,0,1>
    }
  
  object{ paper_towel_rack_top rotate 210*y translate <23,0,1> }

  scale <-1,1,1> 
  
  rotate 56*y translate <-186,.58,-82>
  
}

#declare extra_drums =
union{
  object{ 
    tom
    rotate 90*x
    rotate 18*z
    translate 3.7*y
    scale .8
    rotate -150*y
    translate <-140,.58,-30>    
    }
  union{
    object{ snare }
    object{ cymbal rotate 180*z translate 7.8*y }
    rotate -100*y
    translate -10.1*y
    rotate 180*z
    translate <-130,6.48,-10>
  }
}

#include "spoon.inc"
#declare spoons =
object{ 
  spoon 
  texture{ spoon_tex } 
  rotate -90*y
  translate -1*z
  }

  union{  
    object{ spoons rotate 6*z translate <0,0,0> }
    object{ spoons translate .1*z rotate 50*z rotate 6*x rotate 30*y translate <2,.3,1> }
    translate <-176,.48,-85> 
    }

///////////////////////////////Kitchen Window/////////////////////////////

#declare kitchen_window =
union{
  object{ Window_Frame (52,40,47,35,6,molding_tex,glass_tex,<-15,50/12+1.5,0>*12,0,1,1) }
  superellipsoid{ <.05,.1> scale <24,.25,2.5> translate <-15,50.5/12,-.2>*12 texture{ molding_tex } }
  }

///////////////////////////////Picture//////////////////////////////////// 
 
#include "picture_frame_macro.inc"

#declare picture =
union{ 
  object{ pic_frame(20,15,"pic1.jpg",3,3,.6,matte,molding_tex) scale 1 rotate 90*y translate <0,54,-90> }
  object{ pic_frame(20,15,"pic2.jpg",3,3,.6,matte,molding_tex) scale 1 rotate 90*y translate <0,54,-40> }
}

///////////////////////////////Fridge/////////////////////////////////////

#declare fridge =
union{
  union{
    superellipsoid{
      <.05,.05>
      scale .5*<36,70,25>
      translate <0,35,-13>
      }
    superellipsoid{
      <.05,.05>
      scale .5*<17.5,68,1.5>
      translate <-9,36,-25.6>
      }
    superellipsoid{
      <.05,.05>
      scale .5*<17.5,68,1.5>
      translate <9,36,-25.6>
      }
    texture{ cabinet_tex }    
  }
    superellipsoid{  
      <.1,.05>
      scale .5*<2,36,3>
      translate <3,43,-25.6>
      texture{ black_plastic }
      }  
    superellipsoid{  
      <.1,.05>
      scale .5*<2,36,3>
      translate <-3,43,-25.6>
      texture{ black_plastic }
    }
    rotate 180*y
    translate <-195,0,-11*12>
    
}

#declare stove = 
union{
    superellipsoid{
      <.05,.05>
      scale .5*<30,38,22>
      translate <0,19,-11> 
      texture{ cabinet_tex }
      }
    superellipsoid{
      <.05,.05>
      scale .5*<30,30,2>
      translate <0,21,-23.25>
      texture{ cabinet_tex }
      }
    superellipsoid{
      <.3,.05>
      scale .5*<26,16,.5>
      translate <0,22,-25>
      texture{ grey_plastic }
      }
    superellipsoid{
      <.1,.1>
      scale .5*<26,1.5,2>
      translate <0,33,-25>
      texture{ black_plastic }
      }      
    rotate -90*y
    translate <-245,0,-60>

    }
    
//////////////////////////////////Faucet/////////////////////////////////

#include "faucet.inc"
object{
  faucet
  texture{ chrome }
  rotate -90*y
  translate <-175,34,-10>
  }

/////////////////////////////////Kitchen Window Plant/////////////////////////////
  
#include "random_plant.inc"

#declare rand_plant =
union{
  object{ 
    random_plant 
    texture{ stalk_tex } 
    translate 1.5*y
    }
  lathe{
  	cubic_spline
  	11,
  	<0.000000,-0.005858>,
  	<0.008788,0.000000>,
  	<0.509677,0.008788>,
  	<0.588765,0.070300>,
  	<0.720578,0.726437>,
  	<0.790879,0.785020>,
  	<0.808454,0.899258>,
  	<0.820170,0.990063>,
  	<0.773304,0.978346>,
  	<0.755728,0.834816>,
  	<0.770374,0.682499>
  	texture{ gloss_blue }
  	scale 4
  }
  translate <-13.8,51/12,-.17>*12
}

//////////////////////////////////Mixer///////////////////////////////////////////

#declare mixer =  
union{
  union{
    cylinder{ <2,12,0> <10,12,0>, 2.5 }
    sphere{ <2,12,0>, 2.5 }
    sphere{ <10,12,0>, 2.5 }
    cylinder{ <10,12,0> <10,10,0>, 2.5 }
    box{ <3,0,-1.5> <4,12,1.5> }
    cylinder{ <10,12,0> <13,12,0>, .6 }
    cylinder{ <2,0,0> <2,.5,0>, 3 }
    cylinder{ <10,0,0> <10,.5,0>, 3 }
    box{ <2,0,-3> <10,.5,3> }
    texture{ red_enamel }
    }
  union{
    lathe{
	cubic_spline
	16,
	<0.000000,0.001767>,
	<0.001767,0.000000>,
	<0.143117,0.001767>,
	<0.296836,0.005301>,
	<0.318039,0.040638>,
	<0.321572,0.164320>,
	<0.394015,0.212026>,
	<0.492960,0.303904>,
	<0.565402,0.424051>,
	<0.614875,0.553034>,
	<0.646679,0.701452>,
	<0.666114,0.844569>,
	<0.674949,0.989453>,
	<0.697918,0.985920>,
	<0.687317,0.959417>,
	<0.613108,0.945281>
    	scale <7,7,7>
    	translate <10,.5,0>    	
    }
    cylinder{ <13,12,0> <13.1,12,0>, .6 }
    cylinder{ <10,10,.5> <10,2,.5>,.15 }
    cylinder{ <10,10,-.5> <10,2,-.5>,.15 }
    cylinder{ <10,10,0> <10,9.75,0>, 2 }
    texture{ chrome }
  }
  union{
    cylinder{ <2,0,0> <2,.6,0>, 2.6 }
    cylinder{ <10,0,0> <10,.6,0>, 2.6 }
    box{ <2,0,-2.6> <10,.6,2.6> }
    translate 10.7*y
    texture{ chrome }
    }

  rotate 90*y
  translate <-138,34,-10>
}

/////////////////////////Soap Bottle///////////////////////////////////

#declare soap_bottle =
union{
  difference{
    merge{
      superellipsoid{
        <.1,.1> scale .5*<2,8,2>
        translate 4*y
        }
      superellipsoid{
        <1,.2> rotate 90*x scale .5*<1.2,2,1.2>
        translate 8*y
        }  
    }
    union{
      superellipsoid{
        <.1,.1> scale .5*<2,7.5,2>
        translate 4*y
        }
      superellipsoid{
        <1,.2> rotate 90*x scale .5*<1.2,3,1.2>
        translate 8*y
        }
      scale <.8,1,.8>  
    }  
    texture{ glass_tex2 }
    interior{ ior 1.5 }
    }
  difference{  
    superellipsoid{
      <.1,.1> scale .5*<2.01,7.5,2.01>
      translate 3.75*y
      }
    cylinder{ <0,7,0> <0,10,0>, 3 }
    texture{ soap_tex }
    interior{ ior 1.4 }
    }
  union{
    cylinder{ <0,0,0> <0,.3,0>, .3 }
    cylinder{ <0,0,0> <0,1.5,0>, .15 }
    translate 8.7*y
    texture{ chrome }
    }
  translate <-163,36,-10>
}

///////////////////////////////Paper Towel Roll/////////////////////////////////////

#include "ptowel.inc"

#declare ptowel_roll =
union{
  object{ ptowel texture{ ptowel_tex } }
  difference{
    cylinder{ <0,4,-5.5> <0,4,5.5>, 4 }
    cylinder{ <0,4,-6> <0,4,6>, 1.3 }
    texture{ ptowel_tex }
    }
  difference{
    cylinder{ <0,4,-5.51> <0,4,5.51>, 3.99 }
    cylinder{ <0,4,-6> <0,4,6>, 1.3 }
    texture{ ptowel_tex2 }
    }
    difference{
    cylinder{ <0,4,-5.5> <0,4,5.5>, 1.3 }
    cylinder{ <0,4,-6> <0,4,6>, 1.2 }
    texture{ cardboard }
    }
    scale .8
    translate .58*y
    rotate 40*y
    translate <-180,0,-40>
  }
  
///////////////////////////Soccer Ball/////////////////////////////////////////////

#include "soccer1.inc"
#include "soccer2.inc"

#declare soccer_ball =
union{
  object{ soccer1 texture{ black_plastic } }
  object{ soccer2 texture{ white_plastic } }
  translate <-15,.58,-86>
  }

///////////////////////////////Dust//////////////////////////////////////////////  
  
#declare dust =
box{ <-200,0,6> <1,8.1*12,-10*12> 
     pigment { rgbt 1 } hollow
     interior{ 
       media{ 
         scattering { 1, .001 }  //1, .001
         intervals 10 //10
         }
     }
}