#macro pic_frame(pic_width,pic_height,pic_name,matte_w,frame_w,frame_thk,matte_tex,frame_tex)

#local clipper =
plane{ <0,-1,0> 0 }

#local frame_piece =
prism{
	cubic_spline
	-.5,
	.5,
	27,
	<0.226319,0.004115>,
	<0.411489,0.004115>,
	<0.720105,0.004115>,
	<1.172743,0.004115>,
	<1.174800,0.061723>,
	<1.119249,0.076125>,
	<1.086330,0.059666>,
	<1.051354,0.125504>,
	<0.989630,0.187227>,
	<0.901160,0.211917>,
	<0.808575,0.199572>,
	<0.740680,0.160481>,
	<0.707761,0.150193>,
	<0.689244,0.152251>,
	<0.668669,0.096700>,
	<0.635750,0.082298>,
	<0.580199,0.072011>,
	<0.520533,0.078183>,
	<0.471155,0.106987>,
	<0.409431,0.144021>,
	<0.335363,0.121389>,
	<0.302444,0.051436>,
	<0.277755,0.074068>,
	<0.222204,0.049379>,
	<0.226319,0.004115>,
	<0.411489,0.004115>,
	<0.720105,0.004115>
	rotate 90*z rotate 180*y
	translate -.226*y
}

//#declare frame =
union{
    object{ //top frame 
      frame_piece 
      scale <pic_width+2*matte_w+2*frame_w,frame_w,frame_thk/.21>
      translate (pic_height/2+matte_w)*y
      clipped_by{ plane{ <0,-1,0> 0 rotate 45*z translate <pic_width/2+matte_w+frame_w,pic_height/2+matte_w+frame_w,0> }}
      clipped_by{ plane{ <0,-1,0> 0 rotate -45*z translate <-pic_width/2-matte_w-frame_w,pic_height/2+matte_w+frame_w,0> }}
      texture{ frame_tex }
      }
    object{ //bottom frame
      frame_piece 
      scale <pic_width+2*matte_w+2*frame_w,frame_w,frame_thk/.21>
      translate (pic_height/2+matte_w)*y
      clipped_by{ plane{ <0,-1,0> 0 rotate 45*z translate <pic_width/2+matte_w+frame_w,pic_height/2+matte_w+frame_w,0> }}
      clipped_by{ plane{ <0,-1,0> 0 rotate -45*z translate <-pic_width/2-matte_w-frame_w,pic_height/2+matte_w+frame_w,0> }}
      rotate 180*z
      texture{ frame_tex }
      }
    object{ //right piece
      frame_piece 
      scale <pic_height+2*matte_w+2*frame_w,frame_w,frame_thk/.21>
      translate (pic_width/2+matte_w)*y
      clipped_by{ plane{ <0,-1,0> 0 rotate 45*z translate <pic_height/2+matte_w+frame_w,pic_width/2+matte_w+frame_w,0> }}
      clipped_by{ plane{ <0,-1,0> 0 rotate -45*z translate <-pic_height/2-matte_w-frame_w,pic_width/2+matte_w+frame_w,0> }}
      rotate -90*z
      texture{ frame_tex }
      }
    object{ //right piece
      frame_piece 
      scale <pic_height+2*matte_w+2*frame_w,frame_w,frame_thk/.21>
      translate (pic_width/2+matte_w)*y
      clipped_by{ plane{ <0,-1,0> 0 rotate 45*z translate <pic_height/2+matte_w+frame_w,pic_width/2+matte_w+frame_w,0> }}
      clipped_by{ plane{ <0,-1,0> 0 rotate -45*z translate <-pic_height/2-matte_w-frame_w,pic_width/2+matte_w+frame_w,0> }}
      rotate 90*z
      texture{ frame_tex }
      }
    box{ //picture
      <-pic_width/2,-pic_height/2,0> <pic_width/2,pic_height/2,-.01> 
      texture{
        pigment{
          image_map{
            jpeg pic_name
            interpolate 2
          }
          translate -.5
          scale <pic_width,pic_height,1>    
        }
      }
    }
    
    difference{ //matte
      box{ <-pic_width/2-matte_w,-pic_height/2-matte_w,0> <pic_width/2+matte_w,pic_height/2+matte_w,-.02> texture{ matte_tex } }
      box{ <-pic_width/2,-pic_height/2,.1> <pic_width/2,pic_height/2,-.2> }
      }
    
    difference{ //white_rim_matte
      box{ <-pic_width/2,-pic_height/2,0> <pic_width/2,pic_height/2,-.03> }
      box{ <-pic_width/2+(matte_w*.05),-pic_height/2+(matte_w*.05),.1> <pic_width/2-(matte_w*.05),pic_height/2-(matte_w*.05),-.2> }
      texture{
        pigment{ color rgb 1 }
        finish{ ambient .1 diffuse .9 }
        }
      }
      
    box{ 
      <-pic_width/2-matte_w-frame_w,-pic_height/2-matte_w-frame_w,-.04> 
      <pic_width/2+matte_w+frame_w,pic_height/2+matte_w+frame_w,-.1>
      hollow
      interior{ ior 1.1}
      texture{
        pigment{ rgbf 1 }
        finish{
          reflection .1
          specular .5
          roughness 0.0003
        }
      }
}
      
    
}

#end 