#include "colors.inc"
#include "Woods.inc"
#include "stones1.inc"


#declare blank =
texture{
  pigment{ color rgb .9 }
  finish{ ambient .5 diffuse 1.5 }
}
  
#declare old_tile_tex =
  texture{ 
  pigment{ color rgb <.9,.87,.8> } 
  finish{ 
    ambient 0 
    diffuse .9 
    reflection{ 0, .04 } 
    specular .1 
    roughness .6 
  } 
  normal{ 
    average 
    normal_map 
      { 
        [ .5 wrinkles .3 scale 20 ]
        [ .5 bumps .01 scale .3 ]
        [ .5 agate .13 turbulence .18 scale 6 ]
        }
      scale <3,1,1> 
      } 
  }

#declare tile_tex =
texture{
  average
  texture_map{
    [0.6 old_tile_tex ]
    [0.4 T_Stone1 scale 8 ]
    }
}
  

#declare grout_tex =
texture{
  pigment{ color rgb .8 }
  finish{ 
    specular .2 
    roughness 5 
    ambient 0
    diffuse .8
    }
  }
  
#declare ceiling_tex =
texture{
  pigment{ color rgb 1 }
  finish{ 
    //specular .9 
    //roughness 5 
    ambient 0
    diffuse .9
    }
  }
  
#declare wall_tex =
texture{
  pigment{ color rgb <108/255,43/255,32/255> }
  finish{
    ambient 0
    diffuse .8
    specular .2
    roughness .5
    }
  normal{ bumps .09 scale .15 }
}

#declare molding_tex =
texture{
  pigment{ color rgb 1 }
  finish{
    phong .8
    phong_size 10
    ambient 0
    diffuse .9
    }
}

#declare glass_tex =
texture{
  pigment{ rgbf <.99,.99,.99,.998> }
  finish{
    reflection .2
    specular .7
    roughness 0.0005
    }
}

#declare frosted_glass =
texture{
  pigment{ rgbf <.99,.99,.99,.16> }
  finish{
    ambient .3
    diffuse .8
    specular .9
    roughness 0.5
    reflection .1
    }
}

#declare water_tex =
texture{
  pigment{ rgbf <.95,.98,1,.999> }
  finish{
    reflection .2
    specular 1
    roughness 0.001
    }
}

#declare walnut   =         
    texture { 
      pigment { color rgb <0.25, 0.16, 0.12 >* 0.5 }
      finish{ ambient .6 diffuse .9 phong .4 phong_size 8 }
      normal{ granite .1 scale 1 }
      scale .2
      }
      
#declare clearcoat =
  texture{
    pigment{ color rgbt 1 }
    finish{ specular .95 roughness .01 }
    }

#declare cabinet_tex =
texture{
  pigment{ color rgb 1 } //<239/255,231/255,222/255> }
  finish{ phong .95 phong_size 30 ambient 0 diffuse .9 }
  normal{ wood .03 turbulence .15 rotate 4*x scale .5 }
  }
  
#declare chrome =
texture{
  pigment{ color rgb <255/255,255/255,240/255> }
  finish{ ambient 0 diffuse .4 specular .9 roughness .06 reflection .4 metallic }
  //normal{ bumps .01 scale .02 }
  }
  
#declare chrome2 =
texture{
  pigment{ color rgb <255/255,255/255,240/255> }
  finish{ ambient 0 diffuse .4 specular .9 roughness .06 reflection .2 metallic }
  //normal{ bumps .01 scale .02 }
  }
  
#declare brushed =
texture{
  pigment{ color rgb <255/255,255/255,247/255> }
  finish{ ambient 0 diffuse .25 specular .9 roughness .1 reflection .2 metallic brilliance .9 conserve_energy }
  normal{ wrinkles .3 scale .05 }
  }
  
#declare steel =
texture{
  pigment{ color rgb <255/255,255/255,240/255> }
  finish{ ambient 0 diffuse .3 specular .9 roughness .1 reflection .3 metallic }
  normal{ wrinkles .1 scale 1 }
  }
  
#declare brass =
texture{
  pigment{ color rgb <140/255,85/255,51/255> }
  finish{ ambient 0 diffuse .2 specular .5 roughness .02 reflection .6 metallic }
  normal{ wrinkles .1 scale 1 }
  }
  
#declare countertop_tex =
texture{ T_Stone10 scale 1.2 finish{ reflection .1 } }

#declare table_tex = 
texture{ walnut } 
texture{ clearcoat }

#declare curtain_tex =
texture{
  pigment{ color rgbt <239/255,230/255,220/255,.15> }
  finish{ ambient 0 diffuse .9 roughness 100 }
  normal{ quilted .2 turbulence .1 scale .5 }
  }

#declare cushion_tex =
texture{
  pigment{ color rgb 1 }
  finish{ ambient 0 diffuse .8 roughness 100 }
  normal{ quilted .2 turbulence .1 scale .5 }
  }

#declare cushion_tex_stripe =
texture{
  pigment{ 
    gradient x
    color_map{
      [.05 color rgb 1]
      [.05 color rgb <108/255,43/255,32/255>] //wall color
      [.35 color rgb <108/255,43/255,32/255>] //wall color
      [.35 color rgb 1]
      [.40 color rgb <.1,.1,.55>] //gloss blue
      [.45 color rgb <.1,.1,.55>] //gloss blue
      [.45 color rgb 1]
      [.50 color rgb 1]
      [.50 color rgb <172/255,34/255,34/255>] //reddish
      [.70 color rgb <172/255,34/255,34/255>] //reddish
      [.70 color rgb <0/255,128/255,34/255>] //green
      [.80 color rgb <0/255,128/255,34/255>] //green
      [.80 color rgb 1]
      [.85 color rgb 1]
      [.85 color rgb <.1,.1,.55>] //gloss blue
      [.90 color rgb <.1,.1,.55>] //gloss blue
      [.90 color rgb <108/255,43/255,32/255>] //wall color
      }
  }
  finish{ ambient 0 diffuse .8 roughness 100 }
  //normal{ quilted .2 turbulence .1 scale .5 }
  scale 2
}
  
#declare deck_tex =
texture{
  average
  texture_map{
    [0.05 walnut ]
    [0.95 blank ]
    }
}

#declare black_enamel =
texture{
  pigment{ color rgb .1 }
  finish{ phong .9 phong_size 120 reflection .2 }
  }
  
#declare cord_tex =
texture{
  pigment{ color rgbf <.15,.15,.15,.4> }
  finish{ ambient .1 diffuse .9 phong .9 phong_size 30 }
  }
  
#declare petal_tex =
texture{
  pigment{ color rgb <240/255,193/255,247/255> }
  finish{ ambient .1 diffuse .9 }
  }
  
#declare stalk_tex =
texture{
  pigment{ color rgb <96/255,141/255,33/255> }
  }
  
#declare anther_tex =
texture{
  pigment{ color rgb <84/255,41/255,11/255> }
  }
  
#declare filament_tex =
texture{
  pigment{ color rgb <235/255,243/255,216/255> }
  }
  
#declare matte =
texture{
  pigment{ color rgb <179/255,149/255,117/255> }
  finish{ ambient 0 diffuse .4 }
  }

#declare pt_holder =
texture{
  T_Wood7
  finish{ phong .7 phong_size 30 reflection .1 ambient 0 diffuse .7 }
  normal{ wood .1 turbulence .2 scale .1 }
  scale .8
  rotate 8*x
  }
  
#declare black_plastic =
texture{
  pigment{ color rgb .15 }
  finish{ ambient .1 diffuse .9 phong .9 phong_size 30 }
  }
  
#declare grey_plastic =
texture{
  pigment{ color rgb .4 }
  finish{ ambient .1 diffuse .9 phong .9 phong_size 30 }
  }

#declare white_plastic =
texture{
  pigment{ color rgb 1 }
  finish{ ambient 0 diffuse .9 phong .9 phong_size 30 }
  }

#declare gloss_blue =
texture{
  pigment{ color rgb <.1,.1,.55> }
  finish{ ambient 0 diffuse .9 phong .9 phong_size 30 reflection .2 }
  }
  
#declare red_enamel =
texture{
  pigment{ color rgb <.6,.1,.1> }
  finish{ ambient 0 diffuse .6 phong .9 phong_size 30 }
  }

#declare glass_tex2 =
texture{
  pigment{ rgbf <.99,.99,.99,.998> }
  finish{
    reflection .2
    specular 1
    roughness 0.001
    }
  normal{ bumps .2 scale 1 }
}

#declare soap_tex =
texture{
  pigment{ rgbf <83/255,199/255,255/255,.85> }
}

#declare clorox_tex =
  texture{
    pigment{
      image_map{
        jpeg "clorox.jpg"
        map_type 2
        once
        }
       scale <-1,1,1>
       scale 7.5
       translate .5*y
       }
    finish{ ambient 0 diffuse .9 phong .3 phong_size 30 }
  }
  
#declare oatmeal_tex =
  texture{
    pigment{
      image_map{
        jpeg "oatmeal.jpg"
        map_type 2
        once
        }
       scale <-1,1,1>
       rotate 180*z
       scale 7.5
       translate 7.5*y
       }
    finish{ ambient 0 diffuse .9 phong .3 phong_size 30 }
  }
  
#declare note_tex =
  texture{
    pigment{
      image_map{
        gif "concert_note.gif"
        transmit 41, 1
        once
        }
       translate -.5
       scale <4.3,7,4.3>
       }
    finish{ ambient 0 diffuse 1.2 }
    normal{ wrinkles .15 scale 1.5 }
  }
  
#declare tape_tex =
  texture{
    pigment{ color rgbt <1,1,1,.4> }
    finish{ ambient .1 diffuse .8 phong .9 phong_size 1 }
  }
  
#declare spoon_wood =
  texture{
    T_Wood23
    finish{ ambient 0 diffuse .95 }
    //normal{ granite .3 scale 1 }
    rotate 90*y rotate 3*z 
    }

#declare spoon_plain =
texture{
  pigment{ color rgb <226/255,210/255,173/255> }
  finish{ ambient 0 diffuse .95 }
  normal{ granite .3 scale 1 }
  }

#declare spoon_tex =
texture{
  average
  texture_map{
    [0.6 spoon_wood ]
    [0.4 spoon_plain ]
    }
}
    
#declare ptowel_tex =
  texture{
    pigment{ color rgb 1 }
    finish{ ambient 0 diffuse .9 }
    normal{ 
      average
      normal_map{
        [0.5 quilted .2 scale 2 rotate 45*y ]
        [0.5 quilted .2 scale 1 ]
        }
      }
    }
    
#declare ptowel_tex2 =
  texture{
    pigment{ color rgb 1 }
    finish{ ambient 0 diffuse .9 }
    normal{ wood .3 scale .08 translate 4*y }
    }
    
#declare cardboard =
  texture{
    pigment{ color rgb <183/255,158/255,85/255> }
    finish{ ambient 0 diffuse .8 }
    }
    
    

//////////////Brushed Metal Texture by Rune S. Johansen//////////////////////

   #declare brushed_depth = 15; // Bump size
   #declare copper_pigment = pigment { colour rgb <242/255,159/255,132/255> }
   #declare copper_finish = finish{ ambient 0 diffuse .95 specular .9 roughness .01 phong .9 phong_size 15 brilliance 1 metallic }
   
   #declare brushed_copper =
   texture {
      average
      texture_map {
         [
            pigment {copper_pigment}
            normal {wood +brushed_depth ramp_wave rotate 90*x scale 2 }
            finish {copper_finish}
         ]
         [
            pigment {copper_pigment}
            normal {wood -brushed_depth ramp_wave rotate 90*x scale 2 }
            finish {copper_finish}
         ]
      }
   }

   #declare brushed_steel =
   texture {
      average
      texture_map {
         [
            pigment { color rgb 1 }
            normal {wood +brushed_depth ramp_wave rotate 90*x scale 2 }
            finish {copper_finish}
         ]
         [
            pigment { color rgb 1 }
            normal {wood -brushed_depth ramp_wave rotate 90*x scale 2 }
            finish {copper_finish}
         ]
      }
   }
  
#declare copper_pot =
texture{
  gradient y
    texture_map{
      [0.0 brushed_copper ]
      [0.2 brushed_copper ]
      [0.2 chrome ]
      [1.0 chrome ]
    }
}

#declare copper_pan =
texture{
  gradient y
    texture_map{
      [0.0 brushed_copper ]
      [0.15 brushed_copper ]
      [0.15 chrome ]
      [1.0 chrome ]
    }
}

  
////////////////////////////////////////////////////////////////////////////  