// Copyright (C) 2006 by Christian Frschlin

#declare TONEC  = 0;
#declare TONECs = 1;
#declare TONED  = 2;
#declare TONEDs = 3;
#declare TONEE  = 4;
#declare TONEF  = 5;
#declare TONEFs = 6;
#declare TONEG  = 7;
#declare TONEGs = 8;
#declare TONEA  = 9;
#declare TONEAs = 10;
#declare TONEB  = 11;

#declare FREQA3 = 440;

#declare FREQFACTORHALFTONE = pow(2, 1/12);

#declare TONEFREQ = function(tone, octave)
{
  FREQA3 * pow(FREQFACTORHALFTONE, octave*12 + tone - 45)
}

#macro TONENAME(tone)
  #switch (tone)
    #case (TONEC)  "C"  #break
    #case (TONECs) "C#" #break
    #case (TONED)  "D"  #break
    #case (TONEDs) "D#" #break
    #case (TONEE)  "E"  #break
    #case (TONEF)  "F"  #break
    #case (TONEFs) "F#" #break
    #case (TONEG)  "G"  #break
    #case (TONEGs) "G#" #break
    #case (TONEA)  "A"  #break
    #case (TONEAs) "A#" #break
    #case (TONEB)  "B"  #break
  #end
#end

// Return Wave length in meters
#declare WAVE_LENGTH = function(tone, octave, sonicspeed)
{
  sonicspeed / TONEFREQ(tone, octave)   
}
