//Render with +w4096 +h2304 -A

#declare image_width_Old = 4096;

#declare sr = 1462;
#declare er = 2304;
#declare sc = 379;
#declare ec = 1989;
#declare mask_blur = 20;

global_settings {assumed_gamma 2.2}

camera {
        orthographic
        location <0,0,-2>
        look_at 0
        right x*image_width
        up y*image_height
}

#declare image_ratio = image_width/image_height;
#declare image_height_Old = image_width_Old/image_ratio;
#declare mosaic_pixel = image_width_Old/image_width;
#declare pixels = mosaic_pixel*mosaic_pixel;
#if (sr = 1) #declare sr_ = 1-mask_blur; #else #declare sr_ = sr; #end
#if (sc = 1) #declare sc_ = 1-mask_blur; #else #declare sc_ = sc; #end
#if (er = image_height_Old) #declare er_ = image_height_Old+mask_blur; #else #declare er_ = er; #end
#if (ec = image_width_Old) #declare ec_ = image_width_Old+mask_blur; #else #declare ec_ = ec; #end

box {
        <-1,-1,0.1> <1,1,0>
        pigment {
                boxed 
                color_map {
                        [0                    rgb 0]
                        [mask_blur/(er_-sr_)  rgb 1]
                }
        }
        finish {ambient 1 diffuse 0}
        scale 0.5
        scale <ec_-sc_,er_-sr_,1>
        translate <sc-image_width_Old*0.5+(ec-sc)*0.5+((ec_-sc_)-(ec-sc))*0.5,-sr+image_height_Old*0.5-(er-sr)*0.5-((er_-sr_)-(er-sr))*0.5,0>
}

