/*
This is the source for postprocessing outpour.png within the IRTC rules. 
It inserts a seperate image part, applies some color correction and downscales the original render.

To use this source, you have to adjust only "image_width_factor" to the original resolution of outpour.png.
 
This small file becomes very memory intensive, when rendering!

Render with +w1024 +h576 -A
*/

#declare image_width_factor = 4;
#declare saturation      = 1.1;
#declare g_red           = 1.1;
#declare g_green         = 1.0;
#declare g_blue          = 1.0;   

global_settings {assumed_gamma 2.2}

camera {
        orthographic
        location <0,0,-2>
        look_at 0
        right x*image_width
        up y*image_height
}

#declare image_width_Old = image_width*image_width_factor;
#declare image_ratio = image_width/image_height;
#declare image_height_Old = image_width_Old/image_ratio;
#declare mosaic_pixel = image_width_factor;
#declare pixels = mosaic_pixel*mosaic_pixel;

#declare pig_map = function {pigment {image_map {png "outpour"} translate -0.5 scale <image_width_Old,image_height_Old,1>}}            
#declare mask_map = function {pigment {image_map {tga "mask_outpour"} translate -0.5 scale <image_width_Old,image_height_Old,1>}}        
#declare part_map = function {pigment {image_map {png "outpour_part"} translate -0.5 scale <image_width_Old,image_height_Old,1>}}        

#declare nx = 0;
#while (nx < image_width)
        #declare ny = 0;
        #while (ny < image_height)
                #declare color_sum = 0;
                #declare mx = 0;
                #while (mx < mosaic_pixel)                        
                        #declare my = 0;
                        #while (my < mosaic_pixel)                
                                #declare X = mx+nx*mosaic_pixel-image_width_Old*0.5+0.5;
                                #declare Y = my+ny*mosaic_pixel-image_height_Old*0.5+0.5;
                                #declare color_sum = color_sum+pig_map(X,Y,0)*(1-mask_map(X,Y,0))+part_map(X,Y,0)*mask_map(X,Y,0);
                                #declare my = my+1;
                        #end
                        #declare mx = mx+1;
                #end
                #declare pixel_col = color_sum/pixels;     
                #if (coloring != 1)
                        #declare color_mean = vdot(<pixel_col.x,pixel_col.y,pixel_col.z>,1)/3; 
                        #declare pixel_color = color_mean+(pixel_col-color_mean)*saturation;               
                        #declare pixel_col = pixel_color;
                #end
                box {
                        0 1
                        pigment {color rgb <pow(pixel_col.x,g_red),pow(pixel_col.y,g_green),pow(pixel_col.z,g_blue)>}
                        finish {ambient 1 diffuse 0}
                        translate <nx-image_width*0.5,ny-image_height*0.5,0>
                }
                #declare ny = ny+1;
        #end
        #declare nx = nx+1;
        #debug concat(str(nx,0,0)," columns processed \n")
#end