// textures for the povray scene describing the iPodRetro

// the main texture
#declare mainBodyTexture = texture {
	pigment { color rgb 1 }
	finish  { 	ambient 0
				reflection .14 
	}
	normal {bumps 0.05 scale 4}
}

// the texture of the plastic where the display is cut out
#declare displayCutTexture = texture {
	finish { 	ambient 0 }
	pigment { color rgb 0.5 }
}


// the metal used for the back part of the body
#declare bodyMetal = texture {
	pigment { color rgb 0.7 }
	finish  { 	ambient 0
		reflection .4
	}
	normal {bumps 0.1 scale 4}
}

//the texture, image etc. representing the LCD
#declare lcDisplayTexture = texture {
	pigment {
		image_map { jpeg "./displayContent.jpg"
			map_type 0
			once
	  }
	  rotate 90*x
	  scale <displayWidth, 1, displayHeight>
	  translate <-displayWidth/2, mainThick/2-displayDepth, -displayHeight/2>
	}
	finish { ambient 0.25 }
}

// the glass/plastic on top of the display
#declare displayGlassTexture = texture {
	pigment {color rgbt <1,1,1,0.76> }
	finish  { ambient 0 
		reflection { 0.05, 0.12 } 
	}
}


// the outer metal of the memory cylinder
#declare cylinderOuterTexture = texture {
	pigment {color rgb 0.56 }
	finish { ambient 0
		phong 0.7 phong_size 50 
	}
	normal {
		agate 0.01 scale 0.01
	}
}

// the touchpad
#declare touchpadTexture = texture {
	cylinderOuterTexture
	// pigment {color rgb 0.86 }
	// finish { ambient 0
		// phong 0.25 
		// phong_size 10 
	// }
}
texture {
	finish {ambient 0 }
	pigment {
		image_map { png "./buttonPrint.png"
			map_type 0
			once
		}
		rotate 90*x
		translate <-0.5,mainThick/2,-0.5>
		scale <0.7*touchpadOuterRad,1,0.7*touchpadOuterRad*95/165>
		translate z*touchpadZ
	}
}

// the material of the nipples
#declare nippleTexture = texture {
	pigment { color rgb 0.66 }
	finish { ambient 0
		phong 1 phong_size 200
	}
}

// the material of the inner cylinder
#declare innercylinderTexture = texture {
	nippleTexture
}

// the material of the guides
#declare guideTexture = texture {
	bodyMetal
}

// the material of the gearWheel on the cylinder
#declare gearWheelTexture1 = texture {
	bodyMetal
}

// the material of the gearWheel on the cylinder
#declare gearWheelTexture2 = texture {
	bodyMetal
}

// the material of the gearWheel on the cylinder
#declare gearWheelTexture3 = texture {
	bodyMetal
}

// the material of the axis the gear wheels sit on
#declare gearWheelAxisTexture = texture {
	cylinderOuterTexture
}

// the material the manual
#declare manualPaper = texture {
	pigment { color rgb 0.95 }
	finish { ambient 0
		phong 0.1 phong_size 10 
	}
}
texture {
	finish { 
		ambient 0
	}
	pigment {
		image_map { png "./manualPrint.png"
			map_type 0
			once
		}
		rotate 90*x
		translate <-0.5,0,-0.5>
		scale 6
		translate z*0
	}
}
texture {
	finish { 
		ambient 0
	}
	pigment {
		image_map { png "./apple.png"
			map_type 0
			once
		}
		rotate 90*x
		translate <-0.5,0,-0.5>
		scale 1.5
		translate <-4,0,4>
		translate -z*1
	}
}

#declare wrinkled = texture {
	pigment { color rgb 0.95 }
	finish { ambient 0 
		phong 0.1 phong_size 10
	}
	normal { agate 0.01 scale <0.04,1,0.1>}
}

#declare bookshelfTexture = texture {
	pigment { color rgb 0.93 }
	finish {
		ambient 0
		phong 0.5
		phong_size 100
	}
}

#declare folderBaseTexture = texture {
	pigment {color rgb 0.95*<0.49, 0.32, 0.15> }
	finish { ambient 0
		phong 0.1
		phong_size 10
	}
}



#declare folderTexture1 = texture {
	folderBaseTexture
}
texture {
	pigment {
		image_map { png "./folderBadge.png"
			map_type 0
			once
		}
		rotate -90*y
		translate <0,-0.5,-0.5>
	}
	scale 2*<1,5,2>
	translate <0,6.5,0>
}

#declare folderTexture2 = texture {
	folderBaseTexture
}
texture {
	pigment {
		image_map { png "./folderBadge2.png"
			map_type 0
			once
		}
		rotate -90*y
		translate <0,-0.5,-0.5>
	}
	scale 2*<1,5,2>
	translate <0,6.5,0>
}

