// Persistence of Vision Ray Tracer Scene Description File
// File: rf_chairs.inc
// Vers: 3.6
// Desc: various chairs 
// Date: Sept 22, 2005
// Auth: Rob Fitzel
// Units: inches

#declare incl_rf_chairs = 1;

#ifndef(Metals_Inc_Temp)
  #include "metals.inc"       
#end

#include "shapes.inc"




#declare metal_chair1 =
#local t_seat1 = texture {  pigment {rgb 0.1} }

union { 
  union { 
    // legs
    cylinder {<0,0,0>,<0,17,0> 0.4}
    cylinder {<17,0,0>,<17,17,0> 0.4}
    cylinder {<0,0,17>,<0,26,17> 0.4}
    cylinder {<17,0,17>,<17,26,17> 0.4} 
    
    // seat sppt
    cylinder {<2,16,2>,<15,16,2> 0.3}
    cylinder {<2,16,15>,<15,16,15> 0.3} 
    cylinder {<2,16,2>,<2,16,15> 0.3}
    cylinder {<15,16,2>,<15,16,15> 0.3} 
    
    // connect legs with seat sppt
    cylinder {<0,16,0>,<2,16,2> 0.3} 
    cylinder {<17,16,0>,<15,16,2> 0.3} 
    cylinder {<0,16,17>,<2,16,15> 0.3}
    cylinder {<17,16,17>,<15,16,15> 0.3} 
    
    texture {T_Chrome_3C}
    } 
    
  // seat 
  
  superellipsoid {<0.5,0.5> scale <10,1.5,9> translate <17/2,17.5,17/2> texture {t_seat1}} 
  
  // seat back 
  union {
    union {
      Round_Box_Union(<0,-2,0>,<17,11,2>, 1) 
      rotate <10,0,0> 
      }
    union {
      Round_Box_Union(<0,0,0>,<17,-3,2>, 1)
      } 
    texture {t_seat1}  
    translate <0,25,16>
  }
  
  
  
  translate <-17/2,0,-17/2> 
  scale <1,1.13,0.9>
  rotate <0,-90,0>
};