// Persistence of Vision Ray Tracer Scene Description File
// File: rf_music_stand.inc
// Vers: 3.6
// Desc: A concert-style music stand
// Date: March 14, 2006
// Auth: Rob Fitzel
// Unit: Feet 

#ifndef(Metals_Inc_Temp)
  #include "metals.inc"       
#end

#declare t_music_stand_black = texture {pigment {rgb 0.01} finish {phong 1 phong_size 100}};
#declare t_music_stand_notes = 
texture {
  pigment {
    gradient y
    color_map {
      [0    rgb 0.8]
      [0.2  rgb 0.8]
      [0.2  rgb 0.6]
      [0.4  rgb 0.6]
      [0.45 rgb 0.8]
      [0.5  rgb 0.8]
      [0.5  rgb 0.6]
      [0.7  rgb 0.6]
      [0.7  rgb 0.8]
      [1    rgb 0.8]
    }
    scale 0.2
  }

};



#macro music_stand(tilt, xfrm)  // units: feet
union {
  cylinder {<0,0.2,0>,<0,3,0> 0.03 }  // bottom part of stand
  cylinder {<0,3,0>,<0,3.6,0> 0.025 texture {T_Chrome_2A}} // top part of stand (telescopic extension) 
  cylinder {<-0.1,3.6,0>,<0.1,3.6,0>,0.05 texture {T_Chrome_2A}} 
  
  // note holder
  union {
    box {<-1,0,0>,<1,1,0.001>  }
    box {<-1,0,0>,<1,-0.5,0.001> } 
    
    box {<-0.1,-0.5,0.001>,<-0.9,0.9,0.002> texture {t_music_stand_notes}}  // paper  
    box {< 0.0,-0.5,0.001>,< 0.8,0.9,0.002> texture {t_music_stand_notes}}  // paper

    box {<-1,-0.5,0>,<1,-0.501,0.25> }  
    
    union {
      cylinder {<-0.8,0.8,0>,<0.8,0.8,0> 0.02 clipped_by {plane {z,0}}}
      cylinder {<-0.8,0.7,0>,<0.8,0.7,0> 0.02 clipped_by {plane {z,0}}}
      cylinder {<-0.8,0.6,0>,<0.8,0.6,0> 0.02 clipped_by {plane {z,0}}}  
      cylinder {<-0.8,-0.2,0>,<0.8,-0.2,0> 0.02 clipped_by {plane {z,0}}}
      finish {phong 0.5 phong_size 10}
    }
    rotate <tilt,0,0>
    translate <0,3.6,0.06>
    }

  // base
  torus {0.3,0.05 rotate <90,0,0> scale <1.5,0.7,1> clipped_by{plane{-y,0}} clipped_by{plane{x,0}}  }
  torus {0.3,0.05 rotate <90,0,0> scale <1.5,0.7,1> clipped_by{plane{-y,0}} clipped_by{plane{x,0}} rotate <0,120,0> }
  torus {0.3,0.05 rotate <90,0,0> scale <1.5,0.7,1> clipped_by{plane{-y,0}} clipped_by{plane{x,0}} rotate <0,240,0> }
  texture {t_music_stand_black} 
  
  transform {xfrm}
}
#end

#declare musician_music_stand  = music_stand(-30, transform {translate <0,0,0>});
#declare conductor_music_stand = music_stand(-70, transform {translate <0,0,0>}); 


