// Persistence of Vision Ray Tracer Scene Description File
// File: rf_woodfloor.inc
// Vers: 3.6
// Desc: Wood floor macros
// Date: March 28, 2006
// Auth: Rob Fitzel  


#include "rand.inc" 
#include "colors.inc"
#include "woods.inc" 
 
 
// draw a wood plank floor from <0,0,0> to <fx,0,fz>
// px= plank width; pz= max plank length; sc= txt1 scale, txt1=base texture1; txt2= finish
// fsd: random seed; xfrm= transformation
#macro wood_floor1(fx,fz,px,pz,sc,txt1,txt2,fsd,xfrm) 
  #local fsd = seed(19);
  

  #local lpx = 0; // last plank width 
  union {
    #while (lpx <fx)
      #local lpl = 1;
        #while (lpl<fz)
          #local pl = RRand(0.7,1.2,fsd)*pz; // random plank length 
          #if (lpl+pl > fz)
            #local pl = fz-lpl;
          #end
          #local rand_darkening = texture {pigment {rgbt <0,0,0,RRand(0.7,1,fsd)>}};
          box {<lpx,0,lpl>,<lpx+px-0.001,-0.0001,lpl+pl-0.001> 
               texture {txt1 scale sc translate <10,10,10>*rand(fsd)}  // texture parameter
               texture {rand_darkening}  // rand darkening
               texture {txt2}    // user supplied top finish
               } 
          #local lpl=lpl+pl;
        #end
     #local lpx=lpx+px;
     #end 
     //box {<0,-0.0001,0>,<fx,-0.0001,fz> pigment {rgb 0}} // cracks between wood 
     transform {xfrm} 
   }
#end

// usage

//#local t_floor_wood = texture {T_Wood10 finish {phong 0.7 phong_size 10 reflection 0.02}}
//wood_floor1(5,20,0.2,3,0.1,t_floor_wood,transform {translate <0,0,-3>})

