#include "colors.inc"
#include "metals.inc"
#include "golds.inc"

global_settings {
	max_trace_level 20
}
camera { location <5,0.5,-10> look_at <0,0,-0> }
light_source { <6,0.6,- 8> color  1 }

#declare Container_T= texture {
   pigment {rgbt <1,1,1,1>}
   finish {ambient 0 diffuse 0}
}

#macro Trumpet (faktor,licht)
	#local l1=2;
	#local l2=8;
	difference {
		cylinder {<0,0,-l1-1>*faktor <0,0,l2>*faktor 0.2*faktor }
		cylinder {<0,0,-l1-1.1>*faktor <0,0,l2+0.1>*faktor 0.199*faktor }
		texture { T_Gold_3A }
	}
	difference {
		cylinder {<0,-2,-l1>*faktor <0,-2,l2>*faktor 0.2*faktor }
		cylinder {<0,-2,-l1-0.1>*faktor <0,-2,l2+0.1>*faktor 0.199*faktor }
		texture { T_Gold_3A }
	}
	intersection {
		difference {
			torus { faktor 0.2*faktor
				rotate z*90
				translate <0,-faktor,l2*faktor> 
				texture { T_Gold_3A }
			}
			torus { faktor 0.199*faktor
				rotate z*90
				translate <0,-faktor,l2*faktor> 
				texture { T_Gold_3A }
			}
			texture { T_Gold_3A }
		}
		box { <-1,1,l2>*faktor <1,-5,l2+3>*faktor }
		texture { T_Gold_3A }
	}
	lathe {
		bezier_spline
		8,
		<0.199,0>,<0.199,0.5>,<0.8,1.6>,<1,1.7>,<1,1.7>,
		<0.8,1.6>,<0.2,0.5>,<0.2,0>

		rotate x*-90
		scale faktor
		translate < 0,0,-l1-1>*faktor
		texture { T_Gold_3A }
	}
    torus { faktor 0.01 * faktor 
		rotate <90,0,90>
		translate <0,0,-l1-2.7>*faktor
		texture { T_Gold_3A }
	}
	union {
	intersection {
		torus { faktor 0.2*faktor
			rotate z*90
			translate <0, faktor,-l1*faktor> 
			texture { T_Gold_3A }
		}
		box { <-1,10,-l1>*faktor <1,-10,-l1-3>*faktor }
		texture { T_Gold_3A }
	}
	cylinder {<0,2,-l1>*faktor <0,2,l2+1>*faktor 0.2*faktor 
		texture { T_Gold_3A }
	}
	cone { <0,2,l2+1.25>*faktor 0.3*faktor
		   <0,2,l2+1>*faktor 0.2*faktor
		texture { T_Gold_3A }
    }
	torus { 0.3 *faktor 0.01 * faktor 
		rotate <90,0,90>
		translate <0,2,l2+1.25>*faktor
	}
	texture { T_Gold_3A }
		rotate z*-15
		translate <0,-2*faktor,0>
	}
	light_source { <0,-0,l2>*faktor color  2*licht }
#end


#macro star(a,h,s)
	#local col=<1,1,1>;
	#switch (a)
	#range (512+16,768+64+16)
		#local ssize=1/40+s/80;
		#break
	#else
		#local ssize=1/10+s/20;
		#break
	#end
	sphere {
		vaxis_rotate (<20,(h-512)/15,0>,y,a/1024*360)
		ssize
		texture { pigment { rgb col } finish { ambient 1 reflection 0 } }
	}
#end
Trumpet(1, 5)
/* visible beam */
lathe {
	bezier_spline
	8,
	<0.195,0>,<0.195,0.5>,<0.7,1.6>,<0.9,1.7>,
	<0.9,1.7>,<0.9+1,1.7+2>,<0.9+3,1.7+6>,<0.9+4,1.7+8>//,

	rotate x*-90
	translate < 0,0,-3>
	hollow
	texture {
   		pigment {rgbt <1,1,1,1>}
   		finish {ambient 0 diffuse 0}
   	}
	interior {
	  	media {
		 	intervals 20         
		 	samples 1,5          
		 	emission 0.00
		 	scattering { 3 0.1 }
	  	}
   	}
}
#include "stars.inc"

