//==================================
//  toujours dans l'tude 
//  du son en 3D
//  et des figures de Chladni
// pour l'IRTC d'avril 1006
// topic Music
//
//  hlne - Mars 2006
//
//=================================


// includes gnraux

#include "colors.inc"
#include "textures.inc"
#include "couleurs.inc"
#include "skies.inc"
#include "metals.inc"
#include "functions.inc"



global_settings { max_trace_level 15}


camera
{
  location <0,5,-20>
  look_at <0,5,0>
}



//-------light
light_source { <200, 100, -100> White*1.5 }

//-------light
light_source { <1000, 500, 400> White }


fog 
        {
        distance 300
        color rgb <0.56,0.56,0.73> 
        turbulence 0.2
        turb_depth 0.3
        fog_type 2
        fog_offset 20//15//10
        fog_alt 2
        }


//*******************
//     Ciel
//*******************



sky_sphere {

pigment {
        granite
        color_map {
            [ 0.000  0.270 color rgb < 0, 0, 0> color rgb < 0, 0, 0> ]
            [ 0.270  0.280 color rgb <.5,.5,.4> color rgb <.8,.8,.4> ]
            [ 0.280  0.470 color rgb < 0, 0, 0> color rgb < 0, 0, 0> ]
            [ 0.470  0.480 color rgb <.4,.4,.5> color rgb <.4,.4,.8> ]
            [ 0.480  0.680 color rgb < 0, 0, 0> color rgb < 0, 0, 0> ]
            [ 0.680  0.690 color rgb <.5,.4,.4> color rgb <.8,.4,.4> ]
            [ 0.690  0.880 color rgb < 0, 0, 0> color rgb < 0, 0, 0> ]
            [ 0.880  0.890 color rgb <.5,.5,.5> color rgb < 1, 1, 1> ]
            [ 0.890  1.000 color rgb < 0, 0, 0> color rgb < 0, 0, 0> ]
                  }
       turbulence 1
       sine_wave
       scale .5
        }
        
}        

//********************
//      le sol
//********************

plane   // la mer 
{
        y,-1
        texture {
      pigment  {LightSteelBlue}//{ color red 0.0 green 0.07 blue 0.0 }
      finish {
         reflection 0.45
         ambient 0.15
         diffuse 0.6 phong 1.0 phong_size 80
      }
      normal {
         ripples 0.7
         frequency 0.08
         translate <0, 0, 0>
      }
   }
          
}
  





//***********************************
//  3 tubes en verres
//  contenant des figures de Chladni
//***********************************


// --- Le premier tube
#declare tube1=
  union
{
cylinder
{
  <0,0,0>, <0,10,0>,2
  open
  material {M_NB_Old_Glass}
}  

// --- Premire isosurface - en bas

#declare c1=1.0;
#declare c2=2.0;
#declare c3=1.75;

isosurface {
	function {cos(c1*x) + cos(c2*y) + cos(c3*z)}
	threshold 0
	max_gradient 2.768
	contained_by {box {<-5,0,-5>, < 5, 5, 5>}}
	open
	texture {T_Gold_2C}
	

  
  scale <0.2,0.4,0.2>
  rotate y*10
  translate <0.5,1.5,0>	
	
}

// --- Deuxime isosurface - au milieu

#declare c1=1.0;
#declare c2=2.0;
#declare c3=1.75;

isosurface {
	function {cos(c1*x) + cos(c2*y) + cos(c3*z)}
	threshold 0
	max_gradient 2.768
	contained_by {box {<-5,0,-5>, < 5, 5, 5>}}
	open
	texture {T_Gold_2C}
	

  
  scale <0.2,0.4,0.2>
  translate <0,4,0>	
	
}

// --- troisime isosurface - en haut

#declare c1=1.0;
#declare c2=2.0;
#declare c3=1.75;

isosurface {
	function {cos(c1*x) + cos(c2*y) + cos(c3*z)}
	threshold 0
	max_gradient 2.768
	contained_by {box {<-5,0,-5>, < 5, 5, 5>}}
	open
	texture {T_Gold_2C}
	

  
  scale <0.2,0.4,0.2>
  rotate y*-10
  translate <-0.5,6.5,0>	
	
}

// --- quatrime isosurface - en haut et en dehors  gauche

#declare c1=1.0;
#declare c2=2.0;
#declare c3=1.75;

isosurface {
	function {cos(c1*x) + cos(c2*y) + cos(c3*z)}
	threshold 0
	max_gradient 2.768
	contained_by {box {<-5,0,-5>, < 5, 5, 5>}}
	open
	texture {T_Gold_2C}
	

  
  scale <0.15,0.3,0.1>
  rotate y*15
  translate <-1,11,0>	
	
}

// --- quatrime isosurface - en haut et en dehors  droite

#declare c1=1.0;
#declare c2=2.0;
#declare c3=1.75;

isosurface {
	function {cos(c1*x) + cos(c2*y) + cos(c3*z)}
	threshold 0
	max_gradient 2.768
	contained_by {box {<-5,0,-5>, < 5, 5, 5>}}
	open
	texture {T_Gold_2C}
	

  
  scale <0.15,0.3,0.1>
  rotate y*-15
  translate <1,9.5,-3>	
	
}
}// fin de l'union du tube1  



//===============================

// --- second tube


#declare tube2=
  union
{

cylinder
{
  <0,0,0>, <0,10,0>,2
  open
  material {M_NB_Old_Glass}
}  

// --- Premire isosurface - en bas

#declare c1=2.50;
#declare c2=1.00;
#declare c3=1.60;

isosurface {
	function {cos(c1*x) + cos(c2*y) + cos(c3*z)}
	threshold 0
	max_gradient 3.497
	contained_by {box {<-5,0,-5>, < 5, 5, 5>}}
	open
	texture {T_Gold_2C}
	

  
  scale <0.2,0.4,0.2>
  rotate y*10
  translate <0.5,1.5,0>	
	
}

// --- Deuxime isosurface - au milieu

#declare c1=2.50;
#declare c2=1.00;
#declare c3=1.60;

isosurface {
	function {cos(c1*x) + cos(c2*y) + cos(c3*z)}
	threshold 0
	max_gradient 3.507
	contained_by {box {<-5,0,-5>, < 5, 5, 5>}}
	open
	texture {T_Gold_2C}
	

  
  scale <0.2,0.4,0.2>
  translate <0,4,0>	
	
}

// --- troisime isosurface - en haut

#declare c1=2.50;
#declare c2=1.00;
#declare c3=1.60;


isosurface {
	function {cos(c1*x) + cos(c2*y) + cos(c3*z)}
	threshold 0
	max_gradient 3.503
	contained_by {box {<-5,0,-5>, < 5, 5, 5>}}
	open
	texture {T_Gold_2C}
	

  
  scale <0.2,0.4,0.2>
  rotate y*-10
  translate <-0.5,6.5,0>	
	
}

// --- quatrime isosurface - en haut et en dehors  gauche

#declare c1=2.50;
#declare c2=1.00;
#declare c3=1.60;

isosurface {
	function {cos(c1*x) + cos(c2*y) + cos(c3*z)}
	threshold 0
	max_gradient 3.496
	contained_by {box {<-5,0,-5>, < 5, 5, 5>}}
	open
	texture {T_Gold_2C}
	

  
  scale <0.15,0.3,0.1>
  rotate y*15
  translate <1,9.5,-3>	
	
}

// --- cinquime isosurface - en haut et en dehors  droite

#declare c1=2.50;
#declare c2=1.00;
#declare c3=1.60;

isosurface {
	function {cos(c1*x) + cos(c2*y) + cos(c3*z)}
	threshold 0
	max_gradient 3.496
	contained_by {box {<-5,0,-5>, < 5, 5, 5>}}
	open
	texture {T_Gold_2C}
	

  
  scale <0.15,0.3,0.1>
  rotate y*-15
  translate <-1,11,0>	
	
}

}// fin du tube2

//===============================

// ---  troisieme tube


#declare tube3=
  union
{

cylinder
{
  <0,0,0>, <0,10,0>,2
  open
  material{M_NB_Old_Glass}
}  

// --- Premire isosurface - en bas

#declare c1=1.00;
#declare c2=2.50;
#declare c3=2.00;

isosurface {
	function {cos(c1*x) + cos(c2*y) + cos(c3*z)}
	threshold 0
	max_gradient 3.497
	contained_by {box {<-5,0,-5>, < 5, 5, 5>}}
	open
	texture {T_Gold_2C}
	

  
  scale <0.2,0.4,0.2>
  rotate y*10
  translate <0.5,1.5,0>	
	
}

// --- Deuxime isosurface - au milieu

#declare c1=1.00;
#declare c2=2.50;
#declare c3=2.00;

isosurface {
	function {cos(c1*x) + cos(c2*y) + cos(c3*z)}
	threshold 0
	max_gradient 3.507
	contained_by {box {<-5,0,-5>, < 5, 5, 5>}}
	open
	texture {T_Gold_2C}
	

  
  scale <0.2,0.4,0.2>
  translate <0,4,0>	
	
}

// --- troisime isosurface - en haut

#declare c1=1.00;
#declare c2=2.50;
#declare c3=2.00;


isosurface {
	function {cos(c1*x) + cos(c2*y) + cos(c3*z)}
	threshold 0
	max_gradient 3.503
	contained_by {box {<-5,0,-5>, < 5, 5, 5>}}
	open
	texture {T_Gold_2C}
	

  
  scale <0.2,0.4,0.2>
  rotate y*-10
  translate <-0.5,6.5,0>	
	
}

// --- quatrime isosurface - en haut et en dehors  gauche

#declare c1=1.00;
#declare c2=2.50;
#declare c3=2.00;

isosurface {
	function {cos(c1*x) + cos(c2*y) + cos(c3*z)}
	threshold 0
	max_gradient 3.496
	contained_by {box {<-5,0,-5>, < 5, 5, 5>}}
	open
	texture {T_Gold_2C}
	

  
  scale <0.15,0.3,0.1>
  rotate y*15
  translate <1,9.5,-3>	
	
}

// --- cinquime isosurface - en haut et en dehors  droite

#declare c1=1.00;
#declare c2=2.50;
#declare c3=2.00;

isosurface {
	function {cos(c1*x) + cos(c2*y) + cos(c3*z)}
	threshold 0
	max_gradient 3.496
	contained_by {box {<-5,0,-5>, < 5, 5, 5>}}
	open
	texture {T_Gold_2C}
	

  
  scale <0.15,0.3,0.1>
  rotate y*-15
  translate <-1,11,0>	
	
}

}// fin du tube3


// =========================
// placement des tubes
// =========================

#declare trois_tubes =
union
{
object
{
  tube1
  translate <-4.5,-1,0>//6
}

object
{
  tube2
  translate <0,-1,0>
}

object
{
  tube3
  translate <4.5,-1,0>
}
  
}

//===================

object
{
  trois_tubes
  translate <0,1,0>
}


//=========================
// figures orphelines
//=========================

// de gauche  droite

// --- figure 1

#declare c1=1.0;
#declare c2=2.0;
#declare c3=1.75;

isosurface {
	function {cos(c1*x) + cos(c2*y) + cos(c3*z)}
	threshold 0
	max_gradient 2.768
	contained_by {box {<-5,0,-5>, < 5, 5, 5>}}
	open
	texture {T_Gold_2C}
	

  
  scale <0.2,0.4,0.2>
  //rotate y*10
  translate <-5,-1,-5>	
	
}

// ----- les petites entre les autres

// --- figure 2

#declare c1=2.50;
#declare c2=1.00;
#declare c3=1.60;

isosurface {
	function {cos(c1*x) + cos(c2*y) + cos(c3*z)}
	threshold 0
	max_gradient 3.497
	contained_by {box {<-5,0,-5>, < 5, 5, 5>}}
	open
	texture {T_Gold_2C}
	

  
  scale <0.1,0.3,0.1>
  rotate y*-20
  translate <-3,-1.5,-3>	
	
}
// --- figure 2

#declare c1=2.50;
#declare c2=1.00;
#declare c3=1.60;

isosurface {
	function {cos(c1*x) + cos(c2*y) + cos(c3*z)}
	threshold 0
	max_gradient 3.497
	contained_by {box {<-5,0,-5>, < 5, 5, 5>}}
	open
	texture {T_Gold_2C}
	

  
  scale <0.1,0.3,0.1>
  rotate y*20
  translate <3,-1.5,-3>	
	
}
//==============================

// --- figure 1

#declare c1=1.0;
#declare c2=2.0;
#declare c3=1.75;

isosurface {
	function {cos(c1*x) + cos(c2*y) + cos(c3*z)}
	threshold 0
	max_gradient 2.768
	contained_by {box {<-5,0,-5>, < 5, 5, 5>}}
	open
	texture {T_Gold_2C}
	

  
  scale <0.2,0.4,0.2>
  //rotate y*10
  translate <5,-1,-5>	
	
}
// --- figure 3

#declare c1=1.00;
#declare c2=2.50;
#declare c3=2.00;

isosurface {
	function {cos(c1*x) + cos(c2*y) + cos(c3*z)}
	threshold 0
	max_gradient 3.496
	contained_by {box {<-5,0,-5>, < 5, 5, 5>}}
	open
	texture {T_Gold_2C}
	

  
  scale <0.2,0.4,0.2>
  //rotate y*-15
  translate <0,-1,-5>	
	
}

//==============================
//  flottantes au fond
//==============================

#declare c1=3.00;
#declare c2=3.00;
#declare c3=3.00;

isosurface {
	function {cos(c1*x) + cos(c2*y) + cos(c3*z)}
	threshold 0
	max_gradient 3.497
	contained_by {box {<-5,0,-5>, < 5, 5, 5>}}
	open
	texture {T_Gold_2C}
	

  
  scale <0.6,1.2,0.5>
  rotate y*10
  translate <-35,2,50>	
	
}

#declare c1=3.00;
#declare c2=3.00;
#declare c3=3.00;

isosurface {
	function {cos(c1*x) + cos(c2*y) + cos(c3*z)}
	threshold 0
	max_gradient 3.497
	contained_by {box {<-5,0,-5>, < 5, 5, 5>}}
	open
	texture {T_Gold_2C}
	

  
  scale <0.6,1.2,0.5>
  rotate y*10
  translate <35,2,50>	
	
}



