/********************************************************/
/*                                                      */
/*  tablemix.pov                                        */
/*                                                      */
/*  Une console de mixage                               */
/*                                                      */
/*  IRTC avril 2006 - Music                             */
/*                                                      */
/*  AUTEUR : Vivien TURMEL                              */
/*                                                      */
/*                                                      */
/********************************************************/
/*                                                      */
/* Povray 3.5 Windows                                   */
/*                                                      */
/* Sempron 3000 2000MHz 512Mo                           */
/*                                                      */
/* +w1024 +h768 +am1 +a0.2 -j                           */
/* Parse:    0 hours  0 minutes   2.0 seconds           */
/* Trace:    0 hours  1 minutes  55.0 seconds           */
/* Total:    0 hours  1 minutes  57.0 seconds           */
/*                                                      */
/********************************************************/



#include "colors.inc"



global_settings 
{
  assumed_gamma 1.0
  max_trace_level 4
}




/**********************************/
/*                                */
/*       Camera                   */
/*                                */
/**********************************/


#declare VUE_PLONGEE=0;
#declare VUE_HAUT=1;
#declare VUE_GAUCHE_BAS=2;
#declare VUE_GAUCHE_HAUT=3;
#declare VUE_CENTRE=4;
#declare VUE_DROITE_BAS=5;
#declare VUE_DROITE_HAUT=6;
#declare VUE_ENSEMBLE=7;
#declare VUE_RASANTE=8;

#ifndef (Vue)
  #declare Vue=VUE_PLONGEE;
#end



camera
{
  #switch (Vue)
    #case (VUE_PLONGEE)
      location <0,22.5,-12>
      look_at <0,-4,0>
    #break
    #case (VUE_HAUT)  // a rendre en +w1490 +h640
      orthographic
      location <0,18,0>
      look_at <0,0,0>
      right 74.5*x
      up 32*y
    #break
    #case (VUE_GAUCHE_BAS)
      orthographic
      location <-22,25,-4>
      look_at <-22,0,-4>
    #break
    #case (VUE_GAUCHE_HAUT)
      orthographic
      location <-22,25,4>
      look_at <-22,0,4>
    #break
    #case (VUE_CENTRE)
      orthographic
      location <0,25,0>
      look_at <0,0,0>
    #break
    #case (VUE_DROITE_BAS)
      orthographic
      location <22,25,-4>
      look_at <22,0,-4>
    #break
    #case (VUE_DROITE_HAUT)
      orthographic
      location <22,25,4>
      look_at <22,0,4>
    #break
    #case (VUE_ENSEMBLE) // a rendre en +w1024 +h443
      location <0,32.5,0> 
      look_at <0,0,0>
      right 2.31*x
      up y
    #break
    #case (VUE_RASANTE)
      location <0,10,-16.8>
      look_at <0,-6,0>
    #break
  #end
}





/**********************************/
/*                                */
/*       Lumiere                  */
/*                                */
/**********************************/

//light_source{ <0, 500, 200> rgb 1}


light_source
{
  <0,500,200>
  color White
  area_light <50,0,0>, <0,0,50>, 5, 5
  adaptive 1
  jitter
}


background {White}




/**********************************/
/*                                */
/*       Definitions              */
/*                                */
/**********************************/


#declare HAUT_BOUTON=1.5;
#declare LARG_BOUTON=0.3;


#declare T_CONSOLE = texture {pigment {color rgb <0.03,0.05,0.03>}}

#declare T_TYPE_BOUTON = texture {pigment {Blue}}

#declare T_BOUTON_GRIS = texture {pigment {Gray30}}

#declare T_BOUTON = texture {radial texture_map {[0.5 pigment {Gray10}][0.5 pigment {Gray20}]} frequency 16}



#macro CONTROLE_BASSE (angle_bouton)
union
{
  box {<-1,0,-1.5> <2,0.001,1> texture {T_CONSOLE}}
  union
  {
    union
    {
      cylinder {<0,0,0> <0,HAUT_BOUTON,0> LARG_BOUTON texture {T_BOUTON}}
      cylinder {<0,HAUT_BOUTON-0.01,0> <0,HAUT_BOUTON+0.01,0> LARG_BOUTON texture {T_TYPE_BOUTON}}
      box {<-0.05,HAUT_BOUTON-0.1,0> <0.05,HAUT_BOUTON+0.05,LARG_BOUTON> pigment {White}}
      rotate y*angle_bouton
    }
    union
    {
      #local i=-150;
      #while (i<=150)
        box {<-0.02,0,LARG_BOUTON+0.1> <0.02,0.02,LARG_BOUTON+0.2> rotate y*i pigment {White}}
        #local i=i+30;
      #end
    }
    text {ttf "arial.ttf" "-10" 0.2 0 texture {pigment {White}} rotate x*90 scale 0.3 translate <-0.7,0.034,-0.7>}
    text {ttf "arial.ttf" "+10" 0.2 0 texture {pigment {White}} rotate x*90 scale 0.3 translate <0.3,0.034,-0.7>}
    translate <-0.1,0,0.2>
  }
  text {ttf "arial.ttf" "80 Hz" 0.2 0 texture {pigment {White}} rotate x*90 scale 0.3 translate <1.1,0.034,0>}
  text {ttf "arial.ttf" "LOW CUT" 0.2 0 texture {pigment {White}} rotate x*90 scale 0.3 translate <-0.7,0.034,-1.1>}
  box {<-0.45,0,-0.25> <0.45,0.5,0.25> texture {T_BOUTON_GRIS} translate <1.3,0,-1.0>}
}
#end



#macro CONTROLE_MEDIUM (angle_bouton,frequence)
union
{
  box {<-1,0,-1> <2,0.001,1> texture {T_CONSOLE}}
  union
  {
    union
    {
      cylinder {<0,0,0> <0,HAUT_BOUTON,0> LARG_BOUTON texture {T_BOUTON}}
      cylinder {<0,HAUT_BOUTON-0.01,0> <0,HAUT_BOUTON+0.01,0> LARG_BOUTON texture {T_TYPE_BOUTON}}
      box {<-0.05,HAUT_BOUTON-0.1,0> <0.05,HAUT_BOUTON+0.05,LARG_BOUTON> pigment {White}}
      rotate y*angle_bouton
    }
    union
    {
      #local i=-150;
      #while (i<=150)
        box {<-0.02,0,LARG_BOUTON+0.1> <0.02,0.02,LARG_BOUTON+0.2> rotate y*i pigment {White}}
        #local i=i+30;
      #end
    }
    text {ttf "arial.ttf" "-10" 0.2 0 texture {pigment {White}} rotate x*90 scale 0.3 translate <-0.7,0.034,-0.7>}
    text {ttf "arial.ttf" "+10" 0.2 0 texture {pigment {White}} rotate x*90 scale 0.3 translate <0.3,0.034,-0.7>}
    translate <-0.1,0,0.2>
  }
  text {ttf "arial.ttf" frequence 0.2 0 texture {pigment {White}} rotate x*90 scale 0.3 translate <0.92,0.034,0>}
}
#end



#macro CONTROLE_PAN (angle_bouton)
union
{
  box {<-1,0,-1> <2,0.001,1> texture {T_CONSOLE}}
  union
  {
    union
    {
      cylinder {<0,0,0> <0,HAUT_BOUTON,0> LARG_BOUTON texture {T_BOUTON}}
      cylinder {<0,HAUT_BOUTON-0.01,0> <0,HAUT_BOUTON+0.01,0> LARG_BOUTON texture {pigment {color rgb <0,0.7,0.8>}}}
      box {<-0.05,HAUT_BOUTON-0.1,0> <0.05,HAUT_BOUTON+0.05,LARG_BOUTON> pigment {White}}
      rotate y*angle_bouton
    }
    union
    {
      #local i=-120;
      #while (i<=120)
        box {<-0.02,0,LARG_BOUTON+0.1> <0.02,0.02,LARG_BOUTON+0.2> rotate y*i pigment {White}}
        #local i=i+30;
      #end
    }
    text {ttf "arial.ttf" "L" 0.2 0 texture {pigment {White}} rotate x*90 scale 0.3 translate <-0.6,0.034,-0.7>}
    text {ttf "arial.ttf" "R" 0.2 0 texture {pigment {White}} rotate x*90 scale 0.3 translate <0.5,0.034,-0.7>}
    translate <-0.1,0,0.2>
  }
  text {ttf "arial.ttf" "PAN" 0.2 0 texture {pigment {White}} rotate x*90 scale 0.3 translate <1.0,0.034,0>}
}
#end



#macro MUTE (voie)
union
{
  box {<-0.8,0,0.05> <1.8,0.001,0.95> pigment {White}}
  text {ttf "arial.ttf" voie 0.2 0 texture {pigment {Blue}} rotate x*90 scale 0.4 translate <-0.4,0.034,0.55>}
  text {ttf "arial.ttf" "MUTE" 0.2 0 texture {pigment {Blue}} rotate x*90 scale 0.35 translate <-0.7,0.034,0.15>}
  box {<-0.45,0,-0.3> <0.45,0.5,0.3> texture {T_BOUTON_GRIS} translate <1.3,0,0.5>}
}
#end



#macro CONTROLE_VOLUME (position)
union
{
  difference
  {
    box {<-1,0,-6> <2,0.001,5.5> texture {T_CONSOLE}}
    box {<-0.1,0.00001,-5.35> <0.1,0.01,4.25> texture {pigment {Black}}}
  }
  text {ttf "arial.ttf" "dB" 0.2 0 texture {pigment {White}} rotate x*90 scale 0.3 translate <-0.8,0.034,4.0>}
  text {ttf "arial.ttf" "10" 0.2 0 texture {pigment {White}} rotate x*90 scale 0.3 translate <-0.8,0.034,3.2>}
  box {<-0.15,0,-0.015> <0.15,0.01,0.015> pigment {White} translate <-0.3,0,3.3>}
  box {<-0.15,0,-0.015> <0.15,0.01,0.015> pigment {White} translate <+0.3,0,3.3>}
  text {ttf "arial.ttf" "5" 0.2 0 texture {pigment {White}} rotate x*90 scale 0.3 translate <-0.7,0.034,2.4>}
  box {<-0.15,0,-0.015> <0.15,0.01,0.015> pigment {White} translate <-0.3,0,2.5>}
  box {<-0.15,0,-0.015> <0.15,0.01,0.015> pigment {White} translate <+0.3,0,2.5>}
  text {ttf "arial.ttf" "U" 0.2 0 texture {pigment {White}} rotate x*90 scale 0.3 translate <-0.7,0.034,1.6>}
  box {<-0.15,0,-0.05> <0.15,0.01,0.05> pigment {White} translate <-0.3,0,1.7>}
  box {<-0.15,0,-0.05> <0.15,0.01,0.05> pigment {White} translate <+0.3,0,1.7>}
  text {ttf "arial.ttf" "5" 0.2 0 texture {pigment {White}} rotate x*90 scale 0.3 translate <-0.7,0.034,0.8>}
  box {<-0.15,0,-0.015> <0.15,0.01,0.015> pigment {White} translate <-0.3,0,0.9>}
  box {<-0.15,0,-0.015> <0.15,0.01,0.015> pigment {White} translate <+0.3,0,0.9>}
  text {ttf "arial.ttf" "10" 0.2 0 texture {pigment {White}} rotate x*90 scale 0.3 translate <-0.8,0.034,0>}
  box {<-0.15,0,-0.015> <0.15,0.01,0.015> pigment {White} translate <-0.3,0,0.1>}
  box {<-0.15,0,-0.015> <0.15,0.01,0.015> pigment {White} translate <+0.3,0,0.1>}
  text {ttf "arial.ttf" "15" 0.2 0 texture {pigment {White}} rotate x*90 scale 0.3 translate <-0.8,0.034,-0.8>}
  box {<-0.15,0,-0.015> <0.15,0.01,0.015> pigment {White} translate <-0.3,0,-0.7>}
  box {<-0.15,0,-0.015> <0.15,0.01,0.015> pigment {White} translate <+0.3,0,-0.7>}
  text {ttf "arial.ttf" "20" 0.2 0 texture {pigment {White}} rotate x*90 scale 0.3 translate <-0.8,0.034,-1.6>}
  box {<-0.15,0,-0.015> <0.15,0.01,0.015> pigment {White} translate <-0.3,0,-1.5>}
  box {<-0.15,0,-0.015> <0.15,0.01,0.015> pigment {White} translate <+0.3,0,-1.5>}
  text {ttf "arial.ttf" "30" 0.2 0 texture {pigment {White}} rotate x*90 scale 0.3 translate <-0.8,0.034,-2.4>}
  box {<-0.15,0,-0.015> <0.15,0.01,0.015> pigment {White} translate <-0.3,0,-2.3>}
  box {<-0.15,0,-0.015> <0.15,0.01,0.015> pigment {White} translate <+0.3,0,-2.3>}
  text {ttf "arial.ttf" "40" 0.2 0 texture {pigment {White}} rotate x*90 scale 0.3 translate <-0.8,0.034,-3.2>}
  box {<-0.15,0,-0.015> <0.15,0.01,0.015> pigment {White} translate <-0.3,0,-3.1>}
  box {<-0.15,0,-0.015> <0.15,0.01,0.015> pigment {White} translate <+0.3,0,-3.1>}
  text {ttf "arial.ttf" "50" 0.2 0 texture {pigment {White}} rotate x*90 scale 0.3 translate <-0.8,0.034,-3.6>}
  box {<-0.15,0,-0.015> <0.15,0.01,0.015> pigment {White} translate <-0.3,0,-3.5>}
  box {<-0.15,0,-0.015> <0.15,0.01,0.015> pigment {White} translate <+0.3,0,-3.5>}
  text {ttf "arial.ttf" "60" 0.2 0 texture {pigment {White}} rotate x*90 scale 0.3 translate <-0.8,0.034,-4.0>}
  box {<-0.15,0,-0.015> <0.15,0.01,0.015> pigment {White} translate <-0.3,0,-3.9>}
  box {<-0.15,0,-0.015> <0.15,0.01,0.015> pigment {White} translate <+0.3,0,-3.9>}
  text {ttf "arial.ttf" "oo" 0.2 0 texture {pigment {White}} rotate x*90 scale 0.3 translate <-0.8,0.034,-4.4>}
  box {<-0.15,0,-0.015> <0.15,0.01,0.015> pigment {White} translate <-0.3,0,-4.3>}
  box {<-0.15,0,-0.015> <0.15,0.01,0.015> pigment {White} translate <+0.3,0,-4.3>}
  // Partie droite
  sphere {<1.5,0,5> 0.2 pigment {color rgb <0.3,0,0>}}
  box {<-0.45,0,-0.25> <0.45,0.5,0.25> texture {T_BOUTON_GRIS} translate <1.35,0,4>}
  text {ttf "arial.ttf" "SOLO" 0.2 0 texture {pigment {White}} rotate x*90 scale 0.35 translate <0.9,0.034,3.2>}
  box {<-0.45,0,-0.25> <0.45,0.5,0.25> texture {T_BOUTON_GRIS} translate <1.35,0,2.4>}
  text {ttf "arial.ttf" "1-2" 0.2 0 texture {pigment {White}} rotate x*90 scale 0.35 translate <1.2,0.034,1.6>}
  box {<-0.45,0,-0.25> <0.45,0.5,0.25> texture {T_BOUTON_GRIS} translate <1.35,0,0.8>}
  text {ttf "arial.ttf" "3-4" 0.2 0 texture {pigment {White}} rotate x*90 scale 0.35 translate <1.2,0.034,0>}
  box {<-0.45,0,-0.25> <0.45,0.5,0.25> texture {T_BOUTON_GRIS} translate <1.35,0,-0.8>}
  text {ttf "arial.ttf" "L-R" 0.2 0 texture {pigment {White}} rotate x*90 scale 0.35 translate <1.2,0.034,-1.6>}

  // Potentiometre
  union
  {
    box {<-0.5,0,-0.1> <0.5,0.201,0.1> pigment {Blue}}
    box {<-0.5,0,-1> <0.5,0.2,1>}
    difference
    {
      cylinder {<-0.5,0,0> <0.5,0,0> 1.05 /* pigment {Red} */}
      prism
      {
        linear_spline
        -0.5,1.5,4
        <0,0>, <-1.1,1.1>, <1.1,1.1>, <0,0>
        rotate -x*90
        rotate y*90
        translate x*0.5
        //pigment {Green}
      }
      box {<-1,-1.5,-1.5> <1,0,1.5>}
    }
    pigment {White}
    translate z*(1.6*position/10 + 1.7)
  }
}
#end



/*

Echelle controle du volume

+10   10
+5    5
0     0
-5    -5
-10   -10
-15   -15
-20   -20
-30   -25
-40   -30
-50   -32.5
-60   -35
-oo   -37.5

*/



#macro VOIE (numero,rot_12k,rot_6k,rot_2k,rot_1k,rot_500,rot_200,rot_80,rot_pan,volume)
union
{
  box {<-1.01,0,-16> <-0.95,0.002,13> pigment {White}}
  #declare T_TYPE_BOUTON = texture {pigment {Blue}}
  object {CONTROLE_MEDIUM(rot_12k,"12 kHz") translate <0,0,12>}
  object {CONTROLE_MEDIUM(rot_6k," 6 kHz") translate <0,0,10>}
  object {CONTROLE_MEDIUM(rot_2k," 2 kHz") translate <0,0,8>}
  #declare T_TYPE_BOUTON = texture {pigment {Yellow}}
  object {CONTROLE_MEDIUM(rot_1k," 1 kHz") translate <0,0,6>}
  object {CONTROLE_MEDIUM(rot_500,"500 Hz") translate <0,0,4>}
  object {CONTROLE_MEDIUM(rot_200,"200 Hz") translate <0,0,2>}
  #declare T_TYPE_BOUTON = texture {pigment {Red}}
  object {CONTROLE_BASSE(rot_80)}
  object {CONTROLE_PAN(rot_pan) translate <0,0,-2.5>}
  object {MUTE(numero) translate <0,0,-4.5>}
  object {CONTROLE_VOLUME(volume) translate <0,0,-10>}
  box {<1.95,0,-16> <2.01,0.002,13> pigment {White}}
  translate <0,0,1.5>
}
#end





/**********************************/
/*                                */
/*       Scene                    */
/*                                */
/**********************************/


union
{
  difference
  {
    box {<-37,-0.1,-16> <37.5,0.01,16>}
    box {<-36.8,-1,-15.8> <37.3,1,15.8>}
    pigment {DarkGreen}
    //pigment {Red}
  }

  // Socle de la Console
  box {<-37,-2,-16> <37.5,0,16> texture {T_CONSOLE}}

  object{VOIE("01",   0,   0,   0,   0,   0,   0,   0,   0,    0) translate <-34.9,0,0>}
  object{VOIE("02",-150,-150,-150,   0,   0,   0,   0,-120,    0) translate <-31.9,0,0>}
  object{VOIE("03", -90, -60, -30,   0,   0,   0,  60, -90,   -5) translate <-28.9,0,0>}
  object{VOIE("04",   0,   0,   0,  90, 120, 150,-150,   0,  -10) translate <-25.9,0,0>}
  object{VOIE("05",   0,   0,   0,   0,   0,   0,   0,   0,-37.5) translate <-22.9,0,0>}
  object{VOIE("06",   0,   0,   0, 150,   0,   0,   0,   0,  -35) translate <-19.9,0,0>}
  object{VOIE("07",   0,   0,   0,  30,  60,  30,   0,   0,-32.5) translate <-16.9,0,0>}
  object{VOIE("08", 150, 120,  90, -30, -60, -90,   0,   0,  -30) translate <-13.9,0,0>}
  object{VOIE("09",  60,  60,  30,   0,-120, -30,  30,-150,  -25) translate <-10.9,0,0>}
  object{VOIE("10",   0, -30,   0,   0,   0,  60, 150,   0,  -20) translate <-7.9,0,0>}
  object{VOIE("11",   0,   0,-120,  90,   0,   0, -30,   0,  -15) translate <-4.9,0,0>}
  object{VOIE("12",   0,   0,   0,   0,   0,   0,   0,   0,  -10) translate <-1.9,0,0>}
  object{VOIE("13",  30,  30,  60, -30, -30, -30,   0,   0,   -5) translate <1.1,0,0>}
  object{VOIE("14", -60,-120, -60,  60,  30,-120,-120,   0,    0) translate <4.1,0,0>}
  object{VOIE("15",  90,  90, -90, -60, -90,   0,   0,  60,    5) translate <7.1,0,0>}
  object{VOIE("16",-120, -90,   0, -90,-150,-150, -90,   0,   10) translate <10.1,0,0>}
  object{VOIE("17",   0,   0,   0,   0,   0,   0,  60,   0,    0) translate <13.1,0,0>}
  object{VOIE("18", -30, 150, 120, 120, 150, 120,   0, 150,  -20) translate <16.1,0,0>}
  object{VOIE("19", -60, -60, 150,-150,   0, -60,  90,   0,  -20) translate <19.1,0,0>}
  object{VOIE("20",   0,   0,   0,   0,   0,   0,   0,   0,  -10) translate <22.1,0,0>}
  object{VOIE("21",   0,   0,   0,   0,   0,   0, 120,   0,  -35) translate <25.1,0,0>}
  object{VOIE("22", 120,   0,   0,-120,  90,  90, -60,   0,    0) translate <28.1,0,0>}
  object{VOIE("23",   0,   0,   0,  30,  60,  30,   0,   0,   -5) translate <31.1,0,0>}
  object{VOIE("24",0,0,0,0,0,0,0,0,0) translate <34.1,0,0>}

  translate <-0.25,0,0>

}

