#version 3.5;

#include "colors.inc"
#include "functions.inc"
#include "rand.inc"
#include "stones.inc"
#include "skies.inc"
#include "textures.inc"
 

#declare Boat = 1;
#declare Clouds = 1;		// Slow!
#declare Coordinates = 0;
#declare Fog = 1;
#declare Mist = 1;		// Slow!
#declare Radiosity = 1;       // Slow
#declare Reeds = 1;
#declare SolidClouds = 0;
#declare Rocks = 1;

#declare Camera_Pos = <0,3.0,0>;
#declare Camera_Vec = <7,0.9,10>;

#declare C_Sun=<255,245,173>/255;
//#declare C_Cloud=rgb <92,89,80>/255;
#declare C_Cloud=rgb <29,29,90>/255;
#declare CutY=0.3;
#declare C_Scattering=C_Sun*0.0056;
//#declare C_Absorption=(1-C_Cloud)*0.001;
#declare C_Absorption=(1-C_Cloud)*0.005;
#declare C_Emission=C_Cloud*0.0003;

#declare Intervals=3; // cloud media intervals 1 for tests and higher values (2-5) for smoother results


//#declare Boat_X = 6.5;
//#declare Boat_Y= -0.9;
//#declare Boat_Z = 48;
#declare Boat_X = 5.8;
#declare Boat_Y= -0.9;
#declare Boat_Z = 32;
#declare Boat_Pos = <Boat_X,Boat_Y,Boat_Z>;

#declare Sun_Height = 6000.0;
#declare Sun_Radius = 1200.0;
#declare Seed = seed(63981);
#declare RandomNumber = rand(Seed);

#declare SkyPigment =
    pigment {
      function { min(1,pow(3.6,pow(-x,2))* max(min(y,1),0)) }
      color_map {
	[0.0 color rgb <1.0,0.93,0.49> ]
	[0.04 color rgb <1.0,0.83,0.39> ]
	[0.06 color <0.93,0.78,0.36> ]
	[0.1 color <0.83,0.76,0.43> ]
	[0.2 color <0.79,0.78,0.55> ]
	[0.25 color <0.76,0.78,0.62> ]
	[0.3 color <0.71,0.76,0.66> ]
	[0.5 color <0.23,0.45,0.75> ]
	[0.8 color Black ]
	[1.0 color Black ]
      }
    }



global_settings {
  //adc_bailout 0.003922
  //ambient_light <1.0,1.0,1.0>
  //assumed_gamma 1.5
  //hf_gray_16 off
  //irid_wavelength <0.247059,0.176471,0.137255>
  //max_intersections 64
  max_trace_level 256
  //number_of_waves 10
#if (Radiosity=1)
  radiosity {
    brightness       1.0
    count            100
    distance_maximum 0.0
    error_bound      0.4
    gray_threshold   0.1
    low_error_factor 0.8
    minimum_reuse    0.015
    nearest_count    6
    recursion_limit  2
  }
#end
}


#if (Fog=1)
fog {
  fog_type 2
  fog_offset 0
  fog_alt 1.5
  distance 70
  color rgbt <0.89,0.66,0.16,0.27>
}
#end


light_source {
  <0,0,0>
  color C_Sun
  translate <0.0,Sun_Height,100000.0>
}

camera {
  perspective
  location Camera_Pos
  sky <0, 1, 0>
  angle 96.0
  right <1.8, 0, 0>
  up <0, 1, 0>
  look_at Camera_Pos + Camera_Vec
}


/*
camera {
  perspective
  location <Boat_X,30,Boat_Z>
  sky <0, 1, 0>
  angle 96.0
  right <1.8, 0, 0>
  up <0, 1, 0>
  look_at <Boat_X,0,Boat_Z-1>
}

light_source {
  <Boat_X,50,Boat_Z>
  color <1,1,1>
}
*/

sky_sphere { // Sky
  pigment {
    SkyPigment
    translate <.25,0,0>
  }
}

// Sun
sphere {
  <0,0,0>,1

  hollow
  no_shadow

  texture {
    pigment { 
      color rgb <1,1,1> 
    }
    finish {
      ambient 1.0
    }
  }
 
  scale Sun_Radius
  translate <0.0,Sun_Height,100000.0>
  
}


// Sun halo
disc {
  <0,0,0>, -z, 3.5
  hollow
  no_shadow

  texture{
        pigment{
	  cylindrical
            //poly_wave 2
            color_map{
                [0.0 Clear]
                [0.6 rgbt <1,1,1,0>]
                [1 rgbt <1,1,1,0>]
            }
        } 
        finish{ambient 1}
    scale 3.5
    rotate x*90
    }
  scale Sun_Radius
  translate <0.0,Sun_Height,100000.0>
  }

// Water
plane {
  y, 0
  texture {
    pigment { color rgb <0,0.03,0.1> }

    finish {
      ambient 0
      diffuse 0
      reflection {0.7, 1 fresnel}
      conserve_energy
      specular 0.8 roughness 0.01
    }

    normal {
      #declare LeftOar_X = Boat_X + 3.0;
      #declare LeftOar_Z = Boat_Z - 6.2;
      
      #declare aa = 0.5;
      #declare ff = 3;
      #declare vv = 0.53;
      #declare vbx = 0.51 * 0.34;
      #declare vbz = 0.51* 0.94;
      #declare c_X = Boat_X - 7*0.34;
      #declare c_Z = Boat_Z - 7*0.94;

      function {
	0.01 * f_ridged_mf (x/0.1, y/0.15, z/0.1, 0.1, 3.0, 7, 0.7, 0.7, 2) / max(1,0.001* sqrt(pow(x/0.1,2)+pow(z/0.1,2))) +
	2*f_waves(Boat_X-1-x,0,Boat_Z-6.0-z) / max(1,0.5*sqrt( pow(Boat_X-1-x,2) + pow(Boat_Z-6.0-z,2))) +
	3*f_waves((LeftOar_X-x)/0.2,0,(LeftOar_Z-z)/0.2) / max(1,0.5 * (pow((LeftOar_X-x)/0.2,2) + pow((LeftOar_Z-z)/0.2,2)))
	+
	// doppler effect for boat wake
	0.5+aa*cos( sqrt((x-c_X)*(x-c_X)+(z-c_Z)*(z-c_Z)) * ff * (vv / (vv + (vbx*(x-c_X) + vbz*(z-c_Z))/sqrt((x-c_X)*(x-c_X)+(z-c_Z)*(z-c_Z))))) / max(0.3,0.5*pow(sqrt((pow(x-c_X,2))+pow(z-c_Z,2)),3))
      
      }
    }
  }
  
  interior {
    ior 1.333
  }
  
}


#if (Coordinates=1)
  #declare Height = .1;
  #declare XLimit = 100;
  #declare ZLimit = 100;
  #declare XC = 0;
  #declare ZC = 0;

  #while (XC<=XLimit)
    cylinder {
      <XC,Height,0>,
      <XC,Height,ZLimit>,
      0.05
      pigment {	color Red }
      finish { ambient 0.6 }
    }
    #declare XC = XC+5;
  #end

  #while (ZC<=ZLimit)
    cylinder {
      <0,Height,ZC>,
      <XLimit,Height,ZC>,
      0.05
      pigment {	color Red }
      finish { ambient 0.6 }
    }
    text {
      ttf "timrom.ttf" str(ZC,0,0) .1, 0
      pigment {	color Red }
      finish { ambient 0.6 }
      translate <-2,Height,ZC>
    }
    #declare ZC = ZC+5;
  #end

#end


// Background forest
plane {
  -z, 0
  hollow
  photons { pass_through }
  rotate <0,55,0>
  translate <0,0,1150000>
  texture {
    pigment {
      image_map {
	png "bgforest.png" 
	once
      }
      scale 1000 * <1800,40,1>
      translate 1000 * <-800,0,0>
    }
  }
}

// Island (near)
disc {
  <0,0,0>, -z, 1
  hollow
  photons { pass_through }
  texture {
    pigment {
      image_map {
	png "island.png" 
	interpolate 2
	once
      }
      scale 1.3
      translate <-0.75,-0.1,0>
    }
  }
  scale <700,170,1> * 0.2 
  rotate <0,56,0>
  translate <128,0,300>
}


#if (Rocks=1)

#declare StoneTexture = texture {
  pigment { color rgb <15,8,0>/255 }
  normal { bumps 0.1 scale 0.1 }
}
  
// Lots of rocks to the left of the near island
#declare stoneI = 0;
#declare stoneNum = 40;
#while (stoneI<=stoneNum)
blob {
  threshold 0.5
  
  #declare Pos1 = VRand_In_Sphere(Seed);
  #declare Rad1 = RRand(1.0,2.0,Seed);
  #declare Pos2 = VRand_In_Sphere(Seed);
  #declare Rad2 = RRand(1.0,2.0,Seed);
  #declare Pos3 = VRand_In_Sphere(Seed);
  #declare Rad3 = RRand(1.0,2.0,Seed);
  
  sphere { Pos1, Rad1, 1 }
  sphere { Pos2, Rad2, 1 }
  sphere { Pos2, Rad2, 1 }
  
  texture { StoneTexture }
  #declare ra = RRand(0,365,Seed);
  #declare rd = abs(Rand_Gauss(0,80,Seed));
  scale <1.4,1,1.4>
  scale 1+max(-0.9,Rand_Gauss(0,0.5,Seed))
  translate <cos(ra)*rd,RRand(-0.02,0,Seed),sin(ra)*rd>
  translate <38, 0, 350> 
}    
  #declare stoneI = stoneI+1;
#end


// Island (far)
disc {
  <0,0,0>, -z, 1
  hollow
  photons { pass_through }
  texture {
    pigment {
      image_map {
	png "island2.png" 
	interpolate 2
	once
      }
      scale 1.3
      translate <-0.75,-0.1,0>
  }
  }
  scale <1472,224,1> * 0.2 * 0.5
  rotate <0,56,0>
  translate <890,0,410>
}


#declare Stone1 = isosurface {
  function { f_sphere(x, y, z, 1.2) - f_noise3d(x, y, z) }
  contained_by { box { -2,2 } }
  accuracy 0.01
  texture { StoneTexture }
  scale <1,0.55,1>
  translate <0,-0.1,0>
}


#declare Stone2 = isosurface {
  function { f_sphere(x, y, z, 1.2) - 1.2*f_noise3d(x, y, z) }
  contained_by { box { -2,2 } }
  accuracy 0.01
  texture { StoneTexture }
  scale <1,1,1>
  translate <0,-0.1,0>
}


#declare Stone3 = isosurface {
  function { f_sphere(x, y, z, 1.2) - 1.0*f_ridged_mf(x,y,z, 0.7, 2.0, 4, 0.3, 1.4, 3) }
  contained_by { box { -2,2 } }
  accuracy 0.01 
  texture { StoneTexture }
  scale <1,.9,1.1>
  translate <0,-0.1,0>
}


#declare SmallIsland = isosurface {
  function { f_sphere(x, y, z, 1.2) - f_ridged_mf(x,y,z, 0.5, 2.0, 4, 0.3, 1.4, 3) }
  contained_by { box { -2,2 } }
  accuracy 0.01
  texture { StoneTexture }
  scale <7,2,7>
  translate <0,-1,0>
}

// Background
object { Stone1 scale 3.5 translate <140,0,160> }
object { Stone2 translate <-20,0,190> }
object { Stone3 scale 0.8 translate <-23,0,190> }
object { Stone2 scale 0.4 translate <-26,0,190> }
object { Stone3 scale 0.4 translate <50,0,100> }
object { Stone2 rotate <0,45,0> translate <150,0,100> }
object { Stone1 scale 1.2 rotate <0,15,0> translate <163,0,102> }

// this rock covers a render artifact at the far island
object { Stone1 scale <2,4.2,3> rotate y*49 translate <200,0,60> }

#declare Tern = object {
  #include "tern1.inc"
  scale 0.045
  rotate <-90,55+180,0>
  texture {
    pigment { color White }
  }
}

// Tern on near rock
object {
  Tern
  translate <12,0.6,12>
}
object { Stone1 scale 0.8 rotate y*20 translate <12,-0.1,12> }

// Tern on far rock
object {
  Tern
  translate <40,1.8,10>
}


// Close up
object { SmallIsland translate <30,0,15> }
object { Stone1 translate <20,0,10> }
object { Stone2 translate <40,0,10> }
object { Stone3 translate <25,0,7> }
object { Stone1 scale 0.6 translate <24,0,24> }
object { Stone3 scale 0.2 translate <23,0,21> }
object { Stone3 scale 0.3 rotate y*40 translate <14,-0.5,13> }

object { Stone2 scale 0.3 rotate y*10 translate <15,-0.1,8> }
object { Stone1 scale 0.2 rotate y*11 translate <13,0,6.5> }
object { Stone3 scale 0.1 rotate y*110 translate <13,0,5.8> }



// Lots of small pebbles around small island
#declare stoneI = 0;
#declare stoneNum = 5000;
#while (stoneI<=stoneNum)
  sphere { 
    <0,0,0>, 0.09
    texture { StoneTexture }
    #declare ra = RRand(0,365,Seed);
    #declare rd = 8.1+abs(Rand_Gauss(0,1,Seed));
    scale <1,0.7,1>
    scale 1+max(-0.9,Rand_Gauss(0,0.3,Seed))
    translate <cos(ra)*rd,RRand(-0.02,0,Seed),sin(ra)*rd>
    translate <30, 0, 15> 
  }
    
  #declare stoneI = stoneI+1;
#end

// A few larger pebbles around small island
#declare stoneI = 0;
#declare stoneNum = 200;
#while (stoneI<=stoneNum)
blob {
  threshold 0.5
  
  #declare Pos1 = VRand_In_Sphere(Seed);
  #declare Rad1 = RRand(1.0,2.0,Seed);
  #declare Pos2 = VRand_In_Sphere(Seed);
  #declare Rad2 = RRand(1.0,2.0,Seed);
  #declare Pos3 = VRand_In_Sphere(Seed);
  #declare Rad3 = RRand(1.0,2.0,Seed);
  
  sphere { Pos1, Rad1, 1 }
  sphere { Pos2, Rad2, 1 }
  sphere { Pos2, Rad2, 1 }
  
  texture { StoneTexture }

  #declare ra = RRand(0,365,Seed);
  #declare rd = 8.0+abs(Rand_Gauss(0,1,Seed));
  scale <0.3,0.2,0.3>
  scale 1+max(-0.9,Rand_Gauss(0,0.5,Seed))
  translate <cos(ra)*rd,RRand(-0.02,0,Seed),sin(ra)*rd>
  translate <30, 0, 15> 
}
  #declare stoneI = stoneI+1;
#end

#end

#if (Reeds=1)

  #declare ReedTexture = texture
  {
      pigment {
	wood
	color_map  {
	  [0.0 rgbf <196,131,50,240>/255 ]
	  [1.0 rgbf <1.0,0.83,0.39,240/255> ]
	}
	turbulence 1.5
	scale 0.01
	//color rgbf <196,131,50,240>/255
      }
    
    finish {
      ambient 0.15
    }
  }
  
// The following was generated by my tree modeller
#declare Reed = object {
union {
cone {
<0,0,-2.16667>,0.13,<0,0,0>,0.112667
texture { ReedTexture }
matrix <1,0,0,
0,0.999391,0.0348995,
0,-0.0348995,0.999391,
0,-0.0756156,2.16535>
}
sphere {
<0,-0.0756156,2.16535>,0.112667
texture { ReedTexture }
}
cone {
<0,0,-2.16667>,0.112667,<0,0,0>,0.0953333
texture { ReedTexture }
matrix <1,0,0,
0,0.997564,0.0697565,
0,-0.0697565,0.997564,
0,-0.226755,4.32674>
}
sphere {
<0,-0.226755,4.32674>,0.0953333
texture { ReedTexture }
}
cone {
<0,0,-2.16667>,0.0953333,<0,0,0>,0.078
texture { ReedTexture }
matrix <1,0,0,
0,0.994522,0.104528,
0,-0.104528,0.994522,
0,-0.453233,6.48153>
}
sphere {
<0,-0.453233,6.48153>,0.078
texture { ReedTexture }
}
cone {
<0,0,-2.16667>,0.078,<0,0,0>,0.0606667
texture { ReedTexture }
matrix <1,0,0,
0,0.990268,0.139173,
0,-0.139173,0.990268,
0,-0.754775,8.62711>
}
sphere {
<0,-0.754775,8.62711>,0.0606667
texture { ReedTexture }
}
cone {
<0,0,-2.16667>,0.0606667,<0,0,0>,0.0433333
texture { ReedTexture }
matrix <1,0,0,
0,0.984808,0.173648,
0,-0.173648,0.984808,
0,-1.13101,10.7609>
}
sphere {
<0,-1.13101,10.7609>,0.0433333
texture { ReedTexture }
}
/*
  cone {
<0,0,-2.16667>,0.0433333,<0,0,0>,0.026
texture { ReedTexture }
matrix <1,0,0,
0,0.978148,0.207912,
0,-0.207912,0.978148,
0,-1.58149,12.8802>
}
  */
  cylinder {
<0,0,-2.16667>,<0,0,0>,0.1
texture { ReedTexture }
matrix <1,0,0,
0,0.978148,0.207912,
0,-0.207912,0.978148,
0,-1.58149,12.8802>
}

  sphere {
<0,-1.58149,12.8802>,0.1
texture { ReedTexture }
}
}
  scale 0.2
  rotate x*-90
  rotate y*180
}


// Reed patch I
#declare reedI = 0;
#declare reedNum = 600;
#while (reedI<=reedNum)
  object { 
    Reed 
    #declare thePos = 7*<VRand_In_Sphere(Seed).x,0,VRand_In_Sphere(Seed).y>;
    scale <1,0.8*f_ridged_mf(thePos.x,thePos.y,thePos.z,0.5,3,3,1.0,1.0,2.0),1>
    rotate <0,RRand(0,90,Seed),0>
    rotate <0,0,RRand(-1,6,Seed)>
    translate thePos
    translate <34, 0, 20> 
  }
    
  #declare reedI = reedI+1;
#end

// Reed patch II
#declare reedI = 0;
#declare reedNum = 50;
#while (reedI<=reedNum)
  object { 
    Reed 
    #declare thePos = 2*<VRand_In_Sphere(Seed).x,0,VRand_In_Sphere(Seed).y>;
    scale <1,0.8*f_ridged_mf(thePos.x,thePos.y,thePos.z,0.5,3,3,1.0,1.0,2.0),1>
    rotate <0,RRand(0,90,Seed),0>
    rotate <0,0,RRand(-1,6,Seed)>
    translate <thePos.x*0.3,thePos.y,thePos.z>
    translate <20, 0, 20> 
  }
    
  #declare reedI = reedI+1;
#end

// Floating reed debris
#declare reedI = 0;
#declare reedNum = 200;
#while (reedI<=reedNum)
  cylinder { 
    <0,0,0>, <0.2,0,0>, 0.02

    texture { ReedTexture }

    #declare thePos = 8*<VRand_In_Sphere(Seed).x,0,VRand_In_Sphere(Seed).y>;
    scale <RRand(0.8,1.2,Seed),1,1>
    rotate <0,RRand(0,180,Seed),0>
    translate <thePos.x*0.3,thePos.y,thePos.z>
    translate <18, 0, 18> 
  }
    
  #declare reedI = reedI+1;
#end
  
// Reed patch III
#declare reedI = 0;
#declare reedNum = 100;
#while (reedI<=reedNum)
  object { 
    Reed 
    #declare thePos = 2.5*<VRand_In_Sphere(Seed).x,0,VRand_In_Sphere(Seed).y>;
    scale <0.55,0.2*f_ridged_mf(thePos.x,thePos.y,thePos.z,0.5,3,3,1.0,1.0,2.0),0.55>
    rotate <0,RRand(0,360,Seed),0>
    rotate <0,0,RRand(-1,1,Seed)>
    translate <thePos.x,thePos.y,thePos.z>
    translate <16, 0, 7> 
  }
    
  #declare reedI = reedI+1;
#end

// Floating reed debris
#declare reedI = 0;
#declare reedNum = 50;
#while (reedI<=reedNum)
  cylinder { 
    <0,0,0>, <0.1,0,0>, 0.01

    texture { ReedTexture }

    #declare thePos = 2.5*<VRand_In_Sphere(Seed).x,0,VRand_In_Sphere(Seed).z>;
    scale <RRand(0.8,1.2,Seed),1,1>
    rotate <0,RRand(0,180,Seed),0>
    translate <thePos.x,thePos.y,thePos.z>
    translate <16, 0, 7> 
  }
    
  #declare reedI = reedI+1;
#end
  
#end


#if (Mist=1)

  box {
    <-100,0,1>,
    <200,9.35,220>

    hollow
    
    pigment { color Clear }
    interior {
      media {
	scattering {
	  //2 White / 100
	  2 color rgb <1.0,0.9,0.5> / 110
	  extinction 0.9
	}
	//absorption 0.05
	density {
	  gradient -y
	  turbulence <1.5,1.9,1.5>
	  octaves 5
	  noise_generator 3
	  density_map {
	    [0.0 color rgb 0 ]
	    [0.1 color rgb 0 ]
	    [0.2 color rgb 0.14 ]
	    [0.5 color rgb 0.14 ]
	    [0.6 color rgb 0 ]
	    [1.0 color rgb 0 ]
	  }
	  scale <40,9.35,40>
	}
      }
    }
  }
  
  sphere {
    <0,0,0>, 1
    
    hollow
    pigment {
      color Clear
    }
    interior {
      media {
	scattering{ 2 color rgb <1.0,0.9,0.45> / 90 extinction 0.95}
	intervals Intervals
	density {
	  density_file df3 "cloud1_1.df3"
	  turbulence 0.35
	  lambda 3
	  interpolate 1
	  translate -0.5
	  scale <1,-1,1>
	}
	scale <2,2,2>
      }
    }
    scale <25.0,19.0,25.0>
    translate <0,1,20>
  }
  
#end


#macro Cloud(DF3File)
    sphere {
      <0,0,0>, 1
      
      hollow
      pigment {
	#if (SolidClouds=1)
	  color rgbf <0, 1, 0, 0.5>
	#else
	  color Clear
	#end
      }
      
      
      #if  (SolidClouds!=1)
      interior {
	media {
	    scattering{1,C_Scattering extinction 0.15}
	    absorption C_Absorption
	    emission C_Emission
	    intervals Intervals
	    density {
	      density_file df3 DF3File
	      turbulence 0.15
	      lambda 3
	      interpolate 1
	      translate -0.5
	      scale <1,-1,1>
	    }
	  scale <2,2,2>
	}
      }
      #end
    }
#end
  

#if (Clouds=1)

light_group {

  light_source {
    <0,0,0>
    color rgb C_Sun
    translate <0.0,10.0,10000.0>
  }
  union {
    object { Cloud("cloud2_1.df3") scale <300,140,300>  translate <0,220,600> }
    object { Cloud("cloud2_1.df3") scale <300,140,300> translate <630,220,600> }
    object { Cloud("cloud2_2.df3") scale <300,180,300> translate <800,230,1000> }
    object { Cloud("cloud2_2.df3") scale <300,180,300> translate <5000,250,1200> }
    object { Cloud("cloud2_3.df3") scale <300,180,300> translate <3000,250,600> }
    
    object { Cloud("cloud2_3.df3") scale <300,180,300> translate <500,250,0> } // near right
    
    object { Cloud("cloud2_4.df3") scale <300,140,300>  translate <0,220,1400> }
    object { Cloud("cloud2_4.df3") scale <500,140,500>  translate <2800,220,1200> }
    
    object { Cloud("cloud2_4.df3") scale <650,140,550>  translate <2000,220,2000> } // far center

    object { Cloud("cloud2_5.df3") scale <300,140,300>  translate <-480,240,2999> } // far left
  }
}
#end


#if (Boat=1)
  #include "boat.inc"
  object { 
    Boat 
    scale 0.058
    rotate <0,200,0> 
    translate Boat_Pos
  }
  
#end

