/*
   ----------------      Light and Fog - IRTC Competition       ------------------------
   ----------------               hideaway.pov                  ------------------------
   ----------------               30.June 2006                  ------------------------
   ----------------       copyright by Norbert W. Kern          ------------------------
   ----------------      norbert-werner.kern@t-online.de        ------------------------ 
*/

// this is a demo scene with cylinders instead of meshes.
// render with aspect ratio 16:9 (+w1024 +h576)

#declare focal_blur_  = 0;   // too slow for final render - 1 for test; 2 for final
#declare area_light_  = 0;   // too slow for final render
#declare atmosphere_  = 2;   // 1 for test; 2 for final render
#declare background_  = 1;
#declare shadow_trees = 1;
#declare big_plants_  = 1;
#declare main_roses_  = 1;
#declare other_plants = 1;

#version unofficial MegaPov 1.21;
                
global_settings {
        #declare a_g = 2.2;
        assumed_gamma a_g
        max_trace_level 150
        noise_generator 2
        radiosity {                                
                pretrace_start 0.08
                pretrace_end   0.02
                low_error_factor 0.5
                count 40
                error_bound 2                
                nearest_count 1      
                recursion_limit 2      
                gray_threshold 0.3  
                minimum_reuse 0.015 
                brightness 2.5      
                adc_bailout 0.005
                normal on
                media off                          
        }
}

#include "functions.inc"
#include "transforms.inc"        
//_________________________________________________________________________________    
// camera
#declare cam_loc = vaxis_rotate (<37,0,2.2-0.64>,x,-90);
#declare lookat = vaxis_rotate (<37,1,1.8315-0.4>,x,-90);
#declare cam_ang = 64.8;

#declare cam_mirror = -1;                                                // 1 for normal / -1 for mirror image
#declare cam_z = 0.5*16/9/tan(radians(cam_ang*0.5));                     // amount of camera zoom
#declare cam_a = cam_mirror*16/9;                                        // camera aspect ratio
#declare cam_s = y;                                                      // camera sky vector
#declare cam_d = vnormalize (lookat-cam_loc);                            // camera direction vector
#declare cam_r = vnormalize (vcross(cam_s,cam_d));                       // camera right vector
#declare cam_up = vnormalize (vcross(cam_d,cam_r));                      // camera up vector
#declare cam_dir = cam_d*cam_z;                                          // direction vector scaled
#declare cam_right = cam_r*cam_a;                                        // right vector scaled

camera {
        location cam_loc
        up cam_up
        right cam_right
        direction cam_dir
        #if (focal_blur_ = 1) aperture 0.04 blur_samples 30 focal_point <38.005,1.244,-5.206+0.3> confidence 0.95 variance 0.005 #end  // test
        #if (focal_blur_ = 2) aperture 0.04 blur_samples 90 focal_point <38.005,1.244,-5.206+0.3> confidence 0.95 variance 0.0005 #end 
}

// for rendering from above - added camera vector in red - no atmosphere
//camera {location (<37,200,0>+(lookat-cam_loc)*33) look_at (<37,0,0>+(lookat-cam_loc)*33) sky lookat-cam_loc right image_width/image_height*x angle cam_ang*0.6} cylinder {cam_loc,lookat+(lookat-cam_loc)*100,0.1 pigment {color rgb <1,0,0>} finish {ambient 0 diffuse 1}} #declare atmosphere_ = 0;
              
//_________________________________________________________________________________    
// light
#declare lights = <-1,1,-0.7>*1000;
        
#macro G(Color,g)
        <pow(Color.x,g),pow(Color.y,g),pow(Color.z,g)>
#end
        
light_source {
        lights,
        G(<1,0.836,0.567>*7,1/a_g)*8/3.8 
        #if (area_light_ = 1) area_light <20,0,0> <0,0,20> 3,3 adaptive 0 jitter circular orient #end
}  

#declare Gamma = 2.2/a_g;
//_________________________________________________________________________________    
// sky
sky_sphere {
        pigment{
                gradient y 
                color_map {
                        [0.0 rgb 1*1.25*2*1.5]
                        [0.4 rgb G(<0.4,0.4,0.4>,1/a_g)*1.25*2.5*1.5]
                        [0.7 rgb G(<0.02,0.08,0.3>,1/a_g)*1.25*2.5*1.5]
                        [1.0 rgb G(<0.005,0.02,0.3>,1/a_g)*1.25*2.5*1.5]
                }
                scale 2 
                translate -1
        }
}
//_________________________________________________________________________________    
// atmosphere
#if (atmosphere_ != 0) 
difference {
        sphere {0,50}
        sphere {0,0.1}
        hollow
        material {
                texture {pigment {color rgbt 1}}
                interior {
                        media {
                                scattering {1, rgb 0.01*G(<0.567,0.836,1>,0.6)} 
                                absorption rgb 0.002
                                #if (atmosphere_ = 1) intervals 5 samples 5 #end
                                #if (atmosphere_ = 2) intervals 8 samples 8 #end
                                method 1
                        }
                }
        }
        translate cam_loc
}
#end
//_________________________________________________________________________________    
// land
#include "landscape5a.inc"
object {landscape5 hollow double_illuminate}

plane {
        y,-0.2 hollow double_illuminate
        texture {
                pigment {image_map {jpeg "grassmap" interpolate 2} rotate x*90}
                finish {ambient 0 diffuse 0.5}                                             
                scale 0.25
        }
} 

//_________________________________________________________________________________    
// plants                                                                                       
#if (big_plants_ = 1)                                                                                                                                                                                                                                          
object {                                                                                                                          
        cylinder {0,3.402546*y,0.17}
        texture {
                pigment {color rgb <128,116,96>/255}
                finish {specular 0.2 roughness 0.0025 diffuse 0.6*1 ambient 0}
        }
        double_illuminate hollow scale 1.4                                                      // mitte vorderer          
        translate vaxis_rotate (<35.483875 ,14.51613 ,1.587932>,x,-90)                                                            
}                                                                                                                                 
object {                                                                                                                          
        cylinder {0,3.402546*y,0.17}
        texture {
                pigment {color rgb <128,116,96>/255}
                finish {specular 0.2 roughness 0.0025 diffuse 0.6*1 ambient 0}
        }
        double_illuminate hollow scale 1.5 rotate y*180                                         // links oben aussen       
        translate <58.99055,1.30314,-35.19223>                                                                                    
}                                                                                                                                 
                                                                                                                                                                                                                                          
object {                                                                                                                          
        cylinder {0,1.821667*y,0.09}
        texture {
                pigment {color rgb <100,102,97>/255}
                finish {specular 0.2 roughness 0.025 diffuse 0.6*1 ambient 0}
        }
        double_illuminate hollow scale 1.3                                                      // mitte halbhinten        
        translate vaxis_rotate (<35.483875,14.51613,1.587932>*0.35+<43.548393,24.19355,0.9>*0.65,x,-90)                           
}                                                                                                                                 
object {                                                                                                                         
        cylinder {0,1.821667*y,0.09}
        texture {
                pigment {color rgb <100,102,97>/255}
                finish {specular 0.2 roughness 0.025 diffuse 0.6*1 ambient 0}
        }
        double_illuminate hollow scale 1.3 rotate y*180                                         // rechts oben aussen      
        translate <22.47889,1.24914-0.1,-23.63917>                                                                                
}                                                                                                                                 
                                                                                                                                                                                                                                                                        
object {                                                                                                                          
        cylinder {0,11.26424*z,0.55}
        texture {
                pigment {color rgb <84,84,79>/255}
                finish {specular 0.2 roughness 0.025 ambient 0 diffuse 0.45}
        }
        double_illuminate hollow scale 0.85 rotate x*-90                                        // hinterer halblinks                            
        scale 0.72*1.115 rotate y*21.9191 rotate <-1.9113,180,-22.673*0.4>                                                        
        translate vaxis_rotate (<43.548393 ,24.19355 ,0.594861>,x,-90)                                                            
}                                                                                                                                 
object {                                                                                                                          
        cylinder {0,11.26424*z,0.55}
        texture {
                pigment {color rgb <84,84,79>/255}
                finish {specular 0.2 roughness 0.025 ambient 0 diffuse 0.45}
        }
        double_illuminate hollow scale 0.85 rotate x*-90                                        // hinten halbrechts       
        scale 0.72*1.1*0.93*1.1 rotate y*92.5391 rotate <3.62456,180,17.3731*0.4>                           
        translate vaxis_rotate (<29.032263-4,37.09678 ,1.508486-0.7>,x,-90)
}                                                                                                       
#end 

#if (background_ = 1)

#declare box_length = 1000;
#declare box_depth = box_length-50;
#declare abstand = 17;

#declare sd = seed (45);

#declare treeshadowbox =
union {
        box {
                <0,0,-3>,<box_length,box_depth,-0.2>
                texture {
                        pigment {image_map {jpeg "grassmap" interpolate 2}}
                        finish {ambient 0 diffuse 0.5}                                             
                        scale 0.25
                }
        }
        #declare n = box_length;
        #while (n>0)
                #declare m = box_depth;
                #while (m>0)
                        object {
                                cylinder {0,0.9787*y,0.06}
                                texture {
                                        pigment {color rgb (<0.3843137,0.2294118,0.1019608>+<0.4117647,0.2568628,0.1294118>)*0.5}
                                        finish {diffuse 0.2 ambient 0}
                                }
                                double_illuminate hollow scale 30 rotate x*90 
                                scale (2+rand(sd))*0.4 
                                rotate <rand(sd)*10,rand(sd)*10,rand(sd)*360> 
                                translate <n+(rand(sd)-0.5)*abstand*0.5,m+(rand(sd)-1)*abstand*0.5,-0.2>
                        }
                        #declare m = m-abstand;
                #end
                #declare n = n-abstand;
        #end
}

union {
        object {treeshadowbox translate <-25,25,0> translate <40,24.2,0>}
        object {treeshadowbox translate <-25,25,0> rotate z*90 translate <40,24.2,0>}
        object {treeshadowbox translate <-25,25,0> rotate z*180 translate <40,24.2,0>}
        object {treeshadowbox translate <-25,25,0> rotate z*270 translate <40,24.2,0>}
        rotate x*-90
}            

object {
        cylinder {0,36.97501*y,1.1}
        texture {
                pigment {color rgb <88,88,97>/255}
                finish {diffuse 0.4 ambient 0}
        }
        double_illuminate hollow scale 0.9787/36.97051*22
        translate <0.1355,-0.2,-60.0124>
}
object {
        cylinder {0,36.97501*y,1.1}
        texture {
                pigment {color rgb <88,88,97>/255}
                finish {diffuse 0.4 ambient 0}
        }
        double_illuminate hollow scale 0.9787/36.97051*20 rotate y*90
        translate <6.5679,-0.2,-63.5167>
}
object {
        cylinder {0,36.97501*y,1.1}
        texture {
                pigment {color rgb <88,88,97>/255}
                finish {diffuse 0.4 ambient 0}
        }
        double_illuminate hollow scale 0.9787/36.97051*20 rotate y*180
        translate <13.4603,-0.2,-66.3805>
} 
object {
        cylinder {0,36.97501*y,1.1}
        texture {
                pigment {color rgb <88,88,97>/255}
                finish {diffuse 0.4 ambient 0}
        }
        double_illuminate hollow scale 0.9787/36.97051*22 rotate y*270
        translate <3.0697,-0.2,-61.7189>
}
object {
        cylinder {0,36.97501*y,1.1}
        texture {
                pigment {color rgb <88,88,97>/255}
                finish {diffuse 0.4 ambient 0}
        }
        double_illuminate hollow scale 0.9787/36.97051*22
        translate <18.3441,-0.2,-67.915>
}
#end

#if (shadow_trees = 1)                                                                                                         
object {                                                                                                                          
        cylinder {0,14.29155*y,0.7}
        texture {
                pigment {color rgb <126,107,89>/255}
                finish {specular 0.2 roughness 0.0025 diffuse 0.6 ambient 0}
        }
        double_illuminate hollow scale 0.6 rotate y*2                                                   // vorne links ausserhalb            
        translate vaxis_rotate (<41.935490 ,6.451613 ,0.594861>,x,-90)+<-0.2,-0.4,0>                                              
}                                                                                                                                                                                                                                         
object {                                                                                                                          
        cylinder {0,6.14989*y,0.3}
        texture {
                pigment {color rgb <139,125,126>/255}
                finish {phong 0.1 phong_size 256 diffuse 0.5 ambient 0}
        }
        hollow double_illuminate scale 1.1 rotate y*-10                                                 // vorne rechts ausserhalb 
        translate <28.538,0.113,-10.121>+0.5*(<28.538,0.113,-10.121>-<26.891,0.821,-19.359>)                                      
}                                                                                                                                 
object {                                                                                                                          
        cylinder {0,6.14989*y,0.3}
        texture {
                pigment {color rgb <139,125,126>/255}
                finish {phong 0.1 phong_size 256 diffuse 0.5 ambient 0}
        }
        hollow double_illuminate scale 1.3                                                              // hinten rechts          
        translate <26.891,0.821,-19.359>                                                                                          
}                                                                                                                                 
#end

#if (main_roses_ = 1) 
object {
        cylinder {0,1.523961*y,0.075}
        texture {
                pigment {color rgbt <211,90,93,25.5>/255}
                finish {specular 0.3 roughness 0.005 diffuse 0.6*0.65 ambient 0}
        }
        double_illuminate hollow scale 0.65                                                             // rechts oben            
        translate <35.73862,1.03381-0.23,-5.87065>                                                                                
}
object {                                                                                                                          
        cylinder {0,0.7477069*y,0.037}
        texture {
                pigment {color rgbt <211,90,93,25.5>/255}
                finish {specular 0.3 roughness 0.005 diffuse 0.6*0.65 ambient 0}
        }
        double_illuminate hollow                                                                        // links unten            
        translate <37.71371,0.30441-0.23,-3.32169>                                                                                
}
#end



//_________________________________________________________________________________________
#if (other_plants = 1)

#declare landscape = object {landscape5}
#declare area_min = vaxis_rotate(<15.5882,1.17647,-0.199595>,x,-90);
#declare area_max = vaxis_rotate(<64.4117,47.2954,2.42211>,x,-90);
#declare xrange = area_max.x-area_min.x;
#declare zrange = area_max.z-area_min.z;
#include "plants7.inc"

// reed / bush  ___________________________________________________________________________ 
#declare reed = array[5];
#declare reed[0] =
object {                                                                                                                          
        cylinder {0,19.9997*y,0.4}
        texture {
                pigment {color rgb <75,107,15>/255}
                finish {ambient 0 diffuse 0.6 specular 0.1 roughness 0.025}
        }
        double_illuminate hollow
        scale 0.06                                                                                                                                                                  
}

#declare reed[1] =
object {                                                                                                                          
        cylinder {0,17.9969*y,0.4}
        texture {
                pigment {color rgb <75,107,15>/255}
                finish {ambient 0 diffuse 0.6 specular 0.1 roughness 0.025}
        }
        double_illuminate hollow
        scale 0.06                                                                                                                                                                  
}

#declare reed[2] =
object {                                                                                                                          
        cylinder {0,20.0041*y,0.4}
        texture {
                pigment {color rgb <75,107,15>/255}
                finish {ambient 0 diffuse 0.6 specular 0.1 roughness 0.025}
        }
        double_illuminate hollow
        scale 0.06                                                                                                                                                                  
}

#declare reed[3] =
object {                                                                                                                          
        cylinder {0,19.2159*y,0.4}
        texture {
                pigment {color rgb <75,107,15>/255}
                finish {ambient 0 diffuse 0.6 specular 0.1 roughness 0.025}
        }
        double_illuminate hollow
        scale 0.06                                                                                                                                                                  
}

#declare reed[4] =
object {                                                                                                                          
        cylinder {0,17.8563*y,0.4}
        texture {
                pigment {color rgb <75,107,15>/255}
                finish {ambient 0 diffuse 0.6 specular 0.1 roughness 0.025}
        }
        double_illuminate hollow
        scale 0.06                                                                                                                                                                  
}

#declare dataobject = object {bush_pig}
#declare num = 2000;

#declare nseed = 1;
#declare r1 = seed(nseed);  
#declare r2 = seed(nseed);
#declare r3 = seed(nseed);
#declare n = 0;

#declare reeds = union {
#while (n < num)
        #declare xrand = rand(r1)*xrange;
        #declare zrand = rand(r1)*zrange;                      
        #declare start = <xrand+area_min.x,area_max.y+1,zrand+area_min.z>;
        #declare norm1 = <0,0,0>;
        #declare inter1 = trace (dataobject,start,-y,norm1);
        #if (vlength(norm1) != 0)
                #declare norm = <0,0,0>; 
                #declare inter = trace (landscape,start,-y,norm);
                #if (vlength(norm) != 0)                                   
                        #declare af = inter.x;
                        #declare ag = inter.y;
                        #declare ah = inter.z;
                        #declare ab = (1.5+rand(r3))/2*0.78;
                        #declare ac = 360*rand(r1);
                        #declare ad = 4*rand(r1);
                        #declare ae = 360*rand(r1); 
                        #declare aj = 0.03*degrees(atan2(norm.z,norm.y));
                        #declare ak = 0.03*-degrees(atan2(norm.x,norm.y));
                        #declare ai = int(rand(r2)*5);
                        object { 
                                reed[ai]
                                scale ab
                                rotate y*ac
                                rotate <ad,ae,0>
                                rotate <aj,0,ak>
                                translate <af,ag,ah>
                        }
                        #declare n = n+1;
                        #if(mod(n,50)=0)
                                #debug concat(str(n,0,0)," of 2000 reeds placed.\n")
                        #end
                #end
        #end  
#end
}

// nettle  ________________________________________________________________________________ 
#declare nettle = array[8];
#declare nettle[0] =
object {                                                                                                                          
        cylinder {0,0.3344011*y,0.011*0.32}
        texture {
                pigment {color rgbt <188,124,7,25.5>/255}
                finish {specular 0.3 roughness 0.005 ambient 0 diffuse 0.45}
        }
        double_illuminate hollow 
        scale 5                                                                                                                                                                  
}

#declare nettle[1] =
object {                                                                                                                          
        cylinder {0,0.2456523*y,0.011*0.32}
        texture {
                pigment {color rgbt <179,139,4,25.5>/255}
                finish {specular 0.3 roughness 0.005 ambient 0 diffuse 0.45}
        }
        double_illuminate hollow 
        scale 5                                                                                                                                                                  
}

#declare nettle[2] =
object {                                                                                                                          
        cylinder {0,0.1912173*y,0.011*0.32}
        texture {
                pigment {color rgbt <167,152,3,25.5>/255}
                finish {specular 0.3 roughness 0.005 ambient 0 diffuse 0.45}
        }
        double_illuminate hollow 
        scale 5                                                                                                                                                                  
}
//_________________________________________________________________________________
#declare nettle[3] =
object {                                                                                                                          
        cylinder {0,0.3044085*y,0.011}
        texture {
                pigment {color rgb <66,122,35>/255}
                finish {specular 0.3 roughness 0.005 ambient 0 diffuse 0.55}
        }
        double_illuminate hollow 
        scale 2.5                                                                                                                                                                  
}

#declare nettle[4] =
object {                                                                                                                          
        cylinder {0,0.3285086*y,0.011}
        texture {
                pigment {color rgb <66,122,35>/255}
                finish {specular 0.3 roughness 0.005 ambient 0 diffuse 0.55}
        }
        double_illuminate hollow 
        scale 2.5                                                                                                                                                                  
}

#declare nettle[5] =
object {                                                                                                                          
        cylinder {0,0.4041605*y,0.011}
        texture {
                pigment {color rgb <66,122,35>/255}
                finish {specular 0.3 roughness 0.005 ambient 0 diffuse 0.55}
        }
        double_illuminate hollow 
        scale 2.5                                                                                                                                                                  
}
//_________________________________________________________________________________
#declare nettle[6] =
object {                                                                                                                          
        cylinder {0,27.03397*y,1.1}
        texture {
                pigment {color rgb <244,232,209>/255}
                finish {phong 0 phong_size 0 ambient 0 diffuse 0.5}
        }
        double_illuminate hollow 
        scale 0.021                                                                                                                                                                  
}

#declare nettle[7] =
object {                                                                                                                          
        cylinder {0,28.46104*y,1.1}
        texture {
                pigment {color rgb <244,232,209>/255}
                finish {phong 0 phong_size 0 ambient 0 diffuse 0.5}
        }
        double_illuminate hollow 
        scale 0.021                                                                                                                                                                  
}

#declare dataobject = object {nettle_pig}
#declare num = 17500;

#declare nseed = 0;
#declare r1 = seed(nseed);  
#declare r2 = seed(nseed);
#declare r3 = seed(nseed);
#declare n = 0;

#declare nettles = union {
#while (n < num)
        #declare xrand = rand(r1)*xrange;
        #declare zrand = rand(r1)*zrange;                      
        #declare start = <xrand+area_min.x,area_max.y+1,zrand+area_min.z>;
        #declare norm1 = <0,0,0>;
        #declare inter1 = trace (dataobject,start,-y,norm1);
        #if (vlength(norm1) != 0)
                #declare norm = <0,0,0>; 
                #declare inter = trace (landscape,start,-y,norm);
                #if (vlength(norm) != 0)                                   
                        #declare af = inter.x;
                        #declare ag = inter.y;
                        #declare ah = inter.z;
                        #declare ab = (1.5+rand(r3))/2*0.5;
                        #declare ac = 360*rand(r1);
                        #declare ad = 30*rand(r1);
                        #declare ae = 360*rand(r1); 
                        #declare aj = 0.75*degrees(atan2(norm.z,norm.y));
                        #declare ak = 0.75*-degrees(atan2(norm.x,norm.y));
                        #declare ai = int(rand(r2)*8);
                        #if ((ai < 6.5)|((ai > 6.5)&(ag > 0)))
                                object { 
                                        nettle[ai]
                                        scale ab
                                        rotate y*ac
                                        rotate <ad,ae,0>
                                        rotate <aj,0,ak>
                                        translate <af,ag,ah>
                                }
                        #end
                        #declare n = n+1;
                        #if(mod(n,100)=0)
                                #debug concat(str(n,0,0)," of 17500 nettles placed.\n")
                        #end
                #end
        #end  
#end
}

// buttercup  _____________________________________________________________________________ 
#declare buttercup = array[6];
#declare buttercup[0] =
object {                                                                                                                          
        cylinder {0,0.4328848*y,0.022}
        texture {
                pigment {color rgb <255,222,0>/255}
                finish {specular 0.1 roughness 0.025 ambient 0 diffuse 0.6}
        }
        double_illuminate hollow 
        scale 1.2*0.9                                                                                                                                                                  
}

#declare buttercup[1] =
object {                                                                                                                          
        cylinder {0,0.4149792*y,0.022}
        texture {
                pigment {color rgb <255,222,0>/255}
                finish {specular 0.1 roughness 0.025 ambient 0 diffuse 0.6}
        }
        double_illuminate hollow 
        scale 1.2*0.9                                                                                                                                                                  
}

#declare buttercup[2] =
object {                                                                                                                          
        cylinder {0,0.3904683*y,0.022}
        texture {
                pigment {color rgb <255,222,0>/255}
                finish {specular 0.1 roughness 0.025 ambient 0 diffuse 0.6}
        }
        double_illuminate hollow 
        scale 1.2*0.9                                                                                                                                                                  
}
//_________________________________________________________________________________
#declare buttercup[3] =
object {                                                                                                                          
        cylinder {0,0.06883021*y,0.0034}
        texture {
                pigment {color rgb <218,215,205>/255}
                finish {ambient 0 diffuse 0.4}
        }
        double_illuminate hollow 
        scale 2.5                                                                                                                                                                  
}

#declare buttercup[4] =
object {                                                                                                                          
        cylinder {0,0.1603928*y,0.008}
        texture {
                pigment {color rgb <218,215,205>/255}
                finish {ambient 0 diffuse 0.4}
        }
        double_illuminate hollow 
        scale 2.5                                                                                                                                                                  
}

#declare buttercup[5] =
object {                                                                                                                          
        cylinder {0,0.1417683*y,0.007}
        texture {
                pigment {color rgb <218,215,205>/255}
                finish {ambient 0 diffuse 0.4}
        }
        double_illuminate hollow 
        scale 2.5                                                                                                                                                                  
}

#declare dataobject = object {buttercup_pig}
#declare num = 40000;

#declare nseed = 0;
#declare r1 = seed(nseed);  
#declare r2 = seed(nseed);
#declare r3 = seed(nseed);
#declare n = 0;

#declare buttercups = union {
#while (n < num)
        #declare xrand = rand(r1)*xrange;
        #declare zrand = rand(r1)*zrange;                      
        #declare start = <xrand+area_min.x,area_max.y+1,zrand+area_min.z>;
        #declare norm1 = <0,0,0>;
        #declare inter1 = trace (dataobject,start,-y,norm1);
        #if (vlength(norm1) != 0)
                #declare norm = <0,0,0>; 
                #declare inter = trace (landscape,start,-y,norm);
                #if (vlength(norm) != 0)                                   
                        #declare af = inter.x;
                        #declare ag = inter.y;
                        #declare ah = inter.z;
                        #declare ab = (1.5+rand(r3))/2*0.45;
                        #declare ac = 360*rand(r1);
                        #declare ad = 20*rand(r1);
                        #declare ae = 360*rand(r1); 
                        #declare aj = 0.25*degrees(atan2(norm.z,norm.y));
                        #declare ak = 0.25*-degrees(atan2(norm.x,norm.y));
                        #declare ai = int(rand(r2)*6);      //buttercup + daisy
                        object { 
                                buttercup[ai]
                                scale ab
                                rotate y*ac
                                rotate <ad,ae,0>
                                rotate <aj,0,ak>
                                translate <af,ag,ah>
                        }
                        #declare n = n+1;
                        #if(mod(n,200)=0)
                                #debug concat(str(n,0,0)," of 40000 buttercups placed.\n")
                        #end
                #end
        #end  
#end
}

// buttercup2  ____________________________________________________________________________ 
#declare back_dist = 1;
#declare cam_ang_up = degrees(2*atan2(0.5/cam_z,1));                     // camera angle in cam_up direction
#declare fz = vlength(cam_dir);
#declare fx = vlength(cam_right)/2;
#declare fy = vlength(cam_up)/2; 

#macro OrientZ(p1,p2,cs)          // looks like Reorient_trans macro!
        #declare nz = vnormalize(p2-p1);
        #declare nx = vnormalize(vcross(cs,nz)); 
        #declare ny = vcross(nz,nx);
        matrix <nx.x,nx.y,nx.z,ny.x,ny.y,ny.z,nz.x,nz.y,nz.z,p1.x,p1.y,p1.z>          
#end

#declare view_paint =
box { 
        <0,0,0> <1,1,0.1>
        pigment {color rgb 1}
        translate <-0.5,-0.5,0>
        scale 2*<cam_mirror*fx,fy,0.5>
        translate fz*z
        scale back_dist
        OrientZ (cam_loc,lookat,cam_up)
}

#declare view_pig =  
pigment {
        image_map {tga "hideaway_mask2" once map_type 0 interpolate 2}
        translate <-0.5,-0.5,0>
        scale 2*<cam_mirror*fx,fy,0.5>
        translate fz*z
        scale back_dist
        OrientZ (cam_loc,lookat,cam_up)
}

#declare manytrees_area =
object {landscape5}

#declare r1 = seed(1);
#declare r2 = seed(1);
#declare r3 = seed(1);
#declare r4 = seed(1); 
#declare n = 0;
#declare things_numb = 1000;
#declare buttercups2 = union {
#while (n < things_numb)
        #declare rnd_y = vaxis_rotate (cam_d,vcross (cam_d,cam_up),(rand(r1)-0.5)*cam_ang_up);
        #declare rnd_xy = vaxis_rotate (vnormalize (rnd_y),cam_up,(rand(r3)-0.5)*cam_ang);
        #declare Norm = <0,0,0>;
        #declare Inter = trace (manytrees_area,cam_loc,rnd_xy,Norm);
        #declare NormP = <0,0,0>;
        #declare InterP = trace (view_paint,cam_loc,rnd_xy,NormP);
        #declare effect_col = eval_pigment(view_pig,InterP).x;
        #if ((vlength (Norm) != 0)&(vlength (NormP) != 0)&(effect_col*rand(r3) > 0.1))
                #declare randdist = rand(r4);
                #declare ab = (0.7+0.6*rand(r1))*0.8*1.08*0.35;
                #declare ac = 360*rand(r2);
                #declare ad = 20*rand(r2);
                #declare ae = 360*rand(r2);         
                #declare ai = int(3*rand(r1));
                object { 
                        buttercup[ai]
                        scale ab
                        rotate y*ac
                        rotate <ad,ae,0>
                        translate Inter
                }
                #declare n = n+1; 
        #end
        #if(mod(n,10) = 0)
                #debug concat(str(n,0,0)," of 1000 buttercups2 placed\n")
        #end        
#end    
}

// grass  _________________________________________________________________________________ 
#declare grass = array[3];
#declare grass[0] =
object {                                                                                                                          
        cylinder {0,0.07605506*y,0.003}
        texture {
                pigment {color rgb <97,133,33>/255}
                finish {specular 0.5 roughness 0.005 ambient 0 diffuse 0.5}
        }
        double_illuminate hollow
        scale 5                                                                                                                                                                  
}

#declare grass[1] =
object {                                                                                                                          
        cylinder {0,0.0466884*y,0.003}
        texture {
                pigment {color rgb <97,133,33>/255}
                finish {specular 0.5 roughness 0.005 ambient 0 diffuse 0.5}
        }
        double_illuminate hollow 
        scale 5                                                                                                                                                                  
}

#declare grass[2] =
object {                                                                                                                          
        cylinder {0,0.04743973*y,0.003}
        texture {
                pigment {color rgb <97,133,33>/255}
                finish {specular 0.5 roughness 0.005 ambient 0 diffuse 0.5}
        }
        double_illuminate hollow 
        scale 5                                                                                                                                                                  
}

#declare dataobject = object {grass_pig}
#declare num = 175000;

#declare nseed = 0;
#declare r1 = seed(nseed);  
#declare r2 = seed(nseed);
#declare r3 = seed(nseed);
#declare n = 0;

#declare grasses = union {
#while (n < num)
        #declare xrand = rand(r1)*xrange;
        #declare zrand = rand(r1)*zrange;                      
        #declare start = <xrand+area_min.x,area_max.y+1,zrand+area_min.z>;
        #declare norm1 = <0,0,0>;
        #declare inter1 = trace (dataobject,start,-y,norm1);
        #if (vlength(norm1) != 0)
                #declare norm = <0,0,0>; 
                #declare inter = trace (landscape,start,-y,norm);
                #if (vlength(norm) != 0)                                   
                        #declare af = inter.x;
                        #declare ag = inter.y;
                        #declare ah = inter.z;
                        #declare ab = (1.5+rand(r3))/2*0.65;
                        #declare ac = 360*rand(r1);
                        #declare ad = 10*rand(r1);
                        #declare ae = 360*rand(r1); 
                        #declare aj = 0.95*degrees(atan2(norm.z,norm.y));
                        #declare ak = 0.95*-degrees(atan2(norm.x,norm.y));
                        #declare ai = int(rand(r2)*3);
                        object { 
                                grass[ai]
                                scale ab
                                rotate y*ac
                                rotate <ad,ae,0>
                                rotate <aj,0,ak>
                                translate <af,ag,ah>
                        }
                        #declare n = n+1;
                        #if(mod(n,200)=0)
                                #debug concat(str(n,0,0)," of 175000 grasses placed.\n")
                        #end
                #end
        #end  
#end
}

// dandelion  __________________________________________________________________________________ 
#declare dandelion =
object {                                                                                                                          
        cylinder {0,0.19*y,0.012}
        texture {
                pigment {color rgb <1,0.88,0>}
                finish {specular 0.2 roughness 0.003 ambient 0 diffuse 0.5}
        }
        double_illuminate hollow 
        scale 3.2                                                                                                                                                                  
}

#declare dataobject = object {dandelion_pig}
#declare num = 400;

#declare nseed = 0;
#declare r1 = seed(nseed);  
#declare r2 = seed(nseed);
#declare r3 = seed(nseed);
#declare n = 0;

#declare dandelions = union {
#while (n < num)
        #declare xrand = rand(r1)*xrange;
        #declare zrand = rand(r1)*zrange;                      
        #declare start = <xrand+area_min.x,area_max.y+1,zrand+area_min.z>;
        #declare norm1 = <0,0,0>;
        #declare inter1 = trace (dataobject,start,-y,norm1);
        #if (vlength(norm1) != 0)
                #declare norm = <0,0,0>; 
                #declare inter = trace (landscape,start,-y,norm);
                #if (vlength(norm) != 0)                                   
                        #declare af = inter.x;
                        #declare ag = inter.y;
                        #declare ah = inter.z;
                        #declare ab = (1.5+rand(r3))/2*0.5;
                        #declare ac = 360*rand(r1);
                        #declare ad = 20*rand(r1);
                        #declare ae = 360*rand(r1); 
                        #declare aj = 0.25*degrees(atan2(norm.z,norm.y));
                        #declare ak = 0.25*-degrees(atan2(norm.x,norm.y));
                        object { 
                                dandelion
                                scale ab
                                rotate y*ac
                                rotate <ad,ae,0>
                                rotate <aj,0,ak>
                                translate <af,ag,ah>
                        }
                        #declare n = n+1;
                        #if(mod(n,10)=0)
                                #debug concat(str(n,0,0)," of 400 dandelions placed.\n")
                        #end
                #end
        #end  
#end
}

// clover  _____________________________________________________________________________________ 
#declare clover = array[3];
#declare clover[0] =
object {                                                                                                                          
        cylinder {0,0.1964255*y,0.012}
        texture {
                pigment {color rgb <255,205,202>/255}
                finish {specular 0.2 roughness 0.005 ambient 0 diffuse 0.3}
        }
        double_illuminate hollow 
        scale 0.8                                                                                                                                                                  
}

#declare clover[1] =
object {                                                                                                                          
        cylinder {0,0.09344839*y,0.006}
        texture {
                pigment {color rgb <255,205,202>/255}
                finish {specular 0.2 roughness 0.005 ambient 0 diffuse 0.3}
        }
        double_illuminate hollow 
        scale 0.8*2.5                                                                                                                                                                  
}

#declare clover[2] =
object {                                                                                                                          
        cylinder {0,0.09854986*y,0.006}
        texture {
                pigment {color rgb <255,205,202>/255}
                finish {specular 0.2 roughness 0.005 ambient 0 diffuse 0.3}
        }
        double_illuminate hollow 
        scale 0.8*2.5                                                                                                                                                                  
}

#declare plant_ground =
union {
        object {landscape5}
        object {reeds}
        object {nettles}
        object {buttercups}
        object {buttercups2}
        object {grasses}
        object {dandelions}        
}

#declare plant_area =
object {landscape5}

#declare cam_angle = 64.8;
#declare cam_up = y;

#declare r1 = seed(0);
#declare r2 = seed(0); 
#declare r3 = seed(0);
#declare n = 0;
#while (n < 97)
        #declare rnd_y = vaxis_rotate (lookat-cam_loc,vcross (lookat-cam_loc,cam_up),(rand(r1)-0.5)*cam_angle);
        #declare rnd_xy = vaxis_rotate (rnd_y,cam_up,(rand(r1)-0.5)*cam_angle*16/9);
        #declare Norm1 = <0,0,0>;
        #declare Norm = <0,0,0>;
        #declare Inter1 = trace (plant_ground,cam_loc,rnd_xy,Norm1);
        #declare Inter2 = trace (plant_area,cam_loc,rnd_xy,Norm);
        #if (vlength (Norm) != 0)
                #if (vlength (Inter1-Inter2) < 1e-4)
                        #declare af = Inter2.x;
                        #declare ag = Inter2.y;
                        #declare ah = Inter2.z;
                        #declare ab = (1.5+rand(r3))/2*0.65;
                        #declare ac = 360*rand(r1);
                        #declare ad = 30*rand(r1);
                        #declare ae = 360*rand(r1); 
                        #declare aj = 0.75*degrees(atan2(Norm.z,Norm.y));
                        #declare ak = 0.75*-degrees(atan2(Norm.x,Norm.y));
                        #declare ai = int(rand(r2)*3);
                        object {
                                clover[ai] double_illuminate hollow                                 
                                scale ab
                                rotate y*ac
                                rotate <ad,ae,0>
                                rotate <aj,0,ak>
                                translate <af,ag,ah>
                        }
                #else
                        #declare n = n-1; 
                #end
        #else
                #declare n = n-1;
        #end
        #if(mod(n,2)=0)
                #debug concat(str(n,0,0)," of 97 clover1 placed.\n")
        #end
        #declare n = n+1;
#end

#declare r1 = seed(0);
#declare r2 = seed(0); 
#declare r3 = seed(0);
#declare n = 0;
#while (n < 1654)
        #declare rnd_y = vaxis_rotate (lookat-cam_loc,vcross (lookat-cam_loc,cam_up),(rand(r1)-0.5)*cam_angle);
        #declare rnd_xy = vaxis_rotate (rnd_y,cam_up,(rand(r1)-0.5)*cam_angle*16/9);
        #declare Norm = <0,0,0>;
        #declare Inter2 = trace (plant_area,cam_loc,rnd_xy,Norm);
        #if (vlength (Norm) != 0)
                #declare af = Inter2.x;
                #declare ag = Inter2.y;
                #declare ah = Inter2.z;
                #declare ab = (1.5+rand(r3))/2*0.65;
                #declare ac = 360*rand(r1);
                #declare ad = 30*rand(r1);
                #declare ae = 360*rand(r1); 
                #declare aj = 0.75*degrees(atan2(Norm.z,Norm.y));
                #declare ak = 0.75*-degrees(atan2(Norm.x,Norm.y));
                #declare ai = int(rand(r2)*3);
                object {
                        clover[ai] double_illuminate hollow                                 
                        scale ab
                        rotate y*ac
                        rotate <ad,ae,0>
                        rotate <aj,0,ak>
                        translate <af,ag,ah>
                }
        #else
                #declare n = n-1;
        #end        
        #if(mod(n,100)=0)
                #debug concat(str(n,0,0)," of 1654 clover2 placed.\n")
        #end
        #declare n = n+1;
#end 
//_________________________________________________________________________________           
object {reeds}
object {nettles}
object {buttercups}
object {buttercups2}
object {grasses}
object {dandelions}
#end