// Persistence of Vision Ray Tracer Include File
// File: ground.inc
// Vers: 3.6
// Desc: Various components describing the grounds around the megalithic site.
// Date: 21-June-2006
// Auth: Rick Wedgeworth
//
// Note: The units are in meters.

// ===== Set some useful constants ====

#declare NearGroundGirth  =  96.0;
#declare NearGroundHeight =   3.5;
#declare FarGroundGirth   = 760.0;
#declare FarGroundHeight  =  40.0;

// ===== Build some textures ====

#declare GGT1 = 2.7;
#declare GGT2 = 2.5;
#declare GGT3 = 5.6;
#declare GGT4 = 3.5;
#declare GroundGrassTexture = 
texture {
    pigment {
      radial
      turbulence 0.1
      pigment_map {
        [0.0 
              agate
              turbulence 0.3
              color_map {
                [0.00 color rgbf < 1.00, 1.00, 1.00, 1.00 > ]
                [0.30 color rgbf < 0.30, 0.50, 0.35, 1.00 > ]
                [0.70 color rgbf < 0.30, 0.60, 0.30, 1.00 > ]
                [1.00 color rgbf < 1.00, 1.00, 1.00, 1.00 > ]
              }
              scale <0.51/GGT2,1.01,0.1/GGT2>
        ]
        [0.9 
              agate
              turbulence 0.3
              color_map {
                [0.00 color rgbf < 1.00, 1.00, 1.00, 1.00 > ]
                [0.30 color rgbf < 0.35, 0.50, 0.30, 1.00 > ]
                [0.70 color rgbf < 0.30, 0.50, 0.30, 1.00 > ]
                [1.00 color rgbf < 1.00, 1.00, 1.00, 1.00 > ]
              }
              scale <0.1/GGT2,1.01,0.51/GGT2>
        ]
        [1.0 
              agate
              turbulence 0.3
              color_map {
                [0.00 color rgbf < 1.00, 1.00, 1.00, 1.00 > ]
                [0.30 color rgbf < 0.30, 0.50, 0.30, 1.00 > ]
                [0.70 color rgbf < 0.30, 0.50, 0.30, 1.00 > ]
                [1.00 color rgbf < 1.00, 1.00, 1.00, 1.00 > ]
              }
              scale <0.51/GGT2,1.01,0.1/GGT2>
        ]
     }
     scale <GGT1,1,GGT1>
  }
  translate <0,0,-30>
  rotate <0,-70,0>
}
texture {
    pigment {
      wood
      turbulence 0.1
      pigment_map {
        [0.0 
              agate
              turbulence 0.3
              color_map {
                [0.00 color rgbf < 1.00, 1.00, 1.00, 1.00 > ]
                [1.00 color rgbf < 1.00, 1.00, 1.00, 1.00 > ]
              }
              scale <0.1/GGT4,1.01,0.51/GGT4>
        ]
        [0.9 
              agate
              turbulence 0.3
              color_map {
                [0.00 color rgbf < 1.00, 1.00, 1.00, 1.00 > ]
                [0.30 color rgbf < 0.35, 0.50, 0.30, 1.00 > ]
                [0.70 color rgbf < 0.30, 0.50, 0.30, 1.00 > ]
                [1.00 color rgbf < 1.00, 1.00, 1.00, 1.00 > ]
              }
              scale <0.51/GGT4,1.01,0.1/GGT4>
        ]
        [1.0 
              agate
              turbulence 0.3
              color_map {
                [0.00 color rgbf < 1.00, 1.00, 1.00, 1.00 > ]
                [0.30 color rgbf < 0.30, 0.50, 0.30, 1.00 > ]
                [0.70 color rgbf < 0.30, 0.50, 0.30, 1.00 > ]
                [1.00 color rgbf < 1.00, 1.00, 1.00, 1.00 > ]
              }
              scale <0.1/GGT4,1.01,0.51/GGT4>
        ]
     }
     scale <GGT3,1,GGT3>
  }
}

#declare GFT1 = 0.1;
#declare GFT2 = 60;
#declare GroundFlowerTexture = 
texture {
    pigment {
      bozo
      turbulence 0.3
      pigment_map {
        [0.0 
              bozo
              turbulence 0.7
              color_map {
                [0.00 color rgbf < 1.00, 1.00, 1.00, 1.00 > ]
                [0.15 color rgbf < 1.00, 1.00, 1.00, 1.00 > ]
                [0.20 color rgbt < 1.00, 0.00, 0.00, -2 > ]
                [0.30 color rgbt < 1.00, 0.00, 0.00, -2 > ]
                [0.35 color rgbf < 1.00, 1.00, 1.00, 1.00 > ]
                [0.75 color rgbf < 1.00, 1.00, 1.00, 1.00 > ]
                [0.80 color rgbt < 1.00, 1.00, 0.00, -2 > ]
                [0.90 color rgbt < 1.00, 1.00, 0.00, -2 > ]
                [0.95 color rgbf < 1.00, 1.00, 1.00, 1.00 > ]
                [1.00 color rgbf < 1.00, 1.00, 1.00, 1.00 > ]
              }
              scale <0.51/GFT2,1.01,0.21/GFT2>
        ]
        [0.3 
              agate
              turbulence 0.3
              color_map {
                [0.00 color rgbf < 1.00, 1.00, 1.00, 1.00 > ]
                [1.00 color rgbf < 1.00, 1.00, 1.00, 1.00 > ]
              }
        ]
        [1.0 
              agate
              turbulence 0.3
              color_map {
                [0.00 color rgbf < 1.00, 1.00, 1.00, 1.00 > ]
                [1.00 color rgbf < 1.00, 1.00, 1.00, 1.00 > ]
              }
        ]
     }
     scale <GFT1,1,GFT1>
  }  
  finish { ambient 0.5 }
  rotate <0,-20,0>
  translate <0.24,0,-0.28>
}
  
#declare GroundBaseTexture = texture {  
  pigment {
    bozo
    turbulence 0.7
    color_map { 
        [0.00 color < 0.18, 0.54, 0.13 > ]
        [0.10 color < 0.30, 0.50, 0.30 > ]
        [0.15 color < 0.57, 0.66, 0.25 > ]
        [0.30 color < 0.28, 0.48, 0.20 > ]
        [0.70 color < 0.47, 0.66, 0.25 > ]
        [0.90 color < 0.30, 0.50, 0.22 > ]
        [1.00 color < 0.18, 0.54, 0.13 > ]
    }
    scale 0.03
  }
  normal {
    wrinkles 3
  }
  finish { ambient 0.25 }
}
  
#declare TreeTexture = texture {  
  pigment {
    color < 0.18, 0.54, 0.13 > 
  }
  finish { ambient 0.25 }
}


// ===== Build some interesting objects ====

#declare GroundShape = height_field {
  jpeg "ground.jpg"
  smooth
}

#declare NearGroundGrass = object { 
  GroundShape 
  translate <-0.5,0,-0.5>
  scale <NearGroundGirth,NearGroundHeight,NearGroundGirth>
  texture { GroundGrassTexture }
}

#declare NearGroundFlowers = object {
  GroundShape 
  texture { GroundFlowerTexture }
  translate <-0.5,0,-0.5>
  scale <NearGroundGirth,NearGroundHeight,NearGroundGirth>
  translate <0,-0.025,0>
}

#declare NearGroundBase = object { 
  GroundShape 
  texture { GroundBaseTexture }
  translate <-0.5,0,-0.5>
  scale <NearGroundGirth,NearGroundHeight,NearGroundGirth>
  translate <0,-0.05,0>
}

#declare FarGroundGrass = object { 
  GroundShape 
  translate <-0.5,0,-0.5>
  scale <FarGroundGirth,FarGroundHeight,FarGroundGirth>
  texture { GroundBaseTexture }
}

#declare Tree = union {
  blob {
    sphere { <0.0,0.0,0.0>, 3.5, 1.0 }
    sphere { <0.0,2.0,0.0>, 2.0, 1.0 }
    sphere { <0.1,2.2,0.0>, 1.5, 1.0 }
    sphere { <0.3,2.0,0.2>, 1.5, 1.0 }
    scale <1,0.7,1>
    translate <0,1.5,0>
  }
  cylinder {
    <0,0,0>, <0,2,0>, 0.333
  }
  texture { TreeTexture }
}

#declare FarGroundTrees = union {
  object { 
    Tree
    translate <0,15,-FarGroundGirth/2>
    rotate <0,142,0>
  }
  object { 
    Tree
    translate <0,16,-FarGroundGirth/2>
    rotate <0,142.1,0>
  }
  object { 
    Tree
    translate <0,14,-FarGroundGirth/2>
    rotate <0,142.7,0>
  }
  object { 
    Tree
    translate <0,15,-FarGroundGirth/2>
    rotate <0,143,0>
  }
  object { 
    Tree
    translate <0,13,-FarGroundGirth/2>
    rotate <0,144.4,0>
  }
  object { 
    Tree
    translate <0,14,-FarGroundGirth/2>
    rotate <0,145.2,0>
  }
  object { 
    Tree
    translate <0,16,-FarGroundGirth/2>
    rotate <0,145.5,0>
  }
  object { 
    Tree
    translate <0,15,-FarGroundGirth/2>
    rotate <0,146,0>
  }
}

#declare GrassBlade1 = blob {
  sphere { <0,0.0,0.0>, 1.0, 1.0 scale <1.0, 1.0, 0.1> }
  sphere { <0,0.2,0.0>, 1.0, 1.0 scale <1.0, 1.0, 0.1> }
  sphere { <0,0.4,0.0>, 1.0, 1.0 scale <1.0, 1.0, 0.1> }
  sphere { <0,0.6,0.0>, 1.0, 1.0 scale <1.0, 1.0, 0.1> }
  sphere { <0,0.8,0.0>, 1.0, 1.0 scale <1.0, 1.0, 0.1> }
  sphere { <0,1.0,0.0>, 1.0, 1.0 scale <1.0, 1.0, 0.1> }
  sphere { <0,1.2,0.0>, 0.9, 1.0 scale <1.0, 1.0, 0.1> }
  sphere { <0,1.4,0.0>, 0.9, 1.0 scale <1.0, 1.0, 0.1> }
  sphere { <0,1.6,0.0>, 0.8, 1.0 scale <1.0, 1.0, 0.1> }
  sphere { <0,1.8,0.0>, 0.8, 1.0 scale <1.0, 1.0, 0.1> }
  sphere { <0,2.0,0.0>, 0.7, 1.0 scale <1.0, 1.0, 0.1> }
  sphere { <0,2.2,0.0>, 0.7, 1.0 scale <1.0, 1.0, 0.1> }
  sphere { <0,2.2,0.0>, 0.6, 1.0 scale <1.0, 1.0, 0.1> }
  sphere { <0,2.4,0.0>, 0.6, 1.0 scale <1.0, 1.0, 0.1> }
  sphere { <0,2.6,0.0>, 0.5, 1.0 scale <1.0, 1.0, 0.1> }
  sphere { <0,2.8,0.0>, 0.5, 1.0 scale <1.0, 1.0, 0.1> }
  sphere { <0,3.0,0.0>, 0.4, 1.0 scale <1.0, 1.0, 0.1> }
  sphere { <0,3.2,0.0>, 0.4, 1.0 scale <1.0, 1.0, 0.1> }
  sphere { <0,3.2,0.0>, 0.3, 1.0 scale <1.0, 1.0, 0.1> }
  sphere { <0,3.4,0.0>, 0.3, 1.0 scale <1.0, 1.0, 0.1> }
  sphere { <0,3.6,0.0>, 0.2, 1.0 scale <1.0, 1.0, 0.1> }
  sphere { <0,3.8,0.0>, 0.2, 1.0 scale <1.0, 1.0, 0.1> }
  texture { GroundBaseTexture }
}

#declare GrassBlade2 = blob {
  sphere { <0,0.0,0.00>, 1.0, 1.0 scale <1.0, 1.0, 0.1> }
  sphere { <0,0.2,0.00>, 1.0, 1.0 scale <1.0, 1.0, 0.1> }
  sphere { <0,0.4,0.00>, 1.0, 1.0 scale <1.0, 1.0, 0.1> }
  sphere { <0,0.6,0.00>, 1.0, 1.0 scale <1.0, 1.0, 0.1> }
  sphere { <0,0.8,0.01>, 1.0, 1.0 scale <1.0, 1.0, 0.1> }
  sphere { <0,1.0,0.01>, 1.0, 1.0 scale <1.0, 1.0, 0.1> }
  sphere { <0,1.2,0.01>, 0.9, 1.0 scale <1.0, 1.0, 0.1> }
  sphere { <0,1.4,0.01>, 0.9, 1.0 scale <1.0, 1.0, 0.1> }
  sphere { <0,1.6,0.02>, 0.8, 1.0 scale <1.0, 1.0, 0.1> }
  sphere { <0,1.8,0.02>, 0.8, 1.0 scale <1.0, 1.0, 0.1> }
  sphere { <0,2.0,0.03>, 0.7, 1.0 scale <1.0, 1.0, 0.1> }
  sphere { <0,2.2,0.05>, 0.7, 1.0 scale <1.0, 1.0, 0.1> }
  sphere { <0,2.2,0.08>, 0.6, 1.0 scale <1.0, 1.0, 0.1> }
  sphere { <0,2.4,0.10>, 0.6, 1.0 scale <1.0, 1.0, 0.1> }
  sphere { <0,2.6,0.12>, 0.5, 1.0 scale <1.0, 1.0, 0.1> }
  sphere { <0,2.8,0.15>, 0.5, 1.0 scale <1.0, 1.0, 0.1> }
  sphere { <0,3.0,0.19>, 0.4, 1.0 scale <1.0, 1.0, 0.1> }
  sphere { <0,3.2,0.21>, 0.4, 1.0 scale <1.0, 1.0, 0.1> }
  sphere { <0,3.2,0.25>, 0.3, 1.0 scale <1.0, 1.0, 0.1> }
  sphere { <0,3.4,0.27>, 0.3, 1.0 scale <1.0, 1.0, 0.1> }
  sphere { <0,3.6,0.29>, 0.2, 1.0 scale <1.0, 1.0, 0.1> }
  sphere { <0,3.8,0.30>, 0.2, 1.0 scale <1.0, 1.0, 0.1> }
  texture { GroundBaseTexture }
}

#declare GrassBlade3 = blob {
  sphere { <0,0.0,0.0>, 1.0, 1.0 scale <1.0, 1.0, 0.1> }
  sphere { <0,0.2,0.0>, 1.0, 1.0 scale <1.0, 1.0, 0.1> }
  sphere { <0,0.4,0.1>, 1.0, 1.0 scale <1.0, 1.0, 0.1> }
  sphere { <0,0.6,0.1>, 1.0, 1.0 scale <1.0, 1.0, 0.1> }
  sphere { <0,0.8,0.1>, 1.0, 1.0 scale <1.0, 1.0, 0.1> }
  sphere { <0,1.0,0.1>, 1.0, 1.0 scale <1.0, 1.0, 0.1> }
  sphere { <0,1.2,0.2>, 0.9, 1.0 scale <1.0, 1.0, 0.1> }
  sphere { <0,1.4,0.2>, 0.9, 1.0 scale <1.0, 1.0, 0.1> }
  sphere { <0,1.6,0.2>, 0.8, 1.0 scale <1.0, 1.0, 0.1> }
  sphere { <0,1.8,0.3>, 0.8, 1.0 scale <1.0, 1.0, 0.1> }
  sphere { <0,2.0,0.3>, 0.7, 1.0 scale <1.0, 1.0, 0.1> }
  sphere { <0,2.2,0.3>, 0.7, 1.0 scale <1.0, 1.0, 0.1> }
  sphere { <0,2.2,0.3>, 0.6, 1.0 scale <1.0, 1.0, 0.1> }
  sphere { <0,2.4,0.3>, 0.6, 1.0 scale <1.0, 1.0, 0.1> }
  sphere { <0,2.6,0.2>, 0.5, 1.0 scale <1.0, 1.0, 0.1> }
  sphere { <0,2.8,0.2>, 0.5, 1.0 scale <1.0, 1.0, 0.1> }
  sphere { <0,3.0,0.1>, 0.4, 1.0 scale <1.0, 1.0, 0.1> }
  sphere { <0,3.2,0.1>, 0.4, 1.0 scale <1.0, 1.0, 0.1> }
  sphere { <0,3.2,0.1>, 0.3, 1.0 scale <1.0, 1.0, 0.1> }
  sphere { <0,3.4,0.1>, 0.3, 1.0 scale <1.0, 1.0, 0.1> }
  sphere { <0,3.6,0.0>, 0.2, 1.0 scale <1.0, 1.0, 0.1> }
  sphere { <0,3.8,0.0>, 0.2, 1.0 scale <1.0, 1.0, 0.1> }
  texture { GroundBaseTexture }
}

// ===== Create some macros ====

#macro MakeGrassPatch(Length, Depth)
  #declare GF = 1/20;
  #declare GS = 6;
  union { 
    #declare L = 0.0;
    #while (L<Length)
      #declare D = 0.0;
      #while (D<Depth)
        object { GrassBlade1 scale <1.0, 0.9+rand(seed(D*L+1))/5, 1.0> rotate < rand(seed(D*L+3))*10-5,rand(seed(D*L+6))*10,rand(seed(D*L+ 9))*10-5> translate <(D+rand(seed(D*L+12))/5)*GS,0.0,(L+rand(seed(D*L+15))/5)*GS> }
        object { GrassBlade2 scale <1.0, 0.9+rand(seed(D*L+2))/5, 1.0> rotate < rand(seed(D*L+4))*10-5,rand(seed(D*L+7))*10,rand(seed(D*L+10))*10-5> translate <(D+rand(seed(D*L+13))/5)*GS,0.0,(L+rand(seed(D*L+16))/5)*GS> }
        object { GrassBlade3 scale <1.0, 0.9+rand(seed(D*L+3))/5, 1.0> rotate < rand(seed(D*L+5))*10-5,rand(seed(D*L+8))*10,rand(seed(D*L+11))*10-5> translate <(D+rand(seed(D*L+14))/5)*GS,0.0,(L+rand(seed(D*L+17))/5)*GS> }
        #declare D = D+rand(seed(D*L))/10.0+0.5;
      #end
      #declare L = L+rand(seed(D*L))/10.0+0.2;
    #end
    scale GF
  }
#end


#declare Orthostat60Grass = object {
  MakeGrassPatch(20,4)
  translate <8.62,0.01,-7>
}

// ===== Build main objects ====

#declare NearGround = union {
  object { NearGroundGrass }
  object { NearGroundFlowers }
  object { NearGroundBase }
}

#declare FarGround = union {
  object { FarGroundGrass }
  object { FarGroundTrees }
  object { FarGroundTrees rotate <0,-67,0> translate <0,-2,0> }
}

#declare LongGrass = union {
  object { Orthostat60Grass }
}

#declare GroundFog = fog {
  fog_type 2
  distance 200
  fog_offset 0
  fog_alt 4
  color rgb <0.7,0.7,0.65>*1
}
