// Persistence of Vision Ray Tracer Scene Description File
// File: megalithic.pov
// Vers: 3.6
// Desc: A collection of megaliths, similar to Stonehenge, on a mid-summer's morning.
// Date: 21-June-2006
// Auth: Rick Wedgeworth
//
// Note: The units are in meters.

#version 3.6; 

#include "ground.inc"
#include "stones.inc"
#include "sky.inc"

global_settings {
   max_trace_level 100
   assumed_gamma 2.2
}

#declare SUN_ANGLE = -65;

// ======= Lights! =============

#declare Sun = light_source {
  <0,200000000,0>
  color rgb <1,1,0.9>
}

#declare SpectralLight = light_source {
  <0,0,0>
  color rgb <1,0.6,0.3>
  fade_distance 10
  fade_power 2
} 

// ======= Camera! =============

#declare MainCamera = camera {
  location <0,1.5,-30>
  right <1.333,0,0>
  look_at <0,8,0> 
}

// ======= Scene! =============

#declare SkyBackdrop = sky_sphere {
  pigment {
    gradient y
    color_map {
      [ 0.0 color rgb <0.40,0.40,0.40> ]
      [ 1.0 color rgb <0.40,0.65,0.90> ]
    }
  }
}

// ======= Action! =============

camera { 
  MainCamera
  rotate <0,0,2>
  rotate <0,-70,0>
}

light_source { 
  Sun
  rotate <SUN_ANGLE,0,0>
}
/*
light_source { 
  SpectralLight
  translate <0,2,0>
}
*/
sky_sphere {
  SkyBackdrop
}

fog { GroundFog }

object {
  CentralFog
}

object {
  OminousFog
  rotate <0,-20,0>
  translate <-120,0,105>
}

object { Flock }
 
object { Beam translate <-2.0, 0, 0> rotate <SUN_ANGLE,0,0> }
object { Beam translate <-1.5, 0, 0> scale<0.5,1,0.5> rotate <0,10,0> rotate <SUN_ANGLE,0,0> }

object {
  NearGround
  translate <0,-1.6,0>
}

object {
  FarGround
  rotate <-2.2,0.0,-2.2>
  translate <0,-38,0>
}

object {
  Megaliths
}

object {
  LongGrass
}
