// morning.pov             18 June 2006                IRTC may/june " Light and Fog "

#include "colors.inc"
#include "functions.inc"

background { color rgb < 0.5, 0.5, 0.8 > }


camera {  
        location  < 0, 24, -120 >   
        look_at < 0, 4, 0 >
        angle 50 
       }         
light_source { < -1000, 360, 400 > color rgb < 0.925, 0.925, 0.65 > }
         

light_source { < 50, 50, -150 > color Gray10 shadowless }



light_source { < -0.8, 23.8, -117.5 > color White
                   spotlight
                   point_at < -1.1, 23.5, -117.11 >
                   falloff 36
                   radius 32
             }        
             
light_source { < 2, 50, -150 > color rgb < 0.2, 0.2, 0.3 >
                   spotlight
                   point_at < -1.1, 23.5, -117.11 >
                   falloff 6
                   radius 4
                   shadowless
             }                     


fog {
     distance 90
     color rgbf < 0.75, 0.75, 0.8, 0.2 >  
     fog_type 2
     fog_offset 11
     fog_alt 4
     turbulence 1 omega 1.5
    }                     


// ************************************************************************************

#declare TestA =                                                                      // standard WHITE
                texture {
                          pigment { color White }
                          finish { ambient 0.3 }
                         }        
                         
#declare TestAS =                                                                      // SHINY WHITE
                texture {
                          pigment { color White }
                          finish { ambient 0.3 reflection 0.1 phong 0.5 }
                         }                                 
                         
#declare TestAT =                                                                     // CONCRETE
                texture {
                          pigment { color White }
                          normal { granite scale 0.001 }
                          finish { ambient 0.3 }
                         }                                 
                         
#declare TestX =                                                                       // LENS glass
                texture {
                           pigment { color rgbt < 1, 0.95, 0.9, 0.85 > } 
                           finish { ambient 0.4 reflection 0.2 phong 1 phong_size 80 }   
                         }                

#declare Zun =                                                                         // INTERIOR
              texture {
                       pigment { color rgb < 1, 0.8, 0.68 > }
                       normal { bumps 0.5 scale 0.001 }
                       finish { ambient 0.3 }
                      }                                                 
                      
#declare Zoo =
              texture {
                       pigment { color rgb < 0.6, 0.7, 0.7 > }
                       finish { ambient 0.3 }
                      } 
                      
#declare Flash =                                                                       // BRIGHT RED
              texture {
                       pigment { color rgb < 1, 0.2, 0.1 > }
                       finish { ambient 1 diffuse 0 }
                      }                       

#declare Stains =
                texture {
                         pigment {
                                  gradient x //wrinkles
                                  color_map {
                                              [ 0 color Clear ]
                                              [ 0.3 color Clear ]
                                              [ 0.5 color rgbt < 0.4, 0.5, 0.43, 0.95 > ]
                                              [ 0.57 color Clear ]                                              
                                              [ 1.0 color Clear ]
                                             }
                                      scale < 0.05, 1, 0.05 > turbulence 0.5 omega 1
                                  }
                          finish { ambient 0.3 }
                          }                    


                                                                                                        
// SKY  **********************************************************

sphere { < 0, 0, 0 >,1                                                          // BLUE SKY
                      pigment {
                                gradient y
                                color_map {
                                            [ 0 color rgb < 0.9, 0.8, 0.8 > ]   
                                            [ 0.25 color rgb < 0.9, 0.8, 0.85 > ]                                
                                            [ 1.0 color rgb < 0.7, 0.6, 1 > ]    
                                          }
                              }
                      finish { ambient 1 diffuse 0 }
                      scale < 5000, 1000, 7000 >
                      hollow
      } 

#declare Clouds =
                 union {                                                    
      
sphere { < 0, 0, 0 >,1                                                          // CLOUD TOPS
                      pigment {
                                quilted
                                color_map {
                                            [ 0 color rgb < 1, 1, 0.95 > ]                                                                                    
                                            [ 0.4 color Clear ]
                                            [ 0.7 color Clear ]  
                                            [ 1.0 color rgb < 1, 1, 0.95 > ]    
                                          }
                                   scale 0.3 turbulence 0.15 omega 1      
                              }
                      finish { ambient 0.9 diffuse 0 }
                      scale < 4500, 655, 6500 >
                      hollow
      }                                                     
      
sphere { < 0, 0, 0 >,1                                                          // CLOUD TOPS
                      pigment {
                                wrinkles
                                color_map {
                                            [ 0 color rgb < 0.95, 0.98, 0.9 > ]                                                                                    
                                            [ 0.5 color Clear ]
                                            [ 0.85 color Clear ]  
                                            [ 1.0 color rgb < 1, 1, 0.9 > ]    
                                          }
                                   scale 0.3       
                              }
                      finish { ambient 0.9 diffuse 0 }
                      scale < 4500, 650, 6500 >
                      hollow
      } 
                                      
                                                                                                
      
sphere { < 0, 0, 0 >,1                                                          // CLOUD BASE
                      pigment {
                                wrinkles
                                color_map {
                                            [ 0 color rgb < 0.874, 0.78, 0.9 > ]                                                                                    
                                            [ 0.375 color Clear ]
                                            [ 0.65 color Clear ]  
                                            [ 1.0 color rgb < 0.874, 0.78, 0.9 > ]    
                                          }
                                   scale 0.13 translate z*0.02       
                              }
                      finish { ambient 0.7 diffuse 0.3 }
                      scale < 4500, 630, 6500 >
                      hollow
      }
      
                               }
                               
                                 
object { Clouds  scale < 1.1, 1, 1 > rotate y*-30 translate x*100 }
                                  

// LIGHTHOUSE ********************************************************************************************** LIGHTHOUSE

// scale 1ft = 0.07   ie 1 = 14ft

#declare Domseg =                                                                               // segment of dome
                 difference {
                             cylinder { < 0, 0, -0.6 >,< 0, 0, 0.6 >,0.5 }
                             union {
                                     cylinder { < 0, 0, -0.65 >,< 0, 0, 0.65 >,0.47 }
                                     box { < -0.8, -0.8, 0 >,< 0.8, 0.8, -0.8 > rotate y*15 }
                                     box { < -0.8, -0.8, 0 >,< 0.8, 0.8, 0.8 > rotate y*-15 }
                                     box { < -0.8, 0, -0.8 >,< 0.8, -0.8, 0.8 >  }
                                   }
                                     // texture { TestA }
                             }
#declare Finn =                                                                               // fin of vane
               difference {
                            union {
                                    box { < -0.05, -0.05, -0.002 >,< 0.05, 0.05, 0.002 >
                                                 rotate z*45
                                                 scale < 1.2, 0.5, 0.5 >
                                       }
                                   box { < 0, -0.07, -0.002 >,< 0.06, 0.07, 0.002 > scale < 1, 0.5, 0.5 > }
                                                  translate < -0.15, 0.3, 0 >
                                  } 
                            box { < -0.05, -0.05, -0.004 >,< 0.05, 0.05, 0.004 >
                                                 rotate z*45
                                                 scale < 1.2, 0.5, 1 >
                                                 translate < -0.07, 0.3, 0 >
                                }  
                                          texture { TestA }
                            }                  
#declare Knob =                                                                             // dome top & vane
                union {
                       cone { < 0, 0, 0 >,0.065,< 0, 0.07, 0 >,0.03 }
                       torus { 0.03, 0.01 translate y*0.07 }
                       sphere { < 0, 0, 0 >,0.07 translate y*0.14 }
                       cylinder { < 0, 0, 0 >,< 0, 0.45, 0 >,0.005 }
                       cylinder { < -0.2, 0.3, 0 >,< 0.2, 0.3, 0 >,0.005 }
                       sphere { < 0, 0.3, 0 >,0.02 }
                       difference {
                                   box { < -0.05, -0.05, -0.002 >,< 0.05, 0.05, 0.002 >
                                                 rotate z*45
                                                 scale < 1.2, 0.5, 0.5 >
                                       }
                                   box { < 0, -0.06, -0.003 >,< 0.1, 0.06, 0.003 > }
                                                  translate < -0.15, 0.3, 0 >
                                  } 
                       object { Finn translate x*0.35 }                                        
                                   texture { TestA }
                                   translate y*0.48
                      }                                           
                             
#declare Dome =                                                                                  // dome
               union {
                      object { Domseg }
                      object { Domseg rotate y*30 }  
                      object { Domseg rotate y*60 }  
                      object { Domseg rotate y*90 }  
                      object { Domseg rotate y*120 }  
                      object { Domseg rotate y*150 }  
                      object { Domseg rotate y*180 }      
                      object { Domseg rotate y*-30 }
                      object { Domseg rotate y*-60 }  
                      object { Domseg rotate y*-90 }  
                      object { Domseg rotate y*-120 }  
                      object { Domseg rotate y*-150 } 
                      object { Knob  }                                
                                  translate y*22.8
                                  texture { TestAS } 
                                  texture { Stains } 
                     } 
                     
                    
                                                          
                                  
#declare PostA =
                cylinder { < 0, 21.72, 0 >,< 0, 22, 0 >,0.006 translate x*0.8 texture { TestA } }
                
#declare Post =
               object { PostA translate x*-0.8 scale < 0.5, 1, 0.5 > translate x*0.8 } 
               
#declare Sixth =
                union {
                        object { PostA }
                        object { Post rotate y*-4 }
                        object { Post rotate y*-8 }
                        object { Post rotate y*-12 }
                        object { Post rotate y*-16 }             
                        object { PostA rotate y*-20 }
                        object { Post rotate y*-24 }
                        object { Post rotate y*-28 }
                        object { Post rotate y*-32 }            
                        object { Post rotate y*-36 }
                        object { PostA rotate y*-40 }
                        object { Post rotate y*-44 }
                        object { Post rotate y*-48 }        
                        object { Post rotate y*-52 }            
                        object { Post rotate y*-56 } 
                       }                                     
               
#declare Fence =                                                                             // circular fence
                union {
                        torus { 0.8, 0.006 translate y*22 }
                        torus { 0.8, 0.006 translate y*21.86 }
                        object { Sixth }
                        object { Sixth rotate y*-60 }
                        object { Sixth rotate y*-120 }
                        object { Sixth rotate y*-180 }
                        object { Sixth rotate y*-240 }
                        object { Sixth rotate y*-300 }
                       } 

#declare Lbrak =                                                                                // brackets under deck
                union {
                         box { < 0.5, 0, -0.015 >,< 0.81, -0.015, 0.015 > }
                         box { < 0.5, 0, -0.015 >,< 0.515, -0.25, 0.015 > }
                         difference { 
                                     torus { 0.2, 0.015 rotate x*90 scale < 1, 1, 0.5 > }                                   
                                     box { < -0.21, 0, -0.15 >,< 0.21, 0.25, 0.15 > }
                                                  translate < 0.5, -0.01, 0 >
                                     }
                                           translate y*21.71 
                                           texture { TestA }
                      } 
                      
#declare Lbraks =
                 union {
                        object { Lbrak }
                        object { Lbrak rotate y*30 } 
                        object { Lbrak rotate y*60 }
                        object { Lbrak rotate y*90 }
                        object { Lbrak rotate y*120 }
                        object { Lbrak rotate y*150 }
                        object { Lbrak rotate y*180 } 
                        object { Lbrak rotate y*-30 } 
                        object { Lbrak rotate y*-60 }
                        object { Lbrak rotate y*-90 }
                        object { Lbrak rotate y*-120 }
                        object { Lbrak rotate y*-150 }
                       }                                         
                       
#declare Ldeck =                                                                                  // annular deck
                 union {
                        difference {
                                    cylinder { < 0, 21.71, 0 >,< 0, 21.73, 0 >,0.81 }  
                                    cylinder { < 0, 21.6, 0 >,< 0, 21.8, 0 >,0.78 } 
                                   }
                        union {           
                                torus { 0.77, 0.007 } 
                                torus { 0.74, 0.007 }
                                torus { 0.71, 0.007 }
                                torus { 0.68, 0.007 }
                                torus { 0.65, 0.007 }
                                torus { 0.62, 0.007 }
                                torus { 0.59, 0.007 }
                                torus { 0.56, 0.007 }
                                torus { 0.53, 0.007 }
                                            scale < 1, 0.25, 1 >
                                            translate y*21.71
                               }             
                        object { Lbraks }
                                      texture { TestA }
                       }                                                         
#declare Mull =                                                                                       // mullion
                box { < 0.49, 22.2, -0.007 >,< 0.515, 22.8, 0.007 > texture { TestAS } }
                
#declare Mullions =
                   union {
                           object { Mull }
                           object { Mull rotate y*30 }   
                           object { Mull rotate y*60 } 
                           object { Mull rotate y*90 } 
                           object { Mull rotate y*120 } 
                           object { Mull rotate y*150 } 
                           object { Mull rotate y*180 }
                           object { Mull rotate y*-30 }   
                           object { Mull rotate y*-60 } 
                           object { Mull rotate y*-90 } 
                           object { Mull rotate y*-120 } 
                           object { Mull rotate y*-150 }
                          } 
                          
#declare Winpan =                                                                                 // window panel
                 union { 
                         box { < 0.485, 22.2, -0.12 >,< 0.49, 22.8, 0.12 > texture { TestX } }
                         box { < 0.472, 22.5, -0.12 >,< 0.495, 22.51, 0.12 > }
                         box { < 0.472, 22.2, -0.12 >,< 0.495, 22.21, 0.12 > }
                         box { < 0.472, 22.79, -0.12 >,< 0.495, 22.8, 0.12 > }
                         cylinder { < 0.49, 22.2, -0.12 >,< 0.49, 22.8, -0.12 >,0.005 }
                         cylinder { < 0.49, 22.2, 0.12 >,< 0.49, 22.8, 0.12 >,0.005 }
                         cylinder { < 0.49, 22.21, -0.12 >,< 0.49, 22.21, 0.12 >,0.005 }
                         cylinder { < 0.49, 22.5, -0.12 >,< 0.49, 22.5, 0.12 >,0.005 }
                         cylinder { < 0.49, 22.51, -0.12 >,< 0.49, 22.51, 0.12 >,0.005 }
                         cylinder { < 0.49, 22.79, -0.12 >,< 0.49, 22.79, 0.12 >,0.005 }                          
                         texture { TestA }                                       
                       } 
                       
#declare Glazed =                                                                                // glassed section
                 union {
                         object { Winpan rotate y*37 }
                         object { Winpan rotate y*67 }
                         object { Winpan rotate y*97 }
                         object { Winpan rotate y*127 }
                         object { Winpan rotate y*157 }
                         object { Winpan rotate y*187 }
                         object { Winpan rotate y*7 }
                         object { Winpan rotate y*-23 }
                         object { Winpan rotate y*-53 }
                         object { Winpan rotate y*-83 }
                         object { Winpan rotate y*-113 }
                         object { Winpan rotate y*-143 }
                         object { Winpan rotate y*37 }
                         object { Winpan rotate y*-173 }
                        } 
// lens *******************


#declare Litseg =                                                                                          // lens segment
                 difference {
                             cone { < 0, 0, 0 >,0.18,< 0, 0.04, 0 >,0.2 }
                             cone { < 0, -0.01, 0 >,0.17,< 0, 0.05, 0 >,0.19 }
                                         translate y*0.08 
                                         texture { TestX } 
                            }
                 
#declare Divv =
               difference {
                           torus { 0.19, 0.01 rotate x*90 scale < 1, 1.8, 0.1 > }
                           box { < -0.22, -0.21, -0.22 >,< 0.22, -0.3, 0.22 > }
                                      texture { TestX } 
                          }
                          
#declare Divvs =                                                                                    // divisions in lens
                union {
                       object { Divv }
                       object { Divv rotate y*45 } 
                       object { Divv rotate y*90 }
                       object { Divv rotate y*135 }
                       
                                  rotate y*22.5
                       }           
                                                                   
                 
#declare Toplen =
                 
                               union {
                                      object { Litseg }
                                      object { Litseg scale < 0.95, 1, 0.95 > translate y*0.04 }
                                      object { Litseg scale < 0.89, 1, 0.89 > translate y*0.08 }
                                      object { Litseg scale < 0.8, 1, 0.8 > translate y*0.12 }
                                      object { Litseg scale < 0.72, 1, 0.72 > translate y*0.15 }
                                      object { Litseg scale < 0.6, 1, 0.6 > translate y*0.18 }
                                      object { Litseg scale < 0.45, 1, 0.45 > translate y*0.2 }
                                      object { Litseg rotate z*180 }
                                      object { Litseg scale < 0.95, 1, 0.95 > translate y*0.04 rotate z*180 }
                                      object { Litseg scale < 0.89, 1, 0.89 > translate y*0.08 rotate z*180 }
                                      object { Litseg scale < 0.8, 1, 0.8 > translate y*0.12 rotate z*180 }
                                     }                  
                                
                                              
#declare Round =
                 difference {
                             sphere { < 0, 0, 0 >,0.09 scale < 0.2, 1, 1 > }
                             union {
                                    torus { 0.075, 0.005 scale < 1, 2, 1 > rotate z*90 translate x*0.005 }
                                    torus { 0.06, 0.005 scale < 1, 2, 1 > rotate z*90 translate x*0.01 }
                                    torus { 0.046, 0.005 scale < 1, 2, 1 > rotate z*90 translate x*0.02 }
                                    torus { 0.03, 0.005 scale < 1, 2, 1 > rotate z*90 translate x*0.022 }
                                   }                             
                             translate x*0.205 texture { TestX } 
                           } 
                 
#declare Rounds =
                 union {
                         object { Round }
                         object { Round rotate y*45 }  
                         object { Round rotate y*90 }
                         object { Round rotate y*135 }  
                         object { Round rotate y*180 }
                         object { Round rotate y*-45 }  
                         object { Round rotate y*-90 }
                         object { Round rotate y*-135 }
                        }
#declare Slot =
               cylinder { < 0, 0, -0.18 >,< 0, 0, 0.18 >,0.005 scale < 2, 10, 1 > translate y*-0.26 texture { TestA } }
               
#declare Slots =
                 union {
                        object { Slot }
                        object { Slot rotate y*15 }  
                        object { Slot rotate y*30 } 
                        object { Slot rotate y*45 } 
                        object { Slot rotate y*60 } 
                        object { Slot rotate y*75 } 
                        object { Slot rotate y*90 } 
                        object { Slot rotate y*105 }  
                        object { Slot rotate y*120 } 
                        object { Slot rotate y*135 } 
                        object { Slot rotate y*150 } 
                        object { Slot rotate y*165 } 
                       }              
               
#declare Burn =
                difference {
                            cylinder { < 0, -1, 0 >,< 0, -0.2, 0 >,0.16 }
                              union {
                                      cylinder { < 0, -1, 0 >,< 0, -0.2, 0 >,0.15 } 
                                      object { Slots }
                                    }
                                          texture { TestA }
                           }                                          
#declare Litesys =                                                                                  // fresnel lens
                  union { 
                          object { Burn }                         
                          cylinder { < 0, -0.2, 0 >,< 0, -0.21, 0 >,0.2 texture { Zun } }
                          cylinder { < 0, -0.2, 0 >,< 0, -0.1, 0 >,0.02 texture { Zun } }
                          //cylinder { < 0, -0.18, 0 >,< 0, 0.18, 0 >,0.035 texture { Flash } }
                          //object { Flame }                         
                          torus { 0.202, 0.005 translate y*-0.08 texture { TestX } }
                          torus { 0.202, 0.005 translate y*0.08 texture { TestX } }
                          difference {
                                       cylinder { < 0, -0.08, 0 >,< 0, 0.08, 0 >,0.2 }
                                       cylinder { < 0, -0.09, 0 >,< 0, 0.09, 0 >,0.19 }
                                       texture { TestX } 
                                      }
                          object { Rounds rotate y*-10 }
                          object { Toplen }
                          object { Divvs rotate y*-10 }                                   
                                    translate y*22.4
                          }  
                          
// bricks ********************                          
                                  
#declare Perp =                                                                                         // perp over deck
               cylinder { < 0, 0, 0 >,< 0, 0.07, 0 >,0.003 translate x*0.51 texture { TestA } } 
               
#declare Perps =
                union {
                       object { Perp }
                       object { Perp translate y*0.14 }   
                       object { Perp translate y*0.28 } 
                       object { Perp translate y*0.42 } 
                       object { Perp translate y*0.07 rotate y*15 } 
                       object { Perp translate y*0.21 rotate y*15 } 
                       object { Perp translate y*0.35 rotate y*15 }
                      }
                      
#declare Allperp =                                                                                 // all perps above deck
                     union {
                             object { Perps }
                             object { Perps rotate y*30 } 
                             object { Perps rotate y*60 } 
                             object { Perps rotate y*90 } 
                             object { Perps rotate y*120 } 
                             object { Perps rotate y*150 } 
                             object { Perps rotate y*180 }         
                             object { Perps rotate y*-30 } 
                             object { Perps rotate y*-60 } 
                             object { Perps rotate y*-90 } 
                             object { Perps rotate y*-120 } 
                             object { Perps rotate y*-150 } 
                            
                                        translate y*21.78 
                            }                       
#declare PerpsT =
                 object { Perps rotate z*6 translate < 0.045, 20.99, 0 > }                            // perps on tower
                 
#declare AllperpT =                                                                                 // all perps above deck
                     union {
                             object { PerpsT }
                             object { PerpsT rotate y*30 } 
                             object { PerpsT rotate y*60 } 
                             object { PerpsT rotate y*90 } 
                             object { PerpsT rotate y*120 } 
                             object { PerpsT rotate y*150 } 
                             object { PerpsT rotate y*180 }         
                             object { PerpsT rotate y*-30 } 
                             object { PerpsT rotate y*-60 } 
                             object { PerpsT rotate y*-90 } 
                             object { PerpsT rotate y*-120 } 
                             object { PerpsT rotate y*-150 } 
                            
                                         
                            }                                                                
                            
#declare Allperp =                                                                                 // all perps above deck
                     union {
                             object { Perps }
                             object { Perps rotate y*30 } 
                             object { Perps rotate y*60 } 
                             object { Perps rotate y*90 } 
                             object { Perps rotate y*120 } 
                             object { Perps rotate y*150 } 
                             object { Perps rotate y*180 }         
                             object { Perps rotate y*-30 } 
                             object { Perps rotate y*-60 } 
                             object { Perps rotate y*-90 } 
                             object { Perps rotate y*-120 } 
                             object { Perps rotate y*-150 } 
                            
                                        translate y*21.78 
                            }                                                   
#declare Tower =                                                                                    // tower below deck
                difference {
                            cone { < 0, 21.47, 0 >,0.51,< 0, 10, 0 >,1.67 } 
                            union {
                                   object { AllperpT }
                                   torus { 0.551, 0.003 translate y*21.04 }
                                   torus { 0.544, 0.003 translate y*21.11 }
                                   torus { 0.537, 0.003 translate y*21.18 }
                                   torus { 0.53, 0.003 translate y*21.25 }
                                   torus { 0.523, 0.003 translate y*21.32 }
                                   torus { 0.516, 0.003 translate y*21.39 }
                                  } 
                                        
                                        texture { TestAT }
                           }                                                                                                                                            
#declare Lighthouse =                                                                                     // lighthouse
                union {
                        object { Glazed }
                        object { Litesys }
                        difference {
                                     torus { 0.51, 0.038 scale < 1, 0.75, 1 > texture { TestAS } texture { Stains } }
                                     box { < -0.6, 0, -0.6 >,< 0.6, -0.1, 0.6 > }
                                                translate y*22.8
                                   }                                               
                        difference {
                                    cylinder { < 0, 21.47, 0 >,< 0, 22.2, 0 >,0.51 texture { TestAT } }
                                    union {
                                           torus { 0.51, 0.003 translate y*21.51 }
                                           torus { 0.51, 0.003 translate y*21.58 }
                                           torus { 0.51, 0.003 translate y*21.65 }
                                           torus { 0.51, 0.003 translate y*21.71 }
                                           torus { 0.51, 0.003 translate y*21.78 }
                                           torus { 0.51, 0.003 translate y*21.85 }
                                           torus { 0.51, 0.003 translate y*21.92 }
                                           torus { 0.51, 0.003 translate y*21.99 }
                                           torus { 0.51, 0.003 translate y*22.06 }
                                           object { Allperp }
                                           object { Allperp translate y*-0.5 rotate y*15 }
                                           cylinder { < 0, 21.4, 0 >,< 0, 22.3, 0 >,0.44 texture { Zun } }
                                          } 
                                   }
                        difference {
                                     torus { 0.51, 0.028 scale < 1, 2, 1 > }
                                     box { < -0.6, 0, -0.6 >,< 0.6, 0.1, 0.6 > }
                                                translate y*22.2
                                                texture { TestAT } 
                                   }                         
                        object { Tower }                        
                                              
                        object { Fence }
                        object { Ldeck }
                        object { Dome rotate y*7 }
                        object { Mullions rotate y*22 }
                                   texture { TestA } 
                      }
                                                

object { Lighthouse translate < -1.1, 1.1, -117.1 > } // This one< -0.685, 1.8, -118 > }   


                
// HILLS *************************************************************************************************************************HILLS

// SCALE 1 = 10ft

#declare TerrainA =                   
                   height_field { sys "TerraE.bmp" smooth                                                    
                                  translate < -0.5, -0.5, -0.5 >
                                  scale < 700, 175, 600 >                                  
                                  hollow                                
                                  pigment { 
                                            gradient y
                                            color_map {
                                                        [ 0 color rgb < 0.4, 0.6, 0.3 > ]
                                                        [ 0.325 color rgb < 0.7, 0.85, 0.15 > ]
                                                        [ 0.35 color rgb < 0.9, 0.8, 0.5 > ]
                                                        [ 0.5 color rgb < 0.97, 0.75, 0.5 > ]       
                                                        [ 0.75 color rgb < 0.97, 0.75, 0.5 > ]                                                      
                                                        [ 1.0 color rgb < 0.7, 0.6, 0.15 > ]
                                                      }
                                              scale  40   turbulence 0.15 omega 0.96 
                                           }
                                  normal { granite scale 0.002 }                           
                                  finish { ambient 0.3 }
                                }
                                
                                
// SEA ***************************************************************************

plane { y, 0  
             texture {
                      pigment {  color rgb < 0.45, 0.5, 0.7 > }                               // sea surface               
                      normal { waves 0.1 scale  2  translate z*50 turbulence 1 omega 2 }                              
                      finish { ambient 0.2 reflection 0.15 phong 1 }
                     } 
             texture {
                       pigment {
                                granite
                                color_map {
                                           [ 0 color Clear ]  
                                           [ 0.5 color Clear ] 
                                           [ 0.5 color White ]
                                           [ 0.53 color White ]
                                           [ 0.55 color Clear ] 
                                           [ 1.0 color Clear ] 
                                          }
                                   scale < 1.5, 1, 4 > rotate y*-45       
                                }
                       finish { ambient 0.4 }
                      }
    } 
                                                 
    
                                               // SEA SURFACE                              

object { TerrainA rotate y*-99 rotate x*1 rotate z*4 translate < 250, -15, 330 > }                     // far terrain

object { TerrainA scale < 0.2, 0.1, 0.1 > rotate y*-60 rotate x*1 rotate z*4 translate < 40, 10, -70 > } // close terrain

#declare Surf =
               difference {
                           height_field { sys "TerraE.bmp" smooth                                                    
                                          translate < -0.5, -0.5, -0.5 >
                                          scale < 700, 175, 600 >
                                          rotate y*-99 rotate x*1 rotate z*4 translate < 250, -15, 330 >                                   
                                          hollow  
                                        }
                           union {             
                                   height_field { sys "TerraE.bmp" smooth                                                    
                                          translate < -0.5, -0.5, -0.5 >
                                          scale < 698, 175, 595 >
                                          rotate y*-99 rotate x*1 rotate z*4 translate < 250, -15, 330 >                                   
                                          hollow  
                                        }      
                                        
                                   box { < -100, 0.01, -100 >,< 400, 200, 800 > }  
                                 }                                          
                                  pigment { color White }
                                  normal { bumps scale 0.005 }
                                  finish { ambient 0.5 }
                          }
object { Surf translate < -250, 15, -330 >  scale < 1.05, 1.01, 1.1 > translate < 250, -15, 330 > }  
                          
object { Surf translate < -250, 15, -330 >  scale < 1.05, 1, 1.1 > translate < 250, -15, 325 > }    

object { Surf translate < -250, 15, -330 >  scale < 1.1, 1, 1.2 > translate < 250, -15, 325 > }

                               
                                  
// FOLIAGE  ***********************************************

#declare Stik =
               union {
                      cylinder { < 0, 0, 0 >,< 0, 3, -1 >,0.18 }
                      cylinder { < 0, 3, -1 >,< 0, 6, 0 >,0.18 }
                            pigment { color rgb < 0.6, 0.5, 0.4 > }
                            finish { ambient 0.3 }
                        }
                        
#declare Stiks =
                union {
                        object { Stik }
                        object { Stik scale 0.85 rotate x*30 translate y*6 } 
                        object { Stik scale 0.85 rotate x*-30 translate y*6 }
                                      rotate x*-30
                                      translate z*-1
                       }                            

#declare Leif =
               union {
                       cylinder { < 0, 0, 0 >,< 0.01, 0, 0 >,0.8 scale < 1, 1.5, 1 > }
                       cylinder { < 0, 1, 0 >,< 0, -2, 0 >,0.015 }
                                    translate y*2
                                    pigment { color rgb < 0.9, 0.85, 0.5 > } //rgb < 0.4, 0.65, 0.5 > }
                                    finish { ambient 0.3 }
                     }
#declare Leifs =
                  union {
                          object { Leif }
                          object { Leif rotate < 0, 45, -45 > }  
                          object { Leif rotate < 0, -45, 45 > }
                                   translate y*10 
                        }
#declare Number_of_Cycles = 10 ;
#declare Count_per_Cycle = 10 ;

#declare Starting_Angle = 0 ; 
#declare Angle = 360 / Count_per_Cycle ;
#declare Count = Number_of_Cycles * Count_per_Cycle -1 ;

#declare SD1 = seed(1) ;
#declare SD2 = seed(2) ;

#declare Bussh =
            union {
                union {
                       #while ( Count >= 0 )
                       object { Leifs                               
                                translate < 0, 4*rand(SD1), 0 >
                                rotate < 70*rand(SD2), 30*rand(SD1)*Angle, 0 >
                               }
                       #declare Starting_Angle = Starting_Angle + Angle ;
                       #declare Count = Count - 1 ;
                       #end
                       }
                object { Stiks rotate y*180 translate y*2 }  
                object { Stiks rotate y*60  }   
                object { Stiks rotate y*-60  translate y*1 }  
                   }    
#declare Bussy =
                union {                        
                        object { Bussh } 
                        object { Bussh rotate x*-45 }
                        object { Bussh rotate x*45 }
                        object { Bussh rotate z*-45 }
                        object { Bussh rotate z*450 }
                       }

#declare Tree =
                union {               
                        object  { Bussy }    
                        object  { Bussy scale 0.9 rotate x*-45 translate < 10, -5, -5 > }  
                        object  { Bussy scale 1.1 rotate x*-75 translate < -5, -15, -10 > }                     
                        object  { Bussy scale 0.9 rotate z*-45 translate < 25, 5, 5 > }  
                        object  { Bussy scale 1.1 rotate z*-50 translate < 30, -10, -10 > }       
                        object  { Bussy scale 1.1 rotate x*-50 translate < 25, -20, -15 > } 
                      } 
                      

object { Tree scale 0.025 translate < 6.5, 13.7, -95 > }
object { Tree scale 0.035 translate < 8.5, 13.7, -96 > }
object { Tree scale 0.03 translate < 6.7, 13.7, -97 > }
object { Tree scale < 0.05, 0.025, 0.03 >  translate < 12.5, 14.5, -90 > }
object { Tree scale 0.02 translate < 11, 14, -93 > }




         
// TWO MAST SAILING SHIP  **************************************************************************

#declare Canvas =
                  texture {
                            pigment { color rgbt < 1, 0.9, 0.8, 0.2 > }
                            finish { ambient 0.5 }
                          }
                          
#declare Seams =
                  texture {
                            pigment { 
                                      gradient x
                                      color_map {
                                                 [ 0 color rgb < 0.8, 0.7, 0.6 > ]
                                                 [ 0.02 color rgb < 0.8, 0.7, 0.6 > ]
                                                 [ 0.02 color Clear ]
                                                 [ 1 color Clear ]
                                                }
                                         scale 3.8
                                     }            
                                                 
                            finish { ambient 0.3 }
                          }
                          
#declare Shirts =
                  texture {
                            pigment { 
                                      gradient y
                                      color_map {
                                                 [ 0 color Gray90 ]                                               
                                                 [ 0.5 color Gray90 ]
                                                 [ 0.5 color Clear ]
                                                 [ 1 color Clear ]
                                                }
                                      scale 0.3
                                    }             
                            finish { ambient 0.3 }
                          }                                                                                                    
                          
#declare PaintA =
                  texture {
                            pigment { color rgb < 0.8, 0.4, 0.3 > }
                            finish { ambient 0.3 }
                          }                              
                          
#declare PaintB =
                  texture {
                            pigment { color rgb < 0.95, 0.85, 0.75 > }
                            finish { ambient 0.3 }
                          }
                          
#declare PaintC =
                  texture {
                            pigment { 
                                      gradient y
                                      color_map {
                                                 [ 0 color rgb < 0.9, 0.8, 0.7 > ]                                               
                                                 [ 0.3 color rgb < 0.9, 0.8, 0.7 > ]
                                                 [ 0.3 color Clear ]
                                                 [ 1 color Clear ]
                                                }
                                       scale 4 translate y*1.75
                                    }             
                            finish { ambient 0.3 }
                          }                          
                          
#declare PaintD =
                  texture {
                            pigment { 
                                      gradient x
                                      color_map {
                                                 [ 0 color rgb < 0.8, 0.4, 0.3 > ]                                               
                                                 [ 0.3 color rgb < 0.8, 0.4, 0.3 > ]
                                                 [ 0.3 color Clear ]
                                                 [ 1 color Clear ]
                                                }
                                       scale 4 
                                    }             
                            finish { ambient 0.3 }
                          }                                                    
                          
#declare Sheets =
                  texture {
                            pigment { 
                                      gradient x
                                      color_map {
                                                 [ 0 color Gray40 ]                                               
                                                 [ 0.1 color Gray40 ]
                                                 [ 0.1 color Clear ]
                                                 [ 1 color Clear ]
                                                }
                                      
                                    }             
                            finish { ambient 0.1 }
                          }                                                    
                                                    
// *******************************************************

#declare SailO =
                difference {
                             box { < -10, -10, 0 >,< 10, 0, -10 > }
                             union {
                                     cylinder { < 0, 0, 1 >,< 0, 0, -11 >,7 
                                                    scale < 0.25, 1, 1 >
                                                    rotate z*-20
                                                    translate < -11, -5, 0 >
                                              }                                    
                                     cylinder { < 0, 0, 1 >,< 0, 0, -11 >,7 
                                                    scale < 0.25, 1, 1 >
                                                    rotate z*20
                                                    translate < 11, -5, 0 >
                                              } 
                                     cylinder { < 0, 0, 1 >,< 0, 0, -11 >,12 
                                                    scale < 1, 0.3, 1 >                                                    
                                                    translate y*-10
                                              }
                                    }      
                                           
                             }
                             
#declare Deck =
               cylinder { < 0, 0, 0 >,< 0, 1, 0 >,30 
                                   scale < 1.2, 1, 0.25 >
                                   translate y*-40
                                   texture { PaintB }
                        } 
                        
#declare Bwark =
                difference {
                            cone { < 0, 0, 0 >,30,< 0, 2, 0 >,34 open
                                    scale < 1.2, 1, 0.25 > 
                                 }
                            box { < -10, -1, -10 >,< 43, 3.5, 10 > }        
                                    translate y*-40
                                    texture { PaintB }
                           } 
                           
#declare Hull =
                cone { < 0, 0, 0 >,30,< 0, -5, 0 >,26
                                     scale < 1.2, 1, 0.25 >
                                     translate y*-40
                                     texture { PaintA }
                                     texture { PaintC }
                                     texture { PaintD }
                     }                

#declare House =
                 difference {
                             box { < -10, 1, -4 >,< 10, 3, 4 > }
                             union {
                                    box { < -2, 1.5, -4.5 >,< 2, 2.5, -3.6 > translate x*-7 }
                                    box { < -2, 1.5, -4.5 >,< 2, 2.5, -3.6 > }
                                    box { < -2, 1.5, -4.5 >,< 2, 2.5, -3.6 > translate x*7 }
                                                texture { PaintA }
                                   }             
                                    translate y*-40 texture { PaintB }
                           } 
                 
#declare Lboat =
                 union {
                         cylinder { < -2, -1.5, 0.76 >,< -2, 1.2, 0 >,0.12 }
                         cylinder { < 2, -1.5, 0.76 >,< 2, 1.2, 0 >,0.12 }
                         difference {
                                     sphere { < 0, 0, 0 >,2 }
                                     box { < -2.1, 0, -2.1 >,< 2.1, 2.1, 2.1 > }
                                                   scale < 1.5, 0.6, 0.25 >
                                    }     
                                       translate < 0, -37.5, -8 >
                                       texture { PaintB }
                      } 
                      
#declare Raft =
               superellipsoid { < 0.25, 0.25 > scale < 3, 1, 1.5 > translate y*-38 texture { PaintA } }
                
                
#declare Mast =
               cone { < 0, 0, 0 >,0.6,< 0, 50, 0 >,0.15 translate y*-40 texture { PaintA } }
               
#declare Spar =
               cylinder { < -9, 0, 0 >,< 9, 0, 0 >,0.12 texture { PaintB } }
               
#declare Spars =
                 union {
                         object { Spar }
                         object { Spar scale < 0.7, 1, 1 > translate y*6 }   
                         object { Spar scale < 1.25, 1, 1 > translate y*-9 }
                         object { Spar scale < 1.5, 1, 1 > translate y*-17 }                      
                         object { Spar scale < 1.85, 1, 1 > translate y*-26 }
                       }
                       
#declare Jib =
              cylinder { < 0, 0, 0 >,< -17, 0, 0 >,0.25
                              rotate z*-20
                              translate < -35, -40, 0 >
                              texture { PaintA }
                       }
                       
#declare Rigging =
                   box { < -7, -7, -0.1 >,< 7, 7, 0.1 >                                  
                                  scale < 1, 5, 1 >                                  
                                  texture { Sheets }
                                  rotate z*20 
                                  clipped_by {
                                               box { < -4, -20, -0.2 >,< 15, 50, 0.2 > }
                                             }                                           
                                  translate < 4, -20, 0 >
                       }                                                                                               

#declare SailA =
                 cylinder { < -12, 0, 0 >,< 12, 0, 0 >,6 
                                     scale < 1, 1, 0.7 > 
                                     translate y*-5
                                     clipped_by {
                                                  object { SailO }
                                                }
                                     texture { Canvas }
                                     texture { Seams }
                          } 
                          
#declare SailB =
                union {
                       sphere { < 0, 0, 0 >,7 scale < 1, 0.1, 0.1 > translate x*-6 }  
                       sphere { < 0, 0, 0 >,7 scale < 1, 0.115, 0.1 > translate x*6 }
                                   texture { Canvas }
                      }
                      
#declare SailC =
                 cylinder { < 0, -20, 0 >,< 0, 25, 0 >,10
                                clipped_by {
                                             box { < -10, -10, 0 >,< 10, 10, -11 >
                                                     rotate z*45
                                                     scale < 0.5, 1.25, 1 > 
                                                     translate x*-10
                                                 }
                                           } 
                                scale < 0.7, 0.9, 0.2 > 
                                rotate < 0, 0, -42 >                
                                texture { Canvas }
                          } 
#declare SailL =
                cone { < 0, 0, 0 >,0,< 30, 10, 0 >,20 
                            clipped_by {
                                         difference {
                                                      box { < 10, 1, -21 >,< 30, 20, 0 > }
                                                      box { < 0, 0, 1 >,< 20, 25, -22 > rotate z*30 translate x*30 }
                                                     }
                                       }
                            scale < 1, 0.75, 0.1 >
                            texture { Canvas }
                     }                                                                                                                                               

#declare Sset =
                union {                       
                       object { Mast } 
                       object { Rigging rotate y*-20 }
                       object { Rigging rotate y*160 }
                       object { Spars }                         
                       object { SailA scale < 0.7, 0.6, 1 > translate y*6 }                            
                       object { SailA  } 
                       object { SailA scale < 1.25, 0.8, 1 > translate y*-9 }   
                       object { SailA scale < 1.5, 0.8, 1 > translate y*-17 } 
                       object { SailB scale < 1.2, 1, 1 > translate y*-26 } 
                      }
#declare Sailor =
                  union {
                          difference { 
                                      sphere { < 0, 0, 0 >,1 texture { PaintA }  }
                                      box { < -1.1, -1.1, -1.1 >,< 1.1, 0.2, 0.6 > }
                                              scale < 0.8, 1, 0.8 > 
                                              translate y*2.5
                                     }
                          sphere { < 0, 0, 0 >,0.95 scale < 0.8, 1, 0.8 >
                                                    translate y*2.5 
                                                    texture { Canvas }
                                 }                             
                          sphere { < 0, 0, 0 >,2 scale < 1, 1, 0.4 > } 
                          cylinder { < -0.8, -1, 0 >,< -1.2, -5.5, 0 >,0.76 scale < 1, 1 0.5 > texture { Canvas } }
                          cylinder { < 0.8, -1, 0 >,< 1.2, -5.5, 0 >,0.76 scale < 1, 1, 0.5 > texture { Canvas } }
                                        scale 0.25
                                        texture { PaintA }
                                        texture { Shirts }
                        }                      
#declare Ship =
               union {
                      object { Deck }
                      object { Bwark }
                      object { Hull }
                      object { House translate x*-5 }
                      object { House scale < 0.5, 1, 1 > translate x*19 }
                      object { House scale < 0.25, 1, 0.8 > translate < 21, 2, 0 > }
                      object { Lboat }
                      object { Lboat translate x*6.5 }
                      object { Lboat translate x*-6.5 }
                      object { Raft translate x*-32 }
                      object { Raft translate x*-25 }
                      object { Raft translate x*-18 }
                      object { Sset rotate y*20 translate x*14 } 
                      object { Sset rotate y*20 translate x*-14 } 
                      object { SailC translate < -34, -27, 0 > }
                      object { SailC rotate x*-5 translate < -29, -29, 0 > }
                      object { SailC scale < 1.25, 0.8, 0.8 > rotate < -10, 0, 15 > translate < -22, -27, 0 > }
                      object { SailL translate < 5, -33, 0 > }
                      object { Spar scale < 1.2, 1, 1 > translate < 25, -33.5, 0 > }
                      object { Jib }
                      object { Sailor translate < -20, -38, -5 > }
                      object { Sailor translate < -21, -38, -5 > }
                      object { Sailor translate < -23, -38, -5 > }
                      object { Sailor translate < -24, -38, -4.5 > }
                      object { Sailor translate < -26, -38, -4 > }
                      object { Sailor translate < -27, -38, -4 > }
                      object { Sailor translate < -2, -35.5, 0 > }
                      object { Sailor translate < -4, -35.5, 0 > }
                      object { Sailor translate < -6.2, -35.5, 0 > }
                      object { Sailor translate < -9.4, -35.5, 0 > }
                      object { Sailor translate < -16.2, -35.5, 0 > }
                      object { Sailor translate < -19.4, -35.5, 0 > }
                      object { Sailor translate < 15.2, -35.5, -3 > }
                      object { Sailor translate < 17.4, -35.5, -3 > }
                                     translate y*45
                     }                      

object { Ship scale 0.38 rotate y*-60 translate < -10, 0, 40 > } 

/* TerraE.pov      ( to make height field for cliffs  )     18 May 2006

#include "colors.inc"

background { color rgb < 0.5, 0.5, 0.8 > }

camera {
        location < 0, 0, -50 >        
        look_at < 0, 0, 0 >
        angle 30
        }
        
light_source { < 10, 10, -100 > color White }

plane { z, 0
             pigment {
                       wrinkles
                       color_map {
                                  [ 0 color rgb < 1, 1, 0 > ]                                  
                                  [ 0.4 color rgb < 0.9, 0.85, 0 > ]   
                                  [ 0.5 color rgb < 0.7, 0.8, 0 > ] 
                                  [ 0.6 color rgb < 0.8, 0.6, 0 > ]                                  
                                  [ 1.0 color rgb < 1, 0.75, 0 > ]
                                 }
                           scale < 10, 8, 105 > translate < 1.5, -1, 0 >    
                    }
             finish { ambient 0.4 diffuse 0.4 }
      } 
      
*/      



