
// POV-Ray Object File - 1937 Ford Stake Truck
// created 22-Jun-06
// last update 22-Jun-06
// Copyright 2006 Glenn McCarter (glenn@mccarters.net). Some rights reserved.
// This work is licensed under the Creative Commons Attribution License
// To view a copy of this license, visit http://creativecommons.org/licenses/by/2.0/
//
// Required #include files: "GIncludeRH.inc", "Tires.inc"
//
// Objects:
// Ford37_StakeTruck
//
//
// Intended scale is English system (inches)
// Uses RH coordinate reference system (Z=up)
// Truck sits on Z=0 plane, origin at ground level, between front wheels
// +X is towards the rear of the truck
//
// This file is intended to be included in another POV-Ray scene file,
// but can be rendered alone.
#ifndef (ThisIsMaster) // If this include file was not called by another, then
	#declare RenderMe = 0; // supress self-rendering of other include files
	#declare ThisIsMaster = 1;
	#include "GIncludeRH.inc"
	// renderable sub includes go here
	#declare RenderMe = 1;
#end


//===============================================
//             Variable Declarations
//===============================================

#declare GlassQual = 1;

// set user defaults
#ifndef ( SteeringAngle )
	#declare SteeringAngle = 5; // positive = to the right
#end
#ifndef ( LFJounce )
	#declare LFJounce = 0; // Left Front wheel elevation
#end
#ifndef ( RFJounce )
	#declare RFJounce = 0;
#end
#ifndef ( LRJounce )
	#declare LRJounce = 0;
#end
#ifndef ( RRJounce )
	#declare RRJounce = 0;
#end
#ifndef ( RimColor )
	#declare RimColor = color rgb<.68,.09,.09>; // default is red
#end

#declare HeadlampTex =
	texture {
		pigment { color rgb<.3,.3,.3> }
		finish { ambient 0.02 reflection 0.3 }
	}

// set vehicle main variables
#declare Wheelbase = 118;
#declare FrontTread = 27; // to the inside of the tire
#declare RearTread = 13; // to the inside of the tire

#include "Tires.inc"

//===============================================
//             Transformations
//===============================================

#declare InverseY = // forms a mirror image
	transform {
  	matrix < 1, 0, 0,
             0, -1, 0,
             0, 0, 1,
             0, 0, 0 >
	}

#declare ShearXZ03 =
	transform {
  	matrix < 1, 0, 0, // shear along x-axis, dependent on Z
             0, 1, 0,
            .3, 0, 1,
             0, 0, 0 >
	}
#declare ShearXZ05 =
	transform {
  	matrix < 1, 0, 0, // shear along x-axis, dependent on Z
             0, 1, 0,
            .5, 0, 1,
             0, 0, 0 >
	}
#declare ShearYX03 =
	transform {
  	matrix < 1, .3, 0, // shear along y-axis, dependent on x
             0, 1, 0,
             0, 0, 1,
             0, 0, 0 >
	}


//===============================================
//             Textures
//===============================================

#declare TestTex =
	texture {
		pigment { color rgb<1,1,1> }
		finish { ambient .4 }
	}

#declare SteelTex =
	texture {
		pigment { color rgb<.6,.6,.6> }
		finish {
			ambient .02
			brilliance 6
			diffuse .7
			metallic
			specular .9
			roughness .02
//			reflection .3
		}
	}


#declare GChrome =
	texture {
		pigment { color rgb <0.39, 0.41, 0.43> }
		finish {
			ambient 0.1
			brilliance 6
			diffuse 0.7
			metallic
			specular 0.80
			roughness .01
			reflection 0.8
		}
	}


#declare HubCapTex = texture { GChrome }
//#declare WheelTexture = texture { pigment {White}}
#declare ChromeTex = texture { GChrome }

#declare RimTex =
	texture {
		pigment { RimColor }
		finish { specular .7 roughness .02 }
	}

#declare BrightWhitePaint =
	texture {
		pigment { color rgb<1.0,1.0,1.0> }
		finish { ambient .4 specular .7 roughness .02 }
	}
#declare BlackPaint =
	texture {
		pigment { color rgb<0.0,0.0,0.0> }
		finish { specular .7 roughness .02 }
	}

#declare BodyTex =
	texture {
		pigment { color <0,0,0> }
		finish { specular .8 roughness .008 reflection 0.24 } // for best appearance
//		finish { specular .8 roughness .02 } // for fast render
		normal { bumps .03 scale 10 } // add some waviness
	}

/*
#declare BodyTex = // for test renders only. COMMENT OUT for final render
	texture {
		pigment { color <.7,.6,0> }
		finish { specular .8 roughness .02 } // for fast render
	}
*/


#declare BodyInsideTex =
//    texture { pigment { color <1,1,1> }}
    texture { pigment { color <.5,.5,.5> }}

#declare GlassTex =
	texture {
		#if (GlassQual=1)
			pigment { color rgbf<.70,.75,.72,.97> }
			finish { ambient .02 }
//			finish { ambient .02 reflection .4 }
		#else
			pigment { color rgb<.57,.55,.72>*.6 }
		#end
	}
//    texture { pigment { color Blue }} // for fast render

#declare SeatTexture = // leather
  texture {
    pigment { color <.36,.16,.07> }
    finish { specular .4 roughness .08 }
    normal {crackle .5 scale .5}
  }

#declare ClearPlastic =
	texture {
		pigment { color rgbt<.65,.54,.78,.9> }
		finish { specular .8 roughness .003 }
	}
#declare RedTintPlastic =
	texture {
		pigment { color rgbf<.95,.04,.08,.8> }
		finish { specular .8 roughness .003 }
	}
#declare BrightChrome =
	texture {
		pigment { color rgb <0.69, 0.61, 0.63> }
		finish {
			ambient 0.1
			brilliance 6
			diffuse 0.7
			metallic
			specular 0.80
			roughness .002
			reflection 0.95
		}
	}
#declare WhitePaint =
	texture {
		pigment { color rgb<.95,.94,.98> }
		finish { specular .8 roughness .03 }
	}
#declare TruckChassisTex =
	texture {
		pigment { color rgb<.95,.94,.98>*.02 }
		finish { specular .2 roughness .33 }
	}
#declare StakeTex =
	texture {
		pigment { color rgb<.95,.85,.68>*.42 }
		finish { specular .2 roughness .33 }
	}

//===============================================
//             Wheels
//===============================================

#declare RimHoles = // four rounded slots
	difference {
			cylinder { // outer
				<0,-.05,0>,<0,6,0>,6.5
				texture { RimTex }
			}
			cylinder { // inner hole
				<0,-.1,0>,<0,6.1,0>,6.1
				texture { RimTex }
			}
			box { // cuts two slots
				<-2,-.2,-8>,<2,6.2,8>
				texture { RimTex }
			}
			box { // cuts two slots
				<-2,-.3,-8>,<2,6.3,8>
				texture { RimTex }
				rotate y*90
			}
	} // end of difference

#declare WRim =
	difference {
		lathe { // spun around Y-axis
			cubic_spline
			24,
			<1.0,3.8>,<1.2,3.5>,<1.5,3.3>, // near spindle
			<6.5,3.3>,<7.0,3.0>,<7.3,2.7>, // hubcap mount
			<7.6,2.0>,<7.7,1.7>,<7.8,1.4>,<8.0,1.2>, // outer rim
			<8.4,1.2>,<8.7,1.0>,<8.9,1.2>,<8.7,1.4>, // bead area
			<7.5,3.5>,<6.5,4.0>, // backside
			<1.6,4.0>,<1.4,4.2>,<1.3,4.3>,<1.2,4.4>,<1.0,4.3>, // backside spindle
			<1.0,3.8>,<1.2,3.5>,<1.5,3.3> // three duplicate points
			texture { RimTex }
		}
		object { RimHoles }
	}

#declare HubCap =
	union {
		sphere {
			<0,6.5,0>,6
			texture { HubCapTex }
			clipped_by {
			box { <-5,0,-5>,<5,3,5> } }
		}
		torus { // hubcap rim
			4.3,.4
			texture { HubCapTex }
			translate <0,3,0>
		}
	}

#declare WheelAssy =
	union {
		object { Tire translate <0,0,0> }
		object { WRim  translate <0,0,0> }
		object { HubCap translate <0,-.5,0> }
	}
#declare LeftFrontWheelAssy =
  object { WheelAssy
		translate <0,-4,0> // move to steering pivot
    rotate <0,0,-SteeringAngle> // steer it
		translate <0,4,0> // move back
    translate <0,-10,13> // raise it above ground, origin at inside of tire
    translate <0,-FrontTread,0>
  }
#declare RightFrontWheelAssy =
  object { WheelAssy
		scale <1,-1,1>
		translate <0,4,0> // move to steering pivot
    rotate <0,0,-SteeringAngle>
		translate <0,-4,0> // move back
    translate <0,10,13>
    translate <0,FrontTread,0>
  }
#declare LeftRearWheelAssy =
  object { WheelAssy
    rotate <0,0,0>
    translate <0,-10,13>
    translate <Wheelbase,-RearTread,0>
  }
#declare RightRearWheelAssy =
  object { WheelAssy
    rotate <0,0,180>
    translate <0,10,13>
    translate <Wheelbase,RearTread,0>
  }


//===============================================
//             Front End
//===============================================

#declare Hood =
	union {
		superellipsoid { // RH side
			<.3,.3>
			texture { BodyTex }
			transform ShearYX03
			scale <29,12,16>
			translate <0,6,0>
		}
		superellipsoid { // LH side
			<.3,.3>
			texture { BodyTex }
			transform ShearYX03
			rotate x*180
			scale <29,12,16>
			translate <0,-6,0>
		}
/*
		superellipsoid { // front end
			<.6,.3>
			texture { BodyTex }
			transform ShearXZ05
			scale <8,12,14>
			translate <-25,0,-.3>
		}
*/
		translate <16,0,18> // origin at front base
	}

#declare GrilleShape =
		superellipsoid { // front end
			<.6,.4>
			transform ShearXZ05
			scale <8,12,14>
			translate <0,0,0>
		}

#declare Grille =
	union {
		difference {
			object { GrilleShape
				texture { ChromeTex }
				clipped_by {
//					box { <-8,-20,-26>,<1,20,26> rotate y*12 }
					box { <-48,-420,-426>,<0,420,426> transform ShearXZ05 }
				}
			}
			object { GrilleShape texture { ChromeTex }scale <2,.75,.85> translate <-2,0,0> }
		} // end difference
		intersection {
			object { GrilleShape texture { ChromeTex }scale <4,.75,.9> }
			union {
				cylinder { // center
					<0,0,-10>,<0,0,14>,.3
					scale <5,1,1>
					rotate y*12
					texture { ChromeTex }
				}
				cylinder {
					<0,-2,-10>,<0,-2,14>,.3
					scale <5,1,1>
					rotate y*12
					translate <.4,0,0>
					texture { ChromeTex }
				}
				cylinder {
					<0,2,-10>,<0,2,14>,.3
					scale <5,1,1>
					rotate y*12
					translate <.4,0,0>
					texture { ChromeTex }
				}
				cylinder {
					<0,-4,-10>,<0,-4,14>,.3
					scale <5,1,1>
					rotate y*12
					translate <.6,0,0>
					texture { ChromeTex }
				}
				cylinder {
					<0,4,-10>,<0,4,14>,.3
					scale <5,1,1>
					rotate y*12
					translate <.6,0,0>
					texture { ChromeTex }
				}
				cylinder {
					<0,-6,-10>,<0,-6,14>,.3
					scale <5,1,1>
					rotate y*12
					translate <1.0,0,0>
					texture { ChromeTex }
				}
				cylinder {
					<0,6,-10>,<0,6,14>,.3
					scale <5,1,1>
					rotate y*12
					translate <1.0,0,0>
					texture { ChromeTex }
				}
				cylinder {
					<0,-8,-10>,<0,-8,14>,.3
					scale <5,1,1>
					rotate y*12
					translate <1.3,0,0>
					texture { ChromeTex }
				}
				cylinder {
					<0,8,-10>,<0,8,14>,.3
					scale <5,1,1>
					rotate y*12
					translate <1.3,0,0>
					texture { ChromeTex }
				}
				translate <-5,0,0>
			} // end union of bars
		} // end intersection
		translate <0,0,23> // raise it all up
	}

#declare InnerFenderRH = // connects fenders to hood
	cylinder {
		<0,-8,0>,<0,0,0>,13
		texture { BodyTex }
		clipped_by { box { <-16,-16,-3>,<16,16,16> } }
		translate <0,FrontTread,13>
	}
#declare InnerFenderLH = // connects fenders to hood
	object { InnerFenderRH transform InverseY }

#declare FrontPanel = // underlies front end
	superellipsoid {
		<.2,.2>
		texture { BodyTex }
		scale <36,20,2>
//		clipped_by { box { <-16,-16,-3>,<16,16,16> } }
		translate <-4,0,10>
	}

#declare BumperOuter =
		blob {
			threshold .7 // high = close to center
			cylinder { <0,-FrontTread,0>,<0,FrontTread,0>,6,4.6 }
			sphere { <0,0,0>,20,.8 scale <2.0,2.0,1.2> translate <2,-FrontTread,0> } // outboard end cap
			sphere { <0,0,0>,20,.8 scale <2.0,2.0,1.2> translate <2,FrontTread,0> } // outboard end cap
			sphere { <0,0,0>,22,1 scale <.6,.2,.6> translate <0,12,3> } // center attach
			sphere { <0,0,0>,22,1 scale <.6,.2,.6> translate <0,-12,3> } // center attach
		scale <1,1,.8>
		texture { HubCapTex }
	}

#declare BumperInner =
	union {
		cylinder {
			<0,-FrontTread-2,0>,<0,FrontTread+2,0>,8
		}
		sphere {
			<0,0,0>,8
			scale <1,1,1>
			translate <0,-FrontTread-2,0>
		}
		sphere {
			<0,0,0>,8
			scale <1,1,1>
			translate <0,FrontTread+2,0>
		}
		texture { SteelTex }
	}

#declare FBumper =
	difference {
		object { BumperOuter }
		object { BumperInner translate <8,0,0> }
//		object { BumperOuter scale <1,.99,1> translate <.2,0,0> }
		scale <.8,.8,.7>
	}

#declare OFBEndCap =
	difference {
		cylinder { // main
			<0,0,0>,<0,0,1.8>,3
		}
		cylinder { // subtract inner
			<0,0,-2>,<0,0,2>,2.75
		}
		box { // cut off LH
			<-6,-6,-2>,<6,0,2>
		}
		box { // cut off rear
			<-.3,-6,-2>,<6,6,2>
		}
		texture { HubCapTex }
	}
#declare BumperBeam =
	box {
		<0,-26,0>,<.25,26,1.8>
		texture { HubCapTex }
	}
#declare FatRivet =
	sphere {
		<0,0,0>,.2
		scale <.3,1,1>
		texture { HubCapTex }
	}
#declare OFBAssy =
	union {
		object { BumperBeam }
		object { OFBEndCap translate <0,26,0> }
		object { OFBEndCap rotate <180,0,0> translate <0,-26,0> }
		object { FatRivet translate <-.2,12,0.9> }
		object { FatRivet translate <-.2,-12,0.9> }
	}
#declare OldFBumper =
	union {
		object { OFBAssy }
		object { OFBAssy translate <0,0,2.6> }
	}

#declare FenderShape =
	blob {
		threshold .3
//		sphere { <0,0,0>,42,0.6 scale <1,.4,1> }
//		sphere { <0,0,0>,26,0.1 scale <1,.8,1> translate <26,0,6> }
		sphere { <0,0,0>,42,0.6 scale <1,.4,1> }
		sphere { <0,0,0>,33,0.18 scale <1,.6,1> translate <36,0,6> }
		scale <.85,1,1> rotate <0,20,0>
	}
#declare Fender =
	difference {
		object { FenderShape texture { BodyTex } }
		object { FenderShape scale .97 texture { BodyTex } }
		cylinder { // wheel cutout
			<0,-18,0>,<0,18,0>,13
			texture { BodyTex }
		}
		clipped_by { // cut off bottom edge
			box {	<-26,-12,-3>,<70,12,26> } }
	}

#declare Fenders =
	union {
		object { Fender // left front
			translate <0,-FrontTread-2,13>
		}
		object { Fender // right front
			translate <0,FrontTread+2,13>
		}
	}

#declare RockerPanelRH =
	box {
		<0,0,0>,<56,9,1>
		texture { BodyTex }
	}
#declare RockerPanelLH =
	object { RockerPanelRH transform InverseY }

//===============================================
//             Main Body
//===============================================

#declare OuterShellShape = // this has no texture
	union {
		superellipsoid { // front
			<.3,.3>
			transform ShearXZ03
			scale <16,28,25>
			translate <-13,0,0>
		}
		superellipsoid { // middle
			<.3,.3>
			scale <16,28,25>
		}
/*
		superellipsoid { // rear
			<.3,.3>
//			transform ShearXZ03
			rotate z*180
			scale <16,28,25>
			translate <8,0,0>
		}
*/
	}

#declare OuterShell =
	object { OuterShellShape texture { BodyTex } }
#declare InnerShell =
	object { OuterShell scale .95 }

#if (GlassQual=1)
#declare OuterGlass =
	object { OuterShellShape scale .97 texture { GlassTex } }
#declare InnerGlass =
	object { OuterShellShape scale .96 texture { GlassTex } }
#declare AllGlass =
	intersection {
		object { OuterGlass }
		object { InnerGlass inverse }
	}
#else
#declare AllGlass =
	object { OuterShellShape scale .97 texture { GlassTex } }
#end

#declare FrontWindowCutout =
	union {
		superellipsoid {
			<.2,.2>
			texture { BodyTex }
			scale <12,4,6>
		}
		superellipsoid {
			<.5,.5>
			texture { BodyTex }
			transform ShearXZ03
			scale <10,4,6>
			translate <-2,0,0>
		}
	}
#declare RearWindowCutout =
	union {
		superellipsoid {
			<.3,.3>
			texture { BodyTex }
			scale <5,4,6>
		}
		superellipsoid {
			<.6,.6>
			texture { BodyTex }
			transform ShearXZ05
			rotate z*180
			scale <6,4,6>
			translate <3,0,0>
		}
	}
#declare WindshieldCutout =
	superellipsoid {
		<.2,.2>
		texture { BodyTex }
		scale <10,23,6>
	}
#declare BacklightCutout =
	superellipsoid {
		<.4,.4>
		texture { BodyTex }
		scale <8,16,4.5>
	}
#declare Antenna =
	union {
		cylinder { // base
			<0,0,0>,<0,0,2>,.6
			texture { pigment { color rgb<1,1,1> } }
		}
		cone {
			<0,0,0>,.1,<0,0,28>,.05
			texture { pigment { color rgb<1,1,1> } }
		}
		sphere { // tip
			<0,0,28>,.1
			texture { pigment { color rgb<1,1,1> } }
		}
	}


//===============================================
//         Truck Bed
//===============================================

#declare TBL=6*Feet; // truck bed length
#declare TBW=5*Feet; // truck bed width
#declare LSideStakes =
	union {
		box { <1,1,0>,<3,2,36> translate <0,0,0> }

		box { <1,1,0>,<3,2,36> translate <24,0,0> }
		box { <1,1,0>,<3,2,36> translate <24+4,0,0> }

		box { <1,1,0>,<3,2,36> translate <48,0,0> }
		box { <1,1,0>,<3,2,36> translate <48+4,0,0> }

//		box { <1,1,0>,<3,2,36> translate <60,0,0> }
//		box { <1,1,0>,<3,2,36> translate <60+4,0,0> }

		box { <1,1,0>,<3,2,36> translate <TBL-4,0,0> }

		box { <1,2,0>,<TBL-1,2.7,9> }
		box { <1,2,0>,<TBL-1,2.7,4> translate <0,0,13> }
		box { <1,2,0>,<TBL-1,2.7,4> translate <0,0,22> }
		box { <1,2,0>,<TBL-1,2.7,4> translate <0,0,31> }
		texture { StakeTex }
	} // end union
#declare TruckBed =
	union {
		box { <0,-TBW/2,0>,<TBL,TBW/2,2.5> texture { TruckChassisTex } } // bed
		object { LSideStakes translate <0,-TBW/2,0> }
		object { LSideStakes scale <1,-1,1> translate <0,TBW/2,0> }
		texture { StakeTex }
	} // end union
#declare TruckChassis =
	union {
		box { <0,-1.5,-14>,<TBL-5,1.5,1> translate <0,-11,0> }
		box { <0,-1.5,-14>,<TBL-5,1.5,1> translate <0, 11,0> }
		box { <-100,-8.5,-12>,<TBL-8,8.5,0> translate <0, 0,0> } // front chassis
		cylinder { <0,0,0>,<7,0,0>,3 translate <TBL-8,-11,-3> } // tail light
		cylinder { <0,0,0>,<7,0,0>,3 translate <TBL-8, 11,-3> } // tail light
		texture { TruckChassisTex }
	} // end union

//===============================================
//       Interior
//===============================================

#declare DomeLightColor =
     rgb <.12, .05, .4>;
#declare DomeLight =
    light_source {
      <0,0,0>
      color DomeLightColor
      looks_like {
        cylinder {
          <0,0,0>, <9,0,0>, .3
          scale <1,1,3> rotate <0,16,0>
          texture {
            pigment { color DomeLightColor*2 }
            finish { ambient .99 diffuse .2 }
          }
        }
      }
    }

#declare Seat = // center is at hinge point
  union {
    superellipsoid { // seat back
       <.8,.2>
       scale <3,10,11> translate <2,0,12>
       texture { SeatTexture }
    }
    superellipsoid { // seat bottom
       <.8,.2>
       scale <6,10,3> rotate <0,5,0> translate <-4,0,1>
       texture { SeatTexture }
    }
    scale <1,1,1> rotate <0,15,0> translate <0,0,0>
  } // end union

#declare RearSeat = // center is at hinge point
	object { Seat
    scale <1,2.3,1>
  }

#declare InstrumentPod =
	difference {
		cylinder { // main outer pod
			<0,0,0>,<-3,0,0>,7
			texture { pigment { color <.10,.07,.14> }}
			scale <1,1,.25> rotate <0,-6,0>
		}
		cylinder {
			<-.5,3,0>,<.3,3,0>,1.3
			texture { pigment { color <.20,.22,.24> }
				finish { ambient .15 } }
			scale <1,1,1> rotate <0,-6,0>
		}
		cylinder {
			<-.5,-3,0>,<.3,-3,0>,1.3
			texture { pigment { color <.20,.22,.24> }
				finish { ambient .15 } }
			scale <1,1,1> rotate <0,-6,0>
		}
	} // end differrence

#declare SteeringWheel =
	union {
		torus {
			8,.4
			texture {
				pigment { color rgb<.52,.33,.12> }
			}
		}
		cylinder {
			<0,0,0>,<-12,0,0>,1.5
			texture {
				pigment { color rgb<.1,.1,.1> }
				finish { specular .8 roughness .01 }
			}
		}
		rotate z*90 rotate y*-15
	} // end union

#declare InteriorRearViewMirror =
	union {
		cylinder { <0,0,0>,<0,0,-4>,0.35 }
		sphere { <0,0,0>,3.5 scale <0.07,1,0.4> translate <1.2,0,-4> }
		texture { GChrome }
	} // end union

//===============================================
//       Decoration
//===============================================

#declare StarPart =
	prism { // extruded along y-axis
		linear_sweep
		linear_spline
		-10,        // height 1
		-44,        // height 2
		4,          // number of points
		// the <u,v> points
		< -0.3, 0.0>,
		<  0.0, 1.0>,
		<  0.3, 0.0>,
		< -0.3, 0.0>
		texture {
			pigment { color rgb<.9,.9,.2> }
			finish { specular .8 roughness .01 reflection .3 }
		}
	}
#declare StarShape =
	union {
		object { StarPart rotate <0,0,0> }
		object { StarPart rotate <0,360/5,0> }
		object { StarPart rotate <0,360/5*2,0> }
		object { StarPart rotate <0,360/5*3,0> }
		object { StarPart rotate <0,360/5*4,0> }
	}
#declare StarPaint =
	intersection {
		object { StarShape scale <8,1,8> translate <16,0,20> }
		object { OuterShellShape
			texture {pigment{color rgb<.9,.9,.2>}} translate <24,0,24> }
		object { OuterShellShape inverse scale .96
			texture {pigment{color rgb<.9,.9,.2>}} translate <24,0,24> }
	}

#declare LoneStarTextShape =
	intersection {
    text { // extruded into +Z
      ttf "c:\Windows\Fonts\ARIALBD.TTF",
      "Lone     Star",
      50,  0
      texture { BrightWhitePaint }
      scale <3,3,3>
      rotate <90,0,0> // extruded into -Y
      translate <7,0,23.5>
    }
		object { OuterShellShape texture { BrightWhitePaint }
			translate <24,0,24> }
		object { OuterShellShape texture { BrightWhitePaint }
			inverse scale .96 translate <24,0,24> }
	}
#declare LoneStarText =
	object { LoneStarTextShape texture { WhitePaint }	}

#declare CrimefightersTextShape =
	intersection {
    text { // extruded into +Z
      ttf "c:\Windows\Fonts\ARIALBD.TTF",
      "Crimefighters",
      10,  0
      scale <3,3,3>
      rotate <90,0,0> // extruded into -Y
      translate <6,0,12>
    }
		object { OuterShellShape texture { BrightWhitePaint }
			translate <24,0,24> }
		object { OuterShellShape texture { BrightWhitePaint }
			inverse scale .96 translate <24,0,24> }
	}
#declare CrimefightersText =
	union {
		object { CrimefightersTextShape texture { WhitePaint } }
		object { CrimefightersTextShape texture { BlackPaint } translate <.2,.01,-.2> }
	}

#declare BodyPaint =
	union {
		object { StarPaint translate <0,-.05,0> }
		object { StarPaint transform InverseY translate <0,.05,0> }
		object { LoneStarText translate <0,-.06,0> }
		object { CrimefightersText translate <0,-.05,0> }
	}

//===============================================
//       Objects
//===============================================

#declare Headlamp =
	union {
		torus {
			4.5,.4
			texture { BrightChrome }
			rotate z*90
			scale <2.5,1,1>
		}
		sphere { // outer shell
			<0,0,0>, 4.5
			texture {	BodyTex }
			scale <2.5,1,1>
			clipped_by { box { <0,-6,-6>,<14,6,6> } }
		}
		sphere { // lens
			<0,0,0>, 4.5
			texture {
				HeadlampTex
			}
			scale <.3,1,1>
			translate <-.4,0,0>
		}
	} // end union
#declare Taillamp =
	union {
		superellipsoid { // black housing
			<.3,.3>
			scale <2,2,2>
			texture {
				pigment { color rgb<.02,.02,.08> }
				finish { phong .8 phong_size 100 }
			}
			clipped_by { box { <-3,-3,-3>,<.51,3,3> } }
		}
		superellipsoid { // lens
			<.3,.3>
			scale <2,2,2>
			texture {
				pigment { color rgbt<.8,.1,.1,.5> }
				finish { phong .8 phong_size 100 }
			}
			clipped_by { box { <.5,-3,-3>,<3,3,3> } }
		}
		box { // support
			<-6,-.6,-1>,<0,.6,1>
			texture {
				pigment { color rgb<.02,.02,.08> }
				finish { phong .8 phong_size 100 }
			}
		}
	} // end union

#declare LicensePlate =
	union {
		box { // outer frame
			<0,-5.5,0>,<.1,5.5,3.7>
			texture { pigment { color rgb<.6,.6,.6> } }
			rotate <0,-8,0>
		}
		box { // fake lettering
			<.08,-4.9,0.6>,<0.12,4.9,3.1>
			texture {
				pigment {
					bozo
					color_map {
						[ 0.0  color rgb<0.1,0.1,0.1> ]
						[ 0.3  color rgb<0.1,0.1,0.1> ]
						[ 0.5  color rgb<0.6,0.6,0.6> ]
						[ 0.8  color rgb<0.1,0.1,0.1> ]
						[ 1.0  color rgb<0.1,0.1,0.1> ]
					}
					turbulence .4
				}
			}
			rotate <0,-8,0>
		}
	} // end union
#declare DoorHandleLH =
	union {
		torus {
			2.5,.2
			rotate x*90
			scale <1,.25,1>
			clipped_by { box { <-4,.3,-1>,<4,-3,1> } }
		}
		cylinder { // lock cyl
			<0,.3,0>,<0,-.8,0>,.3
			translate <2.5,0,0>
		}
		torus { // lock cyl ring
			.26,.04
			translate <2.5,-.8,0>
		}
		texture { BrightChrome }
	} // end union
#declare DoorHandleRH =
	object { DoorHandleLH transform InverseY }

#declare ExteriorRearViewMirrorLH =
	union {
		sphere { <0,0,0>,3 scale <1,0.5,0.5> }
		cylinder { <0,0,0>,<0,0,9>,0.6 rotate x*45 }
		superellipsoid { <0.23,0.23> scale <1.5/2,6/2,4/2> rotate z*25 translate <1,-7,7> }
		texture { GChrome }
	} // end union
#declare ExteriorRearViewMirrorRH =
	object { ExteriorRearViewMirrorLH scale <1,-1,1> }


//===============================================
//       Assemblies
//===============================================

#declare Wheels =
	union {
		object { RightFrontWheelAssy translate <10,0,RFJounce> }
		object { LeftFrontWheelAssy translate <10,0,LFJounce> }
		object { RightRearWheelAssy translate <0,0,RRJounce> }
		object { RightRearWheelAssy translate <0,11,RRJounce> }
		object { LeftRearWheelAssy translate <0,0,LRJounce> }
		object { LeftRearWheelAssy translate <0,-11,LRJounce> }
	}

#declare CockpitAssy = // origin at firewall floor center
	union {
		difference {
			object { OuterShell translate <24,0,24> }
			object { InnerShell translate <24.5,0,23.5> }
			object { FrontWindowCutout translate <14,26,38> }
			object { FrontWindowCutout translate <14,-26,38> }
//			object { RearWindowCutout translate <34,26,38> }
//			object { RearWindowCutout translate <34,-26,38> }
			object { WindshieldCutout translate <-8,0,39> }
			object { BacklightCutout translate <50,0,40> }
		}
		object { Antenna translate <-9,-22,30> }
//		object { AllGlass translate <24.2,0,23.7> }
	}

#declare InteriorStuff =
  union {
    object { Seat translate <42,16,12> }
    object { Seat translate <42,-16,12> }
    object { RearSeat translate <64,0,12> }
//    object { DomeLight translate <54,0,42> }
    object { InstrumentPod translate <21,16,30> }
    object { InstrumentPod translate <21,0,30> }
    object { InstrumentPod translate <21,-16,30> }
		object { SteeringWheel translate <26,-16,28> }
		object { InteriorRearViewMirror rotate <0,20,-20> translate <16,12,45> }
  } // end union

#declare Body =
	union {
		object { Hood translate <0,0,8+8> }
//		object { Grille translate <-13,0,4+8> }
		object { Grille scale <1,.9,1> translate <-13,0,4+8> } // thinner
		object { InnerFenderRH translate <0,0,8> }
		object { InnerFenderLH translate <0,0,8> }
		object { FrontPanel translate <14,0,8> }
		object { CockpitAssy translate <40,0,8+14> }
//		object { TrunkAssy translate <Wheelbase+10,0,8+8> }
		object { Fenders translate <10,0,5> }
		object { RockerPanelRH translate <20,24,9+8> }
		object { RockerPanelLH translate <20,-24,9+8> }
		object { OldFBumper translate <-23,0,10+8> }
//		object { RBumper translate <0,0,10+8> }
		object { LicensePlate translate <Wheelbase+34,0,19+8> }
		object { ExteriorRearViewMirrorRH translate <34, 22,51> }
		object { ExteriorRearViewMirrorLH translate <34,-22,51> }
	} // end union

#declare BodyAssy =
	union {
		object { Body }
		object { InteriorStuff translate <30,0,8+14> }
		object { Headlamp translate <-7,-19,32+8> }
		object { Headlamp translate <-7,19,32+8> }
		object { Taillamp translate <Wheelbase+22,-RearTread-6,24+8> } //
		object { Taillamp translate <Wheelbase+22,RearTread+6,24+8> } //
		object { DoorHandleRH translate <66,26.5,38+8> }
		object { DoorHandleLH translate <66,-26.5,38+8> }
	} // end union

//===============================================
//       Complete Vehicles
//===============================================

#declare Ford37_StakeTruck =
  union {
    object { BodyAssy translate <0,0,0>}
		object { TruckChassis translate <85,0,28> }
		object { TruckBed translate <85,0,30> }
    object { Wheels }
  } // end union

//===============================================
//             Viewpoint 01 - for testing only
//===============================================

#if (RenderMe = 1)
global_settings {	max_trace_level 150 }
#declare TestSphere = sphere{ 0,12 pigment { color rgb<1,1,1> } }

	camera {
		perspective
		direction <0.0,     1.0,  0.0>
		sky       <0.0,     0.0,  1.0>  // Use right handed-system!
		up        <0.0,     0.0,  1.0>  // Where Z is up
		right     <1.33333, 0.0,  0.0>

		angle 48
		location  <1*Feet, -35*Feet, 5.5*Feet> // overall
		look_at <0*Feet,0*Feet,8*Feet>
//		location  <3*Feet, -1*Feet, 35*Feet> // top down
//		look_at <3*Feet,3*Feet,3*Feet>

	}

background { color rgb <0.276,0.567,0.982>*.97 } // sky blue
light_source
{ <140*Feet,-300*Feet,250*Feet>, 1.2
//  spotlight point_at <0,0*Feet,2*Feet> radius 25 falloff 36
}
light_source
{ <-140*Feet,-200*Feet,130*Feet>, <1.13,1.08,0.83>*.8
//  spotlight point_at <0,0,2*Feet> radius 25 falloff 36
}

plane { z,-0 pigment { checker rgb <1,1,1>, rgb <1,1,1>*.75 } scale 1*Feet }

//#include "GRuler.inc" // for testing only
//object { TestSphere scale 1 translate <0,0,10> }


object { Ford37_StakeTruck scale 1 rotate z*-14 translate <-15*Feet,12*Feet,0> }
object { Ford37_StakeTruck scale 1 rotate z*135 translate <5*Feet,12*Feet,0> }
#end
