
// POV-Ray Object File - Alien Probe
// created 26-Jun-06
// last update 26-Jun-06
// Copyright 2006 Glenn McCarter (glenn@mccarters.net). Some rights reserved.
// This work is licensed under the Creative Commons Attribution License
// To view a copy of this license, visit http://creativecommons.org/licenses/by/2.0/
//
// Required #include files: "GIncludeRH.inc"
//
// Objects:
// AlienProbe
//
//
// Intended scale is English system (inches)
// Uses RH coordinate reference system (Z=up)
//
// This file is intended to be included in another POV-Ray scene file,
// but can be rendered alone.
#ifndef (ThisIsMaster) // If this include file was not called by another, then
	#declare RenderMe = 0; // supress self-rendering of other include files
	#declare ThisIsMaster = 1;
	#include "GIncludeRH.inc"
	// renderable sub includes go here
	#declare RenderMe = 1;
#end

//===============================================
//             Includes
//===============================================

// non-renderable sub includes go here

//===============================================
//             Variables
//===============================================


//===============================================
//             Textures
//===============================================

#declare PAB=100; // Probe Ambient Brightness

#declare ProbeTex =
	texture {
		pigment { color rgb<.004,.005,.04> }
		finish { ambient 0.1 diffuse 0.6 specular 0.4 roughness .02 }
	}
#declare DarkMetalTex =
	texture {
		pigment { color rgb <0.39, 0.41, 0.43>*.2 }
		finish { ambient 0.1 diffuse 0.7 metallic brilliance 6 specular 0.80 roughness .01 }
	}
#declare BrightGrayTex =
	texture {
		pigment { rgb<.89,.89,1.6> }
		finish { ambient 6 diffuse 0 }
	}
#declare AmbientWhiteTex =
	texture {
		pigment { rgb<.71,.71,1> }
		finish { ambient PAB diffuse 0 }
	}
#declare AmbientBlueTex =
	texture {
		pigment { rgb<0.3,0.3,1> }
		finish { ambient PAB diffuse 0 }
	}
#declare AmbientPurpleTex =
	texture {
		pigment { rgb<.4,0,1> }
		finish { ambient PAB diffuse 0 }
	}
#declare AmbientGreenTex =
	texture {
		pigment { rgb<0,1,0> }
		finish { ambient PAB diffuse 0 }
	}

//===============================================
//             Macros
//===============================================






//===============================================
//             Body Group
//===============================================

//------- Nose Lights -------------
#declare NoseLightGroup =
	union {
		cylinder { <-30,0,0>,<30,0,0>,14 }
		sphere { <0,0,0>,14 translate < 30,0,0> }
		sphere { <0,0,0>,14 translate <-30,0,0> }

		sphere { <0,0,0>,24 scale <.5,1,.7> translate <-20,-7,4> }
		sphere { <-20,-30,4>,5 translate <0,0,0> texture { AmbientWhiteTex } }

		sphere { <28,-14,4>,1.8 texture { AmbientWhiteTex } }
		sphere { <10,-14,-11>,1 scale <1,1,.7> texture { AmbientWhiteTex } }
		sphere { <18,-14,-11>,1 scale <1,1,.7> texture { AmbientBlueTex } }
		sphere { <26,-14,-11>,1.3 scale <1,1,.7> texture { AmbientWhiteTex } }
		texture { ProbeTex }
	} // end union

//------- Body Assembly -------------
#declare ProbeBody =
	union {
		difference {
			sphere { <0,0,0>,8*Feet scale <1,1,.6> }
//			box { <-4,-9*Feet,-9*Feet>,<4,9*Feet,9*Feet> translate <5*Feet,0,0> }
			box { <-9*Feet,-9*Feet,-6>,<9*Feet,9*Feet,6> translate <0,0,-3*Feet> }	
			cylinder { <0,0,-9*Feet>,<0,0,-2*Feet>,3.2*Feet texture { BrightGrayTex } }
		} // end difference
		sphere { <0,0,0>,2.4 scale <1,.2,1> translate <0,-8*Feet,-6> rotate z*-32 texture { AmbientWhiteTex } } // left light
		sphere { <0,0,0>,2.4 scale <1,.2,1> translate <0,-8*Feet,-6> rotate z*-37 texture { AmbientWhiteTex } } // left light
		sphere { <0,0,0>,1.4 scale <1,.2,1> translate <0,-8.0*Feet,-16> rotate z*-12 texture { AmbientBlueTex } } // left light
		sphere { <0,0,0>,1.4 scale <1,.2,1> translate <0,-8.0*Feet,-16> rotate z*-34 texture { AmbientWhiteTex } } // left light
		sphere { <0,0,0>,1.4 scale <1,.2,1> translate <0,-8.0*Feet,-16> rotate z*-48 texture { AmbientBlueTex } } // left light


		difference { // repulsor
		sphere {
			<0,0,0>,7.3*Feet scale <1,1,.6>
			texture {
				pigment {
					radial
					color_map {
						[ 0.04 rgb<0.58,0.58,1.00> ]
						[ 0.18 rgb<0.14,0.14,0.37> ]
						[ 0.40 rgb<0.01,0.01,0.02> ]
					}
					frequency 18
					rotate x*90
				}
				finish { ambient PAB diffuse 0 }
			}
		}
			cylinder { <0,0,-9*Feet>,<0,0,-2*Feet>,3.2*Feet texture { BrightGrayTex } }
		} // end difference
		sphere { <0,0,0>,60 scale <1,1,.6> translate <-3*Feet,-4*Feet,3*Feet> } // antenna pod

		sphere { <0,0,0>,55 scale <.5,1,.5> translate <7*Feet,0*Feet,1*Feet> } // right engine
		#local RD=0;
		#while (RD<360)
			torus {
				10,1
				rotate z*90
				rotate y*RD
				translate <0,-55+0,0>+<7*Feet,0*Feet,1*Feet>
				texture { BrightGrayTex }
			}
			#local RD=RD+80;
		#end

		sphere { <0,0,0>,45 scale <.5,1,.5> translate <5*Feet,0*Feet,3*Feet> } // upper right pod
		texture { ProbeTex }
	} // end union

//------- Antenna Group -------------
#declare AntennaGroup =
	union {
		cylinder { <0,0,0>,<0,0,4*Feet>,3 }
		sphere { <0,0,0>,3 translate <0,0,4*Feet> }
		cone { <0,0,0>,1.2,<0,0,7*Feet>,1.6 translate <-1.2*Feet,-3,0> }
		cylinder { <0,0,0>,<0,0,6.1*Feet>,0.8 translate <0.8*Feet,4,0> }
		cylinder { <0,0,0>,<0,0,6.1*Feet>,1.8 rotate y*14 translate <1.0*Feet,4,0> }
		cone { <0,0,0>,2.6,<0,0,4*Feet>,0.2 translate <-7,23,-6> }
		cylinder { <0,0,0>,<0,0,11.6*Feet>,0.65 translate <-9,-4,0> }

		cylinder { <0,0,0>,<0,0,2*Feet>,4 scale <1,.5,1> translate <-28,-6,0> }
		sphere { <0,0,0>,11 scale <.6,1,.6> translate <-28,-6,2*Feet> }
		texture { ProbeTex }
	} // end union

//------- Articulating Arm -------------
// hangs downward

#declare ToolGroup1 =
	union {
		cylinder { <0,0,0>,<0,0,-12>,2.5 }
		sphere { <0,0,-5>,4 }
		cylinder { <0,0,0>,<0,0,-8>,1.1 rotate x*13 translate <-3,-3,0> }
		difference {
			torus { 2,0.5 scale <1,1,2> }
			cylinder { <0,0,0>,<0,0,-4>,1 }
			translate <0,0,-12>
		} // end difference
		texture { ProbeTex }
	} // end union
#declare LowerArmGroup =
	union {
		object { ToolGroup1 rotate y*30 translate <0,0,0> }
		sphere { // elbow end
			<0,0,17>,2.5
		}
		cone { // lower arm
			<0,0,0>,3.5,<0,0,17>,2.5
			rotate <0,0,0>
		}
		translate <0,0,-17> // origin at elbow
		texture { ProbeTex }
	}
#declare ElbAng=30;
#declare ArticulatingArm = // origin at shoulder joint
	union {
		object { LowerArmGroup rotate <0,0,-12> rotate <0,-ElbAng,0> }
		sphere { // elbow end
			<0,0,0>,2.5

		}
		cylinder { // upper arm
			<2,0,0>,<2,0,18>,1.2
			rotate <0,0,0>
		}
		cylinder { // upper arm
			<-2,0,0>,<-2,0,18>,1.2
			rotate <0,0,0>
		}
		sphere { // shoulder end
			<0,0,18>,3.5
		}
		translate <0,0,-18> // origin at shoulder joint
		texture { ProbeTex }
	}

#declare ArmLight =
	union {
	light_source {
		<0,0,0>,
		color rgb <0.224,0.289,0.543>*10000
		spotlight
			point_at <-4,2,-10>
			radius 3.2
			falloff 10
			tightness 4
		fade_distance 30*Feet
		fade_power 1
		media_interaction on
		media_attenuation on
	}
	sphere { <0,0,0>,0.25 translate <-9,4,-25> texture { pigment{rgb<1,1,1>} finish{ambient 120}} }
	sphere { <0,0,0>,0.13 translate <-17,10,-36> texture { pigment{rgb<1,1,1>} finish{ambient 120}} }
	sphere { <0,0,0>,0.25 translate <-18,16,-49> texture { pigment{rgb<1,1,1>} finish{ambient 120}} }
	} // end union
#declare LowerArmGroup2 =
	union {
		object { ToolGroup1 rotate y*30 translate <0,0,0> }
//		object { ArmLight rotate y*30 translate <0,0,-15> }
//		object { ArmLight translate <-8,0,-15> }
		object { ArmLight translate <7,18,1> }
		sphere { // elbow end
			<0,0,17>,2.5
		}
		cone { // lower arm
			<0,0,0>,3.5,<0,0,17>,2.5
			rotate <0,0,0>
		}
		translate <0,0,-17> // origin at elbow
		texture { ProbeTex }
	}
#declare ElbAng=30;
#declare ArticulatingArm2 = // origin at shoulder joint
	union {
		object { LowerArmGroup2 rotate <0,0,-12> rotate <0,-ElbAng,0> }
		sphere { // elbow end
			<0,0,0>,2.5

		}
		cylinder { // upper arm
			<2,0,0>,<2,0,18>,1.2
			rotate <0,0,0>
		}
		cylinder { // upper arm
			<-2,0,0>,<-2,0,18>,1.2
			rotate <0,0,0>
		}
		sphere { // shoulder end
			<0,0,18>,3.5
		}
		translate <0,0,-18> // origin at shoulder joint
		texture { ProbeTex }
	}


//------- Octopus Arm -------------
// hangs downward
#declare OctoSpline =
	spline {
		natural_spline
		0.00, <  0,-4,-7>,
		0.20, <  0, 0,0>,
		0.40, < -2,-1.1*Feet, -1.6*Feet>,
		0.60, < 24, 2.1*Feet, -3.5*Feet>,
		0.80, <-22, 0.6*Feet, -7.0*Feet>,
		1.00, <  8,-2.1*Feet, -9.0*Feet>
	}
#declare OctopusArm =
	union {
		#local SCMax=30;
		#local SC=0;
		#while (SC<SCMax)
			sphere { <0,0,0>,8 translate OctoSpline(SC/SCMax) }
			#local SC=SC+1;
		#end
		sphere { <0,0,0>,14 translate OctoSpline(1) }
		texture { DarkMetalTex }
	} // end union
#declare OctoSpline2 =
	spline {
		natural_spline
		0.00, <  0,-4,-7>,
		0.20, <  0, 0,0>,
		0.40, < -2,-0.4*Feet, -1.6*Feet>,
		0.60, < 15, 1.1*Feet, -3.5*Feet>,
		0.80, <-10, 1.6*Feet, -7.0*Feet>,
		1.00, <  8,-0.1*Feet, -9.0*Feet>
	}

#declare OctopusArm2 =
	union {
		#local SCMax=20;
		#local SC=0;
		#while (SC<SCMax)
			sphere { <0,0,0>,12 translate OctoSpline2(SC/SCMax) }
			#local SC=SC+1;
		#end
		sphere { <0,0,0>,8 translate OctoSpline2(1) }
		sphere { <0,0,0>,8 translate OctoSpline2(1.05) }
		texture { DarkMetalTex }
	} // end union

#declare RubyLaser =
	union {
	cone { <0,0,0>,0.36,<0,0,-40*Feet>,0.6
		texture {
			pigment { rgb<1,.12,.32> }
			finish { ambient 120 diffuse 0 }
		}
		no_shadow
	}
	sphere { <0,0,0>,2.4
		texture {
			pigment { rgb<1,.32,.32>*2 }
			finish { ambient 120 diffuse 0 }
		}
		translate <0,0,-8*Feet>
		no_shadow
	}
	} // end union

//===============================================
//             Tool Group
//===============================================

#declare ToolHatch =
	union {
		intersection {
			sphere { <0,0,0>,8*Feet scale <1,1,.7> }
			cylinder { <0,0,-6*Feet><0,0,-4*Feet>,3.2*Feet }
		}
		torus { 3.2*Feet,1 rotate x*90 translate <0,0,-52> texture { BrightGrayTex } }
		torus { 3.2*Feet,1 rotate x*90 translate <0,0,-58> texture { BrightGrayTex } }
		texture { ProbeTex }
	} // end union

#declare HLStrut =
	difference {
		cylinder { <0,0,0>,<0,0,4*Feet>,9 scale <1,.2,1> }
		#local WHC=10;
		#while (WHC<4*Feet-8)
			cylinder { <0,-8,0>,<0,8,0>,5 translate <0,0,WHC> }
			#local WHC=WHC+14;
		#end
		texture { DarkMetalTex }
	} // end difference

#declare HatchLeg =
	union {
		object { HLStrut translate <0,0,0*Feet> rotate x*30 }
		object { HLStrut translate <0,0,-4*Feet> rotate x*-30 }
		cylinder { <-5,0,0>,<5,0,0>,2 } // hinge
		cylinder { <0,0,0>,<0,0,4*Feet>,2 texture { DarkMetalTex } } // pullup
		cylinder { <0,0,2*Feet>,<0,0,4*Feet>,2.8 texture { DarkMetalTex } } // pullup
		translate <0,0,3.5*Feet>
	} // end union


#macro ToolSliderGroup(DE) // DE=Downwards Extension
	union {
		object { ToolHatch translate <0,0,0> }
		object { HatchLeg translate <0,-1.0*Feet,-DE> rotate z*0 }
		object { HatchLeg translate <0,-1.0*Feet,-DE> rotate z*120 }
		object { HatchLeg translate <0,-1.0*Feet,-DE> rotate z*240 }
		cylinder { <0,0,0>,<0,0,DE*1.3>,2.5 translate <0,0,-DE> }
		cylinder { <0,0,0>,<0,0,DE*1.3>,0.7 translate <-6,-2,-DE> }
		object { ArticulatingArm scale 1.0 rotate z*-50 translate <0,0,-DE-2> }
		object { ArticulatingArm2 scale 1.5 rotate z*30 translate <-20,-10,-DE-2> }
		object { OctopusArm  scale <0.4,0.4,0.45> rotate z*60 translate <20,0,-DE-2> }
		object { OctopusArm  scale <0.24,0.24,0.5> rotate z*70 translate <10,-8,-DE-2> }
		object { OctopusArm  scale <0.14,0.14,0.4> rotate <20,25,0> translate <-18,-8,-DE-2> }
		object { RubyLaser rotate <0,34,-20> translate <-33,8,-DE-40> }
		object { OctopusArm2  scale <0.4,0.4,0.4> rotate <0,5,-10> translate <-0,8,-DE-2> }
		texture { ProbeTex }
	} // end union
#end


//===============================================
//             Probe Assembly
//===============================================

#declare AlienProbe =
	union {
		object { ProbeBody }
		object { AntennaGroup translate <-3*Feet,-4*Feet,5*Feet+0*Feet> }
		object { NoseLightGroup translate <0,-8*Feet,0> }
		object { ToolSliderGroup(5*Feet) translate <0,0,-5*Feet> }
	} // end union		


//===============================================
//             Mystery Lights
//===============================================

#declare MysteryLights1=
	torus {
		60*Feet,6
		rotate x*90
		texture {
			pigment {
				radial
				color_map {
					[ 0.08 rgb<.03,.03,.3> ]
					[ 0.09 rgbt<0,0,0,1> ]
				}
				frequency 40
				rotate x*90
			}
			finish { ambient PAB diffuse 0 }
		}
	}
#declare MysteryLights2=
	torus {
		100*Feet,3
		rotate x*90
		texture {
			pigment {
				radial
				color_map {
					[ 0.08 rgb<.5,.5,.7> ]
					[ 0.09 rgbt<0,0,0,1> ]
				}
				frequency 120
				rotate x*90
			}
			finish { ambient PAB diffuse 0 }
		}
	}
#declare MysteryLights3=
	difference {
	torus {
		60*Feet,40
		rotate x*90
	}
	torus {
		60*Feet,80
		rotate x*90
		translate <0,0,46>
		texture { pigment { rgbt<0,0,0,1> } }
	}

		texture {
			pigment {
				radial
				color_map {
					[ 0.04 rgb<.03,.03,.3> ]
					[ 0.05 rgbt<0,0,0,1> ]
				}
				frequency 30
				rotate x*90
			}
			finish { ambient PAB diffuse 0 }
		}
	}


//===============================================
//             Viewpoint 01 - for testing only
//===============================================

#if (RenderMe = 1)
global_settings {	max_trace_level 150 }
#declare TestSphere = sphere{ 0,12 pigment { color rgb<1,1,1> } }

	camera {
		perspective
		direction <0.0,     1.0,  0.0>
		sky       <0.0,     0.0,  1.0>  // Use right handed-system!
		up        <0.0,     0.0,  1.0>  // Where Z is up
		right     <1.33333, 0.0,  0.0>

		angle 48
		location  <1*Feet, -35*Feet, 5.5*Feet> // overall
		look_at <0*Feet,0*Feet,12*Feet>

	}

background { color rgb <0.376,0.567,0.682>*.47 }
light_source
{ <140*Feet,-300*Feet,250*Feet>, 1.2
//  spotlight point_at <0,0*Feet,2*Feet> radius 25 falloff 36
}
light_source
{ <-140*Feet,-200*Feet,130*Feet>, <1.13,1.08,0.83>*.8
//  spotlight point_at <0,0,2*Feet> radius 25 falloff 36
}

plane { z,-0 pigment { checker rgb <1,1,1>, rgb <1,1,1>*.75 } scale 1*Feet }

//#include "GRuler.inc" // for testing only
//object { TestSphere scale 1 translate <0,0,10> }

object { AlienProbe scale 1 rotate z*10 translate <0*Feet,22*Feet,20*Feet> }
object { MysteryLights3 translate <0,200*Feet,100*Feet> }
//object { MysteryLights2 translate <0,200*Feet,110*Feet> }
#end

