
// Glenn's POV-Ray Scene File - "Night Train"
// created 26-May-06
// last update 26-May-06
//
// Copyright 2006 Glenn McCarter (glenn@mccarters.net). Some rights reserved.
// This work is licensed under the Creative Commons Attribution License. 
// To view a copy of this license, visit http://creativecommons.org/licenses/by/2.0/ 
// You are free:
// - to copy, distribute, display, and perform the work
// - to make derivative works
// - to make commercial use of the work
// Under the following conditions:
// - Attribution. You must give the original author credit.
// - For any reuse or distribution, you must make clear to others the license terms of this work.
// - Any of these conditions can be waived if you get permission from the copyright holder.
// Your fair use and other rights are in no way affected by the above. 
//
//
// This is the main scene file.
//
//
// Scene uses RH coordinate system, Z = up.
// Scene origin in the center of the room on the floor
// with +X towards the right, and +Y heading away from the camera.


//===============================================
//             Scene Switches
//===============================================

// Keep these at 0:
#declare RenderMe = 0; // supresses self-rendering of the include files, leave at 0
#declare Radiosty = 0; // 0=off, 1=quick, 2=best radiosity
#declare FocalBlur = 0; // 0=off, 1=focal blur
#declare DoFog = 0; // 0=no fog, 1=fog
#declare DoSun = 0;
#declare AreaSun = 0; // 0=normal light, 1=area light for the sun


// Keep these at 1;
#declare ThisIsMaster = 1; // declares this the Master File, leave at 1
#declare DoAtmos      = 1; // 0=no atmosphere, 1=atmosphere media
#declare DoMainLight  = 1;
#declare AreaMain     = 1; // 0=normal light, 1=area light for main light
#declare DoFillLights = 1;
#declare DoTrain      = 1;
#declare DoSmoker     = 1;


#declare My_Cam = 1;
// 1=	Render_Cam
// 8=	Special_Cam

//===============================================
//             Global Settings
//===============================================

#version 3.5;
global_settings {
	adc_bailout 1/255 // default 1/255
//	ambient_light <1.0,1.0,1.0> // default <1,1,1>, use 0 for radiosity
//	ambient_light <0.5,0.5,0.5>
//	ambient_light <0.1,0.1,0.1>
	ambient_light <0.05,0.05,0.05>
//	ambient_light <0.01,0.01,0.01>
//	ambient_light <0.003,0.003,0.003> // test
//	ambient_light <0.0,0.0,0.0> // this is most realistic with radiosity on
//	ambient_light <-0.1,-0.1,-0.1> //
//	ambient_light <-1.1,-1.1,-1.1> // wierd
	assumed_gamma 1.0
	hf_gray_16 off
	irid_wavelength <0.25,0.18,0.14>
	max_intersections 64
	max_trace_level 20
	number_of_waves 10
	noise_generator 2

#switch (Radiosty)
#case (1)
	ambient_light <0.0,0.0,0.0> // this is most realistic with radiosity on
// QUICK TEST
  radiosity{
    adc_bailout 0.01/0.02// CHANGE - use adc_bailout = 0.01 / brightest_ambient_object
		always_sample on     // CHANGE - default on, use off to reduce blotchiness
		brightness 0.5       // CHANGE - default 1.0 for full effect, 0.0 = no radiosity
    count 20             // CHANGE - default 35, 2 is too low, typ 20 to 150, max 1600 rays sent out
    error_bound 1.0      // CHANGE - default 1.8, typ 1 to 3, hi = flat shadows, low = deep shadows
    gray_threshold 0.2   // CHANGE - 0.0 = unrealistically full color bleed, 1.0 = no color bleed
    low_error_factor .6  // leave this, default 0.5
		max_sample -1        // leave this negative unless you have a very bright object causing splotchiness
		media off            // default off, turn on if using media in scene
    minimum_reuse 0.015  // leave this, default 0.015
    nearest_count 5      // CHANGE - default 5, below 4 gets patchy, typ 3 to 10, max 20
		normal off           // default off, turn on for shadow areas to show bumps
    pretrace_start 0.08  // CHANGE - default 0.08, percent of final image size in first mosaic
    pretrace_end   0.04  // CHANGE - default 0.04, percent of final image size in last mosaic
    recursion_limit 3    // CHANGE - default 3, 1 or 2 is often sufficient
  }
#break
#case (2)
// FINAL RENDER
	ambient_light <0.0,0.0,0.0> // this is most realistic with radiosity on
  radiosity{
    adc_bailout 0.01/0.02// CHANGE - use adc_bailout = 0.01 / brightest_ambient_object
		always_sample on     // CHANGE - default on, use off to reduce blotchiness
		brightness 1.0       // CHANGE - default 1.0 for full effect, 0.0 = no radiosity
    count 30             // CHANGE - default 35, 2 is too low, typ 20 to 150, max 1600 rays sent out
    error_bound 1.0      // CHANGE - default 1.8, typ 1 to 3, hi = flat shadows, low = deep shadows
    gray_threshold 0.2   // CHANGE - 0.0 = unrealistically full color bleed, 1.0 = no color bleed
    low_error_factor .5  // leave this, default 0.5
		max_sample -1        // leave this negative unless you have a very bright object causing splotchiness
		media off            // default off, turn on if using media in scene
    minimum_reuse 0.015  // leave this, default 0.015
    nearest_count 8      // CHANGE - default 5, below 4 gets patchy, typ 3 to 10, max 20
		normal off           // default off, turn on for shadow areas to show bumps
    pretrace_start 0.02  // CHANGE - default 0.08, percent of final image size in first mosaic
    pretrace_end   0.004  // CHANGE - default 0.04, percent of final image size in last mosaic
    recursion_limit 7    // CHANGE - default 3, 1 or 2 is often sufficient
  }
   // end radiosity section
#break
#else
#end
}

//===============================================
//             Includes
//===============================================

#include "GIncludeRH.inc" // Glenn's standard includes
//#include "GRuler.inc" // for testing only
#include "RailroadTrack.inc"
#include "AlienProbe.inc"
#if (DoTrain=1)
	#include "Train-PassengerCar.inc"
	#include "SignalTower.inc"
	#include "37Ford_StakeTruck.inc"
#end

#if (DoSmoker=1)
	#include "Smoker.inc"
#end

//===============================================
//             Variables
//===============================================

//#declare CamPos = <460*Feet,900*Feet,7*Feet>; // Camera Position


//===============================================
//             Cameras
//===============================================

#declare Render_Cam =
	camera {
		perspective
		direction <0.0,     1.0,  0.0>
		sky       <0.0,     0.0,  1.0>  // Use right handed-system
		up        <0.0,     0.0,  1.0>  // Where Z is up
		right     <4/3, 0.0,  0.0>  // aspect ratio
//		right     <4/4, 0.0,  0.0>  // aspect ratio
//		right     <9/16, 0.0,  0.0>  // aspect ratio
		angle 45
	location <14*Feet,-26*Feet,5*Feet>
//	look_at <7*Feet,0*Feet,6*Feet>
	look_at <8*Feet,0*Feet,6*Feet> // slightly more right
#if (FocalBlur = 1)
		blur_samples 100 // 100 is ok
		confidence 0.9   // this is a probability
		variance 1/1000  // 1/10000 is pretty good
		aperture 0.6    //lower value = wider range in focus, 10 is very blurry
		focal_point <0,0,1.3+TTH>
	 // end focal blur
#end
}

#declare Special_Cam =
	camera {
		perspective
		direction <0.0,     1.0,  0.0>
		sky       <0.0,     0.0,  1.0>  // Use right handed-system
		up        <0.0,     0.0,  1.0>  // Where Z is up
//		right     <16/9,     0.0,  0.0>
		right     <4/3,     0.0,  0.0>
//	angle 55
//	location <26*Feet,20*Feet,660*Feet> // sky view
//	look_at <26*Feet,120*Feet,5*Feet>
	angle 55
	location <36*Feet,110*Feet,8*Feet> // far view
	look_at <26*Feet,200*Feet,5*Feet>
//	angle 55
//	location <160*Feet,140*Feet,16*Feet> // far right tower view
//	look_at <26*Feet,160*Feet,5*Feet>
//	angle 45
//	location <16*Feet,-26*Feet,36*Feet> // slightly above
//	look_at <0*Feet,60*Feet,5*Feet>
//	angle 45
//	location <2*Feet,-36*Feet,5*Feet> // train track
//	look_at <-2*Feet,-8*Feet,2*Feet>
//	location <8*Feet,-16*Feet,5*Feet> // truck
//	look_at <-2*Feet,-12*Feet,2*Feet>
//	angle 45
//	location <18*Feet,-3*Feet,5*Feet> // smoker overall
//	look_at <70,20,3*Feet>
	}

camera {
#switch (My_Cam)
#case (1) Render_Cam
#break
#else Special_Cam
#end
}

//===============================================
//             Textures
//===============================================

#declare TowerTex =
	texture {
		pigment { color rgb<.54,.61,.68>*.44 }
		normal { bumps 0.3 scale 4 }
		finish { ambient 0.005 diffuse 0.8 specular 0.16 roughness .38 }
	}

#declare ConcreteTex =
	texture {
		pigment { color rgb<.54,.61,.68>*.14 }
		normal { granite 0.4 scale 1.4 }
		finish { diffuse 0.6 specular 0.06 roughness .38 }
	}


//===============================================
//             Lighting
//===============================================

#declare Sun =
	light_source {
		<0,0,0>
		color rgb <0.684,0.639,0.543>*2.3
		#if (AreaSun=1)
			area_light <0,0,0.5*Miles>,<0,0.5*Miles,0>,4,4 adaptive 1 jitter circular orient
		#end
	}
#if (DoSun=1)
object { Sun
	translate <0,0,.5*Miles> // noon at Equator: directly overhead
	rotate y*38 // towards right
  rotate z*-32// behind camera
}
#end

#declare MainSpot =
	union {
	light_source {
		<0,0,0>
		color rgb <0.684,0.639,0.543>*30
		fade_distance 30*Feet
		fade_power 1
		media_interaction on
		media_attenuation on
		#if (AreaMain=1)
			area_light <1.5,0,0>,<0,0,1.5>,3,3 jitter
		#end
		looks_like {
			union {
				sphere { <0,0,0>,6 texture { pigment {rgb<1,1,1>} finish{ambient 100 }}}
				cylinder { <0,0,-40*Feet>,<0,0,26>,4 translate <0,30,0> texture { pigment { rgb<.24,.22,.12>*0.3} } }
			} // end union
		}
	}
//	cylinder { <0,0,0.1>,<0,0,10>,5 texture { pigment {rgb<.1,.1,.1>}} rotate x*4} 
//	cylinder { <0,0,0.1>,<0,0,10>,5 texture { pigment {rgb<.1,.1,.1>}} rotate x*-90} 
	} // end union
#if (DoMainLight=1)
object { MainSpot translate <18*Feet,180*Feet,16*Feet> }
#end

#declare ShadowBox =
	sphere {
		<0,0,0>,3
		texture {
			pigment {
				bozo
				color_map {
					[ 0.01 rgb<1,1,1> ]
					[ 0.02 rgb<1,1,1> ]
				}
				scale 3
			}
			finish{ambient 100 }
		}
	}
object { ShadowBox translate <18*Feet-1,177*Feet,16*Feet> }

#declare FrontFillSpot =
	light_source {
		<0,0,0>
		color rgb <0.684,0.639,0.543>*7.5
		spotlight
			point_at <-80,-50,-0>
			radius 20
			falloff 53
		fade_distance 3*Feet
		fade_power 1
		media_interaction off
		media_attenuation off
		looks_like {
			sphere { <0,0,0>,6 texture { pigment {rgb<1,1,1>} finish{ambient 100 }}}
		}
	}


#declare TowerSpot =
	light_source {
		<0,0,0>
		color rgb <0.684,0.639,0.543>*22
		spotlight
			point_at <-80,-50,50>
			radius 20
			falloff 60
			tightness 10
		fade_distance 3*Feet
		fade_power 1
		media_interaction off
		media_attenuation off
		looks_like {
			sphere { <0,0,0>,6 texture { pigment {rgb<1,1,1>} finish{ambient 100 }}}
		}
	}


#declare FarSpot =
	union {
	light_source {
		<0,0,0>
		color rgb <0.684,0.639,0.243>*38
		spotlight
			point_at <-80,0,-50>
			radius 20
			falloff 70
		fade_distance 30*Feet
		fade_power 1
		media_interaction off
		media_attenuation off
		looks_like {
			sphere { <0,0,0>,6 texture { pigment {rgb<1,1,.5>} finish{ambient 400 }}}
		}
	}
	} // end union
#if (DoFillLights=1)
object { FrontFillSpot translate <36*Feet,100*Feet,16*Feet> }
object { TowerSpot translate <50*Feet,170*Feet,16*Feet> }
object { FarSpot translate <30*Feet,300*Feet,16*Feet> }
#end

#if ( DoFog )

fog {
	fog_type 1 // constant fog
	distance 100*Feet // 
//	distance 500*Feet // deep mist, fairly foggy
//	distance 100000*Feet // fine mist
//	color rgbt<.071,.077,.077,0.5>
//	color rgb<.1,.1,.1> // dull foggy grey 
	color rgb<.1,.1,.1> // dull grey 
//	color rgb<-.1,-.1,-.1> // black
}
#end

#if (DoAtmos)
media {
//	intervals 10 // good but slow (1hr @800x600A3)
//	samples 30,30
//	intervals 1 // very fast (4m @800x600A3) but banded
//	samples 50
	intervals 1 // fast (9m @800x600A3), fine quality 
//	samples 150 // 23 minutes, some jaggy artifacts
	samples 300 //
//	scattering {2, rgb<.00000005,.00000005,.00000005> extinction 0.00005} // no effect
//	scattering {3, rgb<.0000005,.0000005,.0000005> extinction 1.0} // grey sky, justa few rays
//	scattering {3, rgb<.0000005,.0000005,.0000005> extinction 0.1} // test, no rays, too thin
//	scattering {3, rgb<.000005,.000005,.000005> extinction 1.0} // excellent fogginess
		scattering {3, rgb<.00002,.00002,.00002> extinction 1.0} // thicker fog
//	scattering {2, rgb<.0005,.0005,.0005> extinction 1.0}
//	absorption rgb<0.0020,0.0020,0.0020> // severely darkens whole scene
		absorption rgb<0.0010,0.0010,0.0010> // good with thick fog
//	absorption rgb<0.0008,0.0008,0.0008> // good slight overall darkening
//	absorption rgb<0.0002,0.0002,0.0002> // no effect? 
//	absorption rgb<0.00002,0.00002,0.00002> // no effect?
}
#end

#declare MediaSphere =
	sphere { // media sphere
		<0,0,0>,300*Feet
		hollow
		texture { pigment {rgb<.61,.64,.76>} finish {ambient 100 diffuse 0 } }
	}

#if (DoSun !=1)
	object { MediaSphere translate <0,160*Feet,0>} // this is critical to get atmospheric effects in the sky!
#end

//===============================================
//             Environment
//===============================================

//background { color rgb <0.0046, 0.0045, 0.0053> } // deep deep grey
background { color rgb <0.00016, 0.00018, 0.00028> } // deep blue grey
//background { color rgb <0.000, 0.000, 0.000> } // black

#declare GroundPlane =
//	plane { z,-0.1 pigment { checker rgb 1, rgb .75 } scale 10*Feet }
//	plane { -z,-0.1
		box { <-200*Feet,-200*Feet,-1>,<100*Feet,1000*Feet,0>
//	hollow
		texture {
			pigment {
				image_map { // projected from -Z, with top left at <0,1,0>
					png "CrackedPavementS2.png"
				}
				scale 50*Feet
				rotate z*90
				translate <8*Feet,6*Feet+8,0>
			}
			finish { ambient 0.1 diffuse 0.1 specular 0.02 roughness 0.34 }
		}
	}

object { GroundPlane translate <0,0,-0.2> }

#declare GroundTex =
		texture {
			pigment {
				image_map { // projected from -Z, with top left at <0,1,0>
					png "CrackedPavementS2.png"
				}
				scale <0.2,0.2/3,0.2>
//				rotate z*90
				translate <8*Feet,6*Feet+8,0>
			}
//			normal { bumps 0.2 scale 3 }
			finish { ambient 0.1 diffuse 0.1 specular 0.02 roughness 0.34 }
		}
#declare WetGroundTex = // test
		texture {
			pigment { rgb<.18,.13,.02> }
			normal { bumps 0.15 scale 6 }
			finish { specular 0.8 roughness 0.05 reflection 0.24  }
		}
#declare LocalGroundTex =
	texture {
		material_map {
			png "PavementMap.png" // 2-color image map
			texture { GroundTex }
			texture { WetGroundTex translate <0,0,1> }
		}
		scale <30*Feet,90*Feet,1>
	} 

#declare LocalGround =
	box { <-20*Feet,0,-1>,<34*Feet,300*Feet,0>
		texture { LocalGroundTex }
	}
object { LocalGround translate <0,-20*Feet,0> }

#declare FillerGround =
	box { <0,0,-1>,<18,120*Feet,0>
		texture {
			gradient x
			texture_map {
				[ 0.1 RRGravelTex ]
				[ 0.9 LocalGroundTex scale <1,1/3,1> ]
			}
			scale <18,1,1>
		}
	}
object { FillerGround translate <26,-20*Feet,1> }

//===============================================
//             Object Groups
//===============================================

//sphere { <0,0,50*Feet>,30*Feet texture { SteelTex } } // for testing shadows

//---------------- Objects ----------------------


#declare Train =
	union {
		object { PassengerCar }
		object { PassengerCar translate <0,64*Feet*1,0> }
		object { PassengerCar rotate z*-2 translate <3,64*Feet*2,0> }
		object { PassengerCarS rotate z*-4 translate <30,64*Feet*3,0> }
		object { PassengerCarS rotate z*-7 translate <80,64*Feet*4,0> }
		object { PassengerCarS rotate z*-12 translate <180,64*Feet*5-4,0> }
	} // end union

#declare WaterTowerTank =
	union {
		cylinder { <0,0,0>,<0,0,15*Feet>,8*Feet }
		cone { <0,0,15*Feet>,9.2*Feet,<0,0,20*Feet>,2 } // top
		cone { <0,0,0>,8*Feet,<0,0,-3*Feet>,8 } // tank bottom
		cylinder { <0,0,-30*Feet>,<0,0,0>,4 } // inflow pipe
	} // end union
#declare WaterTowerLeg =
	union {
		box { <-10,-10,0>,<10,10,24*Feet> }
		box { <0,-6,-6>,<22*Feet,6,6> rotate <0,-45,0> translate <0,0,6*Feet> }
		box { <0,-6,-6>,<22*Feet,6,6> rotate <0,-45,90> translate <0,0,6*Feet> }
	} // end union
#declare WaterTowerLegGroup =
	union {
		object { WaterTowerLeg rotate z*0 translate <-8*Feet,-8*Feet,0> }
		object { WaterTowerLeg rotate z*90 translate <8*Feet,-8*Feet,0> }
		object { WaterTowerLeg rotate z*180 translate < 8*Feet, 8*Feet,0> }
		object { WaterTowerLeg rotate z*270 translate <-8*Feet,8*Feet,0> }
		scale <0.8,0.8,1>
	} // end union
#declare WaterTower =
	union {
		object { WaterTowerTank translate <0,0,20*Feet> }
		object { WaterTowerLegGroup translate <0,0,0> }
/*
		object { WaterTowerLeg rotate z*0 translate <-8*Feet,-8*Feet,0> }
		object { WaterTowerLeg rotate z*90 translate <8*Feet,-8*Feet,0> }
		object { WaterTowerLeg rotate z*180 translate < 8*Feet, 8*Feet,0> }
		object { WaterTowerLeg rotate z*270 translate <-8*Feet,8*Feet,0> }
*/
		box { <-8*Feet,-8*Feet,20*Feet-10>,<8*Feet,8*Feet,20*Feet> }
		texture { TowerTex }
	} // end union

#macro Crate(CL,CW,CH,RW,RD)
	union {
		box { <RD,RD,RD>,<CL-RD,CW-RD,CH-RD> }

		box { <0,0,0>,<CL,RW,RW> translate <0,0,0> }
		box { <0,0,0>,<CL,RW,RW> translate <0,0,CH-RW> }
		box { <0,0,0>,<CL,RW,RW> translate <0,CW-RW,0> }
		box { <0,0,0>,<CL,RW,RW> translate <0,CW-RW,CH-RW> }

		box { <0.01,0.01,0.01>,<RW,RW,CH-0.01> }
		box { <0.01,0.01,0.01>,<RW,RW,CH-0.01> translate <0,CW-RW,0> }
		box { <0.01,0.01,0.01>,<RW,RW,CH-0.01> translate <CL-RW,0,0> }
		box { <0.01,0.01,0.01>,<RW,RW,CH-0.01> translate <CL-RW,CW-RW,0> }

		box { <0.02,0.02,0.02>,<RW,CW,RW> }
		box { <0.02,0.02,0.02>,<RW,CW,RW> translate <0,0,CH-RW> }
		box { <0.02,0.02,0.02>,<RW,CW,RW> translate <CL-RW,0,0> }
		box { <0.02,0.02,0.02>,<RW,CW,RW> translate <CL-RW,0,CH-RW> }

		texture { pigment {rgb<.45,.40,.22>*0.3} finish {specular 0.3 roughness 0.2 }}
	} // end union
#end

#declare Timber =
	box { <0,-10*Feet,0>,<8,0,7>
//		texture { pigment {rgb<.45,.40,.35>*0.3} finish {specular 0.1 roughness 0.3 }}
		texture {
			pigment {
				wood
				color_map {
				[ 0.00 rgb<.45,.40,.35>*0.03 ]
				[ 0.05 rgb<.45,.40,.35>*0.20 ]
				[ 0.50 rgb<.45,.42,.39>*0.30 ]
				}
				rotate x*90
				scale 0.3
				turbulence 0.2
			}
			finish {specular 0.1 roughness 0.3 }
		}
	}

#declare BuildingFirstFloor =
	union {
		box { <-20,-20,0>,<20,20,10*Feet> translate <10,10,0> } // pillar
		box { <-20,-20,0>,<20,20,10*Feet> translate <20*Feet-10,10,0> } // pillar
		box { <0,0,0>,<20*Feet,4,40> } // base wall
		box { <0,0,7.0*Feet>,<20*Feet,4,10*Feet> } // upper wall
		box { <0,-10,10*Feet-6>,<20*Feet,20*Feet,10*Feet> } // roof
		box { <0,0,0>,<4,20*Feet,10*Feet> } // end wall
		box { <20*Feet-4,0,0>,<20*Feet,20*Feet,10*Feet> } // end wall
		box { <10,2,40>,<20*Feet-10,3,7*Feet> texture { pigment { rgb<0.01,0.01,0.01>} } } // glass
		texture { ConcreteTex }
	} // end union

#declare Building =
	union {
		object { BuildingFirstFloor }
		object { BuildingFirstFloor translate <20*Feet+20,0,0> }
		object { BuildingFirstFloor translate <0,0,10*Feet>}
		object { BuildingFirstFloor translate <20*Feet+20,0,10*Feet> }
	} // end union

//===============================================
//             Object Placement
//===============================================

/*
light_group {
#if (AreaSun =1)
	object { FillLight }
#end

global_lights on
} // light group
*/

object { StraightRailroad(120*Feet,1) translate <-36,-24*Feet,3> }
object { StraightRailroad(200*Feet,0) rotate z*-2.5 translate <-36,-24*Feet+120*Feet,3> }
object { StraightRailroad(300*Feet,0) rotate z*-10 translate <-36,210*Feet,3> }
object { Building rotate z*-80 translate <36*Feet,250*Feet,0> }
object { AlienProbe scale 2 rotate z*6 translate <14.5*Feet,140*Feet,40*Feet> }
object { MysteryLights3 translate <16*Feet,140*Feet,70*Feet> }

#if (DoTrain=1)
object { Train translate <-36,-10*Feet,4.4+3> }

object { SignalTower translate <56,39*Feet,0> }
object { Ford37_StakeTruck rotate z*220 translate <29*Feet,100*Feet,0> }
#end                                            

#if (DoSmoker=1)
object { Smoker rotate y*-12 rotate z*140 translate <40+30,0,5*Feet-3> }
object { Crate(24,24,15.4,3,0.5) rotate z*0 translate <36+33,-12,0> }
object { Timber rotate z*6 translate <25+30,4,0> }


#end

// Extras, ignore these
//object { WaterTower rotate z*-6 translate <12*Feet,140*Feet,0> }
//object { WaterTower rotate z*-9 translate <13*Feet,140*Feet,0> }
//object { SignalTower translate <53,39*Feet,0> }
//object { MysteryLights2 translate <16*Feet,140*Feet,77*Feet> }


