
// POV-Ray Object File - Railroad Tracks
// created 20-Jun-06
// last update 23-Jun-06
// 2004 Glenn McCarter  ( glenn@mccarters.net )
//
// Required #include files: "GIncludeRH.inc"
//
// Objects:
// RailroadTrack // standard US gauge 4"-8.5"
//
//
// Intended scale is English system (inches)
// Uses RH coordinate reference system (Z=up)
//

#ifndef (ThisIsMaster) // If this include file was not called by another, then
	#declare RenderMe = 0; // supress self-rendering of other include files
	#declare ThisIsMaster = 1;
	#include "GIncludeRH.inc"
	#include "shapes.inc"
	// renderable sub includes go here
	#declare RenderMe = 1;
#end

//===============================================
//             Includes
//===============================================

// non-renderable sub includes go here

//===============================================
//             Variables
//===============================================


//===============================================
//             Textures
//===============================================

#declare RailTopTex =
	texture {
		pigment { color rgb<0.835,0.892,0.987>*0.66 }
		finish { specular 0.78 roughness 0.03 brilliance 3 reflection 0.46 }
	}
#declare RailTex =
	texture {
		pigment { color rgb<0.835,0.832,0.737>*0.26 }
		finish { specular 0.1 roughness 0.12 }
	}
#declare RailroadTieTex =
	texture {
		pigment { color rgb<0.845,0.732,0.587>*0.36 }
	}
#declare RRGravelTex =
	texture {
		pigment {
			granite
			color_map {
				[ 0.2 rgb<0.835,0.692,0.647>*0.06 ]
				[ 0.5 rgb<0.835,0.692,0.617>*0.36 ]
				[ 0.8 rgb<0.835,0.692,0.617>*0.26 ]
			}
		}
	}

//===============================================
//             Macros
//===============================================


//===============================================
//             Objects
//===============================================

#macro StraightRail(Length)
	union {
		box { <-0.2,0,0>,<0.2,Length,4> } // web
		box { <-2,0,0>,<2,Length,0.5> } // bottom flange
		box { <0,0,-1>,<2.4,Length,0> rotate y*-20 translate <-2,0,0.5> }
		box { <0,0,-1>,<-2.4,Length,0> rotate y*20 translate <2,0,0.5> }
		cylinder { <0,0,0>,<0,Length,0>,1 scale <1,1,0.7> translate <0,0,4> } // top
		cylinder { <0,0,0>,<0,Length,0>,1 scale <.9,.9,0.7> translate <0,0,4.2> texture { RailTopTex } } // shiny top
		texture { RailTex }
	} // end union
#end

#declare RailroadTieS = // simple version
	box {
		<-8.5*Feet/2,0,-7>,<8.5*Feet/2,9,0>
		texture { RailroadTieTex }
	}
#declare RailroadTieAssy =
	union {
		superellipsoid { <.03,.1> scale <8.5*Feet/2,9/2,7/2> translate <0,4.5,-3.5> }
		box { <2*Feet,0.5,0>,<34.5,8,0.65> } // plate
		box { <-0.4,-0.4,-1>,<0.4,0.4,1.8> translate <32,5.5,0> } // spike
		sphere { <0,0,0>,0.8 scale <1,1,.34> translate <32,5.5,1.8> } // spike head
		texture { RailroadTieTex }
	} // end union

#macro StraightRailroad(Length,BestQuality)
	union {
	object { StraightRail(Length) translate <-(4*Feet+8.5*Inches)/2-1,0,0> }
	object { StraightRail(Length) translate < (4*Feet+8.5*Inches)/2+1,0,0> }
	#local TCT=0;
	#if (BestQuality=1)
		#while (TCT<Length)
			object { RailroadTieAssy translate <0,TCT,0> }
			#local TCT=TCT+24;
		#end
	#else
		#while (TCT<Length)
			object { RailroadTieS translate <0,TCT,0> }
			#local TCT=TCT+24;
		#end
	#end
	cylinder { // simple gravel
		<0,0,0>,<0,Length,0>,5*Feet
		scale <1,1,0.06>
		translate <0,0,-.3*Feet>
		texture { RRGravelTex }
	}
	} // end union
#end

//===============================================
//             For Testing Only
//===============================================

#if (RenderMe = 1)

	camera {
		perspective
		direction <0.0,     1.0,  0.0>
		sky       <0.0,     0.0,  1.0>  // Use right handed-system!
		up        <0.0,     0.0,  1.0>  // Where Z is up
		right     <1.33333, 0.0,  0.0>
		angle 30
		location  <4*Feet, -16*Feet, 5*Feet> // overall
		look_at <0*Feet,0,3*Feet>
	}


light_source
{ <40*Feet,-35*Feet,50*Feet>, 2.4
  spotlight point_at <0,0*Feet,2*Feet> radius 25 falloff 36
}
light_source
{ <-20*Feet,120*Feet,30*Feet>, <1.13,1.08,0.83>*.8
  spotlight point_at <0,0,2*Feet> radius 25 falloff 36
}
plane { z,-0 pigment { checker rgb 1, rgb .75 } scale 1*Feet }

//object { StraightRail(100*Feet) }
//object { RailroadTieS translate <0,0,4> }
object { StraightRailroad(300*Feet,1) translate <-3*Feet,0,4> }

#end
