
// POV-Ray Object File - Railway Signal
// created 19-Jun-06
// last update 19-Jun-06
// Copyright 2006 Glenn McCarter (glenn@mccarters.net). Some rights reserved.
// This work is licensed under the Creative Commons Attribution License
// To view a copy of this license, visit http://creativecommons.org/licenses/by/2.0/
//
// Required #include files: "GIncludeRH.inc"
//
// Objects:
// SignalTower
//
//
// Intended scale is English system (inches)
// Uses RH coordinate reference system (Z=up)
//
// This file is intended to be included in another POV-Ray scene file,
// but can be rendered alone.
#ifndef (ThisIsMaster) // If this include file was not called by another, then
	#declare RenderMe = 0; // supress self-rendering of other include files
	#declare ThisIsMaster = 1;
	#include "GIncludeRH.inc"
	// renderable sub includes go here
	#declare RenderMe = 1;
#end

//===============================================
//             Includes
//===============================================

// non-renderable sub includes go here

//===============================================
//             Variables
//===============================================


//===============================================
//             Textures
//===============================================

#declare SilverPaintTex =
	texture {
		pigment { color rgb<.875,.858,.987>*1.92 }
		finish { specular 0.99 roughness .005 metallic 0.3 brilliance 8 }
	}
#declare SilverPaintTexB =
	texture {
		pigment { color rgb<.875,.858,.987>*1.92 }
		normal { bumps 0.1 scale 8 }
		finish { specular 0.99 roughness .005 metallic 0.3 brilliance 8 }
	}

#declare BlackPaintTex =
	texture {
		pigment { color rgb<.01,.01,.01> }
	}

#declare RedLightTex =
	texture {
		pigment {rgb<1,0.03,0.01>*1}
		finish { ambient 20 }
	}

#declare RedBladeTex =
	texture {
		pigment { rgb<0.8,0.04,0.03>}
	}

#declare SWhiteTex =
	texture {
		pigment { color rgb<1,1,1> }
		finish { ambient 1 }
	}


//===============================================
//             Macros
//===============================================



//===============================================
//             Objects
//===============================================

#macro SPole(Height)
	union {
		cylinder { <0,0,0>,<0,0,Height>,3 texture { SilverPaintTex } }
		superellipsoid {
			<0.2,0.2>
			scale <24/2,24/2,6/2>
		}
		superellipsoid {
			<0.1,0.1>
			scale <18/2,18/2,36/2>
			translate <0,0,16>
		}
		superellipsoid {
			<0.1,0.1>
			scale <16/2,16/2,30/2>
			translate <0,0,16+30>
		}
		cylinder { <0,0,0>,<0,0,3>,6 translate <0,0,48> }
		cylinder { <0,0,0>,<0,0,10>,4 translate <0,0,48> }
		cylinder { <0,0,Height>,<0,0,Height+2>,2 }
		cone { <0,0,Height+2>,3.3,<0,0,Height+17>,0.4 }
		texture { SilverPaintTexB }
	} // end union
#end

#macro SLadder(Height)
	union {
		cylinder { <0,0,0>,<0,0,Height>,0.6 translate < 7,0,0> }
		cylinder { <0,0,0>,<0,0,Height>,0.6 translate <-7,0,0> }
		#declare RC=12;
		#while (RC<Height)
			cylinder { <-7,0,0>,<7,0,0>,0.47 translate <0,0,RC> }
			#declare RC=RC+12;
		#end
		texture { SilverPaintTex }
	} // end union
#end

#declare NumberPlaque =
	union {
		box { <-11,0,0>,<11,1,8> texture { BlackPaintTex } }
		box { <-2,1,-2>,<2,6,10> texture { BlackPaintTex } }
		text { // runs along +x, faces -z
			ttf "Arial.ttf"
			"ES 692"
			0.1,x*0.1
			scale 5
			rotate <90,0,0>
			translate <-9,-0.1,2>
			texture { SWhiteTex }
		}
	} // end union

#declare SPlatform =
	union {
		object { RoundedHalfBox2(24,18,3,2) }
		cylinder { <0,0,0>,<0,0,24>,0.4 translate <2,2,0> }
		cylinder { <0,0,0>,<0,0,24>,0.4 translate <24-2,2,0> }
		cylinder { <0,0,0>,<0,0,24>,0.4 translate <2,18-2,0> }
		cylinder { <0,0,0>,<0,0,24>,0.4 translate <24-2,18-2,0> }

		cylinder { <0,0,0>,<24-4,0,0>,0.4 translate <2,2,24> }
		cylinder { <0,0,0>,<0,18-4,0>,0.4 translate <2,2,24> }
		cylinder { <0,0,0>,<0,18-4,0>,0.4 translate <24-2,2,24> }
		texture { SilverPaintTexB }
	} // end union

#declare DoubleLight =
	union {
		sphere { // light
			<0,0,0>,3.9
			scale <1,0.1,1>
			translate <0,0,10>
			texture { RedLightTex }
		}
		box { <-10,0,0>,<10,1,20> }
		difference {
			cylinder { <0,0,0>,<0,-6,0>,4 }
			cylinder { <0,1,0>,<0,-7,0>,3.9 }
			box { <-8,-8,-8>,<8,8,0> rotate x*-40 translate <0,-4,-4> }
			translate <0,0,10>
		} // end difference
//		texture { SilverPaintTex } // test
		texture { BlackPaintTex }
	} // end union

#declare SBlade =
	union {
		box { <-6 ,0,-2.5>,<-28,-0.5,2.5> texture { RedBladeTex } }
		box { <-28,0,-2.5>,<-32,-0.5,2.5> texture { SWhiteTex } }
		box { <-32,0,-2.5>,<-37,-0.5,2.5> texture { RedBladeTex } }
		box { <-6,0,-4>,<3,-0.5,4> texture { BlackPaintTex } }
	} // end union
#declare SBladeGroup =
	union {
		cylinder { <0,0,0>,<0,-12,0>,3 texture { SilverPaintTex }} // axle mount
		object { SBlade rotate y*0 translate <0,-12,0> }
	} // end union

//===============================================
//             Tower Assembly
//===============================================

#declare SignalTower = // faces -y
	union {
		object { SPole(16*Feet) }
		object { SLadder(14*Feet) rotate x*8 translate <0,30,0> }
		object { NumberPlaque translate <0,-5,8*Feet> }
		object { SPlatform translate <-12,-8,14*Feet> }
		object { DoubleLight translate <0,-6,12.3*Feet> }
		object { SBladeGroup translate <0,0,15*Feet> }
	} // end union
		

//===============================================
//             Viewpoint 01
//===============================================

#if (RenderMe = 1)
global_settings {	max_trace_level 150 }
#declare TestSphere = sphere{ 0,12 pigment { color rgb<1,1,1> } }

	camera {
		perspective
		direction <0.0,     1.0,  0.0>
		sky       <0.0,     0.0,  1.0>  // Use right handed-system!
		up        <0.0,     0.0,  1.0>  // Where Z is up
		right     <1.33333, 0.0,  0.0>

		angle 48
		location  <1*Feet, -35*Feet, 5.5*Feet> // overall
		look_at <0*Feet,0*Feet,8*Feet>
//		location  <3*Feet, -1*Feet, 35*Feet> // top down
//		look_at <3*Feet,3*Feet,3*Feet>

	}

background { color rgb <0.276,0.567,0.982>*.97 } // sky blue
light_source
{ <140*Feet,-300*Feet,250*Feet>, 1.2
//  spotlight point_at <0,0*Feet,2*Feet> radius 25 falloff 36
}
light_source
{ <-140*Feet,-200*Feet,130*Feet>, <1.13,1.08,0.83>*.8
//  spotlight point_at <0,0,2*Feet> radius 25 falloff 36
}

plane { z,-0 pigment { checker rgb <1,1,1>, rgb <1,1,1>*.75 } scale 1*Feet }

//#include "GRuler.inc" // for testing only
//object { TestSphere scale 1 translate <0,0,10> }

object { SignalTower rotate z*0 translate <0,0,0> }
object { SignalTower rotate z*70 translate <-90,90,0> }
object { SignalTower rotate z*-50 translate < 90,90,0> }

#end

