//
// Glenn's BlobMan POV-Ray Scene File
// first concept 30-May-97 last update 18-Jun-06
// 2005 Glenn McCarter  ( glenn@mccarters.net )
// This file does not render.  #include "Smoker.inc" in another .pov file
//
// Objects:
// Smoker
//
// Intended scale is English system (inches)
// Uses RH coordinate reference system (Z=up)
// Origin at base of neck
// Person faces -x
// Sorry, this system does not incorporate inverse kinematics. 8-)


//===============================================
//             Variable Declarations
//===============================================

#ifndef (ThisIsMaster) // now we know this include file was not called by another
	#declare RenderMe = 0; // supress self-rendering of other includes files
	#declare ThisIsMaster = 1;
//	#include "GRuler.inc"
	#include "Colors.inc"
	#include "Textures.inc"
	#include "GIncludeRH.inc"
	#declare RenderMe = 1;
#end

#include "BlobHead31.inc"

#declare HandPose = 1; // overrides default pose
#declare FFat = 1.23; // finger fatness ratio ( 1 = normal, 1.4 = too fat )
#declare LTA    = 02; // thumb, outer joint
#declare LTB    = 05; // thumb, middle joint
#declare LTRot  = 30; // thumb rotation angle
#declare LTExt  = -20; // thumb extension from hand
#declare LF1A   = 08; // index finger, outer joint
#declare LF1B   = 36; // index finger, middle joint
#declare LF1C   = 55; // index finger angle
#declare LF1Rot = 10; // index finger rotation
#declare LF2A   = 09; // middle finger, outer joint
#declare LF2B   = 49; // middle finger, middle joint
#declare LF2C   = 62; // middle finger angle
#declare LF2Rot = 0; // middle finger rotation
#declare LF3A   = 15; // ring finger, outer joint
#declare LF3B   = 48; // ring finger, middle joint
#declare LF3C   = 85; // ring finger angle
#declare LF3Rot = -4; // ring finger rotation
#declare LF4A   = 20; // pinky finger, outer joint
#declare LF4B   = 66; // pinky finger, middle joint
#declare LF4C   = 86; // pinky finger angle
#declare LF4Rot = -10; // pinky finger rotation
#declare LWRot  = -18; // wrist angle
#declare LWCock = -05; // wrist cock side-to-side

#declare RTA    = 32; // thumb, outer joint
#declare RTB    = 45; // thumb, middle joint
#declare RTRot  = 30; // thumb rotation angle
#declare RTExt  = 0; // thumb extension from hand
#declare RF1A   = 03; // index finger, outer joint
#declare RF1B   = 10; // index finger, middle joint
#declare RF1C   = 40; // index finger angle
#declare RF1Rot = 10; // index finger rotation
#declare RF2A   = 05; // middle finger, outer joint
#declare RF2B   = 10; // middle finger, middle joint
#declare RF2C   = 48; // middle finger angle
#declare RF2Rot = 0; // middle finger rotation
#declare RF3A   = 35; // ring finger, outer joint
#declare RF3B   = 98; // ring finger, middle joint
#declare RF3C   = 62; // ring finger angle
#declare RF3Rot = -4; // ring finger rotation
#declare RF4A   = 02; // pinky finger, outer joint
#declare RF4B   = 86; // pinky finger, middle joint
#declare RF4C   = 86; // pinky finger angle
#declare RF4Rot = -10; // pinky finger rotation
#declare RWRot  = -12; // wrist angle
#declare RWCock = -25; // wrist cock side-to-side

#include "BlobHands36.inc"
//#include "Accessories.inc"

#ifndef ( Pose )
// Pose Angles ( in order )
#declare HPan     = -25;   // head, positive = towards his left
#declare HTiltFwd = 25;   // head forward tilt
#declare HCock    = 0;    // head right/left tilt, positive = to the left
#declare TTwist   = 0;    // torso twist, positive = right hip fwd
#declare HipTude  = 0;    // hip attitude, positive = right hip up
#declare RWCock   = 0;    // wrist side-to-side (golf)
#declare RWAng    = 0;    // wrist angle
#declare RETwist  = 110;   // twists the hand, positive = palms up
#declare RElbow   = 140;  // elbow
#declare RAFwd    = 7;   // total arm
#declare RARot    = 55;   // claps hands
#declare RAOut    = 12;   // opens underarm
#declare RAFwd2   = 0;    // total arm
#declare RARot2   = 10;    // claps hands
#declare RAnkle   = 0;     // ankle, positive brings toes up
#declare RKnee    = 15;    // knee bend
#declare RLTwist  = 0;    // leg twist
#declare RLAng    = 20;    // leg angle fwd
#declare RLOut    = 0;    // spread eagle
#declare LWCock   = 0;   // wrist side-to-side (golf)
#declare LWAng    = 0;    // wrist angle rotation
#declare LETwist  = 140;  // twists the hand, positive = palms up
#declare LElbow   = 120;   // elbow
#declare LAFwd    = 16;   // total arm
#declare LARot    = 50;   // claps hands
#declare LAOut    = 16;    // opens underarm
#declare LAFwd2   = 0;    // total arm
#declare LARot2   = 10;  // claps hands
#declare LAnkle   = 0;     // ankle, positive brings toes up
#declare LKnee    = 115;    // knee bend
#declare LLTwist  = 0;    // leg twist
#declare LLAng    = 75;    // leg angle fwd
#declare LLOut    = 22;    // spread eagle
#end

//===============================================
//             Textures
//===============================================

#declare HatTex =
	texture {
//		pigment { color rgb<.002,.001,.008>*1.00 }
		pigment { color rgb<.202,.201,.208>*1.00 }
//		finish { specular 0.96 roughness .008 reflection 0 }
		finish { specular 0.06 roughness .18 reflection <0.02,0.04,0.05> }
	}

#declare SuitTex =
	texture {
//		pigment { color rgb<.02,.01,.08>*1.00 }
//		pigment { color rgb<.202,.201,.218>*1.00 }
		pigment {
			bozo
			color_map {
				[ 0.2 rgb<.402,.401,.418>*0.010 ]
				[ 0.8 rgb<.402,.401,.418>*0.50 ]
			}
			scale <1,1,2>
		}
		finish { diffuse 0.5 specular 0.08 roughness .18 }
	}
#declare ClothTex = texture { SuitTex }
/*
#declare ClothTex = // White test
	texture {
		pigment {color rgb<1.0,1.0,1.0>*0.7 }
		normal {
			crackle 1.2
			scale <1,2,2>
		}
		finish { ambient .3 specular .28 roughness .086 }
	}
*/
#declare PantsTex =
	texture {
//		pigment { color rgb<.02,.01,.08>*1.00 }
		pigment { color rgb<.020,.015,.010>*1.00 }
		normal { bumps 0.6 scale <3,3,5> }
		finish { specular 0.12 roughness .062 }
	}
#declare SocksTex =
	texture {
		pigment { color rgb<.020,.020,.020>*.40 }
		finish { specular 0.02 roughness .22 }
	}
#declare ShoesTex =
	texture {
		pigment { color rgb<.020,.017,.030>*.40 }
		finish { specular 0.45 roughness .022 }
	}




//===============================================
//       Body
//===============================================

#declare CoatButton =
	union {
		cylinder { <-0.1,0,0>,<0,0,0>,0.4 }
		torus { 0.4,0.08 rotate z*90 translate <-0.1,0,0> }
		texture { ShoesTex }
	} // end union
#declare TorsoHalf =
	union {
		sphere { // upper shoulders
			<0,0,0>,9
			scale <.4,1,.4>
			texture { ClothTex }
		}
		cylinder { //torso
			<0,0,0>,<0,0,-14>,9
			scale <.4,1,1>
			texture { ClothTex }
		}
		sphere { // lower end
			<0,0,0>,9
			scale <.4,1,.3>
			translate <0,0,-14>
			texture { ClothTex }
		}
		rotate <10,0,0>
		clipped_by { box {<-6,0,6>,<6,-12,-30>}}
	}

#declare Torso = //center where neck/shoulder join each other
	union {
		object { TorsoHalf }
		object { TorsoHalf transform InverseY }
		object { CoatButton scale 1.5 translate <-3.9,0,-5> }
		object { CoatButton scale 1.5 rotate y*10 translate <-3.9,0,-9.5> }
		object { CoatButton scale 1.5 translate <-3.8,0,-14> }
	}
#declare LHand = // points straight down
	object { LeftHand
//	object { LeftHandWithGunFiring
			rotate <0,-90,0> // point downwards
			rotate <0,LWCock,LWAng> // wrist angles
			translate <-0.0,0.6,-1.6> // drop down, move to touch sleeve
		}
#declare LLowerArm =
	union {
		object { LHand scale 0.9 }
			cone { //lower sleeve except cuff
				<0,0,2>,1.82,<0,0,11>,2.2
				texture { ClothTex }
				rotate <0,0,0>
				translate <0,0,0>
			}
		difference {
			cylinder { //lower sleeve outer
				<0,0,0>,<0,0,2.1>,1.9
				texture { ClothTex }
				rotate <0,0,0>
				translate <0,0,0>
			}
			cylinder { //lower sleeve inner
				<0,0,-.1>,<0,0,6>,1.85
				texture { ClothTex }
				rotate <0,0,0>
				translate <0,0,0>
			}
		} // end difference
		sphere { // elbow joint
			<0,0,11>,2.2
			texture { ClothTex }
			rotate <0,0,0>
			translate <0,0,>
		}
		translate <0,0,-11> // origin at elbow
	}

#declare LeftArm = //origin at shoulder
	union {
		object { LLowerArm rotate <0,0,LETwist> rotate <0,LElbow,0> }
		sphere { // elbow end
			<0,0,0>,2.2
			texture { ClothTex }
		}
		cone { //upper arm
			<0,0,0>,2.2,<0,0,11>,2.5
			texture { ClothTex }
			rotate <0,0,0>
		}
		sphere { //shoulder end
			<0,0,11>,2.5
			texture { ClothTex }
		}
		translate <0,0,-11> // origin at shoulder
	}

#declare RHand = // points straight down
	object { RightHand
		rotate <0,-90,0> // point downwards
		translate <0.0,-0.6,-1.0> // drop down, move to touch sleeve
	}
#declare RLowerArm =
	union {
		object { RHand scale 0.9 }
		difference {
			cone { //lower sleeve outer
				<0,0,0>,1.9,<0,0,11>,2.2
				texture { ClothTex }
				rotate <0,0,0>
				translate <0,0,0>
			}
			cylinder { //lower sleeve inner
				<0,0,-.1>,<0,0,6>,1.8
				texture { ClothTex }
				rotate <0,0,0>
				translate <0,0,0>
			}
		} // end difference
		sphere { // elbow joint
			<0,0,11>,2.2
			texture { ClothTex }
			rotate <0,0,0>
			translate <0,0,>
		}
		translate <0,0,-11> // origin at elbow
	}

#declare RightArm = //origin at shoulder
	union {
		object { RLowerArm rotate <0,0,-RETwist> rotate <0,RElbow,0> }
		sphere { // elbow end
			<0,0,0>,2.2
			texture { ClothTex }
		}
		cone { //upper arm
			<0,0,0>,2.2,<0,0,11>,2.5
			texture { ClothTex }
			rotate <0,0,0>
		}
		sphere { //shoulder end
			<0,0,11>,2.5
			texture { ClothTex }
		}
		translate <0,0,-11> // origin at shoulder
	}

#declare FootShoeR =
	union {
/*
		cylinder { // lower leg
			<0,0,1>,<0,0,8>,2.85
			rotate y*0
			scale <1,.6,1>
			texture { SocksTex }
		}
*/
		superellipsoid { // main shoe
			<.5,.5>
			scale <4.6,2.8,2>
			rotate <0,-5,0>
			translate <-4,0,0.8>
			texture { ShoesTex }
		}
		superellipsoid { // toe box
			<.5,.5>
			scale <4.0,2.3,1.8>
			rotate <0,35,0>
			translate <-8,0,0.8>
			texture { ShoesTex }
		}
		box { // heel
			<-1,-1.5,0>,<1,1.5,.8>
			rotate y*30
			texture { ShoesTex }
		}
	} // end union
#declare FootShoeL = object { FootShoeR scale <1,-1,1> }

#declare RLowerLeg =
	union {
		object { FootShoeR rotate y*RAnkle translate <0,0,-4> }
		sphere { // knee end
			<0,0,17>,2.8
			texture { PantsTex }
		}
		cone { // lower leg
			<0,0,0>,3.5,<0,0,17>,2.8
			texture { PantsTex }
			rotate <0,0,0>
		}
		translate <0,0,-17> // origin at knee
	}

#declare LLowerLeg =
	union {
		object { FootShoeL rotate y*LAnkle translate <4,0,-4> }
		sphere { // knee end
			<0,0,17>,2.8
			texture { PantsTex }
		}
		cone { // lower leg
			<0,0,0>,3.5,<0,0,17>,2.8
			texture { PantsTex }
			rotate <0,0,0>
		}
		translate <0,0,-17> // origin at knee
	}

#declare RightLeg = // origin at pelvis joint
	union {
		object { RLowerLeg rotate <0,0,-RLTwist> rotate <0,-RKnee,0> }
		sphere { // knee end
			<0,0,0>,2.8
			texture { PantsTex }
		}
		cone { // upper leg
			<0,0,0>,2.8,<0,0,18>,3.5
			texture { PantsTex }
			rotate <0,0,0>
		}
		sphere { // pelvis end
			<0,0,18>,3.5
			texture { PantsTex }
		}
		translate <0,0,-18> // origin at pelvis joint
	}

#declare LeftLeg = // origin at pelvis joint
	union {
		object { LLowerLeg rotate <0,0,-LLTwist> rotate <0,-LKnee,0> }
		sphere { // knee end
			<0,0,0>,2.8
			texture { PantsTex }
		}
		cone { // upper leg
			<0,0,0>,2.8,<0,0,18>,3.5
			texture { PantsTex }
			rotate <0,0,0>
		}
		sphere { // pelvis end
			<0,0,18>,3.5
			texture { PantsTex }
		}
		translate <0,0,-18> // origin at pelvis joint
	}

#declare Hips =
	union {
		sphere { // top of cyl
			<0,0,0>,5
			scale <.8,1,.4>
			translate <0,0,8>
			texture { ClothTex }
		}
		cylinder { // main part
			<0,0,0>,<0,0,8>,5
			scale <.8,1,1>
			translate <0,0,0>
			texture { ClothTex }
		}
		sphere { // bottom of cyl
			<0,0,0>,5
			scale <.8,1,.4>
			translate <0,0,0>
			texture { ClothTex }
		}
		sphere { // butt cheek RH
			<0,0,0>,5
			scale <.7,.8,1>
			translate <0,-2,0>
			texture { ClothTex }
		}
		sphere { // butt cheek LH
			<0,0,0>,5
			scale <.7,.8,1>
			translate <0,2,0>
			texture { ClothTex }
		}
	} // end union

#declare LowerTorso =
	union {
		object { Hips translate <.5,0,0> }
		object { LeftLeg
			rotate <-LLOut,LLAng,0>
			translate <0,-3,0>
		}
		object { RightLeg
			rotate <RLOut,RLAng,0>
			translate <0,3,0>
		}
	} // end union


//===============================================
//             Objects
//===============================================

#declare Hat =
	union {
		cylinder {
			<0,0,0>,<0,0,0.2>,8
			scale <1,0.8,1>
		}
		cone {
			<0,0,0>,5.3,<0,0,4.5>,4.5
			scale <1,0.75,1>
		}
		texture { HatTex }
		translate <0,0,10.5>
	} // end union

#declare SmokerLight =

	light_source {
		<0,0,0>
		color rgb <0.684,0.609,0.231>*8
		fade_power 2
		fade_distance 8
		media_interaction off
		media_attenuation off
		looks_like {

			union {
				sphere { <0,0,0>,.45 scale <.7,.7,3>
					texture {
						pigment{
							gradient z
							color_map {
								[ 0.0 rgbt<1,1,0.42,1> ]
								[ 0.4 rgbt<2,2,0.82,0.5> ]
								[ 0.7 rgb<1,1,0.42>*2 ]
								[ 0.86 rgb<1,.5,0.42>*1 ]
							}
							scale <1,1,3>
							translate <0,0,-1.5>
						}
						finish{ambient 25}
					}
					translate <0,0,1>
					rotate <-10,20,0>
				}
				cylinder { <0,0,0>,<0,0,3.5>,0.9 scale <0.5,1,1> translate <0,0,-4> texture { pigment{ rgb<.4,.4,.5> }} }
			} // end union

		}
	}

#declare CoatTails =
	union {
		cone { <0,0,0>,.5,<0,0,-20>,2.5 translate <0,9,0> rotate <0,0,-0> }
		cone { <0,0,0>,.5,<0,0,-20>,2.5 translate <0,9,0> rotate <0,0,-20> }
		cone { <0,0,0>,.5,<0,0,-20>,2.5 translate <0,9,0> rotate <0,0,-40> }
		cone { <0,0,0>,.5,<0,0,-20>,2.5 translate <0,9,0> rotate <0,0,-80> }
		cone { <0,0,0>,.5,<0,0,-20>,2.5 translate <0,9,0> rotate <0,0,-120> }
		cone { <0,0,0>,.5,<0,0,-20>,2.5 translate <0,9,0> rotate <0,0,-150> }

		cone { <0,0,0>,2.5,<0,0,-20>,1.5 rotate x*8 translate <0,7,0> rotate <0,0,-10> }
		cone { <0,0,0>,2.5,<0,0,-20>,1.5 rotate x*8 translate <0,7,0> rotate <0,0,-30> }
		cone { <0,0,0>,2.5,<0,0,-20>,1.5 rotate x*8 translate <0,7,0> rotate <0,0,-65> }
		cone { <0,0,0>,2.5,<0,0,-20>,1.5 rotate x*8 translate <0,7,0> rotate <0,0,-100> }
		cone { <0,0,0>,2.5,<0,0,-20>,1.5 rotate x*8 translate <0,7,0> rotate <0,0,-135> }

		cone { <0,0,0>,1,<0,0,-16>,6 scale <1,.2,1> rotate <0,30,20> translate <6,-8,0> }
		cylinder { <0,0,-10>,<0,0,-20>,6 translate <6,3,0> }
		texture { ClothTex }
	} // end union

#declare CollarGroup =
	union {

		difference {
			cone { <0,0,0>,5,<0,0,4>,4.5 }
			cone { <0,0,-0.1>,3.5,<0,0,4.1>,4.2 }
//			cylinder { <0,0,6>,<-8,0,6>,3.5 }
			scale <1.2,.95,1.0>
		} // end difference

		superellipsoid { <.3,.3> scale <2/2,4/2,2/2> rotate <-10,0,0> translate <0,7,2.7> }
		superellipsoid { <.3,.3> scale <2/2,4/2,2/2> rotate < 10,0,0> translate <0,-7,2.7> }
		
		texture { ClothTex }
	} // end union

#declare Cigarette =
	union {
		cylinder { <0,0,0>,<3.8,0,0>,.23 texture { pigment { rgb<1,1,1> }} }
		cylinder { <2.9,0,0>,<3.85,0,0>,.21 texture { pigment { rgb<.62,.48,.3> }} }
	} // end union

#declare Ankle =
	sphere {
		<0,0,0>,4 scale <1,1,2> translate <0,0,4>
		texture { SocksTex }
	}
//===============================================
//             Groups
//===============================================

#declare Smoker = //center at base of neck, facex -x
	union {
		object { MaleHead scale 1.3 rotate <0,0,HPan> rotate <HCock,-HTiltFwd,0> }
		object { Hat rotate <0,0,HPan> rotate <HCock,-HTiltFwd,0> }
		object { CollarGroup rotate y*-30 translate <0,0,-1> }
		object { Torso rotate <0,0,0> translate <0,0,0> }
		object { LeftArm
			rotate <0,LAFwd,-LARot>
			rotate <-LAOut,0,0>
			rotate <0,LAFwd2,LARot2>
			translate <0,-8,-1> // hang it on the shoulder
		}
		object { RightArm
			rotate <0,RAFwd,RARot>
			rotate <RAOut,0,0>
			rotate <0,RAFwd2,-RARot2>
			translate <0,8,-1> // hang it on the shoulder
		}

		object { LowerTorso
			rotate <HipTude,0,0>
			rotate <0,0,TTwist>
			translate <0,0,-18> // hang it on the spine
		}
		object { CoatTails translate <-4,-0.8,-16> }
		object { Cigarette rotate z*180 rotate <0,-20,30> translate <-6,2.4,2.3> }
		object { SmokerLight rotate <17,-12,-20> translate <-9.5,-0.7,0.6> }
		object { Ankle translate <-8.5,2,-5*Feet> }
	} // end union

//===============================================
//             For Testing Only
//===============================================

#if (RenderMe = 1)

#declare Render_Cam =
	camera {
  perspective
  direction <0.0,     1.0,  0.0>
  sky       <0.0,     0.0,  1.0>  // Use right handed-system!
  up        <0.0,     0.0,  1.0>  // Where Z is up
  right     <1.33333, 0.0,  0.0>
//  location  <-13, -10, 7> // origin closeup
//  look_at   <0.000, 0.000, 0.000>
//  location  <-33, -0, 7> // head front view
//  look_at   <0.000, 0.000, 4.000>
//  location  <2, -30, 4> // head side view
//  look_at   <2, 0, 4>
//  location  <-1, -1, 28> // top view
//  look_at   <0.000, 0.000, 4.000>
//  location  <-9, -4, 2.2> // eye closeup
//  look_at   <0.000, 0.000, 2.200>
//  location  <-25, -22, 7> // 3/4 head view
//  look_at   <0.000, 0.000, 4.000>
//  location  <0, -66, 0> // overall side view
//  look_at   <0, 0, -6>
//  location  <-60, 0, 4> // overall front view
//  look_at   <0, 0, -4>
//  location  <-52, -48, 8> // 3/4 overall view
//  look_at   <0.000, 0.000, -8.000>
  location  <-18, -15*Feet, 58> // render view
  look_at   <-8, 0, 36>
	angle 40
}
camera { Render_Cam }
background { color rgb <0.376,0.567,0.682>*.97 }
light_source
{ <40*Feet,-35*Feet,20*Feet>, 2.0
  spotlight point_at <0,2*Feet,2*Feet> radius 15 falloff 26
}
/*
light_source
{ <-40*Feet,-20*Feet,30*Feet>, <1.13,1.08,0.83>*.8
  spotlight point_at <0,0,2*Feet> radius 15 falloff 26
}
*/
plane { z,-0 pigment { checker rgb 1, rgb .75 } scale 12 }


object { Smoker rotate <0,0,110> translate <-3*Feet,-4*Feet,5*Feet-3> }
object { Smoker rotate <0,0,50> translate <0,0,5*Feet-3> }
object { Smoker rotate y*-12 rotate z*110 translate <4*Feet,6*Feet,5*Feet-3> }

/*
object { Smoker rotate <0,0,110> translate <-3*Feet,-7*Feet,5*Feet-3> }
object { Smoker rotate <0,0,110> translate <0,-6*Feet,5*Feet-3> }
object { Smoker rotate y*-12 rotate z*120 translate <2*Feet,-2*Feet,5*Feet-3> }
*/
//object { SmokerLight scale 20 translate <0,0,20> }
//sphere {<0,0,-3>,3 pigment { White } }

#end

