
// POV-Ray Object File - Train Passenger Car
// created 22-Jun-06
// last update 22-Jun-06
// Copyright 2006 Glenn McCarter (glenn@mccarters.net). Some rights reserved.
// This work is licensed under the Creative Commons Attribution License
// To view a copy of this license, visit http://creativecommons.org/licenses/by/2.0/
//
// Required #include files: "GIncludeRH.inc"
//
// Objects:
// Passengercar
//
//
// Intended scale is English system (inches)
// Uses RH coordinate reference system (Z=up)
//
// This file is intended to be included in another POV-Ray scene file,
// but can be rendered alone.
#ifndef (ThisIsMaster) // If this include file was not called by another, then
	#declare RenderMe = 0; // supress self-rendering of other include files
	#declare ThisIsMaster = 1;
	#include "GIncludeRH.inc"
	// renderable sub includes go here
	#declare RenderMe = 1;
#end

//===============================================
//             Includes
//===============================================

// non-renderable sub includes go here

//===============================================
//             Variables
//===============================================


//===============================================
//             Textures
//===============================================

#declare BrightAluminumTex =
	texture {
		pigment { rgb<.8,.8,.98>*1} // too white?
		pigment { rgb<.8,.8,.98>*.5} // test
//		normal { bumps 0.2 scale <14,90,14> }
//		normal { bumps 0.12 scale 0.002 } // blurred reflection test
//		normal { bumps 0.2 scale <14,90,14> }
//		normal { bumps 0.2 scale <14,90,14> translate <9,36,9> }
		normal { bumps 0.2 scale <8,20,8> }
		normal { bumps 0.12 scale <8,20,8> translate <9,36,9> }
		finish { ambient .1 diffuse 0.7 specular 0.975 roughness 0.025 reflection 0.08 }
	}
#declare WindowFrameTex =
	texture {
		pigment { color rgb<.04,.05,.04> }
		finish { ambient 0.1 diffuse 0.6 specular 0.24 roughness .05 }
	}
#declare WindowGlassTex =
	texture {
		pigment { color rgbt<.04,.05,.04,0.85> }
		finish { ambient 0.1 diffuse 0.6 reflection 0.24 }
	}
#declare WindowCurtainTex =
	texture {
		pigment { color rgb<.94,.95,.84> }
		finish { ambient 0.2 diffuse 0.5 specular 0.24 roughness .12 }
	}
#declare UnderbodyTex =
	texture {
		pigment { color rgb<.64,.55,.54>*.07 }
		normal { bumps 0.3 scale 4 }
		finish { ambient 0.1 diffuse 0.6 specular 0.06 roughness .25 }
	}
#declare RailWheelTex =
	texture {
		pigment { color rgb<.64,.58,.57>*.34 }
		normal { bumps 0.3 scale 4 }
		finish { ambient 0.1 diffuse 0.6 specular 0.06 roughness .25 }
	}
#declare BrightWheelTex =
	texture {
		pigment { color rgb<.875,.858,.987>*1.02 }
		normal { bumps 0.05 scale <.1,3,3> }
		finish { specular 0.66 roughness .05 metallic 0.3 brilliance 5 }
	}
#declare TruckTex =
	texture {
		pigment { color rgb<.64,.55,.54>*.34 }
		normal { bumps 0.2 scale .8 }
		finish { ambient 0.1 diffuse 0.6 specular 0.06 roughness .25 }
	}


//===============================================
//             Macros
//===============================================



//===============================================
//             Objects
//===============================================

#declare SilVerZephyr =
	text {
		ttf "Exotic-Bold.ttf"
		"SILVER ZEPHYR" 1, <0.2,0,0>
		rotate <90,0,90>
		scale <.05,20,5>
		texture {
			pigment { rgb<.8,.8,.98>*.2 }
			finish { ambient .1 diffuse 0.7 specular 0.975 roughness 0.025 reflection 0.08 }
		} 
	}

// Simple version (no wheels)
#declare TWallCyl =
	union {
		sphere { <0,4*Feet,0>,2.0 }
		sphere { <0,0,0>,2.0 scale <1,.3,1> translate <0,60*Feet-10,0> }
		cylinder { <0,4*Feet,0>,<0,60*Feet-10,0>,2.0 }
		scale <0.07,1,1>
	} // end union

#declare TrainCarS=
	union {
		box {<-40,0,2*Feet>,<40,60*Feet,10*Feet> } // sidewall
		#local WNL=5*Feet;
		#while (WNL<55*Feet)
			box { <-41,0,0>,<41,36,18>
				translate <0,WNL,72>
				texture { pigment { rgb<0,0,0> } finish { reflection 0.23 } }
			}
			#local WNL=WNL+5*Feet;
		#end
		object { TWallCyl translate <40,0,30> }
		object { TWallCyl translate <40,0,36> }
		object { TWallCyl translate <40,0,42> }
		object { TWallCyl translate <40,0,108> }
		object { TWallCyl translate <40,0,108+6> }
		cylinder { <0,0,0>,<0,60*Feet,0>,40 scale <1,1,0.5> translate <0,0,10*Feet> }
		texture { BrightAluminumTex }
	} // end union

//===============================================
//             Wheel Group
//===============================================

#declare RailWheelS = // origin at inside of inside flange
	union {
		cylinder { <0,0,0>,<3.1,0,0>,18 }
		cylinder { <-0.8,0,0>,<0,0,0>,19 }
		cylinder { <-30,0,0>,<0,0,0>,5 }
		texture { RailWheelTex }
	} // end union
#declare RailWheel = // origin at inside of inside flange
	union {
		difference { // shiny
			cylinder { <0,0,0>,<3.1,0,0>,18 }
			cylinder { <-1,0,0>,<5,0,0>,16 }
			texture { BrightWheelTex }
		} // end difference
		difference { // dark inside
			cylinder { <0,0,0>,<3,0,0>,17.0 }
			torus { 11.0,5 rotate z*90 scale <.75,1,1> translate <4,0,0> }
		} // end difference
		cylinder { <-0.2,0,0>,<0,0,0>,19 texture { BrightWheelTex } } // flange
		cylinder { <-0.8,0,0>,<-0.2,0,0>,19.1 } // flange backing
		cylinder { <-30,0,0>,<9,0,0>,5 } // axle
		cone { <9,0,0>,5,<10,0,0>,3 } // axle tip
		box { <2,-3,-3>,<5,3,4> }
		texture { RailWheelTex }
	} // end union
#declare TruckSpring =
	union {
		#local CC=0;
		#while (CC<7)
			torus { 3.2,0.7 rotate x*-100 translate <0,0,CC*1.5> }
			#local CC=CC+1;
		#end
		texture { TruckTex }
	} // end union
#declare TruckSpringGroup =
	union {
		object { TruckSpring translate <0,-4,0> }
		object { TruckSpring translate <0, 4,0> }
		difference {
			box { <-24,-10,10>,<5,10,16> }
			box { <  3,-8.5,11.5>,<6,8.5,14.5> }
		} // end difference
		box { <-24,-8,-3>,<5,8,0> }
		texture { TruckTex }
	} // end union

#declare TruckFrame =
	height_field { // extruded into +y
		png "TruckFrame_HFmap.png"
		water_level 1/255
		scale <9.5*Feet,4,3*Feet>
		rotate z*-90
		translate <0,0,0>
		texture { TruckTex }
	}

#declare RW = 4*Feet+8.5*Inches; // RailwayWidth
#declare TruckHalfAssy =
	union {
		object { RailWheel translate <RW/2,-3.5*Feet,18> }
		object { RailWheel translate <RW/2,3.5*Feet,18> }
		object { TruckSpringGroup translate <RW/2+4,0,12> }
		object { TruckFrame translate <RW/2+3,4.7*Feet,2> }
	} // end union	
#declare TruckHalfAssyS = // for right side only
	union {
		object { RailWheelS translate <RW/2,-3.5*Feet,18> }
		object { RailWheelS translate <RW/2,3.5*Feet,18> }
		box { <24,-11,4>,<RW/2,11,14> texture { RailWheelTex } }
	} // end union	

#declare TruckAssy =
	union {
		object { TruckHalfAssy }
		object { TruckHalfAssy scale <-1,1,1> }
	} // end union

#declare RightTruckAssy =
	union {
		object { TruckHalfAssy }
		object { TruckHalfAssyS scale <-1,1,1> }
	} // end union

//===============================================
//             Body Group
//===============================================

#declare TrainCarBodyS=
	union {
		box { <-22,12,24>,<22,60*Feet-12,36> texture { UnderbodyTex } } // frame
		box { <-27,27*Feet,8>,<27,33*Feet,24> } // center box
		box {<-48,0,36>,<48,60*Feet,10*Feet> } // sidewall
		box {<-48,16*Feet,30>,<48,60*Feet-16*Feet,36> } // sidewall base
		#local WNL=5*Feet;
		#while (WNL<55*Feet)
			box { <-49,0,0>,<49,48,18>
				translate <0,WNL,82>
				texture { pigment { rgb<0,0,0> } finish { reflection 0.23 } }
			}
			#local WNL=WNL+6*Feet;
		#end
		object { TWallCyl translate <48,0,40> }
		object { TWallCyl translate <48,0,45> }
		object { TWallCyl translate <48,0,50> }
		object { TWallCyl translate <48,0,55> }
		object { TWallCyl translate <48,0,60> }
		object { TWallCyl translate <48,0,65> }
		object { TWallCyl translate <48,0,108> }
		object { TWallCyl translate <48,0,108+6> }
		cylinder { <0,0,0>,<0,60*Feet,0>,48 scale <1,1,0.5> translate <0,0,10*Feet> }
		texture { BrightAluminumTex }
	} // end union

#declare WCR=4.0;
#declare WindowCutter =
	union {
		box { <46,WCR,0>,<49,48-WCR,18> }
		box { <46,0,WCR>,<49,48,18-WCR> }
		cylinder { <46,WCR,WCR>,<49,WCR,WCR>,WCR }
		cylinder { <46,48-WCR,WCR>,<49,48-WCR,WCR>,WCR }
		cylinder { <46,WCR,18-WCR>,<49,WCR,18-WCR>,WCR }
		cylinder { <46,48-WCR,18-WCR>,<49,48-WCR,18-WCR>,WCR }
		texture { BrightAluminumTex }
	} // end union
#declare WFTorii=
	union {
		torus { WCR,1 rotate z*90 translate <0,WCR,WCR> }
		torus { WCR,1 rotate z*90 translate <0,48-WCR,WCR> }
		torus { WCR,1 rotate z*90 translate <0,WCR,18-WCR> }
		torus { WCR,1 rotate z*90 translate <0,48-WCR,18-WCR> }
		texture { WindowFrameTex }
	} // end union
#declare WindowFrame =
	union {
		difference {
			object { WFTorii }
			box { <-2,-2,WCR>,<2,48+2,18-WCR> }
			box { <-2,WCR,-2>,<2,48-WCR,18+2> }
		} // end difference
		cylinder { <0,0,WCR><0,0,18-WCR>,1 }
		cylinder { <0,48,WCR><0,48,18-WCR>,1 }
		cylinder { <0,WCR,0><0,48-WCR,0>,1 }
		cylinder { <0,WCR,18><0,48-WCR,18>,1 }
		texture { WindowFrameTex }
	} // end union
#declare WindowCurtain =
	box { <-0.1,0,0>,<0,48,18> texture { WindowCurtainTex } }

#declare TrainDoor=
	union{
		difference {
			box { <-1,10,43>,<0,3.5*Feet,100> }
			box { <-2,16,70>,<1,3.5*Feet-6,92> }
		} // end difference
		texture { BrightAluminumTex }
	} // end union
#declare TrainSteps =
	union {
		box { <-10,10,0>,<0,3.5*Feet,8> }
		box { <-10,10,0>,<0,3.5*Feet,8> translate <-10,0,8> }
		box { <-10,10,0>,<0,3.5*Feet,8> translate <-20,0,16> }
		box { <-30,0,-12>,<0,0.5,0> rotate y*45 translate <0,10,8> }
		box { <-30,0,-12>,<0,0.5,0> rotate y*45 translate <0,3.5*Feet,8> }
		texture { BrightAluminumTex }
	} // end union
#declare TrainHandRail =
	union {
		sphere { <0,0,0>,1 }
		cylinder { <0,0,0>,<2,0,0>,0.3 }
		sphere { <0,0,0>,1 translate <0,0,28> }
		cylinder { <0,0,0>,<2,0,0>,0.3 translate <0,0,28> }
		cylinder { <0,0,0>,<0,0,28>,0.3 translate <2,0,0> }
		texture { BrightAluminumTex }
	} // end union

#declare TTopVent=
	union {
		superellipsoid { <0.3,0.05> scale <20/2,20/2,10/1> }
		cylinder { <0,0,-8>,<0,0,8>,3 translate <0,3.8*Feet,5> }
		texture { BrightAluminumTex }
	} // end union

//---------------- Body ---------------------
#declare TrainCarBody= // detailed version
	union {
		object { TrainDoor translate <0,-3.5*Feet,0> rotate z*-75 translate <47.3,3.5*Feet,0> }
		object { TrainSteps translate <48,0,12> }
		object { TrainHandRail translate <48,3.5*Feet+3,44> }
		box { <-21,0,36>,<-20,60*Feet,10*Feet> } // compartment divider wall
		box { <47.5,15*Feet,32>,<48,60*Feet-15*Feet,36> } // lower flange
		difference { // lower flange
			cylinder { <0,15*Feet,0>,<0,60*Feet-15*Feet,0>,6 }
			cylinder { <0,15*Feet-1,0>,<0,60*Feet-15*Feet+1,0>,5.5 }
			box { <-7,15*Feet-1,-7>,<0,60*Feet-15*Feet+1,7> rotate y*-45 }
			translate <48-6,0,32>
		} // end difference
		box { <-0.5,-3,-3>,<0,3,3> rotate x*45 translate <47.99,15*Feet,36> } // flange gusset
		box { <-0.5,-3,-3>,<0,3,3> rotate x*45 translate <47.99,60*Feet-15*Feet,36> } // flange gusset
		box { <47,3.5*Feet,36>,<48,60*Feet,75> } // sidewall main bottom door
		box { <47,0,36>,<48,10,75> } // sidewall main bottom
		box { <0,3.5*Feet+1.5,36>,<47.5,3.5*Feet+3,42> } // door frame support
		object { TWallCyl translate <48,0,40> }
		object { TWallCyl translate <48,0,45> }
		object { TWallCyl translate <48,0,50> }
		object { TWallCyl translate <48,0,55> }
		object { TWallCyl translate <48,0,60> }
		object { TWallCyl translate <48,0,65> }
		object { SilVerZephyr translate <48,25*Feet,69> }

		// window section
		box { <47,3.5*Feet,75>,<48.5,60*Feet,76.4> } // divider
		box { <47,0,75>,<48.5,10,76.4> } // divider
		box { <47,3.5*Feet,75>,<48,60*Feet,82> }
		box { <47,0,75>,<48,10,82> }
		box { <47,0,82,>,<48,10,100> }
		difference { // windowframe cutouts
			box { <47,3.5*Feet,82,>,<48,60*Feet,100> }
			#local WNL=5*Feet;
			#while (WNL<55*Feet)
				object { WindowCutter
					translate <0,WNL,82>
				}
				#local WNL=WNL+6*Feet;
			#end
		} // end difference
		#local WNL=5*Feet;
		#while (WNL<55*Feet)
			object { WindowFrame
				scale <0.75,1,1>
				translate <48,WNL,82>
			}
			#local WNL=WNL+6*Feet;
		#end
		box { <47,3.5*Feet,82>,<47.2,60*Feet,100> texture { WindowGlassTex} } // windows
		object { WindowCurtain translate <46,5*Feet,82> }
		object { WindowCurtain translate <46,5*Feet+6*Feet*2,82> }
		object { WindowCurtain translate <46,5*Feet+6*Feet*3,82> }
		object { WindowCurtain translate <46,5*Feet+6*Feet*4,82> }
		object { WindowCurtain translate <46,5*Feet+6*Feet*5,82> }
		object { WindowCurtain translate <46,5*Feet+6*Feet*6,82> }
		object { WindowCurtain translate <46,5*Feet+6*Feet*7,82> }
		object { WindowCurtain translate <46,5*Feet+6*Feet*8,82> }
		box { <47,0,100>,<48,60*Feet,112> } // over window
//		box { <47,0,112>,<49,60*Feet,113> } // divider
		box {<-48,0,112>,<48,60*Feet,120> } // sidewall main top
		object { TWallCyl translate <48,0,108> }
		object { TWallCyl translate <48,0,108+6> }
		box { <47,0,118>,<49,60*Feet,119> } // divider

		cylinder { <0,0,0>,<0,60*Feet,0>,48 scale <1,1,0.5> translate <0,0,10*Feet> } // roof
		object { TTopVent translate <20,8*Feet,11.0*Feet> }
		object { TTopVent scale <1,-1,1> translate <20,60*Feet-8*Feet,11.0*Feet> }

		box { <-22,12,24>,<22,60*Feet-12,36> texture { UnderbodyTex } } // underframe
		box { <-27,27*Feet,8>,<27,33*Feet,24> } // center under box
		texture { BrightAluminumTex }
	} // end union


//===============================================
//             Car Assembly
//===============================================

#declare PassengerCarS = // extends into +y
	union {
		object { RightTruckAssy translate <0,10*Feet,0> }
		object { RightTruckAssy translate <0,60*Feet-10*Feet,0> }
		object { TrainCarBodyS translate <0,0,0> }
	} // end union

#declare PassengerCar = // extends into +y
	union {
		object { RightTruckAssy translate <0,10*Feet,0> }
		object { RightTruckAssy translate <0,60*Feet-10*Feet,0> }
		object { TrainCarBody }
	} // end union
		
		

//===============================================
//             Viewpoint 01 - for testing only
//===============================================

#if (RenderMe = 1)
global_settings {	max_trace_level 150 }
#declare TestSphere = sphere{ 0,12 pigment { color rgb<1,1,1> } }

	camera {
		perspective
		direction <0.0,     1.0,  0.0>
		sky       <0.0,     0.0,  1.0>  // Use right handed-system!
		up        <0.0,     0.0,  1.0>  // Where Z is up
		right     <1.33333, 0.0,  0.0>

		angle 48
		location  <1*Feet, -35*Feet, 5.5*Feet> // overall
		look_at <0*Feet,0*Feet,8*Feet>
//		location  <3*Feet, -1*Feet, 35*Feet> // top down
//		look_at <3*Feet,3*Feet,3*Feet>

	}

background { color rgb <0.276,0.567,0.982>*.97 } // sky blue
light_source
{ <140*Feet,-300*Feet,250*Feet>, 1.2
//  spotlight point_at <0,0*Feet,2*Feet> radius 25 falloff 36
}
light_source
{ <-140*Feet,-200*Feet,130*Feet>, <1.13,1.08,0.83>*.8
//  spotlight point_at <0,0,2*Feet> radius 25 falloff 36
}

plane { z,-0 pigment { checker rgb <1,1,1>, rgb <1,1,1>*.75 } scale 1*Feet }

//#include "GRuler.inc" // for testing only
//object { TestSphere scale 1 translate <0,0,10> }

//object { PassengerCar scale 5 rotate z*-40 translate <-15*Feet,12*Feet,0> } // truck closeup
object { PassengerCar scale 1 rotate z*-14 translate <-15*Feet,12*Feet,0> }
//object { PassengerCar scale 1 rotate z*-56 translate <-30*Feet,32*Feet,0> }
//object { RightTruckAssy scale 3 rotate z*-54 translate <-8*Feet,22*Feet,0> }
//object { RightTruckAssy scale 3 rotate z*-90 translate <-0*Feet,22*Feet,0> }

//object { PassengerCar scale 3 rotate z*-54 translate <-8*Feet,22*Feet,0> } // wheel detail
#end

