#include "shapes.inc"
#include "textures.inc"

#declare Radiosity=off;

global_settings {
  assumed_gamma 1.0
  max_trace_level 1//0
  #if (Radiosity)
    radiosity {
      gray_threshold .5        
      normal on              
      media on                
    }
  #end
}

sky_sphere { 
  pigment {
    gradient y
    color_map { [0.0 color rgb <0.7,0.7,1.0>] [1.0 color blue 0.5] }
  }   
}
plane {y, .3     
          texture {
		pigment {rgb< 0.137255 , 0.556863 , 0.419608>}
		finish {reflection .35 specular 1 ambient 0 }
		normal {ripples .35 turbulence .5 scale 5} 
	  } 
} 

camera {
  location  <3,0,-35>
  look_at   <3,0,0> 
  angle 15
  translate y*14
  rotate <0, 0, 0>
}  

light_source {
	<-6, 6,-20>
	rgb.7
	area_light <5, 0, 0>, <0, 5, 0>, 5, 5
	adaptive 1
	jitter 
	 media_interaction off 
}
            
light_source {
	<20, 45, 150>
	color rgb 1.5 
	 media_interaction off 
}  

fog {
	distance 1500
	color rgbf <0.5, 0.5, 0.5, .2> 
	turbulence 0.2
	turb_depth 0.3
	fog_type 2
	fog_offset 25
	fog_alt 1
} 

light_source {
	<0, 15.2,0>
	color rgb 1  
	spotlight
	radius 1.5
	falloff 2
	tightness 1
	point_at <15, 16, 75>
} 

sphere {
	0, 500 pigment {rgbt 1} hollow
	interior {
		media {
			scattering {1, 0.01} 
		}
	} 
} 
//textures
#declare Grain=
 pigment
 {bumps
  turbulence 2   
   color_map
   {[0.000 color rgb <0.910, 0.788, 0.788>]
    [0.316 color rgb <0.922, 0.914, 0.871>]
    [0.316 color rgb <0.922, 0.914, 0.871>]
    [0.453 color rgb <0.894, 0.867, 0.780>]
    [0.453 color rgb <0.894, 0.867, 0.780>]
    [0.624 color rgb <0.784, 0.788, 0.788>]
    [0.624 color rgb <0.784, 0.788, 0.788>]
    [0.726 color rgb <0.851, 0.812, 0.741>]
    [0.726 color rgb <0.851, 0.812, 0.741>]
    [0.863 color rgb <0.647, 0.655, 0.655>]
    [0.863 color rgb <0.647, 0.655, 0.655>]
    [1.001 color rgb <0.910, 0.788, 0.788>]
   }  
 }	
#declare Brick_Texture =
 texture {
      pigment {
         Irregular_Bricks_Ptrn (0.01, 1.8, 0.5, 0.1)
         pigment_map {
            [0.01, rgb < 0.1254902,  0.0627451,  0.0 >]
            [0.01, Grain]
         }
      } 
      finish{specular.2 ambient 0}
      normal {
         Irregular_Bricks_Ptrn (0.01, 1.8, 0.5, 0.1) 2
      } 
      scale.27
   } 
#declare Pierre=
 texture{	
		pigment {Grain}
	finish{specular.2 ambient 0}  
	 scale.27
 }	
#declare Rouge=
texture{ 
        pigment{rgb<1,0,0>}  
        finish{phong .2 ambient 0}
        normal{bumps .2 scale .15} 
} 
#declare Vitre=
texture{ 
        pigment {rgbf 1} 
           finish{
           phong .6 phong_size 15
           reflection .55   ambient 0
    } 
    normal{bumps .1 turbulence.8}
}

height_field {     
	png "cap.png"
	smooth  
	water_level  0.01 
	pigment{rgb < 0.854902,  0.8470588,  0.6627451 >} 
	finish{phong .2 ambient 0}
	translate <0,-.1,5> 
	scale <150, 15, 50> 	 
}
#declare Forme=
union{
  difference{
    box{<-6,0,-.5>,<0,6,.5> } 
    box{<-4,-.001,-.5001>,<-1,1,.5001> } 
     box{<-6.1,-.001,-.5001>,<-4,5,.5001> }
    cylinder{<0,0,-.5001>,<0,0,.5001>,1.5
      scale<1,1.5,1>rotate z*30 translate<-3.5,1,0>} 
  }
  cylinder{<0,0,-.5001>,<0,0,.5001>,1.5
    translate<-3.5,4.5,0>} 
    scale<.1,.1,.15>  rotate y*180
}

#declare Borne=
union{
    object{
Round_Box (<-.05,.1,-.2>,<.05,.311,.2>,.01,yes)    }
object{
Round_Cylinder (<0,.3,-.20001>,<0,.3,.20001>,.05,.01,yes) } 
rotate y*90 
}

#declare Ouverture=
union{
    box{<-.05,.1,-.2>,<.05,.3,.2>}
    cylinder{<0,.3,-.201>,<0,.3,.201>,.05} 
    rotate y*90 
  }

union{
union{
cone{y*.3,1.75,y*1.89,1.65}
torus{1.55,.1  translate y*2}
      texture{Pierre}
}
cone{y*2,1.5,y*12.75,1.15 
     texture{Brick_Texture}
}

#declare Radius = 1.15;
#declare Nr = 0;     
#declare EndNr = 24; 
#while (Nr< EndNr)
 object{Forme
        texture{Pierre}
        translate<Radius,12.1,0>
         rotate<0,Nr*360/EndNr,0>}
 #declare Nr=Nr+1;
#end 
union{
cylinder{<0,12.7,0>,<0,12.8,0>,1.8} 
torus{1.8,.03 translate y*12.8}
torus{1.83,.03 translate y*12.83} 
cylinder{<0,12.8,0>,<0,13.06,0>,1.7} 
         texture{Brick_Texture}
}  
difference{
  cylinder{<0,13.05,0>,<0,13.4,0>,1.6}
  cylinder{<0,12.799,0>,<0,13.501,0>,1.5}   
#declare Radius = 1.5;
#declare Nr = 0;     
#declare EndNr = 48; 
#while (Nr< EndNr)
 object{Ouverture
        translate<Radius,13,0>
         rotate<0,Nr*360/EndNr,0>}
 #declare Nr=Nr+1;
#end   
          texture{Pierre}
} 

cylinder{<0,13.39,0>,<0,13.5,0>,1.7 
         texture{Brick_Texture}
}   

#declare Radius = 1.65;
#declare Nr = 0;     
#declare EndNr = 12; 
#while (Nr< EndNr)
 object{Borne texture{Pierre}
        scale <.5,2.8,2.5>
        translate<Radius,12.58,0>
         rotate<0,Nr*360/EndNr,0>}
 #declare Nr=Nr+1;
#end   
union{
cylinder{<0,12.83,0>,<0,14,0>,1}
torus{1,.05 translate y*14} 
torus{1.05,.05 translate y*14.05}
      texture{Brick_Texture}   
}
union{
  cylinder{<0,14,0>,<0,15,0>,.7}

 #declare Radius = .6;
#declare Nr = 0;     
#declare EndNr = 7; 
#while (Nr< EndNr) 
superellipsoid {<.25, .6> scale .12 
        translate<Radius,14.6,0>
         rotate<0,Nr*360/EndNr,0>
         rotate y*25.714}
 #declare Nr=Nr+1;
#end  

//barres vitre
#declare Radius = .7;
#declare Nr = 0;     
#declare EndNr = 7; 
#while (Nr< EndNr) 
cylinder{0,y*1.8,.025 
        translate<Radius,14,0>
         rotate<0,Nr*360/EndNr,0>} 
 #declare Nr=Nr+1;
#end    

  torus{.66,.05   translate y*15.7}
 
  torus{.66,.05   translate y*15.78 }
 
  lathe { cubic_spline
	12,
	<.7,15.5>,
	<.89,16.03>,
	<.83,15.98>,
	<.8,15.82>,
//--------------------
	<.55, 15.82>,
	<.55, 16.1>,
	<.35, 16.3>,
	<.15, 16.4>,
	<.17, 16.5>,
	<.13, 16.65>,  
	<.0, 16.78>,
	<0,17.1>
	sturm.8  
  } 

torus{.88,.025   translate y*16.05} 
    no_reflection   
translate y*-.2  
         texture{Rouge}
}//fin de l'union  
//vitre
difference{
cylinder{<0,14.99,0>,<0,15.7,0>,.7} 
cylinder{<0,14.98,0>,<0,15.8,0>,.69}
translate y*-.2 
    texture{Vitre}
}

//fresnel
union{
  cone{<0,14.95,0>,.25<0,15,0>,.22}  
  cone{<0,15.001,0>,.28<0,15.05,0>,.25} 
  cone{<0,15.051,0>,.31<0,15.1,0>,.28} 
  cone{<0,15.101,0>,.28<0,15.15,0>,.31}
  cone{<0,15.151,0>,.26<0,15.2,0>,.29} 
  intersection{
    sphere{<0,15.27,0>,.28}
    box{<-.29,15.201,-.29>,<.29,15.35,.29>}
  } 
  cone{<0,15.351,0>,.3<0,15.41,0>,.27}
  cone{<0,15.411,0>,.3<0,15.455,0>,.27} 
  cone{<0,15.456,0>,.27<0,15.51,0>,.3}
  cone{<0,15.511,0>,.24<0,15.56,0>,.27} 
  cone{<0,15.561,0>,.21<0,15.61,0>,.24} 
  cone{<0,15.611,0>,.18<0,15.66,0>,.21}
  cone{<0,15.661,0>,.15<0,15.71,0>,.18}
  cone{<0,15.711,0>,.13<0,15.76,0>,.16} 
    translate y*-.2    
         pigment {rgbf 1} 
           finish{
           phong .6 phong_size 15
           reflection 1   ambient 0
    } 
} 
}//fin de phare             