/*
default {
  texture {
    pigment { rgb <1,0,0> }
  }
}


global_settings {
  adc_bailout 0.003922
  ambient_light <1.0,1.0,1.0>
  assumed_gamma 1.8
  hf_gray_16 off
  irid_wavelength <0.25,0.18,0.14>
  max_intersections 64
  max_trace_level 10
  number_of_waves 10
  noise_generator 2
  charset utf8
}

background { color <0.000,0.000,0.000> }

camera {  //  Camera Camera01
  location  <     -8.176,     -15.547,       0.573>
  sky       <    0.00000,     0.00000,     1.00000> // Use right handed-system 
  up        <        0.0,         0.0,         1.0> // Where Z is up
  right     <    1.38192,         0.0,         0.0> // Right Vector is adjusted to compensate for spherical (Moray) vs. planar (POV-Ray) aspect ratio
  angle         54.40000    // Vertical      40.800
  look_at   <      0.276,       0.000,       3.946>
}


light_source {   // Light001
  <0.0, 0.0, 0.0>
  color rgb <1.000, 1.000, 1.000>
  translate  <14.084838, -16.662455, 19.700361>
}
*/

//
// ********  MATERIALS  *******
//

#include "medhouse2.inc"


//
// ********  REFERENCED OBJECTS  *******
//

#declare DoorWinFrame1 = object {
  box { // DoorWinFrame1
    <-1, -1, -1>, <1, 1, 1>
    translate  1.0*z
    photons {
      collect off
    }
    scale <0.01, 0.04, 0.16>
    translate  <-0.15, 0.0, 1.84>
  }
}
#declare DoorWinFrame5 = object {
  box { // DoorWinFrame5
    <-1, -1, -1>, <1, 1, 1>
    translate  1.0*x
    photons {
      collect off
    }
    scale <0.14, 0.04, 0.01>
    translate  <-0.14, 0.0, 1.85>
  }
}
#declare Cube026 = object {
  box { // Cube026
    <-1, -1, -1>, <1, 1, 1>
    translate  <-1.0, 0.0, 1.0>
    photons {
      collect off
    }
    scale <0.02, 0.01, 0.7>
    material {
      T_Wood35
      // Transform to world space
      translate  0.7*x
      translate  <-1.22, 0.15, 0.0>
    }
  }
}
#declare Cube051 = object {
  box { // Cube051
    <-1, -1, -1>, <1, 1, 1>
    translate  <0.0, -1.0, 2.0>
    photons {
      collect off
    }
    scale <0.01, 0.6, 0.02>
    translate  -0.75*x
    material {
      T_Wood35
      // Transform to world space
      translate  -1.4*z
      rotate -25.0*x
      translate  <-1.22, 0.15, 0.0>
    }
  }
}
#declare Cube068 = object {
  box { // Cube068
    <-1, -1, -1>, <1, 1, 1>
    translate  <0.0, -1.0, 1.0>
    photons {
      collect off
    }
    scale <0.01, 0.02, 0.47>
    translate  <-0.75, -0.98, 0.0>
    material {
      T_Wood35
      // Transform to world space
      translate  <-1.22, 0.15, 0.0>
    }
  }
}
#declare Floor1_WallElement1 = object {
  box { // Floor1_WallElement1
    <-1, -1, -1>, <1, 1, 1>
    translate  <0.0, -1.0, 1.0>
    photons {
      collect off
    }
    scale <0.02, 0.09, 1.5>
    translate  <-1.95, 0.0, 3.0>
    material {
      T_Wood7
      // Transform to world space
      translate  0.5*y
    }
  }
}
#declare LintelBeam1 = object {
  box { // LintelBeam1
    <-1, -1, -1>, <1, 1, 1>
    photons {
      collect off
    }
    scale <0.08, 5.0, 0.08>
    translate  <-1.9, 4.35, 2.82>
    material {
      DMFWood4HorBeam
      // Transform to world space
    }
  }
}
#declare LintelBeam7 = object {
  box { // LintelBeam7
    <-1, -1, -1>, <1, 1, 1>
    translate  <0.0, 1.0, -1.0>
    material {
      DMFWood4Hor
    }
    photons {
      collect off
    }
    scale <0.08, 4.9, 0.08>
    translate  <-1.9, -0.5, 5.5>
  }
}
#declare Floor2_WallElement1 = object {
  box { // Floor2_WallElement1
    <-1, -1, -1>, <1, 1, 1>
    translate  <0.0, -1.0, 1.0>
    photons {
      collect off
    }
    scale <0.02, 0.09, 2.14>
    translate  <-1.9, 0.0, 6.0>
    material {
      T_Wood7
      // Transform to world space
      translate  0.5*y
    }
  }
}
#declare LintelBeam13 = object {
  box { // LintelBeam13
    <-1, -1, -1>, <1, 1, 1>
    translate  <0.0, 1.0, -1.0>
    material {
      DMFWood4Hor
    }
    photons {
      collect off
    }
    scale <0.05, 4.9, 0.05>
    translate  <-1.2, -0.5, 7.45>
  }
}
#declare CSG030 = difference {
  box { // Cube093
    <-1, -1, -1>, <1, 1, 1>
    translate  <-1.0, 1.0, 1.0>
    photons {
      collect off
    }
    scale <0.24, 1.0, 1.0>
    translate  0.01*x
  }
  box { // Cube094
    <-1, -1, -1>, <1, 1, 1>
    translate  <-1.0, 1.0, 1.0>
    photons {
      collect off
    }
    scale <0.6, 1.01, 0.3>
    rotate -60.0*y
    translate  <0.0, -0.01, 2.0>
  }
  photons {
    collect off
  }
}
#declare CSG029 = union {
  box { // Cube086
    <-1, -1, -1>, <1, 1, 1>
    translate  <-1.0, 1.0, 1.0>
    photons {
      collect off
    }
    scale <0.25, 1.0, 1.0>
  }
  box { // Cube087
    <-1, -1, -1>, <1, 1, 1>
    translate  <-1.0, 1.0, -1.0>
    photons {
      collect off
    }
    scale <0.05, 0.99, 0.1>
    translate  <0.01, 0.01, 2.0>
  }
  photons {
    collect off
  }
}
#declare Gable1 = difference {
  object { CSG029 }
  box { // Cube088
    <-1, -1, -1>, <1, 1, 1>
    translate  <-1.0, 1.0, 1.0>
    photons {
      collect off
    }
    scale <0.6, 1.01, 0.3>
    rotate -60.0*y
    translate  <0.0, -0.01, 2.0>
  }
  box { // Cube089
    <-1, -1, -1>, <1, 1, 1>
    translate  <-0.99, 1.0, 1.0>
    photons {
      collect off
    }
    scale <0.151, 0.1, 0.375>
    translate  <0.0, -0.03, 0.05>
  }
  cylinder { // Cylndr137
    <0,0,1>, <0,0,0>, 1 
    photons {
      collect off
    }
    scale <0.15, 0.2, 0.15>
    rotate -90.0*x
    translate  <-0.15, -0.01, 0.8>
  }
  box { // Cube090
    <-1, -1, -1>, <1, 1, 1>
    translate  <0.0, 1.0, 1.0>
    photons {
      collect off
    }
    scale <0.18, 0.08, 0.15>
    rotate 20.0*y
    translate  <0.0, -0.01, 0.8>
  }
  cylinder { // Cylndr138
    <0,0,1>, <0,0,0>, 1 
    photons {
      collect off
    }
    scale <0.15, 0.2, 0.15>
    rotate -90.0*x
    translate  <0.0, -0.01, 1.2>
  }
  box { // Cube091
    <-1, -1, -1>, <1, 1, 1>
    translate  <-1.0, 1.0, 1.0>
    photons {
      collect off
    }
    scale <0.23, 1.0, 0.905>
    translate  <0.01, 0.05, -0.01>
  }
  box { // Cube092
    <-1, -1, -1>, <1, 1, 1>
    translate  <-1.0, 1.0, 1.0>
    photons {
      collect off
    }
    scale <0.13, 1.0, 0.18>
    translate  <-0.09, 0.05, 1.599>
  }
  photons {
    collect off
  }
}
#declare CSG033 = difference {
  box { // Cube102
    <-1, -1, -1>, <1, 1, 1>
    translate  <-1.0, 1.0, 1.0>
    photons {
      collect off
    }
    scale <0.24, 1.0, 1.0>
    translate  0.01*x
  }
  box { // Cube103
    <-1, -1, -1>, <1, 1, 1>
    translate  <-1.0, 1.0, 1.0>
    photons {
      collect off
    }
    scale <0.6, 1.01, 0.3>
    rotate -60.0*y
    translate  <0.0, -0.01, 2.0>
  }
  photons {
    collect off
  }
}
#declare CSG032 = union {
  box { // Cube095
    <-1, -1, -1>, <1, 1, 1>
    translate  <-1.0, 1.0, 1.0>
    photons {
      collect off
    }
    scale <0.25, 1.0, 1.0>
  }
  box { // Cube096
    <-1, -1, -1>, <1, 1, 1>
    translate  <-1.0, 1.0, -1.0>
    photons {
      collect off
    }
    scale <0.05, 0.99, 0.1>
    translate  <0.01, 0.01, 2.0>
  }
  photons {
    collect off
  }
}
#declare Gable3 = difference {
  object { CSG032 }
  box { // Cube097
    <-1, -1, -1>, <1, 1, 1>
    translate  <-1.0, 1.0, 1.0>
    photons {
      collect off
    }
    scale <0.6, 1.01, 0.3>
    rotate -60.0*y
    translate  <0.0, -0.01, 2.0>
  }
  box { // Cube098
    <-1, -1, -1>, <1, 1, 1>
    translate  <-0.99, 1.0, 1.0>
    photons {
      collect off
    }
    scale <0.151, 0.08, 0.375>
    translate  <0.0, -0.01, 0.05>
  }
  cylinder { // Cylndr140
    <0,0,1>, <0,0,0>, 1 
    photons {
      collect off
    }
    scale <0.15, 0.2, 0.15>
    rotate -90.0*x
    translate  <-0.15, -0.01, 0.8>
  }
  box { // Cube099
    <-1, -1, -1>, <1, 1, 1>
    translate  <0.0, 1.0, 1.0>
    photons {
      collect off
    }
    scale <0.18, 0.08, 0.15>
    rotate 20.0*y
    translate  <0.0, -0.01, 0.8>
  }
  cylinder { // Cylndr141
    <0,0,1>, <0,0,0>, 1 
    photons {
      collect off
    }
    scale <0.15, 0.2, 0.15>
    rotate -90.0*x
    translate  <0.0, -0.01, 1.2>
  }
  box { // Cube100
    <-1, -1, -1>, <1, 1, 1>
    translate  <-1.0, 1.0, 1.0>
    photons {
      collect off
    }
    scale <0.23, 1.0, 0.905>
    translate  <0.01, 0.05, -0.01>
  }
  box { // Cube101
    <-1, -1, -1>, <1, 1, 1>
    translate  <-1.0, 1.0, 1.0>
    photons {
      collect off
    }
    scale <0.13, 1.0, 0.18>
    translate  <-0.09, 0.05, 1.599>
  }
  photons {
    collect off
  }
  material {
    T_Wood7
    // Transform to parent space
  }
}
#declare Glass1 = difference {
  box { // Cube010
    <-1, -1, -1>, <1, 1, 1>
    translate  -1.0*z
    photons {
      collect off
    }
    scale <0.005, 0.48, 0.47>
    rotate -10.0*y
  }
  box { // Cube011
    <-1, -1, -1>, <1, 1, 1>
    translate  <0.0, 1.0, -1.0>
    photons {
      collect off
    }
    scale <0.01, 0.1, 0.49>
    rotate <-10.0, -10.0, 0.0>
    translate  <0.0, 0.48, 0.01>
  }
  box { // Cube012
    <-1, -1, -1>, <1, 1, 1>
    translate  <0.0, -1.0, -1.0>
    photons {
      collect off
    }
    scale <0.01, 0.1, 0.49>
    rotate <10.0, -10.0, 0.0>
    translate  <0.0, -0.48, 0.01>
  }
  photons {
    collect off
  }
  translate  <-0.48, 0.0, -0.57>
}




//
// ********  OBJECTS  *******
//



#declare GroundFloor_Dif = difference {
  box { // GroundFloor
    <-1, -1, -1>, <1, 1, 1>
    photons {
      collect off
    }
    scale <2.0, 0.15, 1.5>
    translate  1.5*z
  }
  box { // GroundFloor_Door
    <-1, -1, -1>, <1, 1, 1>
    translate  1.0*z
    photons {
      collect off
    }
    scale <0.4, 0.2, 0.95>
    translate  0.58*z
  }
  box { // GroundFloor_Window1
    <-1, -1, -1>, <1, 1, 1>
    translate  1.0*z
    photons {
      collect off
    }
    scale <0.38, 0.2, 0.575>
    translate  <-1.2, 0.0, 1.25>
  }
  box { // GroundFloor_Window2
    <-1, -1, -1>, <1, 1, 1>
    translate  1.0*z
    photons {
      collect off
    }
    scale <0.38, 0.2, 0.44>
    translate  <1.2, 0.0, 1.55>
  }
  photons {
    collect off
  }
  material {
    BrickWall
    // Transform to world space
  }
}
#declare DoorHandle = union {
  box { // Cube013
    <-1, -1, -1>, <1, 1, 1>
    translate  1.0*z
    photons {
      collect off
    }
    scale <0.04, 0.04, 0.15>
    translate  <0.3, 0.0, 0.7>
  }
  cylinder { // Cylndr028
    <0,0,1>, <0,0,0>, 1 
    translate  -0.5*z
    photons {
      collect off
    }
    scale <0.008, 0.008, 0.15>
    rotate -90.0*x
    translate  <0.3, 0.0, 0.9>
  }
  sphere { // Sphere003
    <0,0,0>,1
    photons {
      collect off
    }
    scale <0.03, 0.01, 0.05>
    translate  <0.3, -0.08, 0.9>
  }
  sphere { // Sphere004
    <0,0,0>,1
    photons {
      collect off
    }
    scale <0.03, 0.01, 0.05>
    translate  <0.3, 0.08, 0.9>
  }
  photons {
    collect off
  }
  // All transformations fixed
  translate  -0.1*z
  material {
    Brass_Metal
    // Transform to world space
    translate  <0.38, 0.0, -0.6>
    translate  -0.38*x
    translate  -0.38*x
  }
}
#declare CSG015 = union {
  cylinder { // Cylndr080
    <0,0,1>, <0,0,0>, 1 
    photons {
      collect off
    }
    // All transformations fixed
    scale 0.04
    rotate 90.0*x
    translate  <0.01, 0.0, 0.24>
  }
  cylinder { // Cylndr081
    <0,0,1>, <0,0,0>, 1 
    photons {
      collect off
    }
    // All transformations fixed
    scale 0.04
    rotate 90.0*x
    translate  <0.01, 0.0, 0.16>
  }
  photons {
    collect off
  }
  // All transformations fixed
}
#declare HingeDif11 = difference {
  object { CSG015 }
  cylinder { // Cylndr082
    <0,0,1>, <0,0,0>, 1 
    photons {
      collect off
    }
    // All transformations fixed
    scale <0.04, 0.04, 0.042>
    rotate 90.0*x
    translate  <-0.02, 0.0, 0.26>
  }
  cylinder { // Cylndr083
    <0,0,1>, <0,0,0>, 1 
    photons {
      collect off
    }
    // All transformations fixed
    scale <0.04, 0.04, 0.042>
    rotate 90.0*x
    translate  <-0.02, 0.0, 0.14>
  }
  photons {
    collect off
  }
  // All transformations fixed
}
#declare ShutterHinge11 = union {
  box { // ShutterHingeIron11
    <-1, -1, -1>, <1, 1, 1>
    translate  <1.0, -1.0, 0.0>
    photons {
      collect off
    }
    // All transformations fixed
    scale <0.2, 0.02, 0.02>
    translate  <-0.39, 0.0, 0.2>
  }
  object { HingeDif11 }
  photons {
    collect off
  }
  // All transformations fixed
  translate  -0.01*y
  material {
    New_Brass
    // Transform to world space
    translate  <0.38, 0.0, -0.6>
    translate  -0.38*x
    translate  -0.38*x
  }
}
#declare CSG016 = union {
  cylinder { // Cylndr084
    <0,0,1>, <0,0,0>, 1 
    photons {
      collect off
    }
    // All transformations fixed
    scale 0.04
    rotate 90.0*x
    translate  <0.01, 0.0, 0.24>
  }
  cylinder { // Cylndr085
    <0,0,1>, <0,0,0>, 1 
    photons {
      collect off
    }
    // All transformations fixed
    scale 0.04
    rotate 90.0*x
    translate  <0.01, 0.0, 0.16>
  }
  photons {
    collect off
  }
  // All transformations fixed
}
#declare HingeDif12 = difference {
  object { CSG016 }
  cylinder { // Cylndr086
    <0,0,1>, <0,0,0>, 1 
    photons {
      collect off
    }
    // All transformations fixed
    scale <0.04, 0.04, 0.042>
    rotate 90.0*x
    translate  <-0.02, 0.0, 0.26>
  }
  cylinder { // Cylndr087
    <0,0,1>, <0,0,0>, 1 
    photons {
      collect off
    }
    // All transformations fixed
    scale <0.04, 0.04, 0.042>
    rotate 90.0*x
    translate  <-0.02, 0.0, 0.14>
  }
  photons {
    collect off
  }
  // All transformations fixed
}
#declare ShutterHinge12 = union {
  box { // ShutterHingeIron12
    <-1, -1, -1>, <1, 1, 1>
    translate  <1.0, -1.0, 0.0>
    photons {
      collect off
    }
    // All transformations fixed
    scale <0.2, 0.02, 0.02>
    translate  <-0.39, 0.0, 0.2>
  }
  object { HingeDif12 }
  photons {
    collect off
  }
  translate  <0.0, -0.01, 0.56>
  material {
    New_Brass
    // Transform to world space
    translate  <0.38, 0.0, -0.6>
    translate  -0.38*x
    translate  -0.38*x
  }
}
#declare EntranceDoorLower = union {
  box { // Door
    <-1, -1, -1>, <1, 1, 1>
    rotate <-0.0, -0.0, 0.0>
    translate  1.0*z
    photons {
      collect off
    }
    // All transformations fixed
    scale <0.385, 0.03, 0.5>
  }
  object { DoorHandle }
  object { ShutterHinge11 }
  object { ShutterHinge12 }
  translate  0.38*x
  photons {
    collect off
  }
  // Scaling fixed
  // Rot Z limited (-90.0 to   90.0)
  // Translation fixed
  translate  <-0.38, 0.0, 0.6>
  material {
    T_Wood7
    // Transform to world space
  }
}
#declare DoorDif1 = difference {
  box { // Door2
    <-1, -1, -1>, <1, 1, 1>
    rotate <-0.0, -0.0, 0.0>
    translate  1.0*z
    photons {
      collect off
    }
    scale <0.385, 0.03, 0.435>
    translate  1.6*z
  }
  box { // Door3
    <-1, -1, -1>, <1, 1, 1>
    translate  1.0*z
    photons {
      collect off
    }
    scale <0.15, 0.04, 0.15>
    translate  1.85*z
  }
  translate  <0.385158, 0.0, -0.104865>
  photons {
    collect off
  }
  // All transformations fixed
  translate  <-0.385158, 0.0, 0.1048>
}
#declare CSG017 = union {
  cylinder { // Cylndr088
    <0,0,1>, <0,0,0>, 1 
    photons {
      collect off
    }
    // All transformations fixed
    scale 0.04
    rotate 90.0*x
    translate  <0.01, 0.0, 0.24>
  }
  cylinder { // Cylndr089
    <0,0,1>, <0,0,0>, 1 
    photons {
      collect off
    }
    // All transformations fixed
    scale 0.04
    rotate 90.0*x
    translate  <0.01, 0.0, 0.16>
  }
  photons {
    collect off
  }
  // All transformations fixed
}
#declare HingeDif13 = difference {
  object { CSG017 }
  cylinder { // Cylndr090
    <0,0,1>, <0,0,0>, 1 
    photons {
      collect off
    }
    // All transformations fixed
    scale <0.04, 0.04, 0.042>
    rotate 90.0*x
    translate  <-0.02, 0.0, 0.26>
  }
  cylinder { // Cylndr091
    <0,0,1>, <0,0,0>, 1 
    photons {
      collect off
    }
    // All transformations fixed
    scale <0.04, 0.04, 0.042>
    rotate 90.0*x
    translate  <-0.02, 0.0, 0.14>
  }
  photons {
    collect off
  }
  // All transformations fixed
}
#declare ShutterHinge13 = union {
  box { // ShutterHingeIron13
    <-1, -1, -1>, <1, 1, 1>
    translate  <1.0, -1.0, 0.0>
    photons {
      collect off
    }
    // All transformations fixed
    scale <0.2, 0.02, 0.02>
    translate  <-0.39, 0.0, 0.2>
  }
  object { HingeDif13 }
  photons {
    collect off
  }
  // All transformations fixed
  translate  <0.0, -0.01, 1.52>
  material {
    New_Brass
    // Transform to world space
    translate  0.38*x
    rotate 12.088876*z
    translate  -0.38*x
    translate  -0.38*x
  }
}
#declare CSG018 = union {
  cylinder { // Cylndr092
    <0,0,1>, <0,0,0>, 1 
    photons {
      collect off
    }
    // All transformations fixed
    scale 0.04
    rotate 90.0*x
    translate  <0.01, 0.0, 0.24>
  }
  cylinder { // Cylndr093
    <0,0,1>, <0,0,0>, 1 
    photons {
      collect off
    }
    // All transformations fixed
    scale 0.04
    rotate 90.0*x
    translate  <0.01, 0.0, 0.16>
  }
  photons {
    collect off
  }
  // All transformations fixed
}
#declare HingeDif14 = difference {
  object { CSG018 }
  cylinder { // Cylndr094
    <0,0,1>, <0,0,0>, 1 
    photons {
      collect off
    }
    // All transformations fixed
    scale <0.04, 0.04, 0.042>
    rotate 90.0*x
    translate  <-0.02, 0.0, 0.26>
  }
  cylinder { // Cylndr095
    <0,0,1>, <0,0,0>, 1 
    photons {
      collect off
    }
    // All transformations fixed
    scale <0.04, 0.04, 0.042>
    rotate 90.0*x
    translate  <-0.02, 0.0, 0.14>
  }
  photons {
    collect off
  }
  // All transformations fixed
}
#declare ShutterHinge14 = union {
  box { // ShutterHingeIron14
    <-1, -1, -1>, <1, 1, 1>
    translate  <1.0, -1.0, 0.0>
    photons {
      collect off
    }
    // All transformations fixed
    scale <0.2, 0.02, 0.02>
    translate  <-0.39, 0.0, 0.2>
  }
  object { HingeDif14 }
  photons {
    collect off
  }
  // All transformations fixed
  translate  <0.0, -0.01, 2.12>
  material {
    New_Brass
    // Transform to world space
    translate  0.38*x
    rotate 12.088876*z
    translate  -0.38*x
    translate  -0.38*x
  }
}
#declare DoorWinFrame = union {
  object { DoorWinFrame1 }
  object { // DoorWinFrame2 -> DoorWinFrame1
    DoorWinFrame1
    photons {
      collect off
    }
    rotate -0.0*y
    translate  0.1*x
  }
  object { // DoorWinFrame3 -> DoorWinFrame1
    DoorWinFrame1
    photons {
      collect off
    }
    rotate -0.0*y
    translate  0.2*x
  }
  object { // DoorWinFrame4 -> DoorWinFrame1
    DoorWinFrame1
    photons {
      collect off
    }
    rotate -0.0*y
    translate  0.3*x
  }
  object { DoorWinFrame5 }
  object { // DoorWinFrame6 -> DoorWinFrame5
    DoorWinFrame5
    photons {
      collect off
    }
    translate  0.1*z
  }
  object { // DoorWinFrame7 -> DoorWinFrame5
    DoorWinFrame5
    photons {
      collect off
    }
    translate  0.2*z
  }
  object { // DoorWinFrame8 -> DoorWinFrame5
    DoorWinFrame5
    photons {
      collect off
    }
    translate  0.3*z
  }
  photons {
    collect off
  }
  material {
    T_Wood35
    // Transform to world space
    translate  0.38*x
    rotate 12.088876*z
    translate  -0.38*x
    translate  -0.38*x
  }
}
#declare DoorRidge = difference {
  box { // Ridge1
    <-1, -1, -1>, <1, 1, 1>
    translate  <0.0, -1.0, 1.0>
    photons {
      collect off
    }
    scale <0.385, 0.025, 0.01>
    translate  1.6*z
  }
  cylinder { // Ridge2
    <0,0,1>, <0,0,0>, 1 
    translate  -0.5*z
    photons {
      collect off
    }
    scale <0.01, 0.02, 0.775>
    rotate -90.0*y
    translate  <0.0, -0.05, 1.62>
  }
  photons {
    collect off
  }
}
#declare EntranceDoorUpper = union {
  object { DoorDif1 }
  box { // GroundFloor_DoorPane1
    <-1, -1, -1>, <1, 1, 1>
    translate  1.0*z
    photons {
      collect off
    }
    // All transformations fixed
    scale <0.155, 0.001, 0.155>
    translate  1.845*z
    material {
      WindowGlass
      // Transform to world space
      translate  0.38*x
      rotate 12.088876*z
      translate  -0.38*x
      translate  -0.38*x
    }
  }
  object { ShutterHinge13 }
  object { ShutterHinge14 }
  object { DoorWinFrame }
  object { DoorRidge }
  translate  0.38*x
  photons {
    collect off
  }
  // Scaling fixed
  // Rot Z limited (-90.0 to   90.0)
  // Translation fixed
  rotate -12.088876*z
  translate  -0.38*x
  material {
    T_Wood7
    // Transform to world space
  }
}
#declare Steps = union {
  box { // Step1
    <-1, -1, -1>, <1, 1, 1>
    translate  <0.0, -1.0, 1.0>
    photons {
      collect off
    }
    scale <0.5, 0.5, 0.1>
    translate  -0.1*z
  }
  box { // Step2
    <-1, -1, -1>, <1, 1, 1>
    translate  <0.0, -1.0, 1.0>
    photons {
      collect off
    }
    scale <0.5, 0.4, 0.05>
    translate  0.1*z
  }
  box { // Step3
    <-1, -1, -1>, <1, 1, 1>
    translate  <0.0, -1.0, 1.0>
    photons {
      collect off
    }
    scale <0.5, 0.3, 0.05>
    translate  0.2*z
  }
  box { // Step4
    <-1, -1, -1>, <1, 1, 1>
    translate  <0.0, -1.0, 1.0>
    photons {
      collect off
    }
    scale <0.5, 0.2, 0.05>
    translate  0.3*z
  }
  box { // Step5
    <-1, -1, -1>, <1, 1, 1>
    translate  <0.0, -1.0, 1.0>
    photons {
      collect off
    }
    scale <0.5, 0.1, 0.05>
    translate  0.4*z
  }
  cylinder { // StepEmbossing1
    <0,0,1>, <0,0,0>, 1 
    translate  -0.5*z
    photons {
      collect off
    }
    scale <0.02, 0.02, 1.0>
    rotate -90.0*y
    translate  <0.0, -1.0, 0.08>
  }
  cylinder { // StepEmbossing2
    <0,0,1>, <0,0,0>, 1 
    translate  -0.5*z
    photons {
      collect off
    }
    scale <0.02, 0.02, 1.0>
    rotate -90.0*y
    translate  <0.0, -0.8, 0.18>
  }
  cylinder { // StepEmbossing3
    <0,0,1>, <0,0,0>, 1 
    translate  -0.5*z
    photons {
      collect off
    }
    scale <0.02, 0.02, 1.0>
    rotate -90.0*y
    translate  <0.0, -0.6, 0.28>
  }
  cylinder { // StepEmbossing4
    <0,0,1>, <0,0,0>, 1 
    translate  -0.5*z
    photons {
      collect off
    }
    scale <0.02, 0.02, 1.0>
    rotate -90.0*y
    translate  <0.0, -0.4, 0.38>
  }
  cylinder { // StepEmbossing5
    <0,0,1>, <0,0,0>, 1 
    translate  -0.5*z
    photons {
      collect off
    }
    scale <0.02, 0.02, 1.0>
    rotate -90.0*y
    translate  <0.0, -0.2, 0.48>
  }
  photons {
    collect off
  }
  translate  <-0.04, -0.15, 0.0>
  material {
    AberGraniteGR
    // Transform to world space
  }
}
#declare Group_GroundFloorDoor = union {
  box { // GroundFloor_DoorSill
    <-1, -1, -1>, <1, 1, 1>
    translate  1.0*z
    photons {
      collect off
    }
    scale <0.42, 0.2, 0.03>
    translate  0.54*z
    material {
      DMFWood4Hor
      // Transform to world space
    }
  }
  box { // GroundFloor_DoorVert1
    <-1, -1, -1>, <1, 1, 1>
    translate  <1.0, 0.0, 1.0>
    photons {
      collect off
    }
    scale <0.015, 0.1, 0.935>
    translate  <-0.42, 0.0, 0.6>
    material {
      DMFWood4Ver
      // Transform to world space
    }
  }
  box { // GroundFloor_DoorVert2
    <-1, -1, -1>, <1, 1, 1>
    translate  <-1.0, 0.0, 1.0>
    photons {
      collect off
    }
    scale <0.015, 0.1, 0.935>
    translate  <0.42, 0.0, 0.6>
    material {
      DMFWood4Ver
      // Transform to world space
    }
  }
  box { // GroundFloor_DoorUpper
    <-1, -1, -1>, <1, 1, 1>
    translate  -1.0*z
    photons {
      collect off
    }
    scale <0.42, 0.1, 0.015>
    translate  2.5*z
    material {
      DMFWood4Hor
      // Transform to world space
    }
  }
  object { EntranceDoorLower }
  object { EntranceDoorUpper }
  object { Steps }
  photons {
    collect off
  }
}
#declare Window0_1_1 = union {
  box { // Win1Vert17
    <-1, -1, -1>, <1, 1, 1>
    translate  <1.0, 0.0, 1.0>
    photons {
      collect off
    }
    // All transformations fixed
    scale <0.015, 0.025, 0.4>
    translate  <-1.4, -0.5, 4.0>
    material {
      DMFWood4Ver
      // Transform to world space
      translate  <1.55, 0.0, 2.7>
      translate  <-1.4, -0.5, 0.0>
      rotate 0.0*z rotate 0.0*y rotate 0.0*x
      translate  <-1.4, -0.5, 0.0>
      rotate 0.0*z rotate 0.0*y rotate 0.0*x
    }
  }
  box { // Win1Vert18
    <-1, -1, -1>, <1, 1, 1>
    translate  <-1.0, 0.0, 1.0>
    photons {
      collect off
    }
    // All transformations fixed
    scale <0.015, 0.025, 0.4>
    translate  <-1.05, -0.5, 4.0>
    material {
      DMFWood4Ver
      // Transform to world space
      translate  <1.55, 0.0, 2.7>
      translate  <-1.4, -0.5, 0.0>
      rotate 0.0*z rotate 0.0*y rotate 0.0*x
      translate  <-1.4, -0.5, 0.0>
      rotate 0.0*z rotate 0.0*y rotate 0.0*x
    }
  }
  box { // Win1Hor27
    <-1, -1, -1>, <1, 1, 1>
    translate  -1.0*z
    photons {
      collect off
    }
    // All transformations fixed
    scale <0.15, 0.025, 0.015>
    translate  <-1.22, -0.5, 4.8>
    material {
      DMFWood4Hor
      // Transform to world space
      translate  <1.55, 0.0, 2.7>
      translate  <-1.4, -0.5, 0.0>
      rotate 0.0*z rotate 0.0*y rotate 0.0*x
      translate  <-1.4, -0.5, 0.0>
      rotate 0.0*z rotate 0.0*y rotate 0.0*x
    }
  }
  box { // Win1Hor28
    <-1, -1, -1>, <1, 1, 1>
    translate  1.0*z
    photons {
      collect off
    }
    // All transformations fixed
    scale <0.15, 0.025, 0.015>
    translate  <-1.22, -0.5, 4.0>
    material {
      DMFWood4Hor
      // Transform to world space
      translate  <1.55, 0.0, 2.7>
      translate  <-1.4, -0.5, 0.0>
      rotate 0.0*z rotate 0.0*y rotate 0.0*x
      translate  <-1.4, -0.5, 0.0>
      rotate 0.0*z rotate 0.0*y rotate 0.0*x
    }
  }
  box { // Win1Pane9
    <-1, -1, -1>, <1, 1, 1>
    translate  1.0*z
    photons {
      collect off
    }
    // All transformations fixed
    scale <0.165, 0.001, 0.385>
    translate  <-1.22, -0.5, 4.015>
    material {
      WindowGlass
      // Transform to world space
      translate  <1.55, 0.0, 2.7>
      translate  <-1.4, -0.5, 0.0>
      rotate 0.0*z rotate 0.0*y rotate 0.0*x
      translate  <-1.4, -0.5, 0.0>
      rotate 0.0*z rotate 0.0*y rotate 0.0*x
    }
  }
  box { // Win1Hor29
    <-1, -1, -1>, <1, 1, 1>
    translate  1.0*z
    photons {
      collect off
    }
    // All transformations fixed
    scale <0.15, 0.025, 0.015>
    translate  <-1.22, -0.5, 4.4>
    material {
      DMFWood4Hor
      // Transform to world space
      translate  <1.55, 0.0, 2.7>
      translate  <-1.4, -0.5, 0.0>
      rotate 0.0*z rotate 0.0*y rotate 0.0*x
      translate  <-1.4, -0.5, 0.0>
      rotate 0.0*z rotate 0.0*y rotate 0.0*x
    }
  }
  rotate <-0.0, -0.0, -0.0>
  translate  <1.4, 0.5, 0.0>
  photons {
    collect off
  }
  // Scaling fixed
  // Rot Z limited (0.0 to   90.0)
  // Translation fixed
  translate  <-1.55, 0.0, -2.7>
}
#declare Window0_1_2 = union {
  box { // Win1Vert19
    <-1, -1, -1>, <1, 1, 1>
    translate  <1.0, 0.0, 1.0>
    photons {
      collect off
    }
    // All transformations fixed
    scale <0.015, 0.025, 0.4>
    translate  <-1.39, -0.5, 4.0>
    material {
      DMFWood4Ver
      // Transform to world space
      translate  <0.85, 0.0, 2.7>
      translate  <-1.04, -0.5, 0.0>
      rotate 0.0*z rotate 0.0*y rotate 0.0*x
      translate  <-1.04, -0.5, 0.0>
      rotate 0.0*z rotate 0.0*y rotate 0.0*x
    }
  }
  box { // Win1Vert20
    <-1, -1, -1>, <1, 1, 1>
    translate  <-1.0, 0.0, 1.0>
    photons {
      collect off
    }
    // All transformations fixed
    scale <0.015, 0.025, 0.4>
    translate  <-1.04, -0.5, 4.0>
    material {
      DMFWood4Ver
      // Transform to world space
      translate  <0.85, 0.0, 2.7>
      translate  <-1.04, -0.5, 0.0>
      rotate 0.0*z rotate 0.0*y rotate 0.0*x
      translate  <-1.04, -0.5, 0.0>
      rotate 0.0*z rotate 0.0*y rotate 0.0*x
    }
  }
  box { // Win1Hor30
    <-1, -1, -1>, <1, 1, 1>
    translate  -1.0*z
    photons {
      collect off
    }
    // All transformations fixed
    scale <0.15, 0.025, 0.015>
    translate  <-1.22, -0.5, 4.8>
    material {
      DMFWood4Hor
      // Transform to world space
      translate  <0.85, 0.0, 2.7>
      translate  <-1.04, -0.5, 0.0>
      rotate 0.0*z rotate 0.0*y rotate 0.0*x
      translate  <-1.04, -0.5, 0.0>
      rotate 0.0*z rotate 0.0*y rotate 0.0*x
    }
  }
  box { // Win1Hor31
    <-1, -1, -1>, <1, 1, 1>
    translate  1.0*z
    photons {
      collect off
    }
    // All transformations fixed
    scale <0.15, 0.025, 0.015>
    translate  <-1.22, -0.5, 4.0>
    material {
      DMFWood4Hor
      // Transform to world space
      translate  <0.85, 0.0, 2.7>
      translate  <-1.04, -0.5, 0.0>
      rotate 0.0*z rotate 0.0*y rotate 0.0*x
      translate  <-1.04, -0.5, 0.0>
      rotate 0.0*z rotate 0.0*y rotate 0.0*x
    }
  }
  box { // Win1Pane10
    <-1, -1, -1>, <1, 1, 1>
    translate  1.0*z
    photons {
      collect off
    }
    // All transformations fixed
    scale <0.165, 0.001, 0.385>
    translate  <-1.22, -0.5, 4.015>
    material {
      WindowGlass
      // Transform to world space
      translate  <0.85, 0.0, 2.7>
      translate  <-1.04, -0.5, 0.0>
      rotate 0.0*z rotate 0.0*y rotate 0.0*x
      translate  <-1.04, -0.5, 0.0>
      rotate 0.0*z rotate 0.0*y rotate 0.0*x
    }
  }
  box { // Win1Hor32
    <-1, -1, -1>, <1, 1, 1>
    translate  1.0*z
    photons {
      collect off
    }
    // All transformations fixed
    scale <0.15, 0.025, 0.015>
    translate  <-1.22, -0.5, 4.4>
    material {
      DMFWood4Hor
      // Transform to world space
      translate  <0.85, 0.0, 2.7>
      translate  <-1.04, -0.5, 0.0>
      rotate 0.0*z rotate 0.0*y rotate 0.0*x
      translate  <-1.04, -0.5, 0.0>
      rotate 0.0*z rotate 0.0*y rotate 0.0*x
    }
  }
  rotate <-0.0, -0.0, 0.0>
  translate  <1.04, 0.5, 0.0>
  photons {
    collect off
  }
  // Scaling fixed
  // Rot Z limited (-90.0 to   0.0)
  // Translation fixed
  translate  <-0.85, 0.0, -2.7>
}
#declare CSG019 = union {
  cylinder { // Cylndr096
    <0,0,1>, <0,0,0>, 1 
    photons {
      collect off
    }
    // All transformations fixed
    scale 0.02
    rotate 90.0*x
    translate  <-1.48, -0.65, 4.22>
  }
  cylinder { // Cylndr097
    <0,0,1>, <0,0,0>, 1 
    photons {
      collect off
    }
    // All transformations fixed
    scale 0.02
    rotate 90.0*x
    translate  <-1.48, -0.65, 4.18>
  }
  photons {
    collect off
  }
  // All transformations fixed
}
#declare HingeDif15 = difference {
  object { CSG019 }
  cylinder { // Cylndr098
    <0,0,1>, <0,0,0>, 1 
    photons {
      collect off
    }
    // All transformations fixed
    scale <0.02, 0.02, 0.021>
    rotate 90.0*x
    translate  <-1.495, -0.65, 4.23>
  }
  cylinder { // Cylndr099
    <0,0,1>, <0,0,0>, 1 
    photons {
      collect off
    }
    // All transformations fixed
    scale <0.02, 0.02, 0.021>
    rotate 90.0*x
    translate  <-1.495, -0.65, 4.17>
  }
  photons {
    collect off
  }
  // All transformations fixed
}
#declare ShutterHinge15 = union {
  box { // ShutterHingeIron15
    <-1, -1, -1>, <1, 1, 1>
    translate  <1.0, -1.0, 0.0>
    photons {
      collect off
    }
    // All transformations fixed
    scale <0.1, 0.01, 0.01>
    translate  <-1.68, -0.65, 4.2>
  }
  object { HingeDif15 }
  photons {
    collect off
  }
  // All transformations fixed
  material {
    New_Brass
    // Transform to world space
    translate  <1.55, 0.05, 2.7>
    rotate 13.481627*z
    translate  <-1.68, -0.65, 0.0>
    translate  <-1.68, -0.65, 0.0>
  }
}
#declare CSG020 = union {
  cylinder { // Cylndr100
    <0,0,1>, <0,0,0>, 1 
    photons {
      collect off
    }
    // All transformations fixed
    scale 0.02
    rotate 90.0*x
    translate  <-1.48, -0.65, 4.22>
  }
  cylinder { // Cylndr101
    <0,0,1>, <0,0,0>, 1 
    photons {
      collect off
    }
    // All transformations fixed
    scale 0.02
    rotate 90.0*x
    translate  <-1.48, -0.65, 4.18>
  }
  photons {
    collect off
  }
  // All transformations fixed
}
#declare HingeDif16 = difference {
  object { CSG020 }
  cylinder { // Cylndr102
    <0,0,1>, <0,0,0>, 1 
    photons {
      collect off
    }
    // All transformations fixed
    scale <0.02, 0.02, 0.021>
    rotate 90.0*x
    translate  <-1.495, -0.65, 4.23>
  }
  cylinder { // Cylndr103
    <0,0,1>, <0,0,0>, 1 
    photons {
      collect off
    }
    // All transformations fixed
    scale <0.02, 0.02, 0.021>
    rotate 90.0*x
    translate  <-1.495, -0.65, 4.17>
  }
  photons {
    collect off
  }
  // All transformations fixed
}
#declare ShutterHinge16 = union {
  box { // ShutterHingeIron16
    <-1, -1, -1>, <1, 1, 1>
    translate  <1.0, -1.0, 0.0>
    photons {
      collect off
    }
    // All transformations fixed
    scale <0.1, 0.01, 0.01>
    translate  <-1.68, -0.65, 4.2>
  }
  object { HingeDif16 }
  photons {
    collect off
  }
  // All transformations fixed
  translate  0.4*z
  material {
    New_Brass
    // Transform to world space
    translate  <1.55, 0.05, 2.7>
    rotate 13.481627*z
    translate  <-1.68, -0.65, 0.0>
    translate  <-1.68, -0.65, 0.0>
  }
}
#declare ShutterWin0_1_1 = union {
  box { // Cube021
    <-1, -1, -1>, <1, 1, 1>
    translate  <1.0, 0.0, 1.0>
    photons {
      collect off
    }
    // All transformations fixed
    scale <0.175, 0.01, 0.4>
    translate  <-1.68, -0.65, 4.0>
    material {
      T_Wood7
      // Transform to world space
      translate  <1.55, 0.05, 2.7>
      rotate 13.481627*z
      translate  <-1.68, -0.65, 0.0>
      translate  <-1.68, -0.65, 0.0>
    }
  }
  object { ShutterHinge15 }
  object { ShutterHinge16 }
  cylinder { // Shutterholder6
    <0,0,1>, <0,0,0>, 1 
    photons {
      collect off
    }
    // Scaling fixed
    // Rot Z limited (0.0 to     90.0)
    // Translation fixed
    scale <0.005, 0.005, 0.4>
    rotate <-90.0, 0.0, 49.715675>
    translate  <-1.52, -0.65, 4.01>
    material {
      New_Brass
      // Transform to world space
      translate  <1.55, 0.05, 2.7>
      rotate 13.481627*z
      translate  <-1.68, -0.65, 0.0>
      translate  <-1.68, -0.65, 0.0>
    }
  }
  translate  <1.68, 0.65, 0.0>
  photons {
    collect off
  }
  // Scaling fixed
  // Rot Z limited (-90.0 to   0.0)
  // Translation fixed
  rotate -13.481627*z
  translate  <-1.55, -0.05, -2.7>
}
#declare CSG021 = union {
  cylinder { // Cylndr104
    <0,0,1>, <0,0,0>, 1 
    photons {
      collect off
    }
    // All transformations fixed
    scale 0.02
    rotate 90.0*x
    translate  <-1.48, -0.65, 4.22>
  }
  cylinder { // Cylndr105
    <0,0,1>, <0,0,0>, 1 
    photons {
      collect off
    }
    // All transformations fixed
    scale 0.02
    rotate 90.0*x
    translate  <-1.48, -0.65, 4.18>
  }
  photons {
    collect off
  }
  // All transformations fixed
}
#declare HingeDif17 = difference {
  object { CSG021 }
  cylinder { // Cylndr106
    <0,0,1>, <0,0,0>, 1 
    photons {
      collect off
    }
    // All transformations fixed
    scale <0.02, 0.02, 0.021>
    rotate 90.0*x
    translate  <-1.495, -0.65, 4.23>
  }
  cylinder { // Cylndr107
    <0,0,1>, <0,0,0>, 1 
    photons {
      collect off
    }
    // All transformations fixed
    scale <0.02, 0.02, 0.021>
    rotate 90.0*x
    translate  <-1.495, -0.65, 4.17>
  }
  photons {
    collect off
  }
  // All transformations fixed
}
#declare ShutterHinge17 = union {
  box { // ShutterHingeIron17
    <-1, -1, -1>, <1, 1, 1>
    translate  <1.0, -1.0, 0.0>
    photons {
      collect off
    }
    // All transformations fixed
    scale <0.1, 0.01, 0.01>
    translate  <-1.68, -0.65, 4.2>
  }
  object { HingeDif17 }
  photons {
    collect off
  }
  // All transformations fixed
  material {
    New_Brass
    // Transform to world space
    translate  <0.85, 0.05, 2.7>
    rotate -23.705189*z
    scale <1.0/-1.0, 1.0/1.0, 1.0/1.0>
    translate  <-1.68, -0.65, 0.0>
    translate  <-1.68, -0.65, 0.0>
  }
}
#declare CSG022 = union {
  cylinder { // Cylndr108
    <0,0,1>, <0,0,0>, 1 
    photons {
      collect off
    }
    // All transformations fixed
    scale 0.02
    rotate 90.0*x
    translate  <-1.48, -0.65, 4.22>
  }
  cylinder { // Cylndr109
    <0,0,1>, <0,0,0>, 1 
    photons {
      collect off
    }
    // All transformations fixed
    scale 0.02
    rotate 90.0*x
    translate  <-1.48, -0.65, 4.18>
  }
  photons {
    collect off
  }
  // All transformations fixed
}
#declare HingeDif18 = difference {
  object { CSG022 }
  cylinder { // Cylndr110
    <0,0,1>, <0,0,0>, 1 
    photons {
      collect off
    }
    // All transformations fixed
    scale <0.02, 0.02, 0.021>
    rotate 90.0*x
    translate  <-1.495, -0.65, 4.23>
  }
  cylinder { // Cylndr111
    <0,0,1>, <0,0,0>, 1 
    photons {
      collect off
    }
    // All transformations fixed
    scale <0.02, 0.02, 0.021>
    rotate 90.0*x
    translate  <-1.495, -0.65, 4.17>
  }
  photons {
    collect off
  }
  // All transformations fixed
}
#declare ShutterHinge18 = union {
  box { // ShutterHingeIron18
    <-1, -1, -1>, <1, 1, 1>
    translate  <1.0, -1.0, 0.0>
    photons {
      collect off
    }
    // All transformations fixed
    scale <0.1, 0.01, 0.01>
    translate  <-1.68, -0.65, 4.2>
  }
  object { HingeDif18 }
  photons {
    collect off
  }
  // All transformations fixed
  translate  0.4*z
  material {
    New_Brass
    // Transform to world space
    translate  <0.85, 0.05, 2.7>
    rotate -23.705189*z
    scale <1.0/-1.0, 1.0/1.0, 1.0/1.0>
    translate  <-1.68, -0.65, 0.0>
    translate  <-1.68, -0.65, 0.0>
  }
}
#declare ShutterWin0_1_2 = union {
  box { // Cube022
    <-1, -1, -1>, <1, 1, 1>
    translate  <1.0, 0.0, 1.0>
    photons {
      collect off
    }
    // All transformations fixed
    scale <0.175, 0.01, 0.4>
    translate  <-1.68, -0.65, 4.0>
    material {
      T_Wood7
      // Transform to world space
      translate  <0.85, 0.05, 2.7>
      rotate -23.705189*z
      scale <1.0/-1.0, 1.0/1.0, 1.0/1.0>
      translate  <-1.68, -0.65, 0.0>
      translate  <-1.68, -0.65, 0.0>
    }
  }
  object { ShutterHinge17 }
  object { ShutterHinge18 }
  cylinder { // Shutterholder7
    <0,0,1>, <0,0,0>, 1 
    photons {
      collect off
    }
    // Scaling fixed
    // Rot Z limited (0.0 to     90.0)
    // Translation fixed
    scale <0.005, 0.005, 0.4>
    rotate <-90.0, 0.0, 49.715675>
    translate  <-1.52, -0.65, 4.01>
    material {
      New_Brass
      // Transform to world space
      translate  <0.85, 0.05, 2.7>
      rotate -23.705189*z
      scale <1.0/-1.0, 1.0/1.0, 1.0/1.0>
      translate  <-1.68, -0.65, 0.0>
      translate  <-1.68, -0.65, 0.0>
    }
  }
  translate  <1.68, 0.65, 0.0>
  photons {
    collect off
  }
  // Scaling fixed
  // Rot Z limited (0.0 to   90.0)
  // Translation fixed
  scale <-1.0, 1.0, 1.0>
  rotate 23.705189*z
  translate  <-0.85, -0.05, -2.7>
}
#declare Group_GroundFloor_Window1 = union {
  box { // Window1_Sill
    <-1, -1, -1>, <1, 1, 1>
    translate  1.0*z
    photons {
      collect off
    }
    scale <0.4, 0.2, 0.025>
    translate  <-1.2, 0.0, 1.25>
    material {
      DMFWood4Hor
      // Transform to world space
    }
  }
  box { // GroundFloor_Window1Vert1
    <-1, -1, -1>, <1, 1, 1>
    translate  <-1.0, 0.0, 1.0>
    photons {
      collect off
    }
    scale <0.015, 0.1, 0.575>
    translate  <-1.55, 0.0, 1.25>
    material {
      DMFWood4Ver
      // Transform to world space
    }
  }
  box { // GroundFloor_Window1Vert2
    <-1, -1, -1>, <1, 1, 1>
    translate  <1.0, 0.0, 1.0>
    photons {
      collect off
    }
    scale <0.015, 0.1, 0.575>
    translate  <-0.85, 0.0, 1.25>
    material {
      DMFWood4Ver
      // Transform to world space
    }
  }
  box { // GroundFloor_Window1Upper
    <-1, -1, -1>, <1, 1, 1>
    translate  -1.0*z
    photons {
      collect off
    }
    scale <0.35, 0.1, 0.015>
    translate  <-1.2, 0.0, 2.4>
    material {
      DMFWood4Hor
      // Transform to world space
    }
  }
  object { Window0_1_1 }
  object { Window0_1_2 }
  box { // GroundFloor_Window1Upper1
    <-1, -1, -1>, <1, 1, 1>
    translate  -1.0*z
    photons {
      collect off
    }
    scale <0.35, 0.1, 0.015>
    translate  <-1.2, 0.0, 2.13>
    material {
      DMFWood4Hor
      // Transform to world space
    }
  }
  box { // GroundFloor_WindowPane1
    <-1, -1, -1>, <1, 1, 1>
    translate  1.0*z
    photons {
      collect off
    }
    scale <0.36, 0.001, 0.13>
    translate  <-1.2, 0.0, 2.12>
    material {
      WindowGlass
      // Transform to world space
    }
  }
  object { ShutterWin0_1_1 }
  object { ShutterWin0_1_2 }
  photons {
    collect off
  }
}
#declare Window0_2_1 = union {
  box { // Win1Vert21
    <-1, -1, -1>, <1, 1, 1>
    translate  <1.0, 0.0, 1.0>
    photons {
      collect off
    }
    // All transformations fixed
    scale <0.015, 0.025, 0.4>
    translate  <-1.4, -0.5, 4.0>
    material {
      DMFWood4Ver
      // Transform to world space
      translate  <-0.85, 0.0, 2.4>
      translate  <-1.4, -0.5, 0.0>
      rotate 0.0*z rotate 0.0*y rotate 0.0*x
      translate  <-1.4, -0.5, 0.0>
      rotate 0.0*z rotate 0.0*y rotate 0.0*x
    }
  }
  box { // Win1Vert22
    <-1, -1, -1>, <1, 1, 1>
    translate  <-1.0, 0.0, 1.0>
    photons {
      collect off
    }
    // All transformations fixed
    scale <0.015, 0.025, 0.4>
    translate  <-1.05, -0.5, 4.0>
    material {
      DMFWood4Ver
      // Transform to world space
      translate  <-0.85, 0.0, 2.4>
      translate  <-1.4, -0.5, 0.0>
      rotate 0.0*z rotate 0.0*y rotate 0.0*x
      translate  <-1.4, -0.5, 0.0>
      rotate 0.0*z rotate 0.0*y rotate 0.0*x
    }
  }
  box { // Win1Hor33
    <-1, -1, -1>, <1, 1, 1>
    translate  -1.0*z
    photons {
      collect off
    }
    // All transformations fixed
    scale <0.15, 0.025, 0.015>
    translate  <-1.22, -0.5, 4.8>
    material {
      DMFWood4Hor
      // Transform to world space
      translate  <-0.85, 0.0, 2.4>
      translate  <-1.4, -0.5, 0.0>
      rotate 0.0*z rotate 0.0*y rotate 0.0*x
      translate  <-1.4, -0.5, 0.0>
      rotate 0.0*z rotate 0.0*y rotate 0.0*x
    }
  }
  box { // Win1Hor34
    <-1, -1, -1>, <1, 1, 1>
    translate  1.0*z
    photons {
      collect off
    }
    // All transformations fixed
    scale <0.15, 0.025, 0.015>
    translate  <-1.22, -0.5, 4.0>
    material {
      DMFWood4Hor
      // Transform to world space
      translate  <-0.85, 0.0, 2.4>
      translate  <-1.4, -0.5, 0.0>
      rotate 0.0*z rotate 0.0*y rotate 0.0*x
      translate  <-1.4, -0.5, 0.0>
      rotate 0.0*z rotate 0.0*y rotate 0.0*x
    }
  }
  box { // Win1Pane11
    <-1, -1, -1>, <1, 1, 1>
    translate  1.0*z
    photons {
      collect off
    }
    // All transformations fixed
    scale <0.165, 0.001, 0.385>
    translate  <-1.22, -0.5, 4.015>
    material {
      WindowGlass
      // Transform to world space
      translate  <-0.85, 0.0, 2.4>
      translate  <-1.4, -0.5, 0.0>
      rotate 0.0*z rotate 0.0*y rotate 0.0*x
      translate  <-1.4, -0.5, 0.0>
      rotate 0.0*z rotate 0.0*y rotate 0.0*x
    }
  }
  box { // Win1Hor35
    <-1, -1, -1>, <1, 1, 1>
    translate  1.0*z
    photons {
      collect off
    }
    // All transformations fixed
    scale <0.15, 0.025, 0.015>
    translate  <-1.22, -0.5, 4.4>
    material {
      DMFWood4Hor
      // Transform to world space
      translate  <-0.85, 0.0, 2.4>
      translate  <-1.4, -0.5, 0.0>
      rotate 0.0*z rotate 0.0*y rotate 0.0*x
      translate  <-1.4, -0.5, 0.0>
      rotate 0.0*z rotate 0.0*y rotate 0.0*x
    }
  }
  rotate <-0.0, -0.0, -0.0>
  translate  <1.4, 0.5, 0.0>
  photons {
    collect off
  }
  // Scaling fixed
  // Rot Z limited (0.0 to   90.0)
  // Translation fixed
  translate  <0.85, 0.0, -2.4>
}
#declare Window0_2_2 = union {
  box { // Win1Vert23
    <-1, -1, -1>, <1, 1, 1>
    translate  <1.0, 0.0, 1.0>
    photons {
      collect off
    }
    // All transformations fixed
    scale <0.015, 0.025, 0.4>
    translate  <-1.39, -0.5, 4.0>
    material {
      DMFWood4Ver
      // Transform to world space
      translate  <-1.55, 0.0, 2.4>
      translate  <-1.04, -0.5, 0.0>
      rotate 0.0*z rotate 0.0*y rotate 0.0*x
      translate  <-1.04, -0.5, 0.0>
      rotate 0.0*z rotate 0.0*y rotate 0.0*x
    }
  }
  box { // Win1Vert24
    <-1, -1, -1>, <1, 1, 1>
    translate  <-1.0, 0.0, 1.0>
    photons {
      collect off
    }
    // All transformations fixed
    scale <0.015, 0.025, 0.4>
    translate  <-1.04, -0.5, 4.0>
    material {
      DMFWood4Ver
      // Transform to world space
      translate  <-1.55, 0.0, 2.4>
      translate  <-1.04, -0.5, 0.0>
      rotate 0.0*z rotate 0.0*y rotate 0.0*x
      translate  <-1.04, -0.5, 0.0>
      rotate 0.0*z rotate 0.0*y rotate 0.0*x
    }
  }
  box { // Win1Hor36
    <-1, -1, -1>, <1, 1, 1>
    translate  -1.0*z
    photons {
      collect off
    }
    // All transformations fixed
    scale <0.15, 0.025, 0.015>
    translate  <-1.22, -0.5, 4.8>
    material {
      DMFWood4Hor
      // Transform to world space
      translate  <-1.55, 0.0, 2.4>
      translate  <-1.04, -0.5, 0.0>
      rotate 0.0*z rotate 0.0*y rotate 0.0*x
      translate  <-1.04, -0.5, 0.0>
      rotate 0.0*z rotate 0.0*y rotate 0.0*x
    }
  }
  box { // Win1Hor37
    <-1, -1, -1>, <1, 1, 1>
    translate  1.0*z
    photons {
      collect off
    }
    // All transformations fixed
    scale <0.15, 0.025, 0.015>
    translate  <-1.22, -0.5, 4.0>
    material {
      DMFWood4Hor
      // Transform to world space
      translate  <-1.55, 0.0, 2.4>
      translate  <-1.04, -0.5, 0.0>
      rotate 0.0*z rotate 0.0*y rotate 0.0*x
      translate  <-1.04, -0.5, 0.0>
      rotate 0.0*z rotate 0.0*y rotate 0.0*x
    }
  }
  box { // Win1Pane12
    <-1, -1, -1>, <1, 1, 1>
    translate  1.0*z
    photons {
      collect off
    }
    // All transformations fixed
    scale <0.165, 0.001, 0.385>
    translate  <-1.22, -0.5, 4.015>
    material {
      WindowGlass
      // Transform to world space
      translate  <-1.55, 0.0, 2.4>
      translate  <-1.04, -0.5, 0.0>
      rotate 0.0*z rotate 0.0*y rotate 0.0*x
      translate  <-1.04, -0.5, 0.0>
      rotate 0.0*z rotate 0.0*y rotate 0.0*x
    }
  }
  box { // Win1Hor38
    <-1, -1, -1>, <1, 1, 1>
    translate  1.0*z
    photons {
      collect off
    }
    // All transformations fixed
    scale <0.15, 0.025, 0.015>
    translate  <-1.22, -0.5, 4.4>
    material {
      DMFWood4Hor
      // Transform to world space
      translate  <-1.55, 0.0, 2.4>
      translate  <-1.04, -0.5, 0.0>
      rotate 0.0*z rotate 0.0*y rotate 0.0*x
      translate  <-1.04, -0.5, 0.0>
      rotate 0.0*z rotate 0.0*y rotate 0.0*x
    }
  }
  rotate <-0.0, -0.0, 0.0>
  translate  <1.04, 0.5, 0.0>
  photons {
    collect off
  }
  // Scaling fixed
  // Rot Z limited (-90.0 to   0.0)
  // Translation fixed
  translate  <1.55, 0.0, -2.4>
}
#declare CSG023 = union {
  cylinder { // Cylndr112
    <0,0,1>, <0,0,0>, 1 
    photons {
      collect off
    }
    // All transformations fixed
    scale 0.02
    rotate 90.0*x
    translate  <-1.48, -0.65, 4.22>
  }
  cylinder { // Cylndr113
    <0,0,1>, <0,0,0>, 1 
    photons {
      collect off
    }
    // All transformations fixed
    scale 0.02
    rotate 90.0*x
    translate  <-1.48, -0.65, 4.18>
  }
  photons {
    collect off
  }
  // All transformations fixed
}
#declare HingeDif19 = difference {
  object { CSG023 }
  cylinder { // Cylndr114
    <0,0,1>, <0,0,0>, 1 
    photons {
      collect off
    }
    // All transformations fixed
    scale <0.02, 0.02, 0.021>
    rotate 90.0*x
    translate  <-1.495, -0.65, 4.23>
  }
  cylinder { // Cylndr115
    <0,0,1>, <0,0,0>, 1 
    photons {
      collect off
    }
    // All transformations fixed
    scale <0.02, 0.02, 0.021>
    rotate 90.0*x
    translate  <-1.495, -0.65, 4.17>
  }
  photons {
    collect off
  }
  // All transformations fixed
}
#declare ShutterHinge19 = union {
  box { // ShutterHingeIron19
    <-1, -1, -1>, <1, 1, 1>
    translate  <1.0, -1.0, 0.0>
    photons {
      collect off
    }
    // All transformations fixed
    scale <0.1, 0.01, 0.01>
    translate  <-1.68, -0.65, 4.2>
  }
  object { HingeDif19 }
  photons {
    collect off
  }
  // All transformations fixed
  material {
    New_Brass
    // Transform to world space
    translate  <-0.85, 0.05, 2.4>
    rotate 102.861748*z
    translate  <-1.68, -0.65, 0.0>
    translate  <-1.68, -0.65, 0.0>
  }
}
#declare CSG024 = union {
  cylinder { // Cylndr116
    <0,0,1>, <0,0,0>, 1 
    photons {
      collect off
    }
    // All transformations fixed
    scale 0.02
    rotate 90.0*x
    translate  <-1.48, -0.65, 4.22>
  }
  cylinder { // Cylndr117
    <0,0,1>, <0,0,0>, 1 
    photons {
      collect off
    }
    // All transformations fixed
    scale 0.02
    rotate 90.0*x
    translate  <-1.48, -0.65, 4.18>
  }
  photons {
    collect off
  }
  // All transformations fixed
}
#declare HingeDif20 = difference {
  object { CSG024 }
  cylinder { // Cylndr118
    <0,0,1>, <0,0,0>, 1 
    photons {
      collect off
    }
    // All transformations fixed
    scale <0.02, 0.02, 0.021>
    rotate 90.0*x
    translate  <-1.495, -0.65, 4.23>
  }
  cylinder { // Cylndr119
    <0,0,1>, <0,0,0>, 1 
    photons {
      collect off
    }
    // All transformations fixed
    scale <0.02, 0.02, 0.021>
    rotate 90.0*x
    translate  <-1.495, -0.65, 4.17>
  }
  photons {
    collect off
  }
  // All transformations fixed
}
#declare ShutterHinge20 = union {
  box { // ShutterHingeIron20
    <-1, -1, -1>, <1, 1, 1>
    translate  <1.0, -1.0, 0.0>
    photons {
      collect off
    }
    // All transformations fixed
    scale <0.1, 0.01, 0.01>
    translate  <-1.68, -0.65, 4.2>
  }
  object { HingeDif20 }
  photons {
    collect off
  }
  // All transformations fixed
  translate  0.4*z
  material {
    New_Brass
    // Transform to world space
    translate  <-0.85, 0.05, 2.4>
    rotate 102.861748*z
    translate  <-1.68, -0.65, 0.0>
    translate  <-1.68, -0.65, 0.0>
  }
}
#declare ShutterWin0_2_1 = union {
  box { // Cube023
    <-1, -1, -1>, <1, 1, 1>
    translate  <1.0, 0.0, 1.0>
    photons {
      collect off
    }
    // All transformations fixed
    scale <0.175, 0.01, 0.4>
    translate  <-1.68, -0.65, 4.0>
    material {
      T_Wood7
      // Transform to world space
      translate  <-0.85, 0.05, 2.4>
      rotate 102.861748*z
      translate  <-1.68, -0.65, 0.0>
      translate  <-1.68, -0.65, 0.0>
    }
  }
  object { ShutterHinge19 }
  object { ShutterHinge20 }
  cylinder { // Shutterholder8
    <0,0,1>, <0,0,0>, 1 
    photons {
      collect off
    }
    // Scaling fixed
    // Rot Z limited (0.0 to     90.0)
    // Translation fixed
    scale <0.005, 0.005, 0.4>
    rotate <-90.0, 0.0, 61.544773>
    translate  <-1.52, -0.65, 4.01>
    material {
      New_Brass
      // Transform to world space
      translate  <-0.85, 0.05, 2.4>
      rotate 102.861748*z
      translate  <-1.68, -0.65, 0.0>
      translate  <-1.68, -0.65, 0.0>
    }
  }
  translate  <1.68, 0.65, 0.0>
  photons {
    collect off
  }
  // Scaling fixed
  // Rot Z limited (-120.0 to   0.0)
  // Translation fixed
  rotate -102.861748*z
  translate  <0.85, -0.05, -2.4>
}
#declare CSG025 = union {
  cylinder { // Cylndr120
    <0,0,1>, <0,0,0>, 1 
    photons {
      collect off
    }
    // All transformations fixed
    scale 0.02
    rotate 90.0*x
    translate  <-1.48, -0.65, 4.22>
  }
  cylinder { // Cylndr121
    <0,0,1>, <0,0,0>, 1 
    photons {
      collect off
    }
    // All transformations fixed
    scale 0.02
    rotate 90.0*x
    translate  <-1.48, -0.65, 4.18>
  }
  photons {
    collect off
  }
  // All transformations fixed
}
#declare HingeDif21 = difference {
  object { CSG025 }
  cylinder { // Cylndr122
    <0,0,1>, <0,0,0>, 1 
    photons {
      collect off
    }
    // All transformations fixed
    scale <0.02, 0.02, 0.021>
    rotate 90.0*x
    translate  <-1.495, -0.65, 4.23>
  }
  cylinder { // Cylndr123
    <0,0,1>, <0,0,0>, 1 
    photons {
      collect off
    }
    // All transformations fixed
    scale <0.02, 0.02, 0.021>
    rotate 90.0*x
    translate  <-1.495, -0.65, 4.17>
  }
  photons {
    collect off
  }
  // All transformations fixed
}
#declare ShutterHinge21 = union {
  box { // ShutterHingeIron21
    <-1, -1, -1>, <1, 1, 1>
    translate  <1.0, -1.0, 0.0>
    photons {
      collect off
    }
    // All transformations fixed
    scale <0.1, 0.01, 0.01>
    translate  <-1.68, -0.65, 4.2>
  }
  object { HingeDif21 }
  photons {
    collect off
  }
  // All transformations fixed
  material {
    New_Brass
    // Transform to world space
    translate  <-1.55, 0.05, 2.4>
    rotate -77.598251*z
    scale <1.0/-1.0, 1.0/1.0, 1.0/1.0>
    translate  <-1.68, -0.65, 0.0>
    translate  <-1.68, -0.65, 0.0>
  }
}
#declare CSG026 = union {
  cylinder { // Cylndr124
    <0,0,1>, <0,0,0>, 1 
    photons {
      collect off
    }
    // All transformations fixed
    scale 0.02
    rotate 90.0*x
    translate  <-1.48, -0.65, 4.22>
  }
  cylinder { // Cylndr125
    <0,0,1>, <0,0,0>, 1 
    photons {
      collect off
    }
    // All transformations fixed
    scale 0.02
    rotate 90.0*x
    translate  <-1.48, -0.65, 4.18>
  }
  photons {
    collect off
  }
  // All transformations fixed
}
#declare HingeDif22 = difference {
  object { CSG026 }
  cylinder { // Cylndr126
    <0,0,1>, <0,0,0>, 1 
    photons {
      collect off
    }
    // All transformations fixed
    scale <0.02, 0.02, 0.021>
    rotate 90.0*x
    translate  <-1.495, -0.65, 4.23>
  }
  cylinder { // Cylndr127
    <0,0,1>, <0,0,0>, 1 
    photons {
      collect off
    }
    // All transformations fixed
    scale <0.02, 0.02, 0.021>
    rotate 90.0*x
    translate  <-1.495, -0.65, 4.17>
  }
  photons {
    collect off
  }
  // All transformations fixed
}
#declare ShutterHinge22 = union {
  box { // ShutterHingeIron22
    <-1, -1, -1>, <1, 1, 1>
    translate  <1.0, -1.0, 0.0>
    photons {
      collect off
    }
    // All transformations fixed
    scale <0.1, 0.01, 0.01>
    translate  <-1.68, -0.65, 4.2>
  }
  object { HingeDif22 }
  photons {
    collect off
  }
  // All transformations fixed
  translate  0.4*z
  material {
    New_Brass
    // Transform to world space
    translate  <-1.55, 0.05, 2.4>
    rotate -77.598251*z
    scale <1.0/-1.0, 1.0/1.0, 1.0/1.0>
    translate  <-1.68, -0.65, 0.0>
    translate  <-1.68, -0.65, 0.0>
  }
}
#declare ShutterWin0_2_2 = union {
  box { // Cube024
    <-1, -1, -1>, <1, 1, 1>
    translate  <1.0, 0.0, 1.0>
    photons {
      collect off
    }
    // All transformations fixed
    scale <0.175, 0.01, 0.4>
    translate  <-1.68, -0.65, 4.0>
    material {
      T_Wood7
      // Transform to world space
      translate  <-1.55, 0.05, 2.4>
      rotate -77.598251*z
      scale <1.0/-1.0, 1.0/1.0, 1.0/1.0>
      translate  <-1.68, -0.65, 0.0>
      translate  <-1.68, -0.65, 0.0>
    }
  }
  object { ShutterHinge21 }
  object { ShutterHinge22 }
  cylinder { // Shutterholder9
    <0,0,1>, <0,0,0>, 1 
    photons {
      collect off
    }
    // Scaling fixed
    // Rot Z limited (0.0 to     90.0)
    // Translation fixed
    scale <0.005, 0.005, 0.4>
    rotate <-90.0, 0.0, 64.751656>
    translate  <-1.52, -0.65, 4.01>
    material {
      New_Brass
      // Transform to world space
      translate  <-1.55, 0.05, 2.4>
      rotate -77.598251*z
      scale <1.0/-1.0, 1.0/1.0, 1.0/1.0>
      translate  <-1.68, -0.65, 0.0>
      translate  <-1.68, -0.65, 0.0>
    }
  }
  translate  <1.68, 0.65, 0.0>
  photons {
    collect off
  }
  // Scaling fixed
  // Rot Z limited (0.0 to   120.0)
  // Translation fixed
  scale <-1.0, 1.0, 1.0>
  rotate 77.598251*z
  translate  <1.55, -0.05, -2.4>
}
#declare Group_GroundFloor_Window2 = union {
  box { // Window2_Sill
    <-1, -1, -1>, <1, 1, 1>
    translate  1.0*z
    photons {
      collect off
    }
    scale <0.4, 0.2, 0.025>
    translate  <1.2, 0.0, 1.55>
    material {
      DMFWood4Hor
      // Transform to world space
    }
  }
  box { // GroundFloor_Window2Vert1
    <-1, -1, -1>, <1, 1, 1>
    translate  <-1.0, 0.0, 1.0>
    photons {
      collect off
    }
    scale <0.015, 0.1, 0.4>
    translate  <0.85, 0.0, 1.6>
    material {
      DMFWood4Ver
      // Transform to world space
    }
  }
  box { // GroundFloor_Window2Vert2
    <-1, -1, -1>, <1, 1, 1>
    translate  <1.0, 0.0, 1.0>
    photons {
      collect off
    }
    scale <0.015, 0.1, 0.4>
    translate  <1.55, 0.0, 1.6>
    material {
      DMFWood4Ver
      // Transform to world space
    }
  }
  box { // GroundFloor_Window2Upper
    <-1, -1, -1>, <1, 1, 1>
    translate  -1.0*z
    photons {
      collect off
    }
    scale <0.38, 0.1, 0.015>
    translate  <1.2, 0.0, 2.43>
    material {
      DMFWood4Hor
      // Transform to world space
    }
  }
  object { Window0_2_1 }
  object { Window0_2_2 }
  object { ShutterWin0_2_1 }
  object { ShutterWin0_2_2 }
  photons {
    collect off
  }
}
#declare Group_GroundFloor_DoorAndWindows = union {
  object { Group_GroundFloorDoor }
  object { Group_GroundFloor_Window1 }
  object { Group_GroundFloor_Window2 }
  photons {
    collect off
  }
}
#declare SideWall1 = union {
  box { // Cube025
    <-1, -1, -1>, <1, 1, 1>
    translate  <0.0, -1.0, 1.0>
    photons {
      collect off
    }
    scale <0.02, 0.5, 0.7>
    material {
      T_Wood7
      // Transform to world space
      translate  0.7*x
      translate  <-1.22, 0.15, 0.0>
    }
  }
  object { Cube026 }
  object { // Cube027 -> Cube026
    Cube026
    photons {
      collect off
    }
    translate  -0.1*y
  }
  object { // Cube028 -> Cube026
    Cube026
    photons {
      collect off
    }
    translate  -0.2*y
  }
  object { // Cube029 -> Cube026
    Cube026
    photons {
      collect off
    }
    translate  -0.3*y
  }
  object { // Cube030 -> Cube026
    Cube026
    photons {
      collect off
    }
    translate  -0.4*y
  }
  object { // Cube031 -> Cube026
    Cube026
    photons {
      collect off
    }
    translate  -0.5*y
  }
  object { // Cube032 -> Cube026
    Cube026
    photons {
      collect off
    }
    translate  -0.6*y
  }
  object { // Cube033 -> Cube026
    Cube026
    photons {
      collect off
    }
    translate  -0.7*y
  }
  object { // Cube034 -> Cube026
    Cube026
    photons {
      collect off
    }
    translate  -0.8*y
  }
  object { // Cube035 -> Cube026
    Cube026
    photons {
      collect off
    }
    translate  -0.9*y
  }
  object { // Cube036 -> Cube026
    Cube026
    photons {
      collect off
    }
    translate  -1.0*y
  }
  photons {
    collect off
  }
  translate  -0.7*x
}
#declare SideWall2 = union {
  box { // Cube037
    <-1, -1, -1>, <1, 1, 1>
    translate  <0.0, -1.0, 1.0>
    photons {
      collect off
    }
    scale <0.02, 0.5, 0.7>
    material {
      T_Wood7
      // Transform to world space
      translate  -0.7*x
      rotate -180.0*x
      scale 1.0/-1.0
      translate  <-1.22, 0.15, 0.0>
    }
  }
  box { // Cube038
    <-1, -1, -1>, <1, 1, 1>
    translate  <-1.0, 0.0, 1.0>
    photons {
      collect off
    }
    scale <0.02, 0.01, 0.7>
    material {
      T_Wood35
      // Transform to world space
      translate  -0.7*x
      rotate -180.0*x
      scale 1.0/-1.0
      translate  <-1.22, 0.15, 0.0>
    }
  }
  object { // Cube039 -> Cube026
    Cube026
    photons {
      collect off
    }
    translate  -0.1*y
  }
  object { // Cube040 -> Cube026
    Cube026
    photons {
      collect off
    }
    translate  -0.2*y
  }
  object { // Cube041 -> Cube026
    Cube026
    photons {
      collect off
    }
    translate  -0.3*y
  }
  object { // Cube042 -> Cube026
    Cube026
    photons {
      collect off
    }
    translate  -0.4*y
  }
  object { // Cube043 -> Cube026
    Cube026
    photons {
      collect off
    }
    translate  -0.5*y
  }
  object { // Cube044 -> Cube026
    Cube026
    photons {
      collect off
    }
    translate  -0.6*y
  }
  object { // Cube045 -> Cube026
    Cube026
    photons {
      collect off
    }
    translate  -0.7*y
  }
  object { // Cube046 -> Cube026
    Cube026
    photons {
      collect off
    }
    translate  -0.8*y
  }
  object { // Cube047 -> Cube026
    Cube026
    photons {
      collect off
    }
    translate  -0.9*y
  }
  object { // Cube048 -> Cube026
    Cube026
    photons {
      collect off
    }
    translate  -1.0*y
  }
  photons {
    collect off
  }
  scale -1.0
  rotate 180.0*x
  translate  0.7*x
}
#declare BothSideWalls = union {
  object { SideWall1 }
  object { SideWall2 }
  photons {
    collect off
  }
}
#declare SideWalldif = difference {
  object { BothSideWalls }
  box { // Cube049
    <-1, -1, -1>, <1, 1, 1>
    translate  <0.0, -1.0, 1.0>
    photons {
      collect off
    }
    scale <0.75, 0.6, 0.25>
    rotate 25.0*x
    translate  1.4*z
    material {
      T_Wood7
      // Transform to world space
      translate  <-1.22, 0.15, 0.0>
    }
  }
  photons {
    collect off
  }
}
#declare PothouseRoof = union {
  box { // Cube050
    <-1, -1, -1>, <1, 1, 1>
    translate  <0.0, -1.0, 1.0>
    photons {
      collect off
    }
    scale <0.76, 0.6, 0.02>
  }
  object { Cube051 }
  object { // Cube052 -> Cube051
    Cube051
    photons {
      collect off
    }
    translate  0.1*x
  }
  object { // Cube053 -> Cube051
    Cube051
    photons {
      collect off
    }
    translate  0.2*x
  }
  object { // Cube054 -> Cube051
    Cube051
    photons {
      collect off
    }
    translate  0.3*x
  }
  object { // Cube055 -> Cube051
    Cube051
    photons {
      collect off
    }
    translate  0.4*x
  }
  object { // Cube056 -> Cube051
    Cube051
    photons {
      collect off
    }
    translate  0.5*x
  }
  object { // Cube057 -> Cube051
    Cube051
    photons {
      collect off
    }
    translate  0.6*x
  }
  object { // Cube058 -> Cube051
    Cube051
    photons {
      collect off
    }
    translate  0.7*x
  }
  object { // Cube059 -> Cube051
    Cube051
    photons {
      collect off
    }
    translate  0.8*x
  }
  object { // Cube060 -> Cube051
    Cube051
    photons {
      collect off
    }
    translate  0.9*x
  }
  object { // Cube061 -> Cube051
    Cube051
    photons {
      collect off
    }
    translate  1.0*x
  }
  object { // Cube062 -> Cube051
    Cube051
    photons {
      collect off
    }
    translate  1.1*x
  }
  object { // Cube063 -> Cube051
    Cube051
    photons {
      collect off
    }
    translate  1.2*x
  }
  object { // Cube064 -> Cube051
    Cube051
    photons {
      collect off
    }
    translate  1.3*x
  }
  object { // Cube065 -> Cube051
    Cube051
    photons {
      collect off
    }
    translate  1.4*x
  }
  object { // Cube066 -> Cube051
    Cube051
    photons {
      collect off
    }
    translate  1.5*x
  }
  photons {
    collect off
  }
  rotate 25.0*x
  translate  1.4*z
  material {
    T_Wood7
    // Transform to world space
    translate  <-1.22, 0.15, 0.0>
  }
}
#declare Front = union {
  box { // Cube067
    <-1, -1, -1>, <1, 1, 1>
    translate  <0.0, -1.0, 1.0>
    photons {
      collect off
    }
    scale <0.72, 0.02, 0.47>
    translate  -0.97*y
    material {
      T_Wood7
      // Transform to world space
      translate  <-1.22, 0.15, 0.0>
    }
  }
  object { Cube068 }
  object { // Cube069 -> Cube068
    Cube068
    photons {
      collect off
    }
    translate  0.1*x
  }
  object { // Cube070 -> Cube068
    Cube068
    photons {
      collect off
    }
    translate  0.2*x
  }
  object { // Cube071 -> Cube068
    Cube068
    photons {
      collect off
    }
    translate  0.3*x
  }
  object { // Cube072 -> Cube068
    Cube068
    photons {
      collect off
    }
    translate  0.4*x
  }
  object { // Cube073 -> Cube068
    Cube068
    photons {
      collect off
    }
    translate  0.5*x
  }
  object { // Cube074 -> Cube068
    Cube068
    photons {
      collect off
    }
    translate  0.6*x
  }
  object { // Cube075 -> Cube068
    Cube068
    photons {
      collect off
    }
    translate  0.7*x
  }
  object { // Cube076 -> Cube068
    Cube068
    photons {
      collect off
    }
    translate  0.8*x
  }
  object { // Cube077 -> Cube068
    Cube068
    photons {
      collect off
    }
    translate  0.9*x
  }
  object { // Cube078 -> Cube068
    Cube068
    photons {
      collect off
    }
    translate  1.0*x
  }
  object { // Cube079 -> Cube068
    Cube068
    photons {
      collect off
    }
    translate  1.1*x
  }
  object { // Cube080 -> Cube068
    Cube068
    photons {
      collect off
    }
    translate  1.2*x
  }
  object { // Cube081 -> Cube068
    Cube068
    photons {
      collect off
    }
    translate  1.3*x
  }
  object { // Cube082 -> Cube068
    Cube068
    photons {
      collect off
    }
    translate  1.4*x
  }
  object { // Cube083 -> Cube068
    Cube068
    photons {
      collect off
    }
    translate  1.5*x
  }
  photons {
    collect off
  }
}
#declare FrontDif = difference {
  object { Front }
  box { // Cube084
    <-1, -1, -1>, <1, 1, 1>
    translate  <1.0, -1.0, 1.0>
    photons {
      collect off
    }
    scale <0.175, 0.03, 0.4>
    translate  <-0.4, -0.965, 0.05>
    material {
      T_Wood7
      // Transform to world space
      translate  <-1.22, 0.15, 0.0>
    }
  }
  photons {
    collect off
  }
}
#declare CSG027 = union {
  cylinder { // Cylndr128
    <0,0,1>, <0,0,0>, 1 
    photons {
      collect off
    }
    // All transformations fixed
    scale 0.02
    rotate 90.0*x
    translate  <-1.48, -0.65, 4.22>
  }
  cylinder { // Cylndr129
    <0,0,1>, <0,0,0>, 1 
    photons {
      collect off
    }
    // All transformations fixed
    scale 0.02
    rotate 90.0*x
    translate  <-1.48, -0.65, 4.18>
  }
  photons {
    collect off
  }
  // All transformations fixed
}
#declare HingeDif23 = difference {
  object { CSG027 }
  cylinder { // Cylndr130
    <0,0,1>, <0,0,0>, 1 
    photons {
      collect off
    }
    // All transformations fixed
    scale <0.02, 0.02, 0.021>
    rotate 90.0*x
    translate  <-1.495, -0.65, 4.23>
  }
  cylinder { // Cylndr131
    <0,0,1>, <0,0,0>, 1 
    photons {
      collect off
    }
    // All transformations fixed
    scale <0.02, 0.02, 0.021>
    rotate 90.0*x
    translate  <-1.495, -0.65, 4.17>
  }
  photons {
    collect off
  }
  // All transformations fixed
}
#declare ShutterHinge23 = union {
  box { // ShutterHingeIron23
    <-1, -1, -1>, <1, 1, 1>
    translate  <1.0, -1.0, 0.0>
    photons {
      collect off
    }
    // All transformations fixed
    scale <0.1, 0.01, 0.01>
    translate  <-1.68, -0.65, 4.2>
  }
  object { HingeDif23 }
  photons {
    collect off
  }
  // All transformations fixed
  material {
    New_Brass
    // Transform to world space
    translate  <0.4, 1.0, 3.95>
    rotate 11.373625*z
    translate  <-1.68, -0.65, 0.0>
    translate  <-1.68, -0.65, 0.0>
    translate  <-1.22, 0.15, 0.0>
  }
}
#declare CSG028 = union {
  cylinder { // Cylndr132
    <0,0,1>, <0,0,0>, 1 
    photons {
      collect off
    }
    // All transformations fixed
    scale 0.02
    rotate 90.0*x
    translate  <-1.48, -0.65, 4.22>
  }
  cylinder { // Cylndr133
    <0,0,1>, <0,0,0>, 1 
    photons {
      collect off
    }
    // All transformations fixed
    scale 0.02
    rotate 90.0*x
    translate  <-1.48, -0.65, 4.18>
  }
  photons {
    collect off
  }
  // All transformations fixed
}
#declare HingeDif24 = difference {
  object { CSG028 }
  cylinder { // Cylndr134
    <0,0,1>, <0,0,0>, 1 
    photons {
      collect off
    }
    // All transformations fixed
    scale <0.02, 0.02, 0.021>
    rotate 90.0*x
    translate  <-1.495, -0.65, 4.23>
  }
  cylinder { // Cylndr135
    <0,0,1>, <0,0,0>, 1 
    photons {
      collect off
    }
    // All transformations fixed
    scale <0.02, 0.02, 0.021>
    rotate 90.0*x
    translate  <-1.495, -0.65, 4.17>
  }
  photons {
    collect off
  }
  // All transformations fixed
}
#declare ShutterHinge24 = union {
  box { // ShutterHingeIron24
    <-1, -1, -1>, <1, 1, 1>
    translate  <1.0, -1.0, 0.0>
    photons {
      collect off
    }
    // All transformations fixed
    scale <0.1, 0.01, 0.01>
    translate  <-1.68, -0.65, 4.2>
  }
  object { HingeDif24 }
  photons {
    collect off
  }
  // All transformations fixed
  translate  0.4*z
  material {
    New_Brass
    // Transform to world space
    translate  <0.4, 1.0, 3.95>
    rotate 11.373625*z
    translate  <-1.68, -0.65, 0.0>
    translate  <-1.68, -0.65, 0.0>
    translate  <-1.22, 0.15, 0.0>
  }
}
#declare DoorHandle1 = union {
  cylinder { // Cylndr136
    <0,0,1>, <0,0,0>, 1 
    translate  -0.5*z
    photons {
      collect off
    }
    scale <0.008, 0.008, 0.05>
    rotate -90.0*x
  }
  sphere { // Sphere006
    <0,0,0>,1
    photons {
      collect off
    }
    scale <0.02, 0.01, 0.04>
    translate  -0.03*y
  }
  sphere { // Sphere007
    <0,0,0>,1
    photons {
      collect off
    }
    scale <0.02, 0.01, 0.04>
    translate  0.03*y
  }
  photons {
    collect off
  }
  // All transformations fixed
  translate  <-1.4, -0.65, 4.45>
  material {
    Brass_Metal
    // Transform to world space
    translate  <0.4, 1.0, 3.95>
    rotate 11.373625*z
    translate  <-1.68, -0.65, 0.0>
    translate  <-1.68, -0.65, 0.0>
    translate  <-1.22, 0.15, 0.0>
  }
}
#declare PothouseShutter = union {
  box { // Cube085
    <-1, -1, -1>, <1, 1, 1>
    translate  <1.0, 0.0, 1.0>
    photons {
      collect off
    }
    // All transformations fixed
    scale <0.175, 0.01, 0.4>
    translate  <-1.68, -0.65, 4.0>
    material {
      T_Wood7
      // Transform to world space
      translate  <0.4, 1.0, 3.95>
      rotate 11.373625*z
      translate  <-1.68, -0.65, 0.0>
      translate  <-1.68, -0.65, 0.0>
      translate  <-1.22, 0.15, 0.0>
    }
  }
  object { ShutterHinge23 }
  object { ShutterHinge24 }
  object { DoorHandle1 }
  translate  <1.68, 0.65, 0.0>
  photons {
    collect off
  }
  // Scaling fixed
  // Rot Z limited (-90.0 to   0.0)
  // Translation fixed
  rotate -11.373625*z
  translate  <-0.4, -1.0, -3.95>
}
#declare Pothouse = union {
  object { SideWalldif }
  object { PothouseRoof }
  object { FrontDif }
  object { PothouseShutter }
  box { // PothouseBasement
    <-1, -1, -1>, <1, 1, 1>
    translate  <0.0, -1.0, -1.0>
    photons {
      collect off
    }
    scale <0.75, 0.5, 0.3>
    material {
      BrickWall
      // Transform to world space
      translate  <-1.22, 0.15, 0.0>
    }
  }
  photons {
    collect off
  }
  translate  <1.22, -0.15, 0.0>
}
#declare Group_GroundFloor = union {
  box { // GroundFloor_WestWall
    <-1, -1, -1>, <1, 1, 1>
    photons {
      collect off
    }
    scale <0.05, 4.7, 1.5>
    translate  <-1.95, 4.7, 1.5>
    material {
      BrickWall
      // Transform to world space
    }
  }
  box { // GroundFloor_EastWall
    <-1, -1, -1>, <1, 1, 1>
    photons {
      collect off
    }
    scale <0.05, 4.7, 1.5>
    translate  <1.95, 4.7, 1.5>
    material {
      BrickWall
      // Transform to world space
    }
  }
  object { GroundFloor_Dif }
  object { Group_GroundFloor_DoorAndWindows }
  box { // Basement
    <-1, -1, -1>, <1, 1, 1>
    photons {
      collect off
    }
    scale <2.0, 4.77, 0.3>
    translate  <0.0, 4.62, -0.3>
    material {
      BrickWall
      // Transform to world space
    }
  }
  object { Pothouse }
  box { // Floor0_Floor
    <-1, -1, -1>, <1, 1, 1>
    translate  <0.0, 1.0, 1.0>
    photons {
      collect off
    }
    scale <1.9, 4.7, 0.02>
    translate  0.5*z
    material {
      WoodPanels
      // Transform to world space
    }
  }
  photons {
    collect off
  }
}
#declare Window1_1_1 = union {
  box { // Win1Vert5
    <-1, -1, -1>, <1, 1, 1>
    translate  <1.0, 0.0, 1.0>
    photons {
      collect off
    }
    // All transformations fixed
    scale <0.015, 0.025, 0.4>
    translate  <-1.4, -0.5, 4.0>
    material {
      DMFWood4Ver
      // Transform to world space
      translate  <1.68, 0.6, 0.0>
      translate  <-1.4, -0.5, 0.0>
      rotate 0.0*z rotate 0.0*y rotate 0.0*x
      translate  <-1.4, -0.5, 0.0>
      rotate 0.0*z rotate 0.0*y rotate 0.0*x
    }
  }
  box { // Win1Vert6
    <-1, -1, -1>, <1, 1, 1>
    translate  <-1.0, 0.0, 1.0>
    photons {
      collect off
    }
    // All transformations fixed
    scale <0.015, 0.025, 0.4>
    translate  <-1.04, -0.5, 4.0>
    material {
      DMFWood4Ver
      // Transform to world space
      translate  <1.68, 0.6, 0.0>
      translate  <-1.4, -0.5, 0.0>
      rotate 0.0*z rotate 0.0*y rotate 0.0*x
      translate  <-1.4, -0.5, 0.0>
      rotate 0.0*z rotate 0.0*y rotate 0.0*x
    }
  }
  box { // Win1Hor7
    <-1, -1, -1>, <1, 1, 1>
    translate  -1.0*z
    photons {
      collect off
    }
    // All transformations fixed
    scale <0.15, 0.025, 0.015>
    translate  <-1.22, -0.5, 4.8>
    material {
      DMFWood4Hor
      // Transform to world space
      translate  <1.68, 0.6, 0.0>
      translate  <-1.4, -0.5, 0.0>
      rotate 0.0*z rotate 0.0*y rotate 0.0*x
      translate  <-1.4, -0.5, 0.0>
      rotate 0.0*z rotate 0.0*y rotate 0.0*x
    }
  }
  box { // Win1Hor8
    <-1, -1, -1>, <1, 1, 1>
    translate  1.0*z
    photons {
      collect off
    }
    // All transformations fixed
    scale <0.15, 0.025, 0.015>
    translate  <-1.22, -0.5, 4.0>
    material {
      DMFWood4Hor
      // Transform to world space
      translate  <1.68, 0.6, 0.0>
      translate  <-1.4, -0.5, 0.0>
      rotate 0.0*z rotate 0.0*y rotate 0.0*x
      translate  <-1.4, -0.5, 0.0>
      rotate 0.0*z rotate 0.0*y rotate 0.0*x
    }
  }
  box { // Win1Pane3
    <-1, -1, -1>, <1, 1, 1>
    translate  1.0*z
    photons {
      collect off
    }
    // All transformations fixed
    scale <0.165, 0.001, 0.385>
    translate  <-1.22, -0.5, 4.015>
    material {
      WindowGlass
      // Transform to world space
      translate  <1.68, 0.6, 0.0>
      translate  <-1.4, -0.5, 0.0>
      rotate 0.0*z rotate 0.0*y rotate 0.0*x
      translate  <-1.4, -0.5, 0.0>
      rotate 0.0*z rotate 0.0*y rotate 0.0*x
    }
  }
  box { // Win1Hor10
    <-1, -1, -1>, <1, 1, 1>
    translate  1.0*z
    photons {
      collect off
    }
    // All transformations fixed
    scale <0.15, 0.025, 0.015>
    translate  <-1.22, -0.5, 4.4>
    material {
      DMFWood4Hor
      // Transform to world space
      translate  <1.68, 0.6, 0.0>
      translate  <-1.4, -0.5, 0.0>
      rotate 0.0*z rotate 0.0*y rotate 0.0*x
      translate  <-1.4, -0.5, 0.0>
      rotate 0.0*z rotate 0.0*y rotate 0.0*x
    }
  }
  rotate <-0.0, -0.0, -0.0>
  translate  <1.4, 0.5, 0.0>
  photons {
    collect off
  }
  // Scaling fixed
  // Rot Z limited (0.0 to   90.0)
  // Translation fixed
  translate  <-1.68, -0.6, 0.0>
}
#declare CSG005 = union {
  cylinder { // Cylndr034
    <0,0,1>, <0,0,0>, 1 
    photons {
      collect off
    }
    // All transformations fixed
    scale 0.02
    rotate 90.0*x
    translate  <-1.48, -0.65, 4.22>
  }
  cylinder { // Cylndr035
    <0,0,1>, <0,0,0>, 1 
    photons {
      collect off
    }
    // All transformations fixed
    scale 0.02
    rotate 90.0*x
    translate  <-1.48, -0.65, 4.18>
  }
  photons {
    collect off
  }
  // All transformations fixed
}
#declare HingeDif1 = difference {
  object { CSG005 }
  cylinder { // Cylndr036
    <0,0,1>, <0,0,0>, 1 
    photons {
      collect off
    }
    // All transformations fixed
    scale <0.02, 0.02, 0.021>
    rotate 90.0*x
    translate  <-1.495, -0.65, 4.23>
  }
  cylinder { // Cylndr037
    <0,0,1>, <0,0,0>, 1 
    photons {
      collect off
    }
    // All transformations fixed
    scale <0.02, 0.02, 0.021>
    rotate 90.0*x
    translate  <-1.495, -0.65, 4.17>
  }
  photons {
    collect off
  }
  // All transformations fixed
}
#declare ShutterHinge1 = union {
  box { // ShutterHingeIron1
    <-1, -1, -1>, <1, 1, 1>
    translate  <1.0, -1.0, 0.0>
    photons {
      collect off
    }
    // All transformations fixed
    scale <0.1, 0.01, 0.01>
    translate  <-1.68, -0.65, 4.2>
  }
  object { HingeDif1 }
  photons {
    collect off
  }
  // All transformations fixed
  material {
    New_Brass
    // Transform to world space
    translate  <1.674513, 0.647083, 0.0>
    translate  <-1.68, -0.65, 0.0>
    translate  <-1.68, -0.65, 0.0>
  }
}
#declare CSG006 = union {
  cylinder { // Cylndr038
    <0,0,1>, <0,0,0>, 1 
    photons {
      collect off
    }
    // All transformations fixed
    scale 0.02
    rotate 90.0*x
    translate  <-1.48, -0.65, 4.22>
  }
  cylinder { // Cylndr039
    <0,0,1>, <0,0,0>, 1 
    photons {
      collect off
    }
    // All transformations fixed
    scale 0.02
    rotate 90.0*x
    translate  <-1.48, -0.65, 4.18>
  }
  photons {
    collect off
  }
  // All transformations fixed
}
#declare HingeDif2 = difference {
  object { CSG006 }
  cylinder { // Cylndr040
    <0,0,1>, <0,0,0>, 1 
    photons {
      collect off
    }
    // All transformations fixed
    scale <0.02, 0.02, 0.021>
    rotate 90.0*x
    translate  <-1.495, -0.65, 4.23>
  }
  cylinder { // Cylndr041
    <0,0,1>, <0,0,0>, 1 
    photons {
      collect off
    }
    // All transformations fixed
    scale <0.02, 0.02, 0.021>
    rotate 90.0*x
    translate  <-1.495, -0.65, 4.17>
  }
  photons {
    collect off
  }
  // All transformations fixed
}
#declare ShutterHinge2 = union {
  box { // ShutterHingeIron2
    <-1, -1, -1>, <1, 1, 1>
    translate  <1.0, -1.0, 0.0>
    photons {
      collect off
    }
    // All transformations fixed
    scale <0.1, 0.01, 0.01>
    translate  <-1.68, -0.65, 4.2>
  }
  object { HingeDif2 }
  photons {
    collect off
  }
  // All transformations fixed
  translate  0.4*z
  material {
    New_Brass
    // Transform to world space
    translate  <1.674513, 0.647083, 0.0>
    translate  <-1.68, -0.65, 0.0>
    translate  <-1.68, -0.65, 0.0>
  }
}
#declare ShutterWin1 = union {
  box { // Cube014
    <-1, -1, -1>, <1, 1, 1>
    translate  <1.0, 0.0, 1.0>
    photons {
      collect off
    }
    // All transformations fixed
    scale <0.18, 0.01, 0.4>
    translate  <-1.68, -0.65, 4.0>
    material {
      T_Wood7
      // Transform to world space
      translate  <1.674513, 0.647083, 0.0>
      translate  <-1.68, -0.65, 0.0>
      translate  <-1.68, -0.65, 0.0>
    }
  }
  object { ShutterHinge1 }
  object { ShutterHinge2 }
  cylinder { // Shutterholder1
    <0,0,1>, <0,0,0>, 1 
    photons {
      collect off
    }
    // Scaling fixed
    // Rot Z limited (0.0 to     90.0)
    // Translation fixed
    scale <0.005, 0.005, 0.4>
    rotate <-90.0, 0.0, 49.715675>
    translate  <-1.52, -0.65, 4.01>
    material {
      New_Brass
      // Transform to world space
      translate  <1.674513, 0.647083, 0.0>
      translate  <-1.68, -0.65, 0.0>
      translate  <-1.68, -0.65, 0.0>
    }
  }
  translate  <1.68, 0.65, 0.0>
  photons {
    collect off
  }
  // Scaling fixed
  // Rot Z limited (-120.0 to   0.0)
  // Translation fixed
  translate  <-1.674513, -0.647083, 0.0>
}
#declare Group_Window1 = union {
  box { // Floor1Sill1
    <-1, -1, -1>, <1, 1, 1>
    translate  1.0*z
    photons {
      collect off
    }
    scale <0.19, 0.2, 0.025>
    translate  <-1.5, -0.55, 3.95>
    material {
      DMFWood4Hor
      // Transform to world space
    }
  }
  box { // Floor1Vert1
    <-1, -1, -1>, <1, 1, 1>
    translate  <-1.0, 0.0, 1.0>
    photons {
      collect off
    }
    scale <0.015, 0.2, 0.655>
    translate  <-1.68, -0.5, 3.95>
    material {
      DMFWood4Ver
      // Transform to world space
    }
  }
  box { // Floor1Vert2
    <-1, -1, -1>, <1, 1, 1>
    translate  <1.0, 0.0, 1.0>
    photons {
      collect off
    }
    scale <0.015, 0.2, 0.655>
    translate  <-1.32, -0.5, 3.95>
    material {
      DMFWood4Ver
      // Transform to world space
    }
  }
  box { // Floor1Upper1
    <-1, -1, -1>, <1, 1, 1>
    translate  -1.0*z
    photons {
      collect off
    }
    scale <0.18, 0.2, 0.015>
    translate  <-1.5, -0.5, 5.26>
    material {
      DMFWood4Hor
      // Transform to world space
    }
  }
  object { Window1_1_1 }
  object { ShutterWin1 }
  photons {
    collect off
  }
}
#declare Window1_2_1 = union {
  box { // Win1Vert9
    <-1, -1, -1>, <1, 1, 1>
    translate  <1.0, 0.0, 1.0>
    photons {
      collect off
    }
    // All transformations fixed
    scale <0.015, 0.025, 0.4>
    translate  <-1.4, -0.5, 4.0>
    material {
      DMFWood4Ver
      // Transform to world space
      translate  <0.75, 0.6, 0.0>
      rotate -16.740458*z
      translate  <-1.4, -0.5, 0.0>
      rotate 0.0*z rotate 0.0*y rotate 0.0*x
      translate  <-1.4, -0.5, 0.0>
      rotate 0.0*z rotate 0.0*y rotate 0.0*x
    }
  }
  box { // Win1Vert10
    <-1, -1, -1>, <1, 1, 1>
    translate  <-1.0, 0.0, 1.0>
    photons {
      collect off
    }
    // All transformations fixed
    scale <0.015, 0.025, 0.4>
    translate  <-1.05, -0.5, 4.0>
    material {
      DMFWood4Ver
      // Transform to world space
      translate  <0.75, 0.6, 0.0>
      rotate -16.740458*z
      translate  <-1.4, -0.5, 0.0>
      rotate 0.0*z rotate 0.0*y rotate 0.0*x
      translate  <-1.4, -0.5, 0.0>
      rotate 0.0*z rotate 0.0*y rotate 0.0*x
    }
  }
  box { // Win1Hor15
    <-1, -1, -1>, <1, 1, 1>
    translate  -1.0*z
    photons {
      collect off
    }
    // All transformations fixed
    scale <0.15, 0.025, 0.015>
    translate  <-1.22, -0.5, 4.8>
    material {
      DMFWood4Hor
      // Transform to world space
      translate  <0.75, 0.6, 0.0>
      rotate -16.740458*z
      translate  <-1.4, -0.5, 0.0>
      rotate 0.0*z rotate 0.0*y rotate 0.0*x
      translate  <-1.4, -0.5, 0.0>
      rotate 0.0*z rotate 0.0*y rotate 0.0*x
    }
  }
  box { // Win1Hor16
    <-1, -1, -1>, <1, 1, 1>
    translate  1.0*z
    photons {
      collect off
    }
    // All transformations fixed
    scale <0.15, 0.025, 0.015>
    translate  <-1.22, -0.5, 4.0>
    material {
      DMFWood4Hor
      // Transform to world space
      translate  <0.75, 0.6, 0.0>
      rotate -16.740458*z
      translate  <-1.4, -0.5, 0.0>
      rotate 0.0*z rotate 0.0*y rotate 0.0*x
      translate  <-1.4, -0.5, 0.0>
      rotate 0.0*z rotate 0.0*y rotate 0.0*x
    }
  }
  box { // Win1Pane5
    <-1, -1, -1>, <1, 1, 1>
    translate  1.0*z
    photons {
      collect off
    }
    // All transformations fixed
    scale <0.165, 0.001, 0.385>
    translate  <-1.22, -0.5, 4.015>
    material {
      WindowGlass
      // Transform to world space
      translate  <0.75, 0.6, 0.0>
      rotate -16.740458*z
      translate  <-1.4, -0.5, 0.0>
      rotate 0.0*z rotate 0.0*y rotate 0.0*x
      translate  <-1.4, -0.5, 0.0>
      rotate 0.0*z rotate 0.0*y rotate 0.0*x
    }
  }
  box { // Win1Hor18
    <-1, -1, -1>, <1, 1, 1>
    translate  1.0*z
    photons {
      collect off
    }
    // All transformations fixed
    scale <0.15, 0.025, 0.015>
    translate  <-1.22, -0.5, 4.4>
    material {
      DMFWood4Hor
      // Transform to world space
      translate  <0.75, 0.6, 0.0>
      rotate -16.740458*z
      translate  <-1.4, -0.5, 0.0>
      rotate 0.0*z rotate 0.0*y rotate 0.0*x
      translate  <-1.4, -0.5, 0.0>
      rotate 0.0*z rotate 0.0*y rotate 0.0*x
    }
  }
  rotate <-0.0, -0.0, -0.0>
  translate  <1.4, 0.5, 0.0>
  photons {
    collect off
  }
  // Scaling fixed
  // Rot Z limited (0.0 to   90.0)
  // Translation fixed
  rotate 16.740458*z
  translate  <-0.75, -0.6, 0.0>
}
#declare Window1_2_2 = union {
  box { // Win1Vert11
    <-1, -1, -1>, <1, 1, 1>
    translate  <1.0, 0.0, 1.0>
    photons {
      collect off
    }
    // All transformations fixed
    scale <0.015, 0.025, 0.4>
    translate  <-1.39, -0.5, 4.0>
    material {
      DMFWood4Ver
      // Transform to world space
      translate  <0.05, 0.6, 0.0>
      rotate 45.776661*z
      translate  <-1.04, -0.5, 0.0>
      rotate 0.0*z rotate 0.0*y rotate 0.0*x
      translate  <-1.04, -0.5, 0.0>
      rotate 0.0*z rotate 0.0*y rotate 0.0*x
    }
  }
  box { // Win1Vert12
    <-1, -1, -1>, <1, 1, 1>
    translate  <-1.0, 0.0, 1.0>
    photons {
      collect off
    }
    // All transformations fixed
    scale <0.015, 0.025, 0.4>
    translate  <-1.04, -0.5, 4.0>
    material {
      DMFWood4Ver
      // Transform to world space
      translate  <0.05, 0.6, 0.0>
      rotate 45.776661*z
      translate  <-1.04, -0.5, 0.0>
      rotate 0.0*z rotate 0.0*y rotate 0.0*x
      translate  <-1.04, -0.5, 0.0>
      rotate 0.0*z rotate 0.0*y rotate 0.0*x
    }
  }
  box { // Win1Hor19
    <-1, -1, -1>, <1, 1, 1>
    translate  -1.0*z
    photons {
      collect off
    }
    // All transformations fixed
    scale <0.15, 0.025, 0.015>
    translate  <-1.22, -0.5, 4.8>
    material {
      DMFWood4Hor
      // Transform to world space
      translate  <0.05, 0.6, 0.0>
      rotate 45.776661*z
      translate  <-1.04, -0.5, 0.0>
      rotate 0.0*z rotate 0.0*y rotate 0.0*x
      translate  <-1.04, -0.5, 0.0>
      rotate 0.0*z rotate 0.0*y rotate 0.0*x
    }
  }
  box { // Win1Hor20
    <-1, -1, -1>, <1, 1, 1>
    translate  1.0*z
    photons {
      collect off
    }
    // All transformations fixed
    scale <0.15, 0.025, 0.015>
    translate  <-1.22, -0.5, 4.0>
    material {
      DMFWood4Hor
      // Transform to world space
      translate  <0.05, 0.6, 0.0>
      rotate 45.776661*z
      translate  <-1.04, -0.5, 0.0>
      rotate 0.0*z rotate 0.0*y rotate 0.0*x
      translate  <-1.04, -0.5, 0.0>
      rotate 0.0*z rotate 0.0*y rotate 0.0*x
    }
  }
  box { // Win1Pane6
    <-1, -1, -1>, <1, 1, 1>
    translate  1.0*z
    photons {
      collect off
    }
    // All transformations fixed
    scale <0.165, 0.001, 0.385>
    translate  <-1.22, -0.5, 4.015>
    material {
      WindowGlass
      // Transform to world space
      translate  <0.05, 0.6, 0.0>
      rotate 45.776661*z
      translate  <-1.04, -0.5, 0.0>
      rotate 0.0*z rotate 0.0*y rotate 0.0*x
      translate  <-1.04, -0.5, 0.0>
      rotate 0.0*z rotate 0.0*y rotate 0.0*x
    }
  }
  box { // Win1Hor22
    <-1, -1, -1>, <1, 1, 1>
    translate  1.0*z
    photons {
      collect off
    }
    // All transformations fixed
    scale <0.15, 0.025, 0.015>
    translate  <-1.22, -0.5, 4.4>
    material {
      DMFWood4Hor
      // Transform to world space
      translate  <0.05, 0.6, 0.0>
      rotate 45.776661*z
      translate  <-1.04, -0.5, 0.0>
      rotate 0.0*z rotate 0.0*y rotate 0.0*x
      translate  <-1.04, -0.5, 0.0>
      rotate 0.0*z rotate 0.0*y rotate 0.0*x
    }
  }
  rotate <-0.0, -0.0, 0.0>
  translate  <1.04, 0.5, 0.0>
  photons {
    collect off
  }
  // Scaling fixed
  // Rot Z limited (-90.0 to   0.0)
  // Translation fixed
  rotate -45.776661*z
  translate  <-0.05, -0.6, 0.0>
}
#declare CSG007 = union {
  cylinder { // Cylndr042
    <0,0,1>, <0,0,0>, 1 
    photons {
      collect off
    }
    // All transformations fixed
    scale 0.02
    rotate 90.0*x
    translate  <-1.48, -0.65, 4.22>
  }
  cylinder { // Cylndr043
    <0,0,1>, <0,0,0>, 1 
    photons {
      collect off
    }
    // All transformations fixed
    scale 0.02
    rotate 90.0*x
    translate  <-1.48, -0.65, 4.18>
  }
  photons {
    collect off
  }
  // All transformations fixed
}
#declare HingeDif3 = difference {
  object { CSG007 }
  cylinder { // Cylndr044
    <0,0,1>, <0,0,0>, 1 
    photons {
      collect off
    }
    // All transformations fixed
    scale <0.02, 0.02, 0.021>
    rotate 90.0*x
    translate  <-1.495, -0.65, 4.23>
  }
  cylinder { // Cylndr045
    <0,0,1>, <0,0,0>, 1 
    photons {
      collect off
    }
    // All transformations fixed
    scale <0.02, 0.02, 0.021>
    rotate 90.0*x
    translate  <-1.495, -0.65, 4.17>
  }
  photons {
    collect off
  }
  // All transformations fixed
}
#declare ShutterHinge3 = union {
  box { // ShutterHingeIron3
    <-1, -1, -1>, <1, 1, 1>
    translate  <1.0, -1.0, 0.0>
    photons {
      collect off
    }
    // All transformations fixed
    scale <0.1, 0.01, 0.01>
    translate  <-1.68, -0.65, 4.2>
  }
  object { HingeDif3 }
  photons {
    collect off
  }
  // All transformations fixed
  material {
    New_Brass
    // Transform to world space
    translate  <0.75, 0.647083, 0.0>
    rotate 120.0*z
    translate  <-1.68, -0.65, 0.0>
    translate  <-1.68, -0.65, 0.0>
  }
}
#declare CSG008 = union {
  cylinder { // Cylndr046
    <0,0,1>, <0,0,0>, 1 
    photons {
      collect off
    }
    // All transformations fixed
    scale 0.02
    rotate 90.0*x
    translate  <-1.48, -0.65, 4.22>
  }
  cylinder { // Cylndr047
    <0,0,1>, <0,0,0>, 1 
    photons {
      collect off
    }
    // All transformations fixed
    scale 0.02
    rotate 90.0*x
    translate  <-1.48, -0.65, 4.18>
  }
  photons {
    collect off
  }
  // All transformations fixed
}
#declare HingeDif4 = difference {
  object { CSG008 }
  cylinder { // Cylndr048
    <0,0,1>, <0,0,0>, 1 
    photons {
      collect off
    }
    // All transformations fixed
    scale <0.02, 0.02, 0.021>
    rotate 90.0*x
    translate  <-1.495, -0.65, 4.23>
  }
  cylinder { // Cylndr049
    <0,0,1>, <0,0,0>, 1 
    photons {
      collect off
    }
    // All transformations fixed
    scale <0.02, 0.02, 0.021>
    rotate 90.0*x
    translate  <-1.495, -0.65, 4.17>
  }
  photons {
    collect off
  }
  // All transformations fixed
}
#declare ShutterHinge4 = union {
  box { // ShutterHingeIron4
    <-1, -1, -1>, <1, 1, 1>
    translate  <1.0, -1.0, 0.0>
    photons {
      collect off
    }
    // All transformations fixed
    scale <0.1, 0.01, 0.01>
    translate  <-1.68, -0.65, 4.2>
  }
  object { HingeDif4 }
  photons {
    collect off
  }
  // All transformations fixed
  translate  0.4*z
  material {
    New_Brass
    // Transform to world space
    translate  <0.75, 0.647083, 0.0>
    rotate 120.0*z
    translate  <-1.68, -0.65, 0.0>
    translate  <-1.68, -0.65, 0.0>
  }
}
#declare ShutterWin2_1 = union {
  box { // Cube015
    <-1, -1, -1>, <1, 1, 1>
    translate  <1.0, 0.0, 1.0>
    photons {
      collect off
    }
    // All transformations fixed
    scale <0.175, 0.01, 0.4>
    translate  <-1.68, -0.65, 4.0>
    material {
      T_Wood7
      // Transform to world space
      translate  <0.75, 0.647083, 0.0>
      rotate 120.0*z
      translate  <-1.68, -0.65, 0.0>
      translate  <-1.68, -0.65, 0.0>
    }
  }
  object { ShutterHinge3 }
  object { ShutterHinge4 }
  cylinder { // Shutterholder2
    <0,0,1>, <0,0,0>, 1 
    photons {
      collect off
    }
    // Scaling fixed
    // Rot Z limited (0.0 to     90.0)
    // Translation fixed
    scale <0.005, 0.005, 0.4>
    rotate <-90.0, 0.0, 49.715675>
    translate  <-1.52, -0.65, 4.01>
    material {
      New_Brass
      // Transform to world space
      translate  <0.75, 0.647083, 0.0>
      rotate 120.0*z
      translate  <-1.68, -0.65, 0.0>
      translate  <-1.68, -0.65, 0.0>
    }
  }
  translate  <1.68, 0.65, 0.0>
  photons {
    collect off
  }
  // Scaling fixed
  // Rot Z limited (-120.0 to   0.0)
  // Translation fixed
  rotate -120.0*z
  translate  <-0.75, -0.647083, 0.0>
}
#declare CSG009 = union {
  cylinder { // Cylndr050
    <0,0,1>, <0,0,0>, 1 
    photons {
      collect off
    }
    // All transformations fixed
    scale 0.02
    rotate 90.0*x
    translate  <-1.48, -0.65, 4.22>
  }
  cylinder { // Cylndr051
    <0,0,1>, <0,0,0>, 1 
    photons {
      collect off
    }
    // All transformations fixed
    scale 0.02
    rotate 90.0*x
    translate  <-1.48, -0.65, 4.18>
  }
  photons {
    collect off
  }
  // All transformations fixed
}
#declare HingeDif5 = difference {
  object { CSG009 }
  cylinder { // Cylndr052
    <0,0,1>, <0,0,0>, 1 
    photons {
      collect off
    }
    // All transformations fixed
    scale <0.02, 0.02, 0.021>
    rotate 90.0*x
    translate  <-1.495, -0.65, 4.23>
  }
  cylinder { // Cylndr053
    <0,0,1>, <0,0,0>, 1 
    photons {
      collect off
    }
    // All transformations fixed
    scale <0.02, 0.02, 0.021>
    rotate 90.0*x
    translate  <-1.495, -0.65, 4.17>
  }
  photons {
    collect off
  }
  // All transformations fixed
}
#declare ShutterHinge5 = union {
  box { // ShutterHingeIron5
    <-1, -1, -1>, <1, 1, 1>
    translate  <1.0, -1.0, 0.0>
    photons {
      collect off
    }
    // All transformations fixed
    scale <0.1, 0.01, 0.01>
    translate  <-1.68, -0.65, 4.2>
  }
  object { HingeDif5 }
  photons {
    collect off
  }
  // All transformations fixed
  material {
    New_Brass
    // Transform to world space
    translate  <0.05, 0.647083, 0.0>
    rotate -75.0*z
    scale <1.0/-1.0, 1.0/1.0, 1.0/1.0>
    translate  <-1.68, -0.65, 0.0>
    translate  <-1.68, -0.65, 0.0>
  }
}
#declare CSG010 = union {
  cylinder { // Cylndr054
    <0,0,1>, <0,0,0>, 1 
    photons {
      collect off
    }
    // All transformations fixed
    scale 0.02
    rotate 90.0*x
    translate  <-1.48, -0.65, 4.22>
  }
  cylinder { // Cylndr055
    <0,0,1>, <0,0,0>, 1 
    photons {
      collect off
    }
    // All transformations fixed
    scale 0.02
    rotate 90.0*x
    translate  <-1.48, -0.65, 4.18>
  }
  photons {
    collect off
  }
  // All transformations fixed
}
#declare HingeDif6 = difference {
  object { CSG010 }
  cylinder { // Cylndr056
    <0,0,1>, <0,0,0>, 1 
    photons {
      collect off
    }
    // All transformations fixed
    scale <0.02, 0.02, 0.021>
    rotate 90.0*x
    translate  <-1.495, -0.65, 4.23>
  }
  cylinder { // Cylndr057
    <0,0,1>, <0,0,0>, 1 
    photons {
      collect off
    }
    // All transformations fixed
    scale <0.02, 0.02, 0.021>
    rotate 90.0*x
    translate  <-1.495, -0.65, 4.17>
  }
  photons {
    collect off
  }
  // All transformations fixed
}
#declare ShutterHinge6 = union {
  box { // ShutterHingeIron6
    <-1, -1, -1>, <1, 1, 1>
    translate  <1.0, -1.0, 0.0>
    photons {
      collect off
    }
    // All transformations fixed
    scale <0.1, 0.01, 0.01>
    translate  <-1.68, -0.65, 4.2>
  }
  object { HingeDif6 }
  photons {
    collect off
  }
  // All transformations fixed
  translate  0.4*z
  material {
    New_Brass
    // Transform to world space
    translate  <0.05, 0.647083, 0.0>
    rotate -75.0*z
    scale <1.0/-1.0, 1.0/1.0, 1.0/1.0>
    translate  <-1.68, -0.65, 0.0>
    translate  <-1.68, -0.65, 0.0>
  }
}
#declare ShutterWin2_2 = union {
  box { // Cube016
    <-1, -1, -1>, <1, 1, 1>
    translate  <1.0, 0.0, 1.0>
    photons {
      collect off
    }
    // All transformations fixed
    scale <0.175, 0.01, 0.4>
    translate  <-1.68, -0.65, 4.0>
    material {
      T_Wood7
      // Transform to world space
      translate  <0.05, 0.647083, 0.0>
      rotate -75.0*z
      scale <1.0/-1.0, 1.0/1.0, 1.0/1.0>
      translate  <-1.68, -0.65, 0.0>
      translate  <-1.68, -0.65, 0.0>
    }
  }
  object { ShutterHinge5 }
  object { ShutterHinge6 }
  cylinder { // Shutterholder3
    <0,0,1>, <0,0,0>, 1 
    photons {
      collect off
    }
    // Scaling fixed
    // Rot Z limited (0.0 to     90.0)
    // Translation fixed
    scale <0.005, 0.005, 0.4>
    rotate <-90.0, 0.0, 49.715675>
    translate  <-1.52, -0.65, 4.01>
    material {
      New_Brass
      // Transform to world space
      translate  <0.05, 0.647083, 0.0>
      rotate -75.0*z
      scale <1.0/-1.0, 1.0/1.0, 1.0/1.0>
      translate  <-1.68, -0.65, 0.0>
      translate  <-1.68, -0.65, 0.0>
    }
  }
  translate  <1.68, 0.65, 0.0>
  photons {
    collect off
  }
  // Scaling fixed
  // Rot Z limited (0.0 to   75.0)
  // Translation fixed
  scale <-1.0, 1.0, 1.0>
  rotate 75.0*z
  translate  <-0.05, -0.647083, 0.0>
}
#declare Group_Window2 = union {
  box { // Floor1Sill2
    <-1, -1, -1>, <1, 1, 1>
    translate  1.0*z
    material {
      DMFWood4Hor
    }
    photons {
      collect off
    }
    scale <0.36, 0.2, 0.025>
    translate  <-0.4, -0.55, 3.95>
  }
  box { // Floor1Vert3
    <-1, -1, -1>, <1, 1, 1>
    translate  <-1.0, 0.0, 1.0>
    material {
      DMFWood4Ver
    }
    photons {
      collect off
    }
    scale <0.015, 0.2, 0.655>
    translate  <-0.75, -0.5, 3.95>
  }
  box { // Floor1Upper2
    <-1, -1, -1>, <1, 1, 1>
    translate  -1.0*z
    material {
      DMFWood4Hor
    }
    photons {
      collect off
    }
    scale <0.35, 0.2, 0.015>
    translate  <-0.4, -0.5, 5.26>
  }
  box { // Floor1Window1vert2
    <-1, -1, -1>, <1, 1, 1>
    translate  1.0*z
    photons {
      collect off
    }
    scale <0.015, 0.05, 0.22>
    translate  <-0.4, -0.6, 4.8>
    material {
      DMFWood4Ver
      // Transform to world space
    }
  }
  object { Window1_2_1 }
  object { Window1_2_2 }
  object { ShutterWin2_1 }
  object { ShutterWin2_2 }
  photons {
    collect off
  }
}
#declare Window1_3_1 = union {
  box { // Win1Vert13
    <-1, -1, -1>, <1, 1, 1>
    translate  <1.0, 0.0, 1.0>
    photons {
      collect off
    }
    // All transformations fixed
    scale <0.015, 0.025, 0.4>
    translate  <-1.4, -0.5, 4.0>
    material {
      DMFWood4Ver
      // Transform to world space
      translate  <-0.05, 0.6, 0.0>
      rotate -21.202564*z
      translate  <-1.4, -0.5, 0.0>
      rotate 0.0*z rotate 0.0*y rotate 0.0*x
      translate  <-1.4, -0.5, 0.0>
      rotate 0.0*z rotate 0.0*y rotate 0.0*x
    }
  }
  box { // Win1Vert14
    <-1, -1, -1>, <1, 1, 1>
    translate  <-1.0, 0.0, 1.0>
    photons {
      collect off
    }
    // All transformations fixed
    scale <0.015, 0.025, 0.4>
    translate  <-1.05, -0.5, 4.0>
    material {
      DMFWood4Ver
      // Transform to world space
      translate  <-0.05, 0.6, 0.0>
      rotate -21.202564*z
      translate  <-1.4, -0.5, 0.0>
      rotate 0.0*z rotate 0.0*y rotate 0.0*x
      translate  <-1.4, -0.5, 0.0>
      rotate 0.0*z rotate 0.0*y rotate 0.0*x
    }
  }
  box { // Win1Hor17
    <-1, -1, -1>, <1, 1, 1>
    translate  -1.0*z
    photons {
      collect off
    }
    // All transformations fixed
    scale <0.15, 0.025, 0.015>
    translate  <-1.22, -0.5, 4.8>
    material {
      DMFWood4Hor
      // Transform to world space
      translate  <-0.05, 0.6, 0.0>
      rotate -21.202564*z
      translate  <-1.4, -0.5, 0.0>
      rotate 0.0*z rotate 0.0*y rotate 0.0*x
      translate  <-1.4, -0.5, 0.0>
      rotate 0.0*z rotate 0.0*y rotate 0.0*x
    }
  }
  box { // Win1Hor21
    <-1, -1, -1>, <1, 1, 1>
    translate  1.0*z
    photons {
      collect off
    }
    // All transformations fixed
    scale <0.15, 0.025, 0.015>
    translate  <-1.22, -0.5, 4.0>
    material {
      DMFWood4Hor
      // Transform to world space
      translate  <-0.05, 0.6, 0.0>
      rotate -21.202564*z
      translate  <-1.4, -0.5, 0.0>
      rotate 0.0*z rotate 0.0*y rotate 0.0*x
      translate  <-1.4, -0.5, 0.0>
      rotate 0.0*z rotate 0.0*y rotate 0.0*x
    }
  }
  box { // Win1Pane7
    <-1, -1, -1>, <1, 1, 1>
    translate  1.0*z
    photons {
      collect off
    }
    // All transformations fixed
    scale <0.165, 0.001, 0.385>
    translate  <-1.22, -0.5, 4.015>
    material {
      WindowGlass
      // Transform to world space
      translate  <-0.05, 0.6, 0.0>
      rotate -21.202564*z
      translate  <-1.4, -0.5, 0.0>
      rotate 0.0*z rotate 0.0*y rotate 0.0*x
      translate  <-1.4, -0.5, 0.0>
      rotate 0.0*z rotate 0.0*y rotate 0.0*x
    }
  }
  box { // Win1Hor23
    <-1, -1, -1>, <1, 1, 1>
    translate  1.0*z
    photons {
      collect off
    }
    // All transformations fixed
    scale <0.15, 0.025, 0.015>
    translate  <-1.22, -0.5, 4.4>
    material {
      DMFWood4Hor
      // Transform to world space
      translate  <-0.05, 0.6, 0.0>
      rotate -21.202564*z
      translate  <-1.4, -0.5, 0.0>
      rotate 0.0*z rotate 0.0*y rotate 0.0*x
      translate  <-1.4, -0.5, 0.0>
      rotate 0.0*z rotate 0.0*y rotate 0.0*x
    }
  }
  rotate <-0.0, -0.0, -0.0>
  translate  <1.4, 0.5, 0.0>
  photons {
    collect off
  }
  // Scaling fixed
  // Rot Z limited (0.0 to   90.0)
  // Translation fixed
  rotate 21.202564*z
  translate  <0.05, -0.6, 0.0>
}
#declare Window1_3_2 = union {
  box { // Win1Vert15
    <-1, -1, -1>, <1, 1, 1>
    translate  <1.0, 0.0, 1.0>
    photons {
      collect off
    }
    // All transformations fixed
    scale <0.015, 0.025, 0.4>
    translate  <-1.39, -0.5, 4.0>
    material {
      DMFWood4Ver
      // Transform to world space
      translate  <-0.75, 0.6, 0.0>
      rotate 39.144852*z
      translate  <-1.04, -0.5, 0.0>
      rotate 0.0*z rotate 0.0*y rotate 0.0*x
      translate  <-1.04, -0.5, 0.0>
      rotate 0.0*z rotate 0.0*y rotate 0.0*x
    }
  }
  box { // Win1Vert16
    <-1, -1, -1>, <1, 1, 1>
    translate  <-1.0, 0.0, 1.0>
    photons {
      collect off
    }
    // All transformations fixed
    scale <0.015, 0.025, 0.4>
    translate  <-1.04, -0.5, 4.0>
    material {
      DMFWood4Ver
      // Transform to world space
      translate  <-0.75, 0.6, 0.0>
      rotate 39.144852*z
      translate  <-1.04, -0.5, 0.0>
      rotate 0.0*z rotate 0.0*y rotate 0.0*x
      translate  <-1.04, -0.5, 0.0>
      rotate 0.0*z rotate 0.0*y rotate 0.0*x
    }
  }
  box { // Win1Hor24
    <-1, -1, -1>, <1, 1, 1>
    translate  -1.0*z
    photons {
      collect off
    }
    // All transformations fixed
    scale <0.15, 0.025, 0.015>
    translate  <-1.22, -0.5, 4.8>
    material {
      DMFWood4Hor
      // Transform to world space
      translate  <-0.75, 0.6, 0.0>
      rotate 39.144852*z
      translate  <-1.04, -0.5, 0.0>
      rotate 0.0*z rotate 0.0*y rotate 0.0*x
      translate  <-1.04, -0.5, 0.0>
      rotate 0.0*z rotate 0.0*y rotate 0.0*x
    }
  }
  box { // Win1Hor25
    <-1, -1, -1>, <1, 1, 1>
    translate  1.0*z
    photons {
      collect off
    }
    // All transformations fixed
    scale <0.15, 0.025, 0.015>
    translate  <-1.22, -0.5, 4.0>
    material {
      DMFWood4Hor
      // Transform to world space
      translate  <-0.75, 0.6, 0.0>
      rotate 39.144852*z
      translate  <-1.04, -0.5, 0.0>
      rotate 0.0*z rotate 0.0*y rotate 0.0*x
      translate  <-1.04, -0.5, 0.0>
      rotate 0.0*z rotate 0.0*y rotate 0.0*x
    }
  }
  box { // Win1Pane8
    <-1, -1, -1>, <1, 1, 1>
    translate  1.0*z
    photons {
      collect off
    }
    // All transformations fixed
    scale <0.165, 0.001, 0.385>
    translate  <-1.22, -0.5, 4.015>
    material {
      WindowGlass
      // Transform to world space
      translate  <-0.75, 0.6, 0.0>
      rotate 39.144852*z
      translate  <-1.04, -0.5, 0.0>
      rotate 0.0*z rotate 0.0*y rotate 0.0*x
      translate  <-1.04, -0.5, 0.0>
      rotate 0.0*z rotate 0.0*y rotate 0.0*x
    }
  }
  box { // Win1Hor26
    <-1, -1, -1>, <1, 1, 1>
    translate  1.0*z
    photons {
      collect off
    }
    // All transformations fixed
    scale <0.15, 0.025, 0.015>
    translate  <-1.22, -0.5, 4.4>
    material {
      DMFWood4Hor
      // Transform to world space
      translate  <-0.75, 0.6, 0.0>
      rotate 39.144852*z
      translate  <-1.04, -0.5, 0.0>
      rotate 0.0*z rotate 0.0*y rotate 0.0*x
      translate  <-1.04, -0.5, 0.0>
      rotate 0.0*z rotate 0.0*y rotate 0.0*x
    }
  }
  rotate <-0.0, -0.0, 0.0>
  translate  <1.04, 0.5, 0.0>
  photons {
    collect off
  }
  // Scaling fixed
  // Rot Z limited (-90.0 to   0.0)
  // Translation fixed
  rotate -39.144852*z
  translate  <0.75, -0.6, 0.0>
}
#declare CSG011 = union {
  cylinder { // Cylndr058
    <0,0,1>, <0,0,0>, 1 
    photons {
      collect off
    }
    // All transformations fixed
    scale 0.02
    rotate 90.0*x
    translate  <-1.48, -0.65, 4.22>
  }
  cylinder { // Cylndr059
    <0,0,1>, <0,0,0>, 1 
    photons {
      collect off
    }
    // All transformations fixed
    scale 0.02
    rotate 90.0*x
    translate  <-1.48, -0.65, 4.18>
  }
  photons {
    collect off
  }
  // All transformations fixed
}
#declare HingeDif7 = difference {
  object { CSG011 }
  cylinder { // Cylndr060
    <0,0,1>, <0,0,0>, 1 
    photons {
      collect off
    }
    // All transformations fixed
    scale <0.02, 0.02, 0.021>
    rotate 90.0*x
    translate  <-1.495, -0.65, 4.23>
  }
  cylinder { // Cylndr061
    <0,0,1>, <0,0,0>, 1 
    photons {
      collect off
    }
    // All transformations fixed
    scale <0.02, 0.02, 0.021>
    rotate 90.0*x
    translate  <-1.495, -0.65, 4.17>
  }
  photons {
    collect off
  }
  // All transformations fixed
}
#declare ShutterHinge7 = union {
  box { // ShutterHingeIron7
    <-1, -1, -1>, <1, 1, 1>
    translate  <1.0, -1.0, 0.0>
    photons {
      collect off
    }
    // All transformations fixed
    scale <0.1, 0.01, 0.01>
    translate  <-1.68, -0.65, 4.2>
  }
  object { HingeDif7 }
  photons {
    collect off
  }
  // All transformations fixed
  material {
    New_Brass
    // Transform to world space
    translate  <-0.05, 0.647083, 0.0>
    rotate 75.0*z
    translate  <-1.68, -0.65, 0.0>
    translate  <-1.68, -0.65, 0.0>
  }
}
#declare CSG012 = union {
  cylinder { // Cylndr062
    <0,0,1>, <0,0,0>, 1 
    photons {
      collect off
    }
    // All transformations fixed
    scale 0.02
    rotate 90.0*x
    translate  <-1.48, -0.65, 4.22>
  }
  cylinder { // Cylndr063
    <0,0,1>, <0,0,0>, 1 
    photons {
      collect off
    }
    // All transformations fixed
    scale 0.02
    rotate 90.0*x
    translate  <-1.48, -0.65, 4.18>
  }
  photons {
    collect off
  }
  // All transformations fixed
}
#declare HingeDif8 = difference {
  object { CSG012 }
  cylinder { // Cylndr064
    <0,0,1>, <0,0,0>, 1 
    photons {
      collect off
    }
    // All transformations fixed
    scale <0.02, 0.02, 0.021>
    rotate 90.0*x
    translate  <-1.495, -0.65, 4.23>
  }
  cylinder { // Cylndr065
    <0,0,1>, <0,0,0>, 1 
    photons {
      collect off
    }
    // All transformations fixed
    scale <0.02, 0.02, 0.021>
    rotate 90.0*x
    translate  <-1.495, -0.65, 4.17>
  }
  photons {
    collect off
  }
  // All transformations fixed
}
#declare ShutterHinge8 = union {
  box { // ShutterHingeIron8
    <-1, -1, -1>, <1, 1, 1>
    translate  <1.0, -1.0, 0.0>
    photons {
      collect off
    }
    // All transformations fixed
    scale <0.1, 0.01, 0.01>
    translate  <-1.68, -0.65, 4.2>
  }
  object { HingeDif8 }
  photons {
    collect off
  }
  // All transformations fixed
  translate  0.4*z
  material {
    New_Brass
    // Transform to world space
    translate  <-0.05, 0.647083, 0.0>
    rotate 75.0*z
    translate  <-1.68, -0.65, 0.0>
    translate  <-1.68, -0.65, 0.0>
  }
}
#declare ShutterWin3_1 = union {
  box { // Cube017
    <-1, -1, -1>, <1, 1, 1>
    translate  <1.0, 0.0, 1.0>
    photons {
      collect off
    }
    // All transformations fixed
    scale <0.175, 0.01, 0.4>
    translate  <-1.68, -0.65, 4.0>
    material {
      T_Wood7
      // Transform to world space
      translate  <-0.05, 0.647083, 0.0>
      rotate 75.0*z
      translate  <-1.68, -0.65, 0.0>
      translate  <-1.68, -0.65, 0.0>
    }
  }
  object { ShutterHinge7 }
  object { ShutterHinge8 }
  cylinder { // Shutterholder4
    <0,0,1>, <0,0,0>, 1 
    photons {
      collect off
    }
    // Scaling fixed
    // Rot Z limited (0.0 to     90.0)
    // Translation fixed
    scale <0.005, 0.005, 0.4>
    rotate <-90.0, 0.0, 49.715675>
    translate  <-1.52, -0.65, 4.01>
    material {
      New_Brass
      // Transform to world space
      translate  <-0.05, 0.647083, 0.0>
      rotate 75.0*z
      translate  <-1.68, -0.65, 0.0>
      translate  <-1.68, -0.65, 0.0>
    }
  }
  translate  <1.68, 0.65, 0.0>
  photons {
    collect off
  }
  // Scaling fixed
  // Rot Z limited (-75.0 to   0.0)
  // Translation fixed
  rotate -75.0*z
  translate  <0.05, -0.647083, 0.0>
}
#declare CSG013 = union {
  cylinder { // Cylndr066
    <0,0,1>, <0,0,0>, 1 
    photons {
      collect off
    }
    // All transformations fixed
    scale 0.02
    rotate 90.0*x
    translate  <-1.48, -0.65, 4.22>
  }
  cylinder { // Cylndr067
    <0,0,1>, <0,0,0>, 1 
    photons {
      collect off
    }
    // All transformations fixed
    scale 0.02
    rotate 90.0*x
    translate  <-1.48, -0.65, 4.18>
  }
  photons {
    collect off
  }
  // All transformations fixed
}
#declare HingeDif9 = difference {
  object { CSG013 }
  cylinder { // Cylndr068
    <0,0,1>, <0,0,0>, 1 
    photons {
      collect off
    }
    // All transformations fixed
    scale <0.02, 0.02, 0.021>
    rotate 90.0*x
    translate  <-1.495, -0.65, 4.23>
  }
  cylinder { // Cylndr069
    <0,0,1>, <0,0,0>, 1 
    photons {
      collect off
    }
    // All transformations fixed
    scale <0.02, 0.02, 0.021>
    rotate 90.0*x
    translate  <-1.495, -0.65, 4.17>
  }
  photons {
    collect off
  }
  // All transformations fixed
}
#declare ShutterHinge9 = union {
  box { // ShutterHingeIron9
    <-1, -1, -1>, <1, 1, 1>
    translate  <1.0, -1.0, 0.0>
    photons {
      collect off
    }
    // All transformations fixed
    scale <0.1, 0.01, 0.01>
    translate  <-1.68, -0.65, 4.2>
  }
  object { HingeDif9 }
  photons {
    collect off
  }
  // All transformations fixed
  material {
    New_Brass
    // Transform to world space
    translate  <-0.75, 0.647083, 0.0>
    rotate -34.121738*z
    scale <1.0/-1.0, 1.0/1.0, 1.0/1.0>
    translate  <-1.68, -0.65, 0.0>
    translate  <-1.68, -0.65, 0.0>
  }
}
#declare CSG014 = union {
  cylinder { // Cylndr070
    <0,0,1>, <0,0,0>, 1 
    photons {
      collect off
    }
    // All transformations fixed
    scale 0.02
    rotate 90.0*x
    translate  <-1.48, -0.65, 4.22>
  }
  cylinder { // Cylndr071
    <0,0,1>, <0,0,0>, 1 
    photons {
      collect off
    }
    // All transformations fixed
    scale 0.02
    rotate 90.0*x
    translate  <-1.48, -0.65, 4.18>
  }
  photons {
    collect off
  }
  // All transformations fixed
}
#declare HingeDif10 = difference {
  object { CSG014 }
  cylinder { // Cylndr072
    <0,0,1>, <0,0,0>, 1 
    photons {
      collect off
    }
    // All transformations fixed
    scale <0.02, 0.02, 0.021>
    rotate 90.0*x
    translate  <-1.495, -0.65, 4.23>
  }
  cylinder { // Cylndr073
    <0,0,1>, <0,0,0>, 1 
    photons {
      collect off
    }
    // All transformations fixed
    scale <0.02, 0.02, 0.021>
    rotate 90.0*x
    translate  <-1.495, -0.65, 4.17>
  }
  photons {
    collect off
  }
  // All transformations fixed
}
#declare ShutterHinge10 = union {
  box { // ShutterHingeIron10
    <-1, -1, -1>, <1, 1, 1>
    translate  <1.0, -1.0, 0.0>
    photons {
      collect off
    }
    // All transformations fixed
    scale <0.1, 0.01, 0.01>
    translate  <-1.68, -0.65, 4.2>
  }
  object { HingeDif10 }
  photons {
    collect off
  }
  // All transformations fixed
  translate  0.4*z
  material {
    New_Brass
    // Transform to world space
    translate  <-0.75, 0.647083, 0.0>
    rotate -34.121738*z
    scale <1.0/-1.0, 1.0/1.0, 1.0/1.0>
    translate  <-1.68, -0.65, 0.0>
    translate  <-1.68, -0.65, 0.0>
  }
}
#declare ShutterWin3_2 = union {
  box { // Cube018
    <-1, -1, -1>, <1, 1, 1>
    translate  <1.0, 0.0, 1.0>
    photons {
      collect off
    }
    // All transformations fixed
    scale <0.175, 0.01, 0.4>
    translate  <-1.68, -0.65, 4.0>
    material {
      T_Wood7
      // Transform to world space
      translate  <-0.75, 0.647083, 0.0>
      rotate -34.121738*z
      scale <1.0/-1.0, 1.0/1.0, 1.0/1.0>
      translate  <-1.68, -0.65, 0.0>
      translate  <-1.68, -0.65, 0.0>
    }
  }
  object { ShutterHinge9 }
  object { ShutterHinge10 }
  cylinder { // Shutterholder5
    <0,0,1>, <0,0,0>, 1 
    photons {
      collect off
    }
    // Scaling fixed
    // Rot Z limited (0.0 to     90.0)
    // Translation fixed
    scale <0.005, 0.005, 0.4>
    rotate <-90.0, 0.0, 49.715675>
    translate  <-1.52, -0.65, 4.01>
    material {
      New_Brass
      // Transform to world space
      translate  <-0.75, 0.647083, 0.0>
      rotate -34.121738*z
      scale <1.0/-1.0, 1.0/1.0, 1.0/1.0>
      translate  <-1.68, -0.65, 0.0>
      translate  <-1.68, -0.65, 0.0>
    }
  }
  translate  <1.68, 0.65, 0.0>
  photons {
    collect off
  }
  // Scaling fixed
  // Rot Z limited (0.0 to   120.0)
  // Translation fixed
  scale <-1.0, 1.0, 1.0>
  rotate 34.121738*z
  translate  <0.75, -0.647083, 0.0>
}
#declare Group_Window3 = union {
  box { // Floor1Sill3
    <-1, -1, -1>, <1, 1, 1>
    translate  1.0*z
    material {
      DMFWood4Hor
    }
    photons {
      collect off
    }
    scale <0.36, 0.2, 0.025>
    translate  <0.4, -0.55, 3.95>
  }
  box { // Floor1Upper3
    <-1, -1, -1>, <1, 1, 1>
    translate  -1.0*z
    material {
      DMFWood4Hor
    }
    photons {
      collect off
    }
    scale <0.35, 0.2, 0.015>
    translate  <0.4, -0.5, 5.26>
  }
  box { // Floor1Vert4
    <-1, -1, -1>, <1, 1, 1>
    translate  <1.0, 0.0, 1.0>
    material {
      DMFWood4Ver
    }
    photons {
      collect off
    }
    scale <0.015, 0.2, 0.655>
    translate  <0.75, -0.5, 3.95>
  }
  box { // Floor1Window1vert3
    <-1, -1, -1>, <1, 1, 1>
    translate  1.0*z
    photons {
      collect off
    }
    scale <0.015, 0.05, 0.22>
    translate  <0.4, -0.6, 4.8>
    material {
      DMFWood4Ver
      // Transform to world space
    }
  }
  object { Window1_3_1 }
  object { Window1_3_2 }
  object { ShutterWin3_1 }
  object { ShutterWin3_2 }
  photons {
    collect off
  }
}
#declare Window1_1_2 = union {
  box { // Win1Vert7
    <-1, -1, -1>, <1, 1, 1>
    translate  <1.0, 0.0, 1.0>
    photons {
      collect off
    }
    // All transformations fixed
    scale <0.015, 0.025, 0.29>
    translate  <-1.4, -0.5, 4.65>
    material {
      DMFWood4Ver
      // Transform to world space
      translate  <-1.03, 0.6, 0.0>
      rotate 24.218243*z
      translate  <-1.4, -0.5, 0.0>
      rotate 0.0*z rotate 0.0*y rotate 0.0*x
      translate  <-1.4, -0.5, 0.0>
      rotate 0.0*z rotate 0.0*y rotate 0.0*x
    }
  }
  box { // Win1Vert8
    <-1, -1, -1>, <1, 1, 1>
    translate  <-1.0, 0.0, 1.0>
    photons {
      collect off
    }
    // All transformations fixed
    scale <0.015, 0.025, 0.29>
    translate  <-1.06, -0.5, 4.65>
    material {
      DMFWood4Ver
      // Transform to world space
      translate  <-1.03, 0.6, 0.0>
      rotate 24.218243*z
      translate  <-1.4, -0.5, 0.0>
      rotate 0.0*z rotate 0.0*y rotate 0.0*x
      translate  <-1.4, -0.5, 0.0>
      rotate 0.0*z rotate 0.0*y rotate 0.0*x
    }
  }
  box { // Win1Hor9
    <-1, -1, -1>, <1, 1, 1>
    translate  -1.0*z
    photons {
      collect off
    }
    // All transformations fixed
    scale <0.15, 0.025, 0.015>
    translate  <-1.23, -0.5, 5.23>
    material {
      DMFWood4Hor
      // Transform to world space
      translate  <-1.03, 0.6, 0.0>
      rotate 24.218243*z
      translate  <-1.4, -0.5, 0.0>
      rotate 0.0*z rotate 0.0*y rotate 0.0*x
      translate  <-1.4, -0.5, 0.0>
      rotate 0.0*z rotate 0.0*y rotate 0.0*x
    }
  }
  box { // Win1Hor11
    <-1, -1, -1>, <1, 1, 1>
    translate  1.0*z
    photons {
      collect off
    }
    // All transformations fixed
    scale <0.15, 0.025, 0.015>
    translate  <-1.23, -0.5, 4.65>
    material {
      DMFWood4Hor
      // Transform to world space
      translate  <-1.03, 0.6, 0.0>
      rotate 24.218243*z
      translate  <-1.4, -0.5, 0.0>
      rotate 0.0*z rotate 0.0*y rotate 0.0*x
      translate  <-1.4, -0.5, 0.0>
      rotate 0.0*z rotate 0.0*y rotate 0.0*x
    }
  }
  box { // Win1Pane4
    <-1, -1, -1>, <1, 1, 1>
    translate  1.0*z
    photons {
      collect off
    }
    // All transformations fixed
    scale <0.15, 0.001, 0.278>
    translate  <-1.23, -0.5, 4.66>
    material {
      WindowGlass
      // Transform to world space
      translate  <-1.03, 0.6, 0.0>
      rotate 24.218243*z
      translate  <-1.4, -0.5, 0.0>
      rotate 0.0*z rotate 0.0*y rotate 0.0*x
      translate  <-1.4, -0.5, 0.0>
      rotate 0.0*z rotate 0.0*y rotate 0.0*x
    }
  }
  box { // Win1Hor12
    <-1, -1, -1>, <1, 1, 1>
    translate  1.0*z
    photons {
      collect off
    }
    // All transformations fixed
    scale <0.15, 0.025, 0.015>
    translate  <-1.23, -0.5, 5.0>
    material {
      DMFWood4Hor
      // Transform to world space
      translate  <-1.03, 0.6, 0.0>
      rotate 24.218243*z
      translate  <-1.4, -0.5, 0.0>
      rotate 0.0*z rotate 0.0*y rotate 0.0*x
      translate  <-1.4, -0.5, 0.0>
      rotate 0.0*z rotate 0.0*y rotate 0.0*x
    }
  }
  rotate <-0.0, -0.0, -0.0>
  translate  <1.4, 0.5, 0.0>
  photons {
    collect off
  }
  // Scaling fixed
  // Rot Z limited (-90.0 to   90.0)
  // Translation fixed
  rotate -24.218243*z
  translate  <1.03, -0.6, 0.0>
}
#declare Group_Window4 = union {
  box { // Floor1Sill4
    <-1, -1, -1>, <1, 1, 1>
    translate  1.0*z
    material {
      DMFWood4Hor
    }
    photons {
      collect off
    }
    scale <0.18, 0.2, 0.025>
    translate  <1.2, -0.55, 4.6>
  }
  box { // Floor1Upper4
    <-1, -1, -1>, <1, 1, 1>
    translate  -1.0*z
    material {
      DMFWood4Hor
    }
    photons {
      collect off
    }
    scale <0.17, 0.2, 0.015>
    translate  <1.2, -0.5, 5.26>
  }
  box { // Floor1Vert5
    <-1, -1, -1>, <1, 1, 1>
    translate  <-1.0, 0.0, 1.0>
    material {
      DMFWood4Ver
    }
    photons {
      collect off
    }
    scale <0.015, 0.2, 0.33>
    translate  <1.03, -0.5, 4.6>
  }
  box { // Floor1Vert6
    <-1, -1, -1>, <1, 1, 1>
    translate  <1.0, 0.0, 1.0>
    material {
      DMFWood4Ver
    }
    photons {
      collect off
    }
    scale <0.015, 0.2, 0.33>
    translate  <1.37, -0.5, 4.6>
  }
  object { Window1_1_2 }
  photons {
    collect off
  }
}
#declare Group_Floor1_Windows = union {
  object { Group_Window1 }
  object { Group_Window2 }
  object { Group_Window3 }
  object { Group_Window4 }
  box { // Floor1Window1hor
    <-1, -1, -1>, <1, 1, 1>
    translate  <1.0, 0.0, 1.0>
    material {
      DMFWood4Hor
    }
    photons {
      collect off
    }
    scale <1.22, 0.05, 0.015>
    translate  <-1.7, -0.6, 4.8>
  }
  box { // Floor1_WindowPane
    <-1, -1, -1>, <1, 1, 1>
    translate  <1.0, 0.0, 1.0>
    photons {
      collect off
    }
    scale <1.22, 0.001, 0.22>
    translate  <-1.7, -0.6, 4.81>
    material {
      WindowGlass
      // Transform to world space
    }
  }
  photons {
    collect off
  }
}
#declare Floor1_WallElements = union {
  box { // Floor1
    <-1, -1, -1>, <1, 1, 1>
    translate  1.0*z
    photons {
      collect off
    }
    scale <2.0, 0.15, 1.5>
    translate  3.0*z
  }
  object { Floor1_WallElement1 }
  object { // Floor1_WallElement2 -> Floor1_WallElement1
    Floor1_WallElement1
    photons {
      collect off
    }
    translate  0.15*x
  }
  object { // Floor1_WallElement3 -> Floor1_WallElement1
    Floor1_WallElement1
    photons {
      collect off
    }
    translate  0.3*x
  }
  object { // Floor1_WallElement4 -> Floor1_WallElement1
    Floor1_WallElement1
    photons {
      collect off
    }
    translate  0.45*x
  }
  object { // Floor1_WallElement5 -> Floor1_WallElement1
    Floor1_WallElement1
    photons {
      collect off
    }
    translate  0.6*x
  }
  object { // Floor1_WallElement6 -> Floor1_WallElement1
    Floor1_WallElement1
    photons {
      collect off
    }
    translate  0.75*x
  }
  object { // Floor1_WallElement7 -> Floor1_WallElement1
    Floor1_WallElement1
    photons {
      collect off
    }
    translate  0.9*x
  }
  object { // Floor1_WallElement8 -> Floor1_WallElement1
    Floor1_WallElement1
    photons {
      collect off
    }
    translate  1.05*x
  }
  object { // Floor1_WallElement9 -> Floor1_WallElement1
    Floor1_WallElement1
    photons {
      collect off
    }
    translate  1.2*x
  }
  object { // Floor1_WallElement10 -> Floor1_WallElement1
    Floor1_WallElement1
    photons {
      collect off
    }
    translate  1.35*x
  }
  object { // Floor1_WallElement11 -> Floor1_WallElement1
    Floor1_WallElement1
    photons {
      collect off
    }
    translate  1.5*x
  }
  object { // Floor1_WallElement12 -> Floor1_WallElement1
    Floor1_WallElement1
    photons {
      collect off
    }
    translate  1.65*x
  }
  object { // Floor1_WallElement13 -> Floor1_WallElement1
    Floor1_WallElement1
    photons {
      collect off
    }
    translate  1.8*x
  }
  object { // Floor1_WallElement14 -> Floor1_WallElement1
    Floor1_WallElement1
    photons {
      collect off
    }
    translate  1.95*x
  }
  object { // Floor1_WallElement15 -> Floor1_WallElement1
    Floor1_WallElement1
    photons {
      collect off
    }
    translate  2.1*x
  }
  object { // Floor1_WallElement16 -> Floor1_WallElement1
    Floor1_WallElement1
    photons {
      collect off
    }
    translate  2.25*x
  }
  object { // Floor1_WallElement17 -> Floor1_WallElement1
    Floor1_WallElement1
    photons {
      collect off
    }
    translate  2.4*x
  }
  object { // Floor1_WallElement18 -> Floor1_WallElement1
    Floor1_WallElement1
    photons {
      collect off
    }
    translate  2.55*x
  }
  object { // Floor1_WallElement19 -> Floor1_WallElement1
    Floor1_WallElement1
    photons {
      collect off
    }
    translate  2.7*x
  }
  object { // Floor1_WallElement20 -> Floor1_WallElement1
    Floor1_WallElement1
    photons {
      collect off
    }
    translate  2.85*x
  }
  object { // Floor1_WallElement21 -> Floor1_WallElement1
    Floor1_WallElement1
    photons {
      collect off
    }
    translate  3.0*x
  }
  object { // Floor1_WallElement22 -> Floor1_WallElement1
    Floor1_WallElement1
    photons {
      collect off
    }
    translate  3.15*x
  }
  object { // Floor1_WallElement23 -> Floor1_WallElement1
    Floor1_WallElement1
    photons {
      collect off
    }
    translate  3.3*x
  }
  object { // Floor1_WallElement24 -> Floor1_WallElement1
    Floor1_WallElement1
    photons {
      collect off
    }
    translate  3.45*x
  }
  object { // Floor1_WallElement25 -> Floor1_WallElement1
    Floor1_WallElement1
    photons {
      collect off
    }
    translate  3.6*x
  }
  object { // Floor1_WallElement26 -> Floor1_WallElement1
    Floor1_WallElement1
    photons {
      collect off
    }
    translate  3.75*x
  }
  object { // Floor1_WallElement27 -> Floor1_WallElement1
    Floor1_WallElement1
    photons {
      collect off
    }
    translate  3.9*x
  }
  photons {
    collect off
  }
  translate  -0.5*y
}
#declare FirstFloor = difference {
  object { Floor1_WallElements }
  box { // Floor1Window1
    <-1, -1, -1>, <1, 1, 1>
    translate  1.0*z
    photons {
      collect off
    }
    scale <0.19, 0.25, 0.63>
    translate  <-1.5, -0.5, 3.99>
  }
  box { // Floor1Window2
    <-1, -1, -1>, <1, 1, 1>
    translate  1.0*z
    photons {
      collect off
    }
    scale <0.36, 0.25, 0.63>
    translate  <-0.4, -0.5, 3.98>
  }
  box { // Floor1Window3
    <-1, -1, -1>, <1, 1, 1>
    translate  1.0*z
    photons {
      collect off
    }
    scale <0.36, 0.25, 0.63>
    translate  <0.4, -0.5, 3.98>
  }
  box { // Floor1Window4
    <-1, -1, -1>, <1, 1, 1>
    translate  1.0*z
    photons {
      collect off
    }
    scale <0.18, 0.25, 0.31>
    translate  <1.2, -0.5, 4.63>
  }
  photons {
    collect off
  }
  material {
    T_Wood35
    // Transform to world space
  }
}
#declare MainBeams1 = union {
  box { // Beam7
    <-1, -1, -1>, <1, 1, 1>
    translate  <0.0, -1.0, 1.0>
    photons {
      collect off
    }
    scale <0.05, 0.05, 0.3>
    translate  8.5*z
    material {
      DMFWood4Ver
      // Transform to world space
      translate  <1.9, 0.1, 6.46>
    }
  }
  box { // Beam8
    <-1, -1, -1>, <1, 1, 1>
    translate  <0.0, -1.0, 1.0>
    photons {
      collect off
    }
    scale <0.05, 0.25, 0.05>
    translate  9.1*z
    material {
      DMFWood4HorBeam
      // Transform to world space
      translate  <1.9, 0.1, 6.46>
    }
  }
  box { // Beam10
    <-1, -1, -1>, <1, 1, 1>
    translate  <0.0, -1.0, 1.0>
    photons {
      collect off
    }
    scale <0.03, 0.15, 0.12>
    translate  8.86*z
    material {
      DMFWood4Ver
      // Transform to world space
      translate  <1.9, 0.1, 6.46>
    }
  }
  photons {
    collect off
  }
}
#declare SupportDif1 = difference {
  object { MainBeams1 }
  cylinder { // Cylndr074
    <0,0,1>, <0,0,0>, 1 
    translate  -0.5*z
    photons {
      collect off
    }
    scale <0.19, 0.15, 0.08>
    rotate -90.0*y
    translate  <0.0, -0.3, 8.86>
    material {
      DMFWood4Ver
      // Transform to world space
      translate  <1.9, 0.1, 6.46>
    }
  }
  cylinder { // Cylndr075
    <0,0,1>, <0,0,0>, 1 
    translate  -0.5*z
    photons {
      collect off
    }
    scale <0.05, 0.05, 0.11>
    rotate -90.0*y
    translate  <0.0, -0.1, 8.5>
    material {
      DMFWood4Ver
      // Transform to world space
      translate  <1.9, 0.1, 6.46>
    }
  }
  cylinder { // Cylndr076
    <0,0,1>, <0,0,0>, 1 
    translate  -0.5*z
    photons {
      collect off
    }
    scale <0.05, 0.05, 0.11>
    rotate -90.0*y
    translate  <0.0, -0.5, 9.1>
    material {
      DMFWood4HorBeam
      // Transform to world space
      translate  <1.9, 0.1, 6.46>
    }
  }
  photons {
    collect off
  }
}
#declare BeamSupport1 = union {
  object { SupportDif1 }
  cylinder { // Beam11
    <0,0,1>, <0,0,0>, 1 
    translate  -0.5*z
    photons {
      collect off
    }
    scale <0.05, 0.05, 0.06>
    rotate -90.0*y
    translate  <0.0, -0.3, 9.05>
    material {
      DMFWood4Ver
      // Transform to parent space
    }
  }
  cylinder { // Beam12
    <0,0,1>, <0,0,0>, 1 
    translate  -0.5*z
    photons {
      collect off
    }
    scale <0.05, 0.05, 0.06>
    rotate -90.0*y
    translate  <0.0, -0.15, 8.86>
    material {
      DMFWood4Ver
      // Transform to world space
      translate  <1.9, 0.1, 6.46>
    }
  }
  photons {
    collect off
  }
  translate  <-1.9, -0.1, -6.46>
}
#declare MainBeams2 = union {
  box { // Beam9
    <-1, -1, -1>, <1, 1, 1>
    translate  <0.0, -1.0, 1.0>
    photons {
      collect off
    }
    scale <0.05, 0.05, 0.3>
    translate  8.5*z
    material {
      DMFWood4Ver
      // Transform to world space
      translate  <-1.9, 0.1, 6.46>
    }
  }
  box { // Beam13
    <-1, -1, -1>, <1, 1, 1>
    translate  <0.0, -1.0, 1.0>
    photons {
      collect off
    }
    scale <0.05, 0.25, 0.05>
    translate  9.1*z
    material {
      DMFWood4HorBeam
      // Transform to world space
      translate  <-1.9, 0.1, 6.46>
    }
  }
  box { // Beam14
    <-1, -1, -1>, <1, 1, 1>
    translate  <0.0, -1.0, 1.0>
    photons {
      collect off
    }
    scale <0.03, 0.15, 0.12>
    translate  8.86*z
    material {
      DMFWood4Ver
      // Transform to world space
      translate  <-1.9, 0.1, 6.46>
    }
  }
  photons {
    collect off
  }
}
#declare SupportDif2 = difference {
  object { MainBeams2 }
  cylinder { // Cylndr077
    <0,0,1>, <0,0,0>, 1 
    translate  -0.5*z
    photons {
      collect off
    }
    scale <0.19, 0.15, 0.08>
    rotate -90.0*y
    translate  <0.0, -0.3, 8.86>
    material {
      DMFWood4Ver
      // Transform to world space
      translate  <-1.9, 0.1, 6.46>
    }
  }
  cylinder { // Cylndr078
    <0,0,1>, <0,0,0>, 1 
    translate  -0.5*z
    photons {
      collect off
    }
    scale <0.05, 0.05, 0.11>
    rotate -90.0*y
    translate  <0.0, -0.1, 8.5>
    material {
      DMFWood4Ver
      // Transform to world space
      translate  <-1.9, 0.1, 6.46>
    }
  }
  cylinder { // Cylndr079
    <0,0,1>, <0,0,0>, 1 
    translate  -0.5*z
    photons {
      collect off
    }
    scale <0.05, 0.05, 0.11>
    rotate -90.0*y
    translate  <0.0, -0.5, 9.1>
    material {
      DMFWood4HorBeam
      // Transform to world space
      translate  <-1.9, 0.1, 6.46>
    }
  }
  photons {
    collect off
  }
}
#declare BeamSupport2 = union {
  object { SupportDif2 }
  cylinder { // Beam15
    <0,0,1>, <0,0,0>, 1 
    translate  -0.5*z
    photons {
      collect off
    }
    scale <0.05, 0.05, 0.06>
    rotate -90.0*y
    translate  <0.0, -0.3, 9.05>
    material {
      DMFWood4Ver
      // Transform to parent space
    }
  }
  cylinder { // Beam16
    <0,0,1>, <0,0,0>, 1 
    translate  -0.5*z
    photons {
      collect off
    }
    scale <0.05, 0.05, 0.06>
    rotate -90.0*y
    translate  <0.0, -0.15, 8.86>
    material {
      DMFWood4Ver
      // Transform to world space
      translate  <-1.9, 0.1, 6.46>
    }
  }
  photons {
    collect off
  }
  translate  <1.9, -0.1, -6.46>
}
#declare LowerLintels = union {
  box { // Lintel
    <-1, -1, -1>, <1, 1, 1>
    photons {
      collect off
    }
    scale <2.0, 0.5, 0.1>
    translate  <0.0, -0.2, 3.0>
    material {
      DMFWood4Hor
      // Transform to world space
    }
  }
  object { LintelBeam1 }
  object { // LintelBeam2 -> LintelBeam1
    LintelBeam1
    photons {
      collect off
    }
    rotate 0.0*z
    translate  <0.76, 0.0, -0.0>
  }
  object { // LintelBeam3 -> LintelBeam1
    LintelBeam1
    photons {
      collect off
    }
    rotate 0.0*z
    translate  <1.52, 0.0, -0.0>
  }
  object { // LintelBeam4 -> LintelBeam1
    LintelBeam1
    photons {
      collect off
    }
    rotate 0.0*z
    translate  <2.28, 0.0, -0.0>
  }
  object { // LintelBeam5 -> LintelBeam1
    LintelBeam1
    photons {
      collect off
    }
    rotate 0.0*z
    translate  <3.04, 0.0, -0.0>
  }
  object { // LintelBeam6 -> LintelBeam1
    LintelBeam1
    photons {
      collect off
    }
    rotate 0.0*z
    translate  <3.8, 0.0, -0.0>
  }
  object { BeamSupport1 }
  object { BeamSupport2 }
  photons {
    collect off
  }
}
#declare UpperLintels = union {
  object { LintelBeam7 }
  object { // LintelBeam8 -> LintelBeam7
    LintelBeam7
    photons {
      collect off
    }
    rotate <-0.0, -0.0, 0.0>
    translate  <0.76, 0.0, 0.0>
  }
  object { // LintelBeam9 -> LintelBeam7
    LintelBeam7
    photons {
      collect off
    }
    rotate <-0.0, -0.0, 0.0>
    translate  <1.52, 0.0, 0.0>
  }
  object { // LintelBeam10 -> LintelBeam7
    LintelBeam7
    photons {
      collect off
    }
    rotate <-0.0, -0.0, 0.0>
    translate  <2.28, 0.0, 0.0>
  }
  object { // LintelBeam11 -> LintelBeam7
    LintelBeam7
    photons {
      collect off
    }
    rotate <-0.0, -0.0, 0.0>
    translate  <3.04, 0.0, 0.0>
  }
  object { // LintelBeam12 -> LintelBeam7
    LintelBeam7
    photons {
      collect off
    }
    rotate <-0.0, -0.0, 0.0>
    translate  <3.8, 0.0, 0.0>
  }
  photons {
    collect off
  }
}
#declare Group_Floor1 = union {
  object { Group_Floor1_Windows }
  box { // Floor1_VertStrut1
    <-1, -1, -1>, <1, 1, 1>
    translate  1.0*z
    photons {
      collect off
    }
    scale <0.05, 0.18, 3.63>
    translate  <0.0, -0.6, 3.0>
    material {
      DMFWood4Ver
      // Transform to world space
    }
  }
  box { // Floor1_HorStrut1
    <-1, -1, -1>, <1, 1, 1>
    translate  1.0*z
    photons {
      collect off
    }
    scale <2.0, 0.15, 0.05>
    translate  <0.0, -0.55, 6.0>
    material {
      DMFWood4Hor
      // Transform to world space
    }
  }
  object { FirstFloor }
  box { // Floor1_WestWall
    <-1, -1, -1>, <1, 1, 1>
    photons {
      collect off
    }
    scale <0.05, 5.0, 1.5>
    translate  <-1.95, 4.4, 4.5>
    material {
      T_Wood35
      // Transform to world space
    }
  }
  box { // Floor1_EastWall
    <-1, -1, -1>, <1, 1, 1>
    photons {
      collect off
    }
    scale <0.05, 5.0, 1.5>
    translate  <1.95, 4.4, 4.5>
    material {
      T_Wood35
      // Transform to world space
    }
  }
  object { LowerLintels }
  box { // Floor1_Floor
    <-1, -1, -1>, <1, 1, 1>
    photons {
      collect off
    }
    scale <1.9, 4.5, 0.1>
    translate  <0.0, 4.8, 3.0>
    material {
      WoodPanels
      // Transform to world space
    }
  }
  box { // Floor1_VertStrut2
    <-1, -1, -1>, <1, 1, 1>
    translate  1.0*z
    photons {
      collect off
    }
    scale <0.05, 0.15, 1.53>
    translate  <-0.9, -0.6, 3.0>
    material {
      DMFWood4Ver
      // Transform to world space
    }
  }
  box { // Floor1_VertStrut3
    <-1, -1, -1>, <1, 1, 1>
    translate  1.0*z
    photons {
      collect off
    }
    scale <0.05, 0.15, 1.53>
    translate  <0.9, -0.6, 3.0>
    material {
      DMFWood4Ver
      // Transform to world space
    }
  }
  box { // Floor1_HorStrut2
    <-1, -1, -1>, <1, 1, 1>
    photons {
      collect off
    }
    scale <2.0, 0.15, 0.05>
    translate  <0.0, -0.6, 3.9>
    material {
      DMFWood4Hor
      // Transform to world space
    }
  }
  box { // Floor1_Ceiling
    <-1, -1, -1>, <1, 1, 1>
    translate  <0.0, 1.0, 1.0>
    photons {
      collect off
    }
    scale <1.9, 4.9, 0.03>
    translate  <0.0, -0.5, 5.5>
    material {
      WoodPanels
      // Transform to world space
    }
  }
  object { UpperLintels }
  photons {
    collect off
  }
}
#declare FrontonWest = difference {
  box { // Front1
    <-1, -1, -1>, <1, 1, 1>
    translate  <1.0, 0.0, 1.0>
    material {
      T_Wood7
    }
    photons {
      collect off
    }
    scale <0.15, 0.05, 2.4>
    rotate 25.0*y
    translate  <-2.0, 0.0, 6.0>
  }
  box { // Toit2
    <-1, -1, -1>, <1, 1, 1>
    translate  <1.0, 0.0, 1.0>
    photons {
      collect off
    }
    scale <0.3, 0.07, 1.66>
    rotate 25.0*y
    translate  <-1.662616, 0.0, 6.367772>
  }
  cylinder { // Toit3
    <0,0,1>, <0,0,0>, 1 
    translate  <0.0, 1.0, -0.5>
    photons {
      collect off
    }
    scale <0.3, 0.3, 0.15>
    rotate -90.0*x
    translate  <-1.95, 0.0, 6.0>
  }
  cylinder { // Toit4
    <0,0,1>, <0,0,0>, 1 
    translate  -0.5*z
    photons {
      collect off
    }
    scale <0.4, 0.5, 0.15>
    rotate <-90.0, 25.0, 0.0>
    translate  <-1.3, 0.0, 6.2>
  }
  cylinder { // Toit5
    <0,0,1>, <0,0,0>, 1 
    translate  -0.5*z
    photons {
      collect off
    }
    scale <0.3, 0.4, 0.15>
    rotate -90.0*x
    translate  9.18*z
  }
  box { // Toit6
    <-1, -1, -1>, <1, 1, 1>
    translate  <1.0, 0.0, -1.0>
    photons {
      collect off
    }
    scale <0.18, 0.07, 0.45>
    translate  10.4*z
  }
  material {
    DMFWood6
  }
  photons {
    collect off
  }
}
#declare FrontonEast = difference {
  box { // Front2
    <-1, -1, -1>, <1, 1, 1>
    translate  <1.0, 0.0, 1.0>
    material {
      T_Wood7
    }
    photons {
      collect off
    }
    scale <0.15, 0.05, 2.4>
    rotate 25.0*y
    translate  <-2.0, 0.0, 6.0>
  }
  box { // Toit7
    <-1, -1, -1>, <1, 1, 1>
    translate  <1.0, 0.0, 1.0>
    photons {
      collect off
    }
    scale <0.3, 0.07, 1.66>
    rotate 25.0*y
    translate  <-1.662616, 0.0, 6.367772>
  }
  cylinder { // Toit8
    <0,0,1>, <0,0,0>, 1 
    translate  <0.0, 1.0, -0.5>
    photons {
      collect off
    }
    scale <0.3, 0.3, 0.15>
    rotate -90.0*x
    translate  <-1.95, 0.0, 6.0>
  }
  cylinder { // Toit9
    <0,0,1>, <0,0,0>, 1 
    translate  -0.5*z
    photons {
      collect off
    }
    scale <0.4, 0.5, 0.15>
    rotate <-90.0, 25.0, 0.0>
    translate  <-1.3, 0.0, 6.2>
  }
  cylinder { // Toit10
    <0,0,1>, <0,0,0>, 1 
    translate  -0.5*z
    photons {
      collect off
    }
    scale <0.3, 0.4, 0.15>
    rotate -90.0*x
    translate  9.18*z
  }
  box { // Toit11
    <-1, -1, -1>, <1, 1, 1>
    translate  <1.0, 0.0, -1.0>
    photons {
      collect off
    }
    scale <0.18, 0.07, 0.45>
    translate  10.4*z
  }
  material {
    DMFWood6
  }
  photons {
    collect off
  }
  scale <-1.0, 1.0, 1.0>
}
#declare Fronton = union {
  object { FrontonWest }
  object { FrontonEast }
  box { // RoofDeckW
    <-1, -1, -1>, <1, 1, 1>
    translate  <1.0, 0.0, 1.0>
    material {
      DMFWood4Hor
    }
    photons {
      collect off
    }
    scale <2.42, 0.3, 0.04>
    rotate <-0.0, -65.0, 0.0>
    translate  <-2.0, 0.2, 6.0>
  }
  box { // RoofDeckE
    <-1, -1, -1>, <1, 1, 1>
    translate  <-1.0, 0.0, 1.0>
    material {
      DMFWood4Hor
    }
    photons {
      collect off
    }
    scale <2.42, 0.3, 0.04>
    rotate 65.0*y
    translate  <2.0, 0.2, 6.0>
  }
  photons {
    collect off
  }
  translate  -0.7*y
}
#declare Floor2_WallElements = union {
  box { // Floor2_Wall
    <-1, -1, -1>, <1, 1, 1>
    translate  1.0*z
    photons {
      collect off
    }
    scale <2.0, 0.15, 2.14>
    translate  6.0*z
  }
  object { Floor2_WallElement1 }
  object { // Floor2_WallElement2 -> Floor2_WallElement1
    Floor2_WallElement1
    photons {
      collect off
    }
    translate  0.2*x
  }
  object { // Floor2_WallElement3 -> Floor2_WallElement1
    Floor2_WallElement1
    photons {
      collect off
    }
    translate  0.4*x
  }
  object { // Floor2_WallElement4 -> Floor2_WallElement1
    Floor2_WallElement1
    photons {
      collect off
    }
    translate  0.6*x
  }
  object { // Floor2_WallElement5 -> Floor2_WallElement1
    Floor2_WallElement1
    photons {
      collect off
    }
    translate  0.8*x
  }
  object { // Floor2_WallElement6 -> Floor2_WallElement1
    Floor2_WallElement1
    photons {
      collect off
    }
    translate  1.0*x
  }
  object { // Floor2_WallElement7 -> Floor2_WallElement1
    Floor2_WallElement1
    photons {
      collect off
    }
    translate  1.2*x
  }
  object { // Floor2_WallElement8 -> Floor2_WallElement1
    Floor2_WallElement1
    photons {
      collect off
    }
    translate  1.4*x
  }
  object { // Floor2_WallElement9 -> Floor2_WallElement1
    Floor2_WallElement1
    photons {
      collect off
    }
    translate  1.6*x
  }
  object { // Floor2_WallElement10 -> Floor2_WallElement1
    Floor2_WallElement1
    photons {
      collect off
    }
    translate  1.8*x
  }
  object { // Floor2_WallElement11 -> Floor2_WallElement1
    Floor2_WallElement1
    photons {
      collect off
    }
    translate  2.0*x
  }
  object { // Floor2_WallElement12 -> Floor2_WallElement1
    Floor2_WallElement1
    photons {
      collect off
    }
    translate  2.2*x
  }
  object { // Floor2_WallElement13 -> Floor2_WallElement1
    Floor2_WallElement1
    photons {
      collect off
    }
    translate  2.4*x
  }
  object { // Floor2_WallElement14 -> Floor2_WallElement1
    Floor2_WallElement1
    photons {
      collect off
    }
    translate  2.6*x
  }
  object { // Floor2_WallElement15 -> Floor2_WallElement1
    Floor2_WallElement1
    photons {
      collect off
    }
    translate  2.8*x
  }
  object { // Floor2_WallElement16 -> Floor2_WallElement1
    Floor2_WallElement1
    photons {
      collect off
    }
    translate  3.0*x
  }
  object { // Floor2_WallElement17 -> Floor2_WallElement1
    Floor2_WallElement1
    photons {
      collect off
    }
    translate  3.2*x
  }
  object { // Floor2_WallElement18 -> Floor2_WallElement1
    Floor2_WallElement1
    photons {
      collect off
    }
    translate  3.4*x
  }
  object { // Floor2_WallElement19 -> Floor2_WallElement1
    Floor2_WallElement1
    photons {
      collect off
    }
    translate  3.6*x
  }
  object { // Floor2_WallElement20 -> Floor2_WallElement1
    Floor2_WallElement1
    photons {
      collect off
    }
    translate  3.8*x
  }
  photons {
    collect off
  }
}
#declare TopFloorDif = difference {
  object { Floor2_WallElements }
  box { // RoofDif1
    <-1, -1, -1>, <1, 1, 1>
    translate  <1.0, 0.0, 1.0>
    photons {
      collect off
    }
    scale <2.36, 0.25, 1.0>
    rotate -65.0*y
    translate  <-2.0, 0.0, 6.0>
  }
  box { // Floor2_Attic1
    <-1, -1, -1>, <1, 1, 1>
    translate  <-1.0, 0.0, 1.0>
    photons {
      collect off
    }
    scale <0.15, 0.25, 0.35>
    translate  <-0.18, 0.0, 8.0>
  }
  box { // Floor2_Attic2
    <-1, -1, -1>, <1, 1, 1>
    translate  <1.0, 0.0, 1.0>
    photons {
      collect off
    }
    scale <0.15, 0.25, 0.35>
    translate  <0.18, 0.0, 8.0>
  }
  box { // RoofDif2
    <-1, -1, -1>, <1, 1, 1>
    translate  <-1.0, 0.0, 1.0>
    photons {
      collect off
    }
    scale <2.36, 0.25, 1.0>
    rotate 65.0*y
    translate  <2.0, 0.0, 6.0>
  }
  box { // Floor2_Win1
    <-1, -1, -1>, <1, 1, 1>
    translate  <1.0, 0.0, 1.0>
    photons {
      collect off
    }
    scale <0.41, 0.25, 0.32>
    translate  <-1.01, 0.0, 6.7>
  }
  photons {
    collect off
  }
  translate  -0.5*y
  material {
    T_Wood35
    // Transform to world space
  }
}
#declare Group_Chimney = union {
  box { // Chimney
    <-1, -1, -1>, <1, 1, 1>
    photons {
      collect off
    }
    scale <0.2, 0.2, 1.3>
    translate  <1.7, 3.0, 7.3>
    material {
      BrickWall
      // Transform to world space
    }
  }
  cylinder { // ChimneyStrut
    <0,0,1>, <0,0,0>, 1 
    photons {
      collect off
    }
    scale <0.02, 0.02, 1.7>
    rotate 90.0*y
    translate  <0.0, 3.0, 8.0>
    material {
      Brass_Metal
      // Transform to world space
    }
  }
  box { // ChimneyTop
    <-1, -1, -1>, <1, 1, 1>
    photons {
      collect off
    }
    scale <0.22, 0.22, 0.05>
    translate  <1.7, 3.0, 8.6>
    material {
      BrickWall
      // Transform to world space
    }
  }
  photons {
    collect off
  }
}
#declare Group_Chimney1 = union {
  box { // Chimney1
    <-1, -1, -1>, <1, 1, 1>
    photons {
      collect off
    }
    scale <0.2, 0.2, 1.3>
    translate  <-1.7, 1.7, 7.3>
    material {
      BrickWall
      // Transform to world space
      translate  -5.0*y
    }
  }
  cylinder { // ChimneyStrut1
    <0,0,1>, <0,0,0>, 1 
    photons {
      collect off
    }
    scale <0.02, 0.02, 1.7>
    rotate -90.0*y
    translate  <0.0, 1.7, 8.0>
    material {
      Brass_Metal
      // Transform to world space
      translate  -5.0*y
    }
  }
  box { // ChimneyTop1
    <-1, -1, -1>, <1, 1, 1>
    photons {
      collect off
    }
    scale <0.22, 0.22, 0.05>
    translate  <-1.7, 1.7, 8.6>
    material {
      BrickWall
      // Transform to world space
      translate  -5.0*y
    }
  }
  photons {
    collect off
  }
  translate  5.0*y
}
#declare Floor2_Window1 = union {
  box { // Floor2Vert4
    <-1, -1, -1>, <1, 1, 1>
    translate  <1.0, 0.0, 1.0>
    material {
      DMFWood4Ver
    }
    photons {
      collect off
    }
    scale <0.015, 0.015, 0.285>
    translate  <-1.0, -0.6, 6.75>
  }
  box { // Floor2Vert5
    <-1, -1, -1>, <1, 1, 1>
    translate  <-1.0, 0.0, 1.0>
    material {
      DMFWood4Ver
    }
    photons {
      collect off
    }
    scale <0.015, 0.015, 0.285>
    translate  <-0.72, -0.6, 6.75>
  }
  box { // Floor2Win1Hor1
    <-1, -1, -1>, <1, 1, 1>
    translate  1.0*z
    material {
      DMFWood4Hor
    }
    photons {
      collect off
    }
    scale <0.11, 0.015, 0.015>
    translate  <-0.86, -0.6, 6.75>
  }
  box { // Floor2Win1Hor2
    <-1, -1, -1>, <1, 1, 1>
    translate  1.0*z
    material {
      DMFWood4Hor
    }
    photons {
      collect off
    }
    scale <0.11, 0.015, 0.015>
    translate  <-0.86, -0.6, 7.0>
  }
  box { // Floor2Win1Hor3
    <-1, -1, -1>, <1, 1, 1>
    translate  -1.0*z
    material {
      DMFWood4Hor
    }
    photons {
      collect off
    }
    scale <0.11, 0.015, 0.015>
    translate  <-0.86, -0.6, 7.32>
  }
  box { // Floor2_WindowPane1_1
    <-1, -1, -1>, <1, 1, 1>
    translate  <1.0, 0.0, 1.0>
    photons {
      collect off
    }
    scale <0.12, 0.001, 0.27>
    translate  <-0.98, -0.6, 6.76>
    material {
      WindowGlass
      // Transform to world space
      translate  <1.0, 0.6, -6.75>
      rotate 21.422098*z rotate 0.0*y rotate -0.0*x
      translate  <-1.0, -0.6, 6.75>
      translate  <-1.0, -0.6, 6.75>
    }
  }
  translate  <1.0, 0.6, -6.75>
  photons {
    collect off
  }
  rotate <0.0, -0.0, -21.422098>
  translate  <-1.0, -0.6, 6.75>
}
#declare Floor2_Window2 = union {
  box { // Floor2Vert6
    <-1, -1, -1>, <1, 1, 1>
    translate  <1.0, 0.0, 1.0>
    material {
      DMFWood4Ver
    }
    photons {
      collect off
    }
    scale <0.015, 0.015, 0.285>
    translate  <-1.0, -0.6, 6.75>
  }
  box { // Floor2Vert7
    <-1, -1, -1>, <1, 1, 1>
    translate  <-1.0, 0.0, 1.0>
    material {
      DMFWood4Ver
    }
    photons {
      collect off
    }
    scale <0.015, 0.015, 0.285>
    translate  <-0.72, -0.6, 6.75>
  }
  box { // Floor2Win1Hor4
    <-1, -1, -1>, <1, 1, 1>
    translate  1.0*z
    material {
      DMFWood4Hor
    }
    photons {
      collect off
    }
    scale <0.11, 0.015, 0.015>
    translate  <-0.86, -0.6, 6.75>
  }
  box { // Floor2Win1Hor5
    <-1, -1, -1>, <1, 1, 1>
    translate  1.0*z
    material {
      DMFWood4Hor
    }
    photons {
      collect off
    }
    scale <0.11, 0.015, 0.015>
    translate  <-0.86, -0.6, 7.0>
  }
  box { // Floor2Win1Hor6
    <-1, -1, -1>, <1, 1, 1>
    translate  -1.0*z
    material {
      DMFWood4Hor
    }
    photons {
      collect off
    }
    scale <0.11, 0.015, 0.015>
    translate  <-0.86, -0.6, 7.32>
  }
  box { // Floor2_WindowPane1_2
    <-1, -1, -1>, <1, 1, 1>
    translate  <1.0, 0.0, 1.0>
    photons {
      collect off
    }
    scale <0.12, 0.001, 0.27>
    translate  <-0.98, -0.6, 6.76>
    material {
      WindowGlass
      // Transform to world space
      translate  <0.2, 0.6, -6.75>
      rotate -32.456718*z rotate -0.0*y rotate -0.0*x
      scale <1.0/-1.0, 1.0/1.0, 1.0/1.0>
      translate  <-1.0, -0.6, 6.75>
      translate  <-1.0, -0.6, 6.75>
    }
  }
  translate  <1.0, 0.6, -6.75>
  photons {
    collect off
  }
  scale <-1.0, 1.0, 1.0>
  rotate <0.0, 0.0, 32.456718>
  translate  <-0.2, -0.6, 6.75>
}
#declare GroupFloor2_Window1 = union {
  box { // Floor1WinSill
    <-1, -1, -1>, <1, 1, 1>
    translate  1.0*z
    material {
      DMFWood4Hor
    }
    photons {
      collect off
    }
    scale <0.41, 0.25, 0.025>
    translate  <-0.6, -0.5, 6.7>
  }
  box { // Floor2Vert1
    <-1, -1, -1>, <1, 1, 1>
    translate  <-1.0, 0.0, 1.0>
    material {
      DMFWood4Ver
    }
    photons {
      collect off
    }
    scale <0.015, 0.2, 0.325>
    translate  <-1.0, -0.5, 6.7>
  }
  box { // Floor2Vert2
    <-1, -1, -1>, <1, 1, 1>
    translate  <1.0, 0.0, 1.0>
    material {
      DMFWood4Ver
    }
    photons {
      collect off
    }
    scale <0.015, 0.2, 0.325>
    translate  <-0.2, -0.5, 6.7>
  }
  box { // Floor2Upper1
    <-1, -1, -1>, <1, 1, 1>
    translate  -1.0*z
    material {
      DMFWood4Hor
    }
    photons {
      collect off
    }
    scale <0.4, 0.2, 0.015>
    translate  <-0.6, -0.5, 7.35>
  }
  box { // Floor2Vert3
    <-1, -1, -1>, <1, 1, 1>
    translate  1.0*z
    material {
      DMFWood4Ver
    }
    photons {
      collect off
    }
    scale <0.12, 0.05, 0.325>
    translate  <-0.6, -0.6, 6.7>
  }
  object { Floor2_Window1 }
  object { Floor2_Window2 }
  photons {
    collect off
  }
}
#declare RoofDecoration = union {
  sphere { // Sphere005
    <0,0,0>,1
    photons {
      collect off
    }
    scale 0.1
    translate  <0.0, -0.5, 10.5>
  }
  cone { // Cone007
    <0,0,0>, 0.15, <0,0,1>, 0.0
    photons {
      collect off
    }
    scale <1.0, 1.0, 0.7>
    translate  <0.0, -0.5, 10.5>
  }
  photons {
    collect off
  }
  material {
    T_Wood7
    // Transform to world space
  }
}
#declare Floor2_CeilingAndLintels = union {
  box { // Floor2_Ceiling
    <-1, -1, -1>, <1, 1, 1>
    translate  <0.0, 1.0, 1.0>
    photons {
      collect off
    }
    scale <1.28, 4.9, 0.03>
    translate  <0.0, -0.5, 7.45>
    material {
      WoodPanels
      // Transform to world space
    }
  }
  object { LintelBeam13 }
  object { // LintelBeam14 -> LintelBeam13
    LintelBeam13
    photons {
      collect off
    }
    translate  0.4*x
  }
  object { // LintelBeam15 -> LintelBeam13
    LintelBeam13
    photons {
      collect off
    }
    translate  0.8*x
  }
  object { // LintelBeam16 -> LintelBeam13
    LintelBeam13
    photons {
      collect off
    }
    translate  1.2*x
  }
  object { // LintelBeam17 -> LintelBeam13
    LintelBeam13
    photons {
      collect off
    }
    translate  1.6*x
  }
  object { // LintelBeam18 -> LintelBeam13
    LintelBeam13
    photons {
      collect off
    }
    translate  2.0*x
  }
  object { // LintelBeam19 -> LintelBeam13
    LintelBeam13
    photons {
      collect off
    }
    translate  2.4*x
  }
  photons {
    collect off
  }
}
#declare MainBeams = union {
  box { // Beam1
    <-1, -1, -1>, <1, 1, 1>
    translate  <0.0, -1.0, 1.0>
    photons {
      collect off
    }
    scale <0.05, 0.05, 0.3>
    translate  8.5*z
    material {
      DMFWood4Ver
      // Transform to world space
      translate  0.8*y
    }
  }
  box { // Beam2
    <-1, -1, -1>, <1, 1, 1>
    translate  <0.0, -1.0, 1.0>
    photons {
      collect off
    }
    scale <0.05, 0.25, 0.05>
    translate  9.1*z
    material {
      DMFWood4HorBeam
      // Transform to world space
      translate  0.8*y
    }
  }
  box { // Beam3
    <-1, -1, -1>, <1, 1, 1>
    translate  <0.0, -1.0, 1.0>
    photons {
      collect off
    }
    scale <0.05, 0.45, 0.05>
    translate  9.2*z
    material {
      DMFWood4HorBeam
      // Transform to world space
      translate  0.8*y
    }
  }
  box { // Beam4
    <-1, -1, -1>, <1, 1, 1>
    translate  <0.0, -1.0, 1.0>
    photons {
      collect off
    }
    scale <0.03, 0.15, 0.12>
    translate  8.86*z
    material {
      DMFWood4Ver
      // Transform to world space
      translate  0.8*y
    }
  }
  photons {
    collect off
  }
}
#declare HoistDif = difference {
  object { MainBeams }
  cylinder { // Cylndr031
    <0,0,1>, <0,0,0>, 1 
    translate  -0.5*z
    photons {
      collect off
    }
    scale <0.19, 0.15, 0.08>
    rotate -90.0*y
    translate  <0.0, -0.3, 8.86>
    material {
      DMFWood4Ver
      // Transform to world space
      translate  0.8*y
    }
  }
  cylinder { // Cylndr032
    <0,0,1>, <0,0,0>, 1 
    translate  -0.5*z
    photons {
      collect off
    }
    scale <0.05, 0.05, 0.11>
    rotate -90.0*y
    translate  <0.0, -0.1, 8.5>
    material {
      DMFWood4Ver
      // Transform to world space
      translate  0.8*y
    }
  }
  cylinder { // Cylndr033
    <0,0,1>, <0,0,0>, 1 
    translate  -0.5*z
    photons {
      collect off
    }
    scale <0.05, 0.05, 0.11>
    rotate -90.0*y
    translate  <0.0, -0.5, 9.1>
    material {
      DMFWood4HorBeam
      // Transform to world space
      translate  0.8*y
    }
  }
  photons {
    collect off
  }
}
#declare HookDif = difference {
  torus { // Hook2
    0.08, 0.025  rotate -x*90
    photons {
      collect off
    }
    rotate -90.0*y
    translate  <0.0, -0.8, 8.94>
  }
  box { // Hook3
    <-1, -1, -1>, <1, 1, 1>
    translate  <0.0, 1.0, 1.0>
    photons {
      collect off
    }
    scale <0.03, 0.045, 0.065>
    translate  <0.0, -0.775, 8.92>
  }
  photons {
    collect off
  }
  material {
    Brass_Metal
    // Transform to world space
    translate  0.8*y
  }
}
#declare HoistBeam = union {
  object { HoistDif }
  cylinder { // Beam5
    <0,0,1>, <0,0,0>, 1 
    translate  -0.5*z
    photons {
      collect off
    }
    scale <0.05, 0.05, 0.06>
    rotate -90.0*y
    translate  <0.0, -0.3, 9.05>
    material {
      DMFWood4Ver
      // Transform to parent space
    }
  }
  cylinder { // Beam6
    <0,0,1>, <0,0,0>, 1 
    translate  -0.5*z
    photons {
      collect off
    }
    scale <0.05, 0.05, 0.06>
    rotate -90.0*y
    translate  <0.0, -0.15, 8.86>
    material {
      DMFWood4Ver
      // Transform to world space
      translate  0.8*y
    }
  }
  cylinder { // Hook1
    <0,0,1>, <0,0,0>, 1 
    translate  -1.0*z
    photons {
      collect off
    }
    scale <0.025, 0.025, 0.2>
    translate  <0.0, -0.8, 9.2>
    material {
      Brass_Metal
      // Transform to world space
      translate  0.8*y
    }
  }
  object { HookDif }
  sphere { // Hook4
    <0,0,0>,1
    photons {
      collect off
    }
    scale 0.05
    translate  <0.0, -0.8, 9.2>
    material {
      Brass_Metal
      // Transform to world space
      translate  0.8*y
    }
  }
  photons {
    collect off
  }
  translate  -0.8*y
}
#declare ToBeDifferencedFromRoof = union {
  object { CSG030 }
  object { // CSG031 -> CSG030
    CSG030
    photons {
      collect off
    }
    scale -1.0
    rotate -180.0*x
  }
  photons {
    collect off
  }
  rotate 90.0*z
  translate  <1.3, 1.5, 7.5>
  material {
    T_Wood7
    // Transform to world space
  }
}
#declare RoofDifEast = difference {
  box { // RoofEast
    <-1, -1, -1>, <1, 1, 1>
    translate  <-1.0, 1.0, 1.0>
    photons {
      collect off
    }
    scale <2.35, 5.0, 0.01>
    rotate 65.0*y
    translate  <1.98, -0.5, 6.0>
    material {
      Rust
      // Transform to world space
    }
  }
  object { ToBeDifferencedFromRoof }
  photons {
    collect off
  }
}
#declare GableRoof = union {
  box { // GableRoof1
    <-1, -1, -1>, <1, 1, 1>
    translate  <-1.0, 1.0, 1.0>
    photons {
      collect off
    }
    scale <0.55, 1.05, 0.01>
    rotate -60.0*y
    translate  <0.0, -0.05, 2.0>
  }
  box { // GableRoof2
    <-1, -1, -1>, <1, 1, 1>
    translate  <-1.0, 1.0, 1.0>
    photons {
      collect off
    }
    scale <-0.55, -1.05, -0.01>
    rotate <-180.0, 60.0, 0.0>
    translate  <0.0, -0.05, 2.0>
  }
  cylinder { // Cylndr139
    <0,0,1>, <0,0,0>, 1 
    photons {
      collect off
    }
    scale <0.03, 0.02, 2.1>
    rotate -90.0*x
    translate  <0.0, -0.05, 2.0>
  }
  photons {
    collect off
  }
  material {
    Rust
    // Transform to world space
    translate  <-1.3, -1.5, -7.5>
    rotate -90.0*z
  }
}
#declare GableElements = union {
  object { Gable1 }
  object { // Gable2 -> Gable1
    Gable1
    photons {
      collect off
    }
    scale -1.0
    rotate -180.0*x
  }
  object { GableRoof }
  photons {
    collect off
  }
}
#declare RoofGableDif = difference {
  object { GableElements }
  box { // RoofCut
    <-1, -1, -1>, <1, 1, 1>
    translate  <0.0, 1.0, 1.0>
    photons {
      collect off
    }
    scale <0.58, 0.9, 1.4>
    rotate -25.0*x
    translate  0.025*y
  }
  photons {
    collect off
  }
  material {
    T_Wood7
    // Transform to world space
    translate  <-1.3, -1.5, -7.5>
    rotate -90.0*z
  }
}
#declare RoofGable1 = union {
  object { RoofGableDif }
  box { // GableDoor
    <-1, -1, -1>, <1, 1, 1>
    translate  <1.0, 0.0, 1.0>
    photons {
      collect off
    }
    // Scaling fixed
    // Rot Z limited (0.0 to     90.0)
    // Translation fixed
    scale <0.32, 0.02, 0.71>
    rotate 34.248997*z
    translate  <-0.32, 0.075, 0.0>
    material {
      T_Wood35
      // Transform to world space
      translate  <-1.3, -1.5, -7.5>
      rotate -90.0*z
    }
  }
  photons {
    collect off
  }
  rotate 90.0*z
  translate  <1.3, 1.5, 7.5>
}
#declare ToBeDifferencedFromRoof1 = union {
  object { CSG033 }
  object { // CSG034 -> CSG033
    CSG033
    photons {
      collect off
    }
    scale -1.0
    rotate -180.0*x
  }
  photons {
    collect off
  }
  rotate -90.0*z
  translate  <-1.3, 5.0, 7.5>
  material {
    T_Wood7
    // Transform to world space
  }
}
#declare RoofDifWest = difference {
  box { // RoofWest
    <-1, -1, -1>, <1, 1, 1>
    translate  <1.0, 1.0, 1.0>
    photons {
      collect off
    }
    scale <2.35, 5.0, 0.01>
    rotate -65.0*y
    translate  <-1.98, -0.5, 6.0>
    material {
      Rust
      // Transform to world space
    }
  }
  object { ToBeDifferencedFromRoof1 }
  photons {
    collect off
  }
}
#declare GableRoof5 = union {
  box { // GableRoof3
    <-1, -1, -1>, <1, 1, 1>
    translate  <-1.0, 1.0, 1.0>
    photons {
      collect off
    }
    scale <0.55, 1.05, 0.01>
    rotate -60.0*y
    translate  <0.0, -0.05, 2.0>
  }
  box { // GableRoof4
    <-1, -1, -1>, <1, 1, 1>
    translate  <-1.0, 1.0, 1.0>
    photons {
      collect off
    }
    scale <-0.55, -1.05, -0.01>
    rotate <-180.0, 60.0, 0.0>
    translate  <0.0, -0.05, 2.0>
  }
  cylinder { // Cylndr142
    <0,0,1>, <0,0,0>, 1 
    photons {
      collect off
    }
    scale <0.03, 0.02, 2.1>
    rotate -90.0*x
    translate  <0.0, -0.05, 2.0>
  }
  photons {
    collect off
  }
  material {
    Rust
    // Transform to world space
    translate  <1.3, -5.0, -7.5>
    rotate 90.0*z
  }
}
#declare GableElements1 = union {
  object { Gable3 }
  object { // Gable4 -> Gable3
    Gable3
    photons {
      collect off
    }
    scale -1.0
    rotate -180.0*x
  }
  object { GableRoof5 }
  photons {
    collect off
  }
}
#declare RoofGableDif1 = difference {
  object { GableElements1 }
  box { // RoofCut1
    <-1, -1, -1>, <1, 1, 1>
    translate  <0.0, 1.0, 1.0>
    photons {
      collect off
    }
    scale <0.58, 0.9, 1.4>
    rotate -25.0*x
    translate  0.025*y
  }
  photons {
    collect off
  }
  material {
    T_Wood7
    // Transform to world space
    translate  <1.3, -5.0, -7.5>
    rotate 90.0*z
  }
}
#declare RoofGable2 = union {
  object { RoofGableDif1 }
  box { // GableDoor1
    <-1, -1, -1>, <1, 1, 1>
    translate  <1.0, 0.0, 1.0>
    photons {
      collect off
    }
    // Scaling fixed
    // Rot Z limited (0.0 to     90.0)
    // Translation fixed
    scale <0.32, 0.02, 0.71>
    rotate 62.483402*z
    translate  <-0.32, 0.075, 0.0>
    material {
      T_Wood35
      // Transform to world space
      translate  <1.3, -5.0, -7.5>
      rotate 90.0*z
    }
  }
  photons {
    collect off
  }
  rotate -90.0*z
  translate  <-1.3, 5.0, 7.5>
}
#declare Group_Floor2_Roof = union {
  object { Fronton }
  object { TopFloorDif }
  object { Group_Chimney }
  object { Group_Chimney1 }
  box { // Floor2_HorStrut1
    <-1, -1, -1>, <1, 1, 1>
    translate  -1.0*y
    material {
      DMFWood4Hor
    }
    photons {
      collect off
    }
    scale <0.66, 0.1, 0.05>
    translate  <0.0, -0.55, 8.9>
  }
  box { // Floor2_HorStrut2
    <-1, -1, -1>, <1, 1, 1>
    material {
      DMFWood4Hor
    }
    photons {
      collect off
    }
    scale <1.37, 0.15, 0.05>
    translate  <0.0, -0.55, 7.4>
  }
  box { // AtticShutter1
    <-1, -1, -1>, <1, 1, 1>
    translate  <1.0, 0.0, 1.0>
    photons {
      collect off
    }
    // Scaling fixed
    // Rot Z limited (-90.0 to     90.0)
    // Translation fixed
    scale <0.15, 0.02, 0.35>
    rotate 18.940897*z
    translate  <-0.48, -0.6, 8.0>
    material {
      T_Wood7
      // Transform to world space
    }
  }
  box { // AtticShutter2
    <-1, -1, -1>, <1, 1, 1>
    translate  <-1.0, 0.0, 1.0>
    photons {
      collect off
    }
    // Scaling fixed
    // Rot Z limited (-90.0 to     90.0)
    // Translation fixed
    scale <0.15, 0.02, 0.35>
    rotate -28.565037*z
    translate  <0.48, -0.6, 8.0>
    material {
      T_Wood7
      // Transform to world space
    }
  }
  object { GroupFloor2_Window1 }
  object { RoofDecoration }
  object { Floor2_CeilingAndLintels }
  object { HoistBeam }
  object { RoofDifEast }
  object { RoofGable1 }
  object { RoofDifWest }
  object { RoofGable2 }
  photons {
    collect off
  }
}
#declare BackwallTopFloorDif = difference {
  box { // BackwallTopFloor
    <-1, -1, -1>, <1, 1, 1>
    translate  1.0*z
    photons {
      collect off
    }
    scale <2.0, 0.05, 2.14>
    translate  <0.0, 9.35, 6.0>
  }
  box { // BackwallTopFloor1
    <-1, -1, -1>, <1, 1, 1>
    translate  <1.0, 0.0, 1.0>
    photons {
      collect off
    }
    scale <2.36, 0.1, 1.0>
    rotate -65.0*y
    translate  <-2.0, 9.35, 6.0>
  }
  box { // BackwallTopFloor2
    <-1, -1, -1>, <1, 1, 1>
    translate  <-1.0, 0.0, 1.0>
    photons {
      collect off
    }
    scale <2.36, 0.1, 1.0>
    rotate 65.0*y
    translate  <2.0, 9.35, 6.0>
  }
  photons {
    collect off
  }
  material {
    T_Wood35
    // Transform to world space
  }
}
#declare Backwall = union {
  box { // BackwallGroundFloor
    <-1, -1, -1>, <1, 1, 1>
    photons {
      collect off
    }
    scale <1.9, 0.05, 1.5>
    translate  <0.0, 9.35, 1.5>
    material {
      BrickWall
      // Transform to world space
    }
  }
  box { // BackwallFirstFloor
    <-1, -1, -1>, <1, 1, 1>
    photons {
      collect off
    }
    scale <1.9, 0.05, 1.5>
    translate  <0.0, 9.35, 4.5>
    material {
      T_Wood35
      // Transform to world space
    }
  }
  object { BackwallTopFloorDif }
  photons {
    collect off
  }
}
#declare CSG001 = difference {
  cylinder { // Cylndr001
    <0,0,1>, <0,0,0>, 1 
    photons {
      collect off
    }
    scale <0.2, 0.2, 0.1>
    translate  -0.15*z
  }
  torus { // Torus002
    0.2, 0.05  rotate -x*90
    photons {
      collect off
    }
    translate  -0.1*z
  }
  photons {
    collect off
  }
}
#declare CSG002 = difference {
  box { // Cube001
    <-1, -1, -1>, <1, 1, 1>
    photons {
      collect off
    }
    scale <0.5, 0.5, 0.2>
    translate  -0.37*z
  }
  cylinder { // Cylndr002
    <0,0,1>, <0,0,0>, 1 
    photons {
      collect off
    }
    scale <0.4, 0.5, 1.1>
    rotate -90.0*x
    translate  <0.72, -0.55, -0.17>
  }
  cylinder { // Cylndr003
    <0,0,1>, <0,0,0>, 1 
    photons {
      collect off
    }
    scale <0.4, 0.5, 1.1>
    rotate -90.0*x
    translate  <-0.72, -0.55, -0.17>
  }
  cylinder { // Cylndr004
    <0,0,1>, <0,0,0>, 1 
    photons {
      collect off
    }
    scale <0.4, 0.5, 1.1>
    rotate <-90.0, 0.0, -90.0>
    translate  <-0.55, 0.72, -0.17>
  }
  cylinder { // Cylndr005
    <0,0,1>, <0,0,0>, 1 
    photons {
      collect off
    }
    scale <0.4, 0.5, 1.1>
    rotate <-90.0, 0.0, -90.0>
    translate  <-0.55, -0.72, -0.17>
  }
  cone { // Cone001
    <0,0,0>, 0.5, <0,0,1>, 0.2
    photons {
      collect off
    }
    scale <1.0, 1.0, 0.5>
    translate  -0.7*z
    material {
      White_Paint
      // Transform to world space
      translate  <0.0, 0.81, -3.45>
      rotate -90.0*z
      scale 1.0/0.3
      translate  2.0*x
      translate  2.0*x
    }
  }
  photons {
    collect off
  }
}
#declare Top = union {
  torus { // Torus001
    0.2, 0.05  rotate -x*90
    photons {
      collect off
    }
  }
  object { CSG001 }
  torus { // Torus003
    0.175, 0.02  rotate -x*90
    photons {
      collect off
    }
    translate  -0.15*z
  }
  object { CSG002 }
  cylinder { // Cylndr006
    <0,0,1>, <0,0,0>, 1 
    photons {
      collect off
    }
    scale <0.01, 0.01, 0.96>
    rotate -90.0*x
    translate  <0.48, -0.48, -0.57>
  }
  cylinder { // Cylndr007
    <0,0,1>, <0,0,0>, 1 
    photons {
      collect off
    }
    scale <0.01, 0.01, 0.96>
    rotate -90.0*x
    translate  <-0.48, -0.48, -0.57>
  }
  cylinder { // Cylndr008
    <0,0,1>, <0,0,0>, 1 
    photons {
      collect off
    }
    scale <0.01, 0.01, 0.96>
    rotate <-90.0, 0.0, -90.0>
    translate  <-0.48, -0.48, -0.57>
  }
  cylinder { // Cylndr009
    <0,0,1>, <0,0,0>, 1 
    photons {
      collect off
    }
    scale <0.01, 0.01, 0.96>
    rotate <-90.0, 0.0, -90.0>
    translate  <-0.48, 0.48, -0.57>
  }
  photons {
    collect off
  }
}
#declare LampHolder = union {
  cylinder { // Cylndr010
    <0,0,1>, <0,0,0>, 1 
    photons {
      collect off
    }
    scale <0.02, 0.02, 0.96>
    rotate <-170.0, 10.0, 0.0>
    translate  <0.48, -0.48, -0.57>
  }
  cylinder { // Cylndr011
    <0,0,1>, <0,0,0>, 1 
    photons {
      collect off
    }
    scale <0.02, 0.02, 0.96>
    rotate <-170.0, -10.0, 0.0>
    translate  <-0.48, -0.48, -0.57>
  }
  cylinder { // Cylndr012
    <0,0,1>, <0,0,0>, 1 
    photons {
      collect off
    }
    scale <0.02, 0.02, 0.96>
    rotate <170.0, -10.0, 0.0>
    translate  <-0.48, 0.48, -0.57>
  }
  cylinder { // Cylndr013
    <0,0,1>, <0,0,0>, 1 
    photons {
      collect off
    }
    scale <0.02, 0.02, 0.96>
    rotate <170.0, 10.0, 0.0>
    translate  <0.48, 0.48, -0.57>
  }
  cylinder { // Cylndr014
    <0,0,1>, <0,0,0>, 1 
    photons {
      collect off
    }
    scale <0.015, 0.015, 0.64>
    rotate -90.0*x
    translate  <-0.315, -0.32, -1.5>
  }
  cylinder { // Cylndr015
    <0,0,1>, <0,0,0>, 1 
    photons {
      collect off
    }
    scale <0.015, 0.015, 0.64>
    rotate -90.0*x
    translate  <0.315, -0.32, -1.5>
  }
  cylinder { // Cylndr016
    <0,0,1>, <0,0,0>, 1 
    photons {
      collect off
    }
    scale <0.015, 0.015, 0.64>
    rotate <-90.0, 0.0, -90.0>
    translate  <-0.315, -0.32, -1.5>
  }
  cylinder { // Cylndr017
    <0,0,1>, <0,0,0>, 1 
    photons {
      collect off
    }
    scale <0.015, 0.015, 0.64>
    rotate <-90.0, 0.0, -90.0>
    translate  <-0.315, 0.315, -1.5>
  }
  cylinder { // Cylndr019
    <0,0,1>, <0,0,0>, 1 
    photons {
      collect off
    }
    scale <0.015, 0.015, 0.5>
    rotate <-60.0, 0.0, -45.0>
    translate  -1.75*z
  }
  cylinder { // Cylndr020
    <0,0,1>, <0,0,0>, 1 
    photons {
      collect off
    }
    scale <0.015, 0.015, 0.5>
    rotate <-60.0, 0.0, -135.0>
    translate  -1.75*z
  }
  cylinder { // Cylndr021
    <0,0,1>, <0,0,0>, 1 
    photons {
      collect off
    }
    scale <0.015, 0.015, 0.5>
    rotate <-60.0, 0.0, -225.0>
    translate  -1.75*z
  }
  cylinder { // Cylndr022
    <0,0,1>, <0,0,0>, 1 
    photons {
      collect off
    }
    scale <0.015, 0.015, 0.5>
    rotate <-60.0, 0.0, -315.0>
    translate  -1.75*z
  }
  sphere { // Sphere001
    <0,0,0>,1
    photons {
      collect off
    }
    scale 0.05
    translate  -1.75*z
  }
  photons {
    collect off
  }
}
#declare LampArm = union {
  cylinder { // Cylndr018
    <0,0,1>, <0,0,0>, 1 
    photons {
      collect off
    }
    scale <0.02, 0.02, 0.8>
  }
  cone { // Cone002
    <0,0,0>, 0.06, <0,0,1>, 0.02
    photons {
      collect off
    }
    scale <1.0, 1.0, 0.2>
    translate  0.2*z
  }
  photons {
    collect off
  }
}
#declare Tor1 = difference {
  torus { // Torus004
    0.1, 0.03  rotate -x*90
    photons {
      collect off
    }
    rotate -90.0*x
  }
  box { // Cube002
    <-1, -1, -1>, <1, 1, 1>
    photons {
      collect off
    }
    scale <0.06, 0.05, 0.12>
    translate  0.06*x
  }
  photons {
    collect off
  }
  translate  1.0*z
}
#declare Tor2 = difference {
  torus { // Torus005
    0.15, 0.03  rotate -x*90
    photons {
      collect off
    }
    rotate -90.0*x
  }
  box { // Cube003
    <-1, -1, -1>, <1, 1, 1>
    photons {
      collect off
    }
    scale <0.09, 0.05, 0.17>
    translate  -0.09*x
  }
  photons {
    collect off
  }
  translate  0.95*z
}
#declare Tor3 = difference {
  torus { // Torus006
    0.2, 0.03  rotate -x*90
    photons {
      collect off
    }
    rotate -90.0*x
  }
  box { // Cube004
    <-1, -1, -1>, <1, 1, 1>
    photons {
      collect off
    }
    scale <0.12, 0.054545, 0.250909>
    translate  0.12*x
  }
  photons {
    collect off
  }
  translate  1.0*z
}
#declare GallowDif = difference {
  torus { // Torus007
    1.5, 0.03  rotate -x*90
    photons {
      collect off
    }
    scale <0.8, 0.5, 1.0>
    rotate -90.0*x
    translate  <0.75, 0.0, 0.01>
  }
  box { // Cube006
    <-1, -1, -1>, <1, 1, 1>
    photons {
      collect off
    }
    scale <0.8, 0.05, 1.0>
    translate  -0.05*x
  }
  box { // Cube007
    <-1, -1, -1>, <1, 1, 1>
    photons {
      collect off
    }
    scale <1.3, 0.05, 0.5>
    translate  <0.75, 0.0, -0.5>
  }
  photons {
    collect off
  }
  translate  0.4*z
}
#declare Gallow = union {
  object { Tor1 }
  object { Tor2 }
  object { Tor3 }
  sphere { // Sphere002
    <0,0,0>,1
    photons {
      collect off
    }
    scale 0.055
    translate  0.92*z
  }
  cylinder { // Cylndr023
    <0,0,1>, <0,0,0>, 1 
    photons {
      collect off
    }
    scale <0.03, 0.03, 2.0>
    rotate 90.0*y
    translate  1.2*z
  }
  box { // Cube005
    <-1, -1, -1>, <1, 1, 1>
    photons {
      collect off
    }
    scale <0.05, 0.05, 1.0>
    translate  <2.0, 0.0, 0.4>
  }
  object { GallowDif }
  photons {
    collect off
  }
  translate  -0.4*z
}
#declare LampGlass = union {
  object { Glass1 }
  object { // Glass2 -> Glass1
    Glass1
    photons {
      collect off
    }
    rotate -90.0*z
  }
  object { // Glass3 -> Glass1
    Glass1
    photons {
      collect off
    }
    rotate 180.0*z
  }
  object { // Glass4 -> Glass1
    Glass1
    photons {
      collect off
    }
    rotate 90.0*z
  }
  photons {
    collect off
  }
  material {
    T_Yellow_Glass
    // Transform to world space
    translate  <0.0, 0.81, -3.45>
    rotate -90.0*z
    scale 1.0/0.3
    translate  2.0*x
    translate  2.0*x
  }
}
#declare StreetLamp = union {
  object { Top }
  object { LampHolder }
  object { LampArm }
  object { Gallow }
  object { LampGlass }
  translate  -2.0*x
  photons {
    collect off
  }
  scale 0.3
  rotate 90.0*z
  translate  <0.0, -0.81, 3.45>
  material {
    DarkBlue_Paint
    // Transform to world space
  }
}

#declare mh2=
union { // MedievalHouse2
  object { Group_GroundFloor }
  object { Group_Floor1 }
  object { Group_Floor2_Roof }
  object { Backwall }
  object { StreetLamp }
  photons {
    collect off
  }
}


