// Copyright (C) 2006 by Christian Frschlin

// Quick hack to disable all scene elements which require
// local data or includes I didn't bother to pack for IRTC
#declare LOCAL_DEPENDENCIES = off;

#include "colors.inc"
#include "metals.inc"
#include "stones.inc"
#include "strings.inc"
#include "stars.inc"
#include "rand.inc"
#include "woods.inc"
#include "functions.inc"
#include "glass.inc"

#if (LOCAL_DEPENDENCIES)
#include "solar.inc"
#include "..\..\objects\screw-bottle-lathe.inc"
#else
#declare SUN_COLOR = color White;
#declare EARTH_ATM_SCATTER = color 0.004 * SkyBlue;
#end

global_settings {
  assumed_gamma 1.0
  max_trace_level 10
}

#default {finish {ambient 0}}


/* VIEW */

#declare VIEW_PLANET     = 0;
#declare VIEW_LOW_ORBIT1 = 1;
#declare VIEW_LOW_ORBIT2 = 2;

#declare VIEW = 2;


/* RESOLUTION */

#declare RESOLUTION_ZERO =-1;
#declare RESOLUTION_LOW  = 0;
#declare RESOLUTION_HIGH = 1;
#declare RESOLUTION_ZANY = 2; // (1GB+ recommended)

#declare RESOLUTION = 2;


/* SCENE FLAGS */

#declare USE_TOPOGRAPHY = off;
#declare USE_ATMOSPHERE = on;
#declare USE_CLOUDS = on;

#if (!LOCAL_DEPENDENCIES)
#declare RESOLUTION = RESOLUTION_ZERO;
#declare USE_TOPOGRAPHY = off;
#end


#if (VIEW = VIEW_PLANET)
camera {
  location  <0.0, 0.0, -0.6>
  look_at   <0.0, 0.0,  0.0>
  angle 90
}
light_source {<-10000, 500, -4000> color 3 * SUN_COLOR}
#end 

#if (VIEW = VIEW_LOW_ORBIT1)
camera {
  location  <0.0, 0.0,-0.52>
  look_at   <0.0, 1.0, 0.0>
  sky -z
  angle 90
}
light_source {<-10000, 500, -4000> color 3 * SUN_COLOR}
#end 

#if (VIEW = VIEW_LOW_ORBIT2)
camera {
  location  <0.0, 0.0,-0.52>
  look_at   <0.0, 1.0,-0.0>
  sky 2*z+x
  angle 90
}
light_source {<10000, 500, -4000> color 3 * SUN_COLOR}
#end 


sphere
{
  0, 20000 hollow 
  texture
  {
    average texture_map
    {
      [0.1 Starfield1]
      [0.9 pigment{color Black}]
    }
  }
}


#declare fn_Height=function {
  pigment
  {
    #if (RESOLUTION > RESOLUTION_ZERO)
    image_map 
    {
      #if (RESOLUTION <= RESOLUTION_LOW)
      jpeg "images\worlds\srtm_ramp2.world.5400x2700.jpg"
      #else
      jpeg "images\worlds\srtm_ramp2.world.10800x5400.jpg"
      #end
      map_type 1
    }
    scale 0.9*y
    #end
  }
}

union
{
  #if (USE_TOPOGRAPHY)
  
  isosurface 
  {
    function { f_sphere(x, y, z, 0.5) - 0.002*fn_Height(x,y,z).gray} 
    contained_by { box { -0.6, 0.6 } }
    //max_gradient 10
    max_gradient 2
    accuracy 0.000001
  } 

  #else
  
  sphere {0,0.5}
  
  #end


  #if (USE_ATMOSPHERE)


  //Atmo-Sphere
    
  difference
  {
    sphere {0, 0.53}
    sphere {0, 0.500001}
    no_shadow
    
    hollow 
    
    texture
    {
      pigment {color rgbt 1}
      finish {ambient 0}
    }
    
    interior
    {
      media 
      {
        #if (VIEW = 0)
        scattering {1, 300 * EARTH_ATM_SCATTER}
        #else
        scattering {1, 2000 * EARTH_ATM_SCATTER}
        #end
        
        density
        {
          spherical color_map
          {
            [0       color rgb 0.0]
            [1-0.53  color rgb 0.0]
            [1-0.51  color rgb 0.05]
            [1-0.502 color rgb 0.1]
            [1-0.501  color rgb 0.3]
            [1-0.50   color rgb 1.0]
            [1       color rgb  1.0]
          }
        }
      }    
    }
  }

  #end
  
  
  //Ocean sphere (alternative to using layered texture & transparent pigment map)
  //sphere {0,0.5+0.001}

  // Ocean texture 
  texture
  {
    pigment {color 0.1 * Navy}
    //normal {ripples 0.2 translate -0.5 scale 0.01 translate -0.5*z turbulence 1.0}
    finish {ambient 0 reflection 0.0}
  }
  
  // Satellite land texture (preprocessed to have transparent oceans)
  texture
  {
    pigment
    {
      #if (RESOLUTION > RESOLUTION_ZERO)
      image_map 
      {
        #if (RESOLUTION = RESOLUTION_LOW)
        png "images\worlds\world.200405.3x5400x2700_transparent.png"
        #end

        #if (RESOLUTION = RESOLUTION_HIGH)        
        png "images\worlds\world.200405.3x10800x5400_transparent.png"
        #end

        #if (RESOLUTION = RESOLUTION_ZANY)
        png "images\worlds\world.200405.3x21600x10800_transparent.png"
        #end
        
        map_type 1
      }
      #end
      scale 0.9*y
    }
    finish {ambient 0}
  }
  
  // Cloud layer

  #if (USE_CLOUDS)

  #if (VIEW = 0)
  #declare CLOUDS = pigment
  {
    function {0.85*f_bozo(x, y, z) + 0.15*f_bozo(x*5, y*5, z*5)} 
    scale 0.1 color_map 
    {
      [0.00 rgbt 1]
      [0.5 rgbt 1]
      [0.7 rgb 1]
      [1.00 rgb 1]
    }
    turbulence 0.7
  }
  #else
  #declare CLOUDS = pigment
  {
    function {0.4*f_bozo(x/5, y/5, z/5) + 0.4*f_bozo(x, y, z) + 0.2*f_bozo(x*8, y*8, z*8)} 
    scale 0.05 color_map 
    {
      [0.00 rgbt 1]
      [0.50 rgbt 1]
      [0.8 rgb 1]
      [1.00 rgb 1]
    }
    turbulence 0.7
  } 
  #end 
  
  texture
  {
    pigment {CLOUDS}  
    normal {bozo 0.2 scale 0.0005}
    finish {ambient 0}
  }
  #end

  rotate -58 * y
  rotate -30 * x
}


/* Add some junk objects */
#if (VIEW_LOW_ORBIT2)

#declare METAL = texture
{
  pigment {P_Chrome1}
  finish  {F_MetalB ambient 0}  
}

#declare PLASTIC = texture
{
  pigment {color rgb 0.9}
  finish {phong 0.5 phong_size 30}
}

#declare PEEL = intersection
{
  torus {1,  0.25}
  plane {z, -0.7}
  translate 0.7*x  
  scale <1,1,0.3>
  texture
  {
    pigment {color rgb <0.8,1,0.2>}
    normal {bumps 0.1 scale 0.1}
  }
}

#declare PEELS = union
{ 
  object {PEEL}
  object {PEEL rotate  -100*z}
  object {PEEL rotate  110*z}
}

#declare FISHBONE = union
{
  cylinder {0,y,0.025}
  #local i = 0;
  #while (i < 10)
    union
    {
      cylinder {0,0.2*y,0.02 rotate  135*z}       
      cylinder {0,0.2*y,0.02 rotate -135*z}
      translate (1/9)*i*y
    }
    #local i = i + 1;
  #end
  texture {PLASTIC}
}


#declare NUCLEAR = cylinder
{
  0, y, 0.3
  texture {METAL normal {bumps 0.3 scale 0.1}}
#if (LOCAL_DEPENDENCIES)  
  texture 
  {
    pigment 
    {
      image_map {gif "radiation.gif" once}
      scale 0.3 translate 0.35*y rotate -110*y
    }
    normal {bumps 0.3 scale 0.1}
  }
#end
}
  
#declare BOTTLE = difference
{
#if (LOCAL_DEPENDENCIES)
  object{screw_bottle_lathe}
  object{screw_bottle_lathe scale <0.99,0.9999,0.99> translate 0.001*y}
  pigment {color rgbf <0,1,0,0.0>}
  finish {F_Glass7}
  interior {I_Glass}
#end  
}

#declare CIG = union
{
  cylinder {0,y,0.1}
  texture
  {
    gradient y texture_map
    {
      [0.0 pigment {color Orange}]
      [0.7 pigment {color Brown}]
      [0.71 pigment {color White}]
      [1.0 pigment {color Black}]
    }
  }
}  
  
union
{
  // Toilet seat
  union
  {
    torus    {0.5, 0.1 scale <1, 0.1, 1>}
    sphere   {0, 0.6 scale <1,0.05,1> translate 0.6*z rotate -20*x translate -0.6*z}
    scale <0.8, 1, 1>
    texture {PLASTIC}
    rotate 30*x
    rotate 30*y
    scale 1.2
    translate <1,-0.5,-4>
  }

  // Fish bone
  object {FISHBONE rotate 60*z scale 0.9 translate <3,2.2,-8>}
  
  // Banana peels
  object {PEELS rotate 30*y rotate 70*z translate -40*z translate 15*x translate 15*y}

  // CIG
  object {CIG scale 0.7 rotate 30*y rotate 30*x rotate 20*z translate <-1.3, -1, -5>}

  
  // Nuclear cans
  object {NUCLEAR}
  object {NUCLEAR rotate 10*z rotate -20*x translate <2, 0, -4>}  
  object {NUCLEAR rotate -10*y rotate 70*z translate <-2,2,-6>}
  
  // Empty bottles
  object {BOTTLE rotate 160*x translate <-1, 0.5, -0.5>}
  object {BOTTLE rotate 150*x rotate 170*z translate <2.4, -0.5, -3.5>}

  // Background debris and dust
  cone
  {
    -1.8*z, 1, <3.8,3.7,-5>, 0.2 hollow
    pigment {color rgbt 1}    
    interior
    {
      media
      { 
        emission 50 * Green               
      }
      media 
      {
        emission 15000.0
        density 
        {
          bozo scale 0.12
          density_map { [0 rgb 0][0.82 rgb 0][0.84 rgb <1.0,1.0,1.0>] }
        }
      }     
    }    
  }
  
  /* Compensate for camera position */  
  translate -2*z
  scale 0.0001
  rotate 90*x
  rotate 30*y
  translate -0.52 * z 
}


/* Space Suit - Blob doesn't work with above scaling.
   Therefore let's have him at planet size. */

union
{
  #local pointleft = z;
  #local pointright = z;
  #local leftnorm = pointleft / vlength(pointleft);
  #local rightnorm = pointright / vlength(pointright);

  blob
  {
    threshold 0.5

    // Torso
    cylinder {0.9*y, 1.35*y, 0.40, 1 scale <1,1,0.6>}

    // Buttocks
    sphere {0, 0.2, 1 scale <0.5,1,0.5> translate <-0.08, 0.85, -0.05>}
    sphere {0, 0.2, 1 scale <0.5,1,0.5> translate < 0.08, 0.85, -0.05>}
   
    // Legs
    cylinder {0, 0.85*y, 0.13, 1 translate -0.12 * x}
    cylinder {0, 0.85*y, 0.13, 1 translate  0.12 * x}

    // Feet
    cylinder {0, 0.2*z, 0.1, 1 translate -0.12 * x}
    cylinder {0, 0.2*z, 0.1, 1 translate  0.12 * x}

    // Arms + Hands
    cylinder {<-0.2,1.4,0>, <-0.2,1.4,0> + 0.4 * leftnorm, 0.12, 1}
    cylinder {< 0.2,1.4,0>, < 0.2,1.4,0> + 0.4 * rightnorm, 0.12, 1}
    sphere {<-0.2,1.4,0> + 0.5 * leftnorm, 0.09, 1}
    sphere {< 0.2,1.4,0> + 0.5 * rightnorm, 0.09, 1}
  
  
    // Supply line
    cylinder {1.4*y+0.1*x, 1.6*y+0.5*x, 0.04, 1}
    cylinder {1.6*y+0.5*x, 1.4*y+2.0*x, 0.04, 1}
    
    pigment {color White}
    finish {ambient 0.01}
    normal {wrinkles 1.0 scale 0.08}    
  }
  

  #local binshape = cylinder {0, y, 0.25}
  
  difference
  {
    object {binshape}
    object {binshape scale 0.98 translate 0.05*y}
    texture 
    {
      pigment {color White}
      normal {marble 3.0 scale 0.05 warp {cylindrical}}
      finish {F_MetalB ambient 0}
    }
    translate -0.2*y
    rotate 150*x
    translate <0,1.4,0> + 0.5*leftnorm
  }
      
  rotate -50*y
  rotate -10*x
  translate <3,1.5,-5>
  
  rotate 90*x
  rotate 30*y  
  translate -0.52*z
}


#end
