#declare blank =
texture{
  pigment{ color rgb .7 }
  finish{ ambient .05 diffuse .6 phong .1 phong_size 5 }
  }

#declare stone_tex =
texture{
  pigment{
    granite
    color_map{
      [0.0 color rgb <116/255,91/255,86/255>]
      [0.25 color rgb .5]
      [0.4 color rgb .2]
      [1.0 color rgb .5]
      }
    }
  finish{ ambient 0 diffuse .7 }
  }
  
#declare mortar_tex =
texture{
  pigment{
    granite
    color_map{
      [0.0 color rgb .3 ]
      [1.0 color rgb .45 ]
      }
    scale 10
    }
  finish{ ambient .1 diffuse .7 }
  }
  
#declare sand_stone_tex1 =
texture{
  pigment{
    granite
    color_map{
      [0.0 color rgb 1.3*<246/255,137/255,60/255>]
      [1.0 color rgb 1.5*<246/255,103/255,60/255>]
      }
    scale 2
    }
  finish{ ambient .01 diffuse .3 }
  }

#declare sand_stone_tex2 =
texture{
  pigment{
    granite
    color_map{
      [0.0 color rgb 1.3*<246/255,137/255,60/255>]
      [1.0 color rgb 1.5*<246/255,103/255,60/255>]
      }
    scale 2
    }
  finish{ ambient .01 diffuse .2 }
  }

#declare cor_steel1 =
normal {
  gradient x
  turbulence .12
  slope_map {
    [0   <0, 0>]
    [.1  <.8, .5>]
    [.2 <1.5,0>]
    [.3 <1.5,0>]
    [.4 <.8, -.5>]
    [.5 <0,0>]
    [1 <0,0>]
    }
    scale .01
  }

#declare cor_steel2 =
normal {
  gradient x
  turbulence .07
  slope_map {
    [0   <0, 0>]
    [.1  <.4, .5>]
    [.2 <.8,0>]
    [.3 <.8,0>]
    [.4 <.4, -.5>]
    [.5 <0,0>]
    [1 <0,0>]
    }
    scale .01
  }

#declare cor_steel_plates =
normal{
  bump_map{
    gif "metal_pattern_plates.gif"
    interpolate 2
    bump_size 1
    }
    scale 2
  }

#declare rust_streaks_1 =
texture{
  pigment{
    image_map{
      png "rust_streaks_1.png"
      interpolate 2
    }
    translate -.5
    scale <30,10,1>
    }
    finish{ ambient .05 diffuse .15 }
}

#declare rust_streaks_3 =
texture{
  pigment{
    image_map{
      png "rust_streaks_3.png"
      interpolate 2
    }
    translate -.5
    scale .8*<.5,1,.5>
    }
    finish{ ambient 0 diffuse .5 }
    normal{ cor_steel1 }
}

#declare rust_streaks_4 =
texture{
  pigment{
    image_map{
      png "rust_streaks_4.png"
      interpolate 2
    }
    translate -.5
    scale 1
    }
    finish{ ambient 0 diffuse .4 }
    normal{ granite .2 scale .05 }
}

#declare shafthouse_tex1 =
texture{
  pigment{
    bozo
    turbulence .2
    omega .2
    lambda .8
    octaves 3
    color_map{
      [0.0 color rgb <162/255,178/255,192/255> ]
      [1.0 color rgb <169/255,178/255,188/255> ]
      }
    scale .01*<2,20,2>
    }
  finish{ ambient .05 diffuse .4 specular .1 roughness 1 }
  normal { 
    average
      normal_map{
        [0.8 cor_steel1 bump_size .6 translate 8 ]
        [0.2 cor_steel_plates bump_size 1 scale .5 ]
        }
    }
  }
texture{ rust_streaks_3 translate 8 }

#declare shafthouse_tex2 =
texture{
  pigment{
    bozo
    turbulence .2
    omega .2
    lambda .8
    octaves 3
    color_map{
      [0.0 color rgb <162/255,185/255,200/255> ]
      [1.0 color rgb .98*<169/255,178/255,188/255> ]
      }
    scale .01*<2,20,2>
    }
  finish{ ambient .05 diffuse .4 specular .1 roughness 1 }
  normal { 
    average
      normal_map{
        [0.8 cor_steel1 bump_size .6 translate 1 ]
        [0.2 cor_steel_plates bump_size 1 scale .5 ]
        }
    }
  }
texture{ rust_streaks_3 translate 1 }
  
#declare shafthouse_tex3 =
texture{
  pigment{
    bozo
    turbulence .2
    omega .2
    lambda .8
    octaves 3
    color_map{
      [0.0 color rgb <185/255,201/255,210/255> ]
      [1.0 color rgb .92*<169/255,178/255,188/255> ]
      }
    scale .01*<2,20,2>
    }
  finish{ ambient .05 diffuse .4 specular .1 roughness 1 }
  normal { 
    average
      normal_map{
        [0.8 cor_steel1 bump_size .6 translate 2 ]
        [0.2 cor_steel_plates bump_size 1 scale .5 ]
        }
    }
  }
texture{ rust_streaks_3 translate 5 }
  
#declare shafthouse_tex4 =
texture{
  pigment{
    bozo
    turbulence .2
    omega .2
    lambda .8
    octaves 3
    color_map{
      [0.0 color rgb <201/255,212/255,215/255> ]
      [1.0 color rgb <169/255,178/255,178/255> ]
      }
    scale .01*<2,20,2>
    }
  finish{ ambient .05 diffuse .4 specular .1 roughness 1 }
  normal { 
    average
      normal_map{
        [0.8 cor_steel1 bump_size .6 translate .2 ]
        [0.2 cor_steel_plates bump_size 1 scale .5 ]
        }
    }
  }
texture{ rust_streaks_3 }

#declare shafthouse_tex5 =
texture{
  pigment{
    bozo
    turbulence .2
    omega .2
    lambda .8
    octaves 3
    color_map{
      [0.0 color rgb <201/255,212/255,215/255> ]
      [1.0 color rgb <169/255,178/255,178/255> ]
      }
    scale .01*<2,20,2>
    }
  finish{ ambient .05 diffuse .4 specular .05 roughness 1 }
  normal { cor_steel1 translate .3 }
  }
texture{ rust_streaks_1 scale 2 }

 
#declare shafthouse_tex =
texture {
  image_pattern { gif "metal_pattern.gif" } scale 100
   texture_map {
     [0.0 shafthouse_tex1 ]
     [0.2 shafthouse_tex1 ]
     [0.2 shafthouse_tex2 ]
     [0.5 shafthouse_tex2 ]
     [0.5 shafthouse_tex3 ]
     [0.8 shafthouse_tex3 ]
     [0.8 shafthouse_tex4 ]
     [1.0 shafthouse_tex4 ] 
   }
   scale <1,.40,1>
   translate -5 
 }

#declare white_molding_tex =
texture{
  pigment{ color rgb .95 }
  finish{ ambient .05 diffuse .6 phong .7 phong_size 20 }
  }


#declare dull_steel_tex =
texture{
  pigment{ color rgb .1 }
  finish{ ambient .1 diffuse .2 specular .7 roughness .05 }
  }
  
#declare rusted_metal_tex =
texture{
  pigment{
    bozo
    color_map{
      [0.0 rgb <42,35,32>/255 ]
      [1.0 rgb <60,47,38>/255 ]
      }
    }
  normal{ granite .1 scale 2 }
  finish{ ambient .1 diffuse .5 specular .05 roughness .05 }
  }

#declare rusted_metal_tex2 =
texture{
  pigment{
    granite
    turbulence .02
    color_map{
      [0 color <127/255,61/255,35/255>]
      [.6 color <62/255,38/255,26/255>]
      [.75 color <99/255,77/255,64/255>]
      [1 color <99/255,77/255,64/255>]
      }
    scale <30,28,30> 
    }
  normal {
    gradient y
    slope_map {
      [0   <0, 0>]
      [.03  <.2, .5>]
      [.1 <.2, -.5>]
      [.18 <0,0>]
      [1 <0,0>]
    }
    scale 7.5 translate -4*y
  } 
  finish{ ambient .1 diffuse .5 specular .05 roughness .05 }
  }



#declare rusted_metal_tex3 =
texture{
  pigment{ color rgb <127/255,61/255,35/255> }
  finish{ ambient .1 diffuse .5 specular .05 roughness .05 }
  }


#declare rusted_metal_tex4 =
texture{
  granite
  texture_map{
    [0.0 rusted_metal_tex2 ]
    [0.3 rusted_metal_tex2 ]
    [0.6 dull_steel_tex ]
    [1.0 dull_steel_tex ]
    }
    scale 4 
  }

#declare rusted_metal_tex5 =
texture{
  pigment{
    bozo
    frequency 2
    turbulence .4
    octaves 8 lambda 1.5 omega 0.8
    color_map{
      [0 color <87/255,71/255,45/255> ]
      [.6 color <86/255,45/255,10/255> ]
      [1 color <50/255,21/255,20/255> ]
      }
    scale 1 
    }
  normal { granite .7 turbulence .4
    octaves 8 lambda 1.5 omega 0.8 scale 1 } 
  finish{ ambient .1 diffuse .5 specular .05 roughness .05 }
  }

#declare rusted_metal_tex6 =
texture{
  bozo
  turbulence .4 
  octaves 8 lambda 1.5 omega 0.8  
  texture_map{
    [0.0 rusted_metal_tex5 scale .2 ]
    [0.3 rusted_metal_tex5 scale .5 ]
    [0.5 rusted_metal_tex ]
    [1.0 rusted_metal_tex ]
    }
  }

#declare steel_tex =
texture{
  pigment{ color rgb .8 }
  finish{ ambient .05 diffuse .4 reflection .2 specular .8 roughness .05 }
  }
  
#declare flagpole_tex =
texture{
  granite
  texture_map{
      [0.0 steel_tex ]
      [0.3 steel_tex ]
      [0.8 rusted_metal_tex ]
      [1.0 rusted_metal_tex ]
      }
    scale 5
  }

#declare window_molding_tex_paint =
texture{
  pigment{ color rgb <.9,.4,.4> }
  finish{ ambient .05 diffuse .3 }
  }
  
#declare window_molding_tex_worn =
texture{
  pigment{ color rgb <234/255,216/255,214/255> }
  finish{ ambient .05 diffuse .5 }
  }

#declare window_molding_tex =
texture{
  granite
  texture_map{
      [0.0 window_molding_tex_paint ]
      [0.3 window_molding_tex_paint ]
      [0.8 window_molding_tex_worn ]
      [1.0 window_molding_tex_worn ]
      }
    scale 5
  }
  

#declare glass_tex =  
texture{
  pigment{ rgbf <1,1,1,.96> }
  finish{ reflection .2 specular .8 roughness .01 }
  }
  
#declare glass_tex2 =  
texture{
  pigment{
    granite
    color_map{
      [0.0 color rgbf <1,1,1,1>]
      [0.4 color rgbf <234/255,233/255,218/255,1> ]
      [0.5 color rgbf <234/255,233/255,218/255,.9> ]
      [1.0 color rgbf <234/255,233/255,218/255,.8> ]
      }
    }
  finish{ reflection .03 specular .3 roughness .01 }
  }
  
#declare concrete_base_tex =
texture{
  pigment{
    granite
      color_map{
        [0.0 color rgb .9 ]
        [1.0 color rgb .6 ]
        }
      scale 10
    }
  normal{ 
    average
    normal_map{
      [.5 agate .3 scale 2]
      [.5 granite .3 scale 5]
      }
    }
  finish{ ambient .05 diffuse .56 }
  }
  
#declare concrete_rust =
texture{
  pigment{
    image_map{
      png "rust_streaks_2.png"
      map_type 2
      }
    scale 14
    translate 12.5*y
    rotate 50*y
    }
  normal{ 
    average
    normal_map{
      [.5 agate .6 scale 2]
      [.5 granite .6 scale 5]
      }
    }
  finish{ ambient .05 diffuse .35 }
  translate 127.5*x
  }  
  
#declare ground_base_tex =
texture{
  pigment{
    granite
      color_map{
        [0.0 color rgb 1.6*<32/255,75/255,20/255>]
        [0.6 color rgb 1.6*<75/255,66/255,61/255>]
        }
    }
  finish{ ambient .05 diffuse .75 }
  scale 60 
  }  
  
#declare concrete_tex =
texture{ concrete_base_tex }
texture{ concrete_rust }


#declare hoisthouse_tex1 =
texture{
  pigment{
    bozo
    turbulence .2
    omega .2
    lambda .8
    octaves 3
    color_map{
      [0.0 color rgb <162/255,178/255,192/255> ]
      [1.0 color rgb .9*<169/255,178/255,188/255> ]
      }
      scale .1*<.1,1,1>
    }
  finish{ ambient .05 diffuse .4 specular .1 roughness 1 }
  normal { 
    average
      normal_map{
        [0.7 cor_steel2 bump_size 2 scale 1.2 ]
        [0.3 cor_steel_plates ]
        }
    }
  scale 5
  }
texture{ rust_streaks_4 scale 5 translate 2.6*y  }

#declare hoisthouse_tex2 =
texture{
  pigment{
    bozo
    turbulence .2
    omega .2
    lambda .8
    octaves 3
    color_map{
      [0.0 color rgb <162/255,185/255,200/255> ]
      [1.0 color rgb .91*<169/255,178/255,188/255> ]
      }
      scale .1*<.1,1,1>
    }
  finish{ ambient .05 diffuse .4 specular .1 roughness 1 }
  normal { 
    average
      normal_map{
        [0.7 cor_steel2 bump_size 2 scale 1.2 ]
        [0.3 cor_steel_plates ]
        }
    }
  scale 5
  }
texture{ rust_streaks_4 scale 5 translate 2.6*y  }
  
#declare hoisthouse_tex3 =
texture{
  pigment{
    bozo
    turbulence .2
    omega .2
    lambda .8
    octaves 3
    color_map{
      [0.0 color rgb <185/255,201/255,210/255> ]
      [1.0 color rgb .9*<169/255,178/255,188/255> ]
      }
      scale .1*<.1,1,1>
    }
  finish{ ambient .05 diffuse .4 specular .1 roughness 1 }
  normal { 
    average
      normal_map{
        [0.7 cor_steel2 bump_size 2 scale 1.2 ]
        [0.3 cor_steel_plates ]
        }
    }
  scale 5
  }
texture{ rust_streaks_4 scale 5 translate 2.6*y  }
  
#declare hoisthouse_tex4 =
texture{
  pigment{
    bozo
    turbulence .2
    omega .2
    lambda .8
    octaves 3
    color_map{
      [0.0 color rgb <201/255,212/255,215/255> ]
      [1.0 color rgb .9*<169/255,178/255,178/255> ]
      }
      scale .1*<.1,1,1>
    }
  finish{ ambient .05 diffuse .4 specular .1 roughness 1 }
  normal { 
    average
      normal_map{
        [0.7 cor_steel2 bump_size 2 scale 1.2 ]
        [0.3 cor_steel_plates ]
        }
    }
  scale 5
  }
texture{ rust_streaks_4 scale 5 translate 2.6*y  }
  
#declare hoisthouse_tex =
texture {
  image_pattern { gif "metal_pattern.gif" }
   texture_map {
     [0.0 hoisthouse_tex1 scale .1 ]
     [0.25 hoisthouse_tex2 scale .1 ]
     [0.75 hoisthouse_tex3 scale .1 ]
     [1.0 hoisthouse_tex4 scale .1 ]
   }
   scale 40 translate 20*y
    
 }
 
#declare sky_color1=rgb <101,133,171>/255;
#declare sky_color2=rgb <221,228,233>/255;

#declare sky_color=pigment{
    gradient z
    pigment_map{
        [0 pigment_pattern{
             function{max(0,min(1,y))}
             } 
             color_map{[0 sky_color2*2][0.5 sky_color1*2]}
             ]
        [1 pigment_pattern{
             function{max(0,min(1,y))}
             } 
             color_map{[0 sky_color2][0.5 sky_color1]}
             ]
    }
    scale <1,1,2>
    translate -z
}

#declare sky_color2=pigment{
    gradient y
    pigment_map{
        [0 sky_color2 ]
        [1 sky_color1 ]
    }
    scale <1,1,2>
    translate -z
}

#declare utility_pole_tex =
texture{
  pigment{ color rgb <.7,.75,.6> }
  finish{ ambient .05 diffuse .5 }
  }
  
#declare utility_cable_tex =
texture{
  pigment{ color rgb .1 }
  finish{ ambient .05 diffuse .7 phong .5 phong_size 150 }
  }

#declare poor_rock_tex1 =  
  texture{
  pigment{
    granite
    color_map{
      [0.0 color rgb <116/255,91/255,86/255>]
      [0.25 color rgb .5]
      [0.4 color rgb .2]
      [1.0 color rgb .5]
      }
      scale 10
    }
    normal{ granite 1 scale 10 }
    finish{ ambient .05 diffuse .2 }
    }

#declare poor_rock_tex2 =  
  texture{
  pigment{ color rgb .5 }
    normal{ granite .1 scale 10 }
    finish{ ambient .05 diffuse .2 }
    }
    
#declare leaf_tex1 =
texture{
  pigment{
    granite
    color_map{
      [0.0 color rgb <166/255,206/255,81/255>]
      [0.25 color rgb <166/255,206/255,81/255>]
      [0.4 color rgb <108/255,154/255,58/255>]
      [1.0 color rgb <108/255,154/255,58/255>]
      }
    }
  finish{ ambient 0 diffuse .6 phong .15 phong_size 5 }
  }

#declare leaf_tex2 =
texture{
  pigment{
    granite
    color_map{
      [0.0 color rgb 1.1*<166/255,206/255,81/255>]
      [0.25 color rgb 1.1*<166/255,206/255,81/255>]
      [0.4 color rgb 1.3*<108/255,154/255,58/255>]
      [1.0 color rgb 1.3*<108/255,154/255,58/255>]
      }
    }
  finish{ ambient 0 diffuse .45 phong .15 phong_size 5 }
  scale 4
  }

#declare elm_leaf_tex =
texture{
  pigment{
    granite
    color_map{
      [0.0 color rgb <47,75,29>/255 ]
      [0.25 color rgb <47,75,29>/255 ]
      [0.4 color rgb <68,110,42>/255 ]
      [1.0 color rgb <68,110,42>/255 ]
      }
    }
  finish{ ambient 0 diffuse .45 phong .15 phong_size 60 }
  }
  
#declare birch_leaf_tex =
texture{
  pigment{
    granite
    color_map{
      [0.0 color rgb <113,151,67>/255 ]
      [0.25 color rgb <113,151,67>/255 ]
      [0.4 color rgb <176,216,142>/255 ]
      [1.0 color rgb <176,216,142>/255 ]
      }
    }
  finish{ ambient 0 diffuse .45 phong .5 phong_size 10 }
  }

#declare fruit_tex =
texture{
  pigment{ color rgb <249,238,177>/255 }
  finish{ ambient .05 diffuse .6 }
  }

#declare fuzz_tex =
texture{
  pigment{ color rgb <249,238,177>/255 }
  finish{ ambient .05 diffuse .8 phong .2 phong_size 10 }
  }

#declare stem_tex = 
texture{
  pigment{ color rgb <218,197,160>/255 }
  finish{ ambient .05 diffuse .6 }
  }

#declare bergamot_tex = 
texture{
  pigment{ color rgb <236,178,238>/255 }
  finish{ ambient .05 diffuse .85 }
  }

#declare qal_tex = 
texture{
  pigment{ color rgb .98 }
  finish{ ambient .1 diffuse .8 }
  }
  
#declare trunk_tex =
texture{
  pigment{ color rgb <81/255,61/255,13/255> }
  finish{ ambient .05 diffuse .6 }
  }

#declare birch_trunk_tex =
texture{
  pigment{
    bozo
    color_map{
      [0.0 color rgb .3 ]
      [0.35 color rgb .5 ]
      [0.38 color rgb 1 ]
      [1.0 color rgb 1 ]
      }
    }
  finish{ ambient .05 diffuse .5 }
  normal{ bumps .15 scale <2,1,2> }
  scale <2,1,2>
  }
  
#declare dirt_tex =
texture{
  pigment{
    granite
    color_map{
      [0.0 color rgb .7*<167,157,135>/255 ]
      [1.0 color rgb .65*<189,184,159>/255 ]
      }
    }
  finish{ ambient 0 diffuse .6 }
  normal{ granite .3 scale 2 }
  }
  
#declare dirt_far_tex =
texture{
  pigment{
    granite
    color_map{
      [0.0 color rgb .7*<167,157,135>/255 ]
      [1.0 color rgb .65*<189,184,159>/255 ]
      }
    }
  finish{ ambient 0 diffuse .6 }
  normal{ granite .3 scale 10 }
  }
  
#declare hawk_mask =
texture{
  pigment{
    image_map{
      gif "hawk_mask.gif"
      interpolate 2
      transmit 251, 1
      once
    }
    translate -.5
    scale 2*<2,1.25,1>
    }
    finish{ ambient 0 diffuse .8 }
}