#include "shapes.inc" 
#include "colors.inc"
#include "woods.inc"

global_settings {
  assumed_gamma 1.0
}    

camera{location<0,0,-30>look_at<0,1,3>rotate<5,70,0>angle 15} 
 
light_source{<0,0,-70>rgb .8 rotate<10,60,0>} //camera  
light_source{<9.5,6,4.5>
rgb < 0.8509804,  0.9686275,  1.0 >shadowless} //coin
light_source{<-4, 5.5,4>rgb<.871,.682,.0392>}//mur

/////////////////////////////////////////////////////////////

#declare T_Sol_1=
  texture{
    pigment{dents turbulence 1 scale <2,.3,.3> 
         color_map{
         [0 rgb < 0.957,  0.871,  0.69 >] 
         [.4 rgb < 0.937,  0.812,  0.553 >]
         [.8 rgb < 0.306,  0.239,  0.0784 >]
         } 
       }
       normal{ bozo 2 scale 7 
         turbulence 1 translate <1,5,9>}
    } 
    
#declare T_Sol_2= 
  texture{
    pigment{bozo scale 7 
         turbulence 1  
         phase .1
      color_map{
      [0 rgbt 1]
      [.68 rgbt 1]
      [.78 rgb < 0.2862745,  0.2196078,  0.07058824 >] 
      [.8 rgb < 0.8078431,  0.627451,  0.2078431 >/2]
      }
    } 
    translate <1,5,9>   
  } 

#declare T_Sol=  
texture{
		average
		texture_map {
			[.5, T_Sol_1]
			[1, T_Sol_2] 
		}
	}

#declare T_Mur=
texture{
   pigment{
        agate 
        color_map{
        [0 rgb<95,  72,  50>/255]
        [.7 rgb<97,  91,  82>/255]
        }
   } 
}

#declare P_Carrelage_1=
  pigment {rgb < 0.663,  0.839,  0.718 >}
 
#declare P_Carrelage_2=
 pigment {
     bozo
        color_map{
     [0 rgb < 0.071,  0.059,  0.039 >]
     [.5 rgb < 0.36,  0.4,  0.26 >] 
        }
 }
 
#declare T_Carrelage=
texture{ 
   pigment{
		bozo  
		pigment_map {
			[0 P_Carrelage_1] 
			[.2 P_Carrelage_1]
			[.98 P_Carrelage_2] 
		}
	} 
finish{crand .05} 
	normal{agate .2 }
}  

#declare T_Miroir_1 = texture {
	pigment {rgb 0}
	finish {reflection 1}
} 
#declare T_Miroir_2 = texture {
  pigment {
	 bozo turbulence 2  scale .2
	 color_map{
	 [0 rgb < 0.118,  0.0863,  0.0235 >]
	 [.8 rgb 0]
	 } 
   }
	finish {reflection .3}
} 
#declare T_Miroir= texture { 
                bozo turbulence 1.2  
            texture_map{
            [0 T_Miroir_1] 
            [.5 T_Miroir_1]
            [.8 T_Miroir_2]
            }
    translate z*2
}

#declare T_Poubelle_Int= 
texture{
 pigment{
       bozo
       turbulence .8
       lambda 2
	omega .8
	octaves 5
	frequency 3
	phase .3
       color_map{
       [0 rgb 0]
       [.8 rgb<69,  62,  31>/255] 
       [.9 rgb <65,  67,  33>/255]
       }
 }
   finish{specular .1} 
}  

#declare T_Poubelle_Ext= 
texture{
 pigment{
       bozo
       turbulence 1
       color_map{
       [0 rgb 0] 
       [.5 rgb 0] 
       [.9 rgb <113,  100,  51>/255]
       }
 }
   finish{specular .1} 
} 

#declare T_Souris=
texture{
     pigment{
        agate 
        color_map{
        [0 rgb .25]  
        [.5 rgb .35]
        } 
     }
     finish{specular .05 roughness .02 crand .1}
}
   
#declare T_Boite_1= 
texture{
    pigment{bozo turbulence .5 
      color_map{
      [0  rgb < 0.49,  0.576,  0.616 >]
      [.2 rgb < 0.824,  0.839,  0.843 >]
      [.3 rgb < 0.824,  0.839,  0.843 >] 
      [.5 rgb < 0.6,  0.596,  0.639 >]
      [.6 rgb < 0.6,  0.596,  0.639 >] 
      [.9 rgb < 0.49,  0.576,  0.616  >] 
      } 
    }
    finish{specular .8 roughness 0.1} 
    normal{bumps 3 turbulence .5 }
    translate x*.5
  } 
 texture{
    pigment{bozo 
      color_map{
      [0 rgbf 1]
      [.4 rgbf 1]
      [.8 rgb < 0.863,  0.616,  0.247 >]
      }
    }
  }

#declare T_Boite_2=
texture{
    pigment{
       bumps
       turbulence 1
        lambda 2.5
	omega 0.8 
	phase .9
	octaves 5
       color_map{
      [0  rgb < 183,  98,  21>/255]  
      [.2 rgb<211,  116,  69>/255]   
      [.3 rgb <143,  98,  35>/255]  
      [.5 rgb < 0.6,  0.596,  0.639 >] 
      [.99 rgb 0] 
       }
   }
   finish{ambient .2 phong .8} 
   normal{bumps .6 turbulence 1
        lambda 2.5
	omega 0.8 
	phase .9
	octaves 5} 
  }

#declare T_Bouteille=
texture{   
    pigment{rgbf < 0.216,  0.459,  0.184,.75 >}
    finish{ specular 1
    roughness 0.001
    ambient 0
    diffuse 0
    reflection 0.1}
}  

#declare T_Canette=
texture{   
    pigment{rgbf < 0.294,  0.227,  0.0706,.75 >}
    finish{ specular 1
    roughness 0.001
    ambient 0
    diffuse 0
    reflection 0.1}
} 

#declare T_Gobelet_1=
texture{ 
   pigment{rgb 1}
   finish{phong 1}
}

#declare T_Gobelet_2= 
texture{
   pigment{rgb < 0.7176471,  0.6509804,  0.3843137 >} 
}

#declare T_Gobelet=
texture{
   bozo 
   scale .25 
   phase .1
     texture_map{
   [0 T_Gobelet_1] 
   [.6 T_Gobelet_1]
   [.8 T_Gobelet_2]}
}
   
#declare T_Faience=
  texture{
    pigment {rgb < 0.91,  0.914,  0.812 >}
    } 
  texture{
    pigment{bozo   turbulence 1
      color_map{
      [0 rgbf 1]
      [.4 rgbf 1]
      [.5 rgbt < 0.863,  0.616,  0.247,.8 >] 
      [.7 rgb < 0.933,  0.816,  0.357 >]
      }
    } 
  } 
  texture{
    pigment{leopard  scale .2
      color_map{
      [0 rgb .8]
      [.3 rgbf 1]    
      }
    } 
    finish {phong 1 phong_size 150}
  }  

#declare T_Tuyau=
texture{
 pigment{rgb < 0.82,  0.408,  0.106 >} 
  finish {
    ambient 0
    brilliance 4
    diffuse 0.5
    metallic
    specular 0.80
    roughness 1/80
    reflection 0.5
  }
  normal{bumps .3 scale .05}
}

#declare T_Bouton=
texture{
 pigment{rgb .75}
    finish {
    ambient 0
    brilliance 4
    diffuse 0.5
    metallic
    specular 0.80
    roughness 1/80
    reflection 0.5
  }
}

#declare T_Semelle= 
texture{T_Wood35}
    texture{
         pigment{
              bozo  turbulence 1
                 color_map{
    [0 rgbt 1] 
    [.2 rgbt 1]
    [.6 rgbt < 0.5098039,  0.4470588,  0.3176471,.5 >]}
         }
    }    
////////////////////////////////////////////////////////////

#declare Sol=
polygon{      
      5,
   <-24,-10>,<-24,10>,<10,10>,
   <10,-10>,<-24,-10> 
   rotate x*90 translate <0,-1,-5> 
   }
 
#declare Murs=
union{
polygon{   //mur G    
      5,
   <-24,-1>,<-24,10>,<10,10>,
   <10,-1>,<-24,-1>  
    translate z*5
   }  
polygon{   //mur D    
      5,
   <-5,-1>,<-5,10>,<15,10>,
   <15,-1>,<-5,-1>  
    rotate y*90 translate<10,0,0>
   }   
} 

#declare Plinthes= 
union{  
box{<-22,-1.1,4.5>,<10,.5,5.1>}  //plinthe G  
box{<9.5,-1.1,-15>,<10.1,.5,5>}  //plinthe D
}

#declare Carreau = superellipsoid {<0.5, 0.1>
	scale <.4, .05, .4> 	
} 

#declare Carrelage_Mur_G=  
union{
#declare NiniX = -23; 
#declare NfinX = 10;
#declare NX=NiniX;
#while (NX <= NfinX)
#declare NiniZ = 0;
#declare NfinZ = 7;
#declare NZ=NiniZ;
#while (NZ <= NfinZ)
object{Carreau translate <NX,0,NZ>
}
#declare NZ = NZ + .84;
#end
#declare NX = NX + .84;
#end 
  texture{T_Carrelage}  
}

#declare Carrelage_Mur_D=  
union{
#declare NiniX = -5;
#declare NfinX = 4;
#declare NX=NiniX;
#while (NX <= NfinX)
#declare NiniZ = 0;
#declare NfinZ = 5;
#declare NZ=NiniZ;
#while (NZ <= NfinZ)
object{Carreau translate <NX,0,NZ>
}
#declare NZ = NZ + .84;
#end
#declare NX = NX + .84;
#end
   texture{T_Carrelage}   
}

#declare Carrelage_Plinthe_G=  
union{
#declare NiniX = -23; 
#declare NfinX = 10;
#declare NX=NiniX;
#while (NX <= NfinX)
#declare NiniZ = -1;
#declare NfinZ = 0;
#declare NZ=NiniZ;
#while (NZ <= NfinZ)
object{Carreau translate <NX,0,NZ>
}
#declare NZ = NZ + .84;
#end
#declare NX = NX + .84;
#end 
  texture{T_Carrelage}  
}

#declare Carrelage_Plinthe_D=  
union{
#declare NiniX = -5;
#declare NfinX = 4;
#declare NX=NiniX;
#while (NX <= NfinX)
#declare NiniZ = -1;
#declare NfinZ = 0;
#declare NZ=NiniZ;
#while (NZ <= NfinZ)
object{Carreau translate <NX,0,NZ>
}
#declare NZ = NZ + .84;
#end
#declare NX = NX + .84;
#end 
  texture{T_Carrelage}  
}

#declare Carrelage_Plinthe_G_H=  
union{
#declare NiniX = -23; 
#declare NfinX = 10; 
#declare NX = NiniX;
#while (NX <= NfinX)
object{Carreau translate <NX,0,0>}
#declare NX = NX + .84; 
#end  
  texture{T_Carrelage} 
}

#declare Carrelage_Plinthe_D_H=  
union{
#declare NiniX = -5; 
#declare NfinX = 4; 
#declare NX = NiniX;
#while (NX <= NfinX)
object{Carreau translate <NX,0,0>}
#declare NX = NX + .84; 
#end
  texture{T_Carrelage} 
}
 
#declare Miroir=
    box{<9.92,.7,-4>,<9.99,5,3>
    texture{T_Miroir} 
}

#declare Faience=
blob{threshold .6
  sphere{<0,0,0>,1,1  scale<.8,1.1,1>}    
  sphere{<0,.1,-.1>,.38,-1 scale<1.1,1.2,1>}         
  sphere{<0,.078,-.12>,.4,-1 scale<.8,1.2,1>}
  cylinder{<0,-.62,0>,<0,-.58,0>,.13,1}   
     translate y*.1
} 

#declare Tuyauterie= 
union{
sphere_sweep{
   cubic_spline
 7,
 <-.5,.1,.3>,.03
 <0,.24,.3>,.03
 <0,1,.3>,.03
 <.05,2,.32>,.03 
 <0,2.5,.34>,.03
 <0,2.5,.6>,.03  
 <0,2.5,.7>,.03 
tolerance 1.0-4 
 texture{T_Tuyau}
 } 
union{
cylinder{<0,-.15,0>,<.01,.15,0>,.045} 
torus{.045,.015 translate <0,-.15,0>}
torus{.045,.015 translate <0,.15,0>} 
sphere{<0,0,-.1>,.05 scale<1,1,.6>} 
   rotate<0,0,-3> translate <0,1.2,.3>  
   texture{T_Bouton}
}
}

#declare Nervure=
union{ 
  cylinder{<0,-.7,0>,<0,.5,0>,.075}
  sphere{<0,-.7,0>,.075}
  sphere{<0,.5,0>,.075}                                      
      rotate z*-4.5   scale<1,1,1.5>
} 

#declare Forme=
difference{
union{
cone{<0,-1,0>,.85<0,1,0>,1}
cone{<0,.7,0>,1<0,1.01,0>,1.02} //bord suprieur
torus{.95,.05 translate y*.7}
}
#declare Radius = .975; 
#declare Nr = 0;     
#declare EndNr = 15; 
#while (Nr< EndNr) 
object{Nervure
        translate<Radius,0,0>
         rotate<0,Nr*360/EndNr,0>}
 #declare Nr=Nr+1;
#end 
}
#declare Poignee= 
difference{ 
union{
cylinder{<0,-.06,0>,<0,.06,0>,.15 scale<1,1,2.1>}
box{<-.15,-.059,-.318>,<0,.059,.318>}
 } 
union{
cylinder{<0,-.06,0>,<0,.06,0>,.15 scale<1,1,2.1>}
box{<-.15,-.059,-.318>,<0,.059,.318>}
scale<1,1.2,.8> translate x*-.08
 } 
 texture{T_Poubelle_Ext}
}
 
#declare Poubelle=
union{
     difference{
            object{Forme texture{T_Poubelle_Ext}}  
            object{Forme scale .95 texture{T_Poubelle_Int}} 
            box{<-1.1,.94,-1.1>,<1.1,1.1,1.1>texture{T_Poubelle_Int}}
     }
     object{Poignee translate<1.33,1,0> rotate y*-30 scale.8} 
     object{Poignee translate<1.33,1,0> rotate y*150 scale.8} 
} 

#declare Couvercle = 
union{
 object{Poignee rotate z*90 rotate y*90 translate<0,.69,0> scale.7} 
lathe{
	cubic_spline
	14,
	<0.000000,0.285364>,
	<0.000000,0.407663>,
	<0.591997,0.310178>,
	<0.863181,0.163065>,
	<0.909265,0.111664>,
	<0.992570,0.072670>,
	<0.994342,0.008862>,
	<0.978390,0.007090>,
	<0.973073,0.063808>,
	<0.895085,0.097485>,
	<0.852547,0.148885>,
	<0.583135,0.294226>,
	<0.000000,0.391711>,
	<0.000000,0.264094> 
} 
    texture{T_Poubelle_Ext}
}
  
#declare Corps=
union{
blob{threshold .6
  sphere{<0,0,0>,.7,1 //tete
    scale <2,1,1> rotate z*18}  
  sphere{<-.2,.4,0>,.4,1
    scale <1.3,1,1>}
  cylinder{<0,0,-1>,<0,0,1>,.2,-1    //bouche
    scale <1,2,1> rotate z*30 translate <.2,-.25,0> }
  sphere{<0,0,0>,.2,1    // oreille G
    scale<1.8,3.5,1> rotate<-30,-30,10> translate<-.5,.6,-.35>} 
  sphere{<0,0,0>,.125,-1
    scale<1.8,3.5,1> rotate<-30,-30,10> translate<-.4,.6,-.45>} 
  sphere{<0,0,0>,.2,1     // oreille D
    scale<1.8,3.5,1> rotate<30,0,10> translate<-.5,.6,.35>} 
  sphere{<0,0,0>,.125,-1
    scale<1.8,3.5,1> rotate<30,0,10> translate<-.4,.6,.45>} 
  sphere{<-.5,-1,0>,1,1}    //thorax 
  sphere{<0,-1.25,0>,1,1 //abdomen 
    scale <1,1.5,1>} 
  sphere{<0,0,0>,.5,1  //cuisse D
    scale <1,1.75,.65>rotate z*55 translate<.2,-2.5,-.5>}    
  sphere{<0,0,0>,.5,1  //cuisse G
    scale <1,1.75,.65>rotate z*55 translate<.2,-2.5,.5>} 
  cylinder{<.4,-2.65,-.5>,<-.2,-3.2,-.5>,.08,1} //mollet D   
  cylinder{<.4,-2.65,.5>,<-.2,-3.2,.5>,.08,1} //mollet G 
  cylinder{<-.3,-3.23,-.5>,<.75,-3.2,-.5>,.12,1}  //pied D 
  sphere{<0,-2.15,0>,.08,1                        //orteil ext
    scale<2.5,1.5,1>rotate y*20 translate<.85,0,-.6>}      
  sphere{<0,-2.15,0>,.08,1                         //orteil int
    scale<2.5,1.5,1>rotate y*-20 translate<.85,0,-.4>} 
  sphere{<0,-2.15,0>,.1,1                         //orteil med
    scale<2.5,1.5,1>translate<.9,0,-.5>}  
  cylinder{<-.3,-3.23,.5>,<.75,-3.2,.5>,.12,1}  //pied G 
  sphere{<0,-2.15,0>,.08,1                        //orteil int
    scale<2.5,1.5,1>rotate y*20 translate<.85,0,.4>}      
  sphere{<0,-2.15,0>,.08,1                         //orteil ext
    scale<2.5,1.5,1>rotate y*-20 translate<.85,0,.6>} 
  sphere{<0,-2.15,0>,.1,1                         //orteil med
    scale<2.5,1.5,1>translate<.9,0,.5>}    
} 
sphere_sweep {        //queue
	cubic_spline
	6,
	<0,-2.5, 0>, .1
	<-.05,-2.5, 0>, .1
	<-1.5,-2.2, -.2>, .05
	<-2,-1, .5>, .05
	<-3, -1, -1>, .02
	<-3, -1, -1.2>, .02
	tolerance 1.0-4
} 
} 

#declare Bras_D=
blob{threshold .6                  
   cylinder{<0,-.63,0>,<0,.1,0>,.1,1  //bras 
     scale<1.25,1,1>}  
   sphere{<0,.115,0>,.25,1  
     scale<1.25,3,1>}
   sphere{<0,0,0>,.06,1                   //doigt G
     scale<1,4,1>rotate z*5 translate <.1,-.775,0>}
   sphere{<0,0,0>,.06,1
     scale<1,1,4>rotate <-60,0,5> translate <.135,-.97,-.05>} 
   sphere{<0,0,0>,.06,1           //doigt M
     scale<1,4,1>translate <.015,-.8,0>} 
   sphere{<0,0,0>,.06,1
     scale<1,1,4>rotate <-60,0,0> translate <.02,-1,-.05>}     
   sphere{<0,0,0>,.06,1                        //doigt D
     scale<1,4,1>rotate z*-5 translate <-.07,-.8,0>} 
   sphere{<0,0,0>,.06,1
     scale<1,1,4>rotate <-60,0,-5> translate <-.08,-1,-.05>} 
   sphere{<0,0,0>,.07,1                        //pouce
     scale<1,3,1>rotate z*-30 translate <-.125,-.67,0>} 
   sphere{<0,0,0>,.07,1                        
     scale<1,2,1>rotate <20,0,-10> translate <-.175,-.84,-.05>}      
}  

#declare Bras_G=
blob{threshold .6                  
   cylinder{<0,-.63,0>,<0,.1,0>,.1,1 //bras
     scale<1.25,1,1>}  
    sphere{<0,.115,0>,.25,1  
     scale<1.25,3,1>}
   sphere{<0,0,0>,.06,1                   //doigt G
     scale<1,4,1>rotate z*-5 translate <-.1,-.775,0>}
   sphere{<0,0,0>,.06,1
     scale<1,1,4>rotate <-60,0,-5> translate <-.135,-.97,-.05>} 
   sphere{<0,0,0>,.06,1           //doigt M
     scale<1,4,1>translate <-.015,-.8,0>} 
   sphere{<0,0,0>,.06,1
     scale<1,1,4>rotate <-60,0,0> translate <-.02,-1,-.05>}     
   sphere{<0,0,0>,.06,1                        //doigt D
     scale<1,4,1>rotate z*5 translate <.07,-.8,0>} 
   sphere{<0,0,0>,.06,1
     scale<1,1,4>rotate <-60,0,5> translate <.08,-1,-.05>} 
   sphere{<0,0,0>,.07,1                        //pouce
     scale<1,3,1>rotate z*30 translate <.125,-.67,0>} 
   sphere{<0,0,0>,.07,1                        
     scale<1,2,1>rotate <20,0,10> translate <.175,-.84,-.05>}    
}           

#declare Dents=
union{
intersection{     //dent D
torus{.5,.05}
box{<.2,-.1,.2>,<1,1,1>}
rotate <90,0,20>translate<-.1,.1,-.05>scale <1,1,1.5> 
}  
intersection{     //dent G
torus{.5,.05}
box{<.2,-.1,.2>,<1,1,1>}
rotate <90,0,20>translate<-.1,.1,.05>scale <1,1,1.5>  
} 
} 

#declare Yeux=
union {
 sphere{<0,.5,-.15>,.08} //oeil D
  sphere{<0,.5,.15>,.08}   //oeil G  
  }  
  
#declare Nez=
 sphere{<0,0,0>,.1   
    scale <2,1,1> rotate z*30 translate <.65,.3,0>}

#declare Langue=
blob{threshold .1
  sphere{<0,0,0>,.9,1 scale <2,1,1.4> } 
  sphere{<0,.1,0>,.8,-1 scale <2.2,1,1.45> }
}   

#declare Souris=
union{
object{Corps texture{T_Souris}
}
object{Bras_D texture{T_Souris}
rotate <0,180,55>rotate y*55 translate <-.4,-1.15,-.7>}  
object{Bras_G texture{T_Souris}
rotate z*55 rotate y*-55 translate <-.4,-1.15,.7>} 
object{Langue 
  pigment{
        bozo  scale .2
        color_map{
    [0 rgb < 0.6627451,  0.07843137,  0.0627451 >]  
    [.5 rgb < 0.4588235,  0.05098039,  0.05098039 >]} 
    }
  finish{specular .5 roughness .01}
  rotate<0,0,-60>translate <0,0,0> scale .25
} 
object{Dents pigment{rgb<236,  228,  85>/255}
    finish{specular 1 roughness .15}
}
object{Yeux pigment{rgb 0}finish{phong 1}
}  
object{Nez pigment{rgb 0}finish{specular .2}
} 
}

#declare Boite=
difference{
blob{threshold .6
  cylinder{<-1,0,0>,<1,0,0>,2,1}
  sphere{<1.5,0,0>,.5,-1
    scale<1,3,3>} 
  sphere{<-1.5,0,0>,.5,-1
    scale<1,3,3>}
  sphere{<.3,.3,-2>,.75,-1
    scale<1.25,1.75,.5>} 
  sphere{<-.10,.85,-1.25>,.95,-1
    scale<1,1.5,1>} 
} 
blob{threshold .6
  cylinder{<-1,0,0>,<1,0,0>,2,1}
  sphere{<1.5,0,0>,.5,-1
    scale<1,3,3>} 
  sphere{<-1.5,0,0>,.5,-1
    scale<1,3,3>}
  sphere{<.3,.3,-2>,.75,-1
    scale<1.25,1.75,.5>} 
  sphere{<-.10,.85,-1.25>,.95,-1
    scale<1,1.5,1>} 
    scale .96
}
box{<.9,-1.5,-1.5>,<1.5,1.5,1.5>}
}

#declare Bouteille = 
lathe{
	cubic_spline
	12,
	<0.043712,0.973810>,
	<0.038855,0.995666>,
	<0.067997,0.995666>,
	<0.067997,0.966525>,
	<0.055854,0.944669>,
	<0.070425,0.835388>,
	<0.143279,0.696967>,
	<0.165135,0.514832>,
	<0.165135,0.116566>,
	<0.148136,0.002428>,
	<0.000000,0.007285>,
	<0.097138,-0.179706> 
	texture{T_Bouteille scale .5} 
}

#declare Canette = 
lathe{
	cubic_spline
	12,
	<0.013937,0.989547>,
	<0.055749,0.996516>,
	<0.090592,0.996516>,
	<0.097561,0.965157>,
	<0.080139,0.933798>,
	<0.097561,0.850174>,
	<0.212544,0.742160>,
	<0.229965,0.571429>,
	<0.229965,0.156794>,
	<0.198606,0.006969>,
	<0.000000,0.006969>,
	<0.052265,-0.101045> 
	texture{T_Canette }
}

#declare Gobelet= 
lathe{
	cubic_spline
	13,
	<0.456062,0.987764>,
	<0.456062,0.998888>,
	<0.470523,0.998888>,
	<0.470523,0.984427>,
	<0.446051,0.969967>,
	<0.434928,0.890990>,
	<0.345940,0.252503>,
	<0.307008,0.045606>,
	<0.288098,0.005562>,
	<0.264739,0.003337>,
	<0.134594,0.001112>,
	<0.000000,0.005562>,
	<0.018910,0.048943>
}

#declare fn_Pigm = function {
	pigment {
		crackle
		color_map {
			[0 color rgb 0]
			[1 color rgb 1]
		}
	}
}

#declare Papier=
isosurface {
function { x-fn_Pigm(x/2, y/2, z/2).gray*0.5 }
	contained_by {box {-2, 2}}
	 open 
	 max_gradient 1.4  	
}

#declare Semelle=
difference{
   union{
      box{<-2,-1,-1>,<2,1,1>}
      cylinder{<-2,-1.001,0>,<-2,1.001,0>,1} 
      cylinder{<2,-1.001,0>,<2,1.001,0>,1}
   } 
   difference{   
         cylinder{<0,0,-1.1>,<0,0,1.1>,2.5 
     scale<2,1,1> rotate z*12 translate<-.5,2.25,0>} 
   cylinder{<0,0,-1.2>,<0,0,1.2>,1
     scale<4,1,1> rotate z*22 translate<2,-.35,0>} 
   }  
    texture{T_Semelle}
} 

#declare Laniere=
difference{
     object { Supercone(<-2,-.5,0>,.95,.5, <-.5,0,0>,.95,.75)} 
     object { Supercone(<-2.001,-.5,0>,.85,.4, <-.4999,0,0>,.85,.65)} 
   pigment{rgb<.3,.7,.8>}finish{specular .25 roughness .005} 
   normal{bozo 9 scale .6}
} 

#declare Chaussure=
union{
 object{Semelle}
 object{Laniere}
}

//////////////////////////////////////////////////////////////////////

object{Sol texture{T_Sol}
}
object{Sol pigment{rgb < 0.7764706,  0.7411765,  0.3333333 >}translate y*-.001  //evite transparence du sol
}
object{Murs texture{T_Mur}
} 
object{Plinthes texture{T_Mur}
} 
object{Carrelage_Mur_G rotate x*-90  translate <0,.99,5>
}   
object{Carrelage_Mur_D rotate <-90,90,0>  translate <10,.99,0>
}
object{Carrelage_Plinthe_G rotate x*-90  translate <0,.24,4.5>
} 
object{Carrelage_Plinthe_D rotate <-90,90,0>  translate <9.5,.24,0>
}  
object{Carrelage_Plinthe_G_H translate <0,.5,4.93>
}  
object{Carrelage_Plinthe_D_H rotate y*90 translate <9.95,.5,0>
}         
object{Miroir translate x*-.2
} 
object{Tuyauterie translate<4,1,2.9> scale 1.5
}
object{Tuyauterie translate<0,1,2.9> scale 1.5
}
object{Tuyauterie translate<-4,1,2.9> scale 1.5
}
object {Faience translate<0,1,2.95> scale 1.5
     texture{T_Faience}
}
object {Faience translate<4,1,2.95> scale 1.5
     texture{T_Faience}
}
object {Faience translate<-4,1,2.95> scale 1.5
     texture{T_Faience translate <0,-.8,-.75>}
}                                           
object{Souris rotate y*130 translate <-4,2.27,1>
}
 
union{
object {Poubelle rotate<85,-125,0>translate <-4,0,-3>
} 
object{Couvercle scale 1.05 rotate<0,45,0> translate <-5,-1,-6>
}
object{Boite  texture{T_Boite_1 scale .5} rotate z*90 rotate<-30,0,0>
     scale.5 translate<-5.8,-.45,-4>  scale.7
}        
object{Boite  texture{T_Boite_2 }  rotate<0,180,-40>
     scale<.4,.3,.4> translate<-5,-.5,-4.25>  scale.7
}       
object{Boite  texture{T_Boite_2 }  rotate<0,180,0>
     scale<.4,.3,.4> translate<-10,-1.15,-3.8>  scale.7
}      
object{Bouteille rotate<100,225,0>translate<-2.5,-.3,-2>scale 1.7
} 
object{Canette scale .65 rotate<90,-60,0>
     translate<-3.5,-.52,-2>scale 1.5
}      
object{Canette scale .65 rotate<90,20,0>
     translate<-6,-.52,-4>scale 1.5
}  
object{Gobelet rotate <76,-70,0>translate<-7,-1.75,-9>scale .5
       texture{T_Gobelet}  
} 
object{Gobelet rotate <76,0,0>translate<-13,-1.75,-9>scale .5
       texture{T_Gobelet}  
}    
object{Gobelet rotate <76,-30,0>translate<-16,-1.75,-14>scale .5
       texture{T_Gobelet}  
}
object{Papier pigment{rgb 1}
     rotate z*90 rotate y*45 translate <-30,-2.5,-5>scale<.2,.4,.3>
}
object{Chaussure scale .225 rotate <0,37,0> translate<-6,-.75,-4>
}     
translate<3,0,2>
} 