// make a frame of size l*w  with prisms
#ifndef(Get)
 global_settings{ max_trace_level 20}

 #include "colors.inc"
 #include "Math.inc"
 //#include "stones.inc"
 //#include "metals.inc"
 //#include "shapes.inc"
 #include "Woods.inc"

 camera{ location <0,0,-8>
       look_at <0,0,0>
       right x*image_width/image_height}
 light_source {<0,0,-100> White}
 light_source {<0,100,0> White}
 background{Pink}
 cylinder{-x*4,x*4,.05 pigment{Gold}}
 cylinder{-y*4,y*4,.05 pigment{Gold}}
 //cylinder{-z*4,z*4,.05 pigment{Gold}}

 //======= Change Variables =================

 //#include"frame1.prm"
 #include"Wtrim1.prm"// prism called Thing
 #declare FCorn=<5.3,4>;//Lenght & Width outer frame
 #declare Width= .5;// inter frame
 #declare Height= .25;// height frame (-z direction)

 #declare Face= z;// prism face toward you +-x, +-z
 #declare Reverse=0;//reverse inner and outer frame 

 #declare CornerType=3;// corner & texture types 1-3
 

#end //end of get
 // Textures
#ifndef(BasTex)
 #declare  BasTex=texture {pigment{
                   agate color_map{[0 Gold][.5 Gold*.5][1 Gold]}}
                   normal{granite scale .1}
                   finish{brilliance 2 specular .3 roughness .5}
                    } 
#end
#ifndef(TopTex) 
 #declare  TopTex=texture {T_Wood27 rotate y*75 translate y*33}
#end
#ifndef(BotTex) 
 #declare  BotTex=texture {T_Wood28 rotate y*65 translate z*33}
#end
#ifndef(LefTex) 
 #declare  LefTex=texture {T_Wood29 rotate x*75 translate x*33}
#end
#ifndef(RitTex) 
 #declare  RitTex=texture {T_Wood29 rotate x*75 translate 33}
#end
#ifndef(Corn1Tex) 
 #declare  Corn1Tex=texture {pigment{Gold}}    
#end

//======= End of Changes =================
#declare Wd=Width/2; #declare Ht=Height/2;

#declare Mx= max_extent(Thing);
#declare Mn= min_extent(Thing);
#declare Ct= (Mx+Mn)/2;

#declare Thing=object{Thing translate -Ct}

#declare Base=object{Thing 
              #if(VEq(Face,z)) rotate y*180 #end
              //#if(VEq(Face,-z)) translate <-Mn.x,0,-Mx.z> #end
              #if(VEq(Face,x)) rotate y*90 #end
              #if(VEq(Face,-x))rotate -y*90 #end
              #if(VEq(Face,y)) rotate -x*90 #end
              #if(VEq(Face,-y))rotate x*90 #end
              
              }

#if (Reverse) 
 #declare Base=object{Base scale<-1,1,1> }//translate -x*Mn.x} 
#end 

#declare Mx= max_extent(Thing);
#declare Mn= min_extent(Thing);
#declare Ct= (Mx+Mn)/2;
//#debug concat("Ct=<",vstr(3,Ct,",",3,3),">\n")
#declare Sx=Wd/Mx.x; #declare Sy=1/Mx.y;#declare Sz=Ht/Mx.z;
 #declare Base=object{Base scale<Sx,Sy,Sz> }//translate -x*Mn.x} 
//object{Base pigment{White}}              
//object{Bas pigment{White}}  

#declare H= FCorn.v-Wd;
#declare W= FCorn.u-Wd;
#debug concat("\nH=<",str(H,3,3),"\n")
#debug concat("Ht=<",str(Ht,3,3),"\n")
 #debug concat(" W=<",str(W,3,3),"\n")
 #debug concat(" Wd=<",str(Wd,3,3),"\n\n")
 //left full
#if (CornerType=1)
 #declare Frame=union{
  object{Base scale<1,FCorn.v,1> translate x*W }
  //Right full
  object{Base scale<-1,FCorn.v,1> translate -x*W }
  // top
  object{Base scale<1,FCorn.u,1> rotate z*90 translate y*H }
  // Bottom
  object{Base scale<1,FCorn.u,1> rotate -z*90 translate -y*H }
 texture{BasTex}}
#end 
#if (CornerType=2)

 #declare CornP=intersection{plane{<-1,1,0>,0}
                             object{Base}
                             box{-Width,Width}
                             }
 #declare CornS=union{object{CornP}
                      object{CornP scale <-1,1,1> rotate -z*90}
                     } 
 #declare Frame=union{
 ///corners
  object{CornS rotate z*90 translate <-FCorn.u+Width/2,FCorn.v-Width/2,0>}
  object{CornS translate <FCorn.u-Width/2,FCorn.v-Width/2,0>}
  object{CornS rotate z*180 translate <-FCorn.u+Width/2,-FCorn.v+Width/2,0>}
  object{CornS rotate -z*90 translate <FCorn.u-Width/2,-FCorn.v+Width/2,0>}
  //Left side
  object{Base scale<1,FCorn.v-Width,1> translate x*W }
  //Right side
  object{Base scale<-1,FCorn.v-Width,1> translate -x*W }
  // top side
  object{Base scale<1,FCorn.u-Width,1> rotate z*90 translate y*H }
  // Bottom side
  object{Base scale<1,FCorn.u-Width,1> rotate -z*90 translate -y*H }
 texture{BasTex}}
#end 
#if (CornerType=3)

 #declare CornP=intersection{plane{<1,1,0>,0}
                             plane{<-1,1,0>,0 inverse}
                             object{Base scale<-1,1,1>}
                             box{-Width,Width}
                             }
 #declare CornS=union{object{CornP}
                      object{CornP rotate z*90}
                      object{CornP rotate -z*90}
                      object{CornP rotate z*180}
                     } 
 #declare Frame=union{
 ///corners
  object{CornS translate <-FCorn.u+Width/2,FCorn.v-Width/2,0>}
  object{CornS translate <FCorn.u-Width/2,FCorn.v-Width/2,0>}
  object{CornS translate <-FCorn.u+Width/2,-FCorn.v+Width/2,0>}
  object{CornS translate <FCorn.u-Width/2,-FCorn.v+Width/2,0>}
  //Left side
  object{Base scale<1,FCorn.v-Width,1> translate x*W }
  //Right side
  object{Base scale<-1,FCorn.v-Width,1> translate -x*W }
  // top side
  object{Base scale<1,FCorn.u-Width,1> rotate z*90 translate y*H }
  // Bottom side
  object{Base scale<1,FCorn.u-Width,1> rotate -z*90 translate -y*H }
 texture{BasTex}}
#end 
#if (CornerType=4)// texture per side

 #declare CornP=intersection{plane{<-1,1,0>,0}
                             object{Base}
                             box{-Width,Width}
                             }
 #declare CornS=union{object{CornP}
                      object{CornP scale <-1,1,1> rotate -z*90}
                     } 
#declare LRs= union{object{CornP translate<0,FCorn.v-Width/2,0>}
                    object{Base scale<1,FCorn.v-Width,1> }
                    object{CornP scale <1,-1,1> translate <0,-FCorn.v+Width/2,0>}
                   } 
#declare TBs= union{object{CornP translate<0,FCorn.u-Width/2,0>}
                    object{Base scale<1,FCorn.u-Width,1> }
                    object{CornP scale <1,-1,1> translate <0,-FCorn.u+Width/2,0>}
                   rotate z*90} 

 #declare Frame=union{
   object{LRs texture{LefTex}translate x*W }
     object{LRs texture{RitTex} rotate z*180 translate -x*W }
   object{TBs texture{TopTex} translate y*H }
     object{TBs texture{BotTex} rotate z*180 translate -y*H }
    } 
#end 
#ifndef(Get)
 object{Frame}
#end
 